# -*- coding: utf-8 -*-
"""
Created on Fri May 16 11:54:30 2025

@author: User
"""

import pandas as pd
import matplotlib.pyplot as plt
import numpy as np

# ----------------------------
# 1. Data
# ----------------------------
services = [
    "Food Production", "Raw Material Supply", "Gas Regulation",
    "Climate Regulation", "Water Supply", "Waste Treatment",
    "Soil Formation", "Biodiversity Protection", "Recreation"
]

islands = [
    "Atlanticas", "Azores", "Baleares",
    "Berlengas", "Canarias", "Columbretes", "Madeira"
]

data_05_20 = [
    [-6.36,   0.27, -0.46, -0.46, -0.43,  1.64, -0.51],
    [-18.41,  6.51, -2.06, -2.06, -1.54, 21.52, -10.64],
    [-0.23,   0.04,  0.01,  0.01, -0.03,  0.37, -0.01],
    [-20.31,  6.51, -2.34, -2.34, -1.49, 10.48, -10.96],
    [-4.72,   6.51,  0.06,  0.06,  1.47, -0.26, -3.26],
    [-5.54,   6.51, -0.03, -0.03, -1.35, 13.14, -8.89],
    [-20.31,  6.51, -1.66, -1.66, -1.49, 10.48, -6.79],
    [-6.38,   0.72, -0.39, -0.39, -0.37,  2.20, -1.34],
    [-7.23,   6.51, -0.23, -0.23, -1.99, 42.36, -5.09]
]

data_20_40 = [
    [-13.86,  0.28,  0.92,  0.92, -1.23,  1.42, -0.41],
    [-28.65,  6.60, -2.83, -2.83,  1.27, 20.50, -8.98],
    [-1.25,   0.04, -0.35, -0.35, -0.19,  0.41, -0.02],
    [-26.66,  6.60, -3.69, -3.69,  3.50, 10.48, -8.97],
    [-45.44,  6.60,  4.57,  4.57, -48.62, -3.19, -79.29],
    [-43.01,  6.60,  2.35,  2.35, -26.95, 10.18, -23.47],
    [-26.66,  6.60,  2.09,  2.09,   3.50, 10.48, -4.35],
    [-37.89,  0.73,  3.54,  3.54, -19.14, -0.19, -3.91],
    [-40.36,  6.60,  4.60,  4.60, -17.80, 39.42, -5.51]
]

df_05_20 = pd.DataFrame(data_05_20, index=services, columns=islands)
df_20_40 = pd.DataFrame(data_20_40, index=services, columns=islands)

# ----------------------------
# 2. Heatmaps
# ----------------------------
def plot_heatmap(df, title, fname):
    plt.figure(figsize=(10, 6))
    plt.imshow(df, aspect="auto")
    plt.xticks(ticks=np.arange(len(df.columns)), labels=df.columns, rotation=45, ha="right")
    plt.yticks(ticks=np.arange(len(df.index)), labels=df.index)
    cbar = plt.colorbar(fraction=0.046, pad=0.04)
    cbar.set_label("% change")
    plt.title(title, fontsize=14, weight="bold")
    plt.tight_layout()
    plt.savefig(fname, dpi=300, bbox_inches="tight")
    plt.show()

plot_heatmap(df_05_20, "Ecosystem service change 2005-2020 in BS (%)", "ES_change_2005_2020_heatmap.png")
plot_heatmap(df_20_40, "Ecosystem service change 2020-2040 in BS (%)", "ES_change_2020_2040_heatmap.png" )

# ----------------------------
# 3. Average change per island (bars)
# ----------------------------
avg_05_20 = df_05_20.mean(axis=0)
avg_20_40 = df_20_40.mean(axis=0)

x = np.arange(len(islands))
w = 0.35

plt.figure(figsize=(10, 5))
plt.bar(x - w/2, avg_05_20, width=w, label='2005-2020')
plt.bar(x + w/2, avg_20_40, width=w, label='2020-2040')
plt.xticks(x, islands, rotation=45, ha="right")
plt.ylabel('% Change')
plt.title('Average Ecosystem Service Change in BS', fontweight='bold')
plt.axhline(0)
plt.legend()
plt.tight_layout()
plt.savefig("ES_avg_change_bar.png", dpi=300, bbox_inches="tight")
plt.show()

