# -*- coding: utf-8 -*-
"""
Created on Fri May 16 10:56:01 2025

@author: User
"""

import matplotlib.pyplot as plt
from matplotlib.ticker import FuncFormatter      # por si quisieras formatear con ‘€’
import pandas as pd
import numpy as np

# ------------------------------------------------------------------
# 1.  Datos de ejemplo  ➜  df  (ya los tenías; se incluye por claridad)
# ------------------------------------------------------------------
data = {
    "Built-up"            : [  0,   0,   0,   0,    0,    0,   0,   0,    0],
    "Coastal"             : [ 93,   4,   0,   0,    0,    0,   8,  33.5, 82],
    "Cropland"            : [ 54,   0,   0,   0,    0,   14,   0,  24,    0],
    "Desert"              : [  0,   0,   0,   0,    0,    0,   0,   0,    0],
    "Not used"            : [  0,   0,   0,   0,    0,    0,   0,   0,    0],
    "Ocean"               : [ 15,   0,  38,   0,    0,    0,   0,   1.25, 0],
    "Open Surface water"  : [ 41,   0,   0,   0, 2117,  665,   0, 230,    0],
    "Snow/ice"            : [  0,   0,   0,   0,    0,    0,   0,   0,    0],
    "Terra Firma"         : [ 55,  69, 3.5,70.5,  1.5,   87, 5.5,  14,   34],
    "Wetland"             : [304, 106, 133,   0, 3800, 4177, 0,  574,  881]
}
services = ['Food production', 'Raw Material Supply', 'Gas Regulation',
            'Climate Regulation', 'Water Supply', 'Waste Treatment',
            'Soil Formation', 'Biodiversity Protection', 'Recreation']
df = pd.DataFrame(data, index=services).T     # LULC como índice

# Colores coherentes con tu flujo
colors = plt.cm.Set3(range(len(df.columns)))

# ------------------------------------------------------------------
# 2.  Figura con eje roto
# ------------------------------------------------------------------
fig, (ax_top, ax_bot) = plt.subplots(
    2, 1, sharex=True,
    figsize=(16, 8),
    gridspec_kw={'height_ratios': [1, 3]}   #  ➜ parte alta + parte baja
)

# --- PARTE INFERIOR (0-500) ---
df.plot(kind='bar', stacked=True, ax=ax_bot,
        color=colors, edgecolor='black')
ax_bot.set_ylim(0, 500)

# --- PARTE SUPERIOR (>3 000) ---
df.plot(kind='bar', stacked=True, ax=ax_top,
        color=colors, edgecolor='black', legend=False)
ax_top.set_ylim(3000, 10000)




# -------- Estética común --------
for ax in (ax_top, ax_bot):
    ax.set_ylabel("ESV (€ / ha)", fontsize=13, fontweight='bold')
    ax.tick_params(axis='y', labelsize=11)
    ax.grid(False)

# X-labels sólo en la parte inferior
ax_bot.set_xlabel("LULC class", fontsize=13, fontweight='bold')
ax_bot.set_xticklabels(df.index,
                       rotation=30, ha='right',
                       fontsize=11, fontweight='bold')

# Ocultar spines donde se une la rotura
ax_top.spines.bottom.set_visible(False)
ax_bot.spines.top.set_visible(False)
ax_top.tick_params(labelbottom=False)      # quita etiquetas duplicadas

# Pequeñas “líneas de rotura”
kw = dict(marker=[(-1, -1), (1, 1)], markersize=12,
          linestyle='none', color='k', clip_on=False)
ax_top.plot([0, 1], [0, 0], transform=ax_top.transAxes, **kw)
ax_bot.plot([0, 1], [1, 1], transform=ax_bot.transAxes, **kw)

# -------- Título y leyenda --------
fig.suptitle("ESV Contribution by LULC (Costanza et al., 1997)",
             fontsize=18, fontweight='bold', y=0.97)

ax_bot.legend(title="Ecosystem Service",
              title_fontsize=12, fontsize=11, frameon=False,
              bbox_to_anchor=(1.02, 1.0), loc="upper left")

plt.tight_layout()
plt.subplots_adjust(hspace=0.05)           # espacio vertical mínimo

# -------- Guardar versión lista para diapositiva --------
plt.savefig("ESV_LULC_broken_axis.png", dpi=300, bbox_inches="tight")
plt.show()