# -*- coding: utf-8 -*-
"""
Created on Thu May 15 13:51:57 2025

@author: User
"""

import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ────────── 1) Bloques y ejemplos ──────────
families = [
    ("Lookup Matrices",            "blue",
     ["Land-cover ES Table"]),
    ("Empirical / Statistical",    "green",
     ["Meta-regression", "Benefit-transfer"]),
    ("Rule-based GIS",             "black",
     ["InVEST (carbon, habitat)"]),
    ("Process-based Models",       "gold",
     ["InVEST (water, nutrient)", "SWAT", "LUCI",
      "LULC Data + Economic valuation"]),
    ("AI-Integrated Platforms",    "purple",
     ["ARIES"]),
    ("Economic Valuation",         "red",
     ["Market price", "Cost avoided", "CVM / CE"])
]

# Posición x de cada bloque
x_pos = [  2,   9,  16,  23,  30,  37]     # un poco más separados
offset = -0.8                               # aleja el texto del punto
big_ms = 22                                 # punto y texto grandes para el bloque clave

plt.figure(figsize=(30, 7))
plt.axhline(0, color='black', lw=2)

for (title, col, items), x in zip(families, x_pos):
    highlight = (title == 'Process-based Models')
    
    # punto principal
    plt.plot(x, 0, 'o', color=col,
             ms=(big_ms if highlight else 16), zorder=4)
    
    # título del bloque
    title_kw = dict(fontweight='bold')
    if highlight:                            # recuadro “subrayado”
        title_kw["bbox"] = dict(boxstyle='round,pad=0.3',
                                fc='khaki', ec='none', alpha=0.55)
    plt.text(x, 0.10, title, color=col, fontsize=17,
             ha='center', va='bottom', **title_kw)
    
    # sub-métodos
    y0, dy = -0.12, -0.15                   # mayor separación vertical
    for i, itm in enumerate(items):
        y = y0 + i*dy
        ms = big_ms-3 if highlight else 8
        plt.plot(x+offset, y, 'o', color=col, ms=ms, zorder=3)
        plt.text(x+offset+0.55, y, itm, color=col,
                 fontsize=14, ha='left', va='center',
                 fontweight='bold' if highlight else None)

# ────────── 2) título general ──────────
plt.title("Ecosystem Service Valuation",
          fontsize=20, pad=20, fontweight='bold')

plt.xlabel("Data & Model Complexity →", fontsize=20, fontweight='bold')

# ────────── 3) leyenda ──────────
legend = [
    Patch(color="blue",   label='Lookup Matrices'),
    Patch(color="green",  label='Empirical / Statistical'),
    Patch(color="black", label='Rule-based GIS'),
    Patch(color="gold",    label='Process-based (Our study) '),
    Patch(color="purple", label='AI-Integrated'),
    Patch(color="red",   label='Economic Valuation')
]
plt.legend(handles=legend, ncol=3, frameon=False,
           bbox_to_anchor=(0.5, -0.28), loc='lower center',
           prop={'size': 12, 'weight': 'bold'})

# ────────── 4) limpieza ──────────
plt.xticks([]); plt.yticks([])
for sp in plt.gca().spines.values():
    sp.set_visible(False)
plt.xlim(0, 41);   # cubrir los nuevos x
plt.ylim(-1.15, 0.18)
plt.tight_layout()

# ────────── 5) guardar ──────────
plt.savefig("land_use_ES_methods_highlight_economic_v2.png",
            dpi=300, bbox_inches="tight")
plt.show()


