import sys
import matplotlib.pyplot as plt
import json


file_path = './Programs/Profiling-data/'
file_type = '.json'
fig_type = '.png'


def jsonLoader(file_name):
    with open(file_name, 'r') as json_file:
        json_data = json.load(json_file)
        return json_data
    raise 'FILE ACCESS ERROR'

def visualizing(single_dict, fig_name):

    online_communicationbits_values = [item[1] for item in single_dict if item[1] != 0]


    online_communicationbits_labels = [item[0] for item in single_dict if item[1] != 0]


    sorted_indices = sorted(range(len(online_communicationbits_values)), key=lambda k: online_communicationbits_values[k], reverse=True)
    values = [online_communicationbits_values[i] for i in sorted_indices]
    labels = [online_communicationbits_labels[i] for i in sorted_indices]
    
    print('\t'+str(labels))
    print('\t'+str(values))


    plt.figure(figsize=(8, 8))
    colors = plt.cm.Paired(range(len(values)))
    

    def func(pct, allvalues):
        value = int(pct/100.*sum(allvalues))
        value_GB = value / 1024**3 / 8
        value /= 8
        if value<1024:
            return f"{pct:.2f}%\n({value:.2f}B)"
        value /=1024
        if value<1024:
            return f"{pct:.2f}%\n({value:.2f}KB)"
        value /=1024
        if value<1024:
            return f"{pct:.2f}%\n({value:.2f}MB)"
        value /=1024
        return f"{pct:.2f}%\n({value:.2f}GB)"
    plt.pie(values, colors=colors, wedgeprops=dict(width=0.4, edgecolor='w'), autopct=lambda pct: func(pct, values), startangle=90, pctdistance=0.85)

    handles = [plt.Rectangle((0,0),1,1, color=colors[i], ec="k") for i in range(len(values))]


    # plt.legend(handles, labels, bbox_to_anchor=(0, 0), loc='upper left', borderaxespad=0)
    legend = plt.legend(handles, labels, bbox_to_anchor=(0.5, 0.1), loc='upper center', borderaxespad=0., bbox_transform=plt.gcf().transFigure, ncol=3)


    plt.title('Online Communication Bits')


    plt.savefig(fig_name)

def mergering_at_level(dict, level):
    result_dict = {}

    for item in dict:
        keys = item[0].split('-')
        
        key = ''
        for i in range(0, min(len(keys), level)):
            key += keys[i] + '-'
        
        if key in result_dict:
            result_dict[key] += item[1]
        else:
            result_dict[key] = item[1]
    result_list = [[key, value] for key, value in result_dict.items()]
    return result_list

if __name__=='__main__':
    script_name = sys.argv[0]
    arguments = sys.argv[1:]
    
    pgname = arguments[0]
    
    level = 2
    if len(arguments)>1:
        level = int(arguments[1])

    profiling_dicts = jsonLoader(file_path + pgname + file_type)
    
    for profiling_name, profiling_list in profiling_dicts.items():
        print(profiling_name)
        result_list = mergering_at_level(profiling_list, level)
        visualizing(result_list, file_path + pgname + '-' + profiling_name + fig_type)
    
    print('the result figures have being saved at '+file_path+pgname)