%% This function corresponds to Equation 2 in the main text (where subscripts are indicated by a "_" preceeding them): 
% N(1) = H_1  (Healthy tissue of individual of species j=1)
% N(2) = H_2  (Healthy tissue of individual of species j=2)
% N(3) = I_1  (Infected tissue of individual of species j=1)
% N(4) = I_2  (Infected tissue of individual of species j=2)

function dNdt = TwoSpeciesEQ(t,N,r1,r2,Bmax,n1,n2,beta1,beta2,beta11,beta22,beta12,beta21,mu1,mu2)

%% Set up dNdt object to hold the derivatives of the 4 state variables N(1), N(2), N(3), and N(4)
dNdt(:,1) = zeros(4,1); 

%% Equations
% Equation 2(a) where j = 1:
dNdt(1) = r1.*N(1).^(2/3).*(1 - ((N(1)+N(3))/Bmax).^(4/3)) - N(1).*(beta1*N(3) + beta11*(n1-1)*N(3) + beta12*n2*N(4));

% Equation 2(a) where j = 2:
dNdt(2) = r2.*N(2).^(2/3).*(1 - ((N(2)+N(4))/Bmax).^(4/3)) - N(2).*(beta2*N(4) + beta22*(n2-1)*N(4) + beta21*n1*N(3));

% Equation 2(b) where j = 1:
dNdt(3) = N(1).*(beta1*N(3) + beta11*(n1-1)*N(3) + beta12*n2*N(4)) - mu1*N(3);

% Equation 2(b) where j = 2:
dNdt(4) = N(2).*(beta2*N(4) + beta22*(n2-1)*N(4) + beta21*n1*N(3)) - mu2*N(4);