Code used in “Fast growing annual plants drive disease spillover in multi-host communities” submitted to Journal of Ecology in 2023, accepted in 2024.

## A note about the code
This code contains matlab files used to generate the results and figures in Journal of Ecology article “Fast growing annual plants drive disease spillover in multi-host communities”.

## Matlab function scripts
Matlab script `TwoSpeciesEQ.m` solves equation (2) in the main text.  When solving equation (2) for only one host species, we use script `SingleSpeciesEQ.m` for efficiency.

## Matlab live scripts used to create figures
Figures are generated using results and code from one of five live scripts:
- `RESULTS_NoGrowth_vs_Growth.mlx` (used to create Fig. 1)
- `RESULTS_Biomass_vs_Time.mlx` (used to create Fig. 2)
- `RESULTS_SpilloverPotential.mlx` (used to create Fig. 3)
- `RESULTS_Spillover.mlx` (used to create Fig. 4)
- `RESULTS_Spillover_OUTPUT.mlx` (generates results used by `RESULTS_Spillover.mlx` to create Fig. 4)
- `RESULTS_AmpDilut.mlx` (used to create Fig. 5)
- `RESULTS_AmpDilut_OUTPUT.mlx` (generates results used by `RESULTS_AmpDilut.mlx` to create Fig. 5)
- `RESULTS_CL_PathogenLoad.mlx` (used to create Fig. 6)

Parameter values used to generate a specific figure are given in each figure’s caption, and in Tables S1-S4 of the Supplementary Materials. Some figures (4, 5) required running many simulations and calling those results later from saved Matlab data files. The code for running those simulations is given in `RESULTS_Spillover_OUTPUT.mlx` and `RESULTS_AmpDilut_OUTPUT.mlx`, and the resulting simulation files used by scripts `RESULTS_Spillover.mlx` and `RESULTS_AmpDilut.mlx` are provided in the `Simulation_Runs.zip` file.
