#==============================================================================
#
# IMPORTANT NOTE: Don't add a coding line here! It's not necessary.
#
#==============================================================================
# Dependencies
#==============================================================================
#========
# tkinter
#========
import tkinter as tk
from tkinter import ttk, messagebox, IntVar, DoubleVar, StringVar, BooleanVar, filedialog

from PIL import ImageTk, Image
import webbrowser


#========
# Other
#========
import pandas as pd
import datetime
from decimal import Decimal
import sys
import numpy as np
import csv
from os import path


#======
#Fonts
#======
if sys.platform == "linux" or sys.platform == "win64" or sys.platform == "win32":
    font = "FreeSans"
    # Font 24
    FONT_24 = (font, 20)    
    FONT_24_bold = (font,20, "bold")
    FONT_24_underline = (font, 20, "underline")
    
    # Font 20
    FONT_20= (font, 16)
    FONT_20_bold= (font,16, "bold")
    FONT_20_underline= (font, 16, "underline")
    
    # Font 16
    FONT_16= (font, 13)
    FONT_16_bold= (font,12, "bold")
    FONT_16_underline= (font, 13, "underline")
    
    # Font 14
    FONT_14= (font, 12)
    FONT_14_bold= (font,11, "bold")
    FONT_14_underline = (font, 12, "underline")
    
    # Font 13
    FONT_13= (font, 11)
    FONT_13_bold= (font,10, "bold")
    FONT_13_underline = (font, 11, "underline")
    
    # Font 12
    FONT_12= (font, 10)
    FONT_12_bold= (font,9, "bold")
    FONT_12_underline = (font, 10, "underline")

else:
    font = "Arial"
    # Font 24
    FONT_24 = (font, 24)
    FONT_24_bold = (font,24, "bold")
    FONT_24_underline = (font, 24, "underline")
    
    # Font 20
    FONT_20= (font, 20)
    FONT_20_bold= (font,20, "bold")
    FONT_20_underline= (font, 20, "underline")
    
    # Font 16
    FONT_16= (font, 16)
    FONT_16_bold= (font,16, "bold")
    FONT_16_underline= (font, 16, "underline")
    
    # Font 14
    FONT_14= (font, 14)
    FONT_14_bold= (font,14, "bold")
    FONT_14_underline = (font, 14, "underline")
    
    # Font 13
    FONT_13= (font, 13)
    FONT_13_bold= (font,13, "bold")
    FONT_13_underline = (font, 13, "underline")
    
    # Font 12
    FONT_12= (font, 12)
    FONT_12_bold= (font,12, "bold")
    FONT_12_underline = (font, 12, "underline")


########################
### Sklearn and nltk ###
########################
from sklearn.linear_model import LogisticRegression, PassiveAggressiveClassifier
from sklearn.linear_model import RidgeClassifier, SGDClassifier, Perceptron

from sklearn.discriminant_analysis import LinearDiscriminantAnalysis, QuadraticDiscriminantAnalysis

from sklearn.svm import LinearSVC, NuSVC, SVC

from sklearn.neighbors import KNeighborsClassifier, NearestCentroid, RadiusNeighborsClassifier

from sklearn.gaussian_process import GaussianProcessClassifier

from sklearn.naive_bayes import BernoulliNB, GaussianNB, MultinomialNB

from sklearn.tree import DecisionTreeClassifier, ExtraTreeClassifier

from sklearn.ensemble import AdaBoostClassifier, BaggingClassifier
from sklearn.ensemble import RandomForestClassifier, ExtraTreesClassifier

from sklearn.semi_supervised import LabelPropagation

from sklearn.neural_network import MLPClassifier

# train_test_split used when user select 1 (Train Sample Size (%))
# cross_val_score and cross_val_predict used when user select 2 (K-fold Cross-Validation)
from sklearn.model_selection import train_test_split, cross_val_predict
from sklearn.utils import shuffle
from sklearn import metrics
from sklearn.externals import joblib



#==============================================================================
# Class ClassificaIO:
#
# ClassificaIO is the main class that is necessory to add new windows to.
# Define ClassificaIO class and pass tk.TK as a parameter.
#==============================================================================
class ClassificaIO(tk.Tk):

                         ###########################
    # define function show_frame with two arguments self and controlar
    def show_frame(self, cont):
        # cont is the key used to look for value in self.frames dictionary
        frame = self.frames[cont]
        # tkraise will rais the start window to the front
        frame.tkraise()
                         ###########################


    def __init__(self, *args, **kwargs):


        tk.Tk.__init__(self, *args, **kwargs) # initializing tkinter


        tk.Tk.wm_title(self,"ClassificaIO") # add name to software


        # container_frame is tkinter frame used to add bunch of stuff
        # pack used to pack things in container_frame
        # fill used to fill the space
        # expand used to expand beyond space set
        # configure to minimum size for row and column to 0 with priority
        # weight 1
        container_frame = tk.Frame(self)
        container_frame.pack(side="top", fill="both", expand=True)
        container_frame.grid_rowconfigure(0, weight=1)
        container_frame.grid_columnconfigure(0, weight=1)

        # creat file object in the menu=
        menu = tk.Menu(self)
        self.config(menu= menu)


        # self.frames used to add all windows (pages) in the software. Loop
        # through windows and add the frames to the dictionary self.frames. Use
        # nsew (north south east west) to stretch everything to window size
        self.frames = {}
        for window in (StartWindow,
                       WindowOne_Use_My_Own_Training_Data,
                       WindowTwo_Already_Trained_My_Model):
            each_frame = window(container_frame, self)

            self.frames[window] = each_frame
            each_frame.grid(row=0, column=0, sticky="nsew")


        self.show_frame(StartWindow) # always show start window first
                         ###########################






#==============================================================================
############## Functions Used in All of Following Classes Starts ##############



#==============================================================================
# Function NavigationButtons: allow user to navigate ClassificaIO.
#
# one input:
# command to move to StartWindow (home)
#==============================================================================
def NavigationButtons(self, home):

    # define function to call user manual
    def user_manual():
        webbrowser.open_new("https://goo.gl/Y9J9tD")



    # quit program
    def clint_exit():
        # output message and ask user before quiting
        quiting = messagebox.askquestion(title="Quit",
                                         message="Are you sure you want to "\
                                         "exit the program?")
        # if user select True which return yes then destroy meaning quit
        if quiting == "yes" :
            sys.exit(0)
    # tkinter frame used to add home, backward and forward buttons
    mainframe = tk.Frame(self, bg = "white")
    
    if sys.platform == "linux": 
        # home button
        tk.Button(mainframe, text = "HOME", command = home).pack(side = "left", padx=10)
        # help button
        tk.Button(mainframe, text = "HELP", command = user_manual).pack(side = "left", padx=10)
        # exit button
        tk.Button(mainframe, text = "EXIT PYTHON", command = clint_exit).pack(side = "left",padx=10)
    elif sys.platform == "win64" or sys.platform == "win32":
        # home button
        ttk.Button(mainframe, text = "HOME", command = home).pack(side = "left", padx=10)
        # help button
        ttk.Button(mainframe, text = "HELP", command = user_manual).pack(side = "left", padx=10)
        # exit button
        ttk.Button(mainframe, text = "EXIT PYTHON", command = clint_exit).pack(side = "left",padx=10)
    else:
        # home button
        tk.Button(mainframe, text = "HOME", command = home).pack(side = "left", padx=10)
        # help button
        tk.Button(mainframe, text = "HELP", command = user_manual).pack(side = "left", padx=10)
        # exit button
        tk.Button(mainframe, text = "EXIT PYTHON", command = clint_exit).pack(side = "left",padx=10)


    mainframe.pack(padx=42, anchor="w")
#==============================================================================



#==============================================================================
# Function ErrorMessage: notify user with error message when error has occurred.
#
# Two inputs:
# arg1_message: main error message
# arg2_detail: ditails
#==============================================================================
def ErrorMessage (arg1_title, arg2_message):
    # return error message
    return messagebox.showwarning(title = arg1_title,
                                  message = arg2_message,
                                  detail= "\nFor instructions on using this "\
                                  "program, please refer to the \"user manual\" "\
                                  "by clicking the \"Help\" button in the "\
                                  "menu bar in ClassificaIO")
#==============================================================================





# pre-populated list of all allowed upload files.
current_data_upload=["#Use My Own Training Data Uploaded Files",
                     "Dependent Data: Not Uploaded",
                     "Target Data: Not Uploaded",
                     "Features Data: Not Uploaded",
                     "Test Data: Not Uploaded",

                     "------------------------------------",
                     "#Already Trained My Model Uploaded Files",
                     "Model: Not Uploaded",
                     "Test Data: Not Uploaded",

                     "------------------------------------",
                     "#Upload History"]

#==============================================================================
# Function UserCurrentDataFileUpload: trace any modification occure to dependent,
# target, Features and testing data file upload, as well as tranied model. It
# also provide user with Log History for any file upload.
#
# Six inputs:
# arg0_StandardizeDataFile_func:   e.g. StandardizeDependentDataFile

# arg1_current_data_upload:        current_data_upload

# data_file_upload_index:          index value used to index current_data_upload
#                                  for corresponding namespace

# arg2_upload_type:                e.g. "Dependent Data: "

# arg3_file_name:                  e.g. dependent_data_file_name

# arg4_file_path:                  e.g. "#Dependent Data Path:"

# arg5_current_data_upload_result: current_data_upload_result
#==============================================================================
def CurrentDataFileUploadTracker(arg0_StandardizeDataFile_func,
                                 arg1_current_data_upload,
                                 data_file_upload_index,
                                 arg2_upload_type,
                                 arg3_file_name,
                                 arg4_file_path,
                                 arg5_current_data_upload_result):

    arg1_current_data_upload[data_file_upload_index]= (arg2_upload_type.title()
                                              +(arg3_file_name.split("/")[-1]))
    if arg3_file_name == "Not Uploaded":
        pass
    else:
        arg1_current_data_upload.append(datetime.datetime.now())
        arg1_current_data_upload.append(arg4_file_path)
        arg1_current_data_upload.append(arg3_file_name)
        arg1_current_data_upload.append("")
    arg5_current_data_upload_result.set(arg1_current_data_upload)



############### Functions Used in All of Fallowing Classes Ends ###############
#==============================================================================








#==============================================================================
# Class StartWindow:
#
# StartWindow is the first window that the user will see once ClassificaIO run.
# It contains 3 buttons that user use to get to the other windows.
#==============================================================================
class StartWindow(tk.Frame):

    # Defin init (initialize) function where self is the first argument
    def __init__(self, parent, controller):

        # Parent is the parent class (main class) which is ClassificaIO
        tk.Frame.__init__(self, parent)

                         ###########################
        # Add Scrollbar to start window
        def OnFrameConfigureStartWindow(canvas):
            '''Reset the scroll region to encompass the inner frame'''
            canvas.configure(scrollregion=canvas.bbox("all"))




        # create main canvas for start window
        StartWindowCanvas = tk.Canvas(self, highlightthickness=0, bg = "white")


        # create main frame and add to convas
        StartWindowCanvasFrame = tk.Frame(StartWindowCanvas, bg = "white")

        # add vertical scrollbar to canvas
        vsb = tk.Scrollbar(StartWindowCanvas,
                           orient="vertical",
                           command = StartWindowCanvas.yview,
                           width=13)
        StartWindowCanvas.configure(yscrollcommand = vsb.set)
        vsb.pack(side="right", fill="y")

        # add horizontal scrollbar to canvas
        hsb = tk.Scrollbar(StartWindowCanvas,
                           orient="horizontal",
                           command=StartWindowCanvas.xview,
                           width=13)
        StartWindowCanvas.configure(xscrollcommand=hsb.set)
        hsb.pack(side="bottom", fill="x")


        StartWindowCanvas.pack(fill="both",anchor = "c",expand=True)

        StartWindowCanvas.create_window((1,1),
                                      window = StartWindowCanvasFrame,
                                      anchor="c")


        # bind WindowOneCanvasFrame to canvas
        StartWindowCanvasFrame.bind("<Configure>",
                                    lambda event,
                                    canvas = StartWindowCanvas:OnFrameConfigureStartWindow(
                                                            StartWindowCanvas))
                         ###########################

                         ###########################

        # Add navigation buttons
        NavigationButtons(StartWindowCanvas,
                          lambda: controller.show_frame(StartWindow))

        tk.Label(StartWindowCanvasFrame, bg = "white").pack(padx=2)
                         ###########################

                         ###########################
        # Add lab logo and ClassificaIO name
        StartWindowMainFrame = tk.Frame(StartWindowCanvasFrame, bg = "white")
        tk.Label(StartWindowMainFrame, bg = "white").pack(pady=10)
        logo_and_ClassificaIO_name_frame = tk.Frame(StartWindowMainFrame, bg = "white")


        #lab logo
        here=path.abspath(path.dirname(__file__))
        logoPath=path.join(here,"logo_Lab_round.png")
        upload_logo = Image.open(logoPath)
        resized_logo = upload_logo.resize((150, 150), Image.ANTIALIAS)
        photoimage_logo = ImageTk.PhotoImage(resized_logo)
        labeled_logo = tk.Label(logo_and_ClassificaIO_name_frame,
                                image = photoimage_logo, bg = "white")
        labeled_logo.image = photoimage_logo
        labeled_logo.pack(side = "left",padx=10, anchor="c")

        # ClassificaIO name
        ClassificaIO_label = tk.Label(logo_and_ClassificaIO_name_frame,
                                      text="ClassificaIO", font= FONT_24_bold, bg = "white")
        ClassificaIO_label.pack(side = "right",padx=10,anchor="c" )


        logo_and_ClassificaIO_name_frame.pack(anchor="c")


        tk.Label(StartWindowMainFrame, bg = "white").pack(pady=10)

        # ClassificaIO title
        tk.Label(StartWindowMainFrame,
                 text="Machine Learning for Classification",
                 font= FONT_20_bold, bg = "white").pack(anchor="c" )


        tk.Label(StartWindowMainFrame, bg = "white").pack(pady=20)

        # Button 1 if users using their own training data
        ttk.Button(StartWindowMainFrame,
                  width= 35,
                  text = "use my own training data".title(),
                  command = lambda: controller.show_frame(
                                          WindowOne_Use_My_Own_Training_Data),
                  default='active').pack(anchor="c")

        tk.Label(StartWindowMainFrame, bg = "white").pack(pady=1)

        # Button 2 if users already trained and exported the model
        ttk.Button(StartWindowMainFrame,
                  width= 35,
                  text = "already trained my model".title(),
                  command = lambda: controller.show_frame(
                                          WindowTwo_Already_Trained_My_Model),
                  default='active').pack(anchor="c")


        if sys.platform == "linux":
            tk.Label(StartWindowMainFrame, bg = "white").pack(pady=183)
            StartWindowMainFrame.pack(anchor = "c", padx=537)

        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(StartWindowMainFrame, bg = "white").pack(pady=192)
            StartWindowMainFrame.pack(anchor = "c", padx=540)

        else:
            tk.Label(StartWindowMainFrame, bg = "white").pack(pady=170)
            StartWindowMainFrame.pack(anchor = "c", padx=546)

                         ###########################





#==============================================================================
##### Functions Used in Class: WindowOne_Use_My_Own_Training_Data Starts ######


#==============================================================================
# Function EmptyFrame: will destroy any widget in frame once a classifier title
# selected.

# inmput =  WindowOneCanvasFrame
#==============================================================================
def EmptyFrame(MainConves, ClassifierName):

    global widgets
    for widget in widgets[:]:
        widget.destroy()
        widgets.remove(widget)

    if ClassifierName == "I. Linear_model":
        
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '1: LogisticRegression', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '2: PassiveAggressiveClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '3: Perceptron', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '4: RidgeClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '5: Stochastic Gradient Descent (SGDClassifier)', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=134)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=137)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=129)
        EmptyFrame_Frame.pack(anchor ="c")


    if ClassifierName == "II. Discriminant_analysis":
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '6: LinearDiscriminantAnalysis', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '7: QuadraticDiscriminantAnalysis', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=170)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=174)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=168)
        EmptyFrame_Frame.pack(anchor ="c")

    if ClassifierName == "III. Support vector machines (SVMs)":
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '8: LinearSVC', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '9: NuSVC', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '10: SVC', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=158)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=162)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=155)
        EmptyFrame_Frame.pack(anchor ="c")

    if ClassifierName == "IV. Neighbors":
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '11: KNeighborsClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '12: NearestCentroid', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '13: RadiusNeighborsClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=158)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=162)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=155)
        EmptyFrame_Frame.pack(anchor ="c")

    if ClassifierName == 'V. Gaussian_process':
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '14: GaussianProcessClassifier', fg = 'SteelBlue3', font= FONT_16, bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=182)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=187)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=181)
        EmptyFrame_Frame.pack(anchor ="c")

    if ClassifierName == 'VI. Naive_bayes':
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '15: BernoulliNB', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '16: GaussianNB', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '17: MultinomialNB', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=158)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=162)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=155)
        EmptyFrame_Frame.pack(anchor ="c")

    if ClassifierName == 'VII. Trees':
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '18: DecisionTreeClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '19: ExtraTreeClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=170)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=174)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=168)
        EmptyFrame_Frame.pack(anchor ="c")

    if ClassifierName == 'VIII. Ensemble':
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '20: AdaBoostClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '21: BaggingClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '22: ExtraTreesClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        tk.Label(EmptyFrame_Frame, text = '23: RandomForestClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=146)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=149)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=142)
        EmptyFrame_Frame.pack(anchor ="c")

    if ClassifierName == 'IX. Semi_supervised':
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '24: LabelPropagation', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=182)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=187)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=181)
        EmptyFrame_Frame.pack(anchor ="c")


    if ClassifierName == 'X. Neural_network':
        EmptyFrame_Frame = tk.Frame(MainConves, bg = "white")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=45)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=50)
        tk.Label(EmptyFrame_Frame, text = ClassifierName, font= FONT_16_underline, fg = 'SteelBlue3', bg = "white").pack()
        tk.Label(EmptyFrame_Frame, text = '25: MLPClassifier', font= FONT_16, fg = 'SteelBlue3', bg = "white").pack(anchor="w")
        if sys.platform == "linux": 
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=182)
        elif sys.platform == "win64" or sys.platform == "win32":
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=187)
        else:
            tk.Label(EmptyFrame_Frame, bg = "white").pack(anchor="w",pady=181)
        EmptyFrame_Frame.pack(anchor ="c")

    # destroy these later
    widgets = widgets[:] + [EmptyFrame_Frame]

    for widget in widgets:
        widget.pack() # pack them afterwards





#==============================================================================
# Function OpenDependentDataFile: used to upload dependent data file, as well as
# read and transpose dependent data file to use by Sklearn.

#==============================================================================
def OpenDependentDataFile():
    ''' function to select, upload and read dependent data file '''
    data_file_name = ""
    read_file =  ""


    # upload csv and excel (xlsx) dependent data file
    file_opt = options = {}
    options['filetypes'] = [("CSV files", "*.csv")]


    # open dialog box - opne and read selected file
    dependent_data_file_dialogbox  = tk.filedialog.askopenfile(mode = "rb", **file_opt)


    if dependent_data_file_dialogbox is None:
        data_file_name = "empty"
        read_file = "empty"

    if dependent_data_file_dialogbox is not None:

        data_file_name = dependent_data_file_dialogbox.name
        try:
            # Use index_col = [0] to add column to use as the row labels of
            # the DataFrame and then transpose
            read_file = pd.read_csv(
                    dependent_data_file_dialogbox, index_col = [0]).transpose()
        except:
            read_file = "empty"

    return data_file_name, read_file



#==============================================================================
# Function StandardizeDependentDataFile: will check if dependent data file was
# uploaded or not and execute accordingly. If file is uploaded correctely then
# it will add "id" header to column index 0.

# "id" header will be used to merge both dependent and target datasets.
#==============================================================================
def StandardizeDependentDataFile():
    ''' function to standardize dependent data file '''
    # globalize dependent data file name to show in user "current data upload"
    # window which show user Log History for any file upload.
    global dependent_data_file_name
    global OpenDependentDataFile_output_ReadFile_new
    global OpenDependentDataFile_output_ReadFile_oroginal

    # call function where files been uploaded
    OpenDependentDataFile_output = OpenDependentDataFile()

    # index 0 = file name
    OpenDependentDataFile_output_FileName = OpenDependentDataFile_output[0]
    # index 1 = read file
    OpenDependentDataFile_output_ReadFile = OpenDependentDataFile_output[1]

    # if both file name and read file are empty (no file uploaded)
    if (OpenDependentDataFile_output_ReadFile is "empty"
        and OpenDependentDataFile_output_FileName is "empty"):
        # reset dependent file name to  not uploaded
        dependent_data_file_name = "Not Uploaded"


    # if both file name and read file are not empty (file has been uploaded)
    if (OpenDependentDataFile_output_ReadFile is not "empty"
        and OpenDependentDataFile_output_FileName is not "empty"):
        # keep dependent file name the same
        dependent_data_file_name = OpenDependentDataFile_output_FileName

        OpenDependentDataFile_output_ReadFile_new = OpenDependentDataFile_output_ReadFile
        OpenDependentDataFile_output_ReadFile_new.reset_index(inplace=True)
        accessions_headr = list(OpenDependentDataFile_output_ReadFile_new.columns)[0]
        # change first column headr (CEL files IDs) to id
        OpenDependentDataFile_output_ReadFile_new = (
                OpenDependentDataFile_output_ReadFile_new.rename(columns =
                                                {accessions_headr:'id'}))
        OpenDependentDataFile_output_ReadFile_new["id"]=list(map(str,OpenDependentDataFile_output_ReadFile_new["id"]))
        OpenDependentDataFile_output_ReadFile_oroginal = list(map(str,OpenDependentDataFile_output_ReadFile.columns.values))

    # if file name not empty and read file is empty (no file uploaded)
    if (OpenDependentDataFile_output_ReadFile is "empty" and
        OpenDependentDataFile_output_FileName is not "empty"):
        # reset dependent file name to  not uploaded
        dependent_data_file_name = "Not Uploaded"

        file_name_error= OpenDependentDataFile_output_FileName.split("/")[-1]
        ErrorMessage("Dependent Data File In Use",
                 "An error has occurred during parsing \""+file_name_error\
                 +"\", the error may have been caused by dataset format!")







#==============================================================================
# Function OpenTargetDataFile: used to upload and read dependent data file to
# use by Sklearn.

#==============================================================================
def OpenTargetDataFile():
    ''' function to select, upload and read target data file '''
    data_file_name = ""
    read_file =  ""


    # upload csv and excel (xlsx) dependent data file
    file_opt = options = {}
    options['filetypes'] = [("CSV files", "*.csv")]


    # open dialog box - opne and read selected file
    target_data_file_dialogbox  = tk.filedialog.askopenfile(mode = "rb", **file_opt)


    if target_data_file_dialogbox is None:
        data_file_name = "empty"
        read_file = "empty"

    if target_data_file_dialogbox is not None:

        data_file_name = target_data_file_dialogbox.name
        try:
            # open and read csv file
            read_file = pd.read_csv(
                    target_data_file_dialogbox)
        except:
            read_file = "empty"

    return data_file_name, read_file



#==============================================================================
# Function StandardizeTargetDataFile: will add "id" header to column index 0
# and "target" header to column index 1.

# "id" header will be used to merge both dependent and target datasets.
#==============================================================================
def StandardizeTargetDataFile():
    ''' function to standardize target data file '''
    # globalize target data file name to show in user "current data upload"
    # window which show user Log History for any file upload.
    global target_data_file_name
    global OpenTargetDataFile_output_ReadFile_new

    # call function where files been uploaded
    OpenTargetDataFile_output = OpenTargetDataFile()

    # index 0 = file name
    OpenTargetDataFile_output_FileName = OpenTargetDataFile_output[0]
    # index 1 = read file
    OpenTargetDataFile_output_ReadFile = OpenTargetDataFile_output[1]

    # if both file name and read file are empty (no file uploaded)
    if (OpenTargetDataFile_output_ReadFile is "empty"
        and OpenTargetDataFile_output_FileName is "empty"):
        # reset target file name to  not uploaded
        target_data_file_name = "Not Uploaded"


    # if both file name and read file are not empty (file has been uploaded)
    if (OpenTargetDataFile_output_ReadFile is not "empty"
        and OpenTargetDataFile_output_FileName is not "empty"):
        # keep target file name the same
        target_data_file_name = OpenTargetDataFile_output_FileName

        # change first column headr (CEL files IDs) to ID
        accessions_headr_id = list(OpenTargetDataFile_output_ReadFile.columns)[0]
        accessions_headr_target = list(OpenTargetDataFile_output_ReadFile.columns)[1]

        # add "id" header to column index 0.
        OpenTargetDataFile_output_ReadFile = (
                OpenTargetDataFile_output_ReadFile.rename(columns =
                                        {accessions_headr_id:'id'}))

        # add "target" header to column index 1.
        OpenTargetDataFile_output_ReadFile_new = (
                OpenTargetDataFile_output_ReadFile.rename(columns =
                                        {accessions_headr_target:'target'}))
        OpenTargetDataFile_output_ReadFile_new["id"]   =list(map(str,OpenTargetDataFile_output_ReadFile_new["id"]))


    # if file name not empty and read file is empty (no file uploaded)
    if (OpenTargetDataFile_output_ReadFile is "empty" and
        OpenTargetDataFile_output_FileName is not "empty"):
        # reset target file name to  not uploaded
        target_data_file_name = "Not Uploaded"

        file_name_error= OpenTargetDataFile_output_FileName.split("/")[-1]
        ErrorMessage("Target Data File In Use",
                 "An error has occurred during parsing \""+file_name_error\
                 +"\", the error may have been caused by dataset format!")





#==============================================================================
# Function OpenFeaturesDataFile: used to upload features data file, as well as
# read and transpose features data file to use by Sklearn.

#==============================================================================
def OpenFeaturesDataFile():
    ''' function to select, upload and read features data file '''
    data_file_name = ""
    read_file =  ""


    # upload csv and excel (xlsx) dependent data file
    file_opt = options = {}
    options['filetypes'] = [("CSV files", "*.csv")]


    # open dialog box - opne and read selected file
    features_data_file_dialogbox  = tk.filedialog.askopenfile(mode = "rb", **file_opt)


    if features_data_file_dialogbox is None:
        data_file_name = "empty"
        read_file = "empty"

    if features_data_file_dialogbox is not None:

        data_file_name = features_data_file_dialogbox.name
        try:
            # Use index_col = [0] to add column to use as the row labels of
            # the DataFrame and then transpose
            read_file = pd.read_csv(
                    features_data_file_dialogbox, index_col = [0]).transpose()
        except:
            read_file = "empty"

    return data_file_name, read_file



#==============================================================================
# Function StandardizeFeaturesDataFile: will extract columns headers incase user
# which to extract and intersect a subset of headers

#==============================================================================
def StandardizeFeaturesDataFile():
    ''' function to standardize features data file '''
    # globalize target data file name to show in user "current data upload"
    # window which show user Log History for any file upload.
    global features_data_file_name
    global OpenFeaturesDataFile_output_ReadFile_new

    # call function where files been uploaded
    OpenFeaturesDataFile_output = OpenFeaturesDataFile()

    # index 0 = file name
    OpenFeaturesDataFile_output_FileName = OpenFeaturesDataFile_output[0]
    # index 1 = read file
    OpenFeaturesDataFile_output_ReadFile = OpenFeaturesDataFile_output[1]

    # if both file name and read file are empty (no file uploaded)
    if (OpenFeaturesDataFile_output_ReadFile is "empty"
        and OpenFeaturesDataFile_output_FileName is "empty"):
        # reset target file name to  not uploaded
        features_data_file_name = "Not Uploaded"


    # if both file name and read file are not empty (file has been uploaded)
    if (OpenFeaturesDataFile_output_ReadFile is not "empty"
        and OpenFeaturesDataFile_output_FileName is not "empty"):
        # keep target file name the same
        features_data_file_name = OpenFeaturesDataFile_output_FileName
        OpenFeaturesDataFile_output_ReadFile_new = list(map(str,
                        OpenFeaturesDataFile_output_ReadFile.columns.values))


    # if file name not empty and read file is empty (no file uploaded)
    if (OpenFeaturesDataFile_output_ReadFile is "empty" and
        OpenFeaturesDataFile_output_FileName is not "empty"):
        # reset target file name to  not uploaded
        features_data_file_name = "Not Uploaded"

        file_name_error= OpenFeaturesDataFile_output_FileName.split("/")[-1]
        ErrorMessage("Features Data File In Use",
                 "An error has occurred during parsing \""+file_name_error\
                 +"\", the error may have been caused by dataset format!")







#==============================================================================
# Function OpenTestDataFile: used to upload test data file, as well as
# read and transpose test data file to use by Sklearn.

#==============================================================================
def OpenTestDataFile():
    ''' function to select, upload and read test data file '''
    data_file_name = ""
    read_file =  ""


    # upload csv and excel (xlsx) dependent data file
    file_opt = options = {}
    options['filetypes'] = [("CSV files", "*.csv")]


    # open dialog box - opne and read selected file
    test_data_file_dialogbox  = tk.filedialog.askopenfile(mode = "rb", **file_opt)


    if test_data_file_dialogbox is None:
        data_file_name = "empty"
        read_file = "empty"

    if test_data_file_dialogbox is not None:

        data_file_name = test_data_file_dialogbox.name
        try:
            # Use index_col = [0] to add column to use as the row labels of
            # the DataFrame and then transpose
            read_file = pd.read_csv(
                    test_data_file_dialogbox, index_col = [0]).transpose()
        except:
            read_file = "empty"

    return data_file_name, read_file



#==============================================================================
# Function StandardizeTestDataFile: will add "id" header to column index 0

# "id" header will be used to merge test, dependent and target datasets.
#==============================================================================
def StandardizeTestDataFile():
    ''' function to standardize test data file '''
    # globalize test data file name to show in user "current data upload"
    # window which show user Log History for any file upload.
    global test_data_file_name
    global OpenTestDataFile_output_ReadFile_new
    global OpenTestDataFile_output_ReadFile_oroginal

    # call function where files been uploaded
    OpenTestDataFile_output = OpenTestDataFile()

    # index 0 = file name
    OpenTestDataFile_output_FileName = OpenTestDataFile_output[0]
    # index 1 = read file
    OpenTestDataFile_output_ReadFile = OpenTestDataFile_output[1]

    # if both file name and read file are empty (no file uploaded)
    if (OpenTestDataFile_output_ReadFile is "empty"
        and OpenTestDataFile_output_FileName is "empty"):
        # reset test file name to "not uploaded"
        test_data_file_name = "Not Uploaded"


    # if both file name and read file are not empty (file has been uploaded)
    if (OpenTestDataFile_output_ReadFile is not "empty"
        and OpenTestDataFile_output_FileName is not "empty"):
        # keep test file name the same
        test_data_file_name = OpenTestDataFile_output_FileName

        OpenTestDataFile_output_ReadFile_new = OpenTestDataFile_output_ReadFile
        OpenTestDataFile_output_ReadFile_new.reset_index(inplace=True)
        accessions_headr = list(OpenTestDataFile_output_ReadFile_new.columns)[0]
        # change first column headr (CEL files IDs) to id
        OpenTestDataFile_output_ReadFile_new = (
                OpenTestDataFile_output_ReadFile_new.rename(columns =
                                                {accessions_headr:'id'}))
        OpenTestDataFile_output_ReadFile_oroginal = OpenTestDataFile_output_ReadFile


    # if file name not empty and read file is empty (no file uploaded)
    if (OpenTestDataFile_output_ReadFile is "empty" and
        OpenTestDataFile_output_FileName is not "empty"):
        # reset test file name to "not uploaded"
        test_data_file_name = "Not Uploaded"

        file_name_error= OpenTestDataFile_output_FileName.split("/")[-1]
        ErrorMessage("Test Data File In Use",
                 "An error has occurred during parsing \""+file_name_error\
                 +"\", the error may have been caused by dataset format!")






####### Functions Used in Class: WindowOne_Use_My_Own_Training_Data Ends ######
#==============================================================================



#==============================================================================
# Class WindowOne_Use_My_Own_Training_Data:
#
# This class allow user to train model using their own data. Data to upload:
# 1: Dependent data file:
# 2: Target data file:
# 3: Features file (optional):
#==============================================================================
class WindowOne_Use_My_Own_Training_Data(tk.Frame):


    def __init__(self, parent, controller):

        tk.Frame.__init__(self, parent)

                         ###########################
                         ###########################
        # Add Scrollbar to window one
        def OnFrameConfigureWindowOne(canvas):
            '''Reset the scroll region to encompass the inner frame'''
            canvas.configure(scrollregion=canvas.bbox("all"))




        # create main canvas for window two
        WindowOneCanvas = tk.Canvas(self, highlightthickness=0, bg = "white")


        # create main frame and add to convas
        WindowOneCanvasFrame = tk.Frame(WindowOneCanvas, bg = "white")

        # add vertical scrollbar to canvas
        vsb = tk.Scrollbar(WindowOneCanvas,
                           orient="vertical",
                           command = WindowOneCanvas.yview,
                           width=13)
        WindowOneCanvas.configure(yscrollcommand = vsb.set)
        vsb.pack(side="right", fill="y")

        # add horizontal scrollbar to canvas
        hsb = tk.Scrollbar(WindowOneCanvas,
                           orient="horizontal",
                           command=WindowOneCanvas.xview,
                           width=13)
        WindowOneCanvas.configure(xscrollcommand=hsb.set)
        hsb.pack(side="bottom", fill="x")


        WindowOneCanvas.pack(fill="both",anchor = "c",expand=True)

        WindowOneCanvas.create_window((1,1),
                                      window = WindowOneCanvasFrame,
                                      anchor="c")


        # bind WindowOneCanvasFrame to canvas
        WindowOneCanvasFrame.bind("<Configure>",
                          lambda event,
                          canvas = WindowOneCanvas:OnFrameConfigureWindowOne(
                                                              WindowOneCanvas))
                         ###########################
                         ###########################


                         ###########################
                         ###########################
        # Add navigation buttons
        NavigationButtons(WindowOneCanvas,
                          lambda: controller.show_frame(StartWindow))

        tk.Label(WindowOneCanvasFrame, bg = "white").pack(padx=2)
                         ###########################
                         ###########################



                         ###########################
                         ###########################
        # current_data_upload_result is to trace any modification occure
        # regarding user upload files.
        global current_data_upload
        global current_data_upload_result
        current_data_upload_result = StringVar()
        current_data_upload_result.set(current_data_upload)
                         ###########################
                         ###########################


        global training_data_upload_widgets
        training_data_upload_widgets = [] # contain widgets to be deleted

        # Allow user to upload traning data files
        def training_data_upload_function():


            global training_data_upload_selection_result

            training_data_upload_selection_result = training_data_upload_selection.get()


            # destroy widgets
            global training_data_upload_widgets
            for widget in training_data_upload_widgets[:]:
                widget.destroy()
                training_data_upload_widgets.remove(widget)


                        ###########################
            # Dependent, Target and Features data files
            if training_data_upload_selection_result == "1":

                training_data_upload_selection_frame = ttk.Frame(TrainingDataUploadFrame, padding=(10, 10, 10, 10), relief= "flat", borderwidth=1)

                ttk.Button(training_data_upload_selection_frame, text="Dependent", width=10, command = lambda: CurrentDataFileUploadTracker(StandardizeDependentDataFile(), current_data_upload, 1, "Dependent Data: ", dependent_data_file_name, "#Dependent Data Path:", current_data_upload_result)).pack()

                ttk.Button(training_data_upload_selection_frame, text="Target", width=10, command = lambda: CurrentDataFileUploadTracker(StandardizeTargetDataFile(), current_data_upload, 2, "Target Data: ", target_data_file_name, "#Target Data Path:", current_data_upload_result)).pack()

                ttk.Button(training_data_upload_selection_frame, text="Features", width=10, command = lambda: CurrentDataFileUploadTracker(StandardizeFeaturesDataFile(), current_data_upload, 3, "Features Data: ", features_data_file_name, "#Features Data Path:", current_data_upload_result)).pack()

                training_data_upload_selection_frame.pack(anchor = "c")

            # Dependent and Target data files
            if training_data_upload_selection_result == "2":

                training_data_upload_selection_frame = ttk.Frame(TrainingDataUploadFrame, padding=(10, 10, 10, 10), relief= "flat", borderwidth=1)

                ttk.Button(training_data_upload_selection_frame, text="Dependent", width=10, command = lambda: CurrentDataFileUploadTracker(StandardizeDependentDataFile(), current_data_upload, 1, "Dependent Data: ", dependent_data_file_name, "#Dependent Data Path:", current_data_upload_result)).pack()

                ttk.Button(training_data_upload_selection_frame, text="Target", width=10, command = lambda: CurrentDataFileUploadTracker(StandardizeTargetDataFile(), current_data_upload, 2, "Target Data: ", target_data_file_name, "#Target Data Path:", current_data_upload_result)).pack()

                ttk.Label(training_data_upload_selection_frame).pack(pady=2)

                training_data_upload_selection_frame.pack(anchor = "c")
                        ###########################


            # destroy later
            training_data_upload_widgets = (training_data_upload_widgets[:] + [training_data_upload_selection_frame])
            # pack them afterwards
            for widget in training_data_upload_widgets:
                widget.pack()


                         ###########################
                         ###########################
                         ###########################
                         ###########################


        # list of all 12 classifiers
        ListOfAllClassifiers = ("I. Linear_model",
                                '1: LogisticRegression',
                                '2: PassiveAggressiveClassifier',
                                '3: Perceptron',
                                '4: RidgeClassifier',
                                '5: Stochastic Gradient Descent (SGDClassifier)',

                                "II. Discriminant_analysis",
                                '6: LinearDiscriminantAnalysis',
                                '7: QuadraticDiscriminantAnalysis',

                                'III. Support vector machines (SVMs)',
                                '8: LinearSVC',
                                '9: NuSVC',
                                '10: SVC',

                                'IV. Neighbors',
                                '11: KNeighborsClassifier',
                                '12: NearestCentroid',
                                '13: RadiusNeighborsClassifier',

                                'V. Gaussian_process',
                                '14: GaussianProcessClassifier',

                                'VI. Naive_bayes',
                                '15: BernoulliNB',
                                '16: GaussianNB',
                                '17: MultinomialNB',

                                'VII. Trees',
                                '18: DecisionTreeClassifier',
                                '19: ExtraTreeClassifier',

                                'VIII. Ensemble',
                                '20: AdaBoostClassifier',
                                '21: BaggingClassifier',
                                '22: ExtraTreesClassifier',
                                '23: RandomForestClassifier',

                                'IX. Semi_supervised',
                                '24: LabelPropagation',

                                'X. Neural_network',
                                '25: MLPClassifier')

        AllClassifiers = StringVar(value = ListOfAllClassifiers)



        # SelectedClassifier used to set classifier once is selected
        SelectedClassifier = StringVar()

        # this list will contain widgets to be deleted

        global widgets
        widgets = []

        # This function will contain 14 other functions:
        # each function will be to call a separate classifier

        def ClassifiersSelectionFunc(*args):


            press_selection = AllClassifiersListbox.curselection()
            if len(press_selection)==1:
                press_selection_idx = int(press_selection[0])
                AllClassifiersListbox.see(press_selection_idx)
                classifier_name = ListOfAllClassifiers[press_selection_idx]

                # Set selected classifier to SelectedClassifier
                SelectedClassifier.set(classifier_name)
          #########################################################
          #########################################################
          #########################################################




          #########################################################
          #########################################################
          #########################################################
                # Call function EmptyFrame if user select
                # #Generalized Linear Models from classifiers list.
                if classifier_name ==  "I. Linear_model":
                    EmptyFrame(WindowOneCanvasFrame, classifier_name)


                # Call function LogisticRegression_MainFunc if user select
                # LogisticRegression from classifiers list.
                if classifier_name == '1: LogisticRegression':

                    def LogisticRegression_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################


                        def LogisticRegression_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            LR_TrainTestSplit_vs_KFold_Result = LR_TrainTestSplit_vs_KFold.get()
                            LR_TrainTestSplit_Scale_Result = LR_TrainTestSplit_Scale.get()/100
                            LR_KFold_Result = LR_KFold.get()

                            # get random_state value
                            if LR_random_state_int_or_none.get() == "None":
                                LR_random_state_Result = None
                            else:
                                LR_random_state_Result = LR_random_state.get()

                            LR_penalty_Result = LR_penalty.get() # get penalty value
                            LR_multi_class_result = LR_multi_class.get() # get multi_class value
                            LR_solver_result = LR_solver.get() # get solver value
                            LR_max_iter_result = LR_max_iter.get() # get max_iter value
                            LR_tol_result = LR_tol.get()# get tol value
                            LR_intercept_scaling_result = LR_intercept_scaling.get() # get intercept_scaling value
                            LR_verbose_result = LR_verbose.get() # get verbose value
                            LR_n_jobs_result = LR_n_jobs.get() # get n_jobs value
                            LR_C_result = LR_C.get() # get C value
                            LR_fit_intercept_result  = LR_fit_intercept.get() # get fit_intercept value
                            LR_dual_result = LR_dual.get() # get dual value
                            LR_warm_start_result = LR_warm_start.get() # get warm_start value


                            CallClassifier = LogisticRegression(
                                            penalty = LR_penalty_Result,
                                            dual = LR_dual_result,
                                            tol= LR_tol_result,
                                            C = LR_C_result,
                                            fit_intercept = LR_fit_intercept_result,
                                            intercept_scaling = LR_intercept_scaling_result,
                                            class_weight = None,
                                            random_state = LR_random_state_Result,
                                            solver = LR_solver_result,
                                            max_iter= LR_max_iter_result,
                                            multi_class = LR_multi_class_result,
                                            verbose = LR_verbose_result,
                                            warm_start = LR_warm_start_result,
                                            n_jobs = LR_n_jobs_result)



                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################


                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                        "random_state = "+str(LR_random_state_Result),
                                                        "shuffle = " +str(True),
                                                        "penalty = " + str(LR_penalty_Result) ,
                                                        "multi_class = "+str(LR_multi_class_result),
                                                        "solver = "+str(LR_solver_result),
                                                        "max_iter= "+str(LR_max_iter_result),
                                                        "tol = "+ str(LR_tol_result),
                                                        "intercept_scaling = "+ str(LR_intercept_scaling_result),
                                                        "verbose = "+str(LR_verbose_result),
                                                        "n_jobs = "+str(LR_n_jobs_result),
                                                        "C = "+ str(LR_C_result),
                                                        "fit_intercept = "+str(LR_fit_intercept_result),
                                                        "dual = "+ str(LR_dual_result),
                                                        "warm_start = "+str(LR_warm_start_result),
                                                        "class_weight = "+str(None))



                                    LR_Classifier_Result.set(Classifier_Pramaters)

                                        ####################################
                                        ####################################



                                    # if user select Train Sample Size (%)
                                    if LR_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = LR_TrainTestSplit_Scale_Result, test_size = 1-LR_TrainTestSplit_Scale_Result, random_state= LR_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if LR_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = LR_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = LR_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)


                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy



                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################

                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])




              ###########################################

                        # This frame contain all logistic regression classifier
                        # parameters including classifier discription.
                        LogisticRegressionParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2bDrRAS")

                        SelectedClassifier_and_Link_Frame = tk.Frame(LogisticRegressionParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################

                        discription = ("\"Logistic regression, despite its "+
                                       "name, is a linear model for classification "+
                                       "rather than regression. Logistic "+
                                       "regression is also known in the literature "+
                                       "as logit regression, maximum-entropy "+
                                       "classification (MaxEnt) or the log-linear "+
                                       "classifier.\"")

                        tk.Label(LogisticRegressionParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=10)

                                        ###################
                                        ###################


                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        LR_TrainTestSplit_vs_KFold_Frame=tk.Frame(LogisticRegressionParameters_Frame, bg = "white")


                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        LR_TrainTestSplit_Frame = tk.Frame(LR_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        LR_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(LR_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = LR_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        LR_TrainTestSplit_vs_KFold.set(1)
                        LR_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(LR_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = LR_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        LR_TrainTestSplit_Scale.set(75)
                        LR_TrainTestSplit_Frame.pack(side="top",anchor ="w")




                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        LR_KFold_frame = tk.Frame(LR_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(LR_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = LR_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        LR_KFold= IntVar()
                        tk.Spinbox(LR_KFold_frame, textvariable = LR_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        LR_KFold.set(10)
                        LR_KFold_frame.pack(side="top",anchor ="w")

                        LR_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                        #######################################################


                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        LR_random_state_int_or_none_frame = tk.Frame(LogisticRegressionParameters_Frame, bg = "white")

                        tk.Label(LR_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        LR_random_state_int_frame = tk.Frame(LR_random_state_int_or_none_frame, bg = "white")
                        LR_random_state_int_or_none = StringVar()
                        tk.Radiobutton(LR_random_state_int_frame, text="Integer: ", font = FONT_12, variable = LR_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        LR_random_state_int_or_none.set("None")
                        LR_random_state = IntVar()
                        tk.Spinbox(LR_random_state_int_frame, textvariable = LR_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        LR_random_state.set(0)
                        LR_random_state_int_frame.pack(anchor ="n")

                        LR_random_state_none_frame = tk.Frame(LR_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(LR_random_state_none_frame, text="None", font = FONT_12, variable = LR_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(LR_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        LR_random_state_none_frame.pack(side="left",anchor ="s")

                        LR_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        LR_penalty_multi_class_solver_Frame = tk.Frame(LogisticRegressionParameters_Frame, bg = "white")
                        
                        # declare multi_class parameter
                        LR_multi_class_Frame = tk.Frame(LR_penalty_multi_class_solver_Frame, bg = "white")
                        tk.Label(LR_multi_class_Frame, text="multi_class:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        LR_multi_class = StringVar()
                        LR_multi_class.set("ovr")
                        tk.OptionMenu(LR_multi_class_Frame, LR_multi_class, "ovr", "multinomial").pack(side="right",anchor ="c")
                        LR_multi_class_Frame.pack(side="top",anchor ="w")
                        
                        if sys.platform == "linux": 
                            penalty = "penalty:        "
                            solver = "solver:          "
                            max_iter = "max_iter:                "
                            tol = "tol:                            "
                            n_jobs="n_jobs:  "
                            C="C:            "
                        elif sys.platform == "win64" or sys.platform == "win32":
                            penalty= "penalty:      "
                            solver = "solver:        "
                            max_iter= "max_iter:            "
                            tol = "tol:                     "
                            n_jobs="n_jobs:  "
                            C="C:         "
                        else:
                            penalty= "penalty:      "
                            solver = "solver:        "
                            max_iter= "max_iter:              "
                            tol = "tol:                        "
                            n_jobs="n_jobs:   "
                            C="C:           "  
                          
                        # declare penalty parameter, str = l1 or l2, default: l2
                        LR_penalty_Frame = tk.Frame(LR_penalty_multi_class_solver_Frame, bg = "white")
                        tk.Label(LR_penalty_Frame, text = penalty, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        LR_penalty = StringVar()
                        LR_penalty.set("l2")
                        tk.OptionMenu(LR_penalty_Frame, LR_penalty, "l1", "l2").pack(side="right",anchor ="c")
                        LR_penalty_Frame.pack(side="top",anchor ="w")


                        # declare solver parameter
                        LR_solver_Frame = tk.Frame(LR_penalty_multi_class_solver_Frame, bg = "white")
                        tk.Label(LR_solver_Frame, text = solver, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        LR_solver = StringVar()
                        LR_solver.set("liblinear")
                        tk.OptionMenu(LR_solver_Frame, LR_solver, "liblinear", "newton-cg", "lbfgs", "sag", "saga").pack(side="right",anchor ="c")
                        LR_solver_Frame.pack(side="top",anchor ="w")

                        LR_penalty_multi_class_solver_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # frame contains intercept_scaling, max_iter, and tol parameters
                        LR_intercept_scaling_max_iter_tol_Frame = tk.Frame(LogisticRegressionParameters_Frame, bg = "white")

                        # declare intercept_scaling parameter
                        LR_intercept_scaling_Frame = tk.Frame(LR_intercept_scaling_max_iter_tol_Frame, bg = "white")
                        tk.Label(LR_intercept_scaling_Frame, text="intercept_scaling:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LR_intercept_scaling = DoubleVar()
                        tk.Spinbox(LR_intercept_scaling_Frame, textvariable = LR_intercept_scaling, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        LR_intercept_scaling.set(1)
                        LR_intercept_scaling_Frame.pack(side="top", anchor ="w")
                    

                        # declare max_iter parameter
                        LR_max_iter_Frame = tk.Frame(LR_intercept_scaling_max_iter_tol_Frame, bg = "white")
                        tk.Label(LR_max_iter_Frame, text = max_iter, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LR_max_iter = IntVar()
                        tk.Spinbox(LR_max_iter_Frame, textvariable = LR_max_iter, from_=1, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        LR_max_iter.set(100)
                        LR_max_iter_Frame.pack(side="top", anchor ="w")

                        # declare tol parameter
                        LR_tol_Frame = tk.Frame(LR_intercept_scaling_max_iter_tol_Frame, bg = "white")
                        tk.Label(LR_tol_Frame, text = tol , font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LR_tol = DoubleVar()
                        tk.Spinbox(LR_tol_Frame, textvariable = LR_tol, increment = 0.0001,from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        LR_tol.set("{:.1E}".format(Decimal(0.0001)))
                        LR_tol_Frame.pack(side="top", anchor ="w")


                        LR_intercept_scaling_max_iter_tol_Frame.pack(side= "left", anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # frame contains verbose, n_jobs, and C parameters
                        LR_verbose_n_jobs_C_Frame = tk.Frame(LogisticRegressionParameters_Frame, bg = "white")

                        # declare verbose parameter
                        LR_verbose_Frame = tk.Frame(LR_verbose_n_jobs_C_Frame, bg = "white")
                        tk.Label(LR_verbose_Frame, text="verbose:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LR_verbose = IntVar()
                        tk.Spinbox(LR_verbose_Frame, textvariable = LR_verbose, from_=0, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        LR_verbose.set(0)
                        LR_verbose_Frame.pack(side="top", anchor ="w")

                            
                        # declare verbose parameter
                        LR_n_jobs_Frame = tk.Frame(LR_verbose_n_jobs_C_Frame, bg = "white")
                        tk.Label(LR_n_jobs_Frame, text = n_jobs, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LR_n_jobs = IntVar()
                        tk.Spinbox(LR_n_jobs_Frame, textvariable = LR_n_jobs, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        LR_n_jobs.set(1)
                        LR_n_jobs_Frame.pack(side="top", anchor ="w")

                        # declare C parameter
                        LR_C_Frame = tk.Frame(LR_verbose_n_jobs_C_Frame, bg = "white")
                        tk.Label(LR_C_Frame, text = C, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LR_C = DoubleVar()
                        tk.Spinbox(LR_C_Frame, textvariable = LR_C, from_=1, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        LR_C.set(1)
                        LR_C_Frame.pack(side="top",anchor ="w")

                        LR_verbose_n_jobs_C_Frame.pack(side= "left", anchor ="n",padx =10)

                                        ###################
                                        ###################


                        # declare fit_intercept parameter, bool = default: True
                        LR_fit_intercept_Frame = tk.Frame(LogisticRegressionParameters_Frame, bg = "white")
                        tk.Label(LR_fit_intercept_Frame, text="fit_intercept:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        LR_fit_intercept = BooleanVar()
                        tk.Radiobutton(LR_fit_intercept_Frame, text= "True", variable = LR_fit_intercept, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(LR_fit_intercept_Frame, text= "False", variable = LR_fit_intercept, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        LR_fit_intercept.set(True)
                        LR_fit_intercept_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare dual parameter, bool = default: False
                        LR_dual_Frame = tk.Frame(LogisticRegressionParameters_Frame, bg = "white")
                        tk.Label(LR_dual_Frame, text="dual:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        LR_dual = BooleanVar()
                        tk.Radiobutton(LR_dual_Frame, text= "True", variable = LR_dual, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(LR_dual_Frame, text= "False", variable = LR_dual, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        LR_dual.set(False)
                        LR_dual_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare warm_start parameter, bool = default: False
                        LR_warm_start_Frame = tk.Frame(LogisticRegressionParameters_Frame, bg = "white")
                        tk.Label(LR_warm_start_Frame, text="warm_start:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        LR_warm_start = BooleanVar()
                        tk.Radiobutton(LR_warm_start_Frame, text= "True", variable = LR_warm_start, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(LR_warm_start_Frame, text= "False", variable = LR_warm_start, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        LR_warm_start.set(False)
                        LR_warm_start_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        LogisticRegressionParameters_Frame.pack(anchor ="c")


              ###########################################

                        # declare Logistic Regression classifier result
                        LogisticRegression_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(LogisticRegression_ClassifierEvaluation_MainFrame, width=8, text= "Submit", default='active',command = LogisticRegression_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(LogisticRegression_ClassifierEvaluation_MainFrame, width=8, text= "Submit", default='active',command = LogisticRegression_SubFunc).pack(anchor="c", pady=15)
                        else:
                            ttk.Button(LogisticRegression_ClassifierEvaluation_MainFrame, width=8, text= "Submit", default='active',command = LogisticRegression_SubFunc).pack(anchor="c", pady=20)

                        LogisticRegressionSelectedParameters_Frame = tk.Frame(LogisticRegression_ClassifierEvaluation_MainFrame, bg = "white")
                        LR_Classifier_Result = StringVar()
                        tk.Label(LogisticRegressionSelectedParameters_Frame, textvariable = LR_Classifier_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        LR_Classifier_Result.set("")
                        LogisticRegressionSelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################
                                                                                                                                                                                                        

                        LogisticRegression_output_MainFrame = ttk.Frame(LogisticRegression_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        LogisticRegression_ModelEvaluationStatistics_Frame = ttk.Frame(LogisticRegression_output_MainFrame,padding=(10, 10, 10, 10))

                        LogisticRegression_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(LogisticRegression_ModelEvaluationStatistics_Frame)
                        ttk.Label(LogisticRegression_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        

                        if sys.platform == "linux": 
                            LogisticRegression_ModelEvaluationStatistics_Listbox = tk.Listbox(LogisticRegression_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            LogisticRegression_ModelEvaluationStatistics_Listbox = tk.Listbox(LogisticRegression_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            LogisticRegression_ModelEvaluationStatistics_Listbox = tk.Listbox(LogisticRegression_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                                                    
                        # add vertical scrollbar to list
                        LogisticRegression_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(LogisticRegression_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = LogisticRegression_ModelEvaluationStatistics_Listbox.yview, width=10)
                        LogisticRegression_ModelEvaluationStatistics_Listbox.config(yscrollcommand = LogisticRegression_ModelEvaluationStatistics_Scrollbar_v.set)
                        LogisticRegression_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                
                        # add vertical scrollbar to list
                        LogisticRegression_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(LogisticRegression_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = LogisticRegression_ModelEvaluationStatistics_Listbox.xview, width=10)
                        LogisticRegression_ModelEvaluationStatistics_Listbox.config(xscrollcommand = LogisticRegression_ModelEvaluationStatistics_Scrollbar_h.set)
                        LogisticRegression_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       


                        LogisticRegression_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        LogisticRegression_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(LogisticRegression_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")
                        LogisticRegression_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(LogisticRegression_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # id - actual - predicted
                        LogisticRegression_IdActualPredicted_Frame = ttk.Frame(LogisticRegression_output_MainFrame,padding=(14, 10, 10, 10))

                        LogisticRegression_IdActualPredicted_Listbox_Frame = ttk.Frame(LogisticRegression_IdActualPredicted_Frame)
                        ttk.Label(LogisticRegression_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            LogisticRegression_IdActualPredicted_Listbox = tk.Listbox(LogisticRegression_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            LogisticRegression_IdActualPredicted_Listbox = tk.Listbox(LogisticRegression_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            LogisticRegression_IdActualPredicted_Listbox = tk.Listbox(LogisticRegression_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=36, height=10)

                        
                        # add vertical scrollbar to list
                        LogisticRegression_IdActualPredicted_Scrollbar_v = tk.Scrollbar(LogisticRegression_IdActualPredicted_Listbox_Frame, orient = "vertical", command = LogisticRegression_IdActualPredicted_Listbox.yview, width=10)
                        LogisticRegression_IdActualPredicted_Listbox.config(yscrollcommand = LogisticRegression_IdActualPredicted_Scrollbar_v.set)
                        LogisticRegression_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        LogisticRegression_IdActualPredicted_Scrollbar_h = tk.Scrollbar(LogisticRegression_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = LogisticRegression_IdActualPredicted_Listbox.xview, width=10)
                        LogisticRegression_IdActualPredicted_Listbox.config(xscrollcommand = LogisticRegression_IdActualPredicted_Scrollbar_h.set)
                        LogisticRegression_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")  
                                    
                        LogisticRegression_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        LogisticRegression_IdActualPredicted_Listbox_Frame.pack(anchor="n")

                        # output id - actual - predicted button
                        ttk.Button(LogisticRegression_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        LogisticRegression_IdActualPredicted_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(LogisticRegression_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        LogisticRegression_TestingResults_Frame = ttk.Frame(LogisticRegression_output_MainFrame,padding=(14, 10, 10, 10))

                        LogisticRegression_TestingResults_Listbox_Frame = ttk.Frame(LogisticRegression_TestingResults_Frame)
                        ttk.Label(LogisticRegression_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            LogisticRegression_TestingResults_Listbox = tk.Listbox(LogisticRegression_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            LogisticRegression_TestingResults_Listbox = tk.Listbox(LogisticRegression_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            LogisticRegression_TestingResults_Listbox = tk.Listbox(LogisticRegression_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=36, height=10)
                        
                        # add vertical scrollbar to list
                        LogisticRegression_TestingResults_Scrollbar_v = tk.Scrollbar(LogisticRegression_TestingResults_Listbox_Frame, orient = "vertical", command = LogisticRegression_TestingResults_Listbox.yview, width=10)
                        LogisticRegression_TestingResults_Listbox.config(yscrollcommand = LogisticRegression_TestingResults_Scrollbar_v.set)
                        LogisticRegression_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        LogisticRegression_TestingResults_Scrollbar_h = tk.Scrollbar(LogisticRegression_TestingResults_Listbox_Frame, orient = "horizontal", command = LogisticRegression_TestingResults_Listbox.xview, width=10)
                        LogisticRegression_TestingResults_Listbox.config(xscrollcommand = LogisticRegression_TestingResults_Scrollbar_h.set)
                        LogisticRegression_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        LogisticRegression_TestingResults_Listbox.pack(expand=True, fill="both")
                        LogisticRegression_TestingResults_Listbox_Frame.pack(anchor="n")

                        # output testing results
                        ttk.Button(LogisticRegression_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        LogisticRegression_TestingResults_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        LogisticRegression_output_MainFrame.pack()

                                        ###################
                                        ###################



                        LogisticRegression_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            LR_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(LR_Spacing_Frame, bg = "white").pack()
                            LR_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            LR_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(LR_Spacing_Frame, bg = "white").pack()
                            LR_Spacing_Frame.pack(pady=10)
                        else:
                            LR_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(LR_Spacing_Frame, bg = "white").pack()
                            LR_Spacing_Frame.pack(pady=10)


                        # destroy these later
                        widgets = widgets[:] + [LogisticRegressionParameters_Frame,
                                                LogisticRegression_ClassifierEvaluation_MainFrame,
                                                LR_Spacing_Frame]

                        for widget in widgets:
                            widget.pack() # pack them afterwards

                    LogisticRegression_MainFunc()

          #########################################################
          #########################################################
          #########################################################





          #########################################################
          #########################################################
          #########################################################

                # Call function PassiveAggressiveClassifier_MainFunc if user select
                # PassiveAggressiveClassifier from classifiers list.
                if classifier_name == '2: PassiveAggressiveClassifier':

                    def PassiveAggressiveClassifier_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################

                        def PassiveAggressiveClassifier_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            PassiveAggressive_TrainTestSplit_vs_KFold_Result = PassiveAggressive_TrainTestSplit_vs_KFold.get()
                            PassiveAggressive_TrainTestSplit_Scale_Result = PassiveAggressive_TrainTestSplit_Scale.get()/100
                            PassiveAggressive_KFold_Result = PassiveAggressive_KFold.get()

                            # get random_state value
                            if PA_random_state_int_or_none.get() == "None":
                                PA_random_state_Result = None
                            else:
                                PA_random_state_Result = PA_random_state.get()

                            PA_loss_Result = PA_loss.get() # get loss value
                            PA_verbose_Result = PA_verbose.get() # get verbose value
                            PA_n_jobs_Result = PA_n_jobs.get() # get n_jobs value
                            PA_C_Result = PA_C.get() # get C value

                            # get max_iter value
                            if PA_max_iter_int_or_none.get() == "None":
                                PA_max_iter_Result = None
                            else:
                                PA_max_iter_Result = PA_max_iter.get()

                            # get tol value
                            if PA_tol_int_or_none.get() == "None":
                                PA_tol_Result = None
                            else:
                                PA_tol_Result = PA_tol.get()

                            PA_fit_intercept_Result = PA_fit_intercept.get() # get fit_intercept value
                            PA_warm_start_Result = PA_warm_start.get() # get warm_start value

                            # get average value
                            if PA_average_Integer_true_false.get() != "Integer":
                                if PA_average_Integer_true_false.get() == "True":
                                    PA_average_Integer_Result = True
                                else:
                                    PA_average_Integer_Result = False
                            else:
                                PA_average_Integer_Result = PA_average_Integer.get()



                            CallClassifier = PassiveAggressiveClassifier(
                                                                C= PA_C_Result,
                                                                fit_intercept= PA_fit_intercept_Result,
                                                                max_iter = PA_max_iter_Result,
                                                                tol= PA_tol_Result,
                                                                shuffle= True,
                                                                verbose = PA_verbose_Result,
                                                                loss = PA_loss_Result,
                                                                n_jobs = PA_n_jobs_Result,
                                                                random_state= PA_random_state_Result,
                                                                warm_start= PA_warm_start_Result,
                                                                average= PA_average_Integer_Result,
                                                                class_weight=None,
                                                                n_iter= None)



                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                        "random_state = " +str(PA_random_state_Result),
                                                        "shuffle = " +str(True),
                                                        "loss = " +str(PA_loss_Result),
                                                        "verbose = " +str(PA_verbose_Result),
                                                        "n_jobs = " +str(PA_n_jobs_Result),
                                                        "C = "+str(PA_C_Result),
                                                        "max_iter = " +str(PA_max_iter_Result),
                                                        "tol = " +str(PA_tol_Result),
                                                        "fit_intercept = " +str(PA_fit_intercept_Result),
                                                        "warm_start = " +str(PA_warm_start_Result),
                                                        "average = " +str(PA_average_Integer_Result),
                                                        "class_weight = " +str(None)+
                                                        "n_iter = " +str(None))



                                    PassiveAggressive_Result.set(Classifier_Pramaters)

                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)

                                    if PassiveAggressive_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = PassiveAggressive_TrainTestSplit_Scale_Result, test_size = 1-PassiveAggressive_TrainTestSplit_Scale_Result, random_state = PA_random_state_Result, shuffle= True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if PassiveAggressive_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = PA_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = PassiveAggressive_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])




              ###########################################

                        # This frame contain all PassiveAggressive classifier
                        # parameters including classifier discription.
                        PassiveAggressiveParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2gNkjTW")

                        SelectedClassifier_and_Link_Frame = tk.Frame(PassiveAggressiveParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"The passive-aggressive algorithms "+
                                       "are a family of algorithms for "+
                                       "large-scale learning. They are similar"+
                                       " to the Perceptron in that they do "+
                                       "not require a learning rate. However, "+
                                       "contrary to the Perceptron, they "+
                                       "include a regularization parameter C.\"")
                        tk.Label(PassiveAggressiveParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=10)

              ###########################################

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        PassiveAggressive_TrainTestSplit_vs_KFold_Frame=tk.Frame(PassiveAggressiveParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        PassiveAggressive_TrainTestSplit_Frame = tk.Frame(PassiveAggressive_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        PassiveAggressive_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(PassiveAggressive_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = PassiveAggressive_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        PassiveAggressive_TrainTestSplit_vs_KFold.set(1)
                        PassiveAggressive_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(PassiveAggressive_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = PassiveAggressive_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        PassiveAggressive_TrainTestSplit_Scale.set(75)
                        PassiveAggressive_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        PassiveAggressive_KFold_frame = tk.Frame(PassiveAggressive_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(PassiveAggressive_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = PassiveAggressive_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        PassiveAggressive_KFold= IntVar()
                        tk.Spinbox(PassiveAggressive_KFold_frame, textvariable = PassiveAggressive_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        PassiveAggressive_KFold.set(10)
                        PassiveAggressive_KFold_frame.pack(side="top",anchor ="w")

                        PassiveAggressive_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                        #######################################################




                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        PA_random_state_int_or_none_frame = tk.Frame(PassiveAggressiveParameters_Frame, bg = "white")

                        tk.Label(PA_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        PA_random_state_int_frame = tk.Frame(PA_random_state_int_or_none_frame, bg = "white")
                        PA_random_state_int_or_none = StringVar()
                        tk.Radiobutton(PA_random_state_int_frame, text="Integer: ", font = FONT_12, variable = PA_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        PA_random_state_int_or_none.set("None")
                        PA_random_state = IntVar()
                        tk.Spinbox(PA_random_state_int_frame, textvariable = PA_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        PA_random_state.set(0)
                        PA_random_state_int_frame.pack(anchor ="n")

                        PA_random_state_none_frame = tk.Frame(PA_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(PA_random_state_none_frame, text="None", font = FONT_12, variable = PA_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(PA_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        PA_random_state_none_frame.pack(side="left",anchor ="s")

                        PA_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)


                                        ###################
                                        ###################

                        # frame contains max_iter, verbose, n_iter, n_jobs and C parameters
                        PA_max_iter_verbose_n_iter_n_jobs_C_Frame = tk.Frame(PassiveAggressiveParameters_Frame, bg = "white")

                        if sys.platform == "linux": 
                            loss="loss:"
                            verbose="verbose:"
                            n_jobs = "n_jobs:  "
                            C="C:            "
                        elif sys.platform == "win64" or sys.platform == "win32":
                            loss="loss:"
                            verbose="verbose:  "
                            n_jobs = "n_jobs:    "
                            C="C:           "

                        else:
                            loss="loss:"
                            verbose="verbose:"
                            n_jobs= "n_jobs:  "
                            C="C:          "
                            
                        # declare loss parameter, str = hinge or squared_hinge, default: hinge
                        PA_loss_Frame = tk.Frame(PA_max_iter_verbose_n_iter_n_jobs_C_Frame, bg = "white")
                        tk.Label(PA_loss_Frame, text=loss, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        PA_loss = StringVar()
                        PA_loss.set("hinge")
                        tk.OptionMenu(PA_loss_Frame, PA_loss, "hinge", "squared_hinge").pack(side="right",anchor ="c")
                        PA_loss_Frame.pack(side="top", anchor ="w")


                        # declare verbose parameter
                        PA_verbose_Frame = tk.Frame(PA_max_iter_verbose_n_iter_n_jobs_C_Frame, bg = "white")
                        tk.Label(PA_verbose_Frame, text=verbose, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        PA_verbose = IntVar()
                        tk.Spinbox(PA_verbose_Frame, textvariable = PA_verbose, from_=0, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        PA_verbose.set(0)
                        PA_verbose_Frame.pack(side="top", anchor ="w")


                        # declare n_jobs parameter
                        PA_n_jobs_Frame = tk.Frame(PA_max_iter_verbose_n_iter_n_jobs_C_Frame, bg = "white")
                        tk.Label(PA_n_jobs_Frame, text=n_jobs, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        PA_n_jobs = IntVar()
                        tk.Spinbox(PA_n_jobs_Frame, textvariable = PA_n_jobs, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        PA_n_jobs.set(1)
                        PA_n_jobs_Frame.pack(side="top", anchor ="w")


                        # declare C parameter
                        PA_C_Frame = tk.Frame(PA_max_iter_verbose_n_iter_n_jobs_C_Frame, bg = "white")
                        tk.Label(PA_C_Frame, text=C, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        PA_C = DoubleVar()
                        tk.Spinbox(PA_C_Frame, textvariable = PA_C, from_=1, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        PA_C.set(1)
                        PA_C_Frame.pack(side="top",anchor ="w")

                        PA_max_iter_verbose_n_iter_n_jobs_C_Frame.pack(side= "left", anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare max_iter parameter, int or None, optional (default=None)
                        PA_max_iter_int_or_none_frame = tk.Frame(PassiveAggressiveParameters_Frame, bg = "white")

                        tk.Label(PA_max_iter_int_or_none_frame, text="max_iter:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        PA_max_iter_int_frame = tk.Frame(PA_max_iter_int_or_none_frame, bg = "white")
                        PA_max_iter_int_or_none = StringVar()
                        tk.Radiobutton(PA_max_iter_int_frame, text="Integer:", font = FONT_12, variable = PA_max_iter_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        PA_max_iter_int_or_none.set("Integer")
                        PA_max_iter = IntVar()
                        tk.Spinbox(PA_max_iter_int_frame, textvariable = PA_max_iter, from_=1, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        PA_max_iter.set(1000)
                        PA_max_iter_int_frame.pack(anchor ="n")

                        PA_max_iter_none_frame = tk.Frame(PA_max_iter_int_or_none_frame, bg = "white")
                        tk.Radiobutton(PA_max_iter_none_frame, text="None", font = FONT_12, variable = PA_max_iter_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(PA_max_iter_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        PA_max_iter_none_frame.pack(side="left",anchor ="s")

                        PA_max_iter_int_or_none_frame.pack(side= "left", anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare tol parameter, int or None, optional (default=None)
                        PA_tol_int_or_none_frame = tk.Frame(PassiveAggressiveParameters_Frame, bg = "white")

                        tk.Label(PA_tol_int_or_none_frame, text="tol:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        PA_tol_int_frame = tk.Frame(PA_tol_int_or_none_frame, bg = "white")
                        PA_tol_int_or_none = StringVar()
                        tk.Radiobutton(PA_tol_int_frame, text="float:", font = FONT_12, variable = PA_tol_int_or_none, value = "float", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        PA_tol_int_or_none.set("float")
                        PA_tol = DoubleVar()
                        tk.Spinbox(PA_tol_int_frame, textvariable = PA_tol, increment = 0.001, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        PA_tol.set("{:.1E}".format(Decimal(0.001)))
                        PA_tol_int_frame.pack(anchor ="n")

                        PA_tol_none_frame = tk.Frame(PA_tol_int_or_none_frame, bg = "white")
                        tk.Radiobutton(PA_tol_none_frame, text="None", font = FONT_12, variable = PA_tol_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(PA_tol_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        PA_tol_none_frame.pack(side="left",anchor ="s")

                        PA_tol_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)


                                        ###################
                                        ###################

                        # declare fit_intercept parameter, bool = default: True
                        PA_fit_intercept_Frame = tk.Frame(PassiveAggressiveParameters_Frame, bg = "white")
                        tk.Label(PA_fit_intercept_Frame, text="fit_intercept:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        PA_fit_intercept = BooleanVar()
                        tk.Radiobutton(PA_fit_intercept_Frame, text= "True", variable = PA_fit_intercept, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(PA_fit_intercept_Frame, text= "False", variable = PA_fit_intercept, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        PA_fit_intercept.set(True)
                        PA_fit_intercept_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare warm_start parameter, bool = default: False
                        PA_warm_start_Frame = tk.Frame(PassiveAggressiveParameters_Frame, bg = "white")
                        tk.Label(PA_warm_start_Frame, text="warm_start:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        PA_warm_start = BooleanVar()
                        tk.Radiobutton(PA_warm_start_Frame, text= "True", variable = PA_warm_start, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(PA_warm_start_Frame, text= "False", variable = PA_warm_start, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        PA_warm_start.set(False)
                        PA_warm_start_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare average parameter, bool or int
                        PA_average_MainFrame = tk.Frame(PassiveAggressiveParameters_Frame, bg = "white")

                        tk.Label(PA_average_MainFrame, text="average:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        PA_average_string_frame = tk.Frame(PA_average_MainFrame, bg = "white")
                        PA_average_Integer_true_false = StringVar()
                        tk.Radiobutton(PA_average_string_frame, text="Integer: ", font = FONT_12, variable = PA_average_Integer_true_false, value = "Integer",justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="w" )
                        PA_average_Integer_true_false.set("False")
                        PA_average_Integer= IntVar()
                        tk.Spinbox(PA_average_string_frame, textvariable = PA_average_Integer, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side = "right",anchor ="c")
                        PA_average_Integer.set(1)
                        PA_average_string_frame.pack(side="top",anchor ="w")

                        PA_average_ture_false_Frame = tk.Frame(PA_average_MainFrame, bg = "white")
                        tk.Radiobutton(PA_average_ture_false_Frame, text="True    ", font = FONT_12, variable = PA_average_Integer_true_false, value = "True",justify='left', bg = "white", highlightthickness=0).pack(anchor ="w" )
                        tk.Radiobutton(PA_average_ture_false_Frame, text="False", font = FONT_12, variable = PA_average_Integer_true_false, value = "False",justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        PA_average_ture_false_Frame.pack(side="top",anchor ="w")


                        PA_average_MainFrame.pack(side= "left", anchor ="n", padx =10)
                                        ##################
                                        ##################


                        PassiveAggressiveParameters_Frame.pack(anchor ="c")


              ###########################################
                        # declare LinearRegression classifier Result
                        PassiveAggressive_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(PassiveAggressive_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = PassiveAggressiveClassifier_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(PassiveAggressive_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = PassiveAggressiveClassifier_SubFunc).pack(anchor="c", pady=20)
                        else:
                            ttk.Button(PassiveAggressive_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = PassiveAggressiveClassifier_SubFunc).pack(anchor="c", pady=15)
        

                        PassiveAggressiveSelectedParameters_Frame = tk.Frame(PassiveAggressive_ClassifierEvaluation_MainFrame, bg = "white")
                        PassiveAggressive_Result = StringVar()
                        tk.Label(PassiveAggressiveSelectedParameters_Frame, textvariable = PassiveAggressive_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        PassiveAggressive_Result.set("")
                        PassiveAggressiveSelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################

                        PassiveAggressive_output_MainFrame = ttk.Frame(PassiveAggressive_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################

                        # confusion matrix, model accuracy & error
                        PassiveAggressive_ModelEvaluationStatistics_Frame = ttk.Frame(PassiveAggressive_output_MainFrame,padding=(10, 10, 10, 10))

                        PassiveAggressive_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(PassiveAggressive_ModelEvaluationStatistics_Frame)
                        ttk.Label(PassiveAggressive_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            PassiveAggressive_ModelEvaluationStatistics_Listbox = tk.Listbox(PassiveAggressive_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            PassiveAggressive_ModelEvaluationStatistics_Listbox = tk.Listbox(PassiveAggressive_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            PassiveAggressive_ModelEvaluationStatistics_Listbox = tk.Listbox(PassiveAggressive_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        


                        # add vertical scrollbar to list
                        PassiveAggressive_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(PassiveAggressive_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = PassiveAggressive_ModelEvaluationStatistics_Listbox.yview, width=10)
                        PassiveAggressive_ModelEvaluationStatistics_Listbox.config(yscrollcommand = PassiveAggressive_ModelEvaluationStatistics_Scrollbar_v.set)
                        PassiveAggressive_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        PassiveAggressive_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(PassiveAggressive_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = PassiveAggressive_ModelEvaluationStatistics_Listbox.xview, width=10)
                        PassiveAggressive_ModelEvaluationStatistics_Listbox.config(xscrollcommand = PassiveAggressive_ModelEvaluationStatistics_Scrollbar_h.set)
                        PassiveAggressive_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        PassiveAggressive_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        PassiveAggressive_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")
                        

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(PassiveAggressive_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        PassiveAggressive_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(PassiveAggressive_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        PassiveAggressive_IdActualPredicted_Frame = ttk.Frame(PassiveAggressive_output_MainFrame,padding=(14, 10, 10, 10))

                        PassiveAggressive_IdActualPredicted_Listbox_Frame = ttk.Frame(PassiveAggressive_IdActualPredicted_Frame)
                        ttk.Label(PassiveAggressive_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            PassiveAggressive_IdActualPredicted_Listbox = tk.Listbox(PassiveAggressive_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            PassiveAggressive_IdActualPredicted_Listbox = tk.Listbox(PassiveAggressive_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            PassiveAggressive_IdActualPredicted_Listbox = tk.Listbox(PassiveAggressive_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result , width=36, height=10)
                        
                        
                        # add vertical scrollbar to list
                        PassiveAggressive_IdActualPredicted_Scrollbar_v = tk.Scrollbar(PassiveAggressive_IdActualPredicted_Listbox_Frame, orient = "vertical", command = PassiveAggressive_IdActualPredicted_Listbox.yview, width=10)
                        PassiveAggressive_IdActualPredicted_Listbox.config(yscrollcommand = PassiveAggressive_IdActualPredicted_Scrollbar_v.set)
                        PassiveAggressive_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        PassiveAggressive_IdActualPredicted_Scrollbar_h = tk.Scrollbar(PassiveAggressive_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = PassiveAggressive_IdActualPredicted_Listbox.xview, width=10)
                        PassiveAggressive_IdActualPredicted_Listbox.config(xscrollcommand = PassiveAggressive_IdActualPredicted_Scrollbar_h.set)
                        PassiveAggressive_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        PassiveAggressive_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        PassiveAggressive_IdActualPredicted_Listbox_Frame.pack(anchor="n")     
                        

                        # output id - actual - predicted button
                        ttk.Button(PassiveAggressive_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult ).pack(side= "bottom",anchor="e")

                        PassiveAggressive_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(PassiveAggressive_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        PassiveAggressive_TestingResults_Frame = ttk.Frame(PassiveAggressive_output_MainFrame,padding=(14, 10, 10, 10))

                        PassiveAggressive_TestingResults_Listbox_Frame = ttk.Frame(PassiveAggressive_TestingResults_Frame)
                        ttk.Label(PassiveAggressive_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            PassiveAggressive_TestingResults_Listbox = tk.Listbox(PassiveAggressive_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            PassiveAggressive_TestingResults_Listbox = tk.Listbox(PassiveAggressive_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            PassiveAggressive_TestingResults_Listbox = tk.Listbox(PassiveAggressive_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)


                        # add vertical scrollbar to list
                        PassiveAggressive_TestingResults_Scrollbar_v = tk.Scrollbar(PassiveAggressive_TestingResults_Listbox_Frame, orient = "vertical", command = PassiveAggressive_TestingResults_Listbox.yview, width=10)
                        PassiveAggressive_TestingResults_Listbox.config(yscrollcommand = PassiveAggressive_TestingResults_Scrollbar_v.set)
                        PassiveAggressive_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        PassiveAggressive_TestingResults_Scrollbar_h = tk.Scrollbar(PassiveAggressive_TestingResults_Listbox_Frame, orient = "horizontal", command = PassiveAggressive_TestingResults_Listbox.xview, width=10)
                        PassiveAggressive_TestingResults_Listbox.config(xscrollcommand = PassiveAggressive_TestingResults_Scrollbar_h.set)
                        PassiveAggressive_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")       

                        PassiveAggressive_TestingResults_Listbox.pack(expand=True, fill="both")
                        PassiveAggressive_TestingResults_Listbox_Frame.pack(anchor="n") 
                        

                        # output testing results
                        ttk.Button(PassiveAggressive_TestingResults_Frame,text= "Export Testing",command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        PassiveAggressive_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        PassiveAggressive_output_MainFrame.pack()

                                        ###################
                                        ###################


                        PassiveAggressive_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            PassiveAggressive_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(PassiveAggressive_Spacing_Frame, bg = "white").pack()
                            PassiveAggressive_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            PassiveAggressive_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(PassiveAggressive_Spacing_Frame, bg = "white").pack()
                            PassiveAggressive_Spacing_Frame.pack(pady=9)
                        else:
                            PassiveAggressive_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(PassiveAggressive_Spacing_Frame, bg = "white").pack()
                            PassiveAggressive_Spacing_Frame.pack(pady=9)




                        # destroy these later
                        widgets = widgets[:] + [PassiveAggressiveParameters_Frame,
                                                PassiveAggressive_ClassifierEvaluation_MainFrame,
                                                PassiveAggressive_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    PassiveAggressiveClassifier_MainFunc()
          #########################################################
          #########################################################
          #########################################################




          #########################################################
          #########################################################
          #########################################################
                # Call function Perceptron_MainFunc if user select Perceptron
                # from classifiers list.
                if classifier_name == '3: Perceptron':

                    def Perceptron_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)


                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")

              ###########################################

                        def Perceptron_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            Perceptron_TrainTestSplit_vs_KFold_Result = Perceptron_TrainTestSplit_vs_KFold.get()
                            Perceptron_TrainTestSplit_Scale_Result = Perceptron_TrainTestSplit_Scale.get()/100
                            Perceptron_KFold_Result = Perceptron_KFold.get()

                            # get random_state value
                            if Perceptron_random_state_int_or_none.get() == "None":
                                Perceptron_random_state_Result = None
                            else:
                                Perceptron_random_state_Result = Perceptron_random_state.get()

                            Perceptron_penalty_Result = Perceptron_penalty.get() # get penalty value
                            Perceptron_verbose_Result = Perceptron_verbose.get() # get verbose value
                            Perceptron_n_jobs_Result = Perceptron_n_jobs.get() # get n_jobs value
                            Perceptron_alpha_Result = Perceptron_alpha.get() # get fit_intercept value
                            Perceptron_eta0_Result = Perceptron_eta0.get() # get eta0 value

                            # get max_iter value
                            if Perceptron_max_iter_int_or_none.get() == "None":
                                Perceptron_max_iter_Result = None
                            else:
                                Perceptron_max_iter_Result = Perceptron_max_iter.get()


                            # get tol value
                            if Perceptron_tol_int_or_none.get() == "None":
                                Perceptron_tol_Result = None
                            else:
                                Perceptron_tol_Result = Perceptron_tol.get()

                            Perceptron_fit_intercept_Result = Perceptron_fit_intercept.get() # get max_iter value
                            Perceptron_warm_start_Result = Perceptron_warm_start.get() # get warm_start value


                            CallClassifier =  Perceptron(
                                                        penalty = Perceptron_penalty_Result,
                                                        alpha = Perceptron_alpha_Result,
                                                        fit_intercept = Perceptron_fit_intercept_Result,
                                                        max_iter = Perceptron_max_iter_Result,
                                                        tol = Perceptron_tol_Result,
                                                        shuffle = True,
                                                        verbose = Perceptron_verbose_Result,
                                                        eta0 = Perceptron_eta0_Result,
                                                        n_jobs = Perceptron_n_jobs_Result,
                                                        random_state = Perceptron_random_state_Result,
                                                        class_weight = None,
                                                        warm_start = Perceptron_warm_start_Result)



                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)


                                        ####################################


                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                                "random_state = " +str(Perceptron_random_state_Result),
                                                                "shuffle = " +str(True),
                                                                "penalty = "+str(Perceptron_penalty_Result),
                                                                "verbose = " +str(Perceptron_verbose_Result),
                                                                "n_jobs = " +str(Perceptron_n_jobs_Result),
                                                                "alpha = " +str(Perceptron_alpha_Result),
                                                                "eta0 = " +str(Perceptron_eta0_Result),
                                                                "max_iter = " +str(Perceptron_max_iter_Result),
                                                                "tol = " +str(Perceptron_tol_Result),
                                                                "fit_intercept = " +str(Perceptron_fit_intercept_Result),
                                                                "warm_start = " +str(Perceptron_warm_start_Result),
                                                                "class_weight = " +str(None))


                                    Perceptron_Result.set(Classifier_Pramaters)

                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)

                                    if Perceptron_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = Perceptron_TrainTestSplit_Scale_Result, test_size = 1-Perceptron_TrainTestSplit_Scale_Result, random_state = Perceptron_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if Perceptron_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = Perceptron_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = Perceptron_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################
                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])






              ###########################################

                        # This frame contain all Perceptron classifier
                        # parameters including classifier discription.
                        PerceptronParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2gImp3R")

                        SelectedClassifier_and_Link_Frame = tk.Frame(PerceptronParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"The Perceptron is a simple "+
                                       "algorithm suitable for large scale "+
                                       "learning. It does not require a "+
                                       "learning rate, is not regularized "+
                                       "(penalized) and it updates its model "+
                                       "only on mistakes.\"")
                        tk.Label(PerceptronParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=10)
                                        ###################
                                        ###################

                        # add space on the left
                        tk.Label(PerceptronParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =20)
              ###########################################

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        Perceptron_TrainTestSplit_vs_KFold_Frame=tk.Frame(PerceptronParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        Perceptron_TrainTestSplit_Frame = tk.Frame(Perceptron_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        Perceptron_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(Perceptron_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = Perceptron_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Perceptron_TrainTestSplit_vs_KFold.set(1)
                        Perceptron_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(Perceptron_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = Perceptron_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        Perceptron_TrainTestSplit_Scale.set(75)
                        Perceptron_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        Perceptron_KFold_frame = tk.Frame(Perceptron_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(Perceptron_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = Perceptron_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Perceptron_KFold= IntVar()
                        tk.Spinbox(Perceptron_KFold_frame, textvariable = Perceptron_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Perceptron_KFold.set(10)
                        Perceptron_KFold_frame.pack(side="top",anchor ="w")

                        Perceptron_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                                        ###################
                                        ###################
                        # frame that contains all other parameters starts here.
                        #######################################################


                        # declare random_state parameter, int or None, optional (default=None)
                        Perceptron_random_state_int_or_none_frame = tk.Frame(PerceptronParameters_Frame, bg = "white")

                        tk.Label(Perceptron_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        Perceptron_random_state_int_frame = tk.Frame(Perceptron_random_state_int_or_none_frame, bg = "white")
                        Perceptron_random_state_int_or_none = StringVar()
                        tk.Radiobutton(Perceptron_random_state_int_frame, text="Integer: ", font = FONT_12, variable = Perceptron_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Perceptron_random_state_int_or_none.set("Integer")
                        Perceptron_random_state = IntVar()
                        tk.Spinbox(Perceptron_random_state_int_frame, textvariable = Perceptron_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Perceptron_random_state.set(0)
                        Perceptron_random_state_int_frame.pack(anchor ="n")

                        Perceptron_random_state_none_frame = tk.Frame(Perceptron_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(Perceptron_random_state_none_frame, text="None", font = FONT_12, variable = Perceptron_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(Perceptron_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        Perceptron_random_state_none_frame.pack(side="left",anchor ="s")

                        Perceptron_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare penalty parameter
                        Perceptron_penalty_Frame = tk.Frame(PerceptronParameters_Frame, bg = "white")
                        tk.Label(Perceptron_penalty_Frame, text="penalty:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Perceptron_penalty = StringVar()
                        Perceptron_penalty.set("None")
                        tk.OptionMenu(Perceptron_penalty_Frame, Perceptron_penalty,  "elasticnet", "None", "l2", "l1", ).pack(side="right",anchor ="c")
                        Perceptron_penalty_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################

                        Perceptron_verbose_n_jobs_alpha_eta0_Frame = tk.Frame(PerceptronParameters_Frame, bg = "white")

                        if sys.platform == "linux": 
                            verbose="verbose:"
                            n_jobs = "n_jobs:   "
                            alpha="alpha:     "
                            eta0="eta0:       "
                        elif sys.platform == "win64" or sys.platform == "win32":
                            verbose="verbose:"
                            n_jobs = "n_jobs:  "
                            alpha="alpha:    "
                            eta0="eta0:     "
                        else:
                            verbose="verbose:"
                            n_jobs= "n_jobs:  "
                            alpha="alpha:    "
                            eta0="eta0:      "

                        # declare verbose parameter
                        Perceptron_verbose_Frame = tk.Frame(Perceptron_verbose_n_jobs_alpha_eta0_Frame, bg = "white")
                        tk.Label(Perceptron_verbose_Frame, text=verbose, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        Perceptron_verbose = IntVar()
                        tk.Spinbox(Perceptron_verbose_Frame, textvariable = Perceptron_verbose, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        Perceptron_verbose.set(0)
                        Perceptron_verbose_Frame.pack(side="top", anchor ="w")
                                        ###################
                                        ###################

                        # declare n_jobs parameter
                        Perceptron_n_jobs_Frame = tk.Frame(Perceptron_verbose_n_jobs_alpha_eta0_Frame, bg = "white")
                        tk.Label(Perceptron_n_jobs_Frame, text=n_jobs, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        Perceptron_n_jobs = IntVar()
                        tk.Spinbox(Perceptron_n_jobs_Frame, textvariable = Perceptron_n_jobs, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        Perceptron_n_jobs.set(1)
                        Perceptron_n_jobs_Frame.pack(side="top",anchor ="w")

                                        ###################
                                        ###################

                        # declare alpha parameter
                        Perceptron_alpha_Frame = tk.Frame(Perceptron_verbose_n_jobs_alpha_eta0_Frame, bg = "white")
                        tk.Label(Perceptron_alpha_Frame, text=alpha, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        Perceptron_alpha = DoubleVar()
                        tk.Spinbox(Perceptron_alpha_Frame, textvariable = Perceptron_alpha, increment = 0.0001, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        Perceptron_alpha.set("{:.1E}".format(Decimal(0.0001)))
                        Perceptron_alpha_Frame.pack(side= "top", anchor ="w")

                                        ###################
                                        ###################

                        # declare eta0 parameter
                        Perceptron_eta0_Frame = tk.Frame(Perceptron_verbose_n_jobs_alpha_eta0_Frame, bg = "white")
                        tk.Label(Perceptron_eta0_Frame, text=eta0, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        Perceptron_eta0 = DoubleVar()
                        tk.Spinbox(Perceptron_eta0_Frame, textvariable = Perceptron_eta0, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        Perceptron_eta0.set(1)
                        Perceptron_eta0_Frame.pack(side= "top", anchor ="w")

                        Perceptron_verbose_n_jobs_alpha_eta0_Frame.pack(side= "left", anchor ="n", padx =10)


                                        ###################
                                        ###################


                        # declare max_iter parameter, int or None, optional (default=None)
                        Perceptron_max_iter_int_or_none_frame = tk.Frame(PerceptronParameters_Frame, bg = "white")

                        tk.Label(Perceptron_max_iter_int_or_none_frame, text="max_iter:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        Perceptron_max_iter_int_frame = tk.Frame(Perceptron_max_iter_int_or_none_frame, bg = "white")
                        Perceptron_max_iter_int_or_none = StringVar()
                        tk.Radiobutton(Perceptron_max_iter_int_frame, text="Integer:", font = FONT_12, variable = Perceptron_max_iter_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Perceptron_max_iter_int_or_none.set("Integer")
                        Perceptron_max_iter = IntVar()
                        tk.Spinbox(Perceptron_max_iter_int_frame, textvariable = Perceptron_max_iter, from_=1, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Perceptron_max_iter.set(5)
                        Perceptron_max_iter_int_frame.pack(anchor ="n")

                        Perceptron_max_iter_none_frame = tk.Frame(Perceptron_max_iter_int_or_none_frame, bg = "white")
                        tk.Radiobutton(Perceptron_max_iter_none_frame, text="None", font = FONT_12, variable = Perceptron_max_iter_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(Perceptron_max_iter_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        Perceptron_max_iter_none_frame.pack(side="left",anchor ="s")

                        Perceptron_max_iter_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)


                                        ###################
                                        ###################

                        Perceptron_tol_fit_intercept_MainFrame = tk.Frame(PerceptronParameters_Frame, bg = "white")

                        # declare tol parameter, int or None, optional (default=None)
                        Perceptron_tol_int_or_none_frame = tk.Frame(Perceptron_tol_fit_intercept_MainFrame, bg = "white")

                        tk.Label(Perceptron_tol_int_or_none_frame, text="tol:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        Perceptron_tol_int_frame = tk.Frame(Perceptron_tol_int_or_none_frame, bg = "white")
                        Perceptron_tol_int_or_none = StringVar()
                        tk.Radiobutton(Perceptron_tol_int_frame, text="float:", font = FONT_12, variable = Perceptron_tol_int_or_none, value = "float", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Perceptron_tol_int_or_none.set("None")
                        Perceptron_tol = DoubleVar()
                        tk.Spinbox(Perceptron_tol_int_frame, textvariable = Perceptron_tol, increment = 0.001, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Perceptron_tol.set("{:.1E}".format(Decimal(0.001)))
                        Perceptron_tol_int_frame.pack(anchor ="n")

                        Perceptron_tol_none_frame = tk.Frame(Perceptron_tol_int_or_none_frame, bg = "white")
                        tk.Radiobutton(Perceptron_tol_none_frame, text="None", font = FONT_12, variable = Perceptron_tol_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(Perceptron_tol_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        Perceptron_tol_none_frame.pack(side="left",anchor ="s")

                        Perceptron_tol_int_or_none_frame.pack(side= "top", anchor ="w")

                                        ###################
                                        ###################

                        # declare fit_intercept parameter, bool = default: True
                        Perceptron_fit_intercept_Frame = tk.Frame(PerceptronParameters_Frame, bg = "white")
                        tk.Label(Perceptron_fit_intercept_Frame, text="fit_intercept:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Perceptron_fit_intercept = BooleanVar()
                        tk.Radiobutton(Perceptron_fit_intercept_Frame, text= "True", variable = Perceptron_fit_intercept, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(Perceptron_fit_intercept_Frame, text= "False", variable = Perceptron_fit_intercept, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        Perceptron_fit_intercept.set(True)
                        Perceptron_fit_intercept_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################



                        # declare warm_start parameter, bool = default: True
                        Perceptron_warm_start_Frame = tk.Frame(PerceptronParameters_Frame, bg = "white")
                        tk.Label(Perceptron_warm_start_Frame, text="warm_start:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Perceptron_warm_start = BooleanVar()
                        tk.Radiobutton(Perceptron_warm_start_Frame, text= "True", variable = Perceptron_warm_start, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(Perceptron_warm_start_Frame, text= "False", variable = Perceptron_warm_start, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        Perceptron_warm_start.set(False)
                        Perceptron_warm_start_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        PerceptronParameters_Frame.pack(anchor ="c")


              ###########################################
                        # declare Perceptron classifier Result
                        Perceptron_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(Perceptron_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Perceptron_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(Perceptron_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Perceptron_SubFunc).pack(anchor="c", pady=25)
                        else:
                            ttk.Button(Perceptron_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Perceptron_SubFunc).pack(anchor="c", pady=12)
        
                        PerceptronSelectedParameters_Frame = tk.Frame(Perceptron_ClassifierEvaluation_MainFrame, bg = "white")
                        Perceptron_Result = StringVar()
                        tk.Label(PerceptronSelectedParameters_Frame, textvariable = Perceptron_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        Perceptron_Result.set("")
                        PerceptronSelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################

                        Perceptron_output_MainFrame = ttk.Frame(Perceptron_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        Perceptron_ModelEvaluationStatistics_Frame = ttk.Frame(Perceptron_output_MainFrame,padding=(10, 10, 10, 10))

                        Perceptron_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(Perceptron_ModelEvaluationStatistics_Frame)
                        ttk.Label(Perceptron_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")

                        if sys.platform == "linux": 
                            Perceptron_ModelEvaluationStatistics_Listbox = tk.Listbox(Perceptron_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Perceptron_ModelEvaluationStatistics_Listbox = tk.Listbox(Perceptron_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            Perceptron_ModelEvaluationStatistics_Listbox = tk.Listbox(Perceptron_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        Perceptron_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(Perceptron_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = Perceptron_ModelEvaluationStatistics_Listbox.yview, width=10)
                        Perceptron_ModelEvaluationStatistics_Listbox.config(yscrollcommand = Perceptron_ModelEvaluationStatistics_Scrollbar_v.set)
                        Perceptron_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Perceptron_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(Perceptron_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = Perceptron_ModelEvaluationStatistics_Listbox.xview, width=10)
                        Perceptron_ModelEvaluationStatistics_Listbox.config(xscrollcommand = Perceptron_ModelEvaluationStatistics_Scrollbar_h.set)
                        Perceptron_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        Perceptron_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        Perceptron_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(Perceptron_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        Perceptron_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(Perceptron_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        Perceptron_IdActualPredicted_Frame = ttk.Frame(Perceptron_output_MainFrame,padding=(14, 10, 10, 10))

                        Perceptron_IdActualPredicted_Listbox_Frame = ttk.Frame(Perceptron_IdActualPredicted_Frame)
                        ttk.Label(Perceptron_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            Perceptron_IdActualPredicted_Listbox = tk.Listbox(Perceptron_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Perceptron_IdActualPredicted_Listbox = tk.Listbox(Perceptron_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            Perceptron_IdActualPredicted_Listbox = tk.Listbox(Perceptron_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                        
                        # add vertical scrollbar to list
                        Perceptron_IdActualPredicted_Scrollbar_v = tk.Scrollbar(Perceptron_IdActualPredicted_Listbox_Frame, orient = "vertical", command = Perceptron_IdActualPredicted_Listbox.yview, width=10)
                        Perceptron_IdActualPredicted_Listbox.config(yscrollcommand = Perceptron_IdActualPredicted_Scrollbar_v.set)
                        Perceptron_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Perceptron_IdActualPredicted_Scrollbar_h = tk.Scrollbar(Perceptron_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = Perceptron_IdActualPredicted_Listbox.xview, width=10)
                        Perceptron_IdActualPredicted_Listbox.config(xscrollcommand = Perceptron_IdActualPredicted_Scrollbar_h.set)
                        Perceptron_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        Perceptron_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        Perceptron_IdActualPredicted_Listbox_Frame.pack(anchor="n")                        

                        # output id - actual - predicted button
                        ttk.Button(Perceptron_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        Perceptron_IdActualPredicted_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(Perceptron_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        Perceptron_TestingResults_Frame = ttk.Frame(Perceptron_output_MainFrame,padding=(14, 10, 10, 10))

                        Perceptron_TestingResults_Listbox_Frame = ttk.Frame(Perceptron_TestingResults_Frame)
                        ttk.Label(Perceptron_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            Perceptron_TestingResults_Listbox = tk.Listbox(Perceptron_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Perceptron_TestingResults_Listbox = tk.Listbox(Perceptron_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            Perceptron_TestingResults_Listbox = tk.Listbox(Perceptron_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=36, height=10)
                            
                        # add vertical scrollbar to list
                        Perceptron_TestingResults_Scrollbar_v = tk.Scrollbar(Perceptron_TestingResults_Listbox_Frame, orient = "vertical", command = Perceptron_TestingResults_Listbox.yview, width=10)
                        Perceptron_TestingResults_Listbox.config(yscrollcommand = Perceptron_TestingResults_Scrollbar_v.set)
                        Perceptron_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Perceptron_TestingResults_Scrollbar_h = tk.Scrollbar(Perceptron_TestingResults_Listbox_Frame, orient = "horizontal", command = Perceptron_TestingResults_Listbox.xview, width=10)
                        Perceptron_TestingResults_Listbox.config(xscrollcommand = Perceptron_TestingResults_Scrollbar_h.set)
                        Perceptron_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")       

                        Perceptron_TestingResults_Listbox.pack(expand=True, fill="both")
                        Perceptron_TestingResults_Listbox_Frame.pack(anchor="n")  

                        # output testing results
                        ttk.Button(Perceptron_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        Perceptron_TestingResults_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        Perceptron_output_MainFrame.pack()

                                        ###################
                                        ###################


                        Perceptron_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            Perceptron_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Perceptron_Spacing_Frame, bg = "white").pack()
                            Perceptron_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Perceptron_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Perceptron_Spacing_Frame, bg = "white").pack()
                            Perceptron_Spacing_Frame.pack(pady=15)
                        else:
                            Perceptron_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Perceptron_Spacing_Frame, bg = "white").pack()
                            Perceptron_Spacing_Frame.pack(pady=11)


                        # destroy these later
                        widgets = widgets[:] + [PerceptronParameters_Frame,
                                                Perceptron_ClassifierEvaluation_MainFrame,
                                                Perceptron_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    Perceptron_MainFunc()
          #########################################################
          #########################################################
          #########################################################




          #########################################################
          #########################################################
          #########################################################
                # Call function Ridge_MainFunc if user select Ridge Regression
                # from classifiers list.
                if classifier_name == '4: RidgeClassifier':

                    def Ridge_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def Ridge_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            Ridge_TrainTestSplit_vs_KFold_Result = Ridge_TrainTestSplit_vs_KFold.get()
                            Ridge_TrainTestSplit_Scale_Result = Ridge_TrainTestSplit_Scale.get()/100
                            Ridge_KFold_Result = Ridge_KFold.get()

                            # get random_state value
                            if Ridge_random_state_int_or_none.get() == "None":
                                Ridge_random_state_Result = None
                            else:
                                Ridge_random_state_Result = Ridge_random_state.get()

                            Ridge_solver_Result = Ridge_solver.get() # get solver value
                            Ridge_alpha_Result = Ridge_alpha.get() # get alpha value
                            Ridge_tol_Result = Ridge_tol.get() # get tol value

                            # get max_iter value
                            if Ridge_max_iter_int_or_none.get() == "None":
                                Ridge_max_iter_Result = None
                            else:
                                Ridge_max_iter_Result = Ridge_max_iter.get()


                            Ridge_fit_intercept_Result = Ridge_fit_intercept.get() # get fit_intercept value
                            Ridge_normalize_Result = Ridge_normalize.get() # get normalize value
                            Ridge_copy_X_Result = Ridge_copy_X.get() # get copy_X value



                            CallClassifier = RidgeClassifier(alpha = Ridge_alpha_Result,
                                                            fit_intercept = Ridge_fit_intercept_Result,
                                                            normalize = Ridge_normalize_Result,
                                                            copy_X = Ridge_copy_X_Result,
                                                            max_iter = Ridge_max_iter_Result,
                                                            tol= Ridge_tol_Result,
                                                            class_weight=None,
                                                            solver = Ridge_solver_Result,
                                                            random_state= Ridge_random_state_Result)


                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)


                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)


                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                        "random_state = " +str(Ridge_random_state_Result),
                                                        "shuffle = " +str(True),
                                                        "solver = " +str(Ridge_solver_Result),
                                                        "alpha = "+str(Ridge_alpha_Result),
                                                        "tol = " +str(Ridge_tol_Result),
                                                        "max_iter = " +str(Ridge_max_iter_Result),
                                                        "fit_intercept = " +str(Ridge_fit_intercept_Result),
                                                        "normalize = " +str(Ridge_normalize_Result),
                                                        "copy_X = " +str(Ridge_copy_X_Result))

                                    Ridge_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if Ridge_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = Ridge_TrainTestSplit_Scale_Result, test_size = 1-Ridge_TrainTestSplit_Scale_Result, random_state = Ridge_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if Ridge_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = Ridge_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = Ridge_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################
                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])


              ###########################################

                        # This frame contain Ridge classifier parameters including
                        # classifier discription.
                        RidgeParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2zTfaOQ")

                        SelectedClassifier_and_Link_Frame = tk.Frame(RidgeParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"RidgeClassifier is using Ridge "+
                                       "regression. Ridge regression addresses "+
                                       "some of the problems of Ordinary Least "+
                                       "Squares by imposing a penalty on the "+
                                       "size of coefficients. The ridge "+
                                       "coefficients minimize a penalized "+
                                       "residual sum of squares.\"")
                        tk.Label(RidgeParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=10)
                                        ###################
                                        ###################

                        # add space on the left
                        tk.Label(RidgeParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =7)
              ###########################################

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        Ridge_TrainTestSplit_vs_KFold_Frame=tk.Frame(RidgeParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        Ridge_TrainTestSplit_Frame = tk.Frame(Ridge_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        Ridge_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(Ridge_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = Ridge_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Ridge_TrainTestSplit_vs_KFold.set(1)
                        Ridge_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(Ridge_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = Ridge_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        Ridge_TrainTestSplit_Scale.set(75)
                        Ridge_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        Ridge_KFold_frame = tk.Frame(Ridge_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(Ridge_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = Ridge_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Ridge_KFold= IntVar()
                        tk.Spinbox(Ridge_KFold_frame, textvariable = Ridge_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Ridge_KFold.set(10)
                        Ridge_KFold_frame.pack(side="top",anchor ="w")

                        Ridge_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                                        ###################
                                        ###################

                        # frame that contains all other parameters starts here.
                        #######################################################


                        # declare random_state parameter, int or None, optional (default=None)
                        Ridge_random_state_int_or_none_frame = tk.Frame(RidgeParameters_Frame, bg = "white")

                        tk.Label(Ridge_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        Ridge_random_state_int_frame = tk.Frame(Ridge_random_state_int_or_none_frame, bg = "white")
                        Ridge_random_state_int_or_none = StringVar()
                        tk.Radiobutton(Ridge_random_state_int_frame, text="Integer:", font = FONT_12, variable = Ridge_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Ridge_random_state_int_or_none.set("None")
                        Ridge_random_state = IntVar()
                        tk.Spinbox(Ridge_random_state_int_frame, textvariable = Ridge_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Ridge_random_state.set(0)
                        Ridge_random_state_int_frame.pack(anchor ="n")

                        Ridge_random_state_none_frame = tk.Frame(Ridge_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(Ridge_random_state_none_frame, text="None", font = FONT_12, variable = Ridge_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(Ridge_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        Ridge_random_state_none_frame.pack(side="left",anchor ="s")

                        Ridge_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare solver parameter
                        Ridge_solver_Frame = tk.Frame(RidgeParameters_Frame, bg = "white")
                        tk.Label(Ridge_solver_Frame, text="solver:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Ridge_solver = StringVar()
                        Ridge_solver.set("auto")
                        tk.OptionMenu(Ridge_solver_Frame, Ridge_solver, "auto", "svd", "cholesky", "lsqr", "sparse_cg", "sag", "saga").pack(side="right",anchor ="c")
                        Ridge_solver_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        Ridge_alpha_tol_Frame = tk.Frame(RidgeParameters_Frame, bg = "white")

                        if sys.platform == "linux": 
                            alpha="alpha:"
                            tol="tol:      "
                        elif sys.platform == "win64" or sys.platform == "win32":
                            alpha="alpha:"
                            tol="tol:    "
                        else:
                            alpha="alpha:"
                            tol="tol:     "

                        # declare alpha parameter
                        Ridge_alpha_Frame = tk.Frame(Ridge_alpha_tol_Frame, bg = "white")
                        tk.Label(Ridge_alpha_Frame, text=alpha, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        Ridge_alpha = DoubleVar()
                        tk.Spinbox(Ridge_alpha_Frame, textvariable = Ridge_alpha, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side= "right",anchor ="c")
                        Ridge_alpha.set(1)
                        Ridge_alpha_Frame.pack(side= "top", anchor ="w")

                        # declare tol parameter
                        Ridge_tol_Frame = tk.Frame(Ridge_alpha_tol_Frame, bg = "white")
                        tk.Label(Ridge_tol_Frame, text=tol, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        Ridge_tol = DoubleVar()
                        tk.Spinbox(Ridge_tol_Frame, textvariable = Ridge_tol, increment = 0.001,from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side= "right",anchor ="c")
                        Ridge_tol.set(0.001)
                        Ridge_tol_Frame.pack(side= "top", anchor ="w")

                        Ridge_alpha_tol_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare max_iter parameter, int or None, optional (default=None)
                        Ridge_max_iter_int_or_none_frame = tk.Frame(RidgeParameters_Frame, bg = "white")

                        tk.Label(Ridge_max_iter_int_or_none_frame, text="max_iter:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        Ridge_max_iter_int_frame = tk.Frame(Ridge_max_iter_int_or_none_frame, bg = "white")
                        Ridge_max_iter_int_or_none = StringVar()
                        tk.Radiobutton(Ridge_max_iter_int_frame, text="Integer:", font = FONT_12, variable = Ridge_max_iter_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Ridge_max_iter_int_or_none.set("None")
                        Ridge_max_iter = IntVar()
                        tk.Spinbox(Ridge_max_iter_int_frame, textvariable = Ridge_max_iter, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Ridge_max_iter.set(0)
                        Ridge_max_iter_int_frame.pack(anchor ="n")

                        Ridge_max_iter_none_frame = tk.Frame(Ridge_max_iter_int_or_none_frame, bg = "white")
                        tk.Radiobutton(Ridge_max_iter_none_frame, text="None", font = FONT_12, variable = Ridge_max_iter_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(Ridge_max_iter_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        Ridge_max_iter_none_frame.pack(side="left",anchor ="s")

                        Ridge_max_iter_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)


                                        ###################
                                        ###################

                        # declare fit_intercept parameter, bool = default: True
                        Ridge_fit_intercept_Frame = tk.Frame(RidgeParameters_Frame, bg = "white")
                        tk.Label(Ridge_fit_intercept_Frame, text="fit_intercept:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Ridge_fit_intercept = BooleanVar()
                        tk.Radiobutton(Ridge_fit_intercept_Frame, text= "True", variable = Ridge_fit_intercept, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(Ridge_fit_intercept_Frame, text= "False", variable = Ridge_fit_intercept, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        Ridge_fit_intercept.set(True)
                        Ridge_fit_intercept_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################


                        # declare normalize parameter, bool = default: False
                        Ridge_normalize_Frame = tk.Frame(RidgeParameters_Frame, bg = "white")
                        tk.Label(Ridge_normalize_Frame, text="normalize:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Ridge_normalize = BooleanVar()
                        tk.Radiobutton(Ridge_normalize_Frame, text= "True", variable = Ridge_normalize, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(Ridge_normalize_Frame, text= "False", variable = Ridge_normalize, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        Ridge_normalize.set(False)
                        Ridge_normalize_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################

                        # declare copy_X parameter, bool = default: False
                        Ridge_copy_X_Frame = tk.Frame(RidgeParameters_Frame, bg = "white")
                        tk.Label(Ridge_copy_X_Frame, text="copy_X:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Ridge_copy_X = BooleanVar()
                        tk.Radiobutton(Ridge_copy_X_Frame, text= "True", variable = Ridge_copy_X, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(Ridge_copy_X_Frame, text= "False", variable = Ridge_copy_X, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        Ridge_copy_X.set(True)
                        Ridge_copy_X_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################


                        RidgeParameters_Frame.pack(anchor ="c")



              ###########################################
                        # declare Ridge classifier Result
                        Ridge_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(Ridge_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Ridge_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(Ridge_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Ridge_SubFunc).pack(anchor="c", pady=23)
                        else:
                            ttk.Button(Ridge_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Ridge_SubFunc).pack(anchor="c", pady=26)

                        RidgeSelectedParameters_Frame = tk.Frame(Ridge_ClassifierEvaluation_MainFrame, bg = "white")
                        Ridge_Result = StringVar()
                        tk.Label(RidgeSelectedParameters_Frame, textvariable = Ridge_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        Ridge_Result.set("")
                        RidgeSelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################

                        Ridge_output_MainFrame = ttk.Frame(Ridge_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        Ridge_ModelEvaluationStatistics_Frame = ttk.Frame(Ridge_output_MainFrame,padding=(10, 10, 10, 10))

                        Ridge_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(Ridge_ModelEvaluationStatistics_Frame)
                        ttk.Label(Ridge_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            Ridge_ModelEvaluationStatistics_Listbox = tk.Listbox(Ridge_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Ridge_ModelEvaluationStatistics_Listbox = tk.Listbox(Ridge_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            Ridge_ModelEvaluationStatistics_Listbox = tk.Listbox(Ridge_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        


                        # add vertical scrollbar to list
                        Ridge_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(Ridge_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = Ridge_ModelEvaluationStatistics_Listbox.yview, width=10)
                        Ridge_ModelEvaluationStatistics_Listbox.config(yscrollcommand = Ridge_ModelEvaluationStatistics_Scrollbar_v.set)
                        Ridge_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Ridge_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(Ridge_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = Ridge_ModelEvaluationStatistics_Listbox.xview, width=10)
                        Ridge_ModelEvaluationStatistics_Listbox.config(xscrollcommand = Ridge_ModelEvaluationStatistics_Scrollbar_h.set)
                        Ridge_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        Ridge_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        Ridge_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(Ridge_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        Ridge_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(Ridge_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        Ridge_IdActualPredicted_Frame = ttk.Frame(Ridge_output_MainFrame,padding=(14, 10, 10, 10))

                        Ridge_IdActualPredicted_Listbox_Frame = ttk.Frame(Ridge_IdActualPredicted_Frame)
                        ttk.Label(Ridge_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            Ridge_IdActualPredicted_Listbox = tk.Listbox(Ridge_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Ridge_IdActualPredicted_Listbox = tk.Listbox(Ridge_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            Ridge_IdActualPredicted_Listbox = tk.Listbox(Ridge_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        Ridge_IdActualPredicted_Scrollbar_v = tk.Scrollbar(Ridge_IdActualPredicted_Listbox_Frame, orient = "vertical", command = Ridge_IdActualPredicted_Listbox.yview, width=10)
                        Ridge_IdActualPredicted_Listbox.config(yscrollcommand = Ridge_IdActualPredicted_Scrollbar_v.set)
                        Ridge_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Ridge_IdActualPredicted_Scrollbar_h = tk.Scrollbar(Ridge_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = Ridge_IdActualPredicted_Listbox.xview, width=10)
                        Ridge_IdActualPredicted_Listbox.config(xscrollcommand = Ridge_IdActualPredicted_Scrollbar_h.set)
                        Ridge_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        Ridge_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        Ridge_IdActualPredicted_Listbox_Frame.pack(anchor="n")                              

                        # output id - actual - predicted button
                        ttk.Button(Ridge_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        Ridge_IdActualPredicted_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(Ridge_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        Ridge_TestingResults_Frame = ttk.Frame(Ridge_output_MainFrame,padding=(14, 10, 10, 10))

                        Ridge_TestingResults_Listbox_Frame = ttk.Frame(Ridge_TestingResults_Frame)
                        ttk.Label(Ridge_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            Ridge_TestingResults_Listbox = tk.Listbox(Ridge_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Ridge_TestingResults_Listbox = tk.Listbox(Ridge_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            Ridge_TestingResults_Listbox = tk.Listbox(Ridge_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        Ridge_TestingResults_Scrollbar_v = tk.Scrollbar(Ridge_TestingResults_Listbox_Frame, orient = "vertical", command = Ridge_TestingResults_Listbox.yview, width=10)
                        Ridge_TestingResults_Listbox.config(yscrollcommand = Ridge_TestingResults_Scrollbar_v.set)
                        Ridge_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Ridge_TestingResults_Scrollbar_h = tk.Scrollbar(Ridge_TestingResults_Listbox_Frame, orient = "horizontal", command = Ridge_TestingResults_Listbox.xview, width=10)
                        Ridge_TestingResults_Listbox.config(xscrollcommand = Ridge_TestingResults_Scrollbar_h.set)
                        Ridge_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        Ridge_TestingResults_Listbox.pack(expand=True, fill="both")
                        Ridge_TestingResults_Listbox_Frame.pack(anchor="n")                            

                        # output testing results
                        ttk.Button(Ridge_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        Ridge_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        Ridge_output_MainFrame.pack()

                                        ###################
                                        ###################


                        Ridge_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            Ridge_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Ridge_Spacing_Frame, bg = "white").pack()
                            Ridge_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Ridge_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Ridge_Spacing_Frame, bg = "white").pack()
                            Ridge_Spacing_Frame.pack(pady=9)
                        else:
                            Ridge_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Ridge_Spacing_Frame, bg = "white").pack()
                            Ridge_Spacing_Frame.pack(pady=12)


                        # destroy these later
                        widgets = widgets[:] + [RidgeParameters_Frame,
                                                Ridge_ClassifierEvaluation_MainFrame,
                                                Ridge_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    Ridge_MainFunc()
          #########################################################
          #########################################################
          #########################################################




          #########################################################
          #########################################################
          #########################################################

                # Call function SGD_MainFunc if user select Stochastic Gradient
                # Descent - SGD from classifiers list.
                if classifier_name == '5: Stochastic Gradient Descent (SGDClassifier)':

                    def SGD_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def SGD_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            SGD_TrainTestSplit_vs_KFold_Result = SGD_TrainTestSplit_vs_KFold.get()
                            SGD_TrainTestSplit_Scale_Result = SGD_TrainTestSplit_Scale.get()/100
                            SGD_KFold_Result = SGD_KFold.get()

                            # get random_state value
                            if SGD_random_state_int_or_none.get() == "None":
                                SGD_random_state_Result = None
                            else:
                                SGD_random_state_Result = SGD_random_state.get()

                            SGD_loss_Result = SGD_loss.get()
                            SGD_penalty_Result = SGD_penalty.get()
                            SGD_alpha_Result = SGD_alpha.get()
                            SGD_l1_ratio_Result = SGD_l1_ratio.get()
                            SGD_fit_intercept_Result = SGD_fit_intercept.get()

                            # get max_iter value
                            if SGD_max_iter_int_or_none.get() == "None":
                                SGD_max_iter_Result = None
                            else:
                                SGD_max_iter_Result = SGD_max_iter.get()

                            # get tol value
                            if SGD_tol_int_or_none.get() == "None":
                                SGD_tol_Result = None
                            else:
                                SGD_tol_Result = SGD_tol.get()

                            SGD_verbose_Result = SGD_verbose.get()
                            SGD_epsilon_Result = SGD_epsilon.get()
                            SGD_n_jobs_Result = SGD_n_jobs.get()
                            SGD_learning_rate_Result = SGD_learning_rate.get()
                            SGD_eta0_Result = SGD_eta0.get()
                            SGD_power_t_Result = SGD_power_t.get()

                            # get class_weight value
                            if SGD_class_weight.get() == "none":
                                SGD_class_weight_Result = None
                            else:
                                SGD_class_weight_Result = SGD_class_weight.get()


                            SGD_warm_start_Result = SGD_warm_start.get()

                            if SGD_average_Integer_true_false.get() != "Integer":
                                if SGD_average_Integer_true_false.get() == "True":
                                    SGD_average_Integer_Result = True
                                else:
                                    SGD_average_Integer_Result = False
                            else:
                                SGD_average_Integer_Result = SGD_average_Integer.get()



                            CallClassifier = SGDClassifier(
                                    loss = SGD_loss_Result,
                                    penalty = SGD_penalty_Result,
                                    alpha = SGD_alpha_Result,
                                    l1_ratio = SGD_l1_ratio_Result,
                                    fit_intercept = SGD_fit_intercept_Result,
                                    max_iter = SGD_max_iter_Result,
                                    tol = SGD_tol_Result,
                                    shuffle = True,
                                    verbose = SGD_verbose_Result,
                                    epsilon = SGD_epsilon_Result,
                                    n_jobs = SGD_n_jobs_Result,
                                    random_state = SGD_random_state_Result,
                                    learning_rate = SGD_learning_rate_Result,
                                    eta0 = SGD_eta0_Result,
                                    power_t = SGD_power_t_Result,
                                    class_weight = SGD_class_weight_Result,
                                    warm_start = SGD_warm_start_Result,
                                    average= SGD_average_Integer_Result)



                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                                "random_state = " +str(SGD_random_state_Result),
                                                                "shuffle = " +str(True),
                                                                "penalty = " +str(SGD_penalty_Result),
                                                                "class_weight = " +str(SGD_class_weight_Result),
                                                                "learning_rate = " +str(SGD_learning_rate_Result),
                                                                "loss = "+str(SGD_loss_Result),
                                                                "alpha = " +str(SGD_alpha_Result),
                                                                "l1_ratio = " +str(SGD_l1_ratio_Result),
                                                                "verbose = " +str(SGD_verbose_Result),
                                                                "n_jobs = " +str(SGD_n_jobs_Result),
                                                                "epsilon = " +str(SGD_epsilon_Result),
                                                                "power_t = " +str(SGD_power_t_Result),
                                                                "eta0 = " +str(SGD_eta0_Result),
                                                                "average = " +str(SGD_average_Integer_Result),
                                                                "max_iter = " +str(SGD_max_iter_Result),
                                                                "warm_start = " +str(SGD_warm_start_Result),
                                                                "tol = " +str(SGD_tol_Result),
                                                                "fit_intercept = " +str(SGD_fit_intercept_Result))

                                    SGD_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if SGD_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = SGD_TrainTestSplit_Scale_Result, test_size = 1-SGD_TrainTestSplit_Scale_Result, random_state= SGD_random_state_Result, shuffle =True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if SGD_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = SGD_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = SGD_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################

                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])


              ###########################################

                        # This frame contain all Stochastic Gradient Descent - SGD
                        # classifier parameters including classifier discription.
                        SGDParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/22dnqoa")

                        SelectedClassifier_and_Link_Frame = tk.Frame(SGDParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"The class SGDClassifier implements "+
                                       "a plain stochastic gradient descent "+
                                       "learning routine which supports "+
                                       "different loss functions and penalties "+
                                       "for classification. This estimator "+
                                       "implements regularized linear models "+
                                       "with stochastic gradient descent (SGD) "+
                                       "learning.\"")
                        tk.Label(SGDParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=1)

              ###########################################

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        SGD_TrainTestSplit_vs_KFold_Frame=tk.Frame(SGDParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        SGD_TrainTestSplit_Frame = tk.Frame(SGD_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        SGD_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(SGD_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = SGD_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        SGD_TrainTestSplit_vs_KFold.set(1)
                        SGD_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(SGD_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = SGD_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        SGD_TrainTestSplit_Scale.set(75)
                        SGD_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        SGD_KFold_frame = tk.Frame(SGD_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(SGD_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = SGD_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        SGD_KFold= IntVar()
                        tk.Spinbox(SGD_KFold_frame, textvariable = SGD_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        SGD_KFold.set(10)
                        SGD_KFold_frame.pack(side="top",anchor ="w")

                        SGD_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                                        ###################
                                        ###################


                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        SGD_random_state_int_or_none_frame = tk.Frame(SGDParameters_Frame, bg = "white")

                        tk.Label(SGD_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        SGD_random_state_int_frame = tk.Frame(SGD_random_state_int_or_none_frame, bg = "white")
                        SGD_random_state_int_or_none = StringVar()
                        tk.Radiobutton(SGD_random_state_int_frame, text="Integer: ", font = FONT_12, variable = SGD_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        SGD_random_state_int_or_none.set("None")
                        SGD_random_state = IntVar()
                        tk.Spinbox(SGD_random_state_int_frame, textvariable = SGD_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        SGD_random_state.set(0)
                        SGD_random_state_int_frame.pack(anchor ="n")

                        SGD_random_state_none_frame = tk.Frame(SGD_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(SGD_random_state_none_frame, text="None", font = FONT_12, variable = SGD_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(SGD_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        SGD_random_state_none_frame.pack(side="left",anchor ="s")

                        SGD_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        SGD_loss_penalty_Frame = tk.Frame(SGDParameters_Frame, bg = "white")

                        if sys.platform == "linux": 
                            class_weight="class_weight:"
                            learning_rate= "learning_rate: "
                            penalty="penalty:"
                            loss="loss:      "
                            alpha="alpha:     "
                            l1_ratio= "l1_ratio: "
                            verbose="verbose:"
                            n_jobs="n_jobs:   "
                            epsilon="epsilon:  "
                            power_t="class_weight:"
                            eta0="eta0:                 "
                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            class_weight="class_weight:"
                            learning_rate= "learning_rate:"
                            penalty="penalty:        "
                            loss="loss:             "
                            alpha="alpha:     "
                            l1_ratio= "l1_ratio:  "
                            verbose="verbose: "
                            n_jobs="n_jobs:   "
                            epsilon="epsilon:  "
                            power_t="power_t:"
                            eta0="eta0:     "
                        
                        else:
                            class_weight="class_weight:"
                            learning_rate= "learning_rate:"
                            penalty="penalty:         "
                            loss="loss:              "
                            alpha="alpha:    "
                            l1_ratio= "l1_ratio: "
                            verbose="verbose:"
                            n_jobs="n_jobs:  "
                            epsilon="epsilon: "
                            power_t="power_t:"
                            eta0="eta0:      "
                            
                        # declare class_weight parameter
                        SGD_class_weight_Frame = tk.Frame(SGD_loss_penalty_Frame, bg = "white")
                        tk.Label(SGD_class_weight_Frame, text=class_weight, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        SGD_class_weight = StringVar()
                        SGD_class_weight.set("none")
                        tk.OptionMenu(SGD_class_weight_Frame, SGD_class_weight, "none", "balanced").pack(side="right",anchor ="c")
                        SGD_class_weight_Frame.pack(side="top",anchor ="w")


                        # declare learning_rate parameter
                        SGD_learning_rate_Frame = tk.Frame(SGD_loss_penalty_Frame, bg = "white")
                        tk.Label(SGD_learning_rate_Frame, text=learning_rate, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        SGD_learning_rate = StringVar()
                        SGD_learning_rate.set("optimal")
                        tk.OptionMenu(SGD_learning_rate_Frame, SGD_learning_rate, "optimal","invscaling", "constant").pack(side="right",anchor ="c")
                        SGD_learning_rate_Frame.pack(side="top",anchor ="w")
                        
                        
                        # declare penalty parameter
                        SGD_penalty_Frame = tk.Frame(SGD_loss_penalty_Frame, bg = "white")
                        tk.Label(SGD_penalty_Frame, text=penalty, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        SGD_penalty = StringVar()
                        SGD_penalty.set("l2")
                        tk.OptionMenu(SGD_penalty_Frame, SGD_penalty, "none", "l2", "l1", "elasticnet").pack(side="right",anchor ="c")
                        SGD_penalty_Frame.pack(side="top",anchor ="w")


                        # declare loss parameter
                        SGD_loss_Frame = tk.Frame(SGD_loss_penalty_Frame, bg = "white")
                        tk.Label(SGD_loss_Frame, text=loss, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        SGD_loss = StringVar()
                        SGD_loss.set("hinge")
                        tk.OptionMenu(SGD_loss_Frame, SGD_loss, "hinge", "log", "modified_huber", "squared_hinge", "perceptron", "squared_loss", "huber", "epsilon_insensitive", "squared_epsilon_insensitive" ).pack(side="right",anchor ="c")
                        SGD_loss_Frame.pack(side="left",anchor ="s")


                        SGD_loss_penalty_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        SGD_alpha_l1_ratio_verbose_epsilon_frame = tk.Frame(SGDParameters_Frame, bg = "white")

                        # declare verbose parameter
                        SGD_verbose_Frame = tk.Frame(SGD_alpha_l1_ratio_verbose_epsilon_frame, bg = "white")
                        tk.Label(SGD_verbose_Frame, text=verbose, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        SGD_verbose = IntVar()
                        tk.Spinbox(SGD_verbose_Frame, textvariable = SGD_verbose, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        SGD_verbose.set(0)
                        SGD_verbose_Frame.pack(side="top",anchor ="w")

                        # declare l1_ratio parameter
                        SGD_l1_ratio_Frame = tk.Frame(SGD_alpha_l1_ratio_verbose_epsilon_frame, bg = "white")
                        tk.Label(SGD_l1_ratio_Frame, text=l1_ratio, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        SGD_l1_ratio = DoubleVar()
                        tk.Spinbox(SGD_l1_ratio_Frame, textvariable = SGD_l1_ratio, increment = 0.1, from_=0, to=1, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        SGD_l1_ratio.set(0.15)
                        SGD_l1_ratio_Frame.pack(side="top",anchor ="w")
                        
                        # declare epsilon parameter
                        SGD_epsilon_Frame = tk.Frame(SGD_alpha_l1_ratio_verbose_epsilon_frame, bg = "white")
                        tk.Label(SGD_epsilon_Frame, text=epsilon, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        SGD_epsilon = DoubleVar()
                        tk.Spinbox(SGD_epsilon_Frame, textvariable = SGD_epsilon, increment = 0.1, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        SGD_epsilon.set(0.1)
                        SGD_epsilon_Frame.pack(side="top", anchor ="w")
                        
                        # declare n_jobs parameter
                        SGD_n_jobs_Frame = tk.Frame(SGD_alpha_l1_ratio_verbose_epsilon_frame, bg = "white")
                        tk.Label(SGD_n_jobs_Frame, text=n_jobs, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        SGD_n_jobs = IntVar()
                        tk.Spinbox(SGD_n_jobs_Frame, textvariable = SGD_n_jobs, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        SGD_n_jobs.set(1)
                        SGD_n_jobs_Frame.pack(side="top",anchor ="w")

                        # declare alpha parameter
                        SGD_alpha_Frame = tk.Frame(SGD_alpha_l1_ratio_verbose_epsilon_frame, bg = "white")
                        tk.Label(SGD_alpha_Frame, text=alpha, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        SGD_alpha = DoubleVar()
                        tk.Spinbox(SGD_alpha_Frame, textvariable = SGD_alpha, increment = 0.0001, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        SGD_alpha.set("{:.1E}".format(Decimal(0.0001)))
                        SGD_alpha_Frame.pack(side="left",anchor ="s")

                        SGD_alpha_l1_ratio_verbose_epsilon_frame.pack(side= "left", anchor ="n", padx =10)
                                        ###################
                                        ###################

                        SGD_n_jobs_eta0_power_t_n_iter_frame = tk.Frame(SGDParameters_Frame, bg = "white")
                            
                        # declare power_t parameter
                        SGD_power_t_Frame = tk.Frame(SGD_n_jobs_eta0_power_t_n_iter_frame, bg = "white")
                        tk.Label(SGD_power_t_Frame, text=power_t, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        SGD_power_t = DoubleVar()
                        tk.Spinbox(SGD_power_t_Frame, textvariable = SGD_power_t, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        SGD_power_t.set(0.5)
                        SGD_power_t_Frame.pack(side="top",anchor ="w")


                        # declare eta0 parameter
                        SGD_eta0_Frame = tk.Frame(SGD_n_jobs_eta0_power_t_n_iter_frame, bg = "white")
                        tk.Label(SGD_eta0_Frame, text=eta0, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        SGD_eta0 = DoubleVar()
                        tk.Spinbox(SGD_eta0_Frame, textvariable = SGD_eta0, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        SGD_eta0.set(0)
                        SGD_eta0_Frame.pack(side="top",anchor ="w")


                        # declare average parameter, bool or int
                        SGD_average_MainFrame = tk.Frame(SGD_n_jobs_eta0_power_t_n_iter_frame, bg = "white")

                        tk.Label(SGD_average_MainFrame, text="average:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        SGD_average_string_frame = tk.Frame(SGD_average_MainFrame, bg = "white")
                        SGD_average_Integer_true_false = StringVar()
                        tk.Radiobutton(SGD_average_string_frame, text="Integer: ", font = FONT_12, variable = SGD_average_Integer_true_false, value = "Integer",justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="w" )
                        SGD_average_Integer_true_false.set("False")
                        SGD_average_Integer= IntVar()
                        tk.Spinbox(SGD_average_string_frame, textvariable = SGD_average_Integer, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side = "right",anchor ="c")
                        SGD_average_Integer.set(1)
                        SGD_average_string_frame.pack(side="top",anchor ="w")

                        SGD_average_ture_false_Frame = tk.Frame(SGD_average_MainFrame, bg = "white")
                        tk.Radiobutton(SGD_average_ture_false_Frame, text="True    ", font = FONT_12, variable = SGD_average_Integer_true_false, value = "True",justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c" )
                        tk.Radiobutton(SGD_average_ture_false_Frame, text="False", font = FONT_12, variable = SGD_average_Integer_true_false, value = "False",justify='left', bg = "white", highlightthickness=0).pack(side="right",anchor ="c")
                        SGD_average_ture_false_Frame.pack(side="top",anchor ="w")


                        SGD_average_MainFrame.pack(side="top",anchor ="w", pady =5)


                        SGD_n_jobs_eta0_power_t_n_iter_frame.pack(side= "left", anchor ="n", padx =10)
                                        ###################
                                        ###################

                        SGD_max_iter_warm_start_frame = tk.Frame(SGDParameters_Frame, bg = "white")


                        # declare max_iter parameter, int or None, optional (default=None)
                        SGD_max_iter_int_or_none_frame = tk.Frame(SGD_max_iter_warm_start_frame, bg = "white")

                        tk.Label(SGD_max_iter_int_or_none_frame, text="max_iter:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        SGD_max_iter_int_frame = tk.Frame(SGD_max_iter_int_or_none_frame, bg = "white")
                        SGD_max_iter_int_or_none = StringVar()
                        tk.Radiobutton(SGD_max_iter_int_frame, text="Integer:", font = FONT_12, variable = SGD_max_iter_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        SGD_max_iter_int_or_none.set("Integer")
                        SGD_max_iter = IntVar()
                        tk.Spinbox(SGD_max_iter_int_frame, textvariable = SGD_max_iter, from_=1, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        SGD_max_iter.set(5)
                        SGD_max_iter_int_frame.pack(anchor ="n")

                        SGD_max_iter_none_frame = tk.Frame(SGD_max_iter_int_or_none_frame, bg = "white")
                        tk.Radiobutton(SGD_max_iter_none_frame, text="None", font = FONT_12, variable = SGD_max_iter_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(SGD_max_iter_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        SGD_max_iter_none_frame.pack(side="left",anchor ="s")

                        SGD_max_iter_int_or_none_frame.pack(side="top",anchor ="n")



                        # declare warm_start parameter, bool = default: False
                        SGD_warm_start_Frame = tk.Frame(SGD_max_iter_warm_start_frame, bg = "white")
                        tk.Label(SGD_warm_start_Frame, text="warm_start:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        SGD_warm_start = BooleanVar()
                        tk.Radiobutton(SGD_warm_start_Frame, text= "True", variable = SGD_warm_start, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(SGD_warm_start_Frame, text= "False", variable = SGD_warm_start, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        SGD_warm_start.set(False)
                        SGD_warm_start_Frame.pack(side="top",anchor ="n")

                        SGD_max_iter_warm_start_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################


                        SGD_tol_and_fit_intercept_Frame = tk.Frame(SGDParameters_Frame, bg = "white")

                        # declare tol parameter, int or None, optional (default=None)
                        SGD_tol_int_or_none_frame = tk.Frame(SGD_tol_and_fit_intercept_Frame, bg = "white")

                        tk.Label(SGD_tol_int_or_none_frame, text="tol:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        SGD_tol_int_frame = tk.Frame(SGD_tol_int_or_none_frame, bg = "white")
                        SGD_tol_int_or_none = StringVar()
                        tk.Radiobutton(SGD_tol_int_frame, text="float:", font = FONT_12, variable = SGD_tol_int_or_none, value = "float", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        SGD_tol_int_or_none.set("None")
                        SGD_tol = DoubleVar()
                        tk.Spinbox(SGD_tol_int_frame, textvariable = SGD_tol, increment = 0.001, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        SGD_tol.set("{:.1E}".format(Decimal(0.001)))
                        SGD_tol_int_frame.pack(anchor ="n")

                        SGD_tol_none_frame = tk.Frame(SGD_tol_int_or_none_frame, bg = "white")
                        tk.Radiobutton(SGD_tol_none_frame, text="None", font = FONT_12, variable = SGD_tol_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(SGD_tol_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        SGD_tol_none_frame.pack(side="left",anchor ="s")


                        SGD_tol_int_or_none_frame.pack(side="top",anchor ="w")

                        tk.Label(SGD_tol_and_fit_intercept_Frame, text="fit_intercept:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        # declare fit_intercept parameter, bool = default: True
                        SGD_fit_intercept_Frame = tk.Frame(SGD_tol_and_fit_intercept_Frame, bg = "white")
                        SGD_fit_intercept = BooleanVar()
                        tk.Radiobutton(SGD_fit_intercept_Frame, text= "True", variable = SGD_fit_intercept, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(SGD_fit_intercept_Frame, text= "False", variable = SGD_fit_intercept, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        SGD_fit_intercept.set(True)
                        SGD_fit_intercept_Frame.pack(anchor ="c")

                        SGD_tol_and_fit_intercept_Frame.pack(side= "left", anchor ="n", padx =10)


                                        ###################
                                        ###################


                        SGDParameters_Frame.pack(anchor ="c")



              ###########################################
                        # declare Stochastic Gradient Descent - SGD classifier
                        # Result
                        SGD_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(SGD_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = SGD_SubFunc).pack(anchor="c", pady=0)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(SGD_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = SGD_SubFunc).pack(anchor="c", pady=0)
                        else:
                            ttk.Button(SGD_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = SGD_SubFunc).pack(anchor="c", pady=1)

                        SGDSelectedParameters_Frame = tk.Frame(SGD_ClassifierEvaluation_MainFrame, bg = "white")
                        SGD_Result = StringVar()
                        tk.Label(SGDSelectedParameters_Frame, textvariable = SGD_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        SGD_Result.set("")
                        SGDSelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################

                        SGD_output_MainFrame = ttk.Frame(SGD_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        SGD_ModelEvaluationStatistics_Frame = ttk.Frame(SGD_output_MainFrame,padding=(10, 10, 10, 10))

                        SGD_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(SGD_ModelEvaluationStatistics_Frame)
                        ttk.Label(SGD_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            SGD_ModelEvaluationStatistics_Listbox = tk.Listbox(SGD_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            SGD_ModelEvaluationStatistics_Listbox = tk.Listbox(SGD_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            SGD_ModelEvaluationStatistics_Listbox = tk.Listbox(SGD_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        SGD_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(SGD_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = SGD_ModelEvaluationStatistics_Listbox.yview, width=10)
                        SGD_ModelEvaluationStatistics_Listbox.config(yscrollcommand = SGD_ModelEvaluationStatistics_Scrollbar_v.set)
                        SGD_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        SGD_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(SGD_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = SGD_ModelEvaluationStatistics_Listbox.xview, width=10)
                        SGD_ModelEvaluationStatistics_Listbox.config(xscrollcommand = SGD_ModelEvaluationStatistics_Scrollbar_h.set)
                        SGD_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        SGD_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        SGD_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(SGD_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        SGD_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(SGD_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        SGD_IdActualPredicted_Frame = ttk.Frame(SGD_output_MainFrame,padding=(14, 10, 10, 10))

                        SGD_IdActualPredicted_Listbox_Frame = ttk.Frame(SGD_IdActualPredicted_Frame)
                        ttk.Label(SGD_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            SGD_IdActualPredicted_Listbox = tk.Listbox(SGD_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            SGD_IdActualPredicted_Listbox = tk.Listbox(SGD_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            SGD_IdActualPredicted_Listbox = tk.Listbox(SGD_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                            

                        # add vertical scrollbar to list
                        SGD_IdActualPredicted_Scrollbar_v = tk.Scrollbar(SGD_IdActualPredicted_Listbox_Frame, orient = "vertical", command = SGD_IdActualPredicted_Listbox.yview, width=10)
                        SGD_IdActualPredicted_Listbox.config(yscrollcommand = SGD_IdActualPredicted_Scrollbar_v.set)
                        SGD_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        SGD_IdActualPredicted_Scrollbar_h = tk.Scrollbar(SGD_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = SGD_IdActualPredicted_Listbox.xview, width=10)
                        SGD_IdActualPredicted_Listbox.config(xscrollcommand = SGD_IdActualPredicted_Scrollbar_h.set)
                        SGD_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        SGD_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        SGD_IdActualPredicted_Listbox_Frame.pack(anchor="n")      

                        # output id - actual - predicted button
                        ttk.Button(SGD_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        SGD_IdActualPredicted_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(SGD_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        SGD_TestingResults_Frame = ttk.Frame(SGD_output_MainFrame,padding=(14, 10, 10, 10))

                        SGD_TestingResults_Listbox_Frame = ttk.Frame(SGD_TestingResults_Frame)
                        ttk.Label(SGD_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            SGD_TestingResults_Listbox = tk.Listbox(SGD_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            SGD_TestingResults_Listbox = tk.Listbox(SGD_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            SGD_TestingResults_Listbox = tk.Listbox(SGD_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                            
                        # add vertical scrollbar to list
                        SGD_TestingResults_Scrollbar_v = tk.Scrollbar(SGD_TestingResults_Listbox_Frame, orient = "vertical", command = SGD_TestingResults_Listbox.yview, width=10)
                        SGD_TestingResults_Listbox.config(yscrollcommand = SGD_TestingResults_Scrollbar_v.set)
                        SGD_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        SGD_TestingResults_Scrollbar_h = tk.Scrollbar(SGD_TestingResults_Listbox_Frame, orient = "horizontal", command = SGD_TestingResults_Listbox.xview, width=10)
                        SGD_TestingResults_Listbox.config(xscrollcommand = SGD_TestingResults_Scrollbar_h.set)
                        SGD_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        SGD_TestingResults_Listbox.pack(expand=True, fill="both")
                        SGD_TestingResults_Listbox_Frame.pack(anchor="n")                             
                            

                        # output testing results
                        ttk.Button(SGD_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        SGD_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        SGD_output_MainFrame.pack()

                                        ###################
                                        ###################


                        SGD_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            SGD_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(SGD_Spacing_Frame, bg = "white").pack(pady=0)
                            SGD_Spacing_Frame.pack()
                        elif sys.platform == "win64" or sys.platform == "win32":
                            SGD_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(SGD_Spacing_Frame, bg = "white").pack()
                            SGD_Spacing_Frame.pack(pady=10)
                        else:
                            SGD_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(SGD_Spacing_Frame, bg = "white").pack()
                            SGD_Spacing_Frame.pack(pady=8)



                        # destroy these later
                        widgets = widgets[:] + [SGDParameters_Frame,
                                                SGD_ClassifierEvaluation_MainFrame,
                                                SGD_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    SGD_MainFunc()
          #########################################################
          #########################################################
          #########################################################





          #########################################################
          #########################################################
          #########################################################

                # Call function EmptyFrame if user select
                # '#Linear and Quadratic Discriminant Analysis' from classifiers list.
                if classifier_name ==  "II. Discriminant_analysis":
                    EmptyFrame(WindowOneCanvasFrame, classifier_name)

                # Call function Linear_DA_MainFunc if user select Linear
                # Discriminant Analysis from classifiers list.
                if classifier_name == '6: LinearDiscriminantAnalysis':

                    def Linear_DA_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def Linear_DA_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            Linear_DA_TrainTestSplit_vs_KFold_Result = Linear_DA_TrainTestSplit_vs_KFold.get()
                            Linear_DA_TrainTestSplit_Scale_Result = Linear_DA_TrainTestSplit_Scale.get()/100
                            Linear_DA_KFold_Result = Linear_DA_KFold.get()

                            # get random_state value
                            if Linear_DA_random_state_int_or_none.get() == "None":
                                Linear_DA_random_state_Result = None
                            else:
                                Linear_DA_random_state_Result = Linear_DA_random_state.get()

                            Linear_DA_solver_Result = Linear_DA_solver.get()
                            Linear_DA_tol_Result = Linear_DA_tol.get()

                            # get n_components value
                            if Linear_DA_n_components_int_or_none.get() == "None":
                                Linear_DA_n_components_Result = None
                            else:
                                Linear_DA_n_components_Result = Linear_DA_n_components.get()

                            Linear_DA_store_covariance_Result = Linear_DA_store_covariance.get()


                            CallClassifier = LinearDiscriminantAnalysis(
                                                            solver = Linear_DA_solver_Result,
                                                            shrinkage= None,
                                                            priors=None,
                                                            n_components= Linear_DA_n_components_Result,
                                                            store_covariance= Linear_DA_store_covariance_Result,
                                                            tol = Linear_DA_tol_Result)


                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "randome_state = "+str(Linear_DA_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "solver = "+str(Linear_DA_solver_Result),
                                                            "tol = "+ str(Linear_DA_tol_Result),
                                                            "n_components = "+ str(Linear_DA_n_components_Result),
                                                            "store_covariance = "+ str(Linear_DA_store_covariance_Result),
                                                            "shrinkage = " + str(None),
                                                            "priors = "+ str(None))

                                    Linear_DA_Result.set(Classifier_Pramaters)

                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if Linear_DA_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = Linear_DA_TrainTestSplit_Scale_Result, test_size = 1-Linear_DA_TrainTestSplit_Scale_Result, random_state = Linear_DA_random_state_Result, shuffle= True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if Linear_DA_TrainTestSplit_vs_KFold_Result == 2:
                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = Linear_DA_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = Linear_DA_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################

                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])



             ###########################################

                        # This frame contain all LinearDiscriminantAnalysis classifier
                        # parameters including classifier discription.
                        Linear_DAParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2gHFh2I")

                        SelectedClassifier_and_Link_Frame = tk.Frame(Linear_DAParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"Linear Discriminant Analysis is a"+
                                       " classifier with a linear decision "+
                                       "boundary, generated by fitting class "+
                                       "conditional densities to the data and "+
                                       "using Bayes’ rule. The model fits a "+
                                       "Gaussian density to each class, "+
                                       "assuming that all classes share the "+
                                       "same covariance matrix.\"")

                        tk.Label(Linear_DAParameters_Frame,text = discription,wraplength=1000, bg = "white").pack(anchor="c", pady=10)

                                        ###################
                                        ###################

                        # add space on the left
                        tk.Label(Linear_DAParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =45)


                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        Linear_DA_TrainTestSplit_vs_KFold_Frame=tk.Frame(Linear_DAParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size


                        Linear_DA_TrainTestSplit_Frame = tk.Frame(Linear_DA_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        Linear_DA_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(Linear_DA_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = Linear_DA_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Linear_DA_TrainTestSplit_vs_KFold.set(1)
                        Linear_DA_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(Linear_DA_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = Linear_DA_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        Linear_DA_TrainTestSplit_Scale.set(75)
                        Linear_DA_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        Linear_DA_KFold_frame = tk.Frame(Linear_DA_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(Linear_DA_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = Linear_DA_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Linear_DA_KFold= IntVar()
                        tk.Spinbox(Linear_DA_KFold_frame, textvariable = Linear_DA_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Linear_DA_KFold.set(10)
                        Linear_DA_KFold_frame.pack(side="top",anchor ="w")

                        Linear_DA_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                        #######################################################


                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        Linear_DA_random_state_int_or_none_frame = tk.Frame(Linear_DAParameters_Frame, bg = "white")

                        tk.Label(Linear_DA_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        Linear_DA_random_state_int_frame = tk.Frame(Linear_DA_random_state_int_or_none_frame, bg = "white")
                        Linear_DA_random_state_int_or_none = StringVar()
                        tk.Radiobutton(Linear_DA_random_state_int_frame, text="Integer: ", font = FONT_12, variable = Linear_DA_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Linear_DA_random_state_int_or_none.set("None")
                        Linear_DA_random_state = IntVar()
                        tk.Spinbox(Linear_DA_random_state_int_frame, textvariable = Linear_DA_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Linear_DA_random_state.set(0)
                        Linear_DA_random_state_int_frame.pack(anchor ="n")

                        Linear_DA_random_state_none_frame = tk.Frame(Linear_DA_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(Linear_DA_random_state_none_frame, text="None", font = FONT_12, variable = Linear_DA_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(Linear_DA_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        Linear_DA_random_state_none_frame.pack(side="left",anchor ="s")

                        Linear_DA_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################


                        # declare solver parameter
                        Linear_DA_solver_Frame = tk.Frame(Linear_DAParameters_Frame, bg = "white")
                        tk.Label(Linear_DA_solver_Frame, text="solver:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Linear_DA_solver = StringVar()
                        Linear_DA_solver.set("svd")
                        tk.OptionMenu(Linear_DA_solver_Frame, Linear_DA_solver, "eigen", "lsqr", "svd").pack(anchor ="w")
                        Linear_DA_solver_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare tol parameter
                        Linear_DA_tol_Frame = tk.Frame(Linear_DAParameters_Frame, bg = "white")
                        tk.Label(Linear_DA_tol_Frame, text="tol:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor ="c")
                        Linear_DA_tol = DoubleVar()
                        tk.Spinbox(Linear_DA_tol_Frame, textvariable = Linear_DA_tol, increment = 0.0001, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(anchor ="w")
                        Linear_DA_tol.set("{:.1E}".format(Decimal(0.0001)))
                        Linear_DA_tol_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################


                        # declare n_components parameter, int or None, optional (default=None)
                        Linear_DA_n_components_int_or_none_frame = tk.Frame(Linear_DAParameters_Frame, bg = "white")

                        tk.Label(Linear_DA_n_components_int_or_none_frame, text="n_components:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        Linear_DA_n_components_int_frame = tk.Frame(Linear_DA_n_components_int_or_none_frame, bg = "white")
                        Linear_DA_n_components_int_or_none = StringVar()
                        tk.Radiobutton(Linear_DA_n_components_int_frame, text="Integer:", font = FONT_12, variable = Linear_DA_n_components_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Linear_DA_n_components_int_or_none.set("Integer")
                        Linear_DA_n_components = IntVar()
                        tk.Spinbox(Linear_DA_n_components_int_frame, textvariable = Linear_DA_n_components, from_=1, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Linear_DA_n_components.set(1)
                        Linear_DA_n_components_int_frame.pack(anchor ="n")

                        Linear_DA_n_components_none_frame = tk.Frame(Linear_DA_n_components_int_or_none_frame, bg = "white")
                        tk.Radiobutton(Linear_DA_n_components_none_frame, text="None", font = FONT_12, variable = Linear_DA_n_components_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(Linear_DA_n_components_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        Linear_DA_n_components_none_frame.pack(side="left",anchor ="s")

                        Linear_DA_n_components_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)
                                        ###################
                                        ###################

                        # declare store_covariance parameter, bool = default: False
                        Linear_DA_store_covariance_Frame = tk.Frame(Linear_DAParameters_Frame, bg = "white")
                        tk.Label(Linear_DA_store_covariance_Frame, text="store_covariance:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Linear_DA_store_covariance = BooleanVar()
                        tk.Radiobutton(Linear_DA_store_covariance_Frame, text= "True", variable = Linear_DA_store_covariance, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(Linear_DA_store_covariance_Frame, text= "False", variable = Linear_DA_store_covariance, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        Linear_DA_store_covariance.set(False)
                        Linear_DA_store_covariance_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################


                        Linear_DAParameters_Frame.pack(anchor ="c")



              ###########################################
                        # declare LinearDiscriminantAnalysis classifier result
                        Linear_DA_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(Linear_DA_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Linear_DA_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(Linear_DA_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Linear_DA_SubFunc).pack(anchor="c", pady=18)
                        else:
                            ttk.Button(Linear_DA_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Linear_DA_SubFunc).pack(anchor="c", pady=24)

                        Linear_DA_SelectedParameters_Frame = tk.Frame(Linear_DA_ClassifierEvaluation_MainFrame, bg = "white")
                        Linear_DA_Result = StringVar()
                        tk.Label(Linear_DA_SelectedParameters_Frame, textvariable = Linear_DA_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        Linear_DA_Result.set("")
                        Linear_DA_SelectedParameters_Frame.pack(anchor="c")




                                        ###################
                                        ###################

                        Linear_DA_output_MainFrame = ttk.Frame(Linear_DA_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        Linear_DA_ModelEvaluationStatistics_Frame = ttk.Frame(Linear_DA_output_MainFrame,padding=(10, 10, 10, 10))

                        Linear_DA_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(Linear_DA_ModelEvaluationStatistics_Frame)
                        ttk.Label(Linear_DA_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            Linear_DA_ModelEvaluationStatistics_Listbox = tk.Listbox(Linear_DA_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Linear_DA_ModelEvaluationStatistics_Listbox = tk.Listbox(Linear_DA_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            Linear_DA_ModelEvaluationStatistics_Listbox = tk.Listbox(Linear_DA_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        Linear_DA_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(Linear_DA_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = Linear_DA_ModelEvaluationStatistics_Listbox.yview, width=10)
                        Linear_DA_ModelEvaluationStatistics_Listbox.config(yscrollcommand = Linear_DA_ModelEvaluationStatistics_Scrollbar_v.set)
                        Linear_DA_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Linear_DA_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(Linear_DA_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = Linear_DA_ModelEvaluationStatistics_Listbox.xview, width=10)
                        Linear_DA_ModelEvaluationStatistics_Listbox.config(xscrollcommand = Linear_DA_ModelEvaluationStatistics_Scrollbar_h.set)
                        Linear_DA_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        Linear_DA_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        Linear_DA_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(Linear_DA_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        Linear_DA_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(Linear_DA_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # id - actual - predicted
                        Linear_DA_IdActualPredicted_Frame = ttk.Frame(Linear_DA_output_MainFrame,padding=(14, 10, 10, 10))

                        Linear_DA_IdActualPredicted_Listbox_Frame = ttk.Frame(Linear_DA_IdActualPredicted_Frame)

                        ttk.Label(Linear_DA_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            Linear_DA_IdActualPredicted_Listbox = tk.Listbox(Linear_DA_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Linear_DA_IdActualPredicted_Listbox = tk.Listbox(Linear_DA_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            Linear_DA_IdActualPredicted_Listbox = tk.Listbox(Linear_DA_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        Linear_DA_IdActualPredicted_Scrollbar_v = tk.Scrollbar(Linear_DA_IdActualPredicted_Listbox_Frame, orient = "vertical", command = Linear_DA_IdActualPredicted_Listbox.yview, width=10)
                        Linear_DA_IdActualPredicted_Listbox.config(yscrollcommand = Linear_DA_IdActualPredicted_Scrollbar_v.set)
                        Linear_DA_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Linear_DA_IdActualPredicted_Scrollbar_h = tk.Scrollbar(Linear_DA_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = Linear_DA_IdActualPredicted_Listbox.xview, width=10)
                        Linear_DA_IdActualPredicted_Listbox.config(xscrollcommand = Linear_DA_IdActualPredicted_Scrollbar_h.set)
                        Linear_DA_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        Linear_DA_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        Linear_DA_IdActualPredicted_Listbox_Frame.pack(anchor="n")                             

                        # output id - actual - predicted button
                        ttk.Button(Linear_DA_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        Linear_DA_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(Linear_DA_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        Linear_DA_TestingResults_Frame = ttk.Frame(Linear_DA_output_MainFrame,padding=(14, 10, 10, 10))

                        Linear_DA_TestingResults_Listbox_Frame = ttk.Frame(Linear_DA_TestingResults_Frame)
                        ttk.Label(Linear_DA_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            Linear_DA_TestingResults_Listbox = tk.Listbox(Linear_DA_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Linear_DA_TestingResults_Listbox = tk.Listbox(Linear_DA_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            Linear_DA_TestingResults_Listbox = tk.Listbox(Linear_DA_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        Linear_DA_TestingResults_Scrollbar_v = tk.Scrollbar(Linear_DA_TestingResults_Listbox_Frame, orient = "vertical", command = Linear_DA_TestingResults_Listbox.yview, width=10)
                        Linear_DA_TestingResults_Listbox.config(yscrollcommand = Linear_DA_TestingResults_Scrollbar_v.set)
                        Linear_DA_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Linear_DA_TestingResults_Scrollbar_h = tk.Scrollbar(Linear_DA_TestingResults_Listbox_Frame, orient = "horizontal", command = Linear_DA_TestingResults_Listbox.xview, width=10)
                        Linear_DA_TestingResults_Listbox.config(xscrollcommand = Linear_DA_TestingResults_Scrollbar_h.set)
                        Linear_DA_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        Linear_DA_TestingResults_Listbox.pack(expand=True, fill="both")
                        Linear_DA_TestingResults_Listbox_Frame.pack(anchor="n")                              

                        # output testing results
                        ttk.Button(Linear_DA_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        Linear_DA_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        Linear_DA_output_MainFrame.pack()

                                        ###################
                                        ###################



                        Linear_DA_ClassifierEvaluation_MainFrame.pack()
              ###########################################

                        if sys.platform == "linux": 
                            Linear_DA_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Linear_DA_Spacing_Frame, bg = "white").pack()
                            Linear_DA_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Linear_DA_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Linear_DA_Spacing_Frame, bg = "white").pack()
                            Linear_DA_Spacing_Frame.pack(pady=14)
                        else:
                            Linear_DA_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Linear_DA_Spacing_Frame, bg = "white").pack()
                            Linear_DA_Spacing_Frame.pack(pady=14)


                        # destroy these later
                        widgets = widgets[:] + [Linear_DAParameters_Frame,
                                                 Linear_DA_ClassifierEvaluation_MainFrame,
                                                 Linear_DA_Spacing_Frame]

                        for widget in widgets:
                            widget.pack() # pack them afterwards

                    Linear_DA_MainFunc()
          #########################################################
          #########################################################
          #########################################################





          #########################################################
          #########################################################
          #########################################################

                # Call function Quadratic_DA_MainFunc if user select Quadratic
                # Discriminant Analysis from classifiers list.
                if classifier_name == '7: QuadraticDiscriminantAnalysis':

                    def Quadratic_DA_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def Quadratic_DA_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            Quadratic_DA_TrainTestSplit_vs_KFold_Result = Quadratic_DA_TrainTestSplit_vs_KFold.get()
                            Quadratic_DA_TrainTestSplit_Scale_Result = Quadratic_DA_TrainTestSplit_Scale.get()/100
                            Quadratic_DA_KFold_Result = Quadratic_DA_KFold.get()

                            # get random_state value
                            if Quadratic_DA_random_state_int_or_none.get() == "None":
                                Quadratic_DA_random_state_Result = None
                            else:
                                Quadratic_DA_random_state_Result = Quadratic_DA_random_state.get()

                            Quadratic_DA_reg_param_Result = Quadratic_DA_reg_param.get()
                            Quadratic_DA_store_covariance_Result = Quadratic_DA_store_covariance.get()
                            Quadratic_DA_tol_Result = Quadratic_DA_tol.get()



                            CallClassifier = QuadraticDiscriminantAnalysis(
                                                                priors = None,
                                                                reg_param = Quadratic_DA_reg_param_Result,
                                                                store_covariance= Quadratic_DA_store_covariance_Result,
                                                                tol= Quadratic_DA_tol_Result,
                                                                store_covariances = None)



                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################



                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "randome_state = "+str(Quadratic_DA_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "reg_param = " + str(Quadratic_DA_reg_param_Result),
                                                            "tol = "+ str(Quadratic_DA_tol_Result),
                                                            "store_covariance = "+ str(Quadratic_DA_store_covariance_Result),
                                                            "store_covariances = "+ str(None),
                                                            "priors = "+str(None))

                                    Quadratic_DA_Result.set(Classifier_Pramaters)

                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if Quadratic_DA_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = Quadratic_DA_TrainTestSplit_Scale_Result, test_size = 1-Quadratic_DA_TrainTestSplit_Scale_Result, random_state= Quadratic_DA_random_state_Result , shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if Quadratic_DA_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = Quadratic_DA_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = Quadratic_DA_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################
                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])





             ###########################################

                        # This frame contain all QuadraticDiscriminantAnalysis classifier
                        # parameters including classifier discription.
                        Quadratic_DAParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2yTOS0M")

                        SelectedClassifier_and_Link_Frame = tk.Frame(Quadratic_DAParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"Quadratic Discriminant Analysis is a "+
                                       "classifier with a quadratic decision "+
                                       "boundary, generated by fitting class "+
                                       "conditional densities to the data and "+
                                       "using Bayes’ rule. The model fits a "+
                                       "Gaussian density to each class.\"")
                        tk.Label(Quadratic_DAParameters_Frame,text = discription,wraplength=800, bg = "white").pack(anchor="c", pady=10)
                                        ###################
                                        ###################

                        # add space on the left
                        tk.Label(Quadratic_DAParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =30)

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        Quadratic_DA_TrainTestSplit_vs_KFold_Frame=tk.Frame(Quadratic_DAParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        Quadratic_DA_TrainTestSplit_Frame = tk.Frame(Quadratic_DA_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        Quadratic_DA_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(Quadratic_DA_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = Quadratic_DA_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Quadratic_DA_TrainTestSplit_vs_KFold.set(1)
                        Quadratic_DA_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(Quadratic_DA_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = Quadratic_DA_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        Quadratic_DA_TrainTestSplit_Scale.set(75)
                        Quadratic_DA_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        Quadratic_DA_KFold_frame = tk.Frame(Quadratic_DA_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(Quadratic_DA_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = Quadratic_DA_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Quadratic_DA_KFold= IntVar()
                        tk.Spinbox(Quadratic_DA_KFold_frame, textvariable = Quadratic_DA_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Quadratic_DA_KFold.set(10)
                        Quadratic_DA_KFold_frame.pack(side="top",anchor ="w")

                        Quadratic_DA_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                        #######################################################

                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        Quadratic_DA_random_state_int_or_none_frame = tk.Frame(Quadratic_DAParameters_Frame, bg = "white")

                        tk.Label(Quadratic_DA_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        Quadratic_DA_random_state_int_frame = tk.Frame(Quadratic_DA_random_state_int_or_none_frame, bg = "white")
                        Quadratic_DA_random_state_int_or_none = StringVar()
                        tk.Radiobutton(Quadratic_DA_random_state_int_frame, text="Integer: ", font = FONT_12, variable = Quadratic_DA_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        Quadratic_DA_random_state_int_or_none.set("None")
                        Quadratic_DA_random_state = IntVar()
                        tk.Spinbox(Quadratic_DA_random_state_int_frame, textvariable = Quadratic_DA_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        Quadratic_DA_random_state.set(0)
                        Quadratic_DA_random_state_int_frame.pack(anchor ="n")

                        Quadratic_DA_random_state_none_frame = tk.Frame(Quadratic_DA_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(Quadratic_DA_random_state_none_frame, text="None", font = FONT_12, variable = Quadratic_DA_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(Quadratic_DA_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        Quadratic_DA_random_state_none_frame.pack(side="left",anchor ="s")

                        Quadratic_DA_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare reg_param parameter
                        Quadratic_DA_reg_param_Frame = tk.Frame(Quadratic_DAParameters_Frame, bg = "white")
                        tk.Label(Quadratic_DA_reg_param_Frame, text="reg_param:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor ="c")
                        Quadratic_DA_reg_param = DoubleVar()
                        tk.Spinbox(Quadratic_DA_reg_param_Frame, textvariable = Quadratic_DA_reg_param, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(anchor ="c")
                        Quadratic_DA_reg_param.set(0)
                        Quadratic_DA_reg_param_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare tol parameter
                        Quadratic_DA_tol_Frame = tk.Frame(Quadratic_DAParameters_Frame, bg = "white")
                        tk.Label(Quadratic_DA_tol_Frame, text="tol:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor ="c")
                        Quadratic_DA_tol = DoubleVar()
                        tk.Spinbox(Quadratic_DA_tol_Frame, textvariable = Quadratic_DA_tol, increment = 0.0001, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(anchor ="w")
                        Quadratic_DA_tol.set("{:.1E}".format(Decimal(0.0001)))
                        Quadratic_DA_tol_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare store_covariance parameter, bool = default: False
                        Quadratic_DA_store_covariance_Frame = tk.Frame(Quadratic_DAParameters_Frame, bg = "white")
                        tk.Label(Quadratic_DA_store_covariance_Frame, text="store_covariance:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Quadratic_DA_store_covariance = BooleanVar()
                        tk.Radiobutton(Quadratic_DA_store_covariance_Frame, text= "True", variable = Quadratic_DA_store_covariance, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(Quadratic_DA_store_covariance_Frame, text= "False", variable = Quadratic_DA_store_covariance, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        Quadratic_DA_store_covariance.set(False)
                        Quadratic_DA_store_covariance_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        Quadratic_DAParameters_Frame.pack(anchor ="c")



              ###########################################
                        # declare QuadraticDiscriminantAnalysis classifier result
                        Quadratic_DA_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(Quadratic_DA_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Quadratic_DA_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(Quadratic_DA_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Quadratic_DA_SubFunc).pack(anchor="c", pady=18)
                        else:
                            ttk.Button(Quadratic_DA_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = Quadratic_DA_SubFunc).pack(anchor="c", pady=24)

                        Quadratic_DA_SelectedParameters_Frame = tk.Frame(Quadratic_DA_ClassifierEvaluation_MainFrame, bg = "white")
                        Quadratic_DA_Result = StringVar()
                        tk.Label(Quadratic_DA_SelectedParameters_Frame, textvariable = Quadratic_DA_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        Quadratic_DA_Result.set("")
                        Quadratic_DA_SelectedParameters_Frame.pack(anchor="c")




                                        ###################
                                        ###################

                        Quadratic_DA_output_MainFrame = ttk.Frame(Quadratic_DA_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        Quadratic_DA_ModelEvaluationStatistics_Frame = ttk.Frame(Quadratic_DA_output_MainFrame,padding=(10, 10, 10, 10))

                        Quadratic_DA_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(Quadratic_DA_ModelEvaluationStatistics_Frame)
                        ttk.Label(Quadratic_DA_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            Quadratic_DA_ModelEvaluationStatistics_Listbox = tk.Listbox(Quadratic_DA_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Quadratic_DA_ModelEvaluationStatistics_Listbox = tk.Listbox(Quadratic_DA_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            Quadratic_DA_ModelEvaluationStatistics_Listbox = tk.Listbox(Quadratic_DA_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        Quadratic_DA_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(Quadratic_DA_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = Quadratic_DA_ModelEvaluationStatistics_Listbox.yview, width=10)
                        Quadratic_DA_ModelEvaluationStatistics_Listbox.config(yscrollcommand = Quadratic_DA_ModelEvaluationStatistics_Scrollbar_v.set)
                        Quadratic_DA_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Quadratic_DA_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(Quadratic_DA_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = Quadratic_DA_ModelEvaluationStatistics_Listbox.xview, width=10)
                        Quadratic_DA_ModelEvaluationStatistics_Listbox.config(xscrollcommand = Quadratic_DA_ModelEvaluationStatistics_Scrollbar_h.set)
                        Quadratic_DA_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        Quadratic_DA_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        Quadratic_DA_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(Quadratic_DA_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        Quadratic_DA_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(Quadratic_DA_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        Quadratic_DA_IdActualPredicted_Frame = ttk.Frame(Quadratic_DA_output_MainFrame,padding=(14, 10, 10, 10))

                        Quadratic_DA_IdActualPredicted_Listbox_Frame = ttk.Frame(Quadratic_DA_IdActualPredicted_Frame)
                        ttk.Label(Quadratic_DA_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            Quadratic_DA_IdActualPredicted_Listbox = tk.Listbox(Quadratic_DA_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Quadratic_DA_IdActualPredicted_Listbox = tk.Listbox(Quadratic_DA_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            Quadratic_DA_IdActualPredicted_Listbox = tk.Listbox(Quadratic_DA_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                        
                        # add vertical scrollbar to list
                        Quadratic_DA_IdActualPredicted_Scrollbar_v = tk.Scrollbar(Quadratic_DA_IdActualPredicted_Listbox_Frame, orient = "vertical", command = Quadratic_DA_IdActualPredicted_Listbox.yview, width=10)
                        Quadratic_DA_IdActualPredicted_Listbox.config(yscrollcommand = Quadratic_DA_IdActualPredicted_Scrollbar_v.set)
                        Quadratic_DA_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Quadratic_DA_IdActualPredicted_Scrollbar_h = tk.Scrollbar(Quadratic_DA_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = Quadratic_DA_IdActualPredicted_Listbox.xview, width=10)
                        Quadratic_DA_IdActualPredicted_Listbox.config(xscrollcommand = Quadratic_DA_IdActualPredicted_Scrollbar_h.set)
                        Quadratic_DA_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        Quadratic_DA_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        Quadratic_DA_IdActualPredicted_Listbox_Frame.pack(anchor="n")                         
                        

                        # output id - actual - predicted button
                        ttk.Button(Quadratic_DA_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        Quadratic_DA_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(Quadratic_DA_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        Quadratic_DA_TestingResults_Frame = ttk.Frame(Quadratic_DA_output_MainFrame,padding=(14, 10, 10, 10))

                        Quadratic_DA_TestingResults_Listbox_Frame = ttk.Frame(Quadratic_DA_TestingResults_Frame)
                        ttk.Label(Quadratic_DA_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            Quadratic_DA_TestingResults_Listbox = tk.Listbox(Quadratic_DA_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Quadratic_DA_TestingResults_Listbox = tk.Listbox(Quadratic_DA_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            Quadratic_DA_TestingResults_Listbox = tk.Listbox(Quadratic_DA_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)

                        # add vertical scrollbar to list
                        Quadratic_DA_TestingResults_Scrollbar_v = tk.Scrollbar(Quadratic_DA_TestingResults_Listbox_Frame, orient = "vertical", command = Quadratic_DA_TestingResults_Listbox.yview, width=10)
                        Quadratic_DA_TestingResults_Listbox.config(yscrollcommand = Quadratic_DA_TestingResults_Scrollbar_v.set)
                        Quadratic_DA_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        Quadratic_DA_TestingResults_Scrollbar_h = tk.Scrollbar(Quadratic_DA_TestingResults_Listbox_Frame, orient = "horizontal", command = Quadratic_DA_TestingResults_Listbox.xview, width=10)
                        Quadratic_DA_TestingResults_Listbox.config(xscrollcommand = Quadratic_DA_TestingResults_Scrollbar_h.set)
                        Quadratic_DA_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        Quadratic_DA_TestingResults_Listbox.pack(expand=True, fill="both")
                        Quadratic_DA_TestingResults_Listbox_Frame.pack(anchor="n")                             

                        # output testing results
                        ttk.Button(Quadratic_DA_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        Quadratic_DA_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        Quadratic_DA_output_MainFrame.pack()

                                        ###################
                                        ###################



                        Quadratic_DA_ClassifierEvaluation_MainFrame.pack()
              ###########################################

                        if sys.platform == "linux": 
                            Quadratic_DA_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Quadratic_DA_Spacing_Frame, bg = "white").pack()
                            Quadratic_DA_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            Quadratic_DA_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Quadratic_DA_Spacing_Frame, bg = "white").pack()
                            Quadratic_DA_Spacing_Frame.pack(pady=14)
                        else:
                            Quadratic_DA_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(Quadratic_DA_Spacing_Frame, bg = "white").pack()
                            Quadratic_DA_Spacing_Frame.pack(pady=14)


                        # destroy these later
                        widgets = widgets[:] + [Quadratic_DAParameters_Frame,
                                                 Quadratic_DA_ClassifierEvaluation_MainFrame,
                                                 Quadratic_DA_Spacing_Frame]

                        for widget in widgets:
                            widget.pack() # pack them afterwards

                    Quadratic_DA_MainFunc()
          #########################################################
          #########################################################
          #########################################################





          #########################################################
          #########################################################
          #########################################################

                # Call function EmptyFrame if user select
                # '#Support Vector Machines' from classifiers list.
                if classifier_name ==  'III. Support vector machines (SVMs)':
                    EmptyFrame(WindowOneCanvasFrame, classifier_name)


                # Call function LinearSVC_MainFunc if user select Linear-Support
                # Vector from classifiers list.
                if classifier_name == '8: LinearSVC':

                    def LinearSVC_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################

                        def LinearSVC_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            LinearSVC_TrainTestSplit_vs_KFold_Result = LinearSVC_TrainTestSplit_vs_KFold.get()
                            LinearSVC_TrainTestSplit_Scale_Result = LinearSVC_TrainTestSplit_Scale.get()/100
                            LinearSVC_KFold_Result = LinearSVC_KFold.get()
                            LinearSVC_penalty_Result = LinearSVC_penalty.get() # get penalty value
                            LinearSVC_loss_Result = LinearSVC_loss.get() # get loss value
                            LinearSVC_multi_class_Result = LinearSVC_multi_class.get() # get multi_class value
                            LinearSVC_dual_Result = LinearSVC_dual.get() # get dual value
                            LinearSVC_fit_intercept_Result = LinearSVC_fit_intercept.get() # get fit_intercept value
                            LinearSVC_tol_Result = LinearSVC_tol.get() # get tol value
                            LinearSVC_intercept_scaling_Result = LinearSVC_intercept_scaling.get() # get intercept_scaling value
                            LinearSVC_verbose_Result = LinearSVC_verbose.get() # get verbose value
                            LinearSVC_C_Result = LinearSVC_C.get() # get C value

                            # get random_state value
                            if LinearSVC_random_state_int_or_none.get() == "None":
                                LinearSVC_random_state_Result = None
                            else:
                                LinearSVC_random_state_Result = int(LinearSVC_random_state.get())



                            LinearSVC_max_iter_Result = LinearSVC_max_iter.get() # get max_iter value


                            CallClassifier = LinearSVC(
                                    penalty = LinearSVC_penalty_Result,
                                    loss = LinearSVC_loss_Result,
                                    multi_class = LinearSVC_multi_class_Result,
                                    dual = LinearSVC_dual_Result,
                                    fit_intercept = LinearSVC_fit_intercept_Result,
                                    tol = LinearSVC_tol_Result,
                                    intercept_scaling = LinearSVC_intercept_scaling_Result,
                                    verbose = LinearSVC_verbose_Result,
                                    C = LinearSVC_C_Result,
                                    class_weight = None,
                                    random_state = LinearSVC_random_state_Result,
                                    max_iter = LinearSVC_max_iter_Result)


                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################



                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "randome_state = "+str(LinearSVC_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "loss = "+ str(LinearSVC_loss_Result),
                                                            "multi_class = "+ str(LinearSVC_multi_class_Result),
                                                            "penalty = " + str(LinearSVC_penalty_Result),
                                                            "max_iter = "+str(LinearSVC_max_iter_Result),
                                                            "tol = "+ str(LinearSVC_tol_Result),
                                                            "intercept_scaling = "+ str(LinearSVC_intercept_scaling_Result),
                                                            "verbose = "+ str(LinearSVC_verbose_Result),
                                                            "C = "+ str(LinearSVC_C_Result),
                                                            "dual = "+ str(LinearSVC_dual_Result),
                                                            "fit_intercept = "+ str(LinearSVC_fit_intercept_Result),
                                                            "class_weight = "+str(None))


                                    LinearSVC_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if LinearSVC_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = LinearSVC_TrainTestSplit_Scale_Result, test_size = 1-LinearSVC_TrainTestSplit_Scale_Result, random_state= LinearSVC_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if LinearSVC_TrainTestSplit_vs_KFold_Result == 2:
                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = LinearSVC_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = LinearSVC_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)




                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################

                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])



              ###########################################

                        # This frame contain all LinearSVC classifier
                        # parameters including classifier discription.
                                        ###################
                                        ###################
                        LinearSVCParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2fVID2J")

                        SelectedClassifier_and_Link_Frame = tk.Frame(LinearSVCParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"Linear Support Vector is a supervised "+
                                       "learning classification method with "+
                                       "parameter kernel='linear', but "+
                                       "implemented in terms of liblinear rather "+
                                       "than libsvm, so it has more flexibility "+
                                       "in the choice of penalties and loss "+
                                       "functions and should scale better to "+
                                       "large numbers of samples.\"")
                        tk.Label(LinearSVCParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=10)
                                        ###################
                                        ###################

                        # add space on the left
                        tk.Label(LinearSVCParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =2)

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        LinearSVC_TrainTestSplit_vs_KFold_Frame=tk.Frame(LinearSVCParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        LinearSVC_TrainTestSplit_Frame = tk.Frame(LinearSVC_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        LinearSVC_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(LinearSVC_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = LinearSVC_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        LinearSVC_TrainTestSplit_vs_KFold.set(1)
                        LinearSVC_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(LinearSVC_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = LinearSVC_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        LinearSVC_TrainTestSplit_Scale.set(75)
                        LinearSVC_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        LinearSVC_KFold_frame = tk.Frame(LinearSVC_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(LinearSVC_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = LinearSVC_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        LinearSVC_KFold= IntVar()
                        tk.Spinbox(LinearSVC_KFold_frame, textvariable = LinearSVC_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        LinearSVC_KFold.set(10)
                        LinearSVC_KFold_frame.pack(side="top",anchor ="w")

                        LinearSVC_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n",padx =10)
                        #######################################################


                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        LinearSVC_random_state_int_or_none_frame = tk.Frame(LinearSVCParameters_Frame, bg = "white")

                        tk.Label(LinearSVC_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        LinearSVC_random_state_int_frame = tk.Frame(LinearSVC_random_state_int_or_none_frame, bg = "white")
                        LinearSVC_random_state_int_or_none = StringVar()
                        tk.Radiobutton(LinearSVC_random_state_int_frame, text="Number: ", font = FONT_12, variable = LinearSVC_random_state_int_or_none, value = 1, justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        LinearSVC_random_state_int_or_none.set("None")
                        LinearSVC_random_state = IntVar()
                        tk.Spinbox(LinearSVC_random_state_int_frame, textvariable = LinearSVC_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        LinearSVC_random_state.set(0)
                        LinearSVC_random_state_int_frame.pack(anchor ="n")

                        LinearSVC_random_state_none_frame = tk.Frame(LinearSVC_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(LinearSVC_random_state_none_frame, text="None", font = FONT_12, variable = LinearSVC_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(LinearSVC_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        LinearSVC_random_state_none_frame.pack(side="left",anchor ="s")

                        LinearSVC_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################
                        LinearSVC_multi_class_penalty_loss_Frame = tk.Frame(LinearSVCParameters_Frame, bg = "white")
                        
                        if sys.platform == "linux": 
                            loss= "loss:"
                            multi_class="multi_class:"
                            penalty="penalty:         "
                            intercept_scaling= "intercept_scaling:"
                            max_iter = "max_iter:                "
                            tol="tol:                            "
                            C="C:            "

                        elif sys.platform == "win64" or sys.platform == "win32":
                            loss= "loss:"
                            multi_class="multi_class:    "
                            penalty="penalty:            "
                            intercept_scaling= "intercept_scaling:"
                            max_iter = "max_iter:            "
                            tol="tol:                     "
                            C="C:         "
                        else:
                            loss= "loss:"
                            multi_class="multi_class:             "
                            penalty="penalty:                      "
                            intercept_scaling= "intercept_scaling:"
                            max_iter = "max_iter:              "
                            tol="tol:                        "
                            C="C:           "
                        
                        # declare loss parameter
                        LinearSVC_loss_Frame = tk.Frame(LinearSVC_multi_class_penalty_loss_Frame, bg = "white")
                        tk.Label(LinearSVC_loss_Frame, text=loss, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        LinearSVC_loss = StringVar()
                        LinearSVC_loss.set("squared_hinge")
                        tk.OptionMenu(LinearSVC_loss_Frame, LinearSVC_loss, "squared_hinge", "hinge").pack(side="right",anchor ="c")
                        LinearSVC_loss_Frame.pack(side= "top",anchor ="w")
                        
                        # declare multi_class parameter
                        LinearSVC_multi_class_Frame = tk.Frame(LinearSVC_multi_class_penalty_loss_Frame, bg = "white")
                        tk.Label(LinearSVC_multi_class_Frame, text=multi_class,font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        LinearSVC_multi_class = StringVar()
                        tk.OptionMenu(LinearSVC_multi_class_Frame, LinearSVC_multi_class, "crammer_singer", "ovr").pack(side="right",anchor ="c")
                        LinearSVC_multi_class.set("ovr")
                        LinearSVC_multi_class_Frame.pack(side= "top",anchor ="w")

                        # declare penalty parameter, str = l1 or l2, default: l2
                        LinearSVC_penalty_Frame = tk.Frame(LinearSVC_multi_class_penalty_loss_Frame, bg = "white")
                        tk.Label(LinearSVC_penalty_Frame, text=penalty, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        LinearSVC_penalty = StringVar()
                        LinearSVC_penalty.set("l2")
                        tk.OptionMenu(LinearSVC_penalty_Frame, LinearSVC_penalty, "l1", "l2").pack(side="right",anchor ="c")
                        LinearSVC_penalty_Frame.pack(side= "top",anchor ="w")


                        LinearSVC_multi_class_penalty_loss_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # frame contains intercept_scaling, max_iter, and tol parameters
                        LinearSVC_intercept_scaling_max_iter_tol_Frame = tk.Frame(LinearSVCParameters_Frame, bg = "white")


                        # declare intercept_scaling parameter
                        LinearSVC_intercept_scaling_Frame = tk.Frame(LinearSVC_intercept_scaling_max_iter_tol_Frame, bg = "white")
                        tk.Label(LinearSVC_intercept_scaling_Frame, text=intercept_scaling, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LinearSVC_intercept_scaling = DoubleVar()
                        tk.Spinbox(LinearSVC_intercept_scaling_Frame, textvariable = LinearSVC_intercept_scaling, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        LinearSVC_intercept_scaling.set(1)
                        LinearSVC_intercept_scaling_Frame.pack(side="top", anchor ="w")

                        # declare max_iter parameter
                        LinearSVC_max_iter_Frame = tk.Frame(LinearSVC_intercept_scaling_max_iter_tol_Frame, bg = "white")
                        tk.Label(LinearSVC_max_iter_Frame, text=max_iter, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LinearSVC_max_iter = IntVar()
                        tk.Spinbox(LinearSVC_max_iter_Frame, textvariable = LinearSVC_max_iter, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        LinearSVC_max_iter.set(1000)
                        LinearSVC_max_iter_Frame.pack(side="top", anchor ="w")

                        # declare tol parameter
                        LinearSVC_tol_Frame = tk.Frame(LinearSVC_intercept_scaling_max_iter_tol_Frame, bg = "white")
                        tk.Label(LinearSVC_tol_Frame, text=tol, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LinearSVC_tol = DoubleVar()
                        tk.Spinbox(LinearSVC_tol_Frame, textvariable = LinearSVC_tol, increment = 0.0001,from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        LinearSVC_tol.set("{:.1E}".format(Decimal(0.0001)))
                        LinearSVC_tol_Frame.pack(side="top", anchor ="w")

                        LinearSVC_intercept_scaling_max_iter_tol_Frame.pack(side= "left", anchor ="n",padx =10)


                        # frame contains intercept_scaling, verbose, tol and C parameters
                        LinearSVC_verbose_C_Frame = tk.Frame(LinearSVCParameters_Frame, bg = "white")

                        # declare verbose parameter
                        LinearSVC_verbose_Frame = tk.Frame(LinearSVC_verbose_C_Frame, bg = "white")
                        tk.Label(LinearSVC_verbose_Frame, text="verbose:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LinearSVC_verbose = IntVar()
                        tk.Spinbox(LinearSVC_verbose_Frame, textvariable = LinearSVC_verbose, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        LinearSVC_verbose.set(0)
                        LinearSVC_verbose_Frame.pack(side="top", anchor ="w")

                        # declare C parameter
                        LinearSVC_C_Frame = tk.Frame(LinearSVC_verbose_C_Frame, bg = "white")
                        tk.Label(LinearSVC_C_Frame, text=C, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        LinearSVC_C = DoubleVar()
                        tk.Spinbox(LinearSVC_C_Frame, textvariable = LinearSVC_C, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        LinearSVC_C.set(1)
                        LinearSVC_C_Frame.pack(side="top",anchor ="w")

                        LinearSVC_verbose_C_Frame.pack(side= "left", anchor ="n",padx =10)

                                        ###################
                                        ###################


                        # declare dual parameter, bool = default: True
                        LinearSVC_dual_Frame = tk.Frame(LinearSVCParameters_Frame, bg = "white")
                        tk.Label(LinearSVC_dual_Frame, text="dual:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        LinearSVC_dual = BooleanVar()
                        tk.Radiobutton(LinearSVC_dual_Frame, text= "True", variable = LinearSVC_dual, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(LinearSVC_dual_Frame, text= "False", variable = LinearSVC_dual, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        LinearSVC_dual.set(True)
                        LinearSVC_dual_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare fit_intercept parameter, bool = default: True
                        LinearSVC_fit_intercept_Frame = tk.Frame(LinearSVCParameters_Frame, bg = "white")
                        tk.Label(LinearSVC_fit_intercept_Frame, text="fit_intercept:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        LinearSVC_fit_intercept = BooleanVar()
                        tk.Radiobutton(LinearSVC_fit_intercept_Frame, text= "True", variable = LinearSVC_fit_intercept, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(LinearSVC_fit_intercept_Frame, text= "False", variable = LinearSVC_fit_intercept, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        LinearSVC_fit_intercept.set(True)
                        LinearSVC_fit_intercept_Frame.pack(side= "left",anchor ="n",padx =10)



                        LinearSVCParameters_Frame.pack(anchor ="c")

              ###########################################
                        # declare LinearSVC classifier result
                        LinearSVC_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(LinearSVC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = LinearSVC_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(LinearSVC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = LinearSVC_SubFunc).pack(anchor="c", pady=11)
                        else:
                            ttk.Button(LinearSVC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = LinearSVC_SubFunc).pack(anchor="c", pady=16)

                        LinearSVCSelectedParameters_Frame = tk.Frame(LinearSVC_ClassifierEvaluation_MainFrame, bg = "white")
                        LinearSVC_Result = StringVar()
                        tk.Label(LinearSVCSelectedParameters_Frame, textvariable = LinearSVC_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        LinearSVC_Result.set("")
                        LinearSVCSelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################

                        LinearSVC_output_MainFrame = ttk.Frame(LinearSVC_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        LinearSVC_ModelEvaluationStatistics_Frame = ttk.Frame(LinearSVC_output_MainFrame,padding=(10, 10, 10, 10))

                        LinearSVC_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(LinearSVC_ModelEvaluationStatistics_Frame)
                        ttk.Label(LinearSVC_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            LinearSVC_ModelEvaluationStatistics_Listbox = tk.Listbox(LinearSVC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            LinearSVC_ModelEvaluationStatistics_Listbox = tk.Listbox(LinearSVC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            LinearSVC_ModelEvaluationStatistics_Listbox = tk.Listbox(LinearSVC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
       
                        # add vertical scrollbar to list
                        LinearSVC_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(LinearSVC_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = LinearSVC_ModelEvaluationStatistics_Listbox.yview, width=10)
                        LinearSVC_ModelEvaluationStatistics_Listbox.config(yscrollcommand = LinearSVC_ModelEvaluationStatistics_Scrollbar_v.set)
                        LinearSVC_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        LinearSVC_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(LinearSVC_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = LinearSVC_ModelEvaluationStatistics_Listbox.xview, width=10)
                        LinearSVC_ModelEvaluationStatistics_Listbox.config(xscrollcommand = LinearSVC_ModelEvaluationStatistics_Scrollbar_h.set)
                        LinearSVC_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        LinearSVC_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        LinearSVC_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(LinearSVC_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        LinearSVC_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(LinearSVC_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        LinearSVC_IdActualPredicted_Frame = ttk.Frame(LinearSVC_output_MainFrame,padding=(14, 10, 10, 10))

                        LinearSVC_IdActualPredicted_Listbox_Frame = ttk.Frame(LinearSVC_IdActualPredicted_Frame)
                        ttk.Label(LinearSVC_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            LinearSVC_IdActualPredicted_Listbox = tk.Listbox(LinearSVC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            LinearSVC_IdActualPredicted_Listbox = tk.Listbox(LinearSVC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            LinearSVC_IdActualPredicted_Listbox = tk.Listbox(LinearSVC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        LinearSVC_IdActualPredicted_Scrollbar_v = tk.Scrollbar(LinearSVC_IdActualPredicted_Listbox_Frame, orient = "vertical", command = LinearSVC_IdActualPredicted_Listbox.yview, width=10)
                        LinearSVC_IdActualPredicted_Listbox.config(yscrollcommand = LinearSVC_IdActualPredicted_Scrollbar_v.set)
                        LinearSVC_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        LinearSVC_IdActualPredicted_Scrollbar_h = tk.Scrollbar(LinearSVC_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = LinearSVC_IdActualPredicted_Listbox.xview, width=10)
                        LinearSVC_IdActualPredicted_Listbox.config(xscrollcommand = LinearSVC_IdActualPredicted_Scrollbar_h.set)
                        LinearSVC_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        LinearSVC_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        LinearSVC_IdActualPredicted_Listbox_Frame.pack(anchor="n")  

                        # output id - actual - predicted button
                        ttk.Button(LinearSVC_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        LinearSVC_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(LinearSVC_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        LinearSVC_TestingResults_Frame = ttk.Frame(LinearSVC_output_MainFrame,padding=(14, 10, 10, 10))

                        LinearSVC_TestingResults_Listbox_Frame = ttk.Frame(LinearSVC_TestingResults_Frame)
                        ttk.Label(LinearSVC_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            LinearSVC_TestingResults_Listbox = tk.Listbox(LinearSVC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            LinearSVC_TestingResults_Listbox = tk.Listbox(LinearSVC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            LinearSVC_TestingResults_Listbox = tk.Listbox(LinearSVC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        LinearSVC_TestingResults_Scrollbar_v = tk.Scrollbar(LinearSVC_TestingResults_Listbox_Frame, orient = "vertical", command = LinearSVC_TestingResults_Listbox.yview, width=10)
                        LinearSVC_TestingResults_Listbox.config(yscrollcommand = LinearSVC_TestingResults_Scrollbar_v.set)
                        LinearSVC_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        LinearSVC_TestingResults_Scrollbar_h = tk.Scrollbar(LinearSVC_TestingResults_Listbox_Frame, orient = "horizontal", command = LinearSVC_TestingResults_Listbox.xview, width=10)
                        LinearSVC_TestingResults_Listbox.config(xscrollcommand = LinearSVC_TestingResults_Scrollbar_h.set)
                        LinearSVC_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        LinearSVC_TestingResults_Listbox.pack(expand=True, fill="both")
                        LinearSVC_TestingResults_Listbox_Frame.pack(anchor="n")                             

                        # output testing results
                        ttk.Button(LinearSVC_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        LinearSVC_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        LinearSVC_output_MainFrame.pack()

                                        ###################
                                        ###################


                        LinearSVC_ClassifierEvaluation_MainFrame.pack()
              ###########################################

                        if sys.platform == "linux": 
                            LinearSVC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(LinearSVC_Spacing_Frame, bg = "white").pack()
                            LinearSVC_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            LinearSVC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(LinearSVC_Spacing_Frame, bg = "white").pack()
                            LinearSVC_Spacing_Frame.pack(pady=14)
                        else:
                            LinearSVC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(LinearSVC_Spacing_Frame, bg = "white").pack()
                            LinearSVC_Spacing_Frame.pack(pady=14)

                        # destroy these later
                        widgets = widgets[:] + [LinearSVCParameters_Frame,
                                                LinearSVC_ClassifierEvaluation_MainFrame,
                                                LinearSVC_Spacing_Frame]

                        for widget in widgets:
                            widget.pack() # pack them afterwards

                    LinearSVC_MainFunc()
          #########################################################
          #########################################################
          #########################################################




          #########################################################
          #########################################################
          #########################################################
                # Call function NuSVC_MainFunc if user select Nu-Support Vector
                # from classifiers list.
                if classifier_name == '9: NuSVC':

                    def NuSVC_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def NuSVC_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            NuSVC_TrainTestSplit_vs_KFold_Result = NuSVC_TrainTestSplit_vs_KFold.get()
                            NuSVC_TrainTestSplit_Scale_Result = NuSVC_TrainTestSplit_Scale.get()/100
                            NuSVC_KFold_Result = NuSVC_KFold.get()
                            NuSVC_max_iter_Result = NuSVC_max_iter.get() # get max_iter value
                            NuSVC_nu_Result = NuSVC_nu.get() # get Nu value
                            NuSVC_kernel_Result = NuSVC_kernel.get() # get kernel value
                            NuSVC_degree_Result = NuSVC_degree.get() # get degree value
                            NuSVC_coef0_Result = NuSVC_coef0.get() # get coef0 value
                            NuSVC_probability_Result = NuSVC_probability.get() # get probability value
                            NuSVC_shrinking_Result = NuSVC_shrinking.get() # get shrinking value
                            NuSVC_tol_Result = NuSVC_tol.get() # get tol value
                            NuSVC_cache_size_Result =  NuSVC_cache_size.get() # get cache_size value
                            NuSVC_verbose_Result =  NuSVC_verbose.get() # get verbose value
                            NuSVC_decision_function_shape_Result = NuSVC_decision_function_shape.get() # get decision_function_shape value

                            # get gamma value
                            if NuSVC_gamma_string_float.get() == "String":
                                NuSVC_gamma_string_float_Result = NuSVC_gamma_string.get()
                            if NuSVC_gamma_string_float.get() == "Float":
                                NuSVC_gamma_string_float_Result = NuSVC_gamma_float_Spinbox.get()

                            # get random_state value
                            if NuSVC_random_state_int_or_none.get() == "None":
                                NuSVC_random_state_Result = None
                            else:
                                NuSVC_random_state_Result = NuSVC_random_state.get()


                            CallClassifier = NuSVC(
                                                max_iter = NuSVC_max_iter_Result,
                                                nu = NuSVC_nu_Result,
                                                kernel = NuSVC_kernel_Result,
                                                degree = NuSVC_degree_Result,
                                                gamma = NuSVC_gamma_string_float_Result,
                                                coef0 = NuSVC_coef0_Result,
                                                probability = NuSVC_probability_Result,
                                                shrinking = NuSVC_shrinking_Result,
                                                tol = NuSVC_tol_Result,
                                                cache_size = NuSVC_cache_size_Result,
                                                class_weight=None,
                                                verbose = NuSVC_verbose_Result,
                                                decision_function_shape = NuSVC_decision_function_shape_Result,
                                                random_state = NuSVC_random_state_Result)


                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################


                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "random_state = "+str(NuSVC_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "decision_function_shape = "+str(NuSVC_decision_function_shape_Result),
                                                            "max_iter = "+str(NuSVC_max_iter_Result),
                                                            "tol = "+ str(NuSVC_tol_Result),
                                                            "nu = " + str(NuSVC_nu_Result),
                                                            "kernel = "+ str(NuSVC_kernel_Result),
                                                            "degree = "+ str(NuSVC_degree_Result),
                                                            "coef0 = "+ str(NuSVC_coef0_Result),
                                                            "cache_size = "+ str(NuSVC_cache_size_Result),
                                                            "gamma =  "+str(NuSVC_gamma_string_float_Result),
                                                            "probability = "+ str(NuSVC_probability_Result),
                                                            "shrinking = "+ str(NuSVC_shrinking_Result),
                                                            "verbose = "+str(NuSVC_verbose_Result),
                                                            "class_weight = "+str(None))


                                    NuSVC_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if NuSVC_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = NuSVC_TrainTestSplit_Scale_Result, test_size = 1-NuSVC_TrainTestSplit_Scale_Result, random_state=NuSVC_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if NuSVC_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = NuSVC_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = NuSVC_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])




              ###########################################

                        # This frame contain all NuSVC classifier
                        # parameters including classifier discription.
                        NuSVCParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2gHpIYT")

                        SelectedClassifier_and_Link_Frame = tk.Frame(NuSVCParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"Nu-Support Vector is a supervised "+
                                       "learning classification method that is "+
                                       "similar to SVC but uses a parameter "+
                                       "to control the number of support "+
                                       "vectors and the implementation is "+
                                       "based on libsvm.\"")
                        tk.Label(NuSVCParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=10)
                                        ###################
                                        ###################

                        # add space on the left
                        tk.Label(NuSVCParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =1)


                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        NuSVC_TrainTestSplit_vs_KFold_Frame=tk.Frame(NuSVCParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        NuSVC_TrainTestSplit_Frame = tk.Frame(NuSVC_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        NuSVC_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(NuSVC_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = NuSVC_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        NuSVC_TrainTestSplit_vs_KFold.set(1)
                        NuSVC_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(NuSVC_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = NuSVC_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        NuSVC_TrainTestSplit_Scale.set(75)
                        NuSVC_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        NuSVC_KFold_frame = tk.Frame(NuSVC_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(NuSVC_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = NuSVC_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        NuSVC_KFold= IntVar()
                        tk.Spinbox(NuSVC_KFold_frame, textvariable = NuSVC_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        NuSVC_KFold.set(10)
                        NuSVC_KFold_frame.pack(side="top",anchor ="w")

                        NuSVC_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                        #######################################################


                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        NuSVC_random_state_int_or_none_frame = tk.Frame(NuSVCParameters_Frame, bg = "white")

                        tk.Label(NuSVC_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        NuSVC_random_state_int_frame = tk.Frame(NuSVC_random_state_int_or_none_frame, bg = "white")
                        NuSVC_random_state_int_or_none = StringVar()
                        tk.Radiobutton(NuSVC_random_state_int_frame, text="Integer: ", font = FONT_12, variable = NuSVC_random_state_int_or_none, value = 1, justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        NuSVC_random_state_int_or_none.set("None")
                        NuSVC_random_state = IntVar()
                        tk.Spinbox(NuSVC_random_state_int_frame, textvariable = NuSVC_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        NuSVC_random_state.set(0)
                        NuSVC_random_state_int_frame.pack(anchor ="n")

                        NuSVC_random_state_none_frame = tk.Frame(NuSVC_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(NuSVC_random_state_none_frame, text="None", font = FONT_12, variable = NuSVC_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(NuSVC_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        NuSVC_random_state_none_frame.pack(side="left",anchor ="s")

                        NuSVC_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        NuSVC_decision_function_shape_max_iter_tol_nu_Frame = tk.Frame(NuSVCParameters_Frame, bg = "white")

                        if sys.platform == "linux": 
                            decision_function_shape= "decision_function_shape:"
                            max_iter="max_iter:"
                            tol="tol:            "
                            nu= "nu:            "
                            kernel = "kernel:"
                            degree="degree:         "
                            coef0="coef0:           "
                            cache_size = "cache_size:"

                        elif sys.platform == "win64" or sys.platform == "win32":
                            decision_function_shape= "decision_function_shape:"
                            max_iter="max_iter:"
                            tol="tol:         "
                            nu= "nu:         "
                            kernel = "kernel:"
                            degree="degree:       "
                            coef0="coef0:         "
                            cache_size = "cache_size:"

                        else:
                            decision_function_shape= "decision_function_shape:"
                            max_iter="max_iter:"
                            tol="tol:           "
                            nu= "nu:          "
                            kernel = "kernel:"
                            degree="degree:       "
                            coef0="coef0:          "
                            cache_size = "cache_size:"

                        # declare decision_function_shape parameter
                        NuSVC_decision_function_shape_Frame = tk.Frame(NuSVC_decision_function_shape_max_iter_tol_nu_Frame, bg = "white")
                        tk.Label(NuSVC_decision_function_shape_Frame, text=decision_function_shape, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        NuSVC_decision_function_shape = StringVar()
                        NuSVC_decision_function_shape.set("ovr")
                        tk.OptionMenu(NuSVC_decision_function_shape_Frame, NuSVC_decision_function_shape, "ovr", "ovo").pack(side="right",anchor ="c")
                        NuSVC_decision_function_shape_Frame.pack(side= "top",anchor ="w")

                        # declare max_iter parameter
                        NuSVC_max_iter_Frame = tk.Frame(NuSVC_decision_function_shape_max_iter_tol_nu_Frame, bg = "white")
                        tk.Label(NuSVC_max_iter_Frame, text=max_iter, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        NuSVC_max_iter = IntVar()
                        tk.Spinbox(NuSVC_max_iter_Frame, textvariable = NuSVC_max_iter, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        NuSVC_max_iter.set(-1)
                        NuSVC_max_iter_Frame.pack(side="top",anchor ="w")

                        # declare tol parameter
                        NuSVC_tol_Frame = tk.Frame(NuSVC_decision_function_shape_max_iter_tol_nu_Frame, bg = "white")
                        tk.Label(NuSVC_tol_Frame, text=tol, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        NuSVC_tol = DoubleVar()
                        tk.Spinbox(NuSVC_tol_Frame, textvariable = NuSVC_tol, increment = 0.0001,from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        NuSVC_tol.set("{:.1E}".format(Decimal(0.0001)))
                        NuSVC_tol_Frame.pack(side="top", anchor ="w")

                        # declare nu parameter
                        NuSVC_nu_Frame = tk.Frame(NuSVC_decision_function_shape_max_iter_tol_nu_Frame, bg = "white")
                        tk.Label(NuSVC_nu_Frame, text=nu, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        NuSVC_nu = DoubleVar()
                        tk.Spinbox(NuSVC_nu_Frame, textvariable = NuSVC_nu, from_=-sys.maxsize, to=sys.maxsize, increment=0.1, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        NuSVC_nu.set(0.5)
                        NuSVC_nu_Frame.pack(side="top", anchor ="w")

                        NuSVC_decision_function_shape_max_iter_tol_nu_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        NuSVC_kernel_degree_coef0_cache_size_Frame = tk.Frame(NuSVCParameters_Frame, bg = "white")

                        # declare kernel parameter
                        NuSVC_kernel_Frame = tk.Frame(NuSVC_kernel_degree_coef0_cache_size_Frame, bg = "white")
                        tk.Label(NuSVC_kernel_Frame, text=kernel, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        NuSVC_kernel = StringVar()
                        NuSVC_kernel.set("rbf")
                        tk.OptionMenu(NuSVC_kernel_Frame, NuSVC_kernel, "linear", "poly", "rbf", "sigmoid").pack(side="right",anchor ="c")
                        NuSVC_kernel_Frame.pack(side= "top",anchor ="w")

                        # declare cache_size parameter
                        NuSVC_cache_size_Frame = tk.Frame(NuSVC_kernel_degree_coef0_cache_size_Frame, bg = "white")
                        tk.Label(NuSVC_cache_size_Frame, text=cache_size, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        NuSVC_cache_size = DoubleVar()
                        tk.Spinbox(NuSVC_cache_size_Frame, textvariable = NuSVC_cache_size, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        NuSVC_cache_size.set(200)
                        NuSVC_cache_size_Frame.pack(side="top",anchor ="w")
                        
                        # declare degree parameter
                        NuSVC_degree_Frame = tk.Frame(NuSVC_kernel_degree_coef0_cache_size_Frame, bg = "white")
                        tk.Label(NuSVC_degree_Frame, text=degree, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        NuSVC_degree = IntVar()
                        tk.Spinbox(NuSVC_degree_Frame, textvariable = NuSVC_degree, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        NuSVC_degree.set(3)
                        NuSVC_degree_Frame.pack(side="top",anchor ="w")

                        # declare coef0 parameter
                        NuSVC_coef0_Frame = tk.Frame(NuSVC_kernel_degree_coef0_cache_size_Frame, bg = "white")
                        tk.Label(NuSVC_coef0_Frame, text=coef0, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        NuSVC_coef0 = DoubleVar()
                        tk.Spinbox(NuSVC_coef0_Frame, textvariable = NuSVC_coef0, from_=-sys.maxsize, to=sys.maxsize, width=5 ,relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        NuSVC_coef0.set(0)
                        NuSVC_coef0_Frame.pack(side="top",anchor ="w")


                        NuSVC_kernel_degree_coef0_cache_size_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare gamma parameter float or string, optional (default=”auto”)
                        NuSVC_gamma_MainFrame = tk.Frame(NuSVCParameters_Frame, bg = "white")

                        tk.Label(NuSVC_gamma_MainFrame, text="gamma:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        NuSVC_gamma_string_frame = tk.Frame(NuSVC_gamma_MainFrame, bg = "white")
                        NuSVC_gamma_string_float = StringVar()
                        tk.Radiobutton(NuSVC_gamma_string_frame, text="String: ", font = FONT_12, variable = NuSVC_gamma_string_float, value = "String",justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="w" )
                        NuSVC_gamma_string_float.set("String")
                        NuSVC_gamma_string = StringVar()
                        NuSVC_gamma_string.set("auto")
                        tk.OptionMenu(NuSVC_gamma_string_frame, NuSVC_gamma_string, "auto", "rbf", "poly", "sigmoid").pack(side="right",anchor ="c")
                        NuSVC_gamma_string_frame.pack(side="top",anchor ="w")

                        NuSVC_gamma_float_Radiobutton_frame = tk.Frame(NuSVC_gamma_MainFrame, bg = "white")
                        NuSVC_gamma_float_Radiobutton = StringVar()
                        tk.Radiobutton(NuSVC_gamma_float_Radiobutton_frame, text="Float:   ", font = FONT_12, variable = NuSVC_gamma_string_float, value = "Float",justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="w" )
                        NuSVC_gamma_float_Radiobutton.set("Float")
                        NuSVC_gamma_float_Spinbox= DoubleVar()
                        tk.Spinbox(NuSVC_gamma_float_Radiobutton_frame, textvariable = NuSVC_gamma_float_Spinbox, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        NuSVC_gamma_float_Spinbox.set(1)
                        NuSVC_gamma_float_Radiobutton_frame.pack(side= "left", anchor ="s")

                        NuSVC_gamma_MainFrame.pack(side= "left", anchor ="n", padx =10)
                                        ###################
                                        ###################


                        # declare probability parameter, bool = default: False
                        NuSVC_probability_Frame = tk.Frame(NuSVCParameters_Frame, bg = "white")
                        tk.Label(NuSVC_probability_Frame, text="probability:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        NuSVC_probability = BooleanVar()
                        tk.Radiobutton(NuSVC_probability_Frame, text= "True", variable = NuSVC_probability, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(NuSVC_probability_Frame, text= "False", variable = NuSVC_probability, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        NuSVC_probability.set(False)
                        NuSVC_probability_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################
                        # declare shrinking parameter, bool = default: True
                        NuSVC_shrinking_Frame = tk.Frame(NuSVCParameters_Frame, bg = "white")
                        tk.Label(NuSVC_shrinking_Frame, text="shrinking:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        NuSVC_shrinking = BooleanVar()
                        tk.Radiobutton(NuSVC_shrinking_Frame, text= "True", variable = NuSVC_shrinking, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(NuSVC_shrinking_Frame, text= "False", variable = NuSVC_shrinking, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        NuSVC_shrinking.set(True)
                        NuSVC_shrinking_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################

                        # declare probability parameter, bool = default: False
                        NuSVC_verbose_Frame = tk.Frame(NuSVCParameters_Frame, bg = "white")
                        tk.Label(NuSVC_verbose_Frame, text="verbose:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        NuSVC_verbose = BooleanVar()
                        tk.Radiobutton(NuSVC_verbose_Frame, text= "True", variable = NuSVC_verbose, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(NuSVC_verbose_Frame, text= "False", variable = NuSVC_verbose, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="c")
                        NuSVC_verbose.set(False)
                        NuSVC_verbose_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################

                        NuSVCParameters_Frame.pack(anchor ="c")




              ###########################################
                        # declare NuSVC classifier result
                        NuSVC_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(NuSVC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = NuSVC_SubFunc).pack(anchor="c", pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(NuSVC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = NuSVC_SubFunc).pack(anchor="c", pady=13)
                        else:
                            ttk.Button(NuSVC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = NuSVC_SubFunc).pack(anchor="c", pady=14)

                        NuSVCSelectedParameters_Frame = tk.Frame(NuSVC_ClassifierEvaluation_MainFrame, bg = "white")
                        NuSVC_Result = StringVar()
                        tk.Label(NuSVCSelectedParameters_Frame, textvariable = NuSVC_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        NuSVC_Result.set("")
                        NuSVCSelectedParameters_Frame.pack(anchor="c")


                                        ###################
                                        ###################

                        NuSVC_output_MainFrame = ttk.Frame(NuSVC_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        NuSVC_ModelEvaluationStatistics_Frame = ttk.Frame(NuSVC_output_MainFrame,padding=(10, 10, 10, 10))

                        NuSVC_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(NuSVC_ModelEvaluationStatistics_Frame)
                        ttk.Label(NuSVC_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")

                        if sys.platform == "linux": 
                            NuSVC_ModelEvaluationStatistics_Listbox = tk.Listbox(NuSVC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            NuSVC_ModelEvaluationStatistics_Listbox = tk.Listbox(NuSVC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            NuSVC_ModelEvaluationStatistics_Listbox = tk.Listbox(NuSVC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        NuSVC_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(NuSVC_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = NuSVC_ModelEvaluationStatistics_Listbox.yview, width=10)
                        NuSVC_ModelEvaluationStatistics_Listbox.config(yscrollcommand = NuSVC_ModelEvaluationStatistics_Scrollbar_v.set)
                        NuSVC_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        NuSVC_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(NuSVC_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = NuSVC_ModelEvaluationStatistics_Listbox.xview, width=10)
                        NuSVC_ModelEvaluationStatistics_Listbox.config(xscrollcommand = NuSVC_ModelEvaluationStatistics_Scrollbar_h.set)
                        NuSVC_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        NuSVC_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        NuSVC_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(NuSVC_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        NuSVC_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(NuSVC_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        NuSVC_IdActualPredicted_Frame = ttk.Frame(NuSVC_output_MainFrame,padding=(14, 10, 10, 10))

                        NuSVC_IdActualPredicted_Listbox_Frame = ttk.Frame(NuSVC_IdActualPredicted_Frame)
                        ttk.Label(NuSVC_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            NuSVC_IdActualPredicted_Listbox = tk.Listbox(NuSVC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            NuSVC_IdActualPredicted_Listbox = tk.Listbox(NuSVC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            NuSVC_IdActualPredicted_Listbox = tk.Listbox(NuSVC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        NuSVC_IdActualPredicted_Scrollbar_v = tk.Scrollbar(NuSVC_IdActualPredicted_Listbox_Frame, orient = "vertical", command = NuSVC_IdActualPredicted_Listbox.yview, width=10)
                        NuSVC_IdActualPredicted_Listbox.config(yscrollcommand = NuSVC_IdActualPredicted_Scrollbar_v.set)
                        NuSVC_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        NuSVC_IdActualPredicted_Scrollbar_h = tk.Scrollbar(NuSVC_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = NuSVC_IdActualPredicted_Listbox.xview, width=10)
                        NuSVC_IdActualPredicted_Listbox.config(xscrollcommand = NuSVC_IdActualPredicted_Scrollbar_h.set)
                        NuSVC_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        NuSVC_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        NuSVC_IdActualPredicted_Listbox_Frame.pack(anchor="n")                              

                        # output id - actual - predicted button
                        ttk.Button(NuSVC_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        NuSVC_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(NuSVC_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        NuSVC_TestingResults_Frame = ttk.Frame(NuSVC_output_MainFrame,padding=(14, 10, 10, 10))

                        NuSVC_TestingResults_Listbox_Frame = ttk.Frame(NuSVC_TestingResults_Frame)
                        ttk.Label(NuSVC_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            NuSVC_TestingResults_Listbox = tk.Listbox(NuSVC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            NuSVC_TestingResults_Listbox = tk.Listbox(NuSVC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            NuSVC_TestingResults_Listbox = tk.Listbox(NuSVC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                            
                        # add vertical scrollbar to list
                        NuSVC_TestingResults_Scrollbar_v = tk.Scrollbar(NuSVC_TestingResults_Listbox_Frame, orient = "vertical", command = NuSVC_TestingResults_Listbox.yview, width=10)
                        NuSVC_TestingResults_Listbox.config(yscrollcommand = NuSVC_TestingResults_Scrollbar_v.set)
                        NuSVC_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        NuSVC_TestingResults_Scrollbar_h = tk.Scrollbar(NuSVC_TestingResults_Listbox_Frame, orient = "horizontal", command = NuSVC_TestingResults_Listbox.xview, width=10)
                        NuSVC_TestingResults_Listbox.config(xscrollcommand = NuSVC_TestingResults_Scrollbar_h.set)
                        NuSVC_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        NuSVC_TestingResults_Listbox.pack(expand=True, fill="both")
                        NuSVC_TestingResults_Listbox_Frame.pack(anchor="n")                               
                            
                        # output testing results
                        ttk.Button(NuSVC_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        NuSVC_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        NuSVC_output_MainFrame.pack()

                                        ###################
                                        ###################


                        NuSVC_ClassifierEvaluation_MainFrame.pack()
              ###########################################
              
                        if sys.platform == "linux": 
                            NuSVC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(NuSVC_Spacing_Frame, bg = "white").pack()
                            NuSVC_Spacing_Frame.pack(pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            NuSVC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(NuSVC_Spacing_Frame, bg = "white").pack()
                            NuSVC_Spacing_Frame.pack(pady=12)
                        else:
                            NuSVC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(NuSVC_Spacing_Frame, bg = "white").pack()
                            NuSVC_Spacing_Frame.pack(pady=10)

                        # destroy these later
                        widgets = widgets[:] + [NuSVCParameters_Frame,
                                                NuSVC_ClassifierEvaluation_MainFrame,
                                                NuSVC_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    NuSVC_MainFunc()
          #########################################################
          #########################################################
          #########################################################



          #########################################################
          #########################################################
          #########################################################

                # Call function C_SVC_MainFunc if user select C-Support Vector
                # from classifiers list.
                if classifier_name == '10: SVC':

                    def C_SVC_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def C_SVC_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            C_SVC_TrainTestSplit_vs_KFold_Result = C_SVC_TrainTestSplit_vs_KFold.get()
                            C_SVC_TrainTestSplit_Scale_Result = C_SVC_TrainTestSplit_Scale.get()/100
                            C_SVC_KFold_Result = C_SVC_KFold.get()
                            C_SVC_max_iter_Result = C_SVC_max_iter.get() # get max_iter value
                            C_SVC_C_Result = C_SVC_C.get() # get C value
                            C_SVC_kernel_Result = C_SVC_kernel.get() # get kernel value
                            C_SVC_degree_Result = C_SVC_degree.get() # get degree value
                            C_SVC_coef0_Result = C_SVC_coef0.get() # get coef0 value
                            C_SVC_probability_Result = C_SVC_probability.get() # get probability value
                            C_SVC_shrinking_Result = C_SVC_shrinking.get() # get shrinking value
                            C_SVC_tol_Result = C_SVC_tol.get() # get tol value
                            C_SVC_cache_size_Result =  C_SVC_cache_size.get() # get cache_size value
                            C_SVC_verbose_Result =  C_SVC_verbose.get() # get verbose value
                            C_SVC_decision_function_shape_Result = C_SVC_decision_function_shape.get() # get decision_function_shape value

                            # get gamma value
                            if C_SVC_gamma_string_float.get() == "String":
                                C_SVC_gamma_string_float_Result = C_SVC_gamma_string.get()
                            if C_SVC_gamma_string_float.get() == "Float":
                                C_SVC_gamma_string_float_Result = C_SVC_gamma_float_Spinbox.get()


                            # get random_state value
                            if C_SVC_random_state_int_or_none.get() == "None":
                                C_SVC_random_state_Result = None
                            else:
                                C_SVC_random_state_Result = C_SVC_random_state.get()


                            CallClassifier = SVC(
                                                max_iter = C_SVC_max_iter_Result,
                                                C = C_SVC_C_Result,
                                                kernel = C_SVC_kernel_Result,
                                                degree = C_SVC_degree_Result,
                                                gamma = C_SVC_gamma_string_float_Result,
                                                coef0 = C_SVC_coef0_Result,
                                                probability = C_SVC_probability_Result,
                                                shrinking = C_SVC_shrinking_Result,
                                                tol = C_SVC_tol_Result,
                                                cache_size = C_SVC_cache_size_Result,
                                                class_weight=None,
                                                verbose = C_SVC_verbose_Result,
                                                decision_function_shape = C_SVC_decision_function_shape_Result,
                                                random_state = C_SVC_random_state_Result)


                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "random_state = "+str(C_SVC_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "decision_function_shape = "+str(C_SVC_decision_function_shape_Result),
                                                            "max_iter = "+str(C_SVC_max_iter_Result),
                                                            "tol = "+ str(C_SVC_tol_Result),
                                                            "C = " + str(C_SVC_C_Result),
                                                            "kernel = "+ str(C_SVC_kernel_Result),
                                                            "degree = "+ str(C_SVC_degree_Result),
                                                            "coef0 = "+ str(C_SVC_coef0_Result),
                                                            "cache_size = "+ str(C_SVC_cache_size_Result),
                                                            "gamma = " + str(C_SVC_gamma_string_float_Result),
                                                            "probability = "+ str(C_SVC_probability_Result),
                                                            "shrinking = "+ str(C_SVC_shrinking_Result),
                                                            "verbose = "+str(C_SVC_verbose_Result),
                                                            "class_weight = "+str(None))


                                    C_SVC_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if C_SVC_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = C_SVC_TrainTestSplit_Scale_Result, test_size = 1-C_SVC_TrainTestSplit_Scale_Result, random_state=C_SVC_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if C_SVC_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = C_SVC_random_state_Result)
                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = C_SVC_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])


             ###########################################

                        # This frame contain all NuSVC classifier
                        # parameters including classifier discription.
                        C_SVCParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2g5QSqk")

                        SelectedClassifier_and_Link_Frame = tk.Frame(C_SVCParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"C-Support Vector is a supervised "+
                                       "learning classification method. The "+
                                       "fit time complexity is more than "+
                                       "quadratic with the number of samples "+
                                       "which makes it hard to scale to "+
                                       "dataset with more than a couple of "+
                                       "10000 samples.\"")
                        tk.Label(C_SVCParameters_Frame,text = discription,wraplength=1000, bg = "white").pack(anchor="c", pady=10)
                                        ###################
                                        ###################

                        # add space on the left
                        tk.Label(C_SVCParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =1)

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        C_SVC_TrainTestSplit_vs_KFold_Frame=tk.Frame(C_SVCParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        C_SVC_TrainTestSplit_Frame = tk.Frame(C_SVC_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        C_SVC_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(C_SVC_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = C_SVC_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        C_SVC_TrainTestSplit_vs_KFold.set(1)
                        C_SVC_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(C_SVC_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = C_SVC_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        C_SVC_TrainTestSplit_Scale.set(75)
                        C_SVC_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        C_SVC_KFold_frame = tk.Frame(C_SVC_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(C_SVC_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = C_SVC_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        C_SVC_KFold= IntVar()
                        tk.Spinbox(C_SVC_KFold_frame, textvariable = C_SVC_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        C_SVC_KFold.set(10)
                        C_SVC_KFold_frame.pack(side="top",anchor ="w")

                        C_SVC_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                        #######################################################


                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        C_SVC_random_state_int_or_none_frame = tk.Frame(C_SVCParameters_Frame, bg = "white")

                        tk.Label(C_SVC_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        C_SVC_random_state_int_frame = tk.Frame(C_SVC_random_state_int_or_none_frame, bg = "white")
                        C_SVC_random_state_int_or_none = StringVar()
                        tk.Radiobutton(C_SVC_random_state_int_frame, text="Integer: ", font = FONT_12, variable = C_SVC_random_state_int_or_none, value = 1, justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        C_SVC_random_state_int_or_none.set("None")
                        C_SVC_random_state = IntVar()
                        tk.Spinbox(C_SVC_random_state_int_frame, textvariable = C_SVC_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        C_SVC_random_state.set(0)
                        C_SVC_random_state_int_frame.pack(anchor ="n")

                        C_SVC_random_state_none_frame = tk.Frame(C_SVC_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(C_SVC_random_state_none_frame, text="None", font = FONT_12, variable = C_SVC_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(C_SVC_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        C_SVC_random_state_none_frame.pack(side="left",anchor ="s")

                        C_SVC_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        C_SVC_decision_function_shape_max_iter_tol_C_Frame = tk.Frame(C_SVCParameters_Frame, bg = "white")
                        
                        if sys.platform == "linux": 
                            decision_function_shape= "decision_function_shape:"
                            max_iter="max_iter:"
                            tol="tol:            "
                            C="C:             "
                            kernel = "kernel:"
                            degree="degree:         "
                            coef0="coef0:           "
                            cache_size = "cache_size:"

                        elif sys.platform == "win64" or sys.platform == "win32":
                            decision_function_shape= "decision_function_shape:"
                            max_iter="max_iter:"
                            tol="tol:         "
                            C="C:          "
                            kernel = "kernel:"
                            degree="degree:       "
                            coef0="coef0:         "
                            cache_size = "cache_size:"

                        else:
                            decision_function_shape= "decision_function_shape:"
                            max_iter="max_iter:"
                            tol="tol:           "
                            C="C:            "
                            kernel = "kernel:"
                            degree="degree:       "
                            coef0="coef0:          "
                            cache_size = "cache_size:"
                            
                        # declare decision_function_shape parameter
                        C_SVC_decision_function_shape_Frame = tk.Frame(C_SVC_decision_function_shape_max_iter_tol_C_Frame, bg = "white")
                        tk.Label(C_SVC_decision_function_shape_Frame, text=decision_function_shape, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        C_SVC_decision_function_shape = StringVar()
                        C_SVC_decision_function_shape.set("ovr")
                        tk.OptionMenu(C_SVC_decision_function_shape_Frame, C_SVC_decision_function_shape, "ovr", "ovo").pack(side="right",anchor ="c")
                        C_SVC_decision_function_shape_Frame.pack(side= "top",anchor ="w")

                        # declare max_iter parameter
                        C_SVC_max_iter_Frame = tk.Frame(C_SVC_decision_function_shape_max_iter_tol_C_Frame, bg = "white")
                        tk.Label(C_SVC_max_iter_Frame, text=max_iter, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        C_SVC_max_iter = IntVar()
                        tk.Spinbox(C_SVC_max_iter_Frame, textvariable = C_SVC_max_iter, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        C_SVC_max_iter.set(-1)
                        C_SVC_max_iter_Frame.pack(side="top",anchor ="w")

                        # declare tol parameter
                        C_SVC_tol_Frame = tk.Frame(C_SVC_decision_function_shape_max_iter_tol_C_Frame, bg = "white")
                        tk.Label(C_SVC_tol_Frame, text=tol, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        C_SVC_tol = DoubleVar()
                        tk.Spinbox(C_SVC_tol_Frame, textvariable = C_SVC_tol, increment = 0.001,from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        C_SVC_tol.set("{:.1E}".format(Decimal(0.001)))
                        C_SVC_tol_Frame.pack(side="top", anchor ="w")

                        # declare C parameter
                        C_SVC_C_Frame = tk.Frame(C_SVC_decision_function_shape_max_iter_tol_C_Frame, bg = "white")
                        tk.Label(C_SVC_C_Frame, text=C, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        C_SVC_C = DoubleVar()
                        tk.Spinbox(C_SVC_C_Frame, textvariable = C_SVC_C, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        C_SVC_C.set(1)
                        C_SVC_C_Frame.pack(side="top",anchor ="w")

                        C_SVC_decision_function_shape_max_iter_tol_C_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        C_SVC_kernel_degree_coef0_cache_size_Frame = tk.Frame(C_SVCParameters_Frame, bg = "white")

                        # declare kernel parameter
                        C_SVC_kernel_Frame = tk.Frame(C_SVC_kernel_degree_coef0_cache_size_Frame, bg = "white")
                        tk.Label(C_SVC_kernel_Frame, text=kernel, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        C_SVC_kernel = StringVar()
                        C_SVC_kernel.set("rbf")
                        tk.OptionMenu(C_SVC_kernel_Frame, C_SVC_kernel, "linear", "poly", "rbf", "sigmoid").pack(side="right",anchor ="c")
                        C_SVC_kernel_Frame.pack(side= "top",anchor ="w")


                        # declare cache_size parameter
                        C_SVC_cache_size_Frame = tk.Frame(C_SVC_kernel_degree_coef0_cache_size_Frame, bg = "white")
                        tk.Label(C_SVC_cache_size_Frame, text=cache_size, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        C_SVC_cache_size = DoubleVar()
                        tk.Spinbox(C_SVC_cache_size_Frame, textvariable = C_SVC_cache_size, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        C_SVC_cache_size.set(200)
                        C_SVC_cache_size_Frame.pack(side="top",anchor ="w")

                        # declare degree parameter
                        C_SVC_degree_Frame = tk.Frame(C_SVC_kernel_degree_coef0_cache_size_Frame, bg = "white")
                        tk.Label(C_SVC_degree_Frame, text=degree, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        C_SVC_degree = IntVar()
                        tk.Spinbox(C_SVC_degree_Frame, textvariable = C_SVC_degree, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        C_SVC_degree.set(3)
                        C_SVC_degree_Frame.pack(side="top",anchor ="w")

                        # declare coef0 parameter
                        C_SVC_coef0_Frame = tk.Frame(C_SVC_kernel_degree_coef0_cache_size_Frame, bg = "white")
                        tk.Label(C_SVC_coef0_Frame, text=coef0, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        C_SVC_coef0 = DoubleVar()
                        tk.Spinbox(C_SVC_coef0_Frame, textvariable = C_SVC_coef0, from_=-sys.maxsize, to=sys.maxsize, width=5 ,relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        C_SVC_coef0.set(0)
                        C_SVC_coef0_Frame.pack(side="top",anchor ="w")


                        C_SVC_kernel_degree_coef0_cache_size_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare gamma parameter float or string, optional (default=”auto”)
                        C_SVC_gamma_MainFrame = tk.Frame(C_SVCParameters_Frame, bg = "white")

                        tk.Label(C_SVC_gamma_MainFrame, text="gamma:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        C_SVC_gamma_string_frame = tk.Frame(C_SVC_gamma_MainFrame, bg = "white")
                        C_SVC_gamma_string_float = StringVar()
                        tk.Radiobutton(C_SVC_gamma_string_frame, text="String: ", font = FONT_12, variable = C_SVC_gamma_string_float, value = "String",justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="w" )
                        C_SVC_gamma_string_float.set("String")
                        C_SVC_gamma_string = StringVar()
                        C_SVC_gamma_string.set("auto")
                        tk.OptionMenu(C_SVC_gamma_string_frame, C_SVC_gamma_string, "auto", "rbf", "poly", "sigmoid").pack(side="right",anchor ="c")
                        C_SVC_gamma_string_frame.pack(side="top",anchor ="w")

                        C_SVC_gamma_float_Radiobutton_frame = tk.Frame(C_SVC_gamma_MainFrame, bg = "white")
                        C_SVC_gamma_float_Radiobutton = StringVar()
                        tk.Radiobutton(C_SVC_gamma_float_Radiobutton_frame, text="Float:   ", font = FONT_12, variable = C_SVC_gamma_string_float, value = "Float",justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="w" )
                        C_SVC_gamma_float_Radiobutton.set("Float")
                        C_SVC_gamma_float_Spinbox= DoubleVar()
                        tk.Spinbox(C_SVC_gamma_float_Radiobutton_frame, textvariable = C_SVC_gamma_float_Spinbox, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        C_SVC_gamma_float_Spinbox.set(1)
                        C_SVC_gamma_float_Radiobutton_frame.pack(side= "left", anchor ="s")

                        C_SVC_gamma_MainFrame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare probability parameter, bool = default: False
                        C_SVC_probability_Frame = tk.Frame(C_SVCParameters_Frame, bg = "white")
                        tk.Label(C_SVC_probability_Frame, text="probability:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        C_SVC_probability = BooleanVar()
                        tk.Radiobutton(C_SVC_probability_Frame, text= "True", variable = C_SVC_probability, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(C_SVC_probability_Frame, text= "False", variable = C_SVC_probability, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        C_SVC_probability.set(False)
                        C_SVC_probability_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare shrinking parameter, bool = default: True
                        C_SVC_shrinking_Frame = tk.Frame(C_SVCParameters_Frame, bg = "white")
                        tk.Label(C_SVC_shrinking_Frame, text="shrinking:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        C_SVC_shrinking = BooleanVar()
                        tk.Radiobutton(C_SVC_shrinking_Frame, text= "True", variable = C_SVC_shrinking, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(C_SVC_shrinking_Frame, text= "False", variable = C_SVC_shrinking, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        C_SVC_shrinking.set(True)
                        C_SVC_shrinking_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare verbose parameter, bool = default: False
                        C_SVC_verbose_Frame = tk.Frame(C_SVCParameters_Frame, bg = "white")
                        tk.Label(C_SVC_verbose_Frame, text="verbose:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        C_SVC_verbose = BooleanVar()
                        tk.Radiobutton(C_SVC_verbose_Frame, text= "True", variable = C_SVC_verbose, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(C_SVC_verbose_Frame, text= "False", variable = C_SVC_verbose, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        C_SVC_verbose.set(False)
                        C_SVC_verbose_Frame.pack(side= "left",anchor ="n",padx =10)


                        C_SVCParameters_Frame.pack(anchor ="c")



              ###########################################
                        # declare SVC classifier result
                        C_SVC_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(C_SVC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = C_SVC_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(C_SVC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = C_SVC_SubFunc).pack(anchor="c", pady=13)
                        else:
                            ttk.Button(C_SVC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = C_SVC_SubFunc).pack(anchor="c", pady=14)

                        C_SVC_SelectedParameters_Frame = tk.Frame(C_SVC_ClassifierEvaluation_MainFrame, bg = "white")
                        C_SVC_Result = StringVar()
                        tk.Label(C_SVC_SelectedParameters_Frame, textvariable = C_SVC_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        C_SVC_Result.set("")
                        C_SVC_SelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################

                        C_SVC_output_MainFrame = ttk.Frame(C_SVC_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        C_SVC_ModelEvaluationStatistics_Frame = ttk.Frame(C_SVC_output_MainFrame,padding=(10, 10, 10, 10))

                        C_SVC_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(C_SVC_ModelEvaluationStatistics_Frame)
                        ttk.Label(C_SVC_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            C_SVC_ModelEvaluationStatistics_Listbox = tk.Listbox(C_SVC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            C_SVC_ModelEvaluationStatistics_Listbox = tk.Listbox(C_SVC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            C_SVC_ModelEvaluationStatistics_Listbox = tk.Listbox(C_SVC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
   
                        # add vertical scrollbar to list
                        C_SVC_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(C_SVC_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = C_SVC_ModelEvaluationStatistics_Listbox.yview, width=10)
                        C_SVC_ModelEvaluationStatistics_Listbox.config(yscrollcommand = C_SVC_ModelEvaluationStatistics_Scrollbar_v.set)
                        C_SVC_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        C_SVC_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(C_SVC_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = C_SVC_ModelEvaluationStatistics_Listbox.xview, width=10)
                        C_SVC_ModelEvaluationStatistics_Listbox.config(xscrollcommand = C_SVC_ModelEvaluationStatistics_Scrollbar_h.set)
                        C_SVC_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        C_SVC_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        C_SVC_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")


                        # output confusion matrix, model accuracy & error button
                        ttk.Button(C_SVC_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        C_SVC_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(C_SVC_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        C_SVC_IdActualPredicted_Frame = ttk.Frame(C_SVC_output_MainFrame,padding=(14, 10, 10, 10))

                        C_SVC_IdActualPredicted_Listbox_Frame = ttk.Frame(C_SVC_IdActualPredicted_Frame)
                        ttk.Label(C_SVC_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            C_SVC_IdActualPredicted_Listbox = tk.Listbox(C_SVC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            C_SVC_IdActualPredicted_Listbox = tk.Listbox(C_SVC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            C_SVC_IdActualPredicted_Listbox = tk.Listbox(C_SVC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple",listvariable = predicted_value_result, width=36, height=10)
                            
                        # add vertical scrollbar to list
                        C_SVC_IdActualPredicted_Scrollbar_v = tk.Scrollbar(C_SVC_IdActualPredicted_Listbox_Frame, orient = "vertical", command = C_SVC_IdActualPredicted_Listbox.yview, width=10)
                        C_SVC_IdActualPredicted_Listbox.config(yscrollcommand = C_SVC_IdActualPredicted_Scrollbar_v.set)
                        C_SVC_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        C_SVC_IdActualPredicted_Scrollbar_h = tk.Scrollbar(C_SVC_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = C_SVC_IdActualPredicted_Listbox.xview, width=10)
                        C_SVC_IdActualPredicted_Listbox.config(xscrollcommand = C_SVC_IdActualPredicted_Scrollbar_h.set)
                        C_SVC_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        C_SVC_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        C_SVC_IdActualPredicted_Listbox_Frame.pack(anchor="n")  

                        # output id - actual - predicted button
                        ttk.Button(C_SVC_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        C_SVC_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(C_SVC_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        C_SVC_TestingResults_Frame = ttk.Frame(C_SVC_output_MainFrame,padding=(14, 10, 10, 10))

                        C_SVC_TestingResults_Listbox_Frame = ttk.Frame(C_SVC_TestingResults_Frame)
                        ttk.Label(C_SVC_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            C_SVC_TestingResults_Listbox = tk.Listbox(C_SVC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            C_SVC_TestingResults_Listbox = tk.Listbox(C_SVC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            C_SVC_TestingResults_Listbox = tk.Listbox(C_SVC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        C_SVC_TestingResults_Scrollbar_v = tk.Scrollbar(C_SVC_TestingResults_Listbox_Frame, orient = "vertical", command = C_SVC_TestingResults_Listbox.yview, width=10)
                        C_SVC_TestingResults_Listbox.config(yscrollcommand = C_SVC_TestingResults_Scrollbar_v.set)
                        C_SVC_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
            
                        # add vertical scrollbar to list
                        C_SVC_TestingResults_Scrollbar_h = tk.Scrollbar(C_SVC_TestingResults_Listbox_Frame, orient = "horizontal", command = C_SVC_TestingResults_Listbox.xview, width=10)
                        C_SVC_TestingResults_Listbox.config(xscrollcommand = C_SVC_TestingResults_Scrollbar_h.set)
                        C_SVC_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        C_SVC_TestingResults_Listbox.pack(expand=True, fill="both")
                        C_SVC_TestingResults_Listbox_Frame.pack(anchor="n")                             
                            
                        # output testing results
                        ttk.Button(C_SVC_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        C_SVC_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        C_SVC_output_MainFrame.pack()

                                        ###################
                                        ###################



                        C_SVC_ClassifierEvaluation_MainFrame.pack()
              ###########################################

                        if sys.platform == "linux": 
                            C_SVC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(C_SVC_Spacing_Frame, bg = "white").pack()
                            C_SVC_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            C_SVC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(C_SVC_Spacing_Frame, bg = "white").pack()
                            C_SVC_Spacing_Frame.pack(pady=12)
                        else:
                            C_SVC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(C_SVC_Spacing_Frame, bg = "white").pack()
                            C_SVC_Spacing_Frame.pack(pady=10)

                        # destroy these later
                        widgets = widgets[:] + [C_SVCParameters_Frame,
                                                 C_SVC_ClassifierEvaluation_MainFrame,
                                                 C_SVC_Spacing_Frame]

                        for widget in widgets:
                            widget.pack() # pack them afterwards

                    C_SVC_MainFunc()
          #########################################################
          #########################################################
          #########################################################





          #########################################################
          #########################################################
          #########################################################
                # Call function EmptyFrame if user select
                # '#Nearest Neighbors' from classifiers list.
                if classifier_name ==  'IV. Neighbors':
                    EmptyFrame(WindowOneCanvasFrame, classifier_name)

                # Call function KNearestNeighbors_MainFunc if user select
                # k-Nearest Neighbors from classifiers list.
                if classifier_name == '11: KNeighborsClassifier':

                    def KNearestNeighbors_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def KNearestNeighbors_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            KNN_TrainTestSplit_vs_KFold_Result = KNN_TrainTestSplit_vs_KFold.get()
                            KNN_TrainTestSplit_Scale_Result = KNN_TrainTestSplit_Scale.get()/100
                            KNN_KFold_Result = KNN_KFold.get()

                            # get random_state value
                            if KNN_random_state_int_or_none.get() == "None":
                                KNN_random_state_Result = None
                            else:
                                KNN_random_state_Result = KNN_random_state.get()

                            KNN_Metric_Result = KNN_Metric.get() # get metric value
                            KNN_Weights_Result = KNN_Weights.get() # get weights value
                            KNN_Algorithm_Result = KNN_Algorithm.get() # get Algorithm value
                            KNN_NNeighbors_Result = KNN_NNeighbors.get() # get n_neighbors value
                            KNN_LeafSize_Result = KNN_LeafSize.get() # get leaf_size value
                            KNN_NJobs_Result = KNN_NJobs.get() # get n_jobs value
                            KNN_P_Result = KNN_P.get() # get p value

                            CallClassifier = KNeighborsClassifier(
                                            n_neighbors = KNN_NNeighbors_Result,
                                            weights = KNN_Weights_Result,
                                            algorithm = KNN_Algorithm_Result,
                                            leaf_size = KNN_LeafSize_Result,
                                            p = KNN_P_Result,
                                            metric = KNN_Metric_Result,
                                            metric_params = None,
                                            n_jobs = KNN_NJobs_Result)



                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "random_state = "+str(KNN_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "metric = "+ str(KNN_Metric_Result),
                                                            "weights = "+ str(KNN_Weights_Result),
                                                            "algorithm = "+ str(KNN_Algorithm_Result),
                                                            "n_neighbors = " + str(KNN_NNeighbors_Result),
                                                            "leaf_size = "+ str(KNN_LeafSize_Result),
                                                            "n_jobs = "+str(KNN_NJobs_Result),
                                                            "p = "+str(KNN_P_Result),
                                                            "metric_params = "+str(None))


                                    KNN_Classifier_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if KNN_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = KNN_TrainTestSplit_Scale_Result, test_size = 1-KNN_TrainTestSplit_Scale_Result, random_state= KNN_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if KNN_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = KNN_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = KNN_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])




              ###########################################

                        # This frame contain all K-nearest neighbors classifier
                        # parameters including classifier discription.
                        KNearestNeighborsParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2gM3Tet")

                        SelectedClassifier_and_Link_Frame = tk.Frame(KNearestNeighborsParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"Neighbors-based classification is a "+
                                       "non-generalizing learning: it does not"+
                                       " attempt to construct a general internal"+
                                       " model, but simply stores instances of "+
                                       "the training data. KNeighborsClassifier "+
                                       "implements learning based on the k nearest "+
                                       "neighbors of each query point, where k "+
                                       "is an integer value specified by the user.\"")
                        tk.Label(KNearestNeighborsParameters_Frame, text = discription, wraplength=1200, bg = "white").pack(anchor="c", pady=10)
                                        ###################
                                        ###################

                        # add space on the left
                        tk.Label(KNearestNeighborsParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =75)


                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        KNN_TrainTestSplit_vs_KFold_Frame=tk.Frame(KNearestNeighborsParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        KNN_TrainTestSplit_Frame = tk.Frame(KNN_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        KNN_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(KNN_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = KNN_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        KNN_TrainTestSplit_vs_KFold.set(1)
                        KNN_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(KNN_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = KNN_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        KNN_TrainTestSplit_Scale.set(75)
                        KNN_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        KNN_KFold_frame = tk.Frame(KNN_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(KNN_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = KNN_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        KNN_KFold= IntVar()
                        tk.Spinbox(KNN_KFold_frame, textvariable = KNN_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        KNN_KFold.set(10)
                        KNN_KFold_frame.pack(side="top",anchor ="w")

                        KNN_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                        #######################################################

                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        KNN_random_state_int_or_none_frame = tk.Frame(KNearestNeighborsParameters_Frame, bg = "white")

                        tk.Label(KNN_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        KNN_random_state_int_frame = tk.Frame(KNN_random_state_int_or_none_frame, bg = "white")
                        KNN_random_state_int_or_none = StringVar()
                        tk.Radiobutton(KNN_random_state_int_frame, text="Integer: ", font = FONT_12, variable = KNN_random_state_int_or_none, value = 1, justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        KNN_random_state_int_or_none.set("None")
                        KNN_random_state = IntVar()
                        tk.Spinbox(KNN_random_state_int_frame, textvariable = KNN_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        KNN_random_state.set(0)
                        KNN_random_state_int_frame.pack(anchor ="n")

                        KNN_random_state_none_frame = tk.Frame(KNN_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(KNN_random_state_none_frame, text="None", font = FONT_12, variable = KNN_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(KNN_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        KNN_random_state_none_frame.pack(side="left",anchor ="s")

                        KNN_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        KNN_Algorithm_metric_weights_Frame = tk.Frame(KNearestNeighborsParameters_Frame, bg = "white")

                        if sys.platform == "linux": 
                            algorithm= "algorithm:"
                            weights="weights:   "
                            metric="metric:      "
                            p="p:          "
                            leaf_size="leaf_size:     "


                        elif sys.platform == "win64" or sys.platform == "win32":
                            algorithm= "algorithm:"
                            weights="weights:  "
                            metric="metric:    "
                            p="p:        "
                            leaf_size="leaf_size:    "
                        else:
                            algorithm= "algorithm:"
                            weights="weights:   "
                            metric="metric:     "
                            p="p:         "
                            leaf_size="leaf_size:     "
                        # declare algorithm parameter
                        KNN_Algorithm_Frame = tk.Frame(KNN_Algorithm_metric_weights_Frame, bg = "white")
                        tk.Label(KNN_Algorithm_Frame, text=algorithm, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        KNN_Algorithm = StringVar()
                        KNN_Algorithm.set("auto")
                        tk.OptionMenu(KNN_Algorithm_Frame, KNN_Algorithm, "auto", "ball_tree", "kd_tree", "brute").pack(side="right",anchor ="c")
                        KNN_Algorithm_Frame.pack(side= "top",anchor ="w")
                    
                        # declare weights parameter
                        KNN_Weights_Frame = tk.Frame(KNN_Algorithm_metric_weights_Frame, bg = "white")
                        tk.Label(KNN_Weights_Frame,text=weights, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left", anchor="c")
                        KNN_Weights = StringVar()
                        KNN_Weights.set("uniform")
                        tk.OptionMenu(KNN_Weights_Frame, KNN_Weights, "uniform", "distance").pack(side="right",anchor ="c")
                        KNN_Weights_Frame.pack(side= "top",anchor ="w")

                        # declare metric parameter
                        KNN_Metric_Frame = tk.Frame(KNN_Algorithm_metric_weights_Frame, bg = "white")
                        tk.Label(KNN_Metric_Frame, text=metric, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        KNN_Metric = StringVar()
                        KNN_Metric.set("minkowski")
                        tk.OptionMenu(KNN_Metric_Frame, KNN_Metric, "minkowski", "manhattan", "chebyshev", "euclidean").pack(side="right",anchor ="c")
                        KNN_Metric_Frame.pack(side= "top",anchor ="w")

                        KNN_Algorithm_metric_weights_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        KNN_NNeighbors_leaf_size_Frame = tk.Frame(KNearestNeighborsParameters_Frame, bg = "white")

                        # declare n_neighbors parameter
                        KNN_NNeighbors_Frame = tk.Frame(KNN_NNeighbors_leaf_size_Frame, bg = "white")
                        tk.Label(KNN_NNeighbors_Frame, text="n-neighbors:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left", anchor="c")
                        KNN_NNeighbors = IntVar()
                        tk.Spinbox(KNN_NNeighbors_Frame, textvariable = KNN_NNeighbors, from_=1, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        KNN_NNeighbors.set(5)
                        KNN_NNeighbors_Frame.pack(side= "top",anchor ="w")

                        # declare leaf_size parameter
                        KNN_LeafSize_Frame = tk.Frame(KNN_NNeighbors_leaf_size_Frame, bg = "white")
                        tk.Label(KNN_LeafSize_Frame, text=leaf_size, font=FONT_12,fg = 'SteelBlue3', bg = "white").pack(side="left", anchor="c")
                        KNN_LeafSize = IntVar()
                        tk.Spinbox(KNN_LeafSize_Frame, textvariable = KNN_LeafSize, from_=-sys.maxsize,  to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        KNN_LeafSize.set(30)
                        KNN_LeafSize_Frame.pack(side= "top",anchor ="w")

                        KNN_NNeighbors_leaf_size_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        KNN_n_jobs_p_Frame = tk.Frame(KNearestNeighborsParameters_Frame, bg = "white")

                        # declare n_jobs parameter
                        KNN_NJobs_Frame = tk.Frame(KNN_n_jobs_p_Frame, bg = "white")
                        tk.Label(KNN_NJobs_Frame, text="n_jobs:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left", anchor="c")
                        KNN_NJobs=IntVar()
                        tk.Spinbox(KNN_NJobs_Frame, textvariable = KNN_NJobs, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        KNN_NJobs.set(1)
                        KNN_NJobs_Frame.pack(side= "top",anchor ="w")

                        # declare p parameter
                        KNN_P_Frame = tk.Frame(KNN_n_jobs_p_Frame, bg = "white")
                        tk.Label(KNN_P_Frame, text=p, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left", anchor="c")
                        KNN_P = IntVar()
                        tk.Spinbox(KNN_P_Frame, textvariable = KNN_P, from_=-sys.maxsize,  to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        KNN_P.set(2)
                        KNN_P_Frame.pack(side= "top",anchor ="w")

                        KNN_n_jobs_p_Frame.pack(side= "left",anchor ="n",padx =10)


                        KNearestNeighborsParameters_Frame.pack(anchor ="c")


              ###########################################
                        # declare KNN classifier Result
                        KNearestNeighbors_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(KNearestNeighbors_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = KNearestNeighbors_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(KNearestNeighbors_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = KNearestNeighbors_SubFunc).pack(anchor="c", pady=18)
                        else:
                            ttk.Button(KNearestNeighbors_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = KNearestNeighbors_SubFunc).pack(anchor="c", pady=16)

                        KNearestNeighborsSelectedParameters_Frame = tk.Frame(KNearestNeighbors_ClassifierEvaluation_MainFrame, bg = "white")
                        KNN_Classifier_Result = StringVar()
                        tk.Label(KNearestNeighborsSelectedParameters_Frame, textvariable = KNN_Classifier_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        KNN_Classifier_Result.set("")
                        KNearestNeighborsSelectedParameters_Frame.pack(anchor="c")


                                        ###################
                                        ###################

                        KNearestNeighbors_output_MainFrame = ttk.Frame(KNearestNeighbors_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        KNearestNeighbors_ModelEvaluationStatistics_Frame = ttk.Frame(KNearestNeighbors_output_MainFrame,padding=(10, 10, 10, 10))

                        KNearestNeighbors_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(KNearestNeighbors_ModelEvaluationStatistics_Frame)
                        ttk.Label(KNearestNeighbors_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            KNearestNeighbors_ModelEvaluationStatistics_Listbox = tk.Listbox(KNearestNeighbors_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            KNearestNeighbors_ModelEvaluationStatistics_Listbox = tk.Listbox(KNearestNeighbors_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            KNearestNeighbors_ModelEvaluationStatistics_Listbox = tk.Listbox(KNearestNeighbors_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        


                        # add vertical scrollbar to list
                        KNearestNeighbors_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(KNearestNeighbors_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = KNearestNeighbors_ModelEvaluationStatistics_Listbox.yview, width=10)
                        KNearestNeighbors_ModelEvaluationStatistics_Listbox.config(yscrollcommand = KNearestNeighbors_ModelEvaluationStatistics_Scrollbar_v.set)
                        KNearestNeighbors_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        KNearestNeighbors_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(KNearestNeighbors_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = KNearestNeighbors_ModelEvaluationStatistics_Listbox.xview, width=10)
                        KNearestNeighbors_ModelEvaluationStatistics_Listbox.config(xscrollcommand = KNearestNeighbors_ModelEvaluationStatistics_Scrollbar_h.set)
                        KNearestNeighbors_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        KNearestNeighbors_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        KNearestNeighbors_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(KNearestNeighbors_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        KNearestNeighbors_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(KNearestNeighbors_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        KNearestNeighbors_IdActualPredicted_Frame = ttk.Frame(KNearestNeighbors_output_MainFrame,padding=(14, 10, 10, 10))

                        KNearestNeighbors_IdActualPredicted_Listbox_Frame = ttk.Frame(KNearestNeighbors_IdActualPredicted_Frame)
                        ttk.Label(KNearestNeighbors_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            KNearestNeighbors_IdActualPredicted_Listbox = tk.Listbox(KNearestNeighbors_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            KNearestNeighbors_IdActualPredicted_Listbox = tk.Listbox(KNearestNeighbors_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            KNearestNeighbors_IdActualPredicted_Listbox = tk.Listbox(KNearestNeighbors_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        KNearestNeighbors_IdActualPredicted_Scrollbar_v = tk.Scrollbar(KNearestNeighbors_IdActualPredicted_Listbox_Frame, orient = "vertical", command = KNearestNeighbors_IdActualPredicted_Listbox.yview, width=10)
                        KNearestNeighbors_IdActualPredicted_Listbox.config(yscrollcommand = KNearestNeighbors_IdActualPredicted_Scrollbar_v.set)
                        KNearestNeighbors_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        KNearestNeighbors_IdActualPredicted_Scrollbar_h = tk.Scrollbar(KNearestNeighbors_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = KNearestNeighbors_IdActualPredicted_Listbox.xview, width=10)
                        KNearestNeighbors_IdActualPredicted_Listbox.config(xscrollcommand = KNearestNeighbors_IdActualPredicted_Scrollbar_h.set)
                        KNearestNeighbors_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        KNearestNeighbors_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        KNearestNeighbors_IdActualPredicted_Listbox_Frame.pack(anchor="n")                          

                        # output id - actual - predicted button
                        ttk.Button(KNearestNeighbors_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        KNearestNeighbors_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(KNearestNeighbors_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        KNearestNeighbors_TestingResults_Frame = ttk.Frame(KNearestNeighbors_output_MainFrame,padding=(14, 10, 10, 10))

                        KNearestNeighbors_TestingResults_Listbox_Frame = ttk.Frame(KNearestNeighbors_TestingResults_Frame)
                        ttk.Label(KNearestNeighbors_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            KNearestNeighbors_TestingResults_Listbox = tk.Listbox(KNearestNeighbors_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            KNearestNeighbors_TestingResults_Listbox = tk.Listbox(KNearestNeighbors_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            KNearestNeighbors_TestingResults_Listbox = tk.Listbox(KNearestNeighbors_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        KNearestNeighbors_TestingResults_Scrollbar_v = tk.Scrollbar(KNearestNeighbors_TestingResults_Listbox_Frame, orient = "vertical", command = KNearestNeighbors_TestingResults_Listbox.yview, width=10)
                        KNearestNeighbors_TestingResults_Listbox.config(yscrollcommand = KNearestNeighbors_TestingResults_Scrollbar_v.set)
                        KNearestNeighbors_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
            
                        # add vertical scrollbar to list
                        KNearestNeighbors_TestingResults_Scrollbar_h = tk.Scrollbar(KNearestNeighbors_TestingResults_Listbox_Frame, orient = "horizontal", command = KNearestNeighbors_TestingResults_Listbox.xview, width=10)
                        KNearestNeighbors_TestingResults_Listbox.config(xscrollcommand = KNearestNeighbors_TestingResults_Scrollbar_h.set)
                        KNearestNeighbors_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        KNearestNeighbors_TestingResults_Listbox.pack(expand=True, fill="both")
                        KNearestNeighbors_TestingResults_Listbox_Frame.pack(anchor="n")                              

                        # output testing results
                        ttk.Button(KNearestNeighbors_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        KNearestNeighbors_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        KNearestNeighbors_output_MainFrame.pack()

                                        ###################
                                        ###################


                        KNearestNeighbors_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################
              
                        if sys.platform == "linux": 
                            KNN_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(KNN_Spacing_Frame, bg = "white").pack()
                            KNN_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            KNN_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(KNN_Spacing_Frame, bg = "white").pack()
                            KNN_Spacing_Frame.pack(pady=14)
                        else:
                            KNN_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(KNN_Spacing_Frame, bg = "white").pack()
                            KNN_Spacing_Frame.pack(pady=14)

                        # destroy these later
                        widgets = widgets[:] + [KNearestNeighborsParameters_Frame,
                                                KNearestNeighbors_ClassifierEvaluation_MainFrame,
                                                KNN_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    KNearestNeighbors_MainFunc()
          #########################################################
          #########################################################
          #########################################################




          #########################################################
          #########################################################
          #########################################################

                # Call function RNN_MainFunc if user select Radius-Nearest
                # Neighbors from classifiers list.
                if classifier_name == '12: NearestCentroid':

                    def NearestCentroid_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def NearestCentroid_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            NC_TrainTestSplit_vs_KFold_Result = NC_TrainTestSplit_vs_KFold.get()
                            NC_TrainTestSplit_Scale_Result = NC_TrainTestSplit_Scale.get()/100
                            NC_KFold_Result = NC_KFold.get()

                            # get random_state value
                            if NC_random_state_int_or_none.get() == "None":
                                NC_random_state_Result = None
                            else:
                                NC_random_state_Result = NC_random_state.get()

                            NC_Metric_Result =  NC_Metric.get()

                            # get outlier value
                            if NC_shrink_threshold_float_or_none.get() == "None":
                                NC_shrink_threshold_Result = None
                            else:
                                NC_shrink_threshold_Result = NC_shrink_threshold.get()

                            CallClassifier = NearestCentroid(
                                                            metric = NC_Metric_Result,
                                                            shrink_threshold = NC_shrink_threshold_Result)


                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "random_state = "+str(NC_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "metric = " +str(NC_Metric_Result),
                                                            "shrink_threshold = " +str(NC_shrink_threshold_Result))


                                    NearestCentroid_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if NC_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = NC_TrainTestSplit_Scale_Result, test_size = 1-NC_TrainTestSplit_Scale_Result, random_state=NC_random_state_Result, shuffle=True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if NC_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = NC_random_state_Result)
                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = NC_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])



              ###########################################

                        # This frame contain all Radius-Nearest Neighbors
                        # classifier parameters including classifier discription.
                        NC_Parameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2gHztq9")

                        SelectedClassifier_and_Link_Frame = tk.Frame(NC_Parameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"The NearestCentroid classifier is a "+
                                       "simple algorithm that represents each "+
                                       "class by the centroid of its members."+
                                       " It also has no parameters to choose, "+
                                       "making it a good baseline classifier.\"")
                        tk.Label(NC_Parameters_Frame, text = discription, wraplength=800, bg = "white").pack(anchor="c", pady=10)

                        # add space on the left
                        tk.Label(NC_Parameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =43)


                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        NC_TrainTestSplit_vs_KFold_Frame=tk.Frame(NC_Parameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        NC_TrainTestSplit_Frame = tk.Frame(NC_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        NC_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(NC_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = NC_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        NC_TrainTestSplit_vs_KFold.set(1)
                        NC_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(NC_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = NC_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        NC_TrainTestSplit_Scale.set(75)
                        NC_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        NC_KFold_frame = tk.Frame(NC_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(NC_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = NC_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        NC_KFold= IntVar()
                        tk.Spinbox(NC_KFold_frame, textvariable = NC_KFold, from_=-sys.maxsize,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        NC_KFold.set(10)
                        NC_KFold_frame.pack(side="top",anchor ="w")

                        NC_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        NC_random_state_int_or_none_frame = tk.Frame(NC_Parameters_Frame, bg = "white")

                        tk.Label(NC_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        NC_random_state_int_frame = tk.Frame(NC_random_state_int_or_none_frame, bg = "white")
                        NC_random_state_int_or_none = StringVar()
                        tk.Radiobutton(NC_random_state_int_frame, text="Integer: ", font = FONT_12, variable = NC_random_state_int_or_none, value = 1, justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        NC_random_state_int_or_none.set("None")
                        NC_random_state = IntVar()
                        tk.Spinbox(NC_random_state_int_frame, textvariable = NC_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        NC_random_state.set(0)
                        NC_random_state_int_frame.pack(anchor ="n")

                        NC_random_state_none_frame = tk.Frame(NC_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(NC_random_state_none_frame, text="None", font = FONT_12, variable = NC_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(NC_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        NC_random_state_none_frame.pack(side="left",anchor ="s")

                        NC_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################



                        # declare metric parameter
                        NC_Metric_Frame = tk.Frame(NC_Parameters_Frame, bg = "white")
                        tk.Label(NC_Metric_Frame, text="metric:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        NC_Metric = StringVar()
                        NC_Metric.set("euclidean")
                        tk.OptionMenu(NC_Metric_Frame, NC_Metric, "manhattan", "euclidean").pack(anchor ="c")
                        NC_Metric_Frame.pack(side= "left", anchor ="n", padx =10)



                        # declare shrink_threshold parameter, float or None, optional (default=None)
                        NC_shrink_threshold_float_or_none_frame = tk.Frame(NC_Parameters_Frame, bg = "white")

                        tk.Label(NC_shrink_threshold_float_or_none_frame, text="shrink_threshold:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        NC_shrink_threshold_float_frame = tk.Frame(NC_shrink_threshold_float_or_none_frame, bg = "white")
                        NC_shrink_threshold_float_or_none = StringVar()
                        tk.Radiobutton(NC_shrink_threshold_float_frame, text="Float: ", font = FONT_12, variable = NC_shrink_threshold_float_or_none, value = "Float", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        NC_shrink_threshold_float_or_none.set("None")
                        NC_shrink_threshold = IntVar()
                        tk.Spinbox(NC_shrink_threshold_float_frame, textvariable = NC_shrink_threshold, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        NC_shrink_threshold.set(0)
                        NC_shrink_threshold_float_frame.pack(anchor ="n")

                        NC_outlier_label_none_frame = tk.Frame(NC_shrink_threshold_float_or_none_frame, bg = "white")
                        tk.Radiobutton(NC_outlier_label_none_frame, text="None", font = FONT_12, variable = NC_shrink_threshold_float_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(NC_outlier_label_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        NC_outlier_label_none_frame.pack(side="left",anchor ="s")

                        NC_shrink_threshold_float_or_none_frame.pack(side= "left",anchor ="n",padx =10)



                        NC_Parameters_Frame.pack(anchor ="c")



              ###########################################
                        # declare Radius-Nearest Neighbors classifier Result
                        NC_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(NC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = NearestCentroid_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(NC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = NearestCentroid_SubFunc).pack(anchor="c", pady=19)
                        else:
                            ttk.Button(NC_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = NearestCentroid_SubFunc).pack(anchor="c", pady=24)

                        NCSelectedParameters_Frame = tk.Frame(NC_ClassifierEvaluation_MainFrame, bg = "white")
                        NearestCentroid_Result = StringVar()
                        tk.Label(NCSelectedParameters_Frame, textvariable = NearestCentroid_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        NearestCentroid_Result.set("")
                        NCSelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################

                        NC_output_MainFrame = ttk.Frame(NC_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        NC_ModelEvaluationStatistics_Frame = ttk.Frame(NC_output_MainFrame,padding=(10, 10, 10, 10))

                        NC_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(NC_ModelEvaluationStatistics_Frame)
                        ttk.Label(NC_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            NC_ModelEvaluationStatistics_Listbox = tk.Listbox(NC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            NC_ModelEvaluationStatistics_Listbox = tk.Listbox(NC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            NC_ModelEvaluationStatistics_Listbox = tk.Listbox(NC_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        NC_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(NC_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = NC_ModelEvaluationStatistics_Listbox.yview, width=10)
                        NC_ModelEvaluationStatistics_Listbox.config(yscrollcommand = NC_ModelEvaluationStatistics_Scrollbar_v.set)
                        NC_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        NC_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(NC_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = NC_ModelEvaluationStatistics_Listbox.xview, width=10)
                        NC_ModelEvaluationStatistics_Listbox.config(xscrollcommand = NC_ModelEvaluationStatistics_Scrollbar_h.set)
                        NC_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        NC_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        NC_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(NC_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        NC_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(NC_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        NC_IdActualPredicted_Frame = ttk.Frame(NC_output_MainFrame,padding=(14, 10, 10, 10))

                        NC_IdActualPredicted_Listbox_Frame = ttk.Frame(NC_IdActualPredicted_Frame)
                        ttk.Label(NC_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            NC_IdActualPredicted_Listbox = tk.Listbox(NC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            NC_IdActualPredicted_Listbox = tk.Listbox(NC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            NC_IdActualPredicted_Listbox = tk.Listbox(NC_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        NC_IdActualPredicted_Scrollbar_v = tk.Scrollbar(NC_IdActualPredicted_Listbox_Frame, orient = "vertical", command = NC_IdActualPredicted_Listbox.yview, width=10)
                        NC_IdActualPredicted_Listbox.config(yscrollcommand = NC_IdActualPredicted_Scrollbar_v.set)
                        NC_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        NC_IdActualPredicted_Scrollbar_h = tk.Scrollbar(NC_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = NC_IdActualPredicted_Listbox.xview, width=10)
                        NC_IdActualPredicted_Listbox.config(xscrollcommand = NC_IdActualPredicted_Scrollbar_h.set)
                        NC_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        NC_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        NC_IdActualPredicted_Listbox_Frame.pack(anchor="n")                             

                        # output id - actual - predicted button
                        ttk.Button(NC_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        NC_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(NC_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        NC_TestingResults_Frame = ttk.Frame(NC_output_MainFrame,padding=(14, 10, 10, 10))

                        NC_TestingResults_Listbox_Frame = ttk.Frame(NC_TestingResults_Frame)
                        ttk.Label(NC_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            NC_TestingResults_Listbox = tk.Listbox(NC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            NC_TestingResults_Listbox = tk.Listbox(NC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            NC_TestingResults_Listbox = tk.Listbox(NC_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        NC_TestingResults_Scrollbar_v = tk.Scrollbar(NC_TestingResults_Listbox_Frame, orient = "vertical", command = NC_TestingResults_Listbox.yview, width=10)
                        NC_TestingResults_Listbox.config(yscrollcommand = NC_TestingResults_Scrollbar_v.set)
                        NC_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
            
                        # add vertical scrollbar to list
                        NC_TestingResults_Scrollbar_h = tk.Scrollbar(NC_TestingResults_Listbox_Frame, orient = "horizontal", command = NC_TestingResults_Listbox.xview, width=10)
                        NC_TestingResults_Listbox.config(xscrollcommand = NC_TestingResults_Scrollbar_h.set)
                        NC_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        NC_TestingResults_Listbox.pack(expand=True, fill="both")
                        NC_TestingResults_Listbox_Frame.pack(anchor="n")  

                        # output testing results
                        ttk.Button(NC_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        NC_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        NC_output_MainFrame.pack()

                                        ###################
                                        ###################


                        NC_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            NC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(NC_Spacing_Frame, bg = "white").pack()
                            NC_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            NC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(NC_Spacing_Frame, bg = "white").pack()
                            NC_Spacing_Frame.pack(pady=13)
                        else:
                            NC_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(NC_Spacing_Frame, bg = "white").pack()
                            NC_Spacing_Frame.pack(pady=14)


                        # destroy these later
                        widgets = widgets[:] + [NC_Parameters_Frame,
                                                NC_ClassifierEvaluation_MainFrame,
                                                NC_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    NearestCentroid_MainFunc()
          #########################################################
          #########################################################
          #########################################################






          #########################################################
          #########################################################
          #########################################################

                # Call function RNN_MainFunc if user select Radius-Nearest
                # Neighbors from classifiers list.
                if classifier_name == '13: RadiusNeighborsClassifier':

                    def RNN_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def RNN_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            RNN_TrainTestSplit_vs_KFold_Result = RNN_TrainTestSplit_vs_KFold.get()
                            RNN_TrainTestSplit_Scale_Result = RNN_TrainTestSplit_Scale.get()/100
                            RNN_KFold_Result = RNN_KFold.get()

                            # get random_state value
                            if RNN_random_state_int_or_none.get() == "None":
                                RNN_random_state_Result = None
                            else:
                                RNN_random_state_Result = RNN_random_state.get()

                            RNN_radius_Result = RNN_radius.get()
                            RNN_weights_Result = RNN_Weights.get()
                            RNN_Algorithm_Result = RNN_Algorithm.get()
                            RNN_LeafSize_Result = RNN_LeafSize.get()
                            RNN_P_Result = RNN_P.get()
                            RNN_Metric_Result =  RNN_Metric.get()

                            # get outlier value
                            if RNN_outlier_label_int_or_none.get() == "None":
                                RNN_outlier_label_Result = None
                            else:
                                RNN_outlier_label_Result = RNN_outlier_label.get()

                            CallClassifier = RadiusNeighborsClassifier(
                                                            radius = RNN_radius_Result,
                                                            weights = RNN_weights_Result,
                                                            algorithm = RNN_Algorithm_Result,
                                                            leaf_size = RNN_LeafSize_Result,
                                                            p = RNN_P_Result,
                                                            metric = RNN_Metric_Result,
                                                            outlier_label = RNN_outlier_label_Result,
                                                            metric_params = None)



                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "random_state = "+str(RNN_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "metric = " +str(RNN_Metric_Result),
                                                            "weights = " +str(RNN_weights_Result),
                                                            "algorithm = " +str(RNN_Algorithm_Result),
                                                            "outlier_label = " +str(RNN_outlier_label_Result),
                                                            "radius = "+str(RNN_radius_Result),
                                                            "leaf_size = " +str(RNN_LeafSize_Result),
                                                            "p = " +str(RNN_P_Result),
                                                            "metric_params = " +str(None))


                                    RNN_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if RNN_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = RNN_TrainTestSplit_Scale_Result, test_size = 1-RNN_TrainTestSplit_Scale_Result, random_state= RNN_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if RNN_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = RNN_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = RNN_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])


              ###########################################

                        # This frame contain all Radius-Nearest Neighbors
                        # classifier parameters including classifier discription.
                        RNNParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2gGFqn6")

                        SelectedClassifier_and_Link_Frame = tk.Frame(RNNParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"Neighbors-based classification is a "+
                                       "non-generalizing learning: it does not"+
                                       " attempt to construct a general internal"+
                                       " model, but simply stores instances of "+
                                       "the training data. RadiusNeighborsClassifier "+
                                       "implements learning based on the number"+
                                       " of neighbors within a fixed radius r "+
                                       "of each training point.\"")
                        tk.Label(RNNParameters_Frame, text = discription, wraplength=1100, bg = "white").pack(anchor="c", pady=10)

                        # add space on the left
                        tk.Label(RNNParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =48)


                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        RNN_TrainTestSplit_vs_KFold_Frame=tk.Frame(RNNParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        RNN_TrainTestSplit_Frame = tk.Frame(RNN_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        RNN_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(RNN_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = RNN_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        RNN_TrainTestSplit_vs_KFold.set(1)
                        RNN_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(RNN_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = RNN_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        RNN_TrainTestSplit_Scale.set(75)
                        RNN_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        RNN_KFold_frame = tk.Frame(RNN_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(RNN_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = RNN_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        RNN_KFold= IntVar()
                        tk.Spinbox(RNN_KFold_frame, textvariable = RNN_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        RNN_KFold.set(10)
                        RNN_KFold_frame.pack(side="top",anchor ="w")

                        RNN_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # frame that contains all other parameters starts here.
                        #######################################################
                        # declare random_state parameter, int or None, optional (default=None)
                        RNN_random_state_int_or_none_frame = tk.Frame(RNNParameters_Frame, bg = "white")

                        tk.Label(RNN_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        RNN_random_state_int_frame = tk.Frame(RNN_random_state_int_or_none_frame, bg = "white")
                        RNN_random_state_int_or_none = StringVar()
                        tk.Radiobutton(RNN_random_state_int_frame, text="Integer: ", font = FONT_12, variable = RNN_random_state_int_or_none, value = 1, justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        RNN_random_state_int_or_none.set("None")
                        RNN_random_state = IntVar()
                        tk.Spinbox(RNN_random_state_int_frame, textvariable = RNN_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        RNN_random_state.set(0)
                        RNN_random_state_int_frame.pack(anchor ="n")

                        RNN_random_state_none_frame = tk.Frame(RNN_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(RNN_random_state_none_frame, text="None", font = FONT_12, variable = RNN_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(RNN_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        RNN_random_state_none_frame.pack(side="left",anchor ="s")

                        RNN_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################



                        RNN_Algorithm_metric_weights_algorithm_Frame = tk.Frame(RNNParameters_Frame, bg = "white")

                        if sys.platform == "linux": 
                            algorithm= "algorithm:"
                            weights="weights:   "
                            metric="metric:      "
                        elif sys.platform == "win64" or sys.platform == "win32":
                            algorithm= "algorithm:"
                            weights="weights:  "
                            metric="metric:    "
                        else:
                            algorithm= "algorithm:"
                            weights="weights:   "
                            metric="metric:     "                            

                        # declare algorithm parameter
                        RNN_Algorithm_Frame = tk.Frame(RNN_Algorithm_metric_weights_algorithm_Frame, bg = "white")
                        tk.Label(RNN_Algorithm_Frame, text=algorithm, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        RNN_Algorithm = StringVar()
                        RNN_Algorithm.set("auto")
                        tk.OptionMenu(RNN_Algorithm_Frame, RNN_Algorithm, "auto", "ball_tree", "kd_tree", "brute").pack(side="right",anchor ="c")
                        RNN_Algorithm_Frame.pack(side= "top",anchor ="w")

                        # declare weights parameter
                        RNN_weights_Frame = tk.Frame(RNN_Algorithm_metric_weights_algorithm_Frame, bg = "white")
                        tk.Label(RNN_weights_Frame,         text=weights, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left", anchor="c")
                        RNN_Weights = StringVar()
                        RNN_Weights.set("uniform")
                        tk.OptionMenu(RNN_weights_Frame, RNN_Weights, "uniform", "distance").pack(side="right",anchor ="c")
                        RNN_weights_Frame.pack(side= "top",anchor ="w")

                        # declare metric parameter
                        RNN_Metric_Frame = tk.Frame(RNN_Algorithm_metric_weights_algorithm_Frame, bg = "white")
                        tk.Label(RNN_Metric_Frame, text=metric, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor="c")
                        RNN_Metric = StringVar()
                        RNN_Metric.set("minkowski")
                        tk.OptionMenu(RNN_Metric_Frame, RNN_Metric, "minkowski", "manhattan", "chebyshev", "euclidean").pack(side="right",anchor ="c")
                        RNN_Metric_Frame.pack(side= "top",anchor ="w")

                        RNN_Algorithm_metric_weights_algorithm_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare outlier_label parameter, int or None, optional (default=None)
                        RNN_outlier_label_int_or_none_frame = tk.Frame(RNNParameters_Frame, bg = "white")

                        tk.Label(RNN_outlier_label_int_or_none_frame, text="outlier_label:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        RNN_outlier_label_int_frame = tk.Frame(RNN_outlier_label_int_or_none_frame, bg = "white")
                        RNN_outlier_label_int_or_none = StringVar()
                        tk.Radiobutton(RNN_outlier_label_int_frame, text="Integer: ", font = FONT_12, variable = RNN_outlier_label_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        RNN_outlier_label_int_or_none.set("None")
                        RNN_outlier_label = IntVar()
                        tk.Spinbox(RNN_outlier_label_int_frame, textvariable = RNN_outlier_label, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        RNN_outlier_label.set(0)
                        RNN_outlier_label_int_frame.pack(anchor ="n")

                        RNN_outlier_label_none_frame = tk.Frame(RNN_outlier_label_int_or_none_frame, bg = "white")
                        tk.Radiobutton(RNN_outlier_label_none_frame, text="None", font = FONT_12, variable = RNN_outlier_label_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(RNN_outlier_label_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        RNN_outlier_label_none_frame.pack(side="left",anchor ="s")

                        RNN_outlier_label_int_or_none_frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare radius parameter
                        RNN_radius_Frame = tk.Frame(RNNParameters_Frame, bg = "white")
                        tk.Label(RNN_radius_Frame, text="radius:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        RNN_radius = DoubleVar()
                        tk.Spinbox(RNN_radius_Frame, textvariable = RNN_radius, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(anchor ="c")
                        RNN_radius.set(5)
                        RNN_radius_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare leaf_size parameter
                        RNN_LeafSize_Frame = tk.Frame(RNNParameters_Frame, bg = "white")
                        tk.Label(RNN_LeafSize_Frame, text="leaf_size:", font=FONT_12,fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        RNN_LeafSize = IntVar()
                        tk.Spinbox(RNN_LeafSize_Frame, textvariable = RNN_LeafSize, from_=-sys.maxsize,  to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(anchor ="c")
                        RNN_LeafSize.set(30)
                        RNN_LeafSize_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare p parameter
                        RNN_P_Frame = tk.Frame(RNNParameters_Frame, bg = "white")
                        tk.Label(RNN_P_Frame, text="p:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        RNN_P = IntVar()
                        tk.Spinbox(RNN_P_Frame, textvariable = RNN_P, from_=3,  to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        RNN_P.set(3)
                        RNN_P_Frame.pack(side= "left",anchor ="n",padx =10)


                        RNNParameters_Frame.pack(anchor ="c")



              ###########################################
                        # declare Radius-Nearest Neighbors classifier Result
                        RNN_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(RNN_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = RNN_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(RNN_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = RNN_SubFunc).pack(anchor="c", pady=19)
                        else:
                            ttk.Button(RNN_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = RNN_SubFunc).pack(anchor="c", pady=16)

                        RNNSelectedParameters_Frame = tk.Frame(RNN_ClassifierEvaluation_MainFrame, bg = "white")
                        RNN_Result = StringVar()
                        tk.Label(RNNSelectedParameters_Frame, textvariable = RNN_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        RNN_Result.set("")
                        RNNSelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################

                        RNN_output_MainFrame = ttk.Frame(RNN_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        RNN_ModelEvaluationStatistics_Frame = ttk.Frame(RNN_output_MainFrame,padding=(10, 10, 10, 10))

                        RNN_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(RNN_ModelEvaluationStatistics_Frame)
                        ttk.Label(RNN_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            RNN_ModelEvaluationStatistics_Listbox = tk.Listbox(RNN_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            RNN_ModelEvaluationStatistics_Listbox = tk.Listbox(RNN_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            RNN_ModelEvaluationStatistics_Listbox = tk.Listbox(RNN_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        RNN_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(RNN_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = RNN_ModelEvaluationStatistics_Listbox.yview, width=10)
                        RNN_ModelEvaluationStatistics_Listbox.config(yscrollcommand = RNN_ModelEvaluationStatistics_Scrollbar_v.set)
                        RNN_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        RNN_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(RNN_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = RNN_ModelEvaluationStatistics_Listbox.xview, width=10)
                        RNN_ModelEvaluationStatistics_Listbox.config(xscrollcommand = RNN_ModelEvaluationStatistics_Scrollbar_h.set)
                        RNN_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        RNN_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        RNN_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(RNN_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        RNN_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(RNN_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        RNN_IdActualPredicted_Frame = ttk.Frame(RNN_output_MainFrame,padding=(14, 10, 10, 10))

                        RNN_IdActualPredicted_Listbox_Frame = ttk.Frame(RNN_IdActualPredicted_Frame)
                        ttk.Label(RNN_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            RNN_IdActualPredicted_Listbox = tk.Listbox(RNN_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            RNN_IdActualPredicted_Listbox = tk.Listbox(RNN_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            RNN_IdActualPredicted_Listbox = tk.Listbox(RNN_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        RNN_IdActualPredicted_Scrollbar_v = tk.Scrollbar(RNN_IdActualPredicted_Listbox_Frame, orient = "vertical", command = RNN_IdActualPredicted_Listbox.yview, width=10)
                        RNN_IdActualPredicted_Listbox.config(yscrollcommand = RNN_IdActualPredicted_Scrollbar_v.set)
                        RNN_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        RNN_IdActualPredicted_Scrollbar_h = tk.Scrollbar(RNN_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = RNN_IdActualPredicted_Listbox.xview, width=10)
                        RNN_IdActualPredicted_Listbox.config(xscrollcommand = RNN_IdActualPredicted_Scrollbar_h.set)
                        RNN_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        RNN_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        RNN_IdActualPredicted_Listbox_Frame.pack(anchor="n")                             
                            

                        # output id - actual - predicted button
                        ttk.Button(RNN_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        RNN_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(RNN_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        RNN_TestingResults_Frame = ttk.Frame(RNN_output_MainFrame,padding=(14, 10, 10, 10))

                        RNN_TestingResults_Listbox_Frame = ttk.Frame(RNN_TestingResults_Frame)
                        ttk.Label(RNN_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            RNN_TestingResults_Listbox = tk.Listbox(RNN_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            RNN_TestingResults_Listbox = tk.Listbox(RNN_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            RNN_TestingResults_Listbox = tk.Listbox(RNN_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        RNN_TestingResults_Scrollbar_v = tk.Scrollbar(RNN_TestingResults_Listbox_Frame, orient = "vertical", command = RNN_TestingResults_Listbox.yview, width=10)
                        RNN_TestingResults_Listbox.config(yscrollcommand = RNN_TestingResults_Scrollbar_v.set)
                        RNN_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
            
                        # add vertical scrollbar to list
                        RNN_TestingResults_Scrollbar_h = tk.Scrollbar(RNN_TestingResults_Listbox_Frame, orient = "horizontal", command = RNN_TestingResults_Listbox.xview, width=10)
                        RNN_TestingResults_Listbox.config(xscrollcommand = RNN_TestingResults_Scrollbar_h.set)
                        RNN_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        RNN_TestingResults_Listbox.pack(expand=True, fill="both")
                        RNN_TestingResults_Listbox_Frame.pack(anchor="n")                             
                            
                        # output testing results
                        ttk.Button(RNN_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        RNN_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        RNN_output_MainFrame.pack()

                                        ###################
                                        ###################


                        RNN_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            RNN_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(RNN_Spacing_Frame, bg = "white").pack()
                            RNN_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            RNN_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(RNN_Spacing_Frame, bg = "white").pack()
                            RNN_Spacing_Frame.pack(pady=13)
                        else:
                            RNN_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(RNN_Spacing_Frame, bg = "white").pack()
                            RNN_Spacing_Frame.pack(pady=14)


                        # destroy these later
                        widgets = widgets[:] + [RNNParameters_Frame,
                                                RNN_ClassifierEvaluation_MainFrame,
                                                RNN_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    RNN_MainFunc()
          #########################################################
          #########################################################
          #########################################################




          #########################################################
          #########################################################
          #########################################################
                # Call function EmptyFrame if user select
                # #Generalized Linear Models from classifiers list.
                if classifier_name ==  "V. Gaussian_process":
                    EmptyFrame(WindowOneCanvasFrame, classifier_name)


                # Call function LogisticRegression_MainFunc if user select
                # LogisticRegression from classifiers list.
                if classifier_name == '14: GaussianProcessClassifier':

                    def GaussianProcess_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################

                        def GaussianProcess_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            GP_TrainTestSplit_vs_KFold_Result = GP_TrainTestSplit_vs_KFold.get()
                            GP_TrainTestSplit_Scale_Result = GP_TrainTestSplit_Scale.get()/100
                            GP_KFold_Result = GP_KFold.get()

                            # get random_state value
                            if GP_random_state_int_or_none.get() == "None":
                                GP_random_state_Result = None
                            else:
                                GP_random_state_Result = GP_random_state.get()

                            # get optimizer value
                            if GP_optimizer.get() == "None":
                                GP_optimizer_Result = None
                            else:
                                GP_optimizer_Result = GP_optimizer.get()

                            GP_multi_class_Result = GP_multi_class.get()
                            GP_n_restarts_optimizer_Result = GP_n_restarts_optimizer.get()
                            GP_max_iter_predict_Result = GP_max_iter_predict.get()
                            GP_n_jobs_Result = GP_n_jobs.get()



                            GP_warm_start_Result = GP_warm_start.get()
                            Gp_copy_X_train_Result = Gp_copy_X_train.get()



                            CallClassifier = GaussianProcessClassifier(
                                                                    kernel=None,
                                                                    optimizer = GP_optimizer_Result,
                                                                    n_restarts_optimizer= GP_n_restarts_optimizer_Result,
                                                                    max_iter_predict= GP_max_iter_predict_Result,
                                                                    warm_start = GP_warm_start_Result,
                                                                    copy_X_train = Gp_copy_X_train_Result,
                                                                    random_state= GP_random_state_Result,
                                                                    multi_class= GP_multi_class_Result,
                                                                    n_jobs= GP_n_jobs_Result)

                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "random_state = "+str(GP_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "optimizer = " + str(GP_optimizer_Result),
                                                            "multi_class = "+str(GP_multi_class_Result),
                                                            "n_restarts_optimizer = "+str(GP_n_restarts_optimizer_Result),
                                                            "max_iter_predict = "+str(GP_max_iter_predict_Result),
                                                            "n_jobs = "+str(GP_n_jobs_Result),
                                                            "warm_start= "+str(GP_warm_start_Result),
                                                            "copy_X_train = "+ str(Gp_copy_X_train_Result),
                                                            "kernel = "+str(None))


                                    GP_Classifier_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if GP_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = GP_TrainTestSplit_Scale_Result, test_size = 1-GP_TrainTestSplit_Scale_Result, random_state = GP_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if GP_TrainTestSplit_vs_KFold_Result == 2:


                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = GP_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = GP_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])



              ###########################################

                        # This frame contain all logistic regression classifier
                        # parameters including classifier discription.
                        GaussianProcessParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2xt2bBC")

                        SelectedClassifier_and_Link_Frame = tk.Frame(GaussianProcessParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################

                        discription = ("\"The GaussianProcessClassifier "+
                                       "implements Gaussian processes (GP) for "+
                                       "classification purposes, more "+
                                       "specifically for probabilistic "+
                                       "classification, where test predictions "+
                                       "take the form of class probabilities.\"")
                        tk.Label(GaussianProcessParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=10)

                        # add space on the left
                        tk.Label(GaussianProcessParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =10)
                                        ###################
                                        ###################


                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        GP_TrainTestSplit_vs_KFold_Frame=tk.Frame(GaussianProcessParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        GP_TrainTestSplit_Frame = tk.Frame(GP_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        GP_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(GP_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = GP_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        GP_TrainTestSplit_vs_KFold.set(1)
                        GP_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(GP_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = GP_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        GP_TrainTestSplit_Scale.set(75)
                        GP_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        GP_KFold_frame = tk.Frame(GP_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(GP_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = GP_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        GP_KFold= IntVar()
                        tk.Spinbox(GP_KFold_frame, textvariable = GP_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        GP_KFold.set(10)
                        GP_KFold_frame.pack(side="top",anchor ="w")

                        GP_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)
                        #######################################################


                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        GP_random_state_int_or_none_frame = tk.Frame(GaussianProcessParameters_Frame, bg = "white")

                        tk.Label(GP_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        GP_random_state_int_frame = tk.Frame(GP_random_state_int_or_none_frame, bg = "white")
                        GP_random_state_int_or_none = StringVar()
                        tk.Radiobutton(GP_random_state_int_frame, text="Integer: ", font = FONT_12, variable = GP_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        GP_random_state_int_or_none.set("None")
                        GP_random_state = IntVar()
                        tk.Spinbox(GP_random_state_int_frame, textvariable = GP_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        GP_random_state.set(0)
                        GP_random_state_int_frame.pack(anchor ="n")

                        GP_random_state_none_frame = tk.Frame(GP_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(GP_random_state_none_frame, text="None", font = FONT_12, variable = GP_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(GP_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        GP_random_state_none_frame.pack(side="left",anchor ="s")

                        GP_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        GP_optimizer_multi_class_Frame = tk.Frame(GaussianProcessParameters_Frame, bg = "white")

                        if sys.platform == "linux": 
                            multi_class= "multi_class:"
                            optimizer="optimizer:     "
                            n_restarts_optimizer="n_restarts_optimizer:"
                            max_iter_predict="max_iter_predict:       "
                            n_jobs="n_jobs:                          "
                            
                        elif sys.platform == "win64" or sys.platform == "win32":
                            multi_class= "multi_class:"
                            optimizer="optimizer:   "
                            n_restarts_optimizer="n_restarts_optimizer:"
                            max_iter_predict="max_iter_predict:      "
                            n_jobs="n_jobs:                    "

                        else:
                            multi_class= "multi_class:"
                            optimizer="optimizer:   "
                            n_restarts_optimizer="n_restarts_optimizer:"
                            max_iter_predict="max_iter_predict:      "
                            n_jobs="n_jobs:                       "

                        # declare multi_class parameter
                        GP_multi_class_Frame = tk.Frame(GP_optimizer_multi_class_Frame, bg = "white")
                        tk.Label(GP_multi_class_Frame, text=multi_class, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        GP_multi_class = StringVar()
                        GP_multi_class.set("one_vs_rest")
                        tk.OptionMenu(GP_multi_class_Frame, GP_multi_class, "one_vs_rest", "one_vs_one").pack(side="right",anchor ="c")
                        GP_multi_class_Frame.pack(side="top",anchor ="w")

                            
                        # declare optimizer, str = fmin_l_bfgs_b or None, default: fmin_l_bfgs_b
                        GP_optimizer_Frame = tk.Frame(GP_optimizer_multi_class_Frame, bg = "white")                                                
                        tk.Label(GP_optimizer_Frame, text=optimizer, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side= "left",anchor ="c")
                        GP_optimizer = StringVar()
                        GP_optimizer.set("fmin_l_bfgs_b")
                        tk.OptionMenu(GP_optimizer_Frame, GP_optimizer, "fmin_l_bfgs_b", "None").pack(side="right",anchor ="c")
                        GP_optimizer_Frame.pack(side="top",anchor ="w")
                        
                        GP_optimizer_multi_class_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # frame contains n_restarts_optimizer, max_iter_predict, and n_jobs parameters
                        GP_n_restarts_optimizer_max_iter_predict_n_jobs_Frame = tk.Frame(GaussianProcessParameters_Frame, bg = "white")

                        # declare n_restarts_optimizer parameter
                        GP_n_restarts_optimizer_Frame = tk.Frame(GP_n_restarts_optimizer_max_iter_predict_n_jobs_Frame, bg = "white")
                        tk.Label(GP_n_restarts_optimizer_Frame, text=n_restarts_optimizer, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        GP_n_restarts_optimizer = IntVar()
                        tk.Spinbox(GP_n_restarts_optimizer_Frame, textvariable = GP_n_restarts_optimizer, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        GP_n_restarts_optimizer.set(0)
                        GP_n_restarts_optimizer_Frame.pack(side="top", anchor ="w")

                        # declare max_iter_predict parameter
                        GP_max_iter_predict_Frame = tk.Frame(GP_n_restarts_optimizer_max_iter_predict_n_jobs_Frame, bg = "white")
                        tk.Label(GP_max_iter_predict_Frame, text=max_iter_predict, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        GP_max_iter_predict = IntVar()
                        tk.Spinbox(GP_max_iter_predict_Frame, textvariable = GP_max_iter_predict,from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        GP_max_iter_predict.set(100)
                        GP_max_iter_predict_Frame.pack(side="top", anchor ="w")

                        # declare n_jobs parameter
                        GP_n_jobs_Frame = tk.Frame(GP_n_restarts_optimizer_max_iter_predict_n_jobs_Frame, bg = "white")
                        tk.Label(GP_n_jobs_Frame, text=n_jobs, font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(side="left",anchor ="c")
                        GP_n_jobs = IntVar()
                        tk.Spinbox(GP_n_jobs_Frame, textvariable = GP_n_jobs, from_=-sys.maxsize, to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right", anchor ="c")
                        GP_n_jobs.set(1)
                        GP_n_jobs_Frame.pack(side="top", anchor ="w")

                        GP_n_restarts_optimizer_max_iter_predict_n_jobs_Frame.pack(side= "left", anchor ="n",padx =10)

                                        ###################
                                        ###################


                        # declare warm_start parameter, bool = default: False
                        GP_warm_start_Frame = tk.Frame(GaussianProcessParameters_Frame, bg = "white")
                        tk.Label(GP_warm_start_Frame, text="warm_start:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        GP_warm_start = BooleanVar()
                        tk.Radiobutton(GP_warm_start_Frame, text= "True", variable = GP_warm_start, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(GP_warm_start_Frame, text= "False", variable = GP_warm_start, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        GP_warm_start.set(False)
                        GP_warm_start_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        # declare copy_X_train parameter, bool = default: True
                        Gp_copy_X_train_Frame = tk.Frame(GaussianProcessParameters_Frame, bg = "white")
                        tk.Label(Gp_copy_X_train_Frame, text="copy_X_train:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        Gp_copy_X_train = BooleanVar()
                        tk.Radiobutton(Gp_copy_X_train_Frame, text= "True", variable = Gp_copy_X_train, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(Gp_copy_X_train_Frame, text= "False", variable = Gp_copy_X_train, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        Gp_copy_X_train.set(True)
                        Gp_copy_X_train_Frame.pack(side= "left",anchor ="n",padx =10)


                        GaussianProcessParameters_Frame.pack(anchor ="c")


              ###########################################

                        # declare Logistic Regression classifier result
                        GaussianProcess_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(GaussianProcess_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = GaussianProcess_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(GaussianProcess_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = GaussianProcess_SubFunc).pack(anchor="c", pady=12)
                        else:
                            ttk.Button(GaussianProcess_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = GaussianProcess_SubFunc).pack(anchor="c", pady=16)

                        GaussianProcessSelectedParameters_Frame = tk.Frame(GaussianProcess_ClassifierEvaluation_MainFrame, bg = "white")
                        GP_Classifier_Result = StringVar()
                        tk.Label(GaussianProcessSelectedParameters_Frame, textvariable = GP_Classifier_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        GP_Classifier_Result.set("")
                        GaussianProcessSelectedParameters_Frame.pack(anchor="c")


                                        ###################
                                        ###################

                        GaussianProcess_output_MainFrame = ttk.Frame(GaussianProcess_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        GaussianProcess_ModelEvaluationStatistics_Frame = ttk.Frame(GaussianProcess_output_MainFrame,padding=(10, 10, 10, 10))

                        GaussianProcess_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(GaussianProcess_ModelEvaluationStatistics_Frame)
                        ttk.Label(GaussianProcess_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            GaussianProcess_ModelEvaluationStatistics_Listbox = tk.Listbox(GaussianProcess_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            GaussianProcess_ModelEvaluationStatistics_Listbox = tk.Listbox(GaussianProcess_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            GaussianProcess_ModelEvaluationStatistics_Listbox = tk.Listbox(GaussianProcess_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        GaussianProcess_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(GaussianProcess_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = GaussianProcess_ModelEvaluationStatistics_Listbox.yview, width=10)
                        GaussianProcess_ModelEvaluationStatistics_Listbox.config(yscrollcommand = GaussianProcess_ModelEvaluationStatistics_Scrollbar_v.set)
                        GaussianProcess_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        GaussianProcess_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(GaussianProcess_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = GaussianProcess_ModelEvaluationStatistics_Listbox.xview, width=10)
                        GaussianProcess_ModelEvaluationStatistics_Listbox.config(xscrollcommand = GaussianProcess_ModelEvaluationStatistics_Scrollbar_h.set)
                        GaussianProcess_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        GaussianProcess_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        GaussianProcess_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(GaussianProcess_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        GaussianProcess_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(GaussianProcess_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # id - actual - predicted
                        GaussianProcess_IdActualPredicted_Frame = ttk.Frame(GaussianProcess_output_MainFrame,padding=(14, 10, 10, 10))

                        GaussianProcess_IdActualPredicted_Listbox_Frame = ttk.Frame(GaussianProcess_IdActualPredicted_Frame)
                        ttk.Label(GaussianProcess_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            GaussianProcess_IdActualPredicted_Listbox = tk.Listbox(GaussianProcess_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            GaussianProcess_IdActualPredicted_Listbox = tk.Listbox(GaussianProcess_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            GaussianProcess_IdActualPredicted_Listbox = tk.Listbox(GaussianProcess_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                        
                        # add vertical scrollbar to list
                        GaussianProcess_IdActualPredicted_Scrollbar_v = tk.Scrollbar(GaussianProcess_IdActualPredicted_Listbox_Frame, orient = "vertical", command = GaussianProcess_IdActualPredicted_Listbox.yview, width=10)
                        GaussianProcess_IdActualPredicted_Listbox.config(yscrollcommand = GaussianProcess_IdActualPredicted_Scrollbar_v.set)
                        GaussianProcess_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        GaussianProcess_IdActualPredicted_Scrollbar_h = tk.Scrollbar(GaussianProcess_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = GaussianProcess_IdActualPredicted_Listbox.xview, width=10)
                        GaussianProcess_IdActualPredicted_Listbox.config(xscrollcommand = GaussianProcess_IdActualPredicted_Scrollbar_h.set)
                        GaussianProcess_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        GaussianProcess_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        GaussianProcess_IdActualPredicted_Listbox_Frame.pack(anchor="n")                         

                        # output id - actual - predicted button
                        ttk.Button(GaussianProcess_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        GaussianProcess_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(GaussianProcess_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        GaussianProcess_TestingResults_Frame = ttk.Frame(GaussianProcess_output_MainFrame,padding=(14, 10, 10, 10))

                        GaussianProcess_TestingResults_Listbox_Frame = ttk.Frame(GaussianProcess_TestingResults_Frame)
                        ttk.Label(GaussianProcess_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            GaussianProcess_TestingResults_Listbox = tk.Listbox(GaussianProcess_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            GaussianProcess_TestingResults_Listbox = tk.Listbox(GaussianProcess_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            GaussianProcess_TestingResults_Listbox = tk.Listbox(GaussianProcess_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        GaussianProcess_TestingResults_Scrollbar_v = tk.Scrollbar(GaussianProcess_TestingResults_Listbox_Frame, orient = "vertical", command = GaussianProcess_TestingResults_Listbox.yview, width=10)
                        GaussianProcess_TestingResults_Listbox.config(yscrollcommand = GaussianProcess_TestingResults_Scrollbar_v.set)
                        GaussianProcess_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
            
                        # add vertical scrollbar to list
                        GaussianProcess_TestingResults_Scrollbar_h = tk.Scrollbar(GaussianProcess_TestingResults_Listbox_Frame, orient = "horizontal", command = GaussianProcess_TestingResults_Listbox.xview, width=10)
                        GaussianProcess_TestingResults_Listbox.config(xscrollcommand = GaussianProcess_TestingResults_Scrollbar_h.set)
                        GaussianProcess_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        GaussianProcess_TestingResults_Listbox.pack(expand=True, fill="both")
                        GaussianProcess_TestingResults_Listbox_Frame.pack(anchor="n")                              
                            

                        # output testing results
                        ttk.Button(GaussianProcess_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        GaussianProcess_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        GaussianProcess_output_MainFrame.pack()

                                        ###################
                                        ###################



                        GaussianProcess_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            GP_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(GP_Spacing_Frame, bg = "white").pack()
                            GP_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            GP_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(GP_Spacing_Frame, bg = "white").pack()
                            GP_Spacing_Frame.pack(pady=13)
                        else:
                            GP_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(GP_Spacing_Frame, bg = "white").pack()
                            GP_Spacing_Frame.pack(pady=14)


                        # destroy these later
                        widgets = widgets[:] + [GaussianProcessParameters_Frame,
                                                GaussianProcess_ClassifierEvaluation_MainFrame,
                                                GP_Spacing_Frame]

                        for widget in widgets:
                            widget.pack() # pack them afterwards

                    GaussianProcess_MainFunc()

          #########################################################
          #########################################################
          #########################################################







          #########################################################
          #########################################################
          #########################################################
                # Call function EmptyFrame if user select
                # '#Naive Bayes' from classifiers list.
                if classifier_name ==  'VI. Naive_bayes':
                    EmptyFrame(WindowOneCanvasFrame, classifier_name)


                # Call function BernoulliNB_MainFunc if user select Bernoulli
                # Naive Bayes from classifiers list.
                if classifier_name == '15: BernoulliNB':

                    def BernoulliNB_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def BernoulliNB_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            BernoulliNB_TrainTestSplit_vs_KFold_Result = BernoulliNB_TrainTestSplit_vs_KFold.get()
                            BernoulliNB_TrainTestSplit_Scale_Result = BernoulliNB_TrainTestSplit_Scale.get()/100
                            BernoulliNB_KFold_Result = BernoulliNB_KFold.get()


                            # get random_state value
                            if BernoulliNB_random_state_int_or_none.get() == "None":
                                BernoulliNB_random_state_Result = None
                            else:
                                BernoulliNB_random_state_Result = BernoulliNB_random_state.get()


                            BernoulliNB_alpha_Result = BernoulliNB_alpha.get() # get alpha value
                            BernoulliNB_fit_prior_Result = BernoulliNB_fit_prior.get() # get fit_prior value

                            # get binarize value
                            if BernoulliNB_binarize_float_or_none.get() == "None":
                                BernoulliNB_binarize_Result = None
                            else:
                                BernoulliNB_binarize_Result = BernoulliNB_binarize.get()




                            CallClassifier = BernoulliNB(
                                                        alpha = BernoulliNB_alpha_Result,
                                                        fit_prior = BernoulliNB_fit_prior_Result,
                                                        binarize = BernoulliNB_binarize_Result,
                                                        class_prior = None)


                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "random_state = "+str(BernoulliNB_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "alpha = " + str(BernoulliNB_alpha_Result),
                                                            "binarize = "+ str (BernoulliNB_binarize_Result),
                                                            "fit_prior = "+ str(BernoulliNB_fit_prior_Result),
                                                            "class_prior = "+str(None))


                                    BernoulliNB_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if BernoulliNB_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = BernoulliNB_TrainTestSplit_Scale_Result, test_size = 1-BernoulliNB_TrainTestSplit_Scale_Result, random_state= BernoulliNB_random_state_Result,shuffle = True )

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if BernoulliNB_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = BernoulliNB_random_state_Result)
                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = BernoulliNB_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])


              ###########################################
                        # This frame contain all BernoulliNB classifier
                        # parameters including classifier discription.
                        BernoulliNBParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2yUdt5v")

                        SelectedClassifier_and_Link_Frame = tk.Frame(BernoulliNBParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"BernoulliNB implements the naive Bayes "+
                                       "training and classification algorithms "+
                                       "for data that is distributed according "+
                                       "to multivariate Bernoulli distributions; "+
                                       "i.e., there may be multiple features but "+
                                       "each one is assumed to be a binary-valued "+
                                       "(Bernoulli, boolean) variable.\"")

                        tk.Label(BernoulliNBParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=10)

                        # add space on the left
                        tk.Label(BernoulliNBParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =82)

              ###########################################

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        BernoulliNB_TrainTestSplit_vs_KFold_Frame=tk.Frame(BernoulliNBParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        BernoulliNB_TrainTestSplit_Frame = tk.Frame(BernoulliNB_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        BernoulliNB_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(BernoulliNB_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = BernoulliNB_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        BernoulliNB_TrainTestSplit_vs_KFold.set(1)
                        BernoulliNB_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(BernoulliNB_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = BernoulliNB_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        BernoulliNB_TrainTestSplit_Scale.set(75)
                        BernoulliNB_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        BernoulliNB_KFold_frame = tk.Frame(BernoulliNB_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(BernoulliNB_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = BernoulliNB_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        BernoulliNB_KFold= IntVar()
                        tk.Spinbox(BernoulliNB_KFold_frame, textvariable = BernoulliNB_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        BernoulliNB_KFold.set(10)
                        BernoulliNB_KFold_frame.pack(side="top",anchor ="w")

                        BernoulliNB_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)

                        # frame that contains all other parameters starts here.
                        #######################################################
                        # declare random_state parameter, int or None, optional (default=None)
                        BernoulliNB_random_state_int_or_none_frame = tk.Frame(BernoulliNBParameters_Frame, bg = "white")

                        tk.Label(BernoulliNB_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        BernoulliNB_random_state_int_frame = tk.Frame(BernoulliNB_random_state_int_or_none_frame, bg = "white")
                        BernoulliNB_random_state_int_or_none = StringVar()
                        tk.Radiobutton(BernoulliNB_random_state_int_frame, text="Integer: ", font = FONT_12, variable = BernoulliNB_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        BernoulliNB_random_state_int_or_none.set("None")
                        BernoulliNB_random_state = IntVar()
                        tk.Spinbox(BernoulliNB_random_state_int_frame, textvariable = BernoulliNB_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        BernoulliNB_random_state.set(0)
                        BernoulliNB_random_state_int_frame.pack(anchor ="n")

                        BernoulliNB_random_state_none_frame = tk.Frame(BernoulliNB_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(BernoulliNB_random_state_none_frame, text="None", font = FONT_12, variable = BernoulliNB_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(BernoulliNB_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        BernoulliNB_random_state_none_frame.pack(side="left",anchor ="s")

                        BernoulliNB_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare alpha parameter
                        BernoulliNB_alpha_Frame = tk.Frame(BernoulliNBParameters_Frame, bg = "white")
                        tk.Label(BernoulliNB_alpha_Frame, text="alpha:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor ="c")
                        BernoulliNB_alpha = DoubleVar()
                        tk.Spinbox(BernoulliNB_alpha_Frame, textvariable = BernoulliNB_alpha, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack()
                        BernoulliNB_alpha.set(1)
                        BernoulliNB_alpha_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare binarize parameter, float or None, optional (default=0.0)
                        BernoulliNB_binarize_float_or_none_frame = tk.Frame(BernoulliNBParameters_Frame, bg = "white")

                        tk.Label(BernoulliNB_binarize_float_or_none_frame, text="binarize:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        BernoulliNB_binarize_float_frame = tk.Frame(BernoulliNB_binarize_float_or_none_frame, bg = "white")
                        BernoulliNB_binarize_float_or_none = StringVar()
                        tk.Radiobutton(BernoulliNB_binarize_float_frame, text="Float:    ", font = FONT_12, variable = BernoulliNB_binarize_float_or_none, value = 1,justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        BernoulliNB_binarize_float_or_none.set(1)
                        BernoulliNB_binarize = DoubleVar()
                        tk.Spinbox(BernoulliNB_binarize_float_frame, textvariable = BernoulliNB_binarize, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        BernoulliNB_binarize.set(0)
                        BernoulliNB_binarize_float_frame.pack(anchor ="n")

                        BernoulliNB_binarize_none_frame = tk.Frame(BernoulliNB_binarize_float_or_none_frame, bg = "white")
                        tk.Radiobutton(BernoulliNB_binarize_none_frame, text="None", font = FONT_12, variable = BernoulliNB_binarize_float_or_none, value = "None",justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(BernoulliNB_binarize_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        BernoulliNB_binarize_none_frame.pack(side="left",anchor ="s")

                        BernoulliNB_binarize_float_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare fit_prior parameter, bool = default: False
                        BernoulliNB_fit_prior_Frame = tk.Frame(BernoulliNBParameters_Frame, bg = "white")
                        tk.Label(BernoulliNB_fit_prior_Frame, text="fit_prior:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        BernoulliNB_fit_prior = BooleanVar()
                        tk.Radiobutton(BernoulliNB_fit_prior_Frame, text= "True", variable = BernoulliNB_fit_prior, value = True,justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(BernoulliNB_fit_prior_Frame, text= "False", variable = BernoulliNB_fit_prior, value = False,justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        BernoulliNB_fit_prior.set(True)
                        BernoulliNB_fit_prior_Frame.pack(side= "left",anchor ="n",padx =10)

                                        ###################
                                        ###################

                        BernoulliNBParameters_Frame.pack(anchor ="c")

              ###########################################


                        # declare BernoulliNB classifier Result
                        BernoulliNB_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(BernoulliNB_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = BernoulliNB_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(BernoulliNB_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = BernoulliNB_SubFunc).pack(anchor="c", pady=19)
                        else:
                            ttk.Button(BernoulliNB_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = BernoulliNB_SubFunc).pack(anchor="c", pady=24)

                        BernoulliNBSelectedParameters_Frame = tk.Frame(BernoulliNB_ClassifierEvaluation_MainFrame, bg = "white")
                        BernoulliNB_Result = StringVar()
                        tk.Label(BernoulliNBSelectedParameters_Frame, textvariable = BernoulliNB_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        BernoulliNB_Result.set("")
                        BernoulliNBSelectedParameters_Frame.pack(anchor="c")

                                        ###################
                                        ###################

                        BernoulliNB_output_MainFrame = ttk.Frame(BernoulliNB_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        BernoulliNB_ModelEvaluationStatistics_Frame = ttk.Frame(BernoulliNB_output_MainFrame,padding=(10, 10, 10, 10))

                        BernoulliNB_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(BernoulliNB_ModelEvaluationStatistics_Frame)
                        ttk.Label(BernoulliNB_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            BernoulliNB_ModelEvaluationStatistics_Listbox = tk.Listbox(BernoulliNB_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            BernoulliNB_ModelEvaluationStatistics_Listbox = tk.Listbox(BernoulliNB_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            BernoulliNB_ModelEvaluationStatistics_Listbox = tk.Listbox(BernoulliNB_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        BernoulliNB_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(BernoulliNB_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = BernoulliNB_ModelEvaluationStatistics_Listbox.yview, width=10)
                        BernoulliNB_ModelEvaluationStatistics_Listbox.config(yscrollcommand = BernoulliNB_ModelEvaluationStatistics_Scrollbar_v.set)
                        BernoulliNB_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        BernoulliNB_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(BernoulliNB_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = BernoulliNB_ModelEvaluationStatistics_Listbox.xview, width=10)
                        BernoulliNB_ModelEvaluationStatistics_Listbox.config(xscrollcommand = BernoulliNB_ModelEvaluationStatistics_Scrollbar_h.set)
                        BernoulliNB_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        BernoulliNB_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        BernoulliNB_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(BernoulliNB_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        BernoulliNB_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(BernoulliNB_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        BernoulliNB_IdActualPredicted_Frame = ttk.Frame(BernoulliNB_output_MainFrame,padding=(14, 10, 10, 10))

                        BernoulliNB_IdActualPredicted_Listbox_Frame = ttk.Frame(BernoulliNB_IdActualPredicted_Frame)
                        ttk.Label(BernoulliNB_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            BernoulliNB_IdActualPredicted_Listbox = tk.Listbox(BernoulliNB_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            BernoulliNB_IdActualPredicted_Listbox = tk.Listbox(BernoulliNB_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            BernoulliNB_IdActualPredicted_Listbox = tk.Listbox(BernoulliNB_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                        
                        # add vertical scrollbar to list
                        BernoulliNB_IdActualPredicted_Scrollbar_v = tk.Scrollbar(BernoulliNB_IdActualPredicted_Listbox_Frame, orient = "vertical", command = BernoulliNB_IdActualPredicted_Listbox.yview, width=10)
                        BernoulliNB_IdActualPredicted_Listbox.config(yscrollcommand = BernoulliNB_IdActualPredicted_Scrollbar_v.set)
                        BernoulliNB_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        BernoulliNB_IdActualPredicted_Scrollbar_h = tk.Scrollbar(BernoulliNB_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = BernoulliNB_IdActualPredicted_Listbox.xview, width=10)
                        BernoulliNB_IdActualPredicted_Listbox.config(xscrollcommand = BernoulliNB_IdActualPredicted_Scrollbar_h.set)
                        BernoulliNB_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        BernoulliNB_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        BernoulliNB_IdActualPredicted_Listbox_Frame.pack(anchor="n")   


                        # output id - actual - predicted button
                        ttk.Button(BernoulliNB_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        BernoulliNB_IdActualPredicted_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(BernoulliNB_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        BernoulliNB_TestingResults_Frame = ttk.Frame(BernoulliNB_output_MainFrame,padding=(14, 10, 10, 10))

                        BernoulliNB_TestingResults_Listbox_Frame = ttk.Frame(BernoulliNB_TestingResults_Frame)
                        ttk.Label(BernoulliNB_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            BernoulliNB_TestingResults_Listbox = tk.Listbox(BernoulliNB_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            BernoulliNB_TestingResults_Listbox = tk.Listbox(BernoulliNB_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            BernoulliNB_TestingResults_Listbox = tk.Listbox(BernoulliNB_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        BernoulliNB_TestingResults_Scrollbar_v = tk.Scrollbar(BernoulliNB_TestingResults_Listbox_Frame, orient = "vertical", command = BernoulliNB_TestingResults_Listbox.yview, width=10)
                        BernoulliNB_TestingResults_Listbox.config(yscrollcommand = BernoulliNB_TestingResults_Scrollbar_v.set)
                        BernoulliNB_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
            
                        # add vertical scrollbar to list
                        BernoulliNB_TestingResults_Scrollbar_h = tk.Scrollbar(BernoulliNB_TestingResults_Listbox_Frame, orient = "horizontal", command = BernoulliNB_TestingResults_Listbox.xview, width=10)
                        BernoulliNB_TestingResults_Listbox.config(xscrollcommand = BernoulliNB_TestingResults_Scrollbar_h.set)
                        BernoulliNB_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        BernoulliNB_TestingResults_Listbox.pack(expand=True, fill="both")
                        BernoulliNB_TestingResults_Listbox_Frame.pack(anchor="n")                              
                            
                        # output testing results
                        ttk.Button(BernoulliNB_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        BernoulliNB_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        BernoulliNB_output_MainFrame.pack()

                                        ###################
                                        ###################


                        BernoulliNB_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            BernoulliNB_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(BernoulliNB_Spacing_Frame, bg = "white").pack()
                            BernoulliNB_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            BernoulliNB_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(BernoulliNB_Spacing_Frame, bg = "white").pack()
                            BernoulliNB_Spacing_Frame.pack(pady=13)
                        else:
                            BernoulliNB_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(BernoulliNB_Spacing_Frame, bg = "white").pack()
                            BernoulliNB_Spacing_Frame.pack(pady=14)

                        # destroy these later
                        widgets = widgets[:] + [BernoulliNBParameters_Frame,
                                                BernoulliNB_ClassifierEvaluation_MainFrame,
                                                BernoulliNB_Spacing_Frame]

                         # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    BernoulliNB_MainFunc()
          #########################################################
          #########################################################
          #########################################################








          #########################################################
          #########################################################
          #########################################################
                # Call function GaussianNB_MainFunc if user select Gaussian
                # Naive Bayes from classifiers list.
                if classifier_name == '16: GaussianNB':

                    def GaussianNB_MainFunc():



                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def GaussianNB_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            GaussianNB_TrainTestSplit_vs_KFold_Result = GaussianNB_TrainTestSplit_vs_KFold.get()
                            GaussianNB_TrainTestSplit_Scale_Result = GaussianNB_TrainTestSplit_Scale.get()/100
                            GaussianNB_KFold_Result = GaussianNB_KFold.get()
                            # get random_state value
                            if GaussianNB_random_state_int_or_none.get() == "None":
                                GaussianNB_random_state_Result = None
                            else:
                                GaussianNB_random_state_Result = GaussianNB_random_state.get()

                            CallClassifier = GaussianNB(priors = None)

                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "random_state = "+str(GaussianNB_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "priors = "+str(None))

                                    GaussianNB_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if GaussianNB_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = GaussianNB_TrainTestSplit_Scale_Result, test_size = 1-GaussianNB_TrainTestSplit_Scale_Result, random_state=GaussianNB_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if GaussianNB_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = GaussianNB_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = GaussianNB_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])





              ###########################################

                        # This frame contain all GaussianNB classifier
                        # parameters including classifier discription.
                        GaussianNBParameters_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/2gMOri0")

                        SelectedClassifier_and_Link_Frame = tk.Frame(GaussianNBParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"GaussianNB implements the Gaussian "+
                                       "Naive Bayes algorithm for classification. "+
                                       "The likelihood of the features is assumed "+
                                       "to be Gaussian and the parameters sigma_y "+
                                       "and mu_y are estimated using maximum "+
                                       "likelihood.\"")

                        tk.Label(GaussianNBParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(side="top",anchor ="c",pady=10)


                        # add space on the left
                        tk.Label(GaussianNBParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =134)


              ###########################################

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        GaussianNB_TrainTestSplit_vs_KFold_Frame=tk.Frame(GaussianNBParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        GaussianNB_TrainTestSplit_Frame = tk.Frame(GaussianNB_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        GaussianNB_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(GaussianNB_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = GaussianNB_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        GaussianNB_TrainTestSplit_vs_KFold.set(1)
                        GaussianNB_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(GaussianNB_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = GaussianNB_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        GaussianNB_TrainTestSplit_Scale.set(75)
                        GaussianNB_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        GaussianNB_KFold_frame = tk.Frame(GaussianNB_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(GaussianNB_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = GaussianNB_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        GaussianNB_KFold= IntVar()
                        tk.Spinbox(GaussianNB_KFold_frame, textvariable = GaussianNB_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        GaussianNB_KFold.set(10)
                        GaussianNB_KFold_frame.pack(side="top",anchor ="w")

                        GaussianNB_TrainTestSplit_vs_KFold_Frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare random_state parameter, int or None, optional (default=None)
                        GaussianNB_random_state_int_or_none_frame = tk.Frame(GaussianNBParameters_Frame, bg = "white")

                        tk.Label(GaussianNB_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        GaussianNB_random_state_int_frame = tk.Frame(GaussianNB_random_state_int_or_none_frame, bg = "white")
                        GaussianNB_random_state_int_or_none = StringVar()
                        tk.Radiobutton(GaussianNB_random_state_int_frame, text="Integer: ", font = FONT_12, variable = GaussianNB_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        GaussianNB_random_state_int_or_none.set("None")
                        GaussianNB_random_state = IntVar()
                        tk.Spinbox(GaussianNB_random_state_int_frame, textvariable = GaussianNB_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        GaussianNB_random_state.set(0)
                        GaussianNB_random_state_int_frame.pack(anchor ="n")

                        GaussianNB_random_state_none_frame = tk.Frame(GaussianNB_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(GaussianNB_random_state_none_frame, text="None", font = FONT_12, variable = GaussianNB_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(GaussianNB_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        GaussianNB_random_state_none_frame.pack(side="left",anchor ="s")

                        GaussianNB_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################




                        GaussianNBParameters_Frame.pack(anchor ="c")




              ###########################################
                        # declare GaussianNB classifier Result
                        GaussianNB_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(GaussianNB_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = GaussianNB_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(GaussianNB_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = GaussianNB_SubFunc).pack(anchor="c", pady=19)
                        else:
                            ttk.Button(GaussianNB_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = GaussianNB_SubFunc).pack(anchor="c", pady=24)

                        GaussianNBSelectedParameters_Frame = tk.Frame(GaussianNB_ClassifierEvaluation_MainFrame, bg = "white")
                        GaussianNB_Result = StringVar()
                        tk.Label(GaussianNBSelectedParameters_Frame, textvariable = GaussianNB_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        GaussianNB_Result.set("")
                        GaussianNBSelectedParameters_Frame.pack(anchor="c")


                                        ###################
                                        ###################

                        GaussianNB_output_MainFrame = ttk.Frame(GaussianNB_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        GaussianNB_ModelEvaluationStatistics_Frame = ttk.Frame(GaussianNB_output_MainFrame,padding=(10, 10, 10, 10))

                        GaussianNB_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(GaussianNB_ModelEvaluationStatistics_Frame)
                        ttk.Label(GaussianNB_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            GaussianNB_ModelEvaluationStatistics_Listbox = tk.Listbox(GaussianNB_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            GaussianNB_ModelEvaluationStatistics_Listbox = tk.Listbox(GaussianNB_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            GaussianNB_ModelEvaluationStatistics_Listbox = tk.Listbox(GaussianNB_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        GaussianNB_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(GaussianNB_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = GaussianNB_ModelEvaluationStatistics_Listbox.yview, width=10)
                        GaussianNB_ModelEvaluationStatistics_Listbox.config(yscrollcommand = GaussianNB_ModelEvaluationStatistics_Scrollbar_v.set)
                        GaussianNB_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        GaussianNB_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(GaussianNB_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = GaussianNB_ModelEvaluationStatistics_Listbox.xview, width=10)
                        GaussianNB_ModelEvaluationStatistics_Listbox.config(xscrollcommand = GaussianNB_ModelEvaluationStatistics_Scrollbar_h.set)
                        GaussianNB_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        GaussianNB_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        GaussianNB_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(GaussianNB_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        GaussianNB_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(GaussianNB_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        GaussianNB_IdActualPredicted_Frame = ttk.Frame(GaussianNB_output_MainFrame,padding=(14, 10, 10, 10))

                        GaussianNB_IdActualPredicted_Listbox_Frame = ttk.Frame(GaussianNB_IdActualPredicted_Frame)
                        ttk.Label(GaussianNB_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            GaussianNB_IdActualPredicted_Listbox = tk.Listbox(GaussianNB_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            GaussianNB_IdActualPredicted_Listbox = tk.Listbox(GaussianNB_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            GaussianNB_IdActualPredicted_Listbox = tk.Listbox(GaussianNB_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                        
                        # add vertical scrollbar to list
                        GaussianNB_IdActualPredicted_Scrollbar_v = tk.Scrollbar(GaussianNB_IdActualPredicted_Listbox_Frame, orient = "vertical", command = GaussianNB_IdActualPredicted_Listbox.yview, width=10)
                        GaussianNB_IdActualPredicted_Listbox.config(yscrollcommand = GaussianNB_IdActualPredicted_Scrollbar_v.set)
                        GaussianNB_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        GaussianNB_IdActualPredicted_Scrollbar_h = tk.Scrollbar(GaussianNB_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = GaussianNB_IdActualPredicted_Listbox.xview, width=10)
                        GaussianNB_IdActualPredicted_Listbox.config(xscrollcommand = GaussianNB_IdActualPredicted_Scrollbar_h.set)
                        GaussianNB_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        GaussianNB_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        GaussianNB_IdActualPredicted_Listbox_Frame.pack(anchor="n")                           
                    

                        # output id - actual - predicted button
                        ttk.Button(GaussianNB_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        GaussianNB_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(GaussianNB_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        GaussianNB_TestingResults_Frame = ttk.Frame(GaussianNB_output_MainFrame,padding=(14, 10, 10, 10))

                        GaussianNB_TestingResults_Listbox_Frame = ttk.Frame(GaussianNB_TestingResults_Frame)
                        ttk.Label(GaussianNB_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            GaussianNB_TestingResults_Listbox = tk.Listbox(GaussianNB_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            GaussianNB_TestingResults_Listbox = tk.Listbox(GaussianNB_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            GaussianNB_TestingResults_Listbox = tk.Listbox(GaussianNB_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                        # add vertical scrollbar to list
                        GaussianNB_TestingResults_Scrollbar_v = tk.Scrollbar(GaussianNB_TestingResults_Listbox_Frame, orient = "vertical", command = GaussianNB_TestingResults_Listbox.yview, width=10)
                        GaussianNB_TestingResults_Listbox.config(yscrollcommand = GaussianNB_TestingResults_Scrollbar_v.set)
                        GaussianNB_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
            
                        # add vertical scrollbar to list
                        GaussianNB_TestingResults_Scrollbar_h = tk.Scrollbar(GaussianNB_TestingResults_Listbox_Frame, orient = "horizontal", command = GaussianNB_TestingResults_Listbox.xview, width=10)
                        GaussianNB_TestingResults_Listbox.config(xscrollcommand = GaussianNB_TestingResults_Scrollbar_h.set)
                        GaussianNB_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        GaussianNB_TestingResults_Listbox.pack(expand=True, fill="both")
                        GaussianNB_TestingResults_Listbox_Frame.pack(anchor="n")                              
                            
                        # output testing results
                        ttk.Button(GaussianNB_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        GaussianNB_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        GaussianNB_output_MainFrame.pack()

                                        ###################
                                        ###################

                        GaussianNB_ClassifierEvaluation_MainFrame.pack(anchor="c")
              ###########################################

                        if sys.platform == "linux": 
                            GaussianNB_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(GaussianNB_Spacing_Frame, bg = "white").pack()
                            GaussianNB_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            GaussianNB_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(GaussianNB_Spacing_Frame, bg = "white").pack()
                            GaussianNB_Spacing_Frame.pack(pady=13)
                        else:
                            GaussianNB_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(GaussianNB_Spacing_Frame, bg = "white").pack()
                            GaussianNB_Spacing_Frame.pack(pady=14)


                        # destroy these later
                        widgets = widgets[:] + [GaussianNBParameters_Frame,
                                                GaussianNB_ClassifierEvaluation_MainFrame,
                                                GaussianNB_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()


                    GaussianNB_MainFunc()

          #########################################################
          #########################################################
          #########################################################





          #########################################################
          #########################################################
          #########################################################
                # Call function MultinomialNB_MainFunc if user select Multinomial
                # Naive Bayes from classifiers list.
                if classifier_name == '17: MultinomialNB':

                    def MultinomialNB_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)

                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################
                        def MultinomialNB_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            MultinomialNB_TrainTestSplit_vs_KFold_Result = MultinomialNB_TrainTestSplit_vs_KFold.get()
                            MultinomialNB_TrainTestSplit_Scale_Result = MultinomialNB_TrainTestSplit_Scale.get()/100
                            MultinomialNB_KFold_Result = MultinomialNB_KFold.get()
                            # get random_state value
                            if MultinomialNB_random_state_int_or_none.get() == "None":
                                MultinomialNB_random_state_Result = None
                            else:
                                MultinomialNB_random_state_Result = MultinomialNB_random_state.get()


                            MultinomialNB_alpha_Result = MultinomialNB_alpha.get() # get alpha value
                            MultinomialNB_fit_prior_Result = MultinomialNB_fit_prior.get() # get fit_prior value

                            CallClassifier = MultinomialNB(
                                    alpha = MultinomialNB_alpha_Result,
                                    fit_prior = MultinomialNB_fit_prior_Result,
                                    class_prior = None)


                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    Classifier_Pramaters = ("PARAMETERS: ",
                                                            "random_state = "+str(MultinomialNB_random_state_Result),
                                                            "shuffle = " +str(True),
                                                            "alpha = " + str(MultinomialNB_alpha_Result),
                                                            "fit_prior = "+ str(MultinomialNB_fit_prior_Result),
                                                            "class_prior = "+str(None))


                                    MultinomialNB_Result.set(Classifier_Pramaters)
                                        ####################################
                                        ####################################

                                    # if user select Train Sample Size (%)
                                    if MultinomialNB_TrainTestSplit_vs_KFold_Result == 1:

                                        # break dependent data to train and validation to two data sets
                                        x_train, x_validation, y_train, y_validation = train_test_split (X, y, train_size = MultinomialNB_TrainTestSplit_Scale_Result, test_size = 1-MultinomialNB_TrainTestSplit_Scale_Result, random_state= MultinomialNB_random_state_Result, shuffle = True)

                                        CallClassifier.fit(x_train,y_train) # train (fit your traning data) model
                                        y_pred = CallClassifier.predict(x_validation) # validate your model on x_validation

                                        # identify the id for each validated data point
                                        predicted_value= []
                                        for i, j in zip(list(np.array(x_validation.index)),y_pred):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        # indert the number of all predicted data point
                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y_validation, y_pred) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y_validation,y_pred) # get model accuracy




                                        ####################################

                                    # if user select K-fol Cross-Validation
                                    if MultinomialNB_TrainTestSplit_vs_KFold_Result == 2:

                                        # shuffle data and set randome state paramater  before cross validation
                                        X, y = shuffle(X, y, random_state = MultinomialNB_random_state_Result)

                                        # Generate cross-validated estimates for each input data point
                                        predict = cross_val_predict (CallClassifier, X, y, cv = MultinomialNB_KFold_Result)
                                        CallClassifier.fit(X, y)

                                        # identify the id for each data point
                                        predicted_value = []
                                        for i, j in zip(list(np.array(X.index)),predict):
                                            id_acual_predicted = [OpenTargetDataFile_output_ReadFile_new["id"][i],"一",OpenTargetDataFile_output_ReadFile_new["target"][i],"一", j]
                                            predicted_value.append(id_acual_predicted)

                                        predicted_value.insert(0, "Total objects predicted: "+str(len(predicted_value)))
                                        predicted_value_result.set(predicted_value)

                                        # TP [1, 1], TN [0, 0], FP [0, 1], FN [1, 0]
                                        confusion_matrix = metrics.confusion_matrix(y, predict) # generate confusion metrix
                                        accuracy = metrics.accuracy_score(y, predict) # get model accuracy

                                        ####################################


                                    ###########################################
                                    ####   Add confusion matrix, accuracy  ####
                                    ####          and error result         ####
                                    ###########################################
                                    if len(set(y)) != len(confusion_matrix):
                                        ErrorMessage("Training Data Size Error",
                                                 "An error has occurred during training model. "+
                                                 "The error may have been caused due to  "+
                                                 "training on a dataset that does "+
                                                 "not cover all targets data! Thus, cannot "+
                                                 "constract a valid confusion matrix. "+
                                                 "Try changing \"Train Sample Size (%)\".")

                                    else:
                                        
                                        empty = []
                                        for elem in list(confusion_matrix):
                                            for elem2 in elem:
                                                empty.append(len(str(elem2)))
                                                
                                        tabNum = int(max(empty)+4)

                                            ####################################
    
                                        # empty list to append model confusion matrix, accuracy and error
                                        confusion_matrix_accuracy_error_result = []
    
                                        ###########################################
                                        #### Add prdicte and true class labels ####
                                        ###########################################
                                

                                        confusion_matrix_accuracy_error_result.insert(0," "*(tabNum)+"Predicted Class")
                                        elements_in_y = [str(i) for i in list(set(y))] # remove duplicates in y, then convert each element to string


                                        confusion_matrix_output_1 = "True"+" "*(tabNum-len("True"))+"| "
                                        for part in elements_in_y:
                                            confusion_matrix_output_1 += str(part)+(tabNum-len(str(part)))*" "
                                        confusion_matrix_accuracy_error_result.insert(1,confusion_matrix_output_1)
    
        
                                        confusion_matrix_output_2 = "Class"+" "*(tabNum-len("Class"))+"-"
                                        for part in elements_in_y:
                                            confusion_matrix_output_2 += "-"+(tabNum-len(str(part)))*"-"
                                        confusion_matrix_accuracy_error_result.insert(2,confusion_matrix_output_2)
    

                                        for elem in range(len(set(y))):
                                            confusion_matrix_output_3 = list(confusion_matrix[elem])
                                            firstPart = str(elem)+" "*(tabNum-len(str(elem)))+"| "
                                            for part in confusion_matrix_output_3:
                                                firstPart += str(part)+(tabNum-len(str(part)))*" "
                                            confusion_matrix_accuracy_error_result.insert(elem+3,firstPart)

                                        confusion_matrix_accuracy_error_result.append("")
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Accuracy: ", round(accuracy*100, 2), "%"))
                                        classification_error = 1 - accuracy
                                        confusion_matrix_accuracy_error_result.append("%s %s %s" % ("Classification Error (MR): ", round(classification_error*100, 2), "%"))


                                    model_evaluation_and_statistics_result.set(confusion_matrix_accuracy_error_result)
                                    
                                    
                                        ####################################


                                else:
                                    ErrorMessage("Training Dataframe Shape Error",
                                             "An error has occurred during parsing "+
                                             "\"Dependent\" and \"Target\" data files, "+
                                             "the error may have been caused by "+
                                             "dataframe shape!")
                            except NameError:
                                ErrorMessage("Training Data Upload Error",
                                         "We Can't Sync Your Data: Please "+
                                         "upload all required data files: "+
                                         "\"Dependent and Target\" or "+
                                         "\"Dependent, Target and Features\"")


                            ########################################
                            ############# Testing Data #############
                            ########################################

                            try:

                                if training_data_upload_selection_result == "1" or training_data_upload_selection_result == "2":
                                    all_gene_probs = list(map(str,OpenTestDataFile_output_ReadFile_new.columns.values))

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenFeaturesDataFile_output_ReadFile_new))


                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTesting = list(set(all_gene_probs).intersection(OpenTestDataFile_output_ReadFile_oroginal))


                                    testing_X = OpenTestDataFile_output_ReadFile_new[CommonFeatures_for_DataTesting]
                                    testing_y = CallClassifier.predict(testing_X)


                                    testing_value = []
                                    for i, j in zip(list(np.array(testing_X.index)),testing_y):
                                        testing_value_result =  [OpenTestDataFile_output_ReadFile_new["id"][i],"一",j]
                                        testing_value.append(testing_value_result)


                                    total_testing_num = ("Total objects tested: "+str(len(testing_value)))
                                    testing_value.insert(0, total_testing_num)
                                    testing_result.set(testing_value)

                            except NameError:
                                pass


                            ########################################
                            ############# Export Model #############
                            ########################################

                        def ExportModel ():
                            DataFile= tk.filedialog.asksaveasfilename()

                            if DataFile is None:
                                return

                            if DataFile:
                                ExportModelResult = [CommonFeatures_for_DataTraining,
                                                     CallClassifier,
                                                     confusion_matrix_accuracy_error_result,
                                                     Classifier_Pramaters]

                                joblib.dump(ExportModelResult, DataFile+'.pkl')



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTrainingResult ():
                            DataFile= tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer = csv.writer(DataFile)
                                writer.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer.writerows([[""]])


                                if training_data_upload_selection_result == "1":

                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])
                                    writer.writerows([["##features data file:".title()]])
                                    writer.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer.writerows([["##dependent data file:".title()]])
                                    writer.writerows([["##"+dependent_data_file_name]])
                                    writer.writerows([["##target data file:".title()]])
                                    writer.writerows([["##"+target_data_file_name]])

                                writer.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer.writerows([["##"+pramater]])

                                writer.writerows([[""]])

                                writer.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer.writerow(["##"+item])

                                writer.writerows([[""]])

                                writer.writerow(["##"+predicted_value[0]])
                                for item2 in predicted_value[1:]:
                                    writer.writerow([item2[0],item2[2],item2[4]])



                        ##################################################
                        ############# Export Training Result #############
                        ##################################################

                        def ExportTestingResult ():

                            DataFile = tk.filedialog.asksaveasfile(mode = "w", defaultextension=".csv")

                            if DataFile is None:
                                return

                            if DataFile:
                                writer_testing = csv.writer(DataFile)
                                writer_testing.writerows([["##Analysis Done Using ClassificaIO on "+str(datetime.date.today())]])
                                writer_testing.writerows([[""]])


                                if training_data_upload_selection_result == "1":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])
                                    writer_testing.writerows([["##features data file:".title()]])
                                    writer_testing.writerows([["##"+features_data_file_name]])

                                if training_data_upload_selection_result == "2":
                                    writer_testing.writerows([["##Testing data file:".title()]])
                                    writer_testing.writerows([["##"+test_data_file_name]])
                                    writer_testing.writerows([["##dependent data file:".title()]])
                                    writer_testing.writerows([["##"+dependent_data_file_name]])
                                    writer_testing.writerows([["##target data file:".title()]])
                                    writer_testing.writerows([["##"+target_data_file_name]])


                                writer_testing.writerows([[""]])

                                for pramater in Classifier_Pramaters:
                                    writer_testing.writerows([["##"+pramater]])

                                writer_testing.writerows([[""]])

                                writer_testing.writerows([["##confusion matrix, model accuracy & error:".title()]])
                                for item in confusion_matrix_accuracy_error_result:
                                    writer_testing.writerow(["##"+item])

                                writer_testing.writerows([[""]])

                                writer_testing.writerow(["##"+testing_value[0]])
                                for item4 in testing_value[1:]:
                                    writer_testing.writerow([item4[0],item4[2]])





              ###########################################

                        # This frame contain all MultinomialNBP classifier
                        # parameters including classifier discription.
                        MultinomialNBParameters_Frame = tk.Frame( WindowOneCanvasFrame, bg = "white")
                                        ###################
                                        ###################

                        def calllink(event):
                            webbrowser.open_new("http://bit.ly/22rC9bD")

                        SelectedClassifier_and_Link_Frame = tk.Frame(MultinomialNBParameters_Frame, bg = "white")
                        # classifier name appers as user flip through classifier in listbox
                        tk.Label(SelectedClassifier_and_Link_Frame, textvariable = SelectedClassifier, font= FONT_16, bg = "white").pack(side="left",anchor ="c")
                        # classifier web based link appers next to classifier name
                        Link = tk.Label(SelectedClassifier_and_Link_Frame, text="Learn more.", font=FONT_12_underline, fg = 'SteelBlue3', cursor="hand2", bg = "white")
                        Link.pack(side="right",anchor ="c")
                        SelectedClassifier_and_Link_Frame.pack(side= "top", anchor ="c")
                        Link.bind("<Button-1>", calllink)

                                        ###################
                                        ###################
                        discription = ("\"MultinomialNB implements the naive "+
                                       "Bayes algorithm for multinomially "+
                                       "distributed data, and is one of the two "+
                                       "classic naive Bayes variants used in "+
                                       "text classification (where the data are "+
                                       "typically represented as word vector "+
                                       "counts, although tf-idf vectors are also "+
                                       "known to work well in practice).\"")
                        tk.Label(MultinomialNBParameters_Frame, text = discription, wraplength=1000, bg = "white").pack(anchor="c", pady=10)

                        # add space on the left
                        tk.Label(MultinomialNBParameters_Frame,text = "", bg = "white").pack(side= "left", anchor ="n", padx =100)

                        # frame that contains the choice option between train-test
                        # split or K-fold cross-validation.
                        #######################################################
                        MultinomialNB_TrainTestSplit_vs_KFold_Frame=tk.Frame(MultinomialNBParameters_Frame, bg = "white")

                        # track integer changes (1 or 2) in user selection between
                        # K-fold cross-validation = 1  and train-test split = 2
                        # track changes in user selection between 5% to 95% with
                        # respact to train sample size
                        MultinomialNB_TrainTestSplit_Frame = tk.Frame(MultinomialNB_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        MultinomialNB_TrainTestSplit_vs_KFold = IntVar()
                        tk.Radiobutton(MultinomialNB_TrainTestSplit_Frame, text="Train Sample Size (%):", font = FONT_12_bold, variable = MultinomialNB_TrainTestSplit_vs_KFold, value = 1, justify='left', wraplength=75, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        MultinomialNB_TrainTestSplit_vs_KFold.set(1)
                        MultinomialNB_TrainTestSplit_Scale =  IntVar()
                        tk.Scale(MultinomialNB_TrainTestSplit_Frame, from_=5, to=95, orient= "horizontal", length=100, tickinterval= 45, showvalue=1, variable = MultinomialNB_TrainTestSplit_Scale, bg = "white", highlightthickness=0).pack(side="right", anchor ="c")
                        MultinomialNB_TrainTestSplit_Scale.set(75)
                        MultinomialNB_TrainTestSplit_Frame.pack(side="top",anchor ="w")


                        # track changes in user selection between 1 to 50 with
                        # respact to the number of cross-validation folds
                        MultinomialNB_KFold_frame = tk.Frame(MultinomialNB_TrainTestSplit_vs_KFold_Frame, bg = "white")
                        tk.Radiobutton(MultinomialNB_KFold_frame, text="K-fold Cross-Validation:", font = FONT_12_bold, variable = MultinomialNB_TrainTestSplit_vs_KFold, value = 2, justify='left', wraplength=76, bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        MultinomialNB_KFold= IntVar()
                        tk.Spinbox(MultinomialNB_KFold_frame, textvariable = MultinomialNB_KFold, from_=1,  to=sys.maxsize, width=5, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        MultinomialNB_KFold.set(10)
                        MultinomialNB_KFold_frame.pack(side="top",anchor ="w")

                        MultinomialNB_TrainTestSplit_vs_KFold_Frame.pack( side= "left", anchor ="n", padx =10)
                        #######################################################


                        # frame that contains all other parameters starts here.
                        #######################################################

                        # declare random_state parameter, int or None, optional (default=None)
                        MultinomialNB_random_state_int_or_none_frame = tk.Frame(MultinomialNBParameters_Frame, bg = "white")

                        tk.Label(MultinomialNB_random_state_int_or_none_frame, text="random_state:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")

                        MultinomialNB_random_state_int_frame = tk.Frame(MultinomialNB_random_state_int_or_none_frame, bg = "white")
                        MultinomialNB_random_state_int_or_none = StringVar()
                        tk.Radiobutton(MultinomialNB_random_state_int_frame, text="Integer: ", font = FONT_12, variable = MultinomialNB_random_state_int_or_none, value = "Integer", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        MultinomialNB_random_state_int_or_none.set("None")
                        MultinomialNB_random_state = IntVar()
                        tk.Spinbox(MultinomialNB_random_state_int_frame, textvariable = MultinomialNB_random_state, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(side="right",anchor ="c")
                        MultinomialNB_random_state.set(0)
                        MultinomialNB_random_state_int_frame.pack(anchor ="n")

                        MultinomialNB_random_state_none_frame = tk.Frame(MultinomialNB_random_state_int_or_none_frame, bg = "white")
                        tk.Radiobutton(MultinomialNB_random_state_none_frame, text="None", font = FONT_12, variable = MultinomialNB_random_state_int_or_none, value = "None", justify='left', bg = "white", highlightthickness=0).pack(side="left",anchor ="c")
                        tk.Label(MultinomialNB_random_state_none_frame, text="             ", bg = "white").pack(side="right",anchor ="c")
                        MultinomialNB_random_state_none_frame.pack(side="left",anchor ="s")

                        MultinomialNB_random_state_int_or_none_frame.pack(side= "left", anchor ="n", padx =10)

                                        ###################
                                        ###################

                        # declare alpha parameter
                        MultinomialNB_alpha_Frame = tk.Frame(MultinomialNBParameters_Frame, bg = "white")
                        tk.Label(MultinomialNB_alpha_Frame, text="alpha:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor ="c")
                        MultinomialNB_alpha = DoubleVar()
                        tk.Spinbox(MultinomialNB_alpha_Frame, textvariable = MultinomialNB_alpha, from_=-sys.maxsize, to=sys.maxsize, width=4, relief= "sunken", borderwidth=1, justify='left').pack(anchor="c")
                        MultinomialNB_alpha.set(1)
                        MultinomialNB_alpha_Frame.pack(side= "left", anchor ="n", padx =10)
                                        ###################
                                        ###################
                        # declare fit_prior parameter, bool = default: False
                        MultinomialNB_fit_prior_Frame = tk.Frame(MultinomialNBParameters_Frame, bg = "white")
                        tk.Label(MultinomialNB_fit_prior_Frame, text="fit_prior:", font=FONT_12, fg = 'SteelBlue3', bg = "white").pack(anchor="c")
                        MultinomialNB_fit_prior = BooleanVar()
                        tk.Radiobutton(MultinomialNB_fit_prior_Frame, text= "True", variable = MultinomialNB_fit_prior, value = True, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        tk.Radiobutton(MultinomialNB_fit_prior_Frame, text= "False", variable = MultinomialNB_fit_prior, value = False, justify='left', bg = "white", highlightthickness=0).pack(anchor ="w")
                        MultinomialNB_fit_prior.set(True)
                        MultinomialNB_fit_prior_Frame.pack(side= "left",anchor ="n",padx =10)
                                        ###################
                                        ###################
                        MultinomialNBParameters_Frame.pack(anchor ="c")


              ###########################################

                        # declare MultinomialNB classifier result
                        MultinomialNB_ClassifierEvaluation_MainFrame = tk.Frame(WindowOneCanvasFrame, bg = "white")

                        if sys.platform == "linux": 
                            ttk.Button(MultinomialNB_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = MultinomialNB_SubFunc).pack(anchor="c", pady=1)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            ttk.Button(MultinomialNB_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = MultinomialNB_SubFunc).pack(anchor="c", pady=19)
                        else:
                            ttk.Button(MultinomialNB_ClassifierEvaluation_MainFrame, width=8, default='active', text= "Submit", command = MultinomialNB_SubFunc).pack(anchor="c", pady=24)

                        MultinomialNBSelectedParameters_Frame = tk.Frame(MultinomialNB_ClassifierEvaluation_MainFrame, bg = "white")
                        MultinomialNB_Result = StringVar()
                        tk.Label(MultinomialNBSelectedParameters_Frame, textvariable = MultinomialNB_Result, wraplength=1200, bg = "white").pack(anchor="n")
                        MultinomialNB_Result.set("")
                        MultinomialNBSelectedParameters_Frame.pack(anchor="c")


                                        ###################
                                        ###################

                        MultinomialNB_output_MainFrame = ttk.Frame(MultinomialNB_ClassifierEvaluation_MainFrame,relief= "raised",borderwidth=1)

                                        ###################
                                        ###################
                        # confusion matrix, model accuracy & error
                        MultinomialNB_ModelEvaluationStatistics_Frame = ttk.Frame(MultinomialNB_output_MainFrame,padding=(10, 10, 10, 10))

                        MultinomialNB_ModelEvaluationStatistics_Listbox_Frame = ttk.Frame(MultinomialNB_ModelEvaluationStatistics_Frame)
                        ttk.Label(MultinomialNB_ModelEvaluationStatistics_Listbox_Frame, text="confusion matrix, model accuracy & error".upper(), font=FONT_13_bold).pack(anchor="c")
                        
                        if sys.platform == "linux": 
                            MultinomialNB_ModelEvaluationStatistics_Listbox = tk.Listbox(MultinomialNB_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["FreeMono",12,"bold"] ,listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        
                        elif sys.platform == "win64" or sys.platform == "win32":
                            MultinomialNB_ModelEvaluationStatistics_Listbox = tk.Listbox(MultinomialNB_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple" , font =["Courier",9],listvariable = model_evaluation_and_statistics_result, width=54, height=10)
                        else:
                            MultinomialNB_ModelEvaluationStatistics_Listbox = tk.Listbox(MultinomialNB_ModelEvaluationStatistics_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", font = ["Courier",15,"bold"],listvariable = model_evaluation_and_statistics_result, width=34, height=10)                        

                        # add vertical scrollbar to list
                        MultinomialNB_ModelEvaluationStatistics_Scrollbar_v = tk.Scrollbar(MultinomialNB_ModelEvaluationStatistics_Listbox_Frame, orient = "vertical", command = MultinomialNB_ModelEvaluationStatistics_Listbox.yview, width=10)
                        MultinomialNB_ModelEvaluationStatistics_Listbox.config(yscrollcommand = MultinomialNB_ModelEvaluationStatistics_Scrollbar_v.set)
                        MultinomialNB_ModelEvaluationStatistics_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        MultinomialNB_ModelEvaluationStatistics_Scrollbar_h = tk.Scrollbar(MultinomialNB_ModelEvaluationStatistics_Listbox_Frame, orient = "horizontal", command = MultinomialNB_ModelEvaluationStatistics_Listbox.xview, width=10)
                        MultinomialNB_ModelEvaluationStatistics_Listbox.config(xscrollcommand = MultinomialNB_ModelEvaluationStatistics_Scrollbar_h.set)
                        MultinomialNB_ModelEvaluationStatistics_Scrollbar_h.pack(side="bottom", fill= "x")       

                        MultinomialNB_ModelEvaluationStatistics_Listbox.pack(expand=True, fill="both")
                        MultinomialNB_ModelEvaluationStatistics_Listbox_Frame.pack(anchor="n")

                        # output confusion matrix, model accuracy & error button
                        ttk.Button(MultinomialNB_ModelEvaluationStatistics_Frame,text= "Export Model", command = ExportModel).pack(side= "bottom",anchor="e")

                        MultinomialNB_ModelEvaluationStatistics_Frame.pack(side= "left",anchor="n")


                                        ###################
                                        ###################

                        divider_1 = ttk.Frame(MultinomialNB_output_MainFrame,padding=(0, 180, 0, 0),relief= "raised",borderwidth=1)
                        ttk.Label(divider_1).pack()
                        divider_1.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################
                        # id - actual - predicted
                        MultinomialNB_IdActualPredicted_Frame = ttk.Frame(MultinomialNB_output_MainFrame,padding=(14, 10, 10, 10))

                        MultinomialNB_IdActualPredicted_Listbox_Frame = ttk.Frame(MultinomialNB_IdActualPredicted_Frame)
                        ttk.Label(MultinomialNB_IdActualPredicted_Listbox_Frame, text="training result: id 一 actual 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            MultinomialNB_IdActualPredicted_Listbox = tk.Listbox(MultinomialNB_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            MultinomialNB_IdActualPredicted_Listbox = tk.Listbox(MultinomialNB_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result, width=53, height=10)
                        else:
                            MultinomialNB_IdActualPredicted_Listbox = tk.Listbox(MultinomialNB_IdActualPredicted_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = predicted_value_result,width=36, height=10)
                        
                        # add vertical scrollbar to list
                        MultinomialNB_IdActualPredicted_Scrollbar_v = tk.Scrollbar(MultinomialNB_IdActualPredicted_Listbox_Frame, orient = "vertical", command = MultinomialNB_IdActualPredicted_Listbox.yview, width=10)
                        MultinomialNB_IdActualPredicted_Listbox.config(yscrollcommand = MultinomialNB_IdActualPredicted_Scrollbar_v.set)
                        MultinomialNB_IdActualPredicted_Scrollbar_v.pack(side="right", fill= "y")        
                
                        # add vertical scrollbar to list
                        MultinomialNB_IdActualPredicted_Scrollbar_h = tk.Scrollbar(MultinomialNB_IdActualPredicted_Listbox_Frame, orient = "horizontal", command = MultinomialNB_IdActualPredicted_Listbox.xview, width=10)
                        MultinomialNB_IdActualPredicted_Listbox.config(xscrollcommand = MultinomialNB_IdActualPredicted_Scrollbar_h.set)
                        MultinomialNB_IdActualPredicted_Scrollbar_h.pack(side="bottom", fill= "x")       

                        MultinomialNB_IdActualPredicted_Listbox.pack(expand=True, fill="both")
                        MultinomialNB_IdActualPredicted_Listbox_Frame.pack(anchor="n")                          

                        # output id - actual - predicted button
                        ttk.Button(MultinomialNB_IdActualPredicted_Frame,text= "Export Training", command = ExportTrainingResult).pack(side= "bottom",anchor="e")

                        MultinomialNB_IdActualPredicted_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        divider_2 = ttk.Frame(MultinomialNB_output_MainFrame, padding=(0, 180, 0, 0),relief= "raise",borderwidth=1)
                        ttk.Label(divider_2).pack()
                        divider_2.pack(side = "left", anchor ="c")

                                        ###################
                                        ###################

                        # testing results
                        MultinomialNB_TestingResults_Frame = ttk.Frame(MultinomialNB_output_MainFrame,padding=(14, 10, 10, 10))

                        MultinomialNB_TestingResults_Listbox_Frame = ttk.Frame(MultinomialNB_TestingResults_Frame)
                        ttk.Label(MultinomialNB_TestingResults_Listbox_Frame, text="testing result: id 一 prediction".upper(), font=FONT_13_bold).pack(anchor="c")
                        if sys.platform == "linux":
                            MultinomialNB_TestingResults_Listbox = tk.Listbox(MultinomialNB_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=40, height=10)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            MultinomialNB_TestingResults_Listbox = tk.Listbox(MultinomialNB_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result, width=53, height=10)
                        else:
                            MultinomialNB_TestingResults_Listbox = tk.Listbox(MultinomialNB_TestingResults_Listbox_Frame, relief= "raise", exportselection = False, selectmode="multiple", listvariable = testing_result,width=36, height=10)
                            
                            
                        # add vertical scrollbar to list
                        MultinomialNB_TestingResults_Scrollbar_v = tk.Scrollbar(MultinomialNB_TestingResults_Listbox_Frame, orient = "vertical", command = MultinomialNB_TestingResults_Listbox.yview, width=10)
                        MultinomialNB_TestingResults_Listbox.config(yscrollcommand = MultinomialNB_TestingResults_Scrollbar_v.set)
                        MultinomialNB_TestingResults_Scrollbar_v.pack(side="right", fill= "y")        
            
                        # add vertical scrollbar to list
                        MultinomialNB_TestingResults_Scrollbar_h = tk.Scrollbar(MultinomialNB_TestingResults_Listbox_Frame, orient = "horizontal", command = MultinomialNB_TestingResults_Listbox.xview, width=10)
                        MultinomialNB_TestingResults_Listbox.config(xscrollcommand = MultinomialNB_TestingResults_Scrollbar_h.set)
                        MultinomialNB_TestingResults_Scrollbar_h.pack(side="bottom", fill= "x")  
        
                        MultinomialNB_TestingResults_Listbox.pack(expand=True, fill="both")
                        MultinomialNB_TestingResults_Listbox_Frame.pack(anchor="n")                              
                            

                        # output testing results
                        ttk.Button(MultinomialNB_TestingResults_Frame,text= "Export Testing", command = ExportTestingResult).pack(side= "bottom",anchor="e")

                        MultinomialNB_TestingResults_Frame.pack(side= "left",anchor="n")

                                        ###################
                                        ###################

                        MultinomialNB_output_MainFrame.pack()

                                        ###################
                                        ###################

                        MultinomialNB_ClassifierEvaluation_MainFrame.pack()
              ###########################################

                        if sys.platform == "linux": 
                            MultinomialNB_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(MultinomialNB_Spacing_Frame, bg = "white").pack()
                            MultinomialNB_Spacing_Frame.pack(pady=2)
                        elif sys.platform == "win64" or sys.platform == "win32":
                            MultinomialNB_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(MultinomialNB_Spacing_Frame, bg = "white").pack()
                            MultinomialNB_Spacing_Frame.pack(pady=13)
                        else:
                            MultinomialNB_Spacing_Frame = tk.Frame(WindowOneCanvasFrame, bg = "white")
                            tk.Label(MultinomialNB_Spacing_Frame, bg = "white").pack()
                            MultinomialNB_Spacing_Frame.pack(pady=14)

                        # destroy these later
                        widgets = widgets[:] + [MultinomialNBParameters_Frame,
                                                MultinomialNB_ClassifierEvaluation_MainFrame,
                                                MultinomialNB_Spacing_Frame]
                        # pack them afterwards
                        for widget in widgets:
                            widget.pack()

                    MultinomialNB_MainFunc()
          #########################################################
          #########################################################
          #########################################################







          #########################################################
          #########################################################
          #########################################################

                # Call function EmptyFrame if user select
                # '#Decision Trees' from classifiers list.
                if classifier_name ==  'VII. Trees':
                    EmptyFrame(WindowOneCanvasFrame, classifier_name)

                # Call function DecisionTree_MainFunc if user select Decision
                # Tree from classifiers list.
                if classifier_name == '18: DecisionTreeClassifier':

                    def DecisionTree_MainFunc():

                        global widgets
                        for widget in widgets[:]:
                            widget.destroy()
                            widgets.remove(widget)


                        predicted_value_result = IntVar()
                        predicted_value_result.set("")

                        model_evaluation_and_statistics_result = IntVar()
                        model_evaluation_and_statistics_result.set("")

                        testing_result = IntVar()
                        testing_result.set("")
              ###########################################

                        def DecisionTree_SubFunc():
                            global CommonFeatures_for_DataTraining
                            global CallClassifier
                            global confusion_matrix_accuracy_error_result
                            global Classifier_Pramaters
                            global predicted_value
                            global testing_value

                            DT_TrainTestSplit_vs_KFold_Result = DT_TrainTestSplit_vs_KFold.get()
                            DT_TrainTestSplit_Scale_Result = DT_TrainTestSplit_Scale.get()/100
                            DT_KFold_Result = DT_KFold.get()

                            # get random_state value
                            if DecisionTree_random_state_int_or_none.get() == "None":
                                DecisionTree_random_state_Result = None
                            else:
                                DecisionTree_random_state_Result = DecisionTree_random_state.get()

                            DecisionTree_splitter_Result = DecisionTree_splitter.get() # get splitter value
                            DecisionTree_criterion_Result = DecisionTree_criterion.get() # get criterion value
                            DecisionTree_min_weight_fraction_leaf_Result = DecisionTree_min_weight_fraction_leaf.get() # get min_weight_fraction_leaf value
                            DecisionTree_min_impurity_decrease_Result = DecisionTree_min_impurity_decrease.get() # get min_impurity_decrease value

                            # get max_depth value
                            if DecisionTree_max_depth_int_or_none.get() == "None":
                                DecisionTree_max_depth_Result = None
                            else:
                                DecisionTree_max_depth_Result = DecisionTree_max_depth.get()

                            # get max_leaf_nodes value
                            if DecisionTree_max_leaf_nodes_int_or_none.get() == "None":
                                DecisionTree_max_leaf_nodes_Result = None
                            else:
                                DecisionTree_max_leaf_nodes_Result = DecisionTree_max_leaf_nodes.get()

                            # get max_samples value
                            if DecisionTree_min_samples_split_int_or_float_Radiobutton.get() == "Float":
                                DecisionTree_min_samples_split_int_or_float_Spinbox_Result = float(DecisionTree_min_samples_split_int_or_float_Spinbox.get())
                            if DecisionTree_min_samples_split_int_or_float_Radiobutton.get() == "Integer":
                                DecisionTree_min_samples_split_int_or_float_Spinbox_Result = DecisionTree_min_samples_split_int_or_float_Spinbox.get()

                            # get min_samples_leaf value
                            if DecisionTree_min_samples_leaf_int_or_float_Radiobutton.get() == "Float":
                                DecisionTree_min_samples_leaf_int_or_float_Spinbox_Result = float(DecisionTree_min_samples_leaf_int_or_float_Spinbox.get())
                            if DecisionTree_min_samples_leaf_int_or_float_Radiobutton.get() == "Integer":
                                DecisionTree_min_samples_leaf_int_or_float_Spinbox_Result = DecisionTree_min_samples_leaf_int_or_float_Spinbox.get()

                            DecisionTree_presort_Result = DecisionTree_presort.get() # get presort value

                            # get max_features value
                            if DecisionTree_max_features_string_int_float_none.get() == "String":
                                if DecisionTree_max_features_string.get() =="None":
                                    DecisionTree_max_features_string_int_float_none_Result = None
                                else:
                                    DecisionTree_max_features_string_int_float_none_Result = DecisionTree_max_features_string.get()
                            if DecisionTree_max_features_string_int_float_none.get() == "Float":
                                DecisionTree_max_features_string_int_float_none_Result = float(DecisionTree_max_features_int_or_float_Spinbox.get())
                            if DecisionTree_max_features_string_int_float_none.get() == "Integer":
                                DecisionTree_max_features_string_int_float_none_Result = DecisionTree_max_features_int_or_float_Spinbox.get()


                            CallClassifier = DecisionTreeClassifier(criterion = DecisionTree_criterion_Result,
                                                                    splitter = DecisionTree_splitter_Result,
                                                                    max_depth = DecisionTree_max_depth_Result,
                                                                    min_samples_split = DecisionTree_min_samples_split_int_or_float_Spinbox_Result,
                                                                    min_samples_leaf = DecisionTree_min_samples_leaf_int_or_float_Spinbox_Result,
                                                                    min_weight_fraction_leaf = DecisionTree_min_weight_fraction_leaf_Result,
                                                                    random_state = DecisionTree_random_state_Result,
                                                                    max_features = DecisionTree_max_features_string_int_float_none_Result,
                                                                    max_leaf_nodes = DecisionTree_max_leaf_nodes_Result,
                                                                    min_impurity_decrease = DecisionTree_min_impurity_decrease_Result,
                                                                    class_weight = None,
                                                                    presort = DecisionTree_presort_Result)



                            #######################################
                            ############ Training Data ############
                            #######################################

                            try:

                                # check if number of columns for dependent data file
                                # is bigger than number of columns in target data file.
                                # If true continuo, if false send error.
                                # Target data file should have 2 columns only.
                                if OpenDependentDataFile_output_ReadFile_new.shape[1] > OpenTargetDataFile_output_ReadFile_new.shape[1]:

                                    DependentTargetDataMerge = pd.merge(OpenDependentDataFile_output_ReadFile_new, OpenTargetDataFile_output_ReadFile_new, on='id')
                                    DependentTargetDataMergeFeatures = list(DependentTargetDataMerge.columns.values)

                                        ####################################
                                        ####################################

                                    # if user select 1, user have to upload all
                                    # "Dependent, Target and Features" data files
                                    if training_data_upload_selection_result == "1":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenFeaturesDataFile_output_ReadFile_new))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

                                        ####################################

                                    # if user select 2, user have to upload both
                                    # "Dependent, Target" data files
                                    if training_data_upload_selection_result == "2":
                                        CommonFeatures_for_DataTraining = list(set(DependentTargetDataMergeFeatures).intersection(OpenDependentDataFile_output_ReadFile_oroginal))
                                        X = DependentTargetDataMerge[CommonFeatures_for_DataTraining]
                                        target = ['target']
                                        y = DependentTargetDataMerge[target]
                                        y = np.array(y.target)

