This study focuses on analyzing the operational security of domain registries to identify potential attack surfaces. The analysis and measurements were conducted using public resources, including TLD zone files, domain registration information, and domain status checking interfaces. Among these resources, the domain registration information primarily consists of WHOIS records maintained by registries and registrars. Since historical WHOIS records are not completely available, we provide a script for active WHOIS data collection for a supplement.

Additionally, we performed large-scale measurements to assess the real-world impact of the identified attack surfaces, uncovering vulnerabilities in some domain registries and user domain names. However, adhering to standard vulnerability disclosure requirements, we cannot provide a complete list of affected entities. Instead, we include specific examples to validate our findings.

To this end, the provided artifacts include:
1. `resources.md`: A file listing the official sites of publicly available resources.
2. `whois-collection.py`: A script for actively collecting WHOIS records from WHOIS databases.
3. `affected-cases.md`: A document detailing specific examples of affected domain names and steps for validation.
4. `affected-cases.assets`: A folder containing figure files referenced in affected-cases.md.

The folder structure is as follows:
```
sec25-artifact-104
├── 1-public-resources
│   └── resources.md
├── 2-scripts
│   └── whois-collection.py
├── 3-vulnerability-disclosure
│   ├── affected-cases.assets
│   │   ├── twiin.app-1.png
│   │   ├── twiin.app-2.png
│   │   ├── twiin.app-3.png
│   │   ├── twiin.app-4.jpg
│   │   ├── xn--86q281bo5hhlb.cn-1.png
│   │   └── xn--86q281bo5hhlb.cn-2.png
│   └── affected-cases.md
└── README
```