### Identified Vulnerable Domain Names

This document presents examples of identified vulnerable domain names to demonstrate the validity and feasibility of our findings. We disclose only domains that were previously vulnerable but have since been resolved, minimizing real-world impact and preventing potential exploitation by malicious parties.

In some instances, we include screenshots taken during testing to verify domain statuses that can no longer be reproduced.



#### Case 1: twiin.app (relic domain)

1. The domain name can be registered from a domain registrar.

   <img src="affected-cases.assets/twiin.app-1.png" alt="img" style="zoom:50%;" />

2. The domain name has a delegation record in the TLD zone file.

   <img src="affected-cases.assets/twiin.app-2.png" alt="img" style="zoom:50%;" />

3. The domain name does not have a WHOIS record.

   <img src="affected-cases.assets/twiin.app-3.png" alt="img" style="zoom:50%;" />

4. Attackers can take over the domain name through the delegation records in the TLD name servers, which allows them to abuse an unregistered domain name.

5. We reported the issues to the backend registry, Google, and they have been successfully resolved.

   <img src="affected-cases.assets/twiin.app-4.jpg" alt="img" style="zoom:50%;" />



#### Case 2: cjgroup.top (relic domain)

This domain encountered the same issue as Case 1, which has been addressed by the backend registry, ZDNS.



#### Case3: xn--86q281bo5hhlb.cn (twin domain)

1. The *xn--86q281bo5hhlb.cn (冒泡游戲.cn)* and *xn--86qv51bo8hhkb.cn (冒泡游戏.cn)* are a pair of twin domains. Among these IDNs, *xn--86qv51bo8hhkb.cn (冒泡游戏.cn)* was registered by a registrant and *xn--86q281bo5hhlb.cn (冒泡游戲.cn)* was created by the registry. 
2. They have the same WHOIS record, with the Name Server set to DNSPod.

<img src="affected-cases.assets/xn--86q281bo5hhlb.cn-1.png" alt="img" style="zoom:50%;" />

3. Customers assigned the same NS domains (i.e., *cube.dnspod.net* and *guanaco.dnspod.net*) can configure *xn--86q281bo5hhlb.cn* (*冒泡游戲.cn*) on their configuration pages. (Note: The domain was added solely for testing purposes, without configuring any DNS resource records for malicious use.)

   <img src="affected-cases.assets/xn--86q281bo5hhlb.cn-2.png" alt="img" style="zoom:50%;" />

   