### TLD Zone File Dataset

1. The Centralized Zone Data Service (CZDS). https://czds.icann.org/home

2. CZDS API Client in Python. https://github.com/icann/czds-api-client-python

3. Zone File Data Example (.ltd zone file snapshot on 2025-01-21)

   ```
ltd.    3600    in  soa v0n0.nic.ltd. hostmaster.donuts.email. 1737421562 7200 900 1209600 3600
   0-100.ltd.  3600    in  ns  ns-cloud-b1.googledomains.com.
0-100.ltd.  3600    in  ns  ns-cloud-b2.googledomains.com.
   0-100.ltd.  3600    in  ns  ns-cloud-b3.googledomains.com.
   0-100.ltd.  3600    in  ns  ns-cloud-b4.googledomains.com.
   0-9.ltd.    3600    in  ns  dns1.hichina.com.
   0-9.ltd.    3600    in  ns  dns2.hichina.com.
   0-g.ltd.    3600    in  ns  dns1.akkyhosting16.mx.
   0-g.ltd.    3600    in  ns  dns2.akkyhosting16.mx.
   00.ltd. 3600    in  ns  ns57.domaincontrol.com.
   00.ltd. 3600    in  ns  ns58.domaincontrol.com.
   00000000.ltd.   3600    in  ns  ns1.dns.com.
   00000000.ltd.   3600    in  ns  ns2.dns.com.
   01313.ltd.  3600    in  ns  ns1.dyna-ns.net.
   01313.ltd.  3600    in  ns  ns2.dyna-ns.net.
0378.ltd.   3600    in  ns  dns17.hichina.com.
   0378.ltd.   3600    in  ns  dns18.hichina.com.
   0379.ltd.   3600    in  ns  dns19.hichina.com.
0379.ltd.   3600    in  ns  dns20.hichina.com.
	0386.ltd.   3600    in  ns  ns1.taoa.com.
	0386.ltd.   3600    in  ns  ns2.taoa.com.
	0387.ltd.   3600    in  ns  ns1.taoa.com.
	0387.ltd.   3600    in  ns  ns2.taoa.com.
	0388.ltd.   3600    in  ns  ns1.taoa.com.
	0388.ltd.   3600    in  ns  ns2.taoa.com.
	0389.ltd.   3600    in  ns  ns1.taoa.com.
	0389.ltd.   3600    in  ns  ns2.taoa.com.
	```



### Registrar Registration Interfaces

These three providers can cover most popular TLDs:

1. Alibaba Cloud DNS - API Document: https://api.alibabacloud.com/document/Domain/2018-01-29/CheckDomain
2. Tencent DNSPod - API Explorer - CheckDomain: https://console.cloud.tencent.com/api/explorer?Product=domain&Version=2018-08-08&Action=CheckDomain
3. Dynadot - Domain API: https://www.dynadot.com/domain/api-commands#search





### Examples of Equivalent IDNs
```
domain1-puny,domain1,domain2,idn
xn--xkr46q2lj8jgz22cz2n.xn--czru2d.,华晨宝马汽车.商城.,华晨宝马汽车.商城.,08
xn--9kq2yt3gkxhq3l934bqq7a.xn--czru2d.,云南天糧供應鏈.商城.,云南天粮供应链.商城.,08
xn--mrrw10e1g0a.top.,吸頂燈.top.,吸顶灯.top.,08
xn--zcr140l.wang.,證券.wang.,证券.wang.,08
xn--uirt1a63gw50e.xn--hxt814e.,吸塑包装.网店.,吸塑包装.网店.,08
xn--rovp01br6ein9a.top.,磊羽書齋.top.,磊羽书斋.top.,08
xn--fiqs8sy4g8u8aosd.tel.,中国弹花网.tel.,中国弹花网.tel.,08
xn--8err11iyoi.top.,劇美購.top.,剧美购.top.,08
xn--fiqr3jz0d492bt8g.xn--czru2d.,中國北稻王.商城.,中国北稻王.商城.,08
xn--fiqs8ss1jkk9b.xn--czru2d.,中国轴承.商城.,中国轴承.商城.,08
xn--fiqg419d8w5dkgas35b.xn--czru2d.,中國順丰速運.商城.,中国顺丰速运.商城.,08
xn--zbwn14auyo.top.,祝樂購.top.,祝乐购.top.,08
xn--vytz13j.com.,廈門.com.,厦门.com.,08
xn--fhq355ea989fqj6aswb.xn--czru2d.,上汽通用汽車.商城.,上汽通用汽车.商城.,08
xn--csst60as04a.top.,新多购.top.,新多购.top.,08
xn--zwtz75brulg3o.biz.,重庆特色.biz.,重庆特色.biz.,08
xn--jor977akq5a.top.,捷双购.top.,捷双购.top.,08
xn--fiqs8sl5nz79ause.xn--czru2d.,中国起重机.商城.,中国起重机.商城.,08
xn--1lq90i6wdxutxrpu51b.xn--czru2d.,北京物资回收.商城.,北京物资回收.商城.,08
xn--n9s7a40wrwhstz3hw.xn--czru2d.,安徽研學旅行.商城.,安徽研学旅行.商城.,08
xn--ekr844h.xn--3bst00m.,医美.集团.,医美.集团.,08
xn--yfr598a445a.top.,拍加购.top.,拍加购.top.,08
xn--fiq93r7na627b9po.xn--czru2d.,中國散熱器.商城.,中国散热器.商城.,08
xn--fiqz3fnugp1zzn6abph.xn--czru2d.,中國汽車裝具.商城.,中国汽车装具.商城.,08
xn--tptt97a3nflvw.com.,嶋西淺男.com.,嶋西浅男.com.,08
xn--fiqz9s43q158b.xn--czru2d.,中國檢驗.商城.,中国检验.商城.,08
```


