#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# WrightTools documentation build configuration file, created by
# sphinx-quickstart on Tue Jul 18 13:01:20 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.


# --- import -------------------------------------------------------------------------------------


import glob
import os
import sys

# import sphinx_gallery
import math
import pathlib


# --- define -------------------------------------------------------------------------------------


here = pathlib.Path(__file__).resolve().parent

with open(here.parent / "WrightTools" / "VERSION") as version_file:
    version = version_file.read().strip()


# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

sys.path.insert(0, os.path.abspath("."))
sys.path.insert(0, here.parent / "WrightTools")


# --- general configuration ----------------------------------------------------------------------


# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.doctest",
    "sphinx.ext.autosummary",
    "sphinx.ext.intersphinx",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.mathjax",
    "sphinx.ext.ifconfig",
    "sphinx.ext.viewcode",
    "matplotlib.sphinxext.plot_directive",
    "sphinx_gallery.gen_gallery",
    "sphinx.ext.napoleon",
]

# -----------------------------------------------------------------------------
# Autosummary
# -----------------------------------------------------------------------------

autosummary_generate = glob.glob("api/*.rst")

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "WrightTools"
copyright = "2016-2024, WrightTools Developers"
author = "WrightTools Developers"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = version
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ---------------------------------------------------------------------


# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# HTML context adapted from http://docs.readthedocs.io/en/latest/vcs.html
html_context = {
    "display_github": True,  # Integrate GitHub
    "github_user": "wright-group",  # Username
    "github_repo": "WrightTools",  # Repo name
    "github_version": "master",  # Version
    "conf_py_path": "/docs/",  # Path in the checkout to the docs root
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    "**": [
        "about.html",
        "navigation.html",
        "relations.html",  # needs 'show_related': True theme option to display
        "searchbox.html",
        "donate.html",
    ]
}


# --- Options for HTMLHelp output ----------------------------------------------------------------


# Output file base name for HTML help builder.
htmlhelp_basename = "WrightToolsdoc"


# --- Options for LaTeX output -------------------------------------------------------------------


latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        "WrightTools.tex",
        "WrightTools Documentation",
        "WrightTools Developers",
        "manual",
    )
]


# --- Options for manual page output -------------------------------------------------------------


# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "wrighttools", "WrightTools Documentation", [author], 1)]


# --- Options for Texinfo output -----------------------------------------------------------------


# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "WrightTools",
        "WrightTools Documentation",
        author,
        "WrightTools",
        "One line description of project.",
        "Miscellaneous",
    )
]


# --- gallery ------------------------------------------------------------------------------------


def reset_wt(gallery_conf, fname):
    # This is an awful hack because python does not allow unloading modules
    # This is, however, the same thing upstream sphinx-gallery does for
    # seaborn, so it's not _so_ bad I guess.  2019-04-07 KFS
    for module in list(sys.modules.keys()):
        if module.startswith("WrightTools.datasets"):
            del sys.modules[module]


sphinx_gallery_conf = {
    "examples_dirs": here.parent / "examples",
    "filename_pattern": "/*.py",
    "gallery_dirs": "auto_examples",
    "backreferences_dir": os.path.join("gen_modules", "backreferences"),
    "reset_modules": ["matplotlib", reset_wt],
}


# --- plots --------------------------------------------------------------------------------------


plot_pre_code = """
import numpy as np
np.random.seed(0)
"""

plot_include_source = True
plot_formats = [("png", 100), "pdf"]

phi = (math.sqrt(5) + 1) / 2

plot_rcparams = {
    "font.size": 8,
    "axes.titlesize": 8,
    "axes.labelsize": 8,
    "xtick.labelsize": 8,
    "ytick.labelsize": 8,
    "legend.fontsize": 8,
    "figure.figsize": (3 * phi, 3),
    "figure.subplot.bottom": 0.2,
    "figure.subplot.left": 0.2,
    "figure.subplot.right": 0.9,
    "figure.subplot.top": 0.85,
    "figure.subplot.wspace": 0.4,
    "text.usetex": False,
}


# --- intersphinx configuration ------------------------------------------------------------------


intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
    "scipy": ("https://docs.scipy.org/doc/scipy/reference", None),
    "matplotlib": ("http://matplotlib.org", None),
    "numpy": ("https://docs.scipy.org/doc/numpy/", None),
}
