/* automatically generated by rust-bindgen 0.63.0 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    const UNINIT: ::std::mem::MaybeUninit<__sigset_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__val) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_internal_list> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__prev) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__next) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
impl Default for __pthread_internal_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_mutex_s> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__lock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__owner) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__nusers) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__kind) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__spins) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__elision) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__list) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
impl Default for __pthread_mutex_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__low) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__high) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_cond_s__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__wseq) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__wseq32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq32)
        )
    );
}
impl Default for __pthread_cond_s__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for __pthread_cond_s__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "__pthread_cond_s__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__low) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__high) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_cond_s__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__g1_start) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__g1_start32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start32)
        )
    );
}
impl Default for __pthread_cond_s__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for __pthread_cond_s__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "__pthread_cond_s__bindgen_ty_2 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout___pthread_cond_s() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_cond_s> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s>(),
        48usize,
        concat!("Size of: ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__g_refs) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_refs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__g_size) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__g1_orig_size) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_orig_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__wrefs) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wrefs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__g_signals) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_signals)
        )
    );
}
impl Default for __pthread_cond_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for __pthread_cond_s {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "__pthread_cond_s {{ __bindgen_anon_1: {:?}, __bindgen_anon_2: {:?}, __g_refs: {:?}, __g_size: {:?}, __g1_orig_size: {:?}, __wrefs: {:?}, __g_signals: {:?} }}" , self . __bindgen_anon_1 , self . __bindgen_anon_2 , self . __g_refs , self . __g_size , self . __g1_orig_size , self . __wrefs , self . __g_signals)
    }
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    const UNINIT: ::std::mem::MaybeUninit<pthread_mutex_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__align) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_mutex_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for pthread_mutex_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_mutex_t {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    const UNINIT: ::std::mem::MaybeUninit<pthread_cond_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__align) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Default for pthread_cond_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for pthread_cond_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "pthread_cond_t {{ union }}")
    }
}
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: usize,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    const UNINIT: ::std::mem::MaybeUninit<_IO_FILE> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_ptr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_end) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_base) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_base) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_ptr) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_end) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_buf_base) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_buf_end) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_save_base) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_backup_base) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_save_end) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._markers) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._chain) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._fileno) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._flags2) as usize - ptr as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._old_offset) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._cur_column) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._vtable_offset) as usize - ptr as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._shortbuf) as usize - ptr as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._lock) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._offset) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._codecvt) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_codecvt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._wide_data) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_wide_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._freeres_list) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_list)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._freeres_buf) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_buf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad5) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._mode) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._unused2) as usize - ptr as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
#[test]
fn bindgen_test_layout___jmp_buf_tag() {
    const UNINIT: ::std::mem::MaybeUninit<__jmp_buf_tag> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__jmp_buf_tag>(),
        200usize,
        concat!("Size of: ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__jmp_buf_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__jmpbuf) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__jmpbuf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__mask_was_saved) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__mask_was_saved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__saved_mask) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__saved_mask)
        )
    );
}
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
pub type guint8 = ::std::os::raw::c_uchar;
pub type gchar = ::std::os::raw::c_char;
pub type guint = ::std::os::raw::c_uint;
pub type gpointer = *mut ::std::os::raw::c_void;
pub type GArray = _GArray;
pub type GByteArray = _GByteArray;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GArray {
    pub data: *mut gchar,
    pub len: guint,
}
#[test]
fn bindgen_test_layout__GArray() {
    const UNINIT: ::std::mem::MaybeUninit<_GArray> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_GArray>(),
        16usize,
        concat!("Size of: ", stringify!(_GArray))
    );
    assert_eq!(
        ::std::mem::align_of::<_GArray>(),
        8usize,
        concat!("Alignment of ", stringify!(_GArray))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GArray),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GArray),
            "::",
            stringify!(len)
        )
    );
}
impl Default for _GArray {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GByteArray {
    pub data: *mut guint8,
    pub len: guint,
}
#[test]
fn bindgen_test_layout__GByteArray() {
    const UNINIT: ::std::mem::MaybeUninit<_GByteArray> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_GByteArray>(),
        16usize,
        concat!("Size of: ", stringify!(_GByteArray))
    );
    assert_eq!(
        ::std::mem::align_of::<_GByteArray>(),
        8usize,
        concat!("Alignment of ", stringify!(_GByteArray))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GByteArray),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GByteArray),
            "::",
            stringify!(len)
        )
    );
}
impl Default for _GByteArray {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GHashTable {
    _unused: [u8; 0],
}
pub type GHashTable = _GHashTable;
pub type GSList = _GSList;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GSList {
    pub data: gpointer,
    pub next: *mut GSList,
}
#[test]
fn bindgen_test_layout__GSList() {
    const UNINIT: ::std::mem::MaybeUninit<_GSList> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_GSList>(),
        16usize,
        concat!("Size of: ", stringify!(_GSList))
    );
    assert_eq!(
        ::std::mem::align_of::<_GSList>(),
        8usize,
        concat!("Alignment of ", stringify!(_GSList))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSList),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GSList),
            "::",
            stringify!(next)
        )
    );
}
impl Default for _GSList {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AddressSpace {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Clock {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPUAddressSpace {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPUJumpCache {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Error {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JSONWriter {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryRegion {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryRegionSection {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QDict {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QEMUFile {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QObject {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RAMBlock {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Visitor {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VMChangeStateEntry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IRQState {
    _unused: [u8; 0],
}
pub type qemu_irq = *mut IRQState;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QEnumLookup {
    pub array: *const *const ::std::os::raw::c_char,
    pub special_features: *const ::std::os::raw::c_uchar,
    pub size: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_QEnumLookup() {
    const UNINIT: ::std::mem::MaybeUninit<QEnumLookup> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<QEnumLookup>(),
        24usize,
        concat!("Size of: ", stringify!(QEnumLookup))
    );
    assert_eq!(
        ::std::mem::align_of::<QEnumLookup>(),
        8usize,
        concat!("Alignment of ", stringify!(QEnumLookup))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).array) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(QEnumLookup),
            "::",
            stringify!(array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).special_features) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(QEnumLookup),
            "::",
            stringify!(special_features)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(QEnumLookup),
            "::",
            stringify!(size)
        )
    );
}
impl Default for QEnumLookup {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QTailQLink {
    pub tql_next: *mut ::std::os::raw::c_void,
    pub tql_prev: *mut QTailQLink,
}
#[test]
fn bindgen_test_layout_QTailQLink() {
    const UNINIT: ::std::mem::MaybeUninit<QTailQLink> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<QTailQLink>(),
        16usize,
        concat!("Size of: ", stringify!(QTailQLink))
    );
    assert_eq!(
        ::std::mem::align_of::<QTailQLink>(),
        8usize,
        concat!("Alignment of ", stringify!(QTailQLink))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tql_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(QTailQLink),
            "::",
            stringify!(tql_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tql_prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(QTailQLink),
            "::",
            stringify!(tql_prev)
        )
    );
}
impl Default for QTailQLink {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct QemuMutex {
    pub lock: pthread_mutex_t,
    pub initialized: bool,
}
#[test]
fn bindgen_test_layout_QemuMutex() {
    const UNINIT: ::std::mem::MaybeUninit<QemuMutex> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<QemuMutex>(),
        48usize,
        concat!("Size of: ", stringify!(QemuMutex))
    );
    assert_eq!(
        ::std::mem::align_of::<QemuMutex>(),
        8usize,
        concat!("Alignment of ", stringify!(QemuMutex))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(QemuMutex),
            "::",
            stringify!(lock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).initialized) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(QemuMutex),
            "::",
            stringify!(initialized)
        )
    );
}
impl Default for QemuMutex {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for QemuMutex {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "QemuMutex {{ lock: {:?}, initialized: {:?} }}",
            self.lock, self.initialized
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct QemuCond {
    pub cond: pthread_cond_t,
    pub initialized: bool,
}
#[test]
fn bindgen_test_layout_QemuCond() {
    const UNINIT: ::std::mem::MaybeUninit<QemuCond> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<QemuCond>(),
        56usize,
        concat!("Size of: ", stringify!(QemuCond))
    );
    assert_eq!(
        ::std::mem::align_of::<QemuCond>(),
        8usize,
        concat!("Alignment of ", stringify!(QemuCond))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cond) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(QemuCond),
            "::",
            stringify!(cond)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).initialized) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(QemuCond),
            "::",
            stringify!(initialized)
        )
    );
}
impl Default for QemuCond {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for QemuCond {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "QemuCond {{ cond: {:?}, initialized: {:?} }}",
            self.cond, self.initialized
        )
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct QemuThread {
    pub thread: pthread_t,
}
#[test]
fn bindgen_test_layout_QemuThread() {
    const UNINIT: ::std::mem::MaybeUninit<QemuThread> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<QemuThread>(),
        8usize,
        concat!("Size of: ", stringify!(QemuThread))
    );
    assert_eq!(
        ::std::mem::align_of::<QemuThread>(),
        8usize,
        concat!("Alignment of ", stringify!(QemuThread))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(QemuThread),
            "::",
            stringify!(thread)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Notifier {
    pub notify: ::std::option::Option<
        unsafe extern "C" fn(notifier: *mut Notifier, data: *mut ::std::os::raw::c_void),
    >,
    pub node: Notifier__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Notifier__bindgen_ty_1 {
    pub le_next: *mut Notifier,
    pub le_prev: *mut *mut Notifier,
}
#[test]
fn bindgen_test_layout_Notifier__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<Notifier__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<Notifier__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(Notifier__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<Notifier__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(Notifier__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).le_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Notifier__bindgen_ty_1),
            "::",
            stringify!(le_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).le_prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Notifier__bindgen_ty_1),
            "::",
            stringify!(le_prev)
        )
    );
}
impl Default for Notifier__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_Notifier() {
    const UNINIT: ::std::mem::MaybeUninit<Notifier> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<Notifier>(),
        24usize,
        concat!("Size of: ", stringify!(Notifier))
    );
    assert_eq!(
        ::std::mem::align_of::<Notifier>(),
        8usize,
        concat!("Alignment of ", stringify!(Notifier))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).notify) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Notifier),
            "::",
            stringify!(notify)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Notifier),
            "::",
            stringify!(node)
        )
    );
}
impl Default for Notifier {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type RCUCBFunc = ::std::option::Option<unsafe extern "C" fn(head: *mut rcu_head)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rcu_head {
    pub next: *mut rcu_head,
    pub func: RCUCBFunc,
}
#[test]
fn bindgen_test_layout_rcu_head() {
    const UNINIT: ::std::mem::MaybeUninit<rcu_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rcu_head>(),
        16usize,
        concat!("Size of: ", stringify!(rcu_head))
    );
    assert_eq!(
        ::std::mem::align_of::<rcu_head>(),
        8usize,
        concat!("Alignment of ", stringify!(rcu_head))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rcu_head),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).func) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rcu_head),
            "::",
            stringify!(func)
        )
    );
}
impl Default for rcu_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeImpl {
    _unused: [u8; 0],
}
pub type Type = *mut TypeImpl;
#[doc = " typedef ObjectPropertyAccessor:\n @obj: the object that owns the property\n @v: the visitor that contains the property data\n @name: the name of the property\n @opaque: the object property opaque\n @errp: a pointer to an Error that is filled if getting/setting fails.\n\n Called when trying to get/set a property."]
pub type ObjectPropertyAccessor = ::std::option::Option<
    unsafe extern "C" fn(
        obj: *mut Object,
        v: *mut Visitor,
        name: *const ::std::os::raw::c_char,
        opaque: *mut ::std::os::raw::c_void,
        errp: *mut *mut Error,
    ),
>;
#[doc = " typedef ObjectPropertyResolve:\n @obj: the object that owns the property\n @opaque: the opaque registered with the property\n @part: the name of the property\n\n Resolves the #Object corresponding to property @part.\n\n The returned object can also be used as a starting point\n to resolve a relative path starting with \"@part\".\n\n Returns: If @path is the path that led to @obj, the function\n returns the #Object corresponding to \"@path/@part\".\n If \"@path/@part\" is not a valid object path, it returns #NULL."]
pub type ObjectPropertyResolve = ::std::option::Option<
    unsafe extern "C" fn(
        obj: *mut Object,
        opaque: *mut ::std::os::raw::c_void,
        part: *const ::std::os::raw::c_char,
    ) -> *mut Object,
>;
#[doc = " typedef ObjectPropertyRelease:\n @obj: the object that owns the property\n @name: the name of the property\n @opaque: the opaque registered with the property\n\n Called when a property is removed from a object."]
pub type ObjectPropertyRelease = ::std::option::Option<
    unsafe extern "C" fn(
        obj: *mut Object,
        name: *const ::std::os::raw::c_char,
        opaque: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " typedef ObjectPropertyInit:\n @obj: the object that owns the property\n @prop: the property to set\n\n Called when a property is initialized."]
pub type ObjectPropertyInit =
    ::std::option::Option<unsafe extern "C" fn(obj: *mut Object, prop: *mut ObjectProperty)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectProperty {
    pub name: *mut ::std::os::raw::c_char,
    pub type_: *mut ::std::os::raw::c_char,
    pub description: *mut ::std::os::raw::c_char,
    pub get: ObjectPropertyAccessor,
    pub set: ObjectPropertyAccessor,
    pub resolve: ObjectPropertyResolve,
    pub release: ObjectPropertyRelease,
    pub init: ObjectPropertyInit,
    pub opaque: *mut ::std::os::raw::c_void,
    pub defval: *mut QObject,
}
#[test]
fn bindgen_test_layout_ObjectProperty() {
    const UNINIT: ::std::mem::MaybeUninit<ObjectProperty> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ObjectProperty>(),
        80usize,
        concat!("Size of: ", stringify!(ObjectProperty))
    );
    assert_eq!(
        ::std::mem::align_of::<ObjectProperty>(),
        8usize,
        concat!("Alignment of ", stringify!(ObjectProperty))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).description) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(get)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(set)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).resolve) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(resolve)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).release) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(release)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opaque) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(opaque)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).defval) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectProperty),
            "::",
            stringify!(defval)
        )
    );
}
impl Default for ObjectProperty {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " typedef ObjectUnparent:\n @obj: the object that is being removed from the composition tree\n\n Called when an object is being removed from the QOM composition tree.\n The function should remove any backlinks from children objects to @obj."]
pub type ObjectUnparent = ::std::option::Option<unsafe extern "C" fn(obj: *mut Object)>;
#[doc = " typedef ObjectFree:\n @obj: the object being freed\n\n Called when an object's last reference is removed."]
pub type ObjectFree = ::std::option::Option<unsafe extern "C" fn(obj: *mut ::std::os::raw::c_void)>;
#[doc = " struct ObjectClass:\n\n The base for all classes.  The only thing that #ObjectClass contains is an\n integer type handle."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectClass {
    pub type_: Type,
    pub interfaces: *mut GSList,
    pub object_cast_cache: [*const ::std::os::raw::c_char; 4usize],
    pub class_cast_cache: [*const ::std::os::raw::c_char; 4usize],
    pub unparent: ObjectUnparent,
    pub properties: *mut GHashTable,
}
#[test]
fn bindgen_test_layout_ObjectClass() {
    const UNINIT: ::std::mem::MaybeUninit<ObjectClass> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ObjectClass>(),
        96usize,
        concat!("Size of: ", stringify!(ObjectClass))
    );
    assert_eq!(
        ::std::mem::align_of::<ObjectClass>(),
        8usize,
        concat!("Alignment of ", stringify!(ObjectClass))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectClass),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interfaces) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectClass),
            "::",
            stringify!(interfaces)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).object_cast_cache) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectClass),
            "::",
            stringify!(object_cast_cache)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).class_cast_cache) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectClass),
            "::",
            stringify!(class_cast_cache)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unparent) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectClass),
            "::",
            stringify!(unparent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).properties) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(ObjectClass),
            "::",
            stringify!(properties)
        )
    );
}
impl Default for ObjectClass {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " struct Object:\n\n The base for all objects.  The first member of this object is a pointer to\n a #ObjectClass.  Since C guarantees that the first member of a structure\n always begins at byte 0 of that structure, as long as any sub-object places\n its parent as the first member, we can cast directly to a #Object.\n\n As a result, #Object contains a reference to the objects type as its\n first member.  This allows identification of the real type of the object at\n run time."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Object {
    pub class: *mut ObjectClass,
    pub free: ObjectFree,
    pub properties: *mut GHashTable,
    pub ref_: u32,
    pub parent: *mut Object,
}
#[test]
fn bindgen_test_layout_Object() {
    const UNINIT: ::std::mem::MaybeUninit<Object> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<Object>(),
        40usize,
        concat!("Size of: ", stringify!(Object))
    );
    assert_eq!(
        ::std::mem::align_of::<Object>(),
        8usize,
        concat!("Alignment of ", stringify!(Object))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).class) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Object),
            "::",
            stringify!(class)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).free) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Object),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).properties) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Object),
            "::",
            stringify!(properties)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ref_) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(Object),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(Object),
            "::",
            stringify!(parent)
        )
    );
}
impl Default for Object {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HotplugHandler {
    _unused: [u8; 0],
}
#[doc = " ResettableState:\n Structure holding reset related state. The fields should not be accessed\n directly; the definition is here to allow further inclusion into other\n objects.\n\n @count: Number of reset level the object is into. It is incremented when\n the reset operation starts and decremented when it finishes.\n @hold_phase_pending: flag which indicates that we need to invoke the 'hold'\n phase handler for this object.\n @exit_phase_in_progress: true if we are currently in the exit phase"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ResettableState {
    pub count: ::std::os::raw::c_uint,
    pub hold_phase_pending: bool,
    pub exit_phase_in_progress: bool,
}
#[test]
fn bindgen_test_layout_ResettableState() {
    const UNINIT: ::std::mem::MaybeUninit<ResettableState> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ResettableState>(),
        8usize,
        concat!("Size of: ", stringify!(ResettableState))
    );
    assert_eq!(
        ::std::mem::align_of::<ResettableState>(),
        4usize,
        concat!("Alignment of ", stringify!(ResettableState))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ResettableState),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hold_phase_pending) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ResettableState),
            "::",
            stringify!(hold_phase_pending)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exit_phase_in_progress) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(ResettableState),
            "::",
            stringify!(exit_phase_in_progress)
        )
    );
}
pub type DeviceRealize =
    ::std::option::Option<unsafe extern "C" fn(dev: *mut DeviceState, errp: *mut *mut Error)>;
pub type DeviceUnrealize = ::std::option::Option<unsafe extern "C" fn(dev: *mut DeviceState)>;
pub type DeviceReset = ::std::option::Option<unsafe extern "C" fn(dev: *mut DeviceState)>;
#[doc = " DeviceClass:\n @props: Properties accessing state fields.\n @realize: Callback function invoked when the #DeviceState:realized\n property is changed to %true.\n @unrealize: Callback function invoked when the #DeviceState:realized\n property is changed to %false.\n @hotpluggable: indicates if #DeviceClass is hotpluggable, available\n as readonly \"hotpluggable\" property of #DeviceState instance\n\n # Realization #\n Devices are constructed in two stages,\n 1) object instantiation via object_initialize() and\n 2) device realization via #DeviceState:realized property.\n The former may not fail (and must not abort or exit, since it is called\n during device introspection already), and the latter may return error\n information to the caller and must be re-entrant.\n Trivial field initializations should go into #TypeInfo.instance_init.\n Operations depending on @props static properties should go into @realize.\n After successful realization, setting static properties will fail.\n\n As an interim step, the #DeviceState:realized property can also be\n set with qdev_realize().\n In the future, devices will propagate this state change to their children\n and along busses they expose.\n The point in time will be deferred to machine creation, so that values\n set in @realize will not be introspectable beforehand. Therefore devices\n must not create children during @realize; they should initialize them via\n object_initialize() in their own #TypeInfo.instance_init and forward the\n realization events appropriately.\n\n Any type may override the @realize and/or @unrealize callbacks but needs\n to call the parent type's implementation if keeping their functionality\n is desired. Refer to QOM documentation for further discussion and examples.\n\n <note>\n   <para>\n Since TYPE_DEVICE doesn't implement @realize and @unrealize, types\n derived directly from it need not call their parent's @realize and\n @unrealize.\n For other types consult the documentation and implementation of the\n respective parent types.\n   </para>\n </note>\n\n # Hiding a device #\n To hide a device, a DeviceListener function hide_device() needs to\n be registered.\n It can be used to defer adding a device and therefore hide it from\n the guest. The handler registering to this DeviceListener can save\n the QOpts passed to it for re-using it later. It must return if it\n wants the device to be hidden or visible. When the handler function\n decides the device shall be visible it will be added with\n qdev_device_add() and realized as any other device. Otherwise\n qdev_device_add() will return early without adding the device. The\n guest will not see a \"hidden\" device until it was marked visible\n and qdev_device_add called again.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeviceClass {
    pub parent_class: ObjectClass,
    pub categories: [::std::os::raw::c_ulong; 1usize],
    pub fw_name: *const ::std::os::raw::c_char,
    pub desc: *const ::std::os::raw::c_char,
    pub props_: *mut Property,
    pub user_creatable: bool,
    pub hotpluggable: bool,
    pub reset: DeviceReset,
    pub realize: DeviceRealize,
    pub unrealize: DeviceUnrealize,
    pub vmsd: *const VMStateDescription,
    pub bus_type: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_DeviceClass() {
    const UNINIT: ::std::mem::MaybeUninit<DeviceClass> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<DeviceClass>(),
        176usize,
        concat!("Size of: ", stringify!(DeviceClass))
    );
    assert_eq!(
        ::std::mem::align_of::<DeviceClass>(),
        8usize,
        concat!("Alignment of ", stringify!(DeviceClass))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_class) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).categories) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(categories)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fw_name) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(fw_name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).desc) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).props_) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(props_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).user_creatable) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(user_creatable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hotpluggable) as usize - ptr as usize },
        129usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(hotpluggable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reset) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(reset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).realize) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(realize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unrealize) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(unrealize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmsd) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(vmsd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bus_type) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceClass),
            "::",
            stringify!(bus_type)
        )
    );
}
impl Default for DeviceClass {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedGPIOList {
    pub name: *mut ::std::os::raw::c_char,
    pub in_: *mut qemu_irq,
    pub num_in: ::std::os::raw::c_int,
    pub num_out: ::std::os::raw::c_int,
    pub node: NamedGPIOList__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedGPIOList__bindgen_ty_1 {
    pub le_next: *mut NamedGPIOList,
    pub le_prev: *mut *mut NamedGPIOList,
}
#[test]
fn bindgen_test_layout_NamedGPIOList__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<NamedGPIOList__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<NamedGPIOList__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(NamedGPIOList__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<NamedGPIOList__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(NamedGPIOList__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).le_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedGPIOList__bindgen_ty_1),
            "::",
            stringify!(le_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).le_prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedGPIOList__bindgen_ty_1),
            "::",
            stringify!(le_prev)
        )
    );
}
impl Default for NamedGPIOList__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_NamedGPIOList() {
    const UNINIT: ::std::mem::MaybeUninit<NamedGPIOList> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<NamedGPIOList>(),
        40usize,
        concat!("Size of: ", stringify!(NamedGPIOList))
    );
    assert_eq!(
        ::std::mem::align_of::<NamedGPIOList>(),
        8usize,
        concat!("Alignment of ", stringify!(NamedGPIOList))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedGPIOList),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).in_) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedGPIOList),
            "::",
            stringify!(in_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_in) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedGPIOList),
            "::",
            stringify!(num_in)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_out) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedGPIOList),
            "::",
            stringify!(num_out)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedGPIOList),
            "::",
            stringify!(node)
        )
    );
}
impl Default for NamedGPIOList {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedClockList {
    pub name: *mut ::std::os::raw::c_char,
    pub clock: *mut Clock,
    pub output: bool,
    pub alias: bool,
    pub node: NamedClockList__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedClockList__bindgen_ty_1 {
    pub le_next: *mut NamedClockList,
    pub le_prev: *mut *mut NamedClockList,
}
#[test]
fn bindgen_test_layout_NamedClockList__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<NamedClockList__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<NamedClockList__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(NamedClockList__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<NamedClockList__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(NamedClockList__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).le_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedClockList__bindgen_ty_1),
            "::",
            stringify!(le_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).le_prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedClockList__bindgen_ty_1),
            "::",
            stringify!(le_prev)
        )
    );
}
impl Default for NamedClockList__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_NamedClockList() {
    const UNINIT: ::std::mem::MaybeUninit<NamedClockList> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<NamedClockList>(),
        40usize,
        concat!("Size of: ", stringify!(NamedClockList))
    );
    assert_eq!(
        ::std::mem::align_of::<NamedClockList>(),
        8usize,
        concat!("Alignment of ", stringify!(NamedClockList))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedClockList),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clock) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedClockList),
            "::",
            stringify!(clock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).output) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedClockList),
            "::",
            stringify!(output)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alias) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedClockList),
            "::",
            stringify!(alias)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(NamedClockList),
            "::",
            stringify!(node)
        )
    );
}
impl Default for NamedClockList {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " DeviceState:\n @realized: Indicates whether the device has been fully constructed.\n            When accessed outside big qemu lock, must be accessed with\n            qatomic_load_acquire()\n @reset: ResettableState for the device; handled by Resettable interface.\n\n This structure should not be accessed directly.  We declare it here\n so that it can be embedded in individual device state structures."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeviceState {
    pub parent_obj: Object,
    pub id: *mut ::std::os::raw::c_char,
    pub canonical_path: *mut ::std::os::raw::c_char,
    pub realized: bool,
    pub pending_deleted_event: bool,
    pub pending_deleted_expires_ms: i64,
    pub opts: *mut QDict,
    pub hotplugged: ::std::os::raw::c_int,
    pub allow_unplug_during_migration: bool,
    pub parent_bus: *mut BusState,
    pub gpios: DeviceState__bindgen_ty_1,
    pub clocks: DeviceState__bindgen_ty_2,
    pub child_bus: DeviceState__bindgen_ty_3,
    pub num_child_bus: ::std::os::raw::c_int,
    pub instance_id_alias: ::std::os::raw::c_int,
    pub alias_required_for_version: ::std::os::raw::c_int,
    pub reset: ResettableState,
    pub unplug_blockers: *mut GSList,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeviceState__bindgen_ty_1 {
    pub lh_first: *mut NamedGPIOList,
}
#[test]
fn bindgen_test_layout_DeviceState__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<DeviceState__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<DeviceState__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(DeviceState__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<DeviceState__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(DeviceState__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState__bindgen_ty_1),
            "::",
            stringify!(lh_first)
        )
    );
}
impl Default for DeviceState__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeviceState__bindgen_ty_2 {
    pub lh_first: *mut NamedClockList,
}
#[test]
fn bindgen_test_layout_DeviceState__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<DeviceState__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<DeviceState__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(DeviceState__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<DeviceState__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(DeviceState__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState__bindgen_ty_2),
            "::",
            stringify!(lh_first)
        )
    );
}
impl Default for DeviceState__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeviceState__bindgen_ty_3 {
    pub lh_first: *mut BusState,
}
#[test]
fn bindgen_test_layout_DeviceState__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<DeviceState__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<DeviceState__bindgen_ty_3>(),
        8usize,
        concat!("Size of: ", stringify!(DeviceState__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<DeviceState__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(DeviceState__bindgen_ty_3))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState__bindgen_ty_3),
            "::",
            stringify!(lh_first)
        )
    );
}
impl Default for DeviceState__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_DeviceState() {
    const UNINIT: ::std::mem::MaybeUninit<DeviceState> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<DeviceState>(),
        152usize,
        concat!("Size of: ", stringify!(DeviceState))
    );
    assert_eq!(
        ::std::mem::align_of::<DeviceState>(),
        8usize,
        concat!("Alignment of ", stringify!(DeviceState))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_obj) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(parent_obj)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).canonical_path) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(canonical_path)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).realized) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(realized)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending_deleted_event) as usize - ptr as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(pending_deleted_event)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending_deleted_expires_ms) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(pending_deleted_expires_ms)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opts) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(opts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hotplugged) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(hotplugged)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).allow_unplug_during_migration) as usize - ptr as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(allow_unplug_during_migration)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_bus) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(parent_bus)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gpios) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(gpios)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clocks) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(clocks)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).child_bus) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(child_bus)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_child_bus) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(num_child_bus)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instance_id_alias) as usize - ptr as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(instance_id_alias)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alias_required_for_version) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(alias_required_for_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reset) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(reset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unplug_blockers) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(DeviceState),
            "::",
            stringify!(unplug_blockers)
        )
    );
}
impl Default for DeviceState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct BusChild {
    pub rcu: rcu_head,
    pub child: *mut DeviceState,
    pub index: ::std::os::raw::c_int,
    pub sibling: BusChild__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union BusChild__bindgen_ty_1 {
    pub tqe_next: *mut BusChild,
    pub tqe_circ: QTailQLink,
}
#[test]
fn bindgen_test_layout_BusChild__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<BusChild__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<BusChild__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(BusChild__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<BusChild__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(BusChild__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BusChild__bindgen_ty_1),
            "::",
            stringify!(tqe_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_circ) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BusChild__bindgen_ty_1),
            "::",
            stringify!(tqe_circ)
        )
    );
}
impl Default for BusChild__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for BusChild__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "BusChild__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_BusChild() {
    const UNINIT: ::std::mem::MaybeUninit<BusChild> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<BusChild>(),
        48usize,
        concat!("Size of: ", stringify!(BusChild))
    );
    assert_eq!(
        ::std::mem::align_of::<BusChild>(),
        8usize,
        concat!("Alignment of ", stringify!(BusChild))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rcu) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BusChild),
            "::",
            stringify!(rcu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).child) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(BusChild),
            "::",
            stringify!(child)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(BusChild),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sibling) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(BusChild),
            "::",
            stringify!(sibling)
        )
    );
}
impl Default for BusChild {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for BusChild {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "BusChild {{ rcu: {:?}, child: {:?}, index: {:?}, sibling: {:?} }}",
            self.rcu, self.child, self.index, self.sibling
        )
    }
}
#[doc = " BusState:\n @hotplug_handler: link to a hotplug handler associated with bus.\n @reset: ResettableState for the bus; handled by Resettable interface."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct BusState {
    pub obj: Object,
    pub parent: *mut DeviceState,
    pub name: *mut ::std::os::raw::c_char,
    pub hotplug_handler: *mut HotplugHandler,
    pub max_index: ::std::os::raw::c_int,
    pub realized: bool,
    pub full: bool,
    pub num_children: ::std::os::raw::c_int,
    pub children: BusState__bindgen_ty_1,
    pub sibling: BusState__bindgen_ty_2,
    pub reset: ResettableState,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union BusState__bindgen_ty_1 {
    pub tqh_first: *mut BusChild,
    pub tqh_circ: QTailQLink,
}
#[test]
fn bindgen_test_layout_BusState__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<BusState__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<BusState__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(BusState__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<BusState__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(BusState__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState__bindgen_ty_1),
            "::",
            stringify!(tqh_first)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_circ) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState__bindgen_ty_1),
            "::",
            stringify!(tqh_circ)
        )
    );
}
impl Default for BusState__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for BusState__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "BusState__bindgen_ty_1 {{ union }}")
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BusState__bindgen_ty_2 {
    pub le_next: *mut BusState,
    pub le_prev: *mut *mut BusState,
}
#[test]
fn bindgen_test_layout_BusState__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<BusState__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<BusState__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(BusState__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<BusState__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(BusState__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).le_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState__bindgen_ty_2),
            "::",
            stringify!(le_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).le_prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState__bindgen_ty_2),
            "::",
            stringify!(le_prev)
        )
    );
}
impl Default for BusState__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_BusState() {
    const UNINIT: ::std::mem::MaybeUninit<BusState> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<BusState>(),
        120usize,
        concat!("Size of: ", stringify!(BusState))
    );
    assert_eq!(
        ::std::mem::align_of::<BusState>(),
        8usize,
        concat!("Alignment of ", stringify!(BusState))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).obj) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(obj)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hotplug_handler) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(hotplug_handler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_index) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(max_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).realized) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(realized)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).full) as usize - ptr as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(full)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_children) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(num_children)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).children) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(children)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sibling) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(sibling)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reset) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(BusState),
            "::",
            stringify!(reset)
        )
    );
}
impl Default for BusState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for BusState {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "BusState {{ obj: {:?}, parent: {:?}, name: {:?}, hotplug_handler: {:?}, max_index: {:?}, realized: {:?}, full: {:?}, num_children: {:?}, children: {:?}, sibling: {:?}, reset: {:?} }}" , self . obj , self . parent , self . name , self . hotplug_handler , self . max_index , self . realized , self . full , self . num_children , self . children , self . sibling , self . reset)
    }
}
#[doc = " Property:\n @set_default: true if the default value should be set from @defval,\n    in which case @info->set_default_value must not be NULL\n    (if false then no default value is set by the property system\n     and the field retains whatever value it was given by instance_init).\n @defval: default value for the property. This is used only if @set_default\n     is true."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Property {
    pub name: *const ::std::os::raw::c_char,
    pub info: *const PropertyInfo,
    pub offset: isize,
    pub bitnr: u8,
    pub bitmask: u64,
    pub set_default: bool,
    pub defval: Property__bindgen_ty_1,
    pub arrayoffset: ::std::os::raw::c_int,
    pub arrayinfo: *const PropertyInfo,
    pub arrayfieldsize: ::std::os::raw::c_int,
    pub link_type: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union Property__bindgen_ty_1 {
    pub i: i64,
    pub u: u64,
}
#[test]
fn bindgen_test_layout_Property__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<Property__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<Property__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(Property__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<Property__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(Property__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Property__bindgen_ty_1),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Property__bindgen_ty_1),
            "::",
            stringify!(u)
        )
    );
}
impl Default for Property__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for Property__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "Property__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_Property() {
    const UNINIT: ::std::mem::MaybeUninit<Property> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<Property>(),
        88usize,
        concat!("Size of: ", stringify!(Property))
    );
    assert_eq!(
        ::std::mem::align_of::<Property>(),
        8usize,
        concat!("Alignment of ", stringify!(Property))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bitnr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(bitnr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bitmask) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(bitmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_default) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(set_default)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).defval) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(defval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arrayoffset) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(arrayoffset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arrayinfo) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(arrayinfo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arrayfieldsize) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(arrayfieldsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).link_type) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(Property),
            "::",
            stringify!(link_type)
        )
    );
}
impl Default for Property {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for Property {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "Property {{ name: {:?}, info: {:?}, set_default: {:?}, defval: {:?}, arrayoffset: {:?}, arrayinfo: {:?}, arrayfieldsize: {:?}, link_type: {:?} }}" , self . name , self . info , self . set_default , self . defval , self . arrayoffset , self . arrayinfo , self . arrayfieldsize , self . link_type)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PropertyInfo {
    pub name: *const ::std::os::raw::c_char,
    pub description: *const ::std::os::raw::c_char,
    pub enum_table: *const QEnumLookup,
    pub realized_set_allowed: bool,
    pub print: ::std::option::Option<
        unsafe extern "C" fn(
            obj: *mut Object,
            prop: *mut Property,
            dest: *mut ::std::os::raw::c_char,
            len: usize,
        ) -> ::std::os::raw::c_int,
    >,
    pub set_default_value:
        ::std::option::Option<unsafe extern "C" fn(op: *mut ObjectProperty, prop: *const Property)>,
    pub create: ::std::option::Option<
        unsafe extern "C" fn(
            oc: *mut ObjectClass,
            name: *const ::std::os::raw::c_char,
            prop: *mut Property,
        ) -> *mut ObjectProperty,
    >,
    pub get: ObjectPropertyAccessor,
    pub set: ObjectPropertyAccessor,
    pub release: ObjectPropertyRelease,
}
#[test]
fn bindgen_test_layout_PropertyInfo() {
    const UNINIT: ::std::mem::MaybeUninit<PropertyInfo> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<PropertyInfo>(),
        80usize,
        concat!("Size of: ", stringify!(PropertyInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<PropertyInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(PropertyInfo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).description) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enum_table) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(enum_table)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).realized_set_allowed) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(realized_set_allowed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).print) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(print)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_default_value) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(set_default_value)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(create)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(get)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(set)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).release) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(PropertyInfo),
            "::",
            stringify!(release)
        )
    );
}
impl Default for PropertyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VMStateInfo {
    pub name: *const ::std::os::raw::c_char,
    pub get: ::std::option::Option<
        unsafe extern "C" fn(
            f: *mut QEMUFile,
            pv: *mut ::std::os::raw::c_void,
            size: usize,
            field: *const VMStateField,
        ) -> ::std::os::raw::c_int,
    >,
    pub put: ::std::option::Option<
        unsafe extern "C" fn(
            f: *mut QEMUFile,
            pv: *mut ::std::os::raw::c_void,
            size: usize,
            field: *const VMStateField,
            vmdesc: *mut JSONWriter,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_VMStateInfo() {
    const UNINIT: ::std::mem::MaybeUninit<VMStateInfo> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<VMStateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VMStateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VMStateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VMStateInfo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateInfo),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateInfo),
            "::",
            stringify!(get)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).put) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateInfo),
            "::",
            stringify!(put)
        )
    );
}
impl Default for VMStateInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const VMStateFlags_VMS_SINGLE: VMStateFlags = VMStateFlags(1);
pub const VMStateFlags_VMS_POINTER: VMStateFlags = VMStateFlags(2);
pub const VMStateFlags_VMS_ARRAY: VMStateFlags = VMStateFlags(4);
pub const VMStateFlags_VMS_STRUCT: VMStateFlags = VMStateFlags(8);
pub const VMStateFlags_VMS_VARRAY_INT32: VMStateFlags = VMStateFlags(16);
pub const VMStateFlags_VMS_BUFFER: VMStateFlags = VMStateFlags(32);
pub const VMStateFlags_VMS_ARRAY_OF_POINTER: VMStateFlags = VMStateFlags(64);
pub const VMStateFlags_VMS_VARRAY_UINT16: VMStateFlags = VMStateFlags(128);
pub const VMStateFlags_VMS_VBUFFER: VMStateFlags = VMStateFlags(256);
pub const VMStateFlags_VMS_MULTIPLY: VMStateFlags = VMStateFlags(512);
pub const VMStateFlags_VMS_VARRAY_UINT8: VMStateFlags = VMStateFlags(1024);
pub const VMStateFlags_VMS_VARRAY_UINT32: VMStateFlags = VMStateFlags(2048);
pub const VMStateFlags_VMS_MUST_EXIST: VMStateFlags = VMStateFlags(4096);
pub const VMStateFlags_VMS_ALLOC: VMStateFlags = VMStateFlags(8192);
pub const VMStateFlags_VMS_MULTIPLY_ELEMENTS: VMStateFlags = VMStateFlags(16384);
pub const VMStateFlags_VMS_VSTRUCT: VMStateFlags = VMStateFlags(32768);
impl ::std::ops::BitOr<VMStateFlags> for VMStateFlags {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        VMStateFlags(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for VMStateFlags {
    #[inline]
    fn bitor_assign(&mut self, rhs: VMStateFlags) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<VMStateFlags> for VMStateFlags {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        VMStateFlags(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for VMStateFlags {
    #[inline]
    fn bitand_assign(&mut self, rhs: VMStateFlags) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct VMStateFlags(pub ::std::os::raw::c_uint);
pub const MigrationPriority_MIG_PRI_DEFAULT: MigrationPriority = MigrationPriority(0);
pub const MigrationPriority_MIG_PRI_IOMMU: MigrationPriority = MigrationPriority(1);
pub const MigrationPriority_MIG_PRI_PCI_BUS: MigrationPriority = MigrationPriority(2);
pub const MigrationPriority_MIG_PRI_VIRTIO_MEM: MigrationPriority = MigrationPriority(3);
pub const MigrationPriority_MIG_PRI_GICV3_ITS: MigrationPriority = MigrationPriority(4);
pub const MigrationPriority_MIG_PRI_GICV3: MigrationPriority = MigrationPriority(5);
pub const MigrationPriority_MIG_PRI_MAX: MigrationPriority = MigrationPriority(6);
impl ::std::ops::BitOr<MigrationPriority> for MigrationPriority {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        MigrationPriority(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for MigrationPriority {
    #[inline]
    fn bitor_assign(&mut self, rhs: MigrationPriority) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<MigrationPriority> for MigrationPriority {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        MigrationPriority(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for MigrationPriority {
    #[inline]
    fn bitand_assign(&mut self, rhs: MigrationPriority) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct MigrationPriority(pub ::std::os::raw::c_uint);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VMStateField {
    pub name: *const ::std::os::raw::c_char,
    pub err_hint: *const ::std::os::raw::c_char,
    pub offset: usize,
    pub size: usize,
    pub start: usize,
    pub num: ::std::os::raw::c_int,
    pub num_offset: usize,
    pub size_offset: usize,
    pub info: *const VMStateInfo,
    pub flags: VMStateFlags,
    pub vmsd: *const VMStateDescription,
    pub version_id: ::std::os::raw::c_int,
    pub struct_version_id: ::std::os::raw::c_int,
    pub field_exists: ::std::option::Option<
        unsafe extern "C" fn(
            opaque: *mut ::std::os::raw::c_void,
            version_id: ::std::os::raw::c_int,
        ) -> bool,
    >,
}
#[test]
fn bindgen_test_layout_VMStateField() {
    const UNINIT: ::std::mem::MaybeUninit<VMStateField> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<VMStateField>(),
        104usize,
        concat!("Size of: ", stringify!(VMStateField))
    );
    assert_eq!(
        ::std::mem::align_of::<VMStateField>(),
        8usize,
        concat!("Alignment of ", stringify!(VMStateField))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).err_hint) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(err_hint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_offset) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(num_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size_offset) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(size_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmsd) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(vmsd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version_id) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(version_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).struct_version_id) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(struct_version_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field_exists) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateField),
            "::",
            stringify!(field_exists)
        )
    );
}
impl Default for VMStateField {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VMStateDescription {
    pub name: *const ::std::os::raw::c_char,
    pub unmigratable: ::std::os::raw::c_int,
    pub version_id: ::std::os::raw::c_int,
    pub minimum_version_id: ::std::os::raw::c_int,
    pub priority: MigrationPriority,
    pub pre_load: ::std::option::Option<
        unsafe extern "C" fn(opaque: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub post_load: ::std::option::Option<
        unsafe extern "C" fn(
            opaque: *mut ::std::os::raw::c_void,
            version_id: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub pre_save: ::std::option::Option<
        unsafe extern "C" fn(opaque: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub post_save: ::std::option::Option<
        unsafe extern "C" fn(opaque: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub needed:
        ::std::option::Option<unsafe extern "C" fn(opaque: *mut ::std::os::raw::c_void) -> bool>,
    pub dev_unplug_pending:
        ::std::option::Option<unsafe extern "C" fn(opaque: *mut ::std::os::raw::c_void) -> bool>,
    pub fields: *const VMStateField,
    pub subsections: *mut *const VMStateDescription,
}
#[test]
fn bindgen_test_layout_VMStateDescription() {
    const UNINIT: ::std::mem::MaybeUninit<VMStateDescription> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<VMStateDescription>(),
        88usize,
        concat!("Size of: ", stringify!(VMStateDescription))
    );
    assert_eq!(
        ::std::mem::align_of::<VMStateDescription>(),
        8usize,
        concat!("Alignment of ", stringify!(VMStateDescription))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unmigratable) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(unmigratable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version_id) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(version_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).minimum_version_id) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(minimum_version_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).priority) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(priority)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pre_load) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(pre_load)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).post_load) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(post_load)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pre_save) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(pre_save)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).post_save) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(post_save)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).needed) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(needed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dev_unplug_pending) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(dev_unplug_pending)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(fields)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subsections) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VMStateDescription),
            "::",
            stringify!(subsections)
        )
    );
}
impl Default for VMStateDescription {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type PTR = *mut ::std::os::raw::c_void;
pub type bfd_vma = u64;
pub type bfd_byte = u8;
pub const bfd_flavour_bfd_target_unknown_flavour: bfd_flavour = bfd_flavour(0);
pub const bfd_flavour_bfd_target_aout_flavour: bfd_flavour = bfd_flavour(1);
pub const bfd_flavour_bfd_target_coff_flavour: bfd_flavour = bfd_flavour(2);
pub const bfd_flavour_bfd_target_ecoff_flavour: bfd_flavour = bfd_flavour(3);
pub const bfd_flavour_bfd_target_elf_flavour: bfd_flavour = bfd_flavour(4);
pub const bfd_flavour_bfd_target_ieee_flavour: bfd_flavour = bfd_flavour(5);
pub const bfd_flavour_bfd_target_nlm_flavour: bfd_flavour = bfd_flavour(6);
pub const bfd_flavour_bfd_target_oasys_flavour: bfd_flavour = bfd_flavour(7);
pub const bfd_flavour_bfd_target_tekhex_flavour: bfd_flavour = bfd_flavour(8);
pub const bfd_flavour_bfd_target_srec_flavour: bfd_flavour = bfd_flavour(9);
pub const bfd_flavour_bfd_target_ihex_flavour: bfd_flavour = bfd_flavour(10);
pub const bfd_flavour_bfd_target_som_flavour: bfd_flavour = bfd_flavour(11);
pub const bfd_flavour_bfd_target_os9k_flavour: bfd_flavour = bfd_flavour(12);
pub const bfd_flavour_bfd_target_versados_flavour: bfd_flavour = bfd_flavour(13);
pub const bfd_flavour_bfd_target_msdos_flavour: bfd_flavour = bfd_flavour(14);
pub const bfd_flavour_bfd_target_evax_flavour: bfd_flavour = bfd_flavour(15);
impl ::std::ops::BitOr<bfd_flavour> for bfd_flavour {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        bfd_flavour(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for bfd_flavour {
    #[inline]
    fn bitor_assign(&mut self, rhs: bfd_flavour) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<bfd_flavour> for bfd_flavour {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        bfd_flavour(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for bfd_flavour {
    #[inline]
    fn bitand_assign(&mut self, rhs: bfd_flavour) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct bfd_flavour(pub ::std::os::raw::c_uint);
pub const bfd_endian_BFD_ENDIAN_BIG: bfd_endian = bfd_endian(0);
pub const bfd_endian_BFD_ENDIAN_LITTLE: bfd_endian = bfd_endian(1);
pub const bfd_endian_BFD_ENDIAN_UNKNOWN: bfd_endian = bfd_endian(2);
impl ::std::ops::BitOr<bfd_endian> for bfd_endian {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        bfd_endian(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for bfd_endian {
    #[inline]
    fn bitor_assign(&mut self, rhs: bfd_endian) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<bfd_endian> for bfd_endian {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        bfd_endian(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for bfd_endian {
    #[inline]
    fn bitand_assign(&mut self, rhs: bfd_endian) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct bfd_endian(pub ::std::os::raw::c_uint);
pub const bfd_architecture_bfd_arch_unknown: bfd_architecture = bfd_architecture(0);
pub const bfd_architecture_bfd_arch_obscure: bfd_architecture = bfd_architecture(1);
pub const bfd_architecture_bfd_arch_m68k: bfd_architecture = bfd_architecture(2);
pub const bfd_architecture_bfd_arch_vax: bfd_architecture = bfd_architecture(3);
pub const bfd_architecture_bfd_arch_i960: bfd_architecture = bfd_architecture(4);
pub const bfd_architecture_bfd_arch_a29k: bfd_architecture = bfd_architecture(5);
pub const bfd_architecture_bfd_arch_sparc: bfd_architecture = bfd_architecture(6);
pub const bfd_architecture_bfd_arch_mips: bfd_architecture = bfd_architecture(7);
pub const bfd_architecture_bfd_arch_i386: bfd_architecture = bfd_architecture(8);
pub const bfd_architecture_bfd_arch_we32k: bfd_architecture = bfd_architecture(9);
pub const bfd_architecture_bfd_arch_tahoe: bfd_architecture = bfd_architecture(10);
pub const bfd_architecture_bfd_arch_i860: bfd_architecture = bfd_architecture(11);
pub const bfd_architecture_bfd_arch_romp: bfd_architecture = bfd_architecture(12);
pub const bfd_architecture_bfd_arch_alliant: bfd_architecture = bfd_architecture(13);
pub const bfd_architecture_bfd_arch_convex: bfd_architecture = bfd_architecture(14);
pub const bfd_architecture_bfd_arch_m88k: bfd_architecture = bfd_architecture(15);
pub const bfd_architecture_bfd_arch_pyramid: bfd_architecture = bfd_architecture(16);
pub const bfd_architecture_bfd_arch_h8300: bfd_architecture = bfd_architecture(17);
pub const bfd_architecture_bfd_arch_powerpc: bfd_architecture = bfd_architecture(18);
pub const bfd_architecture_bfd_arch_rs6000: bfd_architecture = bfd_architecture(19);
pub const bfd_architecture_bfd_arch_hppa: bfd_architecture = bfd_architecture(20);
pub const bfd_architecture_bfd_arch_d10v: bfd_architecture = bfd_architecture(21);
pub const bfd_architecture_bfd_arch_z8k: bfd_architecture = bfd_architecture(22);
pub const bfd_architecture_bfd_arch_h8500: bfd_architecture = bfd_architecture(23);
pub const bfd_architecture_bfd_arch_sh: bfd_architecture = bfd_architecture(24);
pub const bfd_architecture_bfd_arch_alpha: bfd_architecture = bfd_architecture(25);
pub const bfd_architecture_bfd_arch_arm: bfd_architecture = bfd_architecture(26);
pub const bfd_architecture_bfd_arch_ns32k: bfd_architecture = bfd_architecture(27);
pub const bfd_architecture_bfd_arch_w65: bfd_architecture = bfd_architecture(28);
pub const bfd_architecture_bfd_arch_tic30: bfd_architecture = bfd_architecture(29);
pub const bfd_architecture_bfd_arch_v850: bfd_architecture = bfd_architecture(30);
pub const bfd_architecture_bfd_arch_arc: bfd_architecture = bfd_architecture(31);
pub const bfd_architecture_bfd_arch_m32r: bfd_architecture = bfd_architecture(32);
pub const bfd_architecture_bfd_arch_mn10200: bfd_architecture = bfd_architecture(33);
pub const bfd_architecture_bfd_arch_mn10300: bfd_architecture = bfd_architecture(34);
pub const bfd_architecture_bfd_arch_avr: bfd_architecture = bfd_architecture(35);
pub const bfd_architecture_bfd_arch_cris: bfd_architecture = bfd_architecture(36);
pub const bfd_architecture_bfd_arch_microblaze: bfd_architecture = bfd_architecture(37);
pub const bfd_architecture_bfd_arch_moxie: bfd_architecture = bfd_architecture(38);
pub const bfd_architecture_bfd_arch_ia64: bfd_architecture = bfd_architecture(39);
pub const bfd_architecture_bfd_arch_nios2: bfd_architecture = bfd_architecture(40);
pub const bfd_architecture_bfd_arch_rx: bfd_architecture = bfd_architecture(41);
pub const bfd_architecture_bfd_arch_loongarch: bfd_architecture = bfd_architecture(42);
pub const bfd_architecture_bfd_arch_last: bfd_architecture = bfd_architecture(43);
impl ::std::ops::BitOr<bfd_architecture> for bfd_architecture {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        bfd_architecture(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for bfd_architecture {
    #[inline]
    fn bitor_assign(&mut self, rhs: bfd_architecture) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<bfd_architecture> for bfd_architecture {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        bfd_architecture(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for bfd_architecture {
    #[inline]
    fn bitand_assign(&mut self, rhs: bfd_architecture) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct bfd_architecture(pub ::std::os::raw::c_uint);
#[repr(C)]
#[derive(Copy, Clone)]
pub struct symbol_cache_entry {
    pub name: *const ::std::os::raw::c_char,
    pub udata: symbol_cache_entry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union symbol_cache_entry__bindgen_ty_1 {
    pub p: PTR,
    pub i: bfd_vma,
}
#[test]
fn bindgen_test_layout_symbol_cache_entry__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<symbol_cache_entry__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<symbol_cache_entry__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(symbol_cache_entry__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<symbol_cache_entry__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(symbol_cache_entry__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).p) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(symbol_cache_entry__bindgen_ty_1),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(symbol_cache_entry__bindgen_ty_1),
            "::",
            stringify!(i)
        )
    );
}
impl Default for symbol_cache_entry__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for symbol_cache_entry__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "symbol_cache_entry__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_symbol_cache_entry() {
    const UNINIT: ::std::mem::MaybeUninit<symbol_cache_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<symbol_cache_entry>(),
        16usize,
        concat!("Size of: ", stringify!(symbol_cache_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<symbol_cache_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(symbol_cache_entry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(symbol_cache_entry),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).udata) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(symbol_cache_entry),
            "::",
            stringify!(udata)
        )
    );
}
impl Default for symbol_cache_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for symbol_cache_entry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "symbol_cache_entry {{ name: {:?}, udata: {:?} }}",
            self.name, self.udata
        )
    }
}
pub type asymbol = symbol_cache_entry;
pub type fprintf_function = ::std::option::Option<
    unsafe extern "C" fn(
        f: *mut FILE,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int,
>;
pub const dis_insn_type_dis_noninsn: dis_insn_type = dis_insn_type(0);
pub const dis_insn_type_dis_nonbranch: dis_insn_type = dis_insn_type(1);
pub const dis_insn_type_dis_branch: dis_insn_type = dis_insn_type(2);
pub const dis_insn_type_dis_condbranch: dis_insn_type = dis_insn_type(3);
pub const dis_insn_type_dis_jsr: dis_insn_type = dis_insn_type(4);
pub const dis_insn_type_dis_condjsr: dis_insn_type = dis_insn_type(5);
pub const dis_insn_type_dis_dref: dis_insn_type = dis_insn_type(6);
pub const dis_insn_type_dis_dref2: dis_insn_type = dis_insn_type(7);
impl ::std::ops::BitOr<dis_insn_type> for dis_insn_type {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        dis_insn_type(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for dis_insn_type {
    #[inline]
    fn bitor_assign(&mut self, rhs: dis_insn_type) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<dis_insn_type> for dis_insn_type {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        dis_insn_type(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for dis_insn_type {
    #[inline]
    fn bitand_assign(&mut self, rhs: dis_insn_type) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct dis_insn_type(pub ::std::os::raw::c_uint);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct disassemble_info {
    pub fprintf_func: fprintf_function,
    pub stream: *mut FILE,
    pub application_data: PTR,
    pub flavour: bfd_flavour,
    pub arch: bfd_architecture,
    pub mach: ::std::os::raw::c_ulong,
    pub endian: bfd_endian,
    pub symbols: *mut *mut asymbol,
    pub num_symbols: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_ulong,
    pub private_data: PTR,
    pub read_memory_func: ::std::option::Option<
        unsafe extern "C" fn(
            memaddr: bfd_vma,
            myaddr: *mut bfd_byte,
            length: ::std::os::raw::c_int,
            info: *mut disassemble_info,
        ) -> ::std::os::raw::c_int,
    >,
    pub memory_error_func: ::std::option::Option<
        unsafe extern "C" fn(
            status: ::std::os::raw::c_int,
            memaddr: bfd_vma,
            info: *mut disassemble_info,
        ),
    >,
    pub print_address_func:
        ::std::option::Option<unsafe extern "C" fn(addr: bfd_vma, info: *mut disassemble_info)>,
    pub print_insn: ::std::option::Option<
        unsafe extern "C" fn(addr: bfd_vma, info: *mut disassemble_info) -> ::std::os::raw::c_int,
    >,
    pub symbol_at_address_func: ::std::option::Option<
        unsafe extern "C" fn(addr: bfd_vma, info: *mut disassemble_info) -> ::std::os::raw::c_int,
    >,
    pub buffer: *const bfd_byte,
    pub buffer_vma: bfd_vma,
    pub buffer_length: ::std::os::raw::c_int,
    pub bytes_per_line: ::std::os::raw::c_int,
    pub bytes_per_chunk: ::std::os::raw::c_int,
    pub display_endian: bfd_endian,
    pub insn_info_valid: ::std::os::raw::c_char,
    pub branch_delay_insns: ::std::os::raw::c_char,
    pub data_size: ::std::os::raw::c_char,
    pub insn_type: dis_insn_type,
    pub target: bfd_vma,
    pub target2: bfd_vma,
    pub disassembler_options: *mut ::std::os::raw::c_char,
    pub target_info: i64,
    pub cap_arch: ::std::os::raw::c_int,
    pub cap_mode: ::std::os::raw::c_int,
    pub cap_insn_unit: ::std::os::raw::c_int,
    pub cap_insn_split: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_disassemble_info() {
    const UNINIT: ::std::mem::MaybeUninit<disassemble_info> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<disassemble_info>(),
        208usize,
        concat!("Size of: ", stringify!(disassemble_info))
    );
    assert_eq!(
        ::std::mem::align_of::<disassemble_info>(),
        8usize,
        concat!("Alignment of ", stringify!(disassemble_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fprintf_func) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(fprintf_func)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stream) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(stream)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).application_data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(application_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flavour) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(flavour)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arch) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(arch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mach) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(mach)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).endian) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(endian)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).symbols) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(symbols)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_symbols) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(num_symbols)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).private_data) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(private_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_memory_func) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(read_memory_func)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).memory_error_func) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(memory_error_func)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).print_address_func) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(print_address_func)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).print_insn) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(print_insn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).symbol_at_address_func) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(symbol_at_address_func)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer_vma) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(buffer_vma)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer_length) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(buffer_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes_per_line) as usize - ptr as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(bytes_per_line)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes_per_chunk) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(bytes_per_chunk)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).display_endian) as usize - ptr as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(display_endian)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).insn_info_valid) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(insn_info_valid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).branch_delay_insns) as usize - ptr as usize },
        153usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(branch_delay_insns)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_size) as usize - ptr as usize },
        154usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(data_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).insn_type) as usize - ptr as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(insn_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).target) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).target2) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(target2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).disassembler_options) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(disassembler_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).target_info) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(target_info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cap_arch) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(cap_arch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cap_mode) as usize - ptr as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(cap_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cap_insn_unit) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(cap_insn_unit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cap_insn_split) as usize - ptr as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(disassemble_info),
            "::",
            stringify!(cap_insn_split)
        )
    );
}
impl Default for disassemble_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " vaddr:\n Type wide enough to contain any #target_ulong virtual address."]
pub type vaddr = u64;
extern "C" {
    pub fn cpu_memory_rw_debug(
        cpu: *mut CPUState,
        addr: vaddr,
        ptr: *mut ::std::os::raw::c_void,
        len: usize,
        is_write: bool,
    ) -> ::std::os::raw::c_int;
}
pub type hwaddr = u64;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct MemTxAttrs {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
}
#[test]
fn bindgen_test_layout_MemTxAttrs() {
    assert_eq!(
        ::std::mem::size_of::<MemTxAttrs>(),
        4usize,
        concat!("Size of: ", stringify!(MemTxAttrs))
    );
    assert_eq!(
        ::std::mem::align_of::<MemTxAttrs>(),
        4usize,
        concat!("Alignment of ", stringify!(MemTxAttrs))
    );
}
impl MemTxAttrs {
    #[inline]
    pub fn unspecified(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_unspecified(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn secure(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_secure(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn user(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_user(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn memory(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn requester_id(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_requester_id(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn byte_swap(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_byte_swap(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn target_tlb_bit0(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_target_tlb_bit0(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn target_tlb_bit1(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_target_tlb_bit1(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn target_tlb_bit2(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_target_tlb_bit2(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        unspecified: ::std::os::raw::c_uint,
        secure: ::std::os::raw::c_uint,
        user: ::std::os::raw::c_uint,
        memory: ::std::os::raw::c_uint,
        requester_id: ::std::os::raw::c_uint,
        byte_swap: ::std::os::raw::c_uint,
        target_tlb_bit0: ::std::os::raw::c_uint,
        target_tlb_bit1: ::std::os::raw::c_uint,
        target_tlb_bit2: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let unspecified: u32 = unsafe { ::std::mem::transmute(unspecified) };
            unspecified as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let secure: u32 = unsafe { ::std::mem::transmute(secure) };
            secure as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let user: u32 = unsafe { ::std::mem::transmute(user) };
            user as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let memory: u32 = unsafe { ::std::mem::transmute(memory) };
            memory as u64
        });
        __bindgen_bitfield_unit.set(4usize, 16u8, {
            let requester_id: u32 = unsafe { ::std::mem::transmute(requester_id) };
            requester_id as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let byte_swap: u32 = unsafe { ::std::mem::transmute(byte_swap) };
            byte_swap as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let target_tlb_bit0: u32 = unsafe { ::std::mem::transmute(target_tlb_bit0) };
            target_tlb_bit0 as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let target_tlb_bit1: u32 = unsafe { ::std::mem::transmute(target_tlb_bit1) };
            target_tlb_bit1 as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let target_tlb_bit2: u32 = unsafe { ::std::mem::transmute(target_tlb_bit2) };
            target_tlb_bit2 as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const qemu_plugin_mem_rw_QEMU_PLUGIN_MEM_R: qemu_plugin_mem_rw = qemu_plugin_mem_rw(1);
pub const qemu_plugin_mem_rw_QEMU_PLUGIN_MEM_W: qemu_plugin_mem_rw = qemu_plugin_mem_rw(2);
pub const qemu_plugin_mem_rw_QEMU_PLUGIN_MEM_RW: qemu_plugin_mem_rw = qemu_plugin_mem_rw(3);
impl ::std::ops::BitOr<qemu_plugin_mem_rw> for qemu_plugin_mem_rw {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        qemu_plugin_mem_rw(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for qemu_plugin_mem_rw {
    #[inline]
    fn bitor_assign(&mut self, rhs: qemu_plugin_mem_rw) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<qemu_plugin_mem_rw> for qemu_plugin_mem_rw {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        qemu_plugin_mem_rw(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for qemu_plugin_mem_rw {
    #[inline]
    fn bitand_assign(&mut self, rhs: qemu_plugin_mem_rw) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct qemu_plugin_mem_rw(pub ::std::os::raw::c_uint);
#[doc = " typedef qemu_plugin_meminfo_t - opaque memory transaction handle\n\n This can be further queried using the qemu_plugin_mem_* query\n functions."]
pub type qemu_plugin_meminfo_t = u32;
extern "C" {
    #[doc = " qemu_plugin_hwaddr_phys_addr() - query physical address for memory operation\n @haddr: address handle from qemu_plugin_get_hwaddr()\n\n Returns the physical address associated with the memory operation\n\n Note that the returned physical address may not be unique if you are dealing\n with multiple address spaces."]
    pub fn qemu_plugin_hwaddr_phys_addr(haddr: *const qemu_plugin_hwaddr) -> u64;
}
pub const MemOp_MO_8: MemOp = MemOp(0);
pub const MemOp_MO_16: MemOp = MemOp(1);
pub const MemOp_MO_32: MemOp = MemOp(2);
pub const MemOp_MO_64: MemOp = MemOp(3);
pub const MemOp_MO_128: MemOp = MemOp(4);
pub const MemOp_MO_256: MemOp = MemOp(5);
pub const MemOp_MO_512: MemOp = MemOp(6);
pub const MemOp_MO_1024: MemOp = MemOp(7);
pub const MemOp_MO_SIZE: MemOp = MemOp(7);
pub const MemOp_MO_SIGN: MemOp = MemOp(8);
pub const MemOp_MO_BSWAP: MemOp = MemOp(16);
pub const MemOp_MO_LE: MemOp = MemOp(0);
pub const MemOp_MO_BE: MemOp = MemOp(16);
pub const MemOp_MO_TE: MemOp = MemOp(0);
pub const MemOp_MO_ASHIFT: MemOp = MemOp(5);
pub const MemOp_MO_AMASK: MemOp = MemOp(224);
pub const MemOp_MO_ALIGN: MemOp = MemOp(224);
pub const MemOp_MO_UNALN: MemOp = MemOp(0);
pub const MemOp_MO_ALIGN_2: MemOp = MemOp(32);
pub const MemOp_MO_ALIGN_4: MemOp = MemOp(64);
pub const MemOp_MO_ALIGN_8: MemOp = MemOp(96);
pub const MemOp_MO_ALIGN_16: MemOp = MemOp(128);
pub const MemOp_MO_ALIGN_32: MemOp = MemOp(160);
pub const MemOp_MO_ALIGN_64: MemOp = MemOp(192);
pub const MemOp_MO_UB: MemOp = MemOp(0);
pub const MemOp_MO_UW: MemOp = MemOp(1);
pub const MemOp_MO_UL: MemOp = MemOp(2);
pub const MemOp_MO_UQ: MemOp = MemOp(3);
pub const MemOp_MO_UO: MemOp = MemOp(4);
pub const MemOp_MO_SB: MemOp = MemOp(8);
pub const MemOp_MO_SW: MemOp = MemOp(9);
pub const MemOp_MO_SL: MemOp = MemOp(10);
pub const MemOp_MO_SQ: MemOp = MemOp(11);
pub const MemOp_MO_SO: MemOp = MemOp(12);
pub const MemOp_MO_LEUW: MemOp = MemOp(1);
pub const MemOp_MO_LEUL: MemOp = MemOp(2);
pub const MemOp_MO_LEUQ: MemOp = MemOp(3);
pub const MemOp_MO_LESW: MemOp = MemOp(9);
pub const MemOp_MO_LESL: MemOp = MemOp(10);
pub const MemOp_MO_LESQ: MemOp = MemOp(11);
pub const MemOp_MO_BEUW: MemOp = MemOp(17);
pub const MemOp_MO_BEUL: MemOp = MemOp(18);
pub const MemOp_MO_BEUQ: MemOp = MemOp(19);
pub const MemOp_MO_BESW: MemOp = MemOp(25);
pub const MemOp_MO_BESL: MemOp = MemOp(26);
pub const MemOp_MO_BESQ: MemOp = MemOp(27);
pub const MemOp_MO_TEUW: MemOp = MemOp(1);
pub const MemOp_MO_TEUL: MemOp = MemOp(2);
pub const MemOp_MO_TEUQ: MemOp = MemOp(3);
pub const MemOp_MO_TEUO: MemOp = MemOp(4);
pub const MemOp_MO_TESW: MemOp = MemOp(9);
pub const MemOp_MO_TESL: MemOp = MemOp(10);
pub const MemOp_MO_TESQ: MemOp = MemOp(11);
pub const MemOp_MO_SSIZE: MemOp = MemOp(15);
impl ::std::ops::BitOr<MemOp> for MemOp {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        MemOp(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for MemOp {
    #[inline]
    fn bitor_assign(&mut self, rhs: MemOp) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<MemOp> for MemOp {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        MemOp(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for MemOp {
    #[inline]
    fn bitand_assign(&mut self, rhs: MemOp) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct MemOp(pub ::std::os::raw::c_uint);
pub type MemOpIdx = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TCGCPUOps {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SysemuCPUOps {
    _unused: [u8; 0],
}
#[doc = " CPUClass:\n @class_by_name: Callback to map -cpu command line model name to an\n instantiatable CPU type.\n @parse_features: Callback to parse command line arguments.\n @reset_dump_flags: #CPUDumpFlags to use for reset logging.\n @has_work: Callback for checking if there is work to do.\n @memory_rw_debug: Callback for GDB memory access.\n @dump_state: Callback for dumping state.\n @get_arch_id: Callback for getting architecture-dependent CPU ID.\n @set_pc: Callback for setting the Program Counter register. This\n       should have the semantics used by the target architecture when\n       setting the PC from a source such as an ELF file entry point;\n       for example on Arm it will also set the Thumb mode bit based\n       on the least significant bit of the new PC value.\n       If the target behaviour here is anything other than \"set\n       the PC register to the value passed in\" then the target must\n       also implement the synchronize_from_tb hook.\n @get_pc: Callback for getting the Program Counter register.\n       As above, with the semantics of the target architecture.\n @gdb_read_register: Callback for letting GDB read a register.\n @gdb_write_register: Callback for letting GDB write a register.\n @gdb_adjust_breakpoint: Callback for adjusting the address of a\n       breakpoint.  Used by AVR to handle a gdb mis-feature with\n       its Harvard architecture split code and data.\n @gdb_num_core_regs: Number of core registers accessible to GDB.\n @gdb_core_xml_file: File name for core registers GDB XML description.\n @gdb_stop_before_watchpoint: Indicates whether GDB expects the CPU to stop\n           before the insn which triggers a watchpoint rather than after it.\n @gdb_arch_name: Optional callback that returns the architecture name known\n to GDB. The caller must free the returned string with g_free.\n @gdb_get_dynamic_xml: Callback to return dynamically generated XML for the\n   gdb stub. Returns a pointer to the XML contents for the specified XML file\n   or NULL if the CPU doesn't have a dynamically generated content for it.\n @disas_set_info: Setup architecture specific components of disassembly info\n @adjust_watchpoint_address: Perform a target-specific adjustment to an\n address before attempting to match it against watchpoints.\n @deprecation_note: If this CPUClass is deprecated, this field provides\n                    related information.\n\n Represents a CPU family or model."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPUClass {
    pub parent_class: DeviceClass,
    pub class_by_name: ::std::option::Option<
        unsafe extern "C" fn(cpu_model: *const ::std::os::raw::c_char) -> *mut ObjectClass,
    >,
    pub parse_features: ::std::option::Option<
        unsafe extern "C" fn(
            typename: *const ::std::os::raw::c_char,
            str_: *mut ::std::os::raw::c_char,
            errp: *mut *mut Error,
        ),
    >,
    pub has_work: ::std::option::Option<unsafe extern "C" fn(cpu: *mut CPUState) -> bool>,
    pub memory_rw_debug: ::std::option::Option<
        unsafe extern "C" fn(
            cpu: *mut CPUState,
            addr: vaddr,
            buf: *mut u8,
            len: ::std::os::raw::c_int,
            is_write: bool,
        ) -> ::std::os::raw::c_int,
    >,
    pub dump_state: ::std::option::Option<
        unsafe extern "C" fn(cpu: *mut CPUState, arg1: *mut FILE, flags: ::std::os::raw::c_int),
    >,
    pub get_arch_id: ::std::option::Option<unsafe extern "C" fn(cpu: *mut CPUState) -> i64>,
    pub set_pc: ::std::option::Option<unsafe extern "C" fn(cpu: *mut CPUState, value: vaddr)>,
    pub get_pc: ::std::option::Option<unsafe extern "C" fn(cpu: *mut CPUState) -> vaddr>,
    pub gdb_read_register: ::std::option::Option<
        unsafe extern "C" fn(
            cpu: *mut CPUState,
            buf: *mut GByteArray,
            reg: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub gdb_write_register: ::std::option::Option<
        unsafe extern "C" fn(
            cpu: *mut CPUState,
            buf: *mut u8,
            reg: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub gdb_adjust_breakpoint:
        ::std::option::Option<unsafe extern "C" fn(cpu: *mut CPUState, addr: vaddr) -> vaddr>,
    pub gdb_core_xml_file: *const ::std::os::raw::c_char,
    pub gdb_arch_name:
        ::std::option::Option<unsafe extern "C" fn(cpu: *mut CPUState) -> *mut gchar>,
    pub gdb_get_dynamic_xml: ::std::option::Option<
        unsafe extern "C" fn(
            cpu: *mut CPUState,
            xmlname: *const ::std::os::raw::c_char,
        ) -> *const ::std::os::raw::c_char,
    >,
    pub disas_set_info: ::std::option::Option<
        unsafe extern "C" fn(cpu: *mut CPUState, info: *mut disassemble_info),
    >,
    pub deprecation_note: *const ::std::os::raw::c_char,
    pub accel_cpu: *mut AccelCPUClass,
    pub sysemu_ops: *const SysemuCPUOps,
    pub tcg_ops: *const TCGCPUOps,
    pub init_accel_cpu: ::std::option::Option<
        unsafe extern "C" fn(accel_cpu: *mut AccelCPUClass, cc: *mut CPUClass),
    >,
    pub reset_dump_flags: ::std::os::raw::c_int,
    pub gdb_num_core_regs: ::std::os::raw::c_int,
    pub gdb_stop_before_watchpoint: bool,
}
#[test]
fn bindgen_test_layout_CPUClass() {
    const UNINIT: ::std::mem::MaybeUninit<CPUClass> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUClass>(),
        352usize,
        concat!("Size of: ", stringify!(CPUClass))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUClass>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUClass))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_class) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).class_by_name) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(class_by_name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parse_features) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(parse_features)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_work) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(has_work)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).memory_rw_debug) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(memory_rw_debug)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dump_state) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(dump_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_arch_id) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(get_arch_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_pc) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(set_pc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_pc) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(get_pc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_read_register) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(gdb_read_register)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_write_register) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(gdb_write_register)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_adjust_breakpoint) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(gdb_adjust_breakpoint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_core_xml_file) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(gdb_core_xml_file)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_arch_name) as usize - ptr as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(gdb_arch_name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_get_dynamic_xml) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(gdb_get_dynamic_xml)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).disas_set_info) as usize - ptr as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(disas_set_info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deprecation_note) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(deprecation_note)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).accel_cpu) as usize - ptr as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(accel_cpu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sysemu_ops) as usize - ptr as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(sysemu_ops)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tcg_ops) as usize - ptr as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(tcg_ops)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init_accel_cpu) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(init_accel_cpu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reset_dump_flags) as usize - ptr as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(reset_dump_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_num_core_regs) as usize - ptr as usize },
        340usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(gdb_num_core_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_stop_before_watchpoint) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUClass),
            "::",
            stringify!(gdb_stop_before_watchpoint)
        )
    );
}
impl Default for CPUClass {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union IcountDecr {
    pub u32_: u32,
    pub u16_: IcountDecr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IcountDecr__bindgen_ty_1 {
    pub low: u16,
    pub high: u16,
}
#[test]
fn bindgen_test_layout_IcountDecr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<IcountDecr__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<IcountDecr__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(IcountDecr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<IcountDecr__bindgen_ty_1>(),
        2usize,
        concat!("Alignment of ", stringify!(IcountDecr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).low) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(IcountDecr__bindgen_ty_1),
            "::",
            stringify!(low)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).high) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(IcountDecr__bindgen_ty_1),
            "::",
            stringify!(high)
        )
    );
}
#[test]
fn bindgen_test_layout_IcountDecr() {
    const UNINIT: ::std::mem::MaybeUninit<IcountDecr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<IcountDecr>(),
        4usize,
        concat!("Size of: ", stringify!(IcountDecr))
    );
    assert_eq!(
        ::std::mem::align_of::<IcountDecr>(),
        4usize,
        concat!("Alignment of ", stringify!(IcountDecr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u32_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(IcountDecr),
            "::",
            stringify!(u32_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u16_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(IcountDecr),
            "::",
            stringify!(u16_)
        )
    );
}
impl Default for IcountDecr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for IcountDecr {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "IcountDecr {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct CPUBreakpoint {
    pub pc: vaddr,
    pub flags: ::std::os::raw::c_int,
    pub entry: CPUBreakpoint__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPUBreakpoint__bindgen_ty_1 {
    pub tqe_next: *mut CPUBreakpoint,
    pub tqe_circ: QTailQLink,
}
#[test]
fn bindgen_test_layout_CPUBreakpoint__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<CPUBreakpoint__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUBreakpoint__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(CPUBreakpoint__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUBreakpoint__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUBreakpoint__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUBreakpoint__bindgen_ty_1),
            "::",
            stringify!(tqe_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_circ) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUBreakpoint__bindgen_ty_1),
            "::",
            stringify!(tqe_circ)
        )
    );
}
impl Default for CPUBreakpoint__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUBreakpoint__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "CPUBreakpoint__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_CPUBreakpoint() {
    const UNINIT: ::std::mem::MaybeUninit<CPUBreakpoint> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUBreakpoint>(),
        32usize,
        concat!("Size of: ", stringify!(CPUBreakpoint))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUBreakpoint>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUBreakpoint))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pc) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUBreakpoint),
            "::",
            stringify!(pc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUBreakpoint),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entry) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUBreakpoint),
            "::",
            stringify!(entry)
        )
    );
}
impl Default for CPUBreakpoint {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUBreakpoint {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "CPUBreakpoint {{ flags: {:?}, entry: {:?} }}",
            self.flags, self.entry
        )
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct CPUWatchpoint {
    pub vaddr: vaddr,
    pub len: vaddr,
    pub hitaddr: vaddr,
    pub hitattrs: MemTxAttrs,
    pub flags: ::std::os::raw::c_int,
    pub entry: CPUWatchpoint__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPUWatchpoint__bindgen_ty_1 {
    pub tqe_next: *mut CPUWatchpoint,
    pub tqe_circ: QTailQLink,
}
#[test]
fn bindgen_test_layout_CPUWatchpoint__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<CPUWatchpoint__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUWatchpoint__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(CPUWatchpoint__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUWatchpoint__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUWatchpoint__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUWatchpoint__bindgen_ty_1),
            "::",
            stringify!(tqe_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_circ) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUWatchpoint__bindgen_ty_1),
            "::",
            stringify!(tqe_circ)
        )
    );
}
impl Default for CPUWatchpoint__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUWatchpoint__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "CPUWatchpoint__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_CPUWatchpoint() {
    const UNINIT: ::std::mem::MaybeUninit<CPUWatchpoint> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUWatchpoint>(),
        48usize,
        concat!("Size of: ", stringify!(CPUWatchpoint))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUWatchpoint>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUWatchpoint))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUWatchpoint),
            "::",
            stringify!(vaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUWatchpoint),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hitaddr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUWatchpoint),
            "::",
            stringify!(hitaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hitattrs) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUWatchpoint),
            "::",
            stringify!(hitattrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUWatchpoint),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entry) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUWatchpoint),
            "::",
            stringify!(entry)
        )
    );
}
impl Default for CPUWatchpoint {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUWatchpoint {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "CPUWatchpoint {{ hitattrs: {:?}, flags: {:?}, entry: {:?} }}",
            self.hitattrs, self.flags, self.entry
        )
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SavedIOTLB {
    pub section: *mut MemoryRegionSection,
    pub mr_offset: hwaddr,
}
#[test]
fn bindgen_test_layout_SavedIOTLB() {
    const UNINIT: ::std::mem::MaybeUninit<SavedIOTLB> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<SavedIOTLB>(),
        16usize,
        concat!("Size of: ", stringify!(SavedIOTLB))
    );
    assert_eq!(
        ::std::mem::align_of::<SavedIOTLB>(),
        8usize,
        concat!("Alignment of ", stringify!(SavedIOTLB))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).section) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SavedIOTLB),
            "::",
            stringify!(section)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mr_offset) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SavedIOTLB),
            "::",
            stringify!(mr_offset)
        )
    );
}
impl Default for SavedIOTLB {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct KVMState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kvm_run {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hax_vcpu_state {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvf_vcpu_state {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_work_item {
    _unused: [u8; 0],
}
#[doc = " CPUState:\n @cpu_index: CPU index (informative).\n @cluster_index: Identifies which cluster this CPU is in.\n   For boards which don't define clusters or for \"loose\" CPUs not assigned\n   to a cluster this will be UNASSIGNED_CLUSTER_INDEX; otherwise it will\n   be the same as the cluster-id property of the CPU object's TYPE_CPU_CLUSTER\n   QOM parent.\n @tcg_cflags: Pre-computed cflags for this cpu.\n @nr_cores: Number of cores within this CPU package.\n @nr_threads: Number of threads within this CPU.\n @running: #true if CPU is currently running (lockless).\n @has_waiter: #true if a CPU is currently waiting for the cpu_exec_end;\n valid under cpu_list_lock.\n @created: Indicates whether the CPU thread has been successfully created.\n @interrupt_request: Indicates a pending interrupt request.\n @halted: Nonzero if the CPU is in suspended state.\n @stop: Indicates a pending stop request.\n @stopped: Indicates the CPU has been artificially stopped.\n @unplug: Indicates a pending CPU unplug request.\n @crash_occurred: Indicates the OS reported a crash (panic) for this CPU\n @singlestep_enabled: Flags for single-stepping.\n @icount_extra: Instructions until next timer event.\n @can_do_io: Nonzero if memory-mapped IO is safe. Deterministic execution\n requires that IO only be performed on the last instruction of a TB\n so that interrupts take effect immediately.\n @cpu_ases: Pointer to array of CPUAddressSpaces (which define the\n            AddressSpaces this CPU has)\n @num_ases: number of CPUAddressSpaces in @cpu_ases\n @as: Pointer to the first AddressSpace, for the convenience of targets which\n      only have a single AddressSpace\n @env_ptr: Pointer to subclass-specific CPUArchState field.\n @icount_decr_ptr: Pointer to IcountDecr field within subclass.\n @gdb_regs: Additional GDB registers.\n @gdb_num_regs: Number of total registers accessible to GDB.\n @gdb_num_g_regs: Number of registers in GDB 'g' packets.\n @next_cpu: Next CPU sharing TB cache.\n @opaque: User data.\n @mem_io_pc: Host Program Counter at which the memory was accessed.\n @kvm_fd: vCPU file descriptor for KVM.\n @work_mutex: Lock to prevent multiple access to @work_list.\n @work_list: List of pending asynchronous work.\n @trace_dstate_delayed: Delayed changes to trace_dstate (includes all changes\n                        to @trace_dstate).\n @trace_dstate: Dynamic tracing state of events for this vCPU (bitmask).\n @plugin_mask: Plugin event bitmap. Modified only via async work.\n @ignore_memory_transaction_failures: Cached copy of the MachineState\n    flag of the same name: allows the board to suppress calling of the\n    CPU do_transaction_failed hook function.\n @kvm_dirty_gfns: Points to the KVM dirty ring for this CPU when KVM dirty\n    ring is enabled.\n @kvm_fetch_index: Keeps the index that we last fetched from the per-vCPU\n    dirty ring structure.\n\n State of one CPU core or thread."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct CPUState {
    pub parent_obj: DeviceState,
    pub cc: *mut CPUClass,
    pub nr_cores: ::std::os::raw::c_int,
    pub nr_threads: ::std::os::raw::c_int,
    pub thread: *mut QemuThread,
    pub thread_id: ::std::os::raw::c_int,
    pub running: bool,
    pub has_waiter: bool,
    pub halt_cond: *mut QemuCond,
    pub thread_kicked: bool,
    pub created: bool,
    pub stop: bool,
    pub stopped: bool,
    pub start_powered_off: bool,
    pub unplug: bool,
    pub crash_occurred: bool,
    pub exit_request: bool,
    pub in_exclusive_context: bool,
    pub cflags_next_tb: u32,
    pub interrupt_request: u32,
    pub singlestep_enabled: ::std::os::raw::c_int,
    pub icount_budget: i64,
    pub icount_extra: i64,
    pub random_seed: u64,
    pub jmp_env: sigjmp_buf,
    pub work_mutex: QemuMutex,
    pub work_list: CPUState__bindgen_ty_1,
    pub cpu_ases: *mut CPUAddressSpace,
    pub num_ases: ::std::os::raw::c_int,
    pub as_: *mut AddressSpace,
    pub memory: *mut MemoryRegion,
    pub env_ptr: *mut CPUArchState,
    pub icount_decr_ptr: *mut IcountDecr,
    pub tb_jmp_cache: *mut CPUJumpCache,
    pub gdb_regs: *mut GDBRegisterState,
    pub gdb_num_regs: ::std::os::raw::c_int,
    pub gdb_num_g_regs: ::std::os::raw::c_int,
    pub node: CPUState__bindgen_ty_2,
    pub breakpoints: CPUState__bindgen_ty_3,
    pub watchpoints: CPUState__bindgen_ty_4,
    pub watchpoint_hit: *mut CPUWatchpoint,
    pub opaque: *mut ::std::os::raw::c_void,
    pub mem_io_pc: usize,
    pub kvm_fd: ::std::os::raw::c_int,
    pub kvm_state: *mut KVMState,
    pub kvm_run: *mut kvm_run,
    pub kvm_dirty_gfns: *mut kvm_dirty_gfn,
    pub kvm_fetch_index: u32,
    pub dirty_pages: u64,
    pub trace_dstate_delayed: [::std::os::raw::c_ulong; 1usize],
    pub trace_dstate: [::std::os::raw::c_ulong; 1usize],
    pub plugin_mask: [::std::os::raw::c_ulong; 1usize],
    pub plugin_mem_cbs: *mut GArray,
    pub saved_iotlb: SavedIOTLB,
    pub cpu_index: ::std::os::raw::c_int,
    pub cluster_index: ::std::os::raw::c_int,
    pub tcg_cflags: u32,
    pub halted: u32,
    pub can_do_io: u32,
    pub exception_index: i32,
    pub vcpu_dirty: bool,
    pub throttle_thread_scheduled: bool,
    pub throttle_us_per_full: i64,
    pub ignore_memory_transaction_failures: bool,
    pub prctl_unalign_sigbus: bool,
    pub hax_vcpu: *mut hax_vcpu_state,
    pub hvf: *mut hvf_vcpu_state,
    pub iommu_notifiers: *mut GArray,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPUState__bindgen_ty_1 {
    pub sqh_first: *mut qemu_work_item,
    pub sqh_last: *mut *mut qemu_work_item,
}
#[test]
fn bindgen_test_layout_CPUState__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<CPUState__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUState__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(CPUState__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUState__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUState__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sqh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState__bindgen_ty_1),
            "::",
            stringify!(sqh_first)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sqh_last) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState__bindgen_ty_1),
            "::",
            stringify!(sqh_last)
        )
    );
}
impl Default for CPUState__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPUState__bindgen_ty_2 {
    pub tqe_next: *mut CPUState,
    pub tqe_circ: QTailQLink,
}
#[test]
fn bindgen_test_layout_CPUState__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<CPUState__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUState__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(CPUState__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUState__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUState__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState__bindgen_ty_2),
            "::",
            stringify!(tqe_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_circ) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState__bindgen_ty_2),
            "::",
            stringify!(tqe_circ)
        )
    );
}
impl Default for CPUState__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUState__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "CPUState__bindgen_ty_2 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPUState__bindgen_ty_3 {
    pub tqh_first: *mut CPUBreakpoint,
    pub tqh_circ: QTailQLink,
}
#[test]
fn bindgen_test_layout_CPUState__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<CPUState__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUState__bindgen_ty_3>(),
        16usize,
        concat!("Size of: ", stringify!(CPUState__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUState__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUState__bindgen_ty_3))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState__bindgen_ty_3),
            "::",
            stringify!(tqh_first)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_circ) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState__bindgen_ty_3),
            "::",
            stringify!(tqh_circ)
        )
    );
}
impl Default for CPUState__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUState__bindgen_ty_3 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "CPUState__bindgen_ty_3 {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPUState__bindgen_ty_4 {
    pub tqh_first: *mut CPUWatchpoint,
    pub tqh_circ: QTailQLink,
}
#[test]
fn bindgen_test_layout_CPUState__bindgen_ty_4() {
    const UNINIT: ::std::mem::MaybeUninit<CPUState__bindgen_ty_4> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUState__bindgen_ty_4>(),
        16usize,
        concat!("Size of: ", stringify!(CPUState__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUState__bindgen_ty_4>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUState__bindgen_ty_4))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState__bindgen_ty_4),
            "::",
            stringify!(tqh_first)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_circ) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState__bindgen_ty_4),
            "::",
            stringify!(tqh_circ)
        )
    );
}
impl Default for CPUState__bindgen_ty_4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUState__bindgen_ty_4 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "CPUState__bindgen_ty_4 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_CPUState() {
    const UNINIT: ::std::mem::MaybeUninit<CPUState> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUState>(),
        816usize,
        concat!("Size of: ", stringify!(CPUState))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUState>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUState))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_obj) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(parent_obj)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cc) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(cc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_cores) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(nr_cores)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_threads) as usize - ptr as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(nr_threads)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(thread)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread_id) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(thread_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).running) as usize - ptr as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(running)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_waiter) as usize - ptr as usize },
        181usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(has_waiter)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).halt_cond) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(halt_cond)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread_kicked) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(thread_kicked)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).created) as usize - ptr as usize },
        193usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(created)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stop) as usize - ptr as usize },
        194usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(stop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stopped) as usize - ptr as usize },
        195usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(stopped)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_powered_off) as usize - ptr as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(start_powered_off)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unplug) as usize - ptr as usize },
        197usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(unplug)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crash_occurred) as usize - ptr as usize },
        198usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(crash_occurred)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exit_request) as usize - ptr as usize },
        199usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(exit_request)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).in_exclusive_context) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(in_exclusive_context)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cflags_next_tb) as usize - ptr as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(cflags_next_tb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interrupt_request) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(interrupt_request)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).singlestep_enabled) as usize - ptr as usize },
        212usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(singlestep_enabled)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).icount_budget) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(icount_budget)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).icount_extra) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(icount_extra)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).random_seed) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(random_seed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).jmp_env) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(jmp_env)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).work_mutex) as usize - ptr as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(work_mutex)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).work_list) as usize - ptr as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(work_list)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu_ases) as usize - ptr as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(cpu_ases)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_ases) as usize - ptr as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(num_ases)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).as_) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(as_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).memory) as usize - ptr as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).env_ptr) as usize - ptr as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(env_ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).icount_decr_ptr) as usize - ptr as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(icount_decr_ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tb_jmp_cache) as usize - ptr as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(tb_jmp_cache)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_regs) as usize - ptr as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(gdb_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_num_regs) as usize - ptr as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(gdb_num_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdb_num_g_regs) as usize - ptr as usize },
        572usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(gdb_num_g_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).breakpoints) as usize - ptr as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(breakpoints)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).watchpoints) as usize - ptr as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(watchpoints)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).watchpoint_hit) as usize - ptr as usize },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(watchpoint_hit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opaque) as usize - ptr as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(opaque)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mem_io_pc) as usize - ptr as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(mem_io_pc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_fd) as usize - ptr as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(kvm_fd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_state) as usize - ptr as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(kvm_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_run) as usize - ptr as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(kvm_run)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_dirty_gfns) as usize - ptr as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(kvm_dirty_gfns)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_fetch_index) as usize - ptr as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(kvm_fetch_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dirty_pages) as usize - ptr as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(dirty_pages)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trace_dstate_delayed) as usize - ptr as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(trace_dstate_delayed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trace_dstate) as usize - ptr as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(trace_dstate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).plugin_mask) as usize - ptr as usize },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(plugin_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).plugin_mem_cbs) as usize - ptr as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(plugin_mem_cbs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).saved_iotlb) as usize - ptr as usize },
        728usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(saved_iotlb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu_index) as usize - ptr as usize },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(cpu_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cluster_index) as usize - ptr as usize },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(cluster_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tcg_cflags) as usize - ptr as usize },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(tcg_cflags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).halted) as usize - ptr as usize },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(halted)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).can_do_io) as usize - ptr as usize },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(can_do_io)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_index) as usize - ptr as usize },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(exception_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vcpu_dirty) as usize - ptr as usize },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(vcpu_dirty)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).throttle_thread_scheduled) as usize - ptr as usize },
        769usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(throttle_thread_scheduled)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).throttle_us_per_full) as usize - ptr as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(throttle_us_per_full)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).ignore_memory_transaction_failures) as usize - ptr as usize
        },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(ignore_memory_transaction_failures)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prctl_unalign_sigbus) as usize - ptr as usize },
        785usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(prctl_unalign_sigbus)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hax_vcpu) as usize - ptr as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(hax_vcpu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hvf) as usize - ptr as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(hvf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iommu_notifiers) as usize - ptr as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUState),
            "::",
            stringify!(iommu_notifiers)
        )
    );
}
impl Default for CPUState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUState {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "CPUState {{ parent_obj: {:?}, cc: {:?}, nr_cores: {:?}, nr_threads: {:?}, thread: {:?}, thread_id: {:?}, running: {:?}, has_waiter: {:?}, halt_cond: {:?}, thread_kicked: {:?}, created: {:?}, stop: {:?}, stopped: {:?}, start_powered_off: {:?}, unplug: {:?}, crash_occurred: {:?}, exit_request: {:?}, in_exclusive_context: {:?}, singlestep_enabled: {:?}, jmp_env: {:?}, work_mutex: {:?}, work_list: {:?}, cpu_ases: {:?}, num_ases: {:?}, as: {:?}, memory: {:?}, env_ptr: {:?}, icount_decr_ptr: {:?}, tb_jmp_cache: {:?}, gdb_regs: {:?}, gdb_num_regs: {:?}, gdb_num_g_regs: {:?}, node: {:?}, breakpoints: {:?}, watchpoints: {:?}, watchpoint_hit: {:?}, opaque: {:?}, kvm_fd: {:?}, kvm_state: {:?}, kvm_run: {:?}, kvm_dirty_gfns: {:?}, trace_dstate_delayed: {:?}, trace_dstate: {:?}, plugin_mask: {:?}, plugin_mem_cbs: {:?}, saved_iotlb: {:?}, cpu_index: {:?}, cluster_index: {:?}, vcpu_dirty: {:?}, throttle_thread_scheduled: {:?}, ignore_memory_transaction_failures: {:?}, prctl_unalign_sigbus: {:?}, hax_vcpu: {:?}, hvf: {:?}, iommu_notifiers: {:?} }}" , self . parent_obj , self . cc , self . nr_cores , self . nr_threads , self . thread , self . thread_id , self . running , self . has_waiter , self . halt_cond , self . thread_kicked , self . created , self . stop , self . stopped , self . start_powered_off , self . unplug , self . crash_occurred , self . exit_request , self . in_exclusive_context , self . singlestep_enabled , self . jmp_env , self . work_mutex , self . work_list , self . cpu_ases , self . num_ases , self . as_ , self . memory , self . env_ptr , self . icount_decr_ptr , self . tb_jmp_cache , self . gdb_regs , self . gdb_num_regs , self . gdb_num_g_regs , self . node , self . breakpoints , self . watchpoints , self . watchpoint_hit , self . opaque , self . kvm_fd , self . kvm_state , self . kvm_run , self . kvm_dirty_gfns , self . trace_dstate_delayed , self . trace_dstate , self . plugin_mask , self . plugin_mem_cbs , self . saved_iotlb , self . cpu_index , self . cluster_index , self . vcpu_dirty , self . throttle_thread_scheduled , self . ignore_memory_transaction_failures , self . prctl_unalign_sigbus , self . hax_vcpu , self . hvf , self . iommu_notifiers)
    }
}
extern "C" {
    #[doc = " cpu_reset:\n @cpu: The CPU whose state is to be reset."]
    pub fn cpu_reset(cpu: *mut CPUState);
}
#[doc = " X86CPU:\n @env: #CPUX86State\n @migratable: If set, only migratable flags will be accepted when \"enforce\"\n mode is used, and only migratable flags will be included in the \"host\"\n CPU model.\n\n An x86 CPU."]
pub type X86CPU = ArchCPU;
pub type target_long = i64;
pub type target_ulong = u64;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CPUTLB {}
#[test]
fn bindgen_test_layout_CPUTLB() {
    assert_eq!(
        ::std::mem::size_of::<CPUTLB>(),
        0usize,
        concat!("Size of: ", stringify!(CPUTLB))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUTLB>(),
        1usize,
        concat!("Alignment of ", stringify!(CPUTLB))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct CPUNegativeOffsetState {
    pub tlb: CPUTLB,
    pub icount_decr: IcountDecr,
}
#[test]
fn bindgen_test_layout_CPUNegativeOffsetState() {
    const UNINIT: ::std::mem::MaybeUninit<CPUNegativeOffsetState> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUNegativeOffsetState>(),
        4usize,
        concat!("Size of: ", stringify!(CPUNegativeOffsetState))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUNegativeOffsetState>(),
        4usize,
        concat!("Alignment of ", stringify!(CPUNegativeOffsetState))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tlb) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUNegativeOffsetState),
            "::",
            stringify!(tlb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).icount_decr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUNegativeOffsetState),
            "::",
            stringify!(icount_decr)
        )
    );
}
impl Default for CPUNegativeOffsetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUNegativeOffsetState {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "CPUNegativeOffsetState {{ tlb: {:?}, icount_decr: {:?} }}",
            self.tlb, self.icount_decr
        )
    }
}
pub const OnOffAuto_ON_OFF_AUTO_AUTO: OnOffAuto = OnOffAuto(0);
pub const OnOffAuto_ON_OFF_AUTO_ON: OnOffAuto = OnOffAuto(1);
pub const OnOffAuto_ON_OFF_AUTO_OFF: OnOffAuto = OnOffAuto(2);
pub const OnOffAuto_ON_OFF_AUTO__MAX: OnOffAuto = OnOffAuto(3);
impl ::std::ops::BitOr<OnOffAuto> for OnOffAuto {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        OnOffAuto(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for OnOffAuto {
    #[inline]
    fn bitor_assign(&mut self, rhs: OnOffAuto) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<OnOffAuto> for OnOffAuto {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        OnOffAuto(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for OnOffAuto {
    #[inline]
    fn bitand_assign(&mut self, rhs: OnOffAuto) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct OnOffAuto(pub ::std::os::raw::c_uint);
pub type float16 = u16;
pub type float32 = u32;
pub type float64 = u64;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct floatx80 {
    pub low: u64,
    pub high: u16,
}
#[test]
fn bindgen_test_layout_floatx80() {
    const UNINIT: ::std::mem::MaybeUninit<floatx80> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<floatx80>(),
        16usize,
        concat!("Size of: ", stringify!(floatx80))
    );
    assert_eq!(
        ::std::mem::align_of::<floatx80>(),
        8usize,
        concat!("Alignment of ", stringify!(floatx80))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).low) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(floatx80),
            "::",
            stringify!(low)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).high) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(floatx80),
            "::",
            stringify!(high)
        )
    );
}
pub const FloatRoundMode_float_round_nearest_even: FloatRoundMode = FloatRoundMode(0);
pub const FloatRoundMode_float_round_down: FloatRoundMode = FloatRoundMode(1);
pub const FloatRoundMode_float_round_up: FloatRoundMode = FloatRoundMode(2);
pub const FloatRoundMode_float_round_to_zero: FloatRoundMode = FloatRoundMode(3);
pub const FloatRoundMode_float_round_ties_away: FloatRoundMode = FloatRoundMode(4);
pub const FloatRoundMode_float_round_to_odd: FloatRoundMode = FloatRoundMode(5);
pub const FloatRoundMode_float_round_to_odd_inf: FloatRoundMode = FloatRoundMode(6);
impl ::std::ops::BitOr<FloatRoundMode> for FloatRoundMode {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        FloatRoundMode(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for FloatRoundMode {
    #[inline]
    fn bitor_assign(&mut self, rhs: FloatRoundMode) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<FloatRoundMode> for FloatRoundMode {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        FloatRoundMode(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for FloatRoundMode {
    #[inline]
    fn bitand_assign(&mut self, rhs: FloatRoundMode) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct FloatRoundMode(pub ::std::os::raw::c_uchar);
pub const FloatX80RoundPrec_floatx80_precision_x: FloatX80RoundPrec = FloatX80RoundPrec(0);
pub const FloatX80RoundPrec_floatx80_precision_d: FloatX80RoundPrec = FloatX80RoundPrec(1);
pub const FloatX80RoundPrec_floatx80_precision_s: FloatX80RoundPrec = FloatX80RoundPrec(2);
impl ::std::ops::BitOr<FloatX80RoundPrec> for FloatX80RoundPrec {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        FloatX80RoundPrec(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for FloatX80RoundPrec {
    #[inline]
    fn bitor_assign(&mut self, rhs: FloatX80RoundPrec) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<FloatX80RoundPrec> for FloatX80RoundPrec {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        FloatX80RoundPrec(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for FloatX80RoundPrec {
    #[inline]
    fn bitand_assign(&mut self, rhs: FloatX80RoundPrec) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct FloatX80RoundPrec(pub ::std::os::raw::c_uchar);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct float_status {
    pub float_exception_flags: u16,
    pub float_rounding_mode: FloatRoundMode,
    pub floatx80_rounding_precision: FloatX80RoundPrec,
    pub tininess_before_rounding: bool,
    pub flush_to_zero: bool,
    pub flush_inputs_to_zero: bool,
    pub default_nan_mode: bool,
    pub snan_bit_is_one: bool,
    pub use_first_nan: bool,
    pub no_signaling_nans: bool,
    pub rebias_overflow: bool,
    pub rebias_underflow: bool,
}
#[test]
fn bindgen_test_layout_float_status() {
    const UNINIT: ::std::mem::MaybeUninit<float_status> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<float_status>(),
        14usize,
        concat!("Size of: ", stringify!(float_status))
    );
    assert_eq!(
        ::std::mem::align_of::<float_status>(),
        2usize,
        concat!("Alignment of ", stringify!(float_status))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float_exception_flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(float_exception_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).float_rounding_mode) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(float_rounding_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).floatx80_rounding_precision) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(floatx80_rounding_precision)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tininess_before_rounding) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(tininess_before_rounding)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush_to_zero) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(flush_to_zero)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush_inputs_to_zero) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(flush_inputs_to_zero)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).default_nan_mode) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(default_nan_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).snan_bit_is_one) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(snan_bit_is_one)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).use_first_nan) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(use_first_nan)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).no_signaling_nans) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(no_signaling_nans)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rebias_overflow) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(rebias_overflow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rebias_underflow) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(float_status),
            "::",
            stringify!(rebias_underflow)
        )
    );
}
impl Default for float_status {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type FeatureWordArray = [u64; 36usize];
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct SegmentCache {
    pub selector: u32,
    pub base: target_ulong,
    pub limit: u32,
    pub flags: u32,
}
#[test]
fn bindgen_test_layout_SegmentCache() {
    const UNINIT: ::std::mem::MaybeUninit<SegmentCache> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<SegmentCache>(),
        24usize,
        concat!("Size of: ", stringify!(SegmentCache))
    );
    assert_eq!(
        ::std::mem::align_of::<SegmentCache>(),
        8usize,
        concat!("Alignment of ", stringify!(SegmentCache))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).selector) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SegmentCache),
            "::",
            stringify!(selector)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SegmentCache),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).limit) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SegmentCache),
            "::",
            stringify!(limit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(SegmentCache),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union MMXReg {
    pub _b_MMXReg: [u8; 8usize],
    pub _w_MMXReg: [u16; 4usize],
    pub _l_MMXReg: [u32; 2usize],
    pub _q_MMXReg: [u64; 1usize],
    pub _s_MMXReg: [float32; 2usize],
    pub _d_MMXReg: [float64; 1usize],
}
#[test]
fn bindgen_test_layout_MMXReg() {
    const UNINIT: ::std::mem::MaybeUninit<MMXReg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MMXReg>(),
        8usize,
        concat!("Size of: ", stringify!(MMXReg))
    );
    assert_eq!(
        ::std::mem::align_of::<MMXReg>(),
        8usize,
        concat!("Alignment of ", stringify!(MMXReg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._b_MMXReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MMXReg),
            "::",
            stringify!(_b_MMXReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._w_MMXReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MMXReg),
            "::",
            stringify!(_w_MMXReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._l_MMXReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MMXReg),
            "::",
            stringify!(_l_MMXReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._q_MMXReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MMXReg),
            "::",
            stringify!(_q_MMXReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._s_MMXReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MMXReg),
            "::",
            stringify!(_s_MMXReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._d_MMXReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MMXReg),
            "::",
            stringify!(_d_MMXReg)
        )
    );
}
impl Default for MMXReg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for MMXReg {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "MMXReg {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union XMMReg {
    pub _q_XMMReg: [u64; 2usize],
}
#[test]
fn bindgen_test_layout_XMMReg() {
    const UNINIT: ::std::mem::MaybeUninit<XMMReg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<XMMReg>(),
        16usize,
        concat!("Size of: ", stringify!(XMMReg))
    );
    assert_eq!(
        ::std::mem::align_of::<XMMReg>(),
        8usize,
        concat!("Alignment of ", stringify!(XMMReg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._q_XMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(XMMReg),
            "::",
            stringify!(_q_XMMReg)
        )
    );
}
impl Default for XMMReg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for XMMReg {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "XMMReg {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union YMMReg {
    pub _q_YMMReg: [u64; 4usize],
    pub _x_YMMReg: [XMMReg; 2usize],
}
#[test]
fn bindgen_test_layout_YMMReg() {
    const UNINIT: ::std::mem::MaybeUninit<YMMReg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<YMMReg>(),
        32usize,
        concat!("Size of: ", stringify!(YMMReg))
    );
    assert_eq!(
        ::std::mem::align_of::<YMMReg>(),
        8usize,
        concat!("Alignment of ", stringify!(YMMReg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._q_YMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(YMMReg),
            "::",
            stringify!(_q_YMMReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._x_YMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(YMMReg),
            "::",
            stringify!(_x_YMMReg)
        )
    );
}
impl Default for YMMReg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for YMMReg {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "YMMReg {{ union }}")
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ZMMReg {
    pub _b_ZMMReg: [u8; 64usize],
    pub _w_ZMMReg: [u16; 32usize],
    pub _l_ZMMReg: [u32; 16usize],
    pub _q_ZMMReg: [u64; 8usize],
    pub _h_ZMMReg: [float16; 32usize],
    pub _s_ZMMReg: [float32; 16usize],
    pub _d_ZMMReg: [float64; 8usize],
    pub _x_ZMMReg: [XMMReg; 4usize],
    pub _y_ZMMReg: [YMMReg; 2usize],
}
#[test]
fn bindgen_test_layout_ZMMReg() {
    const UNINIT: ::std::mem::MaybeUninit<ZMMReg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ZMMReg>(),
        64usize,
        concat!("Size of: ", stringify!(ZMMReg))
    );
    assert_eq!(
        ::std::mem::align_of::<ZMMReg>(),
        8usize,
        concat!("Alignment of ", stringify!(ZMMReg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._b_ZMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ZMMReg),
            "::",
            stringify!(_b_ZMMReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._w_ZMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ZMMReg),
            "::",
            stringify!(_w_ZMMReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._l_ZMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ZMMReg),
            "::",
            stringify!(_l_ZMMReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._q_ZMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ZMMReg),
            "::",
            stringify!(_q_ZMMReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._h_ZMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ZMMReg),
            "::",
            stringify!(_h_ZMMReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._s_ZMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ZMMReg),
            "::",
            stringify!(_s_ZMMReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._d_ZMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ZMMReg),
            "::",
            stringify!(_d_ZMMReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._x_ZMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ZMMReg),
            "::",
            stringify!(_x_ZMMReg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._y_ZMMReg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ZMMReg),
            "::",
            stringify!(_y_ZMMReg)
        )
    );
}
impl Default for ZMMReg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for ZMMReg {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "ZMMReg {{ union }}")
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BNDReg {
    pub lb: u64,
    pub ub: u64,
}
#[test]
fn bindgen_test_layout_BNDReg() {
    const UNINIT: ::std::mem::MaybeUninit<BNDReg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<BNDReg>(),
        16usize,
        concat!("Size of: ", stringify!(BNDReg))
    );
    assert_eq!(
        ::std::mem::align_of::<BNDReg>(),
        8usize,
        concat!("Alignment of ", stringify!(BNDReg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lb) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BNDReg),
            "::",
            stringify!(lb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ub) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(BNDReg),
            "::",
            stringify!(ub)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BNDCSReg {
    pub cfgu: u64,
    pub sts: u64,
}
#[test]
fn bindgen_test_layout_BNDCSReg() {
    const UNINIT: ::std::mem::MaybeUninit<BNDCSReg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<BNDCSReg>(),
        16usize,
        concat!("Size of: ", stringify!(BNDCSReg))
    );
    assert_eq!(
        ::std::mem::align_of::<BNDCSReg>(),
        8usize,
        concat!("Alignment of ", stringify!(BNDCSReg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cfgu) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BNDCSReg),
            "::",
            stringify!(cfgu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sts) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(BNDCSReg),
            "::",
            stringify!(sts)
        )
    );
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub union FPReg {
    pub d: floatx80,
    pub mmx: MMXReg,
}
#[test]
fn bindgen_test_layout_FPReg() {
    const UNINIT: ::std::mem::MaybeUninit<FPReg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<FPReg>(),
        16usize,
        concat!("Size of: ", stringify!(FPReg))
    );
    assert_eq!(
        ::std::mem::align_of::<FPReg>(),
        16usize,
        concat!("Alignment of ", stringify!(FPReg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(FPReg), "::", stringify!(d))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mmx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FPReg),
            "::",
            stringify!(mmx)
        )
    );
}
impl Default for FPReg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for FPReg {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "FPReg {{ union }}")
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MTRRVar {
    pub base: u64,
    pub mask: u64,
}
#[test]
fn bindgen_test_layout_MTRRVar() {
    const UNINIT: ::std::mem::MaybeUninit<MTRRVar> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MTRRVar>(),
        16usize,
        concat!("Size of: ", stringify!(MTRRVar))
    );
    assert_eq!(
        ::std::mem::align_of::<MTRRVar>(),
        8usize,
        concat!("Alignment of ", stringify!(MTRRVar))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MTRRVar),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mask) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MTRRVar),
            "::",
            stringify!(mask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LBREntry {
    pub from: u64,
    pub to: u64,
    pub info: u64,
}
#[test]
fn bindgen_test_layout_LBREntry() {
    const UNINIT: ::std::mem::MaybeUninit<LBREntry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<LBREntry>(),
        24usize,
        concat!("Size of: ", stringify!(LBREntry))
    );
    assert_eq!(
        ::std::mem::align_of::<LBREntry>(),
        8usize,
        concat!("Alignment of ", stringify!(LBREntry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).from) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LBREntry),
            "::",
            stringify!(from)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).to) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LBREntry),
            "::",
            stringify!(to)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LBREntry),
            "::",
            stringify!(info)
        )
    );
}
pub const TPRAccess_TPR_ACCESS_READ: TPRAccess = TPRAccess(0);
pub const TPRAccess_TPR_ACCESS_WRITE: TPRAccess = TPRAccess(1);
impl ::std::ops::BitOr<TPRAccess> for TPRAccess {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        TPRAccess(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for TPRAccess {
    #[inline]
    fn bitor_assign(&mut self, rhs: TPRAccess) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<TPRAccess> for TPRAccess {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        TPRAccess(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for TPRAccess {
    #[inline]
    fn bitand_assign(&mut self, rhs: TPRAccess) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct TPRAccess(pub ::std::os::raw::c_uint);
pub const CacheType_DATA_CACHE: CacheType = CacheType(0);
pub const CacheType_INSTRUCTION_CACHE: CacheType = CacheType(1);
pub const CacheType_UNIFIED_CACHE: CacheType = CacheType(2);
impl ::std::ops::BitOr<CacheType> for CacheType {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        CacheType(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for CacheType {
    #[inline]
    fn bitor_assign(&mut self, rhs: CacheType) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<CacheType> for CacheType {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        CacheType(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for CacheType {
    #[inline]
    fn bitand_assign(&mut self, rhs: CacheType) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct CacheType(pub ::std::os::raw::c_uint);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPUCacheInfo {
    pub type_: CacheType,
    pub level: u8,
    pub size: u32,
    pub line_size: u16,
    pub associativity: u8,
    pub partitions: u8,
    pub sets: u32,
    pub lines_per_tag: u8,
    pub self_init: bool,
    pub no_invd_sharing: bool,
    pub inclusive: bool,
    pub complex_indexing: bool,
}
#[test]
fn bindgen_test_layout_CPUCacheInfo() {
    const UNINIT: ::std::mem::MaybeUninit<CPUCacheInfo> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUCacheInfo>(),
        28usize,
        concat!("Size of: ", stringify!(CPUCacheInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUCacheInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(CPUCacheInfo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).line_size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(line_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).associativity) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(associativity)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).partitions) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(partitions)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sets) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(sets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lines_per_tag) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(lines_per_tag)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).self_init) as usize - ptr as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(self_init)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).no_invd_sharing) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(no_invd_sharing)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inclusive) as usize - ptr as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(inclusive)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).complex_indexing) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCacheInfo),
            "::",
            stringify!(complex_indexing)
        )
    );
}
impl Default for CPUCacheInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CPUCaches {
    pub l1d_cache: *mut CPUCacheInfo,
    pub l1i_cache: *mut CPUCacheInfo,
    pub l2_cache: *mut CPUCacheInfo,
    pub l3_cache: *mut CPUCacheInfo,
}
#[test]
fn bindgen_test_layout_CPUCaches() {
    const UNINIT: ::std::mem::MaybeUninit<CPUCaches> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUCaches>(),
        32usize,
        concat!("Size of: ", stringify!(CPUCaches))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUCaches>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUCaches))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l1d_cache) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCaches),
            "::",
            stringify!(l1d_cache)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l1i_cache) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCaches),
            "::",
            stringify!(l1i_cache)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l2_cache) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCaches),
            "::",
            stringify!(l2_cache)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l3_cache) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUCaches),
            "::",
            stringify!(l3_cache)
        )
    );
}
impl Default for CPUCaches {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub struct CPUArchState {
    pub regs: [target_ulong; 16usize],
    pub eip: target_ulong,
    pub eflags: target_ulong,
    pub cc_dst: target_ulong,
    pub cc_src: target_ulong,
    pub cc_src2: target_ulong,
    pub cc_op: u32,
    pub df: i32,
    pub hflags: u32,
    pub hflags2: u32,
    pub segs: [SegmentCache; 6usize],
    pub ldt: SegmentCache,
    pub tr: SegmentCache,
    pub gdt: SegmentCache,
    pub idt: SegmentCache,
    pub cr: [target_ulong; 5usize],
    pub pdptrs_valid: bool,
    pub pdptrs: [u64; 4usize],
    pub a20_mask: i32,
    pub bnd_regs: [BNDReg; 4usize],
    pub bndcs_regs: BNDCSReg,
    pub msr_bndcfgs: u64,
    pub efer: u64,
    pub start_init_save: CPUArchState__bindgen_ty_1,
    pub fpstt: ::std::os::raw::c_uint,
    pub fpus: u16,
    pub fpuc: u16,
    pub fptags: [u8; 8usize],
    pub fpregs: [FPReg; 8usize],
    pub fpop: u16,
    pub fpcs: u16,
    pub fpds: u16,
    pub fpip: u64,
    pub fpdp: u64,
    pub fp_status: float_status,
    pub ft0: floatx80,
    pub mmx_status: float_status,
    pub sse_status: float_status,
    pub mxcsr: u32,
    pub __bindgen_padding_0: u64,
    pub xmm_regs: [ZMMReg; 32usize],
    pub xmm_t0: ZMMReg,
    pub mmx_t0: MMXReg,
    pub opmask_regs: [u64; 8usize],
    pub xtilecfg: [u8; 64usize],
    pub xtiledata: [u8; 8192usize],
    pub sysenter_cs: u32,
    pub sysenter_esp: target_ulong,
    pub sysenter_eip: target_ulong,
    pub star: u64,
    pub vm_hsave: u64,
    pub lstar: target_ulong,
    pub cstar: target_ulong,
    pub fmask: target_ulong,
    pub kernelgsbase: target_ulong,
    pub tsc_adjust: u64,
    pub tsc_deadline: u64,
    pub tsc_aux: u64,
    pub xcr0: u64,
    pub mcg_status: u64,
    pub msr_ia32_misc_enable: u64,
    pub msr_ia32_feature_control: u64,
    pub msr_ia32_sgxlepubkeyhash: [u64; 4usize],
    pub msr_fixed_ctr_ctrl: u64,
    pub msr_global_ctrl: u64,
    pub msr_global_status: u64,
    pub msr_global_ovf_ctrl: u64,
    pub msr_fixed_counters: [u64; 3usize],
    pub msr_gp_counters: [u64; 18usize],
    pub msr_gp_evtsel: [u64; 18usize],
    pub pat: u64,
    pub smbase: u32,
    pub msr_smi_count: u64,
    pub pkru: u32,
    pub pkrs: u32,
    pub tsx_ctrl: u32,
    pub spec_ctrl: u64,
    pub amd_tsc_scale_msr: u64,
    pub virt_ssbd: u64,
    pub end_init_save: CPUArchState__bindgen_ty_2,
    pub system_time_msr: u64,
    pub wall_clock_msr: u64,
    pub steal_time_msr: u64,
    pub async_pf_en_msr: u64,
    pub async_pf_int_msr: u64,
    pub pv_eoi_en_msr: u64,
    pub poll_control_msr: u64,
    pub msr_hv_hypercall: u64,
    pub msr_hv_guest_os_id: u64,
    pub msr_hv_tsc: u64,
    pub msr_hv_syndbg_control: u64,
    pub msr_hv_syndbg_status: u64,
    pub msr_hv_syndbg_send_page: u64,
    pub msr_hv_syndbg_recv_page: u64,
    pub msr_hv_syndbg_pending_page: u64,
    pub msr_hv_syndbg_options: u64,
    pub msr_hv_vapic: u64,
    pub msr_hv_crash_params: [u64; 5usize],
    pub msr_hv_runtime: u64,
    pub msr_hv_synic_control: u64,
    pub msr_hv_synic_evt_page: u64,
    pub msr_hv_synic_msg_page: u64,
    pub msr_hv_synic_sint: [u64; 16usize],
    pub msr_hv_stimer_config: [u64; 4usize],
    pub msr_hv_stimer_count: [u64; 4usize],
    pub msr_hv_reenlightenment_control: u64,
    pub msr_hv_tsc_emulation_control: u64,
    pub msr_hv_tsc_emulation_status: u64,
    pub msr_rtit_ctrl: u64,
    pub msr_rtit_status: u64,
    pub msr_rtit_output_base: u64,
    pub msr_rtit_output_mask: u64,
    pub msr_rtit_cr3_match: u64,
    pub msr_rtit_addrs: [u64; 8usize],
    pub msr_xfd: u64,
    pub msr_xfd_err: u64,
    pub msr_lbr_ctl: u64,
    pub msr_lbr_depth: u64,
    pub lbr_records: [LBREntry; 32usize],
    pub error_code: ::std::os::raw::c_int,
    pub exception_is_int: ::std::os::raw::c_int,
    pub exception_next_eip: target_ulong,
    pub dr: [target_ulong; 8usize],
    pub __bindgen_anon_1: CPUArchState__bindgen_ty_3,
    pub old_exception: ::std::os::raw::c_int,
    pub vm_vmcb: u64,
    pub tsc_offset: u64,
    pub intercept: u64,
    pub intercept_cr_read: u16,
    pub intercept_cr_write: u16,
    pub intercept_dr_read: u16,
    pub intercept_dr_write: u16,
    pub intercept_exceptions: u32,
    pub nested_cr3: u64,
    pub nested_pg_mode: u32,
    pub v_tpr: u8,
    pub int_ctl: u32,
    pub nmi_injected: u8,
    pub nmi_pending: u8,
    pub retaddr: usize,
    pub end_reset_fields: CPUArchState__bindgen_ty_4,
    pub cpuid_level_func7: u32,
    pub cpuid_min_level_func7: u32,
    pub cpuid_min_level: u32,
    pub cpuid_min_xlevel: u32,
    pub cpuid_min_xlevel2: u32,
    pub cpuid_max_level: u32,
    pub cpuid_max_xlevel: u32,
    pub cpuid_max_xlevel2: u32,
    pub cpuid_level: u32,
    pub cpuid_xlevel: u32,
    pub cpuid_xlevel2: u32,
    pub cpuid_vendor1: u32,
    pub cpuid_vendor2: u32,
    pub cpuid_vendor3: u32,
    pub cpuid_version: u32,
    pub features: FeatureWordArray,
    pub user_features: FeatureWordArray,
    pub cpuid_model: [u32; 12usize],
    pub cache_info_cpuid2: CPUCaches,
    pub cache_info_cpuid4: CPUCaches,
    pub cache_info_amd: CPUCaches,
    pub mtrr_fixed: [u64; 11usize],
    pub mtrr_deftype: u64,
    pub mtrr_var: [MTRRVar; 8usize],
    pub mp_state: u32,
    pub exception_nr: i32,
    pub interrupt_injected: i32,
    pub soft_interrupt: u8,
    pub exception_pending: u8,
    pub exception_injected: u8,
    pub has_error_code: u8,
    pub exception_has_payload: u8,
    pub exception_payload: u64,
    pub triple_fault_pending: u8,
    pub ins_len: u32,
    pub sipi_vector: u32,
    pub tsc_valid: bool,
    pub tsc_khz: i64,
    pub user_tsc_khz: i64,
    pub apic_bus_freq: u64,
    pub tsc: u64,
    pub mcg_cap: u64,
    pub mcg_ctl: u64,
    pub mcg_ext_ctl: u64,
    pub mce_banks: [u64; 40usize],
    pub xstate_bv: u64,
    pub fpus_vmstate: u16,
    pub fptag_vmstate: u16,
    pub fpregs_format_vmstate: u16,
    pub xss: u64,
    pub umwait: u32,
    pub tpr_access_type: TPRAccess,
    pub nr_dies: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CPUArchState__bindgen_ty_1 {}
#[test]
fn bindgen_test_layout_CPUArchState__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<CPUArchState__bindgen_ty_1>(),
        0usize,
        concat!("Size of: ", stringify!(CPUArchState__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUArchState__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(CPUArchState__bindgen_ty_1))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CPUArchState__bindgen_ty_2 {}
#[test]
fn bindgen_test_layout_CPUArchState__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<CPUArchState__bindgen_ty_2>(),
        0usize,
        concat!("Size of: ", stringify!(CPUArchState__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUArchState__bindgen_ty_2>(),
        1usize,
        concat!("Alignment of ", stringify!(CPUArchState__bindgen_ty_2))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union CPUArchState__bindgen_ty_3 {
    pub cpu_breakpoint: [*mut CPUBreakpoint; 4usize],
    pub cpu_watchpoint: [*mut CPUWatchpoint; 4usize],
}
#[test]
fn bindgen_test_layout_CPUArchState__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<CPUArchState__bindgen_ty_3> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUArchState__bindgen_ty_3>(),
        32usize,
        concat!("Size of: ", stringify!(CPUArchState__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUArchState__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(CPUArchState__bindgen_ty_3))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu_breakpoint) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState__bindgen_ty_3),
            "::",
            stringify!(cpu_breakpoint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu_watchpoint) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState__bindgen_ty_3),
            "::",
            stringify!(cpu_watchpoint)
        )
    );
}
impl Default for CPUArchState__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUArchState__bindgen_ty_3 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "CPUArchState__bindgen_ty_3 {{ union }}")
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CPUArchState__bindgen_ty_4 {}
#[test]
fn bindgen_test_layout_CPUArchState__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<CPUArchState__bindgen_ty_4>(),
        0usize,
        concat!("Size of: ", stringify!(CPUArchState__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUArchState__bindgen_ty_4>(),
        1usize,
        concat!("Alignment of ", stringify!(CPUArchState__bindgen_ty_4))
    );
}
#[test]
fn bindgen_test_layout_CPUArchState() {
    const UNINIT: ::std::mem::MaybeUninit<CPUArchState> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<CPUArchState>(),
        14848usize,
        concat!("Size of: ", stringify!(CPUArchState))
    );
    assert_eq!(
        ::std::mem::align_of::<CPUArchState>(),
        16usize,
        concat!("Alignment of ", stringify!(CPUArchState))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).regs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eip) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(eip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eflags) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(eflags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cc_dst) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cc_dst)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cc_src) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cc_src)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cc_src2) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cc_src2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cc_op) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cc_op)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).df) as usize - ptr as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(df)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hflags) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(hflags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hflags2) as usize - ptr as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(hflags2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).segs) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(segs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ldt) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(ldt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tr) as usize - ptr as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gdt) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(gdt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).idt) as usize - ptr as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(idt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cr) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pdptrs_valid) as usize - ptr as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(pdptrs_valid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pdptrs) as usize - ptr as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(pdptrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).a20_mask) as usize - ptr as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(a20_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bnd_regs) as usize - ptr as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(bnd_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bndcs_regs) as usize - ptr as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(bndcs_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_bndcfgs) as usize - ptr as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_bndcfgs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).efer) as usize - ptr as usize },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(efer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_init_save) as usize - ptr as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(start_init_save)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpstt) as usize - ptr as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpstt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpus) as usize - ptr as usize },
        612usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpus)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpuc) as usize - ptr as usize },
        614usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpuc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fptags) as usize - ptr as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fptags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpregs) as usize - ptr as usize },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpregs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpop) as usize - ptr as usize },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpcs) as usize - ptr as usize },
        754usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpcs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpds) as usize - ptr as usize },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpip) as usize - ptr as usize },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpdp) as usize - ptr as usize },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpdp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_status) as usize - ptr as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fp_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ft0) as usize - ptr as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(ft0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mmx_status) as usize - ptr as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mmx_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sse_status) as usize - ptr as usize },
        822usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(sse_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mxcsr) as usize - ptr as usize },
        836usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xmm_regs) as usize - ptr as usize },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(xmm_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xmm_t0) as usize - ptr as usize },
        2896usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(xmm_t0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mmx_t0) as usize - ptr as usize },
        2960usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mmx_t0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opmask_regs) as usize - ptr as usize },
        2968usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(opmask_regs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xtilecfg) as usize - ptr as usize },
        3032usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(xtilecfg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xtiledata) as usize - ptr as usize },
        3096usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(xtiledata)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sysenter_cs) as usize - ptr as usize },
        11288usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(sysenter_cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sysenter_esp) as usize - ptr as usize },
        11296usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(sysenter_esp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sysenter_eip) as usize - ptr as usize },
        11304usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(sysenter_eip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).star) as usize - ptr as usize },
        11312usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(star)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vm_hsave) as usize - ptr as usize },
        11320usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(vm_hsave)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lstar) as usize - ptr as usize },
        11328usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(lstar)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cstar) as usize - ptr as usize },
        11336usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cstar)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fmask) as usize - ptr as usize },
        11344usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kernelgsbase) as usize - ptr as usize },
        11352usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(kernelgsbase)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tsc_adjust) as usize - ptr as usize },
        11360usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tsc_adjust)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tsc_deadline) as usize - ptr as usize },
        11368usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tsc_deadline)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tsc_aux) as usize - ptr as usize },
        11376usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tsc_aux)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xcr0) as usize - ptr as usize },
        11384usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(xcr0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mcg_status) as usize - ptr as usize },
        11392usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mcg_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_ia32_misc_enable) as usize - ptr as usize },
        11400usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_ia32_misc_enable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_ia32_feature_control) as usize - ptr as usize },
        11408usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_ia32_feature_control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_ia32_sgxlepubkeyhash) as usize - ptr as usize },
        11416usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_ia32_sgxlepubkeyhash)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_fixed_ctr_ctrl) as usize - ptr as usize },
        11448usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_fixed_ctr_ctrl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_global_ctrl) as usize - ptr as usize },
        11456usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_global_ctrl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_global_status) as usize - ptr as usize },
        11464usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_global_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_global_ovf_ctrl) as usize - ptr as usize },
        11472usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_global_ovf_ctrl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_fixed_counters) as usize - ptr as usize },
        11480usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_fixed_counters)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_gp_counters) as usize - ptr as usize },
        11504usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_gp_counters)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_gp_evtsel) as usize - ptr as usize },
        11648usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_gp_evtsel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pat) as usize - ptr as usize },
        11792usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(pat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).smbase) as usize - ptr as usize },
        11800usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(smbase)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_smi_count) as usize - ptr as usize },
        11808usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_smi_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pkru) as usize - ptr as usize },
        11816usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(pkru)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pkrs) as usize - ptr as usize },
        11820usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(pkrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tsx_ctrl) as usize - ptr as usize },
        11824usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tsx_ctrl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).spec_ctrl) as usize - ptr as usize },
        11832usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(spec_ctrl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).amd_tsc_scale_msr) as usize - ptr as usize },
        11840usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(amd_tsc_scale_msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).virt_ssbd) as usize - ptr as usize },
        11848usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(virt_ssbd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end_init_save) as usize - ptr as usize },
        11856usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(end_init_save)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).system_time_msr) as usize - ptr as usize },
        11856usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(system_time_msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wall_clock_msr) as usize - ptr as usize },
        11864usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(wall_clock_msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).steal_time_msr) as usize - ptr as usize },
        11872usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(steal_time_msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).async_pf_en_msr) as usize - ptr as usize },
        11880usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(async_pf_en_msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).async_pf_int_msr) as usize - ptr as usize },
        11888usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(async_pf_int_msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pv_eoi_en_msr) as usize - ptr as usize },
        11896usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(pv_eoi_en_msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).poll_control_msr) as usize - ptr as usize },
        11904usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(poll_control_msr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_hypercall) as usize - ptr as usize },
        11912usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_hypercall)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_guest_os_id) as usize - ptr as usize },
        11920usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_guest_os_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_tsc) as usize - ptr as usize },
        11928usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_tsc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_syndbg_control) as usize - ptr as usize },
        11936usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_syndbg_control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_syndbg_status) as usize - ptr as usize },
        11944usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_syndbg_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_syndbg_send_page) as usize - ptr as usize },
        11952usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_syndbg_send_page)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_syndbg_recv_page) as usize - ptr as usize },
        11960usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_syndbg_recv_page)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_syndbg_pending_page) as usize - ptr as usize },
        11968usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_syndbg_pending_page)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_syndbg_options) as usize - ptr as usize },
        11976usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_syndbg_options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_vapic) as usize - ptr as usize },
        11984usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_vapic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_crash_params) as usize - ptr as usize },
        11992usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_crash_params)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_runtime) as usize - ptr as usize },
        12032usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_runtime)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_synic_control) as usize - ptr as usize },
        12040usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_synic_control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_synic_evt_page) as usize - ptr as usize },
        12048usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_synic_evt_page)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_synic_msg_page) as usize - ptr as usize },
        12056usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_synic_msg_page)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_synic_sint) as usize - ptr as usize },
        12064usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_synic_sint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_stimer_config) as usize - ptr as usize },
        12192usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_stimer_config)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_stimer_count) as usize - ptr as usize },
        12224usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_stimer_count)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).msr_hv_reenlightenment_control) as usize - ptr as usize
        },
        12256usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_reenlightenment_control)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).msr_hv_tsc_emulation_control) as usize - ptr as usize
        },
        12264usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_tsc_emulation_control)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_hv_tsc_emulation_status) as usize - ptr as usize },
        12272usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_hv_tsc_emulation_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_rtit_ctrl) as usize - ptr as usize },
        12280usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_rtit_ctrl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_rtit_status) as usize - ptr as usize },
        12288usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_rtit_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_rtit_output_base) as usize - ptr as usize },
        12296usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_rtit_output_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_rtit_output_mask) as usize - ptr as usize },
        12304usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_rtit_output_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_rtit_cr3_match) as usize - ptr as usize },
        12312usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_rtit_cr3_match)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_rtit_addrs) as usize - ptr as usize },
        12320usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_rtit_addrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_xfd) as usize - ptr as usize },
        12384usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_xfd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_xfd_err) as usize - ptr as usize },
        12392usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_xfd_err)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_lbr_ctl) as usize - ptr as usize },
        12400usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_lbr_ctl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msr_lbr_depth) as usize - ptr as usize },
        12408usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(msr_lbr_depth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lbr_records) as usize - ptr as usize },
        12416usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(lbr_records)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error_code) as usize - ptr as usize },
        13184usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(error_code)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_is_int) as usize - ptr as usize },
        13188usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(exception_is_int)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_next_eip) as usize - ptr as usize },
        13192usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(exception_next_eip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dr) as usize - ptr as usize },
        13200usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(dr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).old_exception) as usize - ptr as usize },
        13296usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(old_exception)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vm_vmcb) as usize - ptr as usize },
        13304usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(vm_vmcb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tsc_offset) as usize - ptr as usize },
        13312usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tsc_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intercept) as usize - ptr as usize },
        13320usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(intercept)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intercept_cr_read) as usize - ptr as usize },
        13328usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(intercept_cr_read)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intercept_cr_write) as usize - ptr as usize },
        13330usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(intercept_cr_write)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intercept_dr_read) as usize - ptr as usize },
        13332usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(intercept_dr_read)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intercept_dr_write) as usize - ptr as usize },
        13334usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(intercept_dr_write)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intercept_exceptions) as usize - ptr as usize },
        13336usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(intercept_exceptions)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nested_cr3) as usize - ptr as usize },
        13344usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(nested_cr3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nested_pg_mode) as usize - ptr as usize },
        13352usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(nested_pg_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v_tpr) as usize - ptr as usize },
        13356usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(v_tpr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).int_ctl) as usize - ptr as usize },
        13360usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(int_ctl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nmi_injected) as usize - ptr as usize },
        13364usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(nmi_injected)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nmi_pending) as usize - ptr as usize },
        13365usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(nmi_pending)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).retaddr) as usize - ptr as usize },
        13368usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(retaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end_reset_fields) as usize - ptr as usize },
        13376usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(end_reset_fields)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_level_func7) as usize - ptr as usize },
        13376usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_level_func7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_min_level_func7) as usize - ptr as usize },
        13380usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_min_level_func7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_min_level) as usize - ptr as usize },
        13384usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_min_level)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_min_xlevel) as usize - ptr as usize },
        13388usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_min_xlevel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_min_xlevel2) as usize - ptr as usize },
        13392usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_min_xlevel2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_max_level) as usize - ptr as usize },
        13396usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_max_level)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_max_xlevel) as usize - ptr as usize },
        13400usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_max_xlevel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_max_xlevel2) as usize - ptr as usize },
        13404usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_max_xlevel2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_level) as usize - ptr as usize },
        13408usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_level)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_xlevel) as usize - ptr as usize },
        13412usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_xlevel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_xlevel2) as usize - ptr as usize },
        13416usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_xlevel2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_vendor1) as usize - ptr as usize },
        13420usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_vendor1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_vendor2) as usize - ptr as usize },
        13424usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_vendor2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_vendor3) as usize - ptr as usize },
        13428usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_vendor3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_version) as usize - ptr as usize },
        13432usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).features) as usize - ptr as usize },
        13440usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(features)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).user_features) as usize - ptr as usize },
        13728usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(user_features)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpuid_model) as usize - ptr as usize },
        14016usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cpuid_model)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cache_info_cpuid2) as usize - ptr as usize },
        14064usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cache_info_cpuid2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cache_info_cpuid4) as usize - ptr as usize },
        14096usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cache_info_cpuid4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cache_info_amd) as usize - ptr as usize },
        14128usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(cache_info_amd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mtrr_fixed) as usize - ptr as usize },
        14160usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mtrr_fixed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mtrr_deftype) as usize - ptr as usize },
        14248usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mtrr_deftype)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mtrr_var) as usize - ptr as usize },
        14256usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mtrr_var)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mp_state) as usize - ptr as usize },
        14384usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mp_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_nr) as usize - ptr as usize },
        14388usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(exception_nr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interrupt_injected) as usize - ptr as usize },
        14392usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(interrupt_injected)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).soft_interrupt) as usize - ptr as usize },
        14396usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(soft_interrupt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_pending) as usize - ptr as usize },
        14397usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(exception_pending)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_injected) as usize - ptr as usize },
        14398usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(exception_injected)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_error_code) as usize - ptr as usize },
        14399usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(has_error_code)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_has_payload) as usize - ptr as usize },
        14400usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(exception_has_payload)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exception_payload) as usize - ptr as usize },
        14408usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(exception_payload)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).triple_fault_pending) as usize - ptr as usize },
        14416usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(triple_fault_pending)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ins_len) as usize - ptr as usize },
        14420usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(ins_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sipi_vector) as usize - ptr as usize },
        14424usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(sipi_vector)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tsc_valid) as usize - ptr as usize },
        14428usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tsc_valid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tsc_khz) as usize - ptr as usize },
        14432usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tsc_khz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).user_tsc_khz) as usize - ptr as usize },
        14440usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(user_tsc_khz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).apic_bus_freq) as usize - ptr as usize },
        14448usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(apic_bus_freq)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tsc) as usize - ptr as usize },
        14456usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tsc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mcg_cap) as usize - ptr as usize },
        14464usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mcg_cap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mcg_ctl) as usize - ptr as usize },
        14472usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mcg_ctl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mcg_ext_ctl) as usize - ptr as usize },
        14480usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mcg_ext_ctl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mce_banks) as usize - ptr as usize },
        14488usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(mce_banks)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xstate_bv) as usize - ptr as usize },
        14808usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(xstate_bv)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpus_vmstate) as usize - ptr as usize },
        14816usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpus_vmstate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fptag_vmstate) as usize - ptr as usize },
        14818usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fptag_vmstate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fpregs_format_vmstate) as usize - ptr as usize },
        14820usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(fpregs_format_vmstate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xss) as usize - ptr as usize },
        14824usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(xss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).umwait) as usize - ptr as usize },
        14832usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(umwait)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tpr_access_type) as usize - ptr as usize },
        14836usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(tpr_access_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_dies) as usize - ptr as usize },
        14840usize,
        concat!(
            "Offset of field: ",
            stringify!(CPUArchState),
            "::",
            stringify!(nr_dies)
        )
    );
}
impl Default for CPUArchState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for CPUArchState {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "CPUArchState {{ regs: {:?}, segs: {:?}, ldt: {:?}, tr: {:?}, gdt: {:?}, idt: {:?}, cr: {:?}, pdptrs_valid: {:?}, pdptrs: {:?}, bnd_regs: {:?}, bndcs_regs: {:?}, start_init_save: {:?}, fpstt: {:?}, fptags: {:?}, fpregs: {:?}, fp_status: {:?}, ft0: {:?}, mmx_status: {:?}, sse_status: {:?}, xmm_regs: {:?}, xmm_t0: {:?}, mmx_t0: {:?}, opmask_regs: {:?}, xtilecfg: {:?}, xtiledata: {:?}, msr_ia32_sgxlepubkeyhash: {:?}, msr_fixed_counters: {:?}, msr_gp_counters: {:?}, msr_gp_evtsel: {:?}, end_init_save: {:?}, msr_hv_crash_params: {:?}, msr_hv_synic_sint: {:?}, msr_hv_stimer_config: {:?}, msr_hv_stimer_count: {:?}, msr_rtit_addrs: {:?}, lbr_records: {:?}, error_code: {:?}, exception_is_int: {:?}, dr: {:?}, __bindgen_anon_1: {:?}, old_exception: {:?}, end_reset_fields: {:?}, features: {:?}, user_features: {:?}, cpuid_model: {:?}, cache_info_cpuid2: {:?}, cache_info_cpuid4: {:?}, cache_info_amd: {:?}, mtrr_fixed: {:?}, mtrr_var: {:?}, tsc_valid: {:?}, mce_banks: {:?}, tpr_access_type: {:?}, nr_dies: {:?} }}" , self . regs , self . segs , self . ldt , self . tr , self . gdt , self . idt , self . cr , self . pdptrs_valid , self . pdptrs , self . bnd_regs , self . bndcs_regs , self . start_init_save , self . fpstt , self . fptags , self . fpregs , self . fp_status , self . ft0 , self . mmx_status , self . sse_status , self . xmm_regs , self . xmm_t0 , self . mmx_t0 , self . opmask_regs , self . xtilecfg , self . xtiledata , self . msr_ia32_sgxlepubkeyhash , self . msr_fixed_counters , self . msr_gp_counters , self . msr_gp_evtsel , self . end_init_save , self . msr_hv_crash_params , self . msr_hv_synic_sint , self . msr_hv_stimer_config , self . msr_hv_stimer_count , self . msr_rtit_addrs , self . lbr_records , self . error_code , self . exception_is_int , self . dr , self . __bindgen_anon_1 , self . old_exception , self . end_reset_fields , self . features , self . user_features , self . cpuid_model , self . cache_info_cpuid2 , self . cache_info_cpuid4 , self . cache_info_amd , self . mtrr_fixed , self . mtrr_var , self . tsc_valid , self . mce_banks , self . tpr_access_type , self . nr_dies)
    }
}
pub type CPUX86State = CPUArchState;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kvm_msrs {
    _unused: [u8; 0],
}
#[doc = " X86CPU:\n @env: #CPUX86State\n @migratable: If set, only migratable flags will be accepted when \"enforce\"\n mode is used, and only migratable flags will be included in the \"host\"\n CPU model.\n\n An x86 CPU."]
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub struct ArchCPU {
    pub parent_obj: CPUState,
    pub neg: CPUNegativeOffsetState,
    pub __bindgen_padding_0: u64,
    pub env: CPUX86State,
    pub vmsentry: *mut VMChangeStateEntry,
    pub ucode_rev: u64,
    pub hyperv_spinlock_attempts: u32,
    pub hyperv_vendor: *mut ::std::os::raw::c_char,
    pub hyperv_synic_kvm_only: bool,
    pub hyperv_features: u64,
    pub hyperv_passthrough: bool,
    pub hyperv_no_nonarch_cs: OnOffAuto,
    pub hyperv_vendor_id: [u32; 3usize],
    pub hyperv_interface_id: [u32; 4usize],
    pub hyperv_limits: [u32; 3usize],
    pub hyperv_enforce_cpuid: bool,
    pub hyperv_ver_id_build: u32,
    pub hyperv_ver_id_major: u16,
    pub hyperv_ver_id_minor: u16,
    pub hyperv_ver_id_sp: u32,
    pub hyperv_ver_id_sb: u8,
    pub hyperv_ver_id_sn: u32,
    pub check_cpuid: bool,
    pub enforce_cpuid: bool,
    pub force_features: bool,
    pub expose_kvm: bool,
    pub expose_tcg: bool,
    pub migratable: bool,
    pub migrate_smi_count: bool,
    pub max_features: bool,
    pub apic_id: u32,
    pub vmware_cpuid_freq: bool,
    pub cache_info_passthrough: bool,
    pub mwait: ArchCPU__bindgen_ty_1,
    pub filtered_features: FeatureWordArray,
    pub enable_pmu: bool,
    pub lbr_fmt: u64,
    pub enable_lmce: bool,
    pub enable_l3_cache: bool,
    pub legacy_cache: bool,
    pub enable_cpuid_0xb: bool,
    pub full_cpuid_auto_level: bool,
    pub vendor_cpuid_only: bool,
    pub intel_pt_auto_level: bool,
    pub fill_mtrr_mask: bool,
    pub host_phys_bits: bool,
    pub host_phys_bits_limit: u8,
    pub kvm_no_smi_migration: bool,
    pub kvm_pv_enforce_cpuid: bool,
    pub phys_bits: u32,
    pub apic_state: *mut DeviceState,
    pub cpu_as_root: *mut MemoryRegion,
    pub cpu_as_mem: *mut MemoryRegion,
    pub smram: *mut MemoryRegion,
    pub machine_done: Notifier,
    pub kvm_msr_buf: *mut kvm_msrs,
    pub node_id: i32,
    pub socket_id: i32,
    pub die_id: i32,
    pub core_id: i32,
    pub thread_id: i32,
    pub hv_max_vps: i32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ArchCPU__bindgen_ty_1 {
    pub eax: u32,
    pub ebx: u32,
    pub ecx: u32,
    pub edx: u32,
}
#[test]
fn bindgen_test_layout_ArchCPU__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<ArchCPU__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ArchCPU__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(ArchCPU__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<ArchCPU__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(ArchCPU__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eax) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU__bindgen_ty_1),
            "::",
            stringify!(eax)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ebx) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU__bindgen_ty_1),
            "::",
            stringify!(ebx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU__bindgen_ty_1),
            "::",
            stringify!(ecx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).edx) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU__bindgen_ty_1),
            "::",
            stringify!(edx)
        )
    );
}
#[test]
fn bindgen_test_layout_ArchCPU() {
    const UNINIT: ::std::mem::MaybeUninit<ArchCPU> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ArchCPU>(),
        16240usize,
        concat!("Size of: ", stringify!(ArchCPU))
    );
    assert_eq!(
        ::std::mem::align_of::<ArchCPU>(),
        16usize,
        concat!("Alignment of ", stringify!(ArchCPU))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_obj) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(parent_obj)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).neg) as usize - ptr as usize },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(neg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).env) as usize - ptr as usize },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(env)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmsentry) as usize - ptr as usize },
        15680usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(vmsentry)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ucode_rev) as usize - ptr as usize },
        15688usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(ucode_rev)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_spinlock_attempts) as usize - ptr as usize },
        15696usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_spinlock_attempts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_vendor) as usize - ptr as usize },
        15704usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_vendor)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_synic_kvm_only) as usize - ptr as usize },
        15712usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_synic_kvm_only)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_features) as usize - ptr as usize },
        15720usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_features)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_passthrough) as usize - ptr as usize },
        15728usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_passthrough)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_no_nonarch_cs) as usize - ptr as usize },
        15732usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_no_nonarch_cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_vendor_id) as usize - ptr as usize },
        15736usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_vendor_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_interface_id) as usize - ptr as usize },
        15748usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_interface_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_limits) as usize - ptr as usize },
        15764usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_limits)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_enforce_cpuid) as usize - ptr as usize },
        15776usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_enforce_cpuid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_ver_id_build) as usize - ptr as usize },
        15780usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_ver_id_build)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_ver_id_major) as usize - ptr as usize },
        15784usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_ver_id_major)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_ver_id_minor) as usize - ptr as usize },
        15786usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_ver_id_minor)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_ver_id_sp) as usize - ptr as usize },
        15788usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_ver_id_sp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_ver_id_sb) as usize - ptr as usize },
        15792usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_ver_id_sb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hyperv_ver_id_sn) as usize - ptr as usize },
        15796usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hyperv_ver_id_sn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).check_cpuid) as usize - ptr as usize },
        15800usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(check_cpuid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enforce_cpuid) as usize - ptr as usize },
        15801usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(enforce_cpuid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).force_features) as usize - ptr as usize },
        15802usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(force_features)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).expose_kvm) as usize - ptr as usize },
        15803usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(expose_kvm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).expose_tcg) as usize - ptr as usize },
        15804usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(expose_tcg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).migratable) as usize - ptr as usize },
        15805usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(migratable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).migrate_smi_count) as usize - ptr as usize },
        15806usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(migrate_smi_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_features) as usize - ptr as usize },
        15807usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(max_features)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).apic_id) as usize - ptr as usize },
        15808usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(apic_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vmware_cpuid_freq) as usize - ptr as usize },
        15812usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(vmware_cpuid_freq)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cache_info_passthrough) as usize - ptr as usize },
        15813usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(cache_info_passthrough)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mwait) as usize - ptr as usize },
        15816usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(mwait)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).filtered_features) as usize - ptr as usize },
        15832usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(filtered_features)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enable_pmu) as usize - ptr as usize },
        16120usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(enable_pmu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lbr_fmt) as usize - ptr as usize },
        16128usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(lbr_fmt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enable_lmce) as usize - ptr as usize },
        16136usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(enable_lmce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enable_l3_cache) as usize - ptr as usize },
        16137usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(enable_l3_cache)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).legacy_cache) as usize - ptr as usize },
        16138usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(legacy_cache)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enable_cpuid_0xb) as usize - ptr as usize },
        16139usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(enable_cpuid_0xb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).full_cpuid_auto_level) as usize - ptr as usize },
        16140usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(full_cpuid_auto_level)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vendor_cpuid_only) as usize - ptr as usize },
        16141usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(vendor_cpuid_only)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intel_pt_auto_level) as usize - ptr as usize },
        16142usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(intel_pt_auto_level)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fill_mtrr_mask) as usize - ptr as usize },
        16143usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(fill_mtrr_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).host_phys_bits) as usize - ptr as usize },
        16144usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(host_phys_bits)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).host_phys_bits_limit) as usize - ptr as usize },
        16145usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(host_phys_bits_limit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_no_smi_migration) as usize - ptr as usize },
        16146usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(kvm_no_smi_migration)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_pv_enforce_cpuid) as usize - ptr as usize },
        16147usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(kvm_pv_enforce_cpuid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).phys_bits) as usize - ptr as usize },
        16148usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(phys_bits)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).apic_state) as usize - ptr as usize },
        16152usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(apic_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu_as_root) as usize - ptr as usize },
        16160usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(cpu_as_root)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu_as_mem) as usize - ptr as usize },
        16168usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(cpu_as_mem)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).smram) as usize - ptr as usize },
        16176usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(smram)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).machine_done) as usize - ptr as usize },
        16184usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(machine_done)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kvm_msr_buf) as usize - ptr as usize },
        16208usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(kvm_msr_buf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node_id) as usize - ptr as usize },
        16216usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(node_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).socket_id) as usize - ptr as usize },
        16220usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(socket_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).die_id) as usize - ptr as usize },
        16224usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(die_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).core_id) as usize - ptr as usize },
        16228usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(core_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread_id) as usize - ptr as usize },
        16232usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(thread_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hv_max_vps) as usize - ptr as usize },
        16236usize,
        concat!(
            "Offset of field: ",
            stringify!(ArchCPU),
            "::",
            stringify!(hv_max_vps)
        )
    );
}
impl Default for ArchCPU {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for ArchCPU {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write ! (f , "ArchCPU {{ parent_obj: {:?}, neg: {:?}, env: {:?}, vmsentry: {:?}, hyperv_vendor: {:?}, hyperv_synic_kvm_only: {:?}, hyperv_passthrough: {:?}, hyperv_no_nonarch_cs: {:?}, hyperv_vendor_id: {:?}, hyperv_interface_id: {:?}, hyperv_limits: {:?}, hyperv_enforce_cpuid: {:?}, check_cpuid: {:?}, enforce_cpuid: {:?}, force_features: {:?}, expose_kvm: {:?}, expose_tcg: {:?}, migratable: {:?}, migrate_smi_count: {:?}, max_features: {:?}, vmware_cpuid_freq: {:?}, cache_info_passthrough: {:?}, mwait: {:?}, filtered_features: {:?}, enable_pmu: {:?}, enable_lmce: {:?}, enable_l3_cache: {:?}, legacy_cache: {:?}, enable_cpuid_0xb: {:?}, full_cpuid_auto_level: {:?}, vendor_cpuid_only: {:?}, intel_pt_auto_level: {:?}, fill_mtrr_mask: {:?}, host_phys_bits: {:?}, kvm_no_smi_migration: {:?}, kvm_pv_enforce_cpuid: {:?}, apic_state: {:?}, cpu_as_root: {:?}, cpu_as_mem: {:?}, smram: {:?}, machine_done: {:?}, kvm_msr_buf: {:?} }}" , self . parent_obj , self . neg , self . env , self . vmsentry , self . hyperv_vendor , self . hyperv_synic_kvm_only , self . hyperv_passthrough , self . hyperv_no_nonarch_cs , self . hyperv_vendor_id , self . hyperv_interface_id , self . hyperv_limits , self . hyperv_enforce_cpuid , self . check_cpuid , self . enforce_cpuid , self . force_features , self . expose_kvm , self . expose_tcg , self . migratable , self . migrate_smi_count , self . max_features , self . vmware_cpuid_freq , self . cache_info_passthrough , self . mwait , self . filtered_features , self . enable_pmu , self . enable_lmce , self . enable_l3_cache , self . legacy_cache , self . enable_cpuid_0xb , self . full_cpuid_auto_level , self . vendor_cpuid_only , self . intel_pt_auto_level , self . fill_mtrr_mask , self . host_phys_bits , self . kvm_no_smi_migration , self . kvm_pv_enforce_cpuid , self . apic_state , self . cpu_as_root , self . cpu_as_mem , self . smram , self . machine_done , self . kvm_msr_buf)
    }
}
pub type abi_ulong = target_ulong;
pub type abi_long = target_long;
extern "C" {
    pub fn target_mprotect(
        start: abi_ulong,
        len: abi_ulong,
        prot: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn target_mmap(
        start: abi_ulong,
        len: abi_ulong,
        prot: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
        fd: ::std::os::raw::c_int,
        offset: abi_ulong,
    ) -> abi_long;
}
extern "C" {
    pub fn target_munmap(start: abi_ulong, len: abi_ulong) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AccelCPUClass {
    pub parent_class: ObjectClass,
    pub cpu_class_init: ::std::option::Option<unsafe extern "C" fn(cc: *mut CPUClass)>,
    pub cpu_instance_init: ::std::option::Option<unsafe extern "C" fn(cpu: *mut CPUState)>,
    pub cpu_realizefn: ::std::option::Option<
        unsafe extern "C" fn(cpu: *mut CPUState, errp: *mut *mut Error) -> bool,
    >,
}
#[test]
fn bindgen_test_layout_AccelCPUClass() {
    const UNINIT: ::std::mem::MaybeUninit<AccelCPUClass> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<AccelCPUClass>(),
        120usize,
        concat!("Size of: ", stringify!(AccelCPUClass))
    );
    assert_eq!(
        ::std::mem::align_of::<AccelCPUClass>(),
        8usize,
        concat!("Alignment of ", stringify!(AccelCPUClass))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_class) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AccelCPUClass),
            "::",
            stringify!(parent_class)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu_class_init) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(AccelCPUClass),
            "::",
            stringify!(cpu_class_init)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu_instance_init) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(AccelCPUClass),
            "::",
            stringify!(cpu_instance_init)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpu_realizefn) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(AccelCPUClass),
            "::",
            stringify!(cpu_realizefn)
        )
    );
}
impl Default for AccelCPUClass {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " struct qemu_plugin_hwaddr - opaque hw address handle"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct qemu_plugin_hwaddr {
    pub is_io: bool,
    pub is_store: bool,
    pub v: qemu_plugin_hwaddr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union qemu_plugin_hwaddr__bindgen_ty_1 {
    pub io: qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1,
    pub ram: qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1 {
    pub section: *mut MemoryRegionSection,
    pub offset: hwaddr,
}
#[test]
fn bindgen_test_layout_qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).section) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(section)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(offset)
        )
    );
}
impl Default for qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2 {
    pub hostaddr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hostaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(hostaddr)
        )
    );
}
impl Default for qemu_plugin_hwaddr__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_qemu_plugin_hwaddr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<qemu_plugin_hwaddr__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<qemu_plugin_hwaddr__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(qemu_plugin_hwaddr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<qemu_plugin_hwaddr__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).io) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1),
            "::",
            stringify!(io)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ram) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(qemu_plugin_hwaddr__bindgen_ty_1),
            "::",
            stringify!(ram)
        )
    );
}
impl Default for qemu_plugin_hwaddr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for qemu_plugin_hwaddr__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(f, "qemu_plugin_hwaddr__bindgen_ty_1 {{ union }}")
    }
}
#[test]
fn bindgen_test_layout_qemu_plugin_hwaddr() {
    const UNINIT: ::std::mem::MaybeUninit<qemu_plugin_hwaddr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<qemu_plugin_hwaddr>(),
        24usize,
        concat!("Size of: ", stringify!(qemu_plugin_hwaddr))
    );
    assert_eq!(
        ::std::mem::align_of::<qemu_plugin_hwaddr>(),
        8usize,
        concat!("Alignment of ", stringify!(qemu_plugin_hwaddr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_io) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(qemu_plugin_hwaddr),
            "::",
            stringify!(is_io)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_store) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(qemu_plugin_hwaddr),
            "::",
            stringify!(is_store)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(qemu_plugin_hwaddr),
            "::",
            stringify!(v)
        )
    );
}
impl Default for qemu_plugin_hwaddr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::std::fmt::Debug for qemu_plugin_hwaddr {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        write!(
            f,
            "qemu_plugin_hwaddr {{ is_io: {:?}, is_store: {:?}, v: {:?} }}",
            self.is_io, self.is_store, self.v
        )
    }
}
extern "C" {
    #[doc = " tlb_plugin_lookup: query last TLB lookup\n @cpu: cpu environment\n\n This function can be used directly after a memory operation to\n query information about the access. It is used by the plugin\n infrastructure to expose more information about the address.\n\n It would only fail if not called from an instrumented memory access\n which would be an abuse of the API."]
    pub fn tlb_plugin_lookup(
        cpu: *mut CPUState,
        addr: target_ulong,
        mmu_idx: ::std::os::raw::c_int,
        is_store: bool,
        data: *mut qemu_plugin_hwaddr,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct GDBRegisterState {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_dirty_gfn {
    pub _address: u8,
}
