function x = tucker_clus(dataset, rank, windowSize, testDate, setting, numTargets)

addpath('tensor_toolbox_2.6');

%% params
days = windowSize+1; 	% tensor X will contain d+1 days
maxiters=50;			% tucker max number of iterations
tol=1e-4;				% tucker tol

if strcmp(dataset,'LIGHTSOURCE')

	hours = 19;
	plants = 7;
	variables = 10;

	plantsD = [0,0.167,0.333,0.5,0.667,0.833,1];

	temperatureM    = csvread('datasets/LIGHTSOURCE/lightsource_temperature.csv',1,0);
	irradianceM     = csvread('datasets/LIGHTSOURCE/lightsource_irradiance.csv',1,0);
	pressureM       = csvread('datasets/LIGHTSOURCE/lightsource_pressure.csv',1,0);
	windspeedM      = csvread('datasets/LIGHTSOURCE/lightsource_windspeed.csv',1,0);
	humidityM       = csvread('datasets/LIGHTSOURCE/lightsource_humidity.csv',1,0);
	dewpointM       = csvread('datasets/LIGHTSOURCE/lightsource_dewpoint.csv',1,0);
	windbearingM    = csvread('datasets/LIGHTSOURCE/lightsource_windbearing.csv',1,0);
	cloudcoverM     = csvread('datasets/LIGHTSOURCE/lightsource_cloudcover.csv',1,0);
	altitudeM       = csvread('datasets/LIGHTSOURCE/lightsource_altitude.csv',1,0);
	azimuthM        = csvread('datasets/LIGHTSOURCE/lightsource_azimuth.csv',1,0);

	latM = csvread('datasets/LIGHTSOURCE/lightsource_latitude.csv',1,0);
	lonM = csvread('datasets/LIGHTSOURCE/lightsource_longitude.csv',1,0);

	dataM  = csv2cell('datasets/LIGHTSOURCE/lightsource_data.csv','fromfile');        
	dataMH_LIGHTSOURCE  = csv2cell('datasets/LIGHTSOURCE/lightsource_data_hourly.csv','fromfile');

	LIGHTSOURCE_Y = csvread('datasets/LIGHTSOURCE/lightsource_power.csv',1,0);

	[LIGHTSOURCE_Plants,LIGHTSOURCE_Timestamps] = size(LIGHTSOURCE_Y);
	LIGHTSOURCE_Test = cell(856,1);
	h=1;  i=1;

	while h <= LIGHTSOURCE_Timestamps                       
	    LIGHTSOURCE_Test{i} = LIGHTSOURCE_Y(:,h:h+18);    % Contains target matrices (power) for each day
	    h = h + 19;
	    i = i + 1;
	end

	LIGHTSOURCE_X_Train = {temperatureM; irradianceM; pressureM; windspeedM; humidityM; dewpointM; windbearingM; cloudcoverM; altitudeM; azimuthM};
	LIGHTSOURCE_X_Test  = {temperatureM; irradianceM; pressureM; windspeedM; humidityM; dewpointM; windbearingM; cloudcoverM; altitudeM; azimuthM};

	split1 = [91,95,101,105,113,124,125,130,145,154,155,159,160,170,180,185,198,206,225,234,240,248,249,250,251,260,265,277,280,302,310,316,326,345,351,355];
	split2 = [98,102,108,113,119,120,135,140,141,144,146,152,154,160,170,175,185,187,202,207,213,220,225,238,245,251,253,262,264,265,271,280,288,299,315,321];
	split3 = [91,95,99,105,114,120,125,132,133,137,140,145,148,152,160,162,163,170,175,182,190,195,263,267,276,278,288,290,297,312,320,326,330,342,351,360];
	split4 = [94,97,100,105,118,120,125,127,129,156,157,160,165,174,178,179,196,233,241,242,248,254,262,274,284,287,295,314,316,321,323,326,328,329,342,345];
	split5 = [95,96,99,104,107,115,120,125,129,131,140,150,165,170,172,179,184,193,194,211,222,240,249,256,258,260,265,270,279,288,299,305,324,340,351,352];

	LIGHTSOURCE_Splits = {split1, split2, split3, split4, split5};

	LIGHTSOURCE_4th_Train = cell(10,365);
	LIGHTSOURCE_4th_Test = cell(10,365);

	d=1;
	h=1;
	while h <= LIGHTSOURCE_Timestamps
	    temperatureS  = temperatureM(:,h:h+18);
	    irradianceS = irradianceM(:,h:h+18);
	    pressureS = pressureM(:,h:h+18);
	    windspeedS = windspeedM(:,h:h+18);
	    humidityS = humidityM(:,h:h+18);
	    dewpointS = dewpointM(:,h:h+18);
	    windbearingS = windbearingM(:,h:h+18);
	    cloudcoverS = cloudcoverM(:,h:h+18);
	    altitudeS = altitudeM(:,h:h+18);
	    azimuthS = azimuthM(:,h:h+18);
	    
	    LIGHTSOURCE_4th_Train(:,d) = {temperatureS; irradianceS; pressureS; windspeedS; humidityS; dewpointS; windbearingS; cloudcoverS; altitudeS; azimuthS};
	    LIGHTSOURCE_4th_Test(:,d) = {temperatureS; irradianceS; pressureS; windspeedS; humidityS; dewpointS; windbearingS; cloudcoverS; altitudeS; azimuthS};

	    h = h + 19;
	    d = d + 1;
	end

	%% init

	if (windowSize>0)											% sliding window
		testDayIndex = find(strcmp(dataM,testDate));
		trainDayStart = testDayIndex-windowSize;
		trainDayEnd = testDayIndex-1;
	else 														% landmark window
		testDayIndex = find(strcmp(dataM,testDate));
		trainDayStart = 1;
		trainDayEnd = testDayIndex-1;
		windowSize = trainDayEnd;
		days = testDayIndex;
		fprintf('Training size: %d days\n',testDayIndex);
	end

	real_4d = zeros(variables,days,plants,hours);

	if strcmp(setting,'hourly')
		resultsCellTrain = cell(windowSize*plants*hours,1);
		resultsCellTest = cell(plants*hours,1);
	elseif strcmp(setting,'daily')
		resultsCellTrain = cell(windowSize*plants,1);
		resultsCellTest = cell(plants,1);
	else
		fprintf('Error: No strategy chosen');
	end

	d=1;
    
    for td=trainDayStart:trainDayEnd
        for v=1:variables
            real_4d(v,d,:,:) = cell2mat(LIGHTSOURCE_4th_Train(v,td));
        end
        d=d+1;
    end

	for v=1:variables
		real_4d(v,days,:,:) = cell2mat(LIGHTSOURCE_4th_Test(v,testDayIndex));
	end

	real_4d_tensor = tensor(real_4d);

	T = tucker_als(real_4d_tensor,rank,'maxiters',maxiters,'tol',tol,'init','nvecs');

    if strcmp(setting,'hourly')
    	numTuckerFeatures = rank*3;
    	T_dataset = zeros(plants*windowSize*hours,numTuckerFeatures);
		T_dataset_test = zeros(plants*hours,numTuckerFeatures);
    elseif strcmp(setting,'daily')
	    numTuckerFeatures = rank*2;
	    T_dataset = zeros(plants*windowSize,numTuckerFeatures);
		T_dataset_test = zeros(plants,numTuckerFeatures);
    else
    	fprintf('Error: No strategy chosen');
	end

	if strcmp(setting,'hourly')
		i=1;
		for d=1:windowSize
		    fprintf('Day %d \n',d);
		    for p=1:plants
		    	for h=1:hours
		            T_dataset(i,:) = horzcat(T.U{2}(d,:) , T.U{3}(p,:), T.U{4}(h,:));
		            i=i+1;
		        end
		    end
		end

		i=1;
		for p=1:plants
		    for h=1:hours
		        T_dataset_test(i,:) = horzcat(T.U{2}(days,:) , T.U{3}(p,:), T.U{4}(h,:));
		        i=i+1;
		    end
		end
	elseif strcmp(setting,'daily')
		i=1;
		for d=1:windowSize
		    fprintf('Day %d \n',d);
		    for p=1:plants
		        T_dataset(i,:) = horzcat(T.U{2}(d,:) , T.U{3}(p,:));
		        i=i+1;
		    end
		end

		i=1;
		for p=1:plants
		    T_dataset_test(i,:) = horzcat(T.U{2}(days,:) , T.U{3}(p,:));
		    i=i+1;
		end
	else
		fprintf('Error: No strategy chosen');
	end

	% normalization
	for i=1:numTuckerFeatures
		min_val=min(T_dataset(:,i));
		max_val=max(T_dataset(:,i));
		T_dataset(:,i)=(T_dataset(:,i)-min_val)./(max_val-min_val);
	    T_dataset_test(:,i)=(T_dataset_test(:,i)-min_val)./(max_val-min_val);
	end

	fprintf('\n Filling results in cell... \n');

	%% fill results in cell (lat, lon, date, tucker_features, target_labels)
	if strcmp(setting,'hourly')
		c=1;
		for d=trainDayStart:trainDayEnd
		    fprintf('Day %d \n',d);
			for p=1:LIGHTSOURCE_Plants
		    	for h=((d-1)*(hours)+1):(d*hours)
		        	%p_norm = (p-1)/(LIGHTSOURCE_Plants-1);
		            row_lat = latM(p,1);
		            row_lon = lonM(p,1);
		            row_date = dataMH_LIGHTSOURCE{h};
		            %trainrow = horzcat(num2str(p),',',num2str(row_lat),',',num2str(row_lon),',',row_date,',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',LIGHTSOURCE_Y(p,h)));
		            trainrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',LIGHTSOURCE_Y(p,h)));
		            trainrow = trainrow(1:end-1);
		            resultsCellTrain{c} = trainrow;
		            c=c+1;
		        end
		    end
		end

		c=1;
		for p=1:LIGHTSOURCE_Plants
		    for h=((testDayIndex-1)*(hours)+1):(testDayIndex*hours)
		    	%p_norm = (p-1)/(LIGHTSOURCE_Plants-1);
		        row_lat = latM(p,1);
		        row_lon = lonM(p,1);
		        row_date = dataMH_LIGHTSOURCE{h};
		        %testrow = horzcat(num2str(p),',',num2str(row_lat),',',num2str(row_lon),',',row_date,',',sprintf('%.3f,' , T_dataset_test(c,:)),sprintf('%.3f,',LIGHTSOURCE_Y(p,h)));
		        testrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset_test(c,:)),sprintf('%.3f,',LIGHTSOURCE_Y(p,h)));
		        testrow = testrow(1:end-1);
		        resultsCellTest{c} = testrow;
		        c=c+1;
		    end
		end

	elseif strcmp(setting,'daily')
		c=1;
		for d=trainDayStart:trainDayEnd
		    fprintf('Day %d \n',d);
			for p=1:LIGHTSOURCE_Plants
	            row_lat = latM(p,1);
	            row_lon = lonM(p,1);
	            row_date = dataM{d};
	            trainrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',LIGHTSOURCE_Test{d}(p,:)));
	            trainrow = trainrow(1:end-1);
	            resultsCellTrain{c} = trainrow;
	            c=c+1;
		    end
		end

		c=1;
		for p=1:LIGHTSOURCE_Plants
	        row_lat = latM(p,1);
	        row_lon = lonM(p,1);
	        row_date = dataM{testDayIndex};
	        testrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset_test(c,:)), sprintf('%.3f,',LIGHTSOURCE_Test{testDayIndex}(p,:)));
	        testrow = testrow(1:end-1);
	        resultsCellTest{c} = testrow;
	        c=c+1;
		end

	else
		fprintf('Error: No strategy chosen');
	end


	fid = fopen(strcat('training.arff'),'w');
    
    fprintf(fid,'%s\n','@relation ''training''');
    fprintf(fid,'%s\n','');
    fprintf(fid,'%s\n','@attribute idplant numeric');
    fprintf(fid,'%s\n','@attribute lat numeric');
    fprintf(fid,'%s\n','@attribute lon numeric');        
    %fprintf(fid,'%s\n','@attribute day numeric');
    
    for f=1:numTuckerFeatures
        fprintf(fid,'%s\n',strcat('@attribute tr',num2str(f),' numeric'));
    end

    if numTargets==1
	    fprintf(fid,'%s\n','@attribute target numeric');
    elseif numTargets>1
    	for t=1:numTargets
    		fprintf(fid,'%s\n', strcat('@attribute target', num2str(t), ' numeric'));
    	end
	else
    	fprintf('Error: No strategy chosen');
	end

    fprintf(fid,'%s\n','');
	fprintf(fid,'%s\n','@data');
	fprintf(fid,'%s\n',resultsCellTrain{:});
	fclose(fid);

	tid = fopen(strcat('test.arff'),'w');
    
    fprintf(tid,'%s\n','@relation ''test''');
    fprintf(tid,'%s\n','');
    fprintf(tid,'%s\n','@attribute idplant numeric');
    fprintf(tid,'%s\n','@attribute lat numeric');
    fprintf(tid,'%s\n','@attribute lon numeric');        
    %fprintf(tid,'%s\n','@attribute day numeric');
    
    for f=1:numTuckerFeatures
        fprintf(tid,'%s\n',strcat('@attribute tr',num2str(f),' numeric'));
    end
    
    if numTargets==1
	    fprintf(tid,'%s\n','@attribute target numeric');
    elseif numTargets>1
    	for t=1:numTargets
    		fprintf(tid,'%s\n', strcat('@attribute target', num2str(t), ' numeric'));
    	end
	else
    	fprintf('Error: No strategy chosen');
	end

    fprintf(tid,'%s\n','');
	fprintf(tid,'%s\n','@data');
	fprintf(tid,'%s\n',resultsCellTest{:});
	fclose(tid);
end

if strcmp(dataset,'PV_ITALY')

	hours = 19;
	plants = 17;
	variables = 10;

	plantsD = [0, 0.025, 0.05, 0.075,0.1, 0.125, 0.15, 0.2, 0.225, 0.25, 0.275, 0.3, 0.325, 0.35, 0.375, 0.4, 0.425];

	temperatureM    = csvread('datasets/PV_ITALY/pv_italy_temperature.csv',1,0);
	irradianceM     = csvread('datasets/PV_ITALY/pv_italy_irradiance.csv',1,0);
	pressureM       = csvread('datasets/PV_ITALY/pv_italy_pressure.csv',1,0);
	windspeedM      = csvread('datasets/PV_ITALY/pv_italy_windspeed.csv',1,0);
	humidityM       = csvread('datasets/PV_ITALY/pv_italy_humidity.csv',1,0);
	dewpointM       = csvread('datasets/PV_ITALY/pv_italy_dewpoint.csv',1,0);
	windbearingM    = csvread('datasets/PV_ITALY/pv_italy_windbearing.csv',1,0);
	cloudcoverM     = csvread('datasets/PV_ITALY/pv_italy_cloudcover.csv',1,0);
	altitudeM       = csvread('datasets/PV_ITALY/pv_italy_altitude.csv',1,0);
	azimuthM        = csvread('datasets/PV_ITALY/pv_italy_azimuth.csv',1,0);
	irr_pvgis_modM  = csvread('datasets/PV_ITALY/pv_italy_irr_pvgis_mod.csv',1,0);

	latM = csvread('datasets/PV_ITALY/pv_italy_lat.csv',1,0);
	lonM = csvread('datasets/PV_ITALY/pv_italy_lon.csv',1,0);
	dataM  = csv2cell('datasets/PV_ITALY/pv_italy_data.csv','fromfile');        
	dataMH_PV_ITALY  = csv2cell('datasets/PV_ITALY/pv_italy_data_hourly.csv','fromfile');

	PV_ITALY_Y = csvread('datasets/PV_ITALY/pv_italy_power.csv',1,0);

	[PV_ITALY_Plants,PV_ITALY_Timestamps] = size(PV_ITALY_Y);
	PV_ITALY_Test = cell(856,1);
	h=1;  i=1;

	while h <= PV_ITALY_Timestamps                  % 1:16264      
	    PV_ITALY_Test{i} = PV_ITALY_Y(:,h:h+18);    % Contains target matrices (power) for each day
	    h = h + 19;
	    i = i + 1;
	end

	PV_ITALY_X_Train = {temperatureM; irradianceM; pressureM; windspeedM; humidityM; dewpointM; windbearingM; cloudcoverM; altitudeM; azimuthM};
	PV_ITALY_X_Test  = {temperatureM; irr_pvgis_modM; pressureM; windspeedM; humidityM; dewpointM; windbearingM; cloudcoverM; altitudeM; azimuthM};

	split1 = [97,99,104,115,127,142,153,154,163,191,207,211,226,231,249,259,265,267,276,278,279,285,291,296,309,310,311,324,342,343,346,356,364,377,385,394,403,425,440,446,451,456,457,461,469,474,492,496,497,504,505,513,525,536,538,548,551,572,578,580,591,596,620,633,637,644,647,650,666,689,690,734,736,740,748,762,770,788,802,803,806,809,830,835,844];
	split2 = [94,95,100,113,115,117,122,128,135,151,161,164,172,180,186,191,196,214,225,237,264,268,277,295,313,322,326,330,348,359,364,365,379,386,397,404,422,429,437,448,455,459,464,472,482,484,488,503,508,525,526,551,554,559,568,579,581,599,635,642,650,656,659,679,690,694,698,700,714,719,722,747,772,778,784,786,812,815,825,832,835,836,839,840,846];
	split3 = [98,101,113,122,136,155,175,223,227,237,244,248,263,269,270,277,287,288,290,291,292,294,303,308,325,332,338,347,350,360,366,367,373,376,380,384,399,402,422,428,431,433,469,472,498,500,508,517,523,534,554,556,568,575,589,593,598,609,617,630,648,656,657,658,659,682,685,686,709,713,721,737,738,741,748,761,763,768,788,803,808,812,825,836,845];
	split4 = [99,100,101,114,121,153,154,159,161,176,179,198,232,249,253,269,274,282,296,300,301,303,306,307,310,328,343,382,385,386,393,396,413,420,427,440,457,462,469,471,475,487,491,494,501,511,514,518,543,551,559,560,566,584,608,616,623,647,648,657,660,670,678,686,689,693,695,700,703,715,723,727,735,761,770,785,789,813,818,821,826,828,832,838,843];
	split5 = [92,116,126,127,128,135,138,155,160,174,177,197,214,218,227,229,232,254,257,265,273,288,291,310,321,329,340,350,352,355,364,365,374,377,382,383,396,399,403,404,420,442,472,476,477,486,492,493,502,504,511,512,531,534,536,572,580,596,609,621,625,626,651,667,697,710,727,736,737,745,752,759,768,770,775,801,808,810,812,814,827,832,836,840,843];
	split6 = [115,132,134,142,152,162,181,200,205,221,224,235,237,242,244,248,250,283,296,304,306,332,341,343,368,369,371,406,414,436,438,441,445,447,451,466,474,482,502,509,526,536,539,547,549,577,592,600,601,613,617,623,624,640,642,643,644,645,651,654,659,660,671,676,683,695,702,710,711,717,721,739,740,756,778,782,783,787,791,797,815,817,830,834,851];
	split7 = [95,103,107,108,117,122,129,148,150,158,166,178,183,201,231,251,267,271,287,292,294,298,310,344,370,375,377,380,388,391,407,410,415,419,438,468,474,476,477,488,501,503,521,529,530,531,552,558,559,560,588,590,602,614,620,621,625,633,645,654,680,681,684,685,686,691,714,715,740,743,744,749,776,779,792,804,810,819,822,828,836,839,840,841,853];
	split8 = [100,106,109,113,116,127,142,174,189,206,221,226,232,236,241,242,246,269,304,305,309,318,333,336,338,357,359,363,377,382,385,389,393,400,410,418,429,467,477,486,490,493,496,498,507,518,526,527,532,550,553,557,559,561,575,578,582,597,603,604,611,623,640,698,705,711,717,719,725,734,775,777,785,811,815,819,824,826,834,835,836,839,843,846,853];
	split9 = [92,103,104,105,114,117,125,127,135,149,151,152,163,164,179,180,182,185,195,196,204,212,238,242,254,260,290,330,335,345,349,350,361,373,412,416,417,418,422,433,454,460,482,495,501,502,523,526,533,538,562,574,577,580,585,605,606,612,615,627,628,629,631,652,658,660,662,665,666,678,683,701,726,743,754,758,765,785,793,824,827,837,842,851,853];
	split10 = [96,113,123,134,177,182,195,205,209,215,272,282,291,305,310,313,326,328,333,334,336,337,340,346,348,360,367,377,392,437,451,469,472,490,498,499,500,505,508,513,515,519,525,526,530,538,543,552,553,561,566,570,571,599,600,625,629,637,665,669,670,681,695,696,709,710,712,715,719,726,729,731,739,742,752,779,787,791,808,811,815,825,827,832,845];

	PV_ITALY_Splits = {split1, split2, split3, split4, split5, split6, split7, split8, split9, split10};

	PV_ITALY_4th_Train = cell(10,854);
	PV_ITALY_4th_Test = cell(10,854);

	d=1;
	h=1;
	while h <= PV_ITALY_Timestamps                  % 1:16264      
	    temperatureS  = temperatureM(:,h:h+18);
	    irradianceS = irradianceM(:,h:h+18);
	    pressureS = pressureM(:,h:h+18);
	    windspeedS = windspeedM(:,h:h+18);
	    humidityS = humidityM(:,h:h+18);
	    dewpointS = dewpointM(:,h:h+18);
	    windbearingS = windbearingM(:,h:h+18);
	    cloudcoverS = cloudcoverM(:,h:h+18);
	    altitudeS = altitudeM(:,h:h+18);
	    azimuthS = azimuthM(:,h:h+18);
	    irr_pvgis_modS = irr_pvgis_modM(:,h:h+18);
	    
	    PV_ITALY_4th_Train(:,d) = {temperatureS; irradianceS; pressureS; windspeedS; humidityS; dewpointS; windbearingS; cloudcoverS; altitudeS; azimuthS};
	    PV_ITALY_4th_Test(:,d) = {temperatureS; irr_pvgis_modS; pressureS; windspeedS; humidityS; dewpointS; windbearingS; cloudcoverS; altitudeS; azimuthS};

	    h = h + 19;
	    d = d + 1;
	end

	%% init

	if (windowSize>0)											% sliding window
		testDayIndex = find(strcmp(dataM,testDate));
		trainDayStart = testDayIndex-windowSize;
		trainDayEnd = testDayIndex-1;
	else 														% landmark window
		testDayIndex = find(strcmp(dataM,testDate));
		trainDayStart = 1;
		trainDayEnd = testDayIndex-1;
		windowSize = trainDayEnd;
		days = testDayIndex;
		fprintf('Training size: %d days\n',testDayIndex);
	end

	real_4d = zeros(variables,days,plants,hours);

	if strcmp(setting,'hourly')
		resultsCellTrain = cell(windowSize*plants*hours,1);
		resultsCellTest = cell(plants*hours,1);
	elseif strcmp(setting,'daily')
		resultsCellTrain = cell(windowSize*plants,1);
		resultsCellTest = cell(plants,1);
	else
		fprintf('Error: No strategy chosen');
	end

	d=1;
    
    for td=trainDayStart:trainDayEnd
        for v=1:variables
            real_4d(v,d,:,:) = cell2mat(PV_ITALY_4th_Train(v,td));
        end
        d=d+1;
    end

	for v=1:variables
		real_4d(v,days,:,:) = cell2mat(PV_ITALY_4th_Test(v,testDayIndex));
	end

	real_4d_tensor = tensor(real_4d);

	T = tucker_als(real_4d_tensor,rank,'maxiters',maxiters,'tol',tol,'init','nvecs');

    if strcmp(setting,'hourly')
    	numTuckerFeatures = rank*3;
    	T_dataset = zeros(plants*windowSize*hours,numTuckerFeatures);
		T_dataset_test = zeros(plants*hours,numTuckerFeatures);
    elseif strcmp(setting,'daily')
	    numTuckerFeatures = rank*2;
	    T_dataset = zeros(plants*windowSize,numTuckerFeatures);
		T_dataset_test = zeros(plants,numTuckerFeatures);
    else
    	fprintf('Error: No strategy chosen');
	end

	if strcmp(setting,'hourly')
		i=1;
		for d=1:windowSize
		    fprintf('Day %d \n',d);
		    for p=1:plants
		    	for h=1:hours
		            T_dataset(i,:) = horzcat(T.U{2}(d,:) , T.U{3}(p,:), T.U{4}(h,:));
		            i=i+1;
		        end
		    end
		end

		i=1;
		for p=1:plants
		    for h=1:hours
		        T_dataset_test(i,:) = horzcat(T.U{2}(days,:) , T.U{3}(p,:), T.U{4}(h,:));
		        i=i+1;
		    end
		end
	elseif strcmp(setting,'daily')
		i=1;
		for d=1:windowSize
		    fprintf('Day %d \n',d);
		    for p=1:plants
		        T_dataset(i,:) = horzcat(T.U{2}(d,:) , T.U{3}(p,:));
		        i=i+1;
		    end
		end

		i=1;
		for p=1:plants
		    T_dataset_test(i,:) = horzcat(T.U{2}(days,:) , T.U{3}(p,:));
		    i=i+1;
		end
	else
		fprintf('Error: No strategy chosen');
	end

	% normalization
	for i=1:numTuckerFeatures
		min_val=min(T_dataset(:,i));
		max_val=max(T_dataset(:,i));
		T_dataset(:,i)=(T_dataset(:,i)-min_val)./(max_val-min_val);
	    T_dataset_test(:,i)=(T_dataset_test(:,i)-min_val)./(max_val-min_val);
	end

	fprintf('\n Filling results in cell... \n');

	%% fill results in cell (lat, lon, date, tucker_features, target_labels)
	if strcmp(setting,'hourly')
		c=1;
		for d=trainDayStart:trainDayEnd
		    fprintf('Day %d \n',d);
			for p=1:PV_ITALY_Plants
		    	for h=((d-1)*(hours)+1):(d*hours)
		        	%p_norm = (p-1)/(PV_ITALY_Plants-1);
		            row_lat = latM(p,1);
		            row_lon = lonM(p,1);
		            row_date = dataMH_PV_ITALY{h};
		            %trainrow = horzcat(num2str(p),',',num2str(row_lat),',',num2str(row_lon),',',row_date,',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',PV_ITALY_Y(p,h)));
		            trainrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',PV_ITALY_Y(p,h)));
		            trainrow = trainrow(1:end-1);
		            resultsCellTrain{c} = trainrow;
		            c=c+1;
		        end
		    end
		end

		c=1;
		for p=1:PV_ITALY_Plants
		    for h=((testDayIndex-1)*(hours)+1):(testDayIndex*hours)
		    	%p_norm = (p-1)/(PV_ITALY_Plants-1);
		        row_lat = latM(p,1);
		        row_lon = lonM(p,1);
		        row_date = dataMH_PV_ITALY{h};
		        %testrow = horzcat(num2str(p),',',num2str(row_lat),',',num2str(row_lon),',',row_date,',',sprintf('%.3f,' , T_dataset_test(c,:)),sprintf('%.3f,',PV_ITALY_Y(p,h)));
		        testrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset_test(c,:)),sprintf('%.3f,',PV_ITALY_Y(p,h)));
		        testrow = testrow(1:end-1);
		        resultsCellTest{c} = testrow;
		        c=c+1;
		    end
		end

	elseif strcmp(setting,'daily')
		c=1;
		for d=trainDayStart:trainDayEnd
		    fprintf('Day %d \n',d);
			for p=1:PV_ITALY_Plants
	            row_lat = latM(p,1);
	            row_lon = lonM(p,1);
	            row_date = dataM{d};
	            trainrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',PV_ITALY_Test{d}(p,:)));
	            trainrow = trainrow(1:end-1);
	            resultsCellTrain{c} = trainrow;
	            c=c+1;
		    end
		end

		c=1;
		for p=1:PV_ITALY_Plants
	        row_lat = latM(p,1);
	        row_lon = lonM(p,1);
	        row_date = dataM{testDayIndex};
	        testrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset_test(c,:)), sprintf('%.3f,',PV_ITALY_Test{testDayIndex}(p,:)));
	        testrow = testrow(1:end-1);
	        resultsCellTest{c} = testrow;
	        c=c+1;
		end

	else
		fprintf('Error: No strategy chosen');
	end


	fid = fopen(strcat('training.arff'),'w');
    
    fprintf(fid,'%s\n','@relation ''training''');
    fprintf(fid,'%s\n','');
    fprintf(fid,'%s\n','@attribute idplant numeric');
    fprintf(fid,'%s\n','@attribute lat numeric');
    fprintf(fid,'%s\n','@attribute lon numeric');        
    %fprintf(fid,'%s\n','@attribute day numeric');
    
    for f=1:numTuckerFeatures
        fprintf(fid,'%s\n',strcat('@attribute tr',num2str(f),' numeric'));
    end

    if numTargets==1
	    fprintf(fid,'%s\n','@attribute target numeric');
    elseif numTargets>1
    	for t=1:numTargets
    		fprintf(fid,'%s\n', strcat('@attribute target', num2str(t), ' numeric'));
    	end
	else
    	fprintf('Error: No strategy chosen');
	end

    fprintf(fid,'%s\n','');
	fprintf(fid,'%s\n','@data');
	fprintf(fid,'%s\n',resultsCellTrain{:});
	fclose(fid);

	tid = fopen(strcat('test.arff'),'w');
    
    fprintf(tid,'%s\n','@relation ''test''');
    fprintf(tid,'%s\n','');
    fprintf(tid,'%s\n','@attribute idplant numeric');
    fprintf(tid,'%s\n','@attribute lat numeric');
    fprintf(tid,'%s\n','@attribute lon numeric');        
    %fprintf(tid,'%s\n','@attribute day numeric');
    
    for f=1:numTuckerFeatures
        fprintf(tid,'%s\n',strcat('@attribute tr',num2str(f),' numeric'));
    end
    
    if numTargets==1
	    fprintf(tid,'%s\n','@attribute target numeric');
    elseif numTargets>1
    	for t=1:numTargets
    		fprintf(tid,'%s\n', strcat('@attribute target', num2str(t), ' numeric'));
    	end
	else
    	fprintf('Error: No strategy chosen');
	end

    fprintf(tid,'%s\n','');
	fprintf(tid,'%s\n','@data');
	fprintf(tid,'%s\n',resultsCellTest{:});
	fclose(tid);
end

if strcmp(dataset,'WIND_NREL')

	hours = 24;
	plants = 5;
	variables = 7;

	plantsD = [0.000, 0.117, 0.368, 0.750, 1.000];

	temperatureM    = csvread('datasets/WIND_NREL/wind_nrel_temperature.csv',1,0);
	pressureM       = csvread('datasets/WIND_NREL/wind_nrel_pressure.csv',1,0);
	windspeedM      = csvread('datasets/WIND_NREL/wind_nrel_windspeed.csv',1,0);
	humidityM       = csvread('datasets/WIND_NREL/wind_nrel_humidity.csv',1,0);
	dewpointM       = csvread('datasets/WIND_NREL/wind_nrel_dewpoint.csv',1,0);
	windbearingM    = csvread('datasets/WIND_NREL/wind_nrel_windbearing.csv',1,0);
	cloudcoverM     = csvread('datasets/WIND_NREL/wind_nrel_cloudcover.csv',1,0);

	windspeedforecastM = csvread('datasets/WIND_NREL/wind_nrel_windspeedforecast.csv',1,0);

	WIND_NREL_Y  = csvread('datasets/WIND_NREL/wind_nrel_power.csv',1,0);

	[WIND_NREL_Plants,WIND_NREL_Timestamps] = size(WIND_NREL_Y);
	WIND_NREL_Test = cell(730,1);
	h=1;  i=1;

	while h <= WIND_NREL_Timestamps 
	    WIND_NREL_Test{i} = WIND_NREL_Y(:,h:h+23);
	    h = h + 24;
	    i = i + 1;
	end

	WIND_NREL_X       = {temperatureM; pressureM; windspeedM; humidityM; dewpointM; windbearingM; cloudcoverM};
	WIND_NREL_X_Test  = {temperatureM; pressureM; windspeedforecastM; humidityM; dewpointM; windbearingM; cloudcoverM};

	WIND_NREL_4th_Train = cell(7,730);
	WIND_NREL_4th_Test = cell(7,730);

	d=1;
	h=1;
	while h <= WIND_NREL_Timestamps   
	    temperatureS  = temperatureM(:,h:h+23);
	    pressureS = pressureM(:,h:h+23);
	    windspeedS = windspeedM(:,h:h+23);
	    humidityS = humidityM(:,h:h+23);
	    dewpointS = dewpointM(:,h:h+23);
	    windbearingS = windbearingM(:,h:h+23);
	    cloudcoverS = cloudcoverM(:,h:h+23);
	    windspeedforecastS = windspeedforecastM(:,h:h+23);
	    
	    WIND_NREL_4th_Train(:,d) = {temperatureS; pressureS; windspeedS; humidityS; dewpointS; windbearingS; cloudcoverS};
	    WIND_NREL_4th_Test(:,d) = {temperatureS; pressureS; windspeedforecastS; humidityS; dewpointS; windbearingS; cloudcoverS};

	    h = h + 24;
	    d = d + 1;
	end

	split1 = [95,100,106,108,117,122,131,134,150,155,169,170,171,186,204,231,233,234,237,238,244,245,246,255,258,276,280,303,326,327,338,343,347,349,365,368,390,392,411,412,414,422,425,426,429,439,453,455,467,470,473,474,484,504,521,523,526,552,569,579,587,597,602,608,617,628,640,656,680,684,689,693,702];
	split2 = [119,127,133,135,141,148,151,158,163,168,170,176,180,190,193,226,244,246,256,269,281,289,292,312,315,323,327,331,332,333,338,341,362,363,373,387,402,411,417,424,426,458,459,468,472,483,489,500,509,516,527,533,538,546,595,598,599,619,621,644,646,654,657,658,678,685,686,692,697,701,706,717,723];
	split3 = [99,111,121,126,149,153,167,175,176,179,187,213,235,241,245,253,259,262,266,271,275,276,287,298,314,321,324,325,346,351,360,364,367,369,370,375,381,392,410,416,437,454,457,462,466,471,475,491,499,502,522,532,543,571,578,587,605,607,615,626,632,638,640,651,682,689,696,702,717,718,722,723,729];
	split4 = [93,102,105,108,119,133,138,152,153,167,169,176,189,204,212,240,242,264,271,273,280,288,300,303,318,335,344,352,373,389,391,395,399,400,420,421,422,438,441,449,451,453,465,472,473,475,483,494,502,517,520,524,526,535,536,544,559,565,584,595,604,611,636,642,645,654,662,670,696,709,711,727,730];
	split5 = [97,113,120,130,136,176,180,189,191,203,215,238,242,251,252,253,262,270,279,285,313,316,324,336,344,349,360,373,416,418,420,421,445,465,471,480,484,489,490,497,503,511,516,522,532,553,565,572,577,584,592,600,610,625,631,632,635,637,641,652,654,658,659,663,666,671,675,690,704,712,717,719,729];
	split6 = [101,106,112,126,151,156,172,183,204,209,220,239,247,255,258,273,292,305,310,316,317,324,328,331,337,351,367,368,374,375,418,420,423,442,446,448,451,457,462,467,485,499,506,513,527,532,536,538,540,544,556,561,569,571,575,598,604,606,624,627,638,644,667,668,669,684,714,719,722,723,726,729,730];
	split7 = [114,126,136,139,144,147,158,162,169,173,185,188,199,208,210,212,222,226,228,235,239,253,262,263,269,290,300,302,309,313,332,344,346,348,351,357,364,378,382,392,400,402,405,406,418,444,476,485,510,530,531,537,546,562,600,601,602,611,621,628,633,640,650,656,670,678,689,695,716,718,723,726,727];
	split8 = [107,108,110,114,115,126,127,129,138,141,147,167,192,194,208,214,245,247,249,258,265,273,274,277,285,298,301,308,331,332,333,335,344,345,355,364,383,388,430,432,434,437,440,441,462,475,479,482,485,490,513,518,525,542,547,554,573,576,586,594,596,601,617,627,641,660,689,693,699,702,703,715,724];
	split9 = [94,98,101,105,114,115,117,119,121,143,149,161,182,183,196,209,213,236,246,267,283,295,307,321,326,327,338,345,349,350,368,376,383,399,412,421,427,449,452,454,461,466,480,485,491,493,505,524,536,540,555,558,565,570,574,576,578,592,602,612,628,632,645,646,650,672,679,692,702,716,721,729,730];
	split10 = [91,93,94,105,107,110,123,128,129,150,156,160,161,200,222,226,227,228,234,239,250,277,288,304,310,320,331,358,360,363,373,380,387,390,396,409,414,416,424,432,447,451,454,455,472,474,487,499,512,521,534,550,551,556,562,578,601,604,621,630,631,648,652,655,670,672,681,686,701,708,714,722,726];

	latM_WIND_NREL = csvread('datasets/WIND_NREL/wind_nrel_lat.csv',1,0);
	lonM_WIND_NREL = csvread('datasets/WIND_NREL/wind_nrel_lon.csv',1,0);
	dataM_WIND_NREL = csv2cell('datasets/WIND_NREL/wind_nrel_data.csv','fromfile');
	dataMH_WIND_NREL  = csv2cell('datasets/WIND_NREL/wind_nrel_data_hourly.csv','fromfile');        

	WIND_NREL_Splits = {split1, split2, split3, split4, split5, split6, split7, split8, split9, split10};

	%% init
	if (windowSize>0)											% sliding window
		testDayIndex = find(strcmp(dataM_WIND_NREL,testDate));
		trainDayStart = testDayIndex-windowSize;
		trainDayEnd = testDayIndex-1;
	else 														% landmark window
		testDayIndex = find(strcmp(dataM_WIND_NREL,testDate));
		trainDayStart = 1;
		trainDayEnd = testDayIndex-1;
		windowSize = trainDayEnd;
		days = testDayIndex;
		fprintf('Training size: %d days\n',testDayIndex);
	end

	real_4d = zeros(variables,days,plants,hours);

	if strcmp(setting,'hourly')
		resultsCellTrain = cell(windowSize*plants*hours,1);
		resultsCellTest = cell(plants*hours,1);
	elseif strcmp(setting,'daily')
		resultsCellTrain = cell(windowSize*plants,1);
		resultsCellTest = cell(plants,1);
    else
    	fprintf('Error: No strategy chosen');
	end

	d=1;
    
    for td=trainDayStart:trainDayEnd
        for v=1:variables
            real_4d(v,d,:,:) = cell2mat(WIND_NREL_4th_Train(v,td));
        end
        d=d+1;
    end

	for v=1:variables
	    real_4d(v,days,:,:) = cell2mat(WIND_NREL_4th_Test(v,testDayIndex));
	end

	real_4d_tensor = tensor(real_4d);

	T = tucker_als(real_4d_tensor,rank,'maxiters',maxiters,'tol',tol,'init','nvecs');

    if strcmp(setting,'hourly')
    	numTuckerFeatures = rank*3;
    	T_dataset = zeros(plants*windowSize*hours,numTuckerFeatures);
		T_dataset_test = zeros(plants*hours,numTuckerFeatures);
    elseif strcmp(setting,'daily')
	    numTuckerFeatures = rank*2;
	    T_dataset = zeros(plants*windowSize,numTuckerFeatures);
		T_dataset_test = zeros(plants,numTuckerFeatures);
    else
    	fprintf('Error: No strategy chosen');
	end

	if strcmp(setting,'hourly')
		i=1;
		for d=1:windowSize
		    fprintf('Day %d \n',d);
		    for p=1:plants
		    	for h=1:hours
		            T_dataset(i,:) = horzcat(T.U{2}(d,:) , T.U{3}(p,:), T.U{4}(h,:));
		            i=i+1;
		        end
		    end
		end

		i=1;
		for p=1:plants
		    for h=1:hours
		        T_dataset_test(i,:) = horzcat(T.U{2}(days,:) , T.U{3}(p,:), T.U{4}(h,:));
		        i=i+1;
		    end
		end
	elseif strcmp(setting,'daily')
		i=1;
		for d=1:windowSize
		    fprintf('Day %d \n',d);
		    for p=1:plants
		        T_dataset(i,:) = horzcat(T.U{2}(d,:) , T.U{3}(p,:));
		        i=i+1;
		    end
		end

		i=1;
		for p=1:plants
		    T_dataset_test(i,:) = horzcat(T.U{2}(days,:) , T.U{3}(p,:));
		    i=i+1;
		end
	else
		fprintf('Error: No strategy chosen');
	end

	% normalization
	for i=1:numTuckerFeatures
		min_val=min(T_dataset(:,i));
		max_val=max(T_dataset(:,i));
		T_dataset(:,i)=(T_dataset(:,i)-min_val)./(max_val-min_val);
	    T_dataset_test(:,i)=(T_dataset_test(:,i)-min_val)./(max_val-min_val);
	end

	fprintf('\n Filling results in cell... \n');

	%% fill results in cell (lat, lon, date, tucker_features, target_labels)

	if strcmp(setting,'hourly')
		c=1;
		for d=trainDayStart:trainDayEnd
		    fprintf('Day %d \n',d);
			for p=1:WIND_NREL_Plants
		    	for h=((d-1)*(hours)+1):(d*hours)
		            row_lat = latM_WIND_NREL(p,1);
		            row_lon = lonM_WIND_NREL(p,1);
		            row_date = dataMH_WIND_NREL{h};
		            trainrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',WIND_NREL_Y(p,h)));
		            trainrow = trainrow(1:end-1);
		            resultsCellTrain{c} = trainrow;
		            c=c+1;
		        end
		    end
		end

		c=1;
		for p=1:WIND_NREL_Plants
		    for h=((testDayIndex-1)*(hours)+1):(testDayIndex*hours)
		        row_lat = latM_WIND_NREL(p,1);
		        row_lon = lonM_WIND_NREL(p,1);
		        row_date = dataMH_WIND_NREL{h};
		        testrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset_test(c,:)),sprintf('%.3f,',WIND_NREL_Y(p,h)));
		        testrow = testrow(1:end-1);
		        resultsCellTest{c} = testrow;
		        c=c+1;
		    end
		end

	elseif strcmp(setting,'daily')
		c=1;
		for d=trainDayStart:trainDayEnd
		    fprintf('Day %d \n',d);
			for p=1:WIND_NREL_Plants
	            row_lat = latM_WIND_NREL(p,1);
	            row_lon = lonM_WIND_NREL(p,1);
	            row_date = dataM_WIND_NREL{d};
	            trainrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',WIND_NREL_Test{d}(p,:)));
	            trainrow = trainrow(1:end-1);
	            resultsCellTrain{c} = trainrow;
	            c=c+1;
		    end
		end

		c=1;
		for p=1:WIND_NREL_Plants
	        row_lat = latM_WIND_NREL(p,1);
	        row_lon = lonM_WIND_NREL(p,1);
	        row_date = dataM_WIND_NREL{testDayIndex};
	        testrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset_test(c,:)), sprintf('%.3f,',WIND_NREL_Test{testDayIndex}(p,:)));
	        testrow = testrow(1:end-1);
	        resultsCellTest{c} = testrow;
	        c=c+1;
		end

	else
		fprintf('Error: No strategy chosen');
	end


	fid = fopen(strcat('training.arff'),'w');
    
    fprintf(fid,'%s\n','@relation ''training''');
    fprintf(fid,'%s\n','');
    fprintf(fid,'%s\n','@attribute idplant numeric');
    fprintf(fid,'%s\n','@attribute lat numeric');
    fprintf(fid,'%s\n','@attribute lon numeric');        
    %fprintf(fid,'%s\n','@attribute day numeric');
    
    for f=1:numTuckerFeatures
        fprintf(fid,'%s\n',strcat('@attribute tr',num2str(f),' numeric'));
    end

    if numTargets==1
	    fprintf(fid,'%s\n','@attribute target numeric');
    elseif numTargets>1
    	for t=1:numTargets
    		fprintf(fid,'%s\n', strcat('@attribute target', num2str(t), ' numeric'));
    	end
	else
    	fprintf('Error: No strategy chosen');
	end

    fprintf(fid,'%s\n','');
	fprintf(fid,'%s\n','@data');
	fprintf(fid,'%s\n',resultsCellTrain{:});
	fclose(fid);

	tid = fopen(strcat('test.arff'),'w');
    
    fprintf(tid,'%s\n','@relation ''test''');
    fprintf(tid,'%s\n','');
    fprintf(tid,'%s\n','@attribute idplant numeric');
    fprintf(tid,'%s\n','@attribute lat numeric');
    fprintf(tid,'%s\n','@attribute lon numeric');        
    %fprintf(tid,'%s\n','@attribute day numeric');
    
    for f=1:numTuckerFeatures
        fprintf(tid,'%s\n',strcat('@attribute tr',num2str(f),' numeric'));
    end
    
    if numTargets==1
	    fprintf(tid,'%s\n','@attribute target numeric');
    elseif numTargets>1
    	for t=1:numTargets
    		fprintf(tid,'%s\n', strcat('@attribute target', num2str(t), ' numeric'));
    	end
	else
    	fprintf('Error: No strategy chosen');
	end

    fprintf(tid,'%s\n','');
	fprintf(tid,'%s\n','@data');
	fprintf(tid,'%s\n',resultsCellTest{:});
	fclose(tid);
end

if strcmp(dataset,'PV_NREL')

	hours = 19;
	plants = 48;
	variables = 9;

	plantsD = [0, 0.021,0.043,0.064,0.085,0.106,0.128,0.149,0.17,0.191,0.213,0.234,0.255,0.277,0.298,0.319,0.34,0.362,0.383,0.404,0.426,0.447,0.468,0.489,0.511,0.532,0.553,0.574,0.596,0.617,0.638,0.66,0.681,0.702,0.723,0.745,0.766,0.787,0.809,0.83,0.851,0.872,0.894,0.915,0.936,0.957,0.979,1];

	temperatureM    = csvread('datasets/PV_NREL/pv_nrel_temperature.csv',1,1);
	altitudeM       = csvread('datasets/PV_NREL/pv_nrel_altitude.csv',1,1);
	azimuthM        = csvread('datasets/PV_NREL/pv_nrel_azimuth.csv',1,1);
	pressureM       = csvread('datasets/PV_NREL/pv_nrel_pressure.csv',1,1);
	windspeedM      = csvread('datasets/PV_NREL/pv_nrel_windspeed.csv',1,1);
	humidityM       = csvread('datasets/PV_NREL/pv_nrel_humidity.csv',1,1);
	dewpointM       = csvread('datasets/PV_NREL/pv_nrel_dewpoint.csv',1,1);
	windbearingM    = csvread('datasets/PV_NREL/pv_nrel_windbearing.csv',1,1);
	cloudcoverM     = csvread('datasets/PV_NREL/pv_nrel_cloudcover.csv',1,1);

	PV_NREL_Y  = csvread('datasets/PV_NREL/pv_nrel_power.csv',1,1);

	latM_PV_NREL = csvread('datasets/PV_NREL/pv_nrel_lat.csv',1,0);
	lonM_PV_NREL = csvread('datasets/PV_NREL/pv_nrel_lon.csv',1,0);
	dataM_PV_NREL = csv2cell('datasets/PV_NREL/pv_nrel_data.csv','fromfile');
	dataMH_PV_NREL = csv2cell('datasets/PV_NREL/pv_nrel_data_hourly.csv','fromfile');

	[PV_NREL_Plants,PV_NREL_Timestamps] = size(PV_NREL_Y);
	PV_NREL_Test = cell(364,1);
	h=1;  i=1;

	while h <= PV_NREL_Timestamps        % 1:6916
	    PV_NREL_Test{i} = PV_NREL_Y(:,h:h+18);
	    h = h + 19;
	    i = i + 1;
	end

	PV_NREL_X = {temperatureM; altitudeM; azimuthM; pressureM; windspeedM; humidityM; dewpointM; windbearingM; cloudcoverM};

	split1 = [95,113,128,129,140,141,146,148,165,167,168,177,181,182,192,206,211,222,232,233,248,280,293,296,298,304,306,310,316,331,332,338,345,359,361,362];
	split2 = [94,106,109,112,114,116,123,125,137,142,148,157,162,163,172,178,181,189,193,197,205,234,239,249,266,274,293,294,296,300,319,320,323,327,334,362];
	split3 = [98,103,116,118,126,134,157,165,166,172,180,183,194,197,206,210,212,235,239,246,256,258,273,283,288,298,301,312,330,331,340,344,350,353,355,363];
	split4 = [103,105,119,124,126,133,150,158,169,180,186,199,200,207,209,221,223,241,242,245,247,249,259,263,264,273,274,276,278,284,288,290,307,316,333,334];
	split5 = [93,96,100,102,103,121,129,132,136,139,143,156,157,158,165,166,177,181,215,216,241,251,282,283,292,293,300,302,303,313,315,329,331,337,350,351];
	split6 = [100,136,137,138,145,155,167,177,186,195,196,200,203,210,215,224,230,236,238,250,251,255,269,274,281,296,301,303,310,324,326,328,329,332,342,361];
	split7 = [96,116,120,121,129,140,142,145,150,154,171,172,183,190,204,205,210,229,233,234,249,250,274,276,284,287,297,304,312,322,327,332,335,355,357,359];
	split8 = [102,106,107,109,112,141,158,168,172,197,199,202,212,223,230,240,258,261,263,270,273,284,285,290,293,301,303,310,314,324,328,340,344,353,359,361];
	split9 = [91,115,124,150,183,193,195,198,201,206,207,215,216,219,226,243,267,268,274,283,284,287,288,298,302,312,313,325,329,332,337,340,342,352,355,363];
	split10 = [98,116,120,132,133,138,141,142,144,146,161,163,169,176,180,186,196,199,202,221,236,247,253,262,277,294,295,298,305,307,313,323,324,344,353,354];

	PV_NREL_Splits = {split1, split2, split3, split4, split5, split6, split7, split8, split9, split10};

	PV_NREL_4th_Train = cell(9,364);
	PV_NREL_4th_Test = cell(9,364);

	d=1;
	h=1;
	while h <= PV_NREL_Timestamps                     
	    temperatureS  = temperatureM(:,h:h+18);
	    pressureS = pressureM(:,h:h+18);
	    windspeedS = windspeedM(:,h:h+18);
	    humidityS = humidityM(:,h:h+18);
	    dewpointS = dewpointM(:,h:h+18);
	    windbearingS = windbearingM(:,h:h+18);
	    cloudcoverS = cloudcoverM(:,h:h+18);
	    altitudeS = altitudeM(:,h:h+18);
	    azimuthS = azimuthM(:,h:h+18);
	    
	    PV_NREL_4th_Train(:,d) = {temperatureS; pressureS; windspeedS; humidityS; dewpointS; windbearingS; cloudcoverS; altitudeS; azimuthS};
	    PV_NREL_4th_Train(:,d) = {temperatureS; pressureS; windspeedS; humidityS; dewpointS; windbearingS; cloudcoverS; altitudeS; azimuthS};

	    h = h + 19;
	    d = d + 1;
	end

	kwh2 = csvread('datasets/PV_NREL/pv_nrel_power2.csv',1,0);
	kwh3 = csvread('datasets/PV_NREL/pv_nrel_power3.csv',1,0);
	kwh4 = csvread('datasets/PV_NREL/pv_nrel_power4.csv',1,0);
	kwh5 = csvread('datasets/PV_NREL/pv_nrel_power5.csv',1,0);
	kwh6 = csvread('datasets/PV_NREL/pv_nrel_power6.csv',1,0);
	kwh7 = csvread('datasets/PV_NREL/pv_nrel_power7.csv',1,0);
	kwh8 = csvread('datasets/PV_NREL/pv_nrel_power8.csv',1,0);
	kwh9 = csvread('datasets/PV_NREL/pv_nrel_power9.csv',1,0);
	kwh10 = csvread('datasets/PV_NREL/pv_nrel_power10.csv',1,0);
	kwh11 = csvread('datasets/PV_NREL/pv_nrel_power11.csv',1,0);
	kwh12 = csvread('datasets/PV_NREL/pv_nrel_power12.csv',1,0);
	kwh13 = csvread('datasets/PV_NREL/pv_nrel_power13.csv',1,0);
	kwh14 = csvread('datasets/PV_NREL/pv_nrel_power14.csv',1,0);
	kwh15 = csvread('datasets/PV_NREL/pv_nrel_power15.csv',1,0);
	kwh16 = csvread('datasets/PV_NREL/pv_nrel_power16.csv',1,0);
	kwh17 = csvread('datasets/PV_NREL/pv_nrel_power17.csv',1,0);
	kwh18 = csvread('datasets/PV_NREL/pv_nrel_power18.csv',1,0);
	kwh19 = csvread('datasets/PV_NREL/pv_nrel_power19.csv',1,0);
	kwh20 = csvread('datasets/PV_NREL/pv_nrel_power20.csv',1,0);

	PV_NREL_Y_MT = {kwh2; kwh3; kwh4; kwh5; kwh6; kwh7; kwh8; kwh9; kwh10; kwh11; kwh12; kwh13; kwh14; kwh15; kwh16; kwh17; kwh18; kwh19; kwh20};

	%% init

	if (windowSize>0)											% sliding window
		testDayIndex = find(strcmp(dataM_PV_NREL,testDate));
		trainDayStart = testDayIndex-windowSize;
		trainDayEnd = testDayIndex-1;
	else 														% landmark window
		testDayIndex = find(strcmp(dataM_PV_NREL,testDate));
		trainDayStart = 1;
		trainDayEnd = testDayIndex-1;
		windowSize = trainDayEnd;
		days = testDayIndex;
		fprintf('Training size: %d days\n',testDayIndex);
	end

	real_4d = zeros(variables,days,plants,hours);

	if strcmp(setting,'hourly')
		resultsCellTrain = cell(windowSize*plants*hours,1);
		resultsCellTest = cell(plants*hours,1);
	elseif strcmp(setting,'daily')
		resultsCellTrain = cell(windowSize*plants,1);
		resultsCellTest = cell(plants,1);
    else
    	fprintf('Error: No strategy chosen');
	end

	d=1;
    
    for td=trainDayStart:testDayIndex
        for v=1:variables
            real_4d(v,d,:,:) = cell2mat(PV_NREL_4th_Train(v,td));
        end
        d=d+1;
    end

	real_4d_tensor = tensor(real_4d);

	T = tucker_als(real_4d_tensor,rank,'maxiters',maxiters,'tol',tol,'init','nvecs');

    if strcmp(setting,'hourly')
    	numTuckerFeatures = rank*3;
    	T_dataset = zeros(plants*windowSize*hours,numTuckerFeatures);
		T_dataset_test = zeros(plants*hours,numTuckerFeatures);
    elseif strcmp(setting,'daily')
	    numTuckerFeatures = rank*2;
	    T_dataset = zeros(plants*windowSize,numTuckerFeatures);
		T_dataset_test = zeros(plants,numTuckerFeatures);
    else
    	fprintf('Error: No strategy chosen');
	end

	if strcmp(setting,'hourly')
		i=1;
		for d=1:windowSize
		    fprintf('Day %d \n',d);
		    for p=1:plants
		    	for h=1:hours
		            T_dataset(i,:) = horzcat(T.U{2}(d,:) , T.U{3}(p,:), T.U{4}(h,:));
		            i=i+1;
		        end
		    end
		end

		i=1;
		for p=1:plants
		    for h=1:hours
		        T_dataset_test(i,:) = horzcat(T.U{2}(days,:) , T.U{3}(p,:), T.U{4}(h,:));
		        i=i+1;
		    end
		end
	elseif strcmp(setting,'daily')
		i=1;
		for d=1:windowSize
		    fprintf('Day %d \n',d);
		    for p=1:plants
		        T_dataset(i,:) = horzcat(T.U{2}(d,:) , T.U{3}(p,:));
		        i=i+1;
		    end
		end

		i=1;
		for p=1:plants
		    T_dataset_test(i,:) = horzcat(T.U{2}(days,:) , T.U{3}(p,:));
		    i=i+1;
		end
	else
		fprintf('Error: No strategy chosen');
	end

	% normalization
	for i=1:numTuckerFeatures
		min_val=min(T_dataset(:,i));
		max_val=max(T_dataset(:,i));
		T_dataset(:,i)=(T_dataset(:,i)-min_val)./(max_val-min_val);
	    T_dataset_test(:,i)=(T_dataset_test(:,i)-min_val)./(max_val-min_val);
	end

	fprintf('\n Filling results in cell... \n');

	%% fill results in cell (lat, lon, date, tucker_features, target_labels)

	if strcmp(setting,'hourly')
		c=1;
		for d=trainDayStart:trainDayEnd
		    fprintf('Day %d \n',d);
			for p=1:PV_NREL_Plants
		    	for h=((d-1)*(hours)+1):(d*hours)
		            row_lat = latM_PV_NREL(p,1);
		            row_lon = lonM_PV_NREL(p,1);
		            row_date = dataMH_PV_NREL{h};
		            trainrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',PV_NREL_Y(p,h)));
		            trainrow = trainrow(1:end-1);
		            resultsCellTrain{c} = trainrow;
		            c=c+1;
		        end
		    end
		end

		c=1;
		for p=1:PV_NREL_Plants
		    for h=((testDayIndex-1)*(hours)+1):(testDayIndex*hours)
		        row_lat = latM_PV_NREL(p,1);
		        row_lon = lonM_PV_NREL(p,1);
		        row_date = dataMH_PV_NREL{h};
		        testrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset_test(c,:)),sprintf('%.3f,',PV_NREL_Y(p,h)));
		        testrow = testrow(1:end-1);
		        resultsCellTest{c} = testrow;
		        c=c+1;
		    end
		end

	elseif strcmp(setting,'daily')
		c=1;
		for d=trainDayStart:trainDayEnd
		    fprintf('Day %d \n',d);
			for p=1:PV_NREL_Plants
	            row_lat = latM_PV_NREL(p,1);
	            row_lon = lonM_PV_NREL(p,1);
	            row_date = dataM_PV_NREL{d};
	            trainrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset(c,:)) , sprintf('%.3f,',PV_NREL_Test{d}(p,:)));
	            trainrow = trainrow(1:end-1);
	            resultsCellTrain{c} = trainrow;
	            c=c+1;
		    end
		end

		c=1;
		for p=1:PV_NREL_Plants
	        row_lat = latM_PV_NREL(p,1);
	        row_lon = lonM_PV_NREL(p,1);
	        row_date = dataM_PV_NREL{testDayIndex};
	        testrow = horzcat(sprintf('%.3f,',plantsD(p)),num2str(row_lat),',',num2str(row_lon),',',sprintf('%.3f,' , T_dataset_test(c,:)), sprintf('%.3f,',PV_NREL_Test{testDayIndex}(p,:)));
	        testrow = testrow(1:end-1);
	        resultsCellTest{c} = testrow;
	        c=c+1;
		end

	else
		fprintf('Error: No strategy chosen');
	end


	fid = fopen(strcat('training.arff'),'w');
    
    fprintf(fid,'%s\n','@relation ''training''');
    fprintf(fid,'%s\n','');
    fprintf(fid,'%s\n','@attribute idplant numeric');
    fprintf(fid,'%s\n','@attribute lat numeric');
    fprintf(fid,'%s\n','@attribute lon numeric');        
    %fprintf(fid,'%s\n','@attribute day numeric');
    
    for f=1:numTuckerFeatures
        fprintf(fid,'%s\n',strcat('@attribute tr',num2str(f),' numeric'));
    end

    if numTargets==1
	    fprintf(fid,'%s\n','@attribute target numeric');
    elseif numTargets>1
    	for t=1:numTargets
    		fprintf(fid,'%s\n', strcat('@attribute target', num2str(t), ' numeric'));
    	end
	else
    	fprintf('Error: No strategy chosen');
	end

    fprintf(fid,'%s\n','');
	fprintf(fid,'%s\n','@data');
	fprintf(fid,'%s\n',resultsCellTrain{:});
	fclose(fid);

	tid = fopen(strcat('test.arff'),'w');
    
    fprintf(tid,'%s\n','@relation ''test''');
    fprintf(tid,'%s\n','');
    fprintf(tid,'%s\n','@attribute idplant numeric');
    fprintf(tid,'%s\n','@attribute lat numeric');
    fprintf(tid,'%s\n','@attribute lon numeric');        
    %fprintf(tid,'%s\n','@attribute day numeric');
    
    for f=1:numTuckerFeatures
        fprintf(tid,'%s\n',strcat('@attribute tr',num2str(f),' numeric'));
    end
    
    if numTargets==1
	    fprintf(tid,'%s\n','@attribute target numeric');
    elseif numTargets>1
    	for t=1:numTargets
    		fprintf(tid,'%s\n', strcat('@attribute target', num2str(t), ' numeric'));
    	end
	else
    	fprintf('Error: No strategy chosen');
	end

    fprintf(tid,'%s\n','');
	fprintf(tid,'%s\n','@data');
	fprintf(tid,'%s\n',resultsCellTest{:});
	fclose(tid);
end

end