C-----------------------------------------------------------------------
C     Copyright (C) 2007, ENPC - INRIA - EDF R&D
C
C     This file is part of the air quality modeling system Polyphemus.
C
C     Polyphemus is developed in the INRIA - ENPC joint project-team
C     CLIME and in the ENPC - EDF R&D joint laboratory CEREA.
C
C     Polyphemus is free software; you can redistribute it and/or modify
C     it under the terms of the GNU General Public License as published
C     by the Free Software Foundation; either version 2 of the License,
C     or (at your option) any later version.
C
C     Polyphemus is distributed in the hope that it will be useful, but
C     WITHOUT ANY WARRANTY; without even the implied warranty of
C     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
C     General Public License for more details.
C
C     For more information, visit the Polyphemus web site:
C     http://cerea.enpc.fr/polyphemus/
C-----------------------------------------------------------------------


COD Compilation unit : chemcl
COD Derivative of unit :  chem
COD Dummys:  nx ny nz ns nr nrphot nreactphot nemis nemisspecies nzemis wmol ts dlattenuation dlhumid dltemp dlpress dlcsourc dlcphotolysis_rates tf dlattenuationf dlhumidf dltempf dlpressf dlcsourcf dlcphotolysis_ratesf ncycle dlon dlat dlconc
COD Active IN   dummys:  dlconc dlcsourc dlcsourcf
COD Active OUT  dummys:  dlconc
COD Dependencies between IN and OUT:
COD dlconc <--   dlconc dlcsourc dlcsourcf


      SUBROUTINE CHEMCL (NX, NY, NZ, NS, NR, NRPHOT, NREACTPHOT,
     : NEMIS, NEMISSPECIES, NZEMIS, WMOL, TS, DLATTENUATION, DLHUMID,
     : DLTEMP, DLPRESS, DLCSOURC, DLCPHOTOLYSIS_RATES, DELTA_T,
     : DLATTENUATIONF, DLHUMIDF, DLTEMPF, DLPRESSF, DLCSOURCF,
     : DLCPHOTOLYSIS_RATESF, NCYCLE, DLON, DLAT, DLCONC, DLCSOURCCCL,
     : DLCSOURCFCCL, DLCONCCCL)

      IMPLICIT NONE
      DOUBLE PRECISION SD02S
      DOUBLE PRECISION ZANGZENF
      DOUBLE PRECISION DLMUZERO
      INTEGER JI
      INTEGER NX
      INTEGER NS
      INTEGER I
      INTEGER JJ
      INTEGER NY
      DOUBLE PRECISION ZATT
      INTEGER JK
      INTEGER NZ
      INTEGER JSP
      DOUBLE PRECISION TFCHEM
      DOUBLE PRECISION TSCHEM
      DOUBLE PRECISION TS
      DOUBLE PRECISION DELTA_T
      DOUBLE PRECISION ZANGZEN
      INTEGER NEMIS
      INTEGER NR
      DOUBLE PRECISION SD01S
      INTEGER NZEMIS
      INTEGER NCYCLE
      DOUBLE PRECISION MUZERO
      DOUBLE PRECISION PI
      DOUBLE PRECISION NAVOG
      DOUBLE PRECISION ZATTF
      INTEGER JT
      INTEGER NNN1
      INTEGER NRPHOT
      LOGICAL TEST26(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION ZCSOURCF(NS)
      DOUBLE PRECISION DLPRESSF(NX,NY,NZ)
      DOUBLE PRECISION DLTEMPF(NX,NY,NZ)
      DOUBLE PRECISION ZCSOURCFCCL(NS)
      LOGICAL TEST10(NX,NY,NZ)
      DOUBLE PRECISION DLATTENUATIONF(NX,NY,NZ)
      DOUBLE PRECISION CONVERS_FACTOR_JAC(NS,NS)
      DOUBLE PRECISION DLTEMP(NX,NY,NZ)
      DOUBLE PRECISION DLHUMIDF(NX,NY,NZ)
      DOUBLE PRECISION DLCPHOTOLYSIS_RATES(NX,NY,NZ,NRPHOT)
      LOGICAL TEST33(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION DLHUMID(NX,NY,NZ)
      DOUBLE PRECISION DLON(NX)
      DOUBLE PRECISION DLAT(NY)
      DOUBLE PRECISION DLCSOURCF(NX,NY,NZEMIS,NEMIS)
      DOUBLE PRECISION ZCSOURC(NS)
      DOUBLE PRECISION DLCSOURCCCL(NX,NY,NZEMIS,NEMIS)
      DOUBLE PRECISION ZCCCL(NS)
      DOUBLE PRECISION DLPRESS(NX,NY,NZ)
      INTEGER NREACTPHOT(NRPHOT)
      DOUBLE PRECISION ZCSOURCCCL(NS)
      DOUBLE PRECISION DLRKF(NR)
      DOUBLE PRECISION WMOL(NS)
      DOUBLE PRECISION DLCSOURC(NX,NY,NZEMIS,NEMIS)
      DOUBLE PRECISION DLCPHOTOLYSIS_RATESF(NX,NY,NZ,NRPHOT)
      INTEGER NEMISSPECIES(NEMIS)
      DOUBLE PRECISION DLATTENUATION(NX,NY,NZ)
      DOUBLE PRECISION DLCSOURCFCCL(NX,NY,NZEMIS,NEMIS)
      DOUBLE PRECISION DLCONC(NX,NY,NZ,NS)
      DOUBLE PRECISION DLRKI(NR)
      DOUBLE PRECISION DLCONCCCL(NX,NY,NZ,NS)
      DOUBLE PRECISION CONVERS_FACTOR(NS)
      DOUBLE PRECISION ZC(NS)
      DOUBLE PRECISION SAVE11(NEMIS,NX,NY,NZ)
      DOUBLE PRECISION SAVE12(NEMIS,NX,NY,NZ)
      INTEGER SAVE13(NX,NY,NZ)
      DOUBLE PRECISION SAVE14(NEMIS,NX,NY,NZ)
      DOUBLE PRECISION SAVE15(NEMIS,NX,NY,NZ)
      INTEGER SAVE16(NX,NY,NZ)
      DOUBLE PRECISION SAVE17(NX,NY,NZ)
      DOUBLE PRECISION SAVE18(NX,NY,NZ)
      DOUBLE PRECISION SAVE19(NS,NX,NY,NZ)
      DOUBLE PRECISION SAVE20(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE21(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE22(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE23(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE24(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE27(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE28(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE29(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE30(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE31(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE34(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE35(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE36(NCYCLE,NX,NY,NZ,NR)
      DOUBLE PRECISION SAVE37(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE38(NCYCLE,NX,NY,NZ,NR)
      DOUBLE PRECISION SAVE39(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE40(NRPHOT,NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE41(NRPHOT,NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE42(NCYCLE,NX,NY,NZ,NS)
      INTEGER SAVE43(NCYCLE,NX,NY,NZ)
      DOUBLE PRECISION SAVE44(NS,NX,NY,NZ)
      INTEGER SAVE45(NX,NY,NZ)
      INTEGER SAVE46(NX,NY,NZ)
      INTEGER SAVE47(NX,NY,NZ)
      INTEGER SAVE48(NY,NZ)
      INTEGER SAVE49(NZ)
      INTEGER SAVE51
      INTEGER SAVE6(NS)
      INTEGER option_photolysis
      INTEGER option_chemistry
C
C Initializations of uninitialized variables
C

c This automatic differenciation is okay only for the chemistry model RACM
c and the photolysis tabulation option FastJ.
      option_photolysis = 2
      option_chemistry = 1

      SD02S = 0d0
      ZANGZENF = 0d0
      DLMUZERO = 0d0
      ZATT = 0d0
      TFCHEM = 0d0
      TSCHEM = 0d0
      ZANGZEN = 0d0
      SD01S = 0d0
      ZATTF = 0d0
      DO NNN1 = 1, NR
         DLRKF(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NR
         DLRKI(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         ZC(NNN1) = 0d0
      END DO

      I = 0
      JI = 0
      JT = 0

C
C Initializations of local variables
C

      DO NNN1 = 1, NS
         ZCSOURCCCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         ZCCCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         ZCSOURCFCCL(NNN1) = 0d0
      END DO
C
C Trajectory
C

      PI = 3.14159265358979323846d0
      NAVOG = 6.02213d+23
      DO JSP = 1, NS
         CONVERS_FACTOR(JSP) = (NAVOG*1d-12)/WMOL(JSP)
      END DO
      DO JJ = 1, NS
         SAVE6(JJ) = JI
         DO JI = 1, NS
            CONVERS_FACTOR_JAC(JI,JJ) = WMOL(JI)/WMOL(JJ)
         END DO
      END DO
      SAVE51 = JSP
      DO JSP = 1, NS
         ZCSOURC(JSP) = 0.d0
         ZCSOURCF(JSP) = 0.d0
      END DO
      DO JK = 1, NZ
         SAVE49(JK) = JJ
         DO JJ = 1, NY
            SAVE48(JJ,JK) = JI
            DO JI = 1, NX
               TEST10(JI,JJ,JK) = JK.LE.NZEMIS
               IF (TEST10(JI,JJ,JK)) THEN
                 SAVE13(JI,JJ,JK) = JSP
                 DO JSP = 1, NEMIS
                    SAVE11(JSP,JI,JJ,JK) = ZCSOURC(NEMISSPECIES(JSP)+1)
                    ZCSOURC(NEMISSPECIES(JSP)+1) =
     :               DLCSOURC(JI,JJ,JK,JSP)
         SAVE12(JSP,JI,JJ,JK) = ZCSOURCF(NEMISSPECIES(JSP)+1)
                    ZCSOURCF(NEMISSPECIES(JSP)+1) =
     :               DLCSOURCF(JI,JJ,JK,JSP)
                 END DO
               ELSE
                 SAVE16(JI,JJ,JK) = JSP
                 DO JSP = 1, NEMIS
                    SAVE14(JSP,JI,JJ,JK) = ZCSOURC(NEMISSPECIES(JSP)+1)
                    ZCSOURC(NEMISSPECIES(JSP)+1) = 0.d0
         SAVE15(JSP,JI,JJ,JK) = ZCSOURCF(NEMISSPECIES(JSP)+1)
                    ZCSOURCF(NEMISSPECIES(JSP)+1) = 0.d0
                 END DO
               END IF
               SAVE17(JI,JJ,JK) = ZATT
               ZATT = DLATTENUATION(JI,JJ,JK)
               SAVE18(JI,JJ,JK) = ZATTF
               ZATTF = DLATTENUATIONF(JI,JJ,JK)
               SAVE47(JI,JJ,JK) = JSP
               DO JSP = 1, NS
                  SAVE19(JSP,JI,JJ,JK) = ZC(JSP)
                  ZC(JSP) = DLCONC(JI,JJ,JK,JSP)
               END DO
               SAVE46(JI,JJ,JK) = JT
               DO JT = 1, NCYCLE
                  SAVE20(JT,JI,JJ,JK) = TSCHEM
                  TSCHEM = TS+((-1+JT)*DELTA_T)/NCYCLE
                  SAVE21(JT,JI,JJ,JK) = TFCHEM
                  TFCHEM = TSCHEM+DELTA_T/NCYCLE
                  SAVE22(JT,JI,JJ,JK) = DLMUZERO
                  SAVE23(JT,JI,JJ,JK) = SD01S
                  SD01S = DACOS(DLMUZERO)
                  SAVE24(JT,JI,JJ,JK) = SD02S
                  SD02S = (SD01S*180.d0)/PI
                  TEST26(JT,JI,JJ,JK) = SD02S.GE.0d0
                  IF (TEST26(JT,JI,JJ,JK)) THEN
                    SAVE27(JT,JI,JJ,JK) = ZANGZEN
                    ZANGZEN = SD02S
                  ELSE
                    SAVE28(JT,JI,JJ,JK) = ZANGZEN
                    ZANGZEN = -SD02S
                  END IF
                  SAVE29(JT,JI,JJ,JK) = DLMUZERO
                  DLMUZERO = MUZERO(TFCHEM,DLON(JI),DLAT(JJ))
                  SAVE30(JT,JI,JJ,JK) = SD01S
                  SD01S = DACOS(DLMUZERO)
                  SAVE31(JT,JI,JJ,JK) = SD02S
                  SD02S = (SD01S*180.d0)/PI
                  TEST33(JT,JI,JJ,JK) = SD02S.GE.0d0
                  IF (TEST33(JT,JI,JJ,JK)) THEN
                    SAVE34(JT,JI,JJ,JK) = ZANGZENF
                    ZANGZENF = SD02S
                  ELSE
                    SAVE35(JT,JI,JJ,JK) = ZANGZENF
                    ZANGZENF = -SD02S
                  END IF
                  DO NNN1 = 1, NR
                     SAVE36(JT,JI,JJ,JK,NNN1) = DLRKI(NNN1)
                  END DO
                  SAVE37(JT,JI,JJ,JK) = ZANGZEN
                  CALL KINETIC_racm(NR, DLRKI, DLTEMP(JI,JJ,JK),
     :             DLHUMID(JI,JJ,JK), DLPRESS(JI,JJ,JK), ZANGZEN, ZATT,
     :             option_photolysis)
                  DO NNN1 = 1, NR
                     SAVE38(JT,JI,JJ,JK,NNN1) = DLRKF(NNN1)
                  END DO
                  SAVE39(JT,JI,JJ,JK) = ZANGZENF
                  CALL KINETIC_racm(NR, DLRKF, DLTEMPF(JI,JJ,JK),
     :             DLHUMIDF(JI,JJ,JK), DLPRESSF(JI,JJ,JK), ZANGZENF,
     :             ZATTF, option_photolysis)
                  SAVE43(JT,JI,JJ,JK) = I
                  DO I = 1, NRPHOT
                     SAVE40(I,JT,JI,JJ,JK) = DLRKI(NREACTPHOT(I)+1)
                     DLRKI(NREACTPHOT(I)+1) =
     :                ZATT*DLCPHOTOLYSIS_RATES(JI,JJ,JK,I)
                     SAVE41(I,JT,JI,JJ,JK) = DLRKF(NREACTPHOT(I)+1)
                     DLRKF(NREACTPHOT(I)+1) =
     :                ZATTF*DLCPHOTOLYSIS_RATESF(JI,JJ,JK,I)
                  END DO
                  DO NNN1 = 1, NS
                     SAVE42(JT,JI,JJ,JK,NNN1) = ZC(NNN1)
                  END DO
                  CALL ROSCHEMFWD(NS, NR, ZC, ZCSOURC, ZCSOURCF,
     :             CONVERS_FACTOR, CONVERS_FACTOR_JAC, TSCHEM, TFCHEM,
     :             DLRKI, DLRKF)
               END DO
               SAVE45(JI,JJ,JK) = I
               DO I = 1, NS
                  SAVE44(I,JI,JJ,JK) = DLCONC(JI,JJ,JK,I)
                  DLCONC(JI,JJ,JK,I) = ZC(I)
               END DO
            END DO
         END DO
      END DO
C
C Transposed linear forms
C

      DO JK = NZ, 1, -1
         DO JJ = NY, 1, -1
            DO JI = NX, 1, -1
               DO I = NS, 1, -1
                  DLCONC(JI,JJ,JK,I) = SAVE44(I,JI,JJ,JK)
                  ZCCCL(I) = ZCCCL(I)+DLCONCCCL(JI,JJ,JK,I)
                  DLCONCCCL(JI,JJ,JK,I) = 0d0
               END DO
               I = SAVE45(JI,JJ,JK)
               DO JT = NCYCLE, 1, -1
                  DO NNN1 = NS, 1, -1
                     ZC(NNN1) = SAVE42(JT,JI,JJ,JK,NNN1)
                  END DO
                  CALL ROSCHEMCL(NS, NR, ZC, ZCSOURC, ZCSOURCF,
     :             CONVERS_FACTOR, CONVERS_FACTOR_JAC, TSCHEM, TFCHEM,
     :             DLRKI, DLRKF, ZCCCL, ZCSOURCCCL, ZCSOURCFCCL)
                  DO I = NRPHOT, 1, -1
                     DLRKF(NREACTPHOT(I)+1) = SAVE41(I,JT,JI,JJ,JK)
                     DLRKI(NREACTPHOT(I)+1) = SAVE40(I,JT,JI,JJ,JK)
                  END DO
                  I = SAVE43(JT,JI,JJ,JK)
                  ZANGZENF = SAVE39(JT,JI,JJ,JK)
                  DO NNN1 = NR, 1, -1
                     DLRKF(NNN1) = SAVE38(JT,JI,JJ,JK,NNN1)
                  END DO
                  ZANGZEN = SAVE37(JT,JI,JJ,JK)
                  DO NNN1 = NR, 1, -1
                     DLRKI(NNN1) = SAVE36(JT,JI,JJ,JK,NNN1)
                  END DO
                  IF (TEST33(JT,JI,JJ,JK)) THEN
                    ZANGZENF = SAVE34(JT,JI,JJ,JK)
                  ELSE
                    ZANGZENF = SAVE35(JT,JI,JJ,JK)
                  END IF
                  SD02S = SAVE31(JT,JI,JJ,JK)
                  SD01S = SAVE30(JT,JI,JJ,JK)
                  DLMUZERO = SAVE29(JT,JI,JJ,JK)
                  IF (TEST26(JT,JI,JJ,JK)) THEN
                    ZANGZEN = SAVE27(JT,JI,JJ,JK)
                  ELSE
                    ZANGZEN = SAVE28(JT,JI,JJ,JK)
                  END IF
                  SD02S = SAVE24(JT,JI,JJ,JK)
                  SD01S = SAVE23(JT,JI,JJ,JK)
                  DLMUZERO = SAVE22(JT,JI,JJ,JK)
                  TFCHEM = SAVE21(JT,JI,JJ,JK)
                  TSCHEM = SAVE20(JT,JI,JJ,JK)
               END DO
               JT = SAVE46(JI,JJ,JK)
               DO JSP = NS, 1, -1
                  ZC(JSP) = SAVE19(JSP,JI,JJ,JK)
                  DLCONCCCL(JI,JJ,JK,JSP) =
     :             DLCONCCCL(JI,JJ,JK,JSP)+ZCCCL(JSP)
                  ZCCCL(JSP) = 0d0
               END DO
               JSP = SAVE47(JI,JJ,JK)
               ZATTF = SAVE18(JI,JJ,JK)
               ZATT = SAVE17(JI,JJ,JK)
               IF (TEST10(JI,JJ,JK)) THEN
                 DO JSP = NEMIS, 1, -1
         ZCSOURCF(NEMISSPECIES(JSP)+1) = SAVE12(JSP,JI,JJ,JK)
                    DLCSOURCFCCL(JI,JJ,JK,JSP) =
     :               DLCSOURCFCCL(JI,JJ,JK,JSP)+ZCSOURCFCCL
     :              (NEMISSPECIES(JSP)+1)
                    ZCSOURCFCCL(NEMISSPECIES(JSP)+1) = 0d0
                    ZCSOURC(NEMISSPECIES(JSP)+1) = SAVE11(JSP,JI,JJ,JK)
                    DLCSOURCCCL(JI,JJ,JK,JSP) =
     :               DLCSOURCCCL(JI,JJ,JK,JSP)+ZCSOURCCCL(NEMISSPECIES(
     :              JSP)+1)
                    ZCSOURCCCL(NEMISSPECIES(JSP)+1) = 0d0
                 END DO
                 JSP = SAVE13(JI,JJ,JK)
               ELSE
                 DO JSP = NEMIS, 1, -1
         ZCSOURCF(NEMISSPECIES(JSP)+1) = SAVE15(JSP,JI,JJ,JK)
                    ZCSOURCFCCL(NEMISSPECIES(JSP)+1) = 0d0
                    ZCSOURC(NEMISSPECIES(JSP)+1) = SAVE14(JSP,JI,JJ,JK)
                    ZCSOURCCCL(NEMISSPECIES(JSP)+1) = 0d0
                 END DO
                 JSP = SAVE16(JI,JJ,JK)
               END IF
            END DO
            JI = SAVE48(JJ,JK)
         END DO
         JJ = SAVE49(JK)
      END DO
      DO JSP = NS, 1, -1
         ZCSOURCFCCL(JSP) = 0d0
         ZCSOURCCCL(JSP) = 0d0
      END DO
      JSP = SAVE51
      DO JJ = NS, 1, -1
         JI = SAVE6(JJ)
      END DO
      END



COD Unit from the initial code : kinetic



COD Unit from the initial code : roschem



COD Compilation unit : dratedccl
COD Derivative of unit :  dratedc
COD Dummys:  ns nr rk y dw
COD Active IN   dummys:  y
COD Active OUT  dummys:  dw
COD Dependencies between IN and OUT:
COD dw <--   y


      SUBROUTINE DRATEDCCL (NS, NR, RK, Y, DW, YCCL, DWCCL)

      IMPLICIT NONE
      INTEGER NS
      INTEGER NR
      DOUBLE PRECISION DW(NR,NS)
      DOUBLE PRECISION Y(NS)
      DOUBLE PRECISION DWCCL(NR,NS)
      DOUBLE PRECISION YCCL(NS)
      DOUBLE PRECISION RK(NR)
      DOUBLE PRECISION SAVE1
      DOUBLE PRECISION SAVE10
      DOUBLE PRECISION SAVE100
      DOUBLE PRECISION SAVE101
      DOUBLE PRECISION SAVE102
      DOUBLE PRECISION SAVE103
      DOUBLE PRECISION SAVE104
      DOUBLE PRECISION SAVE105
      DOUBLE PRECISION SAVE106
      DOUBLE PRECISION SAVE107
      DOUBLE PRECISION SAVE108
      DOUBLE PRECISION SAVE109
      DOUBLE PRECISION SAVE11
      DOUBLE PRECISION SAVE110
      DOUBLE PRECISION SAVE111
      DOUBLE PRECISION SAVE112
      DOUBLE PRECISION SAVE113
      DOUBLE PRECISION SAVE114
      DOUBLE PRECISION SAVE115
      DOUBLE PRECISION SAVE116
      DOUBLE PRECISION SAVE117
      DOUBLE PRECISION SAVE118
      DOUBLE PRECISION SAVE119
      DOUBLE PRECISION SAVE12
      DOUBLE PRECISION SAVE120
      DOUBLE PRECISION SAVE121
      DOUBLE PRECISION SAVE122
      DOUBLE PRECISION SAVE123
      DOUBLE PRECISION SAVE124
      DOUBLE PRECISION SAVE125
      DOUBLE PRECISION SAVE126
      DOUBLE PRECISION SAVE127
      DOUBLE PRECISION SAVE128
      DOUBLE PRECISION SAVE129
      DOUBLE PRECISION SAVE13
      DOUBLE PRECISION SAVE130
      DOUBLE PRECISION SAVE131
      DOUBLE PRECISION SAVE132
      DOUBLE PRECISION SAVE133
      DOUBLE PRECISION SAVE134
      DOUBLE PRECISION SAVE135
      DOUBLE PRECISION SAVE136
      DOUBLE PRECISION SAVE137
      DOUBLE PRECISION SAVE138
      DOUBLE PRECISION SAVE139
      DOUBLE PRECISION SAVE14
      DOUBLE PRECISION SAVE140
      DOUBLE PRECISION SAVE141
      DOUBLE PRECISION SAVE142
      DOUBLE PRECISION SAVE143
      DOUBLE PRECISION SAVE144
      DOUBLE PRECISION SAVE145
      DOUBLE PRECISION SAVE146
      DOUBLE PRECISION SAVE147
      DOUBLE PRECISION SAVE148
      DOUBLE PRECISION SAVE149
      DOUBLE PRECISION SAVE15
      DOUBLE PRECISION SAVE150
      DOUBLE PRECISION SAVE151
      DOUBLE PRECISION SAVE152
      DOUBLE PRECISION SAVE153
      DOUBLE PRECISION SAVE154
      DOUBLE PRECISION SAVE155
      DOUBLE PRECISION SAVE156
      DOUBLE PRECISION SAVE157
      DOUBLE PRECISION SAVE158
      DOUBLE PRECISION SAVE159
      DOUBLE PRECISION SAVE16
      DOUBLE PRECISION SAVE160
      DOUBLE PRECISION SAVE161
      DOUBLE PRECISION SAVE162
      DOUBLE PRECISION SAVE163
      DOUBLE PRECISION SAVE164
      DOUBLE PRECISION SAVE165
      DOUBLE PRECISION SAVE166
      DOUBLE PRECISION SAVE167
      DOUBLE PRECISION SAVE168
      DOUBLE PRECISION SAVE169
      DOUBLE PRECISION SAVE17
      DOUBLE PRECISION SAVE170
      DOUBLE PRECISION SAVE171
      DOUBLE PRECISION SAVE172
      DOUBLE PRECISION SAVE173
      DOUBLE PRECISION SAVE174
      DOUBLE PRECISION SAVE175
      DOUBLE PRECISION SAVE176
      DOUBLE PRECISION SAVE177
      DOUBLE PRECISION SAVE178
      DOUBLE PRECISION SAVE179
      DOUBLE PRECISION SAVE18
      DOUBLE PRECISION SAVE180
      DOUBLE PRECISION SAVE181
      DOUBLE PRECISION SAVE182
      DOUBLE PRECISION SAVE183
      DOUBLE PRECISION SAVE184
      DOUBLE PRECISION SAVE185
      DOUBLE PRECISION SAVE186
      DOUBLE PRECISION SAVE187
      DOUBLE PRECISION SAVE188
      DOUBLE PRECISION SAVE189
      DOUBLE PRECISION SAVE19
      DOUBLE PRECISION SAVE190
      DOUBLE PRECISION SAVE191
      DOUBLE PRECISION SAVE192
      DOUBLE PRECISION SAVE193
      DOUBLE PRECISION SAVE194
      DOUBLE PRECISION SAVE195
      DOUBLE PRECISION SAVE196
      DOUBLE PRECISION SAVE197
      DOUBLE PRECISION SAVE198
      DOUBLE PRECISION SAVE199
      DOUBLE PRECISION SAVE2
      DOUBLE PRECISION SAVE20
      DOUBLE PRECISION SAVE200
      DOUBLE PRECISION SAVE201
      DOUBLE PRECISION SAVE202
      DOUBLE PRECISION SAVE203
      DOUBLE PRECISION SAVE204
      DOUBLE PRECISION SAVE205
      DOUBLE PRECISION SAVE206
      DOUBLE PRECISION SAVE207
      DOUBLE PRECISION SAVE208
      DOUBLE PRECISION SAVE209
      DOUBLE PRECISION SAVE21
      DOUBLE PRECISION SAVE210
      DOUBLE PRECISION SAVE211
      DOUBLE PRECISION SAVE212
      DOUBLE PRECISION SAVE213
      DOUBLE PRECISION SAVE214
      DOUBLE PRECISION SAVE215
      DOUBLE PRECISION SAVE216
      DOUBLE PRECISION SAVE217
      DOUBLE PRECISION SAVE218
      DOUBLE PRECISION SAVE219
      DOUBLE PRECISION SAVE22
      DOUBLE PRECISION SAVE220
      DOUBLE PRECISION SAVE221
      DOUBLE PRECISION SAVE222
      DOUBLE PRECISION SAVE223
      DOUBLE PRECISION SAVE224
      DOUBLE PRECISION SAVE225
      DOUBLE PRECISION SAVE226
      DOUBLE PRECISION SAVE227
      DOUBLE PRECISION SAVE228
      DOUBLE PRECISION SAVE229
      DOUBLE PRECISION SAVE23
      DOUBLE PRECISION SAVE230
      DOUBLE PRECISION SAVE231
      DOUBLE PRECISION SAVE232
      DOUBLE PRECISION SAVE233
      DOUBLE PRECISION SAVE234
      DOUBLE PRECISION SAVE235
      DOUBLE PRECISION SAVE236
      DOUBLE PRECISION SAVE237
      DOUBLE PRECISION SAVE238
      DOUBLE PRECISION SAVE239
      DOUBLE PRECISION SAVE24
      DOUBLE PRECISION SAVE240
      DOUBLE PRECISION SAVE241
      DOUBLE PRECISION SAVE242
      DOUBLE PRECISION SAVE243
      DOUBLE PRECISION SAVE244
      DOUBLE PRECISION SAVE245
      DOUBLE PRECISION SAVE246
      DOUBLE PRECISION SAVE247
      DOUBLE PRECISION SAVE248
      DOUBLE PRECISION SAVE249
      DOUBLE PRECISION SAVE25
      DOUBLE PRECISION SAVE250
      DOUBLE PRECISION SAVE251
      DOUBLE PRECISION SAVE252
      DOUBLE PRECISION SAVE253
      DOUBLE PRECISION SAVE254
      DOUBLE PRECISION SAVE255
      DOUBLE PRECISION SAVE256
      DOUBLE PRECISION SAVE257
      DOUBLE PRECISION SAVE258
      DOUBLE PRECISION SAVE259
      DOUBLE PRECISION SAVE26
      DOUBLE PRECISION SAVE260
      DOUBLE PRECISION SAVE261
      DOUBLE PRECISION SAVE262
      DOUBLE PRECISION SAVE263
      DOUBLE PRECISION SAVE264
      DOUBLE PRECISION SAVE265
      DOUBLE PRECISION SAVE266
      DOUBLE PRECISION SAVE267
      DOUBLE PRECISION SAVE268
      DOUBLE PRECISION SAVE269
      DOUBLE PRECISION SAVE27
      DOUBLE PRECISION SAVE270
      DOUBLE PRECISION SAVE271
      DOUBLE PRECISION SAVE272
      DOUBLE PRECISION SAVE273
      DOUBLE PRECISION SAVE274
      DOUBLE PRECISION SAVE275
      DOUBLE PRECISION SAVE276
      DOUBLE PRECISION SAVE277
      DOUBLE PRECISION SAVE278
      DOUBLE PRECISION SAVE279
      DOUBLE PRECISION SAVE28
      DOUBLE PRECISION SAVE280
      DOUBLE PRECISION SAVE281
      DOUBLE PRECISION SAVE282
      DOUBLE PRECISION SAVE283
      DOUBLE PRECISION SAVE284
      DOUBLE PRECISION SAVE285
      DOUBLE PRECISION SAVE286
      DOUBLE PRECISION SAVE287
      DOUBLE PRECISION SAVE288
      DOUBLE PRECISION SAVE289
      DOUBLE PRECISION SAVE29
      DOUBLE PRECISION SAVE290
      DOUBLE PRECISION SAVE291
      DOUBLE PRECISION SAVE292
      DOUBLE PRECISION SAVE293
      DOUBLE PRECISION SAVE294
      DOUBLE PRECISION SAVE295
      DOUBLE PRECISION SAVE296
      DOUBLE PRECISION SAVE297
      DOUBLE PRECISION SAVE298
      DOUBLE PRECISION SAVE299
      DOUBLE PRECISION SAVE3
      DOUBLE PRECISION SAVE30
      DOUBLE PRECISION SAVE300
      DOUBLE PRECISION SAVE301
      DOUBLE PRECISION SAVE302
      DOUBLE PRECISION SAVE303
      DOUBLE PRECISION SAVE304
      DOUBLE PRECISION SAVE305
      DOUBLE PRECISION SAVE306
      DOUBLE PRECISION SAVE307
      DOUBLE PRECISION SAVE308
      DOUBLE PRECISION SAVE309
      DOUBLE PRECISION SAVE31
      DOUBLE PRECISION SAVE310
      DOUBLE PRECISION SAVE311
      DOUBLE PRECISION SAVE312
      DOUBLE PRECISION SAVE313
      DOUBLE PRECISION SAVE314
      DOUBLE PRECISION SAVE315
      DOUBLE PRECISION SAVE316
      DOUBLE PRECISION SAVE317
      DOUBLE PRECISION SAVE318
      DOUBLE PRECISION SAVE319
      DOUBLE PRECISION SAVE32
      DOUBLE PRECISION SAVE320
      DOUBLE PRECISION SAVE321
      DOUBLE PRECISION SAVE322
      DOUBLE PRECISION SAVE323
      DOUBLE PRECISION SAVE324
      DOUBLE PRECISION SAVE325
      DOUBLE PRECISION SAVE326
      DOUBLE PRECISION SAVE327
      DOUBLE PRECISION SAVE328
      DOUBLE PRECISION SAVE329
      DOUBLE PRECISION SAVE33
      DOUBLE PRECISION SAVE330
      DOUBLE PRECISION SAVE331
      DOUBLE PRECISION SAVE332
      DOUBLE PRECISION SAVE333
      DOUBLE PRECISION SAVE334
      DOUBLE PRECISION SAVE335
      DOUBLE PRECISION SAVE336
      DOUBLE PRECISION SAVE337
      DOUBLE PRECISION SAVE338
      DOUBLE PRECISION SAVE339
      DOUBLE PRECISION SAVE34
      DOUBLE PRECISION SAVE340
      DOUBLE PRECISION SAVE341
      DOUBLE PRECISION SAVE342
      DOUBLE PRECISION SAVE343
      DOUBLE PRECISION SAVE344
      DOUBLE PRECISION SAVE345
      DOUBLE PRECISION SAVE346
      DOUBLE PRECISION SAVE347
      DOUBLE PRECISION SAVE348
      DOUBLE PRECISION SAVE349
      DOUBLE PRECISION SAVE35
      DOUBLE PRECISION SAVE350
      DOUBLE PRECISION SAVE351
      DOUBLE PRECISION SAVE352
      DOUBLE PRECISION SAVE353
      DOUBLE PRECISION SAVE354
      DOUBLE PRECISION SAVE355
      DOUBLE PRECISION SAVE356
      DOUBLE PRECISION SAVE357
      DOUBLE PRECISION SAVE358
      DOUBLE PRECISION SAVE359
      DOUBLE PRECISION SAVE36
      DOUBLE PRECISION SAVE360
      DOUBLE PRECISION SAVE361
      DOUBLE PRECISION SAVE362
      DOUBLE PRECISION SAVE363
      DOUBLE PRECISION SAVE364
      DOUBLE PRECISION SAVE365
      DOUBLE PRECISION SAVE366
      DOUBLE PRECISION SAVE367
      DOUBLE PRECISION SAVE368
      DOUBLE PRECISION SAVE369
      DOUBLE PRECISION SAVE37
      DOUBLE PRECISION SAVE370
      DOUBLE PRECISION SAVE371
      DOUBLE PRECISION SAVE372
      DOUBLE PRECISION SAVE373
      DOUBLE PRECISION SAVE374
      DOUBLE PRECISION SAVE375
      DOUBLE PRECISION SAVE376
      DOUBLE PRECISION SAVE377
      DOUBLE PRECISION SAVE378
      DOUBLE PRECISION SAVE379
      DOUBLE PRECISION SAVE38
      DOUBLE PRECISION SAVE380
      DOUBLE PRECISION SAVE381
      DOUBLE PRECISION SAVE382
      DOUBLE PRECISION SAVE383
      DOUBLE PRECISION SAVE384
      DOUBLE PRECISION SAVE385
      DOUBLE PRECISION SAVE386
      DOUBLE PRECISION SAVE387
      DOUBLE PRECISION SAVE388
      DOUBLE PRECISION SAVE389
      DOUBLE PRECISION SAVE39
      DOUBLE PRECISION SAVE390
      DOUBLE PRECISION SAVE391
      DOUBLE PRECISION SAVE392
      DOUBLE PRECISION SAVE393
      DOUBLE PRECISION SAVE394
      DOUBLE PRECISION SAVE395
      DOUBLE PRECISION SAVE396
      DOUBLE PRECISION SAVE397
      DOUBLE PRECISION SAVE398
      DOUBLE PRECISION SAVE399
      DOUBLE PRECISION SAVE4
      DOUBLE PRECISION SAVE40
      DOUBLE PRECISION SAVE400
      DOUBLE PRECISION SAVE401
      DOUBLE PRECISION SAVE402
      DOUBLE PRECISION SAVE403
      DOUBLE PRECISION SAVE404
      DOUBLE PRECISION SAVE405
      DOUBLE PRECISION SAVE406
      DOUBLE PRECISION SAVE407
      DOUBLE PRECISION SAVE408
      DOUBLE PRECISION SAVE409
      DOUBLE PRECISION SAVE41
      DOUBLE PRECISION SAVE410
      DOUBLE PRECISION SAVE411
      DOUBLE PRECISION SAVE412
      DOUBLE PRECISION SAVE413
      DOUBLE PRECISION SAVE414
      DOUBLE PRECISION SAVE415
      DOUBLE PRECISION SAVE416
      DOUBLE PRECISION SAVE417
      DOUBLE PRECISION SAVE418
      DOUBLE PRECISION SAVE419
      DOUBLE PRECISION SAVE42
      DOUBLE PRECISION SAVE420
      DOUBLE PRECISION SAVE421
      DOUBLE PRECISION SAVE422
      DOUBLE PRECISION SAVE423
      DOUBLE PRECISION SAVE424
      DOUBLE PRECISION SAVE425
      DOUBLE PRECISION SAVE426
      DOUBLE PRECISION SAVE427
      DOUBLE PRECISION SAVE428
      DOUBLE PRECISION SAVE429
      DOUBLE PRECISION SAVE43
      DOUBLE PRECISION SAVE430
      DOUBLE PRECISION SAVE431
      DOUBLE PRECISION SAVE432
      DOUBLE PRECISION SAVE433
      DOUBLE PRECISION SAVE434
      DOUBLE PRECISION SAVE435
      DOUBLE PRECISION SAVE436
      DOUBLE PRECISION SAVE437
      DOUBLE PRECISION SAVE438
      DOUBLE PRECISION SAVE439
      DOUBLE PRECISION SAVE44
      DOUBLE PRECISION SAVE45
      DOUBLE PRECISION SAVE46
      DOUBLE PRECISION SAVE47
      DOUBLE PRECISION SAVE48
      DOUBLE PRECISION SAVE49
      DOUBLE PRECISION SAVE5
      DOUBLE PRECISION SAVE50
      DOUBLE PRECISION SAVE51
      DOUBLE PRECISION SAVE52
      DOUBLE PRECISION SAVE53
      DOUBLE PRECISION SAVE54
      DOUBLE PRECISION SAVE55
      DOUBLE PRECISION SAVE56
      DOUBLE PRECISION SAVE57
      DOUBLE PRECISION SAVE58
      DOUBLE PRECISION SAVE59
      DOUBLE PRECISION SAVE6
      DOUBLE PRECISION SAVE60
      DOUBLE PRECISION SAVE61
      DOUBLE PRECISION SAVE62
      DOUBLE PRECISION SAVE63
      DOUBLE PRECISION SAVE64
      DOUBLE PRECISION SAVE65
      DOUBLE PRECISION SAVE66
      DOUBLE PRECISION SAVE67
      DOUBLE PRECISION SAVE68
      DOUBLE PRECISION SAVE69
      DOUBLE PRECISION SAVE7
      DOUBLE PRECISION SAVE70
      DOUBLE PRECISION SAVE71
      DOUBLE PRECISION SAVE72
      DOUBLE PRECISION SAVE73
      DOUBLE PRECISION SAVE74
      DOUBLE PRECISION SAVE75
      DOUBLE PRECISION SAVE76
      DOUBLE PRECISION SAVE77
      DOUBLE PRECISION SAVE78
      DOUBLE PRECISION SAVE79
      DOUBLE PRECISION SAVE8
      DOUBLE PRECISION SAVE80
      DOUBLE PRECISION SAVE81
      DOUBLE PRECISION SAVE82
      DOUBLE PRECISION SAVE83
      DOUBLE PRECISION SAVE84
      DOUBLE PRECISION SAVE85
      DOUBLE PRECISION SAVE86
      DOUBLE PRECISION SAVE87
      DOUBLE PRECISION SAVE88
      DOUBLE PRECISION SAVE89
      DOUBLE PRECISION SAVE9
      DOUBLE PRECISION SAVE90
      DOUBLE PRECISION SAVE91
      DOUBLE PRECISION SAVE92
      DOUBLE PRECISION SAVE93
      DOUBLE PRECISION SAVE94
      DOUBLE PRECISION SAVE95
      DOUBLE PRECISION SAVE96
      DOUBLE PRECISION SAVE97
      DOUBLE PRECISION SAVE98
      DOUBLE PRECISION SAVE99

C
C Trajectory
C

      SAVE1 = DW(1,72)
      DW(1,72) = RK(1)
      SAVE2 = DW(2,50)
      DW(2,50) = RK(2)
      SAVE3 = DW(3,50)
      DW(3,50) = RK(3)
      SAVE4 = DW(4,23)
      DW(4,23) = RK(4)
      SAVE5 = DW(5,55)
      DW(5,55) = RK(5)
      SAVE6 = DW(6,15)
      DW(6,15) = RK(6)
      SAVE7 = DW(7,68)
      DW(7,68) = RK(7)
      SAVE8 = DW(8,68)
      DW(8,68) = RK(8)
      SAVE9 = DW(9,27)
      DW(9,27) = RK(9)
      SAVE10 = DW(10,66)
      DW(10,66) = RK(10)
      SAVE11 = DW(11,66)
      DW(11,66) = RK(11)
      SAVE12 = DW(12,61)
      DW(12,61) = RK(12)
      SAVE13 = DW(13,16)
      DW(13,16) = RK(13)
      SAVE14 = DW(14,53)
      DW(14,53) = RK(14)
      SAVE15 = DW(15,28)
      DW(15,28) = RK(15)
      SAVE16 = DW(16,59)
      DW(16,59) = RK(16)
      SAVE17 = DW(17,51)
      DW(17,51) = RK(17)
      SAVE18 = DW(18,51)
      DW(18,51) = RK(18)
      SAVE19 = DW(19,54)
      DW(19,54) = RK(19)
      SAVE20 = DW(20,48)
      DW(20,48) = RK(20)
      SAVE21 = DW(21,70)
      DW(21,70) = RK(21)
      SAVE22 = DW(22,49)
      DW(22,49) = RK(22)
      SAVE23 = DW(23,24)
      DW(23,24) = RK(23)
      SAVE24 = DW(24,35)
      DW(24,35) = RK(24)
      SAVE25 = DW(25,35)
      DW(25,35) = RK(25)*Y(50)
      SAVE26 = DW(25,50)
      DW(25,50) = RK(25)*Y(35)
      SAVE27 = DW(26,7)
      DW(26,7) = RK(26)
      SAVE28 = DW(27,7)
      DW(27,7) = RK(27)
      SAVE29 = DW(28,7)
      DW(28,7) = RK(28)
      SAVE30 = DW(29,50)
      DW(29,50) = RK(29)*Y(62)
      SAVE31 = DW(29,62)
      DW(29,62) = RK(29)*Y(50)
      SAVE32 = DW(30,50)
      DW(30,50) = RK(30)*Y(71)
      SAVE33 = DW(30,71)
      DW(30,71) = RK(30)*Y(50)
      SAVE34 = DW(31,62)
      DW(31,62) = RK(31)*Y(71)
      SAVE35 = DW(31,71)
      DW(31,71) = RK(31)*Y(62)
      SAVE36 = DW(32,27)
      DW(32,27) = RK(32)*Y(62)
      SAVE37 = DW(32,62)
      DW(32,62) = RK(32)*Y(27)
      SAVE38 = DW(33,71)
      DW(33,71) = RK(33)*Y(71)
      SAVE39 = DW(33,71)
      DW(33,71) = RK(33)*Y(71)
      SAVE40 = DW(34,71)
      DW(34,71) = RK(34)*Y(71)
      SAVE41 = DW(34,71)
      DW(34,71) = RK(34)*Y(71)
      SAVE42 = DW(35,35)
      DW(35,35) = RK(35)*Y(67)
      SAVE43 = DW(35,67)
      DW(35,67) = RK(35)*Y(35)
      SAVE44 = DW(36,35)
      DW(36,35) = RK(36)*Y(72)
      SAVE45 = DW(36,72)
      DW(36,72) = RK(36)*Y(35)
      SAVE46 = DW(37,35)
      DW(37,35) = RK(37)*Y(72)
      SAVE47 = DW(37,72)
      DW(37,72) = RK(37)*Y(35)
      SAVE48 = DW(38,62)
      DW(38,62) = RK(38)*Y(67)
      SAVE49 = DW(38,67)
      DW(38,67) = RK(38)*Y(62)
      SAVE50 = DW(39,62)
      DW(39,62) = RK(39)*Y(72)
      SAVE51 = DW(39,72)
      DW(39,72) = RK(39)*Y(62)
      SAVE52 = DW(40,62)
      DW(40,62) = RK(40)*Y(68)
      SAVE53 = DW(40,68)
      DW(40,68) = RK(40)*Y(62)
      SAVE54 = DW(41,71)
      DW(41,71) = RK(41)*Y(67)
      SAVE55 = DW(41,67)
      DW(41,67) = RK(41)*Y(71)
      SAVE56 = DW(42,71)
      DW(42,71) = RK(42)*Y(72)
      SAVE57 = DW(42,72)
      DW(42,72) = RK(42)*Y(71)
      SAVE58 = DW(43,15)
      DW(43,15) = RK(43)
      SAVE59 = DW(44,71)
      DW(44,71) = RK(44)*Y(68)
      SAVE60 = DW(44,68)
      DW(44,68) = RK(44)*Y(71)
      SAVE61 = DW(45,62)
      DW(45,62) = RK(45)*Y(23)
      SAVE62 = DW(45,23)
      DW(45,23) = RK(45)*Y(62)
      SAVE63 = DW(46,62)
      DW(46,62) = RK(46)*Y(55)
      SAVE64 = DW(46,55)
      DW(46,55) = RK(46)*Y(62)
      SAVE65 = DW(47,62)
      DW(47,62) = RK(47)*Y(15)
      SAVE66 = DW(47,15)
      DW(47,15) = RK(47)*Y(62)
      SAVE67 = DW(48,50)
      DW(48,50) = RK(48)*Y(67)
      SAVE68 = DW(48,67)
      DW(48,67) = RK(48)*Y(50)
      SAVE69 = DW(49,50)
      DW(49,50) = RK(49)*Y(72)
      SAVE70 = DW(49,72)
      DW(49,72) = RK(49)*Y(50)
      SAVE71 = DW(50,67)
      DW(50,67) = RK(50)*Y(67)
      SAVE72 = DW(50,67)
      DW(50,67) = RK(50)*Y(67)
      SAVE73 = DW(51,68)
      DW(51,68) = RK(51)*Y(67)
      SAVE74 = DW(51,67)
      DW(51,67) = RK(51)*Y(68)
      SAVE75 = DW(52,68)
      DW(52,68) = RK(52)*Y(72)
      SAVE76 = DW(52,72)
      DW(52,72) = RK(52)*Y(68)
      SAVE77 = DW(53,68)
      DW(53,68) = RK(53)*Y(72)
      SAVE78 = DW(53,72)
      DW(53,72) = RK(53)*Y(68)
      SAVE79 = DW(54,9)
      DW(54,9) = RK(54)
      SAVE80 = DW(55,68)
      DW(55,68) = RK(55)*Y(68)
      SAVE81 = DW(55,68)
      DW(55,68) = RK(55)*Y(68)
      SAVE82 = DW(56,62)
      DW(56,62) = RK(56)
      SAVE83 = DW(57,62)
      DW(57,62) = RK(57)*Y(1)
      SAVE84 = DW(57,1)
      DW(57,1) = RK(57)*Y(62)
      SAVE85 = DW(58,52)
      DW(58,52) = RK(58)*Y(62)
      SAVE86 = DW(58,62)
      DW(58,62) = RK(58)*Y(52)
      SAVE87 = DW(59,19)
      DW(59,19) = RK(59)*Y(35)
      SAVE88 = DW(59,35)
      DW(59,35) = RK(59)*Y(19)
      SAVE89 = DW(60,49)
      DW(60,49) = RK(60)*Y(35)
      SAVE90 = DW(60,35)
      DW(60,35) = RK(60)*Y(49)
      SAVE91 = DW(61,20)
      DW(61,20) = RK(61)*Y(62)
      SAVE92 = DW(61,62)
      DW(61,62) = RK(61)*Y(20)
      SAVE93 = DW(62,21)
      DW(62,21) = RK(62)*Y(62)
      SAVE94 = DW(62,62)
      DW(62,62) = RK(62)*Y(21)
      SAVE95 = DW(63,2)
      DW(63,2) = RK(63)*Y(62)
      SAVE96 = DW(63,62)
      DW(63,62) = RK(63)*Y(2)
      SAVE97 = DW(64,3)
      DW(64,3) = RK(64)*Y(62)
      SAVE98 = DW(64,62)
      DW(64,62) = RK(64)*Y(3)
      SAVE99 = DW(65,4)
      DW(65,4) = RK(65)*Y(62)
      SAVE100 = DW(65,62)
      DW(65,62) = RK(65)*Y(4)
      SAVE101 = DW(66,11)
      DW(66,11) = RK(66)*Y(62)
      SAVE102 = DW(66,62)
      DW(66,62) = RK(66)*Y(11)
      SAVE103 = DW(67,40)
      DW(67,40) = RK(67)*Y(62)
      SAVE104 = DW(67,62)
      DW(67,62) = RK(67)*Y(40)
      SAVE105 = DW(68,44)
      DW(68,44) = RK(68)*Y(62)
      SAVE106 = DW(68,62)
      DW(68,62) = RK(68)*Y(44)
      SAVE107 = DW(69,12)
      DW(69,12) = RK(69)*Y(62)
      SAVE108 = DW(69,62)
      DW(69,62) = RK(69)*Y(12)
      SAVE109 = DW(70,19)
      DW(70,19) = RK(70)*Y(62)
      SAVE110 = DW(70,62)
      DW(70,62) = RK(70)*Y(19)
      SAVE111 = DW(71,13)
      DW(71,13) = RK(71)*Y(62)
      SAVE112 = DW(71,62)
      DW(71,62) = RK(71)*Y(13)
      SAVE113 = DW(72,14)
      DW(72,14) = RK(72)*Y(62)
      SAVE114 = DW(72,62)
      DW(72,62) = RK(72)*Y(14)
      SAVE115 = DW(73,5)
      DW(73,5) = RK(73)*Y(62)
      SAVE116 = DW(73,62)
      DW(73,62) = RK(73)*Y(5)
      SAVE117 = DW(74,6)
      DW(74,6) = RK(74)*Y(62)
      SAVE118 = DW(74,62)
      DW(74,62) = RK(74)*Y(6)
      SAVE119 = DW(75,30)
      DW(75,30) = RK(75)*Y(62)
      SAVE120 = DW(75,62)
      DW(75,62) = RK(75)*Y(30)
      SAVE121 = DW(76,66)
      DW(76,66) = RK(76)*Y(62)
      SAVE122 = DW(76,62)
      DW(76,62) = RK(76)*Y(66)
      SAVE123 = DW(77,61)
      DW(77,61) = RK(77)*Y(62)
      SAVE124 = DW(77,62)
      DW(77,62) = RK(77)*Y(61)
      SAVE125 = DW(78,59)
      DW(78,59) = RK(78)*Y(62)
      SAVE126 = DW(78,62)
      DW(78,62) = RK(78)*Y(59)
      SAVE127 = DW(79,24)
      DW(79,24) = RK(79)*Y(62)
      SAVE128 = DW(79,62)
      DW(79,62) = RK(79)*Y(24)
      SAVE129 = DW(80,51)
      DW(80,51) = RK(80)*Y(62)
      SAVE130 = DW(80,62)
      DW(80,62) = RK(80)*Y(51)
      SAVE131 = DW(81,54)
      DW(81,54) = RK(81)*Y(62)
      SAVE132 = DW(81,62)
      DW(81,62) = RK(81)*Y(54)
      SAVE133 = DW(82,49)
      DW(82,49) = RK(82)*Y(62)
      SAVE134 = DW(82,62)
      DW(82,62) = RK(82)*Y(49)
      SAVE135 = DW(83,62)
      DW(83,62) = RK(83)*Y(48)
      SAVE136 = DW(83,48)
      DW(83,48) = RK(83)*Y(62)
      SAVE137 = DW(84,62)
      DW(84,62) = RK(84)*Y(10)
      SAVE138 = DW(84,10)
      DW(84,10) = RK(84)*Y(62)
      SAVE139 = DW(85,16)
      DW(85,16) = RK(85)*Y(62)
      SAVE140 = DW(85,62)
      DW(85,62) = RK(85)*Y(16)
      SAVE141 = DW(86,53)
      DW(86,53) = RK(86)*Y(62)
      SAVE142 = DW(86,62)
      DW(86,62) = RK(86)*Y(53)
      SAVE143 = DW(87,28)
      DW(87,28) = RK(87)*Y(62)
      SAVE144 = DW(87,62)
      DW(87,62) = RK(87)*Y(28)
      SAVE145 = DW(88,26)
      DW(88,26) = RK(88)*Y(62)
      SAVE146 = DW(88,62)
      DW(88,62) = RK(88)*Y(26)
      SAVE147 = DW(89,25)
      DW(89,25) = RK(89)*Y(62)
      SAVE148 = DW(89,62)
      DW(89,62) = RK(89)*Y(25)
      SAVE149 = DW(90,70)
      DW(90,70) = RK(90)*Y(62)
      SAVE150 = DW(90,62)
      DW(90,62) = RK(90)*Y(70)
      SAVE151 = DW(91,66)
      DW(91,66) = RK(91)*Y(68)
      SAVE152 = DW(91,68)
      DW(91,68) = RK(91)*Y(66)
      SAVE153 = DW(92,61)
      DW(92,61) = RK(92)*Y(68)
      SAVE154 = DW(92,68)
      DW(92,68) = RK(92)*Y(61)
      SAVE155 = DW(93,51)
      DW(93,51) = RK(93)*Y(68)
      SAVE156 = DW(93,68)
      DW(93,68) = RK(93)*Y(51)
      SAVE157 = DW(94,54)
      DW(94,54) = RK(94)*Y(68)
      SAVE158 = DW(94,68)
      DW(94,68) = RK(94)*Y(54)
      SAVE159 = DW(95,49)
      DW(95,49) = RK(95)*Y(68)
      SAVE160 = DW(95,68)
      DW(95,68) = RK(95)*Y(49)
      SAVE161 = DW(96,48)
      DW(96,48) = RK(96)*Y(68)
      SAVE162 = DW(96,68)
      DW(96,68) = RK(96)*Y(48)
      SAVE163 = DW(97,30)
      DW(97,30) = RK(97)*Y(68)
      SAVE164 = DW(97,68)
      DW(97,68) = RK(97)*Y(30)
      SAVE165 = DW(98,11)
      DW(98,11) = RK(98)*Y(68)
      SAVE166 = DW(98,68)
      DW(98,68) = RK(98)*Y(11)
      SAVE167 = DW(99,40)
      DW(99,40) = RK(99)*Y(68)
      SAVE168 = DW(99,68)
      DW(99,68) = RK(99)*Y(40)
      SAVE169 = DW(100,44)
      DW(100,44) = RK(100)*Y(68)
      SAVE170 = DW(100,68)
      DW(100,68) = RK(100)*Y(44)
      SAVE171 = DW(101,12)
      DW(101,12) = RK(101)*Y(68)
      SAVE172 = DW(101,68)
      DW(101,68) = RK(101)*Y(12)
      SAVE173 = DW(102,19)
      DW(102,19) = RK(102)*Y(68)
      SAVE174 = DW(102,68)
      DW(102,68) = RK(102)*Y(19)
      SAVE175 = DW(103,13)
      DW(103,13) = RK(103)*Y(68)
      SAVE176 = DW(103,68)
      DW(103,68) = RK(103)*Y(13)
      SAVE177 = DW(104,14)
      DW(104,14) = RK(104)*Y(68)
      SAVE178 = DW(104,68)
      DW(104,68) = RK(104)*Y(14)
      SAVE179 = DW(105,25)
      DW(105,25) = RK(105)*Y(68)
      SAVE180 = DW(105,68)
      DW(105,68) = RK(105)*Y(25)
      SAVE181 = DW(106,11)
      DW(106,11) = RK(106)*Y(50)
      SAVE182 = DW(106,50)
      DW(106,50) = RK(106)*Y(11)
      SAVE183 = DW(107,40)
      DW(107,40) = RK(107)*Y(50)
      SAVE184 = DW(107,50)
      DW(107,50) = RK(107)*Y(40)
      SAVE185 = DW(108,44)
      DW(108,44) = RK(108)*Y(50)
      SAVE186 = DW(108,50)
      DW(108,50) = RK(108)*Y(44)
      SAVE187 = DW(109,12)
      DW(109,12) = RK(109)*Y(50)
      SAVE188 = DW(109,50)
      DW(109,50) = RK(109)*Y(12)
      SAVE189 = DW(110,19)
      DW(110,19) = RK(110)*Y(50)
      SAVE190 = DW(110,50)
      DW(110,50) = RK(110)*Y(19)
      SAVE191 = DW(111,13)
      DW(111,13) = RK(111)*Y(50)
      SAVE192 = DW(111,50)
      DW(111,50) = RK(111)*Y(13)
      SAVE193 = DW(112,14)
      DW(112,14) = RK(112)*Y(50)
      SAVE194 = DW(112,50)
      DW(112,50) = RK(112)*Y(14)
      SAVE195 = DW(113,49)
      DW(113,49) = RK(113)*Y(50)
      SAVE196 = DW(113,50)
      DW(113,50) = RK(113)*Y(49)
      SAVE197 = DW(114,48)
      DW(114,48) = RK(114)*Y(50)
      SAVE198 = DW(114,50)
      DW(114,50) = RK(114)*Y(48)
      SAVE199 = DW(115,25)
      DW(115,25) = RK(115)*Y(50)
      SAVE200 = DW(115,50)
      DW(115,50) = RK(115)*Y(25)
      SAVE201 = DW(116,29)
      DW(116,29) = RK(116)*Y(72)
      SAVE202 = DW(116,72)
      DW(116,72) = RK(116)*Y(29)
      SAVE203 = DW(117,29)
      DW(117,29) = RK(117)*Y(71)
      SAVE204 = DW(117,71)
      DW(117,71) = RK(117)*Y(29)
      SAVE205 = DW(118,17)
      DW(118,17) = RK(118)*Y(72)
      SAVE206 = DW(118,72)
      DW(118,72) = RK(118)*Y(17)
      SAVE207 = DW(119,17)
      DW(119,17) = RK(119)
      SAVE208 = DW(120,17)
      DW(120,17) = RK(120)*Y(50)
      SAVE209 = DW(120,50)
      DW(120,50) = RK(120)*Y(17)
      SAVE210 = DW(121,18)
      DW(121,18) = RK(121)*Y(72)
      SAVE211 = DW(121,72)
      DW(121,72) = RK(121)*Y(18)
      SAVE212 = DW(122,18)
      DW(122,18) = RK(122)
      SAVE213 = DW(123,18)
      DW(123,18) = RK(123)*Y(50)
      SAVE214 = DW(123,50)
      DW(123,50) = RK(123)*Y(18)
      SAVE215 = DW(124,22)
      DW(124,22) = RK(124)*Y(72)
      SAVE216 = DW(124,72)
      DW(124,72) = RK(124)*Y(22)
      SAVE217 = DW(125,22)
      DW(125,22) = RK(125)
      SAVE218 = DW(126,22)
      DW(126,22) = RK(126)*Y(50)
      SAVE219 = DW(126,50)
      DW(126,50) = RK(126)*Y(22)
      SAVE220 = DW(127,69)
      DW(127,69) = RK(127)*Y(72)
      SAVE221 = DW(127,72)
      DW(127,72) = RK(127)*Y(69)
      SAVE222 = DW(128,26)
      DW(128,26) = RK(128)
      SAVE223 = DW(129,56)
      DW(129,56) = RK(129)*Y(72)
      SAVE224 = DW(129,72)
      DW(129,72) = RK(129)*Y(56)
      SAVE225 = DW(130,25)
      DW(130,25) = RK(130)
      SAVE226 = DW(131,63)
      DW(131,63) = RK(131)*Y(67)
      SAVE227 = DW(131,67)
      DW(131,67) = RK(131)*Y(63)
      SAVE228 = DW(132,60)
      DW(132,60) = RK(132)*Y(67)
      SAVE229 = DW(132,67)
      DW(132,67) = RK(132)*Y(60)
      SAVE230 = DW(133,64)
      DW(133,64) = RK(133)*Y(67)
      SAVE231 = DW(133,67)
      DW(133,67) = RK(133)*Y(64)
      SAVE232 = DW(134,36)
      DW(134,36) = RK(134)*Y(67)
      SAVE233 = DW(134,67)
      DW(134,67) = RK(134)*Y(36)
      SAVE234 = DW(135,37)
      DW(135,37) = RK(135)*Y(67)
      SAVE235 = DW(135,67)
      DW(135,67) = RK(135)*Y(37)
      SAVE236 = DW(136,38)
      DW(136,38) = RK(136)*Y(67)
      SAVE237 = DW(136,67)
      DW(136,67) = RK(136)*Y(38)
      SAVE238 = DW(137,41)
      DW(137,41) = RK(137)*Y(67)
      SAVE239 = DW(137,67)
      DW(137,67) = RK(137)*Y(41)
      SAVE240 = DW(138,45)
      DW(138,45) = RK(138)*Y(67)
      SAVE241 = DW(138,67)
      DW(138,67) = RK(138)*Y(45)
      SAVE242 = DW(139,39)
      DW(139,39) = RK(139)*Y(67)
      SAVE243 = DW(139,67)
      DW(139,67) = RK(139)*Y(39)
      SAVE244 = DW(140,42)
      DW(140,42) = RK(140)*Y(67)
      SAVE245 = DW(140,67)
      DW(140,67) = RK(140)*Y(42)
      SAVE246 = DW(141,43)
      DW(141,43) = RK(141)*Y(67)
      SAVE247 = DW(141,67)
      DW(141,67) = RK(141)*Y(43)
      SAVE248 = DW(142,31)
      DW(142,31) = RK(142)*Y(67)
      SAVE249 = DW(142,67)
      DW(142,67) = RK(142)*Y(31)
      SAVE250 = DW(143,32)
      DW(143,32) = RK(143)*Y(67)
      SAVE251 = DW(143,67)
      DW(143,67) = RK(143)*Y(32)
      SAVE252 = DW(144,33)
      DW(144,33) = RK(144)*Y(67)
      SAVE253 = DW(144,67)
      DW(144,67) = RK(144)*Y(33)
      SAVE254 = DW(145,69)
      DW(145,69) = RK(145)*Y(67)
      SAVE255 = DW(145,67)
      DW(145,67) = RK(145)*Y(69)
      SAVE256 = DW(146,56)
      DW(146,56) = RK(146)*Y(67)
      SAVE257 = DW(146,67)
      DW(146,67) = RK(146)*Y(56)
      SAVE258 = DW(147,58)
      DW(147,58) = RK(147)*Y(67)
      SAVE259 = DW(147,67)
      DW(147,67) = RK(147)*Y(58)
      SAVE260 = DW(148,47)
      DW(148,47) = RK(148)*Y(67)
      SAVE261 = DW(148,67)
      DW(148,67) = RK(148)*Y(47)
      SAVE262 = DW(149,46)
      DW(149,46) = RK(149)*Y(67)
      SAVE263 = DW(149,67)
      DW(149,67) = RK(149)*Y(46)
      SAVE264 = DW(150,63)
      DW(150,63) = RK(150)*Y(71)
      SAVE265 = DW(150,71)
      DW(150,71) = RK(150)*Y(63)
      SAVE266 = DW(151,60)
      DW(151,60) = RK(151)*Y(71)
      SAVE267 = DW(151,71)
      DW(151,71) = RK(151)*Y(60)
      SAVE268 = DW(152,64)
      DW(152,64) = RK(152)*Y(71)
      SAVE269 = DW(152,71)
      DW(152,71) = RK(152)*Y(64)
      SAVE270 = DW(153,36)
      DW(153,36) = RK(153)*Y(71)
      SAVE271 = DW(153,71)
      DW(153,71) = RK(153)*Y(36)
      SAVE272 = DW(154,37)
      DW(154,37) = RK(154)*Y(71)
      SAVE273 = DW(154,71)
      DW(154,71) = RK(154)*Y(37)
      SAVE274 = DW(155,38)
      DW(155,38) = RK(155)*Y(71)
      SAVE275 = DW(155,71)
      DW(155,71) = RK(155)*Y(38)
      SAVE276 = DW(156,41)
      DW(156,41) = RK(156)*Y(71)
      SAVE277 = DW(156,71)
      DW(156,71) = RK(156)*Y(41)
      SAVE278 = DW(157,45)
      DW(157,45) = RK(157)*Y(71)
      SAVE279 = DW(157,71)
      DW(157,71) = RK(157)*Y(45)
      SAVE280 = DW(158,39)
      DW(158,39) = RK(158)*Y(71)
      SAVE281 = DW(158,71)
      DW(158,71) = RK(158)*Y(39)
      SAVE282 = DW(159,42)
      DW(159,42) = RK(159)*Y(71)
      SAVE283 = DW(159,71)
      DW(159,71) = RK(159)*Y(42)
      SAVE284 = DW(160,43)
      DW(160,43) = RK(160)*Y(71)
      SAVE285 = DW(160,71)
      DW(160,71) = RK(160)*Y(43)
      SAVE286 = DW(161,31)
      DW(161,31) = RK(161)*Y(71)
      SAVE287 = DW(161,71)
      DW(161,71) = RK(161)*Y(31)
      SAVE288 = DW(162,32)
      DW(162,32) = RK(162)*Y(71)
      SAVE289 = DW(162,71)
      DW(162,71) = RK(162)*Y(32)
      SAVE290 = DW(163,33)
      DW(163,33) = RK(163)*Y(71)
      SAVE291 = DW(163,71)
      DW(163,71) = RK(163)*Y(33)
      SAVE292 = DW(164,69)
      DW(164,69) = RK(164)*Y(71)
      SAVE293 = DW(164,71)
      DW(164,71) = RK(164)*Y(69)
      SAVE294 = DW(165,69)
      DW(165,69) = RK(165)*Y(71)
      SAVE295 = DW(165,71)
      DW(165,71) = RK(165)*Y(69)
      SAVE296 = DW(166,56)
      DW(166,56) = RK(166)*Y(71)
      SAVE297 = DW(166,71)
      DW(166,71) = RK(166)*Y(56)
      SAVE298 = DW(167,56)
      DW(167,56) = RK(167)*Y(71)
      SAVE299 = DW(167,71)
      DW(167,71) = RK(167)*Y(56)
      SAVE300 = DW(168,58)
      DW(168,58) = RK(168)*Y(71)
      SAVE301 = DW(168,71)
      DW(168,71) = RK(168)*Y(58)
      SAVE302 = DW(169,47)
      DW(169,47) = RK(169)*Y(71)
      SAVE303 = DW(169,71)
      DW(169,71) = RK(169)*Y(47)
      SAVE304 = DW(170,46)
      DW(170,46) = RK(170)*Y(71)
      SAVE305 = DW(170,71)
      DW(170,71) = RK(170)*Y(46)
      SAVE306 = DW(171,63)
      DW(171,63) = RK(171)*Y(63)
      SAVE307 = DW(171,63)
      DW(171,63) = RK(171)*Y(63)
      SAVE308 = DW(172,60)
      DW(172,60) = RK(172)*Y(63)
      SAVE309 = DW(172,63)
      DW(172,63) = RK(172)*Y(60)
      SAVE310 = DW(173,64)
      DW(173,64) = RK(173)*Y(63)
      SAVE311 = DW(173,63)
      DW(173,63) = RK(173)*Y(64)
      SAVE312 = DW(174,36)
      DW(174,36) = RK(174)*Y(63)
      SAVE313 = DW(174,63)
      DW(174,63) = RK(174)*Y(36)
      SAVE314 = DW(175,37)
      DW(175,37) = RK(175)*Y(63)
      SAVE315 = DW(175,63)
      DW(175,63) = RK(175)*Y(37)
      SAVE316 = DW(176,38)
      DW(176,38) = RK(176)*Y(63)
      SAVE317 = DW(176,63)
      DW(176,63) = RK(176)*Y(38)
      SAVE318 = DW(177,41)
      DW(177,41) = RK(177)*Y(63)
      SAVE319 = DW(177,63)
      DW(177,63) = RK(177)*Y(41)
      SAVE320 = DW(178,45)
      DW(178,45) = RK(178)*Y(63)
      SAVE321 = DW(178,63)
      DW(178,63) = RK(178)*Y(45)
      SAVE322 = DW(179,39)
      DW(179,39) = RK(179)*Y(63)
      SAVE323 = DW(179,63)
      DW(179,63) = RK(179)*Y(39)
      SAVE324 = DW(180,42)
      DW(180,42) = RK(180)*Y(63)
      SAVE325 = DW(180,63)
      DW(180,63) = RK(180)*Y(42)
      SAVE326 = DW(181,43)
      DW(181,43) = RK(181)*Y(63)
      SAVE327 = DW(181,63)
      DW(181,63) = RK(181)*Y(43)
      SAVE328 = DW(182,31)
      DW(182,31) = RK(182)*Y(63)
      SAVE329 = DW(182,63)
      DW(182,63) = RK(182)*Y(31)
      SAVE330 = DW(183,32)
      DW(183,32) = RK(183)*Y(63)
      SAVE331 = DW(183,63)
      DW(183,63) = RK(183)*Y(32)
      SAVE332 = DW(184,33)
      DW(184,33) = RK(184)*Y(63)
      SAVE333 = DW(184,63)
      DW(184,63) = RK(184)*Y(33)
      SAVE334 = DW(185,69)
      DW(185,69) = RK(185)*Y(63)
      SAVE335 = DW(185,63)
      DW(185,63) = RK(185)*Y(69)
      SAVE336 = DW(186,69)
      DW(186,69) = RK(186)*Y(63)
      SAVE337 = DW(186,63)
      DW(186,63) = RK(186)*Y(69)
      SAVE338 = DW(187,56)
      DW(187,56) = RK(187)*Y(63)
      SAVE339 = DW(187,63)
      DW(187,63) = RK(187)*Y(56)
      SAVE340 = DW(188,56)
      DW(188,56) = RK(188)*Y(63)
      SAVE341 = DW(188,63)
      DW(188,63) = RK(188)*Y(56)
      SAVE342 = DW(189,58)
      DW(189,58) = RK(189)*Y(63)
      SAVE343 = DW(189,63)
      DW(189,63) = RK(189)*Y(58)
      SAVE344 = DW(190,47)
      DW(190,47) = RK(190)*Y(63)
      SAVE345 = DW(190,63)
      DW(190,63) = RK(190)*Y(47)
      SAVE346 = DW(191,46)
      DW(191,46) = RK(191)*Y(63)
      SAVE347 = DW(191,63)
      DW(191,63) = RK(191)*Y(46)
      SAVE348 = DW(192,60)
      DW(192,60) = RK(192)*Y(69)
      SAVE349 = DW(192,69)
      DW(192,69) = RK(192)*Y(60)
      SAVE350 = DW(193,64)
      DW(193,64) = RK(193)*Y(69)
      SAVE351 = DW(193,69)
      DW(193,69) = RK(193)*Y(64)
      SAVE352 = DW(194,36)
      DW(194,36) = RK(194)*Y(69)
      SAVE353 = DW(194,69)
      DW(194,69) = RK(194)*Y(36)
      SAVE354 = DW(195,37)
      DW(195,37) = RK(195)*Y(69)
      SAVE355 = DW(195,69)
      DW(195,69) = RK(195)*Y(37)
      SAVE356 = DW(196,38)
      DW(196,38) = RK(196)*Y(69)
      SAVE357 = DW(196,69)
      DW(196,69) = RK(196)*Y(38)
      SAVE358 = DW(197,41)
      DW(197,41) = RK(197)*Y(69)
      SAVE359 = DW(197,69)
      DW(197,69) = RK(197)*Y(41)
      SAVE360 = DW(198,45)
      DW(198,45) = RK(198)*Y(69)
      SAVE361 = DW(198,69)
      DW(198,69) = RK(198)*Y(45)
      SAVE362 = DW(199,39)
      DW(199,39) = RK(199)*Y(69)
      SAVE363 = DW(199,69)
      DW(199,69) = RK(199)*Y(39)
      SAVE364 = DW(200,42)
      DW(200,42) = RK(200)*Y(69)
      SAVE365 = DW(200,69)
      DW(200,69) = RK(200)*Y(42)
      SAVE366 = DW(201,43)
      DW(201,43) = RK(201)*Y(69)
      SAVE367 = DW(201,69)
      DW(201,69) = RK(201)*Y(43)
      SAVE368 = DW(202,31)
      DW(202,31) = RK(202)*Y(69)
      SAVE369 = DW(202,69)
      DW(202,69) = RK(202)*Y(31)
      SAVE370 = DW(203,32)
      DW(203,32) = RK(203)*Y(69)
      SAVE371 = DW(203,69)
      DW(203,69) = RK(203)*Y(32)
      SAVE372 = DW(204,33)
      DW(204,33) = RK(204)*Y(69)
      SAVE373 = DW(204,69)
      DW(204,69) = RK(204)*Y(33)
      SAVE374 = DW(205,69)
      DW(205,69) = RK(205)*Y(69)
      SAVE375 = DW(205,69)
      DW(205,69) = RK(205)*Y(69)
      SAVE376 = DW(206,56)
      DW(206,56) = RK(206)*Y(69)
      SAVE377 = DW(206,69)
      DW(206,69) = RK(206)*Y(56)
      SAVE378 = DW(207,58)
      DW(207,58) = RK(207)*Y(69)
      SAVE379 = DW(207,69)
      DW(207,69) = RK(207)*Y(58)
      SAVE380 = DW(208,47)
      DW(208,47) = RK(208)*Y(69)
      SAVE381 = DW(208,69)
      DW(208,69) = RK(208)*Y(47)
      SAVE382 = DW(209,46)
      DW(209,46) = RK(209)*Y(69)
      SAVE383 = DW(209,69)
      DW(209,69) = RK(209)*Y(46)
      SAVE384 = DW(210,47)
      DW(210,47) = RK(210)*Y(47)
      SAVE385 = DW(210,47)
      DW(210,47) = RK(210)*Y(47)
      SAVE386 = DW(211,47)
      DW(211,47) = RK(211)*Y(46)
      SAVE387 = DW(211,46)
      DW(211,46) = RK(211)*Y(47)
      SAVE388 = DW(212,46)
      DW(212,46) = RK(212)*Y(46)
      SAVE389 = DW(212,46)
      DW(212,46) = RK(212)*Y(46)
      SAVE390 = DW(213,63)
      DW(213,63) = RK(213)*Y(68)
      SAVE391 = DW(213,68)
      DW(213,68) = RK(213)*Y(63)
      SAVE392 = DW(214,60)
      DW(214,60) = RK(214)*Y(68)
      SAVE393 = DW(214,68)
      DW(214,68) = RK(214)*Y(60)
      SAVE394 = DW(215,64)
      DW(215,64) = RK(215)*Y(68)
      SAVE395 = DW(215,68)
      DW(215,68) = RK(215)*Y(64)
      SAVE396 = DW(216,36)
      DW(216,36) = RK(216)*Y(68)
      SAVE397 = DW(216,68)
      DW(216,68) = RK(216)*Y(36)
      SAVE398 = DW(217,37)
      DW(217,37) = RK(217)*Y(68)
      SAVE399 = DW(217,68)
      DW(217,68) = RK(217)*Y(37)
      SAVE400 = DW(218,38)
      DW(218,38) = RK(218)*Y(68)
      SAVE401 = DW(218,68)
      DW(218,68) = RK(218)*Y(38)
      SAVE402 = DW(219,41)
      DW(219,41) = RK(219)*Y(68)
      SAVE403 = DW(219,68)
      DW(219,68) = RK(219)*Y(41)
      SAVE404 = DW(220,45)
      DW(220,45) = RK(220)*Y(68)
      SAVE405 = DW(220,68)
      DW(220,68) = RK(220)*Y(45)
      SAVE406 = DW(221,39)
      DW(221,39) = RK(221)*Y(68)
      SAVE407 = DW(221,68)
      DW(221,68) = RK(221)*Y(39)
      SAVE408 = DW(222,42)
      DW(222,42) = RK(222)*Y(68)
      SAVE409 = DW(222,68)
      DW(222,68) = RK(222)*Y(42)
      SAVE410 = DW(223,43)
      DW(223,43) = RK(223)*Y(68)
      SAVE411 = DW(223,68)
      DW(223,68) = RK(223)*Y(43)
      SAVE412 = DW(224,31)
      DW(224,31) = RK(224)*Y(68)
      SAVE413 = DW(224,68)
      DW(224,68) = RK(224)*Y(31)
      SAVE414 = DW(225,32)
      DW(225,32) = RK(225)*Y(68)
      SAVE415 = DW(225,68)
      DW(225,68) = RK(225)*Y(32)
      SAVE416 = DW(226,33)
      DW(226,33) = RK(226)*Y(68)
      SAVE417 = DW(226,68)
      DW(226,68) = RK(226)*Y(33)
      SAVE418 = DW(227,69)
      DW(227,69) = RK(227)*Y(68)
      SAVE419 = DW(227,68)
      DW(227,68) = RK(227)*Y(69)
      SAVE420 = DW(228,56)
      DW(228,56) = RK(228)*Y(68)
      SAVE421 = DW(228,68)
      DW(228,68) = RK(228)*Y(56)
      SAVE422 = DW(229,58)
      DW(229,58) = RK(229)*Y(68)
      SAVE423 = DW(229,68)
      DW(229,68) = RK(229)*Y(58)
      SAVE424 = DW(230,47)
      DW(230,47) = RK(230)*Y(68)
      SAVE425 = DW(230,68)
      DW(230,68) = RK(230)*Y(47)
      SAVE426 = DW(231,46)
      DW(231,46) = RK(231)*Y(68)
      SAVE427 = DW(231,68)
      DW(231,68) = RK(231)*Y(46)
      SAVE428 = DW(232,65)
      DW(232,65) = RK(232)*Y(71)
      SAVE429 = DW(232,71)
      DW(232,71) = RK(232)*Y(65)
      SAVE430 = DW(233,65)
      DW(233,65) = RK(233)*Y(63)
      SAVE431 = DW(233,63)
      DW(233,63) = RK(233)*Y(65)
      SAVE432 = DW(234,65)
      DW(234,65) = RK(234)*Y(69)
      SAVE433 = DW(234,69)
      DW(234,69) = RK(234)*Y(65)
      SAVE434 = DW(235,65)
      DW(235,65) = RK(235)*Y(65)
      SAVE435 = DW(235,65)
      DW(235,65) = RK(235)*Y(65)
      SAVE436 = DW(236,65)
      DW(236,65) = RK(236)*Y(67)
      SAVE437 = DW(236,67)
      DW(236,67) = RK(236)*Y(65)
      SAVE438 = DW(237,65)
      DW(237,65) = RK(237)*Y(68)
      SAVE439 = DW(237,68)
      DW(237,68) = RK(237)*Y(65)
C
C Transposed linear forms
C

      DW(237,68) = SAVE439
      YCCL(65) = YCCL(65)+DWCCL(237,68)*RK(237)
      DWCCL(237,68) = 0d0
      DW(237,65) = SAVE438
      YCCL(68) = YCCL(68)+DWCCL(237,65)*RK(237)
      DWCCL(237,65) = 0d0
      DW(236,67) = SAVE437
      YCCL(65) = YCCL(65)+DWCCL(236,67)*RK(236)
      DWCCL(236,67) = 0d0
      DW(236,65) = SAVE436
      YCCL(67) = YCCL(67)+DWCCL(236,65)*RK(236)
      DWCCL(236,65) = 0d0
      DW(235,65) = SAVE435
      YCCL(65) = YCCL(65)+DWCCL(235,65)*RK(235)
      DWCCL(235,65) = 0d0
      DW(235,65) = SAVE434
      YCCL(65) = YCCL(65)+DWCCL(235,65)*RK(235)
      DWCCL(235,65) = 0d0
      DW(234,69) = SAVE433
      YCCL(65) = YCCL(65)+DWCCL(234,69)*RK(234)
      DWCCL(234,69) = 0d0
      DW(234,65) = SAVE432
      YCCL(69) = YCCL(69)+DWCCL(234,65)*RK(234)
      DWCCL(234,65) = 0d0
      DW(233,63) = SAVE431
      YCCL(65) = YCCL(65)+DWCCL(233,63)*RK(233)
      DWCCL(233,63) = 0d0
      DW(233,65) = SAVE430
      YCCL(63) = YCCL(63)+DWCCL(233,65)*RK(233)
      DWCCL(233,65) = 0d0
      DW(232,71) = SAVE429
      YCCL(65) = YCCL(65)+DWCCL(232,71)*RK(232)
      DWCCL(232,71) = 0d0
      DW(232,65) = SAVE428
      YCCL(71) = YCCL(71)+DWCCL(232,65)*RK(232)
      DWCCL(232,65) = 0d0
      DW(231,68) = SAVE427
      YCCL(46) = YCCL(46)+DWCCL(231,68)*RK(231)
      DWCCL(231,68) = 0d0
      DW(231,46) = SAVE426
      YCCL(68) = YCCL(68)+DWCCL(231,46)*RK(231)
      DWCCL(231,46) = 0d0
      DW(230,68) = SAVE425
      YCCL(47) = YCCL(47)+DWCCL(230,68)*RK(230)
      DWCCL(230,68) = 0d0
      DW(230,47) = SAVE424
      YCCL(68) = YCCL(68)+DWCCL(230,47)*RK(230)
      DWCCL(230,47) = 0d0
      DW(229,68) = SAVE423
      YCCL(58) = YCCL(58)+DWCCL(229,68)*RK(229)
      DWCCL(229,68) = 0d0
      DW(229,58) = SAVE422
      YCCL(68) = YCCL(68)+DWCCL(229,58)*RK(229)
      DWCCL(229,58) = 0d0
      DW(228,68) = SAVE421
      YCCL(56) = YCCL(56)+DWCCL(228,68)*RK(228)
      DWCCL(228,68) = 0d0
      DW(228,56) = SAVE420
      YCCL(68) = YCCL(68)+DWCCL(228,56)*RK(228)
      DWCCL(228,56) = 0d0
      DW(227,68) = SAVE419
      YCCL(69) = YCCL(69)+DWCCL(227,68)*RK(227)
      DWCCL(227,68) = 0d0
      DW(227,69) = SAVE418
      YCCL(68) = YCCL(68)+DWCCL(227,69)*RK(227)
      DWCCL(227,69) = 0d0
      DW(226,68) = SAVE417
      YCCL(33) = YCCL(33)+DWCCL(226,68)*RK(226)
      DWCCL(226,68) = 0d0
      DW(226,33) = SAVE416
      YCCL(68) = YCCL(68)+DWCCL(226,33)*RK(226)
      DWCCL(226,33) = 0d0
      DW(225,68) = SAVE415
      YCCL(32) = YCCL(32)+DWCCL(225,68)*RK(225)
      DWCCL(225,68) = 0d0
      DW(225,32) = SAVE414
      YCCL(68) = YCCL(68)+DWCCL(225,32)*RK(225)
      DWCCL(225,32) = 0d0
      DW(224,68) = SAVE413
      YCCL(31) = YCCL(31)+DWCCL(224,68)*RK(224)
      DWCCL(224,68) = 0d0
      DW(224,31) = SAVE412
      YCCL(68) = YCCL(68)+DWCCL(224,31)*RK(224)
      DWCCL(224,31) = 0d0
      DW(223,68) = SAVE411
      YCCL(43) = YCCL(43)+DWCCL(223,68)*RK(223)
      DWCCL(223,68) = 0d0
      DW(223,43) = SAVE410
      YCCL(68) = YCCL(68)+DWCCL(223,43)*RK(223)
      DWCCL(223,43) = 0d0
      DW(222,68) = SAVE409
      YCCL(42) = YCCL(42)+DWCCL(222,68)*RK(222)
      DWCCL(222,68) = 0d0
      DW(222,42) = SAVE408
      YCCL(68) = YCCL(68)+DWCCL(222,42)*RK(222)
      DWCCL(222,42) = 0d0
      DW(221,68) = SAVE407
      YCCL(39) = YCCL(39)+DWCCL(221,68)*RK(221)
      DWCCL(221,68) = 0d0
      DW(221,39) = SAVE406
      YCCL(68) = YCCL(68)+DWCCL(221,39)*RK(221)
      DWCCL(221,39) = 0d0
      DW(220,68) = SAVE405
      YCCL(45) = YCCL(45)+DWCCL(220,68)*RK(220)
      DWCCL(220,68) = 0d0
      DW(220,45) = SAVE404
      YCCL(68) = YCCL(68)+DWCCL(220,45)*RK(220)
      DWCCL(220,45) = 0d0
      DW(219,68) = SAVE403
      YCCL(41) = YCCL(41)+DWCCL(219,68)*RK(219)
      DWCCL(219,68) = 0d0
      DW(219,41) = SAVE402
      YCCL(68) = YCCL(68)+DWCCL(219,41)*RK(219)
      DWCCL(219,41) = 0d0
      DW(218,68) = SAVE401
      YCCL(38) = YCCL(38)+DWCCL(218,68)*RK(218)
      DWCCL(218,68) = 0d0
      DW(218,38) = SAVE400
      YCCL(68) = YCCL(68)+DWCCL(218,38)*RK(218)
      DWCCL(218,38) = 0d0
      DW(217,68) = SAVE399
      YCCL(37) = YCCL(37)+DWCCL(217,68)*RK(217)
      DWCCL(217,68) = 0d0
      DW(217,37) = SAVE398
      YCCL(68) = YCCL(68)+DWCCL(217,37)*RK(217)
      DWCCL(217,37) = 0d0
      DW(216,68) = SAVE397
      YCCL(36) = YCCL(36)+DWCCL(216,68)*RK(216)
      DWCCL(216,68) = 0d0
      DW(216,36) = SAVE396
      YCCL(68) = YCCL(68)+DWCCL(216,36)*RK(216)
      DWCCL(216,36) = 0d0
      DW(215,68) = SAVE395
      YCCL(64) = YCCL(64)+DWCCL(215,68)*RK(215)
      DWCCL(215,68) = 0d0
      DW(215,64) = SAVE394
      YCCL(68) = YCCL(68)+DWCCL(215,64)*RK(215)
      DWCCL(215,64) = 0d0
      DW(214,68) = SAVE393
      YCCL(60) = YCCL(60)+DWCCL(214,68)*RK(214)
      DWCCL(214,68) = 0d0
      DW(214,60) = SAVE392
      YCCL(68) = YCCL(68)+DWCCL(214,60)*RK(214)
      DWCCL(214,60) = 0d0
      DW(213,68) = SAVE391
      YCCL(63) = YCCL(63)+DWCCL(213,68)*RK(213)
      DWCCL(213,68) = 0d0
      DW(213,63) = SAVE390
      YCCL(68) = YCCL(68)+DWCCL(213,63)*RK(213)
      DWCCL(213,63) = 0d0
      DW(212,46) = SAVE389
      YCCL(46) = YCCL(46)+DWCCL(212,46)*RK(212)
      DWCCL(212,46) = 0d0
      DW(212,46) = SAVE388
      YCCL(46) = YCCL(46)+DWCCL(212,46)*RK(212)
      DWCCL(212,46) = 0d0
      DW(211,46) = SAVE387
      YCCL(47) = YCCL(47)+DWCCL(211,46)*RK(211)
      DWCCL(211,46) = 0d0
      DW(211,47) = SAVE386
      YCCL(46) = YCCL(46)+DWCCL(211,47)*RK(211)
      DWCCL(211,47) = 0d0
      DW(210,47) = SAVE385
      YCCL(47) = YCCL(47)+DWCCL(210,47)*RK(210)
      DWCCL(210,47) = 0d0
      DW(210,47) = SAVE384
      YCCL(47) = YCCL(47)+DWCCL(210,47)*RK(210)
      DWCCL(210,47) = 0d0
      DW(209,69) = SAVE383
      YCCL(46) = YCCL(46)+DWCCL(209,69)*RK(209)
      DWCCL(209,69) = 0d0
      DW(209,46) = SAVE382
      YCCL(69) = YCCL(69)+DWCCL(209,46)*RK(209)
      DWCCL(209,46) = 0d0
      DW(208,69) = SAVE381
      YCCL(47) = YCCL(47)+DWCCL(208,69)*RK(208)
      DWCCL(208,69) = 0d0
      DW(208,47) = SAVE380
      YCCL(69) = YCCL(69)+DWCCL(208,47)*RK(208)
      DWCCL(208,47) = 0d0
      DW(207,69) = SAVE379
      YCCL(58) = YCCL(58)+DWCCL(207,69)*RK(207)
      DWCCL(207,69) = 0d0
      DW(207,58) = SAVE378
      YCCL(69) = YCCL(69)+DWCCL(207,58)*RK(207)
      DWCCL(207,58) = 0d0
      DW(206,69) = SAVE377
      YCCL(56) = YCCL(56)+DWCCL(206,69)*RK(206)
      DWCCL(206,69) = 0d0
      DW(206,56) = SAVE376
      YCCL(69) = YCCL(69)+DWCCL(206,56)*RK(206)
      DWCCL(206,56) = 0d0
      DW(205,69) = SAVE375
      YCCL(69) = YCCL(69)+DWCCL(205,69)*RK(205)
      DWCCL(205,69) = 0d0
      DW(205,69) = SAVE374
      YCCL(69) = YCCL(69)+DWCCL(205,69)*RK(205)
      DWCCL(205,69) = 0d0
      DW(204,69) = SAVE373
      YCCL(33) = YCCL(33)+DWCCL(204,69)*RK(204)
      DWCCL(204,69) = 0d0
      DW(204,33) = SAVE372
      YCCL(69) = YCCL(69)+DWCCL(204,33)*RK(204)
      DWCCL(204,33) = 0d0
      DW(203,69) = SAVE371
      YCCL(32) = YCCL(32)+DWCCL(203,69)*RK(203)
      DWCCL(203,69) = 0d0
      DW(203,32) = SAVE370
      YCCL(69) = YCCL(69)+DWCCL(203,32)*RK(203)
      DWCCL(203,32) = 0d0
      DW(202,69) = SAVE369
      YCCL(31) = YCCL(31)+DWCCL(202,69)*RK(202)
      DWCCL(202,69) = 0d0
      DW(202,31) = SAVE368
      YCCL(69) = YCCL(69)+DWCCL(202,31)*RK(202)
      DWCCL(202,31) = 0d0
      DW(201,69) = SAVE367
      YCCL(43) = YCCL(43)+DWCCL(201,69)*RK(201)
      DWCCL(201,69) = 0d0
      DW(201,43) = SAVE366
      YCCL(69) = YCCL(69)+DWCCL(201,43)*RK(201)
      DWCCL(201,43) = 0d0
      DW(200,69) = SAVE365
      YCCL(42) = YCCL(42)+DWCCL(200,69)*RK(200)
      DWCCL(200,69) = 0d0
      DW(200,42) = SAVE364
      YCCL(69) = YCCL(69)+DWCCL(200,42)*RK(200)
      DWCCL(200,42) = 0d0
      DW(199,69) = SAVE363
      YCCL(39) = YCCL(39)+DWCCL(199,69)*RK(199)
      DWCCL(199,69) = 0d0
      DW(199,39) = SAVE362
      YCCL(69) = YCCL(69)+DWCCL(199,39)*RK(199)
      DWCCL(199,39) = 0d0
      DW(198,69) = SAVE361
      YCCL(45) = YCCL(45)+DWCCL(198,69)*RK(198)
      DWCCL(198,69) = 0d0
      DW(198,45) = SAVE360
      YCCL(69) = YCCL(69)+DWCCL(198,45)*RK(198)
      DWCCL(198,45) = 0d0
      DW(197,69) = SAVE359
      YCCL(41) = YCCL(41)+DWCCL(197,69)*RK(197)
      DWCCL(197,69) = 0d0
      DW(197,41) = SAVE358
      YCCL(69) = YCCL(69)+DWCCL(197,41)*RK(197)
      DWCCL(197,41) = 0d0
      DW(196,69) = SAVE357
      YCCL(38) = YCCL(38)+DWCCL(196,69)*RK(196)
      DWCCL(196,69) = 0d0
      DW(196,38) = SAVE356
      YCCL(69) = YCCL(69)+DWCCL(196,38)*RK(196)
      DWCCL(196,38) = 0d0
      DW(195,69) = SAVE355
      YCCL(37) = YCCL(37)+DWCCL(195,69)*RK(195)
      DWCCL(195,69) = 0d0
      DW(195,37) = SAVE354
      YCCL(69) = YCCL(69)+DWCCL(195,37)*RK(195)
      DWCCL(195,37) = 0d0
      DW(194,69) = SAVE353
      YCCL(36) = YCCL(36)+DWCCL(194,69)*RK(194)
      DWCCL(194,69) = 0d0
      DW(194,36) = SAVE352
      YCCL(69) = YCCL(69)+DWCCL(194,36)*RK(194)
      DWCCL(194,36) = 0d0
      DW(193,69) = SAVE351
      YCCL(64) = YCCL(64)+DWCCL(193,69)*RK(193)
      DWCCL(193,69) = 0d0
      DW(193,64) = SAVE350
      YCCL(69) = YCCL(69)+DWCCL(193,64)*RK(193)
      DWCCL(193,64) = 0d0
      DW(192,69) = SAVE349
      YCCL(60) = YCCL(60)+DWCCL(192,69)*RK(192)
      DWCCL(192,69) = 0d0
      DW(192,60) = SAVE348
      YCCL(69) = YCCL(69)+DWCCL(192,60)*RK(192)
      DWCCL(192,60) = 0d0
      DW(191,63) = SAVE347
      YCCL(46) = YCCL(46)+DWCCL(191,63)*RK(191)
      DWCCL(191,63) = 0d0
      DW(191,46) = SAVE346
      YCCL(63) = YCCL(63)+DWCCL(191,46)*RK(191)
      DWCCL(191,46) = 0d0
      DW(190,63) = SAVE345
      YCCL(47) = YCCL(47)+DWCCL(190,63)*RK(190)
      DWCCL(190,63) = 0d0
      DW(190,47) = SAVE344
      YCCL(63) = YCCL(63)+DWCCL(190,47)*RK(190)
      DWCCL(190,47) = 0d0
      DW(189,63) = SAVE343
      YCCL(58) = YCCL(58)+DWCCL(189,63)*RK(189)
      DWCCL(189,63) = 0d0
      DW(189,58) = SAVE342
      YCCL(63) = YCCL(63)+DWCCL(189,58)*RK(189)
      DWCCL(189,58) = 0d0
      DW(188,63) = SAVE341
      YCCL(56) = YCCL(56)+DWCCL(188,63)*RK(188)
      DWCCL(188,63) = 0d0
      DW(188,56) = SAVE340
      YCCL(63) = YCCL(63)+DWCCL(188,56)*RK(188)
      DWCCL(188,56) = 0d0
      DW(187,63) = SAVE339
      YCCL(56) = YCCL(56)+DWCCL(187,63)*RK(187)
      DWCCL(187,63) = 0d0
      DW(187,56) = SAVE338
      YCCL(63) = YCCL(63)+DWCCL(187,56)*RK(187)
      DWCCL(187,56) = 0d0
      DW(186,63) = SAVE337
      YCCL(69) = YCCL(69)+DWCCL(186,63)*RK(186)
      DWCCL(186,63) = 0d0
      DW(186,69) = SAVE336
      YCCL(63) = YCCL(63)+DWCCL(186,69)*RK(186)
      DWCCL(186,69) = 0d0
      DW(185,63) = SAVE335
      YCCL(69) = YCCL(69)+DWCCL(185,63)*RK(185)
      DWCCL(185,63) = 0d0
      DW(185,69) = SAVE334
      YCCL(63) = YCCL(63)+DWCCL(185,69)*RK(185)
      DWCCL(185,69) = 0d0
      DW(184,63) = SAVE333
      YCCL(33) = YCCL(33)+DWCCL(184,63)*RK(184)
      DWCCL(184,63) = 0d0
      DW(184,33) = SAVE332
      YCCL(63) = YCCL(63)+DWCCL(184,33)*RK(184)
      DWCCL(184,33) = 0d0
      DW(183,63) = SAVE331
      YCCL(32) = YCCL(32)+DWCCL(183,63)*RK(183)
      DWCCL(183,63) = 0d0
      DW(183,32) = SAVE330
      YCCL(63) = YCCL(63)+DWCCL(183,32)*RK(183)
      DWCCL(183,32) = 0d0
      DW(182,63) = SAVE329
      YCCL(31) = YCCL(31)+DWCCL(182,63)*RK(182)
      DWCCL(182,63) = 0d0
      DW(182,31) = SAVE328
      YCCL(63) = YCCL(63)+DWCCL(182,31)*RK(182)
      DWCCL(182,31) = 0d0
      DW(181,63) = SAVE327
      YCCL(43) = YCCL(43)+DWCCL(181,63)*RK(181)
      DWCCL(181,63) = 0d0
      DW(181,43) = SAVE326
      YCCL(63) = YCCL(63)+DWCCL(181,43)*RK(181)
      DWCCL(181,43) = 0d0
      DW(180,63) = SAVE325
      YCCL(42) = YCCL(42)+DWCCL(180,63)*RK(180)
      DWCCL(180,63) = 0d0
      DW(180,42) = SAVE324
      YCCL(63) = YCCL(63)+DWCCL(180,42)*RK(180)
      DWCCL(180,42) = 0d0
      DW(179,63) = SAVE323
      YCCL(39) = YCCL(39)+DWCCL(179,63)*RK(179)
      DWCCL(179,63) = 0d0
      DW(179,39) = SAVE322
      YCCL(63) = YCCL(63)+DWCCL(179,39)*RK(179)
      DWCCL(179,39) = 0d0
      DW(178,63) = SAVE321
      YCCL(45) = YCCL(45)+DWCCL(178,63)*RK(178)
      DWCCL(178,63) = 0d0
      DW(178,45) = SAVE320
      YCCL(63) = YCCL(63)+DWCCL(178,45)*RK(178)
      DWCCL(178,45) = 0d0
      DW(177,63) = SAVE319
      YCCL(41) = YCCL(41)+DWCCL(177,63)*RK(177)
      DWCCL(177,63) = 0d0
      DW(177,41) = SAVE318
      YCCL(63) = YCCL(63)+DWCCL(177,41)*RK(177)
      DWCCL(177,41) = 0d0
      DW(176,63) = SAVE317
      YCCL(38) = YCCL(38)+DWCCL(176,63)*RK(176)
      DWCCL(176,63) = 0d0
      DW(176,38) = SAVE316
      YCCL(63) = YCCL(63)+DWCCL(176,38)*RK(176)
      DWCCL(176,38) = 0d0
      DW(175,63) = SAVE315
      YCCL(37) = YCCL(37)+DWCCL(175,63)*RK(175)
      DWCCL(175,63) = 0d0
      DW(175,37) = SAVE314
      YCCL(63) = YCCL(63)+DWCCL(175,37)*RK(175)
      DWCCL(175,37) = 0d0
      DW(174,63) = SAVE313
      YCCL(36) = YCCL(36)+DWCCL(174,63)*RK(174)
      DWCCL(174,63) = 0d0
      DW(174,36) = SAVE312
      YCCL(63) = YCCL(63)+DWCCL(174,36)*RK(174)
      DWCCL(174,36) = 0d0
      DW(173,63) = SAVE311
      YCCL(64) = YCCL(64)+DWCCL(173,63)*RK(173)
      DWCCL(173,63) = 0d0
      DW(173,64) = SAVE310
      YCCL(63) = YCCL(63)+DWCCL(173,64)*RK(173)
      DWCCL(173,64) = 0d0
      DW(172,63) = SAVE309
      YCCL(60) = YCCL(60)+DWCCL(172,63)*RK(172)
      DWCCL(172,63) = 0d0
      DW(172,60) = SAVE308
      YCCL(63) = YCCL(63)+DWCCL(172,60)*RK(172)
      DWCCL(172,60) = 0d0
      DW(171,63) = SAVE307
      YCCL(63) = YCCL(63)+DWCCL(171,63)*RK(171)
      DWCCL(171,63) = 0d0
      DW(171,63) = SAVE306
      YCCL(63) = YCCL(63)+DWCCL(171,63)*RK(171)
      DWCCL(171,63) = 0d0
      DW(170,71) = SAVE305
      YCCL(46) = YCCL(46)+DWCCL(170,71)*RK(170)
      DWCCL(170,71) = 0d0
      DW(170,46) = SAVE304
      YCCL(71) = YCCL(71)+DWCCL(170,46)*RK(170)
      DWCCL(170,46) = 0d0
      DW(169,71) = SAVE303
      YCCL(47) = YCCL(47)+DWCCL(169,71)*RK(169)
      DWCCL(169,71) = 0d0
      DW(169,47) = SAVE302
      YCCL(71) = YCCL(71)+DWCCL(169,47)*RK(169)
      DWCCL(169,47) = 0d0
      DW(168,71) = SAVE301
      YCCL(58) = YCCL(58)+DWCCL(168,71)*RK(168)
      DWCCL(168,71) = 0d0
      DW(168,58) = SAVE300
      YCCL(71) = YCCL(71)+DWCCL(168,58)*RK(168)
      DWCCL(168,58) = 0d0
      DW(167,71) = SAVE299
      YCCL(56) = YCCL(56)+DWCCL(167,71)*RK(167)
      DWCCL(167,71) = 0d0
      DW(167,56) = SAVE298
      YCCL(71) = YCCL(71)+DWCCL(167,56)*RK(167)
      DWCCL(167,56) = 0d0
      DW(166,71) = SAVE297
      YCCL(56) = YCCL(56)+DWCCL(166,71)*RK(166)
      DWCCL(166,71) = 0d0
      DW(166,56) = SAVE296
      YCCL(71) = YCCL(71)+DWCCL(166,56)*RK(166)
      DWCCL(166,56) = 0d0
      DW(165,71) = SAVE295
      YCCL(69) = YCCL(69)+DWCCL(165,71)*RK(165)
      DWCCL(165,71) = 0d0
      DW(165,69) = SAVE294
      YCCL(71) = YCCL(71)+DWCCL(165,69)*RK(165)
      DWCCL(165,69) = 0d0
      DW(164,71) = SAVE293
      YCCL(69) = YCCL(69)+DWCCL(164,71)*RK(164)
      DWCCL(164,71) = 0d0
      DW(164,69) = SAVE292
      YCCL(71) = YCCL(71)+DWCCL(164,69)*RK(164)
      DWCCL(164,69) = 0d0
      DW(163,71) = SAVE291
      YCCL(33) = YCCL(33)+DWCCL(163,71)*RK(163)
      DWCCL(163,71) = 0d0
      DW(163,33) = SAVE290
      YCCL(71) = YCCL(71)+DWCCL(163,33)*RK(163)
      DWCCL(163,33) = 0d0
      DW(162,71) = SAVE289
      YCCL(32) = YCCL(32)+DWCCL(162,71)*RK(162)
      DWCCL(162,71) = 0d0
      DW(162,32) = SAVE288
      YCCL(71) = YCCL(71)+DWCCL(162,32)*RK(162)
      DWCCL(162,32) = 0d0
      DW(161,71) = SAVE287
      YCCL(31) = YCCL(31)+DWCCL(161,71)*RK(161)
      DWCCL(161,71) = 0d0
      DW(161,31) = SAVE286
      YCCL(71) = YCCL(71)+DWCCL(161,31)*RK(161)
      DWCCL(161,31) = 0d0
      DW(160,71) = SAVE285
      YCCL(43) = YCCL(43)+DWCCL(160,71)*RK(160)
      DWCCL(160,71) = 0d0
      DW(160,43) = SAVE284
      YCCL(71) = YCCL(71)+DWCCL(160,43)*RK(160)
      DWCCL(160,43) = 0d0
      DW(159,71) = SAVE283
      YCCL(42) = YCCL(42)+DWCCL(159,71)*RK(159)
      DWCCL(159,71) = 0d0
      DW(159,42) = SAVE282
      YCCL(71) = YCCL(71)+DWCCL(159,42)*RK(159)
      DWCCL(159,42) = 0d0
      DW(158,71) = SAVE281
      YCCL(39) = YCCL(39)+DWCCL(158,71)*RK(158)
      DWCCL(158,71) = 0d0
      DW(158,39) = SAVE280
      YCCL(71) = YCCL(71)+DWCCL(158,39)*RK(158)
      DWCCL(158,39) = 0d0
      DW(157,71) = SAVE279
      YCCL(45) = YCCL(45)+DWCCL(157,71)*RK(157)
      DWCCL(157,71) = 0d0
      DW(157,45) = SAVE278
      YCCL(71) = YCCL(71)+DWCCL(157,45)*RK(157)
      DWCCL(157,45) = 0d0
      DW(156,71) = SAVE277
      YCCL(41) = YCCL(41)+DWCCL(156,71)*RK(156)
      DWCCL(156,71) = 0d0
      DW(156,41) = SAVE276
      YCCL(71) = YCCL(71)+DWCCL(156,41)*RK(156)
      DWCCL(156,41) = 0d0
      DW(155,71) = SAVE275
      YCCL(38) = YCCL(38)+DWCCL(155,71)*RK(155)
      DWCCL(155,71) = 0d0
      DW(155,38) = SAVE274
      YCCL(71) = YCCL(71)+DWCCL(155,38)*RK(155)
      DWCCL(155,38) = 0d0
      DW(154,71) = SAVE273
      YCCL(37) = YCCL(37)+DWCCL(154,71)*RK(154)
      DWCCL(154,71) = 0d0
      DW(154,37) = SAVE272
      YCCL(71) = YCCL(71)+DWCCL(154,37)*RK(154)
      DWCCL(154,37) = 0d0
      DW(153,71) = SAVE271
      YCCL(36) = YCCL(36)+DWCCL(153,71)*RK(153)
      DWCCL(153,71) = 0d0
      DW(153,36) = SAVE270
      YCCL(71) = YCCL(71)+DWCCL(153,36)*RK(153)
      DWCCL(153,36) = 0d0
      DW(152,71) = SAVE269
      YCCL(64) = YCCL(64)+DWCCL(152,71)*RK(152)
      DWCCL(152,71) = 0d0
      DW(152,64) = SAVE268
      YCCL(71) = YCCL(71)+DWCCL(152,64)*RK(152)
      DWCCL(152,64) = 0d0
      DW(151,71) = SAVE267
      YCCL(60) = YCCL(60)+DWCCL(151,71)*RK(151)
      DWCCL(151,71) = 0d0
      DW(151,60) = SAVE266
      YCCL(71) = YCCL(71)+DWCCL(151,60)*RK(151)
      DWCCL(151,60) = 0d0
      DW(150,71) = SAVE265
      YCCL(63) = YCCL(63)+DWCCL(150,71)*RK(150)
      DWCCL(150,71) = 0d0
      DW(150,63) = SAVE264
      YCCL(71) = YCCL(71)+DWCCL(150,63)*RK(150)
      DWCCL(150,63) = 0d0
      DW(149,67) = SAVE263
      YCCL(46) = YCCL(46)+DWCCL(149,67)*RK(149)
      DWCCL(149,67) = 0d0
      DW(149,46) = SAVE262
      YCCL(67) = YCCL(67)+DWCCL(149,46)*RK(149)
      DWCCL(149,46) = 0d0
      DW(148,67) = SAVE261
      YCCL(47) = YCCL(47)+DWCCL(148,67)*RK(148)
      DWCCL(148,67) = 0d0
      DW(148,47) = SAVE260
      YCCL(67) = YCCL(67)+DWCCL(148,47)*RK(148)
      DWCCL(148,47) = 0d0
      DW(147,67) = SAVE259
      YCCL(58) = YCCL(58)+DWCCL(147,67)*RK(147)
      DWCCL(147,67) = 0d0
      DW(147,58) = SAVE258
      YCCL(67) = YCCL(67)+DWCCL(147,58)*RK(147)
      DWCCL(147,58) = 0d0
      DW(146,67) = SAVE257
      YCCL(56) = YCCL(56)+DWCCL(146,67)*RK(146)
      DWCCL(146,67) = 0d0
      DW(146,56) = SAVE256
      YCCL(67) = YCCL(67)+DWCCL(146,56)*RK(146)
      DWCCL(146,56) = 0d0
      DW(145,67) = SAVE255
      YCCL(69) = YCCL(69)+DWCCL(145,67)*RK(145)
      DWCCL(145,67) = 0d0
      DW(145,69) = SAVE254
      YCCL(67) = YCCL(67)+DWCCL(145,69)*RK(145)
      DWCCL(145,69) = 0d0
      DW(144,67) = SAVE253
      YCCL(33) = YCCL(33)+DWCCL(144,67)*RK(144)
      DWCCL(144,67) = 0d0
      DW(144,33) = SAVE252
      YCCL(67) = YCCL(67)+DWCCL(144,33)*RK(144)
      DWCCL(144,33) = 0d0
      DW(143,67) = SAVE251
      YCCL(32) = YCCL(32)+DWCCL(143,67)*RK(143)
      DWCCL(143,67) = 0d0
      DW(143,32) = SAVE250
      YCCL(67) = YCCL(67)+DWCCL(143,32)*RK(143)
      DWCCL(143,32) = 0d0
      DW(142,67) = SAVE249
      YCCL(31) = YCCL(31)+DWCCL(142,67)*RK(142)
      DWCCL(142,67) = 0d0
      DW(142,31) = SAVE248
      YCCL(67) = YCCL(67)+DWCCL(142,31)*RK(142)
      DWCCL(142,31) = 0d0
      DW(141,67) = SAVE247
      YCCL(43) = YCCL(43)+DWCCL(141,67)*RK(141)
      DWCCL(141,67) = 0d0
      DW(141,43) = SAVE246
      YCCL(67) = YCCL(67)+DWCCL(141,43)*RK(141)
      DWCCL(141,43) = 0d0
      DW(140,67) = SAVE245
      YCCL(42) = YCCL(42)+DWCCL(140,67)*RK(140)
      DWCCL(140,67) = 0d0
      DW(140,42) = SAVE244
      YCCL(67) = YCCL(67)+DWCCL(140,42)*RK(140)
      DWCCL(140,42) = 0d0
      DW(139,67) = SAVE243
      YCCL(39) = YCCL(39)+DWCCL(139,67)*RK(139)
      DWCCL(139,67) = 0d0
      DW(139,39) = SAVE242
      YCCL(67) = YCCL(67)+DWCCL(139,39)*RK(139)
      DWCCL(139,39) = 0d0
      DW(138,67) = SAVE241
      YCCL(45) = YCCL(45)+DWCCL(138,67)*RK(138)
      DWCCL(138,67) = 0d0
      DW(138,45) = SAVE240
      YCCL(67) = YCCL(67)+DWCCL(138,45)*RK(138)
      DWCCL(138,45) = 0d0
      DW(137,67) = SAVE239
      YCCL(41) = YCCL(41)+DWCCL(137,67)*RK(137)
      DWCCL(137,67) = 0d0
      DW(137,41) = SAVE238
      YCCL(67) = YCCL(67)+DWCCL(137,41)*RK(137)
      DWCCL(137,41) = 0d0
      DW(136,67) = SAVE237
      YCCL(38) = YCCL(38)+DWCCL(136,67)*RK(136)
      DWCCL(136,67) = 0d0
      DW(136,38) = SAVE236
      YCCL(67) = YCCL(67)+DWCCL(136,38)*RK(136)
      DWCCL(136,38) = 0d0
      DW(135,67) = SAVE235
      YCCL(37) = YCCL(37)+DWCCL(135,67)*RK(135)
      DWCCL(135,67) = 0d0
      DW(135,37) = SAVE234
      YCCL(67) = YCCL(67)+DWCCL(135,37)*RK(135)
      DWCCL(135,37) = 0d0
      DW(134,67) = SAVE233
      YCCL(36) = YCCL(36)+DWCCL(134,67)*RK(134)
      DWCCL(134,67) = 0d0
      DW(134,36) = SAVE232
      YCCL(67) = YCCL(67)+DWCCL(134,36)*RK(134)
      DWCCL(134,36) = 0d0
      DW(133,67) = SAVE231
      YCCL(64) = YCCL(64)+DWCCL(133,67)*RK(133)
      DWCCL(133,67) = 0d0
      DW(133,64) = SAVE230
      YCCL(67) = YCCL(67)+DWCCL(133,64)*RK(133)
      DWCCL(133,64) = 0d0
      DW(132,67) = SAVE229
      YCCL(60) = YCCL(60)+DWCCL(132,67)*RK(132)
      DWCCL(132,67) = 0d0
      DW(132,60) = SAVE228
      YCCL(67) = YCCL(67)+DWCCL(132,60)*RK(132)
      DWCCL(132,60) = 0d0
      DW(131,67) = SAVE227
      YCCL(63) = YCCL(63)+DWCCL(131,67)*RK(131)
      DWCCL(131,67) = 0d0
      DW(131,63) = SAVE226
      YCCL(67) = YCCL(67)+DWCCL(131,63)*RK(131)
      DWCCL(131,63) = 0d0
      DW(130,25) = SAVE225
      DWCCL(130,25) = 0d0
      DW(129,72) = SAVE224
      YCCL(56) = YCCL(56)+DWCCL(129,72)*RK(129)
      DWCCL(129,72) = 0d0
      DW(129,56) = SAVE223
      YCCL(72) = YCCL(72)+DWCCL(129,56)*RK(129)
      DWCCL(129,56) = 0d0
      DW(128,26) = SAVE222
      DWCCL(128,26) = 0d0
      DW(127,72) = SAVE221
      YCCL(69) = YCCL(69)+DWCCL(127,72)*RK(127)
      DWCCL(127,72) = 0d0
      DW(127,69) = SAVE220
      YCCL(72) = YCCL(72)+DWCCL(127,69)*RK(127)
      DWCCL(127,69) = 0d0
      DW(126,50) = SAVE219
      YCCL(22) = YCCL(22)+DWCCL(126,50)*RK(126)
      DWCCL(126,50) = 0d0
      DW(126,22) = SAVE218
      YCCL(50) = YCCL(50)+DWCCL(126,22)*RK(126)
      DWCCL(126,22) = 0d0
      DW(125,22) = SAVE217
      DWCCL(125,22) = 0d0
      DW(124,72) = SAVE216
      YCCL(22) = YCCL(22)+DWCCL(124,72)*RK(124)
      DWCCL(124,72) = 0d0
      DW(124,22) = SAVE215
      YCCL(72) = YCCL(72)+DWCCL(124,22)*RK(124)
      DWCCL(124,22) = 0d0
      DW(123,50) = SAVE214
      YCCL(18) = YCCL(18)+DWCCL(123,50)*RK(123)
      DWCCL(123,50) = 0d0
      DW(123,18) = SAVE213
      YCCL(50) = YCCL(50)+DWCCL(123,18)*RK(123)
      DWCCL(123,18) = 0d0
      DW(122,18) = SAVE212
      DWCCL(122,18) = 0d0
      DW(121,72) = SAVE211
      YCCL(18) = YCCL(18)+DWCCL(121,72)*RK(121)
      DWCCL(121,72) = 0d0
      DW(121,18) = SAVE210
      YCCL(72) = YCCL(72)+DWCCL(121,18)*RK(121)
      DWCCL(121,18) = 0d0
      DW(120,50) = SAVE209
      YCCL(17) = YCCL(17)+DWCCL(120,50)*RK(120)
      DWCCL(120,50) = 0d0
      DW(120,17) = SAVE208
      YCCL(50) = YCCL(50)+DWCCL(120,17)*RK(120)
      DWCCL(120,17) = 0d0
      DW(119,17) = SAVE207
      DWCCL(119,17) = 0d0
      DW(118,72) = SAVE206
      YCCL(17) = YCCL(17)+DWCCL(118,72)*RK(118)
      DWCCL(118,72) = 0d0
      DW(118,17) = SAVE205
      YCCL(72) = YCCL(72)+DWCCL(118,17)*RK(118)
      DWCCL(118,17) = 0d0
      DW(117,71) = SAVE204
      YCCL(29) = YCCL(29)+DWCCL(117,71)*RK(117)
      DWCCL(117,71) = 0d0
      DW(117,29) = SAVE203
      YCCL(71) = YCCL(71)+DWCCL(117,29)*RK(117)
      DWCCL(117,29) = 0d0
      DW(116,72) = SAVE202
      YCCL(29) = YCCL(29)+DWCCL(116,72)*RK(116)
      DWCCL(116,72) = 0d0
      DW(116,29) = SAVE201
      YCCL(72) = YCCL(72)+DWCCL(116,29)*RK(116)
      DWCCL(116,29) = 0d0
      DW(115,50) = SAVE200
      YCCL(25) = YCCL(25)+DWCCL(115,50)*RK(115)
      DWCCL(115,50) = 0d0
      DW(115,25) = SAVE199
      YCCL(50) = YCCL(50)+DWCCL(115,25)*RK(115)
      DWCCL(115,25) = 0d0
      DW(114,50) = SAVE198
      YCCL(48) = YCCL(48)+DWCCL(114,50)*RK(114)
      DWCCL(114,50) = 0d0
      DW(114,48) = SAVE197
      YCCL(50) = YCCL(50)+DWCCL(114,48)*RK(114)
      DWCCL(114,48) = 0d0
      DW(113,50) = SAVE196
      YCCL(49) = YCCL(49)+DWCCL(113,50)*RK(113)
      DWCCL(113,50) = 0d0
      DW(113,49) = SAVE195
      YCCL(50) = YCCL(50)+DWCCL(113,49)*RK(113)
      DWCCL(113,49) = 0d0
      DW(112,50) = SAVE194
      YCCL(14) = YCCL(14)+DWCCL(112,50)*RK(112)
      DWCCL(112,50) = 0d0
      DW(112,14) = SAVE193
      YCCL(50) = YCCL(50)+DWCCL(112,14)*RK(112)
      DWCCL(112,14) = 0d0
      DW(111,50) = SAVE192
      YCCL(13) = YCCL(13)+DWCCL(111,50)*RK(111)
      DWCCL(111,50) = 0d0
      DW(111,13) = SAVE191
      YCCL(50) = YCCL(50)+DWCCL(111,13)*RK(111)
      DWCCL(111,13) = 0d0
      DW(110,50) = SAVE190
      YCCL(19) = YCCL(19)+DWCCL(110,50)*RK(110)
      DWCCL(110,50) = 0d0
      DW(110,19) = SAVE189
      YCCL(50) = YCCL(50)+DWCCL(110,19)*RK(110)
      DWCCL(110,19) = 0d0
      DW(109,50) = SAVE188
      YCCL(12) = YCCL(12)+DWCCL(109,50)*RK(109)
      DWCCL(109,50) = 0d0
      DW(109,12) = SAVE187
      YCCL(50) = YCCL(50)+DWCCL(109,12)*RK(109)
      DWCCL(109,12) = 0d0
      DW(108,50) = SAVE186
      YCCL(44) = YCCL(44)+DWCCL(108,50)*RK(108)
      DWCCL(108,50) = 0d0
      DW(108,44) = SAVE185
      YCCL(50) = YCCL(50)+DWCCL(108,44)*RK(108)
      DWCCL(108,44) = 0d0
      DW(107,50) = SAVE184
      YCCL(40) = YCCL(40)+DWCCL(107,50)*RK(107)
      DWCCL(107,50) = 0d0
      DW(107,40) = SAVE183
      YCCL(50) = YCCL(50)+DWCCL(107,40)*RK(107)
      DWCCL(107,40) = 0d0
      DW(106,50) = SAVE182
      YCCL(11) = YCCL(11)+DWCCL(106,50)*RK(106)
      DWCCL(106,50) = 0d0
      DW(106,11) = SAVE181
      YCCL(50) = YCCL(50)+DWCCL(106,11)*RK(106)
      DWCCL(106,11) = 0d0
      DW(105,68) = SAVE180
      YCCL(25) = YCCL(25)+DWCCL(105,68)*RK(105)
      DWCCL(105,68) = 0d0
      DW(105,25) = SAVE179
      YCCL(68) = YCCL(68)+DWCCL(105,25)*RK(105)
      DWCCL(105,25) = 0d0
      DW(104,68) = SAVE178
      YCCL(14) = YCCL(14)+DWCCL(104,68)*RK(104)
      DWCCL(104,68) = 0d0
      DW(104,14) = SAVE177
      YCCL(68) = YCCL(68)+DWCCL(104,14)*RK(104)
      DWCCL(104,14) = 0d0
      DW(103,68) = SAVE176
      YCCL(13) = YCCL(13)+DWCCL(103,68)*RK(103)
      DWCCL(103,68) = 0d0
      DW(103,13) = SAVE175
      YCCL(68) = YCCL(68)+DWCCL(103,13)*RK(103)
      DWCCL(103,13) = 0d0
      DW(102,68) = SAVE174
      YCCL(19) = YCCL(19)+DWCCL(102,68)*RK(102)
      DWCCL(102,68) = 0d0
      DW(102,19) = SAVE173
      YCCL(68) = YCCL(68)+DWCCL(102,19)*RK(102)
      DWCCL(102,19) = 0d0
      DW(101,68) = SAVE172
      YCCL(12) = YCCL(12)+DWCCL(101,68)*RK(101)
      DWCCL(101,68) = 0d0
      DW(101,12) = SAVE171
      YCCL(68) = YCCL(68)+DWCCL(101,12)*RK(101)
      DWCCL(101,12) = 0d0
      DW(100,68) = SAVE170
      YCCL(44) = YCCL(44)+DWCCL(100,68)*RK(100)
      DWCCL(100,68) = 0d0
      DW(100,44) = SAVE169
      YCCL(68) = YCCL(68)+DWCCL(100,44)*RK(100)
      DWCCL(100,44) = 0d0
      DW(99,68) = SAVE168
      YCCL(40) = YCCL(40)+DWCCL(99,68)*RK(99)
      DWCCL(99,68) = 0d0
      DW(99,40) = SAVE167
      YCCL(68) = YCCL(68)+DWCCL(99,40)*RK(99)
      DWCCL(99,40) = 0d0
      DW(98,68) = SAVE166
      YCCL(11) = YCCL(11)+DWCCL(98,68)*RK(98)
      DWCCL(98,68) = 0d0
      DW(98,11) = SAVE165
      YCCL(68) = YCCL(68)+DWCCL(98,11)*RK(98)
      DWCCL(98,11) = 0d0
      DW(97,68) = SAVE164
      YCCL(30) = YCCL(30)+DWCCL(97,68)*RK(97)
      DWCCL(97,68) = 0d0
      DW(97,30) = SAVE163
      YCCL(68) = YCCL(68)+DWCCL(97,30)*RK(97)
      DWCCL(97,30) = 0d0
      DW(96,68) = SAVE162
      YCCL(48) = YCCL(48)+DWCCL(96,68)*RK(96)
      DWCCL(96,68) = 0d0
      DW(96,48) = SAVE161
      YCCL(68) = YCCL(68)+DWCCL(96,48)*RK(96)
      DWCCL(96,48) = 0d0
      DW(95,68) = SAVE160
      YCCL(49) = YCCL(49)+DWCCL(95,68)*RK(95)
      DWCCL(95,68) = 0d0
      DW(95,49) = SAVE159
      YCCL(68) = YCCL(68)+DWCCL(95,49)*RK(95)
      DWCCL(95,49) = 0d0
      DW(94,68) = SAVE158
      YCCL(54) = YCCL(54)+DWCCL(94,68)*RK(94)
      DWCCL(94,68) = 0d0
      DW(94,54) = SAVE157
      YCCL(68) = YCCL(68)+DWCCL(94,54)*RK(94)
      DWCCL(94,54) = 0d0
      DW(93,68) = SAVE156
      YCCL(51) = YCCL(51)+DWCCL(93,68)*RK(93)
      DWCCL(93,68) = 0d0
      DW(93,51) = SAVE155
      YCCL(68) = YCCL(68)+DWCCL(93,51)*RK(93)
      DWCCL(93,51) = 0d0
      DW(92,68) = SAVE154
      YCCL(61) = YCCL(61)+DWCCL(92,68)*RK(92)
      DWCCL(92,68) = 0d0
      DW(92,61) = SAVE153
      YCCL(68) = YCCL(68)+DWCCL(92,61)*RK(92)
      DWCCL(92,61) = 0d0
      DW(91,68) = SAVE152
      YCCL(66) = YCCL(66)+DWCCL(91,68)*RK(91)
      DWCCL(91,68) = 0d0
      DW(91,66) = SAVE151
      YCCL(68) = YCCL(68)+DWCCL(91,66)*RK(91)
      DWCCL(91,66) = 0d0
      DW(90,62) = SAVE150
      YCCL(70) = YCCL(70)+DWCCL(90,62)*RK(90)
      DWCCL(90,62) = 0d0
      DW(90,70) = SAVE149
      YCCL(62) = YCCL(62)+DWCCL(90,70)*RK(90)
      DWCCL(90,70) = 0d0
      DW(89,62) = SAVE148
      YCCL(25) = YCCL(25)+DWCCL(89,62)*RK(89)
      DWCCL(89,62) = 0d0
      DW(89,25) = SAVE147
      YCCL(62) = YCCL(62)+DWCCL(89,25)*RK(89)
      DWCCL(89,25) = 0d0
      DW(88,62) = SAVE146
      YCCL(26) = YCCL(26)+DWCCL(88,62)*RK(88)
      DWCCL(88,62) = 0d0
      DW(88,26) = SAVE145
      YCCL(62) = YCCL(62)+DWCCL(88,26)*RK(88)
      DWCCL(88,26) = 0d0
      DW(87,62) = SAVE144
      YCCL(28) = YCCL(28)+DWCCL(87,62)*RK(87)
      DWCCL(87,62) = 0d0
      DW(87,28) = SAVE143
      YCCL(62) = YCCL(62)+DWCCL(87,28)*RK(87)
      DWCCL(87,28) = 0d0
      DW(86,62) = SAVE142
      YCCL(53) = YCCL(53)+DWCCL(86,62)*RK(86)
      DWCCL(86,62) = 0d0
      DW(86,53) = SAVE141
      YCCL(62) = YCCL(62)+DWCCL(86,53)*RK(86)
      DWCCL(86,53) = 0d0
      DW(85,62) = SAVE140
      YCCL(16) = YCCL(16)+DWCCL(85,62)*RK(85)
      DWCCL(85,62) = 0d0
      DW(85,16) = SAVE139
      YCCL(62) = YCCL(62)+DWCCL(85,16)*RK(85)
      DWCCL(85,16) = 0d0
      DW(84,10) = SAVE138
      YCCL(62) = YCCL(62)+DWCCL(84,10)*RK(84)
      DWCCL(84,10) = 0d0
      DW(84,62) = SAVE137
      YCCL(10) = YCCL(10)+DWCCL(84,62)*RK(84)
      DWCCL(84,62) = 0d0
      DW(83,48) = SAVE136
      YCCL(62) = YCCL(62)+DWCCL(83,48)*RK(83)
      DWCCL(83,48) = 0d0
      DW(83,62) = SAVE135
      YCCL(48) = YCCL(48)+DWCCL(83,62)*RK(83)
      DWCCL(83,62) = 0d0
      DW(82,62) = SAVE134
      YCCL(49) = YCCL(49)+DWCCL(82,62)*RK(82)
      DWCCL(82,62) = 0d0
      DW(82,49) = SAVE133
      YCCL(62) = YCCL(62)+DWCCL(82,49)*RK(82)
      DWCCL(82,49) = 0d0
      DW(81,62) = SAVE132
      YCCL(54) = YCCL(54)+DWCCL(81,62)*RK(81)
      DWCCL(81,62) = 0d0
      DW(81,54) = SAVE131
      YCCL(62) = YCCL(62)+DWCCL(81,54)*RK(81)
      DWCCL(81,54) = 0d0
      DW(80,62) = SAVE130
      YCCL(51) = YCCL(51)+DWCCL(80,62)*RK(80)
      DWCCL(80,62) = 0d0
      DW(80,51) = SAVE129
      YCCL(62) = YCCL(62)+DWCCL(80,51)*RK(80)
      DWCCL(80,51) = 0d0
      DW(79,62) = SAVE128
      YCCL(24) = YCCL(24)+DWCCL(79,62)*RK(79)
      DWCCL(79,62) = 0d0
      DW(79,24) = SAVE127
      YCCL(62) = YCCL(62)+DWCCL(79,24)*RK(79)
      DWCCL(79,24) = 0d0
      DW(78,62) = SAVE126
      YCCL(59) = YCCL(59)+DWCCL(78,62)*RK(78)
      DWCCL(78,62) = 0d0
      DW(78,59) = SAVE125
      YCCL(62) = YCCL(62)+DWCCL(78,59)*RK(78)
      DWCCL(78,59) = 0d0
      DW(77,62) = SAVE124
      YCCL(61) = YCCL(61)+DWCCL(77,62)*RK(77)
      DWCCL(77,62) = 0d0
      DW(77,61) = SAVE123
      YCCL(62) = YCCL(62)+DWCCL(77,61)*RK(77)
      DWCCL(77,61) = 0d0
      DW(76,62) = SAVE122
      YCCL(66) = YCCL(66)+DWCCL(76,62)*RK(76)
      DWCCL(76,62) = 0d0
      DW(76,66) = SAVE121
      YCCL(62) = YCCL(62)+DWCCL(76,66)*RK(76)
      DWCCL(76,66) = 0d0
      DW(75,62) = SAVE120
      YCCL(30) = YCCL(30)+DWCCL(75,62)*RK(75)
      DWCCL(75,62) = 0d0
      DW(75,30) = SAVE119
      YCCL(62) = YCCL(62)+DWCCL(75,30)*RK(75)
      DWCCL(75,30) = 0d0
      DW(74,62) = SAVE118
      YCCL(6) = YCCL(6)+DWCCL(74,62)*RK(74)
      DWCCL(74,62) = 0d0
      DW(74,6) = SAVE117
      YCCL(62) = YCCL(62)+DWCCL(74,6)*RK(74)
      DWCCL(74,6) = 0d0
      DW(73,62) = SAVE116
      YCCL(5) = YCCL(5)+DWCCL(73,62)*RK(73)
      DWCCL(73,62) = 0d0
      DW(73,5) = SAVE115
      YCCL(62) = YCCL(62)+DWCCL(73,5)*RK(73)
      DWCCL(73,5) = 0d0
      DW(72,62) = SAVE114
      YCCL(14) = YCCL(14)+DWCCL(72,62)*RK(72)
      DWCCL(72,62) = 0d0
      DW(72,14) = SAVE113
      YCCL(62) = YCCL(62)+DWCCL(72,14)*RK(72)
      DWCCL(72,14) = 0d0
      DW(71,62) = SAVE112
      YCCL(13) = YCCL(13)+DWCCL(71,62)*RK(71)
      DWCCL(71,62) = 0d0
      DW(71,13) = SAVE111
      YCCL(62) = YCCL(62)+DWCCL(71,13)*RK(71)
      DWCCL(71,13) = 0d0
      DW(70,62) = SAVE110
      YCCL(19) = YCCL(19)+DWCCL(70,62)*RK(70)
      DWCCL(70,62) = 0d0
      DW(70,19) = SAVE109
      YCCL(62) = YCCL(62)+DWCCL(70,19)*RK(70)
      DWCCL(70,19) = 0d0
      DW(69,62) = SAVE108
      YCCL(12) = YCCL(12)+DWCCL(69,62)*RK(69)
      DWCCL(69,62) = 0d0
      DW(69,12) = SAVE107
      YCCL(62) = YCCL(62)+DWCCL(69,12)*RK(69)
      DWCCL(69,12) = 0d0
      DW(68,62) = SAVE106
      YCCL(44) = YCCL(44)+DWCCL(68,62)*RK(68)
      DWCCL(68,62) = 0d0
      DW(68,44) = SAVE105
      YCCL(62) = YCCL(62)+DWCCL(68,44)*RK(68)
      DWCCL(68,44) = 0d0
      DW(67,62) = SAVE104
      YCCL(40) = YCCL(40)+DWCCL(67,62)*RK(67)
      DWCCL(67,62) = 0d0
      DW(67,40) = SAVE103
      YCCL(62) = YCCL(62)+DWCCL(67,40)*RK(67)
      DWCCL(67,40) = 0d0
      DW(66,62) = SAVE102
      YCCL(11) = YCCL(11)+DWCCL(66,62)*RK(66)
      DWCCL(66,62) = 0d0
      DW(66,11) = SAVE101
      YCCL(62) = YCCL(62)+DWCCL(66,11)*RK(66)
      DWCCL(66,11) = 0d0
      DW(65,62) = SAVE100
      YCCL(4) = YCCL(4)+DWCCL(65,62)*RK(65)
      DWCCL(65,62) = 0d0
      DW(65,4) = SAVE99
      YCCL(62) = YCCL(62)+DWCCL(65,4)*RK(65)
      DWCCL(65,4) = 0d0
      DW(64,62) = SAVE98
      YCCL(3) = YCCL(3)+DWCCL(64,62)*RK(64)
      DWCCL(64,62) = 0d0
      DW(64,3) = SAVE97
      YCCL(62) = YCCL(62)+DWCCL(64,3)*RK(64)
      DWCCL(64,3) = 0d0
      DW(63,62) = SAVE96
      YCCL(2) = YCCL(2)+DWCCL(63,62)*RK(63)
      DWCCL(63,62) = 0d0
      DW(63,2) = SAVE95
      YCCL(62) = YCCL(62)+DWCCL(63,2)*RK(63)
      DWCCL(63,2) = 0d0
      DW(62,62) = SAVE94
      YCCL(21) = YCCL(21)+DWCCL(62,62)*RK(62)
      DWCCL(62,62) = 0d0
      DW(62,21) = SAVE93
      YCCL(62) = YCCL(62)+DWCCL(62,21)*RK(62)
      DWCCL(62,21) = 0d0
      DW(61,62) = SAVE92
      YCCL(20) = YCCL(20)+DWCCL(61,62)*RK(61)
      DWCCL(61,62) = 0d0
      DW(61,20) = SAVE91
      YCCL(62) = YCCL(62)+DWCCL(61,20)*RK(61)
      DWCCL(61,20) = 0d0
      DW(60,35) = SAVE90
      YCCL(49) = YCCL(49)+DWCCL(60,35)*RK(60)
      DWCCL(60,35) = 0d0
      DW(60,49) = SAVE89
      YCCL(35) = YCCL(35)+DWCCL(60,49)*RK(60)
      DWCCL(60,49) = 0d0
      DW(59,35) = SAVE88
      YCCL(19) = YCCL(19)+DWCCL(59,35)*RK(59)
      DWCCL(59,35) = 0d0
      DW(59,19) = SAVE87
      YCCL(35) = YCCL(35)+DWCCL(59,19)*RK(59)
      DWCCL(59,19) = 0d0
      DW(58,62) = SAVE86
      YCCL(52) = YCCL(52)+DWCCL(58,62)*RK(58)
      DWCCL(58,62) = 0d0
      DW(58,52) = SAVE85
      YCCL(62) = YCCL(62)+DWCCL(58,52)*RK(58)
      DWCCL(58,52) = 0d0
      DW(57,1) = SAVE84
      YCCL(62) = YCCL(62)+DWCCL(57,1)*RK(57)
      DWCCL(57,1) = 0d0
      DW(57,62) = SAVE83
      YCCL(1) = YCCL(1)+DWCCL(57,62)*RK(57)
      DWCCL(57,62) = 0d0
      DW(56,62) = SAVE82
      DWCCL(56,62) = 0d0
      DW(55,68) = SAVE81
      YCCL(68) = YCCL(68)+DWCCL(55,68)*RK(55)
      DWCCL(55,68) = 0d0
      DW(55,68) = SAVE80
      YCCL(68) = YCCL(68)+DWCCL(55,68)*RK(55)
      DWCCL(55,68) = 0d0
      DW(54,9) = SAVE79
      DWCCL(54,9) = 0d0
      DW(53,72) = SAVE78
      YCCL(68) = YCCL(68)+DWCCL(53,72)*RK(53)
      DWCCL(53,72) = 0d0
      DW(53,68) = SAVE77
      YCCL(72) = YCCL(72)+DWCCL(53,68)*RK(53)
      DWCCL(53,68) = 0d0
      DW(52,72) = SAVE76
      YCCL(68) = YCCL(68)+DWCCL(52,72)*RK(52)
      DWCCL(52,72) = 0d0
      DW(52,68) = SAVE75
      YCCL(72) = YCCL(72)+DWCCL(52,68)*RK(52)
      DWCCL(52,68) = 0d0
      DW(51,67) = SAVE74
      YCCL(68) = YCCL(68)+DWCCL(51,67)*RK(51)
      DWCCL(51,67) = 0d0
      DW(51,68) = SAVE73
      YCCL(67) = YCCL(67)+DWCCL(51,68)*RK(51)
      DWCCL(51,68) = 0d0
      DW(50,67) = SAVE72
      YCCL(67) = YCCL(67)+DWCCL(50,67)*RK(50)
      DWCCL(50,67) = 0d0
      DW(50,67) = SAVE71
      YCCL(67) = YCCL(67)+DWCCL(50,67)*RK(50)
      DWCCL(50,67) = 0d0
      DW(49,72) = SAVE70
      YCCL(50) = YCCL(50)+DWCCL(49,72)*RK(49)
      DWCCL(49,72) = 0d0
      DW(49,50) = SAVE69
      YCCL(72) = YCCL(72)+DWCCL(49,50)*RK(49)
      DWCCL(49,50) = 0d0
      DW(48,67) = SAVE68
      YCCL(50) = YCCL(50)+DWCCL(48,67)*RK(48)
      DWCCL(48,67) = 0d0
      DW(48,50) = SAVE67
      YCCL(67) = YCCL(67)+DWCCL(48,50)*RK(48)
      DWCCL(48,50) = 0d0
      DW(47,15) = SAVE66
      YCCL(62) = YCCL(62)+DWCCL(47,15)*RK(47)
      DWCCL(47,15) = 0d0
      DW(47,62) = SAVE65
      YCCL(15) = YCCL(15)+DWCCL(47,62)*RK(47)
      DWCCL(47,62) = 0d0
      DW(46,55) = SAVE64
      YCCL(62) = YCCL(62)+DWCCL(46,55)*RK(46)
      DWCCL(46,55) = 0d0
      DW(46,62) = SAVE63
      YCCL(55) = YCCL(55)+DWCCL(46,62)*RK(46)
      DWCCL(46,62) = 0d0
      DW(45,23) = SAVE62
      YCCL(62) = YCCL(62)+DWCCL(45,23)*RK(45)
      DWCCL(45,23) = 0d0
      DW(45,62) = SAVE61
      YCCL(23) = YCCL(23)+DWCCL(45,62)*RK(45)
      DWCCL(45,62) = 0d0
      DW(44,68) = SAVE60
      YCCL(71) = YCCL(71)+DWCCL(44,68)*RK(44)
      DWCCL(44,68) = 0d0
      DW(44,71) = SAVE59
      YCCL(68) = YCCL(68)+DWCCL(44,71)*RK(44)
      DWCCL(44,71) = 0d0
      DW(43,15) = SAVE58
      DWCCL(43,15) = 0d0
      DW(42,72) = SAVE57
      YCCL(71) = YCCL(71)+DWCCL(42,72)*RK(42)
      DWCCL(42,72) = 0d0
      DW(42,71) = SAVE56
      YCCL(72) = YCCL(72)+DWCCL(42,71)*RK(42)
      DWCCL(42,71) = 0d0
      DW(41,67) = SAVE55
      YCCL(71) = YCCL(71)+DWCCL(41,67)*RK(41)
      DWCCL(41,67) = 0d0
      DW(41,71) = SAVE54
      YCCL(67) = YCCL(67)+DWCCL(41,71)*RK(41)
      DWCCL(41,71) = 0d0
      DW(40,68) = SAVE53
      YCCL(62) = YCCL(62)+DWCCL(40,68)*RK(40)
      DWCCL(40,68) = 0d0
      DW(40,62) = SAVE52
      YCCL(68) = YCCL(68)+DWCCL(40,62)*RK(40)
      DWCCL(40,62) = 0d0
      DW(39,72) = SAVE51
      YCCL(62) = YCCL(62)+DWCCL(39,72)*RK(39)
      DWCCL(39,72) = 0d0
      DW(39,62) = SAVE50
      YCCL(72) = YCCL(72)+DWCCL(39,62)*RK(39)
      DWCCL(39,62) = 0d0
      DW(38,67) = SAVE49
      YCCL(62) = YCCL(62)+DWCCL(38,67)*RK(38)
      DWCCL(38,67) = 0d0
      DW(38,62) = SAVE48
      YCCL(67) = YCCL(67)+DWCCL(38,62)*RK(38)
      DWCCL(38,62) = 0d0
      DW(37,72) = SAVE47
      YCCL(35) = YCCL(35)+DWCCL(37,72)*RK(37)
      DWCCL(37,72) = 0d0
      DW(37,35) = SAVE46
      YCCL(72) = YCCL(72)+DWCCL(37,35)*RK(37)
      DWCCL(37,35) = 0d0
      DW(36,72) = SAVE45
      YCCL(35) = YCCL(35)+DWCCL(36,72)*RK(36)
      DWCCL(36,72) = 0d0
      DW(36,35) = SAVE44
      YCCL(72) = YCCL(72)+DWCCL(36,35)*RK(36)
      DWCCL(36,35) = 0d0
      DW(35,67) = SAVE43
      YCCL(35) = YCCL(35)+DWCCL(35,67)*RK(35)
      DWCCL(35,67) = 0d0
      DW(35,35) = SAVE42
      YCCL(67) = YCCL(67)+DWCCL(35,35)*RK(35)
      DWCCL(35,35) = 0d0
      DW(34,71) = SAVE41
      YCCL(71) = YCCL(71)+DWCCL(34,71)*RK(34)
      DWCCL(34,71) = 0d0
      DW(34,71) = SAVE40
      YCCL(71) = YCCL(71)+DWCCL(34,71)*RK(34)
      DWCCL(34,71) = 0d0
      DW(33,71) = SAVE39
      YCCL(71) = YCCL(71)+DWCCL(33,71)*RK(33)
      DWCCL(33,71) = 0d0
      DW(33,71) = SAVE38
      YCCL(71) = YCCL(71)+DWCCL(33,71)*RK(33)
      DWCCL(33,71) = 0d0
      DW(32,62) = SAVE37
      YCCL(27) = YCCL(27)+DWCCL(32,62)*RK(32)
      DWCCL(32,62) = 0d0
      DW(32,27) = SAVE36
      YCCL(62) = YCCL(62)+DWCCL(32,27)*RK(32)
      DWCCL(32,27) = 0d0
      DW(31,71) = SAVE35
      YCCL(62) = YCCL(62)+DWCCL(31,71)*RK(31)
      DWCCL(31,71) = 0d0
      DW(31,62) = SAVE34
      YCCL(71) = YCCL(71)+DWCCL(31,62)*RK(31)
      DWCCL(31,62) = 0d0
      DW(30,71) = SAVE33
      YCCL(50) = YCCL(50)+DWCCL(30,71)*RK(30)
      DWCCL(30,71) = 0d0
      DW(30,50) = SAVE32
      YCCL(71) = YCCL(71)+DWCCL(30,50)*RK(30)
      DWCCL(30,50) = 0d0
      DW(29,62) = SAVE31
      YCCL(50) = YCCL(50)+DWCCL(29,62)*RK(29)
      DWCCL(29,62) = 0d0
      DW(29,50) = SAVE30
      YCCL(62) = YCCL(62)+DWCCL(29,50)*RK(29)
      DWCCL(29,50) = 0d0
      DW(28,7) = SAVE29
      DWCCL(28,7) = 0d0
      DW(27,7) = SAVE28
      DWCCL(27,7) = 0d0
      DW(26,7) = SAVE27
      DWCCL(26,7) = 0d0
      DW(25,50) = SAVE26
      YCCL(35) = YCCL(35)+DWCCL(25,50)*RK(25)
      DWCCL(25,50) = 0d0
      DW(25,35) = SAVE25
      YCCL(50) = YCCL(50)+DWCCL(25,35)*RK(25)
      DWCCL(25,35) = 0d0
      DW(24,35) = SAVE24
      DWCCL(24,35) = 0d0
      DW(23,24) = SAVE23
      DWCCL(23,24) = 0d0
      DW(22,49) = SAVE22
      DWCCL(22,49) = 0d0
      DW(21,70) = SAVE21
      DWCCL(21,70) = 0d0
      DW(20,48) = SAVE20
      DWCCL(20,48) = 0d0
      DW(19,54) = SAVE19
      DWCCL(19,54) = 0d0
      DW(18,51) = SAVE18
      DWCCL(18,51) = 0d0
      DW(17,51) = SAVE17
      DWCCL(17,51) = 0d0
      DW(16,59) = SAVE16
      DWCCL(16,59) = 0d0
      DW(15,28) = SAVE15
      DWCCL(15,28) = 0d0
      DW(14,53) = SAVE14
      DWCCL(14,53) = 0d0
      DW(13,16) = SAVE13
      DWCCL(13,16) = 0d0
      DW(12,61) = SAVE12
      DWCCL(12,61) = 0d0
      DW(11,66) = SAVE11
      DWCCL(11,66) = 0d0
      DW(10,66) = SAVE10
      DWCCL(10,66) = 0d0
      DW(9,27) = SAVE9
      DWCCL(9,27) = 0d0
      DW(8,68) = SAVE8
      DWCCL(8,68) = 0d0
      DW(7,68) = SAVE7
      DWCCL(7,68) = 0d0
      DW(6,15) = SAVE6
      DWCCL(6,15) = 0d0
      DW(5,55) = SAVE5
      DWCCL(5,55) = 0d0
      DW(4,23) = SAVE4
      DWCCL(4,23) = 0d0
      DW(3,50) = SAVE3
      DWCCL(3,50) = 0d0
      DW(2,50) = SAVE2
      DWCCL(2,50) = 0d0
      DW(1,72) = SAVE1
      DWCCL(1,72) = 0d0
      END




COD Unit from the initial code : jacdchemdc



COD Compilation unit : fexchemcl
COD Derivative of unit :  fexchem
COD Dummys:  ns nr y rk zcsourc convers_factor chem
COD Active IN   dummys:  y zcsourc
COD Active OUT  dummys:  chem
COD Dependencies between IN and OUT:
COD chem <--   y zcsourc


      SUBROUTINE FEXCHEMCL (NS, NR, Y, RK, ZCSOURC, CONVERS_FACTOR,
     : CHEM, YCCL, ZCSOURCCCL, CHEMCCL)

      IMPLICIT NONE
      INTEGER NS
      INTEGER I
      INTEGER NR
      INTEGER NNN1
      DOUBLE PRECISION CONCCCL(NS)
      DOUBLE PRECISION W(NR)
      DOUBLE PRECISION Y(NS)
      DOUBLE PRECISION ZCSOURC(NS)
      DOUBLE PRECISION WCCL(NR)
      DOUBLE PRECISION YCCL(NS)
      DOUBLE PRECISION ZCSOURCCCL(NS)
      DOUBLE PRECISION CONC(NS)
      DOUBLE PRECISION RK(NR)
      DOUBLE PRECISION CHEMCCL(NS)
      DOUBLE PRECISION CHEM(NS)
      DOUBLE PRECISION CONVERS_FACTOR(NS)
      DOUBLE PRECISION SAVE1(NS)
      DOUBLE PRECISION SAVE10
      DOUBLE PRECISION SAVE100
      DOUBLE PRECISION SAVE1000
      DOUBLE PRECISION SAVE1001
      DOUBLE PRECISION SAVE1002
      DOUBLE PRECISION SAVE1003
      DOUBLE PRECISION SAVE1004
      DOUBLE PRECISION SAVE1005
      DOUBLE PRECISION SAVE1006
      DOUBLE PRECISION SAVE1007
      DOUBLE PRECISION SAVE1008
      DOUBLE PRECISION SAVE1009
      DOUBLE PRECISION SAVE101
      DOUBLE PRECISION SAVE1010
      DOUBLE PRECISION SAVE1011
      DOUBLE PRECISION SAVE1012
      DOUBLE PRECISION SAVE1013
      DOUBLE PRECISION SAVE1014
      DOUBLE PRECISION SAVE1015
      DOUBLE PRECISION SAVE1016
      DOUBLE PRECISION SAVE1017
      DOUBLE PRECISION SAVE1018
      DOUBLE PRECISION SAVE1019
      DOUBLE PRECISION SAVE102
      DOUBLE PRECISION SAVE1020
      DOUBLE PRECISION SAVE1021
      DOUBLE PRECISION SAVE1022
      DOUBLE PRECISION SAVE1023
      DOUBLE PRECISION SAVE1024
      DOUBLE PRECISION SAVE1025
      DOUBLE PRECISION SAVE1026
      DOUBLE PRECISION SAVE1027
      DOUBLE PRECISION SAVE1028
      DOUBLE PRECISION SAVE1029
      DOUBLE PRECISION SAVE103
      DOUBLE PRECISION SAVE1030
      DOUBLE PRECISION SAVE1031
      DOUBLE PRECISION SAVE1032
      DOUBLE PRECISION SAVE1033
      DOUBLE PRECISION SAVE1034
      DOUBLE PRECISION SAVE1035
      DOUBLE PRECISION SAVE1036
      DOUBLE PRECISION SAVE1037
      DOUBLE PRECISION SAVE1038
      DOUBLE PRECISION SAVE1039
      DOUBLE PRECISION SAVE104
      DOUBLE PRECISION SAVE1040
      DOUBLE PRECISION SAVE1041
      DOUBLE PRECISION SAVE1042
      DOUBLE PRECISION SAVE1043
      DOUBLE PRECISION SAVE1044
      DOUBLE PRECISION SAVE1045
      DOUBLE PRECISION SAVE1046
      DOUBLE PRECISION SAVE1047
      DOUBLE PRECISION SAVE1048
      DOUBLE PRECISION SAVE1049
      DOUBLE PRECISION SAVE105
      DOUBLE PRECISION SAVE1050
      DOUBLE PRECISION SAVE1051
      DOUBLE PRECISION SAVE1052
      DOUBLE PRECISION SAVE1053
      DOUBLE PRECISION SAVE1054
      DOUBLE PRECISION SAVE1055
      DOUBLE PRECISION SAVE1056
      DOUBLE PRECISION SAVE1057
      DOUBLE PRECISION SAVE1058
      DOUBLE PRECISION SAVE1059
      DOUBLE PRECISION SAVE106
      DOUBLE PRECISION SAVE1060
      DOUBLE PRECISION SAVE1061
      DOUBLE PRECISION SAVE1062
      DOUBLE PRECISION SAVE1063
      DOUBLE PRECISION SAVE1064
      DOUBLE PRECISION SAVE1065
      DOUBLE PRECISION SAVE1066
      DOUBLE PRECISION SAVE1067
      DOUBLE PRECISION SAVE1068
      DOUBLE PRECISION SAVE1069
      DOUBLE PRECISION SAVE107
      DOUBLE PRECISION SAVE1070
      DOUBLE PRECISION SAVE1071
      DOUBLE PRECISION SAVE1072
      DOUBLE PRECISION SAVE1073
      DOUBLE PRECISION SAVE1074
      DOUBLE PRECISION SAVE1075
      DOUBLE PRECISION SAVE1076
      DOUBLE PRECISION SAVE1077
      DOUBLE PRECISION SAVE1078
      DOUBLE PRECISION SAVE1079
      DOUBLE PRECISION SAVE108
      DOUBLE PRECISION SAVE1080
      DOUBLE PRECISION SAVE1081
      DOUBLE PRECISION SAVE1082
      DOUBLE PRECISION SAVE1083
      DOUBLE PRECISION SAVE1084
      DOUBLE PRECISION SAVE1085
      DOUBLE PRECISION SAVE1086
      DOUBLE PRECISION SAVE1087
      DOUBLE PRECISION SAVE1088
      DOUBLE PRECISION SAVE1089
      DOUBLE PRECISION SAVE109
      DOUBLE PRECISION SAVE1090
      DOUBLE PRECISION SAVE1091
      DOUBLE PRECISION SAVE1092
      DOUBLE PRECISION SAVE1093
      DOUBLE PRECISION SAVE1094
      DOUBLE PRECISION SAVE1095
      DOUBLE PRECISION SAVE1096
      DOUBLE PRECISION SAVE1097
      DOUBLE PRECISION SAVE1098
      DOUBLE PRECISION SAVE1099
      DOUBLE PRECISION SAVE11
      DOUBLE PRECISION SAVE110
      DOUBLE PRECISION SAVE1100
      DOUBLE PRECISION SAVE1101
      DOUBLE PRECISION SAVE1102
      DOUBLE PRECISION SAVE1103
      DOUBLE PRECISION SAVE1104
      DOUBLE PRECISION SAVE1105
      DOUBLE PRECISION SAVE1106
      DOUBLE PRECISION SAVE1107
      DOUBLE PRECISION SAVE1108
      DOUBLE PRECISION SAVE1109
      DOUBLE PRECISION SAVE111
      DOUBLE PRECISION SAVE1110
      DOUBLE PRECISION SAVE1111
      DOUBLE PRECISION SAVE1112
      DOUBLE PRECISION SAVE1113
      DOUBLE PRECISION SAVE1114
      DOUBLE PRECISION SAVE1115
      DOUBLE PRECISION SAVE1116
      DOUBLE PRECISION SAVE1117
      DOUBLE PRECISION SAVE1118
      DOUBLE PRECISION SAVE1119
      DOUBLE PRECISION SAVE112
      DOUBLE PRECISION SAVE1120
      DOUBLE PRECISION SAVE1121
      DOUBLE PRECISION SAVE1122
      DOUBLE PRECISION SAVE1123
      DOUBLE PRECISION SAVE1124
      DOUBLE PRECISION SAVE1125
      DOUBLE PRECISION SAVE1126
      DOUBLE PRECISION SAVE1127
      DOUBLE PRECISION SAVE1128
      DOUBLE PRECISION SAVE1129
      DOUBLE PRECISION SAVE113
      DOUBLE PRECISION SAVE1130
      DOUBLE PRECISION SAVE1131
      DOUBLE PRECISION SAVE1132
      DOUBLE PRECISION SAVE1133
      DOUBLE PRECISION SAVE1134
      DOUBLE PRECISION SAVE1135
      DOUBLE PRECISION SAVE1136
      DOUBLE PRECISION SAVE1137
      DOUBLE PRECISION SAVE1138
      DOUBLE PRECISION SAVE1139
      DOUBLE PRECISION SAVE114
      DOUBLE PRECISION SAVE1140
      DOUBLE PRECISION SAVE1141
      DOUBLE PRECISION SAVE1142
      DOUBLE PRECISION SAVE1143
      DOUBLE PRECISION SAVE1144
      DOUBLE PRECISION SAVE1145
      DOUBLE PRECISION SAVE1146
      DOUBLE PRECISION SAVE1147
      DOUBLE PRECISION SAVE1148
      DOUBLE PRECISION SAVE1149
      DOUBLE PRECISION SAVE115
      DOUBLE PRECISION SAVE1150
      DOUBLE PRECISION SAVE1151
      DOUBLE PRECISION SAVE1152
      DOUBLE PRECISION SAVE1153
      DOUBLE PRECISION SAVE1154
      DOUBLE PRECISION SAVE1155
      DOUBLE PRECISION SAVE1156
      DOUBLE PRECISION SAVE1157
      DOUBLE PRECISION SAVE1158
      DOUBLE PRECISION SAVE1159
      DOUBLE PRECISION SAVE116
      DOUBLE PRECISION SAVE1160
      DOUBLE PRECISION SAVE1161
      DOUBLE PRECISION SAVE1162
      DOUBLE PRECISION SAVE1163
      DOUBLE PRECISION SAVE1164
      DOUBLE PRECISION SAVE1165
      DOUBLE PRECISION SAVE1166
      DOUBLE PRECISION SAVE1167
      DOUBLE PRECISION SAVE1168
      DOUBLE PRECISION SAVE1169
      DOUBLE PRECISION SAVE117
      DOUBLE PRECISION SAVE1170
      DOUBLE PRECISION SAVE1171
      DOUBLE PRECISION SAVE1172
      DOUBLE PRECISION SAVE1173
      DOUBLE PRECISION SAVE1174
      DOUBLE PRECISION SAVE1175
      DOUBLE PRECISION SAVE1176
      DOUBLE PRECISION SAVE1177
      DOUBLE PRECISION SAVE1178
      DOUBLE PRECISION SAVE1179
      DOUBLE PRECISION SAVE118
      DOUBLE PRECISION SAVE1180
      DOUBLE PRECISION SAVE1181
      DOUBLE PRECISION SAVE1182
      DOUBLE PRECISION SAVE1183
      DOUBLE PRECISION SAVE1184
      DOUBLE PRECISION SAVE1185
      DOUBLE PRECISION SAVE1186
      DOUBLE PRECISION SAVE1187
      DOUBLE PRECISION SAVE1188
      DOUBLE PRECISION SAVE1189
      DOUBLE PRECISION SAVE119
      DOUBLE PRECISION SAVE1190
      DOUBLE PRECISION SAVE1191
      DOUBLE PRECISION SAVE1192
      DOUBLE PRECISION SAVE1193
      DOUBLE PRECISION SAVE1194
      DOUBLE PRECISION SAVE1195
      DOUBLE PRECISION SAVE1196
      DOUBLE PRECISION SAVE1197
      DOUBLE PRECISION SAVE1198
      DOUBLE PRECISION SAVE1199
      DOUBLE PRECISION SAVE12
      DOUBLE PRECISION SAVE120
      DOUBLE PRECISION SAVE1200
      DOUBLE PRECISION SAVE1201(NS)
      DOUBLE PRECISION SAVE1202(NS)
      INTEGER SAVE1203
      INTEGER SAVE1204
      INTEGER SAVE1205
      DOUBLE PRECISION SAVE121
      DOUBLE PRECISION SAVE122
      DOUBLE PRECISION SAVE123
      DOUBLE PRECISION SAVE124
      DOUBLE PRECISION SAVE125
      DOUBLE PRECISION SAVE126
      DOUBLE PRECISION SAVE127
      DOUBLE PRECISION SAVE128
      DOUBLE PRECISION SAVE129
      DOUBLE PRECISION SAVE13
      DOUBLE PRECISION SAVE130
      DOUBLE PRECISION SAVE131
      DOUBLE PRECISION SAVE132
      DOUBLE PRECISION SAVE133
      DOUBLE PRECISION SAVE134
      DOUBLE PRECISION SAVE135
      DOUBLE PRECISION SAVE136
      DOUBLE PRECISION SAVE137
      DOUBLE PRECISION SAVE138
      DOUBLE PRECISION SAVE139
      DOUBLE PRECISION SAVE14
      DOUBLE PRECISION SAVE140
      DOUBLE PRECISION SAVE141
      DOUBLE PRECISION SAVE142
      DOUBLE PRECISION SAVE143
      DOUBLE PRECISION SAVE144
      DOUBLE PRECISION SAVE145
      DOUBLE PRECISION SAVE146
      DOUBLE PRECISION SAVE147
      DOUBLE PRECISION SAVE148
      DOUBLE PRECISION SAVE149
      DOUBLE PRECISION SAVE15
      DOUBLE PRECISION SAVE150
      DOUBLE PRECISION SAVE151
      DOUBLE PRECISION SAVE152
      DOUBLE PRECISION SAVE153
      DOUBLE PRECISION SAVE154
      DOUBLE PRECISION SAVE155
      DOUBLE PRECISION SAVE156
      DOUBLE PRECISION SAVE157
      DOUBLE PRECISION SAVE158
      DOUBLE PRECISION SAVE159
      DOUBLE PRECISION SAVE16
      DOUBLE PRECISION SAVE160
      DOUBLE PRECISION SAVE161
      DOUBLE PRECISION SAVE162
      DOUBLE PRECISION SAVE163
      DOUBLE PRECISION SAVE164
      DOUBLE PRECISION SAVE165
      DOUBLE PRECISION SAVE166
      DOUBLE PRECISION SAVE167
      DOUBLE PRECISION SAVE168
      DOUBLE PRECISION SAVE169
      DOUBLE PRECISION SAVE17
      DOUBLE PRECISION SAVE170
      DOUBLE PRECISION SAVE171
      DOUBLE PRECISION SAVE172
      DOUBLE PRECISION SAVE173
      DOUBLE PRECISION SAVE174
      DOUBLE PRECISION SAVE175
      DOUBLE PRECISION SAVE176
      DOUBLE PRECISION SAVE177
      DOUBLE PRECISION SAVE178
      DOUBLE PRECISION SAVE179
      DOUBLE PRECISION SAVE18
      DOUBLE PRECISION SAVE180
      DOUBLE PRECISION SAVE181
      DOUBLE PRECISION SAVE182
      DOUBLE PRECISION SAVE183
      DOUBLE PRECISION SAVE184
      DOUBLE PRECISION SAVE185
      DOUBLE PRECISION SAVE186
      DOUBLE PRECISION SAVE187
      DOUBLE PRECISION SAVE188
      DOUBLE PRECISION SAVE189
      DOUBLE PRECISION SAVE19
      DOUBLE PRECISION SAVE190
      DOUBLE PRECISION SAVE191
      DOUBLE PRECISION SAVE192
      DOUBLE PRECISION SAVE193
      DOUBLE PRECISION SAVE194
      DOUBLE PRECISION SAVE195
      DOUBLE PRECISION SAVE196
      DOUBLE PRECISION SAVE197
      DOUBLE PRECISION SAVE198
      DOUBLE PRECISION SAVE199
      DOUBLE PRECISION SAVE20
      DOUBLE PRECISION SAVE200
      DOUBLE PRECISION SAVE201
      DOUBLE PRECISION SAVE202
      DOUBLE PRECISION SAVE203
      DOUBLE PRECISION SAVE204
      DOUBLE PRECISION SAVE205
      DOUBLE PRECISION SAVE206
      DOUBLE PRECISION SAVE207
      DOUBLE PRECISION SAVE208
      DOUBLE PRECISION SAVE209
      DOUBLE PRECISION SAVE21
      DOUBLE PRECISION SAVE210
      DOUBLE PRECISION SAVE211
      DOUBLE PRECISION SAVE212
      DOUBLE PRECISION SAVE213
      DOUBLE PRECISION SAVE214
      DOUBLE PRECISION SAVE215
      DOUBLE PRECISION SAVE216
      DOUBLE PRECISION SAVE217
      DOUBLE PRECISION SAVE218
      DOUBLE PRECISION SAVE219
      DOUBLE PRECISION SAVE22
      DOUBLE PRECISION SAVE220
      DOUBLE PRECISION SAVE221
      DOUBLE PRECISION SAVE222
      DOUBLE PRECISION SAVE223
      DOUBLE PRECISION SAVE224
      DOUBLE PRECISION SAVE225
      DOUBLE PRECISION SAVE226
      DOUBLE PRECISION SAVE227
      DOUBLE PRECISION SAVE228
      DOUBLE PRECISION SAVE229
      DOUBLE PRECISION SAVE23
      DOUBLE PRECISION SAVE230
      DOUBLE PRECISION SAVE231
      DOUBLE PRECISION SAVE232
      DOUBLE PRECISION SAVE233
      DOUBLE PRECISION SAVE234
      DOUBLE PRECISION SAVE235
      DOUBLE PRECISION SAVE236
      DOUBLE PRECISION SAVE237
      DOUBLE PRECISION SAVE238
      DOUBLE PRECISION SAVE239
      DOUBLE PRECISION SAVE24
      DOUBLE PRECISION SAVE240
      DOUBLE PRECISION SAVE241
      DOUBLE PRECISION SAVE242
      DOUBLE PRECISION SAVE243
      DOUBLE PRECISION SAVE244
      DOUBLE PRECISION SAVE245
      DOUBLE PRECISION SAVE246
      DOUBLE PRECISION SAVE247
      DOUBLE PRECISION SAVE248
      DOUBLE PRECISION SAVE249
      DOUBLE PRECISION SAVE25
      DOUBLE PRECISION SAVE250
      DOUBLE PRECISION SAVE251
      DOUBLE PRECISION SAVE252
      DOUBLE PRECISION SAVE253
      DOUBLE PRECISION SAVE254
      DOUBLE PRECISION SAVE255
      DOUBLE PRECISION SAVE256
      DOUBLE PRECISION SAVE257
      DOUBLE PRECISION SAVE258
      DOUBLE PRECISION SAVE259
      DOUBLE PRECISION SAVE26
      DOUBLE PRECISION SAVE260
      DOUBLE PRECISION SAVE261
      DOUBLE PRECISION SAVE262
      DOUBLE PRECISION SAVE263
      DOUBLE PRECISION SAVE264
      DOUBLE PRECISION SAVE265
      DOUBLE PRECISION SAVE266
      DOUBLE PRECISION SAVE267
      DOUBLE PRECISION SAVE268
      DOUBLE PRECISION SAVE269
      DOUBLE PRECISION SAVE27
      DOUBLE PRECISION SAVE270
      DOUBLE PRECISION SAVE271
      DOUBLE PRECISION SAVE272
      DOUBLE PRECISION SAVE273
      DOUBLE PRECISION SAVE274
      DOUBLE PRECISION SAVE275
      DOUBLE PRECISION SAVE276
      DOUBLE PRECISION SAVE277
      DOUBLE PRECISION SAVE278
      DOUBLE PRECISION SAVE279
      DOUBLE PRECISION SAVE28
      DOUBLE PRECISION SAVE280
      DOUBLE PRECISION SAVE281
      DOUBLE PRECISION SAVE282
      DOUBLE PRECISION SAVE283
      DOUBLE PRECISION SAVE284
      DOUBLE PRECISION SAVE285
      DOUBLE PRECISION SAVE286
      DOUBLE PRECISION SAVE287
      DOUBLE PRECISION SAVE288
      DOUBLE PRECISION SAVE289
      DOUBLE PRECISION SAVE29
      DOUBLE PRECISION SAVE290
      DOUBLE PRECISION SAVE291
      DOUBLE PRECISION SAVE292
      DOUBLE PRECISION SAVE293
      DOUBLE PRECISION SAVE294
      DOUBLE PRECISION SAVE295
      DOUBLE PRECISION SAVE296
      DOUBLE PRECISION SAVE297
      DOUBLE PRECISION SAVE298
      DOUBLE PRECISION SAVE299
      DOUBLE PRECISION SAVE30
      DOUBLE PRECISION SAVE300
      DOUBLE PRECISION SAVE301
      DOUBLE PRECISION SAVE302
      DOUBLE PRECISION SAVE303
      DOUBLE PRECISION SAVE304
      DOUBLE PRECISION SAVE305
      DOUBLE PRECISION SAVE306
      DOUBLE PRECISION SAVE307
      DOUBLE PRECISION SAVE308
      DOUBLE PRECISION SAVE309
      DOUBLE PRECISION SAVE31
      DOUBLE PRECISION SAVE310
      DOUBLE PRECISION SAVE311
      DOUBLE PRECISION SAVE312
      DOUBLE PRECISION SAVE313
      DOUBLE PRECISION SAVE314
      DOUBLE PRECISION SAVE315
      DOUBLE PRECISION SAVE316
      DOUBLE PRECISION SAVE317
      DOUBLE PRECISION SAVE318
      DOUBLE PRECISION SAVE319
      DOUBLE PRECISION SAVE32
      DOUBLE PRECISION SAVE320
      DOUBLE PRECISION SAVE321
      DOUBLE PRECISION SAVE322
      DOUBLE PRECISION SAVE323
      DOUBLE PRECISION SAVE324
      DOUBLE PRECISION SAVE325
      DOUBLE PRECISION SAVE326
      DOUBLE PRECISION SAVE327
      DOUBLE PRECISION SAVE328
      DOUBLE PRECISION SAVE329
      DOUBLE PRECISION SAVE33
      DOUBLE PRECISION SAVE330
      DOUBLE PRECISION SAVE331
      DOUBLE PRECISION SAVE332
      DOUBLE PRECISION SAVE333
      DOUBLE PRECISION SAVE334
      DOUBLE PRECISION SAVE335
      DOUBLE PRECISION SAVE336
      DOUBLE PRECISION SAVE337
      DOUBLE PRECISION SAVE338
      DOUBLE PRECISION SAVE339
      DOUBLE PRECISION SAVE34
      DOUBLE PRECISION SAVE340
      DOUBLE PRECISION SAVE341
      DOUBLE PRECISION SAVE342
      DOUBLE PRECISION SAVE343
      DOUBLE PRECISION SAVE344
      DOUBLE PRECISION SAVE345
      DOUBLE PRECISION SAVE346
      DOUBLE PRECISION SAVE347
      DOUBLE PRECISION SAVE348
      DOUBLE PRECISION SAVE349
      DOUBLE PRECISION SAVE35
      DOUBLE PRECISION SAVE350
      DOUBLE PRECISION SAVE351
      DOUBLE PRECISION SAVE352
      DOUBLE PRECISION SAVE353
      DOUBLE PRECISION SAVE354
      DOUBLE PRECISION SAVE355
      DOUBLE PRECISION SAVE356
      DOUBLE PRECISION SAVE357
      DOUBLE PRECISION SAVE358
      DOUBLE PRECISION SAVE359
      DOUBLE PRECISION SAVE36
      DOUBLE PRECISION SAVE360
      DOUBLE PRECISION SAVE361
      DOUBLE PRECISION SAVE362
      DOUBLE PRECISION SAVE363
      DOUBLE PRECISION SAVE364
      DOUBLE PRECISION SAVE365
      DOUBLE PRECISION SAVE366
      DOUBLE PRECISION SAVE367
      DOUBLE PRECISION SAVE368
      DOUBLE PRECISION SAVE369
      DOUBLE PRECISION SAVE37
      DOUBLE PRECISION SAVE370
      DOUBLE PRECISION SAVE371
      DOUBLE PRECISION SAVE372
      DOUBLE PRECISION SAVE373
      DOUBLE PRECISION SAVE374
      DOUBLE PRECISION SAVE375
      DOUBLE PRECISION SAVE376
      DOUBLE PRECISION SAVE377
      DOUBLE PRECISION SAVE378
      DOUBLE PRECISION SAVE379
      DOUBLE PRECISION SAVE38
      DOUBLE PRECISION SAVE380
      DOUBLE PRECISION SAVE381
      DOUBLE PRECISION SAVE382
      DOUBLE PRECISION SAVE383
      DOUBLE PRECISION SAVE384
      DOUBLE PRECISION SAVE385
      DOUBLE PRECISION SAVE386
      DOUBLE PRECISION SAVE387
      DOUBLE PRECISION SAVE388
      DOUBLE PRECISION SAVE389
      DOUBLE PRECISION SAVE39
      DOUBLE PRECISION SAVE390
      DOUBLE PRECISION SAVE391
      DOUBLE PRECISION SAVE392
      DOUBLE PRECISION SAVE393
      DOUBLE PRECISION SAVE394
      DOUBLE PRECISION SAVE395
      DOUBLE PRECISION SAVE396
      DOUBLE PRECISION SAVE397
      DOUBLE PRECISION SAVE398
      DOUBLE PRECISION SAVE399
      DOUBLE PRECISION SAVE4
      DOUBLE PRECISION SAVE40
      DOUBLE PRECISION SAVE400
      DOUBLE PRECISION SAVE401
      DOUBLE PRECISION SAVE402
      DOUBLE PRECISION SAVE403
      DOUBLE PRECISION SAVE404
      DOUBLE PRECISION SAVE405
      DOUBLE PRECISION SAVE406
      DOUBLE PRECISION SAVE407
      DOUBLE PRECISION SAVE408
      DOUBLE PRECISION SAVE409
      DOUBLE PRECISION SAVE41
      DOUBLE PRECISION SAVE410
      DOUBLE PRECISION SAVE411
      DOUBLE PRECISION SAVE412
      DOUBLE PRECISION SAVE413
      DOUBLE PRECISION SAVE414
      DOUBLE PRECISION SAVE415
      DOUBLE PRECISION SAVE416
      DOUBLE PRECISION SAVE417
      DOUBLE PRECISION SAVE418
      DOUBLE PRECISION SAVE419
      DOUBLE PRECISION SAVE42
      DOUBLE PRECISION SAVE420
      DOUBLE PRECISION SAVE421
      DOUBLE PRECISION SAVE422
      DOUBLE PRECISION SAVE423
      DOUBLE PRECISION SAVE424
      DOUBLE PRECISION SAVE425
      DOUBLE PRECISION SAVE426
      DOUBLE PRECISION SAVE427
      DOUBLE PRECISION SAVE428
      DOUBLE PRECISION SAVE429
      DOUBLE PRECISION SAVE43
      DOUBLE PRECISION SAVE430
      DOUBLE PRECISION SAVE431
      DOUBLE PRECISION SAVE432
      DOUBLE PRECISION SAVE433
      DOUBLE PRECISION SAVE434
      DOUBLE PRECISION SAVE435
      DOUBLE PRECISION SAVE436
      DOUBLE PRECISION SAVE437
      DOUBLE PRECISION SAVE438
      DOUBLE PRECISION SAVE439
      DOUBLE PRECISION SAVE44
      DOUBLE PRECISION SAVE440
      DOUBLE PRECISION SAVE441
      DOUBLE PRECISION SAVE442
      DOUBLE PRECISION SAVE443
      DOUBLE PRECISION SAVE444
      DOUBLE PRECISION SAVE445
      DOUBLE PRECISION SAVE446
      DOUBLE PRECISION SAVE447
      DOUBLE PRECISION SAVE448
      DOUBLE PRECISION SAVE449
      DOUBLE PRECISION SAVE45
      DOUBLE PRECISION SAVE450
      DOUBLE PRECISION SAVE451
      DOUBLE PRECISION SAVE452
      DOUBLE PRECISION SAVE453
      DOUBLE PRECISION SAVE454
      DOUBLE PRECISION SAVE455
      DOUBLE PRECISION SAVE456
      DOUBLE PRECISION SAVE457
      DOUBLE PRECISION SAVE458
      DOUBLE PRECISION SAVE459
      DOUBLE PRECISION SAVE46
      DOUBLE PRECISION SAVE460
      DOUBLE PRECISION SAVE461
      DOUBLE PRECISION SAVE462
      DOUBLE PRECISION SAVE463
      DOUBLE PRECISION SAVE464
      DOUBLE PRECISION SAVE465
      DOUBLE PRECISION SAVE466
      DOUBLE PRECISION SAVE467
      DOUBLE PRECISION SAVE468
      DOUBLE PRECISION SAVE469
      DOUBLE PRECISION SAVE47
      DOUBLE PRECISION SAVE470
      DOUBLE PRECISION SAVE471
      DOUBLE PRECISION SAVE472
      DOUBLE PRECISION SAVE473
      DOUBLE PRECISION SAVE474
      DOUBLE PRECISION SAVE475
      DOUBLE PRECISION SAVE476
      DOUBLE PRECISION SAVE477
      DOUBLE PRECISION SAVE478
      DOUBLE PRECISION SAVE479
      DOUBLE PRECISION SAVE48
      DOUBLE PRECISION SAVE480
      DOUBLE PRECISION SAVE481
      DOUBLE PRECISION SAVE482
      DOUBLE PRECISION SAVE483
      DOUBLE PRECISION SAVE484
      DOUBLE PRECISION SAVE485
      DOUBLE PRECISION SAVE486
      DOUBLE PRECISION SAVE487
      DOUBLE PRECISION SAVE488
      DOUBLE PRECISION SAVE489
      DOUBLE PRECISION SAVE49
      DOUBLE PRECISION SAVE490
      DOUBLE PRECISION SAVE491
      DOUBLE PRECISION SAVE492
      DOUBLE PRECISION SAVE493
      DOUBLE PRECISION SAVE494
      DOUBLE PRECISION SAVE495
      DOUBLE PRECISION SAVE496
      DOUBLE PRECISION SAVE497
      DOUBLE PRECISION SAVE498
      DOUBLE PRECISION SAVE499
      DOUBLE PRECISION SAVE5
      DOUBLE PRECISION SAVE50
      DOUBLE PRECISION SAVE500
      DOUBLE PRECISION SAVE501
      DOUBLE PRECISION SAVE502
      DOUBLE PRECISION SAVE503
      DOUBLE PRECISION SAVE504
      DOUBLE PRECISION SAVE505
      DOUBLE PRECISION SAVE506
      DOUBLE PRECISION SAVE507
      DOUBLE PRECISION SAVE508
      DOUBLE PRECISION SAVE509
      DOUBLE PRECISION SAVE51
      DOUBLE PRECISION SAVE510
      DOUBLE PRECISION SAVE511
      DOUBLE PRECISION SAVE512
      DOUBLE PRECISION SAVE513
      DOUBLE PRECISION SAVE514
      DOUBLE PRECISION SAVE515
      DOUBLE PRECISION SAVE516
      DOUBLE PRECISION SAVE517
      DOUBLE PRECISION SAVE518
      DOUBLE PRECISION SAVE519
      DOUBLE PRECISION SAVE52
      DOUBLE PRECISION SAVE520
      DOUBLE PRECISION SAVE521
      DOUBLE PRECISION SAVE522
      DOUBLE PRECISION SAVE523
      DOUBLE PRECISION SAVE524
      DOUBLE PRECISION SAVE525
      DOUBLE PRECISION SAVE526
      DOUBLE PRECISION SAVE527
      DOUBLE PRECISION SAVE528
      DOUBLE PRECISION SAVE529
      DOUBLE PRECISION SAVE53
      DOUBLE PRECISION SAVE530
      DOUBLE PRECISION SAVE531
      DOUBLE PRECISION SAVE532
      DOUBLE PRECISION SAVE533
      DOUBLE PRECISION SAVE534
      DOUBLE PRECISION SAVE535
      DOUBLE PRECISION SAVE536
      DOUBLE PRECISION SAVE537
      DOUBLE PRECISION SAVE538
      DOUBLE PRECISION SAVE539
      DOUBLE PRECISION SAVE54
      DOUBLE PRECISION SAVE540
      DOUBLE PRECISION SAVE541
      DOUBLE PRECISION SAVE542
      DOUBLE PRECISION SAVE543
      DOUBLE PRECISION SAVE544
      DOUBLE PRECISION SAVE545
      DOUBLE PRECISION SAVE546
      DOUBLE PRECISION SAVE547
      DOUBLE PRECISION SAVE548
      DOUBLE PRECISION SAVE549
      DOUBLE PRECISION SAVE55
      DOUBLE PRECISION SAVE550
      DOUBLE PRECISION SAVE551
      DOUBLE PRECISION SAVE552
      DOUBLE PRECISION SAVE553
      DOUBLE PRECISION SAVE554
      DOUBLE PRECISION SAVE555
      DOUBLE PRECISION SAVE556
      DOUBLE PRECISION SAVE557
      DOUBLE PRECISION SAVE558
      DOUBLE PRECISION SAVE559
      DOUBLE PRECISION SAVE56
      DOUBLE PRECISION SAVE560
      DOUBLE PRECISION SAVE561
      DOUBLE PRECISION SAVE562
      DOUBLE PRECISION SAVE563
      DOUBLE PRECISION SAVE564
      DOUBLE PRECISION SAVE565
      DOUBLE PRECISION SAVE566
      DOUBLE PRECISION SAVE567
      DOUBLE PRECISION SAVE568
      DOUBLE PRECISION SAVE569
      DOUBLE PRECISION SAVE57
      DOUBLE PRECISION SAVE570
      DOUBLE PRECISION SAVE571
      DOUBLE PRECISION SAVE572
      DOUBLE PRECISION SAVE573
      DOUBLE PRECISION SAVE574
      DOUBLE PRECISION SAVE575
      DOUBLE PRECISION SAVE576
      DOUBLE PRECISION SAVE577
      DOUBLE PRECISION SAVE578
      DOUBLE PRECISION SAVE579
      DOUBLE PRECISION SAVE58
      DOUBLE PRECISION SAVE580
      DOUBLE PRECISION SAVE581
      DOUBLE PRECISION SAVE582
      DOUBLE PRECISION SAVE583
      DOUBLE PRECISION SAVE584
      DOUBLE PRECISION SAVE585
      DOUBLE PRECISION SAVE586
      DOUBLE PRECISION SAVE587
      DOUBLE PRECISION SAVE588
      DOUBLE PRECISION SAVE589
      DOUBLE PRECISION SAVE59
      DOUBLE PRECISION SAVE590
      DOUBLE PRECISION SAVE591
      DOUBLE PRECISION SAVE592
      DOUBLE PRECISION SAVE593
      DOUBLE PRECISION SAVE594
      DOUBLE PRECISION SAVE595
      DOUBLE PRECISION SAVE596
      DOUBLE PRECISION SAVE597
      DOUBLE PRECISION SAVE598
      DOUBLE PRECISION SAVE599
      DOUBLE PRECISION SAVE6
      DOUBLE PRECISION SAVE60
      DOUBLE PRECISION SAVE600
      DOUBLE PRECISION SAVE601
      DOUBLE PRECISION SAVE602
      DOUBLE PRECISION SAVE603
      DOUBLE PRECISION SAVE604
      DOUBLE PRECISION SAVE605
      DOUBLE PRECISION SAVE606
      DOUBLE PRECISION SAVE607
      DOUBLE PRECISION SAVE608
      DOUBLE PRECISION SAVE609
      DOUBLE PRECISION SAVE61
      DOUBLE PRECISION SAVE610
      DOUBLE PRECISION SAVE611
      DOUBLE PRECISION SAVE612
      DOUBLE PRECISION SAVE613
      DOUBLE PRECISION SAVE614
      DOUBLE PRECISION SAVE615
      DOUBLE PRECISION SAVE616
      DOUBLE PRECISION SAVE617
      DOUBLE PRECISION SAVE618
      DOUBLE PRECISION SAVE619
      DOUBLE PRECISION SAVE62
      DOUBLE PRECISION SAVE620
      DOUBLE PRECISION SAVE621
      DOUBLE PRECISION SAVE622
      DOUBLE PRECISION SAVE623
      DOUBLE PRECISION SAVE624
      DOUBLE PRECISION SAVE625
      DOUBLE PRECISION SAVE626
      DOUBLE PRECISION SAVE627
      DOUBLE PRECISION SAVE628
      DOUBLE PRECISION SAVE629
      DOUBLE PRECISION SAVE63
      DOUBLE PRECISION SAVE630
      DOUBLE PRECISION SAVE631
      DOUBLE PRECISION SAVE632
      DOUBLE PRECISION SAVE633
      DOUBLE PRECISION SAVE634
      DOUBLE PRECISION SAVE635
      DOUBLE PRECISION SAVE636
      DOUBLE PRECISION SAVE637
      DOUBLE PRECISION SAVE638
      DOUBLE PRECISION SAVE639
      DOUBLE PRECISION SAVE64
      DOUBLE PRECISION SAVE640
      DOUBLE PRECISION SAVE641
      DOUBLE PRECISION SAVE642
      DOUBLE PRECISION SAVE643
      DOUBLE PRECISION SAVE644
      DOUBLE PRECISION SAVE645
      DOUBLE PRECISION SAVE646
      DOUBLE PRECISION SAVE647
      DOUBLE PRECISION SAVE648
      DOUBLE PRECISION SAVE649
      DOUBLE PRECISION SAVE65
      DOUBLE PRECISION SAVE650
      DOUBLE PRECISION SAVE651
      DOUBLE PRECISION SAVE652
      DOUBLE PRECISION SAVE653
      DOUBLE PRECISION SAVE654
      DOUBLE PRECISION SAVE655
      DOUBLE PRECISION SAVE656
      DOUBLE PRECISION SAVE657
      DOUBLE PRECISION SAVE658
      DOUBLE PRECISION SAVE659
      DOUBLE PRECISION SAVE66
      DOUBLE PRECISION SAVE660
      DOUBLE PRECISION SAVE661
      DOUBLE PRECISION SAVE662
      DOUBLE PRECISION SAVE663
      DOUBLE PRECISION SAVE664
      DOUBLE PRECISION SAVE665
      DOUBLE PRECISION SAVE666
      DOUBLE PRECISION SAVE667
      DOUBLE PRECISION SAVE668
      DOUBLE PRECISION SAVE669
      DOUBLE PRECISION SAVE67
      DOUBLE PRECISION SAVE670
      DOUBLE PRECISION SAVE671
      DOUBLE PRECISION SAVE672
      DOUBLE PRECISION SAVE673
      DOUBLE PRECISION SAVE674
      DOUBLE PRECISION SAVE675
      DOUBLE PRECISION SAVE676
      DOUBLE PRECISION SAVE677
      DOUBLE PRECISION SAVE678
      DOUBLE PRECISION SAVE679
      DOUBLE PRECISION SAVE68
      DOUBLE PRECISION SAVE680
      DOUBLE PRECISION SAVE681
      DOUBLE PRECISION SAVE682
      DOUBLE PRECISION SAVE683
      DOUBLE PRECISION SAVE684
      DOUBLE PRECISION SAVE685
      DOUBLE PRECISION SAVE686
      DOUBLE PRECISION SAVE687
      DOUBLE PRECISION SAVE688
      DOUBLE PRECISION SAVE689
      DOUBLE PRECISION SAVE69
      DOUBLE PRECISION SAVE690
      DOUBLE PRECISION SAVE691
      DOUBLE PRECISION SAVE692
      DOUBLE PRECISION SAVE693
      DOUBLE PRECISION SAVE694
      DOUBLE PRECISION SAVE695
      DOUBLE PRECISION SAVE696
      DOUBLE PRECISION SAVE697
      DOUBLE PRECISION SAVE698
      DOUBLE PRECISION SAVE699
      DOUBLE PRECISION SAVE7
      DOUBLE PRECISION SAVE70
      DOUBLE PRECISION SAVE700
      DOUBLE PRECISION SAVE701
      DOUBLE PRECISION SAVE702
      DOUBLE PRECISION SAVE703
      DOUBLE PRECISION SAVE704
      DOUBLE PRECISION SAVE705
      DOUBLE PRECISION SAVE706
      DOUBLE PRECISION SAVE707
      DOUBLE PRECISION SAVE708
      DOUBLE PRECISION SAVE709
      DOUBLE PRECISION SAVE71
      DOUBLE PRECISION SAVE710
      DOUBLE PRECISION SAVE711
      DOUBLE PRECISION SAVE712
      DOUBLE PRECISION SAVE713
      DOUBLE PRECISION SAVE714
      DOUBLE PRECISION SAVE715
      DOUBLE PRECISION SAVE716
      DOUBLE PRECISION SAVE717
      DOUBLE PRECISION SAVE718
      DOUBLE PRECISION SAVE719
      DOUBLE PRECISION SAVE72
      DOUBLE PRECISION SAVE720
      DOUBLE PRECISION SAVE721
      DOUBLE PRECISION SAVE722
      DOUBLE PRECISION SAVE723
      DOUBLE PRECISION SAVE724
      DOUBLE PRECISION SAVE725
      DOUBLE PRECISION SAVE726
      DOUBLE PRECISION SAVE727
      DOUBLE PRECISION SAVE728
      DOUBLE PRECISION SAVE729
      DOUBLE PRECISION SAVE73
      DOUBLE PRECISION SAVE730
      DOUBLE PRECISION SAVE731
      DOUBLE PRECISION SAVE732
      DOUBLE PRECISION SAVE733
      DOUBLE PRECISION SAVE734
      DOUBLE PRECISION SAVE735
      DOUBLE PRECISION SAVE736
      DOUBLE PRECISION SAVE737
      DOUBLE PRECISION SAVE738
      DOUBLE PRECISION SAVE739
      DOUBLE PRECISION SAVE74
      DOUBLE PRECISION SAVE740
      DOUBLE PRECISION SAVE741
      DOUBLE PRECISION SAVE742
      DOUBLE PRECISION SAVE743
      DOUBLE PRECISION SAVE744
      DOUBLE PRECISION SAVE745
      DOUBLE PRECISION SAVE746
      DOUBLE PRECISION SAVE747
      DOUBLE PRECISION SAVE748
      DOUBLE PRECISION SAVE749
      DOUBLE PRECISION SAVE75
      DOUBLE PRECISION SAVE750
      DOUBLE PRECISION SAVE751
      DOUBLE PRECISION SAVE752
      DOUBLE PRECISION SAVE753
      DOUBLE PRECISION SAVE754
      DOUBLE PRECISION SAVE755
      DOUBLE PRECISION SAVE756
      DOUBLE PRECISION SAVE757
      DOUBLE PRECISION SAVE758
      DOUBLE PRECISION SAVE759
      DOUBLE PRECISION SAVE76
      DOUBLE PRECISION SAVE760
      DOUBLE PRECISION SAVE761
      DOUBLE PRECISION SAVE762
      DOUBLE PRECISION SAVE763
      DOUBLE PRECISION SAVE764
      DOUBLE PRECISION SAVE765
      DOUBLE PRECISION SAVE766
      DOUBLE PRECISION SAVE767
      DOUBLE PRECISION SAVE768
      DOUBLE PRECISION SAVE769
      DOUBLE PRECISION SAVE77
      DOUBLE PRECISION SAVE770
      DOUBLE PRECISION SAVE771
      DOUBLE PRECISION SAVE772
      DOUBLE PRECISION SAVE773
      DOUBLE PRECISION SAVE774
      DOUBLE PRECISION SAVE775
      DOUBLE PRECISION SAVE776
      DOUBLE PRECISION SAVE777
      DOUBLE PRECISION SAVE778
      DOUBLE PRECISION SAVE779
      DOUBLE PRECISION SAVE78
      DOUBLE PRECISION SAVE780
      DOUBLE PRECISION SAVE781
      DOUBLE PRECISION SAVE782
      DOUBLE PRECISION SAVE783
      DOUBLE PRECISION SAVE784
      DOUBLE PRECISION SAVE785
      DOUBLE PRECISION SAVE786
      DOUBLE PRECISION SAVE787
      DOUBLE PRECISION SAVE788
      DOUBLE PRECISION SAVE789
      DOUBLE PRECISION SAVE79
      DOUBLE PRECISION SAVE790
      DOUBLE PRECISION SAVE791
      DOUBLE PRECISION SAVE792
      DOUBLE PRECISION SAVE793
      DOUBLE PRECISION SAVE794
      DOUBLE PRECISION SAVE795
      DOUBLE PRECISION SAVE796
      DOUBLE PRECISION SAVE797
      DOUBLE PRECISION SAVE798
      DOUBLE PRECISION SAVE799
      DOUBLE PRECISION SAVE8
      DOUBLE PRECISION SAVE80
      DOUBLE PRECISION SAVE800
      DOUBLE PRECISION SAVE801
      DOUBLE PRECISION SAVE802
      DOUBLE PRECISION SAVE803
      DOUBLE PRECISION SAVE804
      DOUBLE PRECISION SAVE805
      DOUBLE PRECISION SAVE806
      DOUBLE PRECISION SAVE807
      DOUBLE PRECISION SAVE808
      DOUBLE PRECISION SAVE809
      DOUBLE PRECISION SAVE81
      DOUBLE PRECISION SAVE810
      DOUBLE PRECISION SAVE811
      DOUBLE PRECISION SAVE812
      DOUBLE PRECISION SAVE813
      DOUBLE PRECISION SAVE814
      DOUBLE PRECISION SAVE815
      DOUBLE PRECISION SAVE816
      DOUBLE PRECISION SAVE817
      DOUBLE PRECISION SAVE818
      DOUBLE PRECISION SAVE819
      DOUBLE PRECISION SAVE82
      DOUBLE PRECISION SAVE820
      DOUBLE PRECISION SAVE821
      DOUBLE PRECISION SAVE822
      DOUBLE PRECISION SAVE823
      DOUBLE PRECISION SAVE824
      DOUBLE PRECISION SAVE825
      DOUBLE PRECISION SAVE826
      DOUBLE PRECISION SAVE827
      DOUBLE PRECISION SAVE828
      DOUBLE PRECISION SAVE829
      DOUBLE PRECISION SAVE83
      DOUBLE PRECISION SAVE830
      DOUBLE PRECISION SAVE831
      DOUBLE PRECISION SAVE832
      DOUBLE PRECISION SAVE833
      DOUBLE PRECISION SAVE834
      DOUBLE PRECISION SAVE835
      DOUBLE PRECISION SAVE836
      DOUBLE PRECISION SAVE837
      DOUBLE PRECISION SAVE838
      DOUBLE PRECISION SAVE839
      DOUBLE PRECISION SAVE84
      DOUBLE PRECISION SAVE840
      DOUBLE PRECISION SAVE841
      DOUBLE PRECISION SAVE842
      DOUBLE PRECISION SAVE843
      DOUBLE PRECISION SAVE844
      DOUBLE PRECISION SAVE845
      DOUBLE PRECISION SAVE846
      DOUBLE PRECISION SAVE847
      DOUBLE PRECISION SAVE848
      DOUBLE PRECISION SAVE849
      DOUBLE PRECISION SAVE85
      DOUBLE PRECISION SAVE850
      DOUBLE PRECISION SAVE851
      DOUBLE PRECISION SAVE852
      DOUBLE PRECISION SAVE853
      DOUBLE PRECISION SAVE854
      DOUBLE PRECISION SAVE855
      DOUBLE PRECISION SAVE856
      DOUBLE PRECISION SAVE857
      DOUBLE PRECISION SAVE858
      DOUBLE PRECISION SAVE859
      DOUBLE PRECISION SAVE86
      DOUBLE PRECISION SAVE860
      DOUBLE PRECISION SAVE861
      DOUBLE PRECISION SAVE862
      DOUBLE PRECISION SAVE863
      DOUBLE PRECISION SAVE864
      DOUBLE PRECISION SAVE865
      DOUBLE PRECISION SAVE866
      DOUBLE PRECISION SAVE867
      DOUBLE PRECISION SAVE868
      DOUBLE PRECISION SAVE869
      DOUBLE PRECISION SAVE87
      DOUBLE PRECISION SAVE870
      DOUBLE PRECISION SAVE871
      DOUBLE PRECISION SAVE872
      DOUBLE PRECISION SAVE873
      DOUBLE PRECISION SAVE874
      DOUBLE PRECISION SAVE875
      DOUBLE PRECISION SAVE876
      DOUBLE PRECISION SAVE877
      DOUBLE PRECISION SAVE878
      DOUBLE PRECISION SAVE879
      DOUBLE PRECISION SAVE88
      DOUBLE PRECISION SAVE880
      DOUBLE PRECISION SAVE881
      DOUBLE PRECISION SAVE882
      DOUBLE PRECISION SAVE883
      DOUBLE PRECISION SAVE884
      DOUBLE PRECISION SAVE885
      DOUBLE PRECISION SAVE886
      DOUBLE PRECISION SAVE887
      DOUBLE PRECISION SAVE888
      DOUBLE PRECISION SAVE889
      DOUBLE PRECISION SAVE89
      DOUBLE PRECISION SAVE890
      DOUBLE PRECISION SAVE891
      DOUBLE PRECISION SAVE892
      DOUBLE PRECISION SAVE893
      DOUBLE PRECISION SAVE894
      DOUBLE PRECISION SAVE895
      DOUBLE PRECISION SAVE896
      DOUBLE PRECISION SAVE897
      DOUBLE PRECISION SAVE898
      DOUBLE PRECISION SAVE899
      DOUBLE PRECISION SAVE9
      DOUBLE PRECISION SAVE90
      DOUBLE PRECISION SAVE900
      DOUBLE PRECISION SAVE901
      DOUBLE PRECISION SAVE902
      DOUBLE PRECISION SAVE903
      DOUBLE PRECISION SAVE904
      DOUBLE PRECISION SAVE905
      DOUBLE PRECISION SAVE906
      DOUBLE PRECISION SAVE907
      DOUBLE PRECISION SAVE908
      DOUBLE PRECISION SAVE909
      DOUBLE PRECISION SAVE91
      DOUBLE PRECISION SAVE910
      DOUBLE PRECISION SAVE911
      DOUBLE PRECISION SAVE912
      DOUBLE PRECISION SAVE913
      DOUBLE PRECISION SAVE914
      DOUBLE PRECISION SAVE915
      DOUBLE PRECISION SAVE916
      DOUBLE PRECISION SAVE917
      DOUBLE PRECISION SAVE918
      DOUBLE PRECISION SAVE919
      DOUBLE PRECISION SAVE92
      DOUBLE PRECISION SAVE920
      DOUBLE PRECISION SAVE921
      DOUBLE PRECISION SAVE922
      DOUBLE PRECISION SAVE923
      DOUBLE PRECISION SAVE924
      DOUBLE PRECISION SAVE925
      DOUBLE PRECISION SAVE926
      DOUBLE PRECISION SAVE927
      DOUBLE PRECISION SAVE928
      DOUBLE PRECISION SAVE929
      DOUBLE PRECISION SAVE93
      DOUBLE PRECISION SAVE930
      DOUBLE PRECISION SAVE931
      DOUBLE PRECISION SAVE932
      DOUBLE PRECISION SAVE933
      DOUBLE PRECISION SAVE934
      DOUBLE PRECISION SAVE935
      DOUBLE PRECISION SAVE936
      DOUBLE PRECISION SAVE937
      DOUBLE PRECISION SAVE938
      DOUBLE PRECISION SAVE939
      DOUBLE PRECISION SAVE94
      DOUBLE PRECISION SAVE940
      DOUBLE PRECISION SAVE941
      DOUBLE PRECISION SAVE942
      DOUBLE PRECISION SAVE943
      DOUBLE PRECISION SAVE944
      DOUBLE PRECISION SAVE945
      DOUBLE PRECISION SAVE946
      DOUBLE PRECISION SAVE947
      DOUBLE PRECISION SAVE948
      DOUBLE PRECISION SAVE949
      DOUBLE PRECISION SAVE95
      DOUBLE PRECISION SAVE950
      DOUBLE PRECISION SAVE951
      DOUBLE PRECISION SAVE952
      DOUBLE PRECISION SAVE953
      DOUBLE PRECISION SAVE954
      DOUBLE PRECISION SAVE955
      DOUBLE PRECISION SAVE956
      DOUBLE PRECISION SAVE957
      DOUBLE PRECISION SAVE958
      DOUBLE PRECISION SAVE959
      DOUBLE PRECISION SAVE96
      DOUBLE PRECISION SAVE960
      DOUBLE PRECISION SAVE961
      DOUBLE PRECISION SAVE962
      DOUBLE PRECISION SAVE963
      DOUBLE PRECISION SAVE964
      DOUBLE PRECISION SAVE965
      DOUBLE PRECISION SAVE966
      DOUBLE PRECISION SAVE967
      DOUBLE PRECISION SAVE968
      DOUBLE PRECISION SAVE969
      DOUBLE PRECISION SAVE97
      DOUBLE PRECISION SAVE970
      DOUBLE PRECISION SAVE971
      DOUBLE PRECISION SAVE972
      DOUBLE PRECISION SAVE973
      DOUBLE PRECISION SAVE974
      DOUBLE PRECISION SAVE975
      DOUBLE PRECISION SAVE976
      DOUBLE PRECISION SAVE977
      DOUBLE PRECISION SAVE978
      DOUBLE PRECISION SAVE979
      DOUBLE PRECISION SAVE98
      DOUBLE PRECISION SAVE980
      DOUBLE PRECISION SAVE981
      DOUBLE PRECISION SAVE982
      DOUBLE PRECISION SAVE983
      DOUBLE PRECISION SAVE984
      DOUBLE PRECISION SAVE985
      DOUBLE PRECISION SAVE986
      DOUBLE PRECISION SAVE987
      DOUBLE PRECISION SAVE988
      DOUBLE PRECISION SAVE989
      DOUBLE PRECISION SAVE99
      DOUBLE PRECISION SAVE990
      DOUBLE PRECISION SAVE991
      DOUBLE PRECISION SAVE992
      DOUBLE PRECISION SAVE993
      DOUBLE PRECISION SAVE994
      DOUBLE PRECISION SAVE995
      DOUBLE PRECISION SAVE996
      DOUBLE PRECISION SAVE997
      DOUBLE PRECISION SAVE998
      DOUBLE PRECISION SAVE999

C
C Initializations of local variables
C

      DO NNN1 = 1, NS
         CONCCCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NR
         WCCL(NNN1) = 0d0
      END DO
C
C Trajectory
C

      DO I = 1, NS
         SAVE1(I) = CHEM(I)
         CHEM(I) = 0.d0
      END DO
      SAVE1205 = I
      DO I = 1, NS
         CONC(I) = Y(I)*CONVERS_FACTOR(I)
      END DO
      CALL RATES_racm(NS, NR, RK, CONC, W)
      SAVE4 = CHEM(35)
      CHEM(35) = CHEM(35)+W(1)
      SAVE5 = CHEM(67)
      CHEM(67) = CHEM(67)+W(1)
      SAVE6 = CHEM(72)
      CHEM(72) = CHEM(72)-W(1)
      SAVE7 = CHEM(7)
      CHEM(7) = CHEM(7)+W(2)
      SAVE8 = CHEM(50)
      CHEM(50) = CHEM(50)-W(2)
      SAVE9 = CHEM(35)
      CHEM(35) = CHEM(35)+W(3)
      SAVE10 = CHEM(50)
      CHEM(50) = CHEM(50)-W(3)
      SAVE11 = CHEM(23)
      CHEM(23) = CHEM(23)-W(4)
      SAVE12 = CHEM(62)
      CHEM(62) = CHEM(62)+W(4)
      SAVE13 = CHEM(67)
      CHEM(67) = CHEM(67)+W(4)
      SAVE14 = CHEM(55)
      CHEM(55) = CHEM(55)-W(5)
      SAVE15 = CHEM(62)
      CHEM(62) = CHEM(62)+W(5)
      SAVE16 = CHEM(72)
      CHEM(72) = CHEM(72)+W(5)
      SAVE17 = CHEM(15)
      CHEM(15) = CHEM(15)-W(6)
      SAVE18 = CHEM(62)
      CHEM(62) = CHEM(62)+0.3500000000000000d+00*W(6)
      SAVE19 = CHEM(68)
      CHEM(68) = CHEM(68)+0.3500000000000000d+00*W(6)
      SAVE20 = CHEM(71)
      CHEM(71) = CHEM(71)+0.6500000000000000d+00*W(6)
      SAVE21 = CHEM(72)
      CHEM(72) = CHEM(72)+0.6500000000000000d+00*W(6)
      SAVE22 = CHEM(67)
      CHEM(67) = CHEM(67)+W(7)
      SAVE23 = CHEM(68)
      CHEM(68) = CHEM(68)-W(7)
      SAVE24 = CHEM(35)
      CHEM(35) = CHEM(35)+W(8)
      SAVE25 = CHEM(68)
      CHEM(68) = CHEM(68)-W(8)
      SAVE26 = CHEM(72)
      CHEM(72) = CHEM(72)+W(8)
      SAVE27 = CHEM(27)
      CHEM(27) = CHEM(27)-W(9)
      SAVE28 = CHEM(62)
      CHEM(62) = CHEM(62)+0.2000000000000000d+01*W(9)
      SAVE29 = CHEM(52)
      CHEM(52) = CHEM(52)+W(10)
      SAVE30 = CHEM(66)
      CHEM(66) = CHEM(66)-W(10)
      SAVE31 = CHEM(52)
      CHEM(52) = CHEM(52)+W(11)
      SAVE32 = CHEM(66)
      CHEM(66) = CHEM(66)-W(11)
      SAVE33 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2000000000000000d+01*W(11)
      SAVE34 = CHEM(52)
      CHEM(52) = CHEM(52)+W(12)
      SAVE35 = CHEM(61)
      CHEM(61) = CHEM(61)-W(12)
      SAVE36 = CHEM(63)
      CHEM(63) = CHEM(63)+W(12)
      SAVE37 = CHEM(71)
      CHEM(71) = CHEM(71)+W(12)
      SAVE38 = CHEM(16)
      CHEM(16) = CHEM(16)-W(13)
      SAVE39 = CHEM(62)
      CHEM(62) = CHEM(62)+W(13)
      SAVE40 = CHEM(66)
      CHEM(66) = CHEM(66)+W(13)
      SAVE41 = CHEM(71)
      CHEM(71) = CHEM(71)+W(13)
      SAVE42 = CHEM(53)
      CHEM(53) = CHEM(53)-W(14)
      SAVE43 = CHEM(61)
      CHEM(61) = CHEM(61)+W(14)
      SAVE44 = CHEM(62)
      CHEM(62) = CHEM(62)+W(14)
      SAVE45 = CHEM(71)
      CHEM(71) = CHEM(71)+W(14)
      SAVE46 = CHEM(28)
      CHEM(28) = CHEM(28)-W(15)
      SAVE47 = CHEM(62)
      CHEM(62) = CHEM(62)+W(15)
      SAVE48 = CHEM(63)
      CHEM(63) = CHEM(63)+W(15)
      SAVE49 = CHEM(59)
      CHEM(59) = CHEM(59)-W(16)
      SAVE50 = CHEM(60)
      CHEM(60) = CHEM(60)+W(16)
      SAVE51 = CHEM(69)
      CHEM(69) = CHEM(69)+W(16)
      SAVE52 = CHEM(51)
      CHEM(51) = CHEM(51)-W(17)
      SAVE53 = CHEM(52)
      CHEM(52) = CHEM(52)+0.1870000000000000d+01*W(17)
      SAVE54 = CHEM(66)
      CHEM(66) = CHEM(66)+0.1300000000000000d+00*W(17)
      SAVE55 = CHEM(51)
      CHEM(51) = CHEM(51)-W(18)
      SAVE56 = CHEM(52)
      CHEM(52) = CHEM(52)+0.1550000000000000d+01*W(18)
      SAVE57 = CHEM(66)
      CHEM(66) = CHEM(66)+0.4500000000000000d+00*W(18)
      SAVE58 = CHEM(71)
      CHEM(71) = CHEM(71)+0.8000000000000000d+00*W(18)
      SAVE59 = CHEM(52)
      CHEM(52) = CHEM(52)+W(19)
      SAVE60 = CHEM(54)
      CHEM(54) = CHEM(54)-W(19)
      SAVE61 = CHEM(69)
      CHEM(69) = CHEM(69)+W(19)
      SAVE62 = CHEM(71)
      CHEM(71) = CHEM(71)+W(19)
      SAVE63 = CHEM(48)
      CHEM(48) = CHEM(48)-W(20)
      SAVE64 = CHEM(56)
      CHEM(56) = CHEM(56)+W(20)
      SAVE65 = CHEM(71)
      CHEM(71) = CHEM(71)+W(20)
      SAVE66 = CHEM(59)
      CHEM(59) = CHEM(59)+0.8000000000000000d+00*W(21)
      SAVE67 = CHEM(61)
      CHEM(61) = CHEM(61)+0.2000000000000000d+00*W(21)
      SAVE68 = CHEM(70)
      CHEM(70) = CHEM(70)-W(21)
      SAVE69 = CHEM(71)
      CHEM(71) = CHEM(71)+W(21)
      SAVE70 = CHEM(72)
      CHEM(72) = CHEM(72)+W(21)
      SAVE71 = CHEM(49)
      CHEM(49) = CHEM(49)-W(22)
      SAVE72 = CHEM(52)
      CHEM(52) = CHEM(52)+W(22)
      SAVE73 = CHEM(66)
      CHEM(66) = CHEM(66)+W(22)
      SAVE74 = CHEM(69)
      CHEM(69) = CHEM(69)+W(22)
      SAVE75 = CHEM(71)
      CHEM(71) = CHEM(71)+W(22)
      SAVE76 = CHEM(24)
      CHEM(24) = CHEM(24)-W(23)
      SAVE77 = CHEM(66)
      CHEM(66) = CHEM(66)+W(23)
      SAVE78 = CHEM(69)
      CHEM(69) = CHEM(69)+W(23)
      SAVE79 = CHEM(71)
      CHEM(71) = CHEM(71)+W(23)
      SAVE80 = CHEM(35)
      CHEM(35) = CHEM(35)-W(24)
      SAVE81 = CHEM(50)
      CHEM(50) = CHEM(50)+W(24)
      SAVE82 = CHEM(35)
      CHEM(35) = CHEM(35)-W(25)
      SAVE83 = CHEM(50)
      CHEM(50) = CHEM(50)-W(25)
      SAVE84 = CHEM(7)
      CHEM(7) = CHEM(7)-W(26)
      SAVE85 = CHEM(35)
      CHEM(35) = CHEM(35)+W(26)
      SAVE86 = CHEM(7)
      CHEM(7) = CHEM(7)-W(27)
      SAVE87 = CHEM(35)
      CHEM(35) = CHEM(35)+W(27)
      SAVE88 = CHEM(7)
      CHEM(7) = CHEM(7)-W(28)
      SAVE89 = CHEM(62)
      CHEM(62) = CHEM(62)+0.2000000000000000d+01*W(28)
      SAVE90 = CHEM(50)
      CHEM(50) = CHEM(50)-W(29)
      SAVE91 = CHEM(62)
      CHEM(62) = CHEM(62)-W(29)
      SAVE92 = CHEM(71)
      CHEM(71) = CHEM(71)+W(29)
      SAVE93 = CHEM(50)
      CHEM(50) = CHEM(50)-W(30)
      SAVE94 = CHEM(62)
      CHEM(62) = CHEM(62)+W(30)
      SAVE95 = CHEM(71)
      CHEM(71) = CHEM(71)-W(30)
      SAVE96 = CHEM(62)
      CHEM(62) = CHEM(62)-W(31)
      SAVE97 = CHEM(71)
      CHEM(71) = CHEM(71)-W(31)
      SAVE98 = CHEM(27)
      CHEM(27) = CHEM(27)-W(32)
      SAVE99 = CHEM(62)
      CHEM(62) = CHEM(62)-W(32)
      SAVE100 = CHEM(71)
      CHEM(71) = CHEM(71)+W(32)
      SAVE101 = CHEM(27)
      CHEM(27) = CHEM(27)+W(33)
      SAVE102 = CHEM(71)
      CHEM(71) = CHEM(71)-0.2000000000000000d+01*W(33)
      SAVE103 = CHEM(27)
      CHEM(27) = CHEM(27)+W(34)
      SAVE104 = CHEM(71)
      CHEM(71) = CHEM(71)-0.2000000000000000d+01*W(34)
      SAVE105 = CHEM(35)
      CHEM(35) = CHEM(35)-W(35)
      SAVE106 = CHEM(67)
      CHEM(67) = CHEM(67)-W(35)
      SAVE107 = CHEM(72)
      CHEM(72) = CHEM(72)+W(35)
      SAVE108 = CHEM(35)
      CHEM(35) = CHEM(35)-W(36)
      SAVE109 = CHEM(67)
      CHEM(67) = CHEM(67)+W(36)
      SAVE110 = CHEM(72)
      CHEM(72) = CHEM(72)-W(36)
      SAVE111 = CHEM(35)
      CHEM(35) = CHEM(35)-W(37)
      SAVE112 = CHEM(68)
      CHEM(68) = CHEM(68)+W(37)
      SAVE113 = CHEM(72)
      CHEM(72) = CHEM(72)-W(37)
      SAVE114 = CHEM(23)
      CHEM(23) = CHEM(23)+W(38)
      SAVE115 = CHEM(62)
      CHEM(62) = CHEM(62)-W(38)
      SAVE116 = CHEM(67)
      CHEM(67) = CHEM(67)-W(38)
      SAVE117 = CHEM(55)
      CHEM(55) = CHEM(55)+W(39)
      SAVE118 = CHEM(62)
      CHEM(62) = CHEM(62)-W(39)
      SAVE119 = CHEM(72)
      CHEM(72) = CHEM(72)-W(39)
      SAVE120 = CHEM(62)
      CHEM(62) = CHEM(62)-W(40)
      SAVE121 = CHEM(68)
      CHEM(68) = CHEM(68)-W(40)
      SAVE122 = CHEM(71)
      CHEM(71) = CHEM(71)+W(40)
      SAVE123 = CHEM(72)
      CHEM(72) = CHEM(72)+W(40)
      SAVE124 = CHEM(62)
      CHEM(62) = CHEM(62)+W(41)
      SAVE125 = CHEM(67)
      CHEM(67) = CHEM(67)-W(41)
      SAVE126 = CHEM(71)
      CHEM(71) = CHEM(71)-W(41)
      SAVE127 = CHEM(72)
      CHEM(72) = CHEM(72)+W(41)
      SAVE128 = CHEM(15)
      CHEM(15) = CHEM(15)+W(42)
      SAVE129 = CHEM(71)
      CHEM(71) = CHEM(71)-W(42)
      SAVE130 = CHEM(72)
      CHEM(72) = CHEM(72)-W(42)
      SAVE131 = CHEM(15)
      CHEM(15) = CHEM(15)-W(43)
      SAVE132 = CHEM(71)
      CHEM(71) = CHEM(71)+W(43)
      SAVE133 = CHEM(72)
      CHEM(72) = CHEM(72)+W(43)
      SAVE134 = CHEM(55)
      CHEM(55) = CHEM(55)+0.3000000000000000d+00*W(44)
      SAVE135 = CHEM(62)
      CHEM(62) = CHEM(62)+0.7000000000000000d+00*W(44)
      SAVE136 = CHEM(68)
      CHEM(68) = CHEM(68)-W(44)
      SAVE137 = CHEM(71)
      CHEM(71) = CHEM(71)-W(44)
      SAVE138 = CHEM(72)
      CHEM(72) = CHEM(72)+0.7000000000000000d+00*W(44)
      SAVE139 = CHEM(23)
      CHEM(23) = CHEM(23)-W(45)
      SAVE140 = CHEM(62)
      CHEM(62) = CHEM(62)-W(45)
      SAVE141 = CHEM(72)
      CHEM(72) = CHEM(72)+W(45)
      SAVE142 = CHEM(55)
      CHEM(55) = CHEM(55)-W(46)
      SAVE143 = CHEM(62)
      CHEM(62) = CHEM(62)-W(46)
      SAVE144 = CHEM(68)
      CHEM(68) = CHEM(68)+W(46)
      SAVE145 = CHEM(15)
      CHEM(15) = CHEM(15)-W(47)
      SAVE146 = CHEM(62)
      CHEM(62) = CHEM(62)-W(47)
      SAVE147 = CHEM(72)
      CHEM(72) = CHEM(72)+W(47)
      SAVE148 = CHEM(50)
      CHEM(50) = CHEM(50)-W(48)
      SAVE149 = CHEM(67)
      CHEM(67) = CHEM(67)-W(48)
      SAVE150 = CHEM(72)
      CHEM(72) = CHEM(72)+W(48)
      SAVE151 = CHEM(50)
      CHEM(50) = CHEM(50)-W(49)
      SAVE152 = CHEM(68)
      CHEM(68) = CHEM(68)+W(49)
      SAVE153 = CHEM(72)
      CHEM(72) = CHEM(72)-W(49)
      SAVE154 = CHEM(67)
      CHEM(67) = CHEM(67)-0.2000000000000000d+01*W(50)
      SAVE155 = CHEM(72)
      CHEM(72) = CHEM(72)+0.2000000000000000d+01*W(50)
      SAVE156 = CHEM(67)
      CHEM(67) = CHEM(67)-W(51)
      SAVE157 = CHEM(68)
      CHEM(68) = CHEM(68)-W(51)
      SAVE158 = CHEM(72)
      CHEM(72) = CHEM(72)+0.2000000000000000d+01*W(51)
      SAVE159 = CHEM(67)
      CHEM(67) = CHEM(67)+W(52)
      SAVE160 = CHEM(68)
      CHEM(68) = CHEM(68)-W(52)
      SAVE161 = CHEM(9)
      CHEM(9) = CHEM(9)+W(53)
      SAVE162 = CHEM(68)
      CHEM(68) = CHEM(68)-W(53)
      SAVE163 = CHEM(72)
      CHEM(72) = CHEM(72)-W(53)
      SAVE164 = CHEM(9)
      CHEM(9) = CHEM(9)-W(54)
      SAVE165 = CHEM(68)
      CHEM(68) = CHEM(68)+W(54)
      SAVE166 = CHEM(72)
      CHEM(72) = CHEM(72)+W(54)
      SAVE167 = CHEM(68)
      CHEM(68) = CHEM(68)-0.2000000000000000d+01*W(55)
      SAVE168 = CHEM(72)
      CHEM(72) = CHEM(72)+0.2000000000000000d+01*W(55)
      SAVE169 = CHEM(62)
      CHEM(62) = CHEM(62)-W(56)
      SAVE170 = CHEM(71)
      CHEM(71) = CHEM(71)+W(56)
      SAVE171 = CHEM(1)
      CHEM(1) = CHEM(1)-W(57)
      SAVE172 = CHEM(8)
      CHEM(8) = CHEM(8)+W(57)
      SAVE173 = CHEM(62)
      CHEM(62) = CHEM(62)-W(57)
      SAVE174 = CHEM(71)
      CHEM(71) = CHEM(71)+W(57)
      SAVE175 = CHEM(52)
      CHEM(52) = CHEM(52)-W(58)
      SAVE176 = CHEM(62)
      CHEM(62) = CHEM(62)-W(58)
      SAVE177 = CHEM(71)
      CHEM(71) = CHEM(71)+W(58)
      SAVE178 = CHEM(19)
      CHEM(19) = CHEM(19)-W(59)
      SAVE179 = CHEM(35)
      CHEM(35) = CHEM(35)-W(59)
      SAVE180 = CHEM(40)
      CHEM(40) = CHEM(40)+0.8600000000000000d+00*W(59)
      SAVE181 = CHEM(48)
      CHEM(48) = CHEM(48)+0.1300000000000000d+00*W(59)
      SAVE182 = CHEM(52)
      CHEM(52) = CHEM(52)+0.1000000000000000d-01*W(59)
      SAVE183 = CHEM(62)
      CHEM(62) = CHEM(62)+0.2000000000000000d-01*W(59)
      SAVE184 = CHEM(65)
      CHEM(65) = CHEM(65)+0.1500000000000000d+00*W(59)
      SAVE185 = CHEM(66)
      CHEM(66) = CHEM(66)+0.5000000000000000d-01*W(59)
      SAVE186 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2800000000000000d+00*W(59)
      SAVE187 = CHEM(35)
      CHEM(35) = CHEM(35)-W(60)
      SAVE188 = CHEM(49)
      CHEM(49) = CHEM(49)-W(60)
      SAVE189 = CHEM(61)
      CHEM(61) = CHEM(61)+W(60)
      SAVE190 = CHEM(20)
      CHEM(20) = CHEM(20)-W(61)
      SAVE191 = CHEM(62)
      CHEM(62) = CHEM(62)-W(61)
      SAVE192 = CHEM(63)
      CHEM(63) = CHEM(63)+W(61)
      SAVE193 = CHEM(21)
      CHEM(21) = CHEM(21)-W(62)
      SAVE194 = CHEM(60)
      CHEM(60) = CHEM(60)+W(62)
      SAVE195 = CHEM(62)
      CHEM(62) = CHEM(62)-W(62)
      SAVE196 = CHEM(2)
      CHEM(2) = CHEM(2)-W(63)
      SAVE197 = CHEM(34)
      CHEM(34) = CHEM(34)+0.3600000000000000d-01*W(63)
      SAVE198 = CHEM(51)
      CHEM(51) = CHEM(51)+0.3600000000000000d-01*W(63)
      SAVE199 = CHEM(52)
      CHEM(52) = CHEM(52)+0.3600000000000000d-01*W(63)
      SAVE200 = CHEM(61)
      CHEM(61) = CHEM(61)+0.3350000000000000d+00*W(63)
      SAVE201 = CHEM(62)
      CHEM(62) = CHEM(62)-0.9640000000000000d+00*W(63)
      SAVE202 = CHEM(64)
      CHEM(64) = CHEM(64)+0.5830000000000000d+00*W(63)
      SAVE203 = CHEM(66)
      CHEM(66) = CHEM(66)+0.1000000000000000d-01*W(63)
      SAVE204 = CHEM(71)
      CHEM(71) = CHEM(71)+0.3810000000000000d+00*W(63)
      SAVE205 = CHEM(3)
      CHEM(3) = CHEM(3)-W(64)
      SAVE206 = CHEM(36)
      CHEM(36) = CHEM(36)+0.7500000000000000d+00*W(64)
      SAVE207 = CHEM(59)
      CHEM(59) = CHEM(59)+0.2500000000000000d+00*W(64)
      SAVE208 = CHEM(62)
      CHEM(62) = CHEM(62)-W(64)
      SAVE209 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2500000000000000d+00*W(64)
      SAVE210 = CHEM(4)
      CHEM(4) = CHEM(4)-W(65)
      SAVE211 = CHEM(24)
      CHEM(24) = CHEM(24)+0.2400000000000000d-01*W(65)
      SAVE212 = CHEM(37)
      CHEM(37) = CHEM(37)+0.9510000000000000d+00*W(65)
      SAVE213 = CHEM(61)
      CHEM(61) = CHEM(61)+0.2500000000000000d-01*W(65)
      SAVE214 = CHEM(62)
      CHEM(62) = CHEM(62)-W(65)
      SAVE215 = CHEM(71)
      CHEM(71) = CHEM(71)+0.4900000000000000d-01*W(65)
      SAVE216 = CHEM(11)
      CHEM(11) = CHEM(11)-W(66)
      SAVE217 = CHEM(38)
      CHEM(38) = CHEM(38)+W(66)
      SAVE218 = CHEM(62)
      CHEM(62) = CHEM(62)-W(66)
      SAVE219 = CHEM(40)
      CHEM(40) = CHEM(40)-W(67)
      SAVE220 = CHEM(41)
      CHEM(41) = CHEM(41)+W(67)
      SAVE221 = CHEM(62)
      CHEM(62) = CHEM(62)-W(67)
      SAVE222 = CHEM(44)
      CHEM(44) = CHEM(44)-W(68)
      SAVE223 = CHEM(45)
      CHEM(45) = CHEM(45)+W(68)
      SAVE224 = CHEM(62)
      CHEM(62) = CHEM(62)-W(68)
      SAVE225 = CHEM(12)
      CHEM(12) = CHEM(12)-W(69)
      SAVE226 = CHEM(39)
      CHEM(39) = CHEM(39)+W(69)
      SAVE227 = CHEM(62)
      CHEM(62) = CHEM(62)-W(69)
      SAVE228 = CHEM(19)
      CHEM(19) = CHEM(19)-W(70)
      SAVE229 = CHEM(39)
      CHEM(39) = CHEM(39)+W(70)
      SAVE230 = CHEM(62)
      CHEM(62) = CHEM(62)-W(70)
      SAVE231 = CHEM(13)
      CHEM(13) = CHEM(13)-W(71)
      SAVE232 = CHEM(42)
      CHEM(42) = CHEM(42)+W(71)
      SAVE233 = CHEM(62)
      CHEM(62) = CHEM(62)-W(71)
      SAVE234 = CHEM(14)
      CHEM(14) = CHEM(14)-W(72)
      SAVE235 = CHEM(43)
      CHEM(43) = CHEM(43)+W(72)
      SAVE236 = CHEM(62)
      CHEM(62) = CHEM(62)-W(72)
      SAVE237 = CHEM(5)
      CHEM(5) = CHEM(5)-W(73)
      SAVE238 = CHEM(17)
      CHEM(17) = CHEM(17)+0.9000000000000000d+00*W(73)
      SAVE239 = CHEM(62)
      CHEM(62) = CHEM(62)-W(73)
      SAVE240 = CHEM(65)
      CHEM(65) = CHEM(65)+0.1000000000000000d+00*W(73)
      SAVE241 = CHEM(71)
      CHEM(71) = CHEM(71)+0.1000000000000000d+00*W(73)
      SAVE242 = CHEM(6)
      CHEM(6) = CHEM(6)-W(74)
      SAVE243 = CHEM(18)
      CHEM(18) = CHEM(18)+0.9000000000000000d+00*W(74)
      SAVE244 = CHEM(62)
      CHEM(62) = CHEM(62)-W(74)
      SAVE245 = CHEM(65)
      CHEM(65) = CHEM(65)+0.1000000000000000d+00*W(74)
      SAVE246 = CHEM(71)
      CHEM(71) = CHEM(71)+0.1000000000000000d+00*W(74)
      SAVE247 = CHEM(22)
      CHEM(22) = CHEM(22)+0.8500000000000000d+00*W(75)
      SAVE248 = CHEM(29)
      CHEM(29) = CHEM(29)+0.1000000000000000d+00*W(75)
      SAVE249 = CHEM(30)
      CHEM(30) = CHEM(30)-W(75)
      SAVE250 = CHEM(62)
      CHEM(62) = CHEM(62)-W(75)
      SAVE251 = CHEM(65)
      CHEM(65) = CHEM(65)+0.5000000000000000d-01*W(75)
      SAVE252 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5000000000000000d-01*W(75)
      SAVE253 = CHEM(52)
      CHEM(52) = CHEM(52)+W(76)
      SAVE254 = CHEM(62)
      CHEM(62) = CHEM(62)-W(76)
      SAVE255 = CHEM(66)
      CHEM(66) = CHEM(66)-W(76)
      SAVE256 = CHEM(71)
      CHEM(71) = CHEM(71)+W(76)
      SAVE257 = CHEM(61)
      CHEM(61) = CHEM(61)-W(77)
      SAVE258 = CHEM(62)
      CHEM(62) = CHEM(62)-W(77)
      SAVE259 = CHEM(69)
      CHEM(69) = CHEM(69)+W(77)
      SAVE260 = CHEM(58)
      CHEM(58) = CHEM(58)+W(78)
      SAVE261 = CHEM(59)
      CHEM(59) = CHEM(59)-W(78)
      SAVE262 = CHEM(62)
      CHEM(62) = CHEM(62)-W(78)
      SAVE263 = CHEM(24)
      CHEM(24) = CHEM(24)-W(79)
      SAVE264 = CHEM(54)
      CHEM(54) = CHEM(54)+W(79)
      SAVE265 = CHEM(62)
      CHEM(62) = CHEM(62)-W(79)
      SAVE266 = CHEM(71)
      CHEM(71) = CHEM(71)+W(79)
      SAVE267 = CHEM(51)
      CHEM(51) = CHEM(51)-W(80)
      SAVE268 = CHEM(52)
      CHEM(52) = CHEM(52)+0.2000000000000000d+01*W(80)
      SAVE269 = CHEM(62)
      CHEM(62) = CHEM(62)-W(80)
      SAVE270 = CHEM(71)
      CHEM(71) = CHEM(71)+W(80)
      SAVE271 = CHEM(52)
      CHEM(52) = CHEM(52)+W(81)
      SAVE272 = CHEM(54)
      CHEM(54) = CHEM(54)-W(81)
      SAVE273 = CHEM(62)
      CHEM(62) = CHEM(62)-W(81)
      SAVE274 = CHEM(69)
      CHEM(69) = CHEM(69)+W(81)
      SAVE275 = CHEM(24)
      CHEM(24) = CHEM(24)+0.4100000000000000d+00*W(82)
      SAVE276 = CHEM(49)
      CHEM(49) = CHEM(49)-W(82)
      SAVE277 = CHEM(52)
      CHEM(52) = CHEM(52)+0.4100000000000000d+00*W(82)
      SAVE278 = CHEM(54)
      CHEM(54) = CHEM(54)+0.8000000000000000d-01*W(82)
      SAVE279 = CHEM(56)
      CHEM(56) = CHEM(56)+0.5100000000000000d+00*W(82)
      SAVE280 = CHEM(62)
      CHEM(62) = CHEM(62)-W(82)
      SAVE281 = CHEM(65)
      CHEM(65) = CHEM(65)+0.4900000000000000d+00*W(82)
      SAVE282 = CHEM(66)
      CHEM(66) = CHEM(66)+0.8000000000000000d-01*W(82)
      SAVE283 = CHEM(71)
      CHEM(71) = CHEM(71)+0.4900000000000000d+00*W(82)
      SAVE284 = CHEM(10)
      CHEM(10) = CHEM(10)+0.3500000000000000d+00*W(83)
      SAVE285 = CHEM(48)
      CHEM(48) = CHEM(48)-W(83)
      SAVE286 = CHEM(51)
      CHEM(51) = CHEM(51)+0.1500000000000000d+00*W(83)
      SAVE287 = CHEM(54)
      CHEM(54) = CHEM(54)+0.1500000000000000d+00*W(83)
      SAVE288 = CHEM(56)
      CHEM(56) = CHEM(56)+0.5000000000000000d+00*W(83)
      SAVE289 = CHEM(62)
      CHEM(62) = CHEM(62)-W(83)
      SAVE290 = CHEM(65)
      CHEM(65) = CHEM(65)+0.5000000000000000d+00*W(83)
      SAVE291 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5000000000000000d+00*W(83)
      SAVE292 = CHEM(10)
      CHEM(10) = CHEM(10)-W(84)
      SAVE293 = CHEM(59)
      CHEM(59) = CHEM(59)+0.1200000000000000d+00*W(84)
      SAVE294 = CHEM(61)
      CHEM(61) = CHEM(61)+0.8800000000000000d+00*W(84)
      SAVE295 = CHEM(62)
      CHEM(62) = CHEM(62)-W(84)
      SAVE296 = CHEM(71)
      CHEM(71) = CHEM(71)+W(84)
      SAVE297 = CHEM(16)
      CHEM(16) = CHEM(16)-W(85)
      SAVE298 = CHEM(62)
      CHEM(62) = CHEM(62)-0.6500000000000000d+00*W(85)
      SAVE299 = CHEM(63)
      CHEM(63) = CHEM(63)+0.6500000000000000d+00*W(85)
      SAVE300 = CHEM(66)
      CHEM(66) = CHEM(66)+0.3500000000000000d+00*W(85)
      SAVE301 = CHEM(53)
      CHEM(53) = CHEM(53)-W(86)
      SAVE302 = CHEM(59)
      CHEM(59) = CHEM(59)+0.4100000000000000d+00*W(86)
      SAVE303 = CHEM(61)
      CHEM(61) = CHEM(61)+0.8000000000000000d-01*W(86)
      SAVE304 = CHEM(62)
      CHEM(62) = CHEM(62)-0.5100000000000000d+00*W(86)
      SAVE305 = CHEM(64)
      CHEM(64) = CHEM(64)+0.4400000000000000d+00*W(86)
      SAVE306 = CHEM(65)
      CHEM(65) = CHEM(65)+0.7000000000000001d-01*W(86)
      SAVE307 = CHEM(28)
      CHEM(28) = CHEM(28)-W(87)
      SAVE308 = CHEM(62)
      CHEM(62) = CHEM(62)-W(87)
      SAVE309 = CHEM(65)
      CHEM(65) = CHEM(65)+0.3500000000000000d+00*W(87)
      SAVE310 = CHEM(66)
      CHEM(66) = CHEM(66)+0.3500000000000000d+00*W(87)
      SAVE311 = CHEM(69)
      CHEM(69) = CHEM(69)+0.6500000000000000d+00*W(87)
      SAVE312 = CHEM(71)
      CHEM(71) = CHEM(71)+0.3500000000000000d+00*W(87)
      SAVE313 = CHEM(26)
      CHEM(26) = CHEM(26)-W(88)
      SAVE314 = CHEM(62)
      CHEM(62) = CHEM(62)-W(88)
      SAVE315 = CHEM(65)
      CHEM(65) = CHEM(65)+W(88)
      SAVE316 = CHEM(66)
      CHEM(66) = CHEM(66)+W(88)
      SAVE317 = CHEM(68)
      CHEM(68) = CHEM(68)+W(88)
      SAVE318 = CHEM(24)
      CHEM(24) = CHEM(24)+0.6000000000000000d+00*W(89)
      SAVE319 = CHEM(25)
      CHEM(25) = CHEM(25)-W(89)
      SAVE320 = CHEM(26)
      CHEM(26) = CHEM(26)+0.4000000000000000d+00*W(89)
      SAVE321 = CHEM(62)
      CHEM(62) = CHEM(62)-W(89)
      SAVE322 = CHEM(65)
      CHEM(65) = CHEM(65)+W(89)
      SAVE323 = CHEM(66)
      CHEM(66) = CHEM(66)+0.4000000000000000d+00*W(89)
      SAVE324 = CHEM(68)
      CHEM(68) = CHEM(68)+0.6000000000000000d+00*W(89)
      SAVE325 = CHEM(71)
      CHEM(71) = CHEM(71)+0.4000000000000000d+00*W(89)
      SAVE326 = CHEM(62)
      CHEM(62) = CHEM(62)-W(90)
      SAVE327 = CHEM(64)
      CHEM(64) = CHEM(64)+W(90)
      SAVE328 = CHEM(70)
      CHEM(70) = CHEM(70)-W(90)
      SAVE329 = CHEM(72)
      CHEM(72) = CHEM(72)+W(90)
      SAVE330 = CHEM(52)
      CHEM(52) = CHEM(52)+W(91)
      SAVE331 = CHEM(55)
      CHEM(55) = CHEM(55)+W(91)
      SAVE332 = CHEM(66)
      CHEM(66) = CHEM(66)-W(91)
      SAVE333 = CHEM(68)
      CHEM(68) = CHEM(68)-W(91)
      SAVE334 = CHEM(71)
      CHEM(71) = CHEM(71)+W(91)
      SAVE335 = CHEM(55)
      CHEM(55) = CHEM(55)+W(92)
      SAVE336 = CHEM(61)
      CHEM(61) = CHEM(61)-W(92)
      SAVE337 = CHEM(68)
      CHEM(68) = CHEM(68)-W(92)
      SAVE338 = CHEM(69)
      CHEM(69) = CHEM(69)+W(92)
      SAVE339 = CHEM(51)
      CHEM(51) = CHEM(51)-W(93)
      SAVE340 = CHEM(52)
      CHEM(52) = CHEM(52)+0.2000000000000000d+01*W(93)
      SAVE341 = CHEM(55)
      CHEM(55) = CHEM(55)+W(93)
      SAVE342 = CHEM(68)
      CHEM(68) = CHEM(68)-W(93)
      SAVE343 = CHEM(71)
      CHEM(71) = CHEM(71)+W(93)
      SAVE344 = CHEM(52)
      CHEM(52) = CHEM(52)+W(94)
      SAVE345 = CHEM(54)
      CHEM(54) = CHEM(54)-W(94)
      SAVE346 = CHEM(55)
      CHEM(55) = CHEM(55)+W(94)
      SAVE347 = CHEM(68)
      CHEM(68) = CHEM(68)-W(94)
      SAVE348 = CHEM(69)
      CHEM(69) = CHEM(69)+W(94)
      SAVE349 = CHEM(47)
      CHEM(47) = CHEM(47)+0.8000000000000000d+00*W(95)
      SAVE350 = CHEM(49)
      CHEM(49) = CHEM(49)-W(95)
      SAVE351 = CHEM(52)
      CHEM(52) = CHEM(52)+0.8000000000000000d+00*W(95)
      SAVE352 = CHEM(55)
      CHEM(55) = CHEM(55)+0.2000000000000000d+00*W(95)
      SAVE353 = CHEM(56)
      CHEM(56) = CHEM(56)+0.2000000000000000d+00*W(95)
      SAVE354 = CHEM(68)
      CHEM(68) = CHEM(68)-W(95)
      SAVE355 = CHEM(48)
      CHEM(48) = CHEM(48)-W(96)
      SAVE356 = CHEM(51)
      CHEM(51) = CHEM(51)+0.2500000000000000d+00*W(96)
      SAVE357 = CHEM(54)
      CHEM(54) = CHEM(54)+0.2500000000000000d+00*W(96)
      SAVE358 = CHEM(55)
      CHEM(55) = CHEM(55)+0.5000000000000000d+00*W(96)
      SAVE359 = CHEM(56)
      CHEM(56) = CHEM(56)+0.5000000000000000d+00*W(96)
      SAVE360 = CHEM(59)
      CHEM(59) = CHEM(59)+0.3000000000000000d-01*W(96)
      SAVE361 = CHEM(61)
      CHEM(61) = CHEM(61)+0.2500000000000000d+00*W(96)
      SAVE362 = CHEM(65)
      CHEM(65) = CHEM(65)+0.5000000000000000d+00*W(96)
      SAVE363 = CHEM(68)
      CHEM(68) = CHEM(68)-W(96)
      SAVE364 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5000000000000000d+00*W(96)
      SAVE365 = CHEM(72)
      CHEM(72) = CHEM(72)+0.5000000000000000d+00*W(96)
      SAVE366 = CHEM(29)
      CHEM(29) = CHEM(29)+W(97)
      SAVE367 = CHEM(30)
      CHEM(30) = CHEM(30)-W(97)
      SAVE368 = CHEM(55)
      CHEM(55) = CHEM(55)+W(97)
      SAVE369 = CHEM(68)
      CHEM(68) = CHEM(68)-W(97)
      SAVE370 = CHEM(11)
      CHEM(11) = CHEM(11)-W(98)
      SAVE371 = CHEM(46)
      CHEM(46) = CHEM(46)+0.2000000000000000d+00*W(98)
      SAVE372 = CHEM(47)
      CHEM(47) = CHEM(47)+0.8000000000000000d+00*W(98)
      SAVE373 = CHEM(68)
      CHEM(68) = CHEM(68)-W(98)
      SAVE374 = CHEM(40)
      CHEM(40) = CHEM(40)-W(99)
      SAVE375 = CHEM(46)
      CHEM(46) = CHEM(46)+0.5700000000000000d+00*W(99)
      SAVE376 = CHEM(47)
      CHEM(47) = CHEM(47)+0.4300000000000000d+00*W(99)
      SAVE377 = CHEM(68)
      CHEM(68) = CHEM(68)-W(99)
      SAVE378 = CHEM(44)
      CHEM(44) = CHEM(44)-W(100)
      SAVE379 = CHEM(46)
      CHEM(46) = CHEM(46)+0.8900000000000000d+00*W(100)
      SAVE380 = CHEM(47)
      CHEM(47) = CHEM(47)+0.1100000000000000d+00*W(100)
      SAVE381 = CHEM(68)
      CHEM(68) = CHEM(68)-W(100)
      SAVE382 = CHEM(12)
      CHEM(12) = CHEM(12)-W(101)
      SAVE383 = CHEM(46)
      CHEM(46) = CHEM(46)+0.1000000000000000d+00*W(101)
      SAVE384 = CHEM(47)
      CHEM(47) = CHEM(47)+0.9000000000000000d+00*W(101)
      SAVE385 = CHEM(49)
      CHEM(49) = CHEM(49)+0.9000000000000000d+00*W(101)
      SAVE386 = CHEM(68)
      CHEM(68) = CHEM(68)-W(101)
      SAVE387 = CHEM(19)
      CHEM(19) = CHEM(19)-W(102)
      SAVE388 = CHEM(46)
      CHEM(46) = CHEM(46)+0.1000000000000000d+00*W(102)
      SAVE389 = CHEM(47)
      CHEM(47) = CHEM(47)+0.9000000000000000d+00*W(102)
      SAVE390 = CHEM(49)
      CHEM(49) = CHEM(49)+0.9000000000000000d+00*W(102)
      SAVE391 = CHEM(68)
      CHEM(68) = CHEM(68)-W(102)
      SAVE392 = CHEM(13)
      CHEM(13) = CHEM(13)-W(103)
      SAVE393 = CHEM(46)
      CHEM(46) = CHEM(46)+0.9000000000000000d+00*W(103)
      SAVE394 = CHEM(47)
      CHEM(47) = CHEM(47)+0.1000000000000000d+00*W(103)
      SAVE395 = CHEM(68)
      CHEM(68) = CHEM(68)-W(103)
      SAVE396 = CHEM(14)
      CHEM(14) = CHEM(14)-W(104)
      SAVE397 = CHEM(46)
      CHEM(46) = CHEM(46)+0.8700000000000000d+00*W(104)
      SAVE398 = CHEM(47)
      CHEM(47) = CHEM(47)+0.1300000000000000d+00*W(104)
      SAVE399 = CHEM(68)
      CHEM(68) = CHEM(68)-W(104)
      SAVE400 = CHEM(25)
      CHEM(25) = CHEM(25)-W(105)
      SAVE401 = CHEM(26)
      CHEM(26) = CHEM(26)+0.4000000000000000d+00*W(105)
      SAVE402 = CHEM(65)
      CHEM(65) = CHEM(65)+W(105)
      SAVE403 = CHEM(66)
      CHEM(66) = CHEM(66)+0.4000000000000000d+00*W(105)
      SAVE404 = CHEM(68)
      CHEM(68) = CHEM(68)-0.4000000000000000d+00*W(105)
      SAVE405 = CHEM(70)
      CHEM(70) = CHEM(70)+0.6000000000000000d+00*W(105)
      SAVE406 = CHEM(72)
      CHEM(72) = CHEM(72)+0.4000000000000000d+00*W(105)
      SAVE407 = CHEM(11)
      CHEM(11) = CHEM(11)-W(106)
      SAVE408 = CHEM(34)
      CHEM(34) = CHEM(34)+0.3700000000000000d+00*W(106)
      SAVE409 = CHEM(50)
      CHEM(50) = CHEM(50)-W(106)
      SAVE410 = CHEM(52)
      CHEM(52) = CHEM(52)+0.4300000000000000d+00*W(106)
      SAVE411 = CHEM(62)
      CHEM(62) = CHEM(62)+0.1200000000000000d+00*W(106)
      SAVE412 = CHEM(66)
      CHEM(66) = CHEM(66)+W(106)
      SAVE413 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2600000000000000d+00*W(106)
      SAVE414 = CHEM(20)
      CHEM(20) = CHEM(20)+0.6000000000000000d-01*W(107)
      SAVE415 = CHEM(21)
      CHEM(21) = CHEM(21)+0.3000000000000000d-01*W(107)
      SAVE416 = CHEM(27)
      CHEM(27) = CHEM(27)+0.6000000000000000d-02*W(107)
      SAVE417 = CHEM(34)
      CHEM(34) = CHEM(34)+0.1400000000000000d+00*W(107)
      SAVE418 = CHEM(40)
      CHEM(40) = CHEM(40)-W(107)
      SAVE419 = CHEM(50)
      CHEM(50) = CHEM(50)-W(107)
      SAVE420 = CHEM(52)
      CHEM(52) = CHEM(52)+0.3700000000000000d+00*W(107)
      SAVE421 = CHEM(57)
      CHEM(57) = CHEM(57)+0.1000000000000000d+00*W(107)
      SAVE422 = CHEM(58)
      CHEM(58) = CHEM(58)+0.3000000000000000d-01*W(107)
      SAVE423 = CHEM(59)
      CHEM(59) = CHEM(59)+0.3000000000000000d-01*W(107)
      SAVE424 = CHEM(60)
      CHEM(60) = CHEM(60)+0.1000000000000000d+00*W(107)
      SAVE425 = CHEM(61)
      CHEM(61) = CHEM(61)+0.4400000000000000d+00*W(107)
      SAVE426 = CHEM(62)
      CHEM(62) = CHEM(62)+0.4000000000000000d+00*W(107)
      SAVE427 = CHEM(63)
      CHEM(63) = CHEM(63)+0.1900000000000000d+00*W(107)
      SAVE428 = CHEM(66)
      CHEM(66) = CHEM(66)+0.6400000000000000d+00*W(107)
      SAVE429 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2500000000000000d+00*W(107)
      SAVE430 = CHEM(20)
      CHEM(20) = CHEM(20)+0.7000000000000001d-01*W(108)
      SAVE431 = CHEM(21)
      CHEM(21) = CHEM(21)+0.6000000000000000d-01*W(108)
      SAVE432 = CHEM(27)
      CHEM(27) = CHEM(27)+0.1100000000000000d-01*W(108)
      SAVE433 = CHEM(44)
      CHEM(44) = CHEM(44)-W(108)
      SAVE434 = CHEM(50)
      CHEM(50) = CHEM(50)-W(108)
      SAVE435 = CHEM(52)
      CHEM(52) = CHEM(52)+0.3000000000000000d+00*W(108)
      SAVE436 = CHEM(57)
      CHEM(57) = CHEM(57)+0.1400000000000000d+00*W(108)
      SAVE437 = CHEM(58)
      CHEM(58) = CHEM(58)+0.1200000000000000d+00*W(108)
      SAVE438 = CHEM(59)
      CHEM(59) = CHEM(59)+0.1600000000000000d+00*W(108)
      SAVE439 = CHEM(60)
      CHEM(60) = CHEM(60)+0.1800000000000000d+00*W(108)
      SAVE440 = CHEM(61)
      CHEM(61) = CHEM(61)+0.9900000000000000d+00*W(108)
      SAVE441 = CHEM(62)
      CHEM(62) = CHEM(62)+0.6300000000000000d+00*W(108)
      SAVE442 = CHEM(63)
      CHEM(63) = CHEM(63)+0.2300000000000000d+00*W(108)
      SAVE443 = CHEM(66)
      CHEM(66) = CHEM(66)+0.2000000000000000d-01*W(108)
      SAVE444 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2200000000000000d+00*W(108)
      SAVE445 = CHEM(12)
      CHEM(12) = CHEM(12)-W(109)
      SAVE446 = CHEM(27)
      CHEM(27) = CHEM(27)+0.1000000000000000d-02*W(109)
      SAVE447 = CHEM(34)
      CHEM(34) = CHEM(34)+0.1500000000000000d+00*W(109)
      SAVE448 = CHEM(35)
      CHEM(35) = CHEM(35)+0.9000000000000000d-01*W(109)
      SAVE449 = CHEM(40)
      CHEM(40) = CHEM(40)+0.3500000000000000d+00*W(109)
      SAVE450 = CHEM(49)
      CHEM(49) = CHEM(49)+0.3900000000000000d+00*W(109)
      SAVE451 = CHEM(50)
      CHEM(50) = CHEM(50)-W(109)
      SAVE452 = CHEM(52)
      CHEM(52) = CHEM(52)+0.3600000000000000d+00*W(109)
      SAVE453 = CHEM(58)
      CHEM(58) = CHEM(58)+0.2000000000000000d-01*W(109)
      SAVE454 = CHEM(62)
      CHEM(62) = CHEM(62)+0.2800000000000000d+00*W(109)
      SAVE455 = CHEM(63)
      CHEM(63) = CHEM(63)+0.3000000000000000d-01*W(109)
      SAVE456 = CHEM(65)
      CHEM(65) = CHEM(65)+0.1300000000000000d+00*W(109)
      SAVE457 = CHEM(66)
      CHEM(66) = CHEM(66)+0.9000000000000000d+00*W(109)
      SAVE458 = CHEM(69)
      CHEM(69) = CHEM(69)+0.1500000000000000d+00*W(109)
      SAVE459 = CHEM(71)
      CHEM(71) = CHEM(71)+0.3000000000000000d+00*W(109)
      SAVE460 = CHEM(19)
      CHEM(19) = CHEM(19)-W(110)
      SAVE461 = CHEM(27)
      CHEM(27) = CHEM(27)+0.1000000000000000d-02*W(110)
      SAVE462 = CHEM(34)
      CHEM(34) = CHEM(34)+0.1500000000000000d+00*W(110)
      SAVE463 = CHEM(35)
      CHEM(35) = CHEM(35)+0.9000000000000000d-01*W(110)
      SAVE464 = CHEM(40)
      CHEM(40) = CHEM(40)+0.3500000000000000d+00*W(110)
      SAVE465 = CHEM(49)
      CHEM(49) = CHEM(49)+0.3900000000000000d+00*W(110)
      SAVE466 = CHEM(50)
      CHEM(50) = CHEM(50)-W(110)
      SAVE467 = CHEM(52)
      CHEM(52) = CHEM(52)+0.3600000000000000d+00*W(110)
      SAVE468 = CHEM(58)
      CHEM(58) = CHEM(58)+0.2000000000000000d-01*W(110)
      SAVE469 = CHEM(62)
      CHEM(62) = CHEM(62)+0.2800000000000000d+00*W(110)
      SAVE470 = CHEM(63)
      CHEM(63) = CHEM(63)+0.3000000000000000d-01*W(110)
      SAVE471 = CHEM(65)
      CHEM(65) = CHEM(65)+0.1300000000000000d+00*W(110)
      SAVE472 = CHEM(66)
      CHEM(66) = CHEM(66)+0.9000000000000000d+00*W(110)
      SAVE473 = CHEM(69)
      CHEM(69) = CHEM(69)+0.1500000000000000d+00*W(110)
      SAVE474 = CHEM(71)
      CHEM(71) = CHEM(71)+0.3000000000000000d+00*W(110)
      SAVE475 = CHEM(13)
      CHEM(13) = CHEM(13)-W(111)
      SAVE476 = CHEM(27)
      CHEM(27) = CHEM(27)+0.2000000000000000d-01*W(111)
      SAVE477 = CHEM(50)
      CHEM(50) = CHEM(50)-W(111)
      SAVE478 = CHEM(52)
      CHEM(52) = CHEM(52)+0.1400000000000000d+00*W(111)
      SAVE479 = CHEM(58)
      CHEM(58) = CHEM(58)+0.4200000000000000d+00*W(111)
      SAVE480 = CHEM(59)
      CHEM(59) = CHEM(59)+0.5300000000000000d+00*W(111)
      SAVE481 = CHEM(60)
      CHEM(60) = CHEM(60)+0.2000000000000000d+00*W(111)
      SAVE482 = CHEM(61)
      CHEM(61) = CHEM(61)+0.6500000000000000d+00*W(111)
      SAVE483 = CHEM(62)
      CHEM(62) = CHEM(62)+0.8500000000000000d+00*W(111)
      SAVE484 = CHEM(71)
      CHEM(71) = CHEM(71)+0.1000000000000000d+00*W(111)
      SAVE485 = CHEM(14)
      CHEM(14) = CHEM(14)-W(112)
      SAVE486 = CHEM(27)
      CHEM(27) = CHEM(27)+0.2000000000000000d-01*W(112)
      SAVE487 = CHEM(34)
      CHEM(34) = CHEM(34)+0.1000000000000000d-01*W(112)
      SAVE488 = CHEM(40)
      CHEM(40) = CHEM(40)+0.4600000000000000d+00*W(112)
      SAVE489 = CHEM(49)
      CHEM(49) = CHEM(49)+0.7900000000000000d+00*W(112)
      SAVE490 = CHEM(50)
      CHEM(50) = CHEM(50)-W(112)
      SAVE491 = CHEM(52)
      CHEM(52) = CHEM(52)+0.1400000000000000d+00*W(112)
      SAVE492 = CHEM(57)
      CHEM(57) = CHEM(57)+0.7000000000000001d-01*W(112)
      SAVE493 = CHEM(58)
      CHEM(58) = CHEM(58)+0.4200000000000000d+00*W(112)
      SAVE494 = CHEM(60)
      CHEM(60) = CHEM(60)+0.1600000000000000d+00*W(112)
      SAVE495 = CHEM(62)
      CHEM(62) = CHEM(62)+0.8500000000000000d+00*W(112)
      SAVE496 = CHEM(66)
      CHEM(66) = CHEM(66)+0.4000000000000000d-01*W(112)
      SAVE497 = CHEM(71)
      CHEM(71) = CHEM(71)+0.1000000000000000d+00*W(112)
      SAVE498 = CHEM(34)
      CHEM(34) = CHEM(34)+0.2200000000000000d+00*W(113)
      SAVE499 = CHEM(49)
      CHEM(49) = CHEM(49)-W(113)
      SAVE500 = CHEM(50)
      CHEM(50) = CHEM(50)-W(113)
      SAVE501 = CHEM(52)
      CHEM(52) = CHEM(52)+0.5400000000000000d+00*W(113)
      SAVE502 = CHEM(53)
      CHEM(53) = CHEM(53)+0.1300000000000000d+00*W(113)
      SAVE503 = CHEM(54)
      CHEM(54) = CHEM(54)+0.6000000000000000d+00*W(113)
      SAVE504 = CHEM(57)
      CHEM(57) = CHEM(57)+0.1300000000000000d+00*W(113)
      SAVE505 = CHEM(62)
      CHEM(62) = CHEM(62)+0.7000000000000001d-01*W(113)
      SAVE506 = CHEM(66)
      CHEM(66) = CHEM(66)+0.4000000000000000d+00*W(113)
      SAVE507 = CHEM(69)
      CHEM(69) = CHEM(69)+0.1300000000000000d+00*W(113)
      SAVE508 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2900000000000000d+00*W(113)
      SAVE509 = CHEM(28)
      CHEM(28) = CHEM(28)+0.1100000000000000d+00*W(114)
      SAVE510 = CHEM(34)
      CHEM(34) = CHEM(34)+0.1100000000000000d+00*W(114)
      SAVE511 = CHEM(48)
      CHEM(48) = CHEM(48)-W(114)
      SAVE512 = CHEM(50)
      CHEM(50) = CHEM(50)-W(114)
      SAVE513 = CHEM(51)
      CHEM(51) = CHEM(51)+0.5000000000000000d+00*W(114)
      SAVE514 = CHEM(52)
      CHEM(52) = CHEM(52)+0.6600000000000000d+00*W(114)
      SAVE515 = CHEM(54)
      CHEM(54) = CHEM(54)+0.6200000000000000d+00*W(114)
      SAVE516 = CHEM(57)
      CHEM(57) = CHEM(57)+0.2100000000000000d+00*W(114)
      SAVE517 = CHEM(61)
      CHEM(61) = CHEM(61)+0.1600000000000000d+00*W(114)
      SAVE518 = CHEM(62)
      CHEM(62) = CHEM(62)+0.2100000000000000d+00*W(114)
      SAVE519 = CHEM(69)
      CHEM(69) = CHEM(69)+0.2800000000000000d+00*W(114)
      SAVE520 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2900000000000000d+00*W(114)
      SAVE521 = CHEM(25)
      CHEM(25) = CHEM(25)-W(115)
      SAVE522 = CHEM(26)
      CHEM(26) = CHEM(26)+0.3000000000000000d+00*W(115)
      SAVE523 = CHEM(34)
      CHEM(34) = CHEM(34)+0.1100000000000000d+00*W(115)
      SAVE524 = CHEM(50)
      CHEM(50) = CHEM(50)-W(115)
      SAVE525 = CHEM(52)
      CHEM(52) = CHEM(52)+0.1300000000000000d+00*W(115)
      SAVE526 = CHEM(62)
      CHEM(62) = CHEM(62)+0.3600000000000000d-01*W(115)
      SAVE527 = CHEM(66)
      CHEM(66) = CHEM(66)+0.7000000000000000d+00*W(115)
      SAVE528 = CHEM(69)
      CHEM(69) = CHEM(69)+0.7000000000000000d+00*W(115)
      SAVE529 = CHEM(71)
      CHEM(71) = CHEM(71)+0.8000000000000000d-01*W(115)
      SAVE530 = CHEM(72)
      CHEM(72) = CHEM(72)+0.7000000000000000d+00*W(115)
      SAVE531 = CHEM(29)
      CHEM(29) = CHEM(29)-W(116)
      SAVE532 = CHEM(30)
      CHEM(30) = CHEM(30)+0.1000000000000000d+00*W(116)
      SAVE533 = CHEM(70)
      CHEM(70) = CHEM(70)+W(116)
      SAVE534 = CHEM(72)
      CHEM(72) = CHEM(72)-W(116)
      SAVE535 = CHEM(29)
      CHEM(29) = CHEM(29)-W(117)
      SAVE536 = CHEM(30)
      CHEM(30) = CHEM(30)+W(117)
      SAVE537 = CHEM(71)
      CHEM(71) = CHEM(71)-W(117)
      SAVE538 = CHEM(17)
      CHEM(17) = CHEM(17)-W(118)
      SAVE539 = CHEM(23)
      CHEM(23) = CHEM(23)+W(118)
      SAVE540 = CHEM(30)
      CHEM(30) = CHEM(30)+W(118)
      SAVE541 = CHEM(72)
      CHEM(72) = CHEM(72)-W(118)
      SAVE542 = CHEM(17)
      CHEM(17) = CHEM(17)-W(119)
      SAVE543 = CHEM(30)
      CHEM(30) = CHEM(30)+0.2000000000000000d-01*W(119)
      SAVE544 = CHEM(31)
      CHEM(31) = CHEM(31)+0.9800000000000000d+00*W(119)
      SAVE545 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2000000000000000d-01*W(119)
      SAVE546 = CHEM(17)
      CHEM(17) = CHEM(17)-W(120)
      SAVE547 = CHEM(30)
      CHEM(30) = CHEM(30)+W(120)
      SAVE548 = CHEM(50)
      CHEM(50) = CHEM(50)-W(120)
      SAVE549 = CHEM(62)
      CHEM(62) = CHEM(62)+W(120)
      SAVE550 = CHEM(18)
      CHEM(18) = CHEM(18)-W(121)
      SAVE551 = CHEM(23)
      CHEM(23) = CHEM(23)+W(121)
      SAVE552 = CHEM(30)
      CHEM(30) = CHEM(30)+W(121)
      SAVE553 = CHEM(72)
      CHEM(72) = CHEM(72)-W(121)
      SAVE554 = CHEM(18)
      CHEM(18) = CHEM(18)-W(122)
      SAVE555 = CHEM(30)
      CHEM(30) = CHEM(30)+0.2000000000000000d-01*W(122)
      SAVE556 = CHEM(32)
      CHEM(32) = CHEM(32)+0.9800000000000000d+00*W(122)
      SAVE557 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2000000000000000d-01*W(122)
      SAVE558 = CHEM(18)
      CHEM(18) = CHEM(18)-W(123)
      SAVE559 = CHEM(30)
      CHEM(30) = CHEM(30)+W(123)
      SAVE560 = CHEM(50)
      CHEM(50) = CHEM(50)-W(123)
      SAVE561 = CHEM(62)
      CHEM(62) = CHEM(62)+W(123)
      SAVE562 = CHEM(22)
      CHEM(22) = CHEM(22)-W(124)
      SAVE563 = CHEM(23)
      CHEM(23) = CHEM(23)+W(124)
      SAVE564 = CHEM(30)
      CHEM(30) = CHEM(30)+W(124)
      SAVE565 = CHEM(72)
      CHEM(72) = CHEM(72)-W(124)
      SAVE566 = CHEM(22)
      CHEM(22) = CHEM(22)-W(125)
      SAVE567 = CHEM(30)
      CHEM(30) = CHEM(30)+0.2000000000000000d-01*W(125)
      SAVE568 = CHEM(33)
      CHEM(33) = CHEM(33)+0.9800000000000000d+00*W(125)
      SAVE569 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2000000000000000d-01*W(125)
      SAVE570 = CHEM(22)
      CHEM(22) = CHEM(22)-W(126)
      SAVE571 = CHEM(30)
      CHEM(30) = CHEM(30)+W(126)
      SAVE572 = CHEM(50)
      CHEM(50) = CHEM(50)-W(126)
      SAVE573 = CHEM(62)
      CHEM(62) = CHEM(62)+W(126)
      SAVE574 = CHEM(26)
      CHEM(26) = CHEM(26)+W(127)
      SAVE575 = CHEM(69)
      CHEM(69) = CHEM(69)-W(127)
      SAVE576 = CHEM(72)
      CHEM(72) = CHEM(72)-W(127)
      SAVE577 = CHEM(26)
      CHEM(26) = CHEM(26)-W(128)
      SAVE578 = CHEM(69)
      CHEM(69) = CHEM(69)+W(128)
      SAVE579 = CHEM(72)
      CHEM(72) = CHEM(72)+W(128)
      SAVE580 = CHEM(25)
      CHEM(25) = CHEM(25)+W(129)
      SAVE581 = CHEM(56)
      CHEM(56) = CHEM(56)-W(129)
      SAVE582 = CHEM(72)
      CHEM(72) = CHEM(72)-W(129)
      SAVE583 = CHEM(25)
      CHEM(25) = CHEM(25)-W(130)
      SAVE584 = CHEM(56)
      CHEM(56) = CHEM(56)+W(130)
      SAVE585 = CHEM(72)
      CHEM(72) = CHEM(72)+W(130)
      SAVE586 = CHEM(63)
      CHEM(63) = CHEM(63)-W(131)
      SAVE587 = CHEM(66)
      CHEM(66) = CHEM(66)+W(131)
      SAVE588 = CHEM(67)
      CHEM(67) = CHEM(67)-W(131)
      SAVE589 = CHEM(71)
      CHEM(71) = CHEM(71)+W(131)
      SAVE590 = CHEM(72)
      CHEM(72) = CHEM(72)+W(131)
      SAVE591 = CHEM(60)
      CHEM(60) = CHEM(60)-W(132)
      SAVE592 = CHEM(61)
      CHEM(61) = CHEM(61)+W(132)
      SAVE593 = CHEM(67)
      CHEM(67) = CHEM(67)-W(132)
      SAVE594 = CHEM(71)
      CHEM(71) = CHEM(71)+W(132)
      SAVE595 = CHEM(72)
      CHEM(72) = CHEM(72)+W(132)
      SAVE596 = CHEM(51)
      CHEM(51) = CHEM(51)+0.6300000000000000d-01*W(133)
      SAVE597 = CHEM(59)
      CHEM(59) = CHEM(59)+0.6230000000000000d+00*W(133)
      SAVE598 = CHEM(60)
      CHEM(60) = CHEM(60)+0.4800000000000000d-01*W(133)
      SAVE599 = CHEM(61)
      CHEM(61) = CHEM(61)+0.2330000000000000d+00*W(133)
      SAVE600 = CHEM(63)
      CHEM(63) = CHEM(63)+0.1500000000000000d+00*W(133)
      SAVE601 = CHEM(64)
      CHEM(64) = CHEM(64)-W(133)
      SAVE602 = CHEM(65)
      CHEM(65) = CHEM(65)+0.4800000000000000d-01*W(133)
      SAVE603 = CHEM(66)
      CHEM(66) = CHEM(66)+0.4700000000000000d-01*W(133)
      SAVE604 = CHEM(67)
      CHEM(67) = CHEM(67)-W(133)
      SAVE605 = CHEM(70)
      CHEM(70) = CHEM(70)+0.5900000000000000d-01*W(133)
      SAVE606 = CHEM(71)
      CHEM(71) = CHEM(71)+0.7420000000000000d+00*W(133)
      SAVE607 = CHEM(72)
      CHEM(72) = CHEM(72)+0.9409999999999999d+00*W(133)
      SAVE608 = CHEM(36)
      CHEM(36) = CHEM(36)-W(134)
      SAVE609 = CHEM(59)
      CHEM(59) = CHEM(59)+0.7220000000000000d+00*W(134)
      SAVE610 = CHEM(60)
      CHEM(60) = CHEM(60)+0.2450000000000000d+00*W(134)
      SAVE611 = CHEM(61)
      CHEM(61) = CHEM(61)+0.2110000000000000d+00*W(134)
      SAVE612 = CHEM(63)
      CHEM(63) = CHEM(63)+0.3100000000000000d-01*W(134)
      SAVE613 = CHEM(65)
      CHEM(65) = CHEM(65)+0.3340000000000000d+00*W(134)
      SAVE614 = CHEM(66)
      CHEM(66) = CHEM(66)+0.2100000000000000d-01*W(134)
      SAVE615 = CHEM(67)
      CHEM(67) = CHEM(67)-W(134)
      SAVE616 = CHEM(70)
      CHEM(70) = CHEM(70)+0.1240000000000000d+00*W(134)
      SAVE617 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5990000000000000d+00*W(134)
      SAVE618 = CHEM(72)
      CHEM(72) = CHEM(72)+0.8760000000000000d+00*W(134)
      SAVE619 = CHEM(37)
      CHEM(37) = CHEM(37)-W(135)
      SAVE620 = CHEM(59)
      CHEM(59) = CHEM(59)+0.6420000000000000d+00*W(135)
      SAVE621 = CHEM(60)
      CHEM(60) = CHEM(60)+0.1330000000000000d+00*W(135)
      SAVE622 = CHEM(61)
      CHEM(61) = CHEM(61)+0.1500000000000000d+00*W(135)
      SAVE623 = CHEM(65)
      CHEM(65) = CHEM(65)+0.4160000000000000d+00*W(135)
      SAVE624 = CHEM(67)
      CHEM(67) = CHEM(67)-W(135)
      SAVE625 = CHEM(70)
      CHEM(70) = CHEM(70)+0.2610000000000000d+00*W(135)
      SAVE626 = CHEM(71)
      CHEM(71) = CHEM(71)+0.6060000000000000d+00*W(135)
      SAVE627 = CHEM(72)
      CHEM(72) = CHEM(72)+0.7390000000000000d+00*W(135)
      SAVE628 = CHEM(38)
      CHEM(38) = CHEM(38)-W(136)
      SAVE629 = CHEM(61)
      CHEM(61) = CHEM(61)+0.2000000000000000d+00*W(136)
      SAVE630 = CHEM(66)
      CHEM(66) = CHEM(66)+0.1600000000000000d+01*W(136)
      SAVE631 = CHEM(67)
      CHEM(67) = CHEM(67)-W(136)
      SAVE632 = CHEM(71)
      CHEM(71) = CHEM(71)+W(136)
      SAVE633 = CHEM(72)
      CHEM(72) = CHEM(72)+W(136)
      SAVE634 = CHEM(41)
      CHEM(41) = CHEM(41)-W(137)
      SAVE635 = CHEM(59)
      CHEM(59) = CHEM(59)+0.6000000000000000d-01*W(137)
      SAVE636 = CHEM(61)
      CHEM(61) = CHEM(61)+0.9399999999999999d+00*W(137)
      SAVE637 = CHEM(66)
      CHEM(66) = CHEM(66)+W(137)
      SAVE638 = CHEM(67)
      CHEM(67) = CHEM(67)-W(137)
      SAVE639 = CHEM(71)
      CHEM(71) = CHEM(71)+W(137)
      SAVE640 = CHEM(72)
      CHEM(72) = CHEM(72)+W(137)
      SAVE641 = CHEM(45)
      CHEM(45) = CHEM(45)-W(138)
      SAVE642 = CHEM(59)
      CHEM(59) = CHEM(59)+0.2900000000000000d+00*W(138)
      SAVE643 = CHEM(61)
      CHEM(61) = CHEM(61)+0.1710000000000000d+01*W(138)
      SAVE644 = CHEM(67)
      CHEM(67) = CHEM(67)-W(138)
      SAVE645 = CHEM(71)
      CHEM(71) = CHEM(71)+W(138)
      SAVE646 = CHEM(72)
      CHEM(72) = CHEM(72)+W(138)
      SAVE647 = CHEM(39)
      CHEM(39) = CHEM(39)-W(139)
      SAVE648 = CHEM(40)
      CHEM(40) = CHEM(40)+0.3540000000000000d+00*W(139)
      SAVE649 = CHEM(49)
      CHEM(49) = CHEM(49)+0.4460000000000000d+00*W(139)
      SAVE650 = CHEM(66)
      CHEM(66) = CHEM(66)+0.6060000000000000d+00*W(139)
      SAVE651 = CHEM(67)
      CHEM(67) = CHEM(67)-W(139)
      SAVE652 = CHEM(70)
      CHEM(70) = CHEM(70)+0.1530000000000000d+00*W(139)
      SAVE653 = CHEM(71)
      CHEM(71) = CHEM(71)+0.8470000000000000d+00*W(139)
      SAVE654 = CHEM(72)
      CHEM(72) = CHEM(72)+0.8470000000000000d+00*W(139)
      SAVE655 = CHEM(42)
      CHEM(42) = CHEM(42)-W(140)
      SAVE656 = CHEM(59)
      CHEM(59) = CHEM(59)+0.8000000000000000d+00*W(140)
      SAVE657 = CHEM(61)
      CHEM(61) = CHEM(61)+0.8000000000000000d+00*W(140)
      SAVE658 = CHEM(67)
      CHEM(67) = CHEM(67)-W(140)
      SAVE659 = CHEM(70)
      CHEM(70) = CHEM(70)+0.2000000000000000d+00*W(140)
      SAVE660 = CHEM(71)
      CHEM(71) = CHEM(71)+0.8000000000000000d+00*W(140)
      SAVE661 = CHEM(72)
      CHEM(72) = CHEM(72)+0.8000000000000000d+00*W(140)
      SAVE662 = CHEM(43)
      CHEM(43) = CHEM(43)-W(141)
      SAVE663 = CHEM(44)
      CHEM(44) = CHEM(44)+0.2500000000000000d+00*W(141)
      SAVE664 = CHEM(49)
      CHEM(49) = CHEM(49)+0.4000000000000000d+00*W(141)
      SAVE665 = CHEM(66)
      CHEM(66) = CHEM(66)+0.2500000000000000d+00*W(141)
      SAVE666 = CHEM(67)
      CHEM(67) = CHEM(67)-W(141)
      SAVE667 = CHEM(70)
      CHEM(70) = CHEM(70)+0.3500000000000000d+00*W(141)
      SAVE668 = CHEM(71)
      CHEM(71) = CHEM(71)+0.6500000000000000d+00*W(141)
      SAVE669 = CHEM(72)
      CHEM(72) = CHEM(72)+0.6500000000000000d+00*W(141)
      SAVE670 = CHEM(31)
      CHEM(31) = CHEM(31)-W(142)
      SAVE671 = CHEM(48)
      CHEM(48) = CHEM(48)+0.5000000000000000d+00*W(142)
      SAVE672 = CHEM(51)
      CHEM(51) = CHEM(51)+0.1200000000000000d+01*W(142)
      SAVE673 = CHEM(54)
      CHEM(54) = CHEM(54)+0.6500000000000000d+00*W(142)
      SAVE674 = CHEM(67)
      CHEM(67) = CHEM(67)-W(142)
      SAVE675 = CHEM(70)
      CHEM(70) = CHEM(70)+0.5000000000000000d-01*W(142)
      SAVE676 = CHEM(71)
      CHEM(71) = CHEM(71)+0.9500000000000000d+00*W(142)
      SAVE677 = CHEM(72)
      CHEM(72) = CHEM(72)+0.9500000000000000d+00*W(142)
      SAVE678 = CHEM(32)
      CHEM(32) = CHEM(32)-W(143)
      SAVE679 = CHEM(48)
      CHEM(48) = CHEM(48)+0.9500000000000000d+00*W(143)
      SAVE680 = CHEM(51)
      CHEM(51) = CHEM(51)+0.3500000000000000d+00*W(143)
      SAVE681 = CHEM(54)
      CHEM(54) = CHEM(54)+0.6000000000000000d+00*W(143)
      SAVE682 = CHEM(67)
      CHEM(67) = CHEM(67)-W(143)
      SAVE683 = CHEM(70)
      CHEM(70) = CHEM(70)+0.5000000000000000d-01*W(143)
      SAVE684 = CHEM(71)
      CHEM(71) = CHEM(71)+0.9500000000000000d+00*W(143)
      SAVE685 = CHEM(72)
      CHEM(72) = CHEM(72)+0.9500000000000000d+00*W(143)
      SAVE686 = CHEM(33)
      CHEM(33) = CHEM(33)-W(144)
      SAVE687 = CHEM(51)
      CHEM(51) = CHEM(51)+W(144)
      SAVE688 = CHEM(54)
      CHEM(54) = CHEM(54)+W(144)
      SAVE689 = CHEM(67)
      CHEM(67) = CHEM(67)-W(144)
      SAVE690 = CHEM(71)
      CHEM(71) = CHEM(71)+W(144)
      SAVE691 = CHEM(72)
      CHEM(72) = CHEM(72)+W(144)
      SAVE692 = CHEM(63)
      CHEM(63) = CHEM(63)+W(145)
      SAVE693 = CHEM(67)
      CHEM(67) = CHEM(67)-W(145)
      SAVE694 = CHEM(69)
      CHEM(69) = CHEM(69)-W(145)
      SAVE695 = CHEM(72)
      CHEM(72) = CHEM(72)+W(145)
      SAVE696 = CHEM(56)
      CHEM(56) = CHEM(56)-W(146)
      SAVE697 = CHEM(66)
      CHEM(66) = CHEM(66)+W(146)
      SAVE698 = CHEM(67)
      CHEM(67) = CHEM(67)-W(146)
      SAVE699 = CHEM(69)
      CHEM(69) = CHEM(69)+W(146)
      SAVE700 = CHEM(72)
      CHEM(72) = CHEM(72)+W(146)
      SAVE701 = CHEM(54)
      CHEM(54) = CHEM(54)+0.5400000000000000d+00*W(147)
      SAVE702 = CHEM(58)
      CHEM(58) = CHEM(58)-W(147)
      SAVE703 = CHEM(61)
      CHEM(61) = CHEM(61)+0.4600000000000000d+00*W(147)
      SAVE704 = CHEM(65)
      CHEM(65) = CHEM(65)+0.1600000000000000d+00*W(147)
      SAVE705 = CHEM(67)
      CHEM(67) = CHEM(67)-W(147)
      SAVE706 = CHEM(69)
      CHEM(69) = CHEM(69)+0.2300000000000000d+00*W(147)
      SAVE707 = CHEM(71)
      CHEM(71) = CHEM(71)+0.7700000000000000d+00*W(147)
      SAVE708 = CHEM(72)
      CHEM(72) = CHEM(72)+W(147)
      SAVE709 = CHEM(47)
      CHEM(47) = CHEM(47)-W(148)
      SAVE710 = CHEM(67)
      CHEM(67) = CHEM(67)-W(148)
      SAVE711 = CHEM(70)
      CHEM(70) = CHEM(70)+W(148)
      SAVE712 = CHEM(71)
      CHEM(71) = CHEM(71)+W(148)
      SAVE713 = CHEM(72)
      CHEM(72) = CHEM(72)+W(148)
      SAVE714 = CHEM(46)
      CHEM(46) = CHEM(46)-W(149)
      SAVE715 = CHEM(59)
      CHEM(59) = CHEM(59)+0.4640000000000000d+00*W(149)
      SAVE716 = CHEM(61)
      CHEM(61) = CHEM(61)+0.1240000000000000d+01*W(149)
      SAVE717 = CHEM(66)
      CHEM(66) = CHEM(66)+0.2870000000000000d+00*W(149)
      SAVE718 = CHEM(67)
      CHEM(67) = CHEM(67)-W(149)
      SAVE719 = CHEM(72)
      CHEM(72) = CHEM(72)+0.2000000000000000d+01*W(149)
      SAVE720 = CHEM(16)
      CHEM(16) = CHEM(16)+W(150)
      SAVE721 = CHEM(63)
      CHEM(63) = CHEM(63)-W(150)
      SAVE722 = CHEM(71)
      CHEM(71) = CHEM(71)-W(150)
      SAVE723 = CHEM(53)
      CHEM(53) = CHEM(53)+W(151)
      SAVE724 = CHEM(60)
      CHEM(60) = CHEM(60)-W(151)
      SAVE725 = CHEM(71)
      CHEM(71) = CHEM(71)-W(151)
      SAVE726 = CHEM(53)
      CHEM(53) = CHEM(53)+W(152)
      SAVE727 = CHEM(64)
      CHEM(64) = CHEM(64)-W(152)
      SAVE728 = CHEM(71)
      CHEM(71) = CHEM(71)-W(152)
      SAVE729 = CHEM(36)
      CHEM(36) = CHEM(36)-W(153)
      SAVE730 = CHEM(53)
      CHEM(53) = CHEM(53)+W(153)
      SAVE731 = CHEM(71)
      CHEM(71) = CHEM(71)-W(153)
      SAVE732 = CHEM(37)
      CHEM(37) = CHEM(37)-W(154)
      SAVE733 = CHEM(53)
      CHEM(53) = CHEM(53)+W(154)
      SAVE734 = CHEM(71)
      CHEM(71) = CHEM(71)-W(154)
      SAVE735 = CHEM(38)
      CHEM(38) = CHEM(38)-W(155)
      SAVE736 = CHEM(53)
      CHEM(53) = CHEM(53)+W(155)
      SAVE737 = CHEM(71)
      CHEM(71) = CHEM(71)-W(155)
      SAVE738 = CHEM(41)
      CHEM(41) = CHEM(41)-W(156)
      SAVE739 = CHEM(53)
      CHEM(53) = CHEM(53)+W(156)
      SAVE740 = CHEM(71)
      CHEM(71) = CHEM(71)-W(156)
      SAVE741 = CHEM(45)
      CHEM(45) = CHEM(45)-W(157)
      SAVE742 = CHEM(53)
      CHEM(53) = CHEM(53)+W(157)
      SAVE743 = CHEM(71)
      CHEM(71) = CHEM(71)-W(157)
      SAVE744 = CHEM(39)
      CHEM(39) = CHEM(39)-W(158)
      SAVE745 = CHEM(53)
      CHEM(53) = CHEM(53)+W(158)
      SAVE746 = CHEM(71)
      CHEM(71) = CHEM(71)-W(158)
      SAVE747 = CHEM(42)
      CHEM(42) = CHEM(42)-W(159)
      SAVE748 = CHEM(53)
      CHEM(53) = CHEM(53)+W(159)
      SAVE749 = CHEM(71)
      CHEM(71) = CHEM(71)-W(159)
      SAVE750 = CHEM(43)
      CHEM(43) = CHEM(43)-W(160)
      SAVE751 = CHEM(53)
      CHEM(53) = CHEM(53)+W(160)
      SAVE752 = CHEM(71)
      CHEM(71) = CHEM(71)-W(160)
      SAVE753 = CHEM(31)
      CHEM(31) = CHEM(31)-W(161)
      SAVE754 = CHEM(53)
      CHEM(53) = CHEM(53)+W(161)
      SAVE755 = CHEM(71)
      CHEM(71) = CHEM(71)-W(161)
      SAVE756 = CHEM(32)
      CHEM(32) = CHEM(32)-W(162)
      SAVE757 = CHEM(53)
      CHEM(53) = CHEM(53)+W(162)
      SAVE758 = CHEM(71)
      CHEM(71) = CHEM(71)-W(162)
      SAVE759 = CHEM(33)
      CHEM(33) = CHEM(33)-W(163)
      SAVE760 = CHEM(53)
      CHEM(53) = CHEM(53)+W(163)
      SAVE761 = CHEM(71)
      CHEM(71) = CHEM(71)-W(163)
      SAVE762 = CHEM(28)
      CHEM(28) = CHEM(28)+W(164)
      SAVE763 = CHEM(69)
      CHEM(69) = CHEM(69)-W(164)
      SAVE764 = CHEM(71)
      CHEM(71) = CHEM(71)-W(164)
      SAVE765 = CHEM(50)
      CHEM(50) = CHEM(50)+W(165)
      SAVE766 = CHEM(57)
      CHEM(57) = CHEM(57)+W(165)
      SAVE767 = CHEM(69)
      CHEM(69) = CHEM(69)-W(165)
      SAVE768 = CHEM(71)
      CHEM(71) = CHEM(71)-W(165)
      SAVE769 = CHEM(53)
      CHEM(53) = CHEM(53)+W(166)
      SAVE770 = CHEM(56)
      CHEM(56) = CHEM(56)-W(166)
      SAVE771 = CHEM(71)
      CHEM(71) = CHEM(71)-W(166)
      SAVE772 = CHEM(50)
      CHEM(50) = CHEM(50)+W(167)
      SAVE773 = CHEM(56)
      CHEM(56) = CHEM(56)-W(167)
      SAVE774 = CHEM(57)
      CHEM(57) = CHEM(57)+W(167)
      SAVE775 = CHEM(71)
      CHEM(71) = CHEM(71)-W(167)
      SAVE776 = CHEM(53)
      CHEM(53) = CHEM(53)+W(168)
      SAVE777 = CHEM(58)
      CHEM(58) = CHEM(58)-W(168)
      SAVE778 = CHEM(71)
      CHEM(71) = CHEM(71)-W(168)
      SAVE779 = CHEM(47)
      CHEM(47) = CHEM(47)-W(169)
      SAVE780 = CHEM(70)
      CHEM(70) = CHEM(70)+W(169)
      SAVE781 = CHEM(71)
      CHEM(71) = CHEM(71)-W(169)
      SAVE782 = CHEM(46)
      CHEM(46) = CHEM(46)-W(170)
      SAVE783 = CHEM(70)
      CHEM(70) = CHEM(70)+W(170)
      SAVE784 = CHEM(71)
      CHEM(71) = CHEM(71)-W(170)
      SAVE785 = CHEM(63)
      CHEM(63) = CHEM(63)-0.2000000000000000d+01*W(171)
      SAVE786 = CHEM(66)
      CHEM(66) = CHEM(66)+0.1330000000000000d+01*W(171)
      SAVE787 = CHEM(71)
      CHEM(71) = CHEM(71)+0.6600000000000000d+00*W(171)
      SAVE788 = CHEM(60)
      CHEM(60) = CHEM(60)-W(172)
      SAVE789 = CHEM(61)
      CHEM(61) = CHEM(61)+0.7500000000000000d+00*W(172)
      SAVE790 = CHEM(63)
      CHEM(63) = CHEM(63)-W(172)
      SAVE791 = CHEM(66)
      CHEM(66) = CHEM(66)+0.7500000000000000d+00*W(172)
      SAVE792 = CHEM(71)
      CHEM(71) = CHEM(71)+W(172)
      SAVE793 = CHEM(51)
      CHEM(51) = CHEM(51)+0.1190000000000000d+00*W(173)
      SAVE794 = CHEM(54)
      CHEM(54) = CHEM(54)+0.5000000000000000d-02*W(173)
      SAVE795 = CHEM(59)
      CHEM(59) = CHEM(59)+0.1800000000000000d-01*W(173)
      SAVE796 = CHEM(61)
      CHEM(61) = CHEM(61)+0.5800000000000000d+00*W(173)
      SAVE797 = CHEM(63)
      CHEM(63) = CHEM(63)-0.9930000000000000d+00*W(173)
      SAVE798 = CHEM(64)
      CHEM(64) = CHEM(64)-W(173)
      SAVE799 = CHEM(65)
      CHEM(65) = CHEM(65)+0.8500000000000001d-01*W(173)
      SAVE800 = CHEM(66)
      CHEM(66) = CHEM(66)+0.8100000000000001d+00*W(173)
      SAVE801 = CHEM(71)
      CHEM(71) = CHEM(71)+0.9920000000000000d+00*W(173)
      SAVE802 = CHEM(36)
      CHEM(36) = CHEM(36)-W(174)
      SAVE803 = CHEM(59)
      CHEM(59) = CHEM(59)+0.2400000000000000d+00*W(174)
      SAVE804 = CHEM(60)
      CHEM(60) = CHEM(60)+0.1400000000000000d-01*W(174)
      SAVE805 = CHEM(61)
      CHEM(61) = CHEM(61)+0.5230000000000000d+00*W(174)
      SAVE806 = CHEM(63)
      CHEM(63) = CHEM(63)-0.9510000000000000d+00*W(174)
      SAVE807 = CHEM(65)
      CHEM(65) = CHEM(65)+0.2450000000000000d+00*W(174)
      SAVE808 = CHEM(66)
      CHEM(66) = CHEM(66)+0.8290000000000000d+00*W(174)
      SAVE809 = CHEM(71)
      CHEM(71) = CHEM(71)+0.9460000000000000d+00*W(174)
      SAVE810 = CHEM(37)
      CHEM(37) = CHEM(37)-W(175)
      SAVE811 = CHEM(59)
      CHEM(59) = CHEM(59)+0.4190000000000000d+00*W(175)
      SAVE812 = CHEM(60)
      CHEM(60) = CHEM(60)+0.1300000000000000d-01*W(175)
      SAVE813 = CHEM(61)
      CHEM(61) = CHEM(61)+0.4110000000000000d+00*W(175)
      SAVE814 = CHEM(63)
      CHEM(63) = CHEM(63)-W(175)
      SAVE815 = CHEM(65)
      CHEM(65) = CHEM(65)+0.3220000000000000d+00*W(175)
      SAVE816 = CHEM(66)
      CHEM(66) = CHEM(66)+0.7530000000000000d+00*W(175)
      SAVE817 = CHEM(71)
      CHEM(71) = CHEM(71)+0.9930000000000000d+00*W(175)
      SAVE818 = CHEM(38)
      CHEM(38) = CHEM(38)-W(176)
      SAVE819 = CHEM(61)
      CHEM(61) = CHEM(61)+0.3500000000000000d+00*W(176)
      SAVE820 = CHEM(63)
      CHEM(63) = CHEM(63)-W(176)
      SAVE821 = CHEM(66)
      CHEM(66) = CHEM(66)+0.1550000000000000d+01*W(176)
      SAVE822 = CHEM(71)
      CHEM(71) = CHEM(71)+W(176)
      SAVE823 = CHEM(41)
      CHEM(41) = CHEM(41)-W(177)
      SAVE824 = CHEM(59)
      CHEM(59) = CHEM(59)+0.8100000000000000d-01*W(177)
      SAVE825 = CHEM(61)
      CHEM(61) = CHEM(61)+0.6690000000000000d+00*W(177)
      SAVE826 = CHEM(63)
      CHEM(63) = CHEM(63)-W(177)
      SAVE827 = CHEM(66)
      CHEM(66) = CHEM(66)+0.1250000000000000d+01*W(177)
      SAVE828 = CHEM(71)
      CHEM(71) = CHEM(71)+W(177)
      SAVE829 = CHEM(45)
      CHEM(45) = CHEM(45)-W(178)
      SAVE830 = CHEM(59)
      CHEM(59) = CHEM(59)+0.3130000000000000d+00*W(178)
      SAVE831 = CHEM(61)
      CHEM(61) = CHEM(61)+0.9320000000000001d+00*W(178)
      SAVE832 = CHEM(63)
      CHEM(63) = CHEM(63)-W(178)
      SAVE833 = CHEM(66)
      CHEM(66) = CHEM(66)+0.7550000000000000d+00*W(178)
      SAVE834 = CHEM(71)
      CHEM(71) = CHEM(71)+W(178)
      SAVE835 = CHEM(39)
      CHEM(39) = CHEM(39)-W(179)
      SAVE836 = CHEM(40)
      CHEM(40) = CHEM(40)+0.3700000000000000d+00*W(179)
      SAVE837 = CHEM(44)
      CHEM(44) = CHEM(44)+0.8000000000000000d-01*W(179)
      SAVE838 = CHEM(49)
      CHEM(49) = CHEM(49)+0.5500000000000000d+00*W(179)
      SAVE839 = CHEM(63)
      CHEM(63) = CHEM(63)-W(179)
      SAVE840 = CHEM(66)
      CHEM(66) = CHEM(66)+0.1090000000000000d+01*W(179)
      SAVE841 = CHEM(71)
      CHEM(71) = CHEM(71)+W(179)
      SAVE842 = CHEM(42)
      CHEM(42) = CHEM(42)-W(180)
      SAVE843 = CHEM(59)
      CHEM(59) = CHEM(59)+W(180)
      SAVE844 = CHEM(61)
      CHEM(61) = CHEM(61)+W(180)
      SAVE845 = CHEM(63)
      CHEM(63) = CHEM(63)-W(180)
      SAVE846 = CHEM(66)
      CHEM(66) = CHEM(66)+W(180)
      SAVE847 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2000000000000000d+01*W(180)
      SAVE848 = CHEM(43)
      CHEM(43) = CHEM(43)-W(181)
      SAVE849 = CHEM(44)
      CHEM(44) = CHEM(44)+0.4000000000000000d+00*W(181)
      SAVE850 = CHEM(49)
      CHEM(49) = CHEM(49)+0.6000000000000000d+00*W(181)
      SAVE851 = CHEM(63)
      CHEM(63) = CHEM(63)-W(181)
      SAVE852 = CHEM(66)
      CHEM(66) = CHEM(66)+0.1400000000000000d+01*W(181)
      SAVE853 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2000000000000000d+01*W(181)
      SAVE854 = CHEM(31)
      CHEM(31) = CHEM(31)-W(182)
      SAVE855 = CHEM(48)
      CHEM(48) = CHEM(48)+W(182)
      SAVE856 = CHEM(51)
      CHEM(51) = CHEM(51)+0.6500000000000000d+00*W(182)
      SAVE857 = CHEM(54)
      CHEM(54) = CHEM(54)+0.3500000000000000d+00*W(182)
      SAVE858 = CHEM(63)
      CHEM(63) = CHEM(63)-W(182)
      SAVE859 = CHEM(66)
      CHEM(66) = CHEM(66)+W(182)
      SAVE860 = CHEM(71)
      CHEM(71) = CHEM(71)+W(182)
      SAVE861 = CHEM(32)
      CHEM(32) = CHEM(32)-W(183)
      SAVE862 = CHEM(48)
      CHEM(48) = CHEM(48)+W(183)
      SAVE863 = CHEM(51)
      CHEM(51) = CHEM(51)+0.3700000000000000d+00*W(183)
      SAVE864 = CHEM(54)
      CHEM(54) = CHEM(54)+0.6300000000000000d+00*W(183)
      SAVE865 = CHEM(63)
      CHEM(63) = CHEM(63)-W(183)
      SAVE866 = CHEM(66)
      CHEM(66) = CHEM(66)+W(183)
      SAVE867 = CHEM(71)
      CHEM(71) = CHEM(71)+W(183)
      SAVE868 = CHEM(33)
      CHEM(33) = CHEM(33)-W(184)
      SAVE869 = CHEM(51)
      CHEM(51) = CHEM(51)+W(184)
      SAVE870 = CHEM(54)
      CHEM(54) = CHEM(54)+W(184)
      SAVE871 = CHEM(63)
      CHEM(63) = CHEM(63)-W(184)
      SAVE872 = CHEM(66)
      CHEM(66) = CHEM(66)+W(184)
      SAVE873 = CHEM(71)
      CHEM(71) = CHEM(71)+0.2000000000000000d+01*W(184)
      SAVE874 = CHEM(66)
      CHEM(66) = CHEM(66)+W(185)
      SAVE875 = CHEM(69)
      CHEM(69) = CHEM(69)-W(185)
      SAVE876 = CHEM(71)
      CHEM(71) = CHEM(71)+W(185)
      SAVE877 = CHEM(57)
      CHEM(57) = CHEM(57)+W(186)
      SAVE878 = CHEM(63)
      CHEM(63) = CHEM(63)-W(186)
      SAVE879 = CHEM(66)
      CHEM(66) = CHEM(66)+W(186)
      SAVE880 = CHEM(69)
      CHEM(69) = CHEM(69)-W(186)
      SAVE881 = CHEM(56)
      CHEM(56) = CHEM(56)-W(187)
      SAVE882 = CHEM(63)
      CHEM(63) = CHEM(63)-W(187)
      SAVE883 = CHEM(66)
      CHEM(66) = CHEM(66)+0.2000000000000000d+01*W(187)
      SAVE884 = CHEM(69)
      CHEM(69) = CHEM(69)+W(187)
      SAVE885 = CHEM(71)
      CHEM(71) = CHEM(71)+W(187)
      SAVE886 = CHEM(56)
      CHEM(56) = CHEM(56)-W(188)
      SAVE887 = CHEM(57)
      CHEM(57) = CHEM(57)+W(188)
      SAVE888 = CHEM(63)
      CHEM(63) = CHEM(63)-W(188)
      SAVE889 = CHEM(66)
      CHEM(66) = CHEM(66)+W(188)
      SAVE890 = CHEM(24)
      CHEM(24) = CHEM(24)+0.3000000000000000d+00*W(189)
      SAVE891 = CHEM(54)
      CHEM(54) = CHEM(54)+0.4000000000000000d+00*W(189)
      SAVE892 = CHEM(58)
      CHEM(58) = CHEM(58)-W(189)
      SAVE893 = CHEM(61)
      CHEM(61) = CHEM(61)+0.3000000000000000d+00*W(189)
      SAVE894 = CHEM(63)
      CHEM(63) = CHEM(63)-W(189)
      SAVE895 = CHEM(65)
      CHEM(65) = CHEM(65)+0.8000000000000000d-01*W(189)
      SAVE896 = CHEM(66)
      CHEM(66) = CHEM(66)+0.7500000000000000d+00*W(189)
      SAVE897 = CHEM(69)
      CHEM(69) = CHEM(69)+0.1200000000000000d+00*W(189)
      SAVE898 = CHEM(71)
      CHEM(71) = CHEM(71)+0.8800000000000000d+00*W(189)
      SAVE899 = CHEM(47)
      CHEM(47) = CHEM(47)-W(190)
      SAVE900 = CHEM(63)
      CHEM(63) = CHEM(63)-W(190)
      SAVE901 = CHEM(66)
      CHEM(66) = CHEM(66)+0.7500000000000000d+00*W(190)
      SAVE902 = CHEM(70)
      CHEM(70) = CHEM(70)+W(190)
      SAVE903 = CHEM(71)
      CHEM(71) = CHEM(71)+W(190)
      SAVE904 = CHEM(46)
      CHEM(46) = CHEM(46)-W(191)
      SAVE905 = CHEM(59)
      CHEM(59) = CHEM(59)+0.1490000000000000d+00*W(191)
      SAVE906 = CHEM(61)
      CHEM(61) = CHEM(61)+0.6400000000000000d+00*W(191)
      SAVE907 = CHEM(63)
      CHEM(63) = CHEM(63)-W(191)
      SAVE908 = CHEM(66)
      CHEM(66) = CHEM(66)+0.9600000000000000d+00*W(191)
      SAVE909 = CHEM(70)
      CHEM(70) = CHEM(70)+0.5000000000000000d+00*W(191)
      SAVE910 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5000000000000000d+00*W(191)
      SAVE911 = CHEM(72)
      CHEM(72) = CHEM(72)+0.5000000000000000d+00*W(191)
      SAVE912 = CHEM(57)
      CHEM(57) = CHEM(57)+0.5000000000000000d+00*W(192)
      SAVE913 = CHEM(60)
      CHEM(60) = CHEM(60)-W(192)
      SAVE914 = CHEM(61)
      CHEM(61) = CHEM(61)+W(192)
      SAVE915 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5000000000000000d+00*W(192)
      SAVE916 = CHEM(69)
      CHEM(69) = CHEM(69)-W(192)
      SAVE917 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5000000000000000d+00*W(192)
      SAVE918 = CHEM(51)
      CHEM(51) = CHEM(51)+0.1000000000000000d+00*W(193)
      SAVE919 = CHEM(54)
      CHEM(54) = CHEM(54)+0.4000000000000000d-02*W(193)
      SAVE920 = CHEM(57)
      CHEM(57) = CHEM(57)+0.4990000000000000d+00*W(193)
      SAVE921 = CHEM(59)
      CHEM(59) = CHEM(59)+0.1270000000000000d+00*W(193)
      SAVE922 = CHEM(60)
      CHEM(60) = CHEM(60)+0.6000000000000000d-02*W(193)
      SAVE923 = CHEM(61)
      CHEM(61) = CHEM(61)+0.7240000000000000d+00*W(193)
      SAVE924 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5080000000000000d+00*W(193)
      SAVE925 = CHEM(64)
      CHEM(64) = CHEM(64)-W(193)
      SAVE926 = CHEM(65)
      CHEM(65) = CHEM(65)+0.7099999999999999d-01*W(193)
      SAVE927 = CHEM(66)
      CHEM(66) = CHEM(66)+0.9100000000000000d-01*W(193)
      SAVE928 = CHEM(69)
      CHEM(69) = CHEM(69)-W(193)
      SAVE929 = CHEM(71)
      CHEM(71) = CHEM(71)+0.4880000000000000d+00*W(193)
      SAVE930 = CHEM(36)
      CHEM(36) = CHEM(36)-W(194)
      SAVE931 = CHEM(57)
      CHEM(57) = CHEM(57)+0.4950000000000000d+00*W(194)
      SAVE932 = CHEM(59)
      CHEM(59) = CHEM(59)+0.3300000000000000d+00*W(194)
      SAVE933 = CHEM(60)
      CHEM(60) = CHEM(60)+0.1800000000000000d-01*W(194)
      SAVE934 = CHEM(61)
      CHEM(61) = CHEM(61)+0.6770000000000000d+00*W(194)
      SAVE935 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5540000000000000d+00*W(194)
      SAVE936 = CHEM(65)
      CHEM(65) = CHEM(65)+0.2370000000000000d+00*W(194)
      SAVE937 = CHEM(66)
      CHEM(66) = CHEM(66)+0.7600000000000000d-01*W(194)
      SAVE938 = CHEM(69)
      CHEM(69) = CHEM(69)-W(194)
      SAVE939 = CHEM(71)
      CHEM(71) = CHEM(71)+0.4380000000000000d+00*W(194)
      SAVE940 = CHEM(37)
      CHEM(37) = CHEM(37)-W(195)
      SAVE941 = CHEM(57)
      CHEM(57) = CHEM(57)+0.4950000000000000d+00*W(195)
      SAVE942 = CHEM(59)
      CHEM(59) = CHEM(59)+0.5810000000000000d+00*W(195)
      SAVE943 = CHEM(60)
      CHEM(60) = CHEM(60)+0.1500000000000000d-01*W(195)
      SAVE944 = CHEM(61)
      CHEM(61) = CHEM(61)+0.4970000000000000d+00*W(195)
      SAVE945 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5070000000000000d+00*W(195)
      SAVE946 = CHEM(65)
      CHEM(65) = CHEM(65)+0.3180000000000000d+00*W(195)
      SAVE947 = CHEM(69)
      CHEM(69) = CHEM(69)-W(195)
      SAVE948 = CHEM(71)
      CHEM(71) = CHEM(71)+0.4890000000000000d+00*W(195)
      SAVE949 = CHEM(38)
      CHEM(38) = CHEM(38)-W(196)
      SAVE950 = CHEM(57)
      CHEM(57) = CHEM(57)+0.5000000000000000d+00*W(196)
      SAVE951 = CHEM(61)
      CHEM(61) = CHEM(61)+0.6000000000000000d+00*W(196)
      SAVE952 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5000000000000000d+00*W(196)
      SAVE953 = CHEM(66)
      CHEM(66) = CHEM(66)+0.8000000000000000d+00*W(196)
      SAVE954 = CHEM(69)
      CHEM(69) = CHEM(69)-W(196)
      SAVE955 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5000000000000000d+00*W(196)
      SAVE956 = CHEM(41)
      CHEM(41) = CHEM(41)-W(197)
      SAVE957 = CHEM(57)
      CHEM(57) = CHEM(57)+0.4990000000000000d+00*W(197)
      SAVE958 = CHEM(59)
      CHEM(59) = CHEM(59)+0.1410000000000000d+00*W(197)
      SAVE959 = CHEM(61)
      CHEM(61) = CHEM(61)+0.8590000000000000d+00*W(197)
      SAVE960 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5010000000000000d+00*W(197)
      SAVE961 = CHEM(66)
      CHEM(66) = CHEM(66)+0.5010000000000000d+00*W(197)
      SAVE962 = CHEM(69)
      CHEM(69) = CHEM(69)-W(197)
      SAVE963 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5010000000000000d+00*W(197)
      SAVE964 = CHEM(45)
      CHEM(45) = CHEM(45)-W(198)
      SAVE965 = CHEM(57)
      CHEM(57) = CHEM(57)+0.4900000000000000d+00*W(198)
      SAVE966 = CHEM(59)
      CHEM(59) = CHEM(59)+0.5690000000000000d+00*W(198)
      SAVE967 = CHEM(61)
      CHEM(61) = CHEM(61)+0.9409999999999999d+00*W(198)
      SAVE968 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5100000000000000d+00*W(198)
      SAVE969 = CHEM(69)
      CHEM(69) = CHEM(69)-W(198)
      SAVE970 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5100000000000000d+00*W(198)
      SAVE971 = CHEM(39)
      CHEM(39) = CHEM(39)-W(199)
      SAVE972 = CHEM(40)
      CHEM(40) = CHEM(40)+0.2290000000000000d+00*W(199)
      SAVE973 = CHEM(49)
      CHEM(49) = CHEM(49)+0.7710000000000000d+00*W(199)
      SAVE974 = CHEM(57)
      CHEM(57) = CHEM(57)+0.4940000000000000d+00*W(199)
      SAVE975 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5060000000000000d+00*W(199)
      SAVE976 = CHEM(66)
      CHEM(66) = CHEM(66)+0.3400000000000000d+00*W(199)
      SAVE977 = CHEM(69)
      CHEM(69) = CHEM(69)-W(199)
      SAVE978 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5060000000000000d+00*W(199)
      SAVE979 = CHEM(42)
      CHEM(42) = CHEM(42)-W(200)
      SAVE980 = CHEM(59)
      CHEM(59) = CHEM(59)+W(200)
      SAVE981 = CHEM(61)
      CHEM(61) = CHEM(61)+W(200)
      SAVE982 = CHEM(63)
      CHEM(63) = CHEM(63)+W(200)
      SAVE983 = CHEM(69)
      CHEM(69) = CHEM(69)-W(200)
      SAVE984 = CHEM(71)
      CHEM(71) = CHEM(71)+W(200)
      SAVE985 = CHEM(43)
      CHEM(43) = CHEM(43)-W(201)
      SAVE986 = CHEM(44)
      CHEM(44) = CHEM(44)+0.4000000000000000d+00*W(201)
      SAVE987 = CHEM(49)
      CHEM(49) = CHEM(49)+0.6000000000000000d+00*W(201)
      SAVE988 = CHEM(63)
      CHEM(63) = CHEM(63)+W(201)
      SAVE989 = CHEM(66)
      CHEM(66) = CHEM(66)+0.4000000000000000d+00*W(201)
      SAVE990 = CHEM(69)
      CHEM(69) = CHEM(69)-W(201)
      SAVE991 = CHEM(71)
      CHEM(71) = CHEM(71)+W(201)
      SAVE992 = CHEM(31)
      CHEM(31) = CHEM(31)-W(202)
      SAVE993 = CHEM(48)
      CHEM(48) = CHEM(48)+W(202)
      SAVE994 = CHEM(51)
      CHEM(51) = CHEM(51)+0.6500000000000000d+00*W(202)
      SAVE995 = CHEM(54)
      CHEM(54) = CHEM(54)+0.3500000000000000d+00*W(202)
      SAVE996 = CHEM(63)
      CHEM(63) = CHEM(63)+W(202)
      SAVE997 = CHEM(69)
      CHEM(69) = CHEM(69)-W(202)
      SAVE998 = CHEM(71)
      CHEM(71) = CHEM(71)+W(202)
      SAVE999 = CHEM(32)
      CHEM(32) = CHEM(32)-W(203)
      SAVE1000 = CHEM(48)
      CHEM(48) = CHEM(48)+W(203)
      SAVE1001 = CHEM(51)
      CHEM(51) = CHEM(51)+0.3700000000000000d+00*W(203)
      SAVE1002 = CHEM(54)
      CHEM(54) = CHEM(54)+0.6300000000000000d+00*W(203)
      SAVE1003 = CHEM(63)
      CHEM(63) = CHEM(63)+W(203)
      SAVE1004 = CHEM(69)
      CHEM(69) = CHEM(69)-W(203)
      SAVE1005 = CHEM(71)
      CHEM(71) = CHEM(71)+W(203)
      SAVE1006 = CHEM(33)
      CHEM(33) = CHEM(33)-W(204)
      SAVE1007 = CHEM(51)
      CHEM(51) = CHEM(51)+W(204)
      SAVE1008 = CHEM(54)
      CHEM(54) = CHEM(54)+W(204)
      SAVE1009 = CHEM(63)
      CHEM(63) = CHEM(63)+W(204)
      SAVE1010 = CHEM(69)
      CHEM(69) = CHEM(69)-W(204)
      SAVE1011 = CHEM(71)
      CHEM(71) = CHEM(71)+W(204)
      SAVE1012 = CHEM(63)
      CHEM(63) = CHEM(63)+0.2000000000000000d+01*W(205)
      SAVE1013 = CHEM(69)
      CHEM(69) = CHEM(69)-0.2000000000000000d+01*W(205)
      SAVE1014 = CHEM(56)
      CHEM(56) = CHEM(56)-W(206)
      SAVE1015 = CHEM(63)
      CHEM(63) = CHEM(63)+W(206)
      SAVE1016 = CHEM(66)
      CHEM(66) = CHEM(66)+W(206)
      SAVE1017 = CHEM(54)
      CHEM(54) = CHEM(54)+0.5400000000000000d+00*W(207)
      SAVE1018 = CHEM(57)
      CHEM(57) = CHEM(57)+0.5000000000000000d+00*W(207)
      SAVE1019 = CHEM(58)
      CHEM(58) = CHEM(58)-W(207)
      SAVE1020 = CHEM(59)
      CHEM(59) = CHEM(59)+0.1100000000000000d+00*W(207)
      SAVE1021 = CHEM(61)
      CHEM(61) = CHEM(61)+0.3500000000000000d+00*W(207)
      SAVE1022 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5000000000000000d+00*W(207)
      SAVE1023 = CHEM(65)
      CHEM(65) = CHEM(65)+0.8000000000000000d-01*W(207)
      SAVE1024 = CHEM(69)
      CHEM(69) = CHEM(69)-0.8800000000000000d+00*W(207)
      SAVE1025 = CHEM(71)
      CHEM(71) = CHEM(71)+0.3800000000000000d+00*W(207)
      SAVE1026 = CHEM(47)
      CHEM(47) = CHEM(47)-W(208)
      SAVE1027 = CHEM(57)
      CHEM(57) = CHEM(57)+0.5000000000000000d+00*W(208)
      SAVE1028 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5000000000000000d+00*W(208)
      SAVE1029 = CHEM(69)
      CHEM(69) = CHEM(69)-W(208)
      SAVE1030 = CHEM(70)
      CHEM(70) = CHEM(70)+W(208)
      SAVE1031 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5000000000000000d+00*W(208)
      SAVE1032 = CHEM(46)
      CHEM(46) = CHEM(46)-W(209)
      SAVE1033 = CHEM(57)
      CHEM(57) = CHEM(57)+0.4840000000000000d+00*W(209)
      SAVE1034 = CHEM(59)
      CHEM(59) = CHEM(59)+0.1670000000000000d+00*W(209)
      SAVE1035 = CHEM(61)
      CHEM(61) = CHEM(61)+0.6500000000000000d+00*W(209)
      SAVE1036 = CHEM(63)
      CHEM(63) = CHEM(63)+0.5160000000000000d+00*W(209)
      SAVE1037 = CHEM(66)
      CHEM(66) = CHEM(66)+0.2070000000000000d+00*W(209)
      SAVE1038 = CHEM(69)
      CHEM(69) = CHEM(69)-W(209)
      SAVE1039 = CHEM(70)
      CHEM(70) = CHEM(70)+0.4840000000000000d+00*W(209)
      SAVE1040 = CHEM(72)
      CHEM(72) = CHEM(72)+0.5160000000000000d+00*W(209)
      SAVE1041 = CHEM(47)
      CHEM(47) = CHEM(47)-0.2000000000000000d+01*W(210)
      SAVE1042 = CHEM(70)
      CHEM(70) = CHEM(70)+0.2000000000000000d+01*W(210)
      SAVE1043 = CHEM(71)
      CHEM(71) = CHEM(71)+W(210)
      SAVE1044 = CHEM(46)
      CHEM(46) = CHEM(46)-W(211)
      SAVE1045 = CHEM(47)
      CHEM(47) = CHEM(47)-W(211)
      SAVE1046 = CHEM(59)
      CHEM(59) = CHEM(59)+0.1490000000000000d+00*W(211)
      SAVE1047 = CHEM(61)
      CHEM(61) = CHEM(61)+0.6400000000000000d+00*W(211)
      SAVE1048 = CHEM(66)
      CHEM(66) = CHEM(66)+0.2020000000000000d+00*W(211)
      SAVE1049 = CHEM(70)
      CHEM(70) = CHEM(70)+0.1500000000000000d+01*W(211)
      SAVE1050 = CHEM(71)
      CHEM(71) = CHEM(71)+0.5000000000000000d+00*W(211)
      SAVE1051 = CHEM(72)
      CHEM(72) = CHEM(72)+0.5000000000000000d+00*W(211)
      SAVE1052 = CHEM(46)
      CHEM(46) = CHEM(46)-0.2000000000000000d+01*W(212)
      SAVE1053 = CHEM(59)
      CHEM(59) = CHEM(59)+0.2850000000000000d+00*W(212)
      SAVE1054 = CHEM(61)
      CHEM(61) = CHEM(61)+0.1210000000000000d+01*W(212)
      SAVE1055 = CHEM(66)
      CHEM(66) = CHEM(66)+0.5040000000000000d+00*W(212)
      SAVE1056 = CHEM(70)
      CHEM(70) = CHEM(70)+W(212)
      SAVE1057 = CHEM(72)
      CHEM(72) = CHEM(72)+W(212)
      SAVE1058 = CHEM(63)
      CHEM(63) = CHEM(63)-W(213)
      SAVE1059 = CHEM(66)
      CHEM(66) = CHEM(66)+W(213)
      SAVE1060 = CHEM(68)
      CHEM(68) = CHEM(68)-W(213)
      SAVE1061 = CHEM(71)
      CHEM(71) = CHEM(71)+W(213)
      SAVE1062 = CHEM(72)
      CHEM(72) = CHEM(72)+W(213)
      SAVE1063 = CHEM(60)
      CHEM(60) = CHEM(60)-W(214)
      SAVE1064 = CHEM(61)
      CHEM(61) = CHEM(61)+W(214)
      SAVE1065 = CHEM(68)
      CHEM(68) = CHEM(68)-W(214)
      SAVE1066 = CHEM(71)
      CHEM(71) = CHEM(71)+W(214)
      SAVE1067 = CHEM(72)
      CHEM(72) = CHEM(72)+W(214)
      SAVE1068 = CHEM(51)
      CHEM(51) = CHEM(51)+0.6300000000000000d-01*W(215)
      SAVE1069 = CHEM(59)
      CHEM(59) = CHEM(59)+0.6700000000000000d+00*W(215)
      SAVE1070 = CHEM(60)
      CHEM(60) = CHEM(60)+0.5300000000000000d-01*W(215)
      SAVE1071 = CHEM(61)
      CHEM(61) = CHEM(61)+0.2430000000000000d+00*W(215)
      SAVE1072 = CHEM(63)
      CHEM(63) = CHEM(63)+0.1550000000000000d+00*W(215)
      SAVE1073 = CHEM(64)
      CHEM(64) = CHEM(64)-W(215)
      SAVE1074 = CHEM(65)
      CHEM(65) = CHEM(65)+0.5100000000000000d-01*W(215)
      SAVE1075 = CHEM(66)
      CHEM(66) = CHEM(66)+0.4800000000000000d-01*W(215)
      SAVE1076 = CHEM(68)
      CHEM(68) = CHEM(68)-W(215)
      SAVE1077 = CHEM(71)
      CHEM(71) = CHEM(71)+0.7920000000000000d+00*W(215)
      SAVE1078 = CHEM(72)
      CHEM(72) = CHEM(72)+W(215)
      SAVE1079 = CHEM(36)
      CHEM(36) = CHEM(36)-W(216)
      SAVE1080 = CHEM(59)
      CHEM(59) = CHEM(59)+0.8280000000000000d+00*W(216)
      SAVE1081 = CHEM(60)
      CHEM(60) = CHEM(60)+0.2620000000000000d+00*W(216)
      SAVE1082 = CHEM(61)
      CHEM(61) = CHEM(61)+0.2390000000000000d+00*W(216)
      SAVE1083 = CHEM(63)
      CHEM(63) = CHEM(63)+0.4000000000000000d-01*W(216)
      SAVE1084 = CHEM(65)
      CHEM(65) = CHEM(65)+0.3910000000000000d+00*W(216)
      SAVE1085 = CHEM(66)
      CHEM(66) = CHEM(66)+0.2100000000000000d-01*W(216)
      SAVE1086 = CHEM(68)
      CHEM(68) = CHEM(68)-W(216)
      SAVE1087 = CHEM(71)
      CHEM(71) = CHEM(71)+0.6990000000000000d+00*W(216)
      SAVE1088 = CHEM(72)
      CHEM(72) = CHEM(72)+W(216)
      SAVE1089 = CHEM(37)
      CHEM(37) = CHEM(37)-W(217)
      SAVE1090 = CHEM(59)
      CHEM(59) = CHEM(59)+0.8800000000000000d+00*W(217)
      SAVE1091 = CHEM(60)
      CHEM(60) = CHEM(60)+0.1550000000000000d+00*W(217)
      SAVE1092 = CHEM(61)
      CHEM(61) = CHEM(61)+0.1870000000000000d+00*W(217)
      SAVE1093 = CHEM(65)
      CHEM(65) = CHEM(65)+0.5870000000000000d+00*W(217)
      SAVE1094 = CHEM(68)
      CHEM(68) = CHEM(68)-W(217)
      SAVE1095 = CHEM(71)
      CHEM(71) = CHEM(71)+0.8450000000000000d+00*W(217)
      SAVE1096 = CHEM(72)
      CHEM(72) = CHEM(72)+W(217)
      SAVE1097 = CHEM(38)
      CHEM(38) = CHEM(38)-W(218)
      SAVE1098 = CHEM(61)
      CHEM(61) = CHEM(61)+0.2000000000000000d+00*W(218)
      SAVE1099 = CHEM(66)
      CHEM(66) = CHEM(66)+0.1600000000000000d+01*W(218)
      SAVE1100 = CHEM(68)
      CHEM(68) = CHEM(68)-W(218)
      SAVE1101 = CHEM(71)
      CHEM(71) = CHEM(71)+W(218)
      SAVE1102 = CHEM(72)
      CHEM(72) = CHEM(72)+W(218)
      SAVE1103 = CHEM(41)
      CHEM(41) = CHEM(41)-W(219)
      SAVE1104 = CHEM(59)
      CHEM(59) = CHEM(59)+0.6000000000000000d-01*W(219)
      SAVE1105 = CHEM(61)
      CHEM(61) = CHEM(61)+0.9399999999999999d+00*W(219)
      SAVE1106 = CHEM(66)
      CHEM(66) = CHEM(66)+W(219)
      SAVE1107 = CHEM(68)
      CHEM(68) = CHEM(68)-W(219)
      SAVE1108 = CHEM(71)
      CHEM(71) = CHEM(71)+W(219)
      SAVE1109 = CHEM(72)
      CHEM(72) = CHEM(72)+W(219)
      SAVE1110 = CHEM(45)
      CHEM(45) = CHEM(45)-W(220)
      SAVE1111 = CHEM(59)
      CHEM(59) = CHEM(59)+0.2900000000000000d+00*W(220)
      SAVE1112 = CHEM(61)
      CHEM(61) = CHEM(61)+0.1710000000000000d+01*W(220)
      SAVE1113 = CHEM(68)
      CHEM(68) = CHEM(68)-W(220)
      SAVE1114 = CHEM(71)
      CHEM(71) = CHEM(71)+W(220)
      SAVE1115 = CHEM(72)
      CHEM(72) = CHEM(72)+W(220)
      SAVE1116 = CHEM(39)
      CHEM(39) = CHEM(39)-W(221)
      SAVE1117 = CHEM(40)
      CHEM(40) = CHEM(40)+0.4000000000000000d+00*W(221)
      SAVE1118 = CHEM(49)
      CHEM(49) = CHEM(49)+0.6000000000000000d+00*W(221)
      SAVE1119 = CHEM(66)
      CHEM(66) = CHEM(66)+0.6860000000000001d+00*W(221)
      SAVE1120 = CHEM(68)
      CHEM(68) = CHEM(68)-W(221)
      SAVE1121 = CHEM(71)
      CHEM(71) = CHEM(71)+W(221)
      SAVE1122 = CHEM(72)
      CHEM(72) = CHEM(72)+W(221)
      SAVE1123 = CHEM(42)
      CHEM(42) = CHEM(42)-W(222)
      SAVE1124 = CHEM(59)
      CHEM(59) = CHEM(59)+W(222)
      SAVE1125 = CHEM(61)
      CHEM(61) = CHEM(61)+W(222)
      SAVE1126 = CHEM(68)
      CHEM(68) = CHEM(68)-W(222)
      SAVE1127 = CHEM(71)
      CHEM(71) = CHEM(71)+W(222)
      SAVE1128 = CHEM(72)
      CHEM(72) = CHEM(72)+W(222)
      SAVE1129 = CHEM(43)
      CHEM(43) = CHEM(43)-W(223)
      SAVE1130 = CHEM(44)
      CHEM(44) = CHEM(44)+0.4000000000000000d+00*W(223)
      SAVE1131 = CHEM(49)
      CHEM(49) = CHEM(49)+0.6000000000000000d+00*W(223)
      SAVE1132 = CHEM(66)
      CHEM(66) = CHEM(66)+0.4000000000000000d+00*W(223)
      SAVE1133 = CHEM(68)
      CHEM(68) = CHEM(68)-W(223)
      SAVE1134 = CHEM(71)
      CHEM(71) = CHEM(71)+W(223)
      SAVE1135 = CHEM(72)
      CHEM(72) = CHEM(72)+W(223)
      SAVE1136 = CHEM(31)
      CHEM(31) = CHEM(31)-W(224)
      SAVE1137 = CHEM(48)
      CHEM(48) = CHEM(48)+0.5000000000000000d+00*W(224)
      SAVE1138 = CHEM(51)
      CHEM(51) = CHEM(51)+0.1300000000000000d+01*W(224)
      SAVE1139 = CHEM(54)
      CHEM(54) = CHEM(54)+0.7000000000000000d+00*W(224)
      SAVE1140 = CHEM(68)
      CHEM(68) = CHEM(68)-W(224)
      SAVE1141 = CHEM(71)
      CHEM(71) = CHEM(71)+W(224)
      SAVE1142 = CHEM(72)
      CHEM(72) = CHEM(72)+W(224)
      SAVE1143 = CHEM(32)
      CHEM(32) = CHEM(32)-W(225)
      SAVE1144 = CHEM(48)
      CHEM(48) = CHEM(48)+W(225)
      SAVE1145 = CHEM(51)
      CHEM(51) = CHEM(51)+0.7400000000000000d+00*W(225)
      SAVE1146 = CHEM(54)
      CHEM(54) = CHEM(54)+0.1260000000000000d+01*W(225)
      SAVE1147 = CHEM(68)
      CHEM(68) = CHEM(68)-W(225)
      SAVE1148 = CHEM(71)
      CHEM(71) = CHEM(71)+W(225)
      SAVE1149 = CHEM(72)
      CHEM(72) = CHEM(72)+W(225)
      SAVE1150 = CHEM(33)
      CHEM(33) = CHEM(33)-W(226)
      SAVE1151 = CHEM(51)
      CHEM(51) = CHEM(51)+W(226)
      SAVE1152 = CHEM(54)
      CHEM(54) = CHEM(54)+W(226)
      SAVE1153 = CHEM(68)
      CHEM(68) = CHEM(68)-W(226)
      SAVE1154 = CHEM(71)
      CHEM(71) = CHEM(71)+W(226)
      SAVE1155 = CHEM(72)
      CHEM(72) = CHEM(72)+W(226)
      SAVE1156 = CHEM(63)
      CHEM(63) = CHEM(63)+W(227)
      SAVE1157 = CHEM(68)
      CHEM(68) = CHEM(68)-W(227)
      SAVE1158 = CHEM(69)
      CHEM(69) = CHEM(69)-W(227)
      SAVE1159 = CHEM(72)
      CHEM(72) = CHEM(72)+W(227)
      SAVE1160 = CHEM(56)
      CHEM(56) = CHEM(56)-W(228)
      SAVE1161 = CHEM(66)
      CHEM(66) = CHEM(66)+W(228)
      SAVE1162 = CHEM(68)
      CHEM(68) = CHEM(68)-W(228)
      SAVE1163 = CHEM(69)
      CHEM(69) = CHEM(69)+W(228)
      SAVE1164 = CHEM(72)
      CHEM(72) = CHEM(72)+W(228)
      SAVE1165 = CHEM(54)
      CHEM(54) = CHEM(54)+0.5400000000000000d+00*W(229)
      SAVE1166 = CHEM(58)
      CHEM(58) = CHEM(58)-W(229)
      SAVE1167 = CHEM(61)
      CHEM(61) = CHEM(61)+0.4600000000000000d+00*W(229)
      SAVE1168 = CHEM(65)
      CHEM(65) = CHEM(65)+0.1600000000000000d+00*W(229)
      SAVE1169 = CHEM(68)
      CHEM(68) = CHEM(68)-W(229)
      SAVE1170 = CHEM(69)
      CHEM(69) = CHEM(69)+0.2300000000000000d+00*W(229)
      SAVE1171 = CHEM(71)
      CHEM(71) = CHEM(71)+0.7700000000000000d+00*W(229)
      SAVE1172 = CHEM(72)
      CHEM(72) = CHEM(72)+W(229)
      SAVE1173 = CHEM(47)
      CHEM(47) = CHEM(47)-W(230)
      SAVE1174 = CHEM(68)
      CHEM(68) = CHEM(68)-W(230)
      SAVE1175 = CHEM(70)
      CHEM(70) = CHEM(70)+W(230)
      SAVE1176 = CHEM(71)
      CHEM(71) = CHEM(71)+W(230)
      SAVE1177 = CHEM(72)
      CHEM(72) = CHEM(72)+W(230)
      SAVE1178 = CHEM(46)
      CHEM(46) = CHEM(46)-W(231)
      SAVE1179 = CHEM(59)
      CHEM(59) = CHEM(59)+0.4690000000000000d+00*W(231)
      SAVE1180 = CHEM(61)
      CHEM(61) = CHEM(61)+0.1240000000000000d+01*W(231)
      SAVE1181 = CHEM(66)
      CHEM(66) = CHEM(66)+0.2800000000000000d+00*W(231)
      SAVE1182 = CHEM(68)
      CHEM(68) = CHEM(68)-W(231)
      SAVE1183 = CHEM(72)
      CHEM(72) = CHEM(72)+0.2000000000000000d+01*W(231)
      SAVE1184 = CHEM(53)
      CHEM(53) = CHEM(53)+W(232)
      SAVE1185 = CHEM(65)
      CHEM(65) = CHEM(65)-W(232)
      SAVE1186 = CHEM(71)
      CHEM(71) = CHEM(71)-W(232)
      SAVE1187 = CHEM(63)
      CHEM(63) = CHEM(63)-W(233)
      SAVE1188 = CHEM(65)
      CHEM(65) = CHEM(65)-W(233)
      SAVE1189 = CHEM(66)
      CHEM(66) = CHEM(66)+W(233)
      SAVE1190 = CHEM(71)
      CHEM(71) = CHEM(71)+W(233)
      SAVE1191 = CHEM(63)
      CHEM(63) = CHEM(63)+W(234)
      SAVE1192 = CHEM(65)
      CHEM(65) = CHEM(65)-W(234)
      SAVE1193 = CHEM(69)
      CHEM(69) = CHEM(69)-W(234)
      SAVE1194 = CHEM(65)
      CHEM(65) = CHEM(65)-0.2000000000000000d+01*W(235)
      SAVE1195 = CHEM(65)
      CHEM(65) = CHEM(65)-W(236)
      SAVE1196 = CHEM(67)
      CHEM(67) = CHEM(67)-W(236)
      SAVE1197 = CHEM(72)
      CHEM(72) = CHEM(72)+W(236)
      SAVE1198 = CHEM(65)
      CHEM(65) = CHEM(65)-W(237)
      SAVE1199 = CHEM(68)
      CHEM(68) = CHEM(68)-W(237)
      SAVE1200 = CHEM(72)
      CHEM(72) = CHEM(72)+W(237)
      SAVE1204 = I
      DO I = 1, NS
         SAVE1201(I) = CHEM(I)
         CHEM(I) = CHEM(I)/CONVERS_FACTOR(I)
      END DO
      SAVE1203 = I
      DO I = 1, NS
         SAVE1202(I) = CHEM(I)
         CHEM(I) = CHEM(I)+ZCSOURC(I)
      END DO
C
C Transposed linear forms
C

      DO I = NS, 1, -1
         CHEM(I) = SAVE1202(I)
         ZCSOURCCCL(I) = ZCSOURCCCL(I)+CHEMCCL(I)
      END DO
      I = SAVE1203
      DO I = NS, 1, -1
         CHEM(I) = SAVE1201(I)
         CHEMCCL(I) = CHEMCCL(I)*(1d0/CONVERS_FACTOR(I))
      END DO
      I = SAVE1204
      CHEM(72) = SAVE1200
      WCCL(237) = WCCL(237)+CHEMCCL(72)
      CHEM(68) = SAVE1199
      WCCL(237) = WCCL(237)-CHEMCCL(68)
      CHEM(65) = SAVE1198
      WCCL(237) = WCCL(237)-CHEMCCL(65)
      CHEM(72) = SAVE1197
      WCCL(236) = WCCL(236)+CHEMCCL(72)
      CHEM(67) = SAVE1196
      WCCL(236) = WCCL(236)-CHEMCCL(67)
      CHEM(65) = SAVE1195
      WCCL(236) = WCCL(236)-CHEMCCL(65)
      CHEM(65) = SAVE1194
      WCCL(235) = WCCL(235)-CHEMCCL(65)*0.2000000000000000d+01
      CHEM(69) = SAVE1193
      WCCL(234) = WCCL(234)-CHEMCCL(69)
      CHEM(65) = SAVE1192
      WCCL(234) = WCCL(234)-CHEMCCL(65)
      CHEM(63) = SAVE1191
      WCCL(234) = WCCL(234)+CHEMCCL(63)
      CHEM(71) = SAVE1190
      WCCL(233) = WCCL(233)+CHEMCCL(71)
      CHEM(66) = SAVE1189
      WCCL(233) = WCCL(233)+CHEMCCL(66)
      CHEM(65) = SAVE1188
      WCCL(233) = WCCL(233)-CHEMCCL(65)
      CHEM(63) = SAVE1187
      WCCL(233) = WCCL(233)-CHEMCCL(63)
      CHEM(71) = SAVE1186
      WCCL(232) = WCCL(232)-CHEMCCL(71)
      CHEM(65) = SAVE1185
      WCCL(232) = WCCL(232)-CHEMCCL(65)
      CHEM(53) = SAVE1184
      WCCL(232) = WCCL(232)+CHEMCCL(53)
      CHEM(72) = SAVE1183
      WCCL(231) = WCCL(231)+CHEMCCL(72)*0.2000000000000000d+01
      CHEM(68) = SAVE1182
      WCCL(231) = WCCL(231)-CHEMCCL(68)
      CHEM(66) = SAVE1181
      WCCL(231) = WCCL(231)+CHEMCCL(66)*0.2800000000000000d+00
      CHEM(61) = SAVE1180
      WCCL(231) = WCCL(231)+CHEMCCL(61)*0.1240000000000000d+01
      CHEM(59) = SAVE1179
      WCCL(231) = WCCL(231)+CHEMCCL(59)*0.4690000000000000d+00
      CHEM(46) = SAVE1178
      WCCL(231) = WCCL(231)-CHEMCCL(46)
      CHEM(72) = SAVE1177
      WCCL(230) = WCCL(230)+CHEMCCL(72)
      CHEM(71) = SAVE1176
      WCCL(230) = WCCL(230)+CHEMCCL(71)
      CHEM(70) = SAVE1175
      WCCL(230) = WCCL(230)+CHEMCCL(70)
      CHEM(68) = SAVE1174
      WCCL(230) = WCCL(230)-CHEMCCL(68)
      CHEM(47) = SAVE1173
      WCCL(230) = WCCL(230)-CHEMCCL(47)
      CHEM(72) = SAVE1172
      WCCL(229) = WCCL(229)+CHEMCCL(72)
      CHEM(71) = SAVE1171
      WCCL(229) = WCCL(229)+CHEMCCL(71)*0.7700000000000000d+00
      CHEM(69) = SAVE1170
      WCCL(229) = WCCL(229)+CHEMCCL(69)*0.2300000000000000d+00
      CHEM(68) = SAVE1169
      WCCL(229) = WCCL(229)-CHEMCCL(68)
      CHEM(65) = SAVE1168
      WCCL(229) = WCCL(229)+CHEMCCL(65)*0.1600000000000000d+00
      CHEM(61) = SAVE1167
      WCCL(229) = WCCL(229)+CHEMCCL(61)*0.4600000000000000d+00
      CHEM(58) = SAVE1166
      WCCL(229) = WCCL(229)-CHEMCCL(58)
      CHEM(54) = SAVE1165
      WCCL(229) = WCCL(229)+CHEMCCL(54)*0.5400000000000000d+00
      CHEM(72) = SAVE1164
      WCCL(228) = WCCL(228)+CHEMCCL(72)
      CHEM(69) = SAVE1163
      WCCL(228) = WCCL(228)+CHEMCCL(69)
      CHEM(68) = SAVE1162
      WCCL(228) = WCCL(228)-CHEMCCL(68)
      CHEM(66) = SAVE1161
      WCCL(228) = WCCL(228)+CHEMCCL(66)
      CHEM(56) = SAVE1160
      WCCL(228) = WCCL(228)-CHEMCCL(56)
      CHEM(72) = SAVE1159
      WCCL(227) = WCCL(227)+CHEMCCL(72)
      CHEM(69) = SAVE1158
      WCCL(227) = WCCL(227)-CHEMCCL(69)
      CHEM(68) = SAVE1157
      WCCL(227) = WCCL(227)-CHEMCCL(68)
      CHEM(63) = SAVE1156
      WCCL(227) = WCCL(227)+CHEMCCL(63)
      CHEM(72) = SAVE1155
      WCCL(226) = WCCL(226)+CHEMCCL(72)
      CHEM(71) = SAVE1154
      WCCL(226) = WCCL(226)+CHEMCCL(71)
      CHEM(68) = SAVE1153
      WCCL(226) = WCCL(226)-CHEMCCL(68)
      CHEM(54) = SAVE1152
      WCCL(226) = WCCL(226)+CHEMCCL(54)
      CHEM(51) = SAVE1151
      WCCL(226) = WCCL(226)+CHEMCCL(51)
      CHEM(33) = SAVE1150
      WCCL(226) = WCCL(226)-CHEMCCL(33)
      CHEM(72) = SAVE1149
      WCCL(225) = WCCL(225)+CHEMCCL(72)
      CHEM(71) = SAVE1148
      WCCL(225) = WCCL(225)+CHEMCCL(71)
      CHEM(68) = SAVE1147
      WCCL(225) = WCCL(225)-CHEMCCL(68)
      CHEM(54) = SAVE1146
      WCCL(225) = WCCL(225)+CHEMCCL(54)*0.1260000000000000d+01
      CHEM(51) = SAVE1145
      WCCL(225) = WCCL(225)+CHEMCCL(51)*0.7400000000000000d+00
      CHEM(48) = SAVE1144
      WCCL(225) = WCCL(225)+CHEMCCL(48)
      CHEM(32) = SAVE1143
      WCCL(225) = WCCL(225)-CHEMCCL(32)
      CHEM(72) = SAVE1142
      WCCL(224) = WCCL(224)+CHEMCCL(72)
      CHEM(71) = SAVE1141
      WCCL(224) = WCCL(224)+CHEMCCL(71)
      CHEM(68) = SAVE1140
      WCCL(224) = WCCL(224)-CHEMCCL(68)
      CHEM(54) = SAVE1139
      WCCL(224) = WCCL(224)+CHEMCCL(54)*0.7000000000000000d+00
      CHEM(51) = SAVE1138
      WCCL(224) = WCCL(224)+CHEMCCL(51)*0.1300000000000000d+01
      CHEM(48) = SAVE1137
      WCCL(224) = WCCL(224)+CHEMCCL(48)*0.5000000000000000d+00
      CHEM(31) = SAVE1136
      WCCL(224) = WCCL(224)-CHEMCCL(31)
      CHEM(72) = SAVE1135
      WCCL(223) = WCCL(223)+CHEMCCL(72)
      CHEM(71) = SAVE1134
      WCCL(223) = WCCL(223)+CHEMCCL(71)
      CHEM(68) = SAVE1133
      WCCL(223) = WCCL(223)-CHEMCCL(68)
      CHEM(66) = SAVE1132
      WCCL(223) = WCCL(223)+CHEMCCL(66)*0.4000000000000000d+00
      CHEM(49) = SAVE1131
      WCCL(223) = WCCL(223)+CHEMCCL(49)*0.6000000000000000d+00
      CHEM(44) = SAVE1130
      WCCL(223) = WCCL(223)+CHEMCCL(44)*0.4000000000000000d+00
      CHEM(43) = SAVE1129
      WCCL(223) = WCCL(223)-CHEMCCL(43)
      CHEM(72) = SAVE1128
      WCCL(222) = WCCL(222)+CHEMCCL(72)
      CHEM(71) = SAVE1127
      WCCL(222) = WCCL(222)+CHEMCCL(71)
      CHEM(68) = SAVE1126
      WCCL(222) = WCCL(222)-CHEMCCL(68)
      CHEM(61) = SAVE1125
      WCCL(222) = WCCL(222)+CHEMCCL(61)
      CHEM(59) = SAVE1124
      WCCL(222) = WCCL(222)+CHEMCCL(59)
      CHEM(42) = SAVE1123
      WCCL(222) = WCCL(222)-CHEMCCL(42)
      CHEM(72) = SAVE1122
      WCCL(221) = WCCL(221)+CHEMCCL(72)
      CHEM(71) = SAVE1121
      WCCL(221) = WCCL(221)+CHEMCCL(71)
      CHEM(68) = SAVE1120
      WCCL(221) = WCCL(221)-CHEMCCL(68)
      CHEM(66) = SAVE1119
      WCCL(221) = WCCL(221)+CHEMCCL(66)*0.6860000000000001d+00
      CHEM(49) = SAVE1118
      WCCL(221) = WCCL(221)+CHEMCCL(49)*0.6000000000000000d+00
      CHEM(40) = SAVE1117
      WCCL(221) = WCCL(221)+CHEMCCL(40)*0.4000000000000000d+00
      CHEM(39) = SAVE1116
      WCCL(221) = WCCL(221)-CHEMCCL(39)
      CHEM(72) = SAVE1115
      WCCL(220) = WCCL(220)+CHEMCCL(72)
      CHEM(71) = SAVE1114
      WCCL(220) = WCCL(220)+CHEMCCL(71)
      CHEM(68) = SAVE1113
      WCCL(220) = WCCL(220)-CHEMCCL(68)
      CHEM(61) = SAVE1112
      WCCL(220) = WCCL(220)+CHEMCCL(61)*0.1710000000000000d+01
      CHEM(59) = SAVE1111
      WCCL(220) = WCCL(220)+CHEMCCL(59)*0.2900000000000000d+00
      CHEM(45) = SAVE1110
      WCCL(220) = WCCL(220)-CHEMCCL(45)
      CHEM(72) = SAVE1109
      WCCL(219) = WCCL(219)+CHEMCCL(72)
      CHEM(71) = SAVE1108
      WCCL(219) = WCCL(219)+CHEMCCL(71)
      CHEM(68) = SAVE1107
      WCCL(219) = WCCL(219)-CHEMCCL(68)
      CHEM(66) = SAVE1106
      WCCL(219) = WCCL(219)+CHEMCCL(66)
      CHEM(61) = SAVE1105
      WCCL(219) = WCCL(219)+CHEMCCL(61)*0.9399999999999999d+00
      CHEM(59) = SAVE1104
      WCCL(219) = WCCL(219)+CHEMCCL(59)*0.6000000000000000d-01
      CHEM(41) = SAVE1103
      WCCL(219) = WCCL(219)-CHEMCCL(41)
      CHEM(72) = SAVE1102
      WCCL(218) = WCCL(218)+CHEMCCL(72)
      CHEM(71) = SAVE1101
      WCCL(218) = WCCL(218)+CHEMCCL(71)
      CHEM(68) = SAVE1100
      WCCL(218) = WCCL(218)-CHEMCCL(68)
      CHEM(66) = SAVE1099
      WCCL(218) = WCCL(218)+CHEMCCL(66)*0.1600000000000000d+01
      CHEM(61) = SAVE1098
      WCCL(218) = WCCL(218)+CHEMCCL(61)*0.2000000000000000d+00
      CHEM(38) = SAVE1097
      WCCL(218) = WCCL(218)-CHEMCCL(38)
      CHEM(72) = SAVE1096
      WCCL(217) = WCCL(217)+CHEMCCL(72)
      CHEM(71) = SAVE1095
      WCCL(217) = WCCL(217)+CHEMCCL(71)*0.8450000000000000d+00
      CHEM(68) = SAVE1094
      WCCL(217) = WCCL(217)-CHEMCCL(68)
      CHEM(65) = SAVE1093
      WCCL(217) = WCCL(217)+CHEMCCL(65)*0.5870000000000000d+00
      CHEM(61) = SAVE1092
      WCCL(217) = WCCL(217)+CHEMCCL(61)*0.1870000000000000d+00
      CHEM(60) = SAVE1091
      WCCL(217) = WCCL(217)+CHEMCCL(60)*0.1550000000000000d+00
      CHEM(59) = SAVE1090
      WCCL(217) = WCCL(217)+CHEMCCL(59)*0.8800000000000000d+00
      CHEM(37) = SAVE1089
      WCCL(217) = WCCL(217)-CHEMCCL(37)
      CHEM(72) = SAVE1088
      WCCL(216) = WCCL(216)+CHEMCCL(72)
      CHEM(71) = SAVE1087
      WCCL(216) = WCCL(216)+CHEMCCL(71)*0.6990000000000000d+00
      CHEM(68) = SAVE1086
      WCCL(216) = WCCL(216)-CHEMCCL(68)
      CHEM(66) = SAVE1085
      WCCL(216) = WCCL(216)+CHEMCCL(66)*0.2100000000000000d-01
      CHEM(65) = SAVE1084
      WCCL(216) = WCCL(216)+CHEMCCL(65)*0.3910000000000000d+00
      CHEM(63) = SAVE1083
      WCCL(216) = WCCL(216)+CHEMCCL(63)*0.4000000000000000d-01
      CHEM(61) = SAVE1082
      WCCL(216) = WCCL(216)+CHEMCCL(61)*0.2390000000000000d+00
      CHEM(60) = SAVE1081
      WCCL(216) = WCCL(216)+CHEMCCL(60)*0.2620000000000000d+00
      CHEM(59) = SAVE1080
      WCCL(216) = WCCL(216)+CHEMCCL(59)*0.8280000000000000d+00
      CHEM(36) = SAVE1079
      WCCL(216) = WCCL(216)-CHEMCCL(36)
      CHEM(72) = SAVE1078
      WCCL(215) = WCCL(215)+CHEMCCL(72)
      CHEM(71) = SAVE1077
      WCCL(215) = WCCL(215)+CHEMCCL(71)*0.7920000000000000d+00
      CHEM(68) = SAVE1076
      WCCL(215) = WCCL(215)-CHEMCCL(68)
      CHEM(66) = SAVE1075
      WCCL(215) = WCCL(215)+CHEMCCL(66)*0.4800000000000000d-01
      CHEM(65) = SAVE1074
      WCCL(215) = WCCL(215)+CHEMCCL(65)*0.5100000000000000d-01
      CHEM(64) = SAVE1073
      WCCL(215) = WCCL(215)-CHEMCCL(64)
      CHEM(63) = SAVE1072
      WCCL(215) = WCCL(215)+CHEMCCL(63)*0.1550000000000000d+00
      CHEM(61) = SAVE1071
      WCCL(215) = WCCL(215)+CHEMCCL(61)*0.2430000000000000d+00
      CHEM(60) = SAVE1070
      WCCL(215) = WCCL(215)+CHEMCCL(60)*0.5300000000000000d-01
      CHEM(59) = SAVE1069
      WCCL(215) = WCCL(215)+CHEMCCL(59)*0.6700000000000000d+00
      CHEM(51) = SAVE1068
      WCCL(215) = WCCL(215)+CHEMCCL(51)*0.6300000000000000d-01
      CHEM(72) = SAVE1067
      WCCL(214) = WCCL(214)+CHEMCCL(72)
      CHEM(71) = SAVE1066
      WCCL(214) = WCCL(214)+CHEMCCL(71)
      CHEM(68) = SAVE1065
      WCCL(214) = WCCL(214)-CHEMCCL(68)
      CHEM(61) = SAVE1064
      WCCL(214) = WCCL(214)+CHEMCCL(61)
      CHEM(60) = SAVE1063
      WCCL(214) = WCCL(214)-CHEMCCL(60)
      CHEM(72) = SAVE1062
      WCCL(213) = WCCL(213)+CHEMCCL(72)
      CHEM(71) = SAVE1061
      WCCL(213) = WCCL(213)+CHEMCCL(71)
      CHEM(68) = SAVE1060
      WCCL(213) = WCCL(213)-CHEMCCL(68)
      CHEM(66) = SAVE1059
      WCCL(213) = WCCL(213)+CHEMCCL(66)
      CHEM(63) = SAVE1058
      WCCL(213) = WCCL(213)-CHEMCCL(63)
      CHEM(72) = SAVE1057
      WCCL(212) = WCCL(212)+CHEMCCL(72)
      CHEM(70) = SAVE1056
      WCCL(212) = WCCL(212)+CHEMCCL(70)
      CHEM(66) = SAVE1055
      WCCL(212) = WCCL(212)+CHEMCCL(66)*0.5040000000000000d+00
      CHEM(61) = SAVE1054
      WCCL(212) = WCCL(212)+CHEMCCL(61)*0.1210000000000000d+01
      CHEM(59) = SAVE1053
      WCCL(212) = WCCL(212)+CHEMCCL(59)*0.2850000000000000d+00
      CHEM(46) = SAVE1052
      WCCL(212) = WCCL(212)-CHEMCCL(46)*0.2000000000000000d+01
      CHEM(72) = SAVE1051
      WCCL(211) = WCCL(211)+CHEMCCL(72)*0.5000000000000000d+00
      CHEM(71) = SAVE1050
      WCCL(211) = WCCL(211)+CHEMCCL(71)*0.5000000000000000d+00
      CHEM(70) = SAVE1049
      WCCL(211) = WCCL(211)+CHEMCCL(70)*0.1500000000000000d+01
      CHEM(66) = SAVE1048
      WCCL(211) = WCCL(211)+CHEMCCL(66)*0.2020000000000000d+00
      CHEM(61) = SAVE1047
      WCCL(211) = WCCL(211)+CHEMCCL(61)*0.6400000000000000d+00
      CHEM(59) = SAVE1046
      WCCL(211) = WCCL(211)+CHEMCCL(59)*0.1490000000000000d+00
      CHEM(47) = SAVE1045
      WCCL(211) = WCCL(211)-CHEMCCL(47)
      CHEM(46) = SAVE1044
      WCCL(211) = WCCL(211)-CHEMCCL(46)
      CHEM(71) = SAVE1043
      WCCL(210) = WCCL(210)+CHEMCCL(71)
      CHEM(70) = SAVE1042
      WCCL(210) = WCCL(210)+CHEMCCL(70)*0.2000000000000000d+01
      CHEM(47) = SAVE1041
      WCCL(210) = WCCL(210)-CHEMCCL(47)*0.2000000000000000d+01
      CHEM(72) = SAVE1040
      WCCL(209) = WCCL(209)+CHEMCCL(72)*0.5160000000000000d+00
      CHEM(70) = SAVE1039
      WCCL(209) = WCCL(209)+CHEMCCL(70)*0.4840000000000000d+00
      CHEM(69) = SAVE1038
      WCCL(209) = WCCL(209)-CHEMCCL(69)
      CHEM(66) = SAVE1037
      WCCL(209) = WCCL(209)+CHEMCCL(66)*0.2070000000000000d+00
      CHEM(63) = SAVE1036
      WCCL(209) = WCCL(209)+CHEMCCL(63)*0.5160000000000000d+00
      CHEM(61) = SAVE1035
      WCCL(209) = WCCL(209)+CHEMCCL(61)*0.6500000000000000d+00
      CHEM(59) = SAVE1034
      WCCL(209) = WCCL(209)+CHEMCCL(59)*0.1670000000000000d+00
      CHEM(57) = SAVE1033
      WCCL(209) = WCCL(209)+CHEMCCL(57)*0.4840000000000000d+00
      CHEM(46) = SAVE1032
      WCCL(209) = WCCL(209)-CHEMCCL(46)
      CHEM(71) = SAVE1031
      WCCL(208) = WCCL(208)+CHEMCCL(71)*0.5000000000000000d+00
      CHEM(70) = SAVE1030
      WCCL(208) = WCCL(208)+CHEMCCL(70)
      CHEM(69) = SAVE1029
      WCCL(208) = WCCL(208)-CHEMCCL(69)
      CHEM(63) = SAVE1028
      WCCL(208) = WCCL(208)+CHEMCCL(63)*0.5000000000000000d+00
      CHEM(57) = SAVE1027
      WCCL(208) = WCCL(208)+CHEMCCL(57)*0.5000000000000000d+00
      CHEM(47) = SAVE1026
      WCCL(208) = WCCL(208)-CHEMCCL(47)
      CHEM(71) = SAVE1025
      WCCL(207) = WCCL(207)+CHEMCCL(71)*0.3800000000000000d+00
      CHEM(69) = SAVE1024
      WCCL(207) = WCCL(207)-CHEMCCL(69)*0.8800000000000000d+00
      CHEM(65) = SAVE1023
      WCCL(207) = WCCL(207)+CHEMCCL(65)*0.8000000000000000d-01
      CHEM(63) = SAVE1022
      WCCL(207) = WCCL(207)+CHEMCCL(63)*0.5000000000000000d+00
      CHEM(61) = SAVE1021
      WCCL(207) = WCCL(207)+CHEMCCL(61)*0.3500000000000000d+00
      CHEM(59) = SAVE1020
      WCCL(207) = WCCL(207)+CHEMCCL(59)*0.1100000000000000d+00
      CHEM(58) = SAVE1019
      WCCL(207) = WCCL(207)-CHEMCCL(58)
      CHEM(57) = SAVE1018
      WCCL(207) = WCCL(207)+CHEMCCL(57)*0.5000000000000000d+00
      CHEM(54) = SAVE1017
      WCCL(207) = WCCL(207)+CHEMCCL(54)*0.5400000000000000d+00
      CHEM(66) = SAVE1016
      WCCL(206) = WCCL(206)+CHEMCCL(66)
      CHEM(63) = SAVE1015
      WCCL(206) = WCCL(206)+CHEMCCL(63)
      CHEM(56) = SAVE1014
      WCCL(206) = WCCL(206)-CHEMCCL(56)
      CHEM(69) = SAVE1013
      WCCL(205) = WCCL(205)-CHEMCCL(69)*0.2000000000000000d+01
      CHEM(63) = SAVE1012
      WCCL(205) = WCCL(205)+CHEMCCL(63)*0.2000000000000000d+01
      CHEM(71) = SAVE1011
      WCCL(204) = WCCL(204)+CHEMCCL(71)
      CHEM(69) = SAVE1010
      WCCL(204) = WCCL(204)-CHEMCCL(69)
      CHEM(63) = SAVE1009
      WCCL(204) = WCCL(204)+CHEMCCL(63)
      CHEM(54) = SAVE1008
      WCCL(204) = WCCL(204)+CHEMCCL(54)
      CHEM(51) = SAVE1007
      WCCL(204) = WCCL(204)+CHEMCCL(51)
      CHEM(33) = SAVE1006
      WCCL(204) = WCCL(204)-CHEMCCL(33)
      CHEM(71) = SAVE1005
      WCCL(203) = WCCL(203)+CHEMCCL(71)
      CHEM(69) = SAVE1004
      WCCL(203) = WCCL(203)-CHEMCCL(69)
      CHEM(63) = SAVE1003
      WCCL(203) = WCCL(203)+CHEMCCL(63)
      CHEM(54) = SAVE1002
      WCCL(203) = WCCL(203)+CHEMCCL(54)*0.6300000000000000d+00
      CHEM(51) = SAVE1001
      WCCL(203) = WCCL(203)+CHEMCCL(51)*0.3700000000000000d+00
      CHEM(48) = SAVE1000
      WCCL(203) = WCCL(203)+CHEMCCL(48)
      CHEM(32) = SAVE999
      WCCL(203) = WCCL(203)-CHEMCCL(32)
      CHEM(71) = SAVE998
      WCCL(202) = WCCL(202)+CHEMCCL(71)
      CHEM(69) = SAVE997
      WCCL(202) = WCCL(202)-CHEMCCL(69)
      CHEM(63) = SAVE996
      WCCL(202) = WCCL(202)+CHEMCCL(63)
      CHEM(54) = SAVE995
      WCCL(202) = WCCL(202)+CHEMCCL(54)*0.3500000000000000d+00
      CHEM(51) = SAVE994
      WCCL(202) = WCCL(202)+CHEMCCL(51)*0.6500000000000000d+00
      CHEM(48) = SAVE993
      WCCL(202) = WCCL(202)+CHEMCCL(48)
      CHEM(31) = SAVE992
      WCCL(202) = WCCL(202)-CHEMCCL(31)
      CHEM(71) = SAVE991
      WCCL(201) = WCCL(201)+CHEMCCL(71)
      CHEM(69) = SAVE990
      WCCL(201) = WCCL(201)-CHEMCCL(69)
      CHEM(66) = SAVE989
      WCCL(201) = WCCL(201)+CHEMCCL(66)*0.4000000000000000d+00
      CHEM(63) = SAVE988
      WCCL(201) = WCCL(201)+CHEMCCL(63)
      CHEM(49) = SAVE987
      WCCL(201) = WCCL(201)+CHEMCCL(49)*0.6000000000000000d+00
      CHEM(44) = SAVE986
      WCCL(201) = WCCL(201)+CHEMCCL(44)*0.4000000000000000d+00
      CHEM(43) = SAVE985
      WCCL(201) = WCCL(201)-CHEMCCL(43)
      CHEM(71) = SAVE984
      WCCL(200) = WCCL(200)+CHEMCCL(71)
      CHEM(69) = SAVE983
      WCCL(200) = WCCL(200)-CHEMCCL(69)
      CHEM(63) = SAVE982
      WCCL(200) = WCCL(200)+CHEMCCL(63)
      CHEM(61) = SAVE981
      WCCL(200) = WCCL(200)+CHEMCCL(61)
      CHEM(59) = SAVE980
      WCCL(200) = WCCL(200)+CHEMCCL(59)
      CHEM(42) = SAVE979
      WCCL(200) = WCCL(200)-CHEMCCL(42)
      CHEM(71) = SAVE978
      WCCL(199) = WCCL(199)+CHEMCCL(71)*0.5060000000000000d+00
      CHEM(69) = SAVE977
      WCCL(199) = WCCL(199)-CHEMCCL(69)
      CHEM(66) = SAVE976
      WCCL(199) = WCCL(199)+CHEMCCL(66)*0.3400000000000000d+00
      CHEM(63) = SAVE975
      WCCL(199) = WCCL(199)+CHEMCCL(63)*0.5060000000000000d+00
      CHEM(57) = SAVE974
      WCCL(199) = WCCL(199)+CHEMCCL(57)*0.4940000000000000d+00
      CHEM(49) = SAVE973
      WCCL(199) = WCCL(199)+CHEMCCL(49)*0.7710000000000000d+00
      CHEM(40) = SAVE972
      WCCL(199) = WCCL(199)+CHEMCCL(40)*0.2290000000000000d+00
      CHEM(39) = SAVE971
      WCCL(199) = WCCL(199)-CHEMCCL(39)
      CHEM(71) = SAVE970
      WCCL(198) = WCCL(198)+CHEMCCL(71)*0.5100000000000000d+00
      CHEM(69) = SAVE969
      WCCL(198) = WCCL(198)-CHEMCCL(69)
      CHEM(63) = SAVE968
      WCCL(198) = WCCL(198)+CHEMCCL(63)*0.5100000000000000d+00
      CHEM(61) = SAVE967
      WCCL(198) = WCCL(198)+CHEMCCL(61)*0.9409999999999999d+00
      CHEM(59) = SAVE966
      WCCL(198) = WCCL(198)+CHEMCCL(59)*0.5690000000000000d+00
      CHEM(57) = SAVE965
      WCCL(198) = WCCL(198)+CHEMCCL(57)*0.4900000000000000d+00
      CHEM(45) = SAVE964
      WCCL(198) = WCCL(198)-CHEMCCL(45)
      CHEM(71) = SAVE963
      WCCL(197) = WCCL(197)+CHEMCCL(71)*0.5010000000000000d+00
      CHEM(69) = SAVE962
      WCCL(197) = WCCL(197)-CHEMCCL(69)
      CHEM(66) = SAVE961
      WCCL(197) = WCCL(197)+CHEMCCL(66)*0.5010000000000000d+00
      CHEM(63) = SAVE960
      WCCL(197) = WCCL(197)+CHEMCCL(63)*0.5010000000000000d+00
      CHEM(61) = SAVE959
      WCCL(197) = WCCL(197)+CHEMCCL(61)*0.8590000000000000d+00
      CHEM(59) = SAVE958
      WCCL(197) = WCCL(197)+CHEMCCL(59)*0.1410000000000000d+00
      CHEM(57) = SAVE957
      WCCL(197) = WCCL(197)+CHEMCCL(57)*0.4990000000000000d+00
      CHEM(41) = SAVE956
      WCCL(197) = WCCL(197)-CHEMCCL(41)
      CHEM(71) = SAVE955
      WCCL(196) = WCCL(196)+CHEMCCL(71)*0.5000000000000000d+00
      CHEM(69) = SAVE954
      WCCL(196) = WCCL(196)-CHEMCCL(69)
      CHEM(66) = SAVE953
      WCCL(196) = WCCL(196)+CHEMCCL(66)*0.8000000000000000d+00
      CHEM(63) = SAVE952
      WCCL(196) = WCCL(196)+CHEMCCL(63)*0.5000000000000000d+00
      CHEM(61) = SAVE951
      WCCL(196) = WCCL(196)+CHEMCCL(61)*0.6000000000000000d+00
      CHEM(57) = SAVE950
      WCCL(196) = WCCL(196)+CHEMCCL(57)*0.5000000000000000d+00
      CHEM(38) = SAVE949
      WCCL(196) = WCCL(196)-CHEMCCL(38)
      CHEM(71) = SAVE948
      WCCL(195) = WCCL(195)+CHEMCCL(71)*0.4890000000000000d+00
      CHEM(69) = SAVE947
      WCCL(195) = WCCL(195)-CHEMCCL(69)
      CHEM(65) = SAVE946
      WCCL(195) = WCCL(195)+CHEMCCL(65)*0.3180000000000000d+00
      CHEM(63) = SAVE945
      WCCL(195) = WCCL(195)+CHEMCCL(63)*0.5070000000000000d+00
      CHEM(61) = SAVE944
      WCCL(195) = WCCL(195)+CHEMCCL(61)*0.4970000000000000d+00
      CHEM(60) = SAVE943
      WCCL(195) = WCCL(195)+CHEMCCL(60)*0.1500000000000000d-01
      CHEM(59) = SAVE942
      WCCL(195) = WCCL(195)+CHEMCCL(59)*0.5810000000000000d+00
      CHEM(57) = SAVE941
      WCCL(195) = WCCL(195)+CHEMCCL(57)*0.4950000000000000d+00
      CHEM(37) = SAVE940
      WCCL(195) = WCCL(195)-CHEMCCL(37)
      CHEM(71) = SAVE939
      WCCL(194) = WCCL(194)+CHEMCCL(71)*0.4380000000000000d+00
      CHEM(69) = SAVE938
      WCCL(194) = WCCL(194)-CHEMCCL(69)
      CHEM(66) = SAVE937
      WCCL(194) = WCCL(194)+CHEMCCL(66)*0.7600000000000000d-01
      CHEM(65) = SAVE936
      WCCL(194) = WCCL(194)+CHEMCCL(65)*0.2370000000000000d+00
      CHEM(63) = SAVE935
      WCCL(194) = WCCL(194)+CHEMCCL(63)*0.5540000000000000d+00
      CHEM(61) = SAVE934
      WCCL(194) = WCCL(194)+CHEMCCL(61)*0.6770000000000000d+00
      CHEM(60) = SAVE933
      WCCL(194) = WCCL(194)+CHEMCCL(60)*0.1800000000000000d-01
      CHEM(59) = SAVE932
      WCCL(194) = WCCL(194)+CHEMCCL(59)*0.3300000000000000d+00
      CHEM(57) = SAVE931
      WCCL(194) = WCCL(194)+CHEMCCL(57)*0.4950000000000000d+00
      CHEM(36) = SAVE930
      WCCL(194) = WCCL(194)-CHEMCCL(36)
      CHEM(71) = SAVE929
      WCCL(193) = WCCL(193)+CHEMCCL(71)*0.4880000000000000d+00
      CHEM(69) = SAVE928
      WCCL(193) = WCCL(193)-CHEMCCL(69)
      CHEM(66) = SAVE927
      WCCL(193) = WCCL(193)+CHEMCCL(66)*0.9100000000000000d-01
      CHEM(65) = SAVE926
      WCCL(193) = WCCL(193)+CHEMCCL(65)*0.7099999999999999d-01
      CHEM(64) = SAVE925
      WCCL(193) = WCCL(193)-CHEMCCL(64)
      CHEM(63) = SAVE924
      WCCL(193) = WCCL(193)+CHEMCCL(63)*0.5080000000000000d+00
      CHEM(61) = SAVE923
      WCCL(193) = WCCL(193)+CHEMCCL(61)*0.7240000000000000d+00
      CHEM(60) = SAVE922
      WCCL(193) = WCCL(193)+CHEMCCL(60)*0.6000000000000000d-02
      CHEM(59) = SAVE921
      WCCL(193) = WCCL(193)+CHEMCCL(59)*0.1270000000000000d+00
      CHEM(57) = SAVE920
      WCCL(193) = WCCL(193)+CHEMCCL(57)*0.4990000000000000d+00
      CHEM(54) = SAVE919
      WCCL(193) = WCCL(193)+CHEMCCL(54)*0.4000000000000000d-02
      CHEM(51) = SAVE918
      WCCL(193) = WCCL(193)+CHEMCCL(51)*0.1000000000000000d+00
      CHEM(71) = SAVE917
      WCCL(192) = WCCL(192)+CHEMCCL(71)*0.5000000000000000d+00
      CHEM(69) = SAVE916
      WCCL(192) = WCCL(192)-CHEMCCL(69)
      CHEM(63) = SAVE915
      WCCL(192) = WCCL(192)+CHEMCCL(63)*0.5000000000000000d+00
      CHEM(61) = SAVE914
      WCCL(192) = WCCL(192)+CHEMCCL(61)
      CHEM(60) = SAVE913
      WCCL(192) = WCCL(192)-CHEMCCL(60)
      CHEM(57) = SAVE912
      WCCL(192) = WCCL(192)+CHEMCCL(57)*0.5000000000000000d+00
      CHEM(72) = SAVE911
      WCCL(191) = WCCL(191)+CHEMCCL(72)*0.5000000000000000d+00
      CHEM(71) = SAVE910
      WCCL(191) = WCCL(191)+CHEMCCL(71)*0.5000000000000000d+00
      CHEM(70) = SAVE909
      WCCL(191) = WCCL(191)+CHEMCCL(70)*0.5000000000000000d+00
      CHEM(66) = SAVE908
      WCCL(191) = WCCL(191)+CHEMCCL(66)*0.9600000000000000d+00
      CHEM(63) = SAVE907
      WCCL(191) = WCCL(191)-CHEMCCL(63)
      CHEM(61) = SAVE906
      WCCL(191) = WCCL(191)+CHEMCCL(61)*0.6400000000000000d+00
      CHEM(59) = SAVE905
      WCCL(191) = WCCL(191)+CHEMCCL(59)*0.1490000000000000d+00
      CHEM(46) = SAVE904
      WCCL(191) = WCCL(191)-CHEMCCL(46)
      CHEM(71) = SAVE903
      WCCL(190) = WCCL(190)+CHEMCCL(71)
      CHEM(70) = SAVE902
      WCCL(190) = WCCL(190)+CHEMCCL(70)
      CHEM(66) = SAVE901
      WCCL(190) = WCCL(190)+CHEMCCL(66)*0.7500000000000000d+00
      CHEM(63) = SAVE900
      WCCL(190) = WCCL(190)-CHEMCCL(63)
      CHEM(47) = SAVE899
      WCCL(190) = WCCL(190)-CHEMCCL(47)
      CHEM(71) = SAVE898
      WCCL(189) = WCCL(189)+CHEMCCL(71)*0.8800000000000000d+00
      CHEM(69) = SAVE897
      WCCL(189) = WCCL(189)+CHEMCCL(69)*0.1200000000000000d+00
      CHEM(66) = SAVE896
      WCCL(189) = WCCL(189)+CHEMCCL(66)*0.7500000000000000d+00
      CHEM(65) = SAVE895
      WCCL(189) = WCCL(189)+CHEMCCL(65)*0.8000000000000000d-01
      CHEM(63) = SAVE894
      WCCL(189) = WCCL(189)-CHEMCCL(63)
      CHEM(61) = SAVE893
      WCCL(189) = WCCL(189)+CHEMCCL(61)*0.3000000000000000d+00
      CHEM(58) = SAVE892
      WCCL(189) = WCCL(189)-CHEMCCL(58)
      CHEM(54) = SAVE891
      WCCL(189) = WCCL(189)+CHEMCCL(54)*0.4000000000000000d+00
      CHEM(24) = SAVE890
      WCCL(189) = WCCL(189)+CHEMCCL(24)*0.3000000000000000d+00
      CHEM(66) = SAVE889
      WCCL(188) = WCCL(188)+CHEMCCL(66)
      CHEM(63) = SAVE888
      WCCL(188) = WCCL(188)-CHEMCCL(63)
      CHEM(57) = SAVE887
      WCCL(188) = WCCL(188)+CHEMCCL(57)
      CHEM(56) = SAVE886
      WCCL(188) = WCCL(188)-CHEMCCL(56)
      CHEM(71) = SAVE885
      WCCL(187) = WCCL(187)+CHEMCCL(71)
      CHEM(69) = SAVE884
      WCCL(187) = WCCL(187)+CHEMCCL(69)
      CHEM(66) = SAVE883
      WCCL(187) = WCCL(187)+CHEMCCL(66)*0.2000000000000000d+01
      CHEM(63) = SAVE882
      WCCL(187) = WCCL(187)-CHEMCCL(63)
      CHEM(56) = SAVE881
      WCCL(187) = WCCL(187)-CHEMCCL(56)
      CHEM(69) = SAVE880
      WCCL(186) = WCCL(186)-CHEMCCL(69)
      CHEM(66) = SAVE879
      WCCL(186) = WCCL(186)+CHEMCCL(66)
      CHEM(63) = SAVE878
      WCCL(186) = WCCL(186)-CHEMCCL(63)
      CHEM(57) = SAVE877
      WCCL(186) = WCCL(186)+CHEMCCL(57)
      CHEM(71) = SAVE876
      WCCL(185) = WCCL(185)+CHEMCCL(71)
      CHEM(69) = SAVE875
      WCCL(185) = WCCL(185)-CHEMCCL(69)
      CHEM(66) = SAVE874
      WCCL(185) = WCCL(185)+CHEMCCL(66)
      CHEM(71) = SAVE873
      WCCL(184) = WCCL(184)+CHEMCCL(71)*0.2000000000000000d+01
      CHEM(66) = SAVE872
      WCCL(184) = WCCL(184)+CHEMCCL(66)
      CHEM(63) = SAVE871
      WCCL(184) = WCCL(184)-CHEMCCL(63)
      CHEM(54) = SAVE870
      WCCL(184) = WCCL(184)+CHEMCCL(54)
      CHEM(51) = SAVE869
      WCCL(184) = WCCL(184)+CHEMCCL(51)
      CHEM(33) = SAVE868
      WCCL(184) = WCCL(184)-CHEMCCL(33)
      CHEM(71) = SAVE867
      WCCL(183) = WCCL(183)+CHEMCCL(71)
      CHEM(66) = SAVE866
      WCCL(183) = WCCL(183)+CHEMCCL(66)
      CHEM(63) = SAVE865
      WCCL(183) = WCCL(183)-CHEMCCL(63)
      CHEM(54) = SAVE864
      WCCL(183) = WCCL(183)+CHEMCCL(54)*0.6300000000000000d+00
      CHEM(51) = SAVE863
      WCCL(183) = WCCL(183)+CHEMCCL(51)*0.3700000000000000d+00
      CHEM(48) = SAVE862
      WCCL(183) = WCCL(183)+CHEMCCL(48)
      CHEM(32) = SAVE861
      WCCL(183) = WCCL(183)-CHEMCCL(32)
      CHEM(71) = SAVE860
      WCCL(182) = WCCL(182)+CHEMCCL(71)
      CHEM(66) = SAVE859
      WCCL(182) = WCCL(182)+CHEMCCL(66)
      CHEM(63) = SAVE858
      WCCL(182) = WCCL(182)-CHEMCCL(63)
      CHEM(54) = SAVE857
      WCCL(182) = WCCL(182)+CHEMCCL(54)*0.3500000000000000d+00
      CHEM(51) = SAVE856
      WCCL(182) = WCCL(182)+CHEMCCL(51)*0.6500000000000000d+00
      CHEM(48) = SAVE855
      WCCL(182) = WCCL(182)+CHEMCCL(48)
      CHEM(31) = SAVE854
      WCCL(182) = WCCL(182)-CHEMCCL(31)
      CHEM(71) = SAVE853
      WCCL(181) = WCCL(181)+CHEMCCL(71)*0.2000000000000000d+01
      CHEM(66) = SAVE852
      WCCL(181) = WCCL(181)+CHEMCCL(66)*0.1400000000000000d+01
      CHEM(63) = SAVE851
      WCCL(181) = WCCL(181)-CHEMCCL(63)
      CHEM(49) = SAVE850
      WCCL(181) = WCCL(181)+CHEMCCL(49)*0.6000000000000000d+00
      CHEM(44) = SAVE849
      WCCL(181) = WCCL(181)+CHEMCCL(44)*0.4000000000000000d+00
      CHEM(43) = SAVE848
      WCCL(181) = WCCL(181)-CHEMCCL(43)
      CHEM(71) = SAVE847
      WCCL(180) = WCCL(180)+CHEMCCL(71)*0.2000000000000000d+01
      CHEM(66) = SAVE846
      WCCL(180) = WCCL(180)+CHEMCCL(66)
      CHEM(63) = SAVE845
      WCCL(180) = WCCL(180)-CHEMCCL(63)
      CHEM(61) = SAVE844
      WCCL(180) = WCCL(180)+CHEMCCL(61)
      CHEM(59) = SAVE843
      WCCL(180) = WCCL(180)+CHEMCCL(59)
      CHEM(42) = SAVE842
      WCCL(180) = WCCL(180)-CHEMCCL(42)
      CHEM(71) = SAVE841
      WCCL(179) = WCCL(179)+CHEMCCL(71)
      CHEM(66) = SAVE840
      WCCL(179) = WCCL(179)+CHEMCCL(66)*0.1090000000000000d+01
      CHEM(63) = SAVE839
      WCCL(179) = WCCL(179)-CHEMCCL(63)
      CHEM(49) = SAVE838
      WCCL(179) = WCCL(179)+CHEMCCL(49)*0.5500000000000000d+00
      CHEM(44) = SAVE837
      WCCL(179) = WCCL(179)+CHEMCCL(44)*0.8000000000000000d-01
      CHEM(40) = SAVE836
      WCCL(179) = WCCL(179)+CHEMCCL(40)*0.3700000000000000d+00
      CHEM(39) = SAVE835
      WCCL(179) = WCCL(179)-CHEMCCL(39)
      CHEM(71) = SAVE834
      WCCL(178) = WCCL(178)+CHEMCCL(71)
      CHEM(66) = SAVE833
      WCCL(178) = WCCL(178)+CHEMCCL(66)*0.7550000000000000d+00
      CHEM(63) = SAVE832
      WCCL(178) = WCCL(178)-CHEMCCL(63)
      CHEM(61) = SAVE831
      WCCL(178) = WCCL(178)+CHEMCCL(61)*0.9320000000000001d+00
      CHEM(59) = SAVE830
      WCCL(178) = WCCL(178)+CHEMCCL(59)*0.3130000000000000d+00
      CHEM(45) = SAVE829
      WCCL(178) = WCCL(178)-CHEMCCL(45)
      CHEM(71) = SAVE828
      WCCL(177) = WCCL(177)+CHEMCCL(71)
      CHEM(66) = SAVE827
      WCCL(177) = WCCL(177)+CHEMCCL(66)*0.1250000000000000d+01
      CHEM(63) = SAVE826
      WCCL(177) = WCCL(177)-CHEMCCL(63)
      CHEM(61) = SAVE825
      WCCL(177) = WCCL(177)+CHEMCCL(61)*0.6690000000000000d+00
      CHEM(59) = SAVE824
      WCCL(177) = WCCL(177)+CHEMCCL(59)*0.8100000000000000d-01
      CHEM(41) = SAVE823
      WCCL(177) = WCCL(177)-CHEMCCL(41)
      CHEM(71) = SAVE822
      WCCL(176) = WCCL(176)+CHEMCCL(71)
      CHEM(66) = SAVE821
      WCCL(176) = WCCL(176)+CHEMCCL(66)*0.1550000000000000d+01
      CHEM(63) = SAVE820
      WCCL(176) = WCCL(176)-CHEMCCL(63)
      CHEM(61) = SAVE819
      WCCL(176) = WCCL(176)+CHEMCCL(61)*0.3500000000000000d+00
      CHEM(38) = SAVE818
      WCCL(176) = WCCL(176)-CHEMCCL(38)
      CHEM(71) = SAVE817
      WCCL(175) = WCCL(175)+CHEMCCL(71)*0.9930000000000000d+00
      CHEM(66) = SAVE816
      WCCL(175) = WCCL(175)+CHEMCCL(66)*0.7530000000000000d+00
      CHEM(65) = SAVE815
      WCCL(175) = WCCL(175)+CHEMCCL(65)*0.3220000000000000d+00
      CHEM(63) = SAVE814
      WCCL(175) = WCCL(175)-CHEMCCL(63)
      CHEM(61) = SAVE813
      WCCL(175) = WCCL(175)+CHEMCCL(61)*0.4110000000000000d+00
      CHEM(60) = SAVE812
      WCCL(175) = WCCL(175)+CHEMCCL(60)*0.1300000000000000d-01
      CHEM(59) = SAVE811
      WCCL(175) = WCCL(175)+CHEMCCL(59)*0.4190000000000000d+00
      CHEM(37) = SAVE810
      WCCL(175) = WCCL(175)-CHEMCCL(37)
      CHEM(71) = SAVE809
      WCCL(174) = WCCL(174)+CHEMCCL(71)*0.9460000000000000d+00
      CHEM(66) = SAVE808
      WCCL(174) = WCCL(174)+CHEMCCL(66)*0.8290000000000000d+00
      CHEM(65) = SAVE807
      WCCL(174) = WCCL(174)+CHEMCCL(65)*0.2450000000000000d+00
      CHEM(63) = SAVE806
      WCCL(174) = WCCL(174)-CHEMCCL(63)*0.9510000000000000d+00
      CHEM(61) = SAVE805
      WCCL(174) = WCCL(174)+CHEMCCL(61)*0.5230000000000000d+00
      CHEM(60) = SAVE804
      WCCL(174) = WCCL(174)+CHEMCCL(60)*0.1400000000000000d-01
      CHEM(59) = SAVE803
      WCCL(174) = WCCL(174)+CHEMCCL(59)*0.2400000000000000d+00
      CHEM(36) = SAVE802
      WCCL(174) = WCCL(174)-CHEMCCL(36)
      CHEM(71) = SAVE801
      WCCL(173) = WCCL(173)+CHEMCCL(71)*0.9920000000000000d+00
      CHEM(66) = SAVE800
      WCCL(173) = WCCL(173)+CHEMCCL(66)*0.8100000000000001d+00
      CHEM(65) = SAVE799
      WCCL(173) = WCCL(173)+CHEMCCL(65)*0.8500000000000001d-01
      CHEM(64) = SAVE798
      WCCL(173) = WCCL(173)-CHEMCCL(64)
      CHEM(63) = SAVE797
      WCCL(173) = WCCL(173)-CHEMCCL(63)*0.9930000000000000d+00
      CHEM(61) = SAVE796
      WCCL(173) = WCCL(173)+CHEMCCL(61)*0.5800000000000000d+00
      CHEM(59) = SAVE795
      WCCL(173) = WCCL(173)+CHEMCCL(59)*0.1800000000000000d-01
      CHEM(54) = SAVE794
      WCCL(173) = WCCL(173)+CHEMCCL(54)*0.5000000000000000d-02
      CHEM(51) = SAVE793
      WCCL(173) = WCCL(173)+CHEMCCL(51)*0.1190000000000000d+00
      CHEM(71) = SAVE792
      WCCL(172) = WCCL(172)+CHEMCCL(71)
      CHEM(66) = SAVE791
      WCCL(172) = WCCL(172)+CHEMCCL(66)*0.7500000000000000d+00
      CHEM(63) = SAVE790
      WCCL(172) = WCCL(172)-CHEMCCL(63)
      CHEM(61) = SAVE789
      WCCL(172) = WCCL(172)+CHEMCCL(61)*0.7500000000000000d+00
      CHEM(60) = SAVE788
      WCCL(172) = WCCL(172)-CHEMCCL(60)
      CHEM(71) = SAVE787
      WCCL(171) = WCCL(171)+CHEMCCL(71)*0.6600000000000000d+00
      CHEM(66) = SAVE786
      WCCL(171) = WCCL(171)+CHEMCCL(66)*0.1330000000000000d+01
      CHEM(63) = SAVE785
      WCCL(171) = WCCL(171)-CHEMCCL(63)*0.2000000000000000d+01
      CHEM(71) = SAVE784
      WCCL(170) = WCCL(170)-CHEMCCL(71)
      CHEM(70) = SAVE783
      WCCL(170) = WCCL(170)+CHEMCCL(70)
      CHEM(46) = SAVE782
      WCCL(170) = WCCL(170)-CHEMCCL(46)
      CHEM(71) = SAVE781
      WCCL(169) = WCCL(169)-CHEMCCL(71)
      CHEM(70) = SAVE780
      WCCL(169) = WCCL(169)+CHEMCCL(70)
      CHEM(47) = SAVE779
      WCCL(169) = WCCL(169)-CHEMCCL(47)
      CHEM(71) = SAVE778
      WCCL(168) = WCCL(168)-CHEMCCL(71)
      CHEM(58) = SAVE777
      WCCL(168) = WCCL(168)-CHEMCCL(58)
      CHEM(53) = SAVE776
      WCCL(168) = WCCL(168)+CHEMCCL(53)
      CHEM(71) = SAVE775
      WCCL(167) = WCCL(167)-CHEMCCL(71)
      CHEM(57) = SAVE774
      WCCL(167) = WCCL(167)+CHEMCCL(57)
      CHEM(56) = SAVE773
      WCCL(167) = WCCL(167)-CHEMCCL(56)
      CHEM(50) = SAVE772
      WCCL(167) = WCCL(167)+CHEMCCL(50)
      CHEM(71) = SAVE771
      WCCL(166) = WCCL(166)-CHEMCCL(71)
      CHEM(56) = SAVE770
      WCCL(166) = WCCL(166)-CHEMCCL(56)
      CHEM(53) = SAVE769
      WCCL(166) = WCCL(166)+CHEMCCL(53)
      CHEM(71) = SAVE768
      WCCL(165) = WCCL(165)-CHEMCCL(71)
      CHEM(69) = SAVE767
      WCCL(165) = WCCL(165)-CHEMCCL(69)
      CHEM(57) = SAVE766
      WCCL(165) = WCCL(165)+CHEMCCL(57)
      CHEM(50) = SAVE765
      WCCL(165) = WCCL(165)+CHEMCCL(50)
      CHEM(71) = SAVE764
      WCCL(164) = WCCL(164)-CHEMCCL(71)
      CHEM(69) = SAVE763
      WCCL(164) = WCCL(164)-CHEMCCL(69)
      CHEM(28) = SAVE762
      WCCL(164) = WCCL(164)+CHEMCCL(28)
      CHEM(71) = SAVE761
      WCCL(163) = WCCL(163)-CHEMCCL(71)
      CHEM(53) = SAVE760
      WCCL(163) = WCCL(163)+CHEMCCL(53)
      CHEM(33) = SAVE759
      WCCL(163) = WCCL(163)-CHEMCCL(33)
      CHEM(71) = SAVE758
      WCCL(162) = WCCL(162)-CHEMCCL(71)
      CHEM(53) = SAVE757
      WCCL(162) = WCCL(162)+CHEMCCL(53)
      CHEM(32) = SAVE756
      WCCL(162) = WCCL(162)-CHEMCCL(32)
      CHEM(71) = SAVE755
      WCCL(161) = WCCL(161)-CHEMCCL(71)
      CHEM(53) = SAVE754
      WCCL(161) = WCCL(161)+CHEMCCL(53)
      CHEM(31) = SAVE753
      WCCL(161) = WCCL(161)-CHEMCCL(31)
      CHEM(71) = SAVE752
      WCCL(160) = WCCL(160)-CHEMCCL(71)
      CHEM(53) = SAVE751
      WCCL(160) = WCCL(160)+CHEMCCL(53)
      CHEM(43) = SAVE750
      WCCL(160) = WCCL(160)-CHEMCCL(43)
      CHEM(71) = SAVE749
      WCCL(159) = WCCL(159)-CHEMCCL(71)
      CHEM(53) = SAVE748
      WCCL(159) = WCCL(159)+CHEMCCL(53)
      CHEM(42) = SAVE747
      WCCL(159) = WCCL(159)-CHEMCCL(42)
      CHEM(71) = SAVE746
      WCCL(158) = WCCL(158)-CHEMCCL(71)
      CHEM(53) = SAVE745
      WCCL(158) = WCCL(158)+CHEMCCL(53)
      CHEM(39) = SAVE744
      WCCL(158) = WCCL(158)-CHEMCCL(39)
      CHEM(71) = SAVE743
      WCCL(157) = WCCL(157)-CHEMCCL(71)
      CHEM(53) = SAVE742
      WCCL(157) = WCCL(157)+CHEMCCL(53)
      CHEM(45) = SAVE741
      WCCL(157) = WCCL(157)-CHEMCCL(45)
      CHEM(71) = SAVE740
      WCCL(156) = WCCL(156)-CHEMCCL(71)
      CHEM(53) = SAVE739
      WCCL(156) = WCCL(156)+CHEMCCL(53)
      CHEM(41) = SAVE738
      WCCL(156) = WCCL(156)-CHEMCCL(41)
      CHEM(71) = SAVE737
      WCCL(155) = WCCL(155)-CHEMCCL(71)
      CHEM(53) = SAVE736
      WCCL(155) = WCCL(155)+CHEMCCL(53)
      CHEM(38) = SAVE735
      WCCL(155) = WCCL(155)-CHEMCCL(38)
      CHEM(71) = SAVE734
      WCCL(154) = WCCL(154)-CHEMCCL(71)
      CHEM(53) = SAVE733
      WCCL(154) = WCCL(154)+CHEMCCL(53)
      CHEM(37) = SAVE732
      WCCL(154) = WCCL(154)-CHEMCCL(37)
      CHEM(71) = SAVE731
      WCCL(153) = WCCL(153)-CHEMCCL(71)
      CHEM(53) = SAVE730
      WCCL(153) = WCCL(153)+CHEMCCL(53)
      CHEM(36) = SAVE729
      WCCL(153) = WCCL(153)-CHEMCCL(36)
      CHEM(71) = SAVE728
      WCCL(152) = WCCL(152)-CHEMCCL(71)
      CHEM(64) = SAVE727
      WCCL(152) = WCCL(152)-CHEMCCL(64)
      CHEM(53) = SAVE726
      WCCL(152) = WCCL(152)+CHEMCCL(53)
      CHEM(71) = SAVE725
      WCCL(151) = WCCL(151)-CHEMCCL(71)
      CHEM(60) = SAVE724
      WCCL(151) = WCCL(151)-CHEMCCL(60)
      CHEM(53) = SAVE723
      WCCL(151) = WCCL(151)+CHEMCCL(53)
      CHEM(71) = SAVE722
      WCCL(150) = WCCL(150)-CHEMCCL(71)
      CHEM(63) = SAVE721
      WCCL(150) = WCCL(150)-CHEMCCL(63)
      CHEM(16) = SAVE720
      WCCL(150) = WCCL(150)+CHEMCCL(16)
      CHEM(72) = SAVE719
      WCCL(149) = WCCL(149)+CHEMCCL(72)*0.2000000000000000d+01
      CHEM(67) = SAVE718
      WCCL(149) = WCCL(149)-CHEMCCL(67)
      CHEM(66) = SAVE717
      WCCL(149) = WCCL(149)+CHEMCCL(66)*0.2870000000000000d+00
      CHEM(61) = SAVE716
      WCCL(149) = WCCL(149)+CHEMCCL(61)*0.1240000000000000d+01
      CHEM(59) = SAVE715
      WCCL(149) = WCCL(149)+CHEMCCL(59)*0.4640000000000000d+00
      CHEM(46) = SAVE714
      WCCL(149) = WCCL(149)-CHEMCCL(46)
      CHEM(72) = SAVE713
      WCCL(148) = WCCL(148)+CHEMCCL(72)
      CHEM(71) = SAVE712
      WCCL(148) = WCCL(148)+CHEMCCL(71)
      CHEM(70) = SAVE711
      WCCL(148) = WCCL(148)+CHEMCCL(70)
      CHEM(67) = SAVE710
      WCCL(148) = WCCL(148)-CHEMCCL(67)
      CHEM(47) = SAVE709
      WCCL(148) = WCCL(148)-CHEMCCL(47)
      CHEM(72) = SAVE708
      WCCL(147) = WCCL(147)+CHEMCCL(72)
      CHEM(71) = SAVE707
      WCCL(147) = WCCL(147)+CHEMCCL(71)*0.7700000000000000d+00
      CHEM(69) = SAVE706
      WCCL(147) = WCCL(147)+CHEMCCL(69)*0.2300000000000000d+00
      CHEM(67) = SAVE705
      WCCL(147) = WCCL(147)-CHEMCCL(67)
      CHEM(65) = SAVE704
      WCCL(147) = WCCL(147)+CHEMCCL(65)*0.1600000000000000d+00
      CHEM(61) = SAVE703
      WCCL(147) = WCCL(147)+CHEMCCL(61)*0.4600000000000000d+00
      CHEM(58) = SAVE702
      WCCL(147) = WCCL(147)-CHEMCCL(58)
      CHEM(54) = SAVE701
      WCCL(147) = WCCL(147)+CHEMCCL(54)*0.5400000000000000d+00
      CHEM(72) = SAVE700
      WCCL(146) = WCCL(146)+CHEMCCL(72)
      CHEM(69) = SAVE699
      WCCL(146) = WCCL(146)+CHEMCCL(69)
      CHEM(67) = SAVE698
      WCCL(146) = WCCL(146)-CHEMCCL(67)
      CHEM(66) = SAVE697
      WCCL(146) = WCCL(146)+CHEMCCL(66)
      CHEM(56) = SAVE696
      WCCL(146) = WCCL(146)-CHEMCCL(56)
      CHEM(72) = SAVE695
      WCCL(145) = WCCL(145)+CHEMCCL(72)
      CHEM(69) = SAVE694
      WCCL(145) = WCCL(145)-CHEMCCL(69)
      CHEM(67) = SAVE693
      WCCL(145) = WCCL(145)-CHEMCCL(67)
      CHEM(63) = SAVE692
      WCCL(145) = WCCL(145)+CHEMCCL(63)
      CHEM(72) = SAVE691
      WCCL(144) = WCCL(144)+CHEMCCL(72)
      CHEM(71) = SAVE690
      WCCL(144) = WCCL(144)+CHEMCCL(71)
      CHEM(67) = SAVE689
      WCCL(144) = WCCL(144)-CHEMCCL(67)
      CHEM(54) = SAVE688
      WCCL(144) = WCCL(144)+CHEMCCL(54)
      CHEM(51) = SAVE687
      WCCL(144) = WCCL(144)+CHEMCCL(51)
      CHEM(33) = SAVE686
      WCCL(144) = WCCL(144)-CHEMCCL(33)
      CHEM(72) = SAVE685
      WCCL(143) = WCCL(143)+CHEMCCL(72)*0.9500000000000000d+00
      CHEM(71) = SAVE684
      WCCL(143) = WCCL(143)+CHEMCCL(71)*0.9500000000000000d+00
      CHEM(70) = SAVE683
      WCCL(143) = WCCL(143)+CHEMCCL(70)*0.5000000000000000d-01
      CHEM(67) = SAVE682
      WCCL(143) = WCCL(143)-CHEMCCL(67)
      CHEM(54) = SAVE681
      WCCL(143) = WCCL(143)+CHEMCCL(54)*0.6000000000000000d+00
      CHEM(51) = SAVE680
      WCCL(143) = WCCL(143)+CHEMCCL(51)*0.3500000000000000d+00
      CHEM(48) = SAVE679
      WCCL(143) = WCCL(143)+CHEMCCL(48)*0.9500000000000000d+00
      CHEM(32) = SAVE678
      WCCL(143) = WCCL(143)-CHEMCCL(32)
      CHEM(72) = SAVE677
      WCCL(142) = WCCL(142)+CHEMCCL(72)*0.9500000000000000d+00
      CHEM(71) = SAVE676
      WCCL(142) = WCCL(142)+CHEMCCL(71)*0.9500000000000000d+00
      CHEM(70) = SAVE675
      WCCL(142) = WCCL(142)+CHEMCCL(70)*0.5000000000000000d-01
      CHEM(67) = SAVE674
      WCCL(142) = WCCL(142)-CHEMCCL(67)
      CHEM(54) = SAVE673
      WCCL(142) = WCCL(142)+CHEMCCL(54)*0.6500000000000000d+00
      CHEM(51) = SAVE672
      WCCL(142) = WCCL(142)+CHEMCCL(51)*0.1200000000000000d+01
      CHEM(48) = SAVE671
      WCCL(142) = WCCL(142)+CHEMCCL(48)*0.5000000000000000d+00
      CHEM(31) = SAVE670
      WCCL(142) = WCCL(142)-CHEMCCL(31)
      CHEM(72) = SAVE669
      WCCL(141) = WCCL(141)+CHEMCCL(72)*0.6500000000000000d+00
      CHEM(71) = SAVE668
      WCCL(141) = WCCL(141)+CHEMCCL(71)*0.6500000000000000d+00
      CHEM(70) = SAVE667
      WCCL(141) = WCCL(141)+CHEMCCL(70)*0.3500000000000000d+00
      CHEM(67) = SAVE666
      WCCL(141) = WCCL(141)-CHEMCCL(67)
      CHEM(66) = SAVE665
      WCCL(141) = WCCL(141)+CHEMCCL(66)*0.2500000000000000d+00
      CHEM(49) = SAVE664
      WCCL(141) = WCCL(141)+CHEMCCL(49)*0.4000000000000000d+00
      CHEM(44) = SAVE663
      WCCL(141) = WCCL(141)+CHEMCCL(44)*0.2500000000000000d+00
      CHEM(43) = SAVE662
      WCCL(141) = WCCL(141)-CHEMCCL(43)
      CHEM(72) = SAVE661
      WCCL(140) = WCCL(140)+CHEMCCL(72)*0.8000000000000000d+00
      CHEM(71) = SAVE660
      WCCL(140) = WCCL(140)+CHEMCCL(71)*0.8000000000000000d+00
      CHEM(70) = SAVE659
      WCCL(140) = WCCL(140)+CHEMCCL(70)*0.2000000000000000d+00
      CHEM(67) = SAVE658
      WCCL(140) = WCCL(140)-CHEMCCL(67)
      CHEM(61) = SAVE657
      WCCL(140) = WCCL(140)+CHEMCCL(61)*0.8000000000000000d+00
      CHEM(59) = SAVE656
      WCCL(140) = WCCL(140)+CHEMCCL(59)*0.8000000000000000d+00
      CHEM(42) = SAVE655
      WCCL(140) = WCCL(140)-CHEMCCL(42)
      CHEM(72) = SAVE654
      WCCL(139) = WCCL(139)+CHEMCCL(72)*0.8470000000000000d+00
      CHEM(71) = SAVE653
      WCCL(139) = WCCL(139)+CHEMCCL(71)*0.8470000000000000d+00
      CHEM(70) = SAVE652
      WCCL(139) = WCCL(139)+CHEMCCL(70)*0.1530000000000000d+00
      CHEM(67) = SAVE651
      WCCL(139) = WCCL(139)-CHEMCCL(67)
      CHEM(66) = SAVE650
      WCCL(139) = WCCL(139)+CHEMCCL(66)*0.6060000000000000d+00
      CHEM(49) = SAVE649
      WCCL(139) = WCCL(139)+CHEMCCL(49)*0.4460000000000000d+00
      CHEM(40) = SAVE648
      WCCL(139) = WCCL(139)+CHEMCCL(40)*0.3540000000000000d+00
      CHEM(39) = SAVE647
      WCCL(139) = WCCL(139)-CHEMCCL(39)
      CHEM(72) = SAVE646
      WCCL(138) = WCCL(138)+CHEMCCL(72)
      CHEM(71) = SAVE645
      WCCL(138) = WCCL(138)+CHEMCCL(71)
      CHEM(67) = SAVE644
      WCCL(138) = WCCL(138)-CHEMCCL(67)
      CHEM(61) = SAVE643
      WCCL(138) = WCCL(138)+CHEMCCL(61)*0.1710000000000000d+01
      CHEM(59) = SAVE642
      WCCL(138) = WCCL(138)+CHEMCCL(59)*0.2900000000000000d+00
      CHEM(45) = SAVE641
      WCCL(138) = WCCL(138)-CHEMCCL(45)
      CHEM(72) = SAVE640
      WCCL(137) = WCCL(137)+CHEMCCL(72)
      CHEM(71) = SAVE639
      WCCL(137) = WCCL(137)+CHEMCCL(71)
      CHEM(67) = SAVE638
      WCCL(137) = WCCL(137)-CHEMCCL(67)
      CHEM(66) = SAVE637
      WCCL(137) = WCCL(137)+CHEMCCL(66)
      CHEM(61) = SAVE636
      WCCL(137) = WCCL(137)+CHEMCCL(61)*0.9399999999999999d+00
      CHEM(59) = SAVE635
      WCCL(137) = WCCL(137)+CHEMCCL(59)*0.6000000000000000d-01
      CHEM(41) = SAVE634
      WCCL(137) = WCCL(137)-CHEMCCL(41)
      CHEM(72) = SAVE633
      WCCL(136) = WCCL(136)+CHEMCCL(72)
      CHEM(71) = SAVE632
      WCCL(136) = WCCL(136)+CHEMCCL(71)
      CHEM(67) = SAVE631
      WCCL(136) = WCCL(136)-CHEMCCL(67)
      CHEM(66) = SAVE630
      WCCL(136) = WCCL(136)+CHEMCCL(66)*0.1600000000000000d+01
      CHEM(61) = SAVE629
      WCCL(136) = WCCL(136)+CHEMCCL(61)*0.2000000000000000d+00
      CHEM(38) = SAVE628
      WCCL(136) = WCCL(136)-CHEMCCL(38)
      CHEM(72) = SAVE627
      WCCL(135) = WCCL(135)+CHEMCCL(72)*0.7390000000000000d+00
      CHEM(71) = SAVE626
      WCCL(135) = WCCL(135)+CHEMCCL(71)*0.6060000000000000d+00
      CHEM(70) = SAVE625
      WCCL(135) = WCCL(135)+CHEMCCL(70)*0.2610000000000000d+00
      CHEM(67) = SAVE624
      WCCL(135) = WCCL(135)-CHEMCCL(67)
      CHEM(65) = SAVE623
      WCCL(135) = WCCL(135)+CHEMCCL(65)*0.4160000000000000d+00
      CHEM(61) = SAVE622
      WCCL(135) = WCCL(135)+CHEMCCL(61)*0.1500000000000000d+00
      CHEM(60) = SAVE621
      WCCL(135) = WCCL(135)+CHEMCCL(60)*0.1330000000000000d+00
      CHEM(59) = SAVE620
      WCCL(135) = WCCL(135)+CHEMCCL(59)*0.6420000000000000d+00
      CHEM(37) = SAVE619
      WCCL(135) = WCCL(135)-CHEMCCL(37)
      CHEM(72) = SAVE618
      WCCL(134) = WCCL(134)+CHEMCCL(72)*0.8760000000000000d+00
      CHEM(71) = SAVE617
      WCCL(134) = WCCL(134)+CHEMCCL(71)*0.5990000000000000d+00
      CHEM(70) = SAVE616
      WCCL(134) = WCCL(134)+CHEMCCL(70)*0.1240000000000000d+00
      CHEM(67) = SAVE615
      WCCL(134) = WCCL(134)-CHEMCCL(67)
      CHEM(66) = SAVE614
      WCCL(134) = WCCL(134)+CHEMCCL(66)*0.2100000000000000d-01
      CHEM(65) = SAVE613
      WCCL(134) = WCCL(134)+CHEMCCL(65)*0.3340000000000000d+00
      CHEM(63) = SAVE612
      WCCL(134) = WCCL(134)+CHEMCCL(63)*0.3100000000000000d-01
      CHEM(61) = SAVE611
      WCCL(134) = WCCL(134)+CHEMCCL(61)*0.2110000000000000d+00
      CHEM(60) = SAVE610
      WCCL(134) = WCCL(134)+CHEMCCL(60)*0.2450000000000000d+00
      CHEM(59) = SAVE609
      WCCL(134) = WCCL(134)+CHEMCCL(59)*0.7220000000000000d+00
      CHEM(36) = SAVE608
      WCCL(134) = WCCL(134)-CHEMCCL(36)
      CHEM(72) = SAVE607
      WCCL(133) = WCCL(133)+CHEMCCL(72)*0.9409999999999999d+00
      CHEM(71) = SAVE606
      WCCL(133) = WCCL(133)+CHEMCCL(71)*0.7420000000000000d+00
      CHEM(70) = SAVE605
      WCCL(133) = WCCL(133)+CHEMCCL(70)*0.5900000000000000d-01
      CHEM(67) = SAVE604
      WCCL(133) = WCCL(133)-CHEMCCL(67)
      CHEM(66) = SAVE603
      WCCL(133) = WCCL(133)+CHEMCCL(66)*0.4700000000000000d-01
      CHEM(65) = SAVE602
      WCCL(133) = WCCL(133)+CHEMCCL(65)*0.4800000000000000d-01
      CHEM(64) = SAVE601
      WCCL(133) = WCCL(133)-CHEMCCL(64)
      CHEM(63) = SAVE600
      WCCL(133) = WCCL(133)+CHEMCCL(63)*0.1500000000000000d+00
      CHEM(61) = SAVE599
      WCCL(133) = WCCL(133)+CHEMCCL(61)*0.2330000000000000d+00
      CHEM(60) = SAVE598
      WCCL(133) = WCCL(133)+CHEMCCL(60)*0.4800000000000000d-01
      CHEM(59) = SAVE597
      WCCL(133) = WCCL(133)+CHEMCCL(59)*0.6230000000000000d+00
      CHEM(51) = SAVE596
      WCCL(133) = WCCL(133)+CHEMCCL(51)*0.6300000000000000d-01
      CHEM(72) = SAVE595
      WCCL(132) = WCCL(132)+CHEMCCL(72)
      CHEM(71) = SAVE594
      WCCL(132) = WCCL(132)+CHEMCCL(71)
      CHEM(67) = SAVE593
      WCCL(132) = WCCL(132)-CHEMCCL(67)
      CHEM(61) = SAVE592
      WCCL(132) = WCCL(132)+CHEMCCL(61)
      CHEM(60) = SAVE591
      WCCL(132) = WCCL(132)-CHEMCCL(60)
      CHEM(72) = SAVE590
      WCCL(131) = WCCL(131)+CHEMCCL(72)
      CHEM(71) = SAVE589
      WCCL(131) = WCCL(131)+CHEMCCL(71)
      CHEM(67) = SAVE588
      WCCL(131) = WCCL(131)-CHEMCCL(67)
      CHEM(66) = SAVE587
      WCCL(131) = WCCL(131)+CHEMCCL(66)
      CHEM(63) = SAVE586
      WCCL(131) = WCCL(131)-CHEMCCL(63)
      CHEM(72) = SAVE585
      WCCL(130) = WCCL(130)+CHEMCCL(72)
      CHEM(56) = SAVE584
      WCCL(130) = WCCL(130)+CHEMCCL(56)
      CHEM(25) = SAVE583
      WCCL(130) = WCCL(130)-CHEMCCL(25)
      CHEM(72) = SAVE582
      WCCL(129) = WCCL(129)-CHEMCCL(72)
      CHEM(56) = SAVE581
      WCCL(129) = WCCL(129)-CHEMCCL(56)
      CHEM(25) = SAVE580
      WCCL(129) = WCCL(129)+CHEMCCL(25)
      CHEM(72) = SAVE579
      WCCL(128) = WCCL(128)+CHEMCCL(72)
      CHEM(69) = SAVE578
      WCCL(128) = WCCL(128)+CHEMCCL(69)
      CHEM(26) = SAVE577
      WCCL(128) = WCCL(128)-CHEMCCL(26)
      CHEM(72) = SAVE576
      WCCL(127) = WCCL(127)-CHEMCCL(72)
      CHEM(69) = SAVE575
      WCCL(127) = WCCL(127)-CHEMCCL(69)
      CHEM(26) = SAVE574
      WCCL(127) = WCCL(127)+CHEMCCL(26)
      CHEM(62) = SAVE573
      WCCL(126) = WCCL(126)+CHEMCCL(62)
      CHEM(50) = SAVE572
      WCCL(126) = WCCL(126)-CHEMCCL(50)
      CHEM(30) = SAVE571
      WCCL(126) = WCCL(126)+CHEMCCL(30)
      CHEM(22) = SAVE570
      WCCL(126) = WCCL(126)-CHEMCCL(22)
      CHEM(71) = SAVE569
      WCCL(125) = WCCL(125)+CHEMCCL(71)*0.2000000000000000d-01
      CHEM(33) = SAVE568
      WCCL(125) = WCCL(125)+CHEMCCL(33)*0.9800000000000000d+00
      CHEM(30) = SAVE567
      WCCL(125) = WCCL(125)+CHEMCCL(30)*0.2000000000000000d-01
      CHEM(22) = SAVE566
      WCCL(125) = WCCL(125)-CHEMCCL(22)
      CHEM(72) = SAVE565
      WCCL(124) = WCCL(124)-CHEMCCL(72)
      CHEM(30) = SAVE564
      WCCL(124) = WCCL(124)+CHEMCCL(30)
      CHEM(23) = SAVE563
      WCCL(124) = WCCL(124)+CHEMCCL(23)
      CHEM(22) = SAVE562
      WCCL(124) = WCCL(124)-CHEMCCL(22)
      CHEM(62) = SAVE561
      WCCL(123) = WCCL(123)+CHEMCCL(62)
      CHEM(50) = SAVE560
      WCCL(123) = WCCL(123)-CHEMCCL(50)
      CHEM(30) = SAVE559
      WCCL(123) = WCCL(123)+CHEMCCL(30)
      CHEM(18) = SAVE558
      WCCL(123) = WCCL(123)-CHEMCCL(18)
      CHEM(71) = SAVE557
      WCCL(122) = WCCL(122)+CHEMCCL(71)*0.2000000000000000d-01
      CHEM(32) = SAVE556
      WCCL(122) = WCCL(122)+CHEMCCL(32)*0.9800000000000000d+00
      CHEM(30) = SAVE555
      WCCL(122) = WCCL(122)+CHEMCCL(30)*0.2000000000000000d-01
      CHEM(18) = SAVE554
      WCCL(122) = WCCL(122)-CHEMCCL(18)
      CHEM(72) = SAVE553
      WCCL(121) = WCCL(121)-CHEMCCL(72)
      CHEM(30) = SAVE552
      WCCL(121) = WCCL(121)+CHEMCCL(30)
      CHEM(23) = SAVE551
      WCCL(121) = WCCL(121)+CHEMCCL(23)
      CHEM(18) = SAVE550
      WCCL(121) = WCCL(121)-CHEMCCL(18)
      CHEM(62) = SAVE549
      WCCL(120) = WCCL(120)+CHEMCCL(62)
      CHEM(50) = SAVE548
      WCCL(120) = WCCL(120)-CHEMCCL(50)
      CHEM(30) = SAVE547
      WCCL(120) = WCCL(120)+CHEMCCL(30)
      CHEM(17) = SAVE546
      WCCL(120) = WCCL(120)-CHEMCCL(17)
      CHEM(71) = SAVE545
      WCCL(119) = WCCL(119)+CHEMCCL(71)*0.2000000000000000d-01
      CHEM(31) = SAVE544
      WCCL(119) = WCCL(119)+CHEMCCL(31)*0.9800000000000000d+00
      CHEM(30) = SAVE543
      WCCL(119) = WCCL(119)+CHEMCCL(30)*0.2000000000000000d-01
      CHEM(17) = SAVE542
      WCCL(119) = WCCL(119)-CHEMCCL(17)
      CHEM(72) = SAVE541
      WCCL(118) = WCCL(118)-CHEMCCL(72)
      CHEM(30) = SAVE540
      WCCL(118) = WCCL(118)+CHEMCCL(30)
      CHEM(23) = SAVE539
      WCCL(118) = WCCL(118)+CHEMCCL(23)
      CHEM(17) = SAVE538
      WCCL(118) = WCCL(118)-CHEMCCL(17)
      CHEM(71) = SAVE537
      WCCL(117) = WCCL(117)-CHEMCCL(71)
      CHEM(30) = SAVE536
      WCCL(117) = WCCL(117)+CHEMCCL(30)
      CHEM(29) = SAVE535
      WCCL(117) = WCCL(117)-CHEMCCL(29)
      CHEM(72) = SAVE534
      WCCL(116) = WCCL(116)-CHEMCCL(72)
      CHEM(70) = SAVE533
      WCCL(116) = WCCL(116)+CHEMCCL(70)
      CHEM(30) = SAVE532
      WCCL(116) = WCCL(116)+CHEMCCL(30)*0.1000000000000000d+00
      CHEM(29) = SAVE531
      WCCL(116) = WCCL(116)-CHEMCCL(29)
      CHEM(72) = SAVE530
      WCCL(115) = WCCL(115)+CHEMCCL(72)*0.7000000000000000d+00
      CHEM(71) = SAVE529
      WCCL(115) = WCCL(115)+CHEMCCL(71)*0.8000000000000000d-01
      CHEM(69) = SAVE528
      WCCL(115) = WCCL(115)+CHEMCCL(69)*0.7000000000000000d+00
      CHEM(66) = SAVE527
      WCCL(115) = WCCL(115)+CHEMCCL(66)*0.7000000000000000d+00
      CHEM(62) = SAVE526
      WCCL(115) = WCCL(115)+CHEMCCL(62)*0.3600000000000000d-01
      CHEM(52) = SAVE525
      WCCL(115) = WCCL(115)+CHEMCCL(52)*0.1300000000000000d+00
      CHEM(50) = SAVE524
      WCCL(115) = WCCL(115)-CHEMCCL(50)
      CHEM(34) = SAVE523
      WCCL(115) = WCCL(115)+CHEMCCL(34)*0.1100000000000000d+00
      CHEM(26) = SAVE522
      WCCL(115) = WCCL(115)+CHEMCCL(26)*0.3000000000000000d+00
      CHEM(25) = SAVE521
      WCCL(115) = WCCL(115)-CHEMCCL(25)
      CHEM(71) = SAVE520
      WCCL(114) = WCCL(114)+CHEMCCL(71)*0.2900000000000000d+00
      CHEM(69) = SAVE519
      WCCL(114) = WCCL(114)+CHEMCCL(69)*0.2800000000000000d+00
      CHEM(62) = SAVE518
      WCCL(114) = WCCL(114)+CHEMCCL(62)*0.2100000000000000d+00
      CHEM(61) = SAVE517
      WCCL(114) = WCCL(114)+CHEMCCL(61)*0.1600000000000000d+00
      CHEM(57) = SAVE516
      WCCL(114) = WCCL(114)+CHEMCCL(57)*0.2100000000000000d+00
      CHEM(54) = SAVE515
      WCCL(114) = WCCL(114)+CHEMCCL(54)*0.6200000000000000d+00
      CHEM(52) = SAVE514
      WCCL(114) = WCCL(114)+CHEMCCL(52)*0.6600000000000000d+00
      CHEM(51) = SAVE513
      WCCL(114) = WCCL(114)+CHEMCCL(51)*0.5000000000000000d+00
      CHEM(50) = SAVE512
      WCCL(114) = WCCL(114)-CHEMCCL(50)
      CHEM(48) = SAVE511
      WCCL(114) = WCCL(114)-CHEMCCL(48)
      CHEM(34) = SAVE510
      WCCL(114) = WCCL(114)+CHEMCCL(34)*0.1100000000000000d+00
      CHEM(28) = SAVE509
      WCCL(114) = WCCL(114)+CHEMCCL(28)*0.1100000000000000d+00
      CHEM(71) = SAVE508
      WCCL(113) = WCCL(113)+CHEMCCL(71)*0.2900000000000000d+00
      CHEM(69) = SAVE507
      WCCL(113) = WCCL(113)+CHEMCCL(69)*0.1300000000000000d+00
      CHEM(66) = SAVE506
      WCCL(113) = WCCL(113)+CHEMCCL(66)*0.4000000000000000d+00
      CHEM(62) = SAVE505
      WCCL(113) = WCCL(113)+CHEMCCL(62)*0.7000000000000001d-01
      CHEM(57) = SAVE504
      WCCL(113) = WCCL(113)+CHEMCCL(57)*0.1300000000000000d+00
      CHEM(54) = SAVE503
      WCCL(113) = WCCL(113)+CHEMCCL(54)*0.6000000000000000d+00
      CHEM(53) = SAVE502
      WCCL(113) = WCCL(113)+CHEMCCL(53)*0.1300000000000000d+00
      CHEM(52) = SAVE501
      WCCL(113) = WCCL(113)+CHEMCCL(52)*0.5400000000000000d+00
      CHEM(50) = SAVE500
      WCCL(113) = WCCL(113)-CHEMCCL(50)
      CHEM(49) = SAVE499
      WCCL(113) = WCCL(113)-CHEMCCL(49)
      CHEM(34) = SAVE498
      WCCL(113) = WCCL(113)+CHEMCCL(34)*0.2200000000000000d+00
      CHEM(71) = SAVE497
      WCCL(112) = WCCL(112)+CHEMCCL(71)*0.1000000000000000d+00
      CHEM(66) = SAVE496
      WCCL(112) = WCCL(112)+CHEMCCL(66)*0.4000000000000000d-01
      CHEM(62) = SAVE495
      WCCL(112) = WCCL(112)+CHEMCCL(62)*0.8500000000000000d+00
      CHEM(60) = SAVE494
      WCCL(112) = WCCL(112)+CHEMCCL(60)*0.1600000000000000d+00
      CHEM(58) = SAVE493
      WCCL(112) = WCCL(112)+CHEMCCL(58)*0.4200000000000000d+00
      CHEM(57) = SAVE492
      WCCL(112) = WCCL(112)+CHEMCCL(57)*0.7000000000000001d-01
      CHEM(52) = SAVE491
      WCCL(112) = WCCL(112)+CHEMCCL(52)*0.1400000000000000d+00
      CHEM(50) = SAVE490
      WCCL(112) = WCCL(112)-CHEMCCL(50)
      CHEM(49) = SAVE489
      WCCL(112) = WCCL(112)+CHEMCCL(49)*0.7900000000000000d+00
      CHEM(40) = SAVE488
      WCCL(112) = WCCL(112)+CHEMCCL(40)*0.4600000000000000d+00
      CHEM(34) = SAVE487
      WCCL(112) = WCCL(112)+CHEMCCL(34)*0.1000000000000000d-01
      CHEM(27) = SAVE486
      WCCL(112) = WCCL(112)+CHEMCCL(27)*0.2000000000000000d-01
      CHEM(14) = SAVE485
      WCCL(112) = WCCL(112)-CHEMCCL(14)
      CHEM(71) = SAVE484
      WCCL(111) = WCCL(111)+CHEMCCL(71)*0.1000000000000000d+00
      CHEM(62) = SAVE483
      WCCL(111) = WCCL(111)+CHEMCCL(62)*0.8500000000000000d+00
      CHEM(61) = SAVE482
      WCCL(111) = WCCL(111)+CHEMCCL(61)*0.6500000000000000d+00
      CHEM(60) = SAVE481
      WCCL(111) = WCCL(111)+CHEMCCL(60)*0.2000000000000000d+00
      CHEM(59) = SAVE480
      WCCL(111) = WCCL(111)+CHEMCCL(59)*0.5300000000000000d+00
      CHEM(58) = SAVE479
      WCCL(111) = WCCL(111)+CHEMCCL(58)*0.4200000000000000d+00
      CHEM(52) = SAVE478
      WCCL(111) = WCCL(111)+CHEMCCL(52)*0.1400000000000000d+00
      CHEM(50) = SAVE477
      WCCL(111) = WCCL(111)-CHEMCCL(50)
      CHEM(27) = SAVE476
      WCCL(111) = WCCL(111)+CHEMCCL(27)*0.2000000000000000d-01
      CHEM(13) = SAVE475
      WCCL(111) = WCCL(111)-CHEMCCL(13)
      CHEM(71) = SAVE474
      WCCL(110) = WCCL(110)+CHEMCCL(71)*0.3000000000000000d+00
      CHEM(69) = SAVE473
      WCCL(110) = WCCL(110)+CHEMCCL(69)*0.1500000000000000d+00
      CHEM(66) = SAVE472
      WCCL(110) = WCCL(110)+CHEMCCL(66)*0.9000000000000000d+00
      CHEM(65) = SAVE471
      WCCL(110) = WCCL(110)+CHEMCCL(65)*0.1300000000000000d+00
      CHEM(63) = SAVE470
      WCCL(110) = WCCL(110)+CHEMCCL(63)*0.3000000000000000d-01
      CHEM(62) = SAVE469
      WCCL(110) = WCCL(110)+CHEMCCL(62)*0.2800000000000000d+00
      CHEM(58) = SAVE468
      WCCL(110) = WCCL(110)+CHEMCCL(58)*0.2000000000000000d-01
      CHEM(52) = SAVE467
      WCCL(110) = WCCL(110)+CHEMCCL(52)*0.3600000000000000d+00
      CHEM(50) = SAVE466
      WCCL(110) = WCCL(110)-CHEMCCL(50)
      CHEM(49) = SAVE465
      WCCL(110) = WCCL(110)+CHEMCCL(49)*0.3900000000000000d+00
      CHEM(40) = SAVE464
      WCCL(110) = WCCL(110)+CHEMCCL(40)*0.3500000000000000d+00
      CHEM(35) = SAVE463
      WCCL(110) = WCCL(110)+CHEMCCL(35)*0.9000000000000000d-01
      CHEM(34) = SAVE462
      WCCL(110) = WCCL(110)+CHEMCCL(34)*0.1500000000000000d+00
      CHEM(27) = SAVE461
      WCCL(110) = WCCL(110)+CHEMCCL(27)*0.1000000000000000d-02
      CHEM(19) = SAVE460
      WCCL(110) = WCCL(110)-CHEMCCL(19)
      CHEM(71) = SAVE459
      WCCL(109) = WCCL(109)+CHEMCCL(71)*0.3000000000000000d+00
      CHEM(69) = SAVE458
      WCCL(109) = WCCL(109)+CHEMCCL(69)*0.1500000000000000d+00
      CHEM(66) = SAVE457
      WCCL(109) = WCCL(109)+CHEMCCL(66)*0.9000000000000000d+00
      CHEM(65) = SAVE456
      WCCL(109) = WCCL(109)+CHEMCCL(65)*0.1300000000000000d+00
      CHEM(63) = SAVE455
      WCCL(109) = WCCL(109)+CHEMCCL(63)*0.3000000000000000d-01
      CHEM(62) = SAVE454
      WCCL(109) = WCCL(109)+CHEMCCL(62)*0.2800000000000000d+00
      CHEM(58) = SAVE453
      WCCL(109) = WCCL(109)+CHEMCCL(58)*0.2000000000000000d-01
      CHEM(52) = SAVE452
      WCCL(109) = WCCL(109)+CHEMCCL(52)*0.3600000000000000d+00
      CHEM(50) = SAVE451
      WCCL(109) = WCCL(109)-CHEMCCL(50)
      CHEM(49) = SAVE450
      WCCL(109) = WCCL(109)+CHEMCCL(49)*0.3900000000000000d+00
      CHEM(40) = SAVE449
      WCCL(109) = WCCL(109)+CHEMCCL(40)*0.3500000000000000d+00
      CHEM(35) = SAVE448
      WCCL(109) = WCCL(109)+CHEMCCL(35)*0.9000000000000000d-01
      CHEM(34) = SAVE447
      WCCL(109) = WCCL(109)+CHEMCCL(34)*0.1500000000000000d+00
      CHEM(27) = SAVE446
      WCCL(109) = WCCL(109)+CHEMCCL(27)*0.1000000000000000d-02
      CHEM(12) = SAVE445
      WCCL(109) = WCCL(109)-CHEMCCL(12)
      CHEM(71) = SAVE444
      WCCL(108) = WCCL(108)+CHEMCCL(71)*0.2200000000000000d+00
      CHEM(66) = SAVE443
      WCCL(108) = WCCL(108)+CHEMCCL(66)*0.2000000000000000d-01
      CHEM(63) = SAVE442
      WCCL(108) = WCCL(108)+CHEMCCL(63)*0.2300000000000000d+00
      CHEM(62) = SAVE441
      WCCL(108) = WCCL(108)+CHEMCCL(62)*0.6300000000000000d+00
      CHEM(61) = SAVE440
      WCCL(108) = WCCL(108)+CHEMCCL(61)*0.9900000000000000d+00
      CHEM(60) = SAVE439
      WCCL(108) = WCCL(108)+CHEMCCL(60)*0.1800000000000000d+00
      CHEM(59) = SAVE438
      WCCL(108) = WCCL(108)+CHEMCCL(59)*0.1600000000000000d+00
      CHEM(58) = SAVE437
      WCCL(108) = WCCL(108)+CHEMCCL(58)*0.1200000000000000d+00
      CHEM(57) = SAVE436
      WCCL(108) = WCCL(108)+CHEMCCL(57)*0.1400000000000000d+00
      CHEM(52) = SAVE435
      WCCL(108) = WCCL(108)+CHEMCCL(52)*0.3000000000000000d+00
      CHEM(50) = SAVE434
      WCCL(108) = WCCL(108)-CHEMCCL(50)
      CHEM(44) = SAVE433
      WCCL(108) = WCCL(108)-CHEMCCL(44)
      CHEM(27) = SAVE432
      WCCL(108) = WCCL(108)+CHEMCCL(27)*0.1100000000000000d-01
      CHEM(21) = SAVE431
      WCCL(108) = WCCL(108)+CHEMCCL(21)*0.6000000000000000d-01
      CHEM(20) = SAVE430
      WCCL(108) = WCCL(108)+CHEMCCL(20)*0.7000000000000001d-01
      CHEM(71) = SAVE429
      WCCL(107) = WCCL(107)+CHEMCCL(71)*0.2500000000000000d+00
      CHEM(66) = SAVE428
      WCCL(107) = WCCL(107)+CHEMCCL(66)*0.6400000000000000d+00
      CHEM(63) = SAVE427
      WCCL(107) = WCCL(107)+CHEMCCL(63)*0.1900000000000000d+00
      CHEM(62) = SAVE426
      WCCL(107) = WCCL(107)+CHEMCCL(62)*0.4000000000000000d+00
      CHEM(61) = SAVE425
      WCCL(107) = WCCL(107)+CHEMCCL(61)*0.4400000000000000d+00
      CHEM(60) = SAVE424
      WCCL(107) = WCCL(107)+CHEMCCL(60)*0.1000000000000000d+00
      CHEM(59) = SAVE423
      WCCL(107) = WCCL(107)+CHEMCCL(59)*0.3000000000000000d-01
      CHEM(58) = SAVE422
      WCCL(107) = WCCL(107)+CHEMCCL(58)*0.3000000000000000d-01
      CHEM(57) = SAVE421
      WCCL(107) = WCCL(107)+CHEMCCL(57)*0.1000000000000000d+00
      CHEM(52) = SAVE420
      WCCL(107) = WCCL(107)+CHEMCCL(52)*0.3700000000000000d+00
      CHEM(50) = SAVE419
      WCCL(107) = WCCL(107)-CHEMCCL(50)
      CHEM(40) = SAVE418
      WCCL(107) = WCCL(107)-CHEMCCL(40)
      CHEM(34) = SAVE417
      WCCL(107) = WCCL(107)+CHEMCCL(34)*0.1400000000000000d+00
      CHEM(27) = SAVE416
      WCCL(107) = WCCL(107)+CHEMCCL(27)*0.6000000000000000d-02
      CHEM(21) = SAVE415
      WCCL(107) = WCCL(107)+CHEMCCL(21)*0.3000000000000000d-01
      CHEM(20) = SAVE414
      WCCL(107) = WCCL(107)+CHEMCCL(20)*0.6000000000000000d-01
      CHEM(71) = SAVE413
      WCCL(106) = WCCL(106)+CHEMCCL(71)*0.2600000000000000d+00
      CHEM(66) = SAVE412
      WCCL(106) = WCCL(106)+CHEMCCL(66)
      CHEM(62) = SAVE411
      WCCL(106) = WCCL(106)+CHEMCCL(62)*0.1200000000000000d+00
      CHEM(52) = SAVE410
      WCCL(106) = WCCL(106)+CHEMCCL(52)*0.4300000000000000d+00
      CHEM(50) = SAVE409
      WCCL(106) = WCCL(106)-CHEMCCL(50)
      CHEM(34) = SAVE408
      WCCL(106) = WCCL(106)+CHEMCCL(34)*0.3700000000000000d+00
      CHEM(11) = SAVE407
      WCCL(106) = WCCL(106)-CHEMCCL(11)
      CHEM(72) = SAVE406
      WCCL(105) = WCCL(105)+CHEMCCL(72)*0.4000000000000000d+00
      CHEM(70) = SAVE405
      WCCL(105) = WCCL(105)+CHEMCCL(70)*0.6000000000000000d+00
      CHEM(68) = SAVE404
      WCCL(105) = WCCL(105)-CHEMCCL(68)*0.4000000000000000d+00
      CHEM(66) = SAVE403
      WCCL(105) = WCCL(105)+CHEMCCL(66)*0.4000000000000000d+00
      CHEM(65) = SAVE402
      WCCL(105) = WCCL(105)+CHEMCCL(65)
      CHEM(26) = SAVE401
      WCCL(105) = WCCL(105)+CHEMCCL(26)*0.4000000000000000d+00
      CHEM(25) = SAVE400
      WCCL(105) = WCCL(105)-CHEMCCL(25)
      CHEM(68) = SAVE399
      WCCL(104) = WCCL(104)-CHEMCCL(68)
      CHEM(47) = SAVE398
      WCCL(104) = WCCL(104)+CHEMCCL(47)*0.1300000000000000d+00
      CHEM(46) = SAVE397
      WCCL(104) = WCCL(104)+CHEMCCL(46)*0.8700000000000000d+00
      CHEM(14) = SAVE396
      WCCL(104) = WCCL(104)-CHEMCCL(14)
      CHEM(68) = SAVE395
      WCCL(103) = WCCL(103)-CHEMCCL(68)
      CHEM(47) = SAVE394
      WCCL(103) = WCCL(103)+CHEMCCL(47)*0.1000000000000000d+00
      CHEM(46) = SAVE393
      WCCL(103) = WCCL(103)+CHEMCCL(46)*0.9000000000000000d+00
      CHEM(13) = SAVE392
      WCCL(103) = WCCL(103)-CHEMCCL(13)
      CHEM(68) = SAVE391
      WCCL(102) = WCCL(102)-CHEMCCL(68)
      CHEM(49) = SAVE390
      WCCL(102) = WCCL(102)+CHEMCCL(49)*0.9000000000000000d+00
      CHEM(47) = SAVE389
      WCCL(102) = WCCL(102)+CHEMCCL(47)*0.9000000000000000d+00
      CHEM(46) = SAVE388
      WCCL(102) = WCCL(102)+CHEMCCL(46)*0.1000000000000000d+00
      CHEM(19) = SAVE387
      WCCL(102) = WCCL(102)-CHEMCCL(19)
      CHEM(68) = SAVE386
      WCCL(101) = WCCL(101)-CHEMCCL(68)
      CHEM(49) = SAVE385
      WCCL(101) = WCCL(101)+CHEMCCL(49)*0.9000000000000000d+00
      CHEM(47) = SAVE384
      WCCL(101) = WCCL(101)+CHEMCCL(47)*0.9000000000000000d+00
      CHEM(46) = SAVE383
      WCCL(101) = WCCL(101)+CHEMCCL(46)*0.1000000000000000d+00
      CHEM(12) = SAVE382
      WCCL(101) = WCCL(101)-CHEMCCL(12)
      CHEM(68) = SAVE381
      WCCL(100) = WCCL(100)-CHEMCCL(68)
      CHEM(47) = SAVE380
      WCCL(100) = WCCL(100)+CHEMCCL(47)*0.1100000000000000d+00
      CHEM(46) = SAVE379
      WCCL(100) = WCCL(100)+CHEMCCL(46)*0.8900000000000000d+00
      CHEM(44) = SAVE378
      WCCL(100) = WCCL(100)-CHEMCCL(44)
      CHEM(68) = SAVE377
      WCCL(99) = WCCL(99)-CHEMCCL(68)
      CHEM(47) = SAVE376
      WCCL(99) = WCCL(99)+CHEMCCL(47)*0.4300000000000000d+00
      CHEM(46) = SAVE375
      WCCL(99) = WCCL(99)+CHEMCCL(46)*0.5700000000000000d+00
      CHEM(40) = SAVE374
      WCCL(99) = WCCL(99)-CHEMCCL(40)
      CHEM(68) = SAVE373
      WCCL(98) = WCCL(98)-CHEMCCL(68)
      CHEM(47) = SAVE372
      WCCL(98) = WCCL(98)+CHEMCCL(47)*0.8000000000000000d+00
      CHEM(46) = SAVE371
      WCCL(98) = WCCL(98)+CHEMCCL(46)*0.2000000000000000d+00
      CHEM(11) = SAVE370
      WCCL(98) = WCCL(98)-CHEMCCL(11)
      CHEM(68) = SAVE369
      WCCL(97) = WCCL(97)-CHEMCCL(68)
      CHEM(55) = SAVE368
      WCCL(97) = WCCL(97)+CHEMCCL(55)
      CHEM(30) = SAVE367
      WCCL(97) = WCCL(97)-CHEMCCL(30)
      CHEM(29) = SAVE366
      WCCL(97) = WCCL(97)+CHEMCCL(29)
      CHEM(72) = SAVE365
      WCCL(96) = WCCL(96)+CHEMCCL(72)*0.5000000000000000d+00
      CHEM(71) = SAVE364
      WCCL(96) = WCCL(96)+CHEMCCL(71)*0.5000000000000000d+00
      CHEM(68) = SAVE363
      WCCL(96) = WCCL(96)-CHEMCCL(68)
      CHEM(65) = SAVE362
      WCCL(96) = WCCL(96)+CHEMCCL(65)*0.5000000000000000d+00
      CHEM(61) = SAVE361
      WCCL(96) = WCCL(96)+CHEMCCL(61)*0.2500000000000000d+00
      CHEM(59) = SAVE360
      WCCL(96) = WCCL(96)+CHEMCCL(59)*0.3000000000000000d-01
      CHEM(56) = SAVE359
      WCCL(96) = WCCL(96)+CHEMCCL(56)*0.5000000000000000d+00
      CHEM(55) = SAVE358
      WCCL(96) = WCCL(96)+CHEMCCL(55)*0.5000000000000000d+00
      CHEM(54) = SAVE357
      WCCL(96) = WCCL(96)+CHEMCCL(54)*0.2500000000000000d+00
      CHEM(51) = SAVE356
      WCCL(96) = WCCL(96)+CHEMCCL(51)*0.2500000000000000d+00
      CHEM(48) = SAVE355
      WCCL(96) = WCCL(96)-CHEMCCL(48)
      CHEM(68) = SAVE354
      WCCL(95) = WCCL(95)-CHEMCCL(68)
      CHEM(56) = SAVE353
      WCCL(95) = WCCL(95)+CHEMCCL(56)*0.2000000000000000d+00
      CHEM(55) = SAVE352
      WCCL(95) = WCCL(95)+CHEMCCL(55)*0.2000000000000000d+00
      CHEM(52) = SAVE351
      WCCL(95) = WCCL(95)+CHEMCCL(52)*0.8000000000000000d+00
      CHEM(49) = SAVE350
      WCCL(95) = WCCL(95)-CHEMCCL(49)
      CHEM(47) = SAVE349
      WCCL(95) = WCCL(95)+CHEMCCL(47)*0.8000000000000000d+00
      CHEM(69) = SAVE348
      WCCL(94) = WCCL(94)+CHEMCCL(69)
      CHEM(68) = SAVE347
      WCCL(94) = WCCL(94)-CHEMCCL(68)
      CHEM(55) = SAVE346
      WCCL(94) = WCCL(94)+CHEMCCL(55)
      CHEM(54) = SAVE345
      WCCL(94) = WCCL(94)-CHEMCCL(54)
      CHEM(52) = SAVE344
      WCCL(94) = WCCL(94)+CHEMCCL(52)
      CHEM(71) = SAVE343
      WCCL(93) = WCCL(93)+CHEMCCL(71)
      CHEM(68) = SAVE342
      WCCL(93) = WCCL(93)-CHEMCCL(68)
      CHEM(55) = SAVE341
      WCCL(93) = WCCL(93)+CHEMCCL(55)
      CHEM(52) = SAVE340
      WCCL(93) = WCCL(93)+CHEMCCL(52)*0.2000000000000000d+01
      CHEM(51) = SAVE339
      WCCL(93) = WCCL(93)-CHEMCCL(51)
      CHEM(69) = SAVE338
      WCCL(92) = WCCL(92)+CHEMCCL(69)
      CHEM(68) = SAVE337
      WCCL(92) = WCCL(92)-CHEMCCL(68)
      CHEM(61) = SAVE336
      WCCL(92) = WCCL(92)-CHEMCCL(61)
      CHEM(55) = SAVE335
      WCCL(92) = WCCL(92)+CHEMCCL(55)
      CHEM(71) = SAVE334
      WCCL(91) = WCCL(91)+CHEMCCL(71)
      CHEM(68) = SAVE333
      WCCL(91) = WCCL(91)-CHEMCCL(68)
      CHEM(66) = SAVE332
      WCCL(91) = WCCL(91)-CHEMCCL(66)
      CHEM(55) = SAVE331
      WCCL(91) = WCCL(91)+CHEMCCL(55)
      CHEM(52) = SAVE330
      WCCL(91) = WCCL(91)+CHEMCCL(52)
      CHEM(72) = SAVE329
      WCCL(90) = WCCL(90)+CHEMCCL(72)
      CHEM(70) = SAVE328
      WCCL(90) = WCCL(90)-CHEMCCL(70)
      CHEM(64) = SAVE327
      WCCL(90) = WCCL(90)+CHEMCCL(64)
      CHEM(62) = SAVE326
      WCCL(90) = WCCL(90)-CHEMCCL(62)
      CHEM(71) = SAVE325
      WCCL(89) = WCCL(89)+CHEMCCL(71)*0.4000000000000000d+00
      CHEM(68) = SAVE324
      WCCL(89) = WCCL(89)+CHEMCCL(68)*0.6000000000000000d+00
      CHEM(66) = SAVE323
      WCCL(89) = WCCL(89)+CHEMCCL(66)*0.4000000000000000d+00
      CHEM(65) = SAVE322
      WCCL(89) = WCCL(89)+CHEMCCL(65)
      CHEM(62) = SAVE321
      WCCL(89) = WCCL(89)-CHEMCCL(62)
      CHEM(26) = SAVE320
      WCCL(89) = WCCL(89)+CHEMCCL(26)*0.4000000000000000d+00
      CHEM(25) = SAVE319
      WCCL(89) = WCCL(89)-CHEMCCL(25)
      CHEM(24) = SAVE318
      WCCL(89) = WCCL(89)+CHEMCCL(24)*0.6000000000000000d+00
      CHEM(68) = SAVE317
      WCCL(88) = WCCL(88)+CHEMCCL(68)
      CHEM(66) = SAVE316
      WCCL(88) = WCCL(88)+CHEMCCL(66)
      CHEM(65) = SAVE315
      WCCL(88) = WCCL(88)+CHEMCCL(65)
      CHEM(62) = SAVE314
      WCCL(88) = WCCL(88)-CHEMCCL(62)
      CHEM(26) = SAVE313
      WCCL(88) = WCCL(88)-CHEMCCL(26)
      CHEM(71) = SAVE312
      WCCL(87) = WCCL(87)+CHEMCCL(71)*0.3500000000000000d+00
      CHEM(69) = SAVE311
      WCCL(87) = WCCL(87)+CHEMCCL(69)*0.6500000000000000d+00
      CHEM(66) = SAVE310
      WCCL(87) = WCCL(87)+CHEMCCL(66)*0.3500000000000000d+00
      CHEM(65) = SAVE309
      WCCL(87) = WCCL(87)+CHEMCCL(65)*0.3500000000000000d+00
      CHEM(62) = SAVE308
      WCCL(87) = WCCL(87)-CHEMCCL(62)
      CHEM(28) = SAVE307
      WCCL(87) = WCCL(87)-CHEMCCL(28)
      CHEM(65) = SAVE306
      WCCL(86) = WCCL(86)+CHEMCCL(65)*0.7000000000000001d-01
      CHEM(64) = SAVE305
      WCCL(86) = WCCL(86)+CHEMCCL(64)*0.4400000000000000d+00
      CHEM(62) = SAVE304
      WCCL(86) = WCCL(86)-CHEMCCL(62)*0.5100000000000000d+00
      CHEM(61) = SAVE303
      WCCL(86) = WCCL(86)+CHEMCCL(61)*0.8000000000000000d-01
      CHEM(59) = SAVE302
      WCCL(86) = WCCL(86)+CHEMCCL(59)*0.4100000000000000d+00
      CHEM(53) = SAVE301
      WCCL(86) = WCCL(86)-CHEMCCL(53)
      CHEM(66) = SAVE300
      WCCL(85) = WCCL(85)+CHEMCCL(66)*0.3500000000000000d+00
      CHEM(63) = SAVE299
      WCCL(85) = WCCL(85)+CHEMCCL(63)*0.6500000000000000d+00
      CHEM(62) = SAVE298
      WCCL(85) = WCCL(85)-CHEMCCL(62)*0.6500000000000000d+00
      CHEM(16) = SAVE297
      WCCL(85) = WCCL(85)-CHEMCCL(16)
      CHEM(71) = SAVE296
      WCCL(84) = WCCL(84)+CHEMCCL(71)
      CHEM(62) = SAVE295
      WCCL(84) = WCCL(84)-CHEMCCL(62)
      CHEM(61) = SAVE294
      WCCL(84) = WCCL(84)+CHEMCCL(61)*0.8800000000000000d+00
      CHEM(59) = SAVE293
      WCCL(84) = WCCL(84)+CHEMCCL(59)*0.1200000000000000d+00
      CHEM(10) = SAVE292
      WCCL(84) = WCCL(84)-CHEMCCL(10)
      CHEM(71) = SAVE291
      WCCL(83) = WCCL(83)+CHEMCCL(71)*0.5000000000000000d+00
      CHEM(65) = SAVE290
      WCCL(83) = WCCL(83)+CHEMCCL(65)*0.5000000000000000d+00
      CHEM(62) = SAVE289
      WCCL(83) = WCCL(83)-CHEMCCL(62)
      CHEM(56) = SAVE288
      WCCL(83) = WCCL(83)+CHEMCCL(56)*0.5000000000000000d+00
      CHEM(54) = SAVE287
      WCCL(83) = WCCL(83)+CHEMCCL(54)*0.1500000000000000d+00
      CHEM(51) = SAVE286
      WCCL(83) = WCCL(83)+CHEMCCL(51)*0.1500000000000000d+00
      CHEM(48) = SAVE285
      WCCL(83) = WCCL(83)-CHEMCCL(48)
      CHEM(10) = SAVE284
      WCCL(83) = WCCL(83)+CHEMCCL(10)*0.3500000000000000d+00
      CHEM(71) = SAVE283
      WCCL(82) = WCCL(82)+CHEMCCL(71)*0.4900000000000000d+00
      CHEM(66) = SAVE282
      WCCL(82) = WCCL(82)+CHEMCCL(66)*0.8000000000000000d-01
      CHEM(65) = SAVE281
      WCCL(82) = WCCL(82)+CHEMCCL(65)*0.4900000000000000d+00
      CHEM(62) = SAVE280
      WCCL(82) = WCCL(82)-CHEMCCL(62)
      CHEM(56) = SAVE279
      WCCL(82) = WCCL(82)+CHEMCCL(56)*0.5100000000000000d+00
      CHEM(54) = SAVE278
      WCCL(82) = WCCL(82)+CHEMCCL(54)*0.8000000000000000d-01
      CHEM(52) = SAVE277
      WCCL(82) = WCCL(82)+CHEMCCL(52)*0.4100000000000000d+00
      CHEM(49) = SAVE276
      WCCL(82) = WCCL(82)-CHEMCCL(49)
      CHEM(24) = SAVE275
      WCCL(82) = WCCL(82)+CHEMCCL(24)*0.4100000000000000d+00
      CHEM(69) = SAVE274
      WCCL(81) = WCCL(81)+CHEMCCL(69)
      CHEM(62) = SAVE273
      WCCL(81) = WCCL(81)-CHEMCCL(62)
      CHEM(54) = SAVE272
      WCCL(81) = WCCL(81)-CHEMCCL(54)
      CHEM(52) = SAVE271
      WCCL(81) = WCCL(81)+CHEMCCL(52)
      CHEM(71) = SAVE270
      WCCL(80) = WCCL(80)+CHEMCCL(71)
      CHEM(62) = SAVE269
      WCCL(80) = WCCL(80)-CHEMCCL(62)
      CHEM(52) = SAVE268
      WCCL(80) = WCCL(80)+CHEMCCL(52)*0.2000000000000000d+01
      CHEM(51) = SAVE267
      WCCL(80) = WCCL(80)-CHEMCCL(51)
      CHEM(71) = SAVE266
      WCCL(79) = WCCL(79)+CHEMCCL(71)
      CHEM(62) = SAVE265
      WCCL(79) = WCCL(79)-CHEMCCL(62)
      CHEM(54) = SAVE264
      WCCL(79) = WCCL(79)+CHEMCCL(54)
      CHEM(24) = SAVE263
      WCCL(79) = WCCL(79)-CHEMCCL(24)
      CHEM(62) = SAVE262
      WCCL(78) = WCCL(78)-CHEMCCL(62)
      CHEM(59) = SAVE261
      WCCL(78) = WCCL(78)-CHEMCCL(59)
      CHEM(58) = SAVE260
      WCCL(78) = WCCL(78)+CHEMCCL(58)
      CHEM(69) = SAVE259
      WCCL(77) = WCCL(77)+CHEMCCL(69)
      CHEM(62) = SAVE258
      WCCL(77) = WCCL(77)-CHEMCCL(62)
      CHEM(61) = SAVE257
      WCCL(77) = WCCL(77)-CHEMCCL(61)
      CHEM(71) = SAVE256
      WCCL(76) = WCCL(76)+CHEMCCL(71)
      CHEM(66) = SAVE255
      WCCL(76) = WCCL(76)-CHEMCCL(66)
      CHEM(62) = SAVE254
      WCCL(76) = WCCL(76)-CHEMCCL(62)
      CHEM(52) = SAVE253
      WCCL(76) = WCCL(76)+CHEMCCL(52)
      CHEM(71) = SAVE252
      WCCL(75) = WCCL(75)+CHEMCCL(71)*0.5000000000000000d-01
      CHEM(65) = SAVE251
      WCCL(75) = WCCL(75)+CHEMCCL(65)*0.5000000000000000d-01
      CHEM(62) = SAVE250
      WCCL(75) = WCCL(75)-CHEMCCL(62)
      CHEM(30) = SAVE249
      WCCL(75) = WCCL(75)-CHEMCCL(30)
      CHEM(29) = SAVE248
      WCCL(75) = WCCL(75)+CHEMCCL(29)*0.1000000000000000d+00
      CHEM(22) = SAVE247
      WCCL(75) = WCCL(75)+CHEMCCL(22)*0.8500000000000000d+00
      CHEM(71) = SAVE246
      WCCL(74) = WCCL(74)+CHEMCCL(71)*0.1000000000000000d+00
      CHEM(65) = SAVE245
      WCCL(74) = WCCL(74)+CHEMCCL(65)*0.1000000000000000d+00
      CHEM(62) = SAVE244
      WCCL(74) = WCCL(74)-CHEMCCL(62)
      CHEM(18) = SAVE243
      WCCL(74) = WCCL(74)+CHEMCCL(18)*0.9000000000000000d+00
      CHEM(6) = SAVE242
      WCCL(74) = WCCL(74)-CHEMCCL(6)
      CHEM(71) = SAVE241
      WCCL(73) = WCCL(73)+CHEMCCL(71)*0.1000000000000000d+00
      CHEM(65) = SAVE240
      WCCL(73) = WCCL(73)+CHEMCCL(65)*0.1000000000000000d+00
      CHEM(62) = SAVE239
      WCCL(73) = WCCL(73)-CHEMCCL(62)
      CHEM(17) = SAVE238
      WCCL(73) = WCCL(73)+CHEMCCL(17)*0.9000000000000000d+00
      CHEM(5) = SAVE237
      WCCL(73) = WCCL(73)-CHEMCCL(5)
      CHEM(62) = SAVE236
      WCCL(72) = WCCL(72)-CHEMCCL(62)
      CHEM(43) = SAVE235
      WCCL(72) = WCCL(72)+CHEMCCL(43)
      CHEM(14) = SAVE234
      WCCL(72) = WCCL(72)-CHEMCCL(14)
      CHEM(62) = SAVE233
      WCCL(71) = WCCL(71)-CHEMCCL(62)
      CHEM(42) = SAVE232
      WCCL(71) = WCCL(71)+CHEMCCL(42)
      CHEM(13) = SAVE231
      WCCL(71) = WCCL(71)-CHEMCCL(13)
      CHEM(62) = SAVE230
      WCCL(70) = WCCL(70)-CHEMCCL(62)
      CHEM(39) = SAVE229
      WCCL(70) = WCCL(70)+CHEMCCL(39)
      CHEM(19) = SAVE228
      WCCL(70) = WCCL(70)-CHEMCCL(19)
      CHEM(62) = SAVE227
      WCCL(69) = WCCL(69)-CHEMCCL(62)
      CHEM(39) = SAVE226
      WCCL(69) = WCCL(69)+CHEMCCL(39)
      CHEM(12) = SAVE225
      WCCL(69) = WCCL(69)-CHEMCCL(12)
      CHEM(62) = SAVE224
      WCCL(68) = WCCL(68)-CHEMCCL(62)
      CHEM(45) = SAVE223
      WCCL(68) = WCCL(68)+CHEMCCL(45)
      CHEM(44) = SAVE222
      WCCL(68) = WCCL(68)-CHEMCCL(44)
      CHEM(62) = SAVE221
      WCCL(67) = WCCL(67)-CHEMCCL(62)
      CHEM(41) = SAVE220
      WCCL(67) = WCCL(67)+CHEMCCL(41)
      CHEM(40) = SAVE219
      WCCL(67) = WCCL(67)-CHEMCCL(40)
      CHEM(62) = SAVE218
      WCCL(66) = WCCL(66)-CHEMCCL(62)
      CHEM(38) = SAVE217
      WCCL(66) = WCCL(66)+CHEMCCL(38)
      CHEM(11) = SAVE216
      WCCL(66) = WCCL(66)-CHEMCCL(11)
      CHEM(71) = SAVE215
      WCCL(65) = WCCL(65)+CHEMCCL(71)*0.4900000000000000d-01
      CHEM(62) = SAVE214
      WCCL(65) = WCCL(65)-CHEMCCL(62)
      CHEM(61) = SAVE213
      WCCL(65) = WCCL(65)+CHEMCCL(61)*0.2500000000000000d-01
      CHEM(37) = SAVE212
      WCCL(65) = WCCL(65)+CHEMCCL(37)*0.9510000000000000d+00
      CHEM(24) = SAVE211
      WCCL(65) = WCCL(65)+CHEMCCL(24)*0.2400000000000000d-01
      CHEM(4) = SAVE210
      WCCL(65) = WCCL(65)-CHEMCCL(4)
      CHEM(71) = SAVE209
      WCCL(64) = WCCL(64)+CHEMCCL(71)*0.2500000000000000d+00
      CHEM(62) = SAVE208
      WCCL(64) = WCCL(64)-CHEMCCL(62)
      CHEM(59) = SAVE207
      WCCL(64) = WCCL(64)+CHEMCCL(59)*0.2500000000000000d+00
      CHEM(36) = SAVE206
      WCCL(64) = WCCL(64)+CHEMCCL(36)*0.7500000000000000d+00
      CHEM(3) = SAVE205
      WCCL(64) = WCCL(64)-CHEMCCL(3)
      CHEM(71) = SAVE204
      WCCL(63) = WCCL(63)+CHEMCCL(71)*0.3810000000000000d+00
      CHEM(66) = SAVE203
      WCCL(63) = WCCL(63)+CHEMCCL(66)*0.1000000000000000d-01
      CHEM(64) = SAVE202
      WCCL(63) = WCCL(63)+CHEMCCL(64)*0.5830000000000000d+00
      CHEM(62) = SAVE201
      WCCL(63) = WCCL(63)-CHEMCCL(62)*0.9640000000000000d+00
      CHEM(61) = SAVE200
      WCCL(63) = WCCL(63)+CHEMCCL(61)*0.3350000000000000d+00
      CHEM(52) = SAVE199
      WCCL(63) = WCCL(63)+CHEMCCL(52)*0.3600000000000000d-01
      CHEM(51) = SAVE198
      WCCL(63) = WCCL(63)+CHEMCCL(51)*0.3600000000000000d-01
      CHEM(34) = SAVE197
      WCCL(63) = WCCL(63)+CHEMCCL(34)*0.3600000000000000d-01
      CHEM(2) = SAVE196
      WCCL(63) = WCCL(63)-CHEMCCL(2)
      CHEM(62) = SAVE195
      WCCL(62) = WCCL(62)-CHEMCCL(62)
      CHEM(60) = SAVE194
      WCCL(62) = WCCL(62)+CHEMCCL(60)
      CHEM(21) = SAVE193
      WCCL(62) = WCCL(62)-CHEMCCL(21)
      CHEM(63) = SAVE192
      WCCL(61) = WCCL(61)+CHEMCCL(63)
      CHEM(62) = SAVE191
      WCCL(61) = WCCL(61)-CHEMCCL(62)
      CHEM(20) = SAVE190
      WCCL(61) = WCCL(61)-CHEMCCL(20)
      CHEM(61) = SAVE189
      WCCL(60) = WCCL(60)+CHEMCCL(61)
      CHEM(49) = SAVE188
      WCCL(60) = WCCL(60)-CHEMCCL(49)
      CHEM(35) = SAVE187
      WCCL(60) = WCCL(60)-CHEMCCL(35)
      CHEM(71) = SAVE186
      WCCL(59) = WCCL(59)+CHEMCCL(71)*0.2800000000000000d+00
      CHEM(66) = SAVE185
      WCCL(59) = WCCL(59)+CHEMCCL(66)*0.5000000000000000d-01
      CHEM(65) = SAVE184
      WCCL(59) = WCCL(59)+CHEMCCL(65)*0.1500000000000000d+00
      CHEM(62) = SAVE183
      WCCL(59) = WCCL(59)+CHEMCCL(62)*0.2000000000000000d-01
      CHEM(52) = SAVE182
      WCCL(59) = WCCL(59)+CHEMCCL(52)*0.1000000000000000d-01
      CHEM(48) = SAVE181
      WCCL(59) = WCCL(59)+CHEMCCL(48)*0.1300000000000000d+00
      CHEM(40) = SAVE180
      WCCL(59) = WCCL(59)+CHEMCCL(40)*0.8600000000000000d+00
      CHEM(35) = SAVE179
      WCCL(59) = WCCL(59)-CHEMCCL(35)
      CHEM(19) = SAVE178
      WCCL(59) = WCCL(59)-CHEMCCL(19)
      CHEM(71) = SAVE177
      WCCL(58) = WCCL(58)+CHEMCCL(71)
      CHEM(62) = SAVE176
      WCCL(58) = WCCL(58)-CHEMCCL(62)
      CHEM(52) = SAVE175
      WCCL(58) = WCCL(58)-CHEMCCL(52)
      CHEM(71) = SAVE174
      WCCL(57) = WCCL(57)+CHEMCCL(71)
      CHEM(62) = SAVE173
      WCCL(57) = WCCL(57)-CHEMCCL(62)
      CHEM(8) = SAVE172
      WCCL(57) = WCCL(57)+CHEMCCL(8)
      CHEM(1) = SAVE171
      WCCL(57) = WCCL(57)-CHEMCCL(1)
      CHEM(71) = SAVE170
      WCCL(56) = WCCL(56)+CHEMCCL(71)
      CHEM(62) = SAVE169
      WCCL(56) = WCCL(56)-CHEMCCL(62)
      CHEM(72) = SAVE168
      WCCL(55) = WCCL(55)+CHEMCCL(72)*0.2000000000000000d+01
      CHEM(68) = SAVE167
      WCCL(55) = WCCL(55)-CHEMCCL(68)*0.2000000000000000d+01
      CHEM(72) = SAVE166
      WCCL(54) = WCCL(54)+CHEMCCL(72)
      CHEM(68) = SAVE165
      WCCL(54) = WCCL(54)+CHEMCCL(68)
      CHEM(9) = SAVE164
      WCCL(54) = WCCL(54)-CHEMCCL(9)
      CHEM(72) = SAVE163
      WCCL(53) = WCCL(53)-CHEMCCL(72)
      CHEM(68) = SAVE162
      WCCL(53) = WCCL(53)-CHEMCCL(68)
      CHEM(9) = SAVE161
      WCCL(53) = WCCL(53)+CHEMCCL(9)
      CHEM(68) = SAVE160
      WCCL(52) = WCCL(52)-CHEMCCL(68)
      CHEM(67) = SAVE159
      WCCL(52) = WCCL(52)+CHEMCCL(67)
      CHEM(72) = SAVE158
      WCCL(51) = WCCL(51)+CHEMCCL(72)*0.2000000000000000d+01
      CHEM(68) = SAVE157
      WCCL(51) = WCCL(51)-CHEMCCL(68)
      CHEM(67) = SAVE156
      WCCL(51) = WCCL(51)-CHEMCCL(67)
      CHEM(72) = SAVE155
      WCCL(50) = WCCL(50)+CHEMCCL(72)*0.2000000000000000d+01
      CHEM(67) = SAVE154
      WCCL(50) = WCCL(50)-CHEMCCL(67)*0.2000000000000000d+01
      CHEM(72) = SAVE153
      WCCL(49) = WCCL(49)-CHEMCCL(72)
      CHEM(68) = SAVE152
      WCCL(49) = WCCL(49)+CHEMCCL(68)
      CHEM(50) = SAVE151
      WCCL(49) = WCCL(49)-CHEMCCL(50)
      CHEM(72) = SAVE150
      WCCL(48) = WCCL(48)+CHEMCCL(72)
      CHEM(67) = SAVE149
      WCCL(48) = WCCL(48)-CHEMCCL(67)
      CHEM(50) = SAVE148
      WCCL(48) = WCCL(48)-CHEMCCL(50)
      CHEM(72) = SAVE147
      WCCL(47) = WCCL(47)+CHEMCCL(72)
      CHEM(62) = SAVE146
      WCCL(47) = WCCL(47)-CHEMCCL(62)
      CHEM(15) = SAVE145
      WCCL(47) = WCCL(47)-CHEMCCL(15)
      CHEM(68) = SAVE144
      WCCL(46) = WCCL(46)+CHEMCCL(68)
      CHEM(62) = SAVE143
      WCCL(46) = WCCL(46)-CHEMCCL(62)
      CHEM(55) = SAVE142
      WCCL(46) = WCCL(46)-CHEMCCL(55)
      CHEM(72) = SAVE141
      WCCL(45) = WCCL(45)+CHEMCCL(72)
      CHEM(62) = SAVE140
      WCCL(45) = WCCL(45)-CHEMCCL(62)
      CHEM(23) = SAVE139
      WCCL(45) = WCCL(45)-CHEMCCL(23)
      CHEM(72) = SAVE138
      WCCL(44) = WCCL(44)+CHEMCCL(72)*0.7000000000000000d+00
      CHEM(71) = SAVE137
      WCCL(44) = WCCL(44)-CHEMCCL(71)
      CHEM(68) = SAVE136
      WCCL(44) = WCCL(44)-CHEMCCL(68)
      CHEM(62) = SAVE135
      WCCL(44) = WCCL(44)+CHEMCCL(62)*0.7000000000000000d+00
      CHEM(55) = SAVE134
      WCCL(44) = WCCL(44)+CHEMCCL(55)*0.3000000000000000d+00
      CHEM(72) = SAVE133
      WCCL(43) = WCCL(43)+CHEMCCL(72)
      CHEM(71) = SAVE132
      WCCL(43) = WCCL(43)+CHEMCCL(71)
      CHEM(15) = SAVE131
      WCCL(43) = WCCL(43)-CHEMCCL(15)
      CHEM(72) = SAVE130
      WCCL(42) = WCCL(42)-CHEMCCL(72)
      CHEM(71) = SAVE129
      WCCL(42) = WCCL(42)-CHEMCCL(71)
      CHEM(15) = SAVE128
      WCCL(42) = WCCL(42)+CHEMCCL(15)
      CHEM(72) = SAVE127
      WCCL(41) = WCCL(41)+CHEMCCL(72)
      CHEM(71) = SAVE126
      WCCL(41) = WCCL(41)-CHEMCCL(71)
      CHEM(67) = SAVE125
      WCCL(41) = WCCL(41)-CHEMCCL(67)
      CHEM(62) = SAVE124
      WCCL(41) = WCCL(41)+CHEMCCL(62)
      CHEM(72) = SAVE123
      WCCL(40) = WCCL(40)+CHEMCCL(72)
      CHEM(71) = SAVE122
      WCCL(40) = WCCL(40)+CHEMCCL(71)
      CHEM(68) = SAVE121
      WCCL(40) = WCCL(40)-CHEMCCL(68)
      CHEM(62) = SAVE120
      WCCL(40) = WCCL(40)-CHEMCCL(62)
      CHEM(72) = SAVE119
      WCCL(39) = WCCL(39)-CHEMCCL(72)
      CHEM(62) = SAVE118
      WCCL(39) = WCCL(39)-CHEMCCL(62)
      CHEM(55) = SAVE117
      WCCL(39) = WCCL(39)+CHEMCCL(55)
      CHEM(67) = SAVE116
      WCCL(38) = WCCL(38)-CHEMCCL(67)
      CHEM(62) = SAVE115
      WCCL(38) = WCCL(38)-CHEMCCL(62)
      CHEM(23) = SAVE114
      WCCL(38) = WCCL(38)+CHEMCCL(23)
      CHEM(72) = SAVE113
      WCCL(37) = WCCL(37)-CHEMCCL(72)
      CHEM(68) = SAVE112
      WCCL(37) = WCCL(37)+CHEMCCL(68)
      CHEM(35) = SAVE111
      WCCL(37) = WCCL(37)-CHEMCCL(35)
      CHEM(72) = SAVE110
      WCCL(36) = WCCL(36)-CHEMCCL(72)
      CHEM(67) = SAVE109
      WCCL(36) = WCCL(36)+CHEMCCL(67)
      CHEM(35) = SAVE108
      WCCL(36) = WCCL(36)-CHEMCCL(35)
      CHEM(72) = SAVE107
      WCCL(35) = WCCL(35)+CHEMCCL(72)
      CHEM(67) = SAVE106
      WCCL(35) = WCCL(35)-CHEMCCL(67)
      CHEM(35) = SAVE105
      WCCL(35) = WCCL(35)-CHEMCCL(35)
      CHEM(71) = SAVE104
      WCCL(34) = WCCL(34)-CHEMCCL(71)*0.2000000000000000d+01
      CHEM(27) = SAVE103
      WCCL(34) = WCCL(34)+CHEMCCL(27)
      CHEM(71) = SAVE102
      WCCL(33) = WCCL(33)-CHEMCCL(71)*0.2000000000000000d+01
      CHEM(27) = SAVE101
      WCCL(33) = WCCL(33)+CHEMCCL(27)
      CHEM(71) = SAVE100
      WCCL(32) = WCCL(32)+CHEMCCL(71)
      CHEM(62) = SAVE99
      WCCL(32) = WCCL(32)-CHEMCCL(62)
      CHEM(27) = SAVE98
      WCCL(32) = WCCL(32)-CHEMCCL(27)
      CHEM(71) = SAVE97
      WCCL(31) = WCCL(31)-CHEMCCL(71)
      CHEM(62) = SAVE96
      WCCL(31) = WCCL(31)-CHEMCCL(62)
      CHEM(71) = SAVE95
      WCCL(30) = WCCL(30)-CHEMCCL(71)
      CHEM(62) = SAVE94
      WCCL(30) = WCCL(30)+CHEMCCL(62)
      CHEM(50) = SAVE93
      WCCL(30) = WCCL(30)-CHEMCCL(50)
      CHEM(71) = SAVE92
      WCCL(29) = WCCL(29)+CHEMCCL(71)
      CHEM(62) = SAVE91
      WCCL(29) = WCCL(29)-CHEMCCL(62)
      CHEM(50) = SAVE90
      WCCL(29) = WCCL(29)-CHEMCCL(50)
      CHEM(62) = SAVE89
      WCCL(28) = WCCL(28)+CHEMCCL(62)*0.2000000000000000d+01
      CHEM(7) = SAVE88
      WCCL(28) = WCCL(28)-CHEMCCL(7)
      CHEM(35) = SAVE87
      WCCL(27) = WCCL(27)+CHEMCCL(35)
      CHEM(7) = SAVE86
      WCCL(27) = WCCL(27)-CHEMCCL(7)
      CHEM(35) = SAVE85
      WCCL(26) = WCCL(26)+CHEMCCL(35)
      CHEM(7) = SAVE84
      WCCL(26) = WCCL(26)-CHEMCCL(7)
      CHEM(50) = SAVE83
      WCCL(25) = WCCL(25)-CHEMCCL(50)
      CHEM(35) = SAVE82
      WCCL(25) = WCCL(25)-CHEMCCL(35)
      CHEM(50) = SAVE81
      WCCL(24) = WCCL(24)+CHEMCCL(50)
      CHEM(35) = SAVE80
      WCCL(24) = WCCL(24)-CHEMCCL(35)
      CHEM(71) = SAVE79
      WCCL(23) = WCCL(23)+CHEMCCL(71)
      CHEM(69) = SAVE78
      WCCL(23) = WCCL(23)+CHEMCCL(69)
      CHEM(66) = SAVE77
      WCCL(23) = WCCL(23)+CHEMCCL(66)
      CHEM(24) = SAVE76
      WCCL(23) = WCCL(23)-CHEMCCL(24)
      CHEM(71) = SAVE75
      WCCL(22) = WCCL(22)+CHEMCCL(71)
      CHEM(69) = SAVE74
      WCCL(22) = WCCL(22)+CHEMCCL(69)
      CHEM(66) = SAVE73
      WCCL(22) = WCCL(22)+CHEMCCL(66)
      CHEM(52) = SAVE72
      WCCL(22) = WCCL(22)+CHEMCCL(52)
      CHEM(49) = SAVE71
      WCCL(22) = WCCL(22)-CHEMCCL(49)
      CHEM(72) = SAVE70
      WCCL(21) = WCCL(21)+CHEMCCL(72)
      CHEM(71) = SAVE69
      WCCL(21) = WCCL(21)+CHEMCCL(71)
      CHEM(70) = SAVE68
      WCCL(21) = WCCL(21)-CHEMCCL(70)
      CHEM(61) = SAVE67
      WCCL(21) = WCCL(21)+CHEMCCL(61)*0.2000000000000000d+00
      CHEM(59) = SAVE66
      WCCL(21) = WCCL(21)+CHEMCCL(59)*0.8000000000000000d+00
      CHEM(71) = SAVE65
      WCCL(20) = WCCL(20)+CHEMCCL(71)
      CHEM(56) = SAVE64
      WCCL(20) = WCCL(20)+CHEMCCL(56)
      CHEM(48) = SAVE63
      WCCL(20) = WCCL(20)-CHEMCCL(48)
      CHEM(71) = SAVE62
      WCCL(19) = WCCL(19)+CHEMCCL(71)
      CHEM(69) = SAVE61
      WCCL(19) = WCCL(19)+CHEMCCL(69)
      CHEM(54) = SAVE60
      WCCL(19) = WCCL(19)-CHEMCCL(54)
      CHEM(52) = SAVE59
      WCCL(19) = WCCL(19)+CHEMCCL(52)
      CHEM(71) = SAVE58
      WCCL(18) = WCCL(18)+CHEMCCL(71)*0.8000000000000000d+00
      CHEM(66) = SAVE57
      WCCL(18) = WCCL(18)+CHEMCCL(66)*0.4500000000000000d+00
      CHEM(52) = SAVE56
      WCCL(18) = WCCL(18)+CHEMCCL(52)*0.1550000000000000d+01
      CHEM(51) = SAVE55
      WCCL(18) = WCCL(18)-CHEMCCL(51)
      CHEM(66) = SAVE54
      WCCL(17) = WCCL(17)+CHEMCCL(66)*0.1300000000000000d+00
      CHEM(52) = SAVE53
      WCCL(17) = WCCL(17)+CHEMCCL(52)*0.1870000000000000d+01
      CHEM(51) = SAVE52
      WCCL(17) = WCCL(17)-CHEMCCL(51)
      CHEM(69) = SAVE51
      WCCL(16) = WCCL(16)+CHEMCCL(69)
      CHEM(60) = SAVE50
      WCCL(16) = WCCL(16)+CHEMCCL(60)
      CHEM(59) = SAVE49
      WCCL(16) = WCCL(16)-CHEMCCL(59)
      CHEM(63) = SAVE48
      WCCL(15) = WCCL(15)+CHEMCCL(63)
      CHEM(62) = SAVE47
      WCCL(15) = WCCL(15)+CHEMCCL(62)
      CHEM(28) = SAVE46
      WCCL(15) = WCCL(15)-CHEMCCL(28)
      CHEM(71) = SAVE45
      WCCL(14) = WCCL(14)+CHEMCCL(71)
      CHEM(62) = SAVE44
      WCCL(14) = WCCL(14)+CHEMCCL(62)
      CHEM(61) = SAVE43
      WCCL(14) = WCCL(14)+CHEMCCL(61)
      CHEM(53) = SAVE42
      WCCL(14) = WCCL(14)-CHEMCCL(53)
      CHEM(71) = SAVE41
      WCCL(13) = WCCL(13)+CHEMCCL(71)
      CHEM(66) = SAVE40
      WCCL(13) = WCCL(13)+CHEMCCL(66)
      CHEM(62) = SAVE39
      WCCL(13) = WCCL(13)+CHEMCCL(62)
      CHEM(16) = SAVE38
      WCCL(13) = WCCL(13)-CHEMCCL(16)
      CHEM(71) = SAVE37
      WCCL(12) = WCCL(12)+CHEMCCL(71)
      CHEM(63) = SAVE36
      WCCL(12) = WCCL(12)+CHEMCCL(63)
      CHEM(61) = SAVE35
      WCCL(12) = WCCL(12)-CHEMCCL(61)
      CHEM(52) = SAVE34
      WCCL(12) = WCCL(12)+CHEMCCL(52)
      CHEM(71) = SAVE33
      WCCL(11) = WCCL(11)+CHEMCCL(71)*0.2000000000000000d+01
      CHEM(66) = SAVE32
      WCCL(11) = WCCL(11)-CHEMCCL(66)
      CHEM(52) = SAVE31
      WCCL(11) = WCCL(11)+CHEMCCL(52)
      CHEM(66) = SAVE30
      WCCL(10) = WCCL(10)-CHEMCCL(66)
      CHEM(52) = SAVE29
      WCCL(10) = WCCL(10)+CHEMCCL(52)
      CHEM(62) = SAVE28
      WCCL(9) = WCCL(9)+CHEMCCL(62)*0.2000000000000000d+01
      CHEM(27) = SAVE27
      WCCL(9) = WCCL(9)-CHEMCCL(27)
      CHEM(72) = SAVE26
      WCCL(8) = WCCL(8)+CHEMCCL(72)
      CHEM(68) = SAVE25
      WCCL(8) = WCCL(8)-CHEMCCL(68)
      CHEM(35) = SAVE24
      WCCL(8) = WCCL(8)+CHEMCCL(35)
      CHEM(68) = SAVE23
      WCCL(7) = WCCL(7)-CHEMCCL(68)
      CHEM(67) = SAVE22
      WCCL(7) = WCCL(7)+CHEMCCL(67)
      CHEM(72) = SAVE21
      WCCL(6) = WCCL(6)+CHEMCCL(72)*0.6500000000000000d+00
      CHEM(71) = SAVE20
      WCCL(6) = WCCL(6)+CHEMCCL(71)*0.6500000000000000d+00
      CHEM(68) = SAVE19
      WCCL(6) = WCCL(6)+CHEMCCL(68)*0.3500000000000000d+00
      CHEM(62) = SAVE18
      WCCL(6) = WCCL(6)+CHEMCCL(62)*0.3500000000000000d+00
      CHEM(15) = SAVE17
      WCCL(6) = WCCL(6)-CHEMCCL(15)
      CHEM(72) = SAVE16
      WCCL(5) = WCCL(5)+CHEMCCL(72)
      CHEM(62) = SAVE15
      WCCL(5) = WCCL(5)+CHEMCCL(62)
      CHEM(55) = SAVE14
      WCCL(5) = WCCL(5)-CHEMCCL(55)
      CHEM(67) = SAVE13
      WCCL(4) = WCCL(4)+CHEMCCL(67)
      CHEM(62) = SAVE12
      WCCL(4) = WCCL(4)+CHEMCCL(62)
      CHEM(23) = SAVE11
      WCCL(4) = WCCL(4)-CHEMCCL(23)
      CHEM(50) = SAVE10
      WCCL(3) = WCCL(3)-CHEMCCL(50)
      CHEM(35) = SAVE9
      WCCL(3) = WCCL(3)+CHEMCCL(35)
      CHEM(50) = SAVE8
      WCCL(2) = WCCL(2)-CHEMCCL(50)
      CHEM(7) = SAVE7
      WCCL(2) = WCCL(2)+CHEMCCL(7)
      CHEM(72) = SAVE6
      WCCL(1) = WCCL(1)-CHEMCCL(72)
      CHEM(67) = SAVE5
      WCCL(1) = WCCL(1)+CHEMCCL(67)
      CHEM(35) = SAVE4
      WCCL(1) = WCCL(1)+CHEMCCL(35)
      CHEMCCL(35) = 0d0
      CALL RATESCL(NS, NR, RK, CONC, W, CONCCCL, WCCL)
      DO I = NS, 1, -1
         YCCL(I) = YCCL(I)+CONCCCL(I)*CONVERS_FACTOR(I)
         CONCCCL(I) = 0d0
      END DO
      I = SAVE1205
      DO I = NS, 1, -1
         CHEM(I) = SAVE1(I)
         CHEMCCL(I) = 0d0
      END DO
      END



COD Unit from the initial code : rates



COD Compilation unit : jacdchemdccl
COD Derivative of unit :  jacdchemdc
COD Dummys:  ns nr y convers_factor convers_factor_jac rk jacc
COD Active IN   dummys:  y
COD Active OUT  dummys:  jacc
COD Dependencies between IN and OUT:
COD jacc <--   y


      SUBROUTINE JACDCHEMDCCL (NS, NR, Y, CONVERS_FACTOR,
     : CONVERS_FACTOR_JAC, RK, JACC, YCCL, JACCCCL)

      IMPLICIT NONE
      INTEGER NS
      INTEGER I
      INTEGER J
      INTEGER NR
      INTEGER NNN1
      INTEGER NNN2
      DOUBLE PRECISION CONCCCL(NS)
      DOUBLE PRECISION JACC(NS,NS)
      DOUBLE PRECISION CONVERS_FACTOR_JAC(NS,NS)
      DOUBLE PRECISION DW(NR,NS)
      DOUBLE PRECISION Y(NS)
      DOUBLE PRECISION DWCCL(NR,NS)
      DOUBLE PRECISION YCCL(NS)
      DOUBLE PRECISION CONC(NS)
      DOUBLE PRECISION JACCCCL(NS,NS)
      DOUBLE PRECISION RK(NR)
      DOUBLE PRECISION CONVERS_FACTOR(NS)
      DOUBLE PRECISION SAVE1(NS,NS)
      DOUBLE PRECISION SAVE10
      DOUBLE PRECISION SAVE100
      DOUBLE PRECISION SAVE1000
      DOUBLE PRECISION SAVE1001
      DOUBLE PRECISION SAVE1002
      DOUBLE PRECISION SAVE1003
      DOUBLE PRECISION SAVE1004
      DOUBLE PRECISION SAVE1005
      DOUBLE PRECISION SAVE1006
      DOUBLE PRECISION SAVE1007
      DOUBLE PRECISION SAVE1008
      DOUBLE PRECISION SAVE1009
      DOUBLE PRECISION SAVE101
      DOUBLE PRECISION SAVE1010
      DOUBLE PRECISION SAVE1011
      DOUBLE PRECISION SAVE1012
      DOUBLE PRECISION SAVE1013
      DOUBLE PRECISION SAVE1014
      DOUBLE PRECISION SAVE1015
      DOUBLE PRECISION SAVE1016
      DOUBLE PRECISION SAVE1017
      DOUBLE PRECISION SAVE1018
      DOUBLE PRECISION SAVE1019
      DOUBLE PRECISION SAVE102
      DOUBLE PRECISION SAVE1020
      DOUBLE PRECISION SAVE1021
      DOUBLE PRECISION SAVE1022
      DOUBLE PRECISION SAVE1023
      DOUBLE PRECISION SAVE1024
      DOUBLE PRECISION SAVE1025
      DOUBLE PRECISION SAVE1026
      DOUBLE PRECISION SAVE1027
      DOUBLE PRECISION SAVE1028
      DOUBLE PRECISION SAVE1029
      DOUBLE PRECISION SAVE103
      DOUBLE PRECISION SAVE1030
      DOUBLE PRECISION SAVE1031
      DOUBLE PRECISION SAVE1032
      DOUBLE PRECISION SAVE1033
      DOUBLE PRECISION SAVE1034
      DOUBLE PRECISION SAVE1035
      DOUBLE PRECISION SAVE1036
      DOUBLE PRECISION SAVE1037
      DOUBLE PRECISION SAVE1038
      DOUBLE PRECISION SAVE1039
      DOUBLE PRECISION SAVE104
      DOUBLE PRECISION SAVE1040
      DOUBLE PRECISION SAVE1041
      DOUBLE PRECISION SAVE1042
      DOUBLE PRECISION SAVE1043
      DOUBLE PRECISION SAVE1044
      DOUBLE PRECISION SAVE1045
      DOUBLE PRECISION SAVE1046
      DOUBLE PRECISION SAVE1047
      DOUBLE PRECISION SAVE1048
      DOUBLE PRECISION SAVE1049
      DOUBLE PRECISION SAVE105
      DOUBLE PRECISION SAVE1050
      DOUBLE PRECISION SAVE1051
      DOUBLE PRECISION SAVE1052
      DOUBLE PRECISION SAVE1053
      DOUBLE PRECISION SAVE1054
      DOUBLE PRECISION SAVE1055
      DOUBLE PRECISION SAVE1056
      DOUBLE PRECISION SAVE1057
      DOUBLE PRECISION SAVE1058
      DOUBLE PRECISION SAVE1059
      DOUBLE PRECISION SAVE106
      DOUBLE PRECISION SAVE1060
      DOUBLE PRECISION SAVE1061
      DOUBLE PRECISION SAVE1062
      DOUBLE PRECISION SAVE1063
      DOUBLE PRECISION SAVE1064
      DOUBLE PRECISION SAVE1065
      DOUBLE PRECISION SAVE1066
      DOUBLE PRECISION SAVE1067
      DOUBLE PRECISION SAVE1068
      DOUBLE PRECISION SAVE1069
      DOUBLE PRECISION SAVE107
      DOUBLE PRECISION SAVE1070
      DOUBLE PRECISION SAVE1071
      DOUBLE PRECISION SAVE1072
      DOUBLE PRECISION SAVE1073
      DOUBLE PRECISION SAVE1074
      DOUBLE PRECISION SAVE1075
      DOUBLE PRECISION SAVE1076
      DOUBLE PRECISION SAVE1077
      DOUBLE PRECISION SAVE1078
      DOUBLE PRECISION SAVE1079
      DOUBLE PRECISION SAVE108
      DOUBLE PRECISION SAVE1080
      DOUBLE PRECISION SAVE1081
      DOUBLE PRECISION SAVE1082
      DOUBLE PRECISION SAVE1083
      DOUBLE PRECISION SAVE1084
      DOUBLE PRECISION SAVE1085
      DOUBLE PRECISION SAVE1086
      DOUBLE PRECISION SAVE1087
      DOUBLE PRECISION SAVE1088
      DOUBLE PRECISION SAVE1089
      DOUBLE PRECISION SAVE109
      DOUBLE PRECISION SAVE1090
      DOUBLE PRECISION SAVE1091
      DOUBLE PRECISION SAVE1092
      DOUBLE PRECISION SAVE1093
      DOUBLE PRECISION SAVE1094
      DOUBLE PRECISION SAVE1095
      DOUBLE PRECISION SAVE1096
      DOUBLE PRECISION SAVE1097
      DOUBLE PRECISION SAVE1098
      DOUBLE PRECISION SAVE1099
      DOUBLE PRECISION SAVE11
      DOUBLE PRECISION SAVE110
      DOUBLE PRECISION SAVE1100
      DOUBLE PRECISION SAVE1101
      DOUBLE PRECISION SAVE1102
      DOUBLE PRECISION SAVE1103
      DOUBLE PRECISION SAVE1104
      DOUBLE PRECISION SAVE1105
      DOUBLE PRECISION SAVE1106
      DOUBLE PRECISION SAVE1107
      DOUBLE PRECISION SAVE1108
      DOUBLE PRECISION SAVE1109
      DOUBLE PRECISION SAVE111
      DOUBLE PRECISION SAVE1110
      DOUBLE PRECISION SAVE1111
      DOUBLE PRECISION SAVE1112
      DOUBLE PRECISION SAVE1113
      DOUBLE PRECISION SAVE1114
      DOUBLE PRECISION SAVE1115
      DOUBLE PRECISION SAVE1116
      DOUBLE PRECISION SAVE1117
      DOUBLE PRECISION SAVE1118
      DOUBLE PRECISION SAVE1119
      DOUBLE PRECISION SAVE112
      DOUBLE PRECISION SAVE1120
      DOUBLE PRECISION SAVE1121
      DOUBLE PRECISION SAVE1122
      DOUBLE PRECISION SAVE1123
      DOUBLE PRECISION SAVE1124
      DOUBLE PRECISION SAVE1125
      DOUBLE PRECISION SAVE1126
      DOUBLE PRECISION SAVE1127
      DOUBLE PRECISION SAVE1128
      DOUBLE PRECISION SAVE1129
      DOUBLE PRECISION SAVE113
      DOUBLE PRECISION SAVE1130
      DOUBLE PRECISION SAVE1131
      DOUBLE PRECISION SAVE1132
      DOUBLE PRECISION SAVE1133
      DOUBLE PRECISION SAVE1134
      DOUBLE PRECISION SAVE1135
      DOUBLE PRECISION SAVE1136
      DOUBLE PRECISION SAVE1137
      DOUBLE PRECISION SAVE1138
      DOUBLE PRECISION SAVE1139
      DOUBLE PRECISION SAVE114
      DOUBLE PRECISION SAVE1140
      DOUBLE PRECISION SAVE1141
      DOUBLE PRECISION SAVE1142
      DOUBLE PRECISION SAVE1143
      DOUBLE PRECISION SAVE1144
      DOUBLE PRECISION SAVE1145
      DOUBLE PRECISION SAVE1146
      DOUBLE PRECISION SAVE1147
      DOUBLE PRECISION SAVE1148
      DOUBLE PRECISION SAVE1149
      DOUBLE PRECISION SAVE115
      DOUBLE PRECISION SAVE1150
      DOUBLE PRECISION SAVE1151
      DOUBLE PRECISION SAVE1152
      DOUBLE PRECISION SAVE1153
      DOUBLE PRECISION SAVE1154
      DOUBLE PRECISION SAVE1155
      DOUBLE PRECISION SAVE1156
      DOUBLE PRECISION SAVE1157
      DOUBLE PRECISION SAVE1158
      DOUBLE PRECISION SAVE1159
      DOUBLE PRECISION SAVE116
      DOUBLE PRECISION SAVE1160
      DOUBLE PRECISION SAVE1161
      DOUBLE PRECISION SAVE1162
      DOUBLE PRECISION SAVE1163
      DOUBLE PRECISION SAVE1164
      DOUBLE PRECISION SAVE1165
      DOUBLE PRECISION SAVE1166
      DOUBLE PRECISION SAVE1167
      DOUBLE PRECISION SAVE1168
      DOUBLE PRECISION SAVE1169
      DOUBLE PRECISION SAVE117
      DOUBLE PRECISION SAVE1170
      DOUBLE PRECISION SAVE1171
      DOUBLE PRECISION SAVE1172
      DOUBLE PRECISION SAVE1173
      DOUBLE PRECISION SAVE1174
      DOUBLE PRECISION SAVE1175
      DOUBLE PRECISION SAVE1176
      DOUBLE PRECISION SAVE1177
      DOUBLE PRECISION SAVE1178
      DOUBLE PRECISION SAVE1179
      DOUBLE PRECISION SAVE118
      DOUBLE PRECISION SAVE1180
      DOUBLE PRECISION SAVE1181
      DOUBLE PRECISION SAVE1182
      DOUBLE PRECISION SAVE1183
      DOUBLE PRECISION SAVE1184
      DOUBLE PRECISION SAVE1185
      DOUBLE PRECISION SAVE1186
      DOUBLE PRECISION SAVE1187
      DOUBLE PRECISION SAVE1188
      DOUBLE PRECISION SAVE1189
      DOUBLE PRECISION SAVE119
      DOUBLE PRECISION SAVE1190
      DOUBLE PRECISION SAVE1191
      DOUBLE PRECISION SAVE1192
      DOUBLE PRECISION SAVE1193
      DOUBLE PRECISION SAVE1194
      DOUBLE PRECISION SAVE1195
      DOUBLE PRECISION SAVE1196
      DOUBLE PRECISION SAVE1197
      DOUBLE PRECISION SAVE1198
      DOUBLE PRECISION SAVE1199
      DOUBLE PRECISION SAVE12
      DOUBLE PRECISION SAVE120
      DOUBLE PRECISION SAVE1200
      DOUBLE PRECISION SAVE1201
      DOUBLE PRECISION SAVE1202
      DOUBLE PRECISION SAVE1203
      DOUBLE PRECISION SAVE1204
      DOUBLE PRECISION SAVE1205
      DOUBLE PRECISION SAVE1206
      DOUBLE PRECISION SAVE1207
      DOUBLE PRECISION SAVE1208
      DOUBLE PRECISION SAVE1209
      DOUBLE PRECISION SAVE121
      DOUBLE PRECISION SAVE1210
      DOUBLE PRECISION SAVE1211
      DOUBLE PRECISION SAVE1212
      DOUBLE PRECISION SAVE1213
      DOUBLE PRECISION SAVE1214
      DOUBLE PRECISION SAVE1215
      DOUBLE PRECISION SAVE1216
      DOUBLE PRECISION SAVE1217
      DOUBLE PRECISION SAVE1218
      DOUBLE PRECISION SAVE1219
      DOUBLE PRECISION SAVE122
      DOUBLE PRECISION SAVE1220
      DOUBLE PRECISION SAVE1221
      DOUBLE PRECISION SAVE1222
      DOUBLE PRECISION SAVE1223
      DOUBLE PRECISION SAVE1224
      DOUBLE PRECISION SAVE1225
      DOUBLE PRECISION SAVE1226
      DOUBLE PRECISION SAVE1227
      DOUBLE PRECISION SAVE1228
      DOUBLE PRECISION SAVE1229
      DOUBLE PRECISION SAVE123
      DOUBLE PRECISION SAVE1230
      DOUBLE PRECISION SAVE1231
      DOUBLE PRECISION SAVE1232
      DOUBLE PRECISION SAVE1233
      DOUBLE PRECISION SAVE1234
      DOUBLE PRECISION SAVE1235
      DOUBLE PRECISION SAVE1236
      DOUBLE PRECISION SAVE1237
      DOUBLE PRECISION SAVE1238
      DOUBLE PRECISION SAVE1239
      DOUBLE PRECISION SAVE124
      DOUBLE PRECISION SAVE1240
      DOUBLE PRECISION SAVE1241
      DOUBLE PRECISION SAVE1242
      DOUBLE PRECISION SAVE1243
      DOUBLE PRECISION SAVE1244
      DOUBLE PRECISION SAVE1245
      DOUBLE PRECISION SAVE1246
      DOUBLE PRECISION SAVE1247
      DOUBLE PRECISION SAVE1248
      DOUBLE PRECISION SAVE1249
      DOUBLE PRECISION SAVE125
      DOUBLE PRECISION SAVE1250
      DOUBLE PRECISION SAVE1251
      DOUBLE PRECISION SAVE1252
      DOUBLE PRECISION SAVE1253
      DOUBLE PRECISION SAVE1254
      DOUBLE PRECISION SAVE1255
      DOUBLE PRECISION SAVE1256
      DOUBLE PRECISION SAVE1257
      DOUBLE PRECISION SAVE1258
      DOUBLE PRECISION SAVE1259
      DOUBLE PRECISION SAVE126
      DOUBLE PRECISION SAVE1260
      DOUBLE PRECISION SAVE1261
      DOUBLE PRECISION SAVE1262
      DOUBLE PRECISION SAVE1263
      DOUBLE PRECISION SAVE1264
      DOUBLE PRECISION SAVE1265
      DOUBLE PRECISION SAVE1266
      DOUBLE PRECISION SAVE1267
      DOUBLE PRECISION SAVE1268
      DOUBLE PRECISION SAVE1269
      DOUBLE PRECISION SAVE127
      DOUBLE PRECISION SAVE1270
      DOUBLE PRECISION SAVE1271
      DOUBLE PRECISION SAVE1272
      DOUBLE PRECISION SAVE1273
      DOUBLE PRECISION SAVE1274
      DOUBLE PRECISION SAVE1275
      DOUBLE PRECISION SAVE1276
      DOUBLE PRECISION SAVE1277
      DOUBLE PRECISION SAVE1278
      DOUBLE PRECISION SAVE1279
      DOUBLE PRECISION SAVE128
      DOUBLE PRECISION SAVE1280
      DOUBLE PRECISION SAVE1281
      DOUBLE PRECISION SAVE1282
      DOUBLE PRECISION SAVE1283
      DOUBLE PRECISION SAVE1284
      DOUBLE PRECISION SAVE1285
      DOUBLE PRECISION SAVE1286
      DOUBLE PRECISION SAVE1287
      DOUBLE PRECISION SAVE1288
      DOUBLE PRECISION SAVE1289
      DOUBLE PRECISION SAVE129
      DOUBLE PRECISION SAVE1290
      DOUBLE PRECISION SAVE1291
      DOUBLE PRECISION SAVE1292
      DOUBLE PRECISION SAVE1293
      DOUBLE PRECISION SAVE1294
      DOUBLE PRECISION SAVE1295
      DOUBLE PRECISION SAVE1296
      DOUBLE PRECISION SAVE1297
      DOUBLE PRECISION SAVE1298
      DOUBLE PRECISION SAVE1299
      DOUBLE PRECISION SAVE13
      DOUBLE PRECISION SAVE130
      DOUBLE PRECISION SAVE1300
      DOUBLE PRECISION SAVE1301
      DOUBLE PRECISION SAVE1302
      DOUBLE PRECISION SAVE1303
      DOUBLE PRECISION SAVE1304
      DOUBLE PRECISION SAVE1305
      DOUBLE PRECISION SAVE1306
      DOUBLE PRECISION SAVE1307
      DOUBLE PRECISION SAVE1308
      DOUBLE PRECISION SAVE1309
      DOUBLE PRECISION SAVE131
      DOUBLE PRECISION SAVE1310
      DOUBLE PRECISION SAVE1311
      DOUBLE PRECISION SAVE1312
      DOUBLE PRECISION SAVE1313
      DOUBLE PRECISION SAVE1314
      DOUBLE PRECISION SAVE1315
      DOUBLE PRECISION SAVE1316
      DOUBLE PRECISION SAVE1317
      DOUBLE PRECISION SAVE1318
      DOUBLE PRECISION SAVE1319
      DOUBLE PRECISION SAVE132
      DOUBLE PRECISION SAVE1320
      DOUBLE PRECISION SAVE1321
      DOUBLE PRECISION SAVE1322
      DOUBLE PRECISION SAVE1323
      DOUBLE PRECISION SAVE1324
      DOUBLE PRECISION SAVE1325
      DOUBLE PRECISION SAVE1326
      DOUBLE PRECISION SAVE1327
      DOUBLE PRECISION SAVE1328
      DOUBLE PRECISION SAVE1329
      DOUBLE PRECISION SAVE133
      DOUBLE PRECISION SAVE1330
      DOUBLE PRECISION SAVE1331
      DOUBLE PRECISION SAVE1332
      DOUBLE PRECISION SAVE1333
      DOUBLE PRECISION SAVE1334
      DOUBLE PRECISION SAVE1335
      DOUBLE PRECISION SAVE1336
      DOUBLE PRECISION SAVE1337
      DOUBLE PRECISION SAVE1338
      DOUBLE PRECISION SAVE1339
      DOUBLE PRECISION SAVE134
      DOUBLE PRECISION SAVE1340
      DOUBLE PRECISION SAVE1341
      DOUBLE PRECISION SAVE1342
      DOUBLE PRECISION SAVE1343
      DOUBLE PRECISION SAVE1344
      DOUBLE PRECISION SAVE1345
      DOUBLE PRECISION SAVE1346
      DOUBLE PRECISION SAVE1347
      DOUBLE PRECISION SAVE1348
      DOUBLE PRECISION SAVE1349
      DOUBLE PRECISION SAVE135
      DOUBLE PRECISION SAVE1350
      DOUBLE PRECISION SAVE1351
      DOUBLE PRECISION SAVE1352
      DOUBLE PRECISION SAVE1353
      DOUBLE PRECISION SAVE1354
      DOUBLE PRECISION SAVE1355
      DOUBLE PRECISION SAVE1356
      DOUBLE PRECISION SAVE1357
      DOUBLE PRECISION SAVE1358
      DOUBLE PRECISION SAVE1359
      DOUBLE PRECISION SAVE136
      DOUBLE PRECISION SAVE1360
      DOUBLE PRECISION SAVE1361
      DOUBLE PRECISION SAVE1362
      DOUBLE PRECISION SAVE1363
      DOUBLE PRECISION SAVE1364
      DOUBLE PRECISION SAVE1365
      DOUBLE PRECISION SAVE1366
      DOUBLE PRECISION SAVE1367
      DOUBLE PRECISION SAVE1368
      DOUBLE PRECISION SAVE1369
      DOUBLE PRECISION SAVE137
      DOUBLE PRECISION SAVE1370
      DOUBLE PRECISION SAVE1371
      DOUBLE PRECISION SAVE1372
      DOUBLE PRECISION SAVE1373
      DOUBLE PRECISION SAVE1374
      DOUBLE PRECISION SAVE1375
      DOUBLE PRECISION SAVE1376
      DOUBLE PRECISION SAVE1377
      DOUBLE PRECISION SAVE1378
      DOUBLE PRECISION SAVE1379
      DOUBLE PRECISION SAVE138
      DOUBLE PRECISION SAVE1380
      DOUBLE PRECISION SAVE1381
      DOUBLE PRECISION SAVE1382
      DOUBLE PRECISION SAVE1383
      DOUBLE PRECISION SAVE1384
      DOUBLE PRECISION SAVE1385
      DOUBLE PRECISION SAVE1386
      DOUBLE PRECISION SAVE1387
      DOUBLE PRECISION SAVE1388
      DOUBLE PRECISION SAVE1389
      DOUBLE PRECISION SAVE139
      DOUBLE PRECISION SAVE1390
      DOUBLE PRECISION SAVE1391
      DOUBLE PRECISION SAVE1392
      DOUBLE PRECISION SAVE1393
      DOUBLE PRECISION SAVE1394
      DOUBLE PRECISION SAVE1395
      DOUBLE PRECISION SAVE1396
      DOUBLE PRECISION SAVE1397
      DOUBLE PRECISION SAVE1398
      DOUBLE PRECISION SAVE1399
      DOUBLE PRECISION SAVE14
      DOUBLE PRECISION SAVE140
      DOUBLE PRECISION SAVE1400
      DOUBLE PRECISION SAVE1401
      DOUBLE PRECISION SAVE1402
      DOUBLE PRECISION SAVE1403
      DOUBLE PRECISION SAVE1404
      DOUBLE PRECISION SAVE1405
      DOUBLE PRECISION SAVE1406
      DOUBLE PRECISION SAVE1407
      DOUBLE PRECISION SAVE1408
      DOUBLE PRECISION SAVE1409
      DOUBLE PRECISION SAVE141
      DOUBLE PRECISION SAVE1410
      DOUBLE PRECISION SAVE1411
      DOUBLE PRECISION SAVE1412
      DOUBLE PRECISION SAVE1413
      DOUBLE PRECISION SAVE1414
      DOUBLE PRECISION SAVE1415
      DOUBLE PRECISION SAVE1416
      DOUBLE PRECISION SAVE1417
      DOUBLE PRECISION SAVE1418
      DOUBLE PRECISION SAVE1419
      DOUBLE PRECISION SAVE142
      DOUBLE PRECISION SAVE1420
      DOUBLE PRECISION SAVE1421
      DOUBLE PRECISION SAVE1422
      DOUBLE PRECISION SAVE1423
      DOUBLE PRECISION SAVE1424
      DOUBLE PRECISION SAVE1425
      DOUBLE PRECISION SAVE1426
      DOUBLE PRECISION SAVE1427
      DOUBLE PRECISION SAVE1428
      DOUBLE PRECISION SAVE1429
      DOUBLE PRECISION SAVE143
      DOUBLE PRECISION SAVE1430
      DOUBLE PRECISION SAVE1431
      DOUBLE PRECISION SAVE1432
      DOUBLE PRECISION SAVE1433
      DOUBLE PRECISION SAVE1434
      DOUBLE PRECISION SAVE1435
      DOUBLE PRECISION SAVE1436
      DOUBLE PRECISION SAVE1437
      DOUBLE PRECISION SAVE1438
      DOUBLE PRECISION SAVE1439
      DOUBLE PRECISION SAVE144
      DOUBLE PRECISION SAVE1440
      DOUBLE PRECISION SAVE1441
      DOUBLE PRECISION SAVE1442
      DOUBLE PRECISION SAVE1443
      DOUBLE PRECISION SAVE1444
      DOUBLE PRECISION SAVE1445
      DOUBLE PRECISION SAVE1446
      DOUBLE PRECISION SAVE1447
      DOUBLE PRECISION SAVE1448
      DOUBLE PRECISION SAVE1449
      DOUBLE PRECISION SAVE145
      DOUBLE PRECISION SAVE1450
      DOUBLE PRECISION SAVE1451
      DOUBLE PRECISION SAVE1452
      DOUBLE PRECISION SAVE1453
      DOUBLE PRECISION SAVE1454
      DOUBLE PRECISION SAVE1455
      DOUBLE PRECISION SAVE1456
      DOUBLE PRECISION SAVE1457
      DOUBLE PRECISION SAVE1458
      DOUBLE PRECISION SAVE1459
      DOUBLE PRECISION SAVE146
      DOUBLE PRECISION SAVE1460
      DOUBLE PRECISION SAVE1461
      DOUBLE PRECISION SAVE1462
      DOUBLE PRECISION SAVE1463
      DOUBLE PRECISION SAVE1464
      DOUBLE PRECISION SAVE1465
      DOUBLE PRECISION SAVE1466
      DOUBLE PRECISION SAVE1467
      DOUBLE PRECISION SAVE1468
      DOUBLE PRECISION SAVE1469
      DOUBLE PRECISION SAVE147
      DOUBLE PRECISION SAVE1470
      DOUBLE PRECISION SAVE1471
      DOUBLE PRECISION SAVE1472
      DOUBLE PRECISION SAVE1473
      DOUBLE PRECISION SAVE1474
      DOUBLE PRECISION SAVE1475
      DOUBLE PRECISION SAVE1476
      DOUBLE PRECISION SAVE1477
      DOUBLE PRECISION SAVE1478
      DOUBLE PRECISION SAVE1479
      DOUBLE PRECISION SAVE148
      DOUBLE PRECISION SAVE1480
      DOUBLE PRECISION SAVE1481
      DOUBLE PRECISION SAVE1482
      DOUBLE PRECISION SAVE1483
      DOUBLE PRECISION SAVE1484
      DOUBLE PRECISION SAVE1485
      DOUBLE PRECISION SAVE1486
      DOUBLE PRECISION SAVE1487
      DOUBLE PRECISION SAVE1488
      DOUBLE PRECISION SAVE1489
      DOUBLE PRECISION SAVE149
      DOUBLE PRECISION SAVE1490
      DOUBLE PRECISION SAVE1491
      DOUBLE PRECISION SAVE1492
      DOUBLE PRECISION SAVE1493
      DOUBLE PRECISION SAVE1494
      DOUBLE PRECISION SAVE1495
      DOUBLE PRECISION SAVE1496
      DOUBLE PRECISION SAVE1497
      DOUBLE PRECISION SAVE1498
      DOUBLE PRECISION SAVE1499
      DOUBLE PRECISION SAVE15
      DOUBLE PRECISION SAVE150
      DOUBLE PRECISION SAVE1500
      DOUBLE PRECISION SAVE1501
      DOUBLE PRECISION SAVE1502
      DOUBLE PRECISION SAVE1503
      DOUBLE PRECISION SAVE1504
      DOUBLE PRECISION SAVE1505
      DOUBLE PRECISION SAVE1506
      DOUBLE PRECISION SAVE1507
      DOUBLE PRECISION SAVE1508
      DOUBLE PRECISION SAVE1509
      DOUBLE PRECISION SAVE151
      DOUBLE PRECISION SAVE1510
      DOUBLE PRECISION SAVE1511
      DOUBLE PRECISION SAVE1512
      DOUBLE PRECISION SAVE1513
      DOUBLE PRECISION SAVE1514
      DOUBLE PRECISION SAVE1515
      DOUBLE PRECISION SAVE1516
      DOUBLE PRECISION SAVE1517
      DOUBLE PRECISION SAVE1518
      DOUBLE PRECISION SAVE1519
      DOUBLE PRECISION SAVE152
      DOUBLE PRECISION SAVE1520
      DOUBLE PRECISION SAVE1521
      DOUBLE PRECISION SAVE1522
      DOUBLE PRECISION SAVE1523
      DOUBLE PRECISION SAVE1524
      DOUBLE PRECISION SAVE1525
      DOUBLE PRECISION SAVE1526
      DOUBLE PRECISION SAVE1527
      DOUBLE PRECISION SAVE1528
      DOUBLE PRECISION SAVE1529
      DOUBLE PRECISION SAVE153
      DOUBLE PRECISION SAVE1530
      DOUBLE PRECISION SAVE1531
      DOUBLE PRECISION SAVE1532
      DOUBLE PRECISION SAVE1533
      DOUBLE PRECISION SAVE1534
      DOUBLE PRECISION SAVE1535
      DOUBLE PRECISION SAVE1536
      DOUBLE PRECISION SAVE1537
      DOUBLE PRECISION SAVE1538
      DOUBLE PRECISION SAVE1539
      DOUBLE PRECISION SAVE154
      DOUBLE PRECISION SAVE1540
      DOUBLE PRECISION SAVE1541
      DOUBLE PRECISION SAVE1542
      DOUBLE PRECISION SAVE1543
      DOUBLE PRECISION SAVE1544
      DOUBLE PRECISION SAVE1545
      DOUBLE PRECISION SAVE1546
      DOUBLE PRECISION SAVE1547
      DOUBLE PRECISION SAVE1548
      DOUBLE PRECISION SAVE1549
      DOUBLE PRECISION SAVE155
      DOUBLE PRECISION SAVE1550
      DOUBLE PRECISION SAVE1551
      DOUBLE PRECISION SAVE1552
      DOUBLE PRECISION SAVE1553
      DOUBLE PRECISION SAVE1554
      DOUBLE PRECISION SAVE1555
      DOUBLE PRECISION SAVE1556
      DOUBLE PRECISION SAVE1557
      DOUBLE PRECISION SAVE1558
      DOUBLE PRECISION SAVE1559
      DOUBLE PRECISION SAVE156
      DOUBLE PRECISION SAVE1560
      DOUBLE PRECISION SAVE1561
      DOUBLE PRECISION SAVE1562
      DOUBLE PRECISION SAVE1563
      DOUBLE PRECISION SAVE1564
      DOUBLE PRECISION SAVE1565
      DOUBLE PRECISION SAVE1566
      DOUBLE PRECISION SAVE1567
      DOUBLE PRECISION SAVE1568
      DOUBLE PRECISION SAVE1569
      DOUBLE PRECISION SAVE157
      DOUBLE PRECISION SAVE1570
      DOUBLE PRECISION SAVE1571
      DOUBLE PRECISION SAVE1572
      DOUBLE PRECISION SAVE1573
      DOUBLE PRECISION SAVE1574
      DOUBLE PRECISION SAVE1575
      DOUBLE PRECISION SAVE1576
      DOUBLE PRECISION SAVE1577
      DOUBLE PRECISION SAVE1578
      DOUBLE PRECISION SAVE1579
      DOUBLE PRECISION SAVE158
      DOUBLE PRECISION SAVE1580
      DOUBLE PRECISION SAVE1581
      DOUBLE PRECISION SAVE1582
      DOUBLE PRECISION SAVE1583
      DOUBLE PRECISION SAVE1584
      DOUBLE PRECISION SAVE1585
      DOUBLE PRECISION SAVE1586
      DOUBLE PRECISION SAVE1587
      DOUBLE PRECISION SAVE1588
      DOUBLE PRECISION SAVE1589
      DOUBLE PRECISION SAVE159
      DOUBLE PRECISION SAVE1590
      DOUBLE PRECISION SAVE1591
      DOUBLE PRECISION SAVE1592
      DOUBLE PRECISION SAVE1593
      DOUBLE PRECISION SAVE1594
      DOUBLE PRECISION SAVE1595
      DOUBLE PRECISION SAVE1596
      DOUBLE PRECISION SAVE1597
      DOUBLE PRECISION SAVE1598
      DOUBLE PRECISION SAVE1599
      DOUBLE PRECISION SAVE16
      DOUBLE PRECISION SAVE160
      DOUBLE PRECISION SAVE1600
      DOUBLE PRECISION SAVE1601
      DOUBLE PRECISION SAVE1602
      DOUBLE PRECISION SAVE1603
      DOUBLE PRECISION SAVE1604
      DOUBLE PRECISION SAVE1605
      DOUBLE PRECISION SAVE1606
      DOUBLE PRECISION SAVE1607
      DOUBLE PRECISION SAVE1608
      DOUBLE PRECISION SAVE1609
      DOUBLE PRECISION SAVE161
      DOUBLE PRECISION SAVE1610
      DOUBLE PRECISION SAVE1611
      DOUBLE PRECISION SAVE1612
      DOUBLE PRECISION SAVE1613
      DOUBLE PRECISION SAVE1614
      DOUBLE PRECISION SAVE1615
      DOUBLE PRECISION SAVE1616
      DOUBLE PRECISION SAVE1617
      DOUBLE PRECISION SAVE1618
      DOUBLE PRECISION SAVE1619
      DOUBLE PRECISION SAVE162
      DOUBLE PRECISION SAVE1620
      DOUBLE PRECISION SAVE1621
      DOUBLE PRECISION SAVE1622
      DOUBLE PRECISION SAVE1623
      DOUBLE PRECISION SAVE1624
      DOUBLE PRECISION SAVE1625
      DOUBLE PRECISION SAVE1626
      DOUBLE PRECISION SAVE1627
      DOUBLE PRECISION SAVE1628
      DOUBLE PRECISION SAVE1629
      DOUBLE PRECISION SAVE163
      DOUBLE PRECISION SAVE1630
      DOUBLE PRECISION SAVE1631
      DOUBLE PRECISION SAVE1632
      DOUBLE PRECISION SAVE1633
      DOUBLE PRECISION SAVE1634
      DOUBLE PRECISION SAVE1635
      DOUBLE PRECISION SAVE1636
      DOUBLE PRECISION SAVE1637
      DOUBLE PRECISION SAVE1638
      DOUBLE PRECISION SAVE1639
      DOUBLE PRECISION SAVE164
      DOUBLE PRECISION SAVE1640
      DOUBLE PRECISION SAVE1641
      DOUBLE PRECISION SAVE1642
      DOUBLE PRECISION SAVE1643
      DOUBLE PRECISION SAVE1644
      DOUBLE PRECISION SAVE1645
      DOUBLE PRECISION SAVE1646
      DOUBLE PRECISION SAVE1647
      DOUBLE PRECISION SAVE1648
      DOUBLE PRECISION SAVE1649
      DOUBLE PRECISION SAVE165
      DOUBLE PRECISION SAVE1650
      DOUBLE PRECISION SAVE1651
      DOUBLE PRECISION SAVE1652
      DOUBLE PRECISION SAVE1653
      DOUBLE PRECISION SAVE1654
      DOUBLE PRECISION SAVE1655
      DOUBLE PRECISION SAVE1656
      DOUBLE PRECISION SAVE1657
      DOUBLE PRECISION SAVE1658
      DOUBLE PRECISION SAVE1659
      DOUBLE PRECISION SAVE166
      DOUBLE PRECISION SAVE1660
      DOUBLE PRECISION SAVE1661
      DOUBLE PRECISION SAVE1662
      DOUBLE PRECISION SAVE1663
      DOUBLE PRECISION SAVE1664
      DOUBLE PRECISION SAVE1665
      DOUBLE PRECISION SAVE1666
      DOUBLE PRECISION SAVE1667
      DOUBLE PRECISION SAVE1668
      DOUBLE PRECISION SAVE1669
      DOUBLE PRECISION SAVE167
      DOUBLE PRECISION SAVE1670
      DOUBLE PRECISION SAVE1671
      DOUBLE PRECISION SAVE1672
      DOUBLE PRECISION SAVE1673
      DOUBLE PRECISION SAVE1674
      DOUBLE PRECISION SAVE1675
      DOUBLE PRECISION SAVE1676
      DOUBLE PRECISION SAVE1677
      DOUBLE PRECISION SAVE1678
      DOUBLE PRECISION SAVE1679
      DOUBLE PRECISION SAVE168
      DOUBLE PRECISION SAVE1680
      DOUBLE PRECISION SAVE1681
      DOUBLE PRECISION SAVE1682
      DOUBLE PRECISION SAVE1683
      DOUBLE PRECISION SAVE1684
      DOUBLE PRECISION SAVE1685
      DOUBLE PRECISION SAVE1686
      DOUBLE PRECISION SAVE1687
      DOUBLE PRECISION SAVE1688
      DOUBLE PRECISION SAVE1689
      DOUBLE PRECISION SAVE169
      DOUBLE PRECISION SAVE1690
      DOUBLE PRECISION SAVE1691
      DOUBLE PRECISION SAVE1692
      DOUBLE PRECISION SAVE1693
      DOUBLE PRECISION SAVE1694
      DOUBLE PRECISION SAVE1695
      DOUBLE PRECISION SAVE1696
      DOUBLE PRECISION SAVE1697
      DOUBLE PRECISION SAVE1698
      DOUBLE PRECISION SAVE1699
      DOUBLE PRECISION SAVE17
      DOUBLE PRECISION SAVE170
      DOUBLE PRECISION SAVE1700
      DOUBLE PRECISION SAVE1701
      DOUBLE PRECISION SAVE1702
      DOUBLE PRECISION SAVE1703
      DOUBLE PRECISION SAVE1704
      DOUBLE PRECISION SAVE1705
      DOUBLE PRECISION SAVE1706
      DOUBLE PRECISION SAVE1707
      DOUBLE PRECISION SAVE1708
      DOUBLE PRECISION SAVE1709
      DOUBLE PRECISION SAVE171
      DOUBLE PRECISION SAVE1710
      DOUBLE PRECISION SAVE1711
      DOUBLE PRECISION SAVE1712
      DOUBLE PRECISION SAVE1713
      DOUBLE PRECISION SAVE1714
      DOUBLE PRECISION SAVE1715
      DOUBLE PRECISION SAVE1716
      DOUBLE PRECISION SAVE1717
      DOUBLE PRECISION SAVE1718
      DOUBLE PRECISION SAVE1719
      DOUBLE PRECISION SAVE172
      DOUBLE PRECISION SAVE1720
      DOUBLE PRECISION SAVE1721
      DOUBLE PRECISION SAVE1722
      DOUBLE PRECISION SAVE1723
      DOUBLE PRECISION SAVE1724
      DOUBLE PRECISION SAVE1725
      DOUBLE PRECISION SAVE1726
      DOUBLE PRECISION SAVE1727
      DOUBLE PRECISION SAVE1728
      DOUBLE PRECISION SAVE1729
      DOUBLE PRECISION SAVE173
      DOUBLE PRECISION SAVE1730
      DOUBLE PRECISION SAVE1731
      DOUBLE PRECISION SAVE1732
      DOUBLE PRECISION SAVE1733
      DOUBLE PRECISION SAVE1734
      DOUBLE PRECISION SAVE1735
      DOUBLE PRECISION SAVE1736
      DOUBLE PRECISION SAVE1737
      DOUBLE PRECISION SAVE1738
      DOUBLE PRECISION SAVE1739
      DOUBLE PRECISION SAVE174
      DOUBLE PRECISION SAVE1740
      DOUBLE PRECISION SAVE1741
      DOUBLE PRECISION SAVE1742
      DOUBLE PRECISION SAVE1743
      DOUBLE PRECISION SAVE1744
      DOUBLE PRECISION SAVE1745
      DOUBLE PRECISION SAVE1746
      DOUBLE PRECISION SAVE1747
      DOUBLE PRECISION SAVE1748
      DOUBLE PRECISION SAVE1749
      DOUBLE PRECISION SAVE175
      DOUBLE PRECISION SAVE1750
      DOUBLE PRECISION SAVE1751
      DOUBLE PRECISION SAVE1752
      DOUBLE PRECISION SAVE1753
      DOUBLE PRECISION SAVE1754
      DOUBLE PRECISION SAVE1755
      DOUBLE PRECISION SAVE1756
      DOUBLE PRECISION SAVE1757
      DOUBLE PRECISION SAVE1758
      DOUBLE PRECISION SAVE1759
      DOUBLE PRECISION SAVE176
      DOUBLE PRECISION SAVE1760
      DOUBLE PRECISION SAVE1761
      DOUBLE PRECISION SAVE1762
      DOUBLE PRECISION SAVE1763
      DOUBLE PRECISION SAVE1764
      DOUBLE PRECISION SAVE1765
      DOUBLE PRECISION SAVE1766
      DOUBLE PRECISION SAVE1767
      DOUBLE PRECISION SAVE1768
      DOUBLE PRECISION SAVE1769
      DOUBLE PRECISION SAVE177
      DOUBLE PRECISION SAVE1770
      DOUBLE PRECISION SAVE1771
      DOUBLE PRECISION SAVE1772
      DOUBLE PRECISION SAVE1773
      DOUBLE PRECISION SAVE1774
      DOUBLE PRECISION SAVE1775
      DOUBLE PRECISION SAVE1776
      DOUBLE PRECISION SAVE1777
      DOUBLE PRECISION SAVE1778
      DOUBLE PRECISION SAVE1779
      DOUBLE PRECISION SAVE178
      DOUBLE PRECISION SAVE1780
      DOUBLE PRECISION SAVE1781
      DOUBLE PRECISION SAVE1782
      DOUBLE PRECISION SAVE1783
      DOUBLE PRECISION SAVE1784
      DOUBLE PRECISION SAVE1785
      DOUBLE PRECISION SAVE1786
      DOUBLE PRECISION SAVE1787
      DOUBLE PRECISION SAVE1788
      DOUBLE PRECISION SAVE1789
      DOUBLE PRECISION SAVE179
      DOUBLE PRECISION SAVE1790
      DOUBLE PRECISION SAVE1791
      DOUBLE PRECISION SAVE1792
      DOUBLE PRECISION SAVE1793
      DOUBLE PRECISION SAVE1794
      DOUBLE PRECISION SAVE1795
      DOUBLE PRECISION SAVE1796
      DOUBLE PRECISION SAVE1797
      DOUBLE PRECISION SAVE1798
      DOUBLE PRECISION SAVE1799
      DOUBLE PRECISION SAVE18
      DOUBLE PRECISION SAVE180
      DOUBLE PRECISION SAVE1800
      DOUBLE PRECISION SAVE1801
      DOUBLE PRECISION SAVE1802
      DOUBLE PRECISION SAVE1803
      DOUBLE PRECISION SAVE1804
      DOUBLE PRECISION SAVE1805
      DOUBLE PRECISION SAVE1806
      DOUBLE PRECISION SAVE1807
      DOUBLE PRECISION SAVE1808
      DOUBLE PRECISION SAVE1809
      DOUBLE PRECISION SAVE181
      DOUBLE PRECISION SAVE1810
      DOUBLE PRECISION SAVE1811
      DOUBLE PRECISION SAVE1812
      DOUBLE PRECISION SAVE1813
      DOUBLE PRECISION SAVE1814
      DOUBLE PRECISION SAVE1815
      DOUBLE PRECISION SAVE1816
      DOUBLE PRECISION SAVE1817
      DOUBLE PRECISION SAVE1818
      DOUBLE PRECISION SAVE1819
      DOUBLE PRECISION SAVE182
      DOUBLE PRECISION SAVE1820
      DOUBLE PRECISION SAVE1821
      DOUBLE PRECISION SAVE1822
      DOUBLE PRECISION SAVE1823
      DOUBLE PRECISION SAVE1824
      DOUBLE PRECISION SAVE1825
      DOUBLE PRECISION SAVE1826
      DOUBLE PRECISION SAVE1827
      DOUBLE PRECISION SAVE1828
      DOUBLE PRECISION SAVE1829
      DOUBLE PRECISION SAVE183
      DOUBLE PRECISION SAVE1830
      DOUBLE PRECISION SAVE1831
      DOUBLE PRECISION SAVE1832
      DOUBLE PRECISION SAVE1833
      DOUBLE PRECISION SAVE1834
      DOUBLE PRECISION SAVE1835
      DOUBLE PRECISION SAVE1836
      DOUBLE PRECISION SAVE1837
      DOUBLE PRECISION SAVE1838
      DOUBLE PRECISION SAVE1839
      DOUBLE PRECISION SAVE184
      DOUBLE PRECISION SAVE1840
      DOUBLE PRECISION SAVE1841
      DOUBLE PRECISION SAVE1842
      DOUBLE PRECISION SAVE1843
      DOUBLE PRECISION SAVE1844
      DOUBLE PRECISION SAVE1845
      DOUBLE PRECISION SAVE1846
      DOUBLE PRECISION SAVE1847
      DOUBLE PRECISION SAVE1848
      DOUBLE PRECISION SAVE1849
      DOUBLE PRECISION SAVE185
      DOUBLE PRECISION SAVE1850
      DOUBLE PRECISION SAVE1851
      DOUBLE PRECISION SAVE1852
      DOUBLE PRECISION SAVE1853
      DOUBLE PRECISION SAVE1854
      DOUBLE PRECISION SAVE1855
      DOUBLE PRECISION SAVE1856
      DOUBLE PRECISION SAVE1857
      DOUBLE PRECISION SAVE1858
      DOUBLE PRECISION SAVE1859
      DOUBLE PRECISION SAVE186
      DOUBLE PRECISION SAVE1860
      DOUBLE PRECISION SAVE1861
      DOUBLE PRECISION SAVE1862
      DOUBLE PRECISION SAVE1863
      DOUBLE PRECISION SAVE1864
      DOUBLE PRECISION SAVE1865
      DOUBLE PRECISION SAVE1866
      DOUBLE PRECISION SAVE1867
      DOUBLE PRECISION SAVE1868
      DOUBLE PRECISION SAVE1869
      DOUBLE PRECISION SAVE187
      DOUBLE PRECISION SAVE1870
      DOUBLE PRECISION SAVE1871
      DOUBLE PRECISION SAVE1872
      DOUBLE PRECISION SAVE1873
      DOUBLE PRECISION SAVE1874
      DOUBLE PRECISION SAVE1875
      DOUBLE PRECISION SAVE1876
      DOUBLE PRECISION SAVE1877
      DOUBLE PRECISION SAVE1878
      DOUBLE PRECISION SAVE1879
      DOUBLE PRECISION SAVE188
      DOUBLE PRECISION SAVE1880
      DOUBLE PRECISION SAVE1881
      DOUBLE PRECISION SAVE1882
      DOUBLE PRECISION SAVE1883
      DOUBLE PRECISION SAVE1884
      DOUBLE PRECISION SAVE1885
      DOUBLE PRECISION SAVE1886
      DOUBLE PRECISION SAVE1887
      DOUBLE PRECISION SAVE1888
      DOUBLE PRECISION SAVE1889
      DOUBLE PRECISION SAVE189
      DOUBLE PRECISION SAVE1890
      DOUBLE PRECISION SAVE1891
      DOUBLE PRECISION SAVE1892
      DOUBLE PRECISION SAVE1893
      DOUBLE PRECISION SAVE1894
      DOUBLE PRECISION SAVE1895
      DOUBLE PRECISION SAVE1896
      DOUBLE PRECISION SAVE1897
      DOUBLE PRECISION SAVE1898
      DOUBLE PRECISION SAVE1899
      DOUBLE PRECISION SAVE19
      DOUBLE PRECISION SAVE190
      DOUBLE PRECISION SAVE1900
      DOUBLE PRECISION SAVE1901
      DOUBLE PRECISION SAVE1902
      DOUBLE PRECISION SAVE1903
      DOUBLE PRECISION SAVE1904
      DOUBLE PRECISION SAVE1905
      DOUBLE PRECISION SAVE1906
      DOUBLE PRECISION SAVE1907
      DOUBLE PRECISION SAVE1908
      DOUBLE PRECISION SAVE1909
      DOUBLE PRECISION SAVE191
      DOUBLE PRECISION SAVE1910
      DOUBLE PRECISION SAVE1911
      DOUBLE PRECISION SAVE1912
      DOUBLE PRECISION SAVE1913
      DOUBLE PRECISION SAVE1914
      DOUBLE PRECISION SAVE1915
      DOUBLE PRECISION SAVE1916
      DOUBLE PRECISION SAVE1917
      DOUBLE PRECISION SAVE1918
      DOUBLE PRECISION SAVE1919
      DOUBLE PRECISION SAVE192
      DOUBLE PRECISION SAVE1920
      DOUBLE PRECISION SAVE1921
      DOUBLE PRECISION SAVE1922
      DOUBLE PRECISION SAVE1923
      DOUBLE PRECISION SAVE1924
      DOUBLE PRECISION SAVE1925
      DOUBLE PRECISION SAVE1926
      DOUBLE PRECISION SAVE1927
      DOUBLE PRECISION SAVE1928
      DOUBLE PRECISION SAVE1929
      DOUBLE PRECISION SAVE193
      DOUBLE PRECISION SAVE1930
      DOUBLE PRECISION SAVE1931
      DOUBLE PRECISION SAVE1932
      DOUBLE PRECISION SAVE1933
      DOUBLE PRECISION SAVE1934
      DOUBLE PRECISION SAVE1935
      DOUBLE PRECISION SAVE1936
      DOUBLE PRECISION SAVE1937
      DOUBLE PRECISION SAVE1938
      DOUBLE PRECISION SAVE1939
      DOUBLE PRECISION SAVE194
      DOUBLE PRECISION SAVE1940
      DOUBLE PRECISION SAVE1941
      DOUBLE PRECISION SAVE1942
      DOUBLE PRECISION SAVE1943
      DOUBLE PRECISION SAVE1944
      DOUBLE PRECISION SAVE1945
      DOUBLE PRECISION SAVE1946
      DOUBLE PRECISION SAVE1947
      DOUBLE PRECISION SAVE1948
      DOUBLE PRECISION SAVE1949
      DOUBLE PRECISION SAVE195
      DOUBLE PRECISION SAVE1950
      DOUBLE PRECISION SAVE1951
      DOUBLE PRECISION SAVE1952
      DOUBLE PRECISION SAVE1953
      DOUBLE PRECISION SAVE1954
      DOUBLE PRECISION SAVE1955
      DOUBLE PRECISION SAVE1956
      DOUBLE PRECISION SAVE1957
      DOUBLE PRECISION SAVE1958
      DOUBLE PRECISION SAVE1959
      DOUBLE PRECISION SAVE196
      DOUBLE PRECISION SAVE1960
      DOUBLE PRECISION SAVE1961
      DOUBLE PRECISION SAVE1962
      DOUBLE PRECISION SAVE1963
      DOUBLE PRECISION SAVE1964
      DOUBLE PRECISION SAVE1965
      DOUBLE PRECISION SAVE1966
      DOUBLE PRECISION SAVE1967
      DOUBLE PRECISION SAVE1968
      DOUBLE PRECISION SAVE1969
      DOUBLE PRECISION SAVE197
      DOUBLE PRECISION SAVE1970
      DOUBLE PRECISION SAVE1971
      DOUBLE PRECISION SAVE1972
      DOUBLE PRECISION SAVE1973
      DOUBLE PRECISION SAVE1974
      DOUBLE PRECISION SAVE1975
      DOUBLE PRECISION SAVE1976
      DOUBLE PRECISION SAVE1977
      DOUBLE PRECISION SAVE1978
      DOUBLE PRECISION SAVE1979
      DOUBLE PRECISION SAVE198
      DOUBLE PRECISION SAVE1980
      DOUBLE PRECISION SAVE1981
      DOUBLE PRECISION SAVE1982
      DOUBLE PRECISION SAVE1983
      DOUBLE PRECISION SAVE1984
      DOUBLE PRECISION SAVE1985
      DOUBLE PRECISION SAVE1986
      DOUBLE PRECISION SAVE1987
      DOUBLE PRECISION SAVE1988
      DOUBLE PRECISION SAVE1989
      DOUBLE PRECISION SAVE199
      DOUBLE PRECISION SAVE1990
      DOUBLE PRECISION SAVE1991
      DOUBLE PRECISION SAVE1992
      DOUBLE PRECISION SAVE1993
      DOUBLE PRECISION SAVE1994
      DOUBLE PRECISION SAVE1995
      DOUBLE PRECISION SAVE1996
      DOUBLE PRECISION SAVE1997
      DOUBLE PRECISION SAVE1998
      DOUBLE PRECISION SAVE1999
      INTEGER SAVE2(NS)
      DOUBLE PRECISION SAVE20
      DOUBLE PRECISION SAVE200
      DOUBLE PRECISION SAVE2000
      DOUBLE PRECISION SAVE2001
      DOUBLE PRECISION SAVE2002
      DOUBLE PRECISION SAVE2003
      DOUBLE PRECISION SAVE2004
      DOUBLE PRECISION SAVE2005
      DOUBLE PRECISION SAVE2006
      DOUBLE PRECISION SAVE2007
      DOUBLE PRECISION SAVE2008
      DOUBLE PRECISION SAVE2009
      DOUBLE PRECISION SAVE201
      DOUBLE PRECISION SAVE2010
      DOUBLE PRECISION SAVE2011
      DOUBLE PRECISION SAVE2012
      DOUBLE PRECISION SAVE2013
      DOUBLE PRECISION SAVE2014
      DOUBLE PRECISION SAVE2015
      DOUBLE PRECISION SAVE2016
      DOUBLE PRECISION SAVE2017
      DOUBLE PRECISION SAVE2018
      DOUBLE PRECISION SAVE2019
      DOUBLE PRECISION SAVE202
      DOUBLE PRECISION SAVE2020
      DOUBLE PRECISION SAVE2021
      DOUBLE PRECISION SAVE2022
      DOUBLE PRECISION SAVE2023
      DOUBLE PRECISION SAVE2024
      DOUBLE PRECISION SAVE2025
      DOUBLE PRECISION SAVE2026
      DOUBLE PRECISION SAVE2027
      DOUBLE PRECISION SAVE2028
      DOUBLE PRECISION SAVE2029
      DOUBLE PRECISION SAVE203
      DOUBLE PRECISION SAVE2030
      DOUBLE PRECISION SAVE2031
      DOUBLE PRECISION SAVE2032
      DOUBLE PRECISION SAVE2033
      DOUBLE PRECISION SAVE2034
      DOUBLE PRECISION SAVE2035
      DOUBLE PRECISION SAVE2036
      DOUBLE PRECISION SAVE2037
      DOUBLE PRECISION SAVE2038
      DOUBLE PRECISION SAVE2039
      DOUBLE PRECISION SAVE204
      DOUBLE PRECISION SAVE2040
      DOUBLE PRECISION SAVE2041
      DOUBLE PRECISION SAVE2042
      DOUBLE PRECISION SAVE2043
      DOUBLE PRECISION SAVE2044
      DOUBLE PRECISION SAVE2045
      DOUBLE PRECISION SAVE2046
      DOUBLE PRECISION SAVE2047
      DOUBLE PRECISION SAVE2048
      DOUBLE PRECISION SAVE2049
      DOUBLE PRECISION SAVE205
      DOUBLE PRECISION SAVE2050
      DOUBLE PRECISION SAVE2051
      DOUBLE PRECISION SAVE2052
      DOUBLE PRECISION SAVE2053
      DOUBLE PRECISION SAVE2054
      DOUBLE PRECISION SAVE2055
      DOUBLE PRECISION SAVE2056
      DOUBLE PRECISION SAVE2057
      DOUBLE PRECISION SAVE2058
      DOUBLE PRECISION SAVE2059
      DOUBLE PRECISION SAVE206
      DOUBLE PRECISION SAVE2060
      DOUBLE PRECISION SAVE2061
      DOUBLE PRECISION SAVE2062
      DOUBLE PRECISION SAVE2063
      DOUBLE PRECISION SAVE2064
      DOUBLE PRECISION SAVE2065
      DOUBLE PRECISION SAVE2066
      DOUBLE PRECISION SAVE2067
      DOUBLE PRECISION SAVE2068
      DOUBLE PRECISION SAVE2069
      DOUBLE PRECISION SAVE207
      DOUBLE PRECISION SAVE2070
      DOUBLE PRECISION SAVE2071
      DOUBLE PRECISION SAVE2072
      DOUBLE PRECISION SAVE2073
      DOUBLE PRECISION SAVE2074
      DOUBLE PRECISION SAVE2075
      DOUBLE PRECISION SAVE2076
      DOUBLE PRECISION SAVE2077
      DOUBLE PRECISION SAVE2078
      DOUBLE PRECISION SAVE2079
      DOUBLE PRECISION SAVE208
      DOUBLE PRECISION SAVE2080
      DOUBLE PRECISION SAVE2081
      DOUBLE PRECISION SAVE2082
      DOUBLE PRECISION SAVE2083
      DOUBLE PRECISION SAVE2084
      DOUBLE PRECISION SAVE2085
      DOUBLE PRECISION SAVE2086
      DOUBLE PRECISION SAVE2087
      DOUBLE PRECISION SAVE2088
      DOUBLE PRECISION SAVE2089
      DOUBLE PRECISION SAVE209
      DOUBLE PRECISION SAVE2090
      DOUBLE PRECISION SAVE2091
      DOUBLE PRECISION SAVE2092
      DOUBLE PRECISION SAVE2093
      DOUBLE PRECISION SAVE2094
      DOUBLE PRECISION SAVE2095
      DOUBLE PRECISION SAVE2096
      DOUBLE PRECISION SAVE2097
      DOUBLE PRECISION SAVE2098
      DOUBLE PRECISION SAVE2099
      DOUBLE PRECISION SAVE21
      DOUBLE PRECISION SAVE210
      DOUBLE PRECISION SAVE2100
      DOUBLE PRECISION SAVE2101
      DOUBLE PRECISION SAVE2102
      DOUBLE PRECISION SAVE2103
      DOUBLE PRECISION SAVE2104
      DOUBLE PRECISION SAVE2105
      DOUBLE PRECISION SAVE2106
      DOUBLE PRECISION SAVE2107
      DOUBLE PRECISION SAVE2108
      DOUBLE PRECISION SAVE2109
      DOUBLE PRECISION SAVE211
      DOUBLE PRECISION SAVE2110
      DOUBLE PRECISION SAVE2111
      DOUBLE PRECISION SAVE2112
      DOUBLE PRECISION SAVE2113
      DOUBLE PRECISION SAVE2114
      DOUBLE PRECISION SAVE2115
      DOUBLE PRECISION SAVE2116
      DOUBLE PRECISION SAVE2117
      DOUBLE PRECISION SAVE2118
      DOUBLE PRECISION SAVE2119
      DOUBLE PRECISION SAVE212
      DOUBLE PRECISION SAVE2120
      DOUBLE PRECISION SAVE2121
      DOUBLE PRECISION SAVE2122
      DOUBLE PRECISION SAVE2123
      DOUBLE PRECISION SAVE2124
      DOUBLE PRECISION SAVE2125
      DOUBLE PRECISION SAVE2126
      DOUBLE PRECISION SAVE2127
      DOUBLE PRECISION SAVE2128
      DOUBLE PRECISION SAVE2129
      DOUBLE PRECISION SAVE213
      DOUBLE PRECISION SAVE2130
      DOUBLE PRECISION SAVE2131
      DOUBLE PRECISION SAVE2132
      DOUBLE PRECISION SAVE2133
      DOUBLE PRECISION SAVE2134
      DOUBLE PRECISION SAVE2135
      DOUBLE PRECISION SAVE2136
      DOUBLE PRECISION SAVE2137
      DOUBLE PRECISION SAVE2138
      DOUBLE PRECISION SAVE2139
      DOUBLE PRECISION SAVE214
      DOUBLE PRECISION SAVE2140
      DOUBLE PRECISION SAVE2141
      DOUBLE PRECISION SAVE2142
      DOUBLE PRECISION SAVE2143
      DOUBLE PRECISION SAVE2144
      DOUBLE PRECISION SAVE2145
      DOUBLE PRECISION SAVE2146
      DOUBLE PRECISION SAVE2147
      DOUBLE PRECISION SAVE2148
      DOUBLE PRECISION SAVE2149
      DOUBLE PRECISION SAVE215
      DOUBLE PRECISION SAVE2150
      DOUBLE PRECISION SAVE2151
      DOUBLE PRECISION SAVE2152
      DOUBLE PRECISION SAVE2153
      DOUBLE PRECISION SAVE2154
      DOUBLE PRECISION SAVE2155
      DOUBLE PRECISION SAVE2156
      DOUBLE PRECISION SAVE2157
      DOUBLE PRECISION SAVE2158
      DOUBLE PRECISION SAVE2159
      DOUBLE PRECISION SAVE216
      DOUBLE PRECISION SAVE2160
      DOUBLE PRECISION SAVE2161
      DOUBLE PRECISION SAVE2162
      DOUBLE PRECISION SAVE2163
      DOUBLE PRECISION SAVE2164
      DOUBLE PRECISION SAVE2165
      DOUBLE PRECISION SAVE2166
      DOUBLE PRECISION SAVE2167
      DOUBLE PRECISION SAVE2168
      DOUBLE PRECISION SAVE2169
      DOUBLE PRECISION SAVE217
      DOUBLE PRECISION SAVE2170
      DOUBLE PRECISION SAVE2171
      DOUBLE PRECISION SAVE2172
      DOUBLE PRECISION SAVE2173
      DOUBLE PRECISION SAVE2174
      DOUBLE PRECISION SAVE2175
      DOUBLE PRECISION SAVE2176
      DOUBLE PRECISION SAVE2177
      DOUBLE PRECISION SAVE2178
      DOUBLE PRECISION SAVE2179
      DOUBLE PRECISION SAVE218
      DOUBLE PRECISION SAVE2180
      DOUBLE PRECISION SAVE2181
      DOUBLE PRECISION SAVE2182
      DOUBLE PRECISION SAVE2183
      DOUBLE PRECISION SAVE2184
      DOUBLE PRECISION SAVE2185
      DOUBLE PRECISION SAVE2186
      DOUBLE PRECISION SAVE2187
      DOUBLE PRECISION SAVE2188
      DOUBLE PRECISION SAVE2189
      DOUBLE PRECISION SAVE219
      DOUBLE PRECISION SAVE2190
      DOUBLE PRECISION SAVE2191
      DOUBLE PRECISION SAVE2192
      DOUBLE PRECISION SAVE2193
      DOUBLE PRECISION SAVE2194
      DOUBLE PRECISION SAVE2195
      DOUBLE PRECISION SAVE2196
      DOUBLE PRECISION SAVE2197
      DOUBLE PRECISION SAVE2198
      DOUBLE PRECISION SAVE2199
      DOUBLE PRECISION SAVE22
      DOUBLE PRECISION SAVE220
      DOUBLE PRECISION SAVE2200
      DOUBLE PRECISION SAVE2201
      DOUBLE PRECISION SAVE2202
      DOUBLE PRECISION SAVE2203
      DOUBLE PRECISION SAVE2204
      DOUBLE PRECISION SAVE2205
      DOUBLE PRECISION SAVE2206
      DOUBLE PRECISION SAVE2207
      DOUBLE PRECISION SAVE2208
      DOUBLE PRECISION SAVE2209
      DOUBLE PRECISION SAVE221
      DOUBLE PRECISION SAVE2210
      DOUBLE PRECISION SAVE2211
      DOUBLE PRECISION SAVE2212
      DOUBLE PRECISION SAVE2213
      DOUBLE PRECISION SAVE2214
      DOUBLE PRECISION SAVE2215
      DOUBLE PRECISION SAVE2216
      DOUBLE PRECISION SAVE2217
      DOUBLE PRECISION SAVE2218
      DOUBLE PRECISION SAVE2219
      DOUBLE PRECISION SAVE222
      DOUBLE PRECISION SAVE2220
      DOUBLE PRECISION SAVE2221
      DOUBLE PRECISION SAVE2222
      DOUBLE PRECISION SAVE2223
      DOUBLE PRECISION SAVE2224
      DOUBLE PRECISION SAVE2225
      DOUBLE PRECISION SAVE2226
      DOUBLE PRECISION SAVE2227
      DOUBLE PRECISION SAVE2228
      DOUBLE PRECISION SAVE2229
      DOUBLE PRECISION SAVE223
      DOUBLE PRECISION SAVE2230
      DOUBLE PRECISION SAVE2231
      DOUBLE PRECISION SAVE2232
      DOUBLE PRECISION SAVE2233
      DOUBLE PRECISION SAVE2234
      DOUBLE PRECISION SAVE2235
      DOUBLE PRECISION SAVE2236
      DOUBLE PRECISION SAVE2237
      DOUBLE PRECISION SAVE2238
      DOUBLE PRECISION SAVE2239
      DOUBLE PRECISION SAVE224
      DOUBLE PRECISION SAVE2240
      DOUBLE PRECISION SAVE2241
      DOUBLE PRECISION SAVE2242
      DOUBLE PRECISION SAVE2243
      DOUBLE PRECISION SAVE2244
      DOUBLE PRECISION SAVE2245
      DOUBLE PRECISION SAVE2246
      DOUBLE PRECISION SAVE2247
      DOUBLE PRECISION SAVE2248
      DOUBLE PRECISION SAVE2249
      DOUBLE PRECISION SAVE225
      DOUBLE PRECISION SAVE2250
      DOUBLE PRECISION SAVE2251
      DOUBLE PRECISION SAVE2252
      DOUBLE PRECISION SAVE2253
      DOUBLE PRECISION SAVE2254
      DOUBLE PRECISION SAVE2255
      DOUBLE PRECISION SAVE2256
      DOUBLE PRECISION SAVE2257
      DOUBLE PRECISION SAVE2258
      DOUBLE PRECISION SAVE2259
      DOUBLE PRECISION SAVE226
      DOUBLE PRECISION SAVE2260
      DOUBLE PRECISION SAVE2261
      DOUBLE PRECISION SAVE2262
      DOUBLE PRECISION SAVE2263
      DOUBLE PRECISION SAVE2264
      DOUBLE PRECISION SAVE2265
      DOUBLE PRECISION SAVE2266
      DOUBLE PRECISION SAVE2267
      DOUBLE PRECISION SAVE2268
      DOUBLE PRECISION SAVE2269
      DOUBLE PRECISION SAVE227
      DOUBLE PRECISION SAVE2270
      DOUBLE PRECISION SAVE2271
      DOUBLE PRECISION SAVE2272
      DOUBLE PRECISION SAVE2273
      DOUBLE PRECISION SAVE2274
      DOUBLE PRECISION SAVE2275
      DOUBLE PRECISION SAVE2276
      DOUBLE PRECISION SAVE2277
      DOUBLE PRECISION SAVE2278
      DOUBLE PRECISION SAVE2279
      DOUBLE PRECISION SAVE228
      DOUBLE PRECISION SAVE2280
      DOUBLE PRECISION SAVE2281
      DOUBLE PRECISION SAVE2282
      DOUBLE PRECISION SAVE2283
      DOUBLE PRECISION SAVE2284
      DOUBLE PRECISION SAVE2285
      DOUBLE PRECISION SAVE2286
      DOUBLE PRECISION SAVE2287
      DOUBLE PRECISION SAVE2288
      DOUBLE PRECISION SAVE2289(NS,NS)
      DOUBLE PRECISION SAVE229
      INTEGER SAVE2290(NS)
      INTEGER SAVE2291
      INTEGER SAVE2292
      DOUBLE PRECISION SAVE23
      DOUBLE PRECISION SAVE230
      DOUBLE PRECISION SAVE231
      DOUBLE PRECISION SAVE232
      DOUBLE PRECISION SAVE233
      DOUBLE PRECISION SAVE234
      DOUBLE PRECISION SAVE235
      DOUBLE PRECISION SAVE236
      DOUBLE PRECISION SAVE237
      DOUBLE PRECISION SAVE238
      DOUBLE PRECISION SAVE239
      DOUBLE PRECISION SAVE24
      DOUBLE PRECISION SAVE240
      DOUBLE PRECISION SAVE241
      DOUBLE PRECISION SAVE242
      DOUBLE PRECISION SAVE243
      DOUBLE PRECISION SAVE244
      DOUBLE PRECISION SAVE245
      DOUBLE PRECISION SAVE246
      DOUBLE PRECISION SAVE247
      DOUBLE PRECISION SAVE248
      DOUBLE PRECISION SAVE249
      DOUBLE PRECISION SAVE25
      DOUBLE PRECISION SAVE250
      DOUBLE PRECISION SAVE251
      DOUBLE PRECISION SAVE252
      DOUBLE PRECISION SAVE253
      DOUBLE PRECISION SAVE254
      DOUBLE PRECISION SAVE255
      DOUBLE PRECISION SAVE256
      DOUBLE PRECISION SAVE257
      DOUBLE PRECISION SAVE258
      DOUBLE PRECISION SAVE259
      DOUBLE PRECISION SAVE26
      DOUBLE PRECISION SAVE260
      DOUBLE PRECISION SAVE261
      DOUBLE PRECISION SAVE262
      DOUBLE PRECISION SAVE263
      DOUBLE PRECISION SAVE264
      DOUBLE PRECISION SAVE265
      DOUBLE PRECISION SAVE266
      DOUBLE PRECISION SAVE267
      DOUBLE PRECISION SAVE268
      DOUBLE PRECISION SAVE269
      DOUBLE PRECISION SAVE27
      DOUBLE PRECISION SAVE270
      DOUBLE PRECISION SAVE271
      DOUBLE PRECISION SAVE272
      DOUBLE PRECISION SAVE273
      DOUBLE PRECISION SAVE274
      DOUBLE PRECISION SAVE275
      DOUBLE PRECISION SAVE276
      DOUBLE PRECISION SAVE277
      DOUBLE PRECISION SAVE278
      DOUBLE PRECISION SAVE279
      DOUBLE PRECISION SAVE28
      DOUBLE PRECISION SAVE280
      DOUBLE PRECISION SAVE281
      DOUBLE PRECISION SAVE282
      DOUBLE PRECISION SAVE283
      DOUBLE PRECISION SAVE284
      DOUBLE PRECISION SAVE285
      DOUBLE PRECISION SAVE286
      DOUBLE PRECISION SAVE287
      DOUBLE PRECISION SAVE288
      DOUBLE PRECISION SAVE289
      DOUBLE PRECISION SAVE29
      DOUBLE PRECISION SAVE290
      DOUBLE PRECISION SAVE291
      DOUBLE PRECISION SAVE292
      DOUBLE PRECISION SAVE293
      DOUBLE PRECISION SAVE294
      DOUBLE PRECISION SAVE295
      DOUBLE PRECISION SAVE296
      DOUBLE PRECISION SAVE297
      DOUBLE PRECISION SAVE298
      DOUBLE PRECISION SAVE299
      DOUBLE PRECISION SAVE30
      DOUBLE PRECISION SAVE300
      DOUBLE PRECISION SAVE301
      DOUBLE PRECISION SAVE302
      DOUBLE PRECISION SAVE303
      DOUBLE PRECISION SAVE304
      DOUBLE PRECISION SAVE305
      DOUBLE PRECISION SAVE306
      DOUBLE PRECISION SAVE307
      DOUBLE PRECISION SAVE308
      DOUBLE PRECISION SAVE309
      DOUBLE PRECISION SAVE31
      DOUBLE PRECISION SAVE310
      DOUBLE PRECISION SAVE311
      DOUBLE PRECISION SAVE312
      DOUBLE PRECISION SAVE313
      DOUBLE PRECISION SAVE314
      DOUBLE PRECISION SAVE315
      DOUBLE PRECISION SAVE316
      DOUBLE PRECISION SAVE317
      DOUBLE PRECISION SAVE318
      DOUBLE PRECISION SAVE319
      DOUBLE PRECISION SAVE32
      DOUBLE PRECISION SAVE320
      DOUBLE PRECISION SAVE321
      DOUBLE PRECISION SAVE322
      DOUBLE PRECISION SAVE323
      DOUBLE PRECISION SAVE324
      DOUBLE PRECISION SAVE325
      DOUBLE PRECISION SAVE326
      DOUBLE PRECISION SAVE327
      DOUBLE PRECISION SAVE328
      DOUBLE PRECISION SAVE329
      DOUBLE PRECISION SAVE33
      DOUBLE PRECISION SAVE330
      DOUBLE PRECISION SAVE331
      DOUBLE PRECISION SAVE332
      DOUBLE PRECISION SAVE333
      DOUBLE PRECISION SAVE334
      DOUBLE PRECISION SAVE335
      DOUBLE PRECISION SAVE336
      DOUBLE PRECISION SAVE337
      DOUBLE PRECISION SAVE338
      DOUBLE PRECISION SAVE339
      DOUBLE PRECISION SAVE34
      DOUBLE PRECISION SAVE340
      DOUBLE PRECISION SAVE341
      DOUBLE PRECISION SAVE342
      DOUBLE PRECISION SAVE343
      DOUBLE PRECISION SAVE344
      DOUBLE PRECISION SAVE345
      DOUBLE PRECISION SAVE346
      DOUBLE PRECISION SAVE347
      DOUBLE PRECISION SAVE348
      DOUBLE PRECISION SAVE349
      DOUBLE PRECISION SAVE35
      DOUBLE PRECISION SAVE350
      DOUBLE PRECISION SAVE351
      DOUBLE PRECISION SAVE352
      DOUBLE PRECISION SAVE353
      DOUBLE PRECISION SAVE354
      DOUBLE PRECISION SAVE355
      DOUBLE PRECISION SAVE356
      DOUBLE PRECISION SAVE357
      DOUBLE PRECISION SAVE358
      DOUBLE PRECISION SAVE359
      DOUBLE PRECISION SAVE36
      DOUBLE PRECISION SAVE360
      DOUBLE PRECISION SAVE361
      DOUBLE PRECISION SAVE362
      DOUBLE PRECISION SAVE363
      DOUBLE PRECISION SAVE364
      DOUBLE PRECISION SAVE365
      DOUBLE PRECISION SAVE366
      DOUBLE PRECISION SAVE367
      DOUBLE PRECISION SAVE368
      DOUBLE PRECISION SAVE369
      DOUBLE PRECISION SAVE37
      DOUBLE PRECISION SAVE370
      DOUBLE PRECISION SAVE371
      DOUBLE PRECISION SAVE372
      DOUBLE PRECISION SAVE373
      DOUBLE PRECISION SAVE374
      DOUBLE PRECISION SAVE375
      DOUBLE PRECISION SAVE376
      DOUBLE PRECISION SAVE377
      DOUBLE PRECISION SAVE378
      DOUBLE PRECISION SAVE379
      DOUBLE PRECISION SAVE38
      DOUBLE PRECISION SAVE380
      DOUBLE PRECISION SAVE381
      DOUBLE PRECISION SAVE382
      DOUBLE PRECISION SAVE383
      DOUBLE PRECISION SAVE384
      DOUBLE PRECISION SAVE385
      DOUBLE PRECISION SAVE386
      DOUBLE PRECISION SAVE387
      DOUBLE PRECISION SAVE388
      DOUBLE PRECISION SAVE389
      DOUBLE PRECISION SAVE39
      DOUBLE PRECISION SAVE390
      DOUBLE PRECISION SAVE391
      DOUBLE PRECISION SAVE392
      DOUBLE PRECISION SAVE393
      DOUBLE PRECISION SAVE394
      DOUBLE PRECISION SAVE395
      DOUBLE PRECISION SAVE396
      DOUBLE PRECISION SAVE397
      DOUBLE PRECISION SAVE398
      DOUBLE PRECISION SAVE399
      DOUBLE PRECISION SAVE40
      DOUBLE PRECISION SAVE400
      DOUBLE PRECISION SAVE401
      DOUBLE PRECISION SAVE402
      DOUBLE PRECISION SAVE403
      DOUBLE PRECISION SAVE404
      DOUBLE PRECISION SAVE405
      DOUBLE PRECISION SAVE406
      DOUBLE PRECISION SAVE407
      DOUBLE PRECISION SAVE408
      DOUBLE PRECISION SAVE409
      DOUBLE PRECISION SAVE41
      DOUBLE PRECISION SAVE410
      DOUBLE PRECISION SAVE411
      DOUBLE PRECISION SAVE412
      DOUBLE PRECISION SAVE413
      DOUBLE PRECISION SAVE414
      DOUBLE PRECISION SAVE415
      DOUBLE PRECISION SAVE416
      DOUBLE PRECISION SAVE417
      DOUBLE PRECISION SAVE418
      DOUBLE PRECISION SAVE419
      DOUBLE PRECISION SAVE42
      DOUBLE PRECISION SAVE420
      DOUBLE PRECISION SAVE421
      DOUBLE PRECISION SAVE422
      DOUBLE PRECISION SAVE423
      DOUBLE PRECISION SAVE424
      DOUBLE PRECISION SAVE425
      DOUBLE PRECISION SAVE426
      DOUBLE PRECISION SAVE427
      DOUBLE PRECISION SAVE428
      DOUBLE PRECISION SAVE429
      DOUBLE PRECISION SAVE43
      DOUBLE PRECISION SAVE430
      DOUBLE PRECISION SAVE431
      DOUBLE PRECISION SAVE432
      DOUBLE PRECISION SAVE433
      DOUBLE PRECISION SAVE434
      DOUBLE PRECISION SAVE435
      DOUBLE PRECISION SAVE436
      DOUBLE PRECISION SAVE437
      DOUBLE PRECISION SAVE438
      DOUBLE PRECISION SAVE439
      DOUBLE PRECISION SAVE44
      DOUBLE PRECISION SAVE440
      DOUBLE PRECISION SAVE441
      DOUBLE PRECISION SAVE442
      DOUBLE PRECISION SAVE443
      DOUBLE PRECISION SAVE444
      DOUBLE PRECISION SAVE445
      DOUBLE PRECISION SAVE446
      DOUBLE PRECISION SAVE447
      DOUBLE PRECISION SAVE448
      DOUBLE PRECISION SAVE449
      DOUBLE PRECISION SAVE45
      DOUBLE PRECISION SAVE450
      DOUBLE PRECISION SAVE451
      DOUBLE PRECISION SAVE452
      DOUBLE PRECISION SAVE453
      DOUBLE PRECISION SAVE454
      DOUBLE PRECISION SAVE455
      DOUBLE PRECISION SAVE456
      DOUBLE PRECISION SAVE457
      DOUBLE PRECISION SAVE458
      DOUBLE PRECISION SAVE459
      DOUBLE PRECISION SAVE46
      DOUBLE PRECISION SAVE460
      DOUBLE PRECISION SAVE461
      DOUBLE PRECISION SAVE462
      DOUBLE PRECISION SAVE463
      DOUBLE PRECISION SAVE464
      DOUBLE PRECISION SAVE465
      DOUBLE PRECISION SAVE466
      DOUBLE PRECISION SAVE467
      DOUBLE PRECISION SAVE468
      DOUBLE PRECISION SAVE469
      DOUBLE PRECISION SAVE47
      DOUBLE PRECISION SAVE470
      DOUBLE PRECISION SAVE471
      DOUBLE PRECISION SAVE472
      DOUBLE PRECISION SAVE473
      DOUBLE PRECISION SAVE474
      DOUBLE PRECISION SAVE475
      DOUBLE PRECISION SAVE476
      DOUBLE PRECISION SAVE477
      DOUBLE PRECISION SAVE478
      DOUBLE PRECISION SAVE479
      DOUBLE PRECISION SAVE48
      DOUBLE PRECISION SAVE480
      DOUBLE PRECISION SAVE481
      DOUBLE PRECISION SAVE482
      DOUBLE PRECISION SAVE483
      DOUBLE PRECISION SAVE484
      DOUBLE PRECISION SAVE485
      DOUBLE PRECISION SAVE486
      DOUBLE PRECISION SAVE487
      DOUBLE PRECISION SAVE488
      DOUBLE PRECISION SAVE489
      DOUBLE PRECISION SAVE49
      DOUBLE PRECISION SAVE490
      DOUBLE PRECISION SAVE491
      DOUBLE PRECISION SAVE492
      DOUBLE PRECISION SAVE493
      DOUBLE PRECISION SAVE494
      DOUBLE PRECISION SAVE495
      DOUBLE PRECISION SAVE496
      DOUBLE PRECISION SAVE497
      DOUBLE PRECISION SAVE498
      DOUBLE PRECISION SAVE499
      DOUBLE PRECISION SAVE5
      DOUBLE PRECISION SAVE50
      DOUBLE PRECISION SAVE500
      DOUBLE PRECISION SAVE501
      DOUBLE PRECISION SAVE502
      DOUBLE PRECISION SAVE503
      DOUBLE PRECISION SAVE504
      DOUBLE PRECISION SAVE505
      DOUBLE PRECISION SAVE506
      DOUBLE PRECISION SAVE507
      DOUBLE PRECISION SAVE508
      DOUBLE PRECISION SAVE509
      DOUBLE PRECISION SAVE51
      DOUBLE PRECISION SAVE510
      DOUBLE PRECISION SAVE511
      DOUBLE PRECISION SAVE512
      DOUBLE PRECISION SAVE513
      DOUBLE PRECISION SAVE514
      DOUBLE PRECISION SAVE515
      DOUBLE PRECISION SAVE516
      DOUBLE PRECISION SAVE517
      DOUBLE PRECISION SAVE518
      DOUBLE PRECISION SAVE519
      DOUBLE PRECISION SAVE52
      DOUBLE PRECISION SAVE520
      DOUBLE PRECISION SAVE521
      DOUBLE PRECISION SAVE522
      DOUBLE PRECISION SAVE523
      DOUBLE PRECISION SAVE524
      DOUBLE PRECISION SAVE525
      DOUBLE PRECISION SAVE526
      DOUBLE PRECISION SAVE527
      DOUBLE PRECISION SAVE528
      DOUBLE PRECISION SAVE529
      DOUBLE PRECISION SAVE53
      DOUBLE PRECISION SAVE530
      DOUBLE PRECISION SAVE531
      DOUBLE PRECISION SAVE532
      DOUBLE PRECISION SAVE533
      DOUBLE PRECISION SAVE534
      DOUBLE PRECISION SAVE535
      DOUBLE PRECISION SAVE536
      DOUBLE PRECISION SAVE537
      DOUBLE PRECISION SAVE538
      DOUBLE PRECISION SAVE539
      DOUBLE PRECISION SAVE54
      DOUBLE PRECISION SAVE540
      DOUBLE PRECISION SAVE541
      DOUBLE PRECISION SAVE542
      DOUBLE PRECISION SAVE543
      DOUBLE PRECISION SAVE544
      DOUBLE PRECISION SAVE545
      DOUBLE PRECISION SAVE546
      DOUBLE PRECISION SAVE547
      DOUBLE PRECISION SAVE548
      DOUBLE PRECISION SAVE549
      DOUBLE PRECISION SAVE55
      DOUBLE PRECISION SAVE550
      DOUBLE PRECISION SAVE551
      DOUBLE PRECISION SAVE552
      DOUBLE PRECISION SAVE553
      DOUBLE PRECISION SAVE554
      DOUBLE PRECISION SAVE555
      DOUBLE PRECISION SAVE556
      DOUBLE PRECISION SAVE557
      DOUBLE PRECISION SAVE558
      DOUBLE PRECISION SAVE559
      DOUBLE PRECISION SAVE56
      DOUBLE PRECISION SAVE560
      DOUBLE PRECISION SAVE561
      DOUBLE PRECISION SAVE562
      DOUBLE PRECISION SAVE563
      DOUBLE PRECISION SAVE564
      DOUBLE PRECISION SAVE565
      DOUBLE PRECISION SAVE566
      DOUBLE PRECISION SAVE567
      DOUBLE PRECISION SAVE568
      DOUBLE PRECISION SAVE569
      DOUBLE PRECISION SAVE57
      DOUBLE PRECISION SAVE570
      DOUBLE PRECISION SAVE571
      DOUBLE PRECISION SAVE572
      DOUBLE PRECISION SAVE573
      DOUBLE PRECISION SAVE574
      DOUBLE PRECISION SAVE575
      DOUBLE PRECISION SAVE576
      DOUBLE PRECISION SAVE577
      DOUBLE PRECISION SAVE578
      DOUBLE PRECISION SAVE579
      DOUBLE PRECISION SAVE58
      DOUBLE PRECISION SAVE580
      DOUBLE PRECISION SAVE581
      DOUBLE PRECISION SAVE582
      DOUBLE PRECISION SAVE583
      DOUBLE PRECISION SAVE584
      DOUBLE PRECISION SAVE585
      DOUBLE PRECISION SAVE586
      DOUBLE PRECISION SAVE587
      DOUBLE PRECISION SAVE588
      DOUBLE PRECISION SAVE589
      DOUBLE PRECISION SAVE59
      DOUBLE PRECISION SAVE590
      DOUBLE PRECISION SAVE591
      DOUBLE PRECISION SAVE592
      DOUBLE PRECISION SAVE593
      DOUBLE PRECISION SAVE594
      DOUBLE PRECISION SAVE595
      DOUBLE PRECISION SAVE596
      DOUBLE PRECISION SAVE597
      DOUBLE PRECISION SAVE598
      DOUBLE PRECISION SAVE599
      DOUBLE PRECISION SAVE6
      DOUBLE PRECISION SAVE60
      DOUBLE PRECISION SAVE600
      DOUBLE PRECISION SAVE601
      DOUBLE PRECISION SAVE602
      DOUBLE PRECISION SAVE603
      DOUBLE PRECISION SAVE604
      DOUBLE PRECISION SAVE605
      DOUBLE PRECISION SAVE606
      DOUBLE PRECISION SAVE607
      DOUBLE PRECISION SAVE608
      DOUBLE PRECISION SAVE609
      DOUBLE PRECISION SAVE61
      DOUBLE PRECISION SAVE610
      DOUBLE PRECISION SAVE611
      DOUBLE PRECISION SAVE612
      DOUBLE PRECISION SAVE613
      DOUBLE PRECISION SAVE614
      DOUBLE PRECISION SAVE615
      DOUBLE PRECISION SAVE616
      DOUBLE PRECISION SAVE617
      DOUBLE PRECISION SAVE618
      DOUBLE PRECISION SAVE619
      DOUBLE PRECISION SAVE62
      DOUBLE PRECISION SAVE620
      DOUBLE PRECISION SAVE621
      DOUBLE PRECISION SAVE622
      DOUBLE PRECISION SAVE623
      DOUBLE PRECISION SAVE624
      DOUBLE PRECISION SAVE625
      DOUBLE PRECISION SAVE626
      DOUBLE PRECISION SAVE627
      DOUBLE PRECISION SAVE628
      DOUBLE PRECISION SAVE629
      DOUBLE PRECISION SAVE63
      DOUBLE PRECISION SAVE630
      DOUBLE PRECISION SAVE631
      DOUBLE PRECISION SAVE632
      DOUBLE PRECISION SAVE633
      DOUBLE PRECISION SAVE634
      DOUBLE PRECISION SAVE635
      DOUBLE PRECISION SAVE636
      DOUBLE PRECISION SAVE637
      DOUBLE PRECISION SAVE638
      DOUBLE PRECISION SAVE639
      DOUBLE PRECISION SAVE64
      DOUBLE PRECISION SAVE640
      DOUBLE PRECISION SAVE641
      DOUBLE PRECISION SAVE642
      DOUBLE PRECISION SAVE643
      DOUBLE PRECISION SAVE644
      DOUBLE PRECISION SAVE645
      DOUBLE PRECISION SAVE646
      DOUBLE PRECISION SAVE647
      DOUBLE PRECISION SAVE648
      DOUBLE PRECISION SAVE649
      DOUBLE PRECISION SAVE65
      DOUBLE PRECISION SAVE650
      DOUBLE PRECISION SAVE651
      DOUBLE PRECISION SAVE652
      DOUBLE PRECISION SAVE653
      DOUBLE PRECISION SAVE654
      DOUBLE PRECISION SAVE655
      DOUBLE PRECISION SAVE656
      DOUBLE PRECISION SAVE657
      DOUBLE PRECISION SAVE658
      DOUBLE PRECISION SAVE659
      DOUBLE PRECISION SAVE66
      DOUBLE PRECISION SAVE660
      DOUBLE PRECISION SAVE661
      DOUBLE PRECISION SAVE662
      DOUBLE PRECISION SAVE663
      DOUBLE PRECISION SAVE664
      DOUBLE PRECISION SAVE665
      DOUBLE PRECISION SAVE666
      DOUBLE PRECISION SAVE667
      DOUBLE PRECISION SAVE668
      DOUBLE PRECISION SAVE669
      DOUBLE PRECISION SAVE67
      DOUBLE PRECISION SAVE670
      DOUBLE PRECISION SAVE671
      DOUBLE PRECISION SAVE672
      DOUBLE PRECISION SAVE673
      DOUBLE PRECISION SAVE674
      DOUBLE PRECISION SAVE675
      DOUBLE PRECISION SAVE676
      DOUBLE PRECISION SAVE677
      DOUBLE PRECISION SAVE678
      DOUBLE PRECISION SAVE679
      DOUBLE PRECISION SAVE68
      DOUBLE PRECISION SAVE680
      DOUBLE PRECISION SAVE681
      DOUBLE PRECISION SAVE682
      DOUBLE PRECISION SAVE683
      DOUBLE PRECISION SAVE684
      DOUBLE PRECISION SAVE685
      DOUBLE PRECISION SAVE686
      DOUBLE PRECISION SAVE687
      DOUBLE PRECISION SAVE688
      DOUBLE PRECISION SAVE689
      DOUBLE PRECISION SAVE69
      DOUBLE PRECISION SAVE690
      DOUBLE PRECISION SAVE691
      DOUBLE PRECISION SAVE692
      DOUBLE PRECISION SAVE693
      DOUBLE PRECISION SAVE694
      DOUBLE PRECISION SAVE695
      DOUBLE PRECISION SAVE696
      DOUBLE PRECISION SAVE697
      DOUBLE PRECISION SAVE698
      DOUBLE PRECISION SAVE699
      DOUBLE PRECISION SAVE7
      DOUBLE PRECISION SAVE70
      DOUBLE PRECISION SAVE700
      DOUBLE PRECISION SAVE701
      DOUBLE PRECISION SAVE702
      DOUBLE PRECISION SAVE703
      DOUBLE PRECISION SAVE704
      DOUBLE PRECISION SAVE705
      DOUBLE PRECISION SAVE706
      DOUBLE PRECISION SAVE707
      DOUBLE PRECISION SAVE708
      DOUBLE PRECISION SAVE709
      DOUBLE PRECISION SAVE71
      DOUBLE PRECISION SAVE710
      DOUBLE PRECISION SAVE711
      DOUBLE PRECISION SAVE712
      DOUBLE PRECISION SAVE713
      DOUBLE PRECISION SAVE714
      DOUBLE PRECISION SAVE715
      DOUBLE PRECISION SAVE716
      DOUBLE PRECISION SAVE717
      DOUBLE PRECISION SAVE718
      DOUBLE PRECISION SAVE719
      DOUBLE PRECISION SAVE72
      DOUBLE PRECISION SAVE720
      DOUBLE PRECISION SAVE721
      DOUBLE PRECISION SAVE722
      DOUBLE PRECISION SAVE723
      DOUBLE PRECISION SAVE724
      DOUBLE PRECISION SAVE725
      DOUBLE PRECISION SAVE726
      DOUBLE PRECISION SAVE727
      DOUBLE PRECISION SAVE728
      DOUBLE PRECISION SAVE729
      DOUBLE PRECISION SAVE73
      DOUBLE PRECISION SAVE730
      DOUBLE PRECISION SAVE731
      DOUBLE PRECISION SAVE732
      DOUBLE PRECISION SAVE733
      DOUBLE PRECISION SAVE734
      DOUBLE PRECISION SAVE735
      DOUBLE PRECISION SAVE736
      DOUBLE PRECISION SAVE737
      DOUBLE PRECISION SAVE738
      DOUBLE PRECISION SAVE739
      DOUBLE PRECISION SAVE74
      DOUBLE PRECISION SAVE740
      DOUBLE PRECISION SAVE741
      DOUBLE PRECISION SAVE742
      DOUBLE PRECISION SAVE743
      DOUBLE PRECISION SAVE744
      DOUBLE PRECISION SAVE745
      DOUBLE PRECISION SAVE746
      DOUBLE PRECISION SAVE747
      DOUBLE PRECISION SAVE748
      DOUBLE PRECISION SAVE749
      DOUBLE PRECISION SAVE75
      DOUBLE PRECISION SAVE750
      DOUBLE PRECISION SAVE751
      DOUBLE PRECISION SAVE752
      DOUBLE PRECISION SAVE753
      DOUBLE PRECISION SAVE754
      DOUBLE PRECISION SAVE755
      DOUBLE PRECISION SAVE756
      DOUBLE PRECISION SAVE757
      DOUBLE PRECISION SAVE758
      DOUBLE PRECISION SAVE759
      DOUBLE PRECISION SAVE76
      DOUBLE PRECISION SAVE760
      DOUBLE PRECISION SAVE761
      DOUBLE PRECISION SAVE762
      DOUBLE PRECISION SAVE763
      DOUBLE PRECISION SAVE764
      DOUBLE PRECISION SAVE765
      DOUBLE PRECISION SAVE766
      DOUBLE PRECISION SAVE767
      DOUBLE PRECISION SAVE768
      DOUBLE PRECISION SAVE769
      DOUBLE PRECISION SAVE77
      DOUBLE PRECISION SAVE770
      DOUBLE PRECISION SAVE771
      DOUBLE PRECISION SAVE772
      DOUBLE PRECISION SAVE773
      DOUBLE PRECISION SAVE774
      DOUBLE PRECISION SAVE775
      DOUBLE PRECISION SAVE776
      DOUBLE PRECISION SAVE777
      DOUBLE PRECISION SAVE778
      DOUBLE PRECISION SAVE779
      DOUBLE PRECISION SAVE78
      DOUBLE PRECISION SAVE780
      DOUBLE PRECISION SAVE781
      DOUBLE PRECISION SAVE782
      DOUBLE PRECISION SAVE783
      DOUBLE PRECISION SAVE784
      DOUBLE PRECISION SAVE785
      DOUBLE PRECISION SAVE786
      DOUBLE PRECISION SAVE787
      DOUBLE PRECISION SAVE788
      DOUBLE PRECISION SAVE789
      DOUBLE PRECISION SAVE79
      DOUBLE PRECISION SAVE790
      DOUBLE PRECISION SAVE791
      DOUBLE PRECISION SAVE792
      DOUBLE PRECISION SAVE793
      DOUBLE PRECISION SAVE794
      DOUBLE PRECISION SAVE795
      DOUBLE PRECISION SAVE796
      DOUBLE PRECISION SAVE797
      DOUBLE PRECISION SAVE798
      DOUBLE PRECISION SAVE799
      DOUBLE PRECISION SAVE8
      DOUBLE PRECISION SAVE80
      DOUBLE PRECISION SAVE800
      DOUBLE PRECISION SAVE801
      DOUBLE PRECISION SAVE802
      DOUBLE PRECISION SAVE803
      DOUBLE PRECISION SAVE804
      DOUBLE PRECISION SAVE805
      DOUBLE PRECISION SAVE806
      DOUBLE PRECISION SAVE807
      DOUBLE PRECISION SAVE808
      DOUBLE PRECISION SAVE809
      DOUBLE PRECISION SAVE81
      DOUBLE PRECISION SAVE810
      DOUBLE PRECISION SAVE811
      DOUBLE PRECISION SAVE812
      DOUBLE PRECISION SAVE813
      DOUBLE PRECISION SAVE814
      DOUBLE PRECISION SAVE815
      DOUBLE PRECISION SAVE816
      DOUBLE PRECISION SAVE817
      DOUBLE PRECISION SAVE818
      DOUBLE PRECISION SAVE819
      DOUBLE PRECISION SAVE82
      DOUBLE PRECISION SAVE820
      DOUBLE PRECISION SAVE821
      DOUBLE PRECISION SAVE822
      DOUBLE PRECISION SAVE823
      DOUBLE PRECISION SAVE824
      DOUBLE PRECISION SAVE825
      DOUBLE PRECISION SAVE826
      DOUBLE PRECISION SAVE827
      DOUBLE PRECISION SAVE828
      DOUBLE PRECISION SAVE829
      DOUBLE PRECISION SAVE83
      DOUBLE PRECISION SAVE830
      DOUBLE PRECISION SAVE831
      DOUBLE PRECISION SAVE832
      DOUBLE PRECISION SAVE833
      DOUBLE PRECISION SAVE834
      DOUBLE PRECISION SAVE835
      DOUBLE PRECISION SAVE836
      DOUBLE PRECISION SAVE837
      DOUBLE PRECISION SAVE838
      DOUBLE PRECISION SAVE839
      DOUBLE PRECISION SAVE84
      DOUBLE PRECISION SAVE840
      DOUBLE PRECISION SAVE841
      DOUBLE PRECISION SAVE842
      DOUBLE PRECISION SAVE843
      DOUBLE PRECISION SAVE844
      DOUBLE PRECISION SAVE845
      DOUBLE PRECISION SAVE846
      DOUBLE PRECISION SAVE847
      DOUBLE PRECISION SAVE848
      DOUBLE PRECISION SAVE849
      DOUBLE PRECISION SAVE85
      DOUBLE PRECISION SAVE850
      DOUBLE PRECISION SAVE851
      DOUBLE PRECISION SAVE852
      DOUBLE PRECISION SAVE853
      DOUBLE PRECISION SAVE854
      DOUBLE PRECISION SAVE855
      DOUBLE PRECISION SAVE856
      DOUBLE PRECISION SAVE857
      DOUBLE PRECISION SAVE858
      DOUBLE PRECISION SAVE859
      DOUBLE PRECISION SAVE86
      DOUBLE PRECISION SAVE860
      DOUBLE PRECISION SAVE861
      DOUBLE PRECISION SAVE862
      DOUBLE PRECISION SAVE863
      DOUBLE PRECISION SAVE864
      DOUBLE PRECISION SAVE865
      DOUBLE PRECISION SAVE866
      DOUBLE PRECISION SAVE867
      DOUBLE PRECISION SAVE868
      DOUBLE PRECISION SAVE869
      DOUBLE PRECISION SAVE87
      DOUBLE PRECISION SAVE870
      DOUBLE PRECISION SAVE871
      DOUBLE PRECISION SAVE872
      DOUBLE PRECISION SAVE873
      DOUBLE PRECISION SAVE874
      DOUBLE PRECISION SAVE875
      DOUBLE PRECISION SAVE876
      DOUBLE PRECISION SAVE877
      DOUBLE PRECISION SAVE878
      DOUBLE PRECISION SAVE879
      DOUBLE PRECISION SAVE88
      DOUBLE PRECISION SAVE880
      DOUBLE PRECISION SAVE881
      DOUBLE PRECISION SAVE882
      DOUBLE PRECISION SAVE883
      DOUBLE PRECISION SAVE884
      DOUBLE PRECISION SAVE885
      DOUBLE PRECISION SAVE886
      DOUBLE PRECISION SAVE887
      DOUBLE PRECISION SAVE888
      DOUBLE PRECISION SAVE889
      DOUBLE PRECISION SAVE89
      DOUBLE PRECISION SAVE890
      DOUBLE PRECISION SAVE891
      DOUBLE PRECISION SAVE892
      DOUBLE PRECISION SAVE893
      DOUBLE PRECISION SAVE894
      DOUBLE PRECISION SAVE895
      DOUBLE PRECISION SAVE896
      DOUBLE PRECISION SAVE897
      DOUBLE PRECISION SAVE898
      DOUBLE PRECISION SAVE899
      DOUBLE PRECISION SAVE9
      DOUBLE PRECISION SAVE90
      DOUBLE PRECISION SAVE900
      DOUBLE PRECISION SAVE901
      DOUBLE PRECISION SAVE902
      DOUBLE PRECISION SAVE903
      DOUBLE PRECISION SAVE904
      DOUBLE PRECISION SAVE905
      DOUBLE PRECISION SAVE906
      DOUBLE PRECISION SAVE907
      DOUBLE PRECISION SAVE908
      DOUBLE PRECISION SAVE909
      DOUBLE PRECISION SAVE91
      DOUBLE PRECISION SAVE910
      DOUBLE PRECISION SAVE911
      DOUBLE PRECISION SAVE912
      DOUBLE PRECISION SAVE913
      DOUBLE PRECISION SAVE914
      DOUBLE PRECISION SAVE915
      DOUBLE PRECISION SAVE916
      DOUBLE PRECISION SAVE917
      DOUBLE PRECISION SAVE918
      DOUBLE PRECISION SAVE919
      DOUBLE PRECISION SAVE92
      DOUBLE PRECISION SAVE920
      DOUBLE PRECISION SAVE921
      DOUBLE PRECISION SAVE922
      DOUBLE PRECISION SAVE923
      DOUBLE PRECISION SAVE924
      DOUBLE PRECISION SAVE925
      DOUBLE PRECISION SAVE926
      DOUBLE PRECISION SAVE927
      DOUBLE PRECISION SAVE928
      DOUBLE PRECISION SAVE929
      DOUBLE PRECISION SAVE93
      DOUBLE PRECISION SAVE930
      DOUBLE PRECISION SAVE931
      DOUBLE PRECISION SAVE932
      DOUBLE PRECISION SAVE933
      DOUBLE PRECISION SAVE934
      DOUBLE PRECISION SAVE935
      DOUBLE PRECISION SAVE936
      DOUBLE PRECISION SAVE937
      DOUBLE PRECISION SAVE938
      DOUBLE PRECISION SAVE939
      DOUBLE PRECISION SAVE94
      DOUBLE PRECISION SAVE940
      DOUBLE PRECISION SAVE941
      DOUBLE PRECISION SAVE942
      DOUBLE PRECISION SAVE943
      DOUBLE PRECISION SAVE944
      DOUBLE PRECISION SAVE945
      DOUBLE PRECISION SAVE946
      DOUBLE PRECISION SAVE947
      DOUBLE PRECISION SAVE948
      DOUBLE PRECISION SAVE949
      DOUBLE PRECISION SAVE95
      DOUBLE PRECISION SAVE950
      DOUBLE PRECISION SAVE951
      DOUBLE PRECISION SAVE952
      DOUBLE PRECISION SAVE953
      DOUBLE PRECISION SAVE954
      DOUBLE PRECISION SAVE955
      DOUBLE PRECISION SAVE956
      DOUBLE PRECISION SAVE957
      DOUBLE PRECISION SAVE958
      DOUBLE PRECISION SAVE959
      DOUBLE PRECISION SAVE96
      DOUBLE PRECISION SAVE960
      DOUBLE PRECISION SAVE961
      DOUBLE PRECISION SAVE962
      DOUBLE PRECISION SAVE963
      DOUBLE PRECISION SAVE964
      DOUBLE PRECISION SAVE965
      DOUBLE PRECISION SAVE966
      DOUBLE PRECISION SAVE967
      DOUBLE PRECISION SAVE968
      DOUBLE PRECISION SAVE969
      DOUBLE PRECISION SAVE97
      DOUBLE PRECISION SAVE970
      DOUBLE PRECISION SAVE971
      DOUBLE PRECISION SAVE972
      DOUBLE PRECISION SAVE973
      DOUBLE PRECISION SAVE974
      DOUBLE PRECISION SAVE975
      DOUBLE PRECISION SAVE976
      DOUBLE PRECISION SAVE977
      DOUBLE PRECISION SAVE978
      DOUBLE PRECISION SAVE979
      DOUBLE PRECISION SAVE98
      DOUBLE PRECISION SAVE980
      DOUBLE PRECISION SAVE981
      DOUBLE PRECISION SAVE982
      DOUBLE PRECISION SAVE983
      DOUBLE PRECISION SAVE984
      DOUBLE PRECISION SAVE985
      DOUBLE PRECISION SAVE986
      DOUBLE PRECISION SAVE987
      DOUBLE PRECISION SAVE988
      DOUBLE PRECISION SAVE989
      DOUBLE PRECISION SAVE99
      DOUBLE PRECISION SAVE990
      DOUBLE PRECISION SAVE991
      DOUBLE PRECISION SAVE992
      DOUBLE PRECISION SAVE993
      DOUBLE PRECISION SAVE994
      DOUBLE PRECISION SAVE995
      DOUBLE PRECISION SAVE996
      DOUBLE PRECISION SAVE997
      DOUBLE PRECISION SAVE998
      DOUBLE PRECISION SAVE999


C
C Initializations of uninitialized variables
C

      I = 0

C
C Initializations of local variables
C

      DO NNN1 = 1, NS
         CONCCCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         DO NNN2 = 1, NR
            DWCCL(NNN2,NNN1) = 0d0
         END DO
      END DO
C
C Trajectory
C

      DO J = 1, NS
         SAVE2(J) = I
         DO I = 1, NS
            SAVE1(I,J) = JACC(I,J)
            JACC(I,J) = 0.d0
         END DO
      END DO
      SAVE2292 = I
      DO I = 1, NS
         CONC(I) = Y(I)*CONVERS_FACTOR(I)
      END DO
      CALL DRATEDC_racm(NS, NR, RK, CONC, DW)
      SAVE5 = JACC(35,72)
      JACC(35,72) = JACC(35,72)+DW(1,72)
      SAVE6 = JACC(67,72)
      JACC(67,72) = JACC(67,72)+DW(1,72)
      SAVE7 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(1,72)
      SAVE8 = JACC(7,50)
      JACC(7,50) = JACC(7,50)+DW(2,50)
      SAVE9 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(2,50)
      SAVE10 = JACC(35,50)
      JACC(35,50) = JACC(35,50)+DW(3,50)
      SAVE11 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(3,50)
      SAVE12 = JACC(23,23)
      JACC(23,23) = JACC(23,23)-DW(4,23)
      SAVE13 = JACC(62,23)
      JACC(62,23) = JACC(62,23)+DW(4,23)
      SAVE14 = JACC(67,23)
      JACC(67,23) = JACC(67,23)+DW(4,23)
      SAVE15 = JACC(55,55)
      JACC(55,55) = JACC(55,55)-DW(5,55)
      SAVE16 = JACC(62,55)
      JACC(62,55) = JACC(62,55)+DW(5,55)
      SAVE17 = JACC(72,55)
      JACC(72,55) = JACC(72,55)+DW(5,55)
      SAVE18 = JACC(15,15)
      JACC(15,15) = JACC(15,15)-DW(6,15)
      SAVE19 = JACC(62,15)
      JACC(62,15) = JACC(62,15)+0.3500000000000000d+00*DW(6,15)
      SAVE20 = JACC(68,15)
      JACC(68,15) = JACC(68,15)+0.3500000000000000d+00*DW(6,15)
      SAVE21 = JACC(71,15)
      JACC(71,15) = JACC(71,15)+0.6500000000000000d+00*DW(6,15)
      SAVE22 = JACC(72,15)
      JACC(72,15) = JACC(72,15)+0.6500000000000000d+00*DW(6,15)
      SAVE23 = JACC(67,68)
      JACC(67,68) = JACC(67,68)+DW(7,68)
      SAVE24 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(7,68)
      SAVE25 = JACC(35,68)
      JACC(35,68) = JACC(35,68)+DW(8,68)
      SAVE26 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(8,68)
      SAVE27 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(8,68)
      SAVE28 = JACC(27,27)
      JACC(27,27) = JACC(27,27)-DW(9,27)
      SAVE29 = JACC(62,27)
      JACC(62,27) = JACC(62,27)+0.2000000000000000d+01*DW(9,27)
      SAVE30 = JACC(52,66)
      JACC(52,66) = JACC(52,66)+DW(10,66)
      SAVE31 = JACC(66,66)
      JACC(66,66) = JACC(66,66)-DW(10,66)
      SAVE32 = JACC(52,66)
      JACC(52,66) = JACC(52,66)+DW(11,66)
      SAVE33 = JACC(66,66)
      JACC(66,66) = JACC(66,66)-DW(11,66)
      SAVE34 = JACC(71,66)
      JACC(71,66) = JACC(71,66)+0.2000000000000000d+01*DW(11,66)
      SAVE35 = JACC(52,61)
      JACC(52,61) = JACC(52,61)+DW(12,61)
      SAVE36 = JACC(61,61)
      JACC(61,61) = JACC(61,61)-DW(12,61)
      SAVE37 = JACC(63,61)
      JACC(63,61) = JACC(63,61)+DW(12,61)
      SAVE38 = JACC(71,61)
      JACC(71,61) = JACC(71,61)+DW(12,61)
      SAVE39 = JACC(16,16)
      JACC(16,16) = JACC(16,16)-DW(13,16)
      SAVE40 = JACC(62,16)
      JACC(62,16) = JACC(62,16)+DW(13,16)
      SAVE41 = JACC(66,16)
      JACC(66,16) = JACC(66,16)+DW(13,16)
      SAVE42 = JACC(71,16)
      JACC(71,16) = JACC(71,16)+DW(13,16)
      SAVE43 = JACC(53,53)
      JACC(53,53) = JACC(53,53)-DW(14,53)
      SAVE44 = JACC(61,53)
      JACC(61,53) = JACC(61,53)+DW(14,53)
      SAVE45 = JACC(62,53)
      JACC(62,53) = JACC(62,53)+DW(14,53)
      SAVE46 = JACC(71,53)
      JACC(71,53) = JACC(71,53)+DW(14,53)
      SAVE47 = JACC(28,28)
      JACC(28,28) = JACC(28,28)-DW(15,28)
      SAVE48 = JACC(62,28)
      JACC(62,28) = JACC(62,28)+DW(15,28)
      SAVE49 = JACC(63,28)
      JACC(63,28) = JACC(63,28)+DW(15,28)
      SAVE50 = JACC(59,59)
      JACC(59,59) = JACC(59,59)-DW(16,59)
      SAVE51 = JACC(60,59)
      JACC(60,59) = JACC(60,59)+DW(16,59)
      SAVE52 = JACC(69,59)
      JACC(69,59) = JACC(69,59)+DW(16,59)
      SAVE53 = JACC(51,51)
      JACC(51,51) = JACC(51,51)-DW(17,51)
      SAVE54 = JACC(52,51)
      JACC(52,51) = JACC(52,51)+0.1870000000000000d+01*DW(17,51)
      SAVE55 = JACC(66,51)
      JACC(66,51) = JACC(66,51)+0.1300000000000000d+00*DW(17,51)
      SAVE56 = JACC(51,51)
      JACC(51,51) = JACC(51,51)-DW(18,51)
      SAVE57 = JACC(52,51)
      JACC(52,51) = JACC(52,51)+0.1550000000000000d+01*DW(18,51)
      SAVE58 = JACC(66,51)
      JACC(66,51) = JACC(66,51)+0.4500000000000000d+00*DW(18,51)
      SAVE59 = JACC(71,51)
      JACC(71,51) = JACC(71,51)+0.8000000000000000d+00*DW(18,51)
      SAVE60 = JACC(52,54)
      JACC(52,54) = JACC(52,54)+DW(19,54)
      SAVE61 = JACC(54,54)
      JACC(54,54) = JACC(54,54)-DW(19,54)
      SAVE62 = JACC(69,54)
      JACC(69,54) = JACC(69,54)+DW(19,54)
      SAVE63 = JACC(71,54)
      JACC(71,54) = JACC(71,54)+DW(19,54)
      SAVE64 = JACC(48,48)
      JACC(48,48) = JACC(48,48)-DW(20,48)
      SAVE65 = JACC(56,48)
      JACC(56,48) = JACC(56,48)+DW(20,48)
      SAVE66 = JACC(71,48)
      JACC(71,48) = JACC(71,48)+DW(20,48)
      SAVE67 = JACC(59,70)
      JACC(59,70) = JACC(59,70)+0.8000000000000000d+00*DW(21,70)
      SAVE68 = JACC(61,70)
      JACC(61,70) = JACC(61,70)+0.2000000000000000d+00*DW(21,70)
      SAVE69 = JACC(70,70)
      JACC(70,70) = JACC(70,70)-DW(21,70)
      SAVE70 = JACC(71,70)
      JACC(71,70) = JACC(71,70)+DW(21,70)
      SAVE71 = JACC(72,70)
      JACC(72,70) = JACC(72,70)+DW(21,70)
      SAVE72 = JACC(49,49)
      JACC(49,49) = JACC(49,49)-DW(22,49)
      SAVE73 = JACC(52,49)
      JACC(52,49) = JACC(52,49)+DW(22,49)
      SAVE74 = JACC(66,49)
      JACC(66,49) = JACC(66,49)+DW(22,49)
      SAVE75 = JACC(69,49)
      JACC(69,49) = JACC(69,49)+DW(22,49)
      SAVE76 = JACC(71,49)
      JACC(71,49) = JACC(71,49)+DW(22,49)
      SAVE77 = JACC(24,24)
      JACC(24,24) = JACC(24,24)-DW(23,24)
      SAVE78 = JACC(66,24)
      JACC(66,24) = JACC(66,24)+DW(23,24)
      SAVE79 = JACC(69,24)
      JACC(69,24) = JACC(69,24)+DW(23,24)
      SAVE80 = JACC(71,24)
      JACC(71,24) = JACC(71,24)+DW(23,24)
      SAVE81 = JACC(35,35)
      JACC(35,35) = JACC(35,35)-DW(24,35)
      SAVE82 = JACC(50,35)
      JACC(50,35) = JACC(50,35)+DW(24,35)
      SAVE83 = JACC(35,35)
      JACC(35,35) = JACC(35,35)-DW(25,35)
      SAVE84 = JACC(35,50)
      JACC(35,50) = JACC(35,50)-DW(25,50)
      SAVE85 = JACC(50,35)
      JACC(50,35) = JACC(50,35)-DW(25,35)
      SAVE86 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(25,50)
      SAVE87 = JACC(7,7)
      JACC(7,7) = JACC(7,7)-DW(26,7)
      SAVE88 = JACC(35,7)
      JACC(35,7) = JACC(35,7)+DW(26,7)
      SAVE89 = JACC(7,7)
      JACC(7,7) = JACC(7,7)-DW(27,7)
      SAVE90 = JACC(35,7)
      JACC(35,7) = JACC(35,7)+DW(27,7)
      SAVE91 = JACC(7,7)
      JACC(7,7) = JACC(7,7)-DW(28,7)
      SAVE92 = JACC(62,7)
      JACC(62,7) = JACC(62,7)+0.2000000000000000d+01*DW(28,7)
      SAVE93 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(29,50)
      SAVE94 = JACC(50,62)
      JACC(50,62) = JACC(50,62)-DW(29,62)
      SAVE95 = JACC(62,50)
      JACC(62,50) = JACC(62,50)-DW(29,50)
      SAVE96 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(29,62)
      SAVE97 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+DW(29,50)
      SAVE98 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(29,62)
      SAVE99 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(30,50)
      SAVE100 = JACC(50,71)
      JACC(50,71) = JACC(50,71)-DW(30,71)
      SAVE101 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+DW(30,50)
      SAVE102 = JACC(62,71)
      JACC(62,71) = JACC(62,71)+DW(30,71)
      SAVE103 = JACC(71,50)
      JACC(71,50) = JACC(71,50)-DW(30,50)
      SAVE104 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(30,71)
      SAVE105 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(31,62)
      SAVE106 = JACC(62,71)
      JACC(62,71) = JACC(62,71)-DW(31,71)
      SAVE107 = JACC(71,62)
      JACC(71,62) = JACC(71,62)-DW(31,62)
      SAVE108 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(31,71)
      SAVE109 = JACC(27,27)
      JACC(27,27) = JACC(27,27)-DW(32,27)
      SAVE110 = JACC(27,62)
      JACC(27,62) = JACC(27,62)-DW(32,62)
      SAVE111 = JACC(62,27)
      JACC(62,27) = JACC(62,27)-DW(32,27)
      SAVE112 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(32,62)
      SAVE113 = JACC(71,27)
      JACC(71,27) = JACC(71,27)+DW(32,27)
      SAVE114 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(32,62)
      SAVE115 = JACC(27,71)
      JACC(27,71) = JACC(27,71)+DW(33,71)
      SAVE116 = JACC(27,71)
      JACC(27,71) = JACC(27,71)+DW(33,71)
      SAVE117 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-0.2000000000000000d+01*DW(33,71)
      SAVE118 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-0.2000000000000000d+01*DW(33,71)
      SAVE119 = JACC(27,71)
      JACC(27,71) = JACC(27,71)+DW(34,71)
      SAVE120 = JACC(27,71)
      JACC(27,71) = JACC(27,71)+DW(34,71)
      SAVE121 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-0.2000000000000000d+01*DW(34,71)
      SAVE122 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-0.2000000000000000d+01*DW(34,71)
      SAVE123 = JACC(35,35)
      JACC(35,35) = JACC(35,35)-DW(35,35)
      SAVE124 = JACC(35,67)
      JACC(35,67) = JACC(35,67)-DW(35,67)
      SAVE125 = JACC(67,35)
      JACC(67,35) = JACC(67,35)-DW(35,35)
      SAVE126 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(35,67)
      SAVE127 = JACC(72,35)
      JACC(72,35) = JACC(72,35)+DW(35,35)
      SAVE128 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(35,67)
      SAVE129 = JACC(35,35)
      JACC(35,35) = JACC(35,35)-DW(36,35)
      SAVE130 = JACC(35,72)
      JACC(35,72) = JACC(35,72)-DW(36,72)
      SAVE131 = JACC(67,35)
      JACC(67,35) = JACC(67,35)+DW(36,35)
      SAVE132 = JACC(67,72)
      JACC(67,72) = JACC(67,72)+DW(36,72)
      SAVE133 = JACC(72,35)
      JACC(72,35) = JACC(72,35)-DW(36,35)
      SAVE134 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(36,72)
      SAVE135 = JACC(35,35)
      JACC(35,35) = JACC(35,35)-DW(37,35)
      SAVE136 = JACC(35,72)
      JACC(35,72) = JACC(35,72)-DW(37,72)
      SAVE137 = JACC(68,35)
      JACC(68,35) = JACC(68,35)+DW(37,35)
      SAVE138 = JACC(68,72)
      JACC(68,72) = JACC(68,72)+DW(37,72)
      SAVE139 = JACC(72,35)
      JACC(72,35) = JACC(72,35)-DW(37,35)
      SAVE140 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(37,72)
      SAVE141 = JACC(23,62)
      JACC(23,62) = JACC(23,62)+DW(38,62)
      SAVE142 = JACC(23,67)
      JACC(23,67) = JACC(23,67)+DW(38,67)
      SAVE143 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(38,62)
      SAVE144 = JACC(62,67)
      JACC(62,67) = JACC(62,67)-DW(38,67)
      SAVE145 = JACC(67,62)
      JACC(67,62) = JACC(67,62)-DW(38,62)
      SAVE146 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(38,67)
      SAVE147 = JACC(55,62)
      JACC(55,62) = JACC(55,62)+DW(39,62)
      SAVE148 = JACC(55,72)
      JACC(55,72) = JACC(55,72)+DW(39,72)
      SAVE149 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(39,62)
      SAVE150 = JACC(62,72)
      JACC(62,72) = JACC(62,72)-DW(39,72)
      SAVE151 = JACC(72,62)
      JACC(72,62) = JACC(72,62)-DW(39,62)
      SAVE152 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(39,72)
      SAVE153 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(40,62)
      SAVE154 = JACC(62,68)
      JACC(62,68) = JACC(62,68)-DW(40,68)
      SAVE155 = JACC(68,62)
      JACC(68,62) = JACC(68,62)-DW(40,62)
      SAVE156 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(40,68)
      SAVE157 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(40,62)
      SAVE158 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(40,68)
      SAVE159 = JACC(72,62)
      JACC(72,62) = JACC(72,62)+DW(40,62)
      SAVE160 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(40,68)
      SAVE161 = JACC(62,71)
      JACC(62,71) = JACC(62,71)+DW(41,71)
      SAVE162 = JACC(62,67)
      JACC(62,67) = JACC(62,67)+DW(41,67)
      SAVE163 = JACC(67,71)
      JACC(67,71) = JACC(67,71)-DW(41,71)
      SAVE164 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(41,67)
      SAVE165 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(41,71)
      SAVE166 = JACC(71,67)
      JACC(71,67) = JACC(71,67)-DW(41,67)
      SAVE167 = JACC(72,71)
      JACC(72,71) = JACC(72,71)+DW(41,71)
      SAVE168 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(41,67)
      SAVE169 = JACC(15,71)
      JACC(15,71) = JACC(15,71)+DW(42,71)
      SAVE170 = JACC(15,72)
      JACC(15,72) = JACC(15,72)+DW(42,72)
      SAVE171 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(42,71)
      SAVE172 = JACC(71,72)
      JACC(71,72) = JACC(71,72)-DW(42,72)
      SAVE173 = JACC(72,71)
      JACC(72,71) = JACC(72,71)-DW(42,71)
      SAVE174 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(42,72)
      SAVE175 = JACC(15,15)
      JACC(15,15) = JACC(15,15)-DW(43,15)
      SAVE176 = JACC(71,15)
      JACC(71,15) = JACC(71,15)+DW(43,15)
      SAVE177 = JACC(72,15)
      JACC(72,15) = JACC(72,15)+DW(43,15)
      SAVE178 = JACC(55,71)
      JACC(55,71) = JACC(55,71)+0.3000000000000000d+00*DW(44,71)
      SAVE179 = JACC(55,68)
      JACC(55,68) = JACC(55,68)+0.3000000000000000d+00*DW(44,68)
      SAVE180 = JACC(62,71)
      JACC(62,71) = JACC(62,71)+0.7000000000000000d+00*DW(44,71)
      SAVE181 = JACC(62,68)
      JACC(62,68) = JACC(62,68)+0.7000000000000000d+00*DW(44,68)
      SAVE182 = JACC(68,71)
      JACC(68,71) = JACC(68,71)-DW(44,71)
      SAVE183 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(44,68)
      SAVE184 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(44,71)
      SAVE185 = JACC(71,68)
      JACC(71,68) = JACC(71,68)-DW(44,68)
      SAVE186 = JACC(72,71)
      JACC(72,71) = JACC(72,71)+0.7000000000000000d+00*DW(44,71)
      SAVE187 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+0.7000000000000000d+00*DW(44,68)
      SAVE188 = JACC(23,62)
      JACC(23,62) = JACC(23,62)-DW(45,62)
      SAVE189 = JACC(23,23)
      JACC(23,23) = JACC(23,23)-DW(45,23)
      SAVE190 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(45,62)
      SAVE191 = JACC(62,23)
      JACC(62,23) = JACC(62,23)-DW(45,23)
      SAVE192 = JACC(72,62)
      JACC(72,62) = JACC(72,62)+DW(45,62)
      SAVE193 = JACC(72,23)
      JACC(72,23) = JACC(72,23)+DW(45,23)
      SAVE194 = JACC(55,62)
      JACC(55,62) = JACC(55,62)-DW(46,62)
      SAVE195 = JACC(55,55)
      JACC(55,55) = JACC(55,55)-DW(46,55)
      SAVE196 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(46,62)
      SAVE197 = JACC(62,55)
      JACC(62,55) = JACC(62,55)-DW(46,55)
      SAVE198 = JACC(68,62)
      JACC(68,62) = JACC(68,62)+DW(46,62)
      SAVE199 = JACC(68,55)
      JACC(68,55) = JACC(68,55)+DW(46,55)
      SAVE200 = JACC(15,62)
      JACC(15,62) = JACC(15,62)-DW(47,62)
      SAVE201 = JACC(15,15)
      JACC(15,15) = JACC(15,15)-DW(47,15)
      SAVE202 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(47,62)
      SAVE203 = JACC(62,15)
      JACC(62,15) = JACC(62,15)-DW(47,15)
      SAVE204 = JACC(72,62)
      JACC(72,62) = JACC(72,62)+DW(47,62)
      SAVE205 = JACC(72,15)
      JACC(72,15) = JACC(72,15)+DW(47,15)
      SAVE206 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(48,50)
      SAVE207 = JACC(50,67)
      JACC(50,67) = JACC(50,67)-DW(48,67)
      SAVE208 = JACC(67,50)
      JACC(67,50) = JACC(67,50)-DW(48,50)
      SAVE209 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(48,67)
      SAVE210 = JACC(72,50)
      JACC(72,50) = JACC(72,50)+DW(48,50)
      SAVE211 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(48,67)
      SAVE212 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(49,50)
      SAVE213 = JACC(50,72)
      JACC(50,72) = JACC(50,72)-DW(49,72)
      SAVE214 = JACC(68,50)
      JACC(68,50) = JACC(68,50)+DW(49,50)
      SAVE215 = JACC(68,72)
      JACC(68,72) = JACC(68,72)+DW(49,72)
      SAVE216 = JACC(72,50)
      JACC(72,50) = JACC(72,50)-DW(49,50)
      SAVE217 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(49,72)
      SAVE218 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-0.2000000000000000d+01*DW(50,67)
      SAVE219 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-0.2000000000000000d+01*DW(50,67)
      SAVE220 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.2000000000000000d+01*DW(50,67)
      SAVE221 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.2000000000000000d+01*DW(50,67)
      SAVE222 = JACC(67,68)
      JACC(67,68) = JACC(67,68)-DW(51,68)
      SAVE223 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(51,67)
      SAVE224 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(51,68)
      SAVE225 = JACC(68,67)
      JACC(68,67) = JACC(68,67)-DW(51,67)
      SAVE226 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+0.2000000000000000d+01*DW(51,68)
      SAVE227 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.2000000000000000d+01*DW(51,67)
      SAVE228 = JACC(67,68)
      JACC(67,68) = JACC(67,68)+DW(52,68)
      SAVE229 = JACC(67,72)
      JACC(67,72) = JACC(67,72)+DW(52,72)
      SAVE230 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(52,68)
      SAVE231 = JACC(68,72)
      JACC(68,72) = JACC(68,72)-DW(52,72)
      SAVE232 = JACC(9,68)
      JACC(9,68) = JACC(9,68)+DW(53,68)
      SAVE233 = JACC(9,72)
      JACC(9,72) = JACC(9,72)+DW(53,72)
      SAVE234 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(53,68)
      SAVE235 = JACC(68,72)
      JACC(68,72) = JACC(68,72)-DW(53,72)
      SAVE236 = JACC(72,68)
      JACC(72,68) = JACC(72,68)-DW(53,68)
      SAVE237 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(53,72)
      SAVE238 = JACC(9,9)
      JACC(9,9) = JACC(9,9)-DW(54,9)
      SAVE239 = JACC(68,9)
      JACC(68,9) = JACC(68,9)+DW(54,9)
      SAVE240 = JACC(72,9)
      JACC(72,9) = JACC(72,9)+DW(54,9)
      SAVE241 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-0.2000000000000000d+01*DW(55,68)
      SAVE242 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-0.2000000000000000d+01*DW(55,68)
      SAVE243 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+0.2000000000000000d+01*DW(55,68)
      SAVE244 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+0.2000000000000000d+01*DW(55,68)
      SAVE245 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(56,62)
      SAVE246 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(56,62)
      SAVE247 = JACC(1,62)
      JACC(1,62) = JACC(1,62)-DW(57,62)
      SAVE248 = JACC(1,1)
      JACC(1,1) = JACC(1,1)-DW(57,1)
      SAVE249 = JACC(8,62)
      JACC(8,62) = JACC(8,62)+DW(57,62)
      SAVE250 = JACC(8,1)
      JACC(8,1) = JACC(8,1)+DW(57,1)
      SAVE251 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(57,62)
      SAVE252 = JACC(62,1)
      JACC(62,1) = JACC(62,1)-DW(57,1)
      SAVE253 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(57,62)
      SAVE254 = JACC(71,1)
      JACC(71,1) = JACC(71,1)+DW(57,1)
      SAVE255 = JACC(52,52)
      JACC(52,52) = JACC(52,52)-DW(58,52)
      SAVE256 = JACC(52,62)
      JACC(52,62) = JACC(52,62)-DW(58,62)
      SAVE257 = JACC(62,52)
      JACC(62,52) = JACC(62,52)-DW(58,52)
      SAVE258 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(58,62)
      SAVE259 = JACC(71,52)
      JACC(71,52) = JACC(71,52)+DW(58,52)
      SAVE260 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(58,62)
      SAVE261 = JACC(19,19)
      JACC(19,19) = JACC(19,19)-DW(59,19)
      SAVE262 = JACC(19,35)
      JACC(19,35) = JACC(19,35)-DW(59,35)
      SAVE263 = JACC(35,19)
      JACC(35,19) = JACC(35,19)-DW(59,19)
      SAVE264 = JACC(35,35)
      JACC(35,35) = JACC(35,35)-DW(59,35)
      SAVE265 = JACC(40,19)
      JACC(40,19) = JACC(40,19)+0.8600000000000000d+00*DW(59,19)
      SAVE266 = JACC(40,35)
      JACC(40,35) = JACC(40,35)+0.8600000000000000d+00*DW(59,35)
      SAVE267 = JACC(48,19)
      JACC(48,19) = JACC(48,19)+0.1300000000000000d+00*DW(59,19)
      SAVE268 = JACC(48,35)
      JACC(48,35) = JACC(48,35)+0.1300000000000000d+00*DW(59,35)
      SAVE269 = JACC(52,19)
      JACC(52,19) = JACC(52,19)+0.1000000000000000d-01*DW(59,19)
      SAVE270 = JACC(52,35)
      JACC(52,35) = JACC(52,35)+0.1000000000000000d-01*DW(59,35)
      SAVE271 = JACC(62,19)
      JACC(62,19) = JACC(62,19)+0.2000000000000000d-01*DW(59,19)
      SAVE272 = JACC(62,35)
      JACC(62,35) = JACC(62,35)+0.2000000000000000d-01*DW(59,35)
      SAVE273 = JACC(65,19)
      JACC(65,19) = JACC(65,19)+0.1500000000000000d+00*DW(59,19)
      SAVE274 = JACC(65,35)
      JACC(65,35) = JACC(65,35)+0.1500000000000000d+00*DW(59,35)
      SAVE275 = JACC(66,19)
      JACC(66,19) = JACC(66,19)+0.5000000000000000d-01*DW(59,19)
      SAVE276 = JACC(66,35)
      JACC(66,35) = JACC(66,35)+0.5000000000000000d-01*DW(59,35)
      SAVE277 = JACC(71,19)
      JACC(71,19) = JACC(71,19)+0.2800000000000000d+00*DW(59,19)
      SAVE278 = JACC(71,35)
      JACC(71,35) = JACC(71,35)+0.2800000000000000d+00*DW(59,35)
      SAVE279 = JACC(35,49)
      JACC(35,49) = JACC(35,49)-DW(60,49)
      SAVE280 = JACC(35,35)
      JACC(35,35) = JACC(35,35)-DW(60,35)
      SAVE281 = JACC(49,49)
      JACC(49,49) = JACC(49,49)-DW(60,49)
      SAVE282 = JACC(49,35)
      JACC(49,35) = JACC(49,35)-DW(60,35)
      SAVE283 = JACC(61,49)
      JACC(61,49) = JACC(61,49)+DW(60,49)
      SAVE284 = JACC(61,35)
      JACC(61,35) = JACC(61,35)+DW(60,35)
      SAVE285 = JACC(20,20)
      JACC(20,20) = JACC(20,20)-DW(61,20)
      SAVE286 = JACC(20,62)
      JACC(20,62) = JACC(20,62)-DW(61,62)
      SAVE287 = JACC(62,20)
      JACC(62,20) = JACC(62,20)-DW(61,20)
      SAVE288 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(61,62)
      SAVE289 = JACC(63,20)
      JACC(63,20) = JACC(63,20)+DW(61,20)
      SAVE290 = JACC(63,62)
      JACC(63,62) = JACC(63,62)+DW(61,62)
      SAVE291 = JACC(21,21)
      JACC(21,21) = JACC(21,21)-DW(62,21)
      SAVE292 = JACC(21,62)
      JACC(21,62) = JACC(21,62)-DW(62,62)
      SAVE293 = JACC(60,21)
      JACC(60,21) = JACC(60,21)+DW(62,21)
      SAVE294 = JACC(60,62)
      JACC(60,62) = JACC(60,62)+DW(62,62)
      SAVE295 = JACC(62,21)
      JACC(62,21) = JACC(62,21)-DW(62,21)
      SAVE296 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(62,62)
      SAVE297 = JACC(2,2)
      JACC(2,2) = JACC(2,2)-DW(63,2)
      SAVE298 = JACC(2,62)
      JACC(2,62) = JACC(2,62)-DW(63,62)
      SAVE299 = JACC(34,2)
      JACC(34,2) = JACC(34,2)+0.3600000000000000d-01*DW(63,2)
      SAVE300 = JACC(34,62)
      JACC(34,62) = JACC(34,62)+0.3600000000000000d-01*DW(63,62)
      SAVE301 = JACC(51,2)
      JACC(51,2) = JACC(51,2)+0.3600000000000000d-01*DW(63,2)
      SAVE302 = JACC(51,62)
      JACC(51,62) = JACC(51,62)+0.3600000000000000d-01*DW(63,62)
      SAVE303 = JACC(52,2)
      JACC(52,2) = JACC(52,2)+0.3600000000000000d-01*DW(63,2)
      SAVE304 = JACC(52,62)
      JACC(52,62) = JACC(52,62)+0.3600000000000000d-01*DW(63,62)
      SAVE305 = JACC(61,2)
      JACC(61,2) = JACC(61,2)+0.3350000000000000d+00*DW(63,2)
      SAVE306 = JACC(61,62)
      JACC(61,62) = JACC(61,62)+0.3350000000000000d+00*DW(63,62)
      SAVE307 = JACC(62,2)
      JACC(62,2) = JACC(62,2)-0.9640000000000000d+00*DW(63,2)
      SAVE308 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-0.9640000000000000d+00*DW(63,62)
      SAVE309 = JACC(64,2)
      JACC(64,2) = JACC(64,2)+0.5830000000000000d+00*DW(63,2)
      SAVE310 = JACC(64,62)
      JACC(64,62) = JACC(64,62)+0.5830000000000000d+00*DW(63,62)
      SAVE311 = JACC(66,2)
      JACC(66,2) = JACC(66,2)+0.1000000000000000d-01*DW(63,2)
      SAVE312 = JACC(66,62)
      JACC(66,62) = JACC(66,62)+0.1000000000000000d-01*DW(63,62)
      SAVE313 = JACC(71,2)
      JACC(71,2) = JACC(71,2)+0.3810000000000000d+00*DW(63,2)
      SAVE314 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.3810000000000000d+00*DW(63,62)
      SAVE315 = JACC(3,3)
      JACC(3,3) = JACC(3,3)-DW(64,3)
      SAVE316 = JACC(3,62)
      JACC(3,62) = JACC(3,62)-DW(64,62)
      SAVE317 = JACC(36,3)
      JACC(36,3) = JACC(36,3)+0.7500000000000000d+00*DW(64,3)
      SAVE318 = JACC(36,62)
      JACC(36,62) = JACC(36,62)+0.7500000000000000d+00*DW(64,62)
      SAVE319 = JACC(59,3)
      JACC(59,3) = JACC(59,3)+0.2500000000000000d+00*DW(64,3)
      SAVE320 = JACC(59,62)
      JACC(59,62) = JACC(59,62)+0.2500000000000000d+00*DW(64,62)
      SAVE321 = JACC(62,3)
      JACC(62,3) = JACC(62,3)-DW(64,3)
      SAVE322 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(64,62)
      SAVE323 = JACC(71,3)
      JACC(71,3) = JACC(71,3)+0.2500000000000000d+00*DW(64,3)
      SAVE324 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.2500000000000000d+00*DW(64,62)
      SAVE325 = JACC(4,4)
      JACC(4,4) = JACC(4,4)-DW(65,4)
      SAVE326 = JACC(4,62)
      JACC(4,62) = JACC(4,62)-DW(65,62)
      SAVE327 = JACC(24,4)
      JACC(24,4) = JACC(24,4)+0.2400000000000000d-01*DW(65,4)
      SAVE328 = JACC(24,62)
      JACC(24,62) = JACC(24,62)+0.2400000000000000d-01*DW(65,62)
      SAVE329 = JACC(37,4)
      JACC(37,4) = JACC(37,4)+0.9510000000000000d+00*DW(65,4)
      SAVE330 = JACC(37,62)
      JACC(37,62) = JACC(37,62)+0.9510000000000000d+00*DW(65,62)
      SAVE331 = JACC(61,4)
      JACC(61,4) = JACC(61,4)+0.2500000000000000d-01*DW(65,4)
      SAVE332 = JACC(61,62)
      JACC(61,62) = JACC(61,62)+0.2500000000000000d-01*DW(65,62)
      SAVE333 = JACC(62,4)
      JACC(62,4) = JACC(62,4)-DW(65,4)
      SAVE334 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(65,62)
      SAVE335 = JACC(71,4)
      JACC(71,4) = JACC(71,4)+0.4900000000000000d-01*DW(65,4)
      SAVE336 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.4900000000000000d-01*DW(65,62)
      SAVE337 = JACC(11,11)
      JACC(11,11) = JACC(11,11)-DW(66,11)
      SAVE338 = JACC(11,62)
      JACC(11,62) = JACC(11,62)-DW(66,62)
      SAVE339 = JACC(38,11)
      JACC(38,11) = JACC(38,11)+DW(66,11)
      SAVE340 = JACC(38,62)
      JACC(38,62) = JACC(38,62)+DW(66,62)
      SAVE341 = JACC(62,11)
      JACC(62,11) = JACC(62,11)-DW(66,11)
      SAVE342 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(66,62)
      SAVE343 = JACC(40,40)
      JACC(40,40) = JACC(40,40)-DW(67,40)
      SAVE344 = JACC(40,62)
      JACC(40,62) = JACC(40,62)-DW(67,62)
      SAVE345 = JACC(41,40)
      JACC(41,40) = JACC(41,40)+DW(67,40)
      SAVE346 = JACC(41,62)
      JACC(41,62) = JACC(41,62)+DW(67,62)
      SAVE347 = JACC(62,40)
      JACC(62,40) = JACC(62,40)-DW(67,40)
      SAVE348 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(67,62)
      SAVE349 = JACC(44,44)
      JACC(44,44) = JACC(44,44)-DW(68,44)
      SAVE350 = JACC(44,62)
      JACC(44,62) = JACC(44,62)-DW(68,62)
      SAVE351 = JACC(45,44)
      JACC(45,44) = JACC(45,44)+DW(68,44)
      SAVE352 = JACC(45,62)
      JACC(45,62) = JACC(45,62)+DW(68,62)
      SAVE353 = JACC(62,44)
      JACC(62,44) = JACC(62,44)-DW(68,44)
      SAVE354 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(68,62)
      SAVE355 = JACC(12,12)
      JACC(12,12) = JACC(12,12)-DW(69,12)
      SAVE356 = JACC(12,62)
      JACC(12,62) = JACC(12,62)-DW(69,62)
      SAVE357 = JACC(39,12)
      JACC(39,12) = JACC(39,12)+DW(69,12)
      SAVE358 = JACC(39,62)
      JACC(39,62) = JACC(39,62)+DW(69,62)
      SAVE359 = JACC(62,12)
      JACC(62,12) = JACC(62,12)-DW(69,12)
      SAVE360 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(69,62)
      SAVE361 = JACC(19,19)
      JACC(19,19) = JACC(19,19)-DW(70,19)
      SAVE362 = JACC(19,62)
      JACC(19,62) = JACC(19,62)-DW(70,62)
      SAVE363 = JACC(39,19)
      JACC(39,19) = JACC(39,19)+DW(70,19)
      SAVE364 = JACC(39,62)
      JACC(39,62) = JACC(39,62)+DW(70,62)
      SAVE365 = JACC(62,19)
      JACC(62,19) = JACC(62,19)-DW(70,19)
      SAVE366 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(70,62)
      SAVE367 = JACC(13,13)
      JACC(13,13) = JACC(13,13)-DW(71,13)
      SAVE368 = JACC(13,62)
      JACC(13,62) = JACC(13,62)-DW(71,62)
      SAVE369 = JACC(42,13)
      JACC(42,13) = JACC(42,13)+DW(71,13)
      SAVE370 = JACC(42,62)
      JACC(42,62) = JACC(42,62)+DW(71,62)
      SAVE371 = JACC(62,13)
      JACC(62,13) = JACC(62,13)-DW(71,13)
      SAVE372 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(71,62)
      SAVE373 = JACC(14,14)
      JACC(14,14) = JACC(14,14)-DW(72,14)
      SAVE374 = JACC(14,62)
      JACC(14,62) = JACC(14,62)-DW(72,62)
      SAVE375 = JACC(43,14)
      JACC(43,14) = JACC(43,14)+DW(72,14)
      SAVE376 = JACC(43,62)
      JACC(43,62) = JACC(43,62)+DW(72,62)
      SAVE377 = JACC(62,14)
      JACC(62,14) = JACC(62,14)-DW(72,14)
      SAVE378 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(72,62)
      SAVE379 = JACC(5,5)
      JACC(5,5) = JACC(5,5)-DW(73,5)
      SAVE380 = JACC(5,62)
      JACC(5,62) = JACC(5,62)-DW(73,62)
      SAVE381 = JACC(17,5)
      JACC(17,5) = JACC(17,5)+0.9000000000000000d+00*DW(73,5)
      SAVE382 = JACC(17,62)
      JACC(17,62) = JACC(17,62)+0.9000000000000000d+00*DW(73,62)
      SAVE383 = JACC(62,5)
      JACC(62,5) = JACC(62,5)-DW(73,5)
      SAVE384 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(73,62)
      SAVE385 = JACC(65,5)
      JACC(65,5) = JACC(65,5)+0.1000000000000000d+00*DW(73,5)
      SAVE386 = JACC(65,62)
      JACC(65,62) = JACC(65,62)+0.1000000000000000d+00*DW(73,62)
      SAVE387 = JACC(71,5)
      JACC(71,5) = JACC(71,5)+0.1000000000000000d+00*DW(73,5)
      SAVE388 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.1000000000000000d+00*DW(73,62)
      SAVE389 = JACC(6,6)
      JACC(6,6) = JACC(6,6)-DW(74,6)
      SAVE390 = JACC(6,62)
      JACC(6,62) = JACC(6,62)-DW(74,62)
      SAVE391 = JACC(18,6)
      JACC(18,6) = JACC(18,6)+0.9000000000000000d+00*DW(74,6)
      SAVE392 = JACC(18,62)
      JACC(18,62) = JACC(18,62)+0.9000000000000000d+00*DW(74,62)
      SAVE393 = JACC(62,6)
      JACC(62,6) = JACC(62,6)-DW(74,6)
      SAVE394 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(74,62)
      SAVE395 = JACC(65,6)
      JACC(65,6) = JACC(65,6)+0.1000000000000000d+00*DW(74,6)
      SAVE396 = JACC(65,62)
      JACC(65,62) = JACC(65,62)+0.1000000000000000d+00*DW(74,62)
      SAVE397 = JACC(71,6)
      JACC(71,6) = JACC(71,6)+0.1000000000000000d+00*DW(74,6)
      SAVE398 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.1000000000000000d+00*DW(74,62)
      SAVE399 = JACC(22,30)
      JACC(22,30) = JACC(22,30)+0.8500000000000000d+00*DW(75,30)
      SAVE400 = JACC(22,62)
      JACC(22,62) = JACC(22,62)+0.8500000000000000d+00*DW(75,62)
      SAVE401 = JACC(29,30)
      JACC(29,30) = JACC(29,30)+0.1000000000000000d+00*DW(75,30)
      SAVE402 = JACC(29,62)
      JACC(29,62) = JACC(29,62)+0.1000000000000000d+00*DW(75,62)
      SAVE403 = JACC(30,30)
      JACC(30,30) = JACC(30,30)-DW(75,30)
      SAVE404 = JACC(30,62)
      JACC(30,62) = JACC(30,62)-DW(75,62)
      SAVE405 = JACC(62,30)
      JACC(62,30) = JACC(62,30)-DW(75,30)
      SAVE406 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(75,62)
      SAVE407 = JACC(65,30)
      JACC(65,30) = JACC(65,30)+0.5000000000000000d-01*DW(75,30)
      SAVE408 = JACC(65,62)
      JACC(65,62) = JACC(65,62)+0.5000000000000000d-01*DW(75,62)
      SAVE409 = JACC(71,30)
      JACC(71,30) = JACC(71,30)+0.5000000000000000d-01*DW(75,30)
      SAVE410 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.5000000000000000d-01*DW(75,62)
      SAVE411 = JACC(52,66)
      JACC(52,66) = JACC(52,66)+DW(76,66)
      SAVE412 = JACC(52,62)
      JACC(52,62) = JACC(52,62)+DW(76,62)
      SAVE413 = JACC(62,66)
      JACC(62,66) = JACC(62,66)-DW(76,66)
      SAVE414 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(76,62)
      SAVE415 = JACC(66,66)
      JACC(66,66) = JACC(66,66)-DW(76,66)
      SAVE416 = JACC(66,62)
      JACC(66,62) = JACC(66,62)-DW(76,62)
      SAVE417 = JACC(71,66)
      JACC(71,66) = JACC(71,66)+DW(76,66)
      SAVE418 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(76,62)
      SAVE419 = JACC(61,61)
      JACC(61,61) = JACC(61,61)-DW(77,61)
      SAVE420 = JACC(61,62)
      JACC(61,62) = JACC(61,62)-DW(77,62)
      SAVE421 = JACC(62,61)
      JACC(62,61) = JACC(62,61)-DW(77,61)
      SAVE422 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(77,62)
      SAVE423 = JACC(69,61)
      JACC(69,61) = JACC(69,61)+DW(77,61)
      SAVE424 = JACC(69,62)
      JACC(69,62) = JACC(69,62)+DW(77,62)
      SAVE425 = JACC(58,59)
      JACC(58,59) = JACC(58,59)+DW(78,59)
      SAVE426 = JACC(58,62)
      JACC(58,62) = JACC(58,62)+DW(78,62)
      SAVE427 = JACC(59,59)
      JACC(59,59) = JACC(59,59)-DW(78,59)
      SAVE428 = JACC(59,62)
      JACC(59,62) = JACC(59,62)-DW(78,62)
      SAVE429 = JACC(62,59)
      JACC(62,59) = JACC(62,59)-DW(78,59)
      SAVE430 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(78,62)
      SAVE431 = JACC(24,24)
      JACC(24,24) = JACC(24,24)-DW(79,24)
      SAVE432 = JACC(24,62)
      JACC(24,62) = JACC(24,62)-DW(79,62)
      SAVE433 = JACC(54,24)
      JACC(54,24) = JACC(54,24)+DW(79,24)
      SAVE434 = JACC(54,62)
      JACC(54,62) = JACC(54,62)+DW(79,62)
      SAVE435 = JACC(62,24)
      JACC(62,24) = JACC(62,24)-DW(79,24)
      SAVE436 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(79,62)
      SAVE437 = JACC(71,24)
      JACC(71,24) = JACC(71,24)+DW(79,24)
      SAVE438 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(79,62)
      SAVE439 = JACC(51,51)
      JACC(51,51) = JACC(51,51)-DW(80,51)
      SAVE440 = JACC(51,62)
      JACC(51,62) = JACC(51,62)-DW(80,62)
      SAVE441 = JACC(52,51)
      JACC(52,51) = JACC(52,51)+0.2000000000000000d+01*DW(80,51)
      SAVE442 = JACC(52,62)
      JACC(52,62) = JACC(52,62)+0.2000000000000000d+01*DW(80,62)
      SAVE443 = JACC(62,51)
      JACC(62,51) = JACC(62,51)-DW(80,51)
      SAVE444 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(80,62)
      SAVE445 = JACC(71,51)
      JACC(71,51) = JACC(71,51)+DW(80,51)
      SAVE446 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(80,62)
      SAVE447 = JACC(52,54)
      JACC(52,54) = JACC(52,54)+DW(81,54)
      SAVE448 = JACC(52,62)
      JACC(52,62) = JACC(52,62)+DW(81,62)
      SAVE449 = JACC(54,54)
      JACC(54,54) = JACC(54,54)-DW(81,54)
      SAVE450 = JACC(54,62)
      JACC(54,62) = JACC(54,62)-DW(81,62)
      SAVE451 = JACC(62,54)
      JACC(62,54) = JACC(62,54)-DW(81,54)
      SAVE452 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(81,62)
      SAVE453 = JACC(69,54)
      JACC(69,54) = JACC(69,54)+DW(81,54)
      SAVE454 = JACC(69,62)
      JACC(69,62) = JACC(69,62)+DW(81,62)
      SAVE455 = JACC(24,49)
      JACC(24,49) = JACC(24,49)+0.4100000000000000d+00*DW(82,49)
      SAVE456 = JACC(24,62)
      JACC(24,62) = JACC(24,62)+0.4100000000000000d+00*DW(82,62)
      SAVE457 = JACC(49,49)
      JACC(49,49) = JACC(49,49)-DW(82,49)
      SAVE458 = JACC(49,62)
      JACC(49,62) = JACC(49,62)-DW(82,62)
      SAVE459 = JACC(52,49)
      JACC(52,49) = JACC(52,49)+0.4100000000000000d+00*DW(82,49)
      SAVE460 = JACC(52,62)
      JACC(52,62) = JACC(52,62)+0.4100000000000000d+00*DW(82,62)
      SAVE461 = JACC(54,49)
      JACC(54,49) = JACC(54,49)+0.8000000000000000d-01*DW(82,49)
      SAVE462 = JACC(54,62)
      JACC(54,62) = JACC(54,62)+0.8000000000000000d-01*DW(82,62)
      SAVE463 = JACC(56,49)
      JACC(56,49) = JACC(56,49)+0.5100000000000000d+00*DW(82,49)
      SAVE464 = JACC(56,62)
      JACC(56,62) = JACC(56,62)+0.5100000000000000d+00*DW(82,62)
      SAVE465 = JACC(62,49)
      JACC(62,49) = JACC(62,49)-DW(82,49)
      SAVE466 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(82,62)
      SAVE467 = JACC(65,49)
      JACC(65,49) = JACC(65,49)+0.4900000000000000d+00*DW(82,49)
      SAVE468 = JACC(65,62)
      JACC(65,62) = JACC(65,62)+0.4900000000000000d+00*DW(82,62)
      SAVE469 = JACC(66,49)
      JACC(66,49) = JACC(66,49)+0.8000000000000000d-01*DW(82,49)
      SAVE470 = JACC(66,62)
      JACC(66,62) = JACC(66,62)+0.8000000000000000d-01*DW(82,62)
      SAVE471 = JACC(71,49)
      JACC(71,49) = JACC(71,49)+0.4900000000000000d+00*DW(82,49)
      SAVE472 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.4900000000000000d+00*DW(82,62)
      SAVE473 = JACC(10,62)
      JACC(10,62) = JACC(10,62)+0.3500000000000000d+00*DW(83,62)
      SAVE474 = JACC(10,48)
      JACC(10,48) = JACC(10,48)+0.3500000000000000d+00*DW(83,48)
      SAVE475 = JACC(48,62)
      JACC(48,62) = JACC(48,62)-DW(83,62)
      SAVE476 = JACC(48,48)
      JACC(48,48) = JACC(48,48)-DW(83,48)
      SAVE477 = JACC(51,62)
      JACC(51,62) = JACC(51,62)+0.1500000000000000d+00*DW(83,62)
      SAVE478 = JACC(51,48)
      JACC(51,48) = JACC(51,48)+0.1500000000000000d+00*DW(83,48)
      SAVE479 = JACC(54,62)
      JACC(54,62) = JACC(54,62)+0.1500000000000000d+00*DW(83,62)
      SAVE480 = JACC(54,48)
      JACC(54,48) = JACC(54,48)+0.1500000000000000d+00*DW(83,48)
      SAVE481 = JACC(56,62)
      JACC(56,62) = JACC(56,62)+0.5000000000000000d+00*DW(83,62)
      SAVE482 = JACC(56,48)
      JACC(56,48) = JACC(56,48)+0.5000000000000000d+00*DW(83,48)
      SAVE483 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(83,62)
      SAVE484 = JACC(62,48)
      JACC(62,48) = JACC(62,48)-DW(83,48)
      SAVE485 = JACC(65,62)
      JACC(65,62) = JACC(65,62)+0.5000000000000000d+00*DW(83,62)
      SAVE486 = JACC(65,48)
      JACC(65,48) = JACC(65,48)+0.5000000000000000d+00*DW(83,48)
      SAVE487 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.5000000000000000d+00*DW(83,62)
      SAVE488 = JACC(71,48)
      JACC(71,48) = JACC(71,48)+0.5000000000000000d+00*DW(83,48)
      SAVE489 = JACC(10,62)
      JACC(10,62) = JACC(10,62)-DW(84,62)
      SAVE490 = JACC(10,10)
      JACC(10,10) = JACC(10,10)-DW(84,10)
      SAVE491 = JACC(59,62)
      JACC(59,62) = JACC(59,62)+0.1200000000000000d+00*DW(84,62)
      SAVE492 = JACC(59,10)
      JACC(59,10) = JACC(59,10)+0.1200000000000000d+00*DW(84,10)
      SAVE493 = JACC(61,62)
      JACC(61,62) = JACC(61,62)+0.8800000000000000d+00*DW(84,62)
      SAVE494 = JACC(61,10)
      JACC(61,10) = JACC(61,10)+0.8800000000000000d+00*DW(84,10)
      SAVE495 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(84,62)
      SAVE496 = JACC(62,10)
      JACC(62,10) = JACC(62,10)-DW(84,10)
      SAVE497 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+DW(84,62)
      SAVE498 = JACC(71,10)
      JACC(71,10) = JACC(71,10)+DW(84,10)
      SAVE499 = JACC(16,16)
      JACC(16,16) = JACC(16,16)-DW(85,16)
      SAVE500 = JACC(16,62)
      JACC(16,62) = JACC(16,62)-DW(85,62)
      SAVE501 = JACC(62,16)
      JACC(62,16) = JACC(62,16)-0.6500000000000000d+00*DW(85,16)
      SAVE502 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-0.6500000000000000d+00*DW(85,62)
      SAVE503 = JACC(63,16)
      JACC(63,16) = JACC(63,16)+0.6500000000000000d+00*DW(85,16)
      SAVE504 = JACC(63,62)
      JACC(63,62) = JACC(63,62)+0.6500000000000000d+00*DW(85,62)
      SAVE505 = JACC(66,16)
      JACC(66,16) = JACC(66,16)+0.3500000000000000d+00*DW(85,16)
      SAVE506 = JACC(66,62)
      JACC(66,62) = JACC(66,62)+0.3500000000000000d+00*DW(85,62)
      SAVE507 = JACC(53,53)
      JACC(53,53) = JACC(53,53)-DW(86,53)
      SAVE508 = JACC(53,62)
      JACC(53,62) = JACC(53,62)-DW(86,62)
      SAVE509 = JACC(59,53)
      JACC(59,53) = JACC(59,53)+0.4100000000000000d+00*DW(86,53)
      SAVE510 = JACC(59,62)
      JACC(59,62) = JACC(59,62)+0.4100000000000000d+00*DW(86,62)
      SAVE511 = JACC(61,53)
      JACC(61,53) = JACC(61,53)+0.8000000000000000d-01*DW(86,53)
      SAVE512 = JACC(61,62)
      JACC(61,62) = JACC(61,62)+0.8000000000000000d-01*DW(86,62)
      SAVE513 = JACC(62,53)
      JACC(62,53) = JACC(62,53)-0.5100000000000000d+00*DW(86,53)
      SAVE514 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-0.5100000000000000d+00*DW(86,62)
      SAVE515 = JACC(64,53)
      JACC(64,53) = JACC(64,53)+0.4400000000000000d+00*DW(86,53)
      SAVE516 = JACC(64,62)
      JACC(64,62) = JACC(64,62)+0.4400000000000000d+00*DW(86,62)
      SAVE517 = JACC(65,53)
      JACC(65,53) = JACC(65,53)+0.7000000000000001d-01*DW(86,53)
      SAVE518 = JACC(65,62)
      JACC(65,62) = JACC(65,62)+0.7000000000000001d-01*DW(86,62)
      SAVE519 = JACC(28,28)
      JACC(28,28) = JACC(28,28)-DW(87,28)
      SAVE520 = JACC(28,62)
      JACC(28,62) = JACC(28,62)-DW(87,62)
      SAVE521 = JACC(62,28)
      JACC(62,28) = JACC(62,28)-DW(87,28)
      SAVE522 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(87,62)
      SAVE523 = JACC(65,28)
      JACC(65,28) = JACC(65,28)+0.3500000000000000d+00*DW(87,28)
      SAVE524 = JACC(65,62)
      JACC(65,62) = JACC(65,62)+0.3500000000000000d+00*DW(87,62)
      SAVE525 = JACC(66,28)
      JACC(66,28) = JACC(66,28)+0.3500000000000000d+00*DW(87,28)
      SAVE526 = JACC(66,62)
      JACC(66,62) = JACC(66,62)+0.3500000000000000d+00*DW(87,62)
      SAVE527 = JACC(69,28)
      JACC(69,28) = JACC(69,28)+0.6500000000000000d+00*DW(87,28)
      SAVE528 = JACC(69,62)
      JACC(69,62) = JACC(69,62)+0.6500000000000000d+00*DW(87,62)
      SAVE529 = JACC(71,28)
      JACC(71,28) = JACC(71,28)+0.3500000000000000d+00*DW(87,28)
      SAVE530 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.3500000000000000d+00*DW(87,62)
      SAVE531 = JACC(26,26)
      JACC(26,26) = JACC(26,26)-DW(88,26)
      SAVE532 = JACC(26,62)
      JACC(26,62) = JACC(26,62)-DW(88,62)
      SAVE533 = JACC(62,26)
      JACC(62,26) = JACC(62,26)-DW(88,26)
      SAVE534 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(88,62)
      SAVE535 = JACC(65,26)
      JACC(65,26) = JACC(65,26)+DW(88,26)
      SAVE536 = JACC(65,62)
      JACC(65,62) = JACC(65,62)+DW(88,62)
      SAVE537 = JACC(66,26)
      JACC(66,26) = JACC(66,26)+DW(88,26)
      SAVE538 = JACC(66,62)
      JACC(66,62) = JACC(66,62)+DW(88,62)
      SAVE539 = JACC(68,26)
      JACC(68,26) = JACC(68,26)+DW(88,26)
      SAVE540 = JACC(68,62)
      JACC(68,62) = JACC(68,62)+DW(88,62)
      SAVE541 = JACC(24,25)
      JACC(24,25) = JACC(24,25)+0.6000000000000000d+00*DW(89,25)
      SAVE542 = JACC(24,62)
      JACC(24,62) = JACC(24,62)+0.6000000000000000d+00*DW(89,62)
      SAVE543 = JACC(25,25)
      JACC(25,25) = JACC(25,25)-DW(89,25)
      SAVE544 = JACC(25,62)
      JACC(25,62) = JACC(25,62)-DW(89,62)
      SAVE545 = JACC(26,25)
      JACC(26,25) = JACC(26,25)+0.4000000000000000d+00*DW(89,25)
      SAVE546 = JACC(26,62)
      JACC(26,62) = JACC(26,62)+0.4000000000000000d+00*DW(89,62)
      SAVE547 = JACC(62,25)
      JACC(62,25) = JACC(62,25)-DW(89,25)
      SAVE548 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(89,62)
      SAVE549 = JACC(65,25)
      JACC(65,25) = JACC(65,25)+DW(89,25)
      SAVE550 = JACC(65,62)
      JACC(65,62) = JACC(65,62)+DW(89,62)
      SAVE551 = JACC(66,25)
      JACC(66,25) = JACC(66,25)+0.4000000000000000d+00*DW(89,25)
      SAVE552 = JACC(66,62)
      JACC(66,62) = JACC(66,62)+0.4000000000000000d+00*DW(89,62)
      SAVE553 = JACC(68,25)
      JACC(68,25) = JACC(68,25)+0.6000000000000000d+00*DW(89,25)
      SAVE554 = JACC(68,62)
      JACC(68,62) = JACC(68,62)+0.6000000000000000d+00*DW(89,62)
      SAVE555 = JACC(71,25)
      JACC(71,25) = JACC(71,25)+0.4000000000000000d+00*DW(89,25)
      SAVE556 = JACC(71,62)
      JACC(71,62) = JACC(71,62)+0.4000000000000000d+00*DW(89,62)
      SAVE557 = JACC(62,70)
      JACC(62,70) = JACC(62,70)-DW(90,70)
      SAVE558 = JACC(62,62)
      JACC(62,62) = JACC(62,62)-DW(90,62)
      SAVE559 = JACC(64,70)
      JACC(64,70) = JACC(64,70)+DW(90,70)
      SAVE560 = JACC(64,62)
      JACC(64,62) = JACC(64,62)+DW(90,62)
      SAVE561 = JACC(70,70)
      JACC(70,70) = JACC(70,70)-DW(90,70)
      SAVE562 = JACC(70,62)
      JACC(70,62) = JACC(70,62)-DW(90,62)
      SAVE563 = JACC(72,70)
      JACC(72,70) = JACC(72,70)+DW(90,70)
      SAVE564 = JACC(72,62)
      JACC(72,62) = JACC(72,62)+DW(90,62)
      SAVE565 = JACC(52,66)
      JACC(52,66) = JACC(52,66)+DW(91,66)
      SAVE566 = JACC(52,68)
      JACC(52,68) = JACC(52,68)+DW(91,68)
      SAVE567 = JACC(55,66)
      JACC(55,66) = JACC(55,66)+DW(91,66)
      SAVE568 = JACC(55,68)
      JACC(55,68) = JACC(55,68)+DW(91,68)
      SAVE569 = JACC(66,66)
      JACC(66,66) = JACC(66,66)-DW(91,66)
      SAVE570 = JACC(66,68)
      JACC(66,68) = JACC(66,68)-DW(91,68)
      SAVE571 = JACC(68,66)
      JACC(68,66) = JACC(68,66)-DW(91,66)
      SAVE572 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(91,68)
      SAVE573 = JACC(71,66)
      JACC(71,66) = JACC(71,66)+DW(91,66)
      SAVE574 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(91,68)
      SAVE575 = JACC(55,61)
      JACC(55,61) = JACC(55,61)+DW(92,61)
      SAVE576 = JACC(55,68)
      JACC(55,68) = JACC(55,68)+DW(92,68)
      SAVE577 = JACC(61,61)
      JACC(61,61) = JACC(61,61)-DW(92,61)
      SAVE578 = JACC(61,68)
      JACC(61,68) = JACC(61,68)-DW(92,68)
      SAVE579 = JACC(68,61)
      JACC(68,61) = JACC(68,61)-DW(92,61)
      SAVE580 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(92,68)
      SAVE581 = JACC(69,61)
      JACC(69,61) = JACC(69,61)+DW(92,61)
      SAVE582 = JACC(69,68)
      JACC(69,68) = JACC(69,68)+DW(92,68)
      SAVE583 = JACC(51,51)
      JACC(51,51) = JACC(51,51)-DW(93,51)
      SAVE584 = JACC(51,68)
      JACC(51,68) = JACC(51,68)-DW(93,68)
      SAVE585 = JACC(52,51)
      JACC(52,51) = JACC(52,51)+0.2000000000000000d+01*DW(93,51)
      SAVE586 = JACC(52,68)
      JACC(52,68) = JACC(52,68)+0.2000000000000000d+01*DW(93,68)
      SAVE587 = JACC(55,51)
      JACC(55,51) = JACC(55,51)+DW(93,51)
      SAVE588 = JACC(55,68)
      JACC(55,68) = JACC(55,68)+DW(93,68)
      SAVE589 = JACC(68,51)
      JACC(68,51) = JACC(68,51)-DW(93,51)
      SAVE590 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(93,68)
      SAVE591 = JACC(71,51)
      JACC(71,51) = JACC(71,51)+DW(93,51)
      SAVE592 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(93,68)
      SAVE593 = JACC(52,54)
      JACC(52,54) = JACC(52,54)+DW(94,54)
      SAVE594 = JACC(52,68)
      JACC(52,68) = JACC(52,68)+DW(94,68)
      SAVE595 = JACC(54,54)
      JACC(54,54) = JACC(54,54)-DW(94,54)
      SAVE596 = JACC(54,68)
      JACC(54,68) = JACC(54,68)-DW(94,68)
      SAVE597 = JACC(55,54)
      JACC(55,54) = JACC(55,54)+DW(94,54)
      SAVE598 = JACC(55,68)
      JACC(55,68) = JACC(55,68)+DW(94,68)
      SAVE599 = JACC(68,54)
      JACC(68,54) = JACC(68,54)-DW(94,54)
      SAVE600 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(94,68)
      SAVE601 = JACC(69,54)
      JACC(69,54) = JACC(69,54)+DW(94,54)
      SAVE602 = JACC(69,68)
      JACC(69,68) = JACC(69,68)+DW(94,68)
      SAVE603 = JACC(47,49)
      JACC(47,49) = JACC(47,49)+0.8000000000000000d+00*DW(95,49)
      SAVE604 = JACC(47,68)
      JACC(47,68) = JACC(47,68)+0.8000000000000000d+00*DW(95,68)
      SAVE605 = JACC(49,49)
      JACC(49,49) = JACC(49,49)-DW(95,49)
      SAVE606 = JACC(49,68)
      JACC(49,68) = JACC(49,68)-DW(95,68)
      SAVE607 = JACC(52,49)
      JACC(52,49) = JACC(52,49)+0.8000000000000000d+00*DW(95,49)
      SAVE608 = JACC(52,68)
      JACC(52,68) = JACC(52,68)+0.8000000000000000d+00*DW(95,68)
      SAVE609 = JACC(55,49)
      JACC(55,49) = JACC(55,49)+0.2000000000000000d+00*DW(95,49)
      SAVE610 = JACC(55,68)
      JACC(55,68) = JACC(55,68)+0.2000000000000000d+00*DW(95,68)
      SAVE611 = JACC(56,49)
      JACC(56,49) = JACC(56,49)+0.2000000000000000d+00*DW(95,49)
      SAVE612 = JACC(56,68)
      JACC(56,68) = JACC(56,68)+0.2000000000000000d+00*DW(95,68)
      SAVE613 = JACC(68,49)
      JACC(68,49) = JACC(68,49)-DW(95,49)
      SAVE614 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(95,68)
      SAVE615 = JACC(48,48)
      JACC(48,48) = JACC(48,48)-DW(96,48)
      SAVE616 = JACC(48,68)
      JACC(48,68) = JACC(48,68)-DW(96,68)
      SAVE617 = JACC(51,48)
      JACC(51,48) = JACC(51,48)+0.2500000000000000d+00*DW(96,48)
      SAVE618 = JACC(51,68)
      JACC(51,68) = JACC(51,68)+0.2500000000000000d+00*DW(96,68)
      SAVE619 = JACC(54,48)
      JACC(54,48) = JACC(54,48)+0.2500000000000000d+00*DW(96,48)
      SAVE620 = JACC(54,68)
      JACC(54,68) = JACC(54,68)+0.2500000000000000d+00*DW(96,68)
      SAVE621 = JACC(55,48)
      JACC(55,48) = JACC(55,48)+0.5000000000000000d+00*DW(96,48)
      SAVE622 = JACC(55,68)
      JACC(55,68) = JACC(55,68)+0.5000000000000000d+00*DW(96,68)
      SAVE623 = JACC(56,48)
      JACC(56,48) = JACC(56,48)+0.5000000000000000d+00*DW(96,48)
      SAVE624 = JACC(56,68)
      JACC(56,68) = JACC(56,68)+0.5000000000000000d+00*DW(96,68)
      SAVE625 = JACC(59,48)
      JACC(59,48) = JACC(59,48)+0.3000000000000000d-01*DW(96,48)
      SAVE626 = JACC(59,68)
      JACC(59,68) = JACC(59,68)+0.3000000000000000d-01*DW(96,68)
      SAVE627 = JACC(61,48)
      JACC(61,48) = JACC(61,48)+0.2500000000000000d+00*DW(96,48)
      SAVE628 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+0.2500000000000000d+00*DW(96,68)
      SAVE629 = JACC(65,48)
      JACC(65,48) = JACC(65,48)+0.5000000000000000d+00*DW(96,48)
      SAVE630 = JACC(65,68)
      JACC(65,68) = JACC(65,68)+0.5000000000000000d+00*DW(96,68)
      SAVE631 = JACC(68,48)
      JACC(68,48) = JACC(68,48)-DW(96,48)
      SAVE632 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(96,68)
      SAVE633 = JACC(71,48)
      JACC(71,48) = JACC(71,48)+0.5000000000000000d+00*DW(96,48)
      SAVE634 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+0.5000000000000000d+00*DW(96,68)
      SAVE635 = JACC(72,48)
      JACC(72,48) = JACC(72,48)+0.5000000000000000d+00*DW(96,48)
      SAVE636 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+0.5000000000000000d+00*DW(96,68)
      SAVE637 = JACC(29,30)
      JACC(29,30) = JACC(29,30)+DW(97,30)
      SAVE638 = JACC(29,68)
      JACC(29,68) = JACC(29,68)+DW(97,68)
      SAVE639 = JACC(30,30)
      JACC(30,30) = JACC(30,30)-DW(97,30)
      SAVE640 = JACC(30,68)
      JACC(30,68) = JACC(30,68)-DW(97,68)
      SAVE641 = JACC(55,30)
      JACC(55,30) = JACC(55,30)+DW(97,30)
      SAVE642 = JACC(55,68)
      JACC(55,68) = JACC(55,68)+DW(97,68)
      SAVE643 = JACC(68,30)
      JACC(68,30) = JACC(68,30)-DW(97,30)
      SAVE644 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(97,68)
      SAVE645 = JACC(11,11)
      JACC(11,11) = JACC(11,11)-DW(98,11)
      SAVE646 = JACC(11,68)
      JACC(11,68) = JACC(11,68)-DW(98,68)
      SAVE647 = JACC(46,11)
      JACC(46,11) = JACC(46,11)+0.2000000000000000d+00*DW(98,11)
      SAVE648 = JACC(46,68)
      JACC(46,68) = JACC(46,68)+0.2000000000000000d+00*DW(98,68)
      SAVE649 = JACC(47,11)
      JACC(47,11) = JACC(47,11)+0.8000000000000000d+00*DW(98,11)
      SAVE650 = JACC(47,68)
      JACC(47,68) = JACC(47,68)+0.8000000000000000d+00*DW(98,68)
      SAVE651 = JACC(68,11)
      JACC(68,11) = JACC(68,11)-DW(98,11)
      SAVE652 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(98,68)
      SAVE653 = JACC(40,40)
      JACC(40,40) = JACC(40,40)-DW(99,40)
      SAVE654 = JACC(40,68)
      JACC(40,68) = JACC(40,68)-DW(99,68)
      SAVE655 = JACC(46,40)
      JACC(46,40) = JACC(46,40)+0.5700000000000000d+00*DW(99,40)
      SAVE656 = JACC(46,68)
      JACC(46,68) = JACC(46,68)+0.5700000000000000d+00*DW(99,68)
      SAVE657 = JACC(47,40)
      JACC(47,40) = JACC(47,40)+0.4300000000000000d+00*DW(99,40)
      SAVE658 = JACC(47,68)
      JACC(47,68) = JACC(47,68)+0.4300000000000000d+00*DW(99,68)
      SAVE659 = JACC(68,40)
      JACC(68,40) = JACC(68,40)-DW(99,40)
      SAVE660 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(99,68)
      SAVE661 = JACC(44,44)
      JACC(44,44) = JACC(44,44)-DW(100,44)
      SAVE662 = JACC(44,68)
      JACC(44,68) = JACC(44,68)-DW(100,68)
      SAVE663 = JACC(46,44)
      JACC(46,44) = JACC(46,44)+0.8900000000000000d+00*DW(100,44)
      SAVE664 = JACC(46,68)
      JACC(46,68) = JACC(46,68)+0.8900000000000000d+00*DW(100,68)
      SAVE665 = JACC(47,44)
      JACC(47,44) = JACC(47,44)+0.1100000000000000d+00*DW(100,44)
      SAVE666 = JACC(47,68)
      JACC(47,68) = JACC(47,68)+0.1100000000000000d+00*DW(100,68)
      SAVE667 = JACC(68,44)
      JACC(68,44) = JACC(68,44)-DW(100,44)
      SAVE668 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(100,68)
      SAVE669 = JACC(12,12)
      JACC(12,12) = JACC(12,12)-DW(101,12)
      SAVE670 = JACC(12,68)
      JACC(12,68) = JACC(12,68)-DW(101,68)
      SAVE671 = JACC(46,12)
      JACC(46,12) = JACC(46,12)+0.1000000000000000d+00*DW(101,12)
      SAVE672 = JACC(46,68)
      JACC(46,68) = JACC(46,68)+0.1000000000000000d+00*DW(101,68)
      SAVE673 = JACC(47,12)
      JACC(47,12) = JACC(47,12)+0.9000000000000000d+00*DW(101,12)
      SAVE674 = JACC(47,68)
      JACC(47,68) = JACC(47,68)+0.9000000000000000d+00*DW(101,68)
      SAVE675 = JACC(49,12)
      JACC(49,12) = JACC(49,12)+0.9000000000000000d+00*DW(101,12)
      SAVE676 = JACC(49,68)
      JACC(49,68) = JACC(49,68)+0.9000000000000000d+00*DW(101,68)
      SAVE677 = JACC(68,12)
      JACC(68,12) = JACC(68,12)-DW(101,12)
      SAVE678 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(101,68)
      SAVE679 = JACC(19,19)
      JACC(19,19) = JACC(19,19)-DW(102,19)
      SAVE680 = JACC(19,68)
      JACC(19,68) = JACC(19,68)-DW(102,68)
      SAVE681 = JACC(46,19)
      JACC(46,19) = JACC(46,19)+0.1000000000000000d+00*DW(102,19)
      SAVE682 = JACC(46,68)
      JACC(46,68) = JACC(46,68)+0.1000000000000000d+00*DW(102,68)
      SAVE683 = JACC(47,19)
      JACC(47,19) = JACC(47,19)+0.9000000000000000d+00*DW(102,19)
      SAVE684 = JACC(47,68)
      JACC(47,68) = JACC(47,68)+0.9000000000000000d+00*DW(102,68)
      SAVE685 = JACC(49,19)
      JACC(49,19) = JACC(49,19)+0.9000000000000000d+00*DW(102,19)
      SAVE686 = JACC(49,68)
      JACC(49,68) = JACC(49,68)+0.9000000000000000d+00*DW(102,68)
      SAVE687 = JACC(68,19)
      JACC(68,19) = JACC(68,19)-DW(102,19)
      SAVE688 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(102,68)
      SAVE689 = JACC(13,13)
      JACC(13,13) = JACC(13,13)-DW(103,13)
      SAVE690 = JACC(13,68)
      JACC(13,68) = JACC(13,68)-DW(103,68)
      SAVE691 = JACC(46,13)
      JACC(46,13) = JACC(46,13)+0.9000000000000000d+00*DW(103,13)
      SAVE692 = JACC(46,68)
      JACC(46,68) = JACC(46,68)+0.9000000000000000d+00*DW(103,68)
      SAVE693 = JACC(47,13)
      JACC(47,13) = JACC(47,13)+0.1000000000000000d+00*DW(103,13)
      SAVE694 = JACC(47,68)
      JACC(47,68) = JACC(47,68)+0.1000000000000000d+00*DW(103,68)
      SAVE695 = JACC(68,13)
      JACC(68,13) = JACC(68,13)-DW(103,13)
      SAVE696 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(103,68)
      SAVE697 = JACC(14,14)
      JACC(14,14) = JACC(14,14)-DW(104,14)
      SAVE698 = JACC(14,68)
      JACC(14,68) = JACC(14,68)-DW(104,68)
      SAVE699 = JACC(46,14)
      JACC(46,14) = JACC(46,14)+0.8700000000000000d+00*DW(104,14)
      SAVE700 = JACC(46,68)
      JACC(46,68) = JACC(46,68)+0.8700000000000000d+00*DW(104,68)
      SAVE701 = JACC(47,14)
      JACC(47,14) = JACC(47,14)+0.1300000000000000d+00*DW(104,14)
      SAVE702 = JACC(47,68)
      JACC(47,68) = JACC(47,68)+0.1300000000000000d+00*DW(104,68)
      SAVE703 = JACC(68,14)
      JACC(68,14) = JACC(68,14)-DW(104,14)
      SAVE704 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(104,68)
      SAVE705 = JACC(25,25)
      JACC(25,25) = JACC(25,25)-DW(105,25)
      SAVE706 = JACC(25,68)
      JACC(25,68) = JACC(25,68)-DW(105,68)
      SAVE707 = JACC(26,25)
      JACC(26,25) = JACC(26,25)+0.4000000000000000d+00*DW(105,25)
      SAVE708 = JACC(26,68)
      JACC(26,68) = JACC(26,68)+0.4000000000000000d+00*DW(105,68)
      SAVE709 = JACC(65,25)
      JACC(65,25) = JACC(65,25)+DW(105,25)
      SAVE710 = JACC(65,68)
      JACC(65,68) = JACC(65,68)+DW(105,68)
      SAVE711 = JACC(66,25)
      JACC(66,25) = JACC(66,25)+0.4000000000000000d+00*DW(105,25)
      SAVE712 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+0.4000000000000000d+00*DW(105,68)
      SAVE713 = JACC(68,25)
      JACC(68,25) = JACC(68,25)-0.4000000000000000d+00*DW(105,25)
      SAVE714 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-0.4000000000000000d+00*DW(105,68)
      SAVE715 = JACC(70,25)
      JACC(70,25) = JACC(70,25)+0.6000000000000000d+00*DW(105,25)
      SAVE716 = JACC(70,68)
      JACC(70,68) = JACC(70,68)+0.6000000000000000d+00*DW(105,68)
      SAVE717 = JACC(72,25)
      JACC(72,25) = JACC(72,25)+0.4000000000000000d+00*DW(105,25)
      SAVE718 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+0.4000000000000000d+00*DW(105,68)
      SAVE719 = JACC(11,11)
      JACC(11,11) = JACC(11,11)-DW(106,11)
      SAVE720 = JACC(11,50)
      JACC(11,50) = JACC(11,50)-DW(106,50)
      SAVE721 = JACC(34,11)
      JACC(34,11) = JACC(34,11)+0.3700000000000000d+00*DW(106,11)
      SAVE722 = JACC(34,50)
      JACC(34,50) = JACC(34,50)+0.3700000000000000d+00*DW(106,50)
      SAVE723 = JACC(50,11)
      JACC(50,11) = JACC(50,11)-DW(106,11)
      SAVE724 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(106,50)
      SAVE725 = JACC(52,11)
      JACC(52,11) = JACC(52,11)+0.4300000000000000d+00*DW(106,11)
      SAVE726 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.4300000000000000d+00*DW(106,50)
      SAVE727 = JACC(62,11)
      JACC(62,11) = JACC(62,11)+0.1200000000000000d+00*DW(106,11)
      SAVE728 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.1200000000000000d+00*DW(106,50)
      SAVE729 = JACC(66,11)
      JACC(66,11) = JACC(66,11)+DW(106,11)
      SAVE730 = JACC(66,50)
      JACC(66,50) = JACC(66,50)+DW(106,50)
      SAVE731 = JACC(71,11)
      JACC(71,11) = JACC(71,11)+0.2600000000000000d+00*DW(106,11)
      SAVE732 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.2600000000000000d+00*DW(106,50)
      SAVE733 = JACC(20,40)
      JACC(20,40) = JACC(20,40)+0.6000000000000000d-01*DW(107,40)
      SAVE734 = JACC(20,50)
      JACC(20,50) = JACC(20,50)+0.6000000000000000d-01*DW(107,50)
      SAVE735 = JACC(21,40)
      JACC(21,40) = JACC(21,40)+0.3000000000000000d-01*DW(107,40)
      SAVE736 = JACC(21,50)
      JACC(21,50) = JACC(21,50)+0.3000000000000000d-01*DW(107,50)
      SAVE737 = JACC(27,40)
      JACC(27,40) = JACC(27,40)+0.6000000000000000d-02*DW(107,40)
      SAVE738 = JACC(27,50)
      JACC(27,50) = JACC(27,50)+0.6000000000000000d-02*DW(107,50)
      SAVE739 = JACC(34,40)
      JACC(34,40) = JACC(34,40)+0.1400000000000000d+00*DW(107,40)
      SAVE740 = JACC(34,50)
      JACC(34,50) = JACC(34,50)+0.1400000000000000d+00*DW(107,50)
      SAVE741 = JACC(40,40)
      JACC(40,40) = JACC(40,40)-DW(107,40)
      SAVE742 = JACC(40,50)
      JACC(40,50) = JACC(40,50)-DW(107,50)
      SAVE743 = JACC(50,40)
      JACC(50,40) = JACC(50,40)-DW(107,40)
      SAVE744 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(107,50)
      SAVE745 = JACC(52,40)
      JACC(52,40) = JACC(52,40)+0.3700000000000000d+00*DW(107,40)
      SAVE746 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.3700000000000000d+00*DW(107,50)
      SAVE747 = JACC(57,40)
      JACC(57,40) = JACC(57,40)+0.1000000000000000d+00*DW(107,40)
      SAVE748 = JACC(57,50)
      JACC(57,50) = JACC(57,50)+0.1000000000000000d+00*DW(107,50)
      SAVE749 = JACC(58,40)
      JACC(58,40) = JACC(58,40)+0.3000000000000000d-01*DW(107,40)
      SAVE750 = JACC(58,50)
      JACC(58,50) = JACC(58,50)+0.3000000000000000d-01*DW(107,50)
      SAVE751 = JACC(59,40)
      JACC(59,40) = JACC(59,40)+0.3000000000000000d-01*DW(107,40)
      SAVE752 = JACC(59,50)
      JACC(59,50) = JACC(59,50)+0.3000000000000000d-01*DW(107,50)
      SAVE753 = JACC(60,40)
      JACC(60,40) = JACC(60,40)+0.1000000000000000d+00*DW(107,40)
      SAVE754 = JACC(60,50)
      JACC(60,50) = JACC(60,50)+0.1000000000000000d+00*DW(107,50)
      SAVE755 = JACC(61,40)
      JACC(61,40) = JACC(61,40)+0.4400000000000000d+00*DW(107,40)
      SAVE756 = JACC(61,50)
      JACC(61,50) = JACC(61,50)+0.4400000000000000d+00*DW(107,50)
      SAVE757 = JACC(62,40)
      JACC(62,40) = JACC(62,40)+0.4000000000000000d+00*DW(107,40)
      SAVE758 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.4000000000000000d+00*DW(107,50)
      SAVE759 = JACC(63,40)
      JACC(63,40) = JACC(63,40)+0.1900000000000000d+00*DW(107,40)
      SAVE760 = JACC(63,50)
      JACC(63,50) = JACC(63,50)+0.1900000000000000d+00*DW(107,50)
      SAVE761 = JACC(66,40)
      JACC(66,40) = JACC(66,40)+0.6400000000000000d+00*DW(107,40)
      SAVE762 = JACC(66,50)
      JACC(66,50) = JACC(66,50)+0.6400000000000000d+00*DW(107,50)
      SAVE763 = JACC(71,40)
      JACC(71,40) = JACC(71,40)+0.2500000000000000d+00*DW(107,40)
      SAVE764 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.2500000000000000d+00*DW(107,50)
      SAVE765 = JACC(20,44)
      JACC(20,44) = JACC(20,44)+0.7000000000000001d-01*DW(108,44)
      SAVE766 = JACC(20,50)
      JACC(20,50) = JACC(20,50)+0.7000000000000001d-01*DW(108,50)
      SAVE767 = JACC(21,44)
      JACC(21,44) = JACC(21,44)+0.6000000000000000d-01*DW(108,44)
      SAVE768 = JACC(21,50)
      JACC(21,50) = JACC(21,50)+0.6000000000000000d-01*DW(108,50)
      SAVE769 = JACC(27,44)
      JACC(27,44) = JACC(27,44)+0.1100000000000000d-01*DW(108,44)
      SAVE770 = JACC(27,50)
      JACC(27,50) = JACC(27,50)+0.1100000000000000d-01*DW(108,50)
      SAVE771 = JACC(44,44)
      JACC(44,44) = JACC(44,44)-DW(108,44)
      SAVE772 = JACC(44,50)
      JACC(44,50) = JACC(44,50)-DW(108,50)
      SAVE773 = JACC(50,44)
      JACC(50,44) = JACC(50,44)-DW(108,44)
      SAVE774 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(108,50)
      SAVE775 = JACC(52,44)
      JACC(52,44) = JACC(52,44)+0.3000000000000000d+00*DW(108,44)
      SAVE776 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.3000000000000000d+00*DW(108,50)
      SAVE777 = JACC(57,44)
      JACC(57,44) = JACC(57,44)+0.1400000000000000d+00*DW(108,44)
      SAVE778 = JACC(57,50)
      JACC(57,50) = JACC(57,50)+0.1400000000000000d+00*DW(108,50)
      SAVE779 = JACC(58,44)
      JACC(58,44) = JACC(58,44)+0.1200000000000000d+00*DW(108,44)
      SAVE780 = JACC(58,50)
      JACC(58,50) = JACC(58,50)+0.1200000000000000d+00*DW(108,50)
      SAVE781 = JACC(59,44)
      JACC(59,44) = JACC(59,44)+0.1600000000000000d+00*DW(108,44)
      SAVE782 = JACC(59,50)
      JACC(59,50) = JACC(59,50)+0.1600000000000000d+00*DW(108,50)
      SAVE783 = JACC(60,44)
      JACC(60,44) = JACC(60,44)+0.1800000000000000d+00*DW(108,44)
      SAVE784 = JACC(60,50)
      JACC(60,50) = JACC(60,50)+0.1800000000000000d+00*DW(108,50)
      SAVE785 = JACC(61,44)
      JACC(61,44) = JACC(61,44)+0.9900000000000000d+00*DW(108,44)
      SAVE786 = JACC(61,50)
      JACC(61,50) = JACC(61,50)+0.9900000000000000d+00*DW(108,50)
      SAVE787 = JACC(62,44)
      JACC(62,44) = JACC(62,44)+0.6300000000000000d+00*DW(108,44)
      SAVE788 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.6300000000000000d+00*DW(108,50)
      SAVE789 = JACC(63,44)
      JACC(63,44) = JACC(63,44)+0.2300000000000000d+00*DW(108,44)
      SAVE790 = JACC(63,50)
      JACC(63,50) = JACC(63,50)+0.2300000000000000d+00*DW(108,50)
      SAVE791 = JACC(66,44)
      JACC(66,44) = JACC(66,44)+0.2000000000000000d-01*DW(108,44)
      SAVE792 = JACC(66,50)
      JACC(66,50) = JACC(66,50)+0.2000000000000000d-01*DW(108,50)
      SAVE793 = JACC(71,44)
      JACC(71,44) = JACC(71,44)+0.2200000000000000d+00*DW(108,44)
      SAVE794 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.2200000000000000d+00*DW(108,50)
      SAVE795 = JACC(12,12)
      JACC(12,12) = JACC(12,12)-DW(109,12)
      SAVE796 = JACC(12,50)
      JACC(12,50) = JACC(12,50)-DW(109,50)
      SAVE797 = JACC(27,12)
      JACC(27,12) = JACC(27,12)+0.1000000000000000d-02*DW(109,12)
      SAVE798 = JACC(27,50)
      JACC(27,50) = JACC(27,50)+0.1000000000000000d-02*DW(109,50)
      SAVE799 = JACC(34,12)
      JACC(34,12) = JACC(34,12)+0.1500000000000000d+00*DW(109,12)
      SAVE800 = JACC(34,50)
      JACC(34,50) = JACC(34,50)+0.1500000000000000d+00*DW(109,50)
      SAVE801 = JACC(35,12)
      JACC(35,12) = JACC(35,12)+0.9000000000000000d-01*DW(109,12)
      SAVE802 = JACC(35,50)
      JACC(35,50) = JACC(35,50)+0.9000000000000000d-01*DW(109,50)
      SAVE803 = JACC(40,12)
      JACC(40,12) = JACC(40,12)+0.3500000000000000d+00*DW(109,12)
      SAVE804 = JACC(40,50)
      JACC(40,50) = JACC(40,50)+0.3500000000000000d+00*DW(109,50)
      SAVE805 = JACC(49,12)
      JACC(49,12) = JACC(49,12)+0.3900000000000000d+00*DW(109,12)
      SAVE806 = JACC(49,50)
      JACC(49,50) = JACC(49,50)+0.3900000000000000d+00*DW(109,50)
      SAVE807 = JACC(50,12)
      JACC(50,12) = JACC(50,12)-DW(109,12)
      SAVE808 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(109,50)
      SAVE809 = JACC(52,12)
      JACC(52,12) = JACC(52,12)+0.3600000000000000d+00*DW(109,12)
      SAVE810 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.3600000000000000d+00*DW(109,50)
      SAVE811 = JACC(58,12)
      JACC(58,12) = JACC(58,12)+0.2000000000000000d-01*DW(109,12)
      SAVE812 = JACC(58,50)
      JACC(58,50) = JACC(58,50)+0.2000000000000000d-01*DW(109,50)
      SAVE813 = JACC(62,12)
      JACC(62,12) = JACC(62,12)+0.2800000000000000d+00*DW(109,12)
      SAVE814 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.2800000000000000d+00*DW(109,50)
      SAVE815 = JACC(63,12)
      JACC(63,12) = JACC(63,12)+0.3000000000000000d-01*DW(109,12)
      SAVE816 = JACC(63,50)
      JACC(63,50) = JACC(63,50)+0.3000000000000000d-01*DW(109,50)
      SAVE817 = JACC(65,12)
      JACC(65,12) = JACC(65,12)+0.1300000000000000d+00*DW(109,12)
      SAVE818 = JACC(65,50)
      JACC(65,50) = JACC(65,50)+0.1300000000000000d+00*DW(109,50)
      SAVE819 = JACC(66,12)
      JACC(66,12) = JACC(66,12)+0.9000000000000000d+00*DW(109,12)
      SAVE820 = JACC(66,50)
      JACC(66,50) = JACC(66,50)+0.9000000000000000d+00*DW(109,50)
      SAVE821 = JACC(69,12)
      JACC(69,12) = JACC(69,12)+0.1500000000000000d+00*DW(109,12)
      SAVE822 = JACC(69,50)
      JACC(69,50) = JACC(69,50)+0.1500000000000000d+00*DW(109,50)
      SAVE823 = JACC(71,12)
      JACC(71,12) = JACC(71,12)+0.3000000000000000d+00*DW(109,12)
      SAVE824 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.3000000000000000d+00*DW(109,50)
      SAVE825 = JACC(19,19)
      JACC(19,19) = JACC(19,19)-DW(110,19)
      SAVE826 = JACC(19,50)
      JACC(19,50) = JACC(19,50)-DW(110,50)
      SAVE827 = JACC(27,19)
      JACC(27,19) = JACC(27,19)+0.1000000000000000d-02*DW(110,19)
      SAVE828 = JACC(27,50)
      JACC(27,50) = JACC(27,50)+0.1000000000000000d-02*DW(110,50)
      SAVE829 = JACC(34,19)
      JACC(34,19) = JACC(34,19)+0.1500000000000000d+00*DW(110,19)
      SAVE830 = JACC(34,50)
      JACC(34,50) = JACC(34,50)+0.1500000000000000d+00*DW(110,50)
      SAVE831 = JACC(35,19)
      JACC(35,19) = JACC(35,19)+0.9000000000000000d-01*DW(110,19)
      SAVE832 = JACC(35,50)
      JACC(35,50) = JACC(35,50)+0.9000000000000000d-01*DW(110,50)
      SAVE833 = JACC(40,19)
      JACC(40,19) = JACC(40,19)+0.3500000000000000d+00*DW(110,19)
      SAVE834 = JACC(40,50)
      JACC(40,50) = JACC(40,50)+0.3500000000000000d+00*DW(110,50)
      SAVE835 = JACC(49,19)
      JACC(49,19) = JACC(49,19)+0.3900000000000000d+00*DW(110,19)
      SAVE836 = JACC(49,50)
      JACC(49,50) = JACC(49,50)+0.3900000000000000d+00*DW(110,50)
      SAVE837 = JACC(50,19)
      JACC(50,19) = JACC(50,19)-DW(110,19)
      SAVE838 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(110,50)
      SAVE839 = JACC(52,19)
      JACC(52,19) = JACC(52,19)+0.3600000000000000d+00*DW(110,19)
      SAVE840 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.3600000000000000d+00*DW(110,50)
      SAVE841 = JACC(58,19)
      JACC(58,19) = JACC(58,19)+0.2000000000000000d-01*DW(110,19)
      SAVE842 = JACC(58,50)
      JACC(58,50) = JACC(58,50)+0.2000000000000000d-01*DW(110,50)
      SAVE843 = JACC(62,19)
      JACC(62,19) = JACC(62,19)+0.2800000000000000d+00*DW(110,19)
      SAVE844 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.2800000000000000d+00*DW(110,50)
      SAVE845 = JACC(63,19)
      JACC(63,19) = JACC(63,19)+0.3000000000000000d-01*DW(110,19)
      SAVE846 = JACC(63,50)
      JACC(63,50) = JACC(63,50)+0.3000000000000000d-01*DW(110,50)
      SAVE847 = JACC(65,19)
      JACC(65,19) = JACC(65,19)+0.1300000000000000d+00*DW(110,19)
      SAVE848 = JACC(65,50)
      JACC(65,50) = JACC(65,50)+0.1300000000000000d+00*DW(110,50)
      SAVE849 = JACC(66,19)
      JACC(66,19) = JACC(66,19)+0.9000000000000000d+00*DW(110,19)
      SAVE850 = JACC(66,50)
      JACC(66,50) = JACC(66,50)+0.9000000000000000d+00*DW(110,50)
      SAVE851 = JACC(69,19)
      JACC(69,19) = JACC(69,19)+0.1500000000000000d+00*DW(110,19)
      SAVE852 = JACC(69,50)
      JACC(69,50) = JACC(69,50)+0.1500000000000000d+00*DW(110,50)
      SAVE853 = JACC(71,19)
      JACC(71,19) = JACC(71,19)+0.3000000000000000d+00*DW(110,19)
      SAVE854 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.3000000000000000d+00*DW(110,50)
      SAVE855 = JACC(13,13)
      JACC(13,13) = JACC(13,13)-DW(111,13)
      SAVE856 = JACC(13,50)
      JACC(13,50) = JACC(13,50)-DW(111,50)
      SAVE857 = JACC(27,13)
      JACC(27,13) = JACC(27,13)+0.2000000000000000d-01*DW(111,13)
      SAVE858 = JACC(27,50)
      JACC(27,50) = JACC(27,50)+0.2000000000000000d-01*DW(111,50)
      SAVE859 = JACC(50,13)
      JACC(50,13) = JACC(50,13)-DW(111,13)
      SAVE860 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(111,50)
      SAVE861 = JACC(52,13)
      JACC(52,13) = JACC(52,13)+0.1400000000000000d+00*DW(111,13)
      SAVE862 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.1400000000000000d+00*DW(111,50)
      SAVE863 = JACC(58,13)
      JACC(58,13) = JACC(58,13)+0.4200000000000000d+00*DW(111,13)
      SAVE864 = JACC(58,50)
      JACC(58,50) = JACC(58,50)+0.4200000000000000d+00*DW(111,50)
      SAVE865 = JACC(59,13)
      JACC(59,13) = JACC(59,13)+0.5300000000000000d+00*DW(111,13)
      SAVE866 = JACC(59,50)
      JACC(59,50) = JACC(59,50)+0.5300000000000000d+00*DW(111,50)
      SAVE867 = JACC(60,13)
      JACC(60,13) = JACC(60,13)+0.2000000000000000d+00*DW(111,13)
      SAVE868 = JACC(60,50)
      JACC(60,50) = JACC(60,50)+0.2000000000000000d+00*DW(111,50)
      SAVE869 = JACC(61,13)
      JACC(61,13) = JACC(61,13)+0.6500000000000000d+00*DW(111,13)
      SAVE870 = JACC(61,50)
      JACC(61,50) = JACC(61,50)+0.6500000000000000d+00*DW(111,50)
      SAVE871 = JACC(62,13)
      JACC(62,13) = JACC(62,13)+0.8500000000000000d+00*DW(111,13)
      SAVE872 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.8500000000000000d+00*DW(111,50)
      SAVE873 = JACC(71,13)
      JACC(71,13) = JACC(71,13)+0.1000000000000000d+00*DW(111,13)
      SAVE874 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.1000000000000000d+00*DW(111,50)
      SAVE875 = JACC(14,14)
      JACC(14,14) = JACC(14,14)-DW(112,14)
      SAVE876 = JACC(14,50)
      JACC(14,50) = JACC(14,50)-DW(112,50)
      SAVE877 = JACC(27,14)
      JACC(27,14) = JACC(27,14)+0.2000000000000000d-01*DW(112,14)
      SAVE878 = JACC(27,50)
      JACC(27,50) = JACC(27,50)+0.2000000000000000d-01*DW(112,50)
      SAVE879 = JACC(34,14)
      JACC(34,14) = JACC(34,14)+0.1000000000000000d-01*DW(112,14)
      SAVE880 = JACC(34,50)
      JACC(34,50) = JACC(34,50)+0.1000000000000000d-01*DW(112,50)
      SAVE881 = JACC(40,14)
      JACC(40,14) = JACC(40,14)+0.4600000000000000d+00*DW(112,14)
      SAVE882 = JACC(40,50)
      JACC(40,50) = JACC(40,50)+0.4600000000000000d+00*DW(112,50)
      SAVE883 = JACC(49,14)
      JACC(49,14) = JACC(49,14)+0.7900000000000000d+00*DW(112,14)
      SAVE884 = JACC(49,50)
      JACC(49,50) = JACC(49,50)+0.7900000000000000d+00*DW(112,50)
      SAVE885 = JACC(50,14)
      JACC(50,14) = JACC(50,14)-DW(112,14)
      SAVE886 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(112,50)
      SAVE887 = JACC(52,14)
      JACC(52,14) = JACC(52,14)+0.1400000000000000d+00*DW(112,14)
      SAVE888 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.1400000000000000d+00*DW(112,50)
      SAVE889 = JACC(57,14)
      JACC(57,14) = JACC(57,14)+0.7000000000000001d-01*DW(112,14)
      SAVE890 = JACC(57,50)
      JACC(57,50) = JACC(57,50)+0.7000000000000001d-01*DW(112,50)
      SAVE891 = JACC(58,14)
      JACC(58,14) = JACC(58,14)+0.4200000000000000d+00*DW(112,14)
      SAVE892 = JACC(58,50)
      JACC(58,50) = JACC(58,50)+0.4200000000000000d+00*DW(112,50)
      SAVE893 = JACC(60,14)
      JACC(60,14) = JACC(60,14)+0.1600000000000000d+00*DW(112,14)
      SAVE894 = JACC(60,50)
      JACC(60,50) = JACC(60,50)+0.1600000000000000d+00*DW(112,50)
      SAVE895 = JACC(62,14)
      JACC(62,14) = JACC(62,14)+0.8500000000000000d+00*DW(112,14)
      SAVE896 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.8500000000000000d+00*DW(112,50)
      SAVE897 = JACC(66,14)
      JACC(66,14) = JACC(66,14)+0.4000000000000000d-01*DW(112,14)
      SAVE898 = JACC(66,50)
      JACC(66,50) = JACC(66,50)+0.4000000000000000d-01*DW(112,50)
      SAVE899 = JACC(71,14)
      JACC(71,14) = JACC(71,14)+0.1000000000000000d+00*DW(112,14)
      SAVE900 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.1000000000000000d+00*DW(112,50)
      SAVE901 = JACC(34,49)
      JACC(34,49) = JACC(34,49)+0.2200000000000000d+00*DW(113,49)
      SAVE902 = JACC(34,50)
      JACC(34,50) = JACC(34,50)+0.2200000000000000d+00*DW(113,50)
      SAVE903 = JACC(49,49)
      JACC(49,49) = JACC(49,49)-DW(113,49)
      SAVE904 = JACC(49,50)
      JACC(49,50) = JACC(49,50)-DW(113,50)
      SAVE905 = JACC(50,49)
      JACC(50,49) = JACC(50,49)-DW(113,49)
      SAVE906 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(113,50)
      SAVE907 = JACC(52,49)
      JACC(52,49) = JACC(52,49)+0.5400000000000000d+00*DW(113,49)
      SAVE908 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.5400000000000000d+00*DW(113,50)
      SAVE909 = JACC(53,49)
      JACC(53,49) = JACC(53,49)+0.1300000000000000d+00*DW(113,49)
      SAVE910 = JACC(53,50)
      JACC(53,50) = JACC(53,50)+0.1300000000000000d+00*DW(113,50)
      SAVE911 = JACC(54,49)
      JACC(54,49) = JACC(54,49)+0.6000000000000000d+00*DW(113,49)
      SAVE912 = JACC(54,50)
      JACC(54,50) = JACC(54,50)+0.6000000000000000d+00*DW(113,50)
      SAVE913 = JACC(57,49)
      JACC(57,49) = JACC(57,49)+0.1300000000000000d+00*DW(113,49)
      SAVE914 = JACC(57,50)
      JACC(57,50) = JACC(57,50)+0.1300000000000000d+00*DW(113,50)
      SAVE915 = JACC(62,49)
      JACC(62,49) = JACC(62,49)+0.7000000000000001d-01*DW(113,49)
      SAVE916 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.7000000000000001d-01*DW(113,50)
      SAVE917 = JACC(66,49)
      JACC(66,49) = JACC(66,49)+0.4000000000000000d+00*DW(113,49)
      SAVE918 = JACC(66,50)
      JACC(66,50) = JACC(66,50)+0.4000000000000000d+00*DW(113,50)
      SAVE919 = JACC(69,49)
      JACC(69,49) = JACC(69,49)+0.1300000000000000d+00*DW(113,49)
      SAVE920 = JACC(69,50)
      JACC(69,50) = JACC(69,50)+0.1300000000000000d+00*DW(113,50)
      SAVE921 = JACC(71,49)
      JACC(71,49) = JACC(71,49)+0.2900000000000000d+00*DW(113,49)
      SAVE922 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.2900000000000000d+00*DW(113,50)
      SAVE923 = JACC(28,48)
      JACC(28,48) = JACC(28,48)+0.1100000000000000d+00*DW(114,48)
      SAVE924 = JACC(28,50)
      JACC(28,50) = JACC(28,50)+0.1100000000000000d+00*DW(114,50)
      SAVE925 = JACC(34,48)
      JACC(34,48) = JACC(34,48)+0.1100000000000000d+00*DW(114,48)
      SAVE926 = JACC(34,50)
      JACC(34,50) = JACC(34,50)+0.1100000000000000d+00*DW(114,50)
      SAVE927 = JACC(48,48)
      JACC(48,48) = JACC(48,48)-DW(114,48)
      SAVE928 = JACC(48,50)
      JACC(48,50) = JACC(48,50)-DW(114,50)
      SAVE929 = JACC(50,48)
      JACC(50,48) = JACC(50,48)-DW(114,48)
      SAVE930 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(114,50)
      SAVE931 = JACC(51,48)
      JACC(51,48) = JACC(51,48)+0.5000000000000000d+00*DW(114,48)
      SAVE932 = JACC(51,50)
      JACC(51,50) = JACC(51,50)+0.5000000000000000d+00*DW(114,50)
      SAVE933 = JACC(52,48)
      JACC(52,48) = JACC(52,48)+0.6600000000000000d+00*DW(114,48)
      SAVE934 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.6600000000000000d+00*DW(114,50)
      SAVE935 = JACC(54,48)
      JACC(54,48) = JACC(54,48)+0.6200000000000000d+00*DW(114,48)
      SAVE936 = JACC(54,50)
      JACC(54,50) = JACC(54,50)+0.6200000000000000d+00*DW(114,50)
      SAVE937 = JACC(57,48)
      JACC(57,48) = JACC(57,48)+0.2100000000000000d+00*DW(114,48)
      SAVE938 = JACC(57,50)
      JACC(57,50) = JACC(57,50)+0.2100000000000000d+00*DW(114,50)
      SAVE939 = JACC(61,48)
      JACC(61,48) = JACC(61,48)+0.1600000000000000d+00*DW(114,48)
      SAVE940 = JACC(61,50)
      JACC(61,50) = JACC(61,50)+0.1600000000000000d+00*DW(114,50)
      SAVE941 = JACC(62,48)
      JACC(62,48) = JACC(62,48)+0.2100000000000000d+00*DW(114,48)
      SAVE942 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.2100000000000000d+00*DW(114,50)
      SAVE943 = JACC(69,48)
      JACC(69,48) = JACC(69,48)+0.2800000000000000d+00*DW(114,48)
      SAVE944 = JACC(69,50)
      JACC(69,50) = JACC(69,50)+0.2800000000000000d+00*DW(114,50)
      SAVE945 = JACC(71,48)
      JACC(71,48) = JACC(71,48)+0.2900000000000000d+00*DW(114,48)
      SAVE946 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.2900000000000000d+00*DW(114,50)
      SAVE947 = JACC(25,25)
      JACC(25,25) = JACC(25,25)-DW(115,25)
      SAVE948 = JACC(25,50)
      JACC(25,50) = JACC(25,50)-DW(115,50)
      SAVE949 = JACC(26,25)
      JACC(26,25) = JACC(26,25)+0.3000000000000000d+00*DW(115,25)
      SAVE950 = JACC(26,50)
      JACC(26,50) = JACC(26,50)+0.3000000000000000d+00*DW(115,50)
      SAVE951 = JACC(34,25)
      JACC(34,25) = JACC(34,25)+0.1100000000000000d+00*DW(115,25)
      SAVE952 = JACC(34,50)
      JACC(34,50) = JACC(34,50)+0.1100000000000000d+00*DW(115,50)
      SAVE953 = JACC(50,25)
      JACC(50,25) = JACC(50,25)-DW(115,25)
      SAVE954 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(115,50)
      SAVE955 = JACC(52,25)
      JACC(52,25) = JACC(52,25)+0.1300000000000000d+00*DW(115,25)
      SAVE956 = JACC(52,50)
      JACC(52,50) = JACC(52,50)+0.1300000000000000d+00*DW(115,50)
      SAVE957 = JACC(62,25)
      JACC(62,25) = JACC(62,25)+0.3600000000000000d-01*DW(115,25)
      SAVE958 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+0.3600000000000000d-01*DW(115,50)
      SAVE959 = JACC(66,25)
      JACC(66,25) = JACC(66,25)+0.7000000000000000d+00*DW(115,25)
      SAVE960 = JACC(66,50)
      JACC(66,50) = JACC(66,50)+0.7000000000000000d+00*DW(115,50)
      SAVE961 = JACC(69,25)
      JACC(69,25) = JACC(69,25)+0.7000000000000000d+00*DW(115,25)
      SAVE962 = JACC(69,50)
      JACC(69,50) = JACC(69,50)+0.7000000000000000d+00*DW(115,50)
      SAVE963 = JACC(71,25)
      JACC(71,25) = JACC(71,25)+0.8000000000000000d-01*DW(115,25)
      SAVE964 = JACC(71,50)
      JACC(71,50) = JACC(71,50)+0.8000000000000000d-01*DW(115,50)
      SAVE965 = JACC(72,25)
      JACC(72,25) = JACC(72,25)+0.7000000000000000d+00*DW(115,25)
      SAVE966 = JACC(72,50)
      JACC(72,50) = JACC(72,50)+0.7000000000000000d+00*DW(115,50)
      SAVE967 = JACC(29,29)
      JACC(29,29) = JACC(29,29)-DW(116,29)
      SAVE968 = JACC(29,72)
      JACC(29,72) = JACC(29,72)-DW(116,72)
      SAVE969 = JACC(30,29)
      JACC(30,29) = JACC(30,29)+0.1000000000000000d+00*DW(116,29)
      SAVE970 = JACC(30,72)
      JACC(30,72) = JACC(30,72)+0.1000000000000000d+00*DW(116,72)
      SAVE971 = JACC(70,29)
      JACC(70,29) = JACC(70,29)+DW(116,29)
      SAVE972 = JACC(70,72)
      JACC(70,72) = JACC(70,72)+DW(116,72)
      SAVE973 = JACC(72,29)
      JACC(72,29) = JACC(72,29)-DW(116,29)
      SAVE974 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(116,72)
      SAVE975 = JACC(29,29)
      JACC(29,29) = JACC(29,29)-DW(117,29)
      SAVE976 = JACC(29,71)
      JACC(29,71) = JACC(29,71)-DW(117,71)
      SAVE977 = JACC(30,29)
      JACC(30,29) = JACC(30,29)+DW(117,29)
      SAVE978 = JACC(30,71)
      JACC(30,71) = JACC(30,71)+DW(117,71)
      SAVE979 = JACC(71,29)
      JACC(71,29) = JACC(71,29)-DW(117,29)
      SAVE980 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(117,71)
      SAVE981 = JACC(17,17)
      JACC(17,17) = JACC(17,17)-DW(118,17)
      SAVE982 = JACC(17,72)
      JACC(17,72) = JACC(17,72)-DW(118,72)
      SAVE983 = JACC(23,17)
      JACC(23,17) = JACC(23,17)+DW(118,17)
      SAVE984 = JACC(23,72)
      JACC(23,72) = JACC(23,72)+DW(118,72)
      SAVE985 = JACC(30,17)
      JACC(30,17) = JACC(30,17)+DW(118,17)
      SAVE986 = JACC(30,72)
      JACC(30,72) = JACC(30,72)+DW(118,72)
      SAVE987 = JACC(72,17)
      JACC(72,17) = JACC(72,17)-DW(118,17)
      SAVE988 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(118,72)
      SAVE989 = JACC(17,17)
      JACC(17,17) = JACC(17,17)-DW(119,17)
      SAVE990 = JACC(30,17)
      JACC(30,17) = JACC(30,17)+0.2000000000000000d-01*DW(119,17)
      SAVE991 = JACC(31,17)
      JACC(31,17) = JACC(31,17)+0.9800000000000000d+00*DW(119,17)
      SAVE992 = JACC(71,17)
      JACC(71,17) = JACC(71,17)+0.2000000000000000d-01*DW(119,17)
      SAVE993 = JACC(17,17)
      JACC(17,17) = JACC(17,17)-DW(120,17)
      SAVE994 = JACC(17,50)
      JACC(17,50) = JACC(17,50)-DW(120,50)
      SAVE995 = JACC(30,17)
      JACC(30,17) = JACC(30,17)+DW(120,17)
      SAVE996 = JACC(30,50)
      JACC(30,50) = JACC(30,50)+DW(120,50)
      SAVE997 = JACC(50,17)
      JACC(50,17) = JACC(50,17)-DW(120,17)
      SAVE998 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(120,50)
      SAVE999 = JACC(62,17)
      JACC(62,17) = JACC(62,17)+DW(120,17)
      SAVE1000 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+DW(120,50)
      SAVE1001 = JACC(18,18)
      JACC(18,18) = JACC(18,18)-DW(121,18)
      SAVE1002 = JACC(18,72)
      JACC(18,72) = JACC(18,72)-DW(121,72)
      SAVE1003 = JACC(23,18)
      JACC(23,18) = JACC(23,18)+DW(121,18)
      SAVE1004 = JACC(23,72)
      JACC(23,72) = JACC(23,72)+DW(121,72)
      SAVE1005 = JACC(30,18)
      JACC(30,18) = JACC(30,18)+DW(121,18)
      SAVE1006 = JACC(30,72)
      JACC(30,72) = JACC(30,72)+DW(121,72)
      SAVE1007 = JACC(72,18)
      JACC(72,18) = JACC(72,18)-DW(121,18)
      SAVE1008 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(121,72)
      SAVE1009 = JACC(18,18)
      JACC(18,18) = JACC(18,18)-DW(122,18)
      SAVE1010 = JACC(30,18)
      JACC(30,18) = JACC(30,18)+0.2000000000000000d-01*DW(122,18)
      SAVE1011 = JACC(32,18)
      JACC(32,18) = JACC(32,18)+0.9800000000000000d+00*DW(122,18)
      SAVE1012 = JACC(71,18)
      JACC(71,18) = JACC(71,18)+0.2000000000000000d-01*DW(122,18)
      SAVE1013 = JACC(18,18)
      JACC(18,18) = JACC(18,18)-DW(123,18)
      SAVE1014 = JACC(18,50)
      JACC(18,50) = JACC(18,50)-DW(123,50)
      SAVE1015 = JACC(30,18)
      JACC(30,18) = JACC(30,18)+DW(123,18)
      SAVE1016 = JACC(30,50)
      JACC(30,50) = JACC(30,50)+DW(123,50)
      SAVE1017 = JACC(50,18)
      JACC(50,18) = JACC(50,18)-DW(123,18)
      SAVE1018 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(123,50)
      SAVE1019 = JACC(62,18)
      JACC(62,18) = JACC(62,18)+DW(123,18)
      SAVE1020 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+DW(123,50)
      SAVE1021 = JACC(22,22)
      JACC(22,22) = JACC(22,22)-DW(124,22)
      SAVE1022 = JACC(22,72)
      JACC(22,72) = JACC(22,72)-DW(124,72)
      SAVE1023 = JACC(23,22)
      JACC(23,22) = JACC(23,22)+DW(124,22)
      SAVE1024 = JACC(23,72)
      JACC(23,72) = JACC(23,72)+DW(124,72)
      SAVE1025 = JACC(30,22)
      JACC(30,22) = JACC(30,22)+DW(124,22)
      SAVE1026 = JACC(30,72)
      JACC(30,72) = JACC(30,72)+DW(124,72)
      SAVE1027 = JACC(72,22)
      JACC(72,22) = JACC(72,22)-DW(124,22)
      SAVE1028 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(124,72)
      SAVE1029 = JACC(22,22)
      JACC(22,22) = JACC(22,22)-DW(125,22)
      SAVE1030 = JACC(30,22)
      JACC(30,22) = JACC(30,22)+0.2000000000000000d-01*DW(125,22)
      SAVE1031 = JACC(33,22)
      JACC(33,22) = JACC(33,22)+0.9800000000000000d+00*DW(125,22)
      SAVE1032 = JACC(71,22)
      JACC(71,22) = JACC(71,22)+0.2000000000000000d-01*DW(125,22)
      SAVE1033 = JACC(22,22)
      JACC(22,22) = JACC(22,22)-DW(126,22)
      SAVE1034 = JACC(22,50)
      JACC(22,50) = JACC(22,50)-DW(126,50)
      SAVE1035 = JACC(30,22)
      JACC(30,22) = JACC(30,22)+DW(126,22)
      SAVE1036 = JACC(30,50)
      JACC(30,50) = JACC(30,50)+DW(126,50)
      SAVE1037 = JACC(50,22)
      JACC(50,22) = JACC(50,22)-DW(126,22)
      SAVE1038 = JACC(50,50)
      JACC(50,50) = JACC(50,50)-DW(126,50)
      SAVE1039 = JACC(62,22)
      JACC(62,22) = JACC(62,22)+DW(126,22)
      SAVE1040 = JACC(62,50)
      JACC(62,50) = JACC(62,50)+DW(126,50)
      SAVE1041 = JACC(26,69)
      JACC(26,69) = JACC(26,69)+DW(127,69)
      SAVE1042 = JACC(26,72)
      JACC(26,72) = JACC(26,72)+DW(127,72)
      SAVE1043 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(127,69)
      SAVE1044 = JACC(69,72)
      JACC(69,72) = JACC(69,72)-DW(127,72)
      SAVE1045 = JACC(72,69)
      JACC(72,69) = JACC(72,69)-DW(127,69)
      SAVE1046 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(127,72)
      SAVE1047 = JACC(26,26)
      JACC(26,26) = JACC(26,26)-DW(128,26)
      SAVE1048 = JACC(69,26)
      JACC(69,26) = JACC(69,26)+DW(128,26)
      SAVE1049 = JACC(72,26)
      JACC(72,26) = JACC(72,26)+DW(128,26)
      SAVE1050 = JACC(25,56)
      JACC(25,56) = JACC(25,56)+DW(129,56)
      SAVE1051 = JACC(25,72)
      JACC(25,72) = JACC(25,72)+DW(129,72)
      SAVE1052 = JACC(56,56)
      JACC(56,56) = JACC(56,56)-DW(129,56)
      SAVE1053 = JACC(56,72)
      JACC(56,72) = JACC(56,72)-DW(129,72)
      SAVE1054 = JACC(72,56)
      JACC(72,56) = JACC(72,56)-DW(129,56)
      SAVE1055 = JACC(72,72)
      JACC(72,72) = JACC(72,72)-DW(129,72)
      SAVE1056 = JACC(25,25)
      JACC(25,25) = JACC(25,25)-DW(130,25)
      SAVE1057 = JACC(56,25)
      JACC(56,25) = JACC(56,25)+DW(130,25)
      SAVE1058 = JACC(72,25)
      JACC(72,25) = JACC(72,25)+DW(130,25)
      SAVE1059 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(131,63)
      SAVE1060 = JACC(63,67)
      JACC(63,67) = JACC(63,67)-DW(131,67)
      SAVE1061 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(131,63)
      SAVE1062 = JACC(66,67)
      JACC(66,67) = JACC(66,67)+DW(131,67)
      SAVE1063 = JACC(67,63)
      JACC(67,63) = JACC(67,63)-DW(131,63)
      SAVE1064 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(131,67)
      SAVE1065 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(131,63)
      SAVE1066 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+DW(131,67)
      SAVE1067 = JACC(72,63)
      JACC(72,63) = JACC(72,63)+DW(131,63)
      SAVE1068 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(131,67)
      SAVE1069 = JACC(60,60)
      JACC(60,60) = JACC(60,60)-DW(132,60)
      SAVE1070 = JACC(60,67)
      JACC(60,67) = JACC(60,67)-DW(132,67)
      SAVE1071 = JACC(61,60)
      JACC(61,60) = JACC(61,60)+DW(132,60)
      SAVE1072 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+DW(132,67)
      SAVE1073 = JACC(67,60)
      JACC(67,60) = JACC(67,60)-DW(132,60)
      SAVE1074 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(132,67)
      SAVE1075 = JACC(71,60)
      JACC(71,60) = JACC(71,60)+DW(132,60)
      SAVE1076 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+DW(132,67)
      SAVE1077 = JACC(72,60)
      JACC(72,60) = JACC(72,60)+DW(132,60)
      SAVE1078 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(132,67)
      SAVE1079 = JACC(51,64)
      JACC(51,64) = JACC(51,64)+0.6300000000000000d-01*DW(133,64)
      SAVE1080 = JACC(51,67)
      JACC(51,67) = JACC(51,67)+0.6300000000000000d-01*DW(133,67)
      SAVE1081 = JACC(59,64)
      JACC(59,64) = JACC(59,64)+0.6230000000000000d+00*DW(133,64)
      SAVE1082 = JACC(59,67)
      JACC(59,67) = JACC(59,67)+0.6230000000000000d+00*DW(133,67)
      SAVE1083 = JACC(60,64)
      JACC(60,64) = JACC(60,64)+0.4800000000000000d-01*DW(133,64)
      SAVE1084 = JACC(60,67)
      JACC(60,67) = JACC(60,67)+0.4800000000000000d-01*DW(133,67)
      SAVE1085 = JACC(61,64)
      JACC(61,64) = JACC(61,64)+0.2330000000000000d+00*DW(133,64)
      SAVE1086 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+0.2330000000000000d+00*DW(133,67)
      SAVE1087 = JACC(63,64)
      JACC(63,64) = JACC(63,64)+0.1500000000000000d+00*DW(133,64)
      SAVE1088 = JACC(63,67)
      JACC(63,67) = JACC(63,67)+0.1500000000000000d+00*DW(133,67)
      SAVE1089 = JACC(64,64)
      JACC(64,64) = JACC(64,64)-DW(133,64)
      SAVE1090 = JACC(64,67)
      JACC(64,67) = JACC(64,67)-DW(133,67)
      SAVE1091 = JACC(65,64)
      JACC(65,64) = JACC(65,64)+0.4800000000000000d-01*DW(133,64)
      SAVE1092 = JACC(65,67)
      JACC(65,67) = JACC(65,67)+0.4800000000000000d-01*DW(133,67)
      SAVE1093 = JACC(66,64)
      JACC(66,64) = JACC(66,64)+0.4700000000000000d-01*DW(133,64)
      SAVE1094 = JACC(66,67)
      JACC(66,67) = JACC(66,67)+0.4700000000000000d-01*DW(133,67)
      SAVE1095 = JACC(67,64)
      JACC(67,64) = JACC(67,64)-DW(133,64)
      SAVE1096 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(133,67)
      SAVE1097 = JACC(70,64)
      JACC(70,64) = JACC(70,64)+0.5900000000000000d-01*DW(133,64)
      SAVE1098 = JACC(70,67)
      JACC(70,67) = JACC(70,67)+0.5900000000000000d-01*DW(133,67)
      SAVE1099 = JACC(71,64)
      JACC(71,64) = JACC(71,64)+0.7420000000000000d+00*DW(133,64)
      SAVE1100 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+0.7420000000000000d+00*DW(133,67)
      SAVE1101 = JACC(72,64)
      JACC(72,64) = JACC(72,64)+0.9409999999999999d+00*DW(133,64)
      SAVE1102 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.9409999999999999d+00*DW(133,67)
      SAVE1103 = JACC(36,36)
      JACC(36,36) = JACC(36,36)-DW(134,36)
      SAVE1104 = JACC(36,67)
      JACC(36,67) = JACC(36,67)-DW(134,67)
      SAVE1105 = JACC(59,36)
      JACC(59,36) = JACC(59,36)+0.7220000000000000d+00*DW(134,36)
      SAVE1106 = JACC(59,67)
      JACC(59,67) = JACC(59,67)+0.7220000000000000d+00*DW(134,67)
      SAVE1107 = JACC(60,36)
      JACC(60,36) = JACC(60,36)+0.2450000000000000d+00*DW(134,36)
      SAVE1108 = JACC(60,67)
      JACC(60,67) = JACC(60,67)+0.2450000000000000d+00*DW(134,67)
      SAVE1109 = JACC(61,36)
      JACC(61,36) = JACC(61,36)+0.2110000000000000d+00*DW(134,36)
      SAVE1110 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+0.2110000000000000d+00*DW(134,67)
      SAVE1111 = JACC(63,36)
      JACC(63,36) = JACC(63,36)+0.3100000000000000d-01*DW(134,36)
      SAVE1112 = JACC(63,67)
      JACC(63,67) = JACC(63,67)+0.3100000000000000d-01*DW(134,67)
      SAVE1113 = JACC(65,36)
      JACC(65,36) = JACC(65,36)+0.3340000000000000d+00*DW(134,36)
      SAVE1114 = JACC(65,67)
      JACC(65,67) = JACC(65,67)+0.3340000000000000d+00*DW(134,67)
      SAVE1115 = JACC(66,36)
      JACC(66,36) = JACC(66,36)+0.2100000000000000d-01*DW(134,36)
      SAVE1116 = JACC(66,67)
      JACC(66,67) = JACC(66,67)+0.2100000000000000d-01*DW(134,67)
      SAVE1117 = JACC(67,36)
      JACC(67,36) = JACC(67,36)-DW(134,36)
      SAVE1118 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(134,67)
      SAVE1119 = JACC(70,36)
      JACC(70,36) = JACC(70,36)+0.1240000000000000d+00*DW(134,36)
      SAVE1120 = JACC(70,67)
      JACC(70,67) = JACC(70,67)+0.1240000000000000d+00*DW(134,67)
      SAVE1121 = JACC(71,36)
      JACC(71,36) = JACC(71,36)+0.5990000000000000d+00*DW(134,36)
      SAVE1122 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+0.5990000000000000d+00*DW(134,67)
      SAVE1123 = JACC(72,36)
      JACC(72,36) = JACC(72,36)+0.8760000000000000d+00*DW(134,36)
      SAVE1124 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.8760000000000000d+00*DW(134,67)
      SAVE1125 = JACC(37,37)
      JACC(37,37) = JACC(37,37)-DW(135,37)
      SAVE1126 = JACC(37,67)
      JACC(37,67) = JACC(37,67)-DW(135,67)
      SAVE1127 = JACC(59,37)
      JACC(59,37) = JACC(59,37)+0.6420000000000000d+00*DW(135,37)
      SAVE1128 = JACC(59,67)
      JACC(59,67) = JACC(59,67)+0.6420000000000000d+00*DW(135,67)
      SAVE1129 = JACC(60,37)
      JACC(60,37) = JACC(60,37)+0.1330000000000000d+00*DW(135,37)
      SAVE1130 = JACC(60,67)
      JACC(60,67) = JACC(60,67)+0.1330000000000000d+00*DW(135,67)
      SAVE1131 = JACC(61,37)
      JACC(61,37) = JACC(61,37)+0.1500000000000000d+00*DW(135,37)
      SAVE1132 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+0.1500000000000000d+00*DW(135,67)
      SAVE1133 = JACC(65,37)
      JACC(65,37) = JACC(65,37)+0.4160000000000000d+00*DW(135,37)
      SAVE1134 = JACC(65,67)
      JACC(65,67) = JACC(65,67)+0.4160000000000000d+00*DW(135,67)
      SAVE1135 = JACC(67,37)
      JACC(67,37) = JACC(67,37)-DW(135,37)
      SAVE1136 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(135,67)
      SAVE1137 = JACC(70,37)
      JACC(70,37) = JACC(70,37)+0.2610000000000000d+00*DW(135,37)
      SAVE1138 = JACC(70,67)
      JACC(70,67) = JACC(70,67)+0.2610000000000000d+00*DW(135,67)
      SAVE1139 = JACC(71,37)
      JACC(71,37) = JACC(71,37)+0.6060000000000000d+00*DW(135,37)
      SAVE1140 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+0.6060000000000000d+00*DW(135,67)
      SAVE1141 = JACC(72,37)
      JACC(72,37) = JACC(72,37)+0.7390000000000000d+00*DW(135,37)
      SAVE1142 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.7390000000000000d+00*DW(135,67)
      SAVE1143 = JACC(38,38)
      JACC(38,38) = JACC(38,38)-DW(136,38)
      SAVE1144 = JACC(38,67)
      JACC(38,67) = JACC(38,67)-DW(136,67)
      SAVE1145 = JACC(61,38)
      JACC(61,38) = JACC(61,38)+0.2000000000000000d+00*DW(136,38)
      SAVE1146 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+0.2000000000000000d+00*DW(136,67)
      SAVE1147 = JACC(66,38)
      JACC(66,38) = JACC(66,38)+0.1600000000000000d+01*DW(136,38)
      SAVE1148 = JACC(66,67)
      JACC(66,67) = JACC(66,67)+0.1600000000000000d+01*DW(136,67)
      SAVE1149 = JACC(67,38)
      JACC(67,38) = JACC(67,38)-DW(136,38)
      SAVE1150 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(136,67)
      SAVE1151 = JACC(71,38)
      JACC(71,38) = JACC(71,38)+DW(136,38)
      SAVE1152 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+DW(136,67)
      SAVE1153 = JACC(72,38)
      JACC(72,38) = JACC(72,38)+DW(136,38)
      SAVE1154 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(136,67)
      SAVE1155 = JACC(41,41)
      JACC(41,41) = JACC(41,41)-DW(137,41)
      SAVE1156 = JACC(41,67)
      JACC(41,67) = JACC(41,67)-DW(137,67)
      SAVE1157 = JACC(59,41)
      JACC(59,41) = JACC(59,41)+0.6000000000000000d-01*DW(137,41)
      SAVE1158 = JACC(59,67)
      JACC(59,67) = JACC(59,67)+0.6000000000000000d-01*DW(137,67)
      SAVE1159 = JACC(61,41)
      JACC(61,41) = JACC(61,41)+0.9399999999999999d+00*DW(137,41)
      SAVE1160 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+0.9399999999999999d+00*DW(137,67)
      SAVE1161 = JACC(66,41)
      JACC(66,41) = JACC(66,41)+DW(137,41)
      SAVE1162 = JACC(66,67)
      JACC(66,67) = JACC(66,67)+DW(137,67)
      SAVE1163 = JACC(67,41)
      JACC(67,41) = JACC(67,41)-DW(137,41)
      SAVE1164 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(137,67)
      SAVE1165 = JACC(71,41)
      JACC(71,41) = JACC(71,41)+DW(137,41)
      SAVE1166 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+DW(137,67)
      SAVE1167 = JACC(72,41)
      JACC(72,41) = JACC(72,41)+DW(137,41)
      SAVE1168 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(137,67)
      SAVE1169 = JACC(45,45)
      JACC(45,45) = JACC(45,45)-DW(138,45)
      SAVE1170 = JACC(45,67)
      JACC(45,67) = JACC(45,67)-DW(138,67)
      SAVE1171 = JACC(59,45)
      JACC(59,45) = JACC(59,45)+0.2900000000000000d+00*DW(138,45)
      SAVE1172 = JACC(59,67)
      JACC(59,67) = JACC(59,67)+0.2900000000000000d+00*DW(138,67)
      SAVE1173 = JACC(61,45)
      JACC(61,45) = JACC(61,45)+0.1710000000000000d+01*DW(138,45)
      SAVE1174 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+0.1710000000000000d+01*DW(138,67)
      SAVE1175 = JACC(67,45)
      JACC(67,45) = JACC(67,45)-DW(138,45)
      SAVE1176 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(138,67)
      SAVE1177 = JACC(71,45)
      JACC(71,45) = JACC(71,45)+DW(138,45)
      SAVE1178 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+DW(138,67)
      SAVE1179 = JACC(72,45)
      JACC(72,45) = JACC(72,45)+DW(138,45)
      SAVE1180 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(138,67)
      SAVE1181 = JACC(39,39)
      JACC(39,39) = JACC(39,39)-DW(139,39)
      SAVE1182 = JACC(39,67)
      JACC(39,67) = JACC(39,67)-DW(139,67)
      SAVE1183 = JACC(40,39)
      JACC(40,39) = JACC(40,39)+0.3540000000000000d+00*DW(139,39)
      SAVE1184 = JACC(40,67)
      JACC(40,67) = JACC(40,67)+0.3540000000000000d+00*DW(139,67)
      SAVE1185 = JACC(49,39)
      JACC(49,39) = JACC(49,39)+0.4460000000000000d+00*DW(139,39)
      SAVE1186 = JACC(49,67)
      JACC(49,67) = JACC(49,67)+0.4460000000000000d+00*DW(139,67)
      SAVE1187 = JACC(66,39)
      JACC(66,39) = JACC(66,39)+0.6060000000000000d+00*DW(139,39)
      SAVE1188 = JACC(66,67)
      JACC(66,67) = JACC(66,67)+0.6060000000000000d+00*DW(139,67)
      SAVE1189 = JACC(67,39)
      JACC(67,39) = JACC(67,39)-DW(139,39)
      SAVE1190 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(139,67)
      SAVE1191 = JACC(70,39)
      JACC(70,39) = JACC(70,39)+0.1530000000000000d+00*DW(139,39)
      SAVE1192 = JACC(70,67)
      JACC(70,67) = JACC(70,67)+0.1530000000000000d+00*DW(139,67)
      SAVE1193 = JACC(71,39)
      JACC(71,39) = JACC(71,39)+0.8470000000000000d+00*DW(139,39)
      SAVE1194 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+0.8470000000000000d+00*DW(139,67)
      SAVE1195 = JACC(72,39)
      JACC(72,39) = JACC(72,39)+0.8470000000000000d+00*DW(139,39)
      SAVE1196 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.8470000000000000d+00*DW(139,67)
      SAVE1197 = JACC(42,42)
      JACC(42,42) = JACC(42,42)-DW(140,42)
      SAVE1198 = JACC(42,67)
      JACC(42,67) = JACC(42,67)-DW(140,67)
      SAVE1199 = JACC(59,42)
      JACC(59,42) = JACC(59,42)+0.8000000000000000d+00*DW(140,42)
      SAVE1200 = JACC(59,67)
      JACC(59,67) = JACC(59,67)+0.8000000000000000d+00*DW(140,67)
      SAVE1201 = JACC(61,42)
      JACC(61,42) = JACC(61,42)+0.8000000000000000d+00*DW(140,42)
      SAVE1202 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+0.8000000000000000d+00*DW(140,67)
      SAVE1203 = JACC(67,42)
      JACC(67,42) = JACC(67,42)-DW(140,42)
      SAVE1204 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(140,67)
      SAVE1205 = JACC(70,42)
      JACC(70,42) = JACC(70,42)+0.2000000000000000d+00*DW(140,42)
      SAVE1206 = JACC(70,67)
      JACC(70,67) = JACC(70,67)+0.2000000000000000d+00*DW(140,67)
      SAVE1207 = JACC(71,42)
      JACC(71,42) = JACC(71,42)+0.8000000000000000d+00*DW(140,42)
      SAVE1208 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+0.8000000000000000d+00*DW(140,67)
      SAVE1209 = JACC(72,42)
      JACC(72,42) = JACC(72,42)+0.8000000000000000d+00*DW(140,42)
      SAVE1210 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.8000000000000000d+00*DW(140,67)
      SAVE1211 = JACC(43,43)
      JACC(43,43) = JACC(43,43)-DW(141,43)
      SAVE1212 = JACC(43,67)
      JACC(43,67) = JACC(43,67)-DW(141,67)
      SAVE1213 = JACC(44,43)
      JACC(44,43) = JACC(44,43)+0.2500000000000000d+00*DW(141,43)
      SAVE1214 = JACC(44,67)
      JACC(44,67) = JACC(44,67)+0.2500000000000000d+00*DW(141,67)
      SAVE1215 = JACC(49,43)
      JACC(49,43) = JACC(49,43)+0.4000000000000000d+00*DW(141,43)
      SAVE1216 = JACC(49,67)
      JACC(49,67) = JACC(49,67)+0.4000000000000000d+00*DW(141,67)
      SAVE1217 = JACC(66,43)
      JACC(66,43) = JACC(66,43)+0.2500000000000000d+00*DW(141,43)
      SAVE1218 = JACC(66,67)
      JACC(66,67) = JACC(66,67)+0.2500000000000000d+00*DW(141,67)
      SAVE1219 = JACC(67,43)
      JACC(67,43) = JACC(67,43)-DW(141,43)
      SAVE1220 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(141,67)
      SAVE1221 = JACC(70,43)
      JACC(70,43) = JACC(70,43)+0.3500000000000000d+00*DW(141,43)
      SAVE1222 = JACC(70,67)
      JACC(70,67) = JACC(70,67)+0.3500000000000000d+00*DW(141,67)
      SAVE1223 = JACC(71,43)
      JACC(71,43) = JACC(71,43)+0.6500000000000000d+00*DW(141,43)
      SAVE1224 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+0.6500000000000000d+00*DW(141,67)
      SAVE1225 = JACC(72,43)
      JACC(72,43) = JACC(72,43)+0.6500000000000000d+00*DW(141,43)
      SAVE1226 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.6500000000000000d+00*DW(141,67)
      SAVE1227 = JACC(31,31)
      JACC(31,31) = JACC(31,31)-DW(142,31)
      SAVE1228 = JACC(31,67)
      JACC(31,67) = JACC(31,67)-DW(142,67)
      SAVE1229 = JACC(48,31)
      JACC(48,31) = JACC(48,31)+0.5000000000000000d+00*DW(142,31)
      SAVE1230 = JACC(48,67)
      JACC(48,67) = JACC(48,67)+0.5000000000000000d+00*DW(142,67)
      SAVE1231 = JACC(51,31)
      JACC(51,31) = JACC(51,31)+0.1200000000000000d+01*DW(142,31)
      SAVE1232 = JACC(51,67)
      JACC(51,67) = JACC(51,67)+0.1200000000000000d+01*DW(142,67)
      SAVE1233 = JACC(54,31)
      JACC(54,31) = JACC(54,31)+0.6500000000000000d+00*DW(142,31)
      SAVE1234 = JACC(54,67)
      JACC(54,67) = JACC(54,67)+0.6500000000000000d+00*DW(142,67)
      SAVE1235 = JACC(67,31)
      JACC(67,31) = JACC(67,31)-DW(142,31)
      SAVE1236 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(142,67)
      SAVE1237 = JACC(70,31)
      JACC(70,31) = JACC(70,31)+0.5000000000000000d-01*DW(142,31)
      SAVE1238 = JACC(70,67)
      JACC(70,67) = JACC(70,67)+0.5000000000000000d-01*DW(142,67)
      SAVE1239 = JACC(71,31)
      JACC(71,31) = JACC(71,31)+0.9500000000000000d+00*DW(142,31)
      SAVE1240 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+0.9500000000000000d+00*DW(142,67)
      SAVE1241 = JACC(72,31)
      JACC(72,31) = JACC(72,31)+0.9500000000000000d+00*DW(142,31)
      SAVE1242 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.9500000000000000d+00*DW(142,67)
      SAVE1243 = JACC(32,32)
      JACC(32,32) = JACC(32,32)-DW(143,32)
      SAVE1244 = JACC(32,67)
      JACC(32,67) = JACC(32,67)-DW(143,67)
      SAVE1245 = JACC(48,32)
      JACC(48,32) = JACC(48,32)+0.9500000000000000d+00*DW(143,32)
      SAVE1246 = JACC(48,67)
      JACC(48,67) = JACC(48,67)+0.9500000000000000d+00*DW(143,67)
      SAVE1247 = JACC(51,32)
      JACC(51,32) = JACC(51,32)+0.3500000000000000d+00*DW(143,32)
      SAVE1248 = JACC(51,67)
      JACC(51,67) = JACC(51,67)+0.3500000000000000d+00*DW(143,67)
      SAVE1249 = JACC(54,32)
      JACC(54,32) = JACC(54,32)+0.6000000000000000d+00*DW(143,32)
      SAVE1250 = JACC(54,67)
      JACC(54,67) = JACC(54,67)+0.6000000000000000d+00*DW(143,67)
      SAVE1251 = JACC(67,32)
      JACC(67,32) = JACC(67,32)-DW(143,32)
      SAVE1252 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(143,67)
      SAVE1253 = JACC(70,32)
      JACC(70,32) = JACC(70,32)+0.5000000000000000d-01*DW(143,32)
      SAVE1254 = JACC(70,67)
      JACC(70,67) = JACC(70,67)+0.5000000000000000d-01*DW(143,67)
      SAVE1255 = JACC(71,32)
      JACC(71,32) = JACC(71,32)+0.9500000000000000d+00*DW(143,32)
      SAVE1256 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+0.9500000000000000d+00*DW(143,67)
      SAVE1257 = JACC(72,32)
      JACC(72,32) = JACC(72,32)+0.9500000000000000d+00*DW(143,32)
      SAVE1258 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.9500000000000000d+00*DW(143,67)
      SAVE1259 = JACC(33,33)
      JACC(33,33) = JACC(33,33)-DW(144,33)
      SAVE1260 = JACC(33,67)
      JACC(33,67) = JACC(33,67)-DW(144,67)
      SAVE1261 = JACC(51,33)
      JACC(51,33) = JACC(51,33)+DW(144,33)
      SAVE1262 = JACC(51,67)
      JACC(51,67) = JACC(51,67)+DW(144,67)
      SAVE1263 = JACC(54,33)
      JACC(54,33) = JACC(54,33)+DW(144,33)
      SAVE1264 = JACC(54,67)
      JACC(54,67) = JACC(54,67)+DW(144,67)
      SAVE1265 = JACC(67,33)
      JACC(67,33) = JACC(67,33)-DW(144,33)
      SAVE1266 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(144,67)
      SAVE1267 = JACC(71,33)
      JACC(71,33) = JACC(71,33)+DW(144,33)
      SAVE1268 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+DW(144,67)
      SAVE1269 = JACC(72,33)
      JACC(72,33) = JACC(72,33)+DW(144,33)
      SAVE1270 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(144,67)
      SAVE1271 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+DW(145,69)
      SAVE1272 = JACC(63,67)
      JACC(63,67) = JACC(63,67)+DW(145,67)
      SAVE1273 = JACC(67,69)
      JACC(67,69) = JACC(67,69)-DW(145,69)
      SAVE1274 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(145,67)
      SAVE1275 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(145,69)
      SAVE1276 = JACC(69,67)
      JACC(69,67) = JACC(69,67)-DW(145,67)
      SAVE1277 = JACC(72,69)
      JACC(72,69) = JACC(72,69)+DW(145,69)
      SAVE1278 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(145,67)
      SAVE1279 = JACC(56,56)
      JACC(56,56) = JACC(56,56)-DW(146,56)
      SAVE1280 = JACC(56,67)
      JACC(56,67) = JACC(56,67)-DW(146,67)
      SAVE1281 = JACC(66,56)
      JACC(66,56) = JACC(66,56)+DW(146,56)
      SAVE1282 = JACC(66,67)
      JACC(66,67) = JACC(66,67)+DW(146,67)
      SAVE1283 = JACC(67,56)
      JACC(67,56) = JACC(67,56)-DW(146,56)
      SAVE1284 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(146,67)
      SAVE1285 = JACC(69,56)
      JACC(69,56) = JACC(69,56)+DW(146,56)
      SAVE1286 = JACC(69,67)
      JACC(69,67) = JACC(69,67)+DW(146,67)
      SAVE1287 = JACC(72,56)
      JACC(72,56) = JACC(72,56)+DW(146,56)
      SAVE1288 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(146,67)
      SAVE1289 = JACC(54,58)
      JACC(54,58) = JACC(54,58)+0.5400000000000000d+00*DW(147,58)
      SAVE1290 = JACC(54,67)
      JACC(54,67) = JACC(54,67)+0.5400000000000000d+00*DW(147,67)
      SAVE1291 = JACC(58,58)
      JACC(58,58) = JACC(58,58)-DW(147,58)
      SAVE1292 = JACC(58,67)
      JACC(58,67) = JACC(58,67)-DW(147,67)
      SAVE1293 = JACC(61,58)
      JACC(61,58) = JACC(61,58)+0.4600000000000000d+00*DW(147,58)
      SAVE1294 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+0.4600000000000000d+00*DW(147,67)
      SAVE1295 = JACC(65,58)
      JACC(65,58) = JACC(65,58)+0.1600000000000000d+00*DW(147,58)
      SAVE1296 = JACC(65,67)
      JACC(65,67) = JACC(65,67)+0.1600000000000000d+00*DW(147,67)
      SAVE1297 = JACC(67,58)
      JACC(67,58) = JACC(67,58)-DW(147,58)
      SAVE1298 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(147,67)
      SAVE1299 = JACC(69,58)
      JACC(69,58) = JACC(69,58)+0.2300000000000000d+00*DW(147,58)
      SAVE1300 = JACC(69,67)
      JACC(69,67) = JACC(69,67)+0.2300000000000000d+00*DW(147,67)
      SAVE1301 = JACC(71,58)
      JACC(71,58) = JACC(71,58)+0.7700000000000000d+00*DW(147,58)
      SAVE1302 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+0.7700000000000000d+00*DW(147,67)
      SAVE1303 = JACC(72,58)
      JACC(72,58) = JACC(72,58)+DW(147,58)
      SAVE1304 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(147,67)
      SAVE1305 = JACC(47,47)
      JACC(47,47) = JACC(47,47)-DW(148,47)
      SAVE1306 = JACC(47,67)
      JACC(47,67) = JACC(47,67)-DW(148,67)
      SAVE1307 = JACC(67,47)
      JACC(67,47) = JACC(67,47)-DW(148,47)
      SAVE1308 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(148,67)
      SAVE1309 = JACC(70,47)
      JACC(70,47) = JACC(70,47)+DW(148,47)
      SAVE1310 = JACC(70,67)
      JACC(70,67) = JACC(70,67)+DW(148,67)
      SAVE1311 = JACC(71,47)
      JACC(71,47) = JACC(71,47)+DW(148,47)
      SAVE1312 = JACC(71,67)
      JACC(71,67) = JACC(71,67)+DW(148,67)
      SAVE1313 = JACC(72,47)
      JACC(72,47) = JACC(72,47)+DW(148,47)
      SAVE1314 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(148,67)
      SAVE1315 = JACC(46,46)
      JACC(46,46) = JACC(46,46)-DW(149,46)
      SAVE1316 = JACC(46,67)
      JACC(46,67) = JACC(46,67)-DW(149,67)
      SAVE1317 = JACC(59,46)
      JACC(59,46) = JACC(59,46)+0.4640000000000000d+00*DW(149,46)
      SAVE1318 = JACC(59,67)
      JACC(59,67) = JACC(59,67)+0.4640000000000000d+00*DW(149,67)
      SAVE1319 = JACC(61,46)
      JACC(61,46) = JACC(61,46)+0.1240000000000000d+01*DW(149,46)
      SAVE1320 = JACC(61,67)
      JACC(61,67) = JACC(61,67)+0.1240000000000000d+01*DW(149,67)
      SAVE1321 = JACC(66,46)
      JACC(66,46) = JACC(66,46)+0.2870000000000000d+00*DW(149,46)
      SAVE1322 = JACC(66,67)
      JACC(66,67) = JACC(66,67)+0.2870000000000000d+00*DW(149,67)
      SAVE1323 = JACC(67,46)
      JACC(67,46) = JACC(67,46)-DW(149,46)
      SAVE1324 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(149,67)
      SAVE1325 = JACC(72,46)
      JACC(72,46) = JACC(72,46)+0.2000000000000000d+01*DW(149,46)
      SAVE1326 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+0.2000000000000000d+01*DW(149,67)
      SAVE1327 = JACC(16,63)
      JACC(16,63) = JACC(16,63)+DW(150,63)
      SAVE1328 = JACC(16,71)
      JACC(16,71) = JACC(16,71)+DW(150,71)
      SAVE1329 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(150,63)
      SAVE1330 = JACC(63,71)
      JACC(63,71) = JACC(63,71)-DW(150,71)
      SAVE1331 = JACC(71,63)
      JACC(71,63) = JACC(71,63)-DW(150,63)
      SAVE1332 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(150,71)
      SAVE1333 = JACC(53,60)
      JACC(53,60) = JACC(53,60)+DW(151,60)
      SAVE1334 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(151,71)
      SAVE1335 = JACC(60,60)
      JACC(60,60) = JACC(60,60)-DW(151,60)
      SAVE1336 = JACC(60,71)
      JACC(60,71) = JACC(60,71)-DW(151,71)
      SAVE1337 = JACC(71,60)
      JACC(71,60) = JACC(71,60)-DW(151,60)
      SAVE1338 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(151,71)
      SAVE1339 = JACC(53,64)
      JACC(53,64) = JACC(53,64)+DW(152,64)
      SAVE1340 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(152,71)
      SAVE1341 = JACC(64,64)
      JACC(64,64) = JACC(64,64)-DW(152,64)
      SAVE1342 = JACC(64,71)
      JACC(64,71) = JACC(64,71)-DW(152,71)
      SAVE1343 = JACC(71,64)
      JACC(71,64) = JACC(71,64)-DW(152,64)
      SAVE1344 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(152,71)
      SAVE1345 = JACC(36,36)
      JACC(36,36) = JACC(36,36)-DW(153,36)
      SAVE1346 = JACC(36,71)
      JACC(36,71) = JACC(36,71)-DW(153,71)
      SAVE1347 = JACC(53,36)
      JACC(53,36) = JACC(53,36)+DW(153,36)
      SAVE1348 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(153,71)
      SAVE1349 = JACC(71,36)
      JACC(71,36) = JACC(71,36)-DW(153,36)
      SAVE1350 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(153,71)
      SAVE1351 = JACC(37,37)
      JACC(37,37) = JACC(37,37)-DW(154,37)
      SAVE1352 = JACC(37,71)
      JACC(37,71) = JACC(37,71)-DW(154,71)
      SAVE1353 = JACC(53,37)
      JACC(53,37) = JACC(53,37)+DW(154,37)
      SAVE1354 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(154,71)
      SAVE1355 = JACC(71,37)
      JACC(71,37) = JACC(71,37)-DW(154,37)
      SAVE1356 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(154,71)
      SAVE1357 = JACC(38,38)
      JACC(38,38) = JACC(38,38)-DW(155,38)
      SAVE1358 = JACC(38,71)
      JACC(38,71) = JACC(38,71)-DW(155,71)
      SAVE1359 = JACC(53,38)
      JACC(53,38) = JACC(53,38)+DW(155,38)
      SAVE1360 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(155,71)
      SAVE1361 = JACC(71,38)
      JACC(71,38) = JACC(71,38)-DW(155,38)
      SAVE1362 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(155,71)
      SAVE1363 = JACC(41,41)
      JACC(41,41) = JACC(41,41)-DW(156,41)
      SAVE1364 = JACC(41,71)
      JACC(41,71) = JACC(41,71)-DW(156,71)
      SAVE1365 = JACC(53,41)
      JACC(53,41) = JACC(53,41)+DW(156,41)
      SAVE1366 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(156,71)
      SAVE1367 = JACC(71,41)
      JACC(71,41) = JACC(71,41)-DW(156,41)
      SAVE1368 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(156,71)
      SAVE1369 = JACC(45,45)
      JACC(45,45) = JACC(45,45)-DW(157,45)
      SAVE1370 = JACC(45,71)
      JACC(45,71) = JACC(45,71)-DW(157,71)
      SAVE1371 = JACC(53,45)
      JACC(53,45) = JACC(53,45)+DW(157,45)
      SAVE1372 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(157,71)
      SAVE1373 = JACC(71,45)
      JACC(71,45) = JACC(71,45)-DW(157,45)
      SAVE1374 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(157,71)
      SAVE1375 = JACC(39,39)
      JACC(39,39) = JACC(39,39)-DW(158,39)
      SAVE1376 = JACC(39,71)
      JACC(39,71) = JACC(39,71)-DW(158,71)
      SAVE1377 = JACC(53,39)
      JACC(53,39) = JACC(53,39)+DW(158,39)
      SAVE1378 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(158,71)
      SAVE1379 = JACC(71,39)
      JACC(71,39) = JACC(71,39)-DW(158,39)
      SAVE1380 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(158,71)
      SAVE1381 = JACC(42,42)
      JACC(42,42) = JACC(42,42)-DW(159,42)
      SAVE1382 = JACC(42,71)
      JACC(42,71) = JACC(42,71)-DW(159,71)
      SAVE1383 = JACC(53,42)
      JACC(53,42) = JACC(53,42)+DW(159,42)
      SAVE1384 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(159,71)
      SAVE1385 = JACC(71,42)
      JACC(71,42) = JACC(71,42)-DW(159,42)
      SAVE1386 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(159,71)
      SAVE1387 = JACC(43,43)
      JACC(43,43) = JACC(43,43)-DW(160,43)
      SAVE1388 = JACC(43,71)
      JACC(43,71) = JACC(43,71)-DW(160,71)
      SAVE1389 = JACC(53,43)
      JACC(53,43) = JACC(53,43)+DW(160,43)
      SAVE1390 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(160,71)
      SAVE1391 = JACC(71,43)
      JACC(71,43) = JACC(71,43)-DW(160,43)
      SAVE1392 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(160,71)
      SAVE1393 = JACC(31,31)
      JACC(31,31) = JACC(31,31)-DW(161,31)
      SAVE1394 = JACC(31,71)
      JACC(31,71) = JACC(31,71)-DW(161,71)
      SAVE1395 = JACC(53,31)
      JACC(53,31) = JACC(53,31)+DW(161,31)
      SAVE1396 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(161,71)
      SAVE1397 = JACC(71,31)
      JACC(71,31) = JACC(71,31)-DW(161,31)
      SAVE1398 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(161,71)
      SAVE1399 = JACC(32,32)
      JACC(32,32) = JACC(32,32)-DW(162,32)
      SAVE1400 = JACC(32,71)
      JACC(32,71) = JACC(32,71)-DW(162,71)
      SAVE1401 = JACC(53,32)
      JACC(53,32) = JACC(53,32)+DW(162,32)
      SAVE1402 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(162,71)
      SAVE1403 = JACC(71,32)
      JACC(71,32) = JACC(71,32)-DW(162,32)
      SAVE1404 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(162,71)
      SAVE1405 = JACC(33,33)
      JACC(33,33) = JACC(33,33)-DW(163,33)
      SAVE1406 = JACC(33,71)
      JACC(33,71) = JACC(33,71)-DW(163,71)
      SAVE1407 = JACC(53,33)
      JACC(53,33) = JACC(53,33)+DW(163,33)
      SAVE1408 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(163,71)
      SAVE1409 = JACC(71,33)
      JACC(71,33) = JACC(71,33)-DW(163,33)
      SAVE1410 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(163,71)
      SAVE1411 = JACC(28,69)
      JACC(28,69) = JACC(28,69)+DW(164,69)
      SAVE1412 = JACC(28,71)
      JACC(28,71) = JACC(28,71)+DW(164,71)
      SAVE1413 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(164,69)
      SAVE1414 = JACC(69,71)
      JACC(69,71) = JACC(69,71)-DW(164,71)
      SAVE1415 = JACC(71,69)
      JACC(71,69) = JACC(71,69)-DW(164,69)
      SAVE1416 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(164,71)
      SAVE1417 = JACC(50,69)
      JACC(50,69) = JACC(50,69)+DW(165,69)
      SAVE1418 = JACC(50,71)
      JACC(50,71) = JACC(50,71)+DW(165,71)
      SAVE1419 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+DW(165,69)
      SAVE1420 = JACC(57,71)
      JACC(57,71) = JACC(57,71)+DW(165,71)
      SAVE1421 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(165,69)
      SAVE1422 = JACC(69,71)
      JACC(69,71) = JACC(69,71)-DW(165,71)
      SAVE1423 = JACC(71,69)
      JACC(71,69) = JACC(71,69)-DW(165,69)
      SAVE1424 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(165,71)
      SAVE1425 = JACC(53,56)
      JACC(53,56) = JACC(53,56)+DW(166,56)
      SAVE1426 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(166,71)
      SAVE1427 = JACC(56,56)
      JACC(56,56) = JACC(56,56)-DW(166,56)
      SAVE1428 = JACC(56,71)
      JACC(56,71) = JACC(56,71)-DW(166,71)
      SAVE1429 = JACC(71,56)
      JACC(71,56) = JACC(71,56)-DW(166,56)
      SAVE1430 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(166,71)
      SAVE1431 = JACC(50,56)
      JACC(50,56) = JACC(50,56)+DW(167,56)
      SAVE1432 = JACC(50,71)
      JACC(50,71) = JACC(50,71)+DW(167,71)
      SAVE1433 = JACC(56,56)
      JACC(56,56) = JACC(56,56)-DW(167,56)
      SAVE1434 = JACC(56,71)
      JACC(56,71) = JACC(56,71)-DW(167,71)
      SAVE1435 = JACC(57,56)
      JACC(57,56) = JACC(57,56)+DW(167,56)
      SAVE1436 = JACC(57,71)
      JACC(57,71) = JACC(57,71)+DW(167,71)
      SAVE1437 = JACC(71,56)
      JACC(71,56) = JACC(71,56)-DW(167,56)
      SAVE1438 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(167,71)
      SAVE1439 = JACC(53,58)
      JACC(53,58) = JACC(53,58)+DW(168,58)
      SAVE1440 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(168,71)
      SAVE1441 = JACC(58,58)
      JACC(58,58) = JACC(58,58)-DW(168,58)
      SAVE1442 = JACC(58,71)
      JACC(58,71) = JACC(58,71)-DW(168,71)
      SAVE1443 = JACC(71,58)
      JACC(71,58) = JACC(71,58)-DW(168,58)
      SAVE1444 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(168,71)
      SAVE1445 = JACC(47,47)
      JACC(47,47) = JACC(47,47)-DW(169,47)
      SAVE1446 = JACC(47,71)
      JACC(47,71) = JACC(47,71)-DW(169,71)
      SAVE1447 = JACC(70,47)
      JACC(70,47) = JACC(70,47)+DW(169,47)
      SAVE1448 = JACC(70,71)
      JACC(70,71) = JACC(70,71)+DW(169,71)
      SAVE1449 = JACC(71,47)
      JACC(71,47) = JACC(71,47)-DW(169,47)
      SAVE1450 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(169,71)
      SAVE1451 = JACC(46,46)
      JACC(46,46) = JACC(46,46)-DW(170,46)
      SAVE1452 = JACC(46,71)
      JACC(46,71) = JACC(46,71)-DW(170,71)
      SAVE1453 = JACC(70,46)
      JACC(70,46) = JACC(70,46)+DW(170,46)
      SAVE1454 = JACC(70,71)
      JACC(70,71) = JACC(70,71)+DW(170,71)
      SAVE1455 = JACC(71,46)
      JACC(71,46) = JACC(71,46)-DW(170,46)
      SAVE1456 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(170,71)
      SAVE1457 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-0.2000000000000000d+01*DW(171,63)
      SAVE1458 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-0.2000000000000000d+01*DW(171,63)
      SAVE1459 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.1330000000000000d+01*DW(171,63)
      SAVE1460 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.1330000000000000d+01*DW(171,63)
      SAVE1461 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.6600000000000000d+00*DW(171,63)
      SAVE1462 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.6600000000000000d+00*DW(171,63)
      SAVE1463 = JACC(60,60)
      JACC(60,60) = JACC(60,60)-DW(172,60)
      SAVE1464 = JACC(60,63)
      JACC(60,63) = JACC(60,63)-DW(172,63)
      SAVE1465 = JACC(61,60)
      JACC(61,60) = JACC(61,60)+0.7500000000000000d+00*DW(172,60)
      SAVE1466 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+0.7500000000000000d+00*DW(172,63)
      SAVE1467 = JACC(63,60)
      JACC(63,60) = JACC(63,60)-DW(172,60)
      SAVE1468 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(172,63)
      SAVE1469 = JACC(66,60)
      JACC(66,60) = JACC(66,60)+0.7500000000000000d+00*DW(172,60)
      SAVE1470 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.7500000000000000d+00*DW(172,63)
      SAVE1471 = JACC(71,60)
      JACC(71,60) = JACC(71,60)+DW(172,60)
      SAVE1472 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(172,63)
      SAVE1473 = JACC(51,64)
      JACC(51,64) = JACC(51,64)+0.1190000000000000d+00*DW(173,64)
      SAVE1474 = JACC(51,63)
      JACC(51,63) = JACC(51,63)+0.1190000000000000d+00*DW(173,63)
      SAVE1475 = JACC(54,64)
      JACC(54,64) = JACC(54,64)+0.5000000000000000d-02*DW(173,64)
      SAVE1476 = JACC(54,63)
      JACC(54,63) = JACC(54,63)+0.5000000000000000d-02*DW(173,63)
      SAVE1477 = JACC(59,64)
      JACC(59,64) = JACC(59,64)+0.1800000000000000d-01*DW(173,64)
      SAVE1478 = JACC(59,63)
      JACC(59,63) = JACC(59,63)+0.1800000000000000d-01*DW(173,63)
      SAVE1479 = JACC(61,64)
      JACC(61,64) = JACC(61,64)+0.5800000000000000d+00*DW(173,64)
      SAVE1480 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+0.5800000000000000d+00*DW(173,63)
      SAVE1481 = JACC(63,64)
      JACC(63,64) = JACC(63,64)-0.9930000000000000d+00*DW(173,64)
      SAVE1482 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-0.9930000000000000d+00*DW(173,63)
      SAVE1483 = JACC(64,64)
      JACC(64,64) = JACC(64,64)-DW(173,64)
      SAVE1484 = JACC(64,63)
      JACC(64,63) = JACC(64,63)-DW(173,63)
      SAVE1485 = JACC(65,64)
      JACC(65,64) = JACC(65,64)+0.8500000000000001d-01*DW(173,64)
      SAVE1486 = JACC(65,63)
      JACC(65,63) = JACC(65,63)+0.8500000000000001d-01*DW(173,63)
      SAVE1487 = JACC(66,64)
      JACC(66,64) = JACC(66,64)+0.8100000000000001d+00*DW(173,64)
      SAVE1488 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.8100000000000001d+00*DW(173,63)
      SAVE1489 = JACC(71,64)
      JACC(71,64) = JACC(71,64)+0.9920000000000000d+00*DW(173,64)
      SAVE1490 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.9920000000000000d+00*DW(173,63)
      SAVE1491 = JACC(36,36)
      JACC(36,36) = JACC(36,36)-DW(174,36)
      SAVE1492 = JACC(36,63)
      JACC(36,63) = JACC(36,63)-DW(174,63)
      SAVE1493 = JACC(59,36)
      JACC(59,36) = JACC(59,36)+0.2400000000000000d+00*DW(174,36)
      SAVE1494 = JACC(59,63)
      JACC(59,63) = JACC(59,63)+0.2400000000000000d+00*DW(174,63)
      SAVE1495 = JACC(60,36)
      JACC(60,36) = JACC(60,36)+0.1400000000000000d-01*DW(174,36)
      SAVE1496 = JACC(60,63)
      JACC(60,63) = JACC(60,63)+0.1400000000000000d-01*DW(174,63)
      SAVE1497 = JACC(61,36)
      JACC(61,36) = JACC(61,36)+0.5230000000000000d+00*DW(174,36)
      SAVE1498 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+0.5230000000000000d+00*DW(174,63)
      SAVE1499 = JACC(63,36)
      JACC(63,36) = JACC(63,36)-0.9510000000000000d+00*DW(174,36)
      SAVE1500 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-0.9510000000000000d+00*DW(174,63)
      SAVE1501 = JACC(65,36)
      JACC(65,36) = JACC(65,36)+0.2450000000000000d+00*DW(174,36)
      SAVE1502 = JACC(65,63)
      JACC(65,63) = JACC(65,63)+0.2450000000000000d+00*DW(174,63)
      SAVE1503 = JACC(66,36)
      JACC(66,36) = JACC(66,36)+0.8290000000000000d+00*DW(174,36)
      SAVE1504 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.8290000000000000d+00*DW(174,63)
      SAVE1505 = JACC(71,36)
      JACC(71,36) = JACC(71,36)+0.9460000000000000d+00*DW(174,36)
      SAVE1506 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.9460000000000000d+00*DW(174,63)
      SAVE1507 = JACC(37,37)
      JACC(37,37) = JACC(37,37)-DW(175,37)
      SAVE1508 = JACC(37,63)
      JACC(37,63) = JACC(37,63)-DW(175,63)
      SAVE1509 = JACC(59,37)
      JACC(59,37) = JACC(59,37)+0.4190000000000000d+00*DW(175,37)
      SAVE1510 = JACC(59,63)
      JACC(59,63) = JACC(59,63)+0.4190000000000000d+00*DW(175,63)
      SAVE1511 = JACC(60,37)
      JACC(60,37) = JACC(60,37)+0.1300000000000000d-01*DW(175,37)
      SAVE1512 = JACC(60,63)
      JACC(60,63) = JACC(60,63)+0.1300000000000000d-01*DW(175,63)
      SAVE1513 = JACC(61,37)
      JACC(61,37) = JACC(61,37)+0.4110000000000000d+00*DW(175,37)
      SAVE1514 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+0.4110000000000000d+00*DW(175,63)
      SAVE1515 = JACC(63,37)
      JACC(63,37) = JACC(63,37)-DW(175,37)
      SAVE1516 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(175,63)
      SAVE1517 = JACC(65,37)
      JACC(65,37) = JACC(65,37)+0.3220000000000000d+00*DW(175,37)
      SAVE1518 = JACC(65,63)
      JACC(65,63) = JACC(65,63)+0.3220000000000000d+00*DW(175,63)
      SAVE1519 = JACC(66,37)
      JACC(66,37) = JACC(66,37)+0.7530000000000000d+00*DW(175,37)
      SAVE1520 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.7530000000000000d+00*DW(175,63)
      SAVE1521 = JACC(71,37)
      JACC(71,37) = JACC(71,37)+0.9930000000000000d+00*DW(175,37)
      SAVE1522 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.9930000000000000d+00*DW(175,63)
      SAVE1523 = JACC(38,38)
      JACC(38,38) = JACC(38,38)-DW(176,38)
      SAVE1524 = JACC(38,63)
      JACC(38,63) = JACC(38,63)-DW(176,63)
      SAVE1525 = JACC(61,38)
      JACC(61,38) = JACC(61,38)+0.3500000000000000d+00*DW(176,38)
      SAVE1526 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+0.3500000000000000d+00*DW(176,63)
      SAVE1527 = JACC(63,38)
      JACC(63,38) = JACC(63,38)-DW(176,38)
      SAVE1528 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(176,63)
      SAVE1529 = JACC(66,38)
      JACC(66,38) = JACC(66,38)+0.1550000000000000d+01*DW(176,38)
      SAVE1530 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.1550000000000000d+01*DW(176,63)
      SAVE1531 = JACC(71,38)
      JACC(71,38) = JACC(71,38)+DW(176,38)
      SAVE1532 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(176,63)
      SAVE1533 = JACC(41,41)
      JACC(41,41) = JACC(41,41)-DW(177,41)
      SAVE1534 = JACC(41,63)
      JACC(41,63) = JACC(41,63)-DW(177,63)
      SAVE1535 = JACC(59,41)
      JACC(59,41) = JACC(59,41)+0.8100000000000000d-01*DW(177,41)
      SAVE1536 = JACC(59,63)
      JACC(59,63) = JACC(59,63)+0.8100000000000000d-01*DW(177,63)
      SAVE1537 = JACC(61,41)
      JACC(61,41) = JACC(61,41)+0.6690000000000000d+00*DW(177,41)
      SAVE1538 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+0.6690000000000000d+00*DW(177,63)
      SAVE1539 = JACC(63,41)
      JACC(63,41) = JACC(63,41)-DW(177,41)
      SAVE1540 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(177,63)
      SAVE1541 = JACC(66,41)
      JACC(66,41) = JACC(66,41)+0.1250000000000000d+01*DW(177,41)
      SAVE1542 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.1250000000000000d+01*DW(177,63)
      SAVE1543 = JACC(71,41)
      JACC(71,41) = JACC(71,41)+DW(177,41)
      SAVE1544 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(177,63)
      SAVE1545 = JACC(45,45)
      JACC(45,45) = JACC(45,45)-DW(178,45)
      SAVE1546 = JACC(45,63)
      JACC(45,63) = JACC(45,63)-DW(178,63)
      SAVE1547 = JACC(59,45)
      JACC(59,45) = JACC(59,45)+0.3130000000000000d+00*DW(178,45)
      SAVE1548 = JACC(59,63)
      JACC(59,63) = JACC(59,63)+0.3130000000000000d+00*DW(178,63)
      SAVE1549 = JACC(61,45)
      JACC(61,45) = JACC(61,45)+0.9320000000000001d+00*DW(178,45)
      SAVE1550 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+0.9320000000000001d+00*DW(178,63)
      SAVE1551 = JACC(63,45)
      JACC(63,45) = JACC(63,45)-DW(178,45)
      SAVE1552 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(178,63)
      SAVE1553 = JACC(66,45)
      JACC(66,45) = JACC(66,45)+0.7550000000000000d+00*DW(178,45)
      SAVE1554 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.7550000000000000d+00*DW(178,63)
      SAVE1555 = JACC(71,45)
      JACC(71,45) = JACC(71,45)+DW(178,45)
      SAVE1556 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(178,63)
      SAVE1557 = JACC(39,39)
      JACC(39,39) = JACC(39,39)-DW(179,39)
      SAVE1558 = JACC(39,63)
      JACC(39,63) = JACC(39,63)-DW(179,63)
      SAVE1559 = JACC(40,39)
      JACC(40,39) = JACC(40,39)+0.3700000000000000d+00*DW(179,39)
      SAVE1560 = JACC(40,63)
      JACC(40,63) = JACC(40,63)+0.3700000000000000d+00*DW(179,63)
      SAVE1561 = JACC(44,39)
      JACC(44,39) = JACC(44,39)+0.8000000000000000d-01*DW(179,39)
      SAVE1562 = JACC(44,63)
      JACC(44,63) = JACC(44,63)+0.8000000000000000d-01*DW(179,63)
      SAVE1563 = JACC(49,39)
      JACC(49,39) = JACC(49,39)+0.5500000000000000d+00*DW(179,39)
      SAVE1564 = JACC(49,63)
      JACC(49,63) = JACC(49,63)+0.5500000000000000d+00*DW(179,63)
      SAVE1565 = JACC(63,39)
      JACC(63,39) = JACC(63,39)-DW(179,39)
      SAVE1566 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(179,63)
      SAVE1567 = JACC(66,39)
      JACC(66,39) = JACC(66,39)+0.1090000000000000d+01*DW(179,39)
      SAVE1568 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.1090000000000000d+01*DW(179,63)
      SAVE1569 = JACC(71,39)
      JACC(71,39) = JACC(71,39)+DW(179,39)
      SAVE1570 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(179,63)
      SAVE1571 = JACC(42,42)
      JACC(42,42) = JACC(42,42)-DW(180,42)
      SAVE1572 = JACC(42,63)
      JACC(42,63) = JACC(42,63)-DW(180,63)
      SAVE1573 = JACC(59,42)
      JACC(59,42) = JACC(59,42)+DW(180,42)
      SAVE1574 = JACC(59,63)
      JACC(59,63) = JACC(59,63)+DW(180,63)
      SAVE1575 = JACC(61,42)
      JACC(61,42) = JACC(61,42)+DW(180,42)
      SAVE1576 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+DW(180,63)
      SAVE1577 = JACC(63,42)
      JACC(63,42) = JACC(63,42)-DW(180,42)
      SAVE1578 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(180,63)
      SAVE1579 = JACC(66,42)
      JACC(66,42) = JACC(66,42)+DW(180,42)
      SAVE1580 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(180,63)
      SAVE1581 = JACC(71,42)
      JACC(71,42) = JACC(71,42)+0.2000000000000000d+01*DW(180,42)
      SAVE1582 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.2000000000000000d+01*DW(180,63)
      SAVE1583 = JACC(43,43)
      JACC(43,43) = JACC(43,43)-DW(181,43)
      SAVE1584 = JACC(43,63)
      JACC(43,63) = JACC(43,63)-DW(181,63)
      SAVE1585 = JACC(44,43)
      JACC(44,43) = JACC(44,43)+0.4000000000000000d+00*DW(181,43)
      SAVE1586 = JACC(44,63)
      JACC(44,63) = JACC(44,63)+0.4000000000000000d+00*DW(181,63)
      SAVE1587 = JACC(49,43)
      JACC(49,43) = JACC(49,43)+0.6000000000000000d+00*DW(181,43)
      SAVE1588 = JACC(49,63)
      JACC(49,63) = JACC(49,63)+0.6000000000000000d+00*DW(181,63)
      SAVE1589 = JACC(63,43)
      JACC(63,43) = JACC(63,43)-DW(181,43)
      SAVE1590 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(181,63)
      SAVE1591 = JACC(66,43)
      JACC(66,43) = JACC(66,43)+0.1400000000000000d+01*DW(181,43)
      SAVE1592 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.1400000000000000d+01*DW(181,63)
      SAVE1593 = JACC(71,43)
      JACC(71,43) = JACC(71,43)+0.2000000000000000d+01*DW(181,43)
      SAVE1594 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.2000000000000000d+01*DW(181,63)
      SAVE1595 = JACC(31,31)
      JACC(31,31) = JACC(31,31)-DW(182,31)
      SAVE1596 = JACC(31,63)
      JACC(31,63) = JACC(31,63)-DW(182,63)
      SAVE1597 = JACC(48,31)
      JACC(48,31) = JACC(48,31)+DW(182,31)
      SAVE1598 = JACC(48,63)
      JACC(48,63) = JACC(48,63)+DW(182,63)
      SAVE1599 = JACC(51,31)
      JACC(51,31) = JACC(51,31)+0.6500000000000000d+00*DW(182,31)
      SAVE1600 = JACC(51,63)
      JACC(51,63) = JACC(51,63)+0.6500000000000000d+00*DW(182,63)
      SAVE1601 = JACC(54,31)
      JACC(54,31) = JACC(54,31)+0.3500000000000000d+00*DW(182,31)
      SAVE1602 = JACC(54,63)
      JACC(54,63) = JACC(54,63)+0.3500000000000000d+00*DW(182,63)
      SAVE1603 = JACC(63,31)
      JACC(63,31) = JACC(63,31)-DW(182,31)
      SAVE1604 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(182,63)
      SAVE1605 = JACC(66,31)
      JACC(66,31) = JACC(66,31)+DW(182,31)
      SAVE1606 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(182,63)
      SAVE1607 = JACC(71,31)
      JACC(71,31) = JACC(71,31)+DW(182,31)
      SAVE1608 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(182,63)
      SAVE1609 = JACC(32,32)
      JACC(32,32) = JACC(32,32)-DW(183,32)
      SAVE1610 = JACC(32,63)
      JACC(32,63) = JACC(32,63)-DW(183,63)
      SAVE1611 = JACC(48,32)
      JACC(48,32) = JACC(48,32)+DW(183,32)
      SAVE1612 = JACC(48,63)
      JACC(48,63) = JACC(48,63)+DW(183,63)
      SAVE1613 = JACC(51,32)
      JACC(51,32) = JACC(51,32)+0.3700000000000000d+00*DW(183,32)
      SAVE1614 = JACC(51,63)
      JACC(51,63) = JACC(51,63)+0.3700000000000000d+00*DW(183,63)
      SAVE1615 = JACC(54,32)
      JACC(54,32) = JACC(54,32)+0.6300000000000000d+00*DW(183,32)
      SAVE1616 = JACC(54,63)
      JACC(54,63) = JACC(54,63)+0.6300000000000000d+00*DW(183,63)
      SAVE1617 = JACC(63,32)
      JACC(63,32) = JACC(63,32)-DW(183,32)
      SAVE1618 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(183,63)
      SAVE1619 = JACC(66,32)
      JACC(66,32) = JACC(66,32)+DW(183,32)
      SAVE1620 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(183,63)
      SAVE1621 = JACC(71,32)
      JACC(71,32) = JACC(71,32)+DW(183,32)
      SAVE1622 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(183,63)
      SAVE1623 = JACC(33,33)
      JACC(33,33) = JACC(33,33)-DW(184,33)
      SAVE1624 = JACC(33,63)
      JACC(33,63) = JACC(33,63)-DW(184,63)
      SAVE1625 = JACC(51,33)
      JACC(51,33) = JACC(51,33)+DW(184,33)
      SAVE1626 = JACC(51,63)
      JACC(51,63) = JACC(51,63)+DW(184,63)
      SAVE1627 = JACC(54,33)
      JACC(54,33) = JACC(54,33)+DW(184,33)
      SAVE1628 = JACC(54,63)
      JACC(54,63) = JACC(54,63)+DW(184,63)
      SAVE1629 = JACC(63,33)
      JACC(63,33) = JACC(63,33)-DW(184,33)
      SAVE1630 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(184,63)
      SAVE1631 = JACC(66,33)
      JACC(66,33) = JACC(66,33)+DW(184,33)
      SAVE1632 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(184,63)
      SAVE1633 = JACC(71,33)
      JACC(71,33) = JACC(71,33)+0.2000000000000000d+01*DW(184,33)
      SAVE1634 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.2000000000000000d+01*DW(184,63)
      SAVE1635 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+DW(185,69)
      SAVE1636 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(185,63)
      SAVE1637 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(185,69)
      SAVE1638 = JACC(69,63)
      JACC(69,63) = JACC(69,63)-DW(185,63)
      SAVE1639 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+DW(185,69)
      SAVE1640 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(185,63)
      SAVE1641 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+DW(186,69)
      SAVE1642 = JACC(57,63)
      JACC(57,63) = JACC(57,63)+DW(186,63)
      SAVE1643 = JACC(63,69)
      JACC(63,69) = JACC(63,69)-DW(186,69)
      SAVE1644 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(186,63)
      SAVE1645 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+DW(186,69)
      SAVE1646 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(186,63)
      SAVE1647 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(186,69)
      SAVE1648 = JACC(69,63)
      JACC(69,63) = JACC(69,63)-DW(186,63)
      SAVE1649 = JACC(56,56)
      JACC(56,56) = JACC(56,56)-DW(187,56)
      SAVE1650 = JACC(56,63)
      JACC(56,63) = JACC(56,63)-DW(187,63)
      SAVE1651 = JACC(63,56)
      JACC(63,56) = JACC(63,56)-DW(187,56)
      SAVE1652 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(187,63)
      SAVE1653 = JACC(66,56)
      JACC(66,56) = JACC(66,56)+0.2000000000000000d+01*DW(187,56)
      SAVE1654 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.2000000000000000d+01*DW(187,63)
      SAVE1655 = JACC(69,56)
      JACC(69,56) = JACC(69,56)+DW(187,56)
      SAVE1656 = JACC(69,63)
      JACC(69,63) = JACC(69,63)+DW(187,63)
      SAVE1657 = JACC(71,56)
      JACC(71,56) = JACC(71,56)+DW(187,56)
      SAVE1658 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(187,63)
      SAVE1659 = JACC(56,56)
      JACC(56,56) = JACC(56,56)-DW(188,56)
      SAVE1660 = JACC(56,63)
      JACC(56,63) = JACC(56,63)-DW(188,63)
      SAVE1661 = JACC(57,56)
      JACC(57,56) = JACC(57,56)+DW(188,56)
      SAVE1662 = JACC(57,63)
      JACC(57,63) = JACC(57,63)+DW(188,63)
      SAVE1663 = JACC(63,56)
      JACC(63,56) = JACC(63,56)-DW(188,56)
      SAVE1664 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(188,63)
      SAVE1665 = JACC(66,56)
      JACC(66,56) = JACC(66,56)+DW(188,56)
      SAVE1666 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(188,63)
      SAVE1667 = JACC(24,58)
      JACC(24,58) = JACC(24,58)+0.3000000000000000d+00*DW(189,58)
      SAVE1668 = JACC(24,63)
      JACC(24,63) = JACC(24,63)+0.3000000000000000d+00*DW(189,63)
      SAVE1669 = JACC(54,58)
      JACC(54,58) = JACC(54,58)+0.4000000000000000d+00*DW(189,58)
      SAVE1670 = JACC(54,63)
      JACC(54,63) = JACC(54,63)+0.4000000000000000d+00*DW(189,63)
      SAVE1671 = JACC(58,58)
      JACC(58,58) = JACC(58,58)-DW(189,58)
      SAVE1672 = JACC(58,63)
      JACC(58,63) = JACC(58,63)-DW(189,63)
      SAVE1673 = JACC(61,58)
      JACC(61,58) = JACC(61,58)+0.3000000000000000d+00*DW(189,58)
      SAVE1674 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+0.3000000000000000d+00*DW(189,63)
      SAVE1675 = JACC(63,58)
      JACC(63,58) = JACC(63,58)-DW(189,58)
      SAVE1676 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(189,63)
      SAVE1677 = JACC(65,58)
      JACC(65,58) = JACC(65,58)+0.8000000000000000d-01*DW(189,58)
      SAVE1678 = JACC(65,63)
      JACC(65,63) = JACC(65,63)+0.8000000000000000d-01*DW(189,63)
      SAVE1679 = JACC(66,58)
      JACC(66,58) = JACC(66,58)+0.7500000000000000d+00*DW(189,58)
      SAVE1680 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.7500000000000000d+00*DW(189,63)
      SAVE1681 = JACC(69,58)
      JACC(69,58) = JACC(69,58)+0.1200000000000000d+00*DW(189,58)
      SAVE1682 = JACC(69,63)
      JACC(69,63) = JACC(69,63)+0.1200000000000000d+00*DW(189,63)
      SAVE1683 = JACC(71,58)
      JACC(71,58) = JACC(71,58)+0.8800000000000000d+00*DW(189,58)
      SAVE1684 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.8800000000000000d+00*DW(189,63)
      SAVE1685 = JACC(47,47)
      JACC(47,47) = JACC(47,47)-DW(190,47)
      SAVE1686 = JACC(47,63)
      JACC(47,63) = JACC(47,63)-DW(190,63)
      SAVE1687 = JACC(63,47)
      JACC(63,47) = JACC(63,47)-DW(190,47)
      SAVE1688 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(190,63)
      SAVE1689 = JACC(66,47)
      JACC(66,47) = JACC(66,47)+0.7500000000000000d+00*DW(190,47)
      SAVE1690 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.7500000000000000d+00*DW(190,63)
      SAVE1691 = JACC(70,47)
      JACC(70,47) = JACC(70,47)+DW(190,47)
      SAVE1692 = JACC(70,63)
      JACC(70,63) = JACC(70,63)+DW(190,63)
      SAVE1693 = JACC(71,47)
      JACC(71,47) = JACC(71,47)+DW(190,47)
      SAVE1694 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(190,63)
      SAVE1695 = JACC(46,46)
      JACC(46,46) = JACC(46,46)-DW(191,46)
      SAVE1696 = JACC(46,63)
      JACC(46,63) = JACC(46,63)-DW(191,63)
      SAVE1697 = JACC(59,46)
      JACC(59,46) = JACC(59,46)+0.1490000000000000d+00*DW(191,46)
      SAVE1698 = JACC(59,63)
      JACC(59,63) = JACC(59,63)+0.1490000000000000d+00*DW(191,63)
      SAVE1699 = JACC(61,46)
      JACC(61,46) = JACC(61,46)+0.6400000000000000d+00*DW(191,46)
      SAVE1700 = JACC(61,63)
      JACC(61,63) = JACC(61,63)+0.6400000000000000d+00*DW(191,63)
      SAVE1701 = JACC(63,46)
      JACC(63,46) = JACC(63,46)-DW(191,46)
      SAVE1702 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(191,63)
      SAVE1703 = JACC(66,46)
      JACC(66,46) = JACC(66,46)+0.9600000000000000d+00*DW(191,46)
      SAVE1704 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+0.9600000000000000d+00*DW(191,63)
      SAVE1705 = JACC(70,46)
      JACC(70,46) = JACC(70,46)+0.5000000000000000d+00*DW(191,46)
      SAVE1706 = JACC(70,63)
      JACC(70,63) = JACC(70,63)+0.5000000000000000d+00*DW(191,63)
      SAVE1707 = JACC(71,46)
      JACC(71,46) = JACC(71,46)+0.5000000000000000d+00*DW(191,46)
      SAVE1708 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+0.5000000000000000d+00*DW(191,63)
      SAVE1709 = JACC(72,46)
      JACC(72,46) = JACC(72,46)+0.5000000000000000d+00*DW(191,46)
      SAVE1710 = JACC(72,63)
      JACC(72,63) = JACC(72,63)+0.5000000000000000d+00*DW(191,63)
      SAVE1711 = JACC(57,60)
      JACC(57,60) = JACC(57,60)+0.5000000000000000d+00*DW(192,60)
      SAVE1712 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.5000000000000000d+00*DW(192,69)
      SAVE1713 = JACC(60,60)
      JACC(60,60) = JACC(60,60)-DW(192,60)
      SAVE1714 = JACC(60,69)
      JACC(60,69) = JACC(60,69)-DW(192,69)
      SAVE1715 = JACC(61,60)
      JACC(61,60) = JACC(61,60)+DW(192,60)
      SAVE1716 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+DW(192,69)
      SAVE1717 = JACC(63,60)
      JACC(63,60) = JACC(63,60)+0.5000000000000000d+00*DW(192,60)
      SAVE1718 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5000000000000000d+00*DW(192,69)
      SAVE1719 = JACC(69,60)
      JACC(69,60) = JACC(69,60)-DW(192,60)
      SAVE1720 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(192,69)
      SAVE1721 = JACC(71,60)
      JACC(71,60) = JACC(71,60)+0.5000000000000000d+00*DW(192,60)
      SAVE1722 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.5000000000000000d+00*DW(192,69)
      SAVE1723 = JACC(51,64)
      JACC(51,64) = JACC(51,64)+0.1000000000000000d+00*DW(193,64)
      SAVE1724 = JACC(51,69)
      JACC(51,69) = JACC(51,69)+0.1000000000000000d+00*DW(193,69)
      SAVE1725 = JACC(54,64)
      JACC(54,64) = JACC(54,64)+0.4000000000000000d-02*DW(193,64)
      SAVE1726 = JACC(54,69)
      JACC(54,69) = JACC(54,69)+0.4000000000000000d-02*DW(193,69)
      SAVE1727 = JACC(57,64)
      JACC(57,64) = JACC(57,64)+0.4990000000000000d+00*DW(193,64)
      SAVE1728 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.4990000000000000d+00*DW(193,69)
      SAVE1729 = JACC(59,64)
      JACC(59,64) = JACC(59,64)+0.1270000000000000d+00*DW(193,64)
      SAVE1730 = JACC(59,69)
      JACC(59,69) = JACC(59,69)+0.1270000000000000d+00*DW(193,69)
      SAVE1731 = JACC(60,64)
      JACC(60,64) = JACC(60,64)+0.6000000000000000d-02*DW(193,64)
      SAVE1732 = JACC(60,69)
      JACC(60,69) = JACC(60,69)+0.6000000000000000d-02*DW(193,69)
      SAVE1733 = JACC(61,64)
      JACC(61,64) = JACC(61,64)+0.7240000000000000d+00*DW(193,64)
      SAVE1734 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+0.7240000000000000d+00*DW(193,69)
      SAVE1735 = JACC(63,64)
      JACC(63,64) = JACC(63,64)+0.5080000000000000d+00*DW(193,64)
      SAVE1736 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5080000000000000d+00*DW(193,69)
      SAVE1737 = JACC(64,64)
      JACC(64,64) = JACC(64,64)-DW(193,64)
      SAVE1738 = JACC(64,69)
      JACC(64,69) = JACC(64,69)-DW(193,69)
      SAVE1739 = JACC(65,64)
      JACC(65,64) = JACC(65,64)+0.7099999999999999d-01*DW(193,64)
      SAVE1740 = JACC(65,69)
      JACC(65,69) = JACC(65,69)+0.7099999999999999d-01*DW(193,69)
      SAVE1741 = JACC(66,64)
      JACC(66,64) = JACC(66,64)+0.9100000000000000d-01*DW(193,64)
      SAVE1742 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+0.9100000000000000d-01*DW(193,69)
      SAVE1743 = JACC(69,64)
      JACC(69,64) = JACC(69,64)-DW(193,64)
      SAVE1744 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(193,69)
      SAVE1745 = JACC(71,64)
      JACC(71,64) = JACC(71,64)+0.4880000000000000d+00*DW(193,64)
      SAVE1746 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.4880000000000000d+00*DW(193,69)
      SAVE1747 = JACC(36,36)
      JACC(36,36) = JACC(36,36)-DW(194,36)
      SAVE1748 = JACC(36,69)
      JACC(36,69) = JACC(36,69)-DW(194,69)
      SAVE1749 = JACC(57,36)
      JACC(57,36) = JACC(57,36)+0.4950000000000000d+00*DW(194,36)
      SAVE1750 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.4950000000000000d+00*DW(194,69)
      SAVE1751 = JACC(59,36)
      JACC(59,36) = JACC(59,36)+0.3300000000000000d+00*DW(194,36)
      SAVE1752 = JACC(59,69)
      JACC(59,69) = JACC(59,69)+0.3300000000000000d+00*DW(194,69)
      SAVE1753 = JACC(60,36)
      JACC(60,36) = JACC(60,36)+0.1800000000000000d-01*DW(194,36)
      SAVE1754 = JACC(60,69)
      JACC(60,69) = JACC(60,69)+0.1800000000000000d-01*DW(194,69)
      SAVE1755 = JACC(61,36)
      JACC(61,36) = JACC(61,36)+0.6770000000000000d+00*DW(194,36)
      SAVE1756 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+0.6770000000000000d+00*DW(194,69)
      SAVE1757 = JACC(63,36)
      JACC(63,36) = JACC(63,36)+0.5540000000000000d+00*DW(194,36)
      SAVE1758 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5540000000000000d+00*DW(194,69)
      SAVE1759 = JACC(65,36)
      JACC(65,36) = JACC(65,36)+0.2370000000000000d+00*DW(194,36)
      SAVE1760 = JACC(65,69)
      JACC(65,69) = JACC(65,69)+0.2370000000000000d+00*DW(194,69)
      SAVE1761 = JACC(66,36)
      JACC(66,36) = JACC(66,36)+0.7600000000000000d-01*DW(194,36)
      SAVE1762 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+0.7600000000000000d-01*DW(194,69)
      SAVE1763 = JACC(69,36)
      JACC(69,36) = JACC(69,36)-DW(194,36)
      SAVE1764 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(194,69)
      SAVE1765 = JACC(71,36)
      JACC(71,36) = JACC(71,36)+0.4380000000000000d+00*DW(194,36)
      SAVE1766 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.4380000000000000d+00*DW(194,69)
      SAVE1767 = JACC(37,37)
      JACC(37,37) = JACC(37,37)-DW(195,37)
      SAVE1768 = JACC(37,69)
      JACC(37,69) = JACC(37,69)-DW(195,69)
      SAVE1769 = JACC(57,37)
      JACC(57,37) = JACC(57,37)+0.4950000000000000d+00*DW(195,37)
      SAVE1770 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.4950000000000000d+00*DW(195,69)
      SAVE1771 = JACC(59,37)
      JACC(59,37) = JACC(59,37)+0.5810000000000000d+00*DW(195,37)
      SAVE1772 = JACC(59,69)
      JACC(59,69) = JACC(59,69)+0.5810000000000000d+00*DW(195,69)
      SAVE1773 = JACC(60,37)
      JACC(60,37) = JACC(60,37)+0.1500000000000000d-01*DW(195,37)
      SAVE1774 = JACC(60,69)
      JACC(60,69) = JACC(60,69)+0.1500000000000000d-01*DW(195,69)
      SAVE1775 = JACC(61,37)
      JACC(61,37) = JACC(61,37)+0.4970000000000000d+00*DW(195,37)
      SAVE1776 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+0.4970000000000000d+00*DW(195,69)
      SAVE1777 = JACC(63,37)
      JACC(63,37) = JACC(63,37)+0.5070000000000000d+00*DW(195,37)
      SAVE1778 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5070000000000000d+00*DW(195,69)
      SAVE1779 = JACC(65,37)
      JACC(65,37) = JACC(65,37)+0.3180000000000000d+00*DW(195,37)
      SAVE1780 = JACC(65,69)
      JACC(65,69) = JACC(65,69)+0.3180000000000000d+00*DW(195,69)
      SAVE1781 = JACC(69,37)
      JACC(69,37) = JACC(69,37)-DW(195,37)
      SAVE1782 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(195,69)
      SAVE1783 = JACC(71,37)
      JACC(71,37) = JACC(71,37)+0.4890000000000000d+00*DW(195,37)
      SAVE1784 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.4890000000000000d+00*DW(195,69)
      SAVE1785 = JACC(38,38)
      JACC(38,38) = JACC(38,38)-DW(196,38)
      SAVE1786 = JACC(38,69)
      JACC(38,69) = JACC(38,69)-DW(196,69)
      SAVE1787 = JACC(57,38)
      JACC(57,38) = JACC(57,38)+0.5000000000000000d+00*DW(196,38)
      SAVE1788 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.5000000000000000d+00*DW(196,69)
      SAVE1789 = JACC(61,38)
      JACC(61,38) = JACC(61,38)+0.6000000000000000d+00*DW(196,38)
      SAVE1790 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+0.6000000000000000d+00*DW(196,69)
      SAVE1791 = JACC(63,38)
      JACC(63,38) = JACC(63,38)+0.5000000000000000d+00*DW(196,38)
      SAVE1792 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5000000000000000d+00*DW(196,69)
      SAVE1793 = JACC(66,38)
      JACC(66,38) = JACC(66,38)+0.8000000000000000d+00*DW(196,38)
      SAVE1794 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+0.8000000000000000d+00*DW(196,69)
      SAVE1795 = JACC(69,38)
      JACC(69,38) = JACC(69,38)-DW(196,38)
      SAVE1796 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(196,69)
      SAVE1797 = JACC(71,38)
      JACC(71,38) = JACC(71,38)+0.5000000000000000d+00*DW(196,38)
      SAVE1798 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.5000000000000000d+00*DW(196,69)
      SAVE1799 = JACC(41,41)
      JACC(41,41) = JACC(41,41)-DW(197,41)
      SAVE1800 = JACC(41,69)
      JACC(41,69) = JACC(41,69)-DW(197,69)
      SAVE1801 = JACC(57,41)
      JACC(57,41) = JACC(57,41)+0.4990000000000000d+00*DW(197,41)
      SAVE1802 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.4990000000000000d+00*DW(197,69)
      SAVE1803 = JACC(59,41)
      JACC(59,41) = JACC(59,41)+0.1410000000000000d+00*DW(197,41)
      SAVE1804 = JACC(59,69)
      JACC(59,69) = JACC(59,69)+0.1410000000000000d+00*DW(197,69)
      SAVE1805 = JACC(61,41)
      JACC(61,41) = JACC(61,41)+0.8590000000000000d+00*DW(197,41)
      SAVE1806 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+0.8590000000000000d+00*DW(197,69)
      SAVE1807 = JACC(63,41)
      JACC(63,41) = JACC(63,41)+0.5010000000000000d+00*DW(197,41)
      SAVE1808 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5010000000000000d+00*DW(197,69)
      SAVE1809 = JACC(66,41)
      JACC(66,41) = JACC(66,41)+0.5010000000000000d+00*DW(197,41)
      SAVE1810 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+0.5010000000000000d+00*DW(197,69)
      SAVE1811 = JACC(69,41)
      JACC(69,41) = JACC(69,41)-DW(197,41)
      SAVE1812 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(197,69)
      SAVE1813 = JACC(71,41)
      JACC(71,41) = JACC(71,41)+0.5010000000000000d+00*DW(197,41)
      SAVE1814 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.5010000000000000d+00*DW(197,69)
      SAVE1815 = JACC(45,45)
      JACC(45,45) = JACC(45,45)-DW(198,45)
      SAVE1816 = JACC(45,69)
      JACC(45,69) = JACC(45,69)-DW(198,69)
      SAVE1817 = JACC(57,45)
      JACC(57,45) = JACC(57,45)+0.4900000000000000d+00*DW(198,45)
      SAVE1818 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.4900000000000000d+00*DW(198,69)
      SAVE1819 = JACC(59,45)
      JACC(59,45) = JACC(59,45)+0.5690000000000000d+00*DW(198,45)
      SAVE1820 = JACC(59,69)
      JACC(59,69) = JACC(59,69)+0.5690000000000000d+00*DW(198,69)
      SAVE1821 = JACC(61,45)
      JACC(61,45) = JACC(61,45)+0.9409999999999999d+00*DW(198,45)
      SAVE1822 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+0.9409999999999999d+00*DW(198,69)
      SAVE1823 = JACC(63,45)
      JACC(63,45) = JACC(63,45)+0.5100000000000000d+00*DW(198,45)
      SAVE1824 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5100000000000000d+00*DW(198,69)
      SAVE1825 = JACC(69,45)
      JACC(69,45) = JACC(69,45)-DW(198,45)
      SAVE1826 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(198,69)
      SAVE1827 = JACC(71,45)
      JACC(71,45) = JACC(71,45)+0.5100000000000000d+00*DW(198,45)
      SAVE1828 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.5100000000000000d+00*DW(198,69)
      SAVE1829 = JACC(39,39)
      JACC(39,39) = JACC(39,39)-DW(199,39)
      SAVE1830 = JACC(39,69)
      JACC(39,69) = JACC(39,69)-DW(199,69)
      SAVE1831 = JACC(40,39)
      JACC(40,39) = JACC(40,39)+0.2290000000000000d+00*DW(199,39)
      SAVE1832 = JACC(40,69)
      JACC(40,69) = JACC(40,69)+0.2290000000000000d+00*DW(199,69)
      SAVE1833 = JACC(49,39)
      JACC(49,39) = JACC(49,39)+0.7710000000000000d+00*DW(199,39)
      SAVE1834 = JACC(49,69)
      JACC(49,69) = JACC(49,69)+0.7710000000000000d+00*DW(199,69)
      SAVE1835 = JACC(57,39)
      JACC(57,39) = JACC(57,39)+0.4940000000000000d+00*DW(199,39)
      SAVE1836 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.4940000000000000d+00*DW(199,69)
      SAVE1837 = JACC(63,39)
      JACC(63,39) = JACC(63,39)+0.5060000000000000d+00*DW(199,39)
      SAVE1838 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5060000000000000d+00*DW(199,69)
      SAVE1839 = JACC(66,39)
      JACC(66,39) = JACC(66,39)+0.3400000000000000d+00*DW(199,39)
      SAVE1840 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+0.3400000000000000d+00*DW(199,69)
      SAVE1841 = JACC(69,39)
      JACC(69,39) = JACC(69,39)-DW(199,39)
      SAVE1842 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(199,69)
      SAVE1843 = JACC(71,39)
      JACC(71,39) = JACC(71,39)+0.5060000000000000d+00*DW(199,39)
      SAVE1844 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.5060000000000000d+00*DW(199,69)
      SAVE1845 = JACC(42,42)
      JACC(42,42) = JACC(42,42)-DW(200,42)
      SAVE1846 = JACC(42,69)
      JACC(42,69) = JACC(42,69)-DW(200,69)
      SAVE1847 = JACC(59,42)
      JACC(59,42) = JACC(59,42)+DW(200,42)
      SAVE1848 = JACC(59,69)
      JACC(59,69) = JACC(59,69)+DW(200,69)
      SAVE1849 = JACC(61,42)
      JACC(61,42) = JACC(61,42)+DW(200,42)
      SAVE1850 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+DW(200,69)
      SAVE1851 = JACC(63,42)
      JACC(63,42) = JACC(63,42)+DW(200,42)
      SAVE1852 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+DW(200,69)
      SAVE1853 = JACC(69,42)
      JACC(69,42) = JACC(69,42)-DW(200,42)
      SAVE1854 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(200,69)
      SAVE1855 = JACC(71,42)
      JACC(71,42) = JACC(71,42)+DW(200,42)
      SAVE1856 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+DW(200,69)
      SAVE1857 = JACC(43,43)
      JACC(43,43) = JACC(43,43)-DW(201,43)
      SAVE1858 = JACC(43,69)
      JACC(43,69) = JACC(43,69)-DW(201,69)
      SAVE1859 = JACC(44,43)
      JACC(44,43) = JACC(44,43)+0.4000000000000000d+00*DW(201,43)
      SAVE1860 = JACC(44,69)
      JACC(44,69) = JACC(44,69)+0.4000000000000000d+00*DW(201,69)
      SAVE1861 = JACC(49,43)
      JACC(49,43) = JACC(49,43)+0.6000000000000000d+00*DW(201,43)
      SAVE1862 = JACC(49,69)
      JACC(49,69) = JACC(49,69)+0.6000000000000000d+00*DW(201,69)
      SAVE1863 = JACC(63,43)
      JACC(63,43) = JACC(63,43)+DW(201,43)
      SAVE1864 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+DW(201,69)
      SAVE1865 = JACC(66,43)
      JACC(66,43) = JACC(66,43)+0.4000000000000000d+00*DW(201,43)
      SAVE1866 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+0.4000000000000000d+00*DW(201,69)
      SAVE1867 = JACC(69,43)
      JACC(69,43) = JACC(69,43)-DW(201,43)
      SAVE1868 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(201,69)
      SAVE1869 = JACC(71,43)
      JACC(71,43) = JACC(71,43)+DW(201,43)
      SAVE1870 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+DW(201,69)
      SAVE1871 = JACC(31,31)
      JACC(31,31) = JACC(31,31)-DW(202,31)
      SAVE1872 = JACC(31,69)
      JACC(31,69) = JACC(31,69)-DW(202,69)
      SAVE1873 = JACC(48,31)
      JACC(48,31) = JACC(48,31)+DW(202,31)
      SAVE1874 = JACC(48,69)
      JACC(48,69) = JACC(48,69)+DW(202,69)
      SAVE1875 = JACC(51,31)
      JACC(51,31) = JACC(51,31)+0.6500000000000000d+00*DW(202,31)
      SAVE1876 = JACC(51,69)
      JACC(51,69) = JACC(51,69)+0.6500000000000000d+00*DW(202,69)
      SAVE1877 = JACC(54,31)
      JACC(54,31) = JACC(54,31)+0.3500000000000000d+00*DW(202,31)
      SAVE1878 = JACC(54,69)
      JACC(54,69) = JACC(54,69)+0.3500000000000000d+00*DW(202,69)
      SAVE1879 = JACC(63,31)
      JACC(63,31) = JACC(63,31)+DW(202,31)
      SAVE1880 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+DW(202,69)
      SAVE1881 = JACC(69,31)
      JACC(69,31) = JACC(69,31)-DW(202,31)
      SAVE1882 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(202,69)
      SAVE1883 = JACC(71,31)
      JACC(71,31) = JACC(71,31)+DW(202,31)
      SAVE1884 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+DW(202,69)
      SAVE1885 = JACC(32,32)
      JACC(32,32) = JACC(32,32)-DW(203,32)
      SAVE1886 = JACC(32,69)
      JACC(32,69) = JACC(32,69)-DW(203,69)
      SAVE1887 = JACC(48,32)
      JACC(48,32) = JACC(48,32)+DW(203,32)
      SAVE1888 = JACC(48,69)
      JACC(48,69) = JACC(48,69)+DW(203,69)
      SAVE1889 = JACC(51,32)
      JACC(51,32) = JACC(51,32)+0.3700000000000000d+00*DW(203,32)
      SAVE1890 = JACC(51,69)
      JACC(51,69) = JACC(51,69)+0.3700000000000000d+00*DW(203,69)
      SAVE1891 = JACC(54,32)
      JACC(54,32) = JACC(54,32)+0.6300000000000000d+00*DW(203,32)
      SAVE1892 = JACC(54,69)
      JACC(54,69) = JACC(54,69)+0.6300000000000000d+00*DW(203,69)
      SAVE1893 = JACC(63,32)
      JACC(63,32) = JACC(63,32)+DW(203,32)
      SAVE1894 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+DW(203,69)
      SAVE1895 = JACC(69,32)
      JACC(69,32) = JACC(69,32)-DW(203,32)
      SAVE1896 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(203,69)
      SAVE1897 = JACC(71,32)
      JACC(71,32) = JACC(71,32)+DW(203,32)
      SAVE1898 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+DW(203,69)
      SAVE1899 = JACC(33,33)
      JACC(33,33) = JACC(33,33)-DW(204,33)
      SAVE1900 = JACC(33,69)
      JACC(33,69) = JACC(33,69)-DW(204,69)
      SAVE1901 = JACC(51,33)
      JACC(51,33) = JACC(51,33)+DW(204,33)
      SAVE1902 = JACC(51,69)
      JACC(51,69) = JACC(51,69)+DW(204,69)
      SAVE1903 = JACC(54,33)
      JACC(54,33) = JACC(54,33)+DW(204,33)
      SAVE1904 = JACC(54,69)
      JACC(54,69) = JACC(54,69)+DW(204,69)
      SAVE1905 = JACC(63,33)
      JACC(63,33) = JACC(63,33)+DW(204,33)
      SAVE1906 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+DW(204,69)
      SAVE1907 = JACC(69,33)
      JACC(69,33) = JACC(69,33)-DW(204,33)
      SAVE1908 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(204,69)
      SAVE1909 = JACC(71,33)
      JACC(71,33) = JACC(71,33)+DW(204,33)
      SAVE1910 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+DW(204,69)
      SAVE1911 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.2000000000000000d+01*DW(205,69)
      SAVE1912 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.2000000000000000d+01*DW(205,69)
      SAVE1913 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-0.2000000000000000d+01*DW(205,69)
      SAVE1914 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-0.2000000000000000d+01*DW(205,69)
      SAVE1915 = JACC(56,56)
      JACC(56,56) = JACC(56,56)-DW(206,56)
      SAVE1916 = JACC(56,69)
      JACC(56,69) = JACC(56,69)-DW(206,69)
      SAVE1917 = JACC(63,56)
      JACC(63,56) = JACC(63,56)+DW(206,56)
      SAVE1918 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+DW(206,69)
      SAVE1919 = JACC(66,56)
      JACC(66,56) = JACC(66,56)+DW(206,56)
      SAVE1920 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+DW(206,69)
      SAVE1921 = JACC(54,58)
      JACC(54,58) = JACC(54,58)+0.5400000000000000d+00*DW(207,58)
      SAVE1922 = JACC(54,69)
      JACC(54,69) = JACC(54,69)+0.5400000000000000d+00*DW(207,69)
      SAVE1923 = JACC(57,58)
      JACC(57,58) = JACC(57,58)+0.5000000000000000d+00*DW(207,58)
      SAVE1924 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.5000000000000000d+00*DW(207,69)
      SAVE1925 = JACC(58,58)
      JACC(58,58) = JACC(58,58)-DW(207,58)
      SAVE1926 = JACC(58,69)
      JACC(58,69) = JACC(58,69)-DW(207,69)
      SAVE1927 = JACC(59,58)
      JACC(59,58) = JACC(59,58)+0.1100000000000000d+00*DW(207,58)
      SAVE1928 = JACC(59,69)
      JACC(59,69) = JACC(59,69)+0.1100000000000000d+00*DW(207,69)
      SAVE1929 = JACC(61,58)
      JACC(61,58) = JACC(61,58)+0.3500000000000000d+00*DW(207,58)
      SAVE1930 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+0.3500000000000000d+00*DW(207,69)
      SAVE1931 = JACC(63,58)
      JACC(63,58) = JACC(63,58)+0.5000000000000000d+00*DW(207,58)
      SAVE1932 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5000000000000000d+00*DW(207,69)
      SAVE1933 = JACC(65,58)
      JACC(65,58) = JACC(65,58)+0.8000000000000000d-01*DW(207,58)
      SAVE1934 = JACC(65,69)
      JACC(65,69) = JACC(65,69)+0.8000000000000000d-01*DW(207,69)
      SAVE1935 = JACC(69,58)
      JACC(69,58) = JACC(69,58)-0.8800000000000000d+00*DW(207,58)
      SAVE1936 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-0.8800000000000000d+00*DW(207,69)
      SAVE1937 = JACC(71,58)
      JACC(71,58) = JACC(71,58)+0.3800000000000000d+00*DW(207,58)
      SAVE1938 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.3800000000000000d+00*DW(207,69)
      SAVE1939 = JACC(47,47)
      JACC(47,47) = JACC(47,47)-DW(208,47)
      SAVE1940 = JACC(47,69)
      JACC(47,69) = JACC(47,69)-DW(208,69)
      SAVE1941 = JACC(57,47)
      JACC(57,47) = JACC(57,47)+0.5000000000000000d+00*DW(208,47)
      SAVE1942 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.5000000000000000d+00*DW(208,69)
      SAVE1943 = JACC(63,47)
      JACC(63,47) = JACC(63,47)+0.5000000000000000d+00*DW(208,47)
      SAVE1944 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5000000000000000d+00*DW(208,69)
      SAVE1945 = JACC(69,47)
      JACC(69,47) = JACC(69,47)-DW(208,47)
      SAVE1946 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(208,69)
      SAVE1947 = JACC(70,47)
      JACC(70,47) = JACC(70,47)+DW(208,47)
      SAVE1948 = JACC(70,69)
      JACC(70,69) = JACC(70,69)+DW(208,69)
      SAVE1949 = JACC(71,47)
      JACC(71,47) = JACC(71,47)+0.5000000000000000d+00*DW(208,47)
      SAVE1950 = JACC(71,69)
      JACC(71,69) = JACC(71,69)+0.5000000000000000d+00*DW(208,69)
      SAVE1951 = JACC(46,46)
      JACC(46,46) = JACC(46,46)-DW(209,46)
      SAVE1952 = JACC(46,69)
      JACC(46,69) = JACC(46,69)-DW(209,69)
      SAVE1953 = JACC(57,46)
      JACC(57,46) = JACC(57,46)+0.4840000000000000d+00*DW(209,46)
      SAVE1954 = JACC(57,69)
      JACC(57,69) = JACC(57,69)+0.4840000000000000d+00*DW(209,69)
      SAVE1955 = JACC(59,46)
      JACC(59,46) = JACC(59,46)+0.1670000000000000d+00*DW(209,46)
      SAVE1956 = JACC(59,69)
      JACC(59,69) = JACC(59,69)+0.1670000000000000d+00*DW(209,69)
      SAVE1957 = JACC(61,46)
      JACC(61,46) = JACC(61,46)+0.6500000000000000d+00*DW(209,46)
      SAVE1958 = JACC(61,69)
      JACC(61,69) = JACC(61,69)+0.6500000000000000d+00*DW(209,69)
      SAVE1959 = JACC(63,46)
      JACC(63,46) = JACC(63,46)+0.5160000000000000d+00*DW(209,46)
      SAVE1960 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+0.5160000000000000d+00*DW(209,69)
      SAVE1961 = JACC(66,46)
      JACC(66,46) = JACC(66,46)+0.2070000000000000d+00*DW(209,46)
      SAVE1962 = JACC(66,69)
      JACC(66,69) = JACC(66,69)+0.2070000000000000d+00*DW(209,69)
      SAVE1963 = JACC(69,46)
      JACC(69,46) = JACC(69,46)-DW(209,46)
      SAVE1964 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(209,69)
      SAVE1965 = JACC(70,46)
      JACC(70,46) = JACC(70,46)+0.4840000000000000d+00*DW(209,46)
      SAVE1966 = JACC(70,69)
      JACC(70,69) = JACC(70,69)+0.4840000000000000d+00*DW(209,69)
      SAVE1967 = JACC(72,46)
      JACC(72,46) = JACC(72,46)+0.5160000000000000d+00*DW(209,46)
      SAVE1968 = JACC(72,69)
      JACC(72,69) = JACC(72,69)+0.5160000000000000d+00*DW(209,69)
      SAVE1969 = JACC(47,47)
      JACC(47,47) = JACC(47,47)-0.2000000000000000d+01*DW(210,47)
      SAVE1970 = JACC(47,47)
      JACC(47,47) = JACC(47,47)-0.2000000000000000d+01*DW(210,47)
      SAVE1971 = JACC(70,47)
      JACC(70,47) = JACC(70,47)+0.2000000000000000d+01*DW(210,47)
      SAVE1972 = JACC(70,47)
      JACC(70,47) = JACC(70,47)+0.2000000000000000d+01*DW(210,47)
      SAVE1973 = JACC(71,47)
      JACC(71,47) = JACC(71,47)+DW(210,47)
      SAVE1974 = JACC(71,47)
      JACC(71,47) = JACC(71,47)+DW(210,47)
      SAVE1975 = JACC(46,47)
      JACC(46,47) = JACC(46,47)-DW(211,47)
      SAVE1976 = JACC(46,46)
      JACC(46,46) = JACC(46,46)-DW(211,46)
      SAVE1977 = JACC(47,47)
      JACC(47,47) = JACC(47,47)-DW(211,47)
      SAVE1978 = JACC(47,46)
      JACC(47,46) = JACC(47,46)-DW(211,46)
      SAVE1979 = JACC(59,47)
      JACC(59,47) = JACC(59,47)+0.1490000000000000d+00*DW(211,47)
      SAVE1980 = JACC(59,46)
      JACC(59,46) = JACC(59,46)+0.1490000000000000d+00*DW(211,46)
      SAVE1981 = JACC(61,47)
      JACC(61,47) = JACC(61,47)+0.6400000000000000d+00*DW(211,47)
      SAVE1982 = JACC(61,46)
      JACC(61,46) = JACC(61,46)+0.6400000000000000d+00*DW(211,46)
      SAVE1983 = JACC(66,47)
      JACC(66,47) = JACC(66,47)+0.2020000000000000d+00*DW(211,47)
      SAVE1984 = JACC(66,46)
      JACC(66,46) = JACC(66,46)+0.2020000000000000d+00*DW(211,46)
      SAVE1985 = JACC(70,47)
      JACC(70,47) = JACC(70,47)+0.1500000000000000d+01*DW(211,47)
      SAVE1986 = JACC(70,46)
      JACC(70,46) = JACC(70,46)+0.1500000000000000d+01*DW(211,46)
      SAVE1987 = JACC(71,47)
      JACC(71,47) = JACC(71,47)+0.5000000000000000d+00*DW(211,47)
      SAVE1988 = JACC(71,46)
      JACC(71,46) = JACC(71,46)+0.5000000000000000d+00*DW(211,46)
      SAVE1989 = JACC(72,47)
      JACC(72,47) = JACC(72,47)+0.5000000000000000d+00*DW(211,47)
      SAVE1990 = JACC(72,46)
      JACC(72,46) = JACC(72,46)+0.5000000000000000d+00*DW(211,46)
      SAVE1991 = JACC(46,46)
      JACC(46,46) = JACC(46,46)-0.2000000000000000d+01*DW(212,46)
      SAVE1992 = JACC(46,46)
      JACC(46,46) = JACC(46,46)-0.2000000000000000d+01*DW(212,46)
      SAVE1993 = JACC(59,46)
      JACC(59,46) = JACC(59,46)+0.2850000000000000d+00*DW(212,46)
      SAVE1994 = JACC(59,46)
      JACC(59,46) = JACC(59,46)+0.2850000000000000d+00*DW(212,46)
      SAVE1995 = JACC(61,46)
      JACC(61,46) = JACC(61,46)+0.1210000000000000d+01*DW(212,46)
      SAVE1996 = JACC(61,46)
      JACC(61,46) = JACC(61,46)+0.1210000000000000d+01*DW(212,46)
      SAVE1997 = JACC(66,46)
      JACC(66,46) = JACC(66,46)+0.5040000000000000d+00*DW(212,46)
      SAVE1998 = JACC(66,46)
      JACC(66,46) = JACC(66,46)+0.5040000000000000d+00*DW(212,46)
      SAVE1999 = JACC(70,46)
      JACC(70,46) = JACC(70,46)+DW(212,46)
      SAVE2000 = JACC(70,46)
      JACC(70,46) = JACC(70,46)+DW(212,46)
      SAVE2001 = JACC(72,46)
      JACC(72,46) = JACC(72,46)+DW(212,46)
      SAVE2002 = JACC(72,46)
      JACC(72,46) = JACC(72,46)+DW(212,46)
      SAVE2003 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(213,63)
      SAVE2004 = JACC(63,68)
      JACC(63,68) = JACC(63,68)-DW(213,68)
      SAVE2005 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(213,63)
      SAVE2006 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+DW(213,68)
      SAVE2007 = JACC(68,63)
      JACC(68,63) = JACC(68,63)-DW(213,63)
      SAVE2008 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(213,68)
      SAVE2009 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(213,63)
      SAVE2010 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(213,68)
      SAVE2011 = JACC(72,63)
      JACC(72,63) = JACC(72,63)+DW(213,63)
      SAVE2012 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(213,68)
      SAVE2013 = JACC(60,60)
      JACC(60,60) = JACC(60,60)-DW(214,60)
      SAVE2014 = JACC(60,68)
      JACC(60,68) = JACC(60,68)-DW(214,68)
      SAVE2015 = JACC(61,60)
      JACC(61,60) = JACC(61,60)+DW(214,60)
      SAVE2016 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+DW(214,68)
      SAVE2017 = JACC(68,60)
      JACC(68,60) = JACC(68,60)-DW(214,60)
      SAVE2018 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(214,68)
      SAVE2019 = JACC(71,60)
      JACC(71,60) = JACC(71,60)+DW(214,60)
      SAVE2020 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(214,68)
      SAVE2021 = JACC(72,60)
      JACC(72,60) = JACC(72,60)+DW(214,60)
      SAVE2022 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(214,68)
      SAVE2023 = JACC(51,64)
      JACC(51,64) = JACC(51,64)+0.6300000000000000d-01*DW(215,64)
      SAVE2024 = JACC(51,68)
      JACC(51,68) = JACC(51,68)+0.6300000000000000d-01*DW(215,68)
      SAVE2025 = JACC(59,64)
      JACC(59,64) = JACC(59,64)+0.6700000000000000d+00*DW(215,64)
      SAVE2026 = JACC(59,68)
      JACC(59,68) = JACC(59,68)+0.6700000000000000d+00*DW(215,68)
      SAVE2027 = JACC(60,64)
      JACC(60,64) = JACC(60,64)+0.5300000000000000d-01*DW(215,64)
      SAVE2028 = JACC(60,68)
      JACC(60,68) = JACC(60,68)+0.5300000000000000d-01*DW(215,68)
      SAVE2029 = JACC(61,64)
      JACC(61,64) = JACC(61,64)+0.2430000000000000d+00*DW(215,64)
      SAVE2030 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+0.2430000000000000d+00*DW(215,68)
      SAVE2031 = JACC(63,64)
      JACC(63,64) = JACC(63,64)+0.1550000000000000d+00*DW(215,64)
      SAVE2032 = JACC(63,68)
      JACC(63,68) = JACC(63,68)+0.1550000000000000d+00*DW(215,68)
      SAVE2033 = JACC(64,64)
      JACC(64,64) = JACC(64,64)-DW(215,64)
      SAVE2034 = JACC(64,68)
      JACC(64,68) = JACC(64,68)-DW(215,68)
      SAVE2035 = JACC(65,64)
      JACC(65,64) = JACC(65,64)+0.5100000000000000d-01*DW(215,64)
      SAVE2036 = JACC(65,68)
      JACC(65,68) = JACC(65,68)+0.5100000000000000d-01*DW(215,68)
      SAVE2037 = JACC(66,64)
      JACC(66,64) = JACC(66,64)+0.4800000000000000d-01*DW(215,64)
      SAVE2038 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+0.4800000000000000d-01*DW(215,68)
      SAVE2039 = JACC(68,64)
      JACC(68,64) = JACC(68,64)-DW(215,64)
      SAVE2040 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(215,68)
      SAVE2041 = JACC(71,64)
      JACC(71,64) = JACC(71,64)+0.7920000000000000d+00*DW(215,64)
      SAVE2042 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+0.7920000000000000d+00*DW(215,68)
      SAVE2043 = JACC(72,64)
      JACC(72,64) = JACC(72,64)+DW(215,64)
      SAVE2044 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(215,68)
      SAVE2045 = JACC(36,36)
      JACC(36,36) = JACC(36,36)-DW(216,36)
      SAVE2046 = JACC(36,68)
      JACC(36,68) = JACC(36,68)-DW(216,68)
      SAVE2047 = JACC(59,36)
      JACC(59,36) = JACC(59,36)+0.8280000000000000d+00*DW(216,36)
      SAVE2048 = JACC(59,68)
      JACC(59,68) = JACC(59,68)+0.8280000000000000d+00*DW(216,68)
      SAVE2049 = JACC(60,36)
      JACC(60,36) = JACC(60,36)+0.2620000000000000d+00*DW(216,36)
      SAVE2050 = JACC(60,68)
      JACC(60,68) = JACC(60,68)+0.2620000000000000d+00*DW(216,68)
      SAVE2051 = JACC(61,36)
      JACC(61,36) = JACC(61,36)+0.2390000000000000d+00*DW(216,36)
      SAVE2052 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+0.2390000000000000d+00*DW(216,68)
      SAVE2053 = JACC(63,36)
      JACC(63,36) = JACC(63,36)+0.4000000000000000d-01*DW(216,36)
      SAVE2054 = JACC(63,68)
      JACC(63,68) = JACC(63,68)+0.4000000000000000d-01*DW(216,68)
      SAVE2055 = JACC(65,36)
      JACC(65,36) = JACC(65,36)+0.3910000000000000d+00*DW(216,36)
      SAVE2056 = JACC(65,68)
      JACC(65,68) = JACC(65,68)+0.3910000000000000d+00*DW(216,68)
      SAVE2057 = JACC(66,36)
      JACC(66,36) = JACC(66,36)+0.2100000000000000d-01*DW(216,36)
      SAVE2058 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+0.2100000000000000d-01*DW(216,68)
      SAVE2059 = JACC(68,36)
      JACC(68,36) = JACC(68,36)-DW(216,36)
      SAVE2060 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(216,68)
      SAVE2061 = JACC(71,36)
      JACC(71,36) = JACC(71,36)+0.6990000000000000d+00*DW(216,36)
      SAVE2062 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+0.6990000000000000d+00*DW(216,68)
      SAVE2063 = JACC(72,36)
      JACC(72,36) = JACC(72,36)+DW(216,36)
      SAVE2064 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(216,68)
      SAVE2065 = JACC(37,37)
      JACC(37,37) = JACC(37,37)-DW(217,37)
      SAVE2066 = JACC(37,68)
      JACC(37,68) = JACC(37,68)-DW(217,68)
      SAVE2067 = JACC(59,37)
      JACC(59,37) = JACC(59,37)+0.8800000000000000d+00*DW(217,37)
      SAVE2068 = JACC(59,68)
      JACC(59,68) = JACC(59,68)+0.8800000000000000d+00*DW(217,68)
      SAVE2069 = JACC(60,37)
      JACC(60,37) = JACC(60,37)+0.1550000000000000d+00*DW(217,37)
      SAVE2070 = JACC(60,68)
      JACC(60,68) = JACC(60,68)+0.1550000000000000d+00*DW(217,68)
      SAVE2071 = JACC(61,37)
      JACC(61,37) = JACC(61,37)+0.1870000000000000d+00*DW(217,37)
      SAVE2072 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+0.1870000000000000d+00*DW(217,68)
      SAVE2073 = JACC(65,37)
      JACC(65,37) = JACC(65,37)+0.5870000000000000d+00*DW(217,37)
      SAVE2074 = JACC(65,68)
      JACC(65,68) = JACC(65,68)+0.5870000000000000d+00*DW(217,68)
      SAVE2075 = JACC(68,37)
      JACC(68,37) = JACC(68,37)-DW(217,37)
      SAVE2076 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(217,68)
      SAVE2077 = JACC(71,37)
      JACC(71,37) = JACC(71,37)+0.8450000000000000d+00*DW(217,37)
      SAVE2078 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+0.8450000000000000d+00*DW(217,68)
      SAVE2079 = JACC(72,37)
      JACC(72,37) = JACC(72,37)+DW(217,37)
      SAVE2080 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(217,68)
      SAVE2081 = JACC(38,38)
      JACC(38,38) = JACC(38,38)-DW(218,38)
      SAVE2082 = JACC(38,68)
      JACC(38,68) = JACC(38,68)-DW(218,68)
      SAVE2083 = JACC(61,38)
      JACC(61,38) = JACC(61,38)+0.2000000000000000d+00*DW(218,38)
      SAVE2084 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+0.2000000000000000d+00*DW(218,68)
      SAVE2085 = JACC(66,38)
      JACC(66,38) = JACC(66,38)+0.1600000000000000d+01*DW(218,38)
      SAVE2086 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+0.1600000000000000d+01*DW(218,68)
      SAVE2087 = JACC(68,38)
      JACC(68,38) = JACC(68,38)-DW(218,38)
      SAVE2088 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(218,68)
      SAVE2089 = JACC(71,38)
      JACC(71,38) = JACC(71,38)+DW(218,38)
      SAVE2090 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(218,68)
      SAVE2091 = JACC(72,38)
      JACC(72,38) = JACC(72,38)+DW(218,38)
      SAVE2092 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(218,68)
      SAVE2093 = JACC(41,41)
      JACC(41,41) = JACC(41,41)-DW(219,41)
      SAVE2094 = JACC(41,68)
      JACC(41,68) = JACC(41,68)-DW(219,68)
      SAVE2095 = JACC(59,41)
      JACC(59,41) = JACC(59,41)+0.6000000000000000d-01*DW(219,41)
      SAVE2096 = JACC(59,68)
      JACC(59,68) = JACC(59,68)+0.6000000000000000d-01*DW(219,68)
      SAVE2097 = JACC(61,41)
      JACC(61,41) = JACC(61,41)+0.9399999999999999d+00*DW(219,41)
      SAVE2098 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+0.9399999999999999d+00*DW(219,68)
      SAVE2099 = JACC(66,41)
      JACC(66,41) = JACC(66,41)+DW(219,41)
      SAVE2100 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+DW(219,68)
      SAVE2101 = JACC(68,41)
      JACC(68,41) = JACC(68,41)-DW(219,41)
      SAVE2102 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(219,68)
      SAVE2103 = JACC(71,41)
      JACC(71,41) = JACC(71,41)+DW(219,41)
      SAVE2104 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(219,68)
      SAVE2105 = JACC(72,41)
      JACC(72,41) = JACC(72,41)+DW(219,41)
      SAVE2106 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(219,68)
      SAVE2107 = JACC(45,45)
      JACC(45,45) = JACC(45,45)-DW(220,45)
      SAVE2108 = JACC(45,68)
      JACC(45,68) = JACC(45,68)-DW(220,68)
      SAVE2109 = JACC(59,45)
      JACC(59,45) = JACC(59,45)+0.2900000000000000d+00*DW(220,45)
      SAVE2110 = JACC(59,68)
      JACC(59,68) = JACC(59,68)+0.2900000000000000d+00*DW(220,68)
      SAVE2111 = JACC(61,45)
      JACC(61,45) = JACC(61,45)+0.1710000000000000d+01*DW(220,45)
      SAVE2112 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+0.1710000000000000d+01*DW(220,68)
      SAVE2113 = JACC(68,45)
      JACC(68,45) = JACC(68,45)-DW(220,45)
      SAVE2114 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(220,68)
      SAVE2115 = JACC(71,45)
      JACC(71,45) = JACC(71,45)+DW(220,45)
      SAVE2116 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(220,68)
      SAVE2117 = JACC(72,45)
      JACC(72,45) = JACC(72,45)+DW(220,45)
      SAVE2118 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(220,68)
      SAVE2119 = JACC(39,39)
      JACC(39,39) = JACC(39,39)-DW(221,39)
      SAVE2120 = JACC(39,68)
      JACC(39,68) = JACC(39,68)-DW(221,68)
      SAVE2121 = JACC(40,39)
      JACC(40,39) = JACC(40,39)+0.4000000000000000d+00*DW(221,39)
      SAVE2122 = JACC(40,68)
      JACC(40,68) = JACC(40,68)+0.4000000000000000d+00*DW(221,68)
      SAVE2123 = JACC(49,39)
      JACC(49,39) = JACC(49,39)+0.6000000000000000d+00*DW(221,39)
      SAVE2124 = JACC(49,68)
      JACC(49,68) = JACC(49,68)+0.6000000000000000d+00*DW(221,68)
      SAVE2125 = JACC(66,39)
      JACC(66,39) = JACC(66,39)+0.6860000000000001d+00*DW(221,39)
      SAVE2126 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+0.6860000000000001d+00*DW(221,68)
      SAVE2127 = JACC(68,39)
      JACC(68,39) = JACC(68,39)-DW(221,39)
      SAVE2128 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(221,68)
      SAVE2129 = JACC(71,39)
      JACC(71,39) = JACC(71,39)+DW(221,39)
      SAVE2130 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(221,68)
      SAVE2131 = JACC(72,39)
      JACC(72,39) = JACC(72,39)+DW(221,39)
      SAVE2132 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(221,68)
      SAVE2133 = JACC(42,42)
      JACC(42,42) = JACC(42,42)-DW(222,42)
      SAVE2134 = JACC(42,68)
      JACC(42,68) = JACC(42,68)-DW(222,68)
      SAVE2135 = JACC(59,42)
      JACC(59,42) = JACC(59,42)+DW(222,42)
      SAVE2136 = JACC(59,68)
      JACC(59,68) = JACC(59,68)+DW(222,68)
      SAVE2137 = JACC(61,42)
      JACC(61,42) = JACC(61,42)+DW(222,42)
      SAVE2138 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+DW(222,68)
      SAVE2139 = JACC(68,42)
      JACC(68,42) = JACC(68,42)-DW(222,42)
      SAVE2140 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(222,68)
      SAVE2141 = JACC(71,42)
      JACC(71,42) = JACC(71,42)+DW(222,42)
      SAVE2142 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(222,68)
      SAVE2143 = JACC(72,42)
      JACC(72,42) = JACC(72,42)+DW(222,42)
      SAVE2144 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(222,68)
      SAVE2145 = JACC(43,43)
      JACC(43,43) = JACC(43,43)-DW(223,43)
      SAVE2146 = JACC(43,68)
      JACC(43,68) = JACC(43,68)-DW(223,68)
      SAVE2147 = JACC(44,43)
      JACC(44,43) = JACC(44,43)+0.4000000000000000d+00*DW(223,43)
      SAVE2148 = JACC(44,68)
      JACC(44,68) = JACC(44,68)+0.4000000000000000d+00*DW(223,68)
      SAVE2149 = JACC(49,43)
      JACC(49,43) = JACC(49,43)+0.6000000000000000d+00*DW(223,43)
      SAVE2150 = JACC(49,68)
      JACC(49,68) = JACC(49,68)+0.6000000000000000d+00*DW(223,68)
      SAVE2151 = JACC(66,43)
      JACC(66,43) = JACC(66,43)+0.4000000000000000d+00*DW(223,43)
      SAVE2152 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+0.4000000000000000d+00*DW(223,68)
      SAVE2153 = JACC(68,43)
      JACC(68,43) = JACC(68,43)-DW(223,43)
      SAVE2154 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(223,68)
      SAVE2155 = JACC(71,43)
      JACC(71,43) = JACC(71,43)+DW(223,43)
      SAVE2156 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(223,68)
      SAVE2157 = JACC(72,43)
      JACC(72,43) = JACC(72,43)+DW(223,43)
      SAVE2158 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(223,68)
      SAVE2159 = JACC(31,31)
      JACC(31,31) = JACC(31,31)-DW(224,31)
      SAVE2160 = JACC(31,68)
      JACC(31,68) = JACC(31,68)-DW(224,68)
      SAVE2161 = JACC(48,31)
      JACC(48,31) = JACC(48,31)+0.5000000000000000d+00*DW(224,31)
      SAVE2162 = JACC(48,68)
      JACC(48,68) = JACC(48,68)+0.5000000000000000d+00*DW(224,68)
      SAVE2163 = JACC(51,31)
      JACC(51,31) = JACC(51,31)+0.1300000000000000d+01*DW(224,31)
      SAVE2164 = JACC(51,68)
      JACC(51,68) = JACC(51,68)+0.1300000000000000d+01*DW(224,68)
      SAVE2165 = JACC(54,31)
      JACC(54,31) = JACC(54,31)+0.7000000000000000d+00*DW(224,31)
      SAVE2166 = JACC(54,68)
      JACC(54,68) = JACC(54,68)+0.7000000000000000d+00*DW(224,68)
      SAVE2167 = JACC(68,31)
      JACC(68,31) = JACC(68,31)-DW(224,31)
      SAVE2168 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(224,68)
      SAVE2169 = JACC(71,31)
      JACC(71,31) = JACC(71,31)+DW(224,31)
      SAVE2170 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(224,68)
      SAVE2171 = JACC(72,31)
      JACC(72,31) = JACC(72,31)+DW(224,31)
      SAVE2172 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(224,68)
      SAVE2173 = JACC(32,32)
      JACC(32,32) = JACC(32,32)-DW(225,32)
      SAVE2174 = JACC(32,68)
      JACC(32,68) = JACC(32,68)-DW(225,68)
      SAVE2175 = JACC(48,32)
      JACC(48,32) = JACC(48,32)+DW(225,32)
      SAVE2176 = JACC(48,68)
      JACC(48,68) = JACC(48,68)+DW(225,68)
      SAVE2177 = JACC(51,32)
      JACC(51,32) = JACC(51,32)+0.7400000000000000d+00*DW(225,32)
      SAVE2178 = JACC(51,68)
      JACC(51,68) = JACC(51,68)+0.7400000000000000d+00*DW(225,68)
      SAVE2179 = JACC(54,32)
      JACC(54,32) = JACC(54,32)+0.1260000000000000d+01*DW(225,32)
      SAVE2180 = JACC(54,68)
      JACC(54,68) = JACC(54,68)+0.1260000000000000d+01*DW(225,68)
      SAVE2181 = JACC(68,32)
      JACC(68,32) = JACC(68,32)-DW(225,32)
      SAVE2182 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(225,68)
      SAVE2183 = JACC(71,32)
      JACC(71,32) = JACC(71,32)+DW(225,32)
      SAVE2184 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(225,68)
      SAVE2185 = JACC(72,32)
      JACC(72,32) = JACC(72,32)+DW(225,32)
      SAVE2186 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(225,68)
      SAVE2187 = JACC(33,33)
      JACC(33,33) = JACC(33,33)-DW(226,33)
      SAVE2188 = JACC(33,68)
      JACC(33,68) = JACC(33,68)-DW(226,68)
      SAVE2189 = JACC(51,33)
      JACC(51,33) = JACC(51,33)+DW(226,33)
      SAVE2190 = JACC(51,68)
      JACC(51,68) = JACC(51,68)+DW(226,68)
      SAVE2191 = JACC(54,33)
      JACC(54,33) = JACC(54,33)+DW(226,33)
      SAVE2192 = JACC(54,68)
      JACC(54,68) = JACC(54,68)+DW(226,68)
      SAVE2193 = JACC(68,33)
      JACC(68,33) = JACC(68,33)-DW(226,33)
      SAVE2194 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(226,68)
      SAVE2195 = JACC(71,33)
      JACC(71,33) = JACC(71,33)+DW(226,33)
      SAVE2196 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(226,68)
      SAVE2197 = JACC(72,33)
      JACC(72,33) = JACC(72,33)+DW(226,33)
      SAVE2198 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(226,68)
      SAVE2199 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+DW(227,69)
      SAVE2200 = JACC(63,68)
      JACC(63,68) = JACC(63,68)+DW(227,68)
      SAVE2201 = JACC(68,69)
      JACC(68,69) = JACC(68,69)-DW(227,69)
      SAVE2202 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(227,68)
      SAVE2203 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(227,69)
      SAVE2204 = JACC(69,68)
      JACC(69,68) = JACC(69,68)-DW(227,68)
      SAVE2205 = JACC(72,69)
      JACC(72,69) = JACC(72,69)+DW(227,69)
      SAVE2206 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(227,68)
      SAVE2207 = JACC(56,56)
      JACC(56,56) = JACC(56,56)-DW(228,56)
      SAVE2208 = JACC(56,68)
      JACC(56,68) = JACC(56,68)-DW(228,68)
      SAVE2209 = JACC(66,56)
      JACC(66,56) = JACC(66,56)+DW(228,56)
      SAVE2210 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+DW(228,68)
      SAVE2211 = JACC(68,56)
      JACC(68,56) = JACC(68,56)-DW(228,56)
      SAVE2212 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(228,68)
      SAVE2213 = JACC(69,56)
      JACC(69,56) = JACC(69,56)+DW(228,56)
      SAVE2214 = JACC(69,68)
      JACC(69,68) = JACC(69,68)+DW(228,68)
      SAVE2215 = JACC(72,56)
      JACC(72,56) = JACC(72,56)+DW(228,56)
      SAVE2216 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(228,68)
      SAVE2217 = JACC(54,58)
      JACC(54,58) = JACC(54,58)+0.5400000000000000d+00*DW(229,58)
      SAVE2218 = JACC(54,68)
      JACC(54,68) = JACC(54,68)+0.5400000000000000d+00*DW(229,68)
      SAVE2219 = JACC(58,58)
      JACC(58,58) = JACC(58,58)-DW(229,58)
      SAVE2220 = JACC(58,68)
      JACC(58,68) = JACC(58,68)-DW(229,68)
      SAVE2221 = JACC(61,58)
      JACC(61,58) = JACC(61,58)+0.4600000000000000d+00*DW(229,58)
      SAVE2222 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+0.4600000000000000d+00*DW(229,68)
      SAVE2223 = JACC(65,58)
      JACC(65,58) = JACC(65,58)+0.1600000000000000d+00*DW(229,58)
      SAVE2224 = JACC(65,68)
      JACC(65,68) = JACC(65,68)+0.1600000000000000d+00*DW(229,68)
      SAVE2225 = JACC(68,58)
      JACC(68,58) = JACC(68,58)-DW(229,58)
      SAVE2226 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(229,68)
      SAVE2227 = JACC(69,58)
      JACC(69,58) = JACC(69,58)+0.2300000000000000d+00*DW(229,58)
      SAVE2228 = JACC(69,68)
      JACC(69,68) = JACC(69,68)+0.2300000000000000d+00*DW(229,68)
      SAVE2229 = JACC(71,58)
      JACC(71,58) = JACC(71,58)+0.7700000000000000d+00*DW(229,58)
      SAVE2230 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+0.7700000000000000d+00*DW(229,68)
      SAVE2231 = JACC(72,58)
      JACC(72,58) = JACC(72,58)+DW(229,58)
      SAVE2232 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(229,68)
      SAVE2233 = JACC(47,47)
      JACC(47,47) = JACC(47,47)-DW(230,47)
      SAVE2234 = JACC(47,68)
      JACC(47,68) = JACC(47,68)-DW(230,68)
      SAVE2235 = JACC(68,47)
      JACC(68,47) = JACC(68,47)-DW(230,47)
      SAVE2236 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(230,68)
      SAVE2237 = JACC(70,47)
      JACC(70,47) = JACC(70,47)+DW(230,47)
      SAVE2238 = JACC(70,68)
      JACC(70,68) = JACC(70,68)+DW(230,68)
      SAVE2239 = JACC(71,47)
      JACC(71,47) = JACC(71,47)+DW(230,47)
      SAVE2240 = JACC(71,68)
      JACC(71,68) = JACC(71,68)+DW(230,68)
      SAVE2241 = JACC(72,47)
      JACC(72,47) = JACC(72,47)+DW(230,47)
      SAVE2242 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(230,68)
      SAVE2243 = JACC(46,46)
      JACC(46,46) = JACC(46,46)-DW(231,46)
      SAVE2244 = JACC(46,68)
      JACC(46,68) = JACC(46,68)-DW(231,68)
      SAVE2245 = JACC(59,46)
      JACC(59,46) = JACC(59,46)+0.4690000000000000d+00*DW(231,46)
      SAVE2246 = JACC(59,68)
      JACC(59,68) = JACC(59,68)+0.4690000000000000d+00*DW(231,68)
      SAVE2247 = JACC(61,46)
      JACC(61,46) = JACC(61,46)+0.1240000000000000d+01*DW(231,46)
      SAVE2248 = JACC(61,68)
      JACC(61,68) = JACC(61,68)+0.1240000000000000d+01*DW(231,68)
      SAVE2249 = JACC(66,46)
      JACC(66,46) = JACC(66,46)+0.2800000000000000d+00*DW(231,46)
      SAVE2250 = JACC(66,68)
      JACC(66,68) = JACC(66,68)+0.2800000000000000d+00*DW(231,68)
      SAVE2251 = JACC(68,46)
      JACC(68,46) = JACC(68,46)-DW(231,46)
      SAVE2252 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(231,68)
      SAVE2253 = JACC(72,46)
      JACC(72,46) = JACC(72,46)+0.2000000000000000d+01*DW(231,46)
      SAVE2254 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+0.2000000000000000d+01*DW(231,68)
      SAVE2255 = JACC(53,65)
      JACC(53,65) = JACC(53,65)+DW(232,65)
      SAVE2256 = JACC(53,71)
      JACC(53,71) = JACC(53,71)+DW(232,71)
      SAVE2257 = JACC(65,65)
      JACC(65,65) = JACC(65,65)-DW(232,65)
      SAVE2258 = JACC(65,71)
      JACC(65,71) = JACC(65,71)-DW(232,71)
      SAVE2259 = JACC(71,65)
      JACC(71,65) = JACC(71,65)-DW(232,65)
      SAVE2260 = JACC(71,71)
      JACC(71,71) = JACC(71,71)-DW(232,71)
      SAVE2261 = JACC(63,65)
      JACC(63,65) = JACC(63,65)-DW(233,65)
      SAVE2262 = JACC(63,63)
      JACC(63,63) = JACC(63,63)-DW(233,63)
      SAVE2263 = JACC(65,65)
      JACC(65,65) = JACC(65,65)-DW(233,65)
      SAVE2264 = JACC(65,63)
      JACC(65,63) = JACC(65,63)-DW(233,63)
      SAVE2265 = JACC(66,65)
      JACC(66,65) = JACC(66,65)+DW(233,65)
      SAVE2266 = JACC(66,63)
      JACC(66,63) = JACC(66,63)+DW(233,63)
      SAVE2267 = JACC(71,65)
      JACC(71,65) = JACC(71,65)+DW(233,65)
      SAVE2268 = JACC(71,63)
      JACC(71,63) = JACC(71,63)+DW(233,63)
      SAVE2269 = JACC(63,65)
      JACC(63,65) = JACC(63,65)+DW(234,65)
      SAVE2270 = JACC(63,69)
      JACC(63,69) = JACC(63,69)+DW(234,69)
      SAVE2271 = JACC(65,65)
      JACC(65,65) = JACC(65,65)-DW(234,65)
      SAVE2272 = JACC(65,69)
      JACC(65,69) = JACC(65,69)-DW(234,69)
      SAVE2273 = JACC(69,65)
      JACC(69,65) = JACC(69,65)-DW(234,65)
      SAVE2274 = JACC(69,69)
      JACC(69,69) = JACC(69,69)-DW(234,69)
      SAVE2275 = JACC(65,65)
      JACC(65,65) = JACC(65,65)-0.2000000000000000d+01*DW(235,65)
      SAVE2276 = JACC(65,65)
      JACC(65,65) = JACC(65,65)-0.2000000000000000d+01*DW(235,65)
      SAVE2277 = JACC(65,65)
      JACC(65,65) = JACC(65,65)-DW(236,65)
      SAVE2278 = JACC(65,67)
      JACC(65,67) = JACC(65,67)-DW(236,67)
      SAVE2279 = JACC(67,65)
      JACC(67,65) = JACC(67,65)-DW(236,65)
      SAVE2280 = JACC(67,67)
      JACC(67,67) = JACC(67,67)-DW(236,67)
      SAVE2281 = JACC(72,65)
      JACC(72,65) = JACC(72,65)+DW(236,65)
      SAVE2282 = JACC(72,67)
      JACC(72,67) = JACC(72,67)+DW(236,67)
      SAVE2283 = JACC(65,65)
      JACC(65,65) = JACC(65,65)-DW(237,65)
      SAVE2284 = JACC(65,68)
      JACC(65,68) = JACC(65,68)-DW(237,68)
      SAVE2285 = JACC(68,65)
      JACC(68,65) = JACC(68,65)-DW(237,65)
      SAVE2286 = JACC(68,68)
      JACC(68,68) = JACC(68,68)-DW(237,68)
      SAVE2287 = JACC(72,65)
      JACC(72,65) = JACC(72,65)+DW(237,65)
      SAVE2288 = JACC(72,68)
      JACC(72,68) = JACC(72,68)+DW(237,68)
      SAVE2291 = J
      DO J = 1, NS
         SAVE2290(J) = I
         DO I = 1, NS
            SAVE2289(I,J) = JACC(I,J)
            JACC(I,J) = JACC(I,J)*CONVERS_FACTOR_JAC(I,J)
         END DO
      END DO
C
C Transposed linear forms
C

      DO J = NS, 1, -1
         DO I = NS, 1, -1
            JACC(I,J) = SAVE2289(I,J)
            JACCCCL(I,J) = JACCCCL(I,J)*CONVERS_FACTOR_JAC(I,J)
         END DO
         I = SAVE2290(J)
      END DO
      J = SAVE2291
      JACC(72,68) = SAVE2288
      DWCCL(237,68) = DWCCL(237,68)+JACCCCL(72,68)
      JACC(72,65) = SAVE2287
      DWCCL(237,65) = DWCCL(237,65)+JACCCCL(72,65)
      JACC(68,68) = SAVE2286
      DWCCL(237,68) = DWCCL(237,68)-JACCCCL(68,68)
      JACC(68,65) = SAVE2285
      DWCCL(237,65) = DWCCL(237,65)-JACCCCL(68,65)
      JACC(65,68) = SAVE2284
      DWCCL(237,68) = DWCCL(237,68)-JACCCCL(65,68)
      JACC(65,65) = SAVE2283
      DWCCL(237,65) = DWCCL(237,65)-JACCCCL(65,65)
      JACC(72,67) = SAVE2282
      DWCCL(236,67) = DWCCL(236,67)+JACCCCL(72,67)
      JACC(72,65) = SAVE2281
      DWCCL(236,65) = DWCCL(236,65)+JACCCCL(72,65)
      JACC(67,67) = SAVE2280
      DWCCL(236,67) = DWCCL(236,67)-JACCCCL(67,67)
      JACC(67,65) = SAVE2279
      DWCCL(236,65) = DWCCL(236,65)-JACCCCL(67,65)
      JACC(65,67) = SAVE2278
      DWCCL(236,67) = DWCCL(236,67)-JACCCCL(65,67)
      JACC(65,65) = SAVE2277
      DWCCL(236,65) = DWCCL(236,65)-JACCCCL(65,65)
      JACC(65,65) = SAVE2276
      DWCCL(235,65) =
     : DWCCL(235,65)-JACCCCL(65,65)*0.2000000000000000d+01
      JACC(65,65) = SAVE2275
      DWCCL(235,65) =
     : DWCCL(235,65)-JACCCCL(65,65)*0.2000000000000000d+01
      JACC(69,69) = SAVE2274
      DWCCL(234,69) = DWCCL(234,69)-JACCCCL(69,69)
      JACC(69,65) = SAVE2273
      DWCCL(234,65) = DWCCL(234,65)-JACCCCL(69,65)
      JACC(65,69) = SAVE2272
      DWCCL(234,69) = DWCCL(234,69)-JACCCCL(65,69)
      JACC(65,65) = SAVE2271
      DWCCL(234,65) = DWCCL(234,65)-JACCCCL(65,65)
      JACC(63,69) = SAVE2270
      DWCCL(234,69) = DWCCL(234,69)+JACCCCL(63,69)
      JACC(63,65) = SAVE2269
      DWCCL(234,65) = DWCCL(234,65)+JACCCCL(63,65)
      JACC(71,63) = SAVE2268
      DWCCL(233,63) = DWCCL(233,63)+JACCCCL(71,63)
      JACC(71,65) = SAVE2267
      DWCCL(233,65) = DWCCL(233,65)+JACCCCL(71,65)
      JACC(66,63) = SAVE2266
      DWCCL(233,63) = DWCCL(233,63)+JACCCCL(66,63)
      JACC(66,65) = SAVE2265
      DWCCL(233,65) = DWCCL(233,65)+JACCCCL(66,65)
      JACC(65,63) = SAVE2264
      DWCCL(233,63) = DWCCL(233,63)-JACCCCL(65,63)
      JACC(65,65) = SAVE2263
      DWCCL(233,65) = DWCCL(233,65)-JACCCCL(65,65)
      JACC(63,63) = SAVE2262
      DWCCL(233,63) = DWCCL(233,63)-JACCCCL(63,63)
      JACC(63,65) = SAVE2261
      DWCCL(233,65) = DWCCL(233,65)-JACCCCL(63,65)
      JACC(71,71) = SAVE2260
      DWCCL(232,71) = DWCCL(232,71)-JACCCCL(71,71)
      JACC(71,65) = SAVE2259
      DWCCL(232,65) = DWCCL(232,65)-JACCCCL(71,65)
      JACC(65,71) = SAVE2258
      DWCCL(232,71) = DWCCL(232,71)-JACCCCL(65,71)
      JACC(65,65) = SAVE2257
      DWCCL(232,65) = DWCCL(232,65)-JACCCCL(65,65)
      JACC(53,71) = SAVE2256
      DWCCL(232,71) = DWCCL(232,71)+JACCCCL(53,71)
      JACC(53,65) = SAVE2255
      DWCCL(232,65) = DWCCL(232,65)+JACCCCL(53,65)
      JACC(72,68) = SAVE2254
      DWCCL(231,68) =
     : DWCCL(231,68)+JACCCCL(72,68)*0.2000000000000000d+01
      JACC(72,46) = SAVE2253
      DWCCL(231,46) =
     : DWCCL(231,46)+JACCCCL(72,46)*0.2000000000000000d+01
      JACC(68,68) = SAVE2252
      DWCCL(231,68) = DWCCL(231,68)-JACCCCL(68,68)
      JACC(68,46) = SAVE2251
      DWCCL(231,46) = DWCCL(231,46)-JACCCCL(68,46)
      JACC(66,68) = SAVE2250
      DWCCL(231,68) =
     : DWCCL(231,68)+JACCCCL(66,68)*0.2800000000000000d+00
      JACC(66,46) = SAVE2249
      DWCCL(231,46) =
     : DWCCL(231,46)+JACCCCL(66,46)*0.2800000000000000d+00
      JACC(61,68) = SAVE2248
      DWCCL(231,68) =
     : DWCCL(231,68)+JACCCCL(61,68)*0.1240000000000000d+01
      JACC(61,46) = SAVE2247
      DWCCL(231,46) =
     : DWCCL(231,46)+JACCCCL(61,46)*0.1240000000000000d+01
      JACC(59,68) = SAVE2246
      DWCCL(231,68) =
     : DWCCL(231,68)+JACCCCL(59,68)*0.4690000000000000d+00
      JACC(59,46) = SAVE2245
      DWCCL(231,46) =
     : DWCCL(231,46)+JACCCCL(59,46)*0.4690000000000000d+00
      JACC(46,68) = SAVE2244
      DWCCL(231,68) = DWCCL(231,68)-JACCCCL(46,68)
      JACC(46,46) = SAVE2243
      DWCCL(231,46) = DWCCL(231,46)-JACCCCL(46,46)
      JACC(72,68) = SAVE2242
      DWCCL(230,68) = DWCCL(230,68)+JACCCCL(72,68)
      JACC(72,47) = SAVE2241
      DWCCL(230,47) = DWCCL(230,47)+JACCCCL(72,47)
      JACC(71,68) = SAVE2240
      DWCCL(230,68) = DWCCL(230,68)+JACCCCL(71,68)
      JACC(71,47) = SAVE2239
      DWCCL(230,47) = DWCCL(230,47)+JACCCCL(71,47)
      JACC(70,68) = SAVE2238
      DWCCL(230,68) = DWCCL(230,68)+JACCCCL(70,68)
      JACC(70,47) = SAVE2237
      DWCCL(230,47) = DWCCL(230,47)+JACCCCL(70,47)
      JACC(68,68) = SAVE2236
      DWCCL(230,68) = DWCCL(230,68)-JACCCCL(68,68)
      JACC(68,47) = SAVE2235
      DWCCL(230,47) = DWCCL(230,47)-JACCCCL(68,47)
      JACC(47,68) = SAVE2234
      DWCCL(230,68) = DWCCL(230,68)-JACCCCL(47,68)
      JACC(47,47) = SAVE2233
      DWCCL(230,47) = DWCCL(230,47)-JACCCCL(47,47)
      JACC(72,68) = SAVE2232
      DWCCL(229,68) = DWCCL(229,68)+JACCCCL(72,68)
      JACC(72,58) = SAVE2231
      DWCCL(229,58) = DWCCL(229,58)+JACCCCL(72,58)
      JACC(71,68) = SAVE2230
      DWCCL(229,68) =
     : DWCCL(229,68)+JACCCCL(71,68)*0.7700000000000000d+00
      JACC(71,58) = SAVE2229
      DWCCL(229,58) =
     : DWCCL(229,58)+JACCCCL(71,58)*0.7700000000000000d+00
      JACC(69,68) = SAVE2228
      DWCCL(229,68) =
     : DWCCL(229,68)+JACCCCL(69,68)*0.2300000000000000d+00
      JACC(69,58) = SAVE2227
      DWCCL(229,58) =
     : DWCCL(229,58)+JACCCCL(69,58)*0.2300000000000000d+00
      JACC(68,68) = SAVE2226
      DWCCL(229,68) = DWCCL(229,68)-JACCCCL(68,68)
      JACC(68,58) = SAVE2225
      DWCCL(229,58) = DWCCL(229,58)-JACCCCL(68,58)
      JACC(65,68) = SAVE2224
      DWCCL(229,68) =
     : DWCCL(229,68)+JACCCCL(65,68)*0.1600000000000000d+00
      JACC(65,58) = SAVE2223
      DWCCL(229,58) =
     : DWCCL(229,58)+JACCCCL(65,58)*0.1600000000000000d+00
      JACC(61,68) = SAVE2222
      DWCCL(229,68) =
     : DWCCL(229,68)+JACCCCL(61,68)*0.4600000000000000d+00
      JACC(61,58) = SAVE2221
      DWCCL(229,58) =
     : DWCCL(229,58)+JACCCCL(61,58)*0.4600000000000000d+00
      JACC(58,68) = SAVE2220
      DWCCL(229,68) = DWCCL(229,68)-JACCCCL(58,68)
      JACC(58,58) = SAVE2219
      DWCCL(229,58) = DWCCL(229,58)-JACCCCL(58,58)
      JACC(54,68) = SAVE2218
      DWCCL(229,68) =
     : DWCCL(229,68)+JACCCCL(54,68)*0.5400000000000000d+00
      JACC(54,58) = SAVE2217
      DWCCL(229,58) =
     : DWCCL(229,58)+JACCCCL(54,58)*0.5400000000000000d+00
      JACC(72,68) = SAVE2216
      DWCCL(228,68) = DWCCL(228,68)+JACCCCL(72,68)
      JACC(72,56) = SAVE2215
      DWCCL(228,56) = DWCCL(228,56)+JACCCCL(72,56)
      JACC(69,68) = SAVE2214
      DWCCL(228,68) = DWCCL(228,68)+JACCCCL(69,68)
      JACC(69,56) = SAVE2213
      DWCCL(228,56) = DWCCL(228,56)+JACCCCL(69,56)
      JACC(68,68) = SAVE2212
      DWCCL(228,68) = DWCCL(228,68)-JACCCCL(68,68)
      JACC(68,56) = SAVE2211
      DWCCL(228,56) = DWCCL(228,56)-JACCCCL(68,56)
      JACC(66,68) = SAVE2210
      DWCCL(228,68) = DWCCL(228,68)+JACCCCL(66,68)
      JACC(66,56) = SAVE2209
      DWCCL(228,56) = DWCCL(228,56)+JACCCCL(66,56)
      JACC(56,68) = SAVE2208
      DWCCL(228,68) = DWCCL(228,68)-JACCCCL(56,68)
      JACC(56,56) = SAVE2207
      DWCCL(228,56) = DWCCL(228,56)-JACCCCL(56,56)
      JACC(72,68) = SAVE2206
      DWCCL(227,68) = DWCCL(227,68)+JACCCCL(72,68)
      JACC(72,69) = SAVE2205
      DWCCL(227,69) = DWCCL(227,69)+JACCCCL(72,69)
      JACC(69,68) = SAVE2204
      DWCCL(227,68) = DWCCL(227,68)-JACCCCL(69,68)
      JACC(69,69) = SAVE2203
      DWCCL(227,69) = DWCCL(227,69)-JACCCCL(69,69)
      JACC(68,68) = SAVE2202
      DWCCL(227,68) = DWCCL(227,68)-JACCCCL(68,68)
      JACC(68,69) = SAVE2201
      DWCCL(227,69) = DWCCL(227,69)-JACCCCL(68,69)
      JACC(63,68) = SAVE2200
      DWCCL(227,68) = DWCCL(227,68)+JACCCCL(63,68)
      JACC(63,69) = SAVE2199
      DWCCL(227,69) = DWCCL(227,69)+JACCCCL(63,69)
      JACC(72,68) = SAVE2198
      DWCCL(226,68) = DWCCL(226,68)+JACCCCL(72,68)
      JACC(72,33) = SAVE2197
      DWCCL(226,33) = DWCCL(226,33)+JACCCCL(72,33)
      JACC(71,68) = SAVE2196
      DWCCL(226,68) = DWCCL(226,68)+JACCCCL(71,68)
      JACC(71,33) = SAVE2195
      DWCCL(226,33) = DWCCL(226,33)+JACCCCL(71,33)
      JACC(68,68) = SAVE2194
      DWCCL(226,68) = DWCCL(226,68)-JACCCCL(68,68)
      JACC(68,33) = SAVE2193
      DWCCL(226,33) = DWCCL(226,33)-JACCCCL(68,33)
      JACC(54,68) = SAVE2192
      DWCCL(226,68) = DWCCL(226,68)+JACCCCL(54,68)
      JACC(54,33) = SAVE2191
      DWCCL(226,33) = DWCCL(226,33)+JACCCCL(54,33)
      JACC(51,68) = SAVE2190
      DWCCL(226,68) = DWCCL(226,68)+JACCCCL(51,68)
      JACC(51,33) = SAVE2189
      DWCCL(226,33) = DWCCL(226,33)+JACCCCL(51,33)
      JACC(33,68) = SAVE2188
      DWCCL(226,68) = DWCCL(226,68)-JACCCCL(33,68)
      JACC(33,33) = SAVE2187
      DWCCL(226,33) = DWCCL(226,33)-JACCCCL(33,33)
      JACC(72,68) = SAVE2186
      DWCCL(225,68) = DWCCL(225,68)+JACCCCL(72,68)
      JACC(72,32) = SAVE2185
      DWCCL(225,32) = DWCCL(225,32)+JACCCCL(72,32)
      JACC(71,68) = SAVE2184
      DWCCL(225,68) = DWCCL(225,68)+JACCCCL(71,68)
      JACC(71,32) = SAVE2183
      DWCCL(225,32) = DWCCL(225,32)+JACCCCL(71,32)
      JACC(68,68) = SAVE2182
      DWCCL(225,68) = DWCCL(225,68)-JACCCCL(68,68)
      JACC(68,32) = SAVE2181
      DWCCL(225,32) = DWCCL(225,32)-JACCCCL(68,32)
      JACC(54,68) = SAVE2180
      DWCCL(225,68) =
     : DWCCL(225,68)+JACCCCL(54,68)*0.1260000000000000d+01
      JACC(54,32) = SAVE2179
      DWCCL(225,32) =
     : DWCCL(225,32)+JACCCCL(54,32)*0.1260000000000000d+01
      JACC(51,68) = SAVE2178
      DWCCL(225,68) =
     : DWCCL(225,68)+JACCCCL(51,68)*0.7400000000000000d+00
      JACC(51,32) = SAVE2177
      DWCCL(225,32) =
     : DWCCL(225,32)+JACCCCL(51,32)*0.7400000000000000d+00
      JACC(48,68) = SAVE2176
      DWCCL(225,68) = DWCCL(225,68)+JACCCCL(48,68)
      JACC(48,32) = SAVE2175
      DWCCL(225,32) = DWCCL(225,32)+JACCCCL(48,32)
      JACC(32,68) = SAVE2174
      DWCCL(225,68) = DWCCL(225,68)-JACCCCL(32,68)
      JACC(32,32) = SAVE2173
      DWCCL(225,32) = DWCCL(225,32)-JACCCCL(32,32)
      JACC(72,68) = SAVE2172
      DWCCL(224,68) = DWCCL(224,68)+JACCCCL(72,68)
      JACC(72,31) = SAVE2171
      DWCCL(224,31) = DWCCL(224,31)+JACCCCL(72,31)
      JACC(71,68) = SAVE2170
      DWCCL(224,68) = DWCCL(224,68)+JACCCCL(71,68)
      JACC(71,31) = SAVE2169
      DWCCL(224,31) = DWCCL(224,31)+JACCCCL(71,31)
      JACC(68,68) = SAVE2168
      DWCCL(224,68) = DWCCL(224,68)-JACCCCL(68,68)
      JACC(68,31) = SAVE2167
      DWCCL(224,31) = DWCCL(224,31)-JACCCCL(68,31)
      JACC(54,68) = SAVE2166
      DWCCL(224,68) =
     : DWCCL(224,68)+JACCCCL(54,68)*0.7000000000000000d+00
      JACC(54,31) = SAVE2165
      DWCCL(224,31) =
     : DWCCL(224,31)+JACCCCL(54,31)*0.7000000000000000d+00
      JACC(51,68) = SAVE2164
      DWCCL(224,68) =
     : DWCCL(224,68)+JACCCCL(51,68)*0.1300000000000000d+01
      JACC(51,31) = SAVE2163
      DWCCL(224,31) =
     : DWCCL(224,31)+JACCCCL(51,31)*0.1300000000000000d+01
      JACC(48,68) = SAVE2162
      DWCCL(224,68) =
     : DWCCL(224,68)+JACCCCL(48,68)*0.5000000000000000d+00
      JACC(48,31) = SAVE2161
      DWCCL(224,31) =
     : DWCCL(224,31)+JACCCCL(48,31)*0.5000000000000000d+00
      JACC(31,68) = SAVE2160
      DWCCL(224,68) = DWCCL(224,68)-JACCCCL(31,68)
      JACC(31,31) = SAVE2159
      DWCCL(224,31) = DWCCL(224,31)-JACCCCL(31,31)
      JACC(72,68) = SAVE2158
      DWCCL(223,68) = DWCCL(223,68)+JACCCCL(72,68)
      JACC(72,43) = SAVE2157
      DWCCL(223,43) = DWCCL(223,43)+JACCCCL(72,43)
      JACC(71,68) = SAVE2156
      DWCCL(223,68) = DWCCL(223,68)+JACCCCL(71,68)
      JACC(71,43) = SAVE2155
      DWCCL(223,43) = DWCCL(223,43)+JACCCCL(71,43)
      JACC(68,68) = SAVE2154
      DWCCL(223,68) = DWCCL(223,68)-JACCCCL(68,68)
      JACC(68,43) = SAVE2153
      DWCCL(223,43) = DWCCL(223,43)-JACCCCL(68,43)
      JACC(66,68) = SAVE2152
      DWCCL(223,68) =
     : DWCCL(223,68)+JACCCCL(66,68)*0.4000000000000000d+00
      JACC(66,43) = SAVE2151
      DWCCL(223,43) =
     : DWCCL(223,43)+JACCCCL(66,43)*0.4000000000000000d+00
      JACC(49,68) = SAVE2150
      DWCCL(223,68) =
     : DWCCL(223,68)+JACCCCL(49,68)*0.6000000000000000d+00
      JACC(49,43) = SAVE2149
      DWCCL(223,43) =
     : DWCCL(223,43)+JACCCCL(49,43)*0.6000000000000000d+00
      JACC(44,68) = SAVE2148
      DWCCL(223,68) =
     : DWCCL(223,68)+JACCCCL(44,68)*0.4000000000000000d+00
      JACC(44,43) = SAVE2147
      DWCCL(223,43) =
     : DWCCL(223,43)+JACCCCL(44,43)*0.4000000000000000d+00
      JACC(43,68) = SAVE2146
      DWCCL(223,68) = DWCCL(223,68)-JACCCCL(43,68)
      JACC(43,43) = SAVE2145
      DWCCL(223,43) = DWCCL(223,43)-JACCCCL(43,43)
      JACC(72,68) = SAVE2144
      DWCCL(222,68) = DWCCL(222,68)+JACCCCL(72,68)
      JACC(72,42) = SAVE2143
      DWCCL(222,42) = DWCCL(222,42)+JACCCCL(72,42)
      JACC(71,68) = SAVE2142
      DWCCL(222,68) = DWCCL(222,68)+JACCCCL(71,68)
      JACC(71,42) = SAVE2141
      DWCCL(222,42) = DWCCL(222,42)+JACCCCL(71,42)
      JACC(68,68) = SAVE2140
      DWCCL(222,68) = DWCCL(222,68)-JACCCCL(68,68)
      JACC(68,42) = SAVE2139
      DWCCL(222,42) = DWCCL(222,42)-JACCCCL(68,42)
      JACC(61,68) = SAVE2138
      DWCCL(222,68) = DWCCL(222,68)+JACCCCL(61,68)
      JACC(61,42) = SAVE2137
      DWCCL(222,42) = DWCCL(222,42)+JACCCCL(61,42)
      JACC(59,68) = SAVE2136
      DWCCL(222,68) = DWCCL(222,68)+JACCCCL(59,68)
      JACC(59,42) = SAVE2135
      DWCCL(222,42) = DWCCL(222,42)+JACCCCL(59,42)
      JACC(42,68) = SAVE2134
      DWCCL(222,68) = DWCCL(222,68)-JACCCCL(42,68)
      JACC(42,42) = SAVE2133
      DWCCL(222,42) = DWCCL(222,42)-JACCCCL(42,42)
      JACC(72,68) = SAVE2132
      DWCCL(221,68) = DWCCL(221,68)+JACCCCL(72,68)
      JACC(72,39) = SAVE2131
      DWCCL(221,39) = DWCCL(221,39)+JACCCCL(72,39)
      JACC(71,68) = SAVE2130
      DWCCL(221,68) = DWCCL(221,68)+JACCCCL(71,68)
      JACC(71,39) = SAVE2129
      DWCCL(221,39) = DWCCL(221,39)+JACCCCL(71,39)
      JACC(68,68) = SAVE2128
      DWCCL(221,68) = DWCCL(221,68)-JACCCCL(68,68)
      JACC(68,39) = SAVE2127
      DWCCL(221,39) = DWCCL(221,39)-JACCCCL(68,39)
      JACC(66,68) = SAVE2126
      DWCCL(221,68) =
     : DWCCL(221,68)+JACCCCL(66,68)*0.6860000000000001d+00
      JACC(66,39) = SAVE2125
      DWCCL(221,39) =
     : DWCCL(221,39)+JACCCCL(66,39)*0.6860000000000001d+00
      JACC(49,68) = SAVE2124
      DWCCL(221,68) =
     : DWCCL(221,68)+JACCCCL(49,68)*0.6000000000000000d+00
      JACC(49,39) = SAVE2123
      DWCCL(221,39) =
     : DWCCL(221,39)+JACCCCL(49,39)*0.6000000000000000d+00
      JACC(40,68) = SAVE2122
      DWCCL(221,68) =
     : DWCCL(221,68)+JACCCCL(40,68)*0.4000000000000000d+00
      JACC(40,39) = SAVE2121
      DWCCL(221,39) =
     : DWCCL(221,39)+JACCCCL(40,39)*0.4000000000000000d+00
      JACC(39,68) = SAVE2120
      DWCCL(221,68) = DWCCL(221,68)-JACCCCL(39,68)
      JACC(39,39) = SAVE2119
      DWCCL(221,39) = DWCCL(221,39)-JACCCCL(39,39)
      JACC(72,68) = SAVE2118
      DWCCL(220,68) = DWCCL(220,68)+JACCCCL(72,68)
      JACC(72,45) = SAVE2117
      DWCCL(220,45) = DWCCL(220,45)+JACCCCL(72,45)
      JACC(71,68) = SAVE2116
      DWCCL(220,68) = DWCCL(220,68)+JACCCCL(71,68)
      JACC(71,45) = SAVE2115
      DWCCL(220,45) = DWCCL(220,45)+JACCCCL(71,45)
      JACC(68,68) = SAVE2114
      DWCCL(220,68) = DWCCL(220,68)-JACCCCL(68,68)
      JACC(68,45) = SAVE2113
      DWCCL(220,45) = DWCCL(220,45)-JACCCCL(68,45)
      JACC(61,68) = SAVE2112
      DWCCL(220,68) =
     : DWCCL(220,68)+JACCCCL(61,68)*0.1710000000000000d+01
      JACC(61,45) = SAVE2111
      DWCCL(220,45) =
     : DWCCL(220,45)+JACCCCL(61,45)*0.1710000000000000d+01
      JACC(59,68) = SAVE2110
      DWCCL(220,68) =
     : DWCCL(220,68)+JACCCCL(59,68)*0.2900000000000000d+00
      JACC(59,45) = SAVE2109
      DWCCL(220,45) =
     : DWCCL(220,45)+JACCCCL(59,45)*0.2900000000000000d+00
      JACC(45,68) = SAVE2108
      DWCCL(220,68) = DWCCL(220,68)-JACCCCL(45,68)
      JACC(45,45) = SAVE2107
      DWCCL(220,45) = DWCCL(220,45)-JACCCCL(45,45)
      JACC(72,68) = SAVE2106
      DWCCL(219,68) = DWCCL(219,68)+JACCCCL(72,68)
      JACC(72,41) = SAVE2105
      DWCCL(219,41) = DWCCL(219,41)+JACCCCL(72,41)
      JACC(71,68) = SAVE2104
      DWCCL(219,68) = DWCCL(219,68)+JACCCCL(71,68)
      JACC(71,41) = SAVE2103
      DWCCL(219,41) = DWCCL(219,41)+JACCCCL(71,41)
      JACC(68,68) = SAVE2102
      DWCCL(219,68) = DWCCL(219,68)-JACCCCL(68,68)
      JACC(68,41) = SAVE2101
      DWCCL(219,41) = DWCCL(219,41)-JACCCCL(68,41)
      JACC(66,68) = SAVE2100
      DWCCL(219,68) = DWCCL(219,68)+JACCCCL(66,68)
      JACC(66,41) = SAVE2099
      DWCCL(219,41) = DWCCL(219,41)+JACCCCL(66,41)
      JACC(61,68) = SAVE2098
      DWCCL(219,68) =
     : DWCCL(219,68)+JACCCCL(61,68)*0.9399999999999999d+00
      JACC(61,41) = SAVE2097
      DWCCL(219,41) =
     : DWCCL(219,41)+JACCCCL(61,41)*0.9399999999999999d+00
      JACC(59,68) = SAVE2096
      DWCCL(219,68) =
     : DWCCL(219,68)+JACCCCL(59,68)*0.6000000000000000d-01
      JACC(59,41) = SAVE2095
      DWCCL(219,41) =
     : DWCCL(219,41)+JACCCCL(59,41)*0.6000000000000000d-01
      JACC(41,68) = SAVE2094
      DWCCL(219,68) = DWCCL(219,68)-JACCCCL(41,68)
      JACC(41,41) = SAVE2093
      DWCCL(219,41) = DWCCL(219,41)-JACCCCL(41,41)
      JACC(72,68) = SAVE2092
      DWCCL(218,68) = DWCCL(218,68)+JACCCCL(72,68)
      JACC(72,38) = SAVE2091
      DWCCL(218,38) = DWCCL(218,38)+JACCCCL(72,38)
      JACC(71,68) = SAVE2090
      DWCCL(218,68) = DWCCL(218,68)+JACCCCL(71,68)
      JACC(71,38) = SAVE2089
      DWCCL(218,38) = DWCCL(218,38)+JACCCCL(71,38)
      JACC(68,68) = SAVE2088
      DWCCL(218,68) = DWCCL(218,68)-JACCCCL(68,68)
      JACC(68,38) = SAVE2087
      DWCCL(218,38) = DWCCL(218,38)-JACCCCL(68,38)
      JACC(66,68) = SAVE2086
      DWCCL(218,68) =
     : DWCCL(218,68)+JACCCCL(66,68)*0.1600000000000000d+01
      JACC(66,38) = SAVE2085
      DWCCL(218,38) =
     : DWCCL(218,38)+JACCCCL(66,38)*0.1600000000000000d+01
      JACC(61,68) = SAVE2084
      DWCCL(218,68) =
     : DWCCL(218,68)+JACCCCL(61,68)*0.2000000000000000d+00
      JACC(61,38) = SAVE2083
      DWCCL(218,38) =
     : DWCCL(218,38)+JACCCCL(61,38)*0.2000000000000000d+00
      JACC(38,68) = SAVE2082
      DWCCL(218,68) = DWCCL(218,68)-JACCCCL(38,68)
      JACC(38,38) = SAVE2081
      DWCCL(218,38) = DWCCL(218,38)-JACCCCL(38,38)
      JACC(72,68) = SAVE2080
      DWCCL(217,68) = DWCCL(217,68)+JACCCCL(72,68)
      JACC(72,37) = SAVE2079
      DWCCL(217,37) = DWCCL(217,37)+JACCCCL(72,37)
      JACC(71,68) = SAVE2078
      DWCCL(217,68) =
     : DWCCL(217,68)+JACCCCL(71,68)*0.8450000000000000d+00
      JACC(71,37) = SAVE2077
      DWCCL(217,37) =
     : DWCCL(217,37)+JACCCCL(71,37)*0.8450000000000000d+00
      JACC(68,68) = SAVE2076
      DWCCL(217,68) = DWCCL(217,68)-JACCCCL(68,68)
      JACC(68,37) = SAVE2075
      DWCCL(217,37) = DWCCL(217,37)-JACCCCL(68,37)
      JACC(65,68) = SAVE2074
      DWCCL(217,68) =
     : DWCCL(217,68)+JACCCCL(65,68)*0.5870000000000000d+00
      JACC(65,37) = SAVE2073
      DWCCL(217,37) =
     : DWCCL(217,37)+JACCCCL(65,37)*0.5870000000000000d+00
      JACC(61,68) = SAVE2072
      DWCCL(217,68) =
     : DWCCL(217,68)+JACCCCL(61,68)*0.1870000000000000d+00
      JACC(61,37) = SAVE2071
      DWCCL(217,37) =
     : DWCCL(217,37)+JACCCCL(61,37)*0.1870000000000000d+00
      JACC(60,68) = SAVE2070
      DWCCL(217,68) =
     : DWCCL(217,68)+JACCCCL(60,68)*0.1550000000000000d+00
      JACC(60,37) = SAVE2069
      DWCCL(217,37) =
     : DWCCL(217,37)+JACCCCL(60,37)*0.1550000000000000d+00
      JACC(59,68) = SAVE2068
      DWCCL(217,68) =
     : DWCCL(217,68)+JACCCCL(59,68)*0.8800000000000000d+00
      JACC(59,37) = SAVE2067
      DWCCL(217,37) =
     : DWCCL(217,37)+JACCCCL(59,37)*0.8800000000000000d+00
      JACC(37,68) = SAVE2066
      DWCCL(217,68) = DWCCL(217,68)-JACCCCL(37,68)
      JACC(37,37) = SAVE2065
      DWCCL(217,37) = DWCCL(217,37)-JACCCCL(37,37)
      JACC(72,68) = SAVE2064
      DWCCL(216,68) = DWCCL(216,68)+JACCCCL(72,68)
      JACC(72,36) = SAVE2063
      DWCCL(216,36) = DWCCL(216,36)+JACCCCL(72,36)
      JACC(71,68) = SAVE2062
      DWCCL(216,68) =
     : DWCCL(216,68)+JACCCCL(71,68)*0.6990000000000000d+00
      JACC(71,36) = SAVE2061
      DWCCL(216,36) =
     : DWCCL(216,36)+JACCCCL(71,36)*0.6990000000000000d+00
      JACC(68,68) = SAVE2060
      DWCCL(216,68) = DWCCL(216,68)-JACCCCL(68,68)
      JACC(68,36) = SAVE2059
      DWCCL(216,36) = DWCCL(216,36)-JACCCCL(68,36)
      JACC(66,68) = SAVE2058
      DWCCL(216,68) =
     : DWCCL(216,68)+JACCCCL(66,68)*0.2100000000000000d-01
      JACC(66,36) = SAVE2057
      DWCCL(216,36) =
     : DWCCL(216,36)+JACCCCL(66,36)*0.2100000000000000d-01
      JACC(65,68) = SAVE2056
      DWCCL(216,68) =
     : DWCCL(216,68)+JACCCCL(65,68)*0.3910000000000000d+00
      JACC(65,36) = SAVE2055
      DWCCL(216,36) =
     : DWCCL(216,36)+JACCCCL(65,36)*0.3910000000000000d+00
      JACC(63,68) = SAVE2054
      DWCCL(216,68) =
     : DWCCL(216,68)+JACCCCL(63,68)*0.4000000000000000d-01
      JACC(63,36) = SAVE2053
      DWCCL(216,36) =
     : DWCCL(216,36)+JACCCCL(63,36)*0.4000000000000000d-01
      JACC(61,68) = SAVE2052
      DWCCL(216,68) =
     : DWCCL(216,68)+JACCCCL(61,68)*0.2390000000000000d+00
      JACC(61,36) = SAVE2051
      DWCCL(216,36) =
     : DWCCL(216,36)+JACCCCL(61,36)*0.2390000000000000d+00
      JACC(60,68) = SAVE2050
      DWCCL(216,68) =
     : DWCCL(216,68)+JACCCCL(60,68)*0.2620000000000000d+00
      JACC(60,36) = SAVE2049
      DWCCL(216,36) =
     : DWCCL(216,36)+JACCCCL(60,36)*0.2620000000000000d+00
      JACC(59,68) = SAVE2048
      DWCCL(216,68) =
     : DWCCL(216,68)+JACCCCL(59,68)*0.8280000000000000d+00
      JACC(59,36) = SAVE2047
      DWCCL(216,36) =
     : DWCCL(216,36)+JACCCCL(59,36)*0.8280000000000000d+00
      JACC(36,68) = SAVE2046
      DWCCL(216,68) = DWCCL(216,68)-JACCCCL(36,68)
      JACC(36,36) = SAVE2045
      DWCCL(216,36) = DWCCL(216,36)-JACCCCL(36,36)
      JACC(72,68) = SAVE2044
      DWCCL(215,68) = DWCCL(215,68)+JACCCCL(72,68)
      JACC(72,64) = SAVE2043
      DWCCL(215,64) = DWCCL(215,64)+JACCCCL(72,64)
      JACC(71,68) = SAVE2042
      DWCCL(215,68) =
     : DWCCL(215,68)+JACCCCL(71,68)*0.7920000000000000d+00
      JACC(71,64) = SAVE2041
      DWCCL(215,64) =
     : DWCCL(215,64)+JACCCCL(71,64)*0.7920000000000000d+00
      JACC(68,68) = SAVE2040
      DWCCL(215,68) = DWCCL(215,68)-JACCCCL(68,68)
      JACC(68,64) = SAVE2039
      DWCCL(215,64) = DWCCL(215,64)-JACCCCL(68,64)
      JACC(66,68) = SAVE2038
      DWCCL(215,68) =
     : DWCCL(215,68)+JACCCCL(66,68)*0.4800000000000000d-01
      JACC(66,64) = SAVE2037
      DWCCL(215,64) =
     : DWCCL(215,64)+JACCCCL(66,64)*0.4800000000000000d-01
      JACC(65,68) = SAVE2036
      DWCCL(215,68) =
     : DWCCL(215,68)+JACCCCL(65,68)*0.5100000000000000d-01
      JACC(65,64) = SAVE2035
      DWCCL(215,64) =
     : DWCCL(215,64)+JACCCCL(65,64)*0.5100000000000000d-01
      JACC(64,68) = SAVE2034
      DWCCL(215,68) = DWCCL(215,68)-JACCCCL(64,68)
      JACC(64,64) = SAVE2033
      DWCCL(215,64) = DWCCL(215,64)-JACCCCL(64,64)
      JACC(63,68) = SAVE2032
      DWCCL(215,68) =
     : DWCCL(215,68)+JACCCCL(63,68)*0.1550000000000000d+00
      JACC(63,64) = SAVE2031
      DWCCL(215,64) =
     : DWCCL(215,64)+JACCCCL(63,64)*0.1550000000000000d+00
      JACC(61,68) = SAVE2030
      DWCCL(215,68) =
     : DWCCL(215,68)+JACCCCL(61,68)*0.2430000000000000d+00
      JACC(61,64) = SAVE2029
      DWCCL(215,64) =
     : DWCCL(215,64)+JACCCCL(61,64)*0.2430000000000000d+00
      JACC(60,68) = SAVE2028
      DWCCL(215,68) =
     : DWCCL(215,68)+JACCCCL(60,68)*0.5300000000000000d-01
      JACC(60,64) = SAVE2027
      DWCCL(215,64) =
     : DWCCL(215,64)+JACCCCL(60,64)*0.5300000000000000d-01
      JACC(59,68) = SAVE2026
      DWCCL(215,68) =
     : DWCCL(215,68)+JACCCCL(59,68)*0.6700000000000000d+00
      JACC(59,64) = SAVE2025
      DWCCL(215,64) =
     : DWCCL(215,64)+JACCCCL(59,64)*0.6700000000000000d+00
      JACC(51,68) = SAVE2024
      DWCCL(215,68) =
     : DWCCL(215,68)+JACCCCL(51,68)*0.6300000000000000d-01
      JACC(51,64) = SAVE2023
      DWCCL(215,64) =
     : DWCCL(215,64)+JACCCCL(51,64)*0.6300000000000000d-01
      JACC(72,68) = SAVE2022
      DWCCL(214,68) = DWCCL(214,68)+JACCCCL(72,68)
      JACC(72,60) = SAVE2021
      DWCCL(214,60) = DWCCL(214,60)+JACCCCL(72,60)
      JACC(71,68) = SAVE2020
      DWCCL(214,68) = DWCCL(214,68)+JACCCCL(71,68)
      JACC(71,60) = SAVE2019
      DWCCL(214,60) = DWCCL(214,60)+JACCCCL(71,60)
      JACC(68,68) = SAVE2018
      DWCCL(214,68) = DWCCL(214,68)-JACCCCL(68,68)
      JACC(68,60) = SAVE2017
      DWCCL(214,60) = DWCCL(214,60)-JACCCCL(68,60)
      JACC(61,68) = SAVE2016
      DWCCL(214,68) = DWCCL(214,68)+JACCCCL(61,68)
      JACC(61,60) = SAVE2015
      DWCCL(214,60) = DWCCL(214,60)+JACCCCL(61,60)
      JACC(60,68) = SAVE2014
      DWCCL(214,68) = DWCCL(214,68)-JACCCCL(60,68)
      JACC(60,60) = SAVE2013
      DWCCL(214,60) = DWCCL(214,60)-JACCCCL(60,60)
      JACC(72,68) = SAVE2012
      DWCCL(213,68) = DWCCL(213,68)+JACCCCL(72,68)
      JACC(72,63) = SAVE2011
      DWCCL(213,63) = DWCCL(213,63)+JACCCCL(72,63)
      JACC(71,68) = SAVE2010
      DWCCL(213,68) = DWCCL(213,68)+JACCCCL(71,68)
      JACC(71,63) = SAVE2009
      DWCCL(213,63) = DWCCL(213,63)+JACCCCL(71,63)
      JACC(68,68) = SAVE2008
      DWCCL(213,68) = DWCCL(213,68)-JACCCCL(68,68)
      JACC(68,63) = SAVE2007
      DWCCL(213,63) = DWCCL(213,63)-JACCCCL(68,63)
      JACC(66,68) = SAVE2006
      DWCCL(213,68) = DWCCL(213,68)+JACCCCL(66,68)
      JACC(66,63) = SAVE2005
      DWCCL(213,63) = DWCCL(213,63)+JACCCCL(66,63)
      JACC(63,68) = SAVE2004
      DWCCL(213,68) = DWCCL(213,68)-JACCCCL(63,68)
      JACC(63,63) = SAVE2003
      DWCCL(213,63) = DWCCL(213,63)-JACCCCL(63,63)
      JACC(72,46) = SAVE2002
      DWCCL(212,46) = DWCCL(212,46)+JACCCCL(72,46)
      JACC(72,46) = SAVE2001
      DWCCL(212,46) = DWCCL(212,46)+JACCCCL(72,46)
      JACC(70,46) = SAVE2000
      DWCCL(212,46) = DWCCL(212,46)+JACCCCL(70,46)
      JACC(70,46) = SAVE1999
      DWCCL(212,46) = DWCCL(212,46)+JACCCCL(70,46)
      JACC(66,46) = SAVE1998
      DWCCL(212,46) =
     : DWCCL(212,46)+JACCCCL(66,46)*0.5040000000000000d+00
      JACC(66,46) = SAVE1997
      DWCCL(212,46) =
     : DWCCL(212,46)+JACCCCL(66,46)*0.5040000000000000d+00
      JACC(61,46) = SAVE1996
      DWCCL(212,46) =
     : DWCCL(212,46)+JACCCCL(61,46)*0.1210000000000000d+01
      JACC(61,46) = SAVE1995
      DWCCL(212,46) =
     : DWCCL(212,46)+JACCCCL(61,46)*0.1210000000000000d+01
      JACC(59,46) = SAVE1994
      DWCCL(212,46) =
     : DWCCL(212,46)+JACCCCL(59,46)*0.2850000000000000d+00
      JACC(59,46) = SAVE1993
      DWCCL(212,46) =
     : DWCCL(212,46)+JACCCCL(59,46)*0.2850000000000000d+00
      JACC(46,46) = SAVE1992
      DWCCL(212,46) =
     : DWCCL(212,46)-JACCCCL(46,46)*0.2000000000000000d+01
      JACC(46,46) = SAVE1991
      DWCCL(212,46) =
     : DWCCL(212,46)-JACCCCL(46,46)*0.2000000000000000d+01
      JACC(72,46) = SAVE1990
      DWCCL(211,46) =
     : DWCCL(211,46)+JACCCCL(72,46)*0.5000000000000000d+00
      JACC(72,47) = SAVE1989
      DWCCL(211,47) =
     : DWCCL(211,47)+JACCCCL(72,47)*0.5000000000000000d+00
      JACC(71,46) = SAVE1988
      DWCCL(211,46) =
     : DWCCL(211,46)+JACCCCL(71,46)*0.5000000000000000d+00
      JACC(71,47) = SAVE1987
      DWCCL(211,47) =
     : DWCCL(211,47)+JACCCCL(71,47)*0.5000000000000000d+00
      JACC(70,46) = SAVE1986
      DWCCL(211,46) =
     : DWCCL(211,46)+JACCCCL(70,46)*0.1500000000000000d+01
      JACC(70,47) = SAVE1985
      DWCCL(211,47) =
     : DWCCL(211,47)+JACCCCL(70,47)*0.1500000000000000d+01
      JACC(66,46) = SAVE1984
      DWCCL(211,46) =
     : DWCCL(211,46)+JACCCCL(66,46)*0.2020000000000000d+00
      JACC(66,47) = SAVE1983
      DWCCL(211,47) =
     : DWCCL(211,47)+JACCCCL(66,47)*0.2020000000000000d+00
      JACC(61,46) = SAVE1982
      DWCCL(211,46) =
     : DWCCL(211,46)+JACCCCL(61,46)*0.6400000000000000d+00
      JACC(61,47) = SAVE1981
      DWCCL(211,47) =
     : DWCCL(211,47)+JACCCCL(61,47)*0.6400000000000000d+00
      JACC(59,46) = SAVE1980
      DWCCL(211,46) =
     : DWCCL(211,46)+JACCCCL(59,46)*0.1490000000000000d+00
      JACC(59,47) = SAVE1979
      DWCCL(211,47) =
     : DWCCL(211,47)+JACCCCL(59,47)*0.1490000000000000d+00
      JACC(47,46) = SAVE1978
      DWCCL(211,46) = DWCCL(211,46)-JACCCCL(47,46)
      JACC(47,47) = SAVE1977
      DWCCL(211,47) = DWCCL(211,47)-JACCCCL(47,47)
      JACC(46,46) = SAVE1976
      DWCCL(211,46) = DWCCL(211,46)-JACCCCL(46,46)
      JACC(46,47) = SAVE1975
      DWCCL(211,47) = DWCCL(211,47)-JACCCCL(46,47)
      JACC(71,47) = SAVE1974
      DWCCL(210,47) = DWCCL(210,47)+JACCCCL(71,47)
      JACC(71,47) = SAVE1973
      DWCCL(210,47) = DWCCL(210,47)+JACCCCL(71,47)
      JACC(70,47) = SAVE1972
      DWCCL(210,47) =
     : DWCCL(210,47)+JACCCCL(70,47)*0.2000000000000000d+01
      JACC(70,47) = SAVE1971
      DWCCL(210,47) =
     : DWCCL(210,47)+JACCCCL(70,47)*0.2000000000000000d+01
      JACC(47,47) = SAVE1970
      DWCCL(210,47) =
     : DWCCL(210,47)-JACCCCL(47,47)*0.2000000000000000d+01
      JACC(47,47) = SAVE1969
      DWCCL(210,47) =
     : DWCCL(210,47)-JACCCCL(47,47)*0.2000000000000000d+01
      JACC(72,69) = SAVE1968
      DWCCL(209,69) =
     : DWCCL(209,69)+JACCCCL(72,69)*0.5160000000000000d+00
      JACC(72,46) = SAVE1967
      DWCCL(209,46) =
     : DWCCL(209,46)+JACCCCL(72,46)*0.5160000000000000d+00
      JACC(70,69) = SAVE1966
      DWCCL(209,69) =
     : DWCCL(209,69)+JACCCCL(70,69)*0.4840000000000000d+00
      JACC(70,46) = SAVE1965
      DWCCL(209,46) =
     : DWCCL(209,46)+JACCCCL(70,46)*0.4840000000000000d+00
      JACC(69,69) = SAVE1964
      DWCCL(209,69) = DWCCL(209,69)-JACCCCL(69,69)
      JACC(69,46) = SAVE1963
      DWCCL(209,46) = DWCCL(209,46)-JACCCCL(69,46)
      JACC(66,69) = SAVE1962
      DWCCL(209,69) =
     : DWCCL(209,69)+JACCCCL(66,69)*0.2070000000000000d+00
      JACC(66,46) = SAVE1961
      DWCCL(209,46) =
     : DWCCL(209,46)+JACCCCL(66,46)*0.2070000000000000d+00
      JACC(63,69) = SAVE1960
      DWCCL(209,69) =
     : DWCCL(209,69)+JACCCCL(63,69)*0.5160000000000000d+00
      JACC(63,46) = SAVE1959
      DWCCL(209,46) =
     : DWCCL(209,46)+JACCCCL(63,46)*0.5160000000000000d+00
      JACC(61,69) = SAVE1958
      DWCCL(209,69) =
     : DWCCL(209,69)+JACCCCL(61,69)*0.6500000000000000d+00
      JACC(61,46) = SAVE1957
      DWCCL(209,46) =
     : DWCCL(209,46)+JACCCCL(61,46)*0.6500000000000000d+00
      JACC(59,69) = SAVE1956
      DWCCL(209,69) =
     : DWCCL(209,69)+JACCCCL(59,69)*0.1670000000000000d+00
      JACC(59,46) = SAVE1955
      DWCCL(209,46) =
     : DWCCL(209,46)+JACCCCL(59,46)*0.1670000000000000d+00
      JACC(57,69) = SAVE1954
      DWCCL(209,69) =
     : DWCCL(209,69)+JACCCCL(57,69)*0.4840000000000000d+00
      JACC(57,46) = SAVE1953
      DWCCL(209,46) =
     : DWCCL(209,46)+JACCCCL(57,46)*0.4840000000000000d+00
      JACC(46,69) = SAVE1952
      DWCCL(209,69) = DWCCL(209,69)-JACCCCL(46,69)
      JACC(46,46) = SAVE1951
      DWCCL(209,46) = DWCCL(209,46)-JACCCCL(46,46)
      JACC(71,69) = SAVE1950
      DWCCL(208,69) =
     : DWCCL(208,69)+JACCCCL(71,69)*0.5000000000000000d+00
      JACC(71,47) = SAVE1949
      DWCCL(208,47) =
     : DWCCL(208,47)+JACCCCL(71,47)*0.5000000000000000d+00
      JACC(70,69) = SAVE1948
      DWCCL(208,69) = DWCCL(208,69)+JACCCCL(70,69)
      JACC(70,47) = SAVE1947
      DWCCL(208,47) = DWCCL(208,47)+JACCCCL(70,47)
      JACC(69,69) = SAVE1946
      DWCCL(208,69) = DWCCL(208,69)-JACCCCL(69,69)
      JACC(69,47) = SAVE1945
      DWCCL(208,47) = DWCCL(208,47)-JACCCCL(69,47)
      JACC(63,69) = SAVE1944
      DWCCL(208,69) =
     : DWCCL(208,69)+JACCCCL(63,69)*0.5000000000000000d+00
      JACC(63,47) = SAVE1943
      DWCCL(208,47) =
     : DWCCL(208,47)+JACCCCL(63,47)*0.5000000000000000d+00
      JACC(57,69) = SAVE1942
      DWCCL(208,69) =
     : DWCCL(208,69)+JACCCCL(57,69)*0.5000000000000000d+00
      JACC(57,47) = SAVE1941
      DWCCL(208,47) =
     : DWCCL(208,47)+JACCCCL(57,47)*0.5000000000000000d+00
      JACC(47,69) = SAVE1940
      DWCCL(208,69) = DWCCL(208,69)-JACCCCL(47,69)
      JACC(47,47) = SAVE1939
      DWCCL(208,47) = DWCCL(208,47)-JACCCCL(47,47)
      JACC(71,69) = SAVE1938
      DWCCL(207,69) =
     : DWCCL(207,69)+JACCCCL(71,69)*0.3800000000000000d+00
      JACC(71,58) = SAVE1937
      DWCCL(207,58) =
     : DWCCL(207,58)+JACCCCL(71,58)*0.3800000000000000d+00
      JACC(69,69) = SAVE1936
      DWCCL(207,69) =
     : DWCCL(207,69)-JACCCCL(69,69)*0.8800000000000000d+00
      JACC(69,58) = SAVE1935
      DWCCL(207,58) =
     : DWCCL(207,58)-JACCCCL(69,58)*0.8800000000000000d+00
      JACC(65,69) = SAVE1934
      DWCCL(207,69) =
     : DWCCL(207,69)+JACCCCL(65,69)*0.8000000000000000d-01
      JACC(65,58) = SAVE1933
      DWCCL(207,58) =
     : DWCCL(207,58)+JACCCCL(65,58)*0.8000000000000000d-01
      JACC(63,69) = SAVE1932
      DWCCL(207,69) =
     : DWCCL(207,69)+JACCCCL(63,69)*0.5000000000000000d+00
      JACC(63,58) = SAVE1931
      DWCCL(207,58) =
     : DWCCL(207,58)+JACCCCL(63,58)*0.5000000000000000d+00
      JACC(61,69) = SAVE1930
      DWCCL(207,69) =
     : DWCCL(207,69)+JACCCCL(61,69)*0.3500000000000000d+00
      JACC(61,58) = SAVE1929
      DWCCL(207,58) =
     : DWCCL(207,58)+JACCCCL(61,58)*0.3500000000000000d+00
      JACC(59,69) = SAVE1928
      DWCCL(207,69) =
     : DWCCL(207,69)+JACCCCL(59,69)*0.1100000000000000d+00
      JACC(59,58) = SAVE1927
      DWCCL(207,58) =
     : DWCCL(207,58)+JACCCCL(59,58)*0.1100000000000000d+00
      JACC(58,69) = SAVE1926
      DWCCL(207,69) = DWCCL(207,69)-JACCCCL(58,69)
      JACC(58,58) = SAVE1925
      DWCCL(207,58) = DWCCL(207,58)-JACCCCL(58,58)
      JACC(57,69) = SAVE1924
      DWCCL(207,69) =
     : DWCCL(207,69)+JACCCCL(57,69)*0.5000000000000000d+00
      JACC(57,58) = SAVE1923
      DWCCL(207,58) =
     : DWCCL(207,58)+JACCCCL(57,58)*0.5000000000000000d+00
      JACC(54,69) = SAVE1922
      DWCCL(207,69) =
     : DWCCL(207,69)+JACCCCL(54,69)*0.5400000000000000d+00
      JACC(54,58) = SAVE1921
      DWCCL(207,58) =
     : DWCCL(207,58)+JACCCCL(54,58)*0.5400000000000000d+00
      JACC(66,69) = SAVE1920
      DWCCL(206,69) = DWCCL(206,69)+JACCCCL(66,69)
      JACC(66,56) = SAVE1919
      DWCCL(206,56) = DWCCL(206,56)+JACCCCL(66,56)
      JACC(63,69) = SAVE1918
      DWCCL(206,69) = DWCCL(206,69)+JACCCCL(63,69)
      JACC(63,56) = SAVE1917
      DWCCL(206,56) = DWCCL(206,56)+JACCCCL(63,56)
      JACC(56,69) = SAVE1916
      DWCCL(206,69) = DWCCL(206,69)-JACCCCL(56,69)
      JACC(56,56) = SAVE1915
      DWCCL(206,56) = DWCCL(206,56)-JACCCCL(56,56)
      JACC(69,69) = SAVE1914
      DWCCL(205,69) =
     : DWCCL(205,69)-JACCCCL(69,69)*0.2000000000000000d+01
      JACC(69,69) = SAVE1913
      DWCCL(205,69) =
     : DWCCL(205,69)-JACCCCL(69,69)*0.2000000000000000d+01
      JACC(63,69) = SAVE1912
      DWCCL(205,69) =
     : DWCCL(205,69)+JACCCCL(63,69)*0.2000000000000000d+01
      JACC(63,69) = SAVE1911
      DWCCL(205,69) =
     : DWCCL(205,69)+JACCCCL(63,69)*0.2000000000000000d+01
      JACC(71,69) = SAVE1910
      DWCCL(204,69) = DWCCL(204,69)+JACCCCL(71,69)
      JACC(71,33) = SAVE1909
      DWCCL(204,33) = DWCCL(204,33)+JACCCCL(71,33)
      JACC(69,69) = SAVE1908
      DWCCL(204,69) = DWCCL(204,69)-JACCCCL(69,69)
      JACC(69,33) = SAVE1907
      DWCCL(204,33) = DWCCL(204,33)-JACCCCL(69,33)
      JACC(63,69) = SAVE1906
      DWCCL(204,69) = DWCCL(204,69)+JACCCCL(63,69)
      JACC(63,33) = SAVE1905
      DWCCL(204,33) = DWCCL(204,33)+JACCCCL(63,33)
      JACC(54,69) = SAVE1904
      DWCCL(204,69) = DWCCL(204,69)+JACCCCL(54,69)
      JACC(54,33) = SAVE1903
      DWCCL(204,33) = DWCCL(204,33)+JACCCCL(54,33)
      JACC(51,69) = SAVE1902
      DWCCL(204,69) = DWCCL(204,69)+JACCCCL(51,69)
      JACC(51,33) = SAVE1901
      DWCCL(204,33) = DWCCL(204,33)+JACCCCL(51,33)
      JACC(33,69) = SAVE1900
      DWCCL(204,69) = DWCCL(204,69)-JACCCCL(33,69)
      JACC(33,33) = SAVE1899
      DWCCL(204,33) = DWCCL(204,33)-JACCCCL(33,33)
      JACC(71,69) = SAVE1898
      DWCCL(203,69) = DWCCL(203,69)+JACCCCL(71,69)
      JACC(71,32) = SAVE1897
      DWCCL(203,32) = DWCCL(203,32)+JACCCCL(71,32)
      JACC(69,69) = SAVE1896
      DWCCL(203,69) = DWCCL(203,69)-JACCCCL(69,69)
      JACC(69,32) = SAVE1895
      DWCCL(203,32) = DWCCL(203,32)-JACCCCL(69,32)
      JACC(63,69) = SAVE1894
      DWCCL(203,69) = DWCCL(203,69)+JACCCCL(63,69)
      JACC(63,32) = SAVE1893
      DWCCL(203,32) = DWCCL(203,32)+JACCCCL(63,32)
      JACC(54,69) = SAVE1892
      DWCCL(203,69) =
     : DWCCL(203,69)+JACCCCL(54,69)*0.6300000000000000d+00
      JACC(54,32) = SAVE1891
      DWCCL(203,32) =
     : DWCCL(203,32)+JACCCCL(54,32)*0.6300000000000000d+00
      JACC(51,69) = SAVE1890
      DWCCL(203,69) =
     : DWCCL(203,69)+JACCCCL(51,69)*0.3700000000000000d+00
      JACC(51,32) = SAVE1889
      DWCCL(203,32) =
     : DWCCL(203,32)+JACCCCL(51,32)*0.3700000000000000d+00
      JACC(48,69) = SAVE1888
      DWCCL(203,69) = DWCCL(203,69)+JACCCCL(48,69)
      JACC(48,32) = SAVE1887
      DWCCL(203,32) = DWCCL(203,32)+JACCCCL(48,32)
      JACC(32,69) = SAVE1886
      DWCCL(203,69) = DWCCL(203,69)-JACCCCL(32,69)
      JACC(32,32) = SAVE1885
      DWCCL(203,32) = DWCCL(203,32)-JACCCCL(32,32)
      JACC(71,69) = SAVE1884
      DWCCL(202,69) = DWCCL(202,69)+JACCCCL(71,69)
      JACC(71,31) = SAVE1883
      DWCCL(202,31) = DWCCL(202,31)+JACCCCL(71,31)
      JACC(69,69) = SAVE1882
      DWCCL(202,69) = DWCCL(202,69)-JACCCCL(69,69)
      JACC(69,31) = SAVE1881
      DWCCL(202,31) = DWCCL(202,31)-JACCCCL(69,31)
      JACC(63,69) = SAVE1880
      DWCCL(202,69) = DWCCL(202,69)+JACCCCL(63,69)
      JACC(63,31) = SAVE1879
      DWCCL(202,31) = DWCCL(202,31)+JACCCCL(63,31)
      JACC(54,69) = SAVE1878
      DWCCL(202,69) =
     : DWCCL(202,69)+JACCCCL(54,69)*0.3500000000000000d+00
      JACC(54,31) = SAVE1877
      DWCCL(202,31) =
     : DWCCL(202,31)+JACCCCL(54,31)*0.3500000000000000d+00
      JACC(51,69) = SAVE1876
      DWCCL(202,69) =
     : DWCCL(202,69)+JACCCCL(51,69)*0.6500000000000000d+00
      JACC(51,31) = SAVE1875
      DWCCL(202,31) =
     : DWCCL(202,31)+JACCCCL(51,31)*0.6500000000000000d+00
      JACC(48,69) = SAVE1874
      DWCCL(202,69) = DWCCL(202,69)+JACCCCL(48,69)
      JACC(48,31) = SAVE1873
      DWCCL(202,31) = DWCCL(202,31)+JACCCCL(48,31)
      JACC(31,69) = SAVE1872
      DWCCL(202,69) = DWCCL(202,69)-JACCCCL(31,69)
      JACC(31,31) = SAVE1871
      DWCCL(202,31) = DWCCL(202,31)-JACCCCL(31,31)
      JACC(71,69) = SAVE1870
      DWCCL(201,69) = DWCCL(201,69)+JACCCCL(71,69)
      JACC(71,43) = SAVE1869
      DWCCL(201,43) = DWCCL(201,43)+JACCCCL(71,43)
      JACC(69,69) = SAVE1868
      DWCCL(201,69) = DWCCL(201,69)-JACCCCL(69,69)
      JACC(69,43) = SAVE1867
      DWCCL(201,43) = DWCCL(201,43)-JACCCCL(69,43)
      JACC(66,69) = SAVE1866
      DWCCL(201,69) =
     : DWCCL(201,69)+JACCCCL(66,69)*0.4000000000000000d+00
      JACC(66,43) = SAVE1865
      DWCCL(201,43) =
     : DWCCL(201,43)+JACCCCL(66,43)*0.4000000000000000d+00
      JACC(63,69) = SAVE1864
      DWCCL(201,69) = DWCCL(201,69)+JACCCCL(63,69)
      JACC(63,43) = SAVE1863
      DWCCL(201,43) = DWCCL(201,43)+JACCCCL(63,43)
      JACC(49,69) = SAVE1862
      DWCCL(201,69) =
     : DWCCL(201,69)+JACCCCL(49,69)*0.6000000000000000d+00
      JACC(49,43) = SAVE1861
      DWCCL(201,43) =
     : DWCCL(201,43)+JACCCCL(49,43)*0.6000000000000000d+00
      JACC(44,69) = SAVE1860
      DWCCL(201,69) =
     : DWCCL(201,69)+JACCCCL(44,69)*0.4000000000000000d+00
      JACC(44,43) = SAVE1859
      DWCCL(201,43) =
     : DWCCL(201,43)+JACCCCL(44,43)*0.4000000000000000d+00
      JACC(43,69) = SAVE1858
      DWCCL(201,69) = DWCCL(201,69)-JACCCCL(43,69)
      JACC(43,43) = SAVE1857
      DWCCL(201,43) = DWCCL(201,43)-JACCCCL(43,43)
      JACC(71,69) = SAVE1856
      DWCCL(200,69) = DWCCL(200,69)+JACCCCL(71,69)
      JACC(71,42) = SAVE1855
      DWCCL(200,42) = DWCCL(200,42)+JACCCCL(71,42)
      JACC(69,69) = SAVE1854
      DWCCL(200,69) = DWCCL(200,69)-JACCCCL(69,69)
      JACC(69,42) = SAVE1853
      DWCCL(200,42) = DWCCL(200,42)-JACCCCL(69,42)
      JACC(63,69) = SAVE1852
      DWCCL(200,69) = DWCCL(200,69)+JACCCCL(63,69)
      JACC(63,42) = SAVE1851
      DWCCL(200,42) = DWCCL(200,42)+JACCCCL(63,42)
      JACC(61,69) = SAVE1850
      DWCCL(200,69) = DWCCL(200,69)+JACCCCL(61,69)
      JACC(61,42) = SAVE1849
      DWCCL(200,42) = DWCCL(200,42)+JACCCCL(61,42)
      JACC(59,69) = SAVE1848
      DWCCL(200,69) = DWCCL(200,69)+JACCCCL(59,69)
      JACC(59,42) = SAVE1847
      DWCCL(200,42) = DWCCL(200,42)+JACCCCL(59,42)
      JACC(42,69) = SAVE1846
      DWCCL(200,69) = DWCCL(200,69)-JACCCCL(42,69)
      JACC(42,42) = SAVE1845
      DWCCL(200,42) = DWCCL(200,42)-JACCCCL(42,42)
      JACC(71,69) = SAVE1844
      DWCCL(199,69) =
     : DWCCL(199,69)+JACCCCL(71,69)*0.5060000000000000d+00
      JACC(71,39) = SAVE1843
      DWCCL(199,39) =
     : DWCCL(199,39)+JACCCCL(71,39)*0.5060000000000000d+00
      JACC(69,69) = SAVE1842
      DWCCL(199,69) = DWCCL(199,69)-JACCCCL(69,69)
      JACC(69,39) = SAVE1841
      DWCCL(199,39) = DWCCL(199,39)-JACCCCL(69,39)
      JACC(66,69) = SAVE1840
      DWCCL(199,69) =
     : DWCCL(199,69)+JACCCCL(66,69)*0.3400000000000000d+00
      JACC(66,39) = SAVE1839
      DWCCL(199,39) =
     : DWCCL(199,39)+JACCCCL(66,39)*0.3400000000000000d+00
      JACC(63,69) = SAVE1838
      DWCCL(199,69) =
     : DWCCL(199,69)+JACCCCL(63,69)*0.5060000000000000d+00
      JACC(63,39) = SAVE1837
      DWCCL(199,39) =
     : DWCCL(199,39)+JACCCCL(63,39)*0.5060000000000000d+00
      JACC(57,69) = SAVE1836
      DWCCL(199,69) =
     : DWCCL(199,69)+JACCCCL(57,69)*0.4940000000000000d+00
      JACC(57,39) = SAVE1835
      DWCCL(199,39) =
     : DWCCL(199,39)+JACCCCL(57,39)*0.4940000000000000d+00
      JACC(49,69) = SAVE1834
      DWCCL(199,69) =
     : DWCCL(199,69)+JACCCCL(49,69)*0.7710000000000000d+00
      JACC(49,39) = SAVE1833
      DWCCL(199,39) =
     : DWCCL(199,39)+JACCCCL(49,39)*0.7710000000000000d+00
      JACC(40,69) = SAVE1832
      DWCCL(199,69) =
     : DWCCL(199,69)+JACCCCL(40,69)*0.2290000000000000d+00
      JACC(40,39) = SAVE1831
      DWCCL(199,39) =
     : DWCCL(199,39)+JACCCCL(40,39)*0.2290000000000000d+00
      JACC(39,69) = SAVE1830
      DWCCL(199,69) = DWCCL(199,69)-JACCCCL(39,69)
      JACC(39,39) = SAVE1829
      DWCCL(199,39) = DWCCL(199,39)-JACCCCL(39,39)
      JACC(71,69) = SAVE1828
      DWCCL(198,69) =
     : DWCCL(198,69)+JACCCCL(71,69)*0.5100000000000000d+00
      JACC(71,45) = SAVE1827
      DWCCL(198,45) =
     : DWCCL(198,45)+JACCCCL(71,45)*0.5100000000000000d+00
      JACC(69,69) = SAVE1826
      DWCCL(198,69) = DWCCL(198,69)-JACCCCL(69,69)
      JACC(69,45) = SAVE1825
      DWCCL(198,45) = DWCCL(198,45)-JACCCCL(69,45)
      JACC(63,69) = SAVE1824
      DWCCL(198,69) =
     : DWCCL(198,69)+JACCCCL(63,69)*0.5100000000000000d+00
      JACC(63,45) = SAVE1823
      DWCCL(198,45) =
     : DWCCL(198,45)+JACCCCL(63,45)*0.5100000000000000d+00
      JACC(61,69) = SAVE1822
      DWCCL(198,69) =
     : DWCCL(198,69)+JACCCCL(61,69)*0.9409999999999999d+00
      JACC(61,45) = SAVE1821
      DWCCL(198,45) =
     : DWCCL(198,45)+JACCCCL(61,45)*0.9409999999999999d+00
      JACC(59,69) = SAVE1820
      DWCCL(198,69) =
     : DWCCL(198,69)+JACCCCL(59,69)*0.5690000000000000d+00
      JACC(59,45) = SAVE1819
      DWCCL(198,45) =
     : DWCCL(198,45)+JACCCCL(59,45)*0.5690000000000000d+00
      JACC(57,69) = SAVE1818
      DWCCL(198,69) =
     : DWCCL(198,69)+JACCCCL(57,69)*0.4900000000000000d+00
      JACC(57,45) = SAVE1817
      DWCCL(198,45) =
     : DWCCL(198,45)+JACCCCL(57,45)*0.4900000000000000d+00
      JACC(45,69) = SAVE1816
      DWCCL(198,69) = DWCCL(198,69)-JACCCCL(45,69)
      JACC(45,45) = SAVE1815
      DWCCL(198,45) = DWCCL(198,45)-JACCCCL(45,45)
      JACC(71,69) = SAVE1814
      DWCCL(197,69) =
     : DWCCL(197,69)+JACCCCL(71,69)*0.5010000000000000d+00
      JACC(71,41) = SAVE1813
      DWCCL(197,41) =
     : DWCCL(197,41)+JACCCCL(71,41)*0.5010000000000000d+00
      JACC(69,69) = SAVE1812
      DWCCL(197,69) = DWCCL(197,69)-JACCCCL(69,69)
      JACC(69,41) = SAVE1811
      DWCCL(197,41) = DWCCL(197,41)-JACCCCL(69,41)
      JACC(66,69) = SAVE1810
      DWCCL(197,69) =
     : DWCCL(197,69)+JACCCCL(66,69)*0.5010000000000000d+00
      JACC(66,41) = SAVE1809
      DWCCL(197,41) =
     : DWCCL(197,41)+JACCCCL(66,41)*0.5010000000000000d+00
      JACC(63,69) = SAVE1808
      DWCCL(197,69) =
     : DWCCL(197,69)+JACCCCL(63,69)*0.5010000000000000d+00
      JACC(63,41) = SAVE1807
      DWCCL(197,41) =
     : DWCCL(197,41)+JACCCCL(63,41)*0.5010000000000000d+00
      JACC(61,69) = SAVE1806
      DWCCL(197,69) =
     : DWCCL(197,69)+JACCCCL(61,69)*0.8590000000000000d+00
      JACC(61,41) = SAVE1805
      DWCCL(197,41) =
     : DWCCL(197,41)+JACCCCL(61,41)*0.8590000000000000d+00
      JACC(59,69) = SAVE1804
      DWCCL(197,69) =
     : DWCCL(197,69)+JACCCCL(59,69)*0.1410000000000000d+00
      JACC(59,41) = SAVE1803
      DWCCL(197,41) =
     : DWCCL(197,41)+JACCCCL(59,41)*0.1410000000000000d+00
      JACC(57,69) = SAVE1802
      DWCCL(197,69) =
     : DWCCL(197,69)+JACCCCL(57,69)*0.4990000000000000d+00
      JACC(57,41) = SAVE1801
      DWCCL(197,41) =
     : DWCCL(197,41)+JACCCCL(57,41)*0.4990000000000000d+00
      JACC(41,69) = SAVE1800
      DWCCL(197,69) = DWCCL(197,69)-JACCCCL(41,69)
      JACC(41,41) = SAVE1799
      DWCCL(197,41) = DWCCL(197,41)-JACCCCL(41,41)
      JACC(71,69) = SAVE1798
      DWCCL(196,69) =
     : DWCCL(196,69)+JACCCCL(71,69)*0.5000000000000000d+00
      JACC(71,38) = SAVE1797
      DWCCL(196,38) =
     : DWCCL(196,38)+JACCCCL(71,38)*0.5000000000000000d+00
      JACC(69,69) = SAVE1796
      DWCCL(196,69) = DWCCL(196,69)-JACCCCL(69,69)
      JACC(69,38) = SAVE1795
      DWCCL(196,38) = DWCCL(196,38)-JACCCCL(69,38)
      JACC(66,69) = SAVE1794
      DWCCL(196,69) =
     : DWCCL(196,69)+JACCCCL(66,69)*0.8000000000000000d+00
      JACC(66,38) = SAVE1793
      DWCCL(196,38) =
     : DWCCL(196,38)+JACCCCL(66,38)*0.8000000000000000d+00
      JACC(63,69) = SAVE1792
      DWCCL(196,69) =
     : DWCCL(196,69)+JACCCCL(63,69)*0.5000000000000000d+00
      JACC(63,38) = SAVE1791
      DWCCL(196,38) =
     : DWCCL(196,38)+JACCCCL(63,38)*0.5000000000000000d+00
      JACC(61,69) = SAVE1790
      DWCCL(196,69) =
     : DWCCL(196,69)+JACCCCL(61,69)*0.6000000000000000d+00
      JACC(61,38) = SAVE1789
      DWCCL(196,38) =
     : DWCCL(196,38)+JACCCCL(61,38)*0.6000000000000000d+00
      JACC(57,69) = SAVE1788
      DWCCL(196,69) =
     : DWCCL(196,69)+JACCCCL(57,69)*0.5000000000000000d+00
      JACC(57,38) = SAVE1787
      DWCCL(196,38) =
     : DWCCL(196,38)+JACCCCL(57,38)*0.5000000000000000d+00
      JACC(38,69) = SAVE1786
      DWCCL(196,69) = DWCCL(196,69)-JACCCCL(38,69)
      JACC(38,38) = SAVE1785
      DWCCL(196,38) = DWCCL(196,38)-JACCCCL(38,38)
      JACC(71,69) = SAVE1784
      DWCCL(195,69) =
     : DWCCL(195,69)+JACCCCL(71,69)*0.4890000000000000d+00
      JACC(71,37) = SAVE1783
      DWCCL(195,37) =
     : DWCCL(195,37)+JACCCCL(71,37)*0.4890000000000000d+00
      JACC(69,69) = SAVE1782
      DWCCL(195,69) = DWCCL(195,69)-JACCCCL(69,69)
      JACC(69,37) = SAVE1781
      DWCCL(195,37) = DWCCL(195,37)-JACCCCL(69,37)
      JACC(65,69) = SAVE1780
      DWCCL(195,69) =
     : DWCCL(195,69)+JACCCCL(65,69)*0.3180000000000000d+00
      JACC(65,37) = SAVE1779
      DWCCL(195,37) =
     : DWCCL(195,37)+JACCCCL(65,37)*0.3180000000000000d+00
      JACC(63,69) = SAVE1778
      DWCCL(195,69) =
     : DWCCL(195,69)+JACCCCL(63,69)*0.5070000000000000d+00
      JACC(63,37) = SAVE1777
      DWCCL(195,37) =
     : DWCCL(195,37)+JACCCCL(63,37)*0.5070000000000000d+00
      JACC(61,69) = SAVE1776
      DWCCL(195,69) =
     : DWCCL(195,69)+JACCCCL(61,69)*0.4970000000000000d+00
      JACC(61,37) = SAVE1775
      DWCCL(195,37) =
     : DWCCL(195,37)+JACCCCL(61,37)*0.4970000000000000d+00
      JACC(60,69) = SAVE1774
      DWCCL(195,69) =
     : DWCCL(195,69)+JACCCCL(60,69)*0.1500000000000000d-01
      JACC(60,37) = SAVE1773
      DWCCL(195,37) =
     : DWCCL(195,37)+JACCCCL(60,37)*0.1500000000000000d-01
      JACC(59,69) = SAVE1772
      DWCCL(195,69) =
     : DWCCL(195,69)+JACCCCL(59,69)*0.5810000000000000d+00
      JACC(59,37) = SAVE1771
      DWCCL(195,37) =
     : DWCCL(195,37)+JACCCCL(59,37)*0.5810000000000000d+00
      JACC(57,69) = SAVE1770
      DWCCL(195,69) =
     : DWCCL(195,69)+JACCCCL(57,69)*0.4950000000000000d+00
      JACC(57,37) = SAVE1769
      DWCCL(195,37) =
     : DWCCL(195,37)+JACCCCL(57,37)*0.4950000000000000d+00
      JACC(37,69) = SAVE1768
      DWCCL(195,69) = DWCCL(195,69)-JACCCCL(37,69)
      JACC(37,37) = SAVE1767
      DWCCL(195,37) = DWCCL(195,37)-JACCCCL(37,37)
      JACC(71,69) = SAVE1766
      DWCCL(194,69) =
     : DWCCL(194,69)+JACCCCL(71,69)*0.4380000000000000d+00
      JACC(71,36) = SAVE1765
      DWCCL(194,36) =
     : DWCCL(194,36)+JACCCCL(71,36)*0.4380000000000000d+00
      JACC(69,69) = SAVE1764
      DWCCL(194,69) = DWCCL(194,69)-JACCCCL(69,69)
      JACC(69,36) = SAVE1763
      DWCCL(194,36) = DWCCL(194,36)-JACCCCL(69,36)
      JACC(66,69) = SAVE1762
      DWCCL(194,69) =
     : DWCCL(194,69)+JACCCCL(66,69)*0.7600000000000000d-01
      JACC(66,36) = SAVE1761
      DWCCL(194,36) =
     : DWCCL(194,36)+JACCCCL(66,36)*0.7600000000000000d-01
      JACC(65,69) = SAVE1760
      DWCCL(194,69) =
     : DWCCL(194,69)+JACCCCL(65,69)*0.2370000000000000d+00
      JACC(65,36) = SAVE1759
      DWCCL(194,36) =
     : DWCCL(194,36)+JACCCCL(65,36)*0.2370000000000000d+00
      JACC(63,69) = SAVE1758
      DWCCL(194,69) =
     : DWCCL(194,69)+JACCCCL(63,69)*0.5540000000000000d+00
      JACC(63,36) = SAVE1757
      DWCCL(194,36) =
     : DWCCL(194,36)+JACCCCL(63,36)*0.5540000000000000d+00
      JACC(61,69) = SAVE1756
      DWCCL(194,69) =
     : DWCCL(194,69)+JACCCCL(61,69)*0.6770000000000000d+00
      JACC(61,36) = SAVE1755
      DWCCL(194,36) =
     : DWCCL(194,36)+JACCCCL(61,36)*0.6770000000000000d+00
      JACC(60,69) = SAVE1754
      DWCCL(194,69) =
     : DWCCL(194,69)+JACCCCL(60,69)*0.1800000000000000d-01
      JACC(60,36) = SAVE1753
      DWCCL(194,36) =
     : DWCCL(194,36)+JACCCCL(60,36)*0.1800000000000000d-01
      JACC(59,69) = SAVE1752
      DWCCL(194,69) =
     : DWCCL(194,69)+JACCCCL(59,69)*0.3300000000000000d+00
      JACC(59,36) = SAVE1751
      DWCCL(194,36) =
     : DWCCL(194,36)+JACCCCL(59,36)*0.3300000000000000d+00
      JACC(57,69) = SAVE1750
      DWCCL(194,69) =
     : DWCCL(194,69)+JACCCCL(57,69)*0.4950000000000000d+00
      JACC(57,36) = SAVE1749
      DWCCL(194,36) =
     : DWCCL(194,36)+JACCCCL(57,36)*0.4950000000000000d+00
      JACC(36,69) = SAVE1748
      DWCCL(194,69) = DWCCL(194,69)-JACCCCL(36,69)
      JACC(36,36) = SAVE1747
      DWCCL(194,36) = DWCCL(194,36)-JACCCCL(36,36)
      JACC(71,69) = SAVE1746
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(71,69)*0.4880000000000000d+00
      JACC(71,64) = SAVE1745
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(71,64)*0.4880000000000000d+00
      JACC(69,69) = SAVE1744
      DWCCL(193,69) = DWCCL(193,69)-JACCCCL(69,69)
      JACC(69,64) = SAVE1743
      DWCCL(193,64) = DWCCL(193,64)-JACCCCL(69,64)
      JACC(66,69) = SAVE1742
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(66,69)*0.9100000000000000d-01
      JACC(66,64) = SAVE1741
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(66,64)*0.9100000000000000d-01
      JACC(65,69) = SAVE1740
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(65,69)*0.7099999999999999d-01
      JACC(65,64) = SAVE1739
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(65,64)*0.7099999999999999d-01
      JACC(64,69) = SAVE1738
      DWCCL(193,69) = DWCCL(193,69)-JACCCCL(64,69)
      JACC(64,64) = SAVE1737
      DWCCL(193,64) = DWCCL(193,64)-JACCCCL(64,64)
      JACC(63,69) = SAVE1736
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(63,69)*0.5080000000000000d+00
      JACC(63,64) = SAVE1735
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(63,64)*0.5080000000000000d+00
      JACC(61,69) = SAVE1734
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(61,69)*0.7240000000000000d+00
      JACC(61,64) = SAVE1733
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(61,64)*0.7240000000000000d+00
      JACC(60,69) = SAVE1732
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(60,69)*0.6000000000000000d-02
      JACC(60,64) = SAVE1731
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(60,64)*0.6000000000000000d-02
      JACC(59,69) = SAVE1730
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(59,69)*0.1270000000000000d+00
      JACC(59,64) = SAVE1729
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(59,64)*0.1270000000000000d+00
      JACC(57,69) = SAVE1728
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(57,69)*0.4990000000000000d+00
      JACC(57,64) = SAVE1727
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(57,64)*0.4990000000000000d+00
      JACC(54,69) = SAVE1726
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(54,69)*0.4000000000000000d-02
      JACC(54,64) = SAVE1725
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(54,64)*0.4000000000000000d-02
      JACC(51,69) = SAVE1724
      DWCCL(193,69) =
     : DWCCL(193,69)+JACCCCL(51,69)*0.1000000000000000d+00
      JACC(51,64) = SAVE1723
      DWCCL(193,64) =
     : DWCCL(193,64)+JACCCCL(51,64)*0.1000000000000000d+00
      JACC(71,69) = SAVE1722
      DWCCL(192,69) =
     : DWCCL(192,69)+JACCCCL(71,69)*0.5000000000000000d+00
      JACC(71,60) = SAVE1721
      DWCCL(192,60) =
     : DWCCL(192,60)+JACCCCL(71,60)*0.5000000000000000d+00
      JACC(69,69) = SAVE1720
      DWCCL(192,69) = DWCCL(192,69)-JACCCCL(69,69)
      JACC(69,60) = SAVE1719
      DWCCL(192,60) = DWCCL(192,60)-JACCCCL(69,60)
      JACC(63,69) = SAVE1718
      DWCCL(192,69) =
     : DWCCL(192,69)+JACCCCL(63,69)*0.5000000000000000d+00
      JACC(63,60) = SAVE1717
      DWCCL(192,60) =
     : DWCCL(192,60)+JACCCCL(63,60)*0.5000000000000000d+00
      JACC(61,69) = SAVE1716
      DWCCL(192,69) = DWCCL(192,69)+JACCCCL(61,69)
      JACC(61,60) = SAVE1715
      DWCCL(192,60) = DWCCL(192,60)+JACCCCL(61,60)
      JACC(60,69) = SAVE1714
      DWCCL(192,69) = DWCCL(192,69)-JACCCCL(60,69)
      JACC(60,60) = SAVE1713
      DWCCL(192,60) = DWCCL(192,60)-JACCCCL(60,60)
      JACC(57,69) = SAVE1712
      DWCCL(192,69) =
     : DWCCL(192,69)+JACCCCL(57,69)*0.5000000000000000d+00
      JACC(57,60) = SAVE1711
      DWCCL(192,60) =
     : DWCCL(192,60)+JACCCCL(57,60)*0.5000000000000000d+00
      JACC(72,63) = SAVE1710
      DWCCL(191,63) =
     : DWCCL(191,63)+JACCCCL(72,63)*0.5000000000000000d+00
      JACC(72,46) = SAVE1709
      DWCCL(191,46) =
     : DWCCL(191,46)+JACCCCL(72,46)*0.5000000000000000d+00
      JACC(71,63) = SAVE1708
      DWCCL(191,63) =
     : DWCCL(191,63)+JACCCCL(71,63)*0.5000000000000000d+00
      JACC(71,46) = SAVE1707
      DWCCL(191,46) =
     : DWCCL(191,46)+JACCCCL(71,46)*0.5000000000000000d+00
      JACC(70,63) = SAVE1706
      DWCCL(191,63) =
     : DWCCL(191,63)+JACCCCL(70,63)*0.5000000000000000d+00
      JACC(70,46) = SAVE1705
      DWCCL(191,46) =
     : DWCCL(191,46)+JACCCCL(70,46)*0.5000000000000000d+00
      JACC(66,63) = SAVE1704
      DWCCL(191,63) =
     : DWCCL(191,63)+JACCCCL(66,63)*0.9600000000000000d+00
      JACC(66,46) = SAVE1703
      DWCCL(191,46) =
     : DWCCL(191,46)+JACCCCL(66,46)*0.9600000000000000d+00
      JACC(63,63) = SAVE1702
      DWCCL(191,63) = DWCCL(191,63)-JACCCCL(63,63)
      JACC(63,46) = SAVE1701
      DWCCL(191,46) = DWCCL(191,46)-JACCCCL(63,46)
      JACC(61,63) = SAVE1700
      DWCCL(191,63) =
     : DWCCL(191,63)+JACCCCL(61,63)*0.6400000000000000d+00
      JACC(61,46) = SAVE1699
      DWCCL(191,46) =
     : DWCCL(191,46)+JACCCCL(61,46)*0.6400000000000000d+00
      JACC(59,63) = SAVE1698
      DWCCL(191,63) =
     : DWCCL(191,63)+JACCCCL(59,63)*0.1490000000000000d+00
      JACC(59,46) = SAVE1697
      DWCCL(191,46) =
     : DWCCL(191,46)+JACCCCL(59,46)*0.1490000000000000d+00
      JACC(46,63) = SAVE1696
      DWCCL(191,63) = DWCCL(191,63)-JACCCCL(46,63)
      JACC(46,46) = SAVE1695
      DWCCL(191,46) = DWCCL(191,46)-JACCCCL(46,46)
      JACC(71,63) = SAVE1694
      DWCCL(190,63) = DWCCL(190,63)+JACCCCL(71,63)
      JACC(71,47) = SAVE1693
      DWCCL(190,47) = DWCCL(190,47)+JACCCCL(71,47)
      JACC(70,63) = SAVE1692
      DWCCL(190,63) = DWCCL(190,63)+JACCCCL(70,63)
      JACC(70,47) = SAVE1691
      DWCCL(190,47) = DWCCL(190,47)+JACCCCL(70,47)
      JACC(66,63) = SAVE1690
      DWCCL(190,63) =
     : DWCCL(190,63)+JACCCCL(66,63)*0.7500000000000000d+00
      JACC(66,47) = SAVE1689
      DWCCL(190,47) =
     : DWCCL(190,47)+JACCCCL(66,47)*0.7500000000000000d+00
      JACC(63,63) = SAVE1688
      DWCCL(190,63) = DWCCL(190,63)-JACCCCL(63,63)
      JACC(63,47) = SAVE1687
      DWCCL(190,47) = DWCCL(190,47)-JACCCCL(63,47)
      JACC(47,63) = SAVE1686
      DWCCL(190,63) = DWCCL(190,63)-JACCCCL(47,63)
      JACC(47,47) = SAVE1685
      DWCCL(190,47) = DWCCL(190,47)-JACCCCL(47,47)
      JACC(71,63) = SAVE1684
      DWCCL(189,63) =
     : DWCCL(189,63)+JACCCCL(71,63)*0.8800000000000000d+00
      JACC(71,58) = SAVE1683
      DWCCL(189,58) =
     : DWCCL(189,58)+JACCCCL(71,58)*0.8800000000000000d+00
      JACC(69,63) = SAVE1682
      DWCCL(189,63) =
     : DWCCL(189,63)+JACCCCL(69,63)*0.1200000000000000d+00
      JACC(69,58) = SAVE1681
      DWCCL(189,58) =
     : DWCCL(189,58)+JACCCCL(69,58)*0.1200000000000000d+00
      JACC(66,63) = SAVE1680
      DWCCL(189,63) =
     : DWCCL(189,63)+JACCCCL(66,63)*0.7500000000000000d+00
      JACC(66,58) = SAVE1679
      DWCCL(189,58) =
     : DWCCL(189,58)+JACCCCL(66,58)*0.7500000000000000d+00
      JACC(65,63) = SAVE1678
      DWCCL(189,63) =
     : DWCCL(189,63)+JACCCCL(65,63)*0.8000000000000000d-01
      JACC(65,58) = SAVE1677
      DWCCL(189,58) =
     : DWCCL(189,58)+JACCCCL(65,58)*0.8000000000000000d-01
      JACC(63,63) = SAVE1676
      DWCCL(189,63) = DWCCL(189,63)-JACCCCL(63,63)
      JACC(63,58) = SAVE1675
      DWCCL(189,58) = DWCCL(189,58)-JACCCCL(63,58)
      JACC(61,63) = SAVE1674
      DWCCL(189,63) =
     : DWCCL(189,63)+JACCCCL(61,63)*0.3000000000000000d+00
      JACC(61,58) = SAVE1673
      DWCCL(189,58) =
     : DWCCL(189,58)+JACCCCL(61,58)*0.3000000000000000d+00
      JACC(58,63) = SAVE1672
      DWCCL(189,63) = DWCCL(189,63)-JACCCCL(58,63)
      JACC(58,58) = SAVE1671
      DWCCL(189,58) = DWCCL(189,58)-JACCCCL(58,58)
      JACC(54,63) = SAVE1670
      DWCCL(189,63) =
     : DWCCL(189,63)+JACCCCL(54,63)*0.4000000000000000d+00
      JACC(54,58) = SAVE1669
      DWCCL(189,58) =
     : DWCCL(189,58)+JACCCCL(54,58)*0.4000000000000000d+00
      JACC(24,63) = SAVE1668
      DWCCL(189,63) =
     : DWCCL(189,63)+JACCCCL(24,63)*0.3000000000000000d+00
      JACC(24,58) = SAVE1667
      DWCCL(189,58) =
     : DWCCL(189,58)+JACCCCL(24,58)*0.3000000000000000d+00
      JACC(66,63) = SAVE1666
      DWCCL(188,63) = DWCCL(188,63)+JACCCCL(66,63)
      JACC(66,56) = SAVE1665
      DWCCL(188,56) = DWCCL(188,56)+JACCCCL(66,56)
      JACC(63,63) = SAVE1664
      DWCCL(188,63) = DWCCL(188,63)-JACCCCL(63,63)
      JACC(63,56) = SAVE1663
      DWCCL(188,56) = DWCCL(188,56)-JACCCCL(63,56)
      JACC(57,63) = SAVE1662
      DWCCL(188,63) = DWCCL(188,63)+JACCCCL(57,63)
      JACC(57,56) = SAVE1661
      DWCCL(188,56) = DWCCL(188,56)+JACCCCL(57,56)
      JACC(56,63) = SAVE1660
      DWCCL(188,63) = DWCCL(188,63)-JACCCCL(56,63)
      JACC(56,56) = SAVE1659
      DWCCL(188,56) = DWCCL(188,56)-JACCCCL(56,56)
      JACC(71,63) = SAVE1658
      DWCCL(187,63) = DWCCL(187,63)+JACCCCL(71,63)
      JACC(71,56) = SAVE1657
      DWCCL(187,56) = DWCCL(187,56)+JACCCCL(71,56)
      JACC(69,63) = SAVE1656
      DWCCL(187,63) = DWCCL(187,63)+JACCCCL(69,63)
      JACC(69,56) = SAVE1655
      DWCCL(187,56) = DWCCL(187,56)+JACCCCL(69,56)
      JACC(66,63) = SAVE1654
      DWCCL(187,63) =
     : DWCCL(187,63)+JACCCCL(66,63)*0.2000000000000000d+01
      JACC(66,56) = SAVE1653
      DWCCL(187,56) =
     : DWCCL(187,56)+JACCCCL(66,56)*0.2000000000000000d+01
      JACC(63,63) = SAVE1652
      DWCCL(187,63) = DWCCL(187,63)-JACCCCL(63,63)
      JACC(63,56) = SAVE1651
      DWCCL(187,56) = DWCCL(187,56)-JACCCCL(63,56)
      JACC(56,63) = SAVE1650
      DWCCL(187,63) = DWCCL(187,63)-JACCCCL(56,63)
      JACC(56,56) = SAVE1649
      DWCCL(187,56) = DWCCL(187,56)-JACCCCL(56,56)
      JACC(69,63) = SAVE1648
      DWCCL(186,63) = DWCCL(186,63)-JACCCCL(69,63)
      JACC(69,69) = SAVE1647
      DWCCL(186,69) = DWCCL(186,69)-JACCCCL(69,69)
      JACC(66,63) = SAVE1646
      DWCCL(186,63) = DWCCL(186,63)+JACCCCL(66,63)
      JACC(66,69) = SAVE1645
      DWCCL(186,69) = DWCCL(186,69)+JACCCCL(66,69)
      JACC(63,63) = SAVE1644
      DWCCL(186,63) = DWCCL(186,63)-JACCCCL(63,63)
      JACC(63,69) = SAVE1643
      DWCCL(186,69) = DWCCL(186,69)-JACCCCL(63,69)
      JACC(57,63) = SAVE1642
      DWCCL(186,63) = DWCCL(186,63)+JACCCCL(57,63)
      JACC(57,69) = SAVE1641
      DWCCL(186,69) = DWCCL(186,69)+JACCCCL(57,69)
      JACC(71,63) = SAVE1640
      DWCCL(185,63) = DWCCL(185,63)+JACCCCL(71,63)
      JACC(71,69) = SAVE1639
      DWCCL(185,69) = DWCCL(185,69)+JACCCCL(71,69)
      JACC(69,63) = SAVE1638
      DWCCL(185,63) = DWCCL(185,63)-JACCCCL(69,63)
      JACC(69,69) = SAVE1637
      DWCCL(185,69) = DWCCL(185,69)-JACCCCL(69,69)
      JACC(66,63) = SAVE1636
      DWCCL(185,63) = DWCCL(185,63)+JACCCCL(66,63)
      JACC(66,69) = SAVE1635
      DWCCL(185,69) = DWCCL(185,69)+JACCCCL(66,69)
      JACC(71,63) = SAVE1634
      DWCCL(184,63) =
     : DWCCL(184,63)+JACCCCL(71,63)*0.2000000000000000d+01
      JACC(71,33) = SAVE1633
      DWCCL(184,33) =
     : DWCCL(184,33)+JACCCCL(71,33)*0.2000000000000000d+01
      JACC(66,63) = SAVE1632
      DWCCL(184,63) = DWCCL(184,63)+JACCCCL(66,63)
      JACC(66,33) = SAVE1631
      DWCCL(184,33) = DWCCL(184,33)+JACCCCL(66,33)
      JACC(63,63) = SAVE1630
      DWCCL(184,63) = DWCCL(184,63)-JACCCCL(63,63)
      JACC(63,33) = SAVE1629
      DWCCL(184,33) = DWCCL(184,33)-JACCCCL(63,33)
      JACC(54,63) = SAVE1628
      DWCCL(184,63) = DWCCL(184,63)+JACCCCL(54,63)
      JACC(54,33) = SAVE1627
      DWCCL(184,33) = DWCCL(184,33)+JACCCCL(54,33)
      JACC(51,63) = SAVE1626
      DWCCL(184,63) = DWCCL(184,63)+JACCCCL(51,63)
      JACC(51,33) = SAVE1625
      DWCCL(184,33) = DWCCL(184,33)+JACCCCL(51,33)
      JACC(33,63) = SAVE1624
      DWCCL(184,63) = DWCCL(184,63)-JACCCCL(33,63)
      JACC(33,33) = SAVE1623
      DWCCL(184,33) = DWCCL(184,33)-JACCCCL(33,33)
      JACC(71,63) = SAVE1622
      DWCCL(183,63) = DWCCL(183,63)+JACCCCL(71,63)
      JACC(71,32) = SAVE1621
      DWCCL(183,32) = DWCCL(183,32)+JACCCCL(71,32)
      JACC(66,63) = SAVE1620
      DWCCL(183,63) = DWCCL(183,63)+JACCCCL(66,63)
      JACC(66,32) = SAVE1619
      DWCCL(183,32) = DWCCL(183,32)+JACCCCL(66,32)
      JACC(63,63) = SAVE1618
      DWCCL(183,63) = DWCCL(183,63)-JACCCCL(63,63)
      JACC(63,32) = SAVE1617
      DWCCL(183,32) = DWCCL(183,32)-JACCCCL(63,32)
      JACC(54,63) = SAVE1616
      DWCCL(183,63) =
     : DWCCL(183,63)+JACCCCL(54,63)*0.6300000000000000d+00
      JACC(54,32) = SAVE1615
      DWCCL(183,32) =
     : DWCCL(183,32)+JACCCCL(54,32)*0.6300000000000000d+00
      JACC(51,63) = SAVE1614
      DWCCL(183,63) =
     : DWCCL(183,63)+JACCCCL(51,63)*0.3700000000000000d+00
      JACC(51,32) = SAVE1613
      DWCCL(183,32) =
     : DWCCL(183,32)+JACCCCL(51,32)*0.3700000000000000d+00
      JACC(48,63) = SAVE1612
      DWCCL(183,63) = DWCCL(183,63)+JACCCCL(48,63)
      JACC(48,32) = SAVE1611
      DWCCL(183,32) = DWCCL(183,32)+JACCCCL(48,32)
      JACC(32,63) = SAVE1610
      DWCCL(183,63) = DWCCL(183,63)-JACCCCL(32,63)
      JACC(32,32) = SAVE1609
      DWCCL(183,32) = DWCCL(183,32)-JACCCCL(32,32)
      JACC(71,63) = SAVE1608
      DWCCL(182,63) = DWCCL(182,63)+JACCCCL(71,63)
      JACC(71,31) = SAVE1607
      DWCCL(182,31) = DWCCL(182,31)+JACCCCL(71,31)
      JACC(66,63) = SAVE1606
      DWCCL(182,63) = DWCCL(182,63)+JACCCCL(66,63)
      JACC(66,31) = SAVE1605
      DWCCL(182,31) = DWCCL(182,31)+JACCCCL(66,31)
      JACC(63,63) = SAVE1604
      DWCCL(182,63) = DWCCL(182,63)-JACCCCL(63,63)
      JACC(63,31) = SAVE1603
      DWCCL(182,31) = DWCCL(182,31)-JACCCCL(63,31)
      JACC(54,63) = SAVE1602
      DWCCL(182,63) =
     : DWCCL(182,63)+JACCCCL(54,63)*0.3500000000000000d+00
      JACC(54,31) = SAVE1601
      DWCCL(182,31) =
     : DWCCL(182,31)+JACCCCL(54,31)*0.3500000000000000d+00
      JACC(51,63) = SAVE1600
      DWCCL(182,63) =
     : DWCCL(182,63)+JACCCCL(51,63)*0.6500000000000000d+00
      JACC(51,31) = SAVE1599
      DWCCL(182,31) =
     : DWCCL(182,31)+JACCCCL(51,31)*0.6500000000000000d+00
      JACC(48,63) = SAVE1598
      DWCCL(182,63) = DWCCL(182,63)+JACCCCL(48,63)
      JACC(48,31) = SAVE1597
      DWCCL(182,31) = DWCCL(182,31)+JACCCCL(48,31)
      JACC(31,63) = SAVE1596
      DWCCL(182,63) = DWCCL(182,63)-JACCCCL(31,63)
      JACC(31,31) = SAVE1595
      DWCCL(182,31) = DWCCL(182,31)-JACCCCL(31,31)
      JACC(71,63) = SAVE1594
      DWCCL(181,63) =
     : DWCCL(181,63)+JACCCCL(71,63)*0.2000000000000000d+01
      JACC(71,43) = SAVE1593
      DWCCL(181,43) =
     : DWCCL(181,43)+JACCCCL(71,43)*0.2000000000000000d+01
      JACC(66,63) = SAVE1592
      DWCCL(181,63) =
     : DWCCL(181,63)+JACCCCL(66,63)*0.1400000000000000d+01
      JACC(66,43) = SAVE1591
      DWCCL(181,43) =
     : DWCCL(181,43)+JACCCCL(66,43)*0.1400000000000000d+01
      JACC(63,63) = SAVE1590
      DWCCL(181,63) = DWCCL(181,63)-JACCCCL(63,63)
      JACC(63,43) = SAVE1589
      DWCCL(181,43) = DWCCL(181,43)-JACCCCL(63,43)
      JACC(49,63) = SAVE1588
      DWCCL(181,63) =
     : DWCCL(181,63)+JACCCCL(49,63)*0.6000000000000000d+00
      JACC(49,43) = SAVE1587
      DWCCL(181,43) =
     : DWCCL(181,43)+JACCCCL(49,43)*0.6000000000000000d+00
      JACC(44,63) = SAVE1586
      DWCCL(181,63) =
     : DWCCL(181,63)+JACCCCL(44,63)*0.4000000000000000d+00
      JACC(44,43) = SAVE1585
      DWCCL(181,43) =
     : DWCCL(181,43)+JACCCCL(44,43)*0.4000000000000000d+00
      JACC(43,63) = SAVE1584
      DWCCL(181,63) = DWCCL(181,63)-JACCCCL(43,63)
      JACC(43,43) = SAVE1583
      DWCCL(181,43) = DWCCL(181,43)-JACCCCL(43,43)
      JACC(71,63) = SAVE1582
      DWCCL(180,63) =
     : DWCCL(180,63)+JACCCCL(71,63)*0.2000000000000000d+01
      JACC(71,42) = SAVE1581
      DWCCL(180,42) =
     : DWCCL(180,42)+JACCCCL(71,42)*0.2000000000000000d+01
      JACC(66,63) = SAVE1580
      DWCCL(180,63) = DWCCL(180,63)+JACCCCL(66,63)
      JACC(66,42) = SAVE1579
      DWCCL(180,42) = DWCCL(180,42)+JACCCCL(66,42)
      JACC(63,63) = SAVE1578
      DWCCL(180,63) = DWCCL(180,63)-JACCCCL(63,63)
      JACC(63,42) = SAVE1577
      DWCCL(180,42) = DWCCL(180,42)-JACCCCL(63,42)
      JACC(61,63) = SAVE1576
      DWCCL(180,63) = DWCCL(180,63)+JACCCCL(61,63)
      JACC(61,42) = SAVE1575
      DWCCL(180,42) = DWCCL(180,42)+JACCCCL(61,42)
      JACC(59,63) = SAVE1574
      DWCCL(180,63) = DWCCL(180,63)+JACCCCL(59,63)
      JACC(59,42) = SAVE1573
      DWCCL(180,42) = DWCCL(180,42)+JACCCCL(59,42)
      JACC(42,63) = SAVE1572
      DWCCL(180,63) = DWCCL(180,63)-JACCCCL(42,63)
      JACC(42,42) = SAVE1571
      DWCCL(180,42) = DWCCL(180,42)-JACCCCL(42,42)
      JACC(71,63) = SAVE1570
      DWCCL(179,63) = DWCCL(179,63)+JACCCCL(71,63)
      JACC(71,39) = SAVE1569
      DWCCL(179,39) = DWCCL(179,39)+JACCCCL(71,39)
      JACC(66,63) = SAVE1568
      DWCCL(179,63) =
     : DWCCL(179,63)+JACCCCL(66,63)*0.1090000000000000d+01
      JACC(66,39) = SAVE1567
      DWCCL(179,39) =
     : DWCCL(179,39)+JACCCCL(66,39)*0.1090000000000000d+01
      JACC(63,63) = SAVE1566
      DWCCL(179,63) = DWCCL(179,63)-JACCCCL(63,63)
      JACC(63,39) = SAVE1565
      DWCCL(179,39) = DWCCL(179,39)-JACCCCL(63,39)
      JACC(49,63) = SAVE1564
      DWCCL(179,63) =
     : DWCCL(179,63)+JACCCCL(49,63)*0.5500000000000000d+00
      JACC(49,39) = SAVE1563
      DWCCL(179,39) =
     : DWCCL(179,39)+JACCCCL(49,39)*0.5500000000000000d+00
      JACC(44,63) = SAVE1562
      DWCCL(179,63) =
     : DWCCL(179,63)+JACCCCL(44,63)*0.8000000000000000d-01
      JACC(44,39) = SAVE1561
      DWCCL(179,39) =
     : DWCCL(179,39)+JACCCCL(44,39)*0.8000000000000000d-01
      JACC(40,63) = SAVE1560
      DWCCL(179,63) =
     : DWCCL(179,63)+JACCCCL(40,63)*0.3700000000000000d+00
      JACC(40,39) = SAVE1559
      DWCCL(179,39) =
     : DWCCL(179,39)+JACCCCL(40,39)*0.3700000000000000d+00
      JACC(39,63) = SAVE1558
      DWCCL(179,63) = DWCCL(179,63)-JACCCCL(39,63)
      JACC(39,39) = SAVE1557
      DWCCL(179,39) = DWCCL(179,39)-JACCCCL(39,39)
      JACC(71,63) = SAVE1556
      DWCCL(178,63) = DWCCL(178,63)+JACCCCL(71,63)
      JACC(71,45) = SAVE1555
      DWCCL(178,45) = DWCCL(178,45)+JACCCCL(71,45)
      JACC(66,63) = SAVE1554
      DWCCL(178,63) =
     : DWCCL(178,63)+JACCCCL(66,63)*0.7550000000000000d+00
      JACC(66,45) = SAVE1553
      DWCCL(178,45) =
     : DWCCL(178,45)+JACCCCL(66,45)*0.7550000000000000d+00
      JACC(63,63) = SAVE1552
      DWCCL(178,63) = DWCCL(178,63)-JACCCCL(63,63)
      JACC(63,45) = SAVE1551
      DWCCL(178,45) = DWCCL(178,45)-JACCCCL(63,45)
      JACC(61,63) = SAVE1550
      DWCCL(178,63) =
     : DWCCL(178,63)+JACCCCL(61,63)*0.9320000000000001d+00
      JACC(61,45) = SAVE1549
      DWCCL(178,45) =
     : DWCCL(178,45)+JACCCCL(61,45)*0.9320000000000001d+00
      JACC(59,63) = SAVE1548
      DWCCL(178,63) =
     : DWCCL(178,63)+JACCCCL(59,63)*0.3130000000000000d+00
      JACC(59,45) = SAVE1547
      DWCCL(178,45) =
     : DWCCL(178,45)+JACCCCL(59,45)*0.3130000000000000d+00
      JACC(45,63) = SAVE1546
      DWCCL(178,63) = DWCCL(178,63)-JACCCCL(45,63)
      JACC(45,45) = SAVE1545
      DWCCL(178,45) = DWCCL(178,45)-JACCCCL(45,45)
      JACC(71,63) = SAVE1544
      DWCCL(177,63) = DWCCL(177,63)+JACCCCL(71,63)
      JACC(71,41) = SAVE1543
      DWCCL(177,41) = DWCCL(177,41)+JACCCCL(71,41)
      JACC(66,63) = SAVE1542
      DWCCL(177,63) =
     : DWCCL(177,63)+JACCCCL(66,63)*0.1250000000000000d+01
      JACC(66,41) = SAVE1541
      DWCCL(177,41) =
     : DWCCL(177,41)+JACCCCL(66,41)*0.1250000000000000d+01
      JACC(63,63) = SAVE1540
      DWCCL(177,63) = DWCCL(177,63)-JACCCCL(63,63)
      JACC(63,41) = SAVE1539
      DWCCL(177,41) = DWCCL(177,41)-JACCCCL(63,41)
      JACC(61,63) = SAVE1538
      DWCCL(177,63) =
     : DWCCL(177,63)+JACCCCL(61,63)*0.6690000000000000d+00
      JACC(61,41) = SAVE1537
      DWCCL(177,41) =
     : DWCCL(177,41)+JACCCCL(61,41)*0.6690000000000000d+00
      JACC(59,63) = SAVE1536
      DWCCL(177,63) =
     : DWCCL(177,63)+JACCCCL(59,63)*0.8100000000000000d-01
      JACC(59,41) = SAVE1535
      DWCCL(177,41) =
     : DWCCL(177,41)+JACCCCL(59,41)*0.8100000000000000d-01
      JACC(41,63) = SAVE1534
      DWCCL(177,63) = DWCCL(177,63)-JACCCCL(41,63)
      JACC(41,41) = SAVE1533
      DWCCL(177,41) = DWCCL(177,41)-JACCCCL(41,41)
      JACC(71,63) = SAVE1532
      DWCCL(176,63) = DWCCL(176,63)+JACCCCL(71,63)
      JACC(71,38) = SAVE1531
      DWCCL(176,38) = DWCCL(176,38)+JACCCCL(71,38)
      JACC(66,63) = SAVE1530
      DWCCL(176,63) =
     : DWCCL(176,63)+JACCCCL(66,63)*0.1550000000000000d+01
      JACC(66,38) = SAVE1529
      DWCCL(176,38) =
     : DWCCL(176,38)+JACCCCL(66,38)*0.1550000000000000d+01
      JACC(63,63) = SAVE1528
      DWCCL(176,63) = DWCCL(176,63)-JACCCCL(63,63)
      JACC(63,38) = SAVE1527
      DWCCL(176,38) = DWCCL(176,38)-JACCCCL(63,38)
      JACC(61,63) = SAVE1526
      DWCCL(176,63) =
     : DWCCL(176,63)+JACCCCL(61,63)*0.3500000000000000d+00
      JACC(61,38) = SAVE1525
      DWCCL(176,38) =
     : DWCCL(176,38)+JACCCCL(61,38)*0.3500000000000000d+00
      JACC(38,63) = SAVE1524
      DWCCL(176,63) = DWCCL(176,63)-JACCCCL(38,63)
      JACC(38,38) = SAVE1523
      DWCCL(176,38) = DWCCL(176,38)-JACCCCL(38,38)
      JACC(71,63) = SAVE1522
      DWCCL(175,63) =
     : DWCCL(175,63)+JACCCCL(71,63)*0.9930000000000000d+00
      JACC(71,37) = SAVE1521
      DWCCL(175,37) =
     : DWCCL(175,37)+JACCCCL(71,37)*0.9930000000000000d+00
      JACC(66,63) = SAVE1520
      DWCCL(175,63) =
     : DWCCL(175,63)+JACCCCL(66,63)*0.7530000000000000d+00
      JACC(66,37) = SAVE1519
      DWCCL(175,37) =
     : DWCCL(175,37)+JACCCCL(66,37)*0.7530000000000000d+00
      JACC(65,63) = SAVE1518
      DWCCL(175,63) =
     : DWCCL(175,63)+JACCCCL(65,63)*0.3220000000000000d+00
      JACC(65,37) = SAVE1517
      DWCCL(175,37) =
     : DWCCL(175,37)+JACCCCL(65,37)*0.3220000000000000d+00
      JACC(63,63) = SAVE1516
      DWCCL(175,63) = DWCCL(175,63)-JACCCCL(63,63)
      JACC(63,37) = SAVE1515
      DWCCL(175,37) = DWCCL(175,37)-JACCCCL(63,37)
      JACC(61,63) = SAVE1514
      DWCCL(175,63) =
     : DWCCL(175,63)+JACCCCL(61,63)*0.4110000000000000d+00
      JACC(61,37) = SAVE1513
      DWCCL(175,37) =
     : DWCCL(175,37)+JACCCCL(61,37)*0.4110000000000000d+00
      JACC(60,63) = SAVE1512
      DWCCL(175,63) =
     : DWCCL(175,63)+JACCCCL(60,63)*0.1300000000000000d-01
      JACC(60,37) = SAVE1511
      DWCCL(175,37) =
     : DWCCL(175,37)+JACCCCL(60,37)*0.1300000000000000d-01
      JACC(59,63) = SAVE1510
      DWCCL(175,63) =
     : DWCCL(175,63)+JACCCCL(59,63)*0.4190000000000000d+00
      JACC(59,37) = SAVE1509
      DWCCL(175,37) =
     : DWCCL(175,37)+JACCCCL(59,37)*0.4190000000000000d+00
      JACC(37,63) = SAVE1508
      DWCCL(175,63) = DWCCL(175,63)-JACCCCL(37,63)
      JACC(37,37) = SAVE1507
      DWCCL(175,37) = DWCCL(175,37)-JACCCCL(37,37)
      JACC(71,63) = SAVE1506
      DWCCL(174,63) =
     : DWCCL(174,63)+JACCCCL(71,63)*0.9460000000000000d+00
      JACC(71,36) = SAVE1505
      DWCCL(174,36) =
     : DWCCL(174,36)+JACCCCL(71,36)*0.9460000000000000d+00
      JACC(66,63) = SAVE1504
      DWCCL(174,63) =
     : DWCCL(174,63)+JACCCCL(66,63)*0.8290000000000000d+00
      JACC(66,36) = SAVE1503
      DWCCL(174,36) =
     : DWCCL(174,36)+JACCCCL(66,36)*0.8290000000000000d+00
      JACC(65,63) = SAVE1502
      DWCCL(174,63) =
     : DWCCL(174,63)+JACCCCL(65,63)*0.2450000000000000d+00
      JACC(65,36) = SAVE1501
      DWCCL(174,36) =
     : DWCCL(174,36)+JACCCCL(65,36)*0.2450000000000000d+00
      JACC(63,63) = SAVE1500
      DWCCL(174,63) =
     : DWCCL(174,63)-JACCCCL(63,63)*0.9510000000000000d+00
      JACC(63,36) = SAVE1499
      DWCCL(174,36) =
     : DWCCL(174,36)-JACCCCL(63,36)*0.9510000000000000d+00
      JACC(61,63) = SAVE1498
      DWCCL(174,63) =
     : DWCCL(174,63)+JACCCCL(61,63)*0.5230000000000000d+00
      JACC(61,36) = SAVE1497
      DWCCL(174,36) =
     : DWCCL(174,36)+JACCCCL(61,36)*0.5230000000000000d+00
      JACC(60,63) = SAVE1496
      DWCCL(174,63) =
     : DWCCL(174,63)+JACCCCL(60,63)*0.1400000000000000d-01
      JACC(60,36) = SAVE1495
      DWCCL(174,36) =
     : DWCCL(174,36)+JACCCCL(60,36)*0.1400000000000000d-01
      JACC(59,63) = SAVE1494
      DWCCL(174,63) =
     : DWCCL(174,63)+JACCCCL(59,63)*0.2400000000000000d+00
      JACC(59,36) = SAVE1493
      DWCCL(174,36) =
     : DWCCL(174,36)+JACCCCL(59,36)*0.2400000000000000d+00
      JACC(36,63) = SAVE1492
      DWCCL(174,63) = DWCCL(174,63)-JACCCCL(36,63)
      JACC(36,36) = SAVE1491
      DWCCL(174,36) = DWCCL(174,36)-JACCCCL(36,36)
      JACC(71,63) = SAVE1490
      DWCCL(173,63) =
     : DWCCL(173,63)+JACCCCL(71,63)*0.9920000000000000d+00
      JACC(71,64) = SAVE1489
      DWCCL(173,64) =
     : DWCCL(173,64)+JACCCCL(71,64)*0.9920000000000000d+00
      JACC(66,63) = SAVE1488
      DWCCL(173,63) =
     : DWCCL(173,63)+JACCCCL(66,63)*0.8100000000000001d+00
      JACC(66,64) = SAVE1487
      DWCCL(173,64) =
     : DWCCL(173,64)+JACCCCL(66,64)*0.8100000000000001d+00
      JACC(65,63) = SAVE1486
      DWCCL(173,63) =
     : DWCCL(173,63)+JACCCCL(65,63)*0.8500000000000001d-01
      JACC(65,64) = SAVE1485
      DWCCL(173,64) =
     : DWCCL(173,64)+JACCCCL(65,64)*0.8500000000000001d-01
      JACC(64,63) = SAVE1484
      DWCCL(173,63) = DWCCL(173,63)-JACCCCL(64,63)
      JACC(64,64) = SAVE1483
      DWCCL(173,64) = DWCCL(173,64)-JACCCCL(64,64)
      JACC(63,63) = SAVE1482
      DWCCL(173,63) =
     : DWCCL(173,63)-JACCCCL(63,63)*0.9930000000000000d+00
      JACC(63,64) = SAVE1481
      DWCCL(173,64) =
     : DWCCL(173,64)-JACCCCL(63,64)*0.9930000000000000d+00
      JACC(61,63) = SAVE1480
      DWCCL(173,63) =
     : DWCCL(173,63)+JACCCCL(61,63)*0.5800000000000000d+00
      JACC(61,64) = SAVE1479
      DWCCL(173,64) =
     : DWCCL(173,64)+JACCCCL(61,64)*0.5800000000000000d+00
      JACC(59,63) = SAVE1478
      DWCCL(173,63) =
     : DWCCL(173,63)+JACCCCL(59,63)*0.1800000000000000d-01
      JACC(59,64) = SAVE1477
      DWCCL(173,64) =
     : DWCCL(173,64)+JACCCCL(59,64)*0.1800000000000000d-01
      JACC(54,63) = SAVE1476
      DWCCL(173,63) =
     : DWCCL(173,63)+JACCCCL(54,63)*0.5000000000000000d-02
      JACC(54,64) = SAVE1475
      DWCCL(173,64) =
     : DWCCL(173,64)+JACCCCL(54,64)*0.5000000000000000d-02
      JACC(51,63) = SAVE1474
      DWCCL(173,63) =
     : DWCCL(173,63)+JACCCCL(51,63)*0.1190000000000000d+00
      JACC(51,64) = SAVE1473
      DWCCL(173,64) =
     : DWCCL(173,64)+JACCCCL(51,64)*0.1190000000000000d+00
      JACC(71,63) = SAVE1472
      DWCCL(172,63) = DWCCL(172,63)+JACCCCL(71,63)
      JACC(71,60) = SAVE1471
      DWCCL(172,60) = DWCCL(172,60)+JACCCCL(71,60)
      JACC(66,63) = SAVE1470
      DWCCL(172,63) =
     : DWCCL(172,63)+JACCCCL(66,63)*0.7500000000000000d+00
      JACC(66,60) = SAVE1469
      DWCCL(172,60) =
     : DWCCL(172,60)+JACCCCL(66,60)*0.7500000000000000d+00
      JACC(63,63) = SAVE1468
      DWCCL(172,63) = DWCCL(172,63)-JACCCCL(63,63)
      JACC(63,60) = SAVE1467
      DWCCL(172,60) = DWCCL(172,60)-JACCCCL(63,60)
      JACC(61,63) = SAVE1466
      DWCCL(172,63) =
     : DWCCL(172,63)+JACCCCL(61,63)*0.7500000000000000d+00
      JACC(61,60) = SAVE1465
      DWCCL(172,60) =
     : DWCCL(172,60)+JACCCCL(61,60)*0.7500000000000000d+00
      JACC(60,63) = SAVE1464
      DWCCL(172,63) = DWCCL(172,63)-JACCCCL(60,63)
      JACC(60,60) = SAVE1463
      DWCCL(172,60) = DWCCL(172,60)-JACCCCL(60,60)
      JACC(71,63) = SAVE1462
      DWCCL(171,63) =
     : DWCCL(171,63)+JACCCCL(71,63)*0.6600000000000000d+00
      JACC(71,63) = SAVE1461
      DWCCL(171,63) =
     : DWCCL(171,63)+JACCCCL(71,63)*0.6600000000000000d+00
      JACC(66,63) = SAVE1460
      DWCCL(171,63) =
     : DWCCL(171,63)+JACCCCL(66,63)*0.1330000000000000d+01
      JACC(66,63) = SAVE1459
      DWCCL(171,63) =
     : DWCCL(171,63)+JACCCCL(66,63)*0.1330000000000000d+01
      JACC(63,63) = SAVE1458
      DWCCL(171,63) =
     : DWCCL(171,63)-JACCCCL(63,63)*0.2000000000000000d+01
      JACC(63,63) = SAVE1457
      DWCCL(171,63) =
     : DWCCL(171,63)-JACCCCL(63,63)*0.2000000000000000d+01
      JACC(71,71) = SAVE1456
      DWCCL(170,71) = DWCCL(170,71)-JACCCCL(71,71)
      JACC(71,46) = SAVE1455
      DWCCL(170,46) = DWCCL(170,46)-JACCCCL(71,46)
      JACC(70,71) = SAVE1454
      DWCCL(170,71) = DWCCL(170,71)+JACCCCL(70,71)
      JACC(70,46) = SAVE1453
      DWCCL(170,46) = DWCCL(170,46)+JACCCCL(70,46)
      JACC(46,71) = SAVE1452
      DWCCL(170,71) = DWCCL(170,71)-JACCCCL(46,71)
      JACC(46,46) = SAVE1451
      DWCCL(170,46) = DWCCL(170,46)-JACCCCL(46,46)
      JACC(71,71) = SAVE1450
      DWCCL(169,71) = DWCCL(169,71)-JACCCCL(71,71)
      JACC(71,47) = SAVE1449
      DWCCL(169,47) = DWCCL(169,47)-JACCCCL(71,47)
      JACC(70,71) = SAVE1448
      DWCCL(169,71) = DWCCL(169,71)+JACCCCL(70,71)
      JACC(70,47) = SAVE1447
      DWCCL(169,47) = DWCCL(169,47)+JACCCCL(70,47)
      JACC(47,71) = SAVE1446
      DWCCL(169,71) = DWCCL(169,71)-JACCCCL(47,71)
      JACC(47,47) = SAVE1445
      DWCCL(169,47) = DWCCL(169,47)-JACCCCL(47,47)
      JACC(71,71) = SAVE1444
      DWCCL(168,71) = DWCCL(168,71)-JACCCCL(71,71)
      JACC(71,58) = SAVE1443
      DWCCL(168,58) = DWCCL(168,58)-JACCCCL(71,58)
      JACC(58,71) = SAVE1442
      DWCCL(168,71) = DWCCL(168,71)-JACCCCL(58,71)
      JACC(58,58) = SAVE1441
      DWCCL(168,58) = DWCCL(168,58)-JACCCCL(58,58)
      JACC(53,71) = SAVE1440
      DWCCL(168,71) = DWCCL(168,71)+JACCCCL(53,71)
      JACC(53,58) = SAVE1439
      DWCCL(168,58) = DWCCL(168,58)+JACCCCL(53,58)
      JACC(71,71) = SAVE1438
      DWCCL(167,71) = DWCCL(167,71)-JACCCCL(71,71)
      JACC(71,56) = SAVE1437
      DWCCL(167,56) = DWCCL(167,56)-JACCCCL(71,56)
      JACC(57,71) = SAVE1436
      DWCCL(167,71) = DWCCL(167,71)+JACCCCL(57,71)
      JACC(57,56) = SAVE1435
      DWCCL(167,56) = DWCCL(167,56)+JACCCCL(57,56)
      JACC(56,71) = SAVE1434
      DWCCL(167,71) = DWCCL(167,71)-JACCCCL(56,71)
      JACC(56,56) = SAVE1433
      DWCCL(167,56) = DWCCL(167,56)-JACCCCL(56,56)
      JACC(50,71) = SAVE1432
      DWCCL(167,71) = DWCCL(167,71)+JACCCCL(50,71)
      JACC(50,56) = SAVE1431
      DWCCL(167,56) = DWCCL(167,56)+JACCCCL(50,56)
      JACC(71,71) = SAVE1430
      DWCCL(166,71) = DWCCL(166,71)-JACCCCL(71,71)
      JACC(71,56) = SAVE1429
      DWCCL(166,56) = DWCCL(166,56)-JACCCCL(71,56)
      JACC(56,71) = SAVE1428
      DWCCL(166,71) = DWCCL(166,71)-JACCCCL(56,71)
      JACC(56,56) = SAVE1427
      DWCCL(166,56) = DWCCL(166,56)-JACCCCL(56,56)
      JACC(53,71) = SAVE1426
      DWCCL(166,71) = DWCCL(166,71)+JACCCCL(53,71)
      JACC(53,56) = SAVE1425
      DWCCL(166,56) = DWCCL(166,56)+JACCCCL(53,56)
      JACC(71,71) = SAVE1424
      DWCCL(165,71) = DWCCL(165,71)-JACCCCL(71,71)
      JACC(71,69) = SAVE1423
      DWCCL(165,69) = DWCCL(165,69)-JACCCCL(71,69)
      JACC(69,71) = SAVE1422
      DWCCL(165,71) = DWCCL(165,71)-JACCCCL(69,71)
      JACC(69,69) = SAVE1421
      DWCCL(165,69) = DWCCL(165,69)-JACCCCL(69,69)
      JACC(57,71) = SAVE1420
      DWCCL(165,71) = DWCCL(165,71)+JACCCCL(57,71)
      JACC(57,69) = SAVE1419
      DWCCL(165,69) = DWCCL(165,69)+JACCCCL(57,69)
      JACC(50,71) = SAVE1418
      DWCCL(165,71) = DWCCL(165,71)+JACCCCL(50,71)
      JACC(50,69) = SAVE1417
      DWCCL(165,69) = DWCCL(165,69)+JACCCCL(50,69)
      JACC(71,71) = SAVE1416
      DWCCL(164,71) = DWCCL(164,71)-JACCCCL(71,71)
      JACC(71,69) = SAVE1415
      DWCCL(164,69) = DWCCL(164,69)-JACCCCL(71,69)
      JACC(69,71) = SAVE1414
      DWCCL(164,71) = DWCCL(164,71)-JACCCCL(69,71)
      JACC(69,69) = SAVE1413
      DWCCL(164,69) = DWCCL(164,69)-JACCCCL(69,69)
      JACC(28,71) = SAVE1412
      DWCCL(164,71) = DWCCL(164,71)+JACCCCL(28,71)
      JACC(28,69) = SAVE1411
      DWCCL(164,69) = DWCCL(164,69)+JACCCCL(28,69)
      JACC(71,71) = SAVE1410
      DWCCL(163,71) = DWCCL(163,71)-JACCCCL(71,71)
      JACC(71,33) = SAVE1409
      DWCCL(163,33) = DWCCL(163,33)-JACCCCL(71,33)
      JACC(53,71) = SAVE1408
      DWCCL(163,71) = DWCCL(163,71)+JACCCCL(53,71)
      JACC(53,33) = SAVE1407
      DWCCL(163,33) = DWCCL(163,33)+JACCCCL(53,33)
      JACC(33,71) = SAVE1406
      DWCCL(163,71) = DWCCL(163,71)-JACCCCL(33,71)
      JACC(33,33) = SAVE1405
      DWCCL(163,33) = DWCCL(163,33)-JACCCCL(33,33)
      JACC(71,71) = SAVE1404
      DWCCL(162,71) = DWCCL(162,71)-JACCCCL(71,71)
      JACC(71,32) = SAVE1403
      DWCCL(162,32) = DWCCL(162,32)-JACCCCL(71,32)
      JACC(53,71) = SAVE1402
      DWCCL(162,71) = DWCCL(162,71)+JACCCCL(53,71)
      JACC(53,32) = SAVE1401
      DWCCL(162,32) = DWCCL(162,32)+JACCCCL(53,32)
      JACC(32,71) = SAVE1400
      DWCCL(162,71) = DWCCL(162,71)-JACCCCL(32,71)
      JACC(32,32) = SAVE1399
      DWCCL(162,32) = DWCCL(162,32)-JACCCCL(32,32)
      JACC(71,71) = SAVE1398
      DWCCL(161,71) = DWCCL(161,71)-JACCCCL(71,71)
      JACC(71,31) = SAVE1397
      DWCCL(161,31) = DWCCL(161,31)-JACCCCL(71,31)
      JACC(53,71) = SAVE1396
      DWCCL(161,71) = DWCCL(161,71)+JACCCCL(53,71)
      JACC(53,31) = SAVE1395
      DWCCL(161,31) = DWCCL(161,31)+JACCCCL(53,31)
      JACC(31,71) = SAVE1394
      DWCCL(161,71) = DWCCL(161,71)-JACCCCL(31,71)
      JACC(31,31) = SAVE1393
      DWCCL(161,31) = DWCCL(161,31)-JACCCCL(31,31)
      JACC(71,71) = SAVE1392
      DWCCL(160,71) = DWCCL(160,71)-JACCCCL(71,71)
      JACC(71,43) = SAVE1391
      DWCCL(160,43) = DWCCL(160,43)-JACCCCL(71,43)
      JACC(53,71) = SAVE1390
      DWCCL(160,71) = DWCCL(160,71)+JACCCCL(53,71)
      JACC(53,43) = SAVE1389
      DWCCL(160,43) = DWCCL(160,43)+JACCCCL(53,43)
      JACC(43,71) = SAVE1388
      DWCCL(160,71) = DWCCL(160,71)-JACCCCL(43,71)
      JACC(43,43) = SAVE1387
      DWCCL(160,43) = DWCCL(160,43)-JACCCCL(43,43)
      JACC(71,71) = SAVE1386
      DWCCL(159,71) = DWCCL(159,71)-JACCCCL(71,71)
      JACC(71,42) = SAVE1385
      DWCCL(159,42) = DWCCL(159,42)-JACCCCL(71,42)
      JACC(53,71) = SAVE1384
      DWCCL(159,71) = DWCCL(159,71)+JACCCCL(53,71)
      JACC(53,42) = SAVE1383
      DWCCL(159,42) = DWCCL(159,42)+JACCCCL(53,42)
      JACC(42,71) = SAVE1382
      DWCCL(159,71) = DWCCL(159,71)-JACCCCL(42,71)
      JACC(42,42) = SAVE1381
      DWCCL(159,42) = DWCCL(159,42)-JACCCCL(42,42)
      JACC(71,71) = SAVE1380
      DWCCL(158,71) = DWCCL(158,71)-JACCCCL(71,71)
      JACC(71,39) = SAVE1379
      DWCCL(158,39) = DWCCL(158,39)-JACCCCL(71,39)
      JACC(53,71) = SAVE1378
      DWCCL(158,71) = DWCCL(158,71)+JACCCCL(53,71)
      JACC(53,39) = SAVE1377
      DWCCL(158,39) = DWCCL(158,39)+JACCCCL(53,39)
      JACC(39,71) = SAVE1376
      DWCCL(158,71) = DWCCL(158,71)-JACCCCL(39,71)
      JACC(39,39) = SAVE1375
      DWCCL(158,39) = DWCCL(158,39)-JACCCCL(39,39)
      JACC(71,71) = SAVE1374
      DWCCL(157,71) = DWCCL(157,71)-JACCCCL(71,71)
      JACC(71,45) = SAVE1373
      DWCCL(157,45) = DWCCL(157,45)-JACCCCL(71,45)
      JACC(53,71) = SAVE1372
      DWCCL(157,71) = DWCCL(157,71)+JACCCCL(53,71)
      JACC(53,45) = SAVE1371
      DWCCL(157,45) = DWCCL(157,45)+JACCCCL(53,45)
      JACC(45,71) = SAVE1370
      DWCCL(157,71) = DWCCL(157,71)-JACCCCL(45,71)
      JACC(45,45) = SAVE1369
      DWCCL(157,45) = DWCCL(157,45)-JACCCCL(45,45)
      JACC(71,71) = SAVE1368
      DWCCL(156,71) = DWCCL(156,71)-JACCCCL(71,71)
      JACC(71,41) = SAVE1367
      DWCCL(156,41) = DWCCL(156,41)-JACCCCL(71,41)
      JACC(53,71) = SAVE1366
      DWCCL(156,71) = DWCCL(156,71)+JACCCCL(53,71)
      JACC(53,41) = SAVE1365
      DWCCL(156,41) = DWCCL(156,41)+JACCCCL(53,41)
      JACC(41,71) = SAVE1364
      DWCCL(156,71) = DWCCL(156,71)-JACCCCL(41,71)
      JACC(41,41) = SAVE1363
      DWCCL(156,41) = DWCCL(156,41)-JACCCCL(41,41)
      JACC(71,71) = SAVE1362
      DWCCL(155,71) = DWCCL(155,71)-JACCCCL(71,71)
      JACC(71,38) = SAVE1361
      DWCCL(155,38) = DWCCL(155,38)-JACCCCL(71,38)
      JACC(53,71) = SAVE1360
      DWCCL(155,71) = DWCCL(155,71)+JACCCCL(53,71)
      JACC(53,38) = SAVE1359
      DWCCL(155,38) = DWCCL(155,38)+JACCCCL(53,38)
      JACC(38,71) = SAVE1358
      DWCCL(155,71) = DWCCL(155,71)-JACCCCL(38,71)
      JACC(38,38) = SAVE1357
      DWCCL(155,38) = DWCCL(155,38)-JACCCCL(38,38)
      JACC(71,71) = SAVE1356
      DWCCL(154,71) = DWCCL(154,71)-JACCCCL(71,71)
      JACC(71,37) = SAVE1355
      DWCCL(154,37) = DWCCL(154,37)-JACCCCL(71,37)
      JACC(53,71) = SAVE1354
      DWCCL(154,71) = DWCCL(154,71)+JACCCCL(53,71)
      JACC(53,37) = SAVE1353
      DWCCL(154,37) = DWCCL(154,37)+JACCCCL(53,37)
      JACC(37,71) = SAVE1352
      DWCCL(154,71) = DWCCL(154,71)-JACCCCL(37,71)
      JACC(37,37) = SAVE1351
      DWCCL(154,37) = DWCCL(154,37)-JACCCCL(37,37)
      JACC(71,71) = SAVE1350
      DWCCL(153,71) = DWCCL(153,71)-JACCCCL(71,71)
      JACC(71,36) = SAVE1349
      DWCCL(153,36) = DWCCL(153,36)-JACCCCL(71,36)
      JACC(53,71) = SAVE1348
      DWCCL(153,71) = DWCCL(153,71)+JACCCCL(53,71)
      JACC(53,36) = SAVE1347
      DWCCL(153,36) = DWCCL(153,36)+JACCCCL(53,36)
      JACC(36,71) = SAVE1346
      DWCCL(153,71) = DWCCL(153,71)-JACCCCL(36,71)
      JACC(36,36) = SAVE1345
      DWCCL(153,36) = DWCCL(153,36)-JACCCCL(36,36)
      JACC(71,71) = SAVE1344
      DWCCL(152,71) = DWCCL(152,71)-JACCCCL(71,71)
      JACC(71,64) = SAVE1343
      DWCCL(152,64) = DWCCL(152,64)-JACCCCL(71,64)
      JACC(64,71) = SAVE1342
      DWCCL(152,71) = DWCCL(152,71)-JACCCCL(64,71)
      JACC(64,64) = SAVE1341
      DWCCL(152,64) = DWCCL(152,64)-JACCCCL(64,64)
      JACC(53,71) = SAVE1340
      DWCCL(152,71) = DWCCL(152,71)+JACCCCL(53,71)
      JACC(53,64) = SAVE1339
      DWCCL(152,64) = DWCCL(152,64)+JACCCCL(53,64)
      JACC(71,71) = SAVE1338
      DWCCL(151,71) = DWCCL(151,71)-JACCCCL(71,71)
      JACC(71,60) = SAVE1337
      DWCCL(151,60) = DWCCL(151,60)-JACCCCL(71,60)
      JACC(60,71) = SAVE1336
      DWCCL(151,71) = DWCCL(151,71)-JACCCCL(60,71)
      JACC(60,60) = SAVE1335
      DWCCL(151,60) = DWCCL(151,60)-JACCCCL(60,60)
      JACC(53,71) = SAVE1334
      DWCCL(151,71) = DWCCL(151,71)+JACCCCL(53,71)
      JACC(53,60) = SAVE1333
      DWCCL(151,60) = DWCCL(151,60)+JACCCCL(53,60)
      JACC(71,71) = SAVE1332
      DWCCL(150,71) = DWCCL(150,71)-JACCCCL(71,71)
      JACC(71,63) = SAVE1331
      DWCCL(150,63) = DWCCL(150,63)-JACCCCL(71,63)
      JACC(63,71) = SAVE1330
      DWCCL(150,71) = DWCCL(150,71)-JACCCCL(63,71)
      JACC(63,63) = SAVE1329
      DWCCL(150,63) = DWCCL(150,63)-JACCCCL(63,63)
      JACC(16,71) = SAVE1328
      DWCCL(150,71) = DWCCL(150,71)+JACCCCL(16,71)
      JACC(16,63) = SAVE1327
      DWCCL(150,63) = DWCCL(150,63)+JACCCCL(16,63)
      JACC(72,67) = SAVE1326
      DWCCL(149,67) =
     : DWCCL(149,67)+JACCCCL(72,67)*0.2000000000000000d+01
      JACC(72,46) = SAVE1325
      DWCCL(149,46) =
     : DWCCL(149,46)+JACCCCL(72,46)*0.2000000000000000d+01
      JACC(67,67) = SAVE1324
      DWCCL(149,67) = DWCCL(149,67)-JACCCCL(67,67)
      JACC(67,46) = SAVE1323
      DWCCL(149,46) = DWCCL(149,46)-JACCCCL(67,46)
      JACC(66,67) = SAVE1322
      DWCCL(149,67) =
     : DWCCL(149,67)+JACCCCL(66,67)*0.2870000000000000d+00
      JACC(66,46) = SAVE1321
      DWCCL(149,46) =
     : DWCCL(149,46)+JACCCCL(66,46)*0.2870000000000000d+00
      JACC(61,67) = SAVE1320
      DWCCL(149,67) =
     : DWCCL(149,67)+JACCCCL(61,67)*0.1240000000000000d+01
      JACC(61,46) = SAVE1319
      DWCCL(149,46) =
     : DWCCL(149,46)+JACCCCL(61,46)*0.1240000000000000d+01
      JACC(59,67) = SAVE1318
      DWCCL(149,67) =
     : DWCCL(149,67)+JACCCCL(59,67)*0.4640000000000000d+00
      JACC(59,46) = SAVE1317
      DWCCL(149,46) =
     : DWCCL(149,46)+JACCCCL(59,46)*0.4640000000000000d+00
      JACC(46,67) = SAVE1316
      DWCCL(149,67) = DWCCL(149,67)-JACCCCL(46,67)
      JACC(46,46) = SAVE1315
      DWCCL(149,46) = DWCCL(149,46)-JACCCCL(46,46)
      JACC(72,67) = SAVE1314
      DWCCL(148,67) = DWCCL(148,67)+JACCCCL(72,67)
      JACC(72,47) = SAVE1313
      DWCCL(148,47) = DWCCL(148,47)+JACCCCL(72,47)
      JACC(71,67) = SAVE1312
      DWCCL(148,67) = DWCCL(148,67)+JACCCCL(71,67)
      JACC(71,47) = SAVE1311
      DWCCL(148,47) = DWCCL(148,47)+JACCCCL(71,47)
      JACC(70,67) = SAVE1310
      DWCCL(148,67) = DWCCL(148,67)+JACCCCL(70,67)
      JACC(70,47) = SAVE1309
      DWCCL(148,47) = DWCCL(148,47)+JACCCCL(70,47)
      JACC(67,67) = SAVE1308
      DWCCL(148,67) = DWCCL(148,67)-JACCCCL(67,67)
      JACC(67,47) = SAVE1307
      DWCCL(148,47) = DWCCL(148,47)-JACCCCL(67,47)
      JACC(47,67) = SAVE1306
      DWCCL(148,67) = DWCCL(148,67)-JACCCCL(47,67)
      JACC(47,47) = SAVE1305
      DWCCL(148,47) = DWCCL(148,47)-JACCCCL(47,47)
      JACC(72,67) = SAVE1304
      DWCCL(147,67) = DWCCL(147,67)+JACCCCL(72,67)
      JACC(72,58) = SAVE1303
      DWCCL(147,58) = DWCCL(147,58)+JACCCCL(72,58)
      JACC(71,67) = SAVE1302
      DWCCL(147,67) =
     : DWCCL(147,67)+JACCCCL(71,67)*0.7700000000000000d+00
      JACC(71,58) = SAVE1301
      DWCCL(147,58) =
     : DWCCL(147,58)+JACCCCL(71,58)*0.7700000000000000d+00
      JACC(69,67) = SAVE1300
      DWCCL(147,67) =
     : DWCCL(147,67)+JACCCCL(69,67)*0.2300000000000000d+00
      JACC(69,58) = SAVE1299
      DWCCL(147,58) =
     : DWCCL(147,58)+JACCCCL(69,58)*0.2300000000000000d+00
      JACC(67,67) = SAVE1298
      DWCCL(147,67) = DWCCL(147,67)-JACCCCL(67,67)
      JACC(67,58) = SAVE1297
      DWCCL(147,58) = DWCCL(147,58)-JACCCCL(67,58)
      JACC(65,67) = SAVE1296
      DWCCL(147,67) =
     : DWCCL(147,67)+JACCCCL(65,67)*0.1600000000000000d+00
      JACC(65,58) = SAVE1295
      DWCCL(147,58) =
     : DWCCL(147,58)+JACCCCL(65,58)*0.1600000000000000d+00
      JACC(61,67) = SAVE1294
      DWCCL(147,67) =
     : DWCCL(147,67)+JACCCCL(61,67)*0.4600000000000000d+00
      JACC(61,58) = SAVE1293
      DWCCL(147,58) =
     : DWCCL(147,58)+JACCCCL(61,58)*0.4600000000000000d+00
      JACC(58,67) = SAVE1292
      DWCCL(147,67) = DWCCL(147,67)-JACCCCL(58,67)
      JACC(58,58) = SAVE1291
      DWCCL(147,58) = DWCCL(147,58)-JACCCCL(58,58)
      JACC(54,67) = SAVE1290
      DWCCL(147,67) =
     : DWCCL(147,67)+JACCCCL(54,67)*0.5400000000000000d+00
      JACC(54,58) = SAVE1289
      DWCCL(147,58) =
     : DWCCL(147,58)+JACCCCL(54,58)*0.5400000000000000d+00
      JACC(72,67) = SAVE1288
      DWCCL(146,67) = DWCCL(146,67)+JACCCCL(72,67)
      JACC(72,56) = SAVE1287
      DWCCL(146,56) = DWCCL(146,56)+JACCCCL(72,56)
      JACC(69,67) = SAVE1286
      DWCCL(146,67) = DWCCL(146,67)+JACCCCL(69,67)
      JACC(69,56) = SAVE1285
      DWCCL(146,56) = DWCCL(146,56)+JACCCCL(69,56)
      JACC(67,67) = SAVE1284
      DWCCL(146,67) = DWCCL(146,67)-JACCCCL(67,67)
      JACC(67,56) = SAVE1283
      DWCCL(146,56) = DWCCL(146,56)-JACCCCL(67,56)
      JACC(66,67) = SAVE1282
      DWCCL(146,67) = DWCCL(146,67)+JACCCCL(66,67)
      JACC(66,56) = SAVE1281
      DWCCL(146,56) = DWCCL(146,56)+JACCCCL(66,56)
      JACC(56,67) = SAVE1280
      DWCCL(146,67) = DWCCL(146,67)-JACCCCL(56,67)
      JACC(56,56) = SAVE1279
      DWCCL(146,56) = DWCCL(146,56)-JACCCCL(56,56)
      JACC(72,67) = SAVE1278
      DWCCL(145,67) = DWCCL(145,67)+JACCCCL(72,67)
      JACC(72,69) = SAVE1277
      DWCCL(145,69) = DWCCL(145,69)+JACCCCL(72,69)
      JACC(69,67) = SAVE1276
      DWCCL(145,67) = DWCCL(145,67)-JACCCCL(69,67)
      JACC(69,69) = SAVE1275
      DWCCL(145,69) = DWCCL(145,69)-JACCCCL(69,69)
      JACC(67,67) = SAVE1274
      DWCCL(145,67) = DWCCL(145,67)-JACCCCL(67,67)
      JACC(67,69) = SAVE1273
      DWCCL(145,69) = DWCCL(145,69)-JACCCCL(67,69)
      JACC(63,67) = SAVE1272
      DWCCL(145,67) = DWCCL(145,67)+JACCCCL(63,67)
      JACC(63,69) = SAVE1271
      DWCCL(145,69) = DWCCL(145,69)+JACCCCL(63,69)
      JACC(72,67) = SAVE1270
      DWCCL(144,67) = DWCCL(144,67)+JACCCCL(72,67)
      JACC(72,33) = SAVE1269
      DWCCL(144,33) = DWCCL(144,33)+JACCCCL(72,33)
      JACC(71,67) = SAVE1268
      DWCCL(144,67) = DWCCL(144,67)+JACCCCL(71,67)
      JACC(71,33) = SAVE1267
      DWCCL(144,33) = DWCCL(144,33)+JACCCCL(71,33)
      JACC(67,67) = SAVE1266
      DWCCL(144,67) = DWCCL(144,67)-JACCCCL(67,67)
      JACC(67,33) = SAVE1265
      DWCCL(144,33) = DWCCL(144,33)-JACCCCL(67,33)
      JACC(54,67) = SAVE1264
      DWCCL(144,67) = DWCCL(144,67)+JACCCCL(54,67)
      JACC(54,33) = SAVE1263
      DWCCL(144,33) = DWCCL(144,33)+JACCCCL(54,33)
      JACC(51,67) = SAVE1262
      DWCCL(144,67) = DWCCL(144,67)+JACCCCL(51,67)
      JACC(51,33) = SAVE1261
      DWCCL(144,33) = DWCCL(144,33)+JACCCCL(51,33)
      JACC(33,67) = SAVE1260
      DWCCL(144,67) = DWCCL(144,67)-JACCCCL(33,67)
      JACC(33,33) = SAVE1259
      DWCCL(144,33) = DWCCL(144,33)-JACCCCL(33,33)
      JACC(72,67) = SAVE1258
      DWCCL(143,67) =
     : DWCCL(143,67)+JACCCCL(72,67)*0.9500000000000000d+00
      JACC(72,32) = SAVE1257
      DWCCL(143,32) =
     : DWCCL(143,32)+JACCCCL(72,32)*0.9500000000000000d+00
      JACC(71,67) = SAVE1256
      DWCCL(143,67) =
     : DWCCL(143,67)+JACCCCL(71,67)*0.9500000000000000d+00
      JACC(71,32) = SAVE1255
      DWCCL(143,32) =
     : DWCCL(143,32)+JACCCCL(71,32)*0.9500000000000000d+00
      JACC(70,67) = SAVE1254
      DWCCL(143,67) =
     : DWCCL(143,67)+JACCCCL(70,67)*0.5000000000000000d-01
      JACC(70,32) = SAVE1253
      DWCCL(143,32) =
     : DWCCL(143,32)+JACCCCL(70,32)*0.5000000000000000d-01
      JACC(67,67) = SAVE1252
      DWCCL(143,67) = DWCCL(143,67)-JACCCCL(67,67)
      JACC(67,32) = SAVE1251
      DWCCL(143,32) = DWCCL(143,32)-JACCCCL(67,32)
      JACC(54,67) = SAVE1250
      DWCCL(143,67) =
     : DWCCL(143,67)+JACCCCL(54,67)*0.6000000000000000d+00
      JACC(54,32) = SAVE1249
      DWCCL(143,32) =
     : DWCCL(143,32)+JACCCCL(54,32)*0.6000000000000000d+00
      JACC(51,67) = SAVE1248
      DWCCL(143,67) =
     : DWCCL(143,67)+JACCCCL(51,67)*0.3500000000000000d+00
      JACC(51,32) = SAVE1247
      DWCCL(143,32) =
     : DWCCL(143,32)+JACCCCL(51,32)*0.3500000000000000d+00
      JACC(48,67) = SAVE1246
      DWCCL(143,67) =
     : DWCCL(143,67)+JACCCCL(48,67)*0.9500000000000000d+00
      JACC(48,32) = SAVE1245
      DWCCL(143,32) =
     : DWCCL(143,32)+JACCCCL(48,32)*0.9500000000000000d+00
      JACC(32,67) = SAVE1244
      DWCCL(143,67) = DWCCL(143,67)-JACCCCL(32,67)
      JACC(32,32) = SAVE1243
      DWCCL(143,32) = DWCCL(143,32)-JACCCCL(32,32)
      JACC(72,67) = SAVE1242
      DWCCL(142,67) =
     : DWCCL(142,67)+JACCCCL(72,67)*0.9500000000000000d+00
      JACC(72,31) = SAVE1241
      DWCCL(142,31) =
     : DWCCL(142,31)+JACCCCL(72,31)*0.9500000000000000d+00
      JACC(71,67) = SAVE1240
      DWCCL(142,67) =
     : DWCCL(142,67)+JACCCCL(71,67)*0.9500000000000000d+00
      JACC(71,31) = SAVE1239
      DWCCL(142,31) =
     : DWCCL(142,31)+JACCCCL(71,31)*0.9500000000000000d+00
      JACC(70,67) = SAVE1238
      DWCCL(142,67) =
     : DWCCL(142,67)+JACCCCL(70,67)*0.5000000000000000d-01
      JACC(70,31) = SAVE1237
      DWCCL(142,31) =
     : DWCCL(142,31)+JACCCCL(70,31)*0.5000000000000000d-01
      JACC(67,67) = SAVE1236
      DWCCL(142,67) = DWCCL(142,67)-JACCCCL(67,67)
      JACC(67,31) = SAVE1235
      DWCCL(142,31) = DWCCL(142,31)-JACCCCL(67,31)
      JACC(54,67) = SAVE1234
      DWCCL(142,67) =
     : DWCCL(142,67)+JACCCCL(54,67)*0.6500000000000000d+00
      JACC(54,31) = SAVE1233
      DWCCL(142,31) =
     : DWCCL(142,31)+JACCCCL(54,31)*0.6500000000000000d+00
      JACC(51,67) = SAVE1232
      DWCCL(142,67) =
     : DWCCL(142,67)+JACCCCL(51,67)*0.1200000000000000d+01
      JACC(51,31) = SAVE1231
      DWCCL(142,31) =
     : DWCCL(142,31)+JACCCCL(51,31)*0.1200000000000000d+01
      JACC(48,67) = SAVE1230
      DWCCL(142,67) =
     : DWCCL(142,67)+JACCCCL(48,67)*0.5000000000000000d+00
      JACC(48,31) = SAVE1229
      DWCCL(142,31) =
     : DWCCL(142,31)+JACCCCL(48,31)*0.5000000000000000d+00
      JACC(31,67) = SAVE1228
      DWCCL(142,67) = DWCCL(142,67)-JACCCCL(31,67)
      JACC(31,31) = SAVE1227
      DWCCL(142,31) = DWCCL(142,31)-JACCCCL(31,31)
      JACC(72,67) = SAVE1226
      DWCCL(141,67) =
     : DWCCL(141,67)+JACCCCL(72,67)*0.6500000000000000d+00
      JACC(72,43) = SAVE1225
      DWCCL(141,43) =
     : DWCCL(141,43)+JACCCCL(72,43)*0.6500000000000000d+00
      JACC(71,67) = SAVE1224
      DWCCL(141,67) =
     : DWCCL(141,67)+JACCCCL(71,67)*0.6500000000000000d+00
      JACC(71,43) = SAVE1223
      DWCCL(141,43) =
     : DWCCL(141,43)+JACCCCL(71,43)*0.6500000000000000d+00
      JACC(70,67) = SAVE1222
      DWCCL(141,67) =
     : DWCCL(141,67)+JACCCCL(70,67)*0.3500000000000000d+00
      JACC(70,43) = SAVE1221
      DWCCL(141,43) =
     : DWCCL(141,43)+JACCCCL(70,43)*0.3500000000000000d+00
      JACC(67,67) = SAVE1220
      DWCCL(141,67) = DWCCL(141,67)-JACCCCL(67,67)
      JACC(67,43) = SAVE1219
      DWCCL(141,43) = DWCCL(141,43)-JACCCCL(67,43)
      JACC(66,67) = SAVE1218
      DWCCL(141,67) =
     : DWCCL(141,67)+JACCCCL(66,67)*0.2500000000000000d+00
      JACC(66,43) = SAVE1217
      DWCCL(141,43) =
     : DWCCL(141,43)+JACCCCL(66,43)*0.2500000000000000d+00
      JACC(49,67) = SAVE1216
      DWCCL(141,67) =
     : DWCCL(141,67)+JACCCCL(49,67)*0.4000000000000000d+00
      JACC(49,43) = SAVE1215
      DWCCL(141,43) =
     : DWCCL(141,43)+JACCCCL(49,43)*0.4000000000000000d+00
      JACC(44,67) = SAVE1214
      DWCCL(141,67) =
     : DWCCL(141,67)+JACCCCL(44,67)*0.2500000000000000d+00
      JACC(44,43) = SAVE1213
      DWCCL(141,43) =
     : DWCCL(141,43)+JACCCCL(44,43)*0.2500000000000000d+00
      JACC(43,67) = SAVE1212
      DWCCL(141,67) = DWCCL(141,67)-JACCCCL(43,67)
      JACC(43,43) = SAVE1211
      DWCCL(141,43) = DWCCL(141,43)-JACCCCL(43,43)
      JACC(72,67) = SAVE1210
      DWCCL(140,67) =
     : DWCCL(140,67)+JACCCCL(72,67)*0.8000000000000000d+00
      JACC(72,42) = SAVE1209
      DWCCL(140,42) =
     : DWCCL(140,42)+JACCCCL(72,42)*0.8000000000000000d+00
      JACC(71,67) = SAVE1208
      DWCCL(140,67) =
     : DWCCL(140,67)+JACCCCL(71,67)*0.8000000000000000d+00
      JACC(71,42) = SAVE1207
      DWCCL(140,42) =
     : DWCCL(140,42)+JACCCCL(71,42)*0.8000000000000000d+00
      JACC(70,67) = SAVE1206
      DWCCL(140,67) =
     : DWCCL(140,67)+JACCCCL(70,67)*0.2000000000000000d+00
      JACC(70,42) = SAVE1205
      DWCCL(140,42) =
     : DWCCL(140,42)+JACCCCL(70,42)*0.2000000000000000d+00
      JACC(67,67) = SAVE1204
      DWCCL(140,67) = DWCCL(140,67)-JACCCCL(67,67)
      JACC(67,42) = SAVE1203
      DWCCL(140,42) = DWCCL(140,42)-JACCCCL(67,42)
      JACC(61,67) = SAVE1202
      DWCCL(140,67) =
     : DWCCL(140,67)+JACCCCL(61,67)*0.8000000000000000d+00
      JACC(61,42) = SAVE1201
      DWCCL(140,42) =
     : DWCCL(140,42)+JACCCCL(61,42)*0.8000000000000000d+00
      JACC(59,67) = SAVE1200
      DWCCL(140,67) =
     : DWCCL(140,67)+JACCCCL(59,67)*0.8000000000000000d+00
      JACC(59,42) = SAVE1199
      DWCCL(140,42) =
     : DWCCL(140,42)+JACCCCL(59,42)*0.8000000000000000d+00
      JACC(42,67) = SAVE1198
      DWCCL(140,67) = DWCCL(140,67)-JACCCCL(42,67)
      JACC(42,42) = SAVE1197
      DWCCL(140,42) = DWCCL(140,42)-JACCCCL(42,42)
      JACC(72,67) = SAVE1196
      DWCCL(139,67) =
     : DWCCL(139,67)+JACCCCL(72,67)*0.8470000000000000d+00
      JACC(72,39) = SAVE1195
      DWCCL(139,39) =
     : DWCCL(139,39)+JACCCCL(72,39)*0.8470000000000000d+00
      JACC(71,67) = SAVE1194
      DWCCL(139,67) =
     : DWCCL(139,67)+JACCCCL(71,67)*0.8470000000000000d+00
      JACC(71,39) = SAVE1193
      DWCCL(139,39) =
     : DWCCL(139,39)+JACCCCL(71,39)*0.8470000000000000d+00
      JACC(70,67) = SAVE1192
      DWCCL(139,67) =
     : DWCCL(139,67)+JACCCCL(70,67)*0.1530000000000000d+00
      JACC(70,39) = SAVE1191
      DWCCL(139,39) =
     : DWCCL(139,39)+JACCCCL(70,39)*0.1530000000000000d+00
      JACC(67,67) = SAVE1190
      DWCCL(139,67) = DWCCL(139,67)-JACCCCL(67,67)
      JACC(67,39) = SAVE1189
      DWCCL(139,39) = DWCCL(139,39)-JACCCCL(67,39)
      JACC(66,67) = SAVE1188
      DWCCL(139,67) =
     : DWCCL(139,67)+JACCCCL(66,67)*0.6060000000000000d+00
      JACC(66,39) = SAVE1187
      DWCCL(139,39) =
     : DWCCL(139,39)+JACCCCL(66,39)*0.6060000000000000d+00
      JACC(49,67) = SAVE1186
      DWCCL(139,67) =
     : DWCCL(139,67)+JACCCCL(49,67)*0.4460000000000000d+00
      JACC(49,39) = SAVE1185
      DWCCL(139,39) =
     : DWCCL(139,39)+JACCCCL(49,39)*0.4460000000000000d+00
      JACC(40,67) = SAVE1184
      DWCCL(139,67) =
     : DWCCL(139,67)+JACCCCL(40,67)*0.3540000000000000d+00
      JACC(40,39) = SAVE1183
      DWCCL(139,39) =
     : DWCCL(139,39)+JACCCCL(40,39)*0.3540000000000000d+00
      JACC(39,67) = SAVE1182
      DWCCL(139,67) = DWCCL(139,67)-JACCCCL(39,67)
      JACC(39,39) = SAVE1181
      DWCCL(139,39) = DWCCL(139,39)-JACCCCL(39,39)
      JACC(72,67) = SAVE1180
      DWCCL(138,67) = DWCCL(138,67)+JACCCCL(72,67)
      JACC(72,45) = SAVE1179
      DWCCL(138,45) = DWCCL(138,45)+JACCCCL(72,45)
      JACC(71,67) = SAVE1178
      DWCCL(138,67) = DWCCL(138,67)+JACCCCL(71,67)
      JACC(71,45) = SAVE1177
      DWCCL(138,45) = DWCCL(138,45)+JACCCCL(71,45)
      JACC(67,67) = SAVE1176
      DWCCL(138,67) = DWCCL(138,67)-JACCCCL(67,67)
      JACC(67,45) = SAVE1175
      DWCCL(138,45) = DWCCL(138,45)-JACCCCL(67,45)
      JACC(61,67) = SAVE1174
      DWCCL(138,67) =
     : DWCCL(138,67)+JACCCCL(61,67)*0.1710000000000000d+01
      JACC(61,45) = SAVE1173
      DWCCL(138,45) =
     : DWCCL(138,45)+JACCCCL(61,45)*0.1710000000000000d+01
      JACC(59,67) = SAVE1172
      DWCCL(138,67) =
     : DWCCL(138,67)+JACCCCL(59,67)*0.2900000000000000d+00
      JACC(59,45) = SAVE1171
      DWCCL(138,45) =
     : DWCCL(138,45)+JACCCCL(59,45)*0.2900000000000000d+00
      JACC(45,67) = SAVE1170
      DWCCL(138,67) = DWCCL(138,67)-JACCCCL(45,67)
      JACC(45,45) = SAVE1169
      DWCCL(138,45) = DWCCL(138,45)-JACCCCL(45,45)
      JACC(72,67) = SAVE1168
      DWCCL(137,67) = DWCCL(137,67)+JACCCCL(72,67)
      JACC(72,41) = SAVE1167
      DWCCL(137,41) = DWCCL(137,41)+JACCCCL(72,41)
      JACC(71,67) = SAVE1166
      DWCCL(137,67) = DWCCL(137,67)+JACCCCL(71,67)
      JACC(71,41) = SAVE1165
      DWCCL(137,41) = DWCCL(137,41)+JACCCCL(71,41)
      JACC(67,67) = SAVE1164
      DWCCL(137,67) = DWCCL(137,67)-JACCCCL(67,67)
      JACC(67,41) = SAVE1163
      DWCCL(137,41) = DWCCL(137,41)-JACCCCL(67,41)
      JACC(66,67) = SAVE1162
      DWCCL(137,67) = DWCCL(137,67)+JACCCCL(66,67)
      JACC(66,41) = SAVE1161
      DWCCL(137,41) = DWCCL(137,41)+JACCCCL(66,41)
      JACC(61,67) = SAVE1160
      DWCCL(137,67) =
     : DWCCL(137,67)+JACCCCL(61,67)*0.9399999999999999d+00
      JACC(61,41) = SAVE1159
      DWCCL(137,41) =
     : DWCCL(137,41)+JACCCCL(61,41)*0.9399999999999999d+00
      JACC(59,67) = SAVE1158
      DWCCL(137,67) =
     : DWCCL(137,67)+JACCCCL(59,67)*0.6000000000000000d-01
      JACC(59,41) = SAVE1157
      DWCCL(137,41) =
     : DWCCL(137,41)+JACCCCL(59,41)*0.6000000000000000d-01
      JACC(41,67) = SAVE1156
      DWCCL(137,67) = DWCCL(137,67)-JACCCCL(41,67)
      JACC(41,41) = SAVE1155
      DWCCL(137,41) = DWCCL(137,41)-JACCCCL(41,41)
      JACC(72,67) = SAVE1154
      DWCCL(136,67) = DWCCL(136,67)+JACCCCL(72,67)
      JACC(72,38) = SAVE1153
      DWCCL(136,38) = DWCCL(136,38)+JACCCCL(72,38)
      JACC(71,67) = SAVE1152
      DWCCL(136,67) = DWCCL(136,67)+JACCCCL(71,67)
      JACC(71,38) = SAVE1151
      DWCCL(136,38) = DWCCL(136,38)+JACCCCL(71,38)
      JACC(67,67) = SAVE1150
      DWCCL(136,67) = DWCCL(136,67)-JACCCCL(67,67)
      JACC(67,38) = SAVE1149
      DWCCL(136,38) = DWCCL(136,38)-JACCCCL(67,38)
      JACC(66,67) = SAVE1148
      DWCCL(136,67) =
     : DWCCL(136,67)+JACCCCL(66,67)*0.1600000000000000d+01
      JACC(66,38) = SAVE1147
      DWCCL(136,38) =
     : DWCCL(136,38)+JACCCCL(66,38)*0.1600000000000000d+01
      JACC(61,67) = SAVE1146
      DWCCL(136,67) =
     : DWCCL(136,67)+JACCCCL(61,67)*0.2000000000000000d+00
      JACC(61,38) = SAVE1145
      DWCCL(136,38) =
     : DWCCL(136,38)+JACCCCL(61,38)*0.2000000000000000d+00
      JACC(38,67) = SAVE1144
      DWCCL(136,67) = DWCCL(136,67)-JACCCCL(38,67)
      JACC(38,38) = SAVE1143
      DWCCL(136,38) = DWCCL(136,38)-JACCCCL(38,38)
      JACC(72,67) = SAVE1142
      DWCCL(135,67) =
     : DWCCL(135,67)+JACCCCL(72,67)*0.7390000000000000d+00
      JACC(72,37) = SAVE1141
      DWCCL(135,37) =
     : DWCCL(135,37)+JACCCCL(72,37)*0.7390000000000000d+00
      JACC(71,67) = SAVE1140
      DWCCL(135,67) =
     : DWCCL(135,67)+JACCCCL(71,67)*0.6060000000000000d+00
      JACC(71,37) = SAVE1139
      DWCCL(135,37) =
     : DWCCL(135,37)+JACCCCL(71,37)*0.6060000000000000d+00
      JACC(70,67) = SAVE1138
      DWCCL(135,67) =
     : DWCCL(135,67)+JACCCCL(70,67)*0.2610000000000000d+00
      JACC(70,37) = SAVE1137
      DWCCL(135,37) =
     : DWCCL(135,37)+JACCCCL(70,37)*0.2610000000000000d+00
      JACC(67,67) = SAVE1136
      DWCCL(135,67) = DWCCL(135,67)-JACCCCL(67,67)
      JACC(67,37) = SAVE1135
      DWCCL(135,37) = DWCCL(135,37)-JACCCCL(67,37)
      JACC(65,67) = SAVE1134
      DWCCL(135,67) =
     : DWCCL(135,67)+JACCCCL(65,67)*0.4160000000000000d+00
      JACC(65,37) = SAVE1133
      DWCCL(135,37) =
     : DWCCL(135,37)+JACCCCL(65,37)*0.4160000000000000d+00
      JACC(61,67) = SAVE1132
      DWCCL(135,67) =
     : DWCCL(135,67)+JACCCCL(61,67)*0.1500000000000000d+00
      JACC(61,37) = SAVE1131
      DWCCL(135,37) =
     : DWCCL(135,37)+JACCCCL(61,37)*0.1500000000000000d+00
      JACC(60,67) = SAVE1130
      DWCCL(135,67) =
     : DWCCL(135,67)+JACCCCL(60,67)*0.1330000000000000d+00
      JACC(60,37) = SAVE1129
      DWCCL(135,37) =
     : DWCCL(135,37)+JACCCCL(60,37)*0.1330000000000000d+00
      JACC(59,67) = SAVE1128
      DWCCL(135,67) =
     : DWCCL(135,67)+JACCCCL(59,67)*0.6420000000000000d+00
      JACC(59,37) = SAVE1127
      DWCCL(135,37) =
     : DWCCL(135,37)+JACCCCL(59,37)*0.6420000000000000d+00
      JACC(37,67) = SAVE1126
      DWCCL(135,67) = DWCCL(135,67)-JACCCCL(37,67)
      JACC(37,37) = SAVE1125
      DWCCL(135,37) = DWCCL(135,37)-JACCCCL(37,37)
      JACC(72,67) = SAVE1124
      DWCCL(134,67) =
     : DWCCL(134,67)+JACCCCL(72,67)*0.8760000000000000d+00
      JACC(72,36) = SAVE1123
      DWCCL(134,36) =
     : DWCCL(134,36)+JACCCCL(72,36)*0.8760000000000000d+00
      JACC(71,67) = SAVE1122
      DWCCL(134,67) =
     : DWCCL(134,67)+JACCCCL(71,67)*0.5990000000000000d+00
      JACC(71,36) = SAVE1121
      DWCCL(134,36) =
     : DWCCL(134,36)+JACCCCL(71,36)*0.5990000000000000d+00
      JACC(70,67) = SAVE1120
      DWCCL(134,67) =
     : DWCCL(134,67)+JACCCCL(70,67)*0.1240000000000000d+00
      JACC(70,36) = SAVE1119
      DWCCL(134,36) =
     : DWCCL(134,36)+JACCCCL(70,36)*0.1240000000000000d+00
      JACC(67,67) = SAVE1118
      DWCCL(134,67) = DWCCL(134,67)-JACCCCL(67,67)
      JACC(67,36) = SAVE1117
      DWCCL(134,36) = DWCCL(134,36)-JACCCCL(67,36)
      JACC(66,67) = SAVE1116
      DWCCL(134,67) =
     : DWCCL(134,67)+JACCCCL(66,67)*0.2100000000000000d-01
      JACC(66,36) = SAVE1115
      DWCCL(134,36) =
     : DWCCL(134,36)+JACCCCL(66,36)*0.2100000000000000d-01
      JACC(65,67) = SAVE1114
      DWCCL(134,67) =
     : DWCCL(134,67)+JACCCCL(65,67)*0.3340000000000000d+00
      JACC(65,36) = SAVE1113
      DWCCL(134,36) =
     : DWCCL(134,36)+JACCCCL(65,36)*0.3340000000000000d+00
      JACC(63,67) = SAVE1112
      DWCCL(134,67) =
     : DWCCL(134,67)+JACCCCL(63,67)*0.3100000000000000d-01
      JACC(63,36) = SAVE1111
      DWCCL(134,36) =
     : DWCCL(134,36)+JACCCCL(63,36)*0.3100000000000000d-01
      JACC(61,67) = SAVE1110
      DWCCL(134,67) =
     : DWCCL(134,67)+JACCCCL(61,67)*0.2110000000000000d+00
      JACC(61,36) = SAVE1109
      DWCCL(134,36) =
     : DWCCL(134,36)+JACCCCL(61,36)*0.2110000000000000d+00
      JACC(60,67) = SAVE1108
      DWCCL(134,67) =
     : DWCCL(134,67)+JACCCCL(60,67)*0.2450000000000000d+00
      JACC(60,36) = SAVE1107
      DWCCL(134,36) =
     : DWCCL(134,36)+JACCCCL(60,36)*0.2450000000000000d+00
      JACC(59,67) = SAVE1106
      DWCCL(134,67) =
     : DWCCL(134,67)+JACCCCL(59,67)*0.7220000000000000d+00
      JACC(59,36) = SAVE1105
      DWCCL(134,36) =
     : DWCCL(134,36)+JACCCCL(59,36)*0.7220000000000000d+00
      JACC(36,67) = SAVE1104
      DWCCL(134,67) = DWCCL(134,67)-JACCCCL(36,67)
      JACC(36,36) = SAVE1103
      DWCCL(134,36) = DWCCL(134,36)-JACCCCL(36,36)
      JACC(72,67) = SAVE1102
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(72,67)*0.9409999999999999d+00
      JACC(72,64) = SAVE1101
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(72,64)*0.9409999999999999d+00
      JACC(71,67) = SAVE1100
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(71,67)*0.7420000000000000d+00
      JACC(71,64) = SAVE1099
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(71,64)*0.7420000000000000d+00
      JACC(70,67) = SAVE1098
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(70,67)*0.5900000000000000d-01
      JACC(70,64) = SAVE1097
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(70,64)*0.5900000000000000d-01
      JACC(67,67) = SAVE1096
      DWCCL(133,67) = DWCCL(133,67)-JACCCCL(67,67)
      JACC(67,64) = SAVE1095
      DWCCL(133,64) = DWCCL(133,64)-JACCCCL(67,64)
      JACC(66,67) = SAVE1094
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(66,67)*0.4700000000000000d-01
      JACC(66,64) = SAVE1093
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(66,64)*0.4700000000000000d-01
      JACC(65,67) = SAVE1092
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(65,67)*0.4800000000000000d-01
      JACC(65,64) = SAVE1091
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(65,64)*0.4800000000000000d-01
      JACC(64,67) = SAVE1090
      DWCCL(133,67) = DWCCL(133,67)-JACCCCL(64,67)
      JACC(64,64) = SAVE1089
      DWCCL(133,64) = DWCCL(133,64)-JACCCCL(64,64)
      JACC(63,67) = SAVE1088
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(63,67)*0.1500000000000000d+00
      JACC(63,64) = SAVE1087
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(63,64)*0.1500000000000000d+00
      JACC(61,67) = SAVE1086
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(61,67)*0.2330000000000000d+00
      JACC(61,64) = SAVE1085
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(61,64)*0.2330000000000000d+00
      JACC(60,67) = SAVE1084
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(60,67)*0.4800000000000000d-01
      JACC(60,64) = SAVE1083
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(60,64)*0.4800000000000000d-01
      JACC(59,67) = SAVE1082
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(59,67)*0.6230000000000000d+00
      JACC(59,64) = SAVE1081
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(59,64)*0.6230000000000000d+00
      JACC(51,67) = SAVE1080
      DWCCL(133,67) =
     : DWCCL(133,67)+JACCCCL(51,67)*0.6300000000000000d-01
      JACC(51,64) = SAVE1079
      DWCCL(133,64) =
     : DWCCL(133,64)+JACCCCL(51,64)*0.6300000000000000d-01
      JACC(72,67) = SAVE1078
      DWCCL(132,67) = DWCCL(132,67)+JACCCCL(72,67)
      JACC(72,60) = SAVE1077
      DWCCL(132,60) = DWCCL(132,60)+JACCCCL(72,60)
      JACC(71,67) = SAVE1076
      DWCCL(132,67) = DWCCL(132,67)+JACCCCL(71,67)
      JACC(71,60) = SAVE1075
      DWCCL(132,60) = DWCCL(132,60)+JACCCCL(71,60)
      JACC(67,67) = SAVE1074
      DWCCL(132,67) = DWCCL(132,67)-JACCCCL(67,67)
      JACC(67,60) = SAVE1073
      DWCCL(132,60) = DWCCL(132,60)-JACCCCL(67,60)
      JACC(61,67) = SAVE1072
      DWCCL(132,67) = DWCCL(132,67)+JACCCCL(61,67)
      JACC(61,60) = SAVE1071
      DWCCL(132,60) = DWCCL(132,60)+JACCCCL(61,60)
      JACC(60,67) = SAVE1070
      DWCCL(132,67) = DWCCL(132,67)-JACCCCL(60,67)
      JACC(60,60) = SAVE1069
      DWCCL(132,60) = DWCCL(132,60)-JACCCCL(60,60)
      JACC(72,67) = SAVE1068
      DWCCL(131,67) = DWCCL(131,67)+JACCCCL(72,67)
      JACC(72,63) = SAVE1067
      DWCCL(131,63) = DWCCL(131,63)+JACCCCL(72,63)
      JACC(71,67) = SAVE1066
      DWCCL(131,67) = DWCCL(131,67)+JACCCCL(71,67)
      JACC(71,63) = SAVE1065
      DWCCL(131,63) = DWCCL(131,63)+JACCCCL(71,63)
      JACC(67,67) = SAVE1064
      DWCCL(131,67) = DWCCL(131,67)-JACCCCL(67,67)
      JACC(67,63) = SAVE1063
      DWCCL(131,63) = DWCCL(131,63)-JACCCCL(67,63)
      JACC(66,67) = SAVE1062
      DWCCL(131,67) = DWCCL(131,67)+JACCCCL(66,67)
      JACC(66,63) = SAVE1061
      DWCCL(131,63) = DWCCL(131,63)+JACCCCL(66,63)
      JACC(63,67) = SAVE1060
      DWCCL(131,67) = DWCCL(131,67)-JACCCCL(63,67)
      JACC(63,63) = SAVE1059
      DWCCL(131,63) = DWCCL(131,63)-JACCCCL(63,63)
      JACC(72,25) = SAVE1058
      DWCCL(130,25) = DWCCL(130,25)+JACCCCL(72,25)
      JACC(56,25) = SAVE1057
      DWCCL(130,25) = DWCCL(130,25)+JACCCCL(56,25)
      JACC(25,25) = SAVE1056
      DWCCL(130,25) = DWCCL(130,25)-JACCCCL(25,25)
      JACC(72,72) = SAVE1055
      DWCCL(129,72) = DWCCL(129,72)-JACCCCL(72,72)
      JACC(72,56) = SAVE1054
      DWCCL(129,56) = DWCCL(129,56)-JACCCCL(72,56)
      JACC(56,72) = SAVE1053
      DWCCL(129,72) = DWCCL(129,72)-JACCCCL(56,72)
      JACC(56,56) = SAVE1052
      DWCCL(129,56) = DWCCL(129,56)-JACCCCL(56,56)
      JACC(25,72) = SAVE1051
      DWCCL(129,72) = DWCCL(129,72)+JACCCCL(25,72)
      JACC(25,56) = SAVE1050
      DWCCL(129,56) = DWCCL(129,56)+JACCCCL(25,56)
      JACC(72,26) = SAVE1049
      DWCCL(128,26) = DWCCL(128,26)+JACCCCL(72,26)
      JACC(69,26) = SAVE1048
      DWCCL(128,26) = DWCCL(128,26)+JACCCCL(69,26)
      JACC(26,26) = SAVE1047
      DWCCL(128,26) = DWCCL(128,26)-JACCCCL(26,26)
      JACC(72,72) = SAVE1046
      DWCCL(127,72) = DWCCL(127,72)-JACCCCL(72,72)
      JACC(72,69) = SAVE1045
      DWCCL(127,69) = DWCCL(127,69)-JACCCCL(72,69)
      JACC(69,72) = SAVE1044
      DWCCL(127,72) = DWCCL(127,72)-JACCCCL(69,72)
      JACC(69,69) = SAVE1043
      DWCCL(127,69) = DWCCL(127,69)-JACCCCL(69,69)
      JACC(26,72) = SAVE1042
      DWCCL(127,72) = DWCCL(127,72)+JACCCCL(26,72)
      JACC(26,69) = SAVE1041
      DWCCL(127,69) = DWCCL(127,69)+JACCCCL(26,69)
      JACC(62,50) = SAVE1040
      DWCCL(126,50) = DWCCL(126,50)+JACCCCL(62,50)
      JACC(62,22) = SAVE1039
      DWCCL(126,22) = DWCCL(126,22)+JACCCCL(62,22)
      JACC(50,50) = SAVE1038
      DWCCL(126,50) = DWCCL(126,50)-JACCCCL(50,50)
      JACC(50,22) = SAVE1037
      DWCCL(126,22) = DWCCL(126,22)-JACCCCL(50,22)
      JACC(30,50) = SAVE1036
      DWCCL(126,50) = DWCCL(126,50)+JACCCCL(30,50)
      JACC(30,22) = SAVE1035
      DWCCL(126,22) = DWCCL(126,22)+JACCCCL(30,22)
      JACC(22,50) = SAVE1034
      DWCCL(126,50) = DWCCL(126,50)-JACCCCL(22,50)
      JACC(22,22) = SAVE1033
      DWCCL(126,22) = DWCCL(126,22)-JACCCCL(22,22)
      JACC(71,22) = SAVE1032
      DWCCL(125,22) =
     : DWCCL(125,22)+JACCCCL(71,22)*0.2000000000000000d-01
      JACC(33,22) = SAVE1031
      DWCCL(125,22) =
     : DWCCL(125,22)+JACCCCL(33,22)*0.9800000000000000d+00
      JACC(30,22) = SAVE1030
      DWCCL(125,22) =
     : DWCCL(125,22)+JACCCCL(30,22)*0.2000000000000000d-01
      JACC(22,22) = SAVE1029
      DWCCL(125,22) = DWCCL(125,22)-JACCCCL(22,22)
      JACC(72,72) = SAVE1028
      DWCCL(124,72) = DWCCL(124,72)-JACCCCL(72,72)
      JACC(72,22) = SAVE1027
      DWCCL(124,22) = DWCCL(124,22)-JACCCCL(72,22)
      JACC(30,72) = SAVE1026
      DWCCL(124,72) = DWCCL(124,72)+JACCCCL(30,72)
      JACC(30,22) = SAVE1025
      DWCCL(124,22) = DWCCL(124,22)+JACCCCL(30,22)
      JACC(23,72) = SAVE1024
      DWCCL(124,72) = DWCCL(124,72)+JACCCCL(23,72)
      JACC(23,22) = SAVE1023
      DWCCL(124,22) = DWCCL(124,22)+JACCCCL(23,22)
      JACC(22,72) = SAVE1022
      DWCCL(124,72) = DWCCL(124,72)-JACCCCL(22,72)
      JACC(22,22) = SAVE1021
      DWCCL(124,22) = DWCCL(124,22)-JACCCCL(22,22)
      JACC(62,50) = SAVE1020
      DWCCL(123,50) = DWCCL(123,50)+JACCCCL(62,50)
      JACC(62,18) = SAVE1019
      DWCCL(123,18) = DWCCL(123,18)+JACCCCL(62,18)
      JACC(50,50) = SAVE1018
      DWCCL(123,50) = DWCCL(123,50)-JACCCCL(50,50)
      JACC(50,18) = SAVE1017
      DWCCL(123,18) = DWCCL(123,18)-JACCCCL(50,18)
      JACC(30,50) = SAVE1016
      DWCCL(123,50) = DWCCL(123,50)+JACCCCL(30,50)
      JACC(30,18) = SAVE1015
      DWCCL(123,18) = DWCCL(123,18)+JACCCCL(30,18)
      JACC(18,50) = SAVE1014
      DWCCL(123,50) = DWCCL(123,50)-JACCCCL(18,50)
      JACC(18,18) = SAVE1013
      DWCCL(123,18) = DWCCL(123,18)-JACCCCL(18,18)
      JACC(71,18) = SAVE1012
      DWCCL(122,18) =
     : DWCCL(122,18)+JACCCCL(71,18)*0.2000000000000000d-01
      JACC(32,18) = SAVE1011
      DWCCL(122,18) =
     : DWCCL(122,18)+JACCCCL(32,18)*0.9800000000000000d+00
      JACC(30,18) = SAVE1010
      DWCCL(122,18) =
     : DWCCL(122,18)+JACCCCL(30,18)*0.2000000000000000d-01
      JACC(18,18) = SAVE1009
      DWCCL(122,18) = DWCCL(122,18)-JACCCCL(18,18)
      JACC(72,72) = SAVE1008
      DWCCL(121,72) = DWCCL(121,72)-JACCCCL(72,72)
      JACC(72,18) = SAVE1007
      DWCCL(121,18) = DWCCL(121,18)-JACCCCL(72,18)
      JACC(30,72) = SAVE1006
      DWCCL(121,72) = DWCCL(121,72)+JACCCCL(30,72)
      JACC(30,18) = SAVE1005
      DWCCL(121,18) = DWCCL(121,18)+JACCCCL(30,18)
      JACC(23,72) = SAVE1004
      DWCCL(121,72) = DWCCL(121,72)+JACCCCL(23,72)
      JACC(23,18) = SAVE1003
      DWCCL(121,18) = DWCCL(121,18)+JACCCCL(23,18)
      JACC(18,72) = SAVE1002
      DWCCL(121,72) = DWCCL(121,72)-JACCCCL(18,72)
      JACC(18,18) = SAVE1001
      DWCCL(121,18) = DWCCL(121,18)-JACCCCL(18,18)
      JACC(62,50) = SAVE1000
      DWCCL(120,50) = DWCCL(120,50)+JACCCCL(62,50)
      JACC(62,17) = SAVE999
      DWCCL(120,17) = DWCCL(120,17)+JACCCCL(62,17)
      JACC(50,50) = SAVE998
      DWCCL(120,50) = DWCCL(120,50)-JACCCCL(50,50)
      JACC(50,17) = SAVE997
      DWCCL(120,17) = DWCCL(120,17)-JACCCCL(50,17)
      JACC(30,50) = SAVE996
      DWCCL(120,50) = DWCCL(120,50)+JACCCCL(30,50)
      JACC(30,17) = SAVE995
      DWCCL(120,17) = DWCCL(120,17)+JACCCCL(30,17)
      JACC(17,50) = SAVE994
      DWCCL(120,50) = DWCCL(120,50)-JACCCCL(17,50)
      JACC(17,17) = SAVE993
      DWCCL(120,17) = DWCCL(120,17)-JACCCCL(17,17)
      JACC(71,17) = SAVE992
      DWCCL(119,17) =
     : DWCCL(119,17)+JACCCCL(71,17)*0.2000000000000000d-01
      JACC(31,17) = SAVE991
      DWCCL(119,17) =
     : DWCCL(119,17)+JACCCCL(31,17)*0.9800000000000000d+00
      JACC(30,17) = SAVE990
      DWCCL(119,17) =
     : DWCCL(119,17)+JACCCCL(30,17)*0.2000000000000000d-01
      JACC(17,17) = SAVE989
      DWCCL(119,17) = DWCCL(119,17)-JACCCCL(17,17)
      JACC(72,72) = SAVE988
      DWCCL(118,72) = DWCCL(118,72)-JACCCCL(72,72)
      JACC(72,17) = SAVE987
      DWCCL(118,17) = DWCCL(118,17)-JACCCCL(72,17)
      JACC(30,72) = SAVE986
      DWCCL(118,72) = DWCCL(118,72)+JACCCCL(30,72)
      JACC(30,17) = SAVE985
      DWCCL(118,17) = DWCCL(118,17)+JACCCCL(30,17)
      JACC(23,72) = SAVE984
      DWCCL(118,72) = DWCCL(118,72)+JACCCCL(23,72)
      JACC(23,17) = SAVE983
      DWCCL(118,17) = DWCCL(118,17)+JACCCCL(23,17)
      JACC(17,72) = SAVE982
      DWCCL(118,72) = DWCCL(118,72)-JACCCCL(17,72)
      JACC(17,17) = SAVE981
      DWCCL(118,17) = DWCCL(118,17)-JACCCCL(17,17)
      JACC(71,71) = SAVE980
      DWCCL(117,71) = DWCCL(117,71)-JACCCCL(71,71)
      JACC(71,29) = SAVE979
      DWCCL(117,29) = DWCCL(117,29)-JACCCCL(71,29)
      JACC(30,71) = SAVE978
      DWCCL(117,71) = DWCCL(117,71)+JACCCCL(30,71)
      JACC(30,29) = SAVE977
      DWCCL(117,29) = DWCCL(117,29)+JACCCCL(30,29)
      JACC(29,71) = SAVE976
      DWCCL(117,71) = DWCCL(117,71)-JACCCCL(29,71)
      JACC(29,29) = SAVE975
      DWCCL(117,29) = DWCCL(117,29)-JACCCCL(29,29)
      JACC(72,72) = SAVE974
      DWCCL(116,72) = DWCCL(116,72)-JACCCCL(72,72)
      JACC(72,29) = SAVE973
      DWCCL(116,29) = DWCCL(116,29)-JACCCCL(72,29)
      JACC(70,72) = SAVE972
      DWCCL(116,72) = DWCCL(116,72)+JACCCCL(70,72)
      JACC(70,29) = SAVE971
      DWCCL(116,29) = DWCCL(116,29)+JACCCCL(70,29)
      JACC(30,72) = SAVE970
      DWCCL(116,72) =
     : DWCCL(116,72)+JACCCCL(30,72)*0.1000000000000000d+00
      JACC(30,29) = SAVE969
      DWCCL(116,29) =
     : DWCCL(116,29)+JACCCCL(30,29)*0.1000000000000000d+00
      JACC(29,72) = SAVE968
      DWCCL(116,72) = DWCCL(116,72)-JACCCCL(29,72)
      JACC(29,29) = SAVE967
      DWCCL(116,29) = DWCCL(116,29)-JACCCCL(29,29)
      JACC(72,50) = SAVE966
      DWCCL(115,50) =
     : DWCCL(115,50)+JACCCCL(72,50)*0.7000000000000000d+00
      JACC(72,25) = SAVE965
      DWCCL(115,25) =
     : DWCCL(115,25)+JACCCCL(72,25)*0.7000000000000000d+00
      JACC(71,50) = SAVE964
      DWCCL(115,50) =
     : DWCCL(115,50)+JACCCCL(71,50)*0.8000000000000000d-01
      JACC(71,25) = SAVE963
      DWCCL(115,25) =
     : DWCCL(115,25)+JACCCCL(71,25)*0.8000000000000000d-01
      JACC(69,50) = SAVE962
      DWCCL(115,50) =
     : DWCCL(115,50)+JACCCCL(69,50)*0.7000000000000000d+00
      JACC(69,25) = SAVE961
      DWCCL(115,25) =
     : DWCCL(115,25)+JACCCCL(69,25)*0.7000000000000000d+00
      JACC(66,50) = SAVE960
      DWCCL(115,50) =
     : DWCCL(115,50)+JACCCCL(66,50)*0.7000000000000000d+00
      JACC(66,25) = SAVE959
      DWCCL(115,25) =
     : DWCCL(115,25)+JACCCCL(66,25)*0.7000000000000000d+00
      JACC(62,50) = SAVE958
      DWCCL(115,50) =
     : DWCCL(115,50)+JACCCCL(62,50)*0.3600000000000000d-01
      JACC(62,25) = SAVE957
      DWCCL(115,25) =
     : DWCCL(115,25)+JACCCCL(62,25)*0.3600000000000000d-01
      JACC(52,50) = SAVE956
      DWCCL(115,50) =
     : DWCCL(115,50)+JACCCCL(52,50)*0.1300000000000000d+00
      JACC(52,25) = SAVE955
      DWCCL(115,25) =
     : DWCCL(115,25)+JACCCCL(52,25)*0.1300000000000000d+00
      JACC(50,50) = SAVE954
      DWCCL(115,50) = DWCCL(115,50)-JACCCCL(50,50)
      JACC(50,25) = SAVE953
      DWCCL(115,25) = DWCCL(115,25)-JACCCCL(50,25)
      JACC(34,50) = SAVE952
      DWCCL(115,50) =
     : DWCCL(115,50)+JACCCCL(34,50)*0.1100000000000000d+00
      JACC(34,25) = SAVE951
      DWCCL(115,25) =
     : DWCCL(115,25)+JACCCCL(34,25)*0.1100000000000000d+00
      JACC(26,50) = SAVE950
      DWCCL(115,50) =
     : DWCCL(115,50)+JACCCCL(26,50)*0.3000000000000000d+00
      JACC(26,25) = SAVE949
      DWCCL(115,25) =
     : DWCCL(115,25)+JACCCCL(26,25)*0.3000000000000000d+00
      JACC(25,50) = SAVE948
      DWCCL(115,50) = DWCCL(115,50)-JACCCCL(25,50)
      JACC(25,25) = SAVE947
      DWCCL(115,25) = DWCCL(115,25)-JACCCCL(25,25)
      JACC(71,50) = SAVE946
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(71,50)*0.2900000000000000d+00
      JACC(71,48) = SAVE945
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(71,48)*0.2900000000000000d+00
      JACC(69,50) = SAVE944
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(69,50)*0.2800000000000000d+00
      JACC(69,48) = SAVE943
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(69,48)*0.2800000000000000d+00
      JACC(62,50) = SAVE942
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(62,50)*0.2100000000000000d+00
      JACC(62,48) = SAVE941
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(62,48)*0.2100000000000000d+00
      JACC(61,50) = SAVE940
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(61,50)*0.1600000000000000d+00
      JACC(61,48) = SAVE939
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(61,48)*0.1600000000000000d+00
      JACC(57,50) = SAVE938
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(57,50)*0.2100000000000000d+00
      JACC(57,48) = SAVE937
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(57,48)*0.2100000000000000d+00
      JACC(54,50) = SAVE936
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(54,50)*0.6200000000000000d+00
      JACC(54,48) = SAVE935
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(54,48)*0.6200000000000000d+00
      JACC(52,50) = SAVE934
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(52,50)*0.6600000000000000d+00
      JACC(52,48) = SAVE933
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(52,48)*0.6600000000000000d+00
      JACC(51,50) = SAVE932
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(51,50)*0.5000000000000000d+00
      JACC(51,48) = SAVE931
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(51,48)*0.5000000000000000d+00
      JACC(50,50) = SAVE930
      DWCCL(114,50) = DWCCL(114,50)-JACCCCL(50,50)
      JACC(50,48) = SAVE929
      DWCCL(114,48) = DWCCL(114,48)-JACCCCL(50,48)
      JACC(48,50) = SAVE928
      DWCCL(114,50) = DWCCL(114,50)-JACCCCL(48,50)
      JACC(48,48) = SAVE927
      DWCCL(114,48) = DWCCL(114,48)-JACCCCL(48,48)
      JACC(34,50) = SAVE926
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(34,50)*0.1100000000000000d+00
      JACC(34,48) = SAVE925
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(34,48)*0.1100000000000000d+00
      JACC(28,50) = SAVE924
      DWCCL(114,50) =
     : DWCCL(114,50)+JACCCCL(28,50)*0.1100000000000000d+00
      JACC(28,48) = SAVE923
      DWCCL(114,48) =
     : DWCCL(114,48)+JACCCCL(28,48)*0.1100000000000000d+00
      JACC(71,50) = SAVE922
      DWCCL(113,50) =
     : DWCCL(113,50)+JACCCCL(71,50)*0.2900000000000000d+00
      JACC(71,49) = SAVE921
      DWCCL(113,49) =
     : DWCCL(113,49)+JACCCCL(71,49)*0.2900000000000000d+00
      JACC(69,50) = SAVE920
      DWCCL(113,50) =
     : DWCCL(113,50)+JACCCCL(69,50)*0.1300000000000000d+00
      JACC(69,49) = SAVE919
      DWCCL(113,49) =
     : DWCCL(113,49)+JACCCCL(69,49)*0.1300000000000000d+00
      JACC(66,50) = SAVE918
      DWCCL(113,50) =
     : DWCCL(113,50)+JACCCCL(66,50)*0.4000000000000000d+00
      JACC(66,49) = SAVE917
      DWCCL(113,49) =
     : DWCCL(113,49)+JACCCCL(66,49)*0.4000000000000000d+00
      JACC(62,50) = SAVE916
      DWCCL(113,50) =
     : DWCCL(113,50)+JACCCCL(62,50)*0.7000000000000001d-01
      JACC(62,49) = SAVE915
      DWCCL(113,49) =
     : DWCCL(113,49)+JACCCCL(62,49)*0.7000000000000001d-01
      JACC(57,50) = SAVE914
      DWCCL(113,50) =
     : DWCCL(113,50)+JACCCCL(57,50)*0.1300000000000000d+00
      JACC(57,49) = SAVE913
      DWCCL(113,49) =
     : DWCCL(113,49)+JACCCCL(57,49)*0.1300000000000000d+00
      JACC(54,50) = SAVE912
      DWCCL(113,50) =
     : DWCCL(113,50)+JACCCCL(54,50)*0.6000000000000000d+00
      JACC(54,49) = SAVE911
      DWCCL(113,49) =
     : DWCCL(113,49)+JACCCCL(54,49)*0.6000000000000000d+00
      JACC(53,50) = SAVE910
      DWCCL(113,50) =
     : DWCCL(113,50)+JACCCCL(53,50)*0.1300000000000000d+00
      JACC(53,49) = SAVE909
      DWCCL(113,49) =
     : DWCCL(113,49)+JACCCCL(53,49)*0.1300000000000000d+00
      JACC(52,50) = SAVE908
      DWCCL(113,50) =
     : DWCCL(113,50)+JACCCCL(52,50)*0.5400000000000000d+00
      JACC(52,49) = SAVE907
      DWCCL(113,49) =
     : DWCCL(113,49)+JACCCCL(52,49)*0.5400000000000000d+00
      JACC(50,50) = SAVE906
      DWCCL(113,50) = DWCCL(113,50)-JACCCCL(50,50)
      JACC(50,49) = SAVE905
      DWCCL(113,49) = DWCCL(113,49)-JACCCCL(50,49)
      JACC(49,50) = SAVE904
      DWCCL(113,50) = DWCCL(113,50)-JACCCCL(49,50)
      JACC(49,49) = SAVE903
      DWCCL(113,49) = DWCCL(113,49)-JACCCCL(49,49)
      JACC(34,50) = SAVE902
      DWCCL(113,50) =
     : DWCCL(113,50)+JACCCCL(34,50)*0.2200000000000000d+00
      JACC(34,49) = SAVE901
      DWCCL(113,49) =
     : DWCCL(113,49)+JACCCCL(34,49)*0.2200000000000000d+00
      JACC(71,50) = SAVE900
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(71,50)*0.1000000000000000d+00
      JACC(71,14) = SAVE899
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(71,14)*0.1000000000000000d+00
      JACC(66,50) = SAVE898
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(66,50)*0.4000000000000000d-01
      JACC(66,14) = SAVE897
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(66,14)*0.4000000000000000d-01
      JACC(62,50) = SAVE896
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(62,50)*0.8500000000000000d+00
      JACC(62,14) = SAVE895
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(62,14)*0.8500000000000000d+00
      JACC(60,50) = SAVE894
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(60,50)*0.1600000000000000d+00
      JACC(60,14) = SAVE893
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(60,14)*0.1600000000000000d+00
      JACC(58,50) = SAVE892
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(58,50)*0.4200000000000000d+00
      JACC(58,14) = SAVE891
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(58,14)*0.4200000000000000d+00
      JACC(57,50) = SAVE890
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(57,50)*0.7000000000000001d-01
      JACC(57,14) = SAVE889
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(57,14)*0.7000000000000001d-01
      JACC(52,50) = SAVE888
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(52,50)*0.1400000000000000d+00
      JACC(52,14) = SAVE887
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(52,14)*0.1400000000000000d+00
      JACC(50,50) = SAVE886
      DWCCL(112,50) = DWCCL(112,50)-JACCCCL(50,50)
      JACC(50,14) = SAVE885
      DWCCL(112,14) = DWCCL(112,14)-JACCCCL(50,14)
      JACC(49,50) = SAVE884
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(49,50)*0.7900000000000000d+00
      JACC(49,14) = SAVE883
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(49,14)*0.7900000000000000d+00
      JACC(40,50) = SAVE882
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(40,50)*0.4600000000000000d+00
      JACC(40,14) = SAVE881
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(40,14)*0.4600000000000000d+00
      JACC(34,50) = SAVE880
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(34,50)*0.1000000000000000d-01
      JACC(34,14) = SAVE879
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(34,14)*0.1000000000000000d-01
      JACC(27,50) = SAVE878
      DWCCL(112,50) =
     : DWCCL(112,50)+JACCCCL(27,50)*0.2000000000000000d-01
      JACC(27,14) = SAVE877
      DWCCL(112,14) =
     : DWCCL(112,14)+JACCCCL(27,14)*0.2000000000000000d-01
      JACC(14,50) = SAVE876
      DWCCL(112,50) = DWCCL(112,50)-JACCCCL(14,50)
      JACC(14,14) = SAVE875
      DWCCL(112,14) = DWCCL(112,14)-JACCCCL(14,14)
      JACC(71,50) = SAVE874
      DWCCL(111,50) =
     : DWCCL(111,50)+JACCCCL(71,50)*0.1000000000000000d+00
      JACC(71,13) = SAVE873
      DWCCL(111,13) =
     : DWCCL(111,13)+JACCCCL(71,13)*0.1000000000000000d+00
      JACC(62,50) = SAVE872
      DWCCL(111,50) =
     : DWCCL(111,50)+JACCCCL(62,50)*0.8500000000000000d+00
      JACC(62,13) = SAVE871
      DWCCL(111,13) =
     : DWCCL(111,13)+JACCCCL(62,13)*0.8500000000000000d+00
      JACC(61,50) = SAVE870
      DWCCL(111,50) =
     : DWCCL(111,50)+JACCCCL(61,50)*0.6500000000000000d+00
      JACC(61,13) = SAVE869
      DWCCL(111,13) =
     : DWCCL(111,13)+JACCCCL(61,13)*0.6500000000000000d+00
      JACC(60,50) = SAVE868
      DWCCL(111,50) =
     : DWCCL(111,50)+JACCCCL(60,50)*0.2000000000000000d+00
      JACC(60,13) = SAVE867
      DWCCL(111,13) =
     : DWCCL(111,13)+JACCCCL(60,13)*0.2000000000000000d+00
      JACC(59,50) = SAVE866
      DWCCL(111,50) =
     : DWCCL(111,50)+JACCCCL(59,50)*0.5300000000000000d+00
      JACC(59,13) = SAVE865
      DWCCL(111,13) =
     : DWCCL(111,13)+JACCCCL(59,13)*0.5300000000000000d+00
      JACC(58,50) = SAVE864
      DWCCL(111,50) =
     : DWCCL(111,50)+JACCCCL(58,50)*0.4200000000000000d+00
      JACC(58,13) = SAVE863
      DWCCL(111,13) =
     : DWCCL(111,13)+JACCCCL(58,13)*0.4200000000000000d+00
      JACC(52,50) = SAVE862
      DWCCL(111,50) =
     : DWCCL(111,50)+JACCCCL(52,50)*0.1400000000000000d+00
      JACC(52,13) = SAVE861
      DWCCL(111,13) =
     : DWCCL(111,13)+JACCCCL(52,13)*0.1400000000000000d+00
      JACC(50,50) = SAVE860
      DWCCL(111,50) = DWCCL(111,50)-JACCCCL(50,50)
      JACC(50,13) = SAVE859
      DWCCL(111,13) = DWCCL(111,13)-JACCCCL(50,13)
      JACC(27,50) = SAVE858
      DWCCL(111,50) =
     : DWCCL(111,50)+JACCCCL(27,50)*0.2000000000000000d-01
      JACC(27,13) = SAVE857
      DWCCL(111,13) =
     : DWCCL(111,13)+JACCCCL(27,13)*0.2000000000000000d-01
      JACC(13,50) = SAVE856
      DWCCL(111,50) = DWCCL(111,50)-JACCCCL(13,50)
      JACC(13,13) = SAVE855
      DWCCL(111,13) = DWCCL(111,13)-JACCCCL(13,13)
      JACC(71,50) = SAVE854
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(71,50)*0.3000000000000000d+00
      JACC(71,19) = SAVE853
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(71,19)*0.3000000000000000d+00
      JACC(69,50) = SAVE852
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(69,50)*0.1500000000000000d+00
      JACC(69,19) = SAVE851
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(69,19)*0.1500000000000000d+00
      JACC(66,50) = SAVE850
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(66,50)*0.9000000000000000d+00
      JACC(66,19) = SAVE849
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(66,19)*0.9000000000000000d+00
      JACC(65,50) = SAVE848
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(65,50)*0.1300000000000000d+00
      JACC(65,19) = SAVE847
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(65,19)*0.1300000000000000d+00
      JACC(63,50) = SAVE846
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(63,50)*0.3000000000000000d-01
      JACC(63,19) = SAVE845
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(63,19)*0.3000000000000000d-01
      JACC(62,50) = SAVE844
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(62,50)*0.2800000000000000d+00
      JACC(62,19) = SAVE843
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(62,19)*0.2800000000000000d+00
      JACC(58,50) = SAVE842
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(58,50)*0.2000000000000000d-01
      JACC(58,19) = SAVE841
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(58,19)*0.2000000000000000d-01
      JACC(52,50) = SAVE840
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(52,50)*0.3600000000000000d+00
      JACC(52,19) = SAVE839
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(52,19)*0.3600000000000000d+00
      JACC(50,50) = SAVE838
      DWCCL(110,50) = DWCCL(110,50)-JACCCCL(50,50)
      JACC(50,19) = SAVE837
      DWCCL(110,19) = DWCCL(110,19)-JACCCCL(50,19)
      JACC(49,50) = SAVE836
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(49,50)*0.3900000000000000d+00
      JACC(49,19) = SAVE835
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(49,19)*0.3900000000000000d+00
      JACC(40,50) = SAVE834
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(40,50)*0.3500000000000000d+00
      JACC(40,19) = SAVE833
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(40,19)*0.3500000000000000d+00
      JACC(35,50) = SAVE832
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(35,50)*0.9000000000000000d-01
      JACC(35,19) = SAVE831
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(35,19)*0.9000000000000000d-01
      JACC(34,50) = SAVE830
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(34,50)*0.1500000000000000d+00
      JACC(34,19) = SAVE829
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(34,19)*0.1500000000000000d+00
      JACC(27,50) = SAVE828
      DWCCL(110,50) =
     : DWCCL(110,50)+JACCCCL(27,50)*0.1000000000000000d-02
      JACC(27,19) = SAVE827
      DWCCL(110,19) =
     : DWCCL(110,19)+JACCCCL(27,19)*0.1000000000000000d-02
      JACC(19,50) = SAVE826
      DWCCL(110,50) = DWCCL(110,50)-JACCCCL(19,50)
      JACC(19,19) = SAVE825
      DWCCL(110,19) = DWCCL(110,19)-JACCCCL(19,19)
      JACC(71,50) = SAVE824
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(71,50)*0.3000000000000000d+00
      JACC(71,12) = SAVE823
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(71,12)*0.3000000000000000d+00
      JACC(69,50) = SAVE822
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(69,50)*0.1500000000000000d+00
      JACC(69,12) = SAVE821
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(69,12)*0.1500000000000000d+00
      JACC(66,50) = SAVE820
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(66,50)*0.9000000000000000d+00
      JACC(66,12) = SAVE819
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(66,12)*0.9000000000000000d+00
      JACC(65,50) = SAVE818
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(65,50)*0.1300000000000000d+00
      JACC(65,12) = SAVE817
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(65,12)*0.1300000000000000d+00
      JACC(63,50) = SAVE816
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(63,50)*0.3000000000000000d-01
      JACC(63,12) = SAVE815
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(63,12)*0.3000000000000000d-01
      JACC(62,50) = SAVE814
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(62,50)*0.2800000000000000d+00
      JACC(62,12) = SAVE813
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(62,12)*0.2800000000000000d+00
      JACC(58,50) = SAVE812
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(58,50)*0.2000000000000000d-01
      JACC(58,12) = SAVE811
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(58,12)*0.2000000000000000d-01
      JACC(52,50) = SAVE810
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(52,50)*0.3600000000000000d+00
      JACC(52,12) = SAVE809
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(52,12)*0.3600000000000000d+00
      JACC(50,50) = SAVE808
      DWCCL(109,50) = DWCCL(109,50)-JACCCCL(50,50)
      JACC(50,12) = SAVE807
      DWCCL(109,12) = DWCCL(109,12)-JACCCCL(50,12)
      JACC(49,50) = SAVE806
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(49,50)*0.3900000000000000d+00
      JACC(49,12) = SAVE805
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(49,12)*0.3900000000000000d+00
      JACC(40,50) = SAVE804
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(40,50)*0.3500000000000000d+00
      JACC(40,12) = SAVE803
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(40,12)*0.3500000000000000d+00
      JACC(35,50) = SAVE802
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(35,50)*0.9000000000000000d-01
      JACC(35,12) = SAVE801
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(35,12)*0.9000000000000000d-01
      JACC(34,50) = SAVE800
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(34,50)*0.1500000000000000d+00
      JACC(34,12) = SAVE799
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(34,12)*0.1500000000000000d+00
      JACC(27,50) = SAVE798
      DWCCL(109,50) =
     : DWCCL(109,50)+JACCCCL(27,50)*0.1000000000000000d-02
      JACC(27,12) = SAVE797
      DWCCL(109,12) =
     : DWCCL(109,12)+JACCCCL(27,12)*0.1000000000000000d-02
      JACC(12,50) = SAVE796
      DWCCL(109,50) = DWCCL(109,50)-JACCCCL(12,50)
      JACC(12,12) = SAVE795
      DWCCL(109,12) = DWCCL(109,12)-JACCCCL(12,12)
      JACC(71,50) = SAVE794
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(71,50)*0.2200000000000000d+00
      JACC(71,44) = SAVE793
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(71,44)*0.2200000000000000d+00
      JACC(66,50) = SAVE792
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(66,50)*0.2000000000000000d-01
      JACC(66,44) = SAVE791
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(66,44)*0.2000000000000000d-01
      JACC(63,50) = SAVE790
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(63,50)*0.2300000000000000d+00
      JACC(63,44) = SAVE789
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(63,44)*0.2300000000000000d+00
      JACC(62,50) = SAVE788
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(62,50)*0.6300000000000000d+00
      JACC(62,44) = SAVE787
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(62,44)*0.6300000000000000d+00
      JACC(61,50) = SAVE786
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(61,50)*0.9900000000000000d+00
      JACC(61,44) = SAVE785
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(61,44)*0.9900000000000000d+00
      JACC(60,50) = SAVE784
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(60,50)*0.1800000000000000d+00
      JACC(60,44) = SAVE783
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(60,44)*0.1800000000000000d+00
      JACC(59,50) = SAVE782
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(59,50)*0.1600000000000000d+00
      JACC(59,44) = SAVE781
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(59,44)*0.1600000000000000d+00
      JACC(58,50) = SAVE780
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(58,50)*0.1200000000000000d+00
      JACC(58,44) = SAVE779
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(58,44)*0.1200000000000000d+00
      JACC(57,50) = SAVE778
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(57,50)*0.1400000000000000d+00
      JACC(57,44) = SAVE777
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(57,44)*0.1400000000000000d+00
      JACC(52,50) = SAVE776
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(52,50)*0.3000000000000000d+00
      JACC(52,44) = SAVE775
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(52,44)*0.3000000000000000d+00
      JACC(50,50) = SAVE774
      DWCCL(108,50) = DWCCL(108,50)-JACCCCL(50,50)
      JACC(50,44) = SAVE773
      DWCCL(108,44) = DWCCL(108,44)-JACCCCL(50,44)
      JACC(44,50) = SAVE772
      DWCCL(108,50) = DWCCL(108,50)-JACCCCL(44,50)
      JACC(44,44) = SAVE771
      DWCCL(108,44) = DWCCL(108,44)-JACCCCL(44,44)
      JACC(27,50) = SAVE770
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(27,50)*0.1100000000000000d-01
      JACC(27,44) = SAVE769
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(27,44)*0.1100000000000000d-01
      JACC(21,50) = SAVE768
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(21,50)*0.6000000000000000d-01
      JACC(21,44) = SAVE767
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(21,44)*0.6000000000000000d-01
      JACC(20,50) = SAVE766
      DWCCL(108,50) =
     : DWCCL(108,50)+JACCCCL(20,50)*0.7000000000000001d-01
      JACC(20,44) = SAVE765
      DWCCL(108,44) =
     : DWCCL(108,44)+JACCCCL(20,44)*0.7000000000000001d-01
      JACC(71,50) = SAVE764
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(71,50)*0.2500000000000000d+00
      JACC(71,40) = SAVE763
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(71,40)*0.2500000000000000d+00
      JACC(66,50) = SAVE762
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(66,50)*0.6400000000000000d+00
      JACC(66,40) = SAVE761
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(66,40)*0.6400000000000000d+00
      JACC(63,50) = SAVE760
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(63,50)*0.1900000000000000d+00
      JACC(63,40) = SAVE759
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(63,40)*0.1900000000000000d+00
      JACC(62,50) = SAVE758
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(62,50)*0.4000000000000000d+00
      JACC(62,40) = SAVE757
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(62,40)*0.4000000000000000d+00
      JACC(61,50) = SAVE756
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(61,50)*0.4400000000000000d+00
      JACC(61,40) = SAVE755
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(61,40)*0.4400000000000000d+00
      JACC(60,50) = SAVE754
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(60,50)*0.1000000000000000d+00
      JACC(60,40) = SAVE753
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(60,40)*0.1000000000000000d+00
      JACC(59,50) = SAVE752
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(59,50)*0.3000000000000000d-01
      JACC(59,40) = SAVE751
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(59,40)*0.3000000000000000d-01
      JACC(58,50) = SAVE750
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(58,50)*0.3000000000000000d-01
      JACC(58,40) = SAVE749
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(58,40)*0.3000000000000000d-01
      JACC(57,50) = SAVE748
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(57,50)*0.1000000000000000d+00
      JACC(57,40) = SAVE747
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(57,40)*0.1000000000000000d+00
      JACC(52,50) = SAVE746
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(52,50)*0.3700000000000000d+00
      JACC(52,40) = SAVE745
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(52,40)*0.3700000000000000d+00
      JACC(50,50) = SAVE744
      DWCCL(107,50) = DWCCL(107,50)-JACCCCL(50,50)
      JACC(50,40) = SAVE743
      DWCCL(107,40) = DWCCL(107,40)-JACCCCL(50,40)
      JACC(40,50) = SAVE742
      DWCCL(107,50) = DWCCL(107,50)-JACCCCL(40,50)
      JACC(40,40) = SAVE741
      DWCCL(107,40) = DWCCL(107,40)-JACCCCL(40,40)
      JACC(34,50) = SAVE740
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(34,50)*0.1400000000000000d+00
      JACC(34,40) = SAVE739
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(34,40)*0.1400000000000000d+00
      JACC(27,50) = SAVE738
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(27,50)*0.6000000000000000d-02
      JACC(27,40) = SAVE737
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(27,40)*0.6000000000000000d-02
      JACC(21,50) = SAVE736
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(21,50)*0.3000000000000000d-01
      JACC(21,40) = SAVE735
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(21,40)*0.3000000000000000d-01
      JACC(20,50) = SAVE734
      DWCCL(107,50) =
     : DWCCL(107,50)+JACCCCL(20,50)*0.6000000000000000d-01
      JACC(20,40) = SAVE733
      DWCCL(107,40) =
     : DWCCL(107,40)+JACCCCL(20,40)*0.6000000000000000d-01
      JACC(71,50) = SAVE732
      DWCCL(106,50) =
     : DWCCL(106,50)+JACCCCL(71,50)*0.2600000000000000d+00
      JACC(71,11) = SAVE731
      DWCCL(106,11) =
     : DWCCL(106,11)+JACCCCL(71,11)*0.2600000000000000d+00
      JACC(66,50) = SAVE730
      DWCCL(106,50) = DWCCL(106,50)+JACCCCL(66,50)
      JACC(66,11) = SAVE729
      DWCCL(106,11) = DWCCL(106,11)+JACCCCL(66,11)
      JACC(62,50) = SAVE728
      DWCCL(106,50) =
     : DWCCL(106,50)+JACCCCL(62,50)*0.1200000000000000d+00
      JACC(62,11) = SAVE727
      DWCCL(106,11) =
     : DWCCL(106,11)+JACCCCL(62,11)*0.1200000000000000d+00
      JACC(52,50) = SAVE726
      DWCCL(106,50) =
     : DWCCL(106,50)+JACCCCL(52,50)*0.4300000000000000d+00
      JACC(52,11) = SAVE725
      DWCCL(106,11) =
     : DWCCL(106,11)+JACCCCL(52,11)*0.4300000000000000d+00
      JACC(50,50) = SAVE724
      DWCCL(106,50) = DWCCL(106,50)-JACCCCL(50,50)
      JACC(50,11) = SAVE723
      DWCCL(106,11) = DWCCL(106,11)-JACCCCL(50,11)
      JACC(34,50) = SAVE722
      DWCCL(106,50) =
     : DWCCL(106,50)+JACCCCL(34,50)*0.3700000000000000d+00
      JACC(34,11) = SAVE721
      DWCCL(106,11) =
     : DWCCL(106,11)+JACCCCL(34,11)*0.3700000000000000d+00
      JACC(11,50) = SAVE720
      DWCCL(106,50) = DWCCL(106,50)-JACCCCL(11,50)
      JACC(11,11) = SAVE719
      DWCCL(106,11) = DWCCL(106,11)-JACCCCL(11,11)
      JACC(72,68) = SAVE718
      DWCCL(105,68) =
     : DWCCL(105,68)+JACCCCL(72,68)*0.4000000000000000d+00
      JACC(72,25) = SAVE717
      DWCCL(105,25) =
     : DWCCL(105,25)+JACCCCL(72,25)*0.4000000000000000d+00
      JACC(70,68) = SAVE716
      DWCCL(105,68) =
     : DWCCL(105,68)+JACCCCL(70,68)*0.6000000000000000d+00
      JACC(70,25) = SAVE715
      DWCCL(105,25) =
     : DWCCL(105,25)+JACCCCL(70,25)*0.6000000000000000d+00
      JACC(68,68) = SAVE714
      DWCCL(105,68) =
     : DWCCL(105,68)-JACCCCL(68,68)*0.4000000000000000d+00
      JACC(68,25) = SAVE713
      DWCCL(105,25) =
     : DWCCL(105,25)-JACCCCL(68,25)*0.4000000000000000d+00
      JACC(66,68) = SAVE712
      DWCCL(105,68) =
     : DWCCL(105,68)+JACCCCL(66,68)*0.4000000000000000d+00
      JACC(66,25) = SAVE711
      DWCCL(105,25) =
     : DWCCL(105,25)+JACCCCL(66,25)*0.4000000000000000d+00
      JACC(65,68) = SAVE710
      DWCCL(105,68) = DWCCL(105,68)+JACCCCL(65,68)
      JACC(65,25) = SAVE709
      DWCCL(105,25) = DWCCL(105,25)+JACCCCL(65,25)
      JACC(26,68) = SAVE708
      DWCCL(105,68) =
     : DWCCL(105,68)+JACCCCL(26,68)*0.4000000000000000d+00
      JACC(26,25) = SAVE707
      DWCCL(105,25) =
     : DWCCL(105,25)+JACCCCL(26,25)*0.4000000000000000d+00
      JACC(25,68) = SAVE706
      DWCCL(105,68) = DWCCL(105,68)-JACCCCL(25,68)
      JACC(25,25) = SAVE705
      DWCCL(105,25) = DWCCL(105,25)-JACCCCL(25,25)
      JACC(68,68) = SAVE704
      DWCCL(104,68) = DWCCL(104,68)-JACCCCL(68,68)
      JACC(68,14) = SAVE703
      DWCCL(104,14) = DWCCL(104,14)-JACCCCL(68,14)
      JACC(47,68) = SAVE702
      DWCCL(104,68) =
     : DWCCL(104,68)+JACCCCL(47,68)*0.1300000000000000d+00
      JACC(47,14) = SAVE701
      DWCCL(104,14) =
     : DWCCL(104,14)+JACCCCL(47,14)*0.1300000000000000d+00
      JACC(46,68) = SAVE700
      DWCCL(104,68) =
     : DWCCL(104,68)+JACCCCL(46,68)*0.8700000000000000d+00
      JACC(46,14) = SAVE699
      DWCCL(104,14) =
     : DWCCL(104,14)+JACCCCL(46,14)*0.8700000000000000d+00
      JACC(14,68) = SAVE698
      DWCCL(104,68) = DWCCL(104,68)-JACCCCL(14,68)
      JACC(14,14) = SAVE697
      DWCCL(104,14) = DWCCL(104,14)-JACCCCL(14,14)
      JACC(68,68) = SAVE696
      DWCCL(103,68) = DWCCL(103,68)-JACCCCL(68,68)
      JACC(68,13) = SAVE695
      DWCCL(103,13) = DWCCL(103,13)-JACCCCL(68,13)
      JACC(47,68) = SAVE694
      DWCCL(103,68) =
     : DWCCL(103,68)+JACCCCL(47,68)*0.1000000000000000d+00
      JACC(47,13) = SAVE693
      DWCCL(103,13) =
     : DWCCL(103,13)+JACCCCL(47,13)*0.1000000000000000d+00
      JACC(46,68) = SAVE692
      DWCCL(103,68) =
     : DWCCL(103,68)+JACCCCL(46,68)*0.9000000000000000d+00
      JACC(46,13) = SAVE691
      DWCCL(103,13) =
     : DWCCL(103,13)+JACCCCL(46,13)*0.9000000000000000d+00
      JACC(13,68) = SAVE690
      DWCCL(103,68) = DWCCL(103,68)-JACCCCL(13,68)
      JACC(13,13) = SAVE689
      DWCCL(103,13) = DWCCL(103,13)-JACCCCL(13,13)
      JACC(68,68) = SAVE688
      DWCCL(102,68) = DWCCL(102,68)-JACCCCL(68,68)
      JACC(68,19) = SAVE687
      DWCCL(102,19) = DWCCL(102,19)-JACCCCL(68,19)
      JACC(49,68) = SAVE686
      DWCCL(102,68) =
     : DWCCL(102,68)+JACCCCL(49,68)*0.9000000000000000d+00
      JACC(49,19) = SAVE685
      DWCCL(102,19) =
     : DWCCL(102,19)+JACCCCL(49,19)*0.9000000000000000d+00
      JACC(47,68) = SAVE684
      DWCCL(102,68) =
     : DWCCL(102,68)+JACCCCL(47,68)*0.9000000000000000d+00
      JACC(47,19) = SAVE683
      DWCCL(102,19) =
     : DWCCL(102,19)+JACCCCL(47,19)*0.9000000000000000d+00
      JACC(46,68) = SAVE682
      DWCCL(102,68) =
     : DWCCL(102,68)+JACCCCL(46,68)*0.1000000000000000d+00
      JACC(46,19) = SAVE681
      DWCCL(102,19) =
     : DWCCL(102,19)+JACCCCL(46,19)*0.1000000000000000d+00
      JACC(19,68) = SAVE680
      DWCCL(102,68) = DWCCL(102,68)-JACCCCL(19,68)
      JACC(19,19) = SAVE679
      DWCCL(102,19) = DWCCL(102,19)-JACCCCL(19,19)
      JACC(68,68) = SAVE678
      DWCCL(101,68) = DWCCL(101,68)-JACCCCL(68,68)
      JACC(68,12) = SAVE677
      DWCCL(101,12) = DWCCL(101,12)-JACCCCL(68,12)
      JACC(49,68) = SAVE676
      DWCCL(101,68) =
     : DWCCL(101,68)+JACCCCL(49,68)*0.9000000000000000d+00
      JACC(49,12) = SAVE675
      DWCCL(101,12) =
     : DWCCL(101,12)+JACCCCL(49,12)*0.9000000000000000d+00
      JACC(47,68) = SAVE674
      DWCCL(101,68) =
     : DWCCL(101,68)+JACCCCL(47,68)*0.9000000000000000d+00
      JACC(47,12) = SAVE673
      DWCCL(101,12) =
     : DWCCL(101,12)+JACCCCL(47,12)*0.9000000000000000d+00
      JACC(46,68) = SAVE672
      DWCCL(101,68) =
     : DWCCL(101,68)+JACCCCL(46,68)*0.1000000000000000d+00
      JACC(46,12) = SAVE671
      DWCCL(101,12) =
     : DWCCL(101,12)+JACCCCL(46,12)*0.1000000000000000d+00
      JACC(12,68) = SAVE670
      DWCCL(101,68) = DWCCL(101,68)-JACCCCL(12,68)
      JACC(12,12) = SAVE669
      DWCCL(101,12) = DWCCL(101,12)-JACCCCL(12,12)
      JACC(68,68) = SAVE668
      DWCCL(100,68) = DWCCL(100,68)-JACCCCL(68,68)
      JACC(68,44) = SAVE667
      DWCCL(100,44) = DWCCL(100,44)-JACCCCL(68,44)
      JACC(47,68) = SAVE666
      DWCCL(100,68) =
     : DWCCL(100,68)+JACCCCL(47,68)*0.1100000000000000d+00
      JACC(47,44) = SAVE665
      DWCCL(100,44) =
     : DWCCL(100,44)+JACCCCL(47,44)*0.1100000000000000d+00
      JACC(46,68) = SAVE664
      DWCCL(100,68) =
     : DWCCL(100,68)+JACCCCL(46,68)*0.8900000000000000d+00
      JACC(46,44) = SAVE663
      DWCCL(100,44) =
     : DWCCL(100,44)+JACCCCL(46,44)*0.8900000000000000d+00
      JACC(44,68) = SAVE662
      DWCCL(100,68) = DWCCL(100,68)-JACCCCL(44,68)
      JACC(44,44) = SAVE661
      DWCCL(100,44) = DWCCL(100,44)-JACCCCL(44,44)
      JACC(68,68) = SAVE660
      DWCCL(99,68) = DWCCL(99,68)-JACCCCL(68,68)
      JACC(68,40) = SAVE659
      DWCCL(99,40) = DWCCL(99,40)-JACCCCL(68,40)
      JACC(47,68) = SAVE658
      DWCCL(99,68) = DWCCL(99,68)+JACCCCL(47,68)*0.4300000000000000d+00
      JACC(47,40) = SAVE657
      DWCCL(99,40) = DWCCL(99,40)+JACCCCL(47,40)*0.4300000000000000d+00
      JACC(46,68) = SAVE656
      DWCCL(99,68) = DWCCL(99,68)+JACCCCL(46,68)*0.5700000000000000d+00
      JACC(46,40) = SAVE655
      DWCCL(99,40) = DWCCL(99,40)+JACCCCL(46,40)*0.5700000000000000d+00
      JACC(40,68) = SAVE654
      DWCCL(99,68) = DWCCL(99,68)-JACCCCL(40,68)
      JACC(40,40) = SAVE653
      DWCCL(99,40) = DWCCL(99,40)-JACCCCL(40,40)
      JACC(68,68) = SAVE652
      DWCCL(98,68) = DWCCL(98,68)-JACCCCL(68,68)
      JACC(68,11) = SAVE651
      DWCCL(98,11) = DWCCL(98,11)-JACCCCL(68,11)
      JACC(47,68) = SAVE650
      DWCCL(98,68) = DWCCL(98,68)+JACCCCL(47,68)*0.8000000000000000d+00
      JACC(47,11) = SAVE649
      DWCCL(98,11) = DWCCL(98,11)+JACCCCL(47,11)*0.8000000000000000d+00
      JACC(46,68) = SAVE648
      DWCCL(98,68) = DWCCL(98,68)+JACCCCL(46,68)*0.2000000000000000d+00
      JACC(46,11) = SAVE647
      DWCCL(98,11) = DWCCL(98,11)+JACCCCL(46,11)*0.2000000000000000d+00
      JACC(11,68) = SAVE646
      DWCCL(98,68) = DWCCL(98,68)-JACCCCL(11,68)
      JACC(11,11) = SAVE645
      DWCCL(98,11) = DWCCL(98,11)-JACCCCL(11,11)
      JACC(68,68) = SAVE644
      DWCCL(97,68) = DWCCL(97,68)-JACCCCL(68,68)
      JACC(68,30) = SAVE643
      DWCCL(97,30) = DWCCL(97,30)-JACCCCL(68,30)
      JACC(55,68) = SAVE642
      DWCCL(97,68) = DWCCL(97,68)+JACCCCL(55,68)
      JACC(55,30) = SAVE641
      DWCCL(97,30) = DWCCL(97,30)+JACCCCL(55,30)
      JACC(30,68) = SAVE640
      DWCCL(97,68) = DWCCL(97,68)-JACCCCL(30,68)
      JACC(30,30) = SAVE639
      DWCCL(97,30) = DWCCL(97,30)-JACCCCL(30,30)
      JACC(29,68) = SAVE638
      DWCCL(97,68) = DWCCL(97,68)+JACCCCL(29,68)
      JACC(29,30) = SAVE637
      DWCCL(97,30) = DWCCL(97,30)+JACCCCL(29,30)
      JACC(72,68) = SAVE636
      DWCCL(96,68) = DWCCL(96,68)+JACCCCL(72,68)*0.5000000000000000d+00
      JACC(72,48) = SAVE635
      DWCCL(96,48) = DWCCL(96,48)+JACCCCL(72,48)*0.5000000000000000d+00
      JACC(71,68) = SAVE634
      DWCCL(96,68) = DWCCL(96,68)+JACCCCL(71,68)*0.5000000000000000d+00
      JACC(71,48) = SAVE633
      DWCCL(96,48) = DWCCL(96,48)+JACCCCL(71,48)*0.5000000000000000d+00
      JACC(68,68) = SAVE632
      DWCCL(96,68) = DWCCL(96,68)-JACCCCL(68,68)
      JACC(68,48) = SAVE631
      DWCCL(96,48) = DWCCL(96,48)-JACCCCL(68,48)
      JACC(65,68) = SAVE630
      DWCCL(96,68) = DWCCL(96,68)+JACCCCL(65,68)*0.5000000000000000d+00
      JACC(65,48) = SAVE629
      DWCCL(96,48) = DWCCL(96,48)+JACCCCL(65,48)*0.5000000000000000d+00
      JACC(61,68) = SAVE628
      DWCCL(96,68) = DWCCL(96,68)+JACCCCL(61,68)*0.2500000000000000d+00
      JACC(61,48) = SAVE627
      DWCCL(96,48) = DWCCL(96,48)+JACCCCL(61,48)*0.2500000000000000d+00
      JACC(59,68) = SAVE626
      DWCCL(96,68) = DWCCL(96,68)+JACCCCL(59,68)*0.3000000000000000d-01
      JACC(59,48) = SAVE625
      DWCCL(96,48) = DWCCL(96,48)+JACCCCL(59,48)*0.3000000000000000d-01
      JACC(56,68) = SAVE624
      DWCCL(96,68) = DWCCL(96,68)+JACCCCL(56,68)*0.5000000000000000d+00
      JACC(56,48) = SAVE623
      DWCCL(96,48) = DWCCL(96,48)+JACCCCL(56,48)*0.5000000000000000d+00
      JACC(55,68) = SAVE622
      DWCCL(96,68) = DWCCL(96,68)+JACCCCL(55,68)*0.5000000000000000d+00
      JACC(55,48) = SAVE621
      DWCCL(96,48) = DWCCL(96,48)+JACCCCL(55,48)*0.5000000000000000d+00
      JACC(54,68) = SAVE620
      DWCCL(96,68) = DWCCL(96,68)+JACCCCL(54,68)*0.2500000000000000d+00
      JACC(54,48) = SAVE619
      DWCCL(96,48) = DWCCL(96,48)+JACCCCL(54,48)*0.2500000000000000d+00
      JACC(51,68) = SAVE618
      DWCCL(96,68) = DWCCL(96,68)+JACCCCL(51,68)*0.2500000000000000d+00
      JACC(51,48) = SAVE617
      DWCCL(96,48) = DWCCL(96,48)+JACCCCL(51,48)*0.2500000000000000d+00
      JACC(48,68) = SAVE616
      DWCCL(96,68) = DWCCL(96,68)-JACCCCL(48,68)
      JACC(48,48) = SAVE615
      DWCCL(96,48) = DWCCL(96,48)-JACCCCL(48,48)
      JACC(68,68) = SAVE614
      DWCCL(95,68) = DWCCL(95,68)-JACCCCL(68,68)
      JACC(68,49) = SAVE613
      DWCCL(95,49) = DWCCL(95,49)-JACCCCL(68,49)
      JACC(56,68) = SAVE612
      DWCCL(95,68) = DWCCL(95,68)+JACCCCL(56,68)*0.2000000000000000d+00
      JACC(56,49) = SAVE611
      DWCCL(95,49) = DWCCL(95,49)+JACCCCL(56,49)*0.2000000000000000d+00
      JACC(55,68) = SAVE610
      DWCCL(95,68) = DWCCL(95,68)+JACCCCL(55,68)*0.2000000000000000d+00
      JACC(55,49) = SAVE609
      DWCCL(95,49) = DWCCL(95,49)+JACCCCL(55,49)*0.2000000000000000d+00
      JACC(52,68) = SAVE608
      DWCCL(95,68) = DWCCL(95,68)+JACCCCL(52,68)*0.8000000000000000d+00
      JACC(52,49) = SAVE607
      DWCCL(95,49) = DWCCL(95,49)+JACCCCL(52,49)*0.8000000000000000d+00
      JACC(49,68) = SAVE606
      DWCCL(95,68) = DWCCL(95,68)-JACCCCL(49,68)
      JACC(49,49) = SAVE605
      DWCCL(95,49) = DWCCL(95,49)-JACCCCL(49,49)
      JACC(47,68) = SAVE604
      DWCCL(95,68) = DWCCL(95,68)+JACCCCL(47,68)*0.8000000000000000d+00
      JACC(47,49) = SAVE603
      DWCCL(95,49) = DWCCL(95,49)+JACCCCL(47,49)*0.8000000000000000d+00
      JACC(69,68) = SAVE602
      DWCCL(94,68) = DWCCL(94,68)+JACCCCL(69,68)
      JACC(69,54) = SAVE601
      DWCCL(94,54) = DWCCL(94,54)+JACCCCL(69,54)
      JACC(68,68) = SAVE600
      DWCCL(94,68) = DWCCL(94,68)-JACCCCL(68,68)
      JACC(68,54) = SAVE599
      DWCCL(94,54) = DWCCL(94,54)-JACCCCL(68,54)
      JACC(55,68) = SAVE598
      DWCCL(94,68) = DWCCL(94,68)+JACCCCL(55,68)
      JACC(55,54) = SAVE597
      DWCCL(94,54) = DWCCL(94,54)+JACCCCL(55,54)
      JACC(54,68) = SAVE596
      DWCCL(94,68) = DWCCL(94,68)-JACCCCL(54,68)
      JACC(54,54) = SAVE595
      DWCCL(94,54) = DWCCL(94,54)-JACCCCL(54,54)
      JACC(52,68) = SAVE594
      DWCCL(94,68) = DWCCL(94,68)+JACCCCL(52,68)
      JACC(52,54) = SAVE593
      DWCCL(94,54) = DWCCL(94,54)+JACCCCL(52,54)
      JACC(71,68) = SAVE592
      DWCCL(93,68) = DWCCL(93,68)+JACCCCL(71,68)
      JACC(71,51) = SAVE591
      DWCCL(93,51) = DWCCL(93,51)+JACCCCL(71,51)
      JACC(68,68) = SAVE590
      DWCCL(93,68) = DWCCL(93,68)-JACCCCL(68,68)
      JACC(68,51) = SAVE589
      DWCCL(93,51) = DWCCL(93,51)-JACCCCL(68,51)
      JACC(55,68) = SAVE588
      DWCCL(93,68) = DWCCL(93,68)+JACCCCL(55,68)
      JACC(55,51) = SAVE587
      DWCCL(93,51) = DWCCL(93,51)+JACCCCL(55,51)
      JACC(52,68) = SAVE586
      DWCCL(93,68) = DWCCL(93,68)+JACCCCL(52,68)*0.2000000000000000d+01
      JACC(52,51) = SAVE585
      DWCCL(93,51) = DWCCL(93,51)+JACCCCL(52,51)*0.2000000000000000d+01
      JACC(51,68) = SAVE584
      DWCCL(93,68) = DWCCL(93,68)-JACCCCL(51,68)
      JACC(51,51) = SAVE583
      DWCCL(93,51) = DWCCL(93,51)-JACCCCL(51,51)
      JACC(69,68) = SAVE582
      DWCCL(92,68) = DWCCL(92,68)+JACCCCL(69,68)
      JACC(69,61) = SAVE581
      DWCCL(92,61) = DWCCL(92,61)+JACCCCL(69,61)
      JACC(68,68) = SAVE580
      DWCCL(92,68) = DWCCL(92,68)-JACCCCL(68,68)
      JACC(68,61) = SAVE579
      DWCCL(92,61) = DWCCL(92,61)-JACCCCL(68,61)
      JACC(61,68) = SAVE578
      DWCCL(92,68) = DWCCL(92,68)-JACCCCL(61,68)
      JACC(61,61) = SAVE577
      DWCCL(92,61) = DWCCL(92,61)-JACCCCL(61,61)
      JACC(55,68) = SAVE576
      DWCCL(92,68) = DWCCL(92,68)+JACCCCL(55,68)
      JACC(55,61) = SAVE575
      DWCCL(92,61) = DWCCL(92,61)+JACCCCL(55,61)
      JACC(71,68) = SAVE574
      DWCCL(91,68) = DWCCL(91,68)+JACCCCL(71,68)
      JACC(71,66) = SAVE573
      DWCCL(91,66) = DWCCL(91,66)+JACCCCL(71,66)
      JACC(68,68) = SAVE572
      DWCCL(91,68) = DWCCL(91,68)-JACCCCL(68,68)
      JACC(68,66) = SAVE571
      DWCCL(91,66) = DWCCL(91,66)-JACCCCL(68,66)
      JACC(66,68) = SAVE570
      DWCCL(91,68) = DWCCL(91,68)-JACCCCL(66,68)
      JACC(66,66) = SAVE569
      DWCCL(91,66) = DWCCL(91,66)-JACCCCL(66,66)
      JACC(55,68) = SAVE568
      DWCCL(91,68) = DWCCL(91,68)+JACCCCL(55,68)
      JACC(55,66) = SAVE567
      DWCCL(91,66) = DWCCL(91,66)+JACCCCL(55,66)
      JACC(52,68) = SAVE566
      DWCCL(91,68) = DWCCL(91,68)+JACCCCL(52,68)
      JACC(52,66) = SAVE565
      DWCCL(91,66) = DWCCL(91,66)+JACCCCL(52,66)
      JACC(72,62) = SAVE564
      DWCCL(90,62) = DWCCL(90,62)+JACCCCL(72,62)
      JACC(72,70) = SAVE563
      DWCCL(90,70) = DWCCL(90,70)+JACCCCL(72,70)
      JACC(70,62) = SAVE562
      DWCCL(90,62) = DWCCL(90,62)-JACCCCL(70,62)
      JACC(70,70) = SAVE561
      DWCCL(90,70) = DWCCL(90,70)-JACCCCL(70,70)
      JACC(64,62) = SAVE560
      DWCCL(90,62) = DWCCL(90,62)+JACCCCL(64,62)
      JACC(64,70) = SAVE559
      DWCCL(90,70) = DWCCL(90,70)+JACCCCL(64,70)
      JACC(62,62) = SAVE558
      DWCCL(90,62) = DWCCL(90,62)-JACCCCL(62,62)
      JACC(62,70) = SAVE557
      DWCCL(90,70) = DWCCL(90,70)-JACCCCL(62,70)
      JACC(71,62) = SAVE556
      DWCCL(89,62) = DWCCL(89,62)+JACCCCL(71,62)*0.4000000000000000d+00
      JACC(71,25) = SAVE555
      DWCCL(89,25) = DWCCL(89,25)+JACCCCL(71,25)*0.4000000000000000d+00
      JACC(68,62) = SAVE554
      DWCCL(89,62) = DWCCL(89,62)+JACCCCL(68,62)*0.6000000000000000d+00
      JACC(68,25) = SAVE553
      DWCCL(89,25) = DWCCL(89,25)+JACCCCL(68,25)*0.6000000000000000d+00
      JACC(66,62) = SAVE552
      DWCCL(89,62) = DWCCL(89,62)+JACCCCL(66,62)*0.4000000000000000d+00
      JACC(66,25) = SAVE551
      DWCCL(89,25) = DWCCL(89,25)+JACCCCL(66,25)*0.4000000000000000d+00
      JACC(65,62) = SAVE550
      DWCCL(89,62) = DWCCL(89,62)+JACCCCL(65,62)
      JACC(65,25) = SAVE549
      DWCCL(89,25) = DWCCL(89,25)+JACCCCL(65,25)
      JACC(62,62) = SAVE548
      DWCCL(89,62) = DWCCL(89,62)-JACCCCL(62,62)
      JACC(62,25) = SAVE547
      DWCCL(89,25) = DWCCL(89,25)-JACCCCL(62,25)
      JACC(26,62) = SAVE546
      DWCCL(89,62) = DWCCL(89,62)+JACCCCL(26,62)*0.4000000000000000d+00
      JACC(26,25) = SAVE545
      DWCCL(89,25) = DWCCL(89,25)+JACCCCL(26,25)*0.4000000000000000d+00
      JACC(25,62) = SAVE544
      DWCCL(89,62) = DWCCL(89,62)-JACCCCL(25,62)
      JACC(25,25) = SAVE543
      DWCCL(89,25) = DWCCL(89,25)-JACCCCL(25,25)
      JACC(24,62) = SAVE542
      DWCCL(89,62) = DWCCL(89,62)+JACCCCL(24,62)*0.6000000000000000d+00
      JACC(24,25) = SAVE541
      DWCCL(89,25) = DWCCL(89,25)+JACCCCL(24,25)*0.6000000000000000d+00
      JACC(68,62) = SAVE540
      DWCCL(88,62) = DWCCL(88,62)+JACCCCL(68,62)
      JACC(68,26) = SAVE539
      DWCCL(88,26) = DWCCL(88,26)+JACCCCL(68,26)
      JACC(66,62) = SAVE538
      DWCCL(88,62) = DWCCL(88,62)+JACCCCL(66,62)
      JACC(66,26) = SAVE537
      DWCCL(88,26) = DWCCL(88,26)+JACCCCL(66,26)
      JACC(65,62) = SAVE536
      DWCCL(88,62) = DWCCL(88,62)+JACCCCL(65,62)
      JACC(65,26) = SAVE535
      DWCCL(88,26) = DWCCL(88,26)+JACCCCL(65,26)
      JACC(62,62) = SAVE534
      DWCCL(88,62) = DWCCL(88,62)-JACCCCL(62,62)
      JACC(62,26) = SAVE533
      DWCCL(88,26) = DWCCL(88,26)-JACCCCL(62,26)
      JACC(26,62) = SAVE532
      DWCCL(88,62) = DWCCL(88,62)-JACCCCL(26,62)
      JACC(26,26) = SAVE531
      DWCCL(88,26) = DWCCL(88,26)-JACCCCL(26,26)
      JACC(71,62) = SAVE530
      DWCCL(87,62) = DWCCL(87,62)+JACCCCL(71,62)*0.3500000000000000d+00
      JACC(71,28) = SAVE529
      DWCCL(87,28) = DWCCL(87,28)+JACCCCL(71,28)*0.3500000000000000d+00
      JACC(69,62) = SAVE528
      DWCCL(87,62) = DWCCL(87,62)+JACCCCL(69,62)*0.6500000000000000d+00
      JACC(69,28) = SAVE527
      DWCCL(87,28) = DWCCL(87,28)+JACCCCL(69,28)*0.6500000000000000d+00
      JACC(66,62) = SAVE526
      DWCCL(87,62) = DWCCL(87,62)+JACCCCL(66,62)*0.3500000000000000d+00
      JACC(66,28) = SAVE525
      DWCCL(87,28) = DWCCL(87,28)+JACCCCL(66,28)*0.3500000000000000d+00
      JACC(65,62) = SAVE524
      DWCCL(87,62) = DWCCL(87,62)+JACCCCL(65,62)*0.3500000000000000d+00
      JACC(65,28) = SAVE523
      DWCCL(87,28) = DWCCL(87,28)+JACCCCL(65,28)*0.3500000000000000d+00
      JACC(62,62) = SAVE522
      DWCCL(87,62) = DWCCL(87,62)-JACCCCL(62,62)
      JACC(62,28) = SAVE521
      DWCCL(87,28) = DWCCL(87,28)-JACCCCL(62,28)
      JACC(28,62) = SAVE520
      DWCCL(87,62) = DWCCL(87,62)-JACCCCL(28,62)
      JACC(28,28) = SAVE519
      DWCCL(87,28) = DWCCL(87,28)-JACCCCL(28,28)
      JACC(65,62) = SAVE518
      DWCCL(86,62) = DWCCL(86,62)+JACCCCL(65,62)*0.7000000000000001d-01
      JACC(65,53) = SAVE517
      DWCCL(86,53) = DWCCL(86,53)+JACCCCL(65,53)*0.7000000000000001d-01
      JACC(64,62) = SAVE516
      DWCCL(86,62) = DWCCL(86,62)+JACCCCL(64,62)*0.4400000000000000d+00
      JACC(64,53) = SAVE515
      DWCCL(86,53) = DWCCL(86,53)+JACCCCL(64,53)*0.4400000000000000d+00
      JACC(62,62) = SAVE514
      DWCCL(86,62) = DWCCL(86,62)-JACCCCL(62,62)*0.5100000000000000d+00
      JACC(62,53) = SAVE513
      DWCCL(86,53) = DWCCL(86,53)-JACCCCL(62,53)*0.5100000000000000d+00
      JACC(61,62) = SAVE512
      DWCCL(86,62) = DWCCL(86,62)+JACCCCL(61,62)*0.8000000000000000d-01
      JACC(61,53) = SAVE511
      DWCCL(86,53) = DWCCL(86,53)+JACCCCL(61,53)*0.8000000000000000d-01
      JACC(59,62) = SAVE510
      DWCCL(86,62) = DWCCL(86,62)+JACCCCL(59,62)*0.4100000000000000d+00
      JACC(59,53) = SAVE509
      DWCCL(86,53) = DWCCL(86,53)+JACCCCL(59,53)*0.4100000000000000d+00
      JACC(53,62) = SAVE508
      DWCCL(86,62) = DWCCL(86,62)-JACCCCL(53,62)
      JACC(53,53) = SAVE507
      DWCCL(86,53) = DWCCL(86,53)-JACCCCL(53,53)
      JACC(66,62) = SAVE506
      DWCCL(85,62) = DWCCL(85,62)+JACCCCL(66,62)*0.3500000000000000d+00
      JACC(66,16) = SAVE505
      DWCCL(85,16) = DWCCL(85,16)+JACCCCL(66,16)*0.3500000000000000d+00
      JACC(63,62) = SAVE504
      DWCCL(85,62) = DWCCL(85,62)+JACCCCL(63,62)*0.6500000000000000d+00
      JACC(63,16) = SAVE503
      DWCCL(85,16) = DWCCL(85,16)+JACCCCL(63,16)*0.6500000000000000d+00
      JACC(62,62) = SAVE502
      DWCCL(85,62) = DWCCL(85,62)-JACCCCL(62,62)*0.6500000000000000d+00
      JACC(62,16) = SAVE501
      DWCCL(85,16) = DWCCL(85,16)-JACCCCL(62,16)*0.6500000000000000d+00
      JACC(16,62) = SAVE500
      DWCCL(85,62) = DWCCL(85,62)-JACCCCL(16,62)
      JACC(16,16) = SAVE499
      DWCCL(85,16) = DWCCL(85,16)-JACCCCL(16,16)
      JACC(71,10) = SAVE498
      DWCCL(84,10) = DWCCL(84,10)+JACCCCL(71,10)
      JACC(71,62) = SAVE497
      DWCCL(84,62) = DWCCL(84,62)+JACCCCL(71,62)
      JACC(62,10) = SAVE496
      DWCCL(84,10) = DWCCL(84,10)-JACCCCL(62,10)
      JACC(62,62) = SAVE495
      DWCCL(84,62) = DWCCL(84,62)-JACCCCL(62,62)
      JACC(61,10) = SAVE494
      DWCCL(84,10) = DWCCL(84,10)+JACCCCL(61,10)*0.8800000000000000d+00
      JACC(61,62) = SAVE493
      DWCCL(84,62) = DWCCL(84,62)+JACCCCL(61,62)*0.8800000000000000d+00
      JACC(59,10) = SAVE492
      DWCCL(84,10) = DWCCL(84,10)+JACCCCL(59,10)*0.1200000000000000d+00
      JACC(59,62) = SAVE491
      DWCCL(84,62) = DWCCL(84,62)+JACCCCL(59,62)*0.1200000000000000d+00
      JACC(10,10) = SAVE490
      DWCCL(84,10) = DWCCL(84,10)-JACCCCL(10,10)
      JACC(10,62) = SAVE489
      DWCCL(84,62) = DWCCL(84,62)-JACCCCL(10,62)
      JACC(71,48) = SAVE488
      DWCCL(83,48) = DWCCL(83,48)+JACCCCL(71,48)*0.5000000000000000d+00
      JACC(71,62) = SAVE487
      DWCCL(83,62) = DWCCL(83,62)+JACCCCL(71,62)*0.5000000000000000d+00
      JACC(65,48) = SAVE486
      DWCCL(83,48) = DWCCL(83,48)+JACCCCL(65,48)*0.5000000000000000d+00
      JACC(65,62) = SAVE485
      DWCCL(83,62) = DWCCL(83,62)+JACCCCL(65,62)*0.5000000000000000d+00
      JACC(62,48) = SAVE484
      DWCCL(83,48) = DWCCL(83,48)-JACCCCL(62,48)
      JACC(62,62) = SAVE483
      DWCCL(83,62) = DWCCL(83,62)-JACCCCL(62,62)
      JACC(56,48) = SAVE482
      DWCCL(83,48) = DWCCL(83,48)+JACCCCL(56,48)*0.5000000000000000d+00
      JACC(56,62) = SAVE481
      DWCCL(83,62) = DWCCL(83,62)+JACCCCL(56,62)*0.5000000000000000d+00
      JACC(54,48) = SAVE480
      DWCCL(83,48) = DWCCL(83,48)+JACCCCL(54,48)*0.1500000000000000d+00
      JACC(54,62) = SAVE479
      DWCCL(83,62) = DWCCL(83,62)+JACCCCL(54,62)*0.1500000000000000d+00
      JACC(51,48) = SAVE478
      DWCCL(83,48) = DWCCL(83,48)+JACCCCL(51,48)*0.1500000000000000d+00
      JACC(51,62) = SAVE477
      DWCCL(83,62) = DWCCL(83,62)+JACCCCL(51,62)*0.1500000000000000d+00
      JACC(48,48) = SAVE476
      DWCCL(83,48) = DWCCL(83,48)-JACCCCL(48,48)
      JACC(48,62) = SAVE475
      DWCCL(83,62) = DWCCL(83,62)-JACCCCL(48,62)
      JACC(10,48) = SAVE474
      DWCCL(83,48) = DWCCL(83,48)+JACCCCL(10,48)*0.3500000000000000d+00
      JACC(10,62) = SAVE473
      DWCCL(83,62) = DWCCL(83,62)+JACCCCL(10,62)*0.3500000000000000d+00
      JACC(71,62) = SAVE472
      DWCCL(82,62) = DWCCL(82,62)+JACCCCL(71,62)*0.4900000000000000d+00
      JACC(71,49) = SAVE471
      DWCCL(82,49) = DWCCL(82,49)+JACCCCL(71,49)*0.4900000000000000d+00
      JACC(66,62) = SAVE470
      DWCCL(82,62) = DWCCL(82,62)+JACCCCL(66,62)*0.8000000000000000d-01
      JACC(66,49) = SAVE469
      DWCCL(82,49) = DWCCL(82,49)+JACCCCL(66,49)*0.8000000000000000d-01
      JACC(65,62) = SAVE468
      DWCCL(82,62) = DWCCL(82,62)+JACCCCL(65,62)*0.4900000000000000d+00
      JACC(65,49) = SAVE467
      DWCCL(82,49) = DWCCL(82,49)+JACCCCL(65,49)*0.4900000000000000d+00
      JACC(62,62) = SAVE466
      DWCCL(82,62) = DWCCL(82,62)-JACCCCL(62,62)
      JACC(62,49) = SAVE465
      DWCCL(82,49) = DWCCL(82,49)-JACCCCL(62,49)
      JACC(56,62) = SAVE464
      DWCCL(82,62) = DWCCL(82,62)+JACCCCL(56,62)*0.5100000000000000d+00
      JACC(56,49) = SAVE463
      DWCCL(82,49) = DWCCL(82,49)+JACCCCL(56,49)*0.5100000000000000d+00
      JACC(54,62) = SAVE462
      DWCCL(82,62) = DWCCL(82,62)+JACCCCL(54,62)*0.8000000000000000d-01
      JACC(54,49) = SAVE461
      DWCCL(82,49) = DWCCL(82,49)+JACCCCL(54,49)*0.8000000000000000d-01
      JACC(52,62) = SAVE460
      DWCCL(82,62) = DWCCL(82,62)+JACCCCL(52,62)*0.4100000000000000d+00
      JACC(52,49) = SAVE459
      DWCCL(82,49) = DWCCL(82,49)+JACCCCL(52,49)*0.4100000000000000d+00
      JACC(49,62) = SAVE458
      DWCCL(82,62) = DWCCL(82,62)-JACCCCL(49,62)
      JACC(49,49) = SAVE457
      DWCCL(82,49) = DWCCL(82,49)-JACCCCL(49,49)
      JACC(24,62) = SAVE456
      DWCCL(82,62) = DWCCL(82,62)+JACCCCL(24,62)*0.4100000000000000d+00
      JACC(24,49) = SAVE455
      DWCCL(82,49) = DWCCL(82,49)+JACCCCL(24,49)*0.4100000000000000d+00
      JACC(69,62) = SAVE454
      DWCCL(81,62) = DWCCL(81,62)+JACCCCL(69,62)
      JACC(69,54) = SAVE453
      DWCCL(81,54) = DWCCL(81,54)+JACCCCL(69,54)
      JACC(62,62) = SAVE452
      DWCCL(81,62) = DWCCL(81,62)-JACCCCL(62,62)
      JACC(62,54) = SAVE451
      DWCCL(81,54) = DWCCL(81,54)-JACCCCL(62,54)
      JACC(54,62) = SAVE450
      DWCCL(81,62) = DWCCL(81,62)-JACCCCL(54,62)
      JACC(54,54) = SAVE449
      DWCCL(81,54) = DWCCL(81,54)-JACCCCL(54,54)
      JACC(52,62) = SAVE448
      DWCCL(81,62) = DWCCL(81,62)+JACCCCL(52,62)
      JACC(52,54) = SAVE447
      DWCCL(81,54) = DWCCL(81,54)+JACCCCL(52,54)
      JACC(71,62) = SAVE446
      DWCCL(80,62) = DWCCL(80,62)+JACCCCL(71,62)
      JACC(71,51) = SAVE445
      DWCCL(80,51) = DWCCL(80,51)+JACCCCL(71,51)
      JACC(62,62) = SAVE444
      DWCCL(80,62) = DWCCL(80,62)-JACCCCL(62,62)
      JACC(62,51) = SAVE443
      DWCCL(80,51) = DWCCL(80,51)-JACCCCL(62,51)
      JACC(52,62) = SAVE442
      DWCCL(80,62) = DWCCL(80,62)+JACCCCL(52,62)*0.2000000000000000d+01
      JACC(52,51) = SAVE441
      DWCCL(80,51) = DWCCL(80,51)+JACCCCL(52,51)*0.2000000000000000d+01
      JACC(51,62) = SAVE440
      DWCCL(80,62) = DWCCL(80,62)-JACCCCL(51,62)
      JACC(51,51) = SAVE439
      DWCCL(80,51) = DWCCL(80,51)-JACCCCL(51,51)
      JACC(71,62) = SAVE438
      DWCCL(79,62) = DWCCL(79,62)+JACCCCL(71,62)
      JACC(71,24) = SAVE437
      DWCCL(79,24) = DWCCL(79,24)+JACCCCL(71,24)
      JACC(62,62) = SAVE436
      DWCCL(79,62) = DWCCL(79,62)-JACCCCL(62,62)
      JACC(62,24) = SAVE435
      DWCCL(79,24) = DWCCL(79,24)-JACCCCL(62,24)
      JACC(54,62) = SAVE434
      DWCCL(79,62) = DWCCL(79,62)+JACCCCL(54,62)
      JACC(54,24) = SAVE433
      DWCCL(79,24) = DWCCL(79,24)+JACCCCL(54,24)
      JACC(24,62) = SAVE432
      DWCCL(79,62) = DWCCL(79,62)-JACCCCL(24,62)
      JACC(24,24) = SAVE431
      DWCCL(79,24) = DWCCL(79,24)-JACCCCL(24,24)
      JACC(62,62) = SAVE430
      DWCCL(78,62) = DWCCL(78,62)-JACCCCL(62,62)
      JACC(62,59) = SAVE429
      DWCCL(78,59) = DWCCL(78,59)-JACCCCL(62,59)
      JACC(59,62) = SAVE428
      DWCCL(78,62) = DWCCL(78,62)-JACCCCL(59,62)
      JACC(59,59) = SAVE427
      DWCCL(78,59) = DWCCL(78,59)-JACCCCL(59,59)
      JACC(58,62) = SAVE426
      DWCCL(78,62) = DWCCL(78,62)+JACCCCL(58,62)
      JACC(58,59) = SAVE425
      DWCCL(78,59) = DWCCL(78,59)+JACCCCL(58,59)
      JACC(69,62) = SAVE424
      DWCCL(77,62) = DWCCL(77,62)+JACCCCL(69,62)
      JACC(69,61) = SAVE423
      DWCCL(77,61) = DWCCL(77,61)+JACCCCL(69,61)
      JACC(62,62) = SAVE422
      DWCCL(77,62) = DWCCL(77,62)-JACCCCL(62,62)
      JACC(62,61) = SAVE421
      DWCCL(77,61) = DWCCL(77,61)-JACCCCL(62,61)
      JACC(61,62) = SAVE420
      DWCCL(77,62) = DWCCL(77,62)-JACCCCL(61,62)
      JACC(61,61) = SAVE419
      DWCCL(77,61) = DWCCL(77,61)-JACCCCL(61,61)
      JACC(71,62) = SAVE418
      DWCCL(76,62) = DWCCL(76,62)+JACCCCL(71,62)
      JACC(71,66) = SAVE417
      DWCCL(76,66) = DWCCL(76,66)+JACCCCL(71,66)
      JACC(66,62) = SAVE416
      DWCCL(76,62) = DWCCL(76,62)-JACCCCL(66,62)
      JACC(66,66) = SAVE415
      DWCCL(76,66) = DWCCL(76,66)-JACCCCL(66,66)
      JACC(62,62) = SAVE414
      DWCCL(76,62) = DWCCL(76,62)-JACCCCL(62,62)
      JACC(62,66) = SAVE413
      DWCCL(76,66) = DWCCL(76,66)-JACCCCL(62,66)
      JACC(52,62) = SAVE412
      DWCCL(76,62) = DWCCL(76,62)+JACCCCL(52,62)
      JACC(52,66) = SAVE411
      DWCCL(76,66) = DWCCL(76,66)+JACCCCL(52,66)
      JACC(71,62) = SAVE410
      DWCCL(75,62) = DWCCL(75,62)+JACCCCL(71,62)*0.5000000000000000d-01
      JACC(71,30) = SAVE409
      DWCCL(75,30) = DWCCL(75,30)+JACCCCL(71,30)*0.5000000000000000d-01
      JACC(65,62) = SAVE408
      DWCCL(75,62) = DWCCL(75,62)+JACCCCL(65,62)*0.5000000000000000d-01
      JACC(65,30) = SAVE407
      DWCCL(75,30) = DWCCL(75,30)+JACCCCL(65,30)*0.5000000000000000d-01
      JACC(62,62) = SAVE406
      DWCCL(75,62) = DWCCL(75,62)-JACCCCL(62,62)
      JACC(62,30) = SAVE405
      DWCCL(75,30) = DWCCL(75,30)-JACCCCL(62,30)
      JACC(30,62) = SAVE404
      DWCCL(75,62) = DWCCL(75,62)-JACCCCL(30,62)
      JACC(30,30) = SAVE403
      DWCCL(75,30) = DWCCL(75,30)-JACCCCL(30,30)
      JACC(29,62) = SAVE402
      DWCCL(75,62) = DWCCL(75,62)+JACCCCL(29,62)*0.1000000000000000d+00
      JACC(29,30) = SAVE401
      DWCCL(75,30) = DWCCL(75,30)+JACCCCL(29,30)*0.1000000000000000d+00
      JACC(22,62) = SAVE400
      DWCCL(75,62) = DWCCL(75,62)+JACCCCL(22,62)*0.8500000000000000d+00
      JACC(22,30) = SAVE399
      DWCCL(75,30) = DWCCL(75,30)+JACCCCL(22,30)*0.8500000000000000d+00
      JACC(71,62) = SAVE398
      DWCCL(74,62) = DWCCL(74,62)+JACCCCL(71,62)*0.1000000000000000d+00
      JACC(71,6) = SAVE397
      DWCCL(74,6) = DWCCL(74,6)+JACCCCL(71,6)*0.1000000000000000d+00
      JACC(65,62) = SAVE396
      DWCCL(74,62) = DWCCL(74,62)+JACCCCL(65,62)*0.1000000000000000d+00
      JACC(65,6) = SAVE395
      DWCCL(74,6) = DWCCL(74,6)+JACCCCL(65,6)*0.1000000000000000d+00
      JACC(62,62) = SAVE394
      DWCCL(74,62) = DWCCL(74,62)-JACCCCL(62,62)
      JACC(62,6) = SAVE393
      DWCCL(74,6) = DWCCL(74,6)-JACCCCL(62,6)
      JACC(18,62) = SAVE392
      DWCCL(74,62) = DWCCL(74,62)+JACCCCL(18,62)*0.9000000000000000d+00
      JACC(18,6) = SAVE391
      DWCCL(74,6) = DWCCL(74,6)+JACCCCL(18,6)*0.9000000000000000d+00
      JACC(6,62) = SAVE390
      DWCCL(74,62) = DWCCL(74,62)-JACCCCL(6,62)
      JACC(6,6) = SAVE389
      DWCCL(74,6) = DWCCL(74,6)-JACCCCL(6,6)
      JACC(71,62) = SAVE388
      DWCCL(73,62) = DWCCL(73,62)+JACCCCL(71,62)*0.1000000000000000d+00
      JACC(71,5) = SAVE387
      DWCCL(73,5) = DWCCL(73,5)+JACCCCL(71,5)*0.1000000000000000d+00
      JACC(65,62) = SAVE386
      DWCCL(73,62) = DWCCL(73,62)+JACCCCL(65,62)*0.1000000000000000d+00
      JACC(65,5) = SAVE385
      DWCCL(73,5) = DWCCL(73,5)+JACCCCL(65,5)*0.1000000000000000d+00
      JACC(62,62) = SAVE384
      DWCCL(73,62) = DWCCL(73,62)-JACCCCL(62,62)
      JACC(62,5) = SAVE383
      DWCCL(73,5) = DWCCL(73,5)-JACCCCL(62,5)
      JACC(17,62) = SAVE382
      DWCCL(73,62) = DWCCL(73,62)+JACCCCL(17,62)*0.9000000000000000d+00
      JACC(17,5) = SAVE381
      DWCCL(73,5) = DWCCL(73,5)+JACCCCL(17,5)*0.9000000000000000d+00
      JACC(5,62) = SAVE380
      DWCCL(73,62) = DWCCL(73,62)-JACCCCL(5,62)
      JACC(5,5) = SAVE379
      DWCCL(73,5) = DWCCL(73,5)-JACCCCL(5,5)
      JACC(62,62) = SAVE378
      DWCCL(72,62) = DWCCL(72,62)-JACCCCL(62,62)
      JACC(62,14) = SAVE377
      DWCCL(72,14) = DWCCL(72,14)-JACCCCL(62,14)
      JACC(43,62) = SAVE376
      DWCCL(72,62) = DWCCL(72,62)+JACCCCL(43,62)
      JACC(43,14) = SAVE375
      DWCCL(72,14) = DWCCL(72,14)+JACCCCL(43,14)
      JACC(14,62) = SAVE374
      DWCCL(72,62) = DWCCL(72,62)-JACCCCL(14,62)
      JACC(14,14) = SAVE373
      DWCCL(72,14) = DWCCL(72,14)-JACCCCL(14,14)
      JACC(62,62) = SAVE372
      DWCCL(71,62) = DWCCL(71,62)-JACCCCL(62,62)
      JACC(62,13) = SAVE371
      DWCCL(71,13) = DWCCL(71,13)-JACCCCL(62,13)
      JACC(42,62) = SAVE370
      DWCCL(71,62) = DWCCL(71,62)+JACCCCL(42,62)
      JACC(42,13) = SAVE369
      DWCCL(71,13) = DWCCL(71,13)+JACCCCL(42,13)
      JACC(13,62) = SAVE368
      DWCCL(71,62) = DWCCL(71,62)-JACCCCL(13,62)
      JACC(13,13) = SAVE367
      DWCCL(71,13) = DWCCL(71,13)-JACCCCL(13,13)
      JACC(62,62) = SAVE366
      DWCCL(70,62) = DWCCL(70,62)-JACCCCL(62,62)
      JACC(62,19) = SAVE365
      DWCCL(70,19) = DWCCL(70,19)-JACCCCL(62,19)
      JACC(39,62) = SAVE364
      DWCCL(70,62) = DWCCL(70,62)+JACCCCL(39,62)
      JACC(39,19) = SAVE363
      DWCCL(70,19) = DWCCL(70,19)+JACCCCL(39,19)
      JACC(19,62) = SAVE362
      DWCCL(70,62) = DWCCL(70,62)-JACCCCL(19,62)
      JACC(19,19) = SAVE361
      DWCCL(70,19) = DWCCL(70,19)-JACCCCL(19,19)
      JACC(62,62) = SAVE360
      DWCCL(69,62) = DWCCL(69,62)-JACCCCL(62,62)
      JACC(62,12) = SAVE359
      DWCCL(69,12) = DWCCL(69,12)-JACCCCL(62,12)
      JACC(39,62) = SAVE358
      DWCCL(69,62) = DWCCL(69,62)+JACCCCL(39,62)
      JACC(39,12) = SAVE357
      DWCCL(69,12) = DWCCL(69,12)+JACCCCL(39,12)
      JACC(12,62) = SAVE356
      DWCCL(69,62) = DWCCL(69,62)-JACCCCL(12,62)
      JACC(12,12) = SAVE355
      DWCCL(69,12) = DWCCL(69,12)-JACCCCL(12,12)
      JACC(62,62) = SAVE354
      DWCCL(68,62) = DWCCL(68,62)-JACCCCL(62,62)
      JACC(62,44) = SAVE353
      DWCCL(68,44) = DWCCL(68,44)-JACCCCL(62,44)
      JACC(45,62) = SAVE352
      DWCCL(68,62) = DWCCL(68,62)+JACCCCL(45,62)
      JACC(45,44) = SAVE351
      DWCCL(68,44) = DWCCL(68,44)+JACCCCL(45,44)
      JACC(44,62) = SAVE350
      DWCCL(68,62) = DWCCL(68,62)-JACCCCL(44,62)
      JACC(44,44) = SAVE349
      DWCCL(68,44) = DWCCL(68,44)-JACCCCL(44,44)
      JACC(62,62) = SAVE348
      DWCCL(67,62) = DWCCL(67,62)-JACCCCL(62,62)
      JACC(62,40) = SAVE347
      DWCCL(67,40) = DWCCL(67,40)-JACCCCL(62,40)
      JACC(41,62) = SAVE346
      DWCCL(67,62) = DWCCL(67,62)+JACCCCL(41,62)
      JACC(41,40) = SAVE345
      DWCCL(67,40) = DWCCL(67,40)+JACCCCL(41,40)
      JACC(40,62) = SAVE344
      DWCCL(67,62) = DWCCL(67,62)-JACCCCL(40,62)
      JACC(40,40) = SAVE343
      DWCCL(67,40) = DWCCL(67,40)-JACCCCL(40,40)
      JACC(62,62) = SAVE342
      DWCCL(66,62) = DWCCL(66,62)-JACCCCL(62,62)
      JACC(62,11) = SAVE341
      DWCCL(66,11) = DWCCL(66,11)-JACCCCL(62,11)
      JACC(38,62) = SAVE340
      DWCCL(66,62) = DWCCL(66,62)+JACCCCL(38,62)
      JACC(38,11) = SAVE339
      DWCCL(66,11) = DWCCL(66,11)+JACCCCL(38,11)
      JACC(11,62) = SAVE338
      DWCCL(66,62) = DWCCL(66,62)-JACCCCL(11,62)
      JACC(11,11) = SAVE337
      DWCCL(66,11) = DWCCL(66,11)-JACCCCL(11,11)
      JACC(71,62) = SAVE336
      DWCCL(65,62) = DWCCL(65,62)+JACCCCL(71,62)*0.4900000000000000d-01
      JACC(71,4) = SAVE335
      DWCCL(65,4) = DWCCL(65,4)+JACCCCL(71,4)*0.4900000000000000d-01
      JACC(62,62) = SAVE334
      DWCCL(65,62) = DWCCL(65,62)-JACCCCL(62,62)
      JACC(62,4) = SAVE333
      DWCCL(65,4) = DWCCL(65,4)-JACCCCL(62,4)
      JACC(61,62) = SAVE332
      DWCCL(65,62) = DWCCL(65,62)+JACCCCL(61,62)*0.2500000000000000d-01
      JACC(61,4) = SAVE331
      DWCCL(65,4) = DWCCL(65,4)+JACCCCL(61,4)*0.2500000000000000d-01
      JACC(37,62) = SAVE330
      DWCCL(65,62) = DWCCL(65,62)+JACCCCL(37,62)*0.9510000000000000d+00
      JACC(37,4) = SAVE329
      DWCCL(65,4) = DWCCL(65,4)+JACCCCL(37,4)*0.9510000000000000d+00
      JACC(24,62) = SAVE328
      DWCCL(65,62) = DWCCL(65,62)+JACCCCL(24,62)*0.2400000000000000d-01
      JACC(24,4) = SAVE327
      DWCCL(65,4) = DWCCL(65,4)+JACCCCL(24,4)*0.2400000000000000d-01
      JACC(4,62) = SAVE326
      DWCCL(65,62) = DWCCL(65,62)-JACCCCL(4,62)
      JACC(4,4) = SAVE325
      DWCCL(65,4) = DWCCL(65,4)-JACCCCL(4,4)
      JACC(71,62) = SAVE324
      DWCCL(64,62) = DWCCL(64,62)+JACCCCL(71,62)*0.2500000000000000d+00
      JACC(71,3) = SAVE323
      DWCCL(64,3) = DWCCL(64,3)+JACCCCL(71,3)*0.2500000000000000d+00
      JACC(62,62) = SAVE322
      DWCCL(64,62) = DWCCL(64,62)-JACCCCL(62,62)
      JACC(62,3) = SAVE321
      DWCCL(64,3) = DWCCL(64,3)-JACCCCL(62,3)
      JACC(59,62) = SAVE320
      DWCCL(64,62) = DWCCL(64,62)+JACCCCL(59,62)*0.2500000000000000d+00
      JACC(59,3) = SAVE319
      DWCCL(64,3) = DWCCL(64,3)+JACCCCL(59,3)*0.2500000000000000d+00
      JACC(36,62) = SAVE318
      DWCCL(64,62) = DWCCL(64,62)+JACCCCL(36,62)*0.7500000000000000d+00
      JACC(36,3) = SAVE317
      DWCCL(64,3) = DWCCL(64,3)+JACCCCL(36,3)*0.7500000000000000d+00
      JACC(3,62) = SAVE316
      DWCCL(64,62) = DWCCL(64,62)-JACCCCL(3,62)
      JACC(3,3) = SAVE315
      DWCCL(64,3) = DWCCL(64,3)-JACCCCL(3,3)
      JACC(71,62) = SAVE314
      DWCCL(63,62) = DWCCL(63,62)+JACCCCL(71,62)*0.3810000000000000d+00
      JACC(71,2) = SAVE313
      DWCCL(63,2) = DWCCL(63,2)+JACCCCL(71,2)*0.3810000000000000d+00
      JACC(66,62) = SAVE312
      DWCCL(63,62) = DWCCL(63,62)+JACCCCL(66,62)*0.1000000000000000d-01
      JACC(66,2) = SAVE311
      DWCCL(63,2) = DWCCL(63,2)+JACCCCL(66,2)*0.1000000000000000d-01
      JACC(64,62) = SAVE310
      DWCCL(63,62) = DWCCL(63,62)+JACCCCL(64,62)*0.5830000000000000d+00
      JACC(64,2) = SAVE309
      DWCCL(63,2) = DWCCL(63,2)+JACCCCL(64,2)*0.5830000000000000d+00
      JACC(62,62) = SAVE308
      DWCCL(63,62) = DWCCL(63,62)-JACCCCL(62,62)*0.9640000000000000d+00
      JACC(62,2) = SAVE307
      DWCCL(63,2) = DWCCL(63,2)-JACCCCL(62,2)*0.9640000000000000d+00
      JACC(61,62) = SAVE306
      DWCCL(63,62) = DWCCL(63,62)+JACCCCL(61,62)*0.3350000000000000d+00
      JACC(61,2) = SAVE305
      DWCCL(63,2) = DWCCL(63,2)+JACCCCL(61,2)*0.3350000000000000d+00
      JACC(52,62) = SAVE304
      DWCCL(63,62) = DWCCL(63,62)+JACCCCL(52,62)*0.3600000000000000d-01
      JACC(52,2) = SAVE303
      DWCCL(63,2) = DWCCL(63,2)+JACCCCL(52,2)*0.3600000000000000d-01
      JACC(51,62) = SAVE302
      DWCCL(63,62) = DWCCL(63,62)+JACCCCL(51,62)*0.3600000000000000d-01
      JACC(51,2) = SAVE301
      DWCCL(63,2) = DWCCL(63,2)+JACCCCL(51,2)*0.3600000000000000d-01
      JACC(34,62) = SAVE300
      DWCCL(63,62) = DWCCL(63,62)+JACCCCL(34,62)*0.3600000000000000d-01
      JACC(34,2) = SAVE299
      DWCCL(63,2) = DWCCL(63,2)+JACCCCL(34,2)*0.3600000000000000d-01
      JACC(2,62) = SAVE298
      DWCCL(63,62) = DWCCL(63,62)-JACCCCL(2,62)
      JACC(2,2) = SAVE297
      DWCCL(63,2) = DWCCL(63,2)-JACCCCL(2,2)
      JACC(62,62) = SAVE296
      DWCCL(62,62) = DWCCL(62,62)-JACCCCL(62,62)
      JACC(62,21) = SAVE295
      DWCCL(62,21) = DWCCL(62,21)-JACCCCL(62,21)
      JACC(60,62) = SAVE294
      DWCCL(62,62) = DWCCL(62,62)+JACCCCL(60,62)
      JACC(60,21) = SAVE293
      DWCCL(62,21) = DWCCL(62,21)+JACCCCL(60,21)
      JACC(21,62) = SAVE292
      DWCCL(62,62) = DWCCL(62,62)-JACCCCL(21,62)
      JACC(21,21) = SAVE291
      DWCCL(62,21) = DWCCL(62,21)-JACCCCL(21,21)
      JACC(63,62) = SAVE290
      DWCCL(61,62) = DWCCL(61,62)+JACCCCL(63,62)
      JACC(63,20) = SAVE289
      DWCCL(61,20) = DWCCL(61,20)+JACCCCL(63,20)
      JACC(62,62) = SAVE288
      DWCCL(61,62) = DWCCL(61,62)-JACCCCL(62,62)
      JACC(62,20) = SAVE287
      DWCCL(61,20) = DWCCL(61,20)-JACCCCL(62,20)
      JACC(20,62) = SAVE286
      DWCCL(61,62) = DWCCL(61,62)-JACCCCL(20,62)
      JACC(20,20) = SAVE285
      DWCCL(61,20) = DWCCL(61,20)-JACCCCL(20,20)
      JACC(61,35) = SAVE284
      DWCCL(60,35) = DWCCL(60,35)+JACCCCL(61,35)
      JACC(61,49) = SAVE283
      DWCCL(60,49) = DWCCL(60,49)+JACCCCL(61,49)
      JACC(49,35) = SAVE282
      DWCCL(60,35) = DWCCL(60,35)-JACCCCL(49,35)
      JACC(49,49) = SAVE281
      DWCCL(60,49) = DWCCL(60,49)-JACCCCL(49,49)
      JACC(35,35) = SAVE280
      DWCCL(60,35) = DWCCL(60,35)-JACCCCL(35,35)
      JACC(35,49) = SAVE279
      DWCCL(60,49) = DWCCL(60,49)-JACCCCL(35,49)
      JACC(71,35) = SAVE278
      DWCCL(59,35) = DWCCL(59,35)+JACCCCL(71,35)*0.2800000000000000d+00
      JACC(71,19) = SAVE277
      DWCCL(59,19) = DWCCL(59,19)+JACCCCL(71,19)*0.2800000000000000d+00
      JACC(66,35) = SAVE276
      DWCCL(59,35) = DWCCL(59,35)+JACCCCL(66,35)*0.5000000000000000d-01
      JACC(66,19) = SAVE275
      DWCCL(59,19) = DWCCL(59,19)+JACCCCL(66,19)*0.5000000000000000d-01
      JACC(65,35) = SAVE274
      DWCCL(59,35) = DWCCL(59,35)+JACCCCL(65,35)*0.1500000000000000d+00
      JACC(65,19) = SAVE273
      DWCCL(59,19) = DWCCL(59,19)+JACCCCL(65,19)*0.1500000000000000d+00
      JACC(62,35) = SAVE272
      DWCCL(59,35) = DWCCL(59,35)+JACCCCL(62,35)*0.2000000000000000d-01
      JACC(62,19) = SAVE271
      DWCCL(59,19) = DWCCL(59,19)+JACCCCL(62,19)*0.2000000000000000d-01
      JACC(52,35) = SAVE270
      DWCCL(59,35) = DWCCL(59,35)+JACCCCL(52,35)*0.1000000000000000d-01
      JACC(52,19) = SAVE269
      DWCCL(59,19) = DWCCL(59,19)+JACCCCL(52,19)*0.1000000000000000d-01
      JACC(48,35) = SAVE268
      DWCCL(59,35) = DWCCL(59,35)+JACCCCL(48,35)*0.1300000000000000d+00
      JACC(48,19) = SAVE267
      DWCCL(59,19) = DWCCL(59,19)+JACCCCL(48,19)*0.1300000000000000d+00
      JACC(40,35) = SAVE266
      DWCCL(59,35) = DWCCL(59,35)+JACCCCL(40,35)*0.8600000000000000d+00
      JACC(40,19) = SAVE265
      DWCCL(59,19) = DWCCL(59,19)+JACCCCL(40,19)*0.8600000000000000d+00
      JACC(35,35) = SAVE264
      DWCCL(59,35) = DWCCL(59,35)-JACCCCL(35,35)
      JACC(35,19) = SAVE263
      DWCCL(59,19) = DWCCL(59,19)-JACCCCL(35,19)
      JACC(19,35) = SAVE262
      DWCCL(59,35) = DWCCL(59,35)-JACCCCL(19,35)
      JACC(19,19) = SAVE261
      DWCCL(59,19) = DWCCL(59,19)-JACCCCL(19,19)
      JACC(71,62) = SAVE260
      DWCCL(58,62) = DWCCL(58,62)+JACCCCL(71,62)
      JACC(71,52) = SAVE259
      DWCCL(58,52) = DWCCL(58,52)+JACCCCL(71,52)
      JACC(62,62) = SAVE258
      DWCCL(58,62) = DWCCL(58,62)-JACCCCL(62,62)
      JACC(62,52) = SAVE257
      DWCCL(58,52) = DWCCL(58,52)-JACCCCL(62,52)
      JACC(52,62) = SAVE256
      DWCCL(58,62) = DWCCL(58,62)-JACCCCL(52,62)
      JACC(52,52) = SAVE255
      DWCCL(58,52) = DWCCL(58,52)-JACCCCL(52,52)
      JACC(71,1) = SAVE254
      DWCCL(57,1) = DWCCL(57,1)+JACCCCL(71,1)
      JACC(71,62) = SAVE253
      DWCCL(57,62) = DWCCL(57,62)+JACCCCL(71,62)
      JACC(62,1) = SAVE252
      DWCCL(57,1) = DWCCL(57,1)-JACCCCL(62,1)
      JACC(62,62) = SAVE251
      DWCCL(57,62) = DWCCL(57,62)-JACCCCL(62,62)
      JACC(8,1) = SAVE250
      DWCCL(57,1) = DWCCL(57,1)+JACCCCL(8,1)
      JACC(8,62) = SAVE249
      DWCCL(57,62) = DWCCL(57,62)+JACCCCL(8,62)
      JACC(1,1) = SAVE248
      DWCCL(57,1) = DWCCL(57,1)-JACCCCL(1,1)
      JACC(1,62) = SAVE247
      DWCCL(57,62) = DWCCL(57,62)-JACCCCL(1,62)
      JACC(71,62) = SAVE246
      DWCCL(56,62) = DWCCL(56,62)+JACCCCL(71,62)
      JACC(62,62) = SAVE245
      DWCCL(56,62) = DWCCL(56,62)-JACCCCL(62,62)
      JACC(72,68) = SAVE244
      DWCCL(55,68) = DWCCL(55,68)+JACCCCL(72,68)*0.2000000000000000d+01
      JACC(72,68) = SAVE243
      DWCCL(55,68) = DWCCL(55,68)+JACCCCL(72,68)*0.2000000000000000d+01
      JACC(68,68) = SAVE242
      DWCCL(55,68) = DWCCL(55,68)-JACCCCL(68,68)*0.2000000000000000d+01
      JACC(68,68) = SAVE241
      DWCCL(55,68) = DWCCL(55,68)-JACCCCL(68,68)*0.2000000000000000d+01
      JACC(72,9) = SAVE240
      DWCCL(54,9) = DWCCL(54,9)+JACCCCL(72,9)
      JACC(68,9) = SAVE239
      DWCCL(54,9) = DWCCL(54,9)+JACCCCL(68,9)
      JACC(9,9) = SAVE238
      DWCCL(54,9) = DWCCL(54,9)-JACCCCL(9,9)
      JACC(72,72) = SAVE237
      DWCCL(53,72) = DWCCL(53,72)-JACCCCL(72,72)
      JACC(72,68) = SAVE236
      DWCCL(53,68) = DWCCL(53,68)-JACCCCL(72,68)
      JACC(68,72) = SAVE235
      DWCCL(53,72) = DWCCL(53,72)-JACCCCL(68,72)
      JACC(68,68) = SAVE234
      DWCCL(53,68) = DWCCL(53,68)-JACCCCL(68,68)
      JACC(9,72) = SAVE233
      DWCCL(53,72) = DWCCL(53,72)+JACCCCL(9,72)
      JACC(9,68) = SAVE232
      DWCCL(53,68) = DWCCL(53,68)+JACCCCL(9,68)
      JACC(68,72) = SAVE231
      DWCCL(52,72) = DWCCL(52,72)-JACCCCL(68,72)
      JACC(68,68) = SAVE230
      DWCCL(52,68) = DWCCL(52,68)-JACCCCL(68,68)
      JACC(67,72) = SAVE229
      DWCCL(52,72) = DWCCL(52,72)+JACCCCL(67,72)
      JACC(67,68) = SAVE228
      DWCCL(52,68) = DWCCL(52,68)+JACCCCL(67,68)
      JACC(72,67) = SAVE227
      DWCCL(51,67) = DWCCL(51,67)+JACCCCL(72,67)*0.2000000000000000d+01
      JACC(72,68) = SAVE226
      DWCCL(51,68) = DWCCL(51,68)+JACCCCL(72,68)*0.2000000000000000d+01
      JACC(68,67) = SAVE225
      DWCCL(51,67) = DWCCL(51,67)-JACCCCL(68,67)
      JACC(68,68) = SAVE224
      DWCCL(51,68) = DWCCL(51,68)-JACCCCL(68,68)
      JACC(67,67) = SAVE223
      DWCCL(51,67) = DWCCL(51,67)-JACCCCL(67,67)
      JACC(67,68) = SAVE222
      DWCCL(51,68) = DWCCL(51,68)-JACCCCL(67,68)
      JACC(72,67) = SAVE221
      DWCCL(50,67) = DWCCL(50,67)+JACCCCL(72,67)*0.2000000000000000d+01
      JACC(72,67) = SAVE220
      DWCCL(50,67) = DWCCL(50,67)+JACCCCL(72,67)*0.2000000000000000d+01
      JACC(67,67) = SAVE219
      DWCCL(50,67) = DWCCL(50,67)-JACCCCL(67,67)*0.2000000000000000d+01
      JACC(67,67) = SAVE218
      DWCCL(50,67) = DWCCL(50,67)-JACCCCL(67,67)*0.2000000000000000d+01
      JACC(72,72) = SAVE217
      DWCCL(49,72) = DWCCL(49,72)-JACCCCL(72,72)
      JACC(72,50) = SAVE216
      DWCCL(49,50) = DWCCL(49,50)-JACCCCL(72,50)
      JACC(68,72) = SAVE215
      DWCCL(49,72) = DWCCL(49,72)+JACCCCL(68,72)
      JACC(68,50) = SAVE214
      DWCCL(49,50) = DWCCL(49,50)+JACCCCL(68,50)
      JACC(50,72) = SAVE213
      DWCCL(49,72) = DWCCL(49,72)-JACCCCL(50,72)
      JACC(50,50) = SAVE212
      DWCCL(49,50) = DWCCL(49,50)-JACCCCL(50,50)
      JACC(72,67) = SAVE211
      DWCCL(48,67) = DWCCL(48,67)+JACCCCL(72,67)
      JACC(72,50) = SAVE210
      DWCCL(48,50) = DWCCL(48,50)+JACCCCL(72,50)
      JACC(67,67) = SAVE209
      DWCCL(48,67) = DWCCL(48,67)-JACCCCL(67,67)
      JACC(67,50) = SAVE208
      DWCCL(48,50) = DWCCL(48,50)-JACCCCL(67,50)
      JACC(50,67) = SAVE207
      DWCCL(48,67) = DWCCL(48,67)-JACCCCL(50,67)
      JACC(50,50) = SAVE206
      DWCCL(48,50) = DWCCL(48,50)-JACCCCL(50,50)
      JACC(72,15) = SAVE205
      DWCCL(47,15) = DWCCL(47,15)+JACCCCL(72,15)
      JACC(72,62) = SAVE204
      DWCCL(47,62) = DWCCL(47,62)+JACCCCL(72,62)
      JACC(62,15) = SAVE203
      DWCCL(47,15) = DWCCL(47,15)-JACCCCL(62,15)
      JACC(62,62) = SAVE202
      DWCCL(47,62) = DWCCL(47,62)-JACCCCL(62,62)
      JACC(15,15) = SAVE201
      DWCCL(47,15) = DWCCL(47,15)-JACCCCL(15,15)
      JACC(15,62) = SAVE200
      DWCCL(47,62) = DWCCL(47,62)-JACCCCL(15,62)
      JACC(68,55) = SAVE199
      DWCCL(46,55) = DWCCL(46,55)+JACCCCL(68,55)
      JACC(68,62) = SAVE198
      DWCCL(46,62) = DWCCL(46,62)+JACCCCL(68,62)
      JACC(62,55) = SAVE197
      DWCCL(46,55) = DWCCL(46,55)-JACCCCL(62,55)
      JACC(62,62) = SAVE196
      DWCCL(46,62) = DWCCL(46,62)-JACCCCL(62,62)
      JACC(55,55) = SAVE195
      DWCCL(46,55) = DWCCL(46,55)-JACCCCL(55,55)
      JACC(55,62) = SAVE194
      DWCCL(46,62) = DWCCL(46,62)-JACCCCL(55,62)
      JACC(72,23) = SAVE193
      DWCCL(45,23) = DWCCL(45,23)+JACCCCL(72,23)
      JACC(72,62) = SAVE192
      DWCCL(45,62) = DWCCL(45,62)+JACCCCL(72,62)
      JACC(62,23) = SAVE191
      DWCCL(45,23) = DWCCL(45,23)-JACCCCL(62,23)
      JACC(62,62) = SAVE190
      DWCCL(45,62) = DWCCL(45,62)-JACCCCL(62,62)
      JACC(23,23) = SAVE189
      DWCCL(45,23) = DWCCL(45,23)-JACCCCL(23,23)
      JACC(23,62) = SAVE188
      DWCCL(45,62) = DWCCL(45,62)-JACCCCL(23,62)
      JACC(72,68) = SAVE187
      DWCCL(44,68) = DWCCL(44,68)+JACCCCL(72,68)*0.7000000000000000d+00
      JACC(72,71) = SAVE186
      DWCCL(44,71) = DWCCL(44,71)+JACCCCL(72,71)*0.7000000000000000d+00
      JACC(71,68) = SAVE185
      DWCCL(44,68) = DWCCL(44,68)-JACCCCL(71,68)
      JACC(71,71) = SAVE184
      DWCCL(44,71) = DWCCL(44,71)-JACCCCL(71,71)
      JACC(68,68) = SAVE183
      DWCCL(44,68) = DWCCL(44,68)-JACCCCL(68,68)
      JACC(68,71) = SAVE182
      DWCCL(44,71) = DWCCL(44,71)-JACCCCL(68,71)
      JACC(62,68) = SAVE181
      DWCCL(44,68) = DWCCL(44,68)+JACCCCL(62,68)*0.7000000000000000d+00
      JACC(62,71) = SAVE180
      DWCCL(44,71) = DWCCL(44,71)+JACCCCL(62,71)*0.7000000000000000d+00
      JACC(55,68) = SAVE179
      DWCCL(44,68) = DWCCL(44,68)+JACCCCL(55,68)*0.3000000000000000d+00
      JACC(55,71) = SAVE178
      DWCCL(44,71) = DWCCL(44,71)+JACCCCL(55,71)*0.3000000000000000d+00
      JACC(72,15) = SAVE177
      DWCCL(43,15) = DWCCL(43,15)+JACCCCL(72,15)
      JACC(71,15) = SAVE176
      DWCCL(43,15) = DWCCL(43,15)+JACCCCL(71,15)
      JACC(15,15) = SAVE175
      DWCCL(43,15) = DWCCL(43,15)-JACCCCL(15,15)
      JACC(72,72) = SAVE174
      DWCCL(42,72) = DWCCL(42,72)-JACCCCL(72,72)
      JACC(72,71) = SAVE173
      DWCCL(42,71) = DWCCL(42,71)-JACCCCL(72,71)
      JACC(71,72) = SAVE172
      DWCCL(42,72) = DWCCL(42,72)-JACCCCL(71,72)
      JACC(71,71) = SAVE171
      DWCCL(42,71) = DWCCL(42,71)-JACCCCL(71,71)
      JACC(15,72) = SAVE170
      DWCCL(42,72) = DWCCL(42,72)+JACCCCL(15,72)
      JACC(15,71) = SAVE169
      DWCCL(42,71) = DWCCL(42,71)+JACCCCL(15,71)
      JACC(72,67) = SAVE168
      DWCCL(41,67) = DWCCL(41,67)+JACCCCL(72,67)
      JACC(72,71) = SAVE167
      DWCCL(41,71) = DWCCL(41,71)+JACCCCL(72,71)
      JACC(71,67) = SAVE166
      DWCCL(41,67) = DWCCL(41,67)-JACCCCL(71,67)
      JACC(71,71) = SAVE165
      DWCCL(41,71) = DWCCL(41,71)-JACCCCL(71,71)
      JACC(67,67) = SAVE164
      DWCCL(41,67) = DWCCL(41,67)-JACCCCL(67,67)
      JACC(67,71) = SAVE163
      DWCCL(41,71) = DWCCL(41,71)-JACCCCL(67,71)
      JACC(62,67) = SAVE162
      DWCCL(41,67) = DWCCL(41,67)+JACCCCL(62,67)
      JACC(62,71) = SAVE161
      DWCCL(41,71) = DWCCL(41,71)+JACCCCL(62,71)
      JACC(72,68) = SAVE160
      DWCCL(40,68) = DWCCL(40,68)+JACCCCL(72,68)
      JACC(72,62) = SAVE159
      DWCCL(40,62) = DWCCL(40,62)+JACCCCL(72,62)
      JACC(71,68) = SAVE158
      DWCCL(40,68) = DWCCL(40,68)+JACCCCL(71,68)
      JACC(71,62) = SAVE157
      DWCCL(40,62) = DWCCL(40,62)+JACCCCL(71,62)
      JACC(68,68) = SAVE156
      DWCCL(40,68) = DWCCL(40,68)-JACCCCL(68,68)
      JACC(68,62) = SAVE155
      DWCCL(40,62) = DWCCL(40,62)-JACCCCL(68,62)
      JACC(62,68) = SAVE154
      DWCCL(40,68) = DWCCL(40,68)-JACCCCL(62,68)
      JACC(62,62) = SAVE153
      DWCCL(40,62) = DWCCL(40,62)-JACCCCL(62,62)
      JACC(72,72) = SAVE152
      DWCCL(39,72) = DWCCL(39,72)-JACCCCL(72,72)
      JACC(72,62) = SAVE151
      DWCCL(39,62) = DWCCL(39,62)-JACCCCL(72,62)
      JACC(62,72) = SAVE150
      DWCCL(39,72) = DWCCL(39,72)-JACCCCL(62,72)
      JACC(62,62) = SAVE149
      DWCCL(39,62) = DWCCL(39,62)-JACCCCL(62,62)
      JACC(55,72) = SAVE148
      DWCCL(39,72) = DWCCL(39,72)+JACCCCL(55,72)
      JACC(55,62) = SAVE147
      DWCCL(39,62) = DWCCL(39,62)+JACCCCL(55,62)
      JACC(67,67) = SAVE146
      DWCCL(38,67) = DWCCL(38,67)-JACCCCL(67,67)
      JACC(67,62) = SAVE145
      DWCCL(38,62) = DWCCL(38,62)-JACCCCL(67,62)
      JACC(62,67) = SAVE144
      DWCCL(38,67) = DWCCL(38,67)-JACCCCL(62,67)
      JACC(62,62) = SAVE143
      DWCCL(38,62) = DWCCL(38,62)-JACCCCL(62,62)
      JACC(23,67) = SAVE142
      DWCCL(38,67) = DWCCL(38,67)+JACCCCL(23,67)
      JACC(23,62) = SAVE141
      DWCCL(38,62) = DWCCL(38,62)+JACCCCL(23,62)
      JACC(72,72) = SAVE140
      DWCCL(37,72) = DWCCL(37,72)-JACCCCL(72,72)
      JACC(72,35) = SAVE139
      DWCCL(37,35) = DWCCL(37,35)-JACCCCL(72,35)
      JACC(68,72) = SAVE138
      DWCCL(37,72) = DWCCL(37,72)+JACCCCL(68,72)
      JACC(68,35) = SAVE137
      DWCCL(37,35) = DWCCL(37,35)+JACCCCL(68,35)
      JACC(35,72) = SAVE136
      DWCCL(37,72) = DWCCL(37,72)-JACCCCL(35,72)
      JACC(35,35) = SAVE135
      DWCCL(37,35) = DWCCL(37,35)-JACCCCL(35,35)
      JACC(72,72) = SAVE134
      DWCCL(36,72) = DWCCL(36,72)-JACCCCL(72,72)
      JACC(72,35) = SAVE133
      DWCCL(36,35) = DWCCL(36,35)-JACCCCL(72,35)
      JACC(67,72) = SAVE132
      DWCCL(36,72) = DWCCL(36,72)+JACCCCL(67,72)
      JACC(67,35) = SAVE131
      DWCCL(36,35) = DWCCL(36,35)+JACCCCL(67,35)
      JACC(35,72) = SAVE130
      DWCCL(36,72) = DWCCL(36,72)-JACCCCL(35,72)
      JACC(35,35) = SAVE129
      DWCCL(36,35) = DWCCL(36,35)-JACCCCL(35,35)
      JACC(72,67) = SAVE128
      DWCCL(35,67) = DWCCL(35,67)+JACCCCL(72,67)
      JACC(72,35) = SAVE127
      DWCCL(35,35) = DWCCL(35,35)+JACCCCL(72,35)
      JACC(67,67) = SAVE126
      DWCCL(35,67) = DWCCL(35,67)-JACCCCL(67,67)
      JACC(67,35) = SAVE125
      DWCCL(35,35) = DWCCL(35,35)-JACCCCL(67,35)
      JACC(35,67) = SAVE124
      DWCCL(35,67) = DWCCL(35,67)-JACCCCL(35,67)
      JACC(35,35) = SAVE123
      DWCCL(35,35) = DWCCL(35,35)-JACCCCL(35,35)
      JACC(71,71) = SAVE122
      DWCCL(34,71) = DWCCL(34,71)-JACCCCL(71,71)*0.2000000000000000d+01
      JACC(71,71) = SAVE121
      DWCCL(34,71) = DWCCL(34,71)-JACCCCL(71,71)*0.2000000000000000d+01
      JACC(27,71) = SAVE120
      DWCCL(34,71) = DWCCL(34,71)+JACCCCL(27,71)
      JACC(27,71) = SAVE119
      DWCCL(34,71) = DWCCL(34,71)+JACCCCL(27,71)
      JACC(71,71) = SAVE118
      DWCCL(33,71) = DWCCL(33,71)-JACCCCL(71,71)*0.2000000000000000d+01
      JACC(71,71) = SAVE117
      DWCCL(33,71) = DWCCL(33,71)-JACCCCL(71,71)*0.2000000000000000d+01
      JACC(27,71) = SAVE116
      DWCCL(33,71) = DWCCL(33,71)+JACCCCL(27,71)
      JACC(27,71) = SAVE115
      DWCCL(33,71) = DWCCL(33,71)+JACCCCL(27,71)
      JACC(71,62) = SAVE114
      DWCCL(32,62) = DWCCL(32,62)+JACCCCL(71,62)
      JACC(71,27) = SAVE113
      DWCCL(32,27) = DWCCL(32,27)+JACCCCL(71,27)
      JACC(62,62) = SAVE112
      DWCCL(32,62) = DWCCL(32,62)-JACCCCL(62,62)
      JACC(62,27) = SAVE111
      DWCCL(32,27) = DWCCL(32,27)-JACCCCL(62,27)
      JACC(27,62) = SAVE110
      DWCCL(32,62) = DWCCL(32,62)-JACCCCL(27,62)
      JACC(27,27) = SAVE109
      DWCCL(32,27) = DWCCL(32,27)-JACCCCL(27,27)
      JACC(71,71) = SAVE108
      DWCCL(31,71) = DWCCL(31,71)-JACCCCL(71,71)
      JACC(71,62) = SAVE107
      DWCCL(31,62) = DWCCL(31,62)-JACCCCL(71,62)
      JACC(62,71) = SAVE106
      DWCCL(31,71) = DWCCL(31,71)-JACCCCL(62,71)
      JACC(62,62) = SAVE105
      DWCCL(31,62) = DWCCL(31,62)-JACCCCL(62,62)
      JACC(71,71) = SAVE104
      DWCCL(30,71) = DWCCL(30,71)-JACCCCL(71,71)
      JACC(71,50) = SAVE103
      DWCCL(30,50) = DWCCL(30,50)-JACCCCL(71,50)
      JACC(62,71) = SAVE102
      DWCCL(30,71) = DWCCL(30,71)+JACCCCL(62,71)
      JACC(62,50) = SAVE101
      DWCCL(30,50) = DWCCL(30,50)+JACCCCL(62,50)
      JACC(50,71) = SAVE100
      DWCCL(30,71) = DWCCL(30,71)-JACCCCL(50,71)
      JACC(50,50) = SAVE99
      DWCCL(30,50) = DWCCL(30,50)-JACCCCL(50,50)
      JACC(71,62) = SAVE98
      DWCCL(29,62) = DWCCL(29,62)+JACCCCL(71,62)
      JACC(71,50) = SAVE97
      DWCCL(29,50) = DWCCL(29,50)+JACCCCL(71,50)
      JACC(62,62) = SAVE96
      DWCCL(29,62) = DWCCL(29,62)-JACCCCL(62,62)
      JACC(62,50) = SAVE95
      DWCCL(29,50) = DWCCL(29,50)-JACCCCL(62,50)
      JACC(50,62) = SAVE94
      DWCCL(29,62) = DWCCL(29,62)-JACCCCL(50,62)
      JACC(50,50) = SAVE93
      DWCCL(29,50) = DWCCL(29,50)-JACCCCL(50,50)
      JACC(62,7) = SAVE92
      DWCCL(28,7) = DWCCL(28,7)+JACCCCL(62,7)*0.2000000000000000d+01
      JACC(7,7) = SAVE91
      DWCCL(28,7) = DWCCL(28,7)-JACCCCL(7,7)
      JACC(35,7) = SAVE90
      DWCCL(27,7) = DWCCL(27,7)+JACCCCL(35,7)
      JACC(7,7) = SAVE89
      DWCCL(27,7) = DWCCL(27,7)-JACCCCL(7,7)
      JACC(35,7) = SAVE88
      DWCCL(26,7) = DWCCL(26,7)+JACCCCL(35,7)
      JACC(7,7) = SAVE87
      DWCCL(26,7) = DWCCL(26,7)-JACCCCL(7,7)
      JACC(50,50) = SAVE86
      DWCCL(25,50) = DWCCL(25,50)-JACCCCL(50,50)
      JACC(50,35) = SAVE85
      DWCCL(25,35) = DWCCL(25,35)-JACCCCL(50,35)
      JACC(35,50) = SAVE84
      DWCCL(25,50) = DWCCL(25,50)-JACCCCL(35,50)
      JACC(35,35) = SAVE83
      DWCCL(25,35) = DWCCL(25,35)-JACCCCL(35,35)
      JACC(50,35) = SAVE82
      DWCCL(24,35) = DWCCL(24,35)+JACCCCL(50,35)
      JACC(35,35) = SAVE81
      DWCCL(24,35) = DWCCL(24,35)-JACCCCL(35,35)
      JACC(71,24) = SAVE80
      DWCCL(23,24) = DWCCL(23,24)+JACCCCL(71,24)
      JACC(69,24) = SAVE79
      DWCCL(23,24) = DWCCL(23,24)+JACCCCL(69,24)
      JACC(66,24) = SAVE78
      DWCCL(23,24) = DWCCL(23,24)+JACCCCL(66,24)
      JACC(24,24) = SAVE77
      DWCCL(23,24) = DWCCL(23,24)-JACCCCL(24,24)
      JACC(71,49) = SAVE76
      DWCCL(22,49) = DWCCL(22,49)+JACCCCL(71,49)
      JACC(69,49) = SAVE75
      DWCCL(22,49) = DWCCL(22,49)+JACCCCL(69,49)
      JACC(66,49) = SAVE74
      DWCCL(22,49) = DWCCL(22,49)+JACCCCL(66,49)
      JACC(52,49) = SAVE73
      DWCCL(22,49) = DWCCL(22,49)+JACCCCL(52,49)
      JACC(49,49) = SAVE72
      DWCCL(22,49) = DWCCL(22,49)-JACCCCL(49,49)
      JACC(72,70) = SAVE71
      DWCCL(21,70) = DWCCL(21,70)+JACCCCL(72,70)
      JACC(71,70) = SAVE70
      DWCCL(21,70) = DWCCL(21,70)+JACCCCL(71,70)
      JACC(70,70) = SAVE69
      DWCCL(21,70) = DWCCL(21,70)-JACCCCL(70,70)
      JACC(61,70) = SAVE68
      DWCCL(21,70) = DWCCL(21,70)+JACCCCL(61,70)*0.2000000000000000d+00
      JACC(59,70) = SAVE67
      DWCCL(21,70) = DWCCL(21,70)+JACCCCL(59,70)*0.8000000000000000d+00
      JACC(71,48) = SAVE66
      DWCCL(20,48) = DWCCL(20,48)+JACCCCL(71,48)
      JACC(56,48) = SAVE65
      DWCCL(20,48) = DWCCL(20,48)+JACCCCL(56,48)
      JACC(48,48) = SAVE64
      DWCCL(20,48) = DWCCL(20,48)-JACCCCL(48,48)
      JACC(71,54) = SAVE63
      DWCCL(19,54) = DWCCL(19,54)+JACCCCL(71,54)
      JACC(69,54) = SAVE62
      DWCCL(19,54) = DWCCL(19,54)+JACCCCL(69,54)
      JACC(54,54) = SAVE61
      DWCCL(19,54) = DWCCL(19,54)-JACCCCL(54,54)
      JACC(52,54) = SAVE60
      DWCCL(19,54) = DWCCL(19,54)+JACCCCL(52,54)
      JACC(71,51) = SAVE59
      DWCCL(18,51) = DWCCL(18,51)+JACCCCL(71,51)*0.8000000000000000d+00
      JACC(66,51) = SAVE58
      DWCCL(18,51) = DWCCL(18,51)+JACCCCL(66,51)*0.4500000000000000d+00
      JACC(52,51) = SAVE57
      DWCCL(18,51) = DWCCL(18,51)+JACCCCL(52,51)*0.1550000000000000d+01
      JACC(51,51) = SAVE56
      DWCCL(18,51) = DWCCL(18,51)-JACCCCL(51,51)
      JACC(66,51) = SAVE55
      DWCCL(17,51) = DWCCL(17,51)+JACCCCL(66,51)*0.1300000000000000d+00
      JACC(52,51) = SAVE54
      DWCCL(17,51) = DWCCL(17,51)+JACCCCL(52,51)*0.1870000000000000d+01
      JACC(51,51) = SAVE53
      DWCCL(17,51) = DWCCL(17,51)-JACCCCL(51,51)
      JACC(69,59) = SAVE52
      DWCCL(16,59) = DWCCL(16,59)+JACCCCL(69,59)
      JACC(60,59) = SAVE51
      DWCCL(16,59) = DWCCL(16,59)+JACCCCL(60,59)
      JACC(59,59) = SAVE50
      DWCCL(16,59) = DWCCL(16,59)-JACCCCL(59,59)
      JACC(63,28) = SAVE49
      DWCCL(15,28) = DWCCL(15,28)+JACCCCL(63,28)
      JACC(62,28) = SAVE48
      DWCCL(15,28) = DWCCL(15,28)+JACCCCL(62,28)
      JACC(28,28) = SAVE47
      DWCCL(15,28) = DWCCL(15,28)-JACCCCL(28,28)
      JACC(71,53) = SAVE46
      DWCCL(14,53) = DWCCL(14,53)+JACCCCL(71,53)
      JACC(62,53) = SAVE45
      DWCCL(14,53) = DWCCL(14,53)+JACCCCL(62,53)
      JACC(61,53) = SAVE44
      DWCCL(14,53) = DWCCL(14,53)+JACCCCL(61,53)
      JACC(53,53) = SAVE43
      DWCCL(14,53) = DWCCL(14,53)-JACCCCL(53,53)
      JACC(71,16) = SAVE42
      DWCCL(13,16) = DWCCL(13,16)+JACCCCL(71,16)
      JACC(66,16) = SAVE41
      DWCCL(13,16) = DWCCL(13,16)+JACCCCL(66,16)
      JACC(62,16) = SAVE40
      DWCCL(13,16) = DWCCL(13,16)+JACCCCL(62,16)
      JACC(16,16) = SAVE39
      DWCCL(13,16) = DWCCL(13,16)-JACCCCL(16,16)
      JACC(71,61) = SAVE38
      DWCCL(12,61) = DWCCL(12,61)+JACCCCL(71,61)
      JACC(63,61) = SAVE37
      DWCCL(12,61) = DWCCL(12,61)+JACCCCL(63,61)
      JACC(61,61) = SAVE36
      DWCCL(12,61) = DWCCL(12,61)-JACCCCL(61,61)
      JACC(52,61) = SAVE35
      DWCCL(12,61) = DWCCL(12,61)+JACCCCL(52,61)
      JACC(71,66) = SAVE34
      DWCCL(11,66) = DWCCL(11,66)+JACCCCL(71,66)*0.2000000000000000d+01
      JACC(66,66) = SAVE33
      DWCCL(11,66) = DWCCL(11,66)-JACCCCL(66,66)
      JACC(52,66) = SAVE32
      DWCCL(11,66) = DWCCL(11,66)+JACCCCL(52,66)
      JACC(66,66) = SAVE31
      DWCCL(10,66) = DWCCL(10,66)-JACCCCL(66,66)
      JACC(52,66) = SAVE30
      DWCCL(10,66) = DWCCL(10,66)+JACCCCL(52,66)
      JACC(62,27) = SAVE29
      DWCCL(9,27) = DWCCL(9,27)+JACCCCL(62,27)*0.2000000000000000d+01
      JACC(27,27) = SAVE28
      DWCCL(9,27) = DWCCL(9,27)-JACCCCL(27,27)
      JACC(72,68) = SAVE27
      DWCCL(8,68) = DWCCL(8,68)+JACCCCL(72,68)
      JACC(68,68) = SAVE26
      DWCCL(8,68) = DWCCL(8,68)-JACCCCL(68,68)
      JACC(35,68) = SAVE25
      DWCCL(8,68) = DWCCL(8,68)+JACCCCL(35,68)
      JACC(68,68) = SAVE24
      DWCCL(7,68) = DWCCL(7,68)-JACCCCL(68,68)
      JACC(67,68) = SAVE23
      DWCCL(7,68) = DWCCL(7,68)+JACCCCL(67,68)
      JACC(72,15) = SAVE22
      DWCCL(6,15) = DWCCL(6,15)+JACCCCL(72,15)*0.6500000000000000d+00
      JACC(71,15) = SAVE21
      DWCCL(6,15) = DWCCL(6,15)+JACCCCL(71,15)*0.6500000000000000d+00
      JACC(68,15) = SAVE20
      DWCCL(6,15) = DWCCL(6,15)+JACCCCL(68,15)*0.3500000000000000d+00
      JACC(62,15) = SAVE19
      DWCCL(6,15) = DWCCL(6,15)+JACCCCL(62,15)*0.3500000000000000d+00
      JACC(15,15) = SAVE18
      DWCCL(6,15) = DWCCL(6,15)-JACCCCL(15,15)
      JACC(72,55) = SAVE17
      DWCCL(5,55) = DWCCL(5,55)+JACCCCL(72,55)
      JACC(62,55) = SAVE16
      DWCCL(5,55) = DWCCL(5,55)+JACCCCL(62,55)
      JACC(55,55) = SAVE15
      DWCCL(5,55) = DWCCL(5,55)-JACCCCL(55,55)
      JACC(67,23) = SAVE14
      DWCCL(4,23) = DWCCL(4,23)+JACCCCL(67,23)
      JACC(62,23) = SAVE13
      DWCCL(4,23) = DWCCL(4,23)+JACCCCL(62,23)
      JACC(23,23) = SAVE12
      DWCCL(4,23) = DWCCL(4,23)-JACCCCL(23,23)
      JACC(50,50) = SAVE11
      DWCCL(3,50) = DWCCL(3,50)-JACCCCL(50,50)
      JACC(35,50) = SAVE10
      DWCCL(3,50) = DWCCL(3,50)+JACCCCL(35,50)
      JACC(50,50) = SAVE9
      DWCCL(2,50) = DWCCL(2,50)-JACCCCL(50,50)
      JACC(7,50) = SAVE8
      DWCCL(2,50) = DWCCL(2,50)+JACCCCL(7,50)
      JACC(72,72) = SAVE7
      DWCCL(1,72) = DWCCL(1,72)-JACCCCL(72,72)
      JACC(67,72) = SAVE6
      DWCCL(1,72) = DWCCL(1,72)+JACCCCL(67,72)
      JACC(35,72) = SAVE5
      DWCCL(1,72) = DWCCL(1,72)+JACCCCL(35,72)
      JACCCCL(35,72) = 0d0
      CALL DRATEDCCL(NS, NR, RK, CONC, DW, CONCCCL, DWCCL)
      DO I = NS, 1, -1
         YCCL(I) = YCCL(I)+CONCCCL(I)*CONVERS_FACTOR(I)
         CONCCCL(I) = 0d0
      END DO
      I = SAVE2292
      DO J = NS, 1, -1
         DO I = NS, 1, -1
            JACC(I,J) = SAVE1(I,J)
            JACCCCL(I,J) = 0d0
         END DO
         I = SAVE2(J)
      END DO
      END



COD Unit from the initial code : dratedc



COD Compilation unit : ratescl
COD Derivative of unit :  rates
COD Dummys:  ns nr rk y w
COD Active IN   dummys:  y
COD Active OUT  dummys:  w
COD Dependencies between IN and OUT:
COD w <--   y


      SUBROUTINE RATESCL (NS, NR, RK, Y, W, YCCL, WCCL)

      IMPLICIT NONE
      INTEGER NS
      INTEGER NR
      DOUBLE PRECISION W(NR)
      DOUBLE PRECISION Y(NS)
      DOUBLE PRECISION WCCL(NR)
      DOUBLE PRECISION YCCL(NS)
      DOUBLE PRECISION RK(NR)
      DOUBLE PRECISION SAVE1
      DOUBLE PRECISION SAVE10
      DOUBLE PRECISION SAVE100
      DOUBLE PRECISION SAVE101
      DOUBLE PRECISION SAVE102
      DOUBLE PRECISION SAVE103
      DOUBLE PRECISION SAVE104
      DOUBLE PRECISION SAVE105
      DOUBLE PRECISION SAVE106
      DOUBLE PRECISION SAVE107
      DOUBLE PRECISION SAVE108
      DOUBLE PRECISION SAVE109
      DOUBLE PRECISION SAVE11
      DOUBLE PRECISION SAVE110
      DOUBLE PRECISION SAVE111
      DOUBLE PRECISION SAVE112
      DOUBLE PRECISION SAVE113
      DOUBLE PRECISION SAVE114
      DOUBLE PRECISION SAVE115
      DOUBLE PRECISION SAVE116
      DOUBLE PRECISION SAVE117
      DOUBLE PRECISION SAVE118
      DOUBLE PRECISION SAVE119
      DOUBLE PRECISION SAVE12
      DOUBLE PRECISION SAVE120
      DOUBLE PRECISION SAVE121
      DOUBLE PRECISION SAVE122
      DOUBLE PRECISION SAVE123
      DOUBLE PRECISION SAVE124
      DOUBLE PRECISION SAVE125
      DOUBLE PRECISION SAVE126
      DOUBLE PRECISION SAVE127
      DOUBLE PRECISION SAVE128
      DOUBLE PRECISION SAVE129
      DOUBLE PRECISION SAVE13
      DOUBLE PRECISION SAVE130
      DOUBLE PRECISION SAVE131
      DOUBLE PRECISION SAVE132
      DOUBLE PRECISION SAVE133
      DOUBLE PRECISION SAVE134
      DOUBLE PRECISION SAVE135
      DOUBLE PRECISION SAVE136
      DOUBLE PRECISION SAVE137
      DOUBLE PRECISION SAVE138
      DOUBLE PRECISION SAVE139
      DOUBLE PRECISION SAVE14
      DOUBLE PRECISION SAVE140
      DOUBLE PRECISION SAVE141
      DOUBLE PRECISION SAVE142
      DOUBLE PRECISION SAVE143
      DOUBLE PRECISION SAVE144
      DOUBLE PRECISION SAVE145
      DOUBLE PRECISION SAVE146
      DOUBLE PRECISION SAVE147
      DOUBLE PRECISION SAVE148
      DOUBLE PRECISION SAVE149
      DOUBLE PRECISION SAVE15
      DOUBLE PRECISION SAVE150
      DOUBLE PRECISION SAVE151
      DOUBLE PRECISION SAVE152
      DOUBLE PRECISION SAVE153
      DOUBLE PRECISION SAVE154
      DOUBLE PRECISION SAVE155
      DOUBLE PRECISION SAVE156
      DOUBLE PRECISION SAVE157
      DOUBLE PRECISION SAVE158
      DOUBLE PRECISION SAVE159
      DOUBLE PRECISION SAVE16
      DOUBLE PRECISION SAVE160
      DOUBLE PRECISION SAVE161
      DOUBLE PRECISION SAVE162
      DOUBLE PRECISION SAVE163
      DOUBLE PRECISION SAVE164
      DOUBLE PRECISION SAVE165
      DOUBLE PRECISION SAVE166
      DOUBLE PRECISION SAVE167
      DOUBLE PRECISION SAVE168
      DOUBLE PRECISION SAVE169
      DOUBLE PRECISION SAVE17
      DOUBLE PRECISION SAVE170
      DOUBLE PRECISION SAVE171
      DOUBLE PRECISION SAVE172
      DOUBLE PRECISION SAVE173
      DOUBLE PRECISION SAVE174
      DOUBLE PRECISION SAVE175
      DOUBLE PRECISION SAVE176
      DOUBLE PRECISION SAVE177
      DOUBLE PRECISION SAVE178
      DOUBLE PRECISION SAVE179
      DOUBLE PRECISION SAVE18
      DOUBLE PRECISION SAVE180
      DOUBLE PRECISION SAVE181
      DOUBLE PRECISION SAVE182
      DOUBLE PRECISION SAVE183
      DOUBLE PRECISION SAVE184
      DOUBLE PRECISION SAVE185
      DOUBLE PRECISION SAVE186
      DOUBLE PRECISION SAVE187
      DOUBLE PRECISION SAVE188
      DOUBLE PRECISION SAVE189
      DOUBLE PRECISION SAVE19
      DOUBLE PRECISION SAVE190
      DOUBLE PRECISION SAVE191
      DOUBLE PRECISION SAVE192
      DOUBLE PRECISION SAVE193
      DOUBLE PRECISION SAVE194
      DOUBLE PRECISION SAVE195
      DOUBLE PRECISION SAVE196
      DOUBLE PRECISION SAVE197
      DOUBLE PRECISION SAVE198
      DOUBLE PRECISION SAVE199
      DOUBLE PRECISION SAVE2
      DOUBLE PRECISION SAVE20
      DOUBLE PRECISION SAVE200
      DOUBLE PRECISION SAVE201
      DOUBLE PRECISION SAVE202
      DOUBLE PRECISION SAVE203
      DOUBLE PRECISION SAVE204
      DOUBLE PRECISION SAVE205
      DOUBLE PRECISION SAVE206
      DOUBLE PRECISION SAVE207
      DOUBLE PRECISION SAVE208
      DOUBLE PRECISION SAVE209
      DOUBLE PRECISION SAVE21
      DOUBLE PRECISION SAVE210
      DOUBLE PRECISION SAVE211
      DOUBLE PRECISION SAVE212
      DOUBLE PRECISION SAVE213
      DOUBLE PRECISION SAVE214
      DOUBLE PRECISION SAVE215
      DOUBLE PRECISION SAVE216
      DOUBLE PRECISION SAVE217
      DOUBLE PRECISION SAVE218
      DOUBLE PRECISION SAVE219
      DOUBLE PRECISION SAVE22
      DOUBLE PRECISION SAVE220
      DOUBLE PRECISION SAVE221
      DOUBLE PRECISION SAVE222
      DOUBLE PRECISION SAVE223
      DOUBLE PRECISION SAVE224
      DOUBLE PRECISION SAVE225
      DOUBLE PRECISION SAVE226
      DOUBLE PRECISION SAVE227
      DOUBLE PRECISION SAVE228
      DOUBLE PRECISION SAVE229
      DOUBLE PRECISION SAVE23
      DOUBLE PRECISION SAVE230
      DOUBLE PRECISION SAVE231
      DOUBLE PRECISION SAVE232
      DOUBLE PRECISION SAVE233
      DOUBLE PRECISION SAVE234
      DOUBLE PRECISION SAVE235
      DOUBLE PRECISION SAVE236
      DOUBLE PRECISION SAVE237
      DOUBLE PRECISION SAVE24
      DOUBLE PRECISION SAVE25
      DOUBLE PRECISION SAVE26
      DOUBLE PRECISION SAVE27
      DOUBLE PRECISION SAVE28
      DOUBLE PRECISION SAVE29
      DOUBLE PRECISION SAVE3
      DOUBLE PRECISION SAVE30
      DOUBLE PRECISION SAVE31
      DOUBLE PRECISION SAVE32
      DOUBLE PRECISION SAVE33
      DOUBLE PRECISION SAVE34
      DOUBLE PRECISION SAVE35
      DOUBLE PRECISION SAVE36
      DOUBLE PRECISION SAVE37
      DOUBLE PRECISION SAVE38
      DOUBLE PRECISION SAVE39
      DOUBLE PRECISION SAVE4
      DOUBLE PRECISION SAVE40
      DOUBLE PRECISION SAVE41
      DOUBLE PRECISION SAVE42
      DOUBLE PRECISION SAVE43
      DOUBLE PRECISION SAVE44
      DOUBLE PRECISION SAVE45
      DOUBLE PRECISION SAVE46
      DOUBLE PRECISION SAVE47
      DOUBLE PRECISION SAVE48
      DOUBLE PRECISION SAVE49
      DOUBLE PRECISION SAVE5
      DOUBLE PRECISION SAVE50
      DOUBLE PRECISION SAVE51
      DOUBLE PRECISION SAVE52
      DOUBLE PRECISION SAVE53
      DOUBLE PRECISION SAVE54
      DOUBLE PRECISION SAVE55
      DOUBLE PRECISION SAVE56
      DOUBLE PRECISION SAVE57
      DOUBLE PRECISION SAVE58
      DOUBLE PRECISION SAVE59
      DOUBLE PRECISION SAVE6
      DOUBLE PRECISION SAVE60
      DOUBLE PRECISION SAVE61
      DOUBLE PRECISION SAVE62
      DOUBLE PRECISION SAVE63
      DOUBLE PRECISION SAVE64
      DOUBLE PRECISION SAVE65
      DOUBLE PRECISION SAVE66
      DOUBLE PRECISION SAVE67
      DOUBLE PRECISION SAVE68
      DOUBLE PRECISION SAVE69
      DOUBLE PRECISION SAVE7
      DOUBLE PRECISION SAVE70
      DOUBLE PRECISION SAVE71
      DOUBLE PRECISION SAVE72
      DOUBLE PRECISION SAVE73
      DOUBLE PRECISION SAVE74
      DOUBLE PRECISION SAVE75
      DOUBLE PRECISION SAVE76
      DOUBLE PRECISION SAVE77
      DOUBLE PRECISION SAVE78
      DOUBLE PRECISION SAVE79
      DOUBLE PRECISION SAVE8
      DOUBLE PRECISION SAVE80
      DOUBLE PRECISION SAVE81
      DOUBLE PRECISION SAVE82
      DOUBLE PRECISION SAVE83
      DOUBLE PRECISION SAVE84
      DOUBLE PRECISION SAVE85
      DOUBLE PRECISION SAVE86
      DOUBLE PRECISION SAVE87
      DOUBLE PRECISION SAVE88
      DOUBLE PRECISION SAVE89
      DOUBLE PRECISION SAVE9
      DOUBLE PRECISION SAVE90
      DOUBLE PRECISION SAVE91
      DOUBLE PRECISION SAVE92
      DOUBLE PRECISION SAVE93
      DOUBLE PRECISION SAVE94
      DOUBLE PRECISION SAVE95
      DOUBLE PRECISION SAVE96
      DOUBLE PRECISION SAVE97
      DOUBLE PRECISION SAVE98
      DOUBLE PRECISION SAVE99

C
C Trajectory
C

      SAVE1 = W(1)
      W(1) = RK(1)*Y(72)
      SAVE2 = W(2)
      W(2) = RK(2)*Y(50)
      SAVE3 = W(3)
      W(3) = RK(3)*Y(50)
      SAVE4 = W(4)
      W(4) = RK(4)*Y(23)
      SAVE5 = W(5)
      W(5) = RK(5)*Y(55)
      SAVE6 = W(6)
      W(6) = RK(6)*Y(15)
      SAVE7 = W(7)
      W(7) = RK(7)*Y(68)
      SAVE8 = W(8)
      W(8) = RK(8)*Y(68)
      SAVE9 = W(9)
      W(9) = RK(9)*Y(27)
      SAVE10 = W(10)
      W(10) = RK(10)*Y(66)
      SAVE11 = W(11)
      W(11) = RK(11)*Y(66)
      SAVE12 = W(12)
      W(12) = RK(12)*Y(61)
      SAVE13 = W(13)
      W(13) = RK(13)*Y(16)
      SAVE14 = W(14)
      W(14) = RK(14)*Y(53)
      SAVE15 = W(15)
      W(15) = RK(15)*Y(28)
      SAVE16 = W(16)
      W(16) = RK(16)*Y(59)
      SAVE17 = W(17)
      W(17) = RK(17)*Y(51)
      SAVE18 = W(18)
      W(18) = RK(18)*Y(51)
      SAVE19 = W(19)
      W(19) = RK(19)*Y(54)
      SAVE20 = W(20)
      W(20) = RK(20)*Y(48)
      SAVE21 = W(21)
      W(21) = RK(21)*Y(70)
      SAVE22 = W(22)
      W(22) = RK(22)*Y(49)
      SAVE23 = W(23)
      W(23) = RK(23)*Y(24)
      SAVE24 = W(24)
      W(24) = RK(24)*Y(35)
      SAVE25 = W(25)
      W(25) = RK(25)*Y(35)*Y(50)
      SAVE26 = W(26)
      W(26) = RK(26)*Y(7)
      SAVE27 = W(27)
      W(27) = RK(27)*Y(7)
      SAVE28 = W(28)
      W(28) = RK(28)*Y(7)
      SAVE29 = W(29)
      W(29) = RK(29)*Y(50)*Y(62)
      SAVE30 = W(30)
      W(30) = RK(30)*Y(50)*Y(71)
      SAVE31 = W(31)
      W(31) = RK(31)*Y(62)*Y(71)
      SAVE32 = W(32)
      W(32) = RK(32)*Y(27)*Y(62)
      SAVE33 = W(33)
      W(33) = RK(33)*Y(71)*Y(71)
      SAVE34 = W(34)
      W(34) = RK(34)*Y(71)*Y(71)
      SAVE35 = W(35)
      W(35) = RK(35)*Y(35)*Y(67)
      SAVE36 = W(36)
      W(36) = RK(36)*Y(35)*Y(72)
      SAVE37 = W(37)
      W(37) = RK(37)*Y(35)*Y(72)
      SAVE38 = W(38)
      W(38) = RK(38)*Y(62)*Y(67)
      SAVE39 = W(39)
      W(39) = RK(39)*Y(62)*Y(72)
      SAVE40 = W(40)
      W(40) = RK(40)*Y(62)*Y(68)
      SAVE41 = W(41)
      W(41) = RK(41)*Y(71)*Y(67)
      SAVE42 = W(42)
      W(42) = RK(42)*Y(71)*Y(72)
      SAVE43 = W(43)
      W(43) = RK(43)*Y(15)
      SAVE44 = W(44)
      W(44) = RK(44)*Y(71)*Y(68)
      SAVE45 = W(45)
      W(45) = RK(45)*Y(62)*Y(23)
      SAVE46 = W(46)
      W(46) = RK(46)*Y(62)*Y(55)
      SAVE47 = W(47)
      W(47) = RK(47)*Y(62)*Y(15)
      SAVE48 = W(48)
      W(48) = RK(48)*Y(50)*Y(67)
      SAVE49 = W(49)
      W(49) = RK(49)*Y(50)*Y(72)
      SAVE50 = W(50)
      W(50) = RK(50)*Y(67)*Y(67)
      SAVE51 = W(51)
      W(51) = RK(51)*Y(68)*Y(67)
      SAVE52 = W(52)
      W(52) = RK(52)*Y(68)*Y(72)
      SAVE53 = W(53)
      W(53) = RK(53)*Y(68)*Y(72)
      SAVE54 = W(54)
      W(54) = RK(54)*Y(9)
      SAVE55 = W(55)
      W(55) = RK(55)*Y(68)*Y(68)
      SAVE56 = W(56)
      W(56) = RK(56)*Y(62)
      SAVE57 = W(57)
      W(57) = RK(57)*Y(62)*Y(1)
      SAVE58 = W(58)
      W(58) = RK(58)*Y(52)*Y(62)
      SAVE59 = W(59)
      W(59) = RK(59)*Y(19)*Y(35)
      SAVE60 = W(60)
      W(60) = RK(60)*Y(49)*Y(35)
      SAVE61 = W(61)
      W(61) = RK(61)*Y(20)*Y(62)
      SAVE62 = W(62)
      W(62) = RK(62)*Y(21)*Y(62)
      SAVE63 = W(63)
      W(63) = RK(63)*Y(2)*Y(62)
      SAVE64 = W(64)
      W(64) = RK(64)*Y(3)*Y(62)
      SAVE65 = W(65)
      W(65) = RK(65)*Y(4)*Y(62)
      SAVE66 = W(66)
      W(66) = RK(66)*Y(11)*Y(62)
      SAVE67 = W(67)
      W(67) = RK(67)*Y(40)*Y(62)
      SAVE68 = W(68)
      W(68) = RK(68)*Y(44)*Y(62)
      SAVE69 = W(69)
      W(69) = RK(69)*Y(12)*Y(62)
      SAVE70 = W(70)
      W(70) = RK(70)*Y(19)*Y(62)
      SAVE71 = W(71)
      W(71) = RK(71)*Y(13)*Y(62)
      SAVE72 = W(72)
      W(72) = RK(72)*Y(14)*Y(62)
      SAVE73 = W(73)
      W(73) = RK(73)*Y(5)*Y(62)
      SAVE74 = W(74)
      W(74) = RK(74)*Y(6)*Y(62)
      SAVE75 = W(75)
      W(75) = RK(75)*Y(30)*Y(62)
      SAVE76 = W(76)
      W(76) = RK(76)*Y(66)*Y(62)
      SAVE77 = W(77)
      W(77) = RK(77)*Y(61)*Y(62)
      SAVE78 = W(78)
      W(78) = RK(78)*Y(59)*Y(62)
      SAVE79 = W(79)
      W(79) = RK(79)*Y(24)*Y(62)
      SAVE80 = W(80)
      W(80) = RK(80)*Y(51)*Y(62)
      SAVE81 = W(81)
      W(81) = RK(81)*Y(54)*Y(62)
      SAVE82 = W(82)
      W(82) = RK(82)*Y(49)*Y(62)
      SAVE83 = W(83)
      W(83) = RK(83)*Y(62)*Y(48)
      SAVE84 = W(84)
      W(84) = RK(84)*Y(62)*Y(10)
      SAVE85 = W(85)
      W(85) = RK(85)*Y(16)*Y(62)
      SAVE86 = W(86)
      W(86) = RK(86)*Y(53)*Y(62)
      SAVE87 = W(87)
      W(87) = RK(87)*Y(28)*Y(62)
      SAVE88 = W(88)
      W(88) = RK(88)*Y(26)*Y(62)
      SAVE89 = W(89)
      W(89) = RK(89)*Y(25)*Y(62)
      SAVE90 = W(90)
      W(90) = RK(90)*Y(70)*Y(62)
      SAVE91 = W(91)
      W(91) = RK(91)*Y(66)*Y(68)
      SAVE92 = W(92)
      W(92) = RK(92)*Y(61)*Y(68)
      SAVE93 = W(93)
      W(93) = RK(93)*Y(51)*Y(68)
      SAVE94 = W(94)
      W(94) = RK(94)*Y(54)*Y(68)
      SAVE95 = W(95)
      W(95) = RK(95)*Y(49)*Y(68)
      SAVE96 = W(96)
      W(96) = RK(96)*Y(48)*Y(68)
      SAVE97 = W(97)
      W(97) = RK(97)*Y(30)*Y(68)
      SAVE98 = W(98)
      W(98) = RK(98)*Y(11)*Y(68)
      SAVE99 = W(99)
      W(99) = RK(99)*Y(40)*Y(68)
      SAVE100 = W(100)
      W(100) = RK(100)*Y(44)*Y(68)
      SAVE101 = W(101)
      W(101) = RK(101)*Y(12)*Y(68)
      SAVE102 = W(102)
      W(102) = RK(102)*Y(19)*Y(68)
      SAVE103 = W(103)
      W(103) = RK(103)*Y(13)*Y(68)
      SAVE104 = W(104)
      W(104) = RK(104)*Y(14)*Y(68)
      SAVE105 = W(105)
      W(105) = RK(105)*Y(25)*Y(68)
      SAVE106 = W(106)
      W(106) = RK(106)*Y(11)*Y(50)
      SAVE107 = W(107)
      W(107) = RK(107)*Y(40)*Y(50)
      SAVE108 = W(108)
      W(108) = RK(108)*Y(44)*Y(50)
      SAVE109 = W(109)
      W(109) = RK(109)*Y(12)*Y(50)
      SAVE110 = W(110)
      W(110) = RK(110)*Y(19)*Y(50)
      SAVE111 = W(111)
      W(111) = RK(111)*Y(13)*Y(50)
      SAVE112 = W(112)
      W(112) = RK(112)*Y(14)*Y(50)
      SAVE113 = W(113)
      W(113) = RK(113)*Y(49)*Y(50)
      SAVE114 = W(114)
      W(114) = RK(114)*Y(48)*Y(50)
      SAVE115 = W(115)
      W(115) = RK(115)*Y(25)*Y(50)
      SAVE116 = W(116)
      W(116) = RK(116)*Y(29)*Y(72)
      SAVE117 = W(117)
      W(117) = RK(117)*Y(29)*Y(71)
      SAVE118 = W(118)
      W(118) = RK(118)*Y(17)*Y(72)
      SAVE119 = W(119)
      W(119) = RK(119)*Y(17)
      SAVE120 = W(120)
      W(120) = RK(120)*Y(17)*Y(50)
      SAVE121 = W(121)
      W(121) = RK(121)*Y(18)*Y(72)
      SAVE122 = W(122)
      W(122) = RK(122)*Y(18)
      SAVE123 = W(123)
      W(123) = RK(123)*Y(18)*Y(50)
      SAVE124 = W(124)
      W(124) = RK(124)*Y(22)*Y(72)
      SAVE125 = W(125)
      W(125) = RK(125)*Y(22)
      SAVE126 = W(126)
      W(126) = RK(126)*Y(22)*Y(50)
      SAVE127 = W(127)
      W(127) = RK(127)*Y(69)*Y(72)
      SAVE128 = W(128)
      W(128) = RK(128)*Y(26)
      SAVE129 = W(129)
      W(129) = RK(129)*Y(56)*Y(72)
      SAVE130 = W(130)
      W(130) = RK(130)*Y(25)
      SAVE131 = W(131)
      W(131) = RK(131)*Y(63)*Y(67)
      SAVE132 = W(132)
      W(132) = RK(132)*Y(60)*Y(67)
      SAVE133 = W(133)
      W(133) = RK(133)*Y(64)*Y(67)
      SAVE134 = W(134)
      W(134) = RK(134)*Y(36)*Y(67)
      SAVE135 = W(135)
      W(135) = RK(135)*Y(37)*Y(67)
      SAVE136 = W(136)
      W(136) = RK(136)*Y(38)*Y(67)
      SAVE137 = W(137)
      W(137) = RK(137)*Y(41)*Y(67)
      SAVE138 = W(138)
      W(138) = RK(138)*Y(45)*Y(67)
      SAVE139 = W(139)
      W(139) = RK(139)*Y(39)*Y(67)
      SAVE140 = W(140)
      W(140) = RK(140)*Y(42)*Y(67)
      SAVE141 = W(141)
      W(141) = RK(141)*Y(43)*Y(67)
      SAVE142 = W(142)
      W(142) = RK(142)*Y(31)*Y(67)
      SAVE143 = W(143)
      W(143) = RK(143)*Y(32)*Y(67)
      SAVE144 = W(144)
      W(144) = RK(144)*Y(33)*Y(67)
      SAVE145 = W(145)
      W(145) = RK(145)*Y(69)*Y(67)
      SAVE146 = W(146)
      W(146) = RK(146)*Y(56)*Y(67)
      SAVE147 = W(147)
      W(147) = RK(147)*Y(58)*Y(67)
      SAVE148 = W(148)
      W(148) = RK(148)*Y(47)*Y(67)
      SAVE149 = W(149)
      W(149) = RK(149)*Y(46)*Y(67)
      SAVE150 = W(150)
      W(150) = RK(150)*Y(63)*Y(71)
      SAVE151 = W(151)
      W(151) = RK(151)*Y(60)*Y(71)
      SAVE152 = W(152)
      W(152) = RK(152)*Y(64)*Y(71)
      SAVE153 = W(153)
      W(153) = RK(153)*Y(36)*Y(71)
      SAVE154 = W(154)
      W(154) = RK(154)*Y(37)*Y(71)
      SAVE155 = W(155)
      W(155) = RK(155)*Y(38)*Y(71)
      SAVE156 = W(156)
      W(156) = RK(156)*Y(41)*Y(71)
      SAVE157 = W(157)
      W(157) = RK(157)*Y(45)*Y(71)
      SAVE158 = W(158)
      W(158) = RK(158)*Y(39)*Y(71)
      SAVE159 = W(159)
      W(159) = RK(159)*Y(42)*Y(71)
      SAVE160 = W(160)
      W(160) = RK(160)*Y(43)*Y(71)
      SAVE161 = W(161)
      W(161) = RK(161)*Y(31)*Y(71)
      SAVE162 = W(162)
      W(162) = RK(162)*Y(32)*Y(71)
      SAVE163 = W(163)
      W(163) = RK(163)*Y(33)*Y(71)
      SAVE164 = W(164)
      W(164) = RK(164)*Y(69)*Y(71)
      SAVE165 = W(165)
      W(165) = RK(165)*Y(69)*Y(71)
      SAVE166 = W(166)
      W(166) = RK(166)*Y(56)*Y(71)
      SAVE167 = W(167)
      W(167) = RK(167)*Y(56)*Y(71)
      SAVE168 = W(168)
      W(168) = RK(168)*Y(58)*Y(71)
      SAVE169 = W(169)
      W(169) = RK(169)*Y(47)*Y(71)
      SAVE170 = W(170)
      W(170) = RK(170)*Y(46)*Y(71)
      SAVE171 = W(171)
      W(171) = RK(171)*Y(63)*Y(63)
      SAVE172 = W(172)
      W(172) = RK(172)*Y(60)*Y(63)
      SAVE173 = W(173)
      W(173) = RK(173)*Y(64)*Y(63)
      SAVE174 = W(174)
      W(174) = RK(174)*Y(36)*Y(63)
      SAVE175 = W(175)
      W(175) = RK(175)*Y(37)*Y(63)
      SAVE176 = W(176)
      W(176) = RK(176)*Y(38)*Y(63)
      SAVE177 = W(177)
      W(177) = RK(177)*Y(41)*Y(63)
      SAVE178 = W(178)
      W(178) = RK(178)*Y(45)*Y(63)
      SAVE179 = W(179)
      W(179) = RK(179)*Y(39)*Y(63)
      SAVE180 = W(180)
      W(180) = RK(180)*Y(42)*Y(63)
      SAVE181 = W(181)
      W(181) = RK(181)*Y(43)*Y(63)
      SAVE182 = W(182)
      W(182) = RK(182)*Y(31)*Y(63)
      SAVE183 = W(183)
      W(183) = RK(183)*Y(32)*Y(63)
      SAVE184 = W(184)
      W(184) = RK(184)*Y(33)*Y(63)
      SAVE185 = W(185)
      W(185) = RK(185)*Y(69)*Y(63)
      SAVE186 = W(186)
      W(186) = RK(186)*Y(69)*Y(63)
      SAVE187 = W(187)
      W(187) = RK(187)*Y(56)*Y(63)
      SAVE188 = W(188)
      W(188) = RK(188)*Y(56)*Y(63)
      SAVE189 = W(189)
      W(189) = RK(189)*Y(58)*Y(63)
      SAVE190 = W(190)
      W(190) = RK(190)*Y(47)*Y(63)
      SAVE191 = W(191)
      W(191) = RK(191)*Y(46)*Y(63)
      SAVE192 = W(192)
      W(192) = RK(192)*Y(60)*Y(69)
      SAVE193 = W(193)
      W(193) = RK(193)*Y(64)*Y(69)
      SAVE194 = W(194)
      W(194) = RK(194)*Y(36)*Y(69)
      SAVE195 = W(195)
      W(195) = RK(195)*Y(37)*Y(69)
      SAVE196 = W(196)
      W(196) = RK(196)*Y(38)*Y(69)
      SAVE197 = W(197)
      W(197) = RK(197)*Y(41)*Y(69)
      SAVE198 = W(198)
      W(198) = RK(198)*Y(45)*Y(69)
      SAVE199 = W(199)
      W(199) = RK(199)*Y(39)*Y(69)
      SAVE200 = W(200)
      W(200) = RK(200)*Y(42)*Y(69)
      SAVE201 = W(201)
      W(201) = RK(201)*Y(43)*Y(69)
      SAVE202 = W(202)
      W(202) = RK(202)*Y(31)*Y(69)
      SAVE203 = W(203)
      W(203) = RK(203)*Y(32)*Y(69)
      SAVE204 = W(204)
      W(204) = RK(204)*Y(33)*Y(69)
      SAVE205 = W(205)
      W(205) = RK(205)*Y(69)*Y(69)
      SAVE206 = W(206)
      W(206) = RK(206)*Y(56)*Y(69)
      SAVE207 = W(207)
      W(207) = RK(207)*Y(58)*Y(69)
      SAVE208 = W(208)
      W(208) = RK(208)*Y(47)*Y(69)
      SAVE209 = W(209)
      W(209) = RK(209)*Y(46)*Y(69)
      SAVE210 = W(210)
      W(210) = RK(210)*Y(47)*Y(47)
      SAVE211 = W(211)
      W(211) = RK(211)*Y(47)*Y(46)
      SAVE212 = W(212)
      W(212) = RK(212)*Y(46)*Y(46)
      SAVE213 = W(213)
      W(213) = RK(213)*Y(63)*Y(68)
      SAVE214 = W(214)
      W(214) = RK(214)*Y(60)*Y(68)
      SAVE215 = W(215)
      W(215) = RK(215)*Y(64)*Y(68)
      SAVE216 = W(216)
      W(216) = RK(216)*Y(36)*Y(68)
      SAVE217 = W(217)
      W(217) = RK(217)*Y(37)*Y(68)
      SAVE218 = W(218)
      W(218) = RK(218)*Y(38)*Y(68)
      SAVE219 = W(219)
      W(219) = RK(219)*Y(41)*Y(68)
      SAVE220 = W(220)
      W(220) = RK(220)*Y(45)*Y(68)
      SAVE221 = W(221)
      W(221) = RK(221)*Y(39)*Y(68)
      SAVE222 = W(222)
      W(222) = RK(222)*Y(42)*Y(68)
      SAVE223 = W(223)
      W(223) = RK(223)*Y(43)*Y(68)
      SAVE224 = W(224)
      W(224) = RK(224)*Y(31)*Y(68)
      SAVE225 = W(225)
      W(225) = RK(225)*Y(32)*Y(68)
      SAVE226 = W(226)
      W(226) = RK(226)*Y(33)*Y(68)
      SAVE227 = W(227)
      W(227) = RK(227)*Y(69)*Y(68)
      SAVE228 = W(228)
      W(228) = RK(228)*Y(56)*Y(68)
      SAVE229 = W(229)
      W(229) = RK(229)*Y(58)*Y(68)
      SAVE230 = W(230)
      W(230) = RK(230)*Y(47)*Y(68)
      SAVE231 = W(231)
      W(231) = RK(231)*Y(46)*Y(68)
      SAVE232 = W(232)
      W(232) = RK(232)*Y(65)*Y(71)
      SAVE233 = W(233)
      W(233) = RK(233)*Y(65)*Y(63)
      SAVE234 = W(234)
      W(234) = RK(234)*Y(65)*Y(69)
      SAVE235 = W(235)
      W(235) = RK(235)*Y(65)*Y(65)
      SAVE236 = W(236)
      W(236) = RK(236)*Y(65)*Y(67)
      SAVE237 = W(237)
      W(237) = RK(237)*Y(65)*Y(68)
C
C Transposed linear forms
C

      W(237) = SAVE237
      YCCL(68) = YCCL(68)+WCCL(237)*(Y(65)*RK(237))
      YCCL(65) = YCCL(65)+WCCL(237)*(Y(68)*RK(237))
      WCCL(237) = 0d0
      W(236) = SAVE236
      YCCL(67) = YCCL(67)+WCCL(236)*(Y(65)*RK(236))
      YCCL(65) = YCCL(65)+WCCL(236)*(Y(67)*RK(236))
      WCCL(236) = 0d0
      W(235) = SAVE235
      YCCL(65) = YCCL(65)+WCCL(235)*((Y(65)+Y(65))*RK(235))
      WCCL(235) = 0d0
      W(234) = SAVE234
      YCCL(69) = YCCL(69)+WCCL(234)*(Y(65)*RK(234))
      YCCL(65) = YCCL(65)+WCCL(234)*(Y(69)*RK(234))
      WCCL(234) = 0d0
      W(233) = SAVE233
      YCCL(63) = YCCL(63)+WCCL(233)*(Y(65)*RK(233))
      YCCL(65) = YCCL(65)+WCCL(233)*(Y(63)*RK(233))
      WCCL(233) = 0d0
      W(232) = SAVE232
      YCCL(71) = YCCL(71)+WCCL(232)*(Y(65)*RK(232))
      YCCL(65) = YCCL(65)+WCCL(232)*(Y(71)*RK(232))
      WCCL(232) = 0d0
      W(231) = SAVE231
      YCCL(68) = YCCL(68)+WCCL(231)*(Y(46)*RK(231))
      YCCL(46) = YCCL(46)+WCCL(231)*(Y(68)*RK(231))
      WCCL(231) = 0d0
      W(230) = SAVE230
      YCCL(68) = YCCL(68)+WCCL(230)*(Y(47)*RK(230))
      YCCL(47) = YCCL(47)+WCCL(230)*(Y(68)*RK(230))
      WCCL(230) = 0d0
      W(229) = SAVE229
      YCCL(68) = YCCL(68)+WCCL(229)*(Y(58)*RK(229))
      YCCL(58) = YCCL(58)+WCCL(229)*(Y(68)*RK(229))
      WCCL(229) = 0d0
      W(228) = SAVE228
      YCCL(68) = YCCL(68)+WCCL(228)*(Y(56)*RK(228))
      YCCL(56) = YCCL(56)+WCCL(228)*(Y(68)*RK(228))
      WCCL(228) = 0d0
      W(227) = SAVE227
      YCCL(68) = YCCL(68)+WCCL(227)*(Y(69)*RK(227))
      YCCL(69) = YCCL(69)+WCCL(227)*(Y(68)*RK(227))
      WCCL(227) = 0d0
      W(226) = SAVE226
      YCCL(68) = YCCL(68)+WCCL(226)*(Y(33)*RK(226))
      YCCL(33) = YCCL(33)+WCCL(226)*(Y(68)*RK(226))
      WCCL(226) = 0d0
      W(225) = SAVE225
      YCCL(68) = YCCL(68)+WCCL(225)*(Y(32)*RK(225))
      YCCL(32) = YCCL(32)+WCCL(225)*(Y(68)*RK(225))
      WCCL(225) = 0d0
      W(224) = SAVE224
      YCCL(68) = YCCL(68)+WCCL(224)*(Y(31)*RK(224))
      YCCL(31) = YCCL(31)+WCCL(224)*(Y(68)*RK(224))
      WCCL(224) = 0d0
      W(223) = SAVE223
      YCCL(68) = YCCL(68)+WCCL(223)*(Y(43)*RK(223))
      YCCL(43) = YCCL(43)+WCCL(223)*(Y(68)*RK(223))
      WCCL(223) = 0d0
      W(222) = SAVE222
      YCCL(68) = YCCL(68)+WCCL(222)*(Y(42)*RK(222))
      YCCL(42) = YCCL(42)+WCCL(222)*(Y(68)*RK(222))
      WCCL(222) = 0d0
      W(221) = SAVE221
      YCCL(68) = YCCL(68)+WCCL(221)*(Y(39)*RK(221))
      YCCL(39) = YCCL(39)+WCCL(221)*(Y(68)*RK(221))
      WCCL(221) = 0d0
      W(220) = SAVE220
      YCCL(68) = YCCL(68)+WCCL(220)*(Y(45)*RK(220))
      YCCL(45) = YCCL(45)+WCCL(220)*(Y(68)*RK(220))
      WCCL(220) = 0d0
      W(219) = SAVE219
      YCCL(68) = YCCL(68)+WCCL(219)*(Y(41)*RK(219))
      YCCL(41) = YCCL(41)+WCCL(219)*(Y(68)*RK(219))
      WCCL(219) = 0d0
      W(218) = SAVE218
      YCCL(68) = YCCL(68)+WCCL(218)*(Y(38)*RK(218))
      YCCL(38) = YCCL(38)+WCCL(218)*(Y(68)*RK(218))
      WCCL(218) = 0d0
      W(217) = SAVE217
      YCCL(68) = YCCL(68)+WCCL(217)*(Y(37)*RK(217))
      YCCL(37) = YCCL(37)+WCCL(217)*(Y(68)*RK(217))
      WCCL(217) = 0d0
      W(216) = SAVE216
      YCCL(68) = YCCL(68)+WCCL(216)*(Y(36)*RK(216))
      YCCL(36) = YCCL(36)+WCCL(216)*(Y(68)*RK(216))
      WCCL(216) = 0d0
      W(215) = SAVE215
      YCCL(68) = YCCL(68)+WCCL(215)*(Y(64)*RK(215))
      YCCL(64) = YCCL(64)+WCCL(215)*(Y(68)*RK(215))
      WCCL(215) = 0d0
      W(214) = SAVE214
      YCCL(68) = YCCL(68)+WCCL(214)*(Y(60)*RK(214))
      YCCL(60) = YCCL(60)+WCCL(214)*(Y(68)*RK(214))
      WCCL(214) = 0d0
      W(213) = SAVE213
      YCCL(68) = YCCL(68)+WCCL(213)*(Y(63)*RK(213))
      YCCL(63) = YCCL(63)+WCCL(213)*(Y(68)*RK(213))
      WCCL(213) = 0d0
      W(212) = SAVE212
      YCCL(46) = YCCL(46)+WCCL(212)*((Y(46)+Y(46))*RK(212))
      WCCL(212) = 0d0
      W(211) = SAVE211
      YCCL(46) = YCCL(46)+WCCL(211)*(Y(47)*RK(211))
      YCCL(47) = YCCL(47)+WCCL(211)*(Y(46)*RK(211))
      WCCL(211) = 0d0
      W(210) = SAVE210
      YCCL(47) = YCCL(47)+WCCL(210)*((Y(47)+Y(47))*RK(210))
      WCCL(210) = 0d0
      W(209) = SAVE209
      YCCL(69) = YCCL(69)+WCCL(209)*(Y(46)*RK(209))
      YCCL(46) = YCCL(46)+WCCL(209)*(Y(69)*RK(209))
      WCCL(209) = 0d0
      W(208) = SAVE208
      YCCL(69) = YCCL(69)+WCCL(208)*(Y(47)*RK(208))
      YCCL(47) = YCCL(47)+WCCL(208)*(Y(69)*RK(208))
      WCCL(208) = 0d0
      W(207) = SAVE207
      YCCL(69) = YCCL(69)+WCCL(207)*(Y(58)*RK(207))
      YCCL(58) = YCCL(58)+WCCL(207)*(Y(69)*RK(207))
      WCCL(207) = 0d0
      W(206) = SAVE206
      YCCL(69) = YCCL(69)+WCCL(206)*(Y(56)*RK(206))
      YCCL(56) = YCCL(56)+WCCL(206)*(Y(69)*RK(206))
      WCCL(206) = 0d0
      W(205) = SAVE205
      YCCL(69) = YCCL(69)+WCCL(205)*((Y(69)+Y(69))*RK(205))
      WCCL(205) = 0d0
      W(204) = SAVE204
      YCCL(69) = YCCL(69)+WCCL(204)*(Y(33)*RK(204))
      YCCL(33) = YCCL(33)+WCCL(204)*(Y(69)*RK(204))
      WCCL(204) = 0d0
      W(203) = SAVE203
      YCCL(69) = YCCL(69)+WCCL(203)*(Y(32)*RK(203))
      YCCL(32) = YCCL(32)+WCCL(203)*(Y(69)*RK(203))
      WCCL(203) = 0d0
      W(202) = SAVE202
      YCCL(69) = YCCL(69)+WCCL(202)*(Y(31)*RK(202))
      YCCL(31) = YCCL(31)+WCCL(202)*(Y(69)*RK(202))
      WCCL(202) = 0d0
      W(201) = SAVE201
      YCCL(69) = YCCL(69)+WCCL(201)*(Y(43)*RK(201))
      YCCL(43) = YCCL(43)+WCCL(201)*(Y(69)*RK(201))
      WCCL(201) = 0d0
      W(200) = SAVE200
      YCCL(69) = YCCL(69)+WCCL(200)*(Y(42)*RK(200))
      YCCL(42) = YCCL(42)+WCCL(200)*(Y(69)*RK(200))
      WCCL(200) = 0d0
      W(199) = SAVE199
      YCCL(69) = YCCL(69)+WCCL(199)*(Y(39)*RK(199))
      YCCL(39) = YCCL(39)+WCCL(199)*(Y(69)*RK(199))
      WCCL(199) = 0d0
      W(198) = SAVE198
      YCCL(69) = YCCL(69)+WCCL(198)*(Y(45)*RK(198))
      YCCL(45) = YCCL(45)+WCCL(198)*(Y(69)*RK(198))
      WCCL(198) = 0d0
      W(197) = SAVE197
      YCCL(69) = YCCL(69)+WCCL(197)*(Y(41)*RK(197))
      YCCL(41) = YCCL(41)+WCCL(197)*(Y(69)*RK(197))
      WCCL(197) = 0d0
      W(196) = SAVE196
      YCCL(69) = YCCL(69)+WCCL(196)*(Y(38)*RK(196))
      YCCL(38) = YCCL(38)+WCCL(196)*(Y(69)*RK(196))
      WCCL(196) = 0d0
      W(195) = SAVE195
      YCCL(69) = YCCL(69)+WCCL(195)*(Y(37)*RK(195))
      YCCL(37) = YCCL(37)+WCCL(195)*(Y(69)*RK(195))
      WCCL(195) = 0d0
      W(194) = SAVE194
      YCCL(69) = YCCL(69)+WCCL(194)*(Y(36)*RK(194))
      YCCL(36) = YCCL(36)+WCCL(194)*(Y(69)*RK(194))
      WCCL(194) = 0d0
      W(193) = SAVE193
      YCCL(69) = YCCL(69)+WCCL(193)*(Y(64)*RK(193))
      YCCL(64) = YCCL(64)+WCCL(193)*(Y(69)*RK(193))
      WCCL(193) = 0d0
      W(192) = SAVE192
      YCCL(69) = YCCL(69)+WCCL(192)*(Y(60)*RK(192))
      YCCL(60) = YCCL(60)+WCCL(192)*(Y(69)*RK(192))
      WCCL(192) = 0d0
      W(191) = SAVE191
      YCCL(63) = YCCL(63)+WCCL(191)*(Y(46)*RK(191))
      YCCL(46) = YCCL(46)+WCCL(191)*(Y(63)*RK(191))
      WCCL(191) = 0d0
      W(190) = SAVE190
      YCCL(63) = YCCL(63)+WCCL(190)*(Y(47)*RK(190))
      YCCL(47) = YCCL(47)+WCCL(190)*(Y(63)*RK(190))
      WCCL(190) = 0d0
      W(189) = SAVE189
      YCCL(63) = YCCL(63)+WCCL(189)*(Y(58)*RK(189))
      YCCL(58) = YCCL(58)+WCCL(189)*(Y(63)*RK(189))
      WCCL(189) = 0d0
      W(188) = SAVE188
      YCCL(63) = YCCL(63)+WCCL(188)*(Y(56)*RK(188))
      YCCL(56) = YCCL(56)+WCCL(188)*(Y(63)*RK(188))
      WCCL(188) = 0d0
      W(187) = SAVE187
      YCCL(63) = YCCL(63)+WCCL(187)*(Y(56)*RK(187))
      YCCL(56) = YCCL(56)+WCCL(187)*(Y(63)*RK(187))
      WCCL(187) = 0d0
      W(186) = SAVE186
      YCCL(63) = YCCL(63)+WCCL(186)*(Y(69)*RK(186))
      YCCL(69) = YCCL(69)+WCCL(186)*(Y(63)*RK(186))
      WCCL(186) = 0d0
      W(185) = SAVE185
      YCCL(63) = YCCL(63)+WCCL(185)*(Y(69)*RK(185))
      YCCL(69) = YCCL(69)+WCCL(185)*(Y(63)*RK(185))
      WCCL(185) = 0d0
      W(184) = SAVE184
      YCCL(63) = YCCL(63)+WCCL(184)*(Y(33)*RK(184))
      YCCL(33) = YCCL(33)+WCCL(184)*(Y(63)*RK(184))
      WCCL(184) = 0d0
      W(183) = SAVE183
      YCCL(63) = YCCL(63)+WCCL(183)*(Y(32)*RK(183))
      YCCL(32) = YCCL(32)+WCCL(183)*(Y(63)*RK(183))
      WCCL(183) = 0d0
      W(182) = SAVE182
      YCCL(63) = YCCL(63)+WCCL(182)*(Y(31)*RK(182))
      YCCL(31) = YCCL(31)+WCCL(182)*(Y(63)*RK(182))
      WCCL(182) = 0d0
      W(181) = SAVE181
      YCCL(63) = YCCL(63)+WCCL(181)*(Y(43)*RK(181))
      YCCL(43) = YCCL(43)+WCCL(181)*(Y(63)*RK(181))
      WCCL(181) = 0d0
      W(180) = SAVE180
      YCCL(63) = YCCL(63)+WCCL(180)*(Y(42)*RK(180))
      YCCL(42) = YCCL(42)+WCCL(180)*(Y(63)*RK(180))
      WCCL(180) = 0d0
      W(179) = SAVE179
      YCCL(63) = YCCL(63)+WCCL(179)*(Y(39)*RK(179))
      YCCL(39) = YCCL(39)+WCCL(179)*(Y(63)*RK(179))
      WCCL(179) = 0d0
      W(178) = SAVE178
      YCCL(63) = YCCL(63)+WCCL(178)*(Y(45)*RK(178))
      YCCL(45) = YCCL(45)+WCCL(178)*(Y(63)*RK(178))
      WCCL(178) = 0d0
      W(177) = SAVE177
      YCCL(63) = YCCL(63)+WCCL(177)*(Y(41)*RK(177))
      YCCL(41) = YCCL(41)+WCCL(177)*(Y(63)*RK(177))
      WCCL(177) = 0d0
      W(176) = SAVE176
      YCCL(63) = YCCL(63)+WCCL(176)*(Y(38)*RK(176))
      YCCL(38) = YCCL(38)+WCCL(176)*(Y(63)*RK(176))
      WCCL(176) = 0d0
      W(175) = SAVE175
      YCCL(63) = YCCL(63)+WCCL(175)*(Y(37)*RK(175))
      YCCL(37) = YCCL(37)+WCCL(175)*(Y(63)*RK(175))
      WCCL(175) = 0d0
      W(174) = SAVE174
      YCCL(63) = YCCL(63)+WCCL(174)*(Y(36)*RK(174))
      YCCL(36) = YCCL(36)+WCCL(174)*(Y(63)*RK(174))
      WCCL(174) = 0d0
      W(173) = SAVE173
      YCCL(63) = YCCL(63)+WCCL(173)*(Y(64)*RK(173))
      YCCL(64) = YCCL(64)+WCCL(173)*(Y(63)*RK(173))
      WCCL(173) = 0d0
      W(172) = SAVE172
      YCCL(63) = YCCL(63)+WCCL(172)*(Y(60)*RK(172))
      YCCL(60) = YCCL(60)+WCCL(172)*(Y(63)*RK(172))
      WCCL(172) = 0d0
      W(171) = SAVE171
      YCCL(63) = YCCL(63)+WCCL(171)*((Y(63)+Y(63))*RK(171))
      WCCL(171) = 0d0
      W(170) = SAVE170
      YCCL(71) = YCCL(71)+WCCL(170)*(Y(46)*RK(170))
      YCCL(46) = YCCL(46)+WCCL(170)*(Y(71)*RK(170))
      WCCL(170) = 0d0
      W(169) = SAVE169
      YCCL(71) = YCCL(71)+WCCL(169)*(Y(47)*RK(169))
      YCCL(47) = YCCL(47)+WCCL(169)*(Y(71)*RK(169))
      WCCL(169) = 0d0
      W(168) = SAVE168
      YCCL(71) = YCCL(71)+WCCL(168)*(Y(58)*RK(168))
      YCCL(58) = YCCL(58)+WCCL(168)*(Y(71)*RK(168))
      WCCL(168) = 0d0
      W(167) = SAVE167
      YCCL(71) = YCCL(71)+WCCL(167)*(Y(56)*RK(167))
      YCCL(56) = YCCL(56)+WCCL(167)*(Y(71)*RK(167))
      WCCL(167) = 0d0
      W(166) = SAVE166
      YCCL(71) = YCCL(71)+WCCL(166)*(Y(56)*RK(166))
      YCCL(56) = YCCL(56)+WCCL(166)*(Y(71)*RK(166))
      WCCL(166) = 0d0
      W(165) = SAVE165
      YCCL(71) = YCCL(71)+WCCL(165)*(Y(69)*RK(165))
      YCCL(69) = YCCL(69)+WCCL(165)*(Y(71)*RK(165))
      WCCL(165) = 0d0
      W(164) = SAVE164
      YCCL(71) = YCCL(71)+WCCL(164)*(Y(69)*RK(164))
      YCCL(69) = YCCL(69)+WCCL(164)*(Y(71)*RK(164))
      WCCL(164) = 0d0
      W(163) = SAVE163
      YCCL(71) = YCCL(71)+WCCL(163)*(Y(33)*RK(163))
      YCCL(33) = YCCL(33)+WCCL(163)*(Y(71)*RK(163))
      WCCL(163) = 0d0
      W(162) = SAVE162
      YCCL(71) = YCCL(71)+WCCL(162)*(Y(32)*RK(162))
      YCCL(32) = YCCL(32)+WCCL(162)*(Y(71)*RK(162))
      WCCL(162) = 0d0
      W(161) = SAVE161
      YCCL(71) = YCCL(71)+WCCL(161)*(Y(31)*RK(161))
      YCCL(31) = YCCL(31)+WCCL(161)*(Y(71)*RK(161))
      WCCL(161) = 0d0
      W(160) = SAVE160
      YCCL(71) = YCCL(71)+WCCL(160)*(Y(43)*RK(160))
      YCCL(43) = YCCL(43)+WCCL(160)*(Y(71)*RK(160))
      WCCL(160) = 0d0
      W(159) = SAVE159
      YCCL(71) = YCCL(71)+WCCL(159)*(Y(42)*RK(159))
      YCCL(42) = YCCL(42)+WCCL(159)*(Y(71)*RK(159))
      WCCL(159) = 0d0
      W(158) = SAVE158
      YCCL(71) = YCCL(71)+WCCL(158)*(Y(39)*RK(158))
      YCCL(39) = YCCL(39)+WCCL(158)*(Y(71)*RK(158))
      WCCL(158) = 0d0
      W(157) = SAVE157
      YCCL(71) = YCCL(71)+WCCL(157)*(Y(45)*RK(157))
      YCCL(45) = YCCL(45)+WCCL(157)*(Y(71)*RK(157))
      WCCL(157) = 0d0
      W(156) = SAVE156
      YCCL(71) = YCCL(71)+WCCL(156)*(Y(41)*RK(156))
      YCCL(41) = YCCL(41)+WCCL(156)*(Y(71)*RK(156))
      WCCL(156) = 0d0
      W(155) = SAVE155
      YCCL(71) = YCCL(71)+WCCL(155)*(Y(38)*RK(155))
      YCCL(38) = YCCL(38)+WCCL(155)*(Y(71)*RK(155))
      WCCL(155) = 0d0
      W(154) = SAVE154
      YCCL(71) = YCCL(71)+WCCL(154)*(Y(37)*RK(154))
      YCCL(37) = YCCL(37)+WCCL(154)*(Y(71)*RK(154))
      WCCL(154) = 0d0
      W(153) = SAVE153
      YCCL(71) = YCCL(71)+WCCL(153)*(Y(36)*RK(153))
      YCCL(36) = YCCL(36)+WCCL(153)*(Y(71)*RK(153))
      WCCL(153) = 0d0
      W(152) = SAVE152
      YCCL(71) = YCCL(71)+WCCL(152)*(Y(64)*RK(152))
      YCCL(64) = YCCL(64)+WCCL(152)*(Y(71)*RK(152))
      WCCL(152) = 0d0
      W(151) = SAVE151
      YCCL(71) = YCCL(71)+WCCL(151)*(Y(60)*RK(151))
      YCCL(60) = YCCL(60)+WCCL(151)*(Y(71)*RK(151))
      WCCL(151) = 0d0
      W(150) = SAVE150
      YCCL(71) = YCCL(71)+WCCL(150)*(Y(63)*RK(150))
      YCCL(63) = YCCL(63)+WCCL(150)*(Y(71)*RK(150))
      WCCL(150) = 0d0
      W(149) = SAVE149
      YCCL(67) = YCCL(67)+WCCL(149)*(Y(46)*RK(149))
      YCCL(46) = YCCL(46)+WCCL(149)*(Y(67)*RK(149))
      WCCL(149) = 0d0
      W(148) = SAVE148
      YCCL(67) = YCCL(67)+WCCL(148)*(Y(47)*RK(148))
      YCCL(47) = YCCL(47)+WCCL(148)*(Y(67)*RK(148))
      WCCL(148) = 0d0
      W(147) = SAVE147
      YCCL(67) = YCCL(67)+WCCL(147)*(Y(58)*RK(147))
      YCCL(58) = YCCL(58)+WCCL(147)*(Y(67)*RK(147))
      WCCL(147) = 0d0
      W(146) = SAVE146
      YCCL(67) = YCCL(67)+WCCL(146)*(Y(56)*RK(146))
      YCCL(56) = YCCL(56)+WCCL(146)*(Y(67)*RK(146))
      WCCL(146) = 0d0
      W(145) = SAVE145
      YCCL(67) = YCCL(67)+WCCL(145)*(Y(69)*RK(145))
      YCCL(69) = YCCL(69)+WCCL(145)*(Y(67)*RK(145))
      WCCL(145) = 0d0
      W(144) = SAVE144
      YCCL(67) = YCCL(67)+WCCL(144)*(Y(33)*RK(144))
      YCCL(33) = YCCL(33)+WCCL(144)*(Y(67)*RK(144))
      WCCL(144) = 0d0
      W(143) = SAVE143
      YCCL(67) = YCCL(67)+WCCL(143)*(Y(32)*RK(143))
      YCCL(32) = YCCL(32)+WCCL(143)*(Y(67)*RK(143))
      WCCL(143) = 0d0
      W(142) = SAVE142
      YCCL(67) = YCCL(67)+WCCL(142)*(Y(31)*RK(142))
      YCCL(31) = YCCL(31)+WCCL(142)*(Y(67)*RK(142))
      WCCL(142) = 0d0
      W(141) = SAVE141
      YCCL(67) = YCCL(67)+WCCL(141)*(Y(43)*RK(141))
      YCCL(43) = YCCL(43)+WCCL(141)*(Y(67)*RK(141))
      WCCL(141) = 0d0
      W(140) = SAVE140
      YCCL(67) = YCCL(67)+WCCL(140)*(Y(42)*RK(140))
      YCCL(42) = YCCL(42)+WCCL(140)*(Y(67)*RK(140))
      WCCL(140) = 0d0
      W(139) = SAVE139
      YCCL(67) = YCCL(67)+WCCL(139)*(Y(39)*RK(139))
      YCCL(39) = YCCL(39)+WCCL(139)*(Y(67)*RK(139))
      WCCL(139) = 0d0
      W(138) = SAVE138
      YCCL(67) = YCCL(67)+WCCL(138)*(Y(45)*RK(138))
      YCCL(45) = YCCL(45)+WCCL(138)*(Y(67)*RK(138))
      WCCL(138) = 0d0
      W(137) = SAVE137
      YCCL(67) = YCCL(67)+WCCL(137)*(Y(41)*RK(137))
      YCCL(41) = YCCL(41)+WCCL(137)*(Y(67)*RK(137))
      WCCL(137) = 0d0
      W(136) = SAVE136
      YCCL(67) = YCCL(67)+WCCL(136)*(Y(38)*RK(136))
      YCCL(38) = YCCL(38)+WCCL(136)*(Y(67)*RK(136))
      WCCL(136) = 0d0
      W(135) = SAVE135
      YCCL(67) = YCCL(67)+WCCL(135)*(Y(37)*RK(135))
      YCCL(37) = YCCL(37)+WCCL(135)*(Y(67)*RK(135))
      WCCL(135) = 0d0
      W(134) = SAVE134
      YCCL(67) = YCCL(67)+WCCL(134)*(Y(36)*RK(134))
      YCCL(36) = YCCL(36)+WCCL(134)*(Y(67)*RK(134))
      WCCL(134) = 0d0
      W(133) = SAVE133
      YCCL(67) = YCCL(67)+WCCL(133)*(Y(64)*RK(133))
      YCCL(64) = YCCL(64)+WCCL(133)*(Y(67)*RK(133))
      WCCL(133) = 0d0
      W(132) = SAVE132
      YCCL(67) = YCCL(67)+WCCL(132)*(Y(60)*RK(132))
      YCCL(60) = YCCL(60)+WCCL(132)*(Y(67)*RK(132))
      WCCL(132) = 0d0
      W(131) = SAVE131
      YCCL(67) = YCCL(67)+WCCL(131)*(Y(63)*RK(131))
      YCCL(63) = YCCL(63)+WCCL(131)*(Y(67)*RK(131))
      WCCL(131) = 0d0
      W(130) = SAVE130
      YCCL(25) = YCCL(25)+WCCL(130)*RK(130)
      WCCL(130) = 0d0
      W(129) = SAVE129
      YCCL(72) = YCCL(72)+WCCL(129)*(Y(56)*RK(129))
      YCCL(56) = YCCL(56)+WCCL(129)*(Y(72)*RK(129))
      WCCL(129) = 0d0
      W(128) = SAVE128
      YCCL(26) = YCCL(26)+WCCL(128)*RK(128)
      WCCL(128) = 0d0
      W(127) = SAVE127
      YCCL(72) = YCCL(72)+WCCL(127)*(Y(69)*RK(127))
      YCCL(69) = YCCL(69)+WCCL(127)*(Y(72)*RK(127))
      WCCL(127) = 0d0
      W(126) = SAVE126
      YCCL(50) = YCCL(50)+WCCL(126)*(Y(22)*RK(126))
      YCCL(22) = YCCL(22)+WCCL(126)*(Y(50)*RK(126))
      WCCL(126) = 0d0
      W(125) = SAVE125
      YCCL(22) = YCCL(22)+WCCL(125)*RK(125)
      WCCL(125) = 0d0
      W(124) = SAVE124
      YCCL(72) = YCCL(72)+WCCL(124)*(Y(22)*RK(124))
      YCCL(22) = YCCL(22)+WCCL(124)*(Y(72)*RK(124))
      WCCL(124) = 0d0
      W(123) = SAVE123
      YCCL(50) = YCCL(50)+WCCL(123)*(Y(18)*RK(123))
      YCCL(18) = YCCL(18)+WCCL(123)*(Y(50)*RK(123))
      WCCL(123) = 0d0
      W(122) = SAVE122
      YCCL(18) = YCCL(18)+WCCL(122)*RK(122)
      WCCL(122) = 0d0
      W(121) = SAVE121
      YCCL(72) = YCCL(72)+WCCL(121)*(Y(18)*RK(121))
      YCCL(18) = YCCL(18)+WCCL(121)*(Y(72)*RK(121))
      WCCL(121) = 0d0
      W(120) = SAVE120
      YCCL(50) = YCCL(50)+WCCL(120)*(Y(17)*RK(120))
      YCCL(17) = YCCL(17)+WCCL(120)*(Y(50)*RK(120))
      WCCL(120) = 0d0
      W(119) = SAVE119
      YCCL(17) = YCCL(17)+WCCL(119)*RK(119)
      WCCL(119) = 0d0
      W(118) = SAVE118
      YCCL(72) = YCCL(72)+WCCL(118)*(Y(17)*RK(118))
      YCCL(17) = YCCL(17)+WCCL(118)*(Y(72)*RK(118))
      WCCL(118) = 0d0
      W(117) = SAVE117
      YCCL(71) = YCCL(71)+WCCL(117)*(Y(29)*RK(117))
      YCCL(29) = YCCL(29)+WCCL(117)*(Y(71)*RK(117))
      WCCL(117) = 0d0
      W(116) = SAVE116
      YCCL(72) = YCCL(72)+WCCL(116)*(Y(29)*RK(116))
      YCCL(29) = YCCL(29)+WCCL(116)*(Y(72)*RK(116))
      WCCL(116) = 0d0
      W(115) = SAVE115
      YCCL(50) = YCCL(50)+WCCL(115)*(Y(25)*RK(115))
      YCCL(25) = YCCL(25)+WCCL(115)*(Y(50)*RK(115))
      WCCL(115) = 0d0
      W(114) = SAVE114
      YCCL(50) = YCCL(50)+WCCL(114)*(Y(48)*RK(114))
      YCCL(48) = YCCL(48)+WCCL(114)*(Y(50)*RK(114))
      WCCL(114) = 0d0
      W(113) = SAVE113
      YCCL(50) = YCCL(50)+WCCL(113)*(Y(49)*RK(113))
      YCCL(49) = YCCL(49)+WCCL(113)*(Y(50)*RK(113))
      WCCL(113) = 0d0
      W(112) = SAVE112
      YCCL(50) = YCCL(50)+WCCL(112)*(Y(14)*RK(112))
      YCCL(14) = YCCL(14)+WCCL(112)*(Y(50)*RK(112))
      WCCL(112) = 0d0
      W(111) = SAVE111
      YCCL(50) = YCCL(50)+WCCL(111)*(Y(13)*RK(111))
      YCCL(13) = YCCL(13)+WCCL(111)*(Y(50)*RK(111))
      WCCL(111) = 0d0
      W(110) = SAVE110
      YCCL(50) = YCCL(50)+WCCL(110)*(Y(19)*RK(110))
      YCCL(19) = YCCL(19)+WCCL(110)*(Y(50)*RK(110))
      WCCL(110) = 0d0
      W(109) = SAVE109
      YCCL(50) = YCCL(50)+WCCL(109)*(Y(12)*RK(109))
      YCCL(12) = YCCL(12)+WCCL(109)*(Y(50)*RK(109))
      WCCL(109) = 0d0
      W(108) = SAVE108
      YCCL(50) = YCCL(50)+WCCL(108)*(Y(44)*RK(108))
      YCCL(44) = YCCL(44)+WCCL(108)*(Y(50)*RK(108))
      WCCL(108) = 0d0
      W(107) = SAVE107
      YCCL(50) = YCCL(50)+WCCL(107)*(Y(40)*RK(107))
      YCCL(40) = YCCL(40)+WCCL(107)*(Y(50)*RK(107))
      WCCL(107) = 0d0
      W(106) = SAVE106
      YCCL(50) = YCCL(50)+WCCL(106)*(Y(11)*RK(106))
      YCCL(11) = YCCL(11)+WCCL(106)*(Y(50)*RK(106))
      WCCL(106) = 0d0
      W(105) = SAVE105
      YCCL(68) = YCCL(68)+WCCL(105)*(Y(25)*RK(105))
      YCCL(25) = YCCL(25)+WCCL(105)*(Y(68)*RK(105))
      WCCL(105) = 0d0
      W(104) = SAVE104
      YCCL(68) = YCCL(68)+WCCL(104)*(Y(14)*RK(104))
      YCCL(14) = YCCL(14)+WCCL(104)*(Y(68)*RK(104))
      WCCL(104) = 0d0
      W(103) = SAVE103
      YCCL(68) = YCCL(68)+WCCL(103)*(Y(13)*RK(103))
      YCCL(13) = YCCL(13)+WCCL(103)*(Y(68)*RK(103))
      WCCL(103) = 0d0
      W(102) = SAVE102
      YCCL(68) = YCCL(68)+WCCL(102)*(Y(19)*RK(102))
      YCCL(19) = YCCL(19)+WCCL(102)*(Y(68)*RK(102))
      WCCL(102) = 0d0
      W(101) = SAVE101
      YCCL(68) = YCCL(68)+WCCL(101)*(Y(12)*RK(101))
      YCCL(12) = YCCL(12)+WCCL(101)*(Y(68)*RK(101))
      WCCL(101) = 0d0
      W(100) = SAVE100
      YCCL(68) = YCCL(68)+WCCL(100)*(Y(44)*RK(100))
      YCCL(44) = YCCL(44)+WCCL(100)*(Y(68)*RK(100))
      WCCL(100) = 0d0
      W(99) = SAVE99
      YCCL(68) = YCCL(68)+WCCL(99)*(Y(40)*RK(99))
      YCCL(40) = YCCL(40)+WCCL(99)*(Y(68)*RK(99))
      WCCL(99) = 0d0
      W(98) = SAVE98
      YCCL(68) = YCCL(68)+WCCL(98)*(Y(11)*RK(98))
      YCCL(11) = YCCL(11)+WCCL(98)*(Y(68)*RK(98))
      WCCL(98) = 0d0
      W(97) = SAVE97
      YCCL(68) = YCCL(68)+WCCL(97)*(Y(30)*RK(97))
      YCCL(30) = YCCL(30)+WCCL(97)*(Y(68)*RK(97))
      WCCL(97) = 0d0
      W(96) = SAVE96
      YCCL(68) = YCCL(68)+WCCL(96)*(Y(48)*RK(96))
      YCCL(48) = YCCL(48)+WCCL(96)*(Y(68)*RK(96))
      WCCL(96) = 0d0
      W(95) = SAVE95
      YCCL(68) = YCCL(68)+WCCL(95)*(Y(49)*RK(95))
      YCCL(49) = YCCL(49)+WCCL(95)*(Y(68)*RK(95))
      WCCL(95) = 0d0
      W(94) = SAVE94
      YCCL(68) = YCCL(68)+WCCL(94)*(Y(54)*RK(94))
      YCCL(54) = YCCL(54)+WCCL(94)*(Y(68)*RK(94))
      WCCL(94) = 0d0
      W(93) = SAVE93
      YCCL(68) = YCCL(68)+WCCL(93)*(Y(51)*RK(93))
      YCCL(51) = YCCL(51)+WCCL(93)*(Y(68)*RK(93))
      WCCL(93) = 0d0
      W(92) = SAVE92
      YCCL(68) = YCCL(68)+WCCL(92)*(Y(61)*RK(92))
      YCCL(61) = YCCL(61)+WCCL(92)*(Y(68)*RK(92))
      WCCL(92) = 0d0
      W(91) = SAVE91
      YCCL(68) = YCCL(68)+WCCL(91)*(Y(66)*RK(91))
      YCCL(66) = YCCL(66)+WCCL(91)*(Y(68)*RK(91))
      WCCL(91) = 0d0
      W(90) = SAVE90
      YCCL(62) = YCCL(62)+WCCL(90)*(Y(70)*RK(90))
      YCCL(70) = YCCL(70)+WCCL(90)*(Y(62)*RK(90))
      WCCL(90) = 0d0
      W(89) = SAVE89
      YCCL(62) = YCCL(62)+WCCL(89)*(Y(25)*RK(89))
      YCCL(25) = YCCL(25)+WCCL(89)*(Y(62)*RK(89))
      WCCL(89) = 0d0
      W(88) = SAVE88
      YCCL(62) = YCCL(62)+WCCL(88)*(Y(26)*RK(88))
      YCCL(26) = YCCL(26)+WCCL(88)*(Y(62)*RK(88))
      WCCL(88) = 0d0
      W(87) = SAVE87
      YCCL(62) = YCCL(62)+WCCL(87)*(Y(28)*RK(87))
      YCCL(28) = YCCL(28)+WCCL(87)*(Y(62)*RK(87))
      WCCL(87) = 0d0
      W(86) = SAVE86
      YCCL(62) = YCCL(62)+WCCL(86)*(Y(53)*RK(86))
      YCCL(53) = YCCL(53)+WCCL(86)*(Y(62)*RK(86))
      WCCL(86) = 0d0
      W(85) = SAVE85
      YCCL(62) = YCCL(62)+WCCL(85)*(Y(16)*RK(85))
      YCCL(16) = YCCL(16)+WCCL(85)*(Y(62)*RK(85))
      WCCL(85) = 0d0
      W(84) = SAVE84
      YCCL(10) = YCCL(10)+WCCL(84)*(Y(62)*RK(84))
      YCCL(62) = YCCL(62)+WCCL(84)*(Y(10)*RK(84))
      WCCL(84) = 0d0
      W(83) = SAVE83
      YCCL(48) = YCCL(48)+WCCL(83)*(Y(62)*RK(83))
      YCCL(62) = YCCL(62)+WCCL(83)*(Y(48)*RK(83))
      WCCL(83) = 0d0
      W(82) = SAVE82
      YCCL(62) = YCCL(62)+WCCL(82)*(Y(49)*RK(82))
      YCCL(49) = YCCL(49)+WCCL(82)*(Y(62)*RK(82))
      WCCL(82) = 0d0
      W(81) = SAVE81
      YCCL(62) = YCCL(62)+WCCL(81)*(Y(54)*RK(81))
      YCCL(54) = YCCL(54)+WCCL(81)*(Y(62)*RK(81))
      WCCL(81) = 0d0
      W(80) = SAVE80
      YCCL(62) = YCCL(62)+WCCL(80)*(Y(51)*RK(80))
      YCCL(51) = YCCL(51)+WCCL(80)*(Y(62)*RK(80))
      WCCL(80) = 0d0
      W(79) = SAVE79
      YCCL(62) = YCCL(62)+WCCL(79)*(Y(24)*RK(79))
      YCCL(24) = YCCL(24)+WCCL(79)*(Y(62)*RK(79))
      WCCL(79) = 0d0
      W(78) = SAVE78
      YCCL(62) = YCCL(62)+WCCL(78)*(Y(59)*RK(78))
      YCCL(59) = YCCL(59)+WCCL(78)*(Y(62)*RK(78))
      WCCL(78) = 0d0
      W(77) = SAVE77
      YCCL(62) = YCCL(62)+WCCL(77)*(Y(61)*RK(77))
      YCCL(61) = YCCL(61)+WCCL(77)*(Y(62)*RK(77))
      WCCL(77) = 0d0
      W(76) = SAVE76
      YCCL(62) = YCCL(62)+WCCL(76)*(Y(66)*RK(76))
      YCCL(66) = YCCL(66)+WCCL(76)*(Y(62)*RK(76))
      WCCL(76) = 0d0
      W(75) = SAVE75
      YCCL(62) = YCCL(62)+WCCL(75)*(Y(30)*RK(75))
      YCCL(30) = YCCL(30)+WCCL(75)*(Y(62)*RK(75))
      WCCL(75) = 0d0
      W(74) = SAVE74
      YCCL(62) = YCCL(62)+WCCL(74)*(Y(6)*RK(74))
      YCCL(6) = YCCL(6)+WCCL(74)*(Y(62)*RK(74))
      WCCL(74) = 0d0
      W(73) = SAVE73
      YCCL(62) = YCCL(62)+WCCL(73)*(Y(5)*RK(73))
      YCCL(5) = YCCL(5)+WCCL(73)*(Y(62)*RK(73))
      WCCL(73) = 0d0
      W(72) = SAVE72
      YCCL(62) = YCCL(62)+WCCL(72)*(Y(14)*RK(72))
      YCCL(14) = YCCL(14)+WCCL(72)*(Y(62)*RK(72))
      WCCL(72) = 0d0
      W(71) = SAVE71
      YCCL(62) = YCCL(62)+WCCL(71)*(Y(13)*RK(71))
      YCCL(13) = YCCL(13)+WCCL(71)*(Y(62)*RK(71))
      WCCL(71) = 0d0
      W(70) = SAVE70
      YCCL(62) = YCCL(62)+WCCL(70)*(Y(19)*RK(70))
      YCCL(19) = YCCL(19)+WCCL(70)*(Y(62)*RK(70))
      WCCL(70) = 0d0
      W(69) = SAVE69
      YCCL(62) = YCCL(62)+WCCL(69)*(Y(12)*RK(69))
      YCCL(12) = YCCL(12)+WCCL(69)*(Y(62)*RK(69))
      WCCL(69) = 0d0
      W(68) = SAVE68
      YCCL(62) = YCCL(62)+WCCL(68)*(Y(44)*RK(68))
      YCCL(44) = YCCL(44)+WCCL(68)*(Y(62)*RK(68))
      WCCL(68) = 0d0
      W(67) = SAVE67
      YCCL(62) = YCCL(62)+WCCL(67)*(Y(40)*RK(67))
      YCCL(40) = YCCL(40)+WCCL(67)*(Y(62)*RK(67))
      WCCL(67) = 0d0
      W(66) = SAVE66
      YCCL(62) = YCCL(62)+WCCL(66)*(Y(11)*RK(66))
      YCCL(11) = YCCL(11)+WCCL(66)*(Y(62)*RK(66))
      WCCL(66) = 0d0
      W(65) = SAVE65
      YCCL(62) = YCCL(62)+WCCL(65)*(Y(4)*RK(65))
      YCCL(4) = YCCL(4)+WCCL(65)*(Y(62)*RK(65))
      WCCL(65) = 0d0
      W(64) = SAVE64
      YCCL(62) = YCCL(62)+WCCL(64)*(Y(3)*RK(64))
      YCCL(3) = YCCL(3)+WCCL(64)*(Y(62)*RK(64))
      WCCL(64) = 0d0
      W(63) = SAVE63
      YCCL(62) = YCCL(62)+WCCL(63)*(Y(2)*RK(63))
      YCCL(2) = YCCL(2)+WCCL(63)*(Y(62)*RK(63))
      WCCL(63) = 0d0
      W(62) = SAVE62
      YCCL(62) = YCCL(62)+WCCL(62)*(Y(21)*RK(62))
      YCCL(21) = YCCL(21)+WCCL(62)*(Y(62)*RK(62))
      WCCL(62) = 0d0
      W(61) = SAVE61
      YCCL(62) = YCCL(62)+WCCL(61)*(Y(20)*RK(61))
      YCCL(20) = YCCL(20)+WCCL(61)*(Y(62)*RK(61))
      WCCL(61) = 0d0
      W(60) = SAVE60
      YCCL(35) = YCCL(35)+WCCL(60)*(Y(49)*RK(60))
      YCCL(49) = YCCL(49)+WCCL(60)*(Y(35)*RK(60))
      WCCL(60) = 0d0
      W(59) = SAVE59
      YCCL(35) = YCCL(35)+WCCL(59)*(Y(19)*RK(59))
      YCCL(19) = YCCL(19)+WCCL(59)*(Y(35)*RK(59))
      WCCL(59) = 0d0
      W(58) = SAVE58
      YCCL(62) = YCCL(62)+WCCL(58)*(Y(52)*RK(58))
      YCCL(52) = YCCL(52)+WCCL(58)*(Y(62)*RK(58))
      WCCL(58) = 0d0
      W(57) = SAVE57
      YCCL(1) = YCCL(1)+WCCL(57)*(Y(62)*RK(57))
      YCCL(62) = YCCL(62)+WCCL(57)*(Y(1)*RK(57))
      WCCL(57) = 0d0
      W(56) = SAVE56
      YCCL(62) = YCCL(62)+WCCL(56)*RK(56)
      WCCL(56) = 0d0
      W(55) = SAVE55
      YCCL(68) = YCCL(68)+WCCL(55)*((Y(68)+Y(68))*RK(55))
      WCCL(55) = 0d0
      W(54) = SAVE54
      YCCL(9) = YCCL(9)+WCCL(54)*RK(54)
      WCCL(54) = 0d0
      W(53) = SAVE53
      YCCL(72) = YCCL(72)+WCCL(53)*(Y(68)*RK(53))
      YCCL(68) = YCCL(68)+WCCL(53)*(Y(72)*RK(53))
      WCCL(53) = 0d0
      W(52) = SAVE52
      YCCL(72) = YCCL(72)+WCCL(52)*(Y(68)*RK(52))
      YCCL(68) = YCCL(68)+WCCL(52)*(Y(72)*RK(52))
      WCCL(52) = 0d0
      W(51) = SAVE51
      YCCL(67) = YCCL(67)+WCCL(51)*(Y(68)*RK(51))
      YCCL(68) = YCCL(68)+WCCL(51)*(Y(67)*RK(51))
      WCCL(51) = 0d0
      W(50) = SAVE50
      YCCL(67) = YCCL(67)+WCCL(50)*((Y(67)+Y(67))*RK(50))
      WCCL(50) = 0d0
      W(49) = SAVE49
      YCCL(72) = YCCL(72)+WCCL(49)*(Y(50)*RK(49))
      YCCL(50) = YCCL(50)+WCCL(49)*(Y(72)*RK(49))
      WCCL(49) = 0d0
      W(48) = SAVE48
      YCCL(67) = YCCL(67)+WCCL(48)*(Y(50)*RK(48))
      YCCL(50) = YCCL(50)+WCCL(48)*(Y(67)*RK(48))
      WCCL(48) = 0d0
      W(47) = SAVE47
      YCCL(15) = YCCL(15)+WCCL(47)*(Y(62)*RK(47))
      YCCL(62) = YCCL(62)+WCCL(47)*(Y(15)*RK(47))
      WCCL(47) = 0d0
      W(46) = SAVE46
      YCCL(55) = YCCL(55)+WCCL(46)*(Y(62)*RK(46))
      YCCL(62) = YCCL(62)+WCCL(46)*(Y(55)*RK(46))
      WCCL(46) = 0d0
      W(45) = SAVE45
      YCCL(23) = YCCL(23)+WCCL(45)*(Y(62)*RK(45))
      YCCL(62) = YCCL(62)+WCCL(45)*(Y(23)*RK(45))
      WCCL(45) = 0d0
      W(44) = SAVE44
      YCCL(68) = YCCL(68)+WCCL(44)*(Y(71)*RK(44))
      YCCL(71) = YCCL(71)+WCCL(44)*(Y(68)*RK(44))
      WCCL(44) = 0d0
      W(43) = SAVE43
      YCCL(15) = YCCL(15)+WCCL(43)*RK(43)
      WCCL(43) = 0d0
      W(42) = SAVE42
      YCCL(72) = YCCL(72)+WCCL(42)*(Y(71)*RK(42))
      YCCL(71) = YCCL(71)+WCCL(42)*(Y(72)*RK(42))
      WCCL(42) = 0d0
      W(41) = SAVE41
      YCCL(67) = YCCL(67)+WCCL(41)*(Y(71)*RK(41))
      YCCL(71) = YCCL(71)+WCCL(41)*(Y(67)*RK(41))
      WCCL(41) = 0d0
      W(40) = SAVE40
      YCCL(68) = YCCL(68)+WCCL(40)*(Y(62)*RK(40))
      YCCL(62) = YCCL(62)+WCCL(40)*(Y(68)*RK(40))
      WCCL(40) = 0d0
      W(39) = SAVE39
      YCCL(72) = YCCL(72)+WCCL(39)*(Y(62)*RK(39))
      YCCL(62) = YCCL(62)+WCCL(39)*(Y(72)*RK(39))
      WCCL(39) = 0d0
      W(38) = SAVE38
      YCCL(67) = YCCL(67)+WCCL(38)*(Y(62)*RK(38))
      YCCL(62) = YCCL(62)+WCCL(38)*(Y(67)*RK(38))
      WCCL(38) = 0d0
      W(37) = SAVE37
      YCCL(72) = YCCL(72)+WCCL(37)*(Y(35)*RK(37))
      YCCL(35) = YCCL(35)+WCCL(37)*(Y(72)*RK(37))
      WCCL(37) = 0d0
      W(36) = SAVE36
      YCCL(72) = YCCL(72)+WCCL(36)*(Y(35)*RK(36))
      YCCL(35) = YCCL(35)+WCCL(36)*(Y(72)*RK(36))
      WCCL(36) = 0d0
      W(35) = SAVE35
      YCCL(67) = YCCL(67)+WCCL(35)*(Y(35)*RK(35))
      YCCL(35) = YCCL(35)+WCCL(35)*(Y(67)*RK(35))
      WCCL(35) = 0d0
      W(34) = SAVE34
      YCCL(71) = YCCL(71)+WCCL(34)*((Y(71)+Y(71))*RK(34))
      WCCL(34) = 0d0
      W(33) = SAVE33
      YCCL(71) = YCCL(71)+WCCL(33)*((Y(71)+Y(71))*RK(33))
      WCCL(33) = 0d0
      W(32) = SAVE32
      YCCL(62) = YCCL(62)+WCCL(32)*(Y(27)*RK(32))
      YCCL(27) = YCCL(27)+WCCL(32)*(Y(62)*RK(32))
      WCCL(32) = 0d0
      W(31) = SAVE31
      YCCL(71) = YCCL(71)+WCCL(31)*(Y(62)*RK(31))
      YCCL(62) = YCCL(62)+WCCL(31)*(Y(71)*RK(31))
      WCCL(31) = 0d0
      W(30) = SAVE30
      YCCL(71) = YCCL(71)+WCCL(30)*(Y(50)*RK(30))
      YCCL(50) = YCCL(50)+WCCL(30)*(Y(71)*RK(30))
      WCCL(30) = 0d0
      W(29) = SAVE29
      YCCL(62) = YCCL(62)+WCCL(29)*(Y(50)*RK(29))
      YCCL(50) = YCCL(50)+WCCL(29)*(Y(62)*RK(29))
      WCCL(29) = 0d0
      W(28) = SAVE28
      YCCL(7) = YCCL(7)+WCCL(28)*RK(28)
      WCCL(28) = 0d0
      W(27) = SAVE27
      YCCL(7) = YCCL(7)+WCCL(27)*RK(27)
      WCCL(27) = 0d0
      W(26) = SAVE26
      YCCL(7) = YCCL(7)+WCCL(26)*RK(26)
      WCCL(26) = 0d0
      W(25) = SAVE25
      YCCL(50) = YCCL(50)+WCCL(25)*(Y(35)*RK(25))
      YCCL(35) = YCCL(35)+WCCL(25)*(Y(50)*RK(25))
      WCCL(25) = 0d0
      W(24) = SAVE24
      YCCL(35) = YCCL(35)+WCCL(24)*RK(24)
      WCCL(24) = 0d0
      W(23) = SAVE23
      YCCL(24) = YCCL(24)+WCCL(23)*RK(23)
      WCCL(23) = 0d0
      W(22) = SAVE22
      YCCL(49) = YCCL(49)+WCCL(22)*RK(22)
      WCCL(22) = 0d0
      W(21) = SAVE21
      YCCL(70) = YCCL(70)+WCCL(21)*RK(21)
      WCCL(21) = 0d0
      W(20) = SAVE20
      YCCL(48) = YCCL(48)+WCCL(20)*RK(20)
      WCCL(20) = 0d0
      W(19) = SAVE19
      YCCL(54) = YCCL(54)+WCCL(19)*RK(19)
      WCCL(19) = 0d0
      W(18) = SAVE18
      YCCL(51) = YCCL(51)+WCCL(18)*RK(18)
      WCCL(18) = 0d0
      W(17) = SAVE17
      YCCL(51) = YCCL(51)+WCCL(17)*RK(17)
      WCCL(17) = 0d0
      W(16) = SAVE16
      YCCL(59) = YCCL(59)+WCCL(16)*RK(16)
      WCCL(16) = 0d0
      W(15) = SAVE15
      YCCL(28) = YCCL(28)+WCCL(15)*RK(15)
      WCCL(15) = 0d0
      W(14) = SAVE14
      YCCL(53) = YCCL(53)+WCCL(14)*RK(14)
      WCCL(14) = 0d0
      W(13) = SAVE13
      YCCL(16) = YCCL(16)+WCCL(13)*RK(13)
      WCCL(13) = 0d0
      W(12) = SAVE12
      YCCL(61) = YCCL(61)+WCCL(12)*RK(12)
      WCCL(12) = 0d0
      W(11) = SAVE11
      YCCL(66) = YCCL(66)+WCCL(11)*RK(11)
      WCCL(11) = 0d0
      W(10) = SAVE10
      YCCL(66) = YCCL(66)+WCCL(10)*RK(10)
      WCCL(10) = 0d0
      W(9) = SAVE9
      YCCL(27) = YCCL(27)+WCCL(9)*RK(9)
      WCCL(9) = 0d0
      W(8) = SAVE8
      YCCL(68) = YCCL(68)+WCCL(8)*RK(8)
      WCCL(8) = 0d0
      W(7) = SAVE7
      YCCL(68) = YCCL(68)+WCCL(7)*RK(7)
      WCCL(7) = 0d0
      W(6) = SAVE6
      YCCL(15) = YCCL(15)+WCCL(6)*RK(6)
      WCCL(6) = 0d0
      W(5) = SAVE5
      YCCL(55) = YCCL(55)+WCCL(5)*RK(5)
      WCCL(5) = 0d0
      W(4) = SAVE4
      YCCL(23) = YCCL(23)+WCCL(4)*RK(4)
      WCCL(4) = 0d0
      W(3) = SAVE3
      YCCL(50) = YCCL(50)+WCCL(3)*RK(3)
      WCCL(3) = 0d0
      W(2) = SAVE2
      YCCL(50) = YCCL(50)+WCCL(2)*RK(2)
      WCCL(2) = 0d0
      W(1) = SAVE1
      YCCL(72) = YCCL(72)+WCCL(1)*RK(1)
      WCCL(1) = 0d0
      END



COD Unit from the initial code : solvlin



COD Unit from the initial code : muzero



COD Compilation unit : roschemcl
COD Derivative of unit :  roschem
COD Dummys:  ns nr dlconc zcsourc zcsourcf convers_factor convers_factor_jac ts tf dlrki dlrkf
COD Active IN   dummys:  dlconc zcsourc zcsourcf
COD Active OUT  dummys:  dlconc
COD Dependencies between IN and OUT:
COD dlconc <--   dlconc zcsourc zcsourcf


      SUBROUTINE ROSCHEMCL (NS, NR, DLCONC, ZCSOURC, ZCSOURCF,
     : CONVERS_FACTOR, CONVERS_FACTOR_JAC, TS, TF, DLRKI, DLRKF,
     : DLCONCCCL, ZCSOURCCCL, ZCSOURCFCCL)

      IMPLICIT NONE
      INTEGER JI
      INTEGER NS
      INTEGER JJ
      DOUBLE PRECISION THRESHOLD
      DOUBLE PRECISION DLSTEP
      DOUBLE PRECISION TS
      DOUBLE PRECISION TF
      INTEGER NR
      DOUBLE PRECISION SD01S
      DOUBLE PRECISION IGAMMA
      INTEGER NNN1
      INTEGER NNN2
      DOUBLE PRECISION DLB2CCL(NS)
      DOUBLE PRECISION ZCSOURCF(NS)
      DOUBLE PRECISION ZCSOURCFCCL(NS)
      DOUBLE PRECISION DLDRDC(NS,NS)
      DOUBLE PRECISION CONVERS_FACTOR_JAC(NS,NS)
      DOUBLE PRECISION DLMAT(NS,NS)
      DOUBLE PRECISION DLK2CCL(NS)
      DOUBLE PRECISION DLDRDCCCL(NS,NS)
      DOUBLE PRECISION DLCONCBISCCL(NS)
      DOUBLE PRECISION DLCONC_NEW(NS)
      DOUBLE PRECISION DLB1CCL(NS)
      DOUBLE PRECISION ZCSOURC(NS)
      DOUBLE PRECISION DLCONCBIS(NS)
      LOGICAL TEST14(NS)
      DOUBLE PRECISION DLMATLU(NS,NS)
      DOUBLE PRECISION DLRCCL(NS)
      DOUBLE PRECISION DLR(NS)
      DOUBLE PRECISION DLK1CCL(NS)
      DOUBLE PRECISION DLB1(NS)
      DOUBLE PRECISION ZCSOURCCCL(NS)
      DOUBLE PRECISION DLRKF(NR)
      DOUBLE PRECISION DLCONC_NEWCCL(NS)
      DOUBLE PRECISION DLB2(NS)
      DOUBLE PRECISION DLK1(NS)
      LOGICAL TEST23(NS)
      DOUBLE PRECISION DLMATCCL(NS,NS)
      DOUBLE PRECISION DLK2(NS)
      DOUBLE PRECISION DLMATLUCCL(NS,NS)
      DOUBLE PRECISION DLCONC(NS)
      DOUBLE PRECISION DLRKI(NR)
      DOUBLE PRECISION DLCONCCCL(NS)
      DOUBLE PRECISION CONVERS_FACTOR(NS)
      DOUBLE PRECISION SAVE15(NS)
      DOUBLE PRECISION SAVE16(NS)
      DOUBLE PRECISION SAVE17(NS)
      DOUBLE PRECISION SAVE24(NS)
      DOUBLE PRECISION SAVE25(NS)
      INTEGER SAVE27
      DOUBLE PRECISION SAVE8(NS)
      INTEGER SAVE9(NS)
      INTEGER option_chemistry

C
C Initializations of uninitialized variables
C

c This automatic differenciation is only okay for the chemistry model RACM.
      option_chemistry = 1

      DO NNN1 = 1, NS
         DLR(NNN1) = 0d0
      END DO

      JI = 0

C
C Initializations of local variables
C

      DO NNN1 = 1, NS
         DLK1CCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         DO NNN2 = 1, NS
            DLDRDCCCL(NNN2,NNN1) = 0d0
         END DO
      END DO
      DO NNN1 = 1, NS
         DLB2CCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         DLB1CCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         DLCONC_NEWCCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         DO NNN2 = 1, NS
            DLMATLUCCL(NNN2,NNN1) = 0d0
         END DO
      END DO
      DO NNN1 = 1, NS
         DLRCCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         DLCONCBISCCL(NNN1) = 0d0
      END DO
      DO NNN1 = 1, NS
         DO NNN2 = 1, NS
            DLMATCCL(NNN2,NNN1) = 0d0
         END DO
      END DO
      DO NNN1 = 1, NS
         DLK2CCL(NNN1) = 0d0
      END DO
C
C Trajectory
C

      THRESHOLD = 0.d0
      DLSTEP = TF-TS
      SD01S = DSQRT(2.d0)
      IGAMMA = 1.d0+1.d0/SD01S
      CALL FEXCHEM_racm(NS, NR, DLCONC, DLRKI, ZCSOURC, CONVERS_FACTOR,
     : DLB1)
      CALL JACDCHEMDC_racm(NS, NR, DLCONC, CONVERS_FACTOR,
     : CONVERS_FACTOR_JAC, DLRKI, DLDRDC)
      DO JJ = 1, NS
         SAVE9(JJ) = JI
         DO JI = 1, NS
            DLMAT(JI,JJ) = -IGAMMA*DLSTEP*DLDRDC(JI,JJ)
         END DO
         SAVE8(JJ) = DLMAT(JJ,JJ)
         DLMAT(JJ,JJ) = 1.d0+DLMAT(JJ,JJ)
      END DO
      CALL SOLVLIN(NS, 0, DLMAT, DLMATLU, DLK1, DLB1, option_chemistry)
      DO JI = 1, NS
         DLCONCBIS(JI) = DLCONC(JI)+DLSTEP*DLK1(JI)
         TEST14(JI) = DLCONCBIS(JI).LE.THRESHOLD
         IF (TEST14(JI)) THEN
           SAVE15(JI) = DLCONCBIS(JI)
           DLCONCBIS(JI) = THRESHOLD
           SAVE16(JI) = DLK1(JI)
           DLK1(JI) = (DLCONCBIS(JI)-DLCONC(JI))/DLSTEP
         END IF
      END DO
      DO NNN1 = 1, NS
         SAVE17(NNN1) = DLR(NNN1)
      END DO
      CALL FEXCHEM_racm(NS, NR, DLCONCBIS, DLRKF, ZCSOURCF,
     : CONVERS_FACTOR, DLR)
      SAVE27 = JI
      DO JI = 1, NS
         DLB2(JI) = DLR(JI)-2.d0*DLK1(JI)
      END DO
      CALL SOLVLIN(NS, 1, DLMAT, DLMATLU, DLK2, DLB2, option_chemistry)
      DO JI = 1, NS
         DLCONC_NEW(JI) =
     :    DLCONC(JI)+1.5d0*DLSTEP*DLK1(JI)+0.5d0*DLSTEP*DLK2(JI)
         TEST23(JI) = DLCONC_NEW(JI).LE.THRESHOLD
         IF (TEST23(JI)) THEN
           SAVE24(JI) = DLCONC(JI)
           DLCONC(JI) = THRESHOLD
         ELSE
           SAVE25(JI) = DLCONC(JI)
           DLCONC(JI) = DLCONC_NEW(JI)
         END IF
      END DO
C
C Transposed linear forms
C

      DO JI = NS, 1, -1
         IF (TEST23(JI)) THEN
           DLCONC(JI) = SAVE24(JI)
           DLCONCCCL(JI) = 0d0
         ELSE
           DLCONC(JI) = SAVE25(JI)
           DLCONC_NEWCCL(JI) = DLCONC_NEWCCL(JI)+DLCONCCCL(JI)
           DLCONCCCL(JI) = 0d0
         END IF
         DLCONCCCL(JI) = DLCONCCCL(JI)+DLCONC_NEWCCL(JI)
         DLK1CCL(JI) = DLK1CCL(JI)+DLCONC_NEWCCL(JI)*(DLSTEP*1.5d0)
         DLK2CCL(JI) = DLK2CCL(JI)+DLCONC_NEWCCL(JI)*(DLSTEP*0.5d0)
         DLCONC_NEWCCL(JI) = 0d0
      END DO
      CALL SOLVLINCL(NS, 1, DLMAT, DLMATLU, DLK2, DLB2, DLMATCCL,
     : DLMATLUCCL, DLK2CCL, DLB2CCL)
      DO JI = NS, 1, -1
         DLRCCL(JI) = DLRCCL(JI)+DLB2CCL(JI)
         DLK1CCL(JI) = DLK1CCL(JI)-DLB2CCL(JI)*2.d0
         DLB2CCL(JI) = 0d0
      END DO
      JI = SAVE27
      DO NNN1 = NS, 1, -1
         DLR(NNN1) = SAVE17(NNN1)
      END DO
      CALL FEXCHEMCL(NS, NR, DLCONCBIS, DLRKF, ZCSOURCF,
     : CONVERS_FACTOR, DLR, DLCONCBISCCL, ZCSOURCFCCL, DLRCCL)
      DO JI = NS, 1, -1
         IF (TEST14(JI)) THEN
           DLK1(JI) = SAVE16(JI)
           DLCONCBISCCL(JI) = DLCONCBISCCL(JI)+DLK1CCL(JI)*(1d0/DLSTEP)
           DLCONCCCL(JI) = DLCONCCCL(JI)-DLK1CCL(JI)*(1d0/DLSTEP)
           DLK1CCL(JI) = 0d0
           DLCONCBIS(JI) = SAVE15(JI)
           DLCONCBISCCL(JI) = 0d0
         END IF
         DLCONCCCL(JI) = DLCONCCCL(JI)+DLCONCBISCCL(JI)
         DLK1CCL(JI) = DLK1CCL(JI)+DLCONCBISCCL(JI)*DLSTEP
         DLCONCBISCCL(JI) = 0d0
      END DO
      CALL SOLVLINCL(NS, 0, DLMAT, DLMATLU, DLK1, DLB1, DLMATCCL,
     : DLMATLUCCL, DLK1CCL, DLB1CCL)
      DO JJ = NS, 1, -1
         DLMAT(JJ,JJ) = SAVE8(JJ)
         DO JI = NS, 1, -1
            DLDRDCCCL(JI,JJ) =
     :       DLDRDCCCL(JI,JJ)-DLMATCCL(JI,JJ)*(DLSTEP*IGAMMA)
            DLMATCCL(JI,JJ) = 0d0
         END DO
         JI = SAVE9(JJ)
      END DO
      CALL JACDCHEMDCCL(NS, NR, DLCONC, CONVERS_FACTOR,
     : CONVERS_FACTOR_JAC, DLRKI, DLDRDC, DLCONCCCL, DLDRDCCCL)
      CALL FEXCHEMCL(NS, NR, DLCONC, DLRKI, ZCSOURC, CONVERS_FACTOR,
     : DLB1, DLCONCCCL, ZCSOURCCCL, DLB1CCL)
      END



COD Unit from the initial code : fexchem



