import pandas as pd
import matplotlib.pyplot as plt
import numpy.ma as ma

def make_windrose_figure(wd, ws, title, fig_name):

    from windrose import WindroseAxes
    
    ax = WindroseAxes.from_ax()
    print(wd.shape, ws.shape)
    ax.bar(wd, ws, normed=True, opening=0.8, edgecolor='white')

    # ax.set_yticks(np.arange(5, 25, step=5))
    # ax.set_yticklabels(np.arange(5, 25, step=5))
    ax.set_title(title)

    ax.set_legend(loc = "lower center", ncol = 6)
    plt.savefig(fig_name)


def draw_windrose(obs):
    
    wd = pd.to_numeric(obs["WindDirection_105_9m"], errors = 'coerce').fillna(-999, downcast = 'infer') # [begin_id:nval]
    ws = pd.to_numeric(obs["MeanWindSpeed_105_9m"], errors = 'coerce').fillna(-999, downcast = 'infer') # [begin_id:nval]

    wd_obs = ma.masked_where(wd == -999, wd)
    ws_obs = ma.masked_where(ws == -999, ws)
    
    title = "Measurement at 105.9 m"
    fig_name = "windrose_105_obs.png"

    make_windrose_figure(wd_obs, ws_obs, title, fig_name)



# Draw Wind rose     


obs = pd.read_csv("/cerea_raid/users/kimy/work/EDF/POWERX/script_plot/LiDAR_20161201to20171124_LISIBLE.txt", sep="\t")

draw_windrose(obs)
    
