% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpmd_predict_fit_4.R
\name{hpmd_predict_fit_4_variable}
\alias{hpmd_predict_fit_4_variable}
\title{Predicts decomposition rates and initial leaching losses for model HPM-leaching in Teickner et al. (2024) for one litter sample with variable environmental conditions}
\usage{
hpmd_predict_fit_4_variable(newdata)
}
\arguments{
\item{newdata}{The same as for \code{hpmd_predict_fit_4} with an additional column
\code{id_time_step}, an integer specifying the step number. Column
\code{incubation_duration} now specifies the duration of the time step and the total
incubation duration up to the current step is the sum of the \code{incubation_duration}
values of all previous steps and the current step. \code{m0} is only considered for
the first time step and dynamically computed for all subsequent time steps.}
}
\value{
\code{newdata} with additional columns with predicted initial leaching
losses, decomposition rates, and remaining masses.
}
\description{
Here, it is assumed that one litter sample decomposes where conditions are
constant during specified periods of time, but change from one period to the
next period. The function then predicts decomposition from one time step to the
next. This function may be used to simulate decomposition of \emph{Sphagnum} litter
when environmental conditions change.
}
\details{
For parameters \code{phi_2_p2} (measurement errors for remaining masses) and
\code{alpha_2} (factor that controls how fast decomposition rates decrease with
increasing mass loss), the functions assumes by default average values
estimated for species across the studies analyzed in
\insertCite{Teickner.2024a;textual}{hpmdpredict}. If other measurement errors
for remaining masses or values for \code{alpha_2} should to be assumed, this has
to be specified via \code{newdata}.
}
\examples{
# Comparison between changing and constant environmental conditions. Here, in
# the first example both layer_degree_of_saturation_1 and
# sample_depth_lower change over time.
set.seed(8484)
newdata <-
  tibble::tibble(
    id_time_step = 1:6,
    incubation_duration = c(5, 5, 5, 5, 5, 100),
    m0 = 1,
    l0 = 0,
    layer_degree_of_saturation_1 = c(0.2, 0.6, 0.8, 1, 1, 1),
    layer_water_table_depth_to_surface_1 = 30,
    sample_depth_lower = c(10, 20, 30, 35, 40, 50),
    hpm_taxon_rank_value = "Sphagnum angustifolium"
 )

res <- hpmd_predict_fit_4_variable(newdata)

newdata <-
  tibble::tibble(
    incubation_duration = cumsum(c(5, 5, 5, 5, 5, 100)),
    m0 = 1,
    l0 = 0,
    layer_degree_of_saturation_1 = c(0.4),
    layer_water_table_depth_to_surface_1 = 30,
    sample_depth_lower = c(10),
    hpm_taxon_rank_value = "Sphagnum angustifolium"
 )

res1 <- hpmd_predict_fit_4(newdata)

plot(mean(res$mass_relative_mass) ~ cumsum(res$incubation_duration))
points(mean(res1$mass_relative_mass) ~ res1$incubation_duration, col = "red")

set.seed(8484)
newdata <-
  tibble::tibble(
    id_time_step = 1:6,
    incubation_duration = cumsum(c(5, 5, 5, 5, 5, 100)),
    m0 = 1,
    l0 = 0,
    layer_degree_of_saturation_1 = c(0.4),
    layer_water_table_depth_to_surface_1 = 30,
    sample_depth_lower = c(10),
    hpm_taxon_rank_value = "Sphagnum angustifolium"
 )

res1 <- hpmd_predict_fit_4(newdata)

newdata$incubation_duration <- c(5, 5, 5, 5, 5, 100)

set.seed(8484)
res <- hpmd_predict_fit_4_variable(newdata)

plot(mean(res$mass_relative_mass) ~ cumsum(res$incubation_duration))
points(mean(res1$mass_relative_mass) ~ res1$incubation_duration, col = "red")

}
