% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpmd_predict_fit_4.R
\name{hpmd_predict_fit_4}
\alias{hpmd_predict_fit_4}
\title{Predicts decomposition rates and initial leaching losses for model HPM-leaching in Teickner et al. (2024) for constant decomposition conditions}
\usage{
hpmd_predict_fit_4(newdata)
}
\arguments{
\item{newdata}{A data frame with a row for each prediction to generate. The
data frame must contain the following columns:
\describe{
\item{\code{incubation_duration}}{A numeric vector with the incubation durations.}
\item{\code{m0}}{A numeric vector with the initial mass of the litter.}
\item{\code{layer_degree_of_saturation_1}}{A numeric vector with the degree of
saturation during the incubation.}
\item{\code{layer_water_table_depth_to_surface_1}}{A numeric vector with the
water table depth to the surface (cm) during the incubation.}
\item{\code{sample_depth_lower}}{A numeric vector with the depth of the sample
below the peat surface during the incubation.}
\item{\code{hpm_taxon_rank_value}}{A character value defining the Sphagnum
species. Allowed species names are defined in \code{hpm_taxon_rank_value_allowed}}
}
The data frame may contain additional column, in particular the parameter
values estimated by model HPM-leaching may be changed to other values. See
the readme file for a list of parameters whose values can be changed.}
}
\value{
\code{newdata} with additional columns with predicted initial leaching
losses, decomposition rates, and remaining masses. Additional columns are:
\describe{
\item{m69_p1}{See readme.}
\item{m69_p2}{See readme.}
\item{m68_p1}{See readme.}
\item{m68_p2}{See readme.}
\item{m68_p3_2}{See readme.}
\item{hpm_l_2_p1}{See readme.}
\item{hpm_l_2_p3}{See readme.}
\item{hpm_l_2_p4}{See readme.}
\item{hpm_k_2_p1}{See readme.}
\item{alpha_2}{See readme.}
\item{phi_2}{See readme.}
\item{hpm_k_2}{Average decomposition rates predicted by the HPM
decomposition module \insertCite{Frolking.2010}{hpmdpredict} (yr$^{-1}$).}
\item{k0}{Decomposition rate of an individual litterbag experiment predicted
by the HPM decomposition module \insertCite{Frolking.2010}{hpmdpredict}
(yr$^{-1}$).}
\item{l0}{Initial leaching loss of an individual litterbag experiment predicted
by HPM-leaching (g/g).}
\item{mass_relative_mass_mu}{Average fraction of the initial mass remaining
predicted by the HPM decomposition module
\insertCite{Frolking.2010}{hpmdpredict} (g/g).}
\item{mass_relative_mass}{Fraction of the initial mass remaining of an
individual litterbag as predicted by the HPM decomposition module
\insertCite{Frolking.2010}{hpmdpredict} (g/g).}
}
}
\description{
This function takes the posterior of  model HPM-leaching in
\insertCite{Teickner.2024a;textual}{hpmdpredict} and a data frame
specifying prediction controls and optionally other parameter values and
predicts Sphagnum decomposition rates, initial leaching losses, and remaining
masses during a litterbag experiment assuming constant conditions.
}
\details{
For parameters \code{phi_2_p2} (measurement errors for remaining masses) and
\code{alpha_2} (factor that controls how fast decomposition rates decrease with
increasing mass loss), the functions assumes by default average values
estimated for species across the studies analyzed in
\insertCite{Teickner.2024a;textual}{hpmdpredict}. If other measurement errors
for remaining masses or values for \code{alpha_2} should to be assumed, this has
to be specified via \code{newdata}.
}
\examples{
set.seed(4334)
newdata <-
  tibble::tibble(
    incubation_duration = seq(0, 100, 1),
    m0 = 1,
    layer_degree_of_saturation_1 = 0.4,
    layer_water_table_depth_to_surface_1 = 20,
    sample_depth_lower = 10,
    hpm_taxon_rank_value = "Sphagnum fuscum"
 )

res <- hpmd_predict_fit_4(newdata)

# Example for modifying model parameters: Here, a different optimum degree of
# saturation for decomposition
newdata$m69_p1 <- 0.4
res1 <- hpmd_predict_fit_4(newdata)

plot(mean(res$mass_relative_mass) ~ res$incubation_duration, type = "l")
lines(mean(res1$mass_relative_mass) ~ res1$incubation_duration, col = "red")

}
\references{
\insertAllCited{}
}
