
<!-- README.md is generated from README.Rmd. Please edit that file -->

# hpmdpredict

<!-- badges: start -->

[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
<!-- badges: end -->

`hpmdpredict` provides model HPM-leaching from (Teickner, Pebesma,
and Knorr 2024) and functions to make predictions with this model.
HPM-leaching models the fraction of initial mass remaining in
*Sphagnum* litterbag experiments in dependency of species, degree of
saturation, and distance below the water table, and it also models the
magnitude of initial leaching losses.

## Installation

You can install the development version of `hpmdpredict` in R by
downloading the `tar.gz` file in this repository and executing:

``` r
install.packages("hpmdpredict_0.0.0.9000.tar.gz", type = "source")
```

## Example

To make predictions, one first has to define some variables like the
incubation duration. Here, we predict remaining masses and initial
leaching losses for *S. fuscum* incubated at a degree of saturation of
0.6 L$_\text{water}$ L$_\text{pores}^{-1}$ during the first five years.

``` r
library(hpmdpredict)

d <- 
  tibble::tibble(
    incubation_duration = seq(from = 0, to = 5, length.out = 30),
    m0 = 1,
    layer_degree_of_saturation_1 = 0.6,
    layer_water_table_depth_to_surface_1 = 20,
    sample_depth_lower = 10,
    hpm_taxon_rank_value = "Sphagnum fuscum"
  )
```

Next, one can pass this data frame to `hpmd_predict_fit_4()` which makes
the predictions.

``` r
library(hpmdpredict)
d <- hpmdpredict::hpmd_predict_fit_4(newdata = d)
```

To illustrate the result, we plot predicted remaining masses versus
incubation time:

``` r
library(ggplot2)
library(ggdist)

d |>
  ggplot(aes(ydist = mass_relative_mass * 100, x = incubation_duration)) +
  stat_lineribbon() +
  scale_fill_brewer() +
  labs(
    y = "Fraction of initial mass (%)",
    x = "Incubation duration (yr)"
  )
```

<img src="man/figures/README-sup-hpmd-hpmdpredict-3-1.png" width="80%" />

## Model parameters

Model parameters that can be modified when making predictions are:

<table class="table table-striped table-condensed" style="margin-left: auto; margin-right: auto;">
<thead>
<tr>
<th style="text-align:left;position: sticky; top:0; background-color: #FFFFFF;">
Parameter
</th>
<th style="text-align:left;position: sticky; top:0; background-color: #FFFFFF;">
Description
</th>
<th style="text-align:left;position: sticky; top:0; background-color: #FFFFFF;">
HPM parameter name
</th>
</tr>
</thead>
<tbody>
<tr>
<td style="text-align:left;">
phi_2
</td>
<td style="text-align:left;min-width: 40em; ">
Precision parameter for the Beta distribution modeling remaining
fractions of inital masses predicted by HPM-leaching. Larger values
imply smaller errors in remaining masses (-).
</td>
<td style="text-align:left;">
</td>
</tr>
<tr>
<td style="text-align:left;">
alpha_2
</td>
<td style="text-align:left;min-width: 40em; ">
Parameter that controls how fast decomposition rates decrease as mass is
lost during the decomposition (-).
</td>
<td style="text-align:left;">
</td>
</tr>
<tr>
<td style="text-align:left;">
m69_p1
</td>
<td style="text-align:left;min-width: 40em; ">
Peat degree of saturation where aerobic decomposition rates are maximal
(L<sub>water</sub> L<sub>pores</sub><sup>-1</sup>).
</td>
<td style="text-align:left;">
<i>W<sub>opt</sub></i>
</td>
</tr>
<tr>
<td style="text-align:left;">
m69_p2
</td>
<td style="text-align:left;min-width: 40em; ">
Curvature of the relation of aerobic decomposition rates to the degree
of saturation (larger values imply a more peaked relation) (-).
</td>
<td style="text-align:left;">
<i>c<sub>1</sub></i>
</td>
</tr>
<tr>
<td style="text-align:left;">
m68_p1
</td>
<td style="text-align:left;min-width: 40em; ">
Minimum anaerobic decomposition rate (yr<sup>-1</sup>).
</td>
<td style="text-align:left;">
<i>f<sub>min</sub></i>
</td>
</tr>
<tr>
<td style="text-align:left;">
m68_p2
</td>
<td style="text-align:left;min-width: 40em; ">
Anoxia scale length. Represents limitation of anaerobic decomposition
rates with increasing distance below the annual water table depth (m).
</td>
<td style="text-align:left;">
<i>c<sub>2</sub></i>
</td>
</tr>
<tr>
<td style="text-align:left;">
m68_p3_2
</td>
<td style="text-align:left;min-width: 40em; ">
Maximum possible decomposition rate for the <i>Sphagnum</i> species
(yr<sup>-1</sup>).
</td>
<td style="text-align:left;">
<i>k<sub>0,i</sub></i>
</td>
</tr>
<tr>
<td style="text-align:left;">
hpm_k_2_p1
</td>
<td style="text-align:left;min-width: 40em; ">
Shape parameter for the Gamma distribution modeling decomposition rates
predicted by the HPM (-).
</td>
<td style="text-align:left;">
</td>
</tr>
<tr>
<td style="text-align:left;">
hpm_l_2_p1
</td>
<td style="text-align:left;min-width: 40em; ">
Intercept for average *Sphagnum* initial leaching losses at a degree of
saturation of 0 L<sub>water</sub> L<sub>pores</sub><sup>-1</sup> (logit
scale).
</td>
<td style="text-align:left;">
</td>
</tr>
<tr>
<td style="text-align:left;">
hpm_l_2_p3
</td>
<td style="text-align:left;min-width: 40em; ">
Slope for the relation between *Sphagnum* initial leaching losses and
the degree of saturation (logit scale) (L<sub>pores</sub>
L<sub>water</sub><sup>-1</sup>).
</td>
<td style="text-align:left;">
</td>
</tr>
<tr>
<td style="text-align:left;">
hpm_l_2_p4
</td>
<td style="text-align:left;min-width: 40em; ">
Precision parameter for the Beta distribution modeling initial leaching
losses predicted by HPM-leaching. Larger values imply smaller errors
in leaching losses (-).
</td>
<td style="text-align:left;">
</td>
</tr>
</tbody>
</table>

## Citation

Please cite this R package as:

> Henning Teickner and Klaus-Holger Knorr (2024): “hpmdpredict:
> Predictions with Model HPM-leaching from Teickner et al. (2024).
> URL:—todo”

## Licenses

Text and figures : [CC BY
4.0](https://creativecommons.org/licenses/by/4.0/)

Code : See the DESCRIPTION file

## Contributions

We welcome contributions from everyone. Please note that the hpmdpredict
project is released with a [Contributor Code of
Conduct](https://contributor-covenant.org/version/2/1/CODE_OF_CONDUCT.html).
By contributing to this project, you agree to abide by its terms.

## References

<div id="refs" class="references csl-bib-body hanging-indent"
entry-spacing="0">

<div id="ref-Teickner.2024a" class="csl-entry">

Teickner, Henning, Edzer Pebesma, and Klaus-Holger Knorr. 2024.
“Underestimation of Anaerobic Decomposition Rates in *Sphagnum*
Litterbag Experiments by the Holocene Peatland Model Depends on Initial
Leaching Losses.”

</div>

</div>
