#!/usr/bin/env bash

## Run the full evaluation from the "ROSA: Finding Backdoors with Fuzzing" paper.
##
## This script reproduces Table II and Figure 2 from the paper.
## Note that this will take *quite a while*: in order to not make any assumptions about the host
## machine running this code, no attempts have been made to parallelize it. As such, one should
## expect this to run for a minimum of:
##     (17 targets) * (8 hours) * (10 runs) = 1360 hours
## Note that this time does not account for:
## - The evaluation of the results (which might take a long time depending on how fast each target
##   is);
## - The simulation of different phase 1 durations, which is needed in order to produce Figure 2.


set -e


targets=(
    # Authentic.
    belkin_unoptimized-backdoored belkin-backdoored dlink-backdoored scfgmgr-backdoored
    tenda-backdoored php-backdoored proftpd-backdoored vsftpd-backdoored
    # Synthetic.
    sudo-backdoored libpng-backdoored libsndfile-backdoored libtiff-backdoored libxml2-backdoored
    lua-backdoored openssl-backdoored php_unserialize-backdoored poppler-backdoored
    sqlite3-backdoored
)
minutes_per_run=480  # 8 hours
runs=10

for target in "${targets[@]}"
do
    RUN_TARGET_NO_PDF=1 /root/artifact/run-target.sh $target $minutes_per_run $runs
done

# Generate the PDF with the full Table II and Figure 2.
# The generated output directories are of the form <TARGET>__<MINUTES PER RUN>mpr_<RUNS>r_<DATE>.
echo "Generating PDF..."
/root/artifact/tools/results-to-pdf.py /root/evaluation/*mpr*/ \
    --output /root/evaluation/full-evaluation.pdf
