
<!-- README.md is generated from README.Rmd. Please edit that file -->

[![DOI](https://zenodo.org/badge/805337783.svg)](https://zenodo.org/doi/10.5281/zenodo.11472954)
![Last-changedate](https://img.shields.io/badge/last%20change-2025--01--23-brightgreen.svg)

## Compendium of R code and data for “A Synthesis of *Sphagnum* Litterbag Experiments: Initial Leaching Losses Bias Decomposition Rate Estimates” and “Peat Oxic and Anoxic Controls of *Sphagnum* Decomposition Rates in the Holocene Peatland Model Decomposition Module Estimated from Litterbag Data”.

This repository contains the data and code for our two manuscripts:

Teickner, H., Pebesma, E., & Knorr, K.-H. (2025). A synthesis of
*Sphagnum* litterbag experiments: Initial leaching losses bias
decomposition rate estimates. Biogeosciences, 22(2), 417–433.
<https://doi.org/10.5194/bg-22-417-2025>

Henning Teickner, Edzer Pebesma, and Klaus-Holger Knorr (2024): Peat
Oxic and Anoxic Controls of *Sphagnum* Decomposition Rates in the
Holocene Peatland Model Decomposition Module Estimated from Litterbag
Data. (not peer-reviewed preprint). DOI: 10.5194/egusphere-2024-1739

### How to cite

Please cite this compendium as:

> Henning Teickner, Edzer Pebesma, and Klaus-Holger Knorr, (2025).
> Compendium of R code and data for “A Synthesis of *Sphagnum* Litterbag
> Experiments: Initial Leaching Losses Bias Decomposition Rate
> Estimates” and “Peat Oxic and Anoxic Controls of *Sphagnum*
> Decomposition Rates in the Holocene Peatland Model Decomposition
> Module Estimated from Litterbag Data”. Accessed 23 Jan 2025.
> <https://github.com/henningte/eb1125>

### Contents

Code to reproduce each manuscript is in the folder in [:file_folder:
targets](targets):  
- [:file_folder: leaching](targets/leaching): \> Henning Teickner, Edzer
Pebesma, and Klaus-Holger Knorr (2024): *A Synthesis of *Sphagnum*
Litterbag Experiments: Initial Leaching Losses Bias Decomposition Rate
Estimates*. Preprint.  
- [:file_folder: hpm_decomposition](targets/hpm_decomposition): \>
Henning Teickner, Edzer Pebesma, and Klaus-Holger Knorr (2024): *Peat
Oxic and Anoxic Controls of *Sphagnum* Decomposition Rates in the
Holocene Peatland Model Decomposition Module Estimated from Litterbag
Data*. Preprint.

To reproduce the manuscripts, run the ‘targets’ workflow by executing
`run.R` in above folders.

### Licenses

**Text and figures :**
[CC-BY-4.0](http://creativecommons.org/licenses/by/4.0/)

**Code :** See the [DESCRIPTION](DESCRIPTION) file

**Data :** [CC-0](http://creativecommons.org/publicdomain/zero/1.0/)
attribution requested in reuse. See the sources section for licenses for
data derived from external sources and how to give credit to the
original author(s) and the source.

### Sources

-   [:file_folder:
    evo12547-sup-0001-suppmat(1)-Tab-S2.csv](targets/leaching/derived_data/evo12547-sup-0001-suppmat(1)-Tab-S2.csv):
    This file is from the [supporting information of Johnson et al.
    (2015)](https://academic.oup.com/evolut/article/69/1/90/6851823#supplementary-data).
-   [:file_folder:
    dpeatdecomposition_snapshot.rds](targets/leaching/derived_data/dpeatdecomposition_snapshot.rds):
    This file is the subset of the data from the Peat Decomposition
    Database (Teickner and Knorr 2024) we analyzed in this project.

### Contributions

We welcome contributions from everyone. Before you get started, please
see our [contributor guidelines](CONTRIBUTING.md). Please note that this
project is released with a [Contributor Code of Conduct](CONDUCT.md). By
participating in this project you agree to abide by its terms.

### Funding

This study was funded by the Deutsche Forschungsgemeinschaft (DFG,
German Research Foundation) grant no. KN 929/23-1 to Klaus-Holger Knorr
and grant no. PE 1632/18-1 to Edzer Pebesma.

### References

<div id="refs" class="references csl-bib-body hanging-indent">

<div id="ref-Johnson.2015" class="csl-entry">

Johnson, Matthew G., Gustaf Granath, Teemu Tahvanainen, Remy Pouliot,
Hans K. Stenøien, Line Rochefort, Håkan Rydin, and A. Jonathan Shaw.
2015. “Evolution of Niche Preference in *Sphagnum* Peat Mosses.”
*Evolution* 69 (1): 90–103. <https://doi.org/10.1111/evo.12547>.

</div>

<div id="ref-Teickner.2024c" class="csl-entry">

Teickner, Henning, and Klaus-Holger Knorr. 2024. “Peatland Decomposition
Database (1.0.0).” Zenodo. <https://doi.org/10.5281/ZENODO.11276065>.

</div>

</div>
