% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepare the data for modelling}
\usage{
prepare_data(mat = NULL, sampl.eff = NULL)
}
\arguments{
\item{mat}{An integer matrix containing quantitative (not qualitative or binary)
count data con interaction frequency (e.g. visits to flowers, number of fruits
consumed per plant or species). Plants must be in rows, Animals must be in columns.}

\item{sampl.eff}{A numeric vector with the sampling effort (e.g. observation hours)
spent on each plant.}
}
\value{
A named list with all the data required to run the model.
}
\description{
Prepare the data for modelling
}
\examples{
data(web)
prepare_data(web, sampl.eff = rep(20, nrow(web)))
}
