% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_residuals.R
\name{plot_residuals}
\alias{plot_residuals}
\title{Plot heatmap of residuals}
\usage{
plot_residuals(pred.df = NULL, data = NULL, ...)
}
\arguments{
\item{pred.df}{A data frame containing the predicted counts, as generated by
\code{\link[=predict_counts]{predict_counts()}}}

\item{data}{Data list (from \code{prepare_data()})}

\item{...}{Further arguments for \code{\link[network.tools:plot_web_heatmap]{network.tools::plot_web_heatmap()}}.}
}
\value{
A ggplot object
}
\description{
Plot heatmap of residuals (observed - predicted counts).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(web)
dt <- prepare_data(mat = web, sampl.eff = rep(20, nrow(web)))
fit <- fit_model(dt, refresh = 0)
pred.df <- predict_counts(fit, dt)
plot_residuals(pred.df, dt)
plot_residuals(pred.df, dt, sort = FALSE)
\dontshow{\}) # examplesIf}
}
