% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prior.R
\name{plot_prior}
\alias{plot_prior}
\title{Plot prior distribution for r (preference) parameter}
\usage{
plot_prior(beta = NULL, fit = NULL, data = NULL)
}
\arguments{
\item{beta}{A number > 0. Rate of the exponential distribution.}

\item{fit}{A fitted model, as obtained from \code{fit_model()}.}

\item{data}{Data list (from \code{\link[=prepare_data]{prepare_data()}}).}
}
\value{
A plot
}
\description{
The \code{r} (preference) parameter in Young et al. model takes a prior
exponential distribution with rate = beta. Use this function to
visualise the prior distribution of \code{r} given the chosen beta.
Alternatively, if providing the fitted model, a plot comparing the
prior versus posterior preference(s) will be produced.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Providing value for beta
plot_prior(beta = 0.01)
plot_prior(beta = 0.001)

## Providing fitted model
data(web)
dt <- prepare_data(mat = web, sampl.eff = rep(20, nrow(web)))
fit <- fit_model(dt, refresh = 0)
plot_prior(fit = fit, data = dt)
\dontshow{\}) # examplesIf}
}
