% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_interaction_prob.R
\name{plot_interaction_prob}
\alias{plot_interaction_prob}
\title{Plot heatmap of interaction probabilities}
\usage{
plot_interaction_prob(post = NULL)
}
\arguments{
\item{post}{Data frame containing the posterior probabilities, as generated
from \code{get_posterior()}.}
}
\value{
A ggplot object
}
\description{
Plot a heatmap of average interaction probabilities
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(web)
dt <- prepare_data(mat = web, sampl.eff = rep(20, nrow(web)))
fit <- fit_model(dt, refresh = 0)
post <- get_posterior(fit, dt)
plot_interaction_prob(post)
\dontshow{\}) # examplesIf}
}
