% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_counts_pred_obs.R
\name{plot_counts_pred_obs}
\alias{plot_counts_pred_obs}
\title{Plot predicted versus observed counts}
\usage{
plot_counts_pred_obs(
  pred.df = NULL,
  data = NULL,
  byplant = FALSE,
  width = 0.95,
  ...
)
}
\arguments{
\item{pred.df}{A data frame containing the predicted counts, as generated by
\code{predict_counts()}}

\item{data}{Data list (from \code{prepare_data()})}

\item{byplant}{Logical. If TRUE, show predicted and observed counts per plant
(using \code{ggplot2::facet_wrap()}). If FALSE, show all interactions in the same plot.}

\item{width}{width of the credible interval (default = 0.95).}

\item{...}{Further arguments to be passed to \code{ggplot2::facet_wrap()} if
\code{byplant = TRUE}, or to \code{tidybayes::geom_pointinterval()} if \code{byplant = FALSE}.}
}
\value{
A ggplot object
}
\description{
Plot predicted versus observed counts
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(web)
dt <- prepare_data(mat = web, sampl.eff = rep(20, nrow(web)))
fit <- fit_model(dt, refresh = 0)
pred.df <- predict_counts(fit, dt)
plot_counts_pred_obs(pred.df, dt)
plot_counts_pred_obs(pred.df, dt, fatten_point = 3)
plot_counts_pred_obs(pred.df, dt, byplant = TRUE)
plot_counts_pred_obs(pred.df, dt, byplant = TRUE, scale = "free")
\dontshow{\}) # examplesIf}
}
