% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_counts_pred.R
\name{plot_counts_pred}
\alias{plot_counts_pred}
\title{Plot heatmap of predicted counts}
\usage{
plot_counts_pred(pred.df = NULL, ...)
}
\arguments{
\item{pred.df}{A data frame containing the predicted counts, as generated by
\code{\link[=predict_counts]{predict_counts()}}}

\item{...}{Further arguments for \code{\link[network.tools:plot_web_heatmap]{network.tools::plot_web_heatmap()}}.}
}
\value{
A ggplot object
}
\description{
Plot heatmap of predicted counts
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(web)
dt <- prepare_data(mat = web, sampl.eff = rep(20, nrow(web)))
fit <- fit_model(dt, refresh = 0)
pred.df <- predict_counts(fit, dt)
plot_counts_pred(pred.df)
plot_counts_pred(pred.df, sort = FALSE)
\dontshow{\}) # examplesIf}
}
