% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_posterior.R
\name{get_posterior}
\alias{get_posterior}
\title{Get posterior values}
\usage{
get_posterior(
  fit = NULL,
  data = NULL,
  param = c("all", "connectance", "preference", "plant.abund", "animal.abund",
    "int.prob", "link")
)
}
\arguments{
\item{fit}{Fitted model (from \code{\link[=fit_model]{fit_model()}})}

\item{data}{Data list (from \code{\link[=prepare_data]{prepare_data()}})}

\item{param}{character. Name of the parameter to retrieve the posterior samples.}
}
\value{
A data frame
}
\description{
Get posterior values
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(web)
dt <- prepare_data(mat = web, sampl.eff = rep(20, nrow(web)))
fit <- fit_model(dt, refresh = 0)
get_posterior(fit, dt, param = "connectance")

int.prob <- get_posterior(fit, dt, param = "int.prob")
int.prob
int.prob |> tidybayes::mean_qi()  # mean edge probability

# all posteriors
get_posterior(fit, dt, param = "all")
\dontshow{\}) # examplesIf}
}
