% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Fit model}
\usage{
fit_model(
  data = NULL,
  model = c("sampling_effort", "Young2021", "varying_preferences"),
  beta = 0.01,
  ...
)
}
\arguments{
\item{data}{A named list containing the required data, as obtained from
\code{\link[=prepare_data]{prepare_data()}}.}

\item{model}{character. One of "Young2021", "sampling_effort", or
"varying_preferences", or a path to a file describing the Stan model in case
you want to use a modified Stan model.}

\item{beta}{Rate of exponential prior on \code{r} (preference) parameter.
Default beta is 0.01. Increase it if you have large count numbers
(can examine the resultant prior using \code{\link[=plot_prior]{plot_prior()}}).}

\item{...}{Further arguments for \code{\link[cmdstanr:model-method-sample]{cmdstanr::sample()}}, like \code{iter_warmup},
\code{iter_sampling}, or \code{thin}, among others. It is recommended to increase the
number of iterations (e.g. iter_sampling = 10000).}
}
\value{
A fitted model (\code{\link[cmdstanr:CmdStanMCMC]{cmdstanr::CmdStanMCMC()}} object).
}
\description{
Fit model
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(web)
dt <- prepare_data(mat = web, sampl.eff = rep(20, nrow(web)))
fit <- fit_model(dt)
\dontshow{\}) # examplesIf}
}
