#' Plot heatmap of predicted counts
#'
#' @param pred.df A data frame containing the predicted counts, as generated by
#' [predict_counts()]
#' @param ... Further arguments for [network.tools::plot_web_heatmap()].
#'
#' @return A ggplot object
#' @export
#'
#' @examplesIf interactive()
#' data(web)
#' dt <- prepare_data(mat = web, sampl.eff = rep(20, nrow(web)))
#' fit <- fit_model(dt, refresh = 0)
#' pred.df <- predict_counts(fit, dt)
#' plot_counts_pred(pred.df)
#' plot_counts_pred(pred.df, sort = FALSE)

plot_counts_pred <- function(pred.df = NULL, ...) {

  pred.df |>
    dplyr::select(Plant, Animal, count) |>
    tidybayes::mean_qi() |>
    network.tools::plot_web_heatmap(int.var = "count", ...) +
    ggplot2::labs(title = "Predicted counts", fill = "")
}
