(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    103079,       2516]
NotebookOptionsPosition[    100957,       2437]
NotebookOutlinePosition[    101325,       2453]
CellTagsIndexPosition[    101282,       2450]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "The", " ", "notebook", " ", "is", " ", "organized", " ", "as", " ", 
     RowBox[{"follows", ".", " ", "In"}], " ", "Section", " ", "0", " ", 
     "there", " ", "are", " ", "model", " ", "input", " ", 
     RowBox[{"parameters", ".", " ", "In"}], " ", "section", " ", "I", " ", 
     "there", " ", "are", " ", "import", " ", "of", " ", 
     RowBox[{"FairSHiP", "'"}], "s", " ", "data", " ", "and", " ", "defining",
      " ", "the", " ", "amount", " ", "of", " ", "produced", " ", "HNLs"}], 
    ",", " ", 
    RowBox[{"decay", " ", "probability", " ", "and", " ", "detection", " ", 
     RowBox[{"acceptance", ".", " ", "In"}], " ", "section", " ", "II", " ", 
     "there", " ", "is", " ", "a", " ", "generation", " ", "of", " ", "a", 
     " ", "contour", " ", "of", " ", "the", " ", "SHiP", " ", "experiment", 
     " ", "sensitivity", " ", "bound", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"defined", " ", "as", " ", "90", "%", " ", 
        RowBox[{"C", ".", "L", ".", " ", "exclusion"}], " ", "limit"}], ",", 
       " ", 
       RowBox[{
       "which", " ", "corresponds", " ", "to", " ", "2.3", " ", "detected", 
        " ", "HNL", " ", "decay", " ", "events"}]}], ")"}], " ", "to", " ", 
     "the", " ", "given", " ", "model", " ", "parametrized", " ", "by", " ", 
     "the", " ", "ratio", " ", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["U", "e"], "2"], ":", 
      SuperscriptBox[
       SubscriptBox["U", "\[Mu]"], "2"], ":", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["U", "\[Tau]"], "2"], " ", "in", " ", "external", " ", 
       "file", " ", "located", " ", "at", " ", "notebook", " ", 
       RowBox[{"directory", ".", " ", "The"}], " ", "file", " ", "contains", 
       " ", "a", " ", "table", " ", "with", " ", "two", " ", 
       RowBox[{"columns", ":", " ", 
        RowBox[{"'", "HNL", " ", "mass", " ", "in", " ", 
         RowBox[{"GeV", "'"}], " ", 
         RowBox[{"and", " ", "'"}], 
         SuperscriptBox["U", "2"], " ", "at", " ", "the", " ", "sensitivity", 
         " ", 
         RowBox[{
          RowBox[{"bound", "'"}], "."}]}]}]}]}]}]}], " ", 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"To", " ", "generate", " ", "the", " ", "external", " ", "file"}],
     ",", " ", 
    RowBox[{
     RowBox[{
     "just", " ", "set", " ", "the", " ", "parameters", " ", "from", " ", 
      "Section", " ", "0", " ", "to", " ", "desired", " ", "values", " ", 
      "and", " ", "then", " ", "evaluate", " ", "Sections", " ", "0"}], "-", 
     "2"}]}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7421956383923683`*^9, 3.7421956903481627`*^9}, {
   3.7421957405500298`*^9, 3.742195744398074*^9}, {3.742195810349555*^9, 
   3.7421958284267282`*^9}, {3.7421958587452955`*^9, 3.742196113725655*^9}, {
   3.7421961469750247`*^9, 3.7421961974558754`*^9}, {3.7421962307244344`*^9, 
   3.7421962978638477`*^9}, {3.7421974340547504`*^9, 
   3.7421974676314917`*^9}, {3.7421995423425255`*^9, 3.742199570657258*^9}, {
   3.7421996802363415`*^9, 3.742199710165324*^9}, {3.7422016679159346`*^9, 
   3.7422016683849277`*^9}, {3.7422020151175165`*^9, 
   3.7422020685366898`*^9}, {3.742214750896453*^9, 3.742214771227256*^9}, 
   3.7422783691328964`*^9, {3.7422791123071127`*^9, 
   3.7422791214629903`*^9}},ExpressionUUID->"e04de9d0-9991-4666-b0c6-\
6999fe642074"],

Cell[CellGroupData[{

Cell["0. Input parameters", "Section",
 CellChangeTimes->{{3.7421974773415737`*^9, 
  3.7421974804433303`*^9}},ExpressionUUID->"891b58b0-ba69-4ea0-b1d8-\
4bcbcdafc1a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Parameters", " ", "xe"}], ",", " ", "xm", ",", " ", 
    RowBox[{
     RowBox[{"xt", " ", "defining", " ", "the", " ", "ratio", " ", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["U", "e"], "2"], ":", 
       SuperscriptBox[
        SubscriptBox["U", "\[Mu]"], "2"], ":", 
       SuperscriptBox[
        SubscriptBox["U", "\[Tau]"], "2"]}]}], " ", "=", " ", 
     RowBox[{"xe", ":", "xm", ":", "xt"}]}]}], "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"Xe", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Xm", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Xt", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "MIXINGANGLE", " ", "defines", " ", "the", " ", "parametrization", " ", 
       "for", " ", "mixing", " ", "angles", " ", "using", " ", "mixing", " ", 
       "angle", " ", "ratios", " ", "and", " ", "the", " ", "overal", " ", 
       "normalization", " ", 
       RowBox[{
        SuperscriptBox["U", "2"], ".", " ", "There"}], " ", "are", " ", "4", 
       " ", 
       RowBox[{"options", ":", "\[IndentingNewLine]", 
        RowBox[{"\"\<\!\(\*SuperscriptBox[\(U\), \(2\)]\)\>\"", " ", "-", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            SubscriptBox["U", "e"], "2"], ",", 
           SuperscriptBox[
            SubscriptBox["U", "\[Mu]"], "2"], ",", 
           SuperscriptBox[
            SubscriptBox["U", "\[Tau]"], "2"]}], ")"}]}]}]}], "=", 
      RowBox[{
       FractionBox[
        SuperscriptBox["U", "2"], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["Xe", "2"], "+", 
          SuperscriptBox["Xm", "2"], "+", 
          SuperscriptBox["Xt", "2"]}]]], 
       RowBox[{"(", 
        RowBox[{"Xe", ",", "Xm", ",", "Xt"}], ")"}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(U\), \(e\)], \(2\)]\)\>\"", 
       " ", "-", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["U", "e"], "2"], ",", 
         SuperscriptBox[
          SubscriptBox["U", "\[Mu]"], "2"], ",", 
         SuperscriptBox[
          SubscriptBox["U", "\[Tau]"], "2"]}], ")"}]}], "=", 
      RowBox[{
       SuperscriptBox["U", "2"], 
       RowBox[{"(", 
        RowBox[{"1", ",", 
         FractionBox["Xm", "Xe"], ",", 
         FractionBox["Xt", "Xe"]}], ")"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(U\), \(\[Mu]\)], \(2\)]\)\>\"",
        " ", "-", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["U", "e"], "2"], ",", 
         SuperscriptBox[
          SubscriptBox["U", "\[Mu]"], "2"], ",", 
         SuperscriptBox[
          SubscriptBox["U", "\[Tau]"], "2"]}], ")"}]}], "=", 
      RowBox[{
       SuperscriptBox["U", "2"], 
       RowBox[{"(", 
        RowBox[{
         FractionBox["Xe", "Xm"], ",", "1", ",", 
         FractionBox["Xt", "Xm"]}], ")"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(U\), \(\[Tau]\)], \
\(2\)]\)\>\"", " ", "-", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["U", "e"], "2"], ",", 
         SuperscriptBox[
          SubscriptBox["U", "\[Mu]"], "2"], ",", 
         SuperscriptBox[
          SubscriptBox["U", "\[Tau]"], "2"]}], ")"}]}], "=", 
      RowBox[{
       SuperscriptBox["U", "2"], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox["Xe", "Xt"], ",", 
          FractionBox["Xm", "Xt"], ",", "1"}], ")"}], "."}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Do", " ", "not", " ", "choose", " ", 
     SuperscriptBox[
      SubscriptBox["U", "i"], "2"], " ", "if", " ", "corresponding", " ", 
     SubscriptBox["x", "i"], " ", "is", " ", 
     RowBox[{"zero", "!"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "MIXINGANGLE", "=", "\"\<\!\(\*SuperscriptBox[\(U\), \(2\)]\)\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"WITHBC", " ", "determines", " ", "to", " ", "use", " ", 
      SubscriptBox["B", "c"], " ", "meson", " ", "or", " ", 
      RowBox[{"no", ".", " ", "The"}], " ", "possible", " ", 
      RowBox[{"values", ":", "\[IndentingNewLine]", 
       RowBox[{"False", " ", "-", " ", 
        RowBox[{"not", " ", "to", " ", "use", " ", 
         SubscriptBox["B", "c"], " ", "meson", " ", "for", " ", "sensitivity",
          " ", "calculation"}]}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"True", " ", "-", " ", 
       RowBox[{"use", " ", 
        SubscriptBox["B", "c"], " ", "mesons", " ", "with", " ", "production",
         " ", "fraction", " ", 
        SubscriptBox["f", 
         RowBox[{"b", "\[Rule]", 
          SubscriptBox["B", "c"]}]]}]}], "=", " ", 
      RowBox[{"2.6", "*", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "3"}]], "."}]}]}]}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"WITHBC", "=", "True"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Name", " ", "of", " ", "external", " ", "file"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FILENAME", "=", "\"\<SensitivityContour.dat\>\""}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.749535583786748*^9, 3.74953558680275*^9}},
 ExpressionUUID -> "5d33ceda-2d45-4006-833a-12574bac0d26"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Importing files and defining functions", "Section",
 CellChangeTimes->{{3.741780808172905*^9, 
  3.741780815331168*^9}},ExpressionUUID->"bf6d9558-918d-488c-9319-\
7e824e8e4220"],

Cell[CellGroupData[{

Cell["Importing files", "Subsection",
 CellChangeTimes->{{3.741983281532173*^9, 
  3.741983284310588*^9}},ExpressionUUID->"428d6012-7106-4f6f-ac0c-\
11762a4f8a12"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Importing", " ", 
                    RowBox[{"data", ".", " ", "It"}], " ", "is", " ", 
                    "organized", " ", "as", " ", "follows", " ", 
                    RowBox[{
                    RowBox[{"(", "columns", ")"}], ".", " ", "1"}]}], ")"}], 
                    " ", "Mass", " ", "in", " ", 
                    RowBox[{"GeV", ".", " ", "2"}]}], ")"}], " ", 
                    "Production", " ", "from", " ", "e", " ", "channel", " ", 
                    
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "3"}]}], ")"}],
                     " ", "Production", " ", "from", " ", "e", " ", "channel",
                     " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "4"}]}], ")"}],
                     " ", "Production", " ", "from", " ", "\[Mu]", " ", 
                    "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox[
                    StyleBox["B",
                    FontWeight->"Plain"], "c"]}], ")"}], ".", " ", "5"}]}], 
                    ")"}], " ", "Production", " ", "from", " ", "\[Mu]", " ", 
                    "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "6"}]}], ")"}],
                     " ", "Production", " ", "from", " ", "\[Tau]", " ", 
                    "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "7"}]}], ")"}],
                     " ", "Production", " ", "from", " ", "\[Tau]", " ", 
                    "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "8"}]}], ")"}],
                     " ", "Detection", " ", "efficiency", " ", "for", " ", 
                    "e", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "9"}]}], ")"}],
                     " ", "Detection", " ", "efficiency", " ", "for", " ", 
                    "e", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "10"}]}], 
                    ")"}], " ", "Detection", " ", "efficiency", " ", "for", 
                    " ", "\[Mu]", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox[
                    StyleBox["B",
                    FontWeight->"Plain"], "c"]}], ")"}], ".", " ", "11"}]}], 
                    ")"}], " ", "Detection", " ", "efficiency", " ", "for", 
                    " ", "\[Mu]", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "12"}]}], 
                    ")"}], " ", "Detection", " ", "efficiency", " ", "for", 
                    " ", "\[Tau]", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "13"}]}], 
                    ")"}], " ", "Detection", " ", "efficiency", " ", "for", 
                    " ", "\[Tau]", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "14"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "e", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "15"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "e", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "16"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "\[Mu]", 
                    " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "17"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "\[Mu]", 
                    " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "18"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "\[Tau]", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}]}], ",", " ", 
                    RowBox[{"assuming", " ", "e", " ", "production", " ", 
                    RowBox[{"channel", ".", " ", "19"}]}]}], ")"}], " ", 
                    "Decay", " ", "probability", " ", "component", " ", "for",
                     " ", "mixing", " ", "with", " ", "\[Tau]", " ", 
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}]}], ",", " ", 
                    RowBox[{"assuming", " ", "\[Tau]", " ", "production", " ", 
                    RowBox[{"channel", ".", " ", "20"}]}]}], ")"}], " ", 
                    "Decay", " ", "probability", " ", "component", " ", "for",
                     " ", "mixing", " ", "with", " ", "\[Tau]", " ", 
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}]}], ",", " ", 
                   RowBox[{"assuming", " ", "e", " ", "production", " ", 
                    RowBox[{"channel", ".", " ", "21"}]}]}], ")"}], " ", 
                 "Decay", " ", "probability", " ", "component", " ", "for", 
                 " ", "mixing", " ", "with", " ", "\[Tau]", " ", 
                 RowBox[{"(", 
                  RowBox[{"without", " ", 
                   SubscriptBox["B", "c"]}], ")"}]}], ",", " ", 
                RowBox[{"assuming", " ", "\[Tau]", " ", "production", " ", 
                 RowBox[{"channel", ".", " ", "22"}]}]}], ")"}], " ", "<", 
              SubscriptBox["\[Gamma]", "N"], ">", " ", 
              RowBox[{"for", " ", "mixing", " ", "with", " ", 
               SubscriptBox["\[Nu]", "e"], " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"with", " ", 
                  SubscriptBox["B", "c"]}], ")"}], ".", " ", "23"}]}]}], 
             ")"}], " ", "<", 
            SubscriptBox["\[Gamma]", "N"], ">", " ", 
            RowBox[{"for", " ", "mixing", " ", "with", " ", 
             SubscriptBox["\[Nu]", "e"], " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"without", " ", 
                SubscriptBox["B", "c"]}], ")"}], ".", " ", "24"}]}]}], ")"}], 
          " ", "<", 
          SubscriptBox["\[Gamma]", "N"], ">", " ", 
          RowBox[{"for", " ", "mixing", " ", "with", " ", 
           SubscriptBox["\[Nu]", "\[Mu]"], " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"with", " ", 
              SubscriptBox["B", "c"]}], ")"}], ".", " ", "25"}]}]}], ")"}], 
        " ", "<", 
        SubscriptBox["\[Gamma]", "N"], ">", " ", 
        RowBox[{"for", " ", "mixing", " ", "with", " ", 
         SubscriptBox["\[Nu]", "\[Mu]"], " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"without", " ", 
            SubscriptBox["B", "c"]}], ")"}], ".", " ", "26"}]}]}], ")"}], " ",
       "<", 
      SubscriptBox["\[Gamma]", "N"], ">", " ", 
      RowBox[{"for", " ", "mixing", " ", "with", " ", 
       SubscriptBox["\[Nu]", "\[Tau]"], " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"with", " ", 
          SubscriptBox["B", "c"]}], ")"}], ".", " ", "27"}]}]}], ")"}], " ", 
    "<", 
    SubscriptBox["\[Gamma]", "N"], ">", " ", 
    RowBox[{"for", " ", "mixing", " ", "with", " ", 
     SubscriptBox["\[Nu]", "\[Tau]"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"without", " ", 
        SubscriptBox["B", "c"]}], ")"}], "."}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"InputTable", "=", 
     RowBox[{"Import", "[", "\"\<inputfile.dat\>\"", "]"}]}], 
    ";"}]}]}]], "Input",ExpressionUUID->"bf7e9a1e-6a28-4d52-84d9-\
a007cb9c0862"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Production vectors", "Subsection",
 CellChangeTimes->{{3.74198329806074*^9, 
  3.7419833001208878`*^9}},ExpressionUUID->"bd0e8240-1be7-417b-92b1-\
bdc46d5a3226"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"U2vector", "[", 
     RowBox[{"U2_", ",", "xe_", ",", "xm_", ",", "xt_"}], "]"}], " ", "=", 
    " ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
      "MIXINGANGLE", "\[Equal]", 
       "\"\<\!\(\*SuperscriptBox[\(U\), \(2\)]\)\>\""}], ",", 
      RowBox[{
       FractionBox["U2", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          SuperscriptBox["xe", "2"], "+", 
          SuperscriptBox["xm", "2"], "+", 
          SuperscriptBox["xt", "2"]}], "]"}]], 
       RowBox[{"{", 
        RowBox[{"xe", ",", "xm", ",", "xt"}], "}"}]}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
        "MIXINGANGLE", "\[Equal]", 
         "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(U\), \(e\)], \
\(2\)]\)\>\""}], ",", 
        RowBox[{"U2", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           FractionBox["xm", "xe"], ",", 
           FractionBox["xt", "xe"]}], "}"}]}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
          "MIXINGANGLE", "\[Equal]", 
           "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(U\), \(\[Mu]\)], \(2\)]\)\
\>\""}], ",", 
          RowBox[{"U2", 
           RowBox[{"{", 
            RowBox[{
             FractionBox["xe", "xm"], ",", "1", ",", 
             FractionBox["xt", "xm"]}], "}"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
            "MIXINGANGLE", "\[Equal]", 
             "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(U\), \(\[Tau]\)], \
\(2\)]\)\>\""}], ",", 
            RowBox[{"U2", 
             RowBox[{"{", 
              RowBox[{
               FractionBox["xe", "xt"], ",", 
               FractionBox["xm", "xt"], ",", "1"}], "}"}]}], ",", "0"}], 
           "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Production", " ", "vector", " ", "in", " ", "the", " ", "form", " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["N", 
       RowBox[{"prod", ",", "e"}]], ";", " ", 
      SubscriptBox["N", 
       RowBox[{"prod", ",", "\[Mu]"}]], ";", " ", 
      SubscriptBox["N", 
       RowBox[{"prod", ",", "\[Tau]"}]]}], ")"}], " ", "at", " ", "unit", " ",
     "U", " ", "for", " ", "each", " ", "channel"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionVectorTemp", "[", 
   RowBox[{"M_", ",", 
    RowBox[{"WithBc_:", "False"}]}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{"WithBc", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
       "]"}], ",", 
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
       "]"}], ",", 
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
       "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
       "]"}], ",", 
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
       "]"}], ",", 
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
       "]"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductionVector", "[", 
    RowBox[{"M_", ",", "U2_", ",", "xe_", ",", "xm_", ",", "xt_"}], "]"}], 
   "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ProductionVectorTemp", "[", 
        RowBox[{"M", ",", "WITHBC"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], 
      RowBox[{
       RowBox[{"U2vector", "[", 
        RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"ProductionVectorTemp", "[", 
        RowBox[{"M", ",", "WITHBC"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], 
      RowBox[{
       RowBox[{"U2vector", "[", 
        RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"ProductionVectorTemp", "[", 
        RowBox[{"M", ",", "WITHBC"}], "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], 
      RowBox[{
       RowBox[{"U2vector", "[", 
        RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ProductionVector", "[", 
  RowBox[{"2", ",", "1", ",", "Xe", ",", "Xm", ",", "Xt"}], "]"}]}], "Input",E\
xpressionUUID->"e7375a29-dd22-45ce-a947-6d3e00021175"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "0.`", ",", "5.4592974580047327`*^11", ",", "7.142532761817798`*^9"}], 
   "}"}], TraditionalForm]], "Output",ExpressionUUID->"af197da0-9381-4a16-\
9da3-12d76e84f927"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Decay vectors", "Subsection",
 CellChangeTimes->{{3.7419828553911963`*^9, 
  3.7419828574306784`*^9}},ExpressionUUID->"536b43c5-f375-435f-b193-\
fb0c39269176"],

Cell[CellGroupData[{

Cell["1. Definitions", "Subsubsection",ExpressionUUID->"4367137e-c276-42d8-ae10-2912d81826a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Decay", " ", "vectors", " ", "in", " ", "the", " ", "form", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["l", 
        RowBox[{"to", " ", "detector"}]], "/", 
       SubscriptBox["l", 
        RowBox[{"decay", ",", "e"}]]}], ";", " ", 
      RowBox[{
       SubscriptBox["l", 
        RowBox[{"to", " ", "detector"}]], "/", 
       SubscriptBox["l", 
        RowBox[{"decay", ",", "\[Mu]"}]]}], ";", " ", 
      RowBox[{
       SubscriptBox["l", 
        RowBox[{"to", " ", "detector"}]], "/", 
       SubscriptBox["l", 
        RowBox[{"decay", ",", "\[Tau]"}]]}]}], ")"}], " ", "at", " ", "unit", 
    " ", "U", " ", "for", " ", "each", " ", "channel"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"DecayComponent\[Tau]\[Tau]WithBc", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "19"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "4.52"}], "&"}]}], "]"}], 
       ",", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "18"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "4.52"}], "&&", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", "6.15"}]}], "&"}]}], 
        "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayComponent\[Tau]\[Tau]WithoutBc", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "21"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "3.52"}], "&"}]}], "]"}], 
       ",", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "3.52"}], "&&", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", "6.15"}]}], "&"}]}], 
        "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVectorAssociation", "[", 
     RowBox[{"flavorProd_", ",", "flavorDec_", ",", 
      RowBox[{"WithBc_:", "False"}], ",", "i_"}], "]"}], ":=", 
    RowBox[{"If", "[", 
     RowBox[{"WithBc", ",", 
      RowBox[{
       RowBox[{"Association", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "\[Rule]", " ", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "22", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "14", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "22", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<e\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "22", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "16", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "24", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<e\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "22", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"DecayComponent\[Tau]\[Tau]WithBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "26", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<e\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "24", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "14", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "22", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "24", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "16", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "24", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], 
           "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "24", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"DecayComponent\[Tau]\[Tau]WithBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "26", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<e\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "26", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "14", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "22", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], 
           "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "26", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "16", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "24", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], 
           "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "26", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"DecayComponent\[Tau]\[Tau]WithBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "26", "]"}], "]"}]}]}]}], "}"}], "]"}], "[", 
       RowBox[{"{", 
        RowBox[{"flavorProd", ",", "flavorDec"}], "}"}], "]"}], ",", 
      RowBox[{
       RowBox[{"Association", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "\[Rule]", " ", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "23", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "15", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "23", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<e\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "23", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "17", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "25", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<e\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "23", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"DecayComponent\[Tau]\[Tau]WithoutBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "27", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<e\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "25", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "15", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "23", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "25", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "17", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "25", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], 
           "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "25", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"DecayComponent\[Tau]\[Tau]WithoutBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "27", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<e\>\""}], "}"}], "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "27", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "15", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "23", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
          
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], 
           "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "27", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "17", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "25", "]"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], 
           "\[Rule]", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              RowBox[{"InputTable", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "27", "]"}], "]"}]], 
            RowBox[{
             RowBox[{"DecayComponent\[Tau]\[Tau]WithoutBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{"InputTable", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "27", "]"}], "]"}]}]}]}], "}"}], "]"}], "[", 
       RowBox[{"{", 
        RowBox[{"flavorProd", ",", "flavorDec"}], "}"}], "]"}]}], 
     "]"}]}]}]}]], "Input",ExpressionUUID->"72c508d4-63f3-4237-965f-\
f1c1398f620e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Construction of decay vector", "Subsubsection",ExpressionUUID->"f3055119-ddc2-4bbb-a324-7ac345f2181e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DecayVectorTable", "[", 
   RowBox[{"flavorProd_", ",", "flavorDec_", ",", "WithBc_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"InputTable", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"DecayVectorAssociation", "[", 
       RowBox[{"flavorProd", ",", "flavorDec", ",", "WithBc", ",", "i"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "InputTable", "]"}], ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DecayVector", "[", 
    RowBox[{"mN_", ",", "U2_", ",", "xe_", ",", "xm_", ",", "xt_"}], "]"}], 
   "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"DecayVectorTable", "[", 
           RowBox[{"\"\<e\>\"", ",", "\"\<e\>\"", ",", "WITHBC"}], "]"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "mN", 
        "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"DecayVectorTable", "[", 
           RowBox[{"\"\<e\>\"", ",", "\"\<\[Mu]\>\"", ",", "WITHBC"}], "]"}], 
          ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "mN", 
        "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"DecayVectorTable", "[", 
           RowBox[{"\"\<e\>\"", ",", "\"\<\[Tau]\>\"", ",", "WITHBC"}], "]"}],
           ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "mN", 
        "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"DecayVectorTable", "[", 
           RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<e\>\"", ",", "WITHBC"}], "]"}], 
          ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "mN", 
        "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"DecayVectorTable", "[", 
           RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\"", ",", "WITHBC"}], 
           "]"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "mN", 
        "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"DecayVectorTable", "[", 
           RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Tau]\>\"", ",", "WITHBC"}], 
           "]"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "mN", 
        "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"DecayVectorTable", "[", 
           RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<e\>\"", ",", "WITHBC"}], "]"}],
           ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "mN", 
        "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"DecayVectorTable", "[", 
           RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Mu]\>\"", ",", "WITHBC"}], 
           "]"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "mN", 
        "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"DecayVectorTable", "[", 
           RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\"", ",", "WITHBC"}], 
           "]"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "mN", 
        "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",ExpressionUUID->"4314ac96-a127-4bba-\
908b-812d5487c689"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Decay probability", "Subsection",
 CellChangeTimes->{{3.741982890449233*^9, 
  3.741982893400933*^9}},ExpressionUUID->"339426de-4ee9-4527-8fb5-\
cd4aecb6706f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ldetector", "=", "46"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ltodetector", "=", "52"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DecayProbability", "[", 
    RowBox[{"mN_", ",", "U2_", ",", "xe_", ",", "xm_", ",", "xt_"}], "]"}], 
   "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"DecayVector", "[", 
           RowBox[{"mN", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
          "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "*", 
        FractionBox["ltodetector", "ldetector"]}], "]"}], "-", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"DecayVector", "[", 
           RowBox[{"mN", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
          "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "*", 
        FractionBox[
         RowBox[{"ldetector", "+", "ltodetector"}], "ldetector"]}], "]"}]}], 
     ",", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"DecayVector", "[", 
           RowBox[{"mN", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
          "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "*", 
        FractionBox["ltodetector", "ldetector"]}], "]"}], "-", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"DecayVector", "[", 
           RowBox[{"mN", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
          "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "*", 
        FractionBox[
         RowBox[{"ldetector", "+", "ltodetector"}], "ldetector"]}], "]"}]}], 
     ",", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"DecayVector", "[", 
           RowBox[{"mN", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
          "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "*", 
        FractionBox["ltodetector", "ldetector"]}], "]"}], "-", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"DecayVector", "[", 
           RowBox[{"mN", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
          "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "*", 
        FractionBox[
         RowBox[{"ldetector", "+", "ltodetector"}], "ldetector"]}], "]"}]}]}],
     "}"}]}], ";"}]}], "Input",ExpressionUUID->"9613c55c-cd11-4965-83db-\
a5ad3e72ffec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Detection acceptance", "Subsection",
 CellChangeTimes->{{3.741982918609409*^9, 
  3.741982923197935*^9}},ExpressionUUID->"13e2ca4b-12d8-4f17-a51d-\
248d636c2eef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"\[Gamma]", "-", "factors"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"gammafactor", "[", 
     RowBox[{"M_", ",", 
      RowBox[{"WithBc_:", "False"}]}], "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{"WithBc", ",", 
        RowBox[{
         RowBox[{"Interpolation", "[", 
          RowBox[{"InputTable", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "22"}], "}"}]}], "]"}], "]"}], "]"}], "[", 
         "M", "]"}], ",", 
        RowBox[{
         RowBox[{"Interpolation", "[", 
          RowBox[{"InputTable", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "23"}], "}"}]}], "]"}], "]"}], "]"}], "[", 
         "M", "]"}]}], "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{"WithBc", ",", 
        RowBox[{
         RowBox[{"Interpolation", "[", 
          RowBox[{"InputTable", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "24"}], "}"}]}], "]"}], "]"}], "]"}], "[", 
         "M", "]"}], ",", 
        RowBox[{
         RowBox[{"Interpolation", "[", 
          RowBox[{"InputTable", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "25"}], "}"}]}], "]"}], "]"}], "]"}], "[", 
         "M", "]"}]}], "]"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{"WithBc", ",", 
        RowBox[{
         RowBox[{"Interpolation", "[", 
          RowBox[{"InputTable", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "26"}], "}"}]}], "]"}], "]"}], "]"}], "[", 
         "M", "]"}], ",", 
        RowBox[{
         RowBox[{"Interpolation", "[", 
          RowBox[{"InputTable", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "27"}], "}"}]}], "]"}], "]"}], "]"}], "[", 
         "M", "]"}]}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Partial", " ", "Br", " ", "ratio"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PartialBrChannel", "[", 
     RowBox[{
     "M_", ",", "U2_", ",", "xe_", ",", "xm_", ",", "xt_", ",", "i_"}], "]"}],
     ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"DecayVector", "[", 
         RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
        "[", 
        RowBox[{"[", "i", "]"}], "]"}], "*", 
       RowBox[{
        RowBox[{"U2vector", "[", 
         RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"DecayVector", "[", 
          RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
         "[", 
         RowBox[{"[", "1", "]"}], "]"}], "*", 
        RowBox[{
         RowBox[{"U2vector", "[", 
          RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"DecayVector", "[", 
          RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
         "[", 
         RowBox[{"[", "2", "]"}], "]"}], "*", 
        RowBox[{
         RowBox[{"U2vector", "[", 
          RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"DecayVector", "[", 
          RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], 
         "[", 
         RowBox[{"[", "3", "]"}], "]"}], "*", 
        RowBox[{
         RowBox[{"U2vector", "[", 
          RowBox[{"U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}]}], ")"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Detection", " ", "acceptance"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DetectionAcceptance", "[", 
     RowBox[{"M_", ",", "U2_", ",", "xe_", ",", "xm_", ",", "xt_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
       "]"}], "*", 
      RowBox[{"PartialBrChannel", "[", 
       RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt", ",", "1"}], 
       "]"}]}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
       "]"}], "*", 
      RowBox[{"PartialBrChannel", "[", 
       RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt", ",", "2"}], 
       "]"}]}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"InputTable", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "12"}], "}"}]}], "]"}], "]"}], ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
       "]"}], "*", 
      RowBox[{"PartialBrChannel", "[", 
       RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt", ",", "3"}], 
       "]"}]}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"DetectionAcceptance", "[", 
    RowBox[{"0.5", ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "5"}]], ",", "Xe", ",", "Xm", ",", "Xt"}], 
    "]"}]}]}]], "Input",ExpressionUUID->"12849b21-924a-4822-8d43-\
83dafbfe0a16"],

Cell[BoxData[
 FormBox["0.20371447919251193`", TraditionalForm]], "Output",ExpressionUUID->"9ec6cf2f-3783-45f2-9481-af4c530f9267"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Decays number", "Subsection",
 CellChangeTimes->{{3.741982933968254*^9, 
  3.7419829361886845`*^9}},ExpressionUUID->"19818300-0d58-4746-9cb5-\
6f071dffc7fd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"EventsNumber", "[", 
    RowBox[{"M_", ",", "U2_", ",", "xe_", ",", "xm_", ",", "xt_"}], "]"}], 
   "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductionVector", "[", 
      RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}], ".", 
     RowBox[{"DecayProbability", "[", 
      RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}]}], "*", 
    RowBox[{"DetectionAcceptance", "[", 
     RowBox[{"M", ",", "U2", ",", "xe", ",", "xm", ",", "xt"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"EventsNumber", "[", 
  RowBox[{"1.5", ",", 
   SuperscriptBox["10", 
    RowBox[{"-", "10"}]], ",", "Xe", ",", "Xm", ",", "Xt"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"EventsNumber", "[", 
  RowBox[{"6", ",", 
   SuperscriptBox["10", 
    RowBox[{"-", "13"}]], ",", "Xe", ",", "Xm", ",", "Xt"}], "]"}]}], "Input",\
ExpressionUUID->"99f1ac07-a153-4027-9d6f-9d5801ba4f14"],

Cell[BoxData[
 FormBox["1.5627586429056037`", TraditionalForm]], "Output",ExpressionUUID->"96b4b278-1599-4c74-a954-7c623df337d9"],

Cell[BoxData[
 FormBox["9.380873318065438`*^-11", TraditionalForm]], "Output",ExpressionUUID->"4e9697df-bbed-40ea-b6cf-98f8981c5d6e"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["II. Generating sensitivity contours", "Section",
 CellChangeTimes->{{3.741780825725105*^9, 
  3.7417808380208006`*^9}},ExpressionUUID->"c11fef64-e56d-47e3-b911-\
3db93ae6a0a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "This", " ", "part", " ", "generates", " ", "data", " ", "and", " ", 
     "draws", " ", "the", " ", "sensitivity", " ", 
     RowBox[{"curve", ".", " ", "It"}], " ", "takes", " ", "some", " ", 
     "time"}], ",", " ", 
    RowBox[{"please", " ", "wait"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MIXINGANGLEASSOCIATION", "=", 
     RowBox[{"Association", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
        "\"\<\!\(\*SuperscriptBox[\(U\), \(2\)]\)\>\"", "\[Rule]", " ", 
         RowBox[{"Xe", "+", "Xm", "+", "Xt"}]}], ",", 
        RowBox[{
        "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(U\), \(e\)], \(2\)]\)\>\"", 
         "\[Rule]", " ", "Xe"}], ",", 
        RowBox[{
        "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(U\), \(\[Mu]\)], \
\(2\)]\)\>\"", "\[Rule]", " ", "Xm"}], ",", 
        RowBox[{
        "\"\<\!\(\*SuperscriptBox[SubscriptBox[\(U\), \(\[Tau]\)], \(2\)]\)\>\
\"", "\[Rule]", " ", "Xt"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MIXINGANGLEASSOCIATION", "[", "MIXINGANGLE", "]"}], 
      "\[NotEqual]", "0"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ModelSensitivity", "=", 
       RowBox[{"Quiet", "[", 
        RowBox[{"RegionPlot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"EventsNumber", "[", 
            RowBox[{"M", ",", 
             SuperscriptBox["10", "U2"], ",", "Xe", ",", "Xm", ",", "Xt"}], 
            "]"}], "\[GreaterEqual]", "2.3"}], ",", 
          RowBox[{"{", 
           RowBox[{"M", ",", "0", ",", "6.2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"U2", ",", 
            RowBox[{"-", "13"}], ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"NotebookDirectory", "[", "]"}], ",", "FILENAME"}], "}"}], 
         "]"}], ",", 
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"10", "^", 
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "&"}], "/@", 
           RowBox[{"Partition", "[", 
            RowBox[{
             RowBox[{"Flatten", "[", 
              RowBox[{"Cases", "[", 
               RowBox[{
                RowBox[{"Normal", "@", "ModelSensitivity"}], ",", 
                RowBox[{
                 RowBox[{"Line", "[", "x_", "]"}], "\[RuleDelayed]", "x"}], 
                ",", "Infinity"}], "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ">", 
             SuperscriptBox["10", 
              RowBox[{"-", "4"}]]}], "&&", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "<", "0.098"}]}], "&"}]}], 
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ListLogPlot", "[", 
       RowBox[{
        RowBox[{"Import", "[", "FILENAME", "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "6.2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "13"}]], ",", 
             SuperscriptBox["10", 
              RowBox[{"-", "2"}]]}], "}"}]}], "}"}]}], ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"Filling", "\[Rule]", "Top"}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", 
         RowBox[{"3", "/", "4"}]}], ",", 
        RowBox[{"FrameStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"22", ",", "Black"}], "]"}]}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<HNL mass [GeV]\>\"", ",", "MIXINGANGLE"}], "}"}]}], 
        ",", 
        RowBox[{"GridLines", "\[Rule]", " ", "Automatic"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", 
        RowBox[{"LabelStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"Black", ",", 
           RowBox[{"FontSize", "\[Rule]", 
            RowBox[{"Scaled", "[", ".05", "]"}]}]}], "]"}]}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{
     "Print", "[", 
      "\"\<Choose another \!\(\*SuperscriptBox[\(U\), \(2\)]\) for the \
plot!\>\"", "]"}]}], "]"}]}]}]], "Input",ExpressionUUID->"d8e082bb-a3a5-4983-\
b967-fc2e4989c433"],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, GraphicsComplexBox[CompressedData["
1:eJxdmHk4VV37x82kcIyVoczTMRybc4hYqwmFHqE3IioRkUiGJFOlKLPKUHqS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     "], {{
       {RGBColor[0.368417, 0.506779, 0.709798], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwV1FVgEAQUBdABo0ZsMNjoBSkgLd2tkkNAUrqUDunuLgVppZWURkClG5SS
DqVLpZuzj3M/3tf9uS+qReeYTnEDAgLikE3kIDuxt3gEEp8EJCQRiQkiCUlJ
RnKCCSEFKQklFakJI5w0pCUd6clARjIRQSRRRJOZLGSN7UZ2cvABOclFbj4k
D3nJR34KUJBCfERhilCUYhSnBCUpRWnKUJZylKcCFalEZapQlY/5hE+pRnVq
UJNa1CaGOnxGXepRn89pQEMa0ZgmNOULmtGcFrSkFa1pQ1va0Z4OfMlXdKQT
nelCV7rRnR70pBdf05s+9KUf/RnAQAYxmCEMZRjDGcFIRjGaMYxlHOOZwEQm
MZkpTGUa0/mGb5nBTL5jFrOZw1zmMZ8FfM8PLGQRi1nCUpaxnB/5iRWsZBWr
WcNafmYd69nARjaxmS1s5Re2sZ0d/Mpv/M5OdrGbPexlH/s5wEEOcZgjHOUY
x/mDPznBSU5xmjP8xVnOcZ4LXOQSl7nCVa7xN/9wnRvc5Ba3ucNd7nGfBzzk
X/7jfx7xmCc85RnPecFLXvGaN7zlHbGPIE7s/olHIPFJQEISkZggkpCUZCQn
mBBSkJJQUpGaMMJJQ1rSkZ4MZCQTEUQSRTSZyUJW3gMfE4SS
          
          "]]]}, {}, {}, {}}, {{}, {}, 
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.007333333333333334], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwV01V4EAQABOANRmzUYEHDRg4E6W4pkR5d0indrZR0CUgo3WGAKI3SHUpJ
Kh1KKp0/D/9993gvF92qW2zXwICAgGwiO3H0uAQRj/gkICHBhJCIxCQhKckI
JTkpCCOcCCJJSSpSk4a0pCM9GchIFNFkIjNZyPp+F9mJIQc5+YBc5OZD8pCX
fOSnAAUpRGGKUJRiFKcEJSlFacpQlnJ8RHkqUJFKVOZjqvAJValGdWpQk1rU
JpY61KUe9WlAQxrRmCY0pRmf0pwWtKQVrWlDW9rRng50pBOf0ZkudKUb3elB
T3rRmz70pR/9GcBABjGYIQzlc75gGMMZwUhG8SWjGcNYxjGeCUxkEpOZwlS+
YhrTmcHXzGQWs5nDN3zLXOYxnwUsZBGLWcJSlrGcFaxkFatZw3d8zw/8yFrW
8RPr+Zlf2MBGNrGZLWxlG9v5ld/YwU52sZs97GUf+znAQQ5xmCMc5RjH+Z0/
OMFJTnGaM/zJWc5xngtc5BJ/8TeXucJVrnGdG9zkFre5wz/8y13ucZ8HPOQR
//E/j3nCU57xnBe85BWvecNbAnw/8P3/iUsQ8YhPAhISTAiJSEwSkpKMUJKT
gjDCiSCSlKQiNWlISzrSk4GMRBFNJjKThazE8A5dioSQ
         
         "]]}}}], {}, {}, {{}, {}}, {{}, {}}},
   AspectRatio->NCache[
     Rational[3, 4], 0.75],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, -29.806964028807922`},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
      "\"\\!\\(\\*SuperscriptBox[SubscriptBox[\\(U\\), \\(\[Mu]\\)], \\(2\\)]\
\\)\"", TraditionalForm], None}, {
      FormBox["\"HNL mass [GeV]\"", TraditionalForm], None}},
   FrameStyle->Directive[22, 
     GrayLevel[0]],
   FrameTicks->FrontEndValueCache[{{
       Charting`ScaledTicks[{Log, Exp}], 
       Charting`ScaledFrameTicks[{Log, Exp}]}, {
      Automatic, Automatic}}, {{{{-29.933606208922594`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "13"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-25.328436022934504`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-20.72326583694641, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-6.907755278982137, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-27.631021115928547`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-4.605170185988091, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}}, {{-29.933606208922594`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-25.328436022934504`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-20.72326583694641, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-16.11809565095832, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-6.907755278982137, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.01, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-27.631021115928547`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-9.210340371976182, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-4.605170185988091, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
         FormBox[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {0.005, 
         0.}, {
          AbsoluteThickness[0.1]}}}}, {Automatic, Automatic}}],
   GridLines->FrontEndValueCache[{Automatic, 
      Charting`ScaledTickValues[{Log, Exp}]}, {
     Automatic, {{-29.933606208922594`, 
        Directive[
         AbsoluteThickness[0.1]]}, {-25.328436022934504`, 
        Directive[
         AbsoluteThickness[0.1]]}, {-20.72326583694641, 
        Directive[
         AbsoluteThickness[0.1]]}, {-16.11809565095832, 
        Directive[
         AbsoluteThickness[0.1]]}, {-11.512925464970229`, 
        Directive[
         AbsoluteThickness[0.1]]}, {-6.907755278982137, 
        Directive[
         AbsoluteThickness[0.1]]}}}],
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->Large,
   LabelStyle->Directive[
     GrayLevel[0], FontSize -> Scaled[0.05]],
   Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Exp[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Exp[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->
    NCache[{{0, 6.2}, {-Log[10000000000000], -Log[100]}}, {{
      0, 6.2}, {-29.933606208922594`, -4.605170185988092}}],
   PlotRangeClipping->True,
   PlotRangePadding->{{0, 0}, {0, 0}},
   Ticks->{Automatic, 
     Charting`ScaledTicks[{Log, Exp}]}], TraditionalForm]], "Output",ImageCach\
e->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"15cd767c-9af7-4fbe-bd78-74c624c7a4c7"]
}, Open  ]],

Cell[BoxData[""], "Input",ExpressionUUID->"0c5048cd-f618-48b8-8418-cb65b9f70df8"],

Cell[BoxData[""], "Input",ExpressionUUID->"a52688f3-29bf-4502-bea8-8e473fc56f84"]
}, Open  ]]
},
WindowSize->{1500, 917},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.25 Inherited,
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[400, 13, 3475, 69, 396, "Input"],
Cell[CellGroupData[{
Cell[3900, 86, 168, 3, 88, "Section"],
Cell[4071, 91, 5655, 153, 712, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9763, 249, 186, 3, 88, "Section"],
Cell[CellGroupData[{
Cell[9974, 256, 163, 3, 62, "Subsection"],
Cell[10140, 261, 11260, 256, 908, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21437, 522, 167, 3, 73, "Subsection"],
Cell[CellGroupData[{
Cell[21629, 529, 6083, 175, 430, "Input"],
Cell[27715, 706, 222, 6, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27986, 718, 165, 3, 91, "Subsection"],
Cell[CellGroupData[{
Cell[28176, 725, 94, 0, 77, "Subsubsection"],
Cell[28273, 727, 16232, 425, 1918, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44542, 1157, 111, 0, 77, "Subsubsection"],
Cell[44656, 1159, 5455, 146, 510, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50160, 1311, 165, 3, 91, "Subsection"],
Cell[50328, 1316, 2589, 75, 371, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52954, 1396, 168, 3, 91, "Subsection"],
Cell[CellGroupData[{
Cell[53147, 1403, 6136, 170, 628, "Input"],
Cell[59286, 1575, 130, 1, 58, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59465, 1582, 163, 3, 91, "Subsection"],
Cell[CellGroupData[{
Cell[59653, 1589, 951, 24, 147, "Input"],
Cell[60607, 1615, 129, 1, 58, "Output"],
Cell[60739, 1618, 133, 1, 62, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60933, 1626, 182, 3, 135, "Section"],
Cell[CellGroupData[{
Cell[61140, 1633, 5029, 130, 488, "Input"],
Cell[66172, 1765, 34589, 664, 846, 17790, 388, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[100776, 2432, 81, 0, 58, "Input"],
Cell[100860, 2434, 81, 0, 58, "Input"]
}, Open  ]]
}
]
*)

