(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    143393,       3907]
NotebookOptionsPosition[    141920,       3851]
NotebookOutlinePosition[    142290,       3867]
CellTagsIndexPosition[    142247,       3864]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"This", " ", "notebook", " ", "uses", " ", 
   RowBox[{"results", ".", "dat"}], " ", "to", " ", "produce", " ", 
   "intermediate", " ", "file", " ", 
   RowBox[{"inputfile", ".", "dat"}], " ", "that", " ", "is", " ", "needed", 
   " ", "for", " ", "effective", " ", "sensitivity", " ", "curve", " ", 
   RowBox[{"production", ".", " ", "You"}], " ", "need", " ", "to", " ", 
   "run", " ", "it", " ", "only", " ", 
   RowBox[{"once", "!"}], "\[IndentingNewLine]", "\[IndentingNewLine]", "If", 
   " ", "you", " ", "are", " ", "interested", " ", "in", " ", "the", " ", 
   "content", " ", "of", " ", "the", " ", 
   RowBox[{"inputfile", ".", "dat"}], " ", "see", " ", "the", " ", 
   "description", " ", "in", " ", "the", " ", "section", " ", "IV"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.745835274088438*^9, 3.745835373023264*^9}, {
  3.745835709017397*^9, 3.745835750310245*^9}, {3.7458371478383083`*^9, 
  3.7458371604739933`*^9}, {3.745837369604125*^9, 3.7458374401659117`*^9}}],

Cell[CellGroupData[{

Cell["1. Loading data", "Section",
 CellChangeTimes->{{3.7417809963172674`*^9, 3.741781006627085*^9}, {
  3.745835264387372*^9, 3.745835265199527*^9}},
 ExpressionUUID -> "60abd6f5-e7d6-4a2d-a831-df81e668ca11"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Llist", "=", 
    RowBox[{"{", 
     RowBox[{"\"\<e\>\"", ",", "\"\<\[Mu]\>\"", ",", "\"\<\[Tau]\>\""}], 
     "}"}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"List", " ", "with", " ", "lepton", " ", "flavors"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Auxiliary", " ", "functions"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Get", " ", "lepton", " ", "flavor", " ", "by", " ", "list", " ", "of", 
    " ", "couplings"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GetL", "[", "Couplings_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "Lnum", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Lnum", "=", 
       RowBox[{"Position", "[", 
        RowBox[{"Couplings", ",", 
         RowBox[{"_", "?", "Positive"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "Lnum", "]"}], "\[NotEqual]", "1"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<Cannot find a main coupling in \>\"", ",", "Couplings", ",", 
           "\"\<. Exit.\>\""}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Abort", "[", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Llist", "[", 
       RowBox[{"[", 
        RowBox[{"Lnum", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Add", " ", "new", " ", "data", " ", "point", " ", "to", " ", "the", " ", 
    "corresponding", " ", "MassList"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddPoint", "[", 
    RowBox[{"Mass_", ",", "Couplings_", ",", "Results_", ",", "Meson_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "tmpMassList", ",", "massi", ",", "i", ",", "ProductionL", ",", 
       "DecayL"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Meson", "\[Equal]", "\"\<D\>\""}], ",", 
        RowBox[{"tmpMassList", "=", "MassListD"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Meson", "\[Equal]", "\"\<B\>\""}], ",", 
          RowBox[{"tmpMassList", "=", "MassListB"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpMassList", "=", "MassListBc"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"massi", "=", 
       RowBox[{"-", "1"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", " ", 
         RowBox[{"Length", "[", "tmpMassList", "]"}]}], ",", 
        RowBox[{"i", "++"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"tmpMassList", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            "\"\<\!\(\*SubscriptBox[\(M\), \(N\)]\)\>\"", "]"}], "\[Equal]", 
           "Mass"}], ",", 
          RowBox[{"massi", "=", "i"}]}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"massi", "\[Equal]", 
         RowBox[{"-", "1"}]}], ",", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"tmpMassList", ",", 
          RowBox[{"<|", 
           RowBox[{
           "\"\<\!\(\*SubscriptBox[\(M\), \(N\)]\)\>\"", "\[Rule]", " ", 
            "Mass"}], "|>"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ProductionL", "=", 
       RowBox[{"GetL", "[", 
        RowBox[{"Couplings", "[", 
         RowBox[{"[", 
          RowBox[{";;", "3"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DecayL", "=", 
       RowBox[{"GetL", "[", 
        RowBox[{"Couplings", "[", 
         RowBox[{"[", 
          RowBox[{"4", ";;"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{
        RowBox[{"tmpMassList", "[", 
         RowBox[{"[", "massi", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ProductionL", ",", "DecayL"}], "}"}], "\[Rule]", 
         "Results"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Meson", "\[Equal]", "\"\<D\>\""}], ",", 
        RowBox[{"MassListD", "=", "tmpMassList"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Meson", "\[Equal]", "\"\<B\>\""}], ",", 
          RowBox[{"MassListB", "=", "tmpMassList"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"MassListBc", "=", "tmpMassList"}]}], "]"}]}], "]"}], 
      ";"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Return", " ", "M", " ", "and", " ", 
    SubscriptBox["N", "det"], " ", "data", " ", "for", " ", "the", " ", 
    "given", " ", "production", " ", "and", " ", "decay", " ", "flavors"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GetMNdata", "[", 
   RowBox[{"lp_", ",", "ld_", ",", "meson_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tmpMassList", ",", "MNlist", ",", "i"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"meson", "\[Equal]", "\"\<D\>\""}], ",", 
       RowBox[{"tmpMassList", "=", "MassListD"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"meson", "\[Equal]", "\"\<B\>\""}], ",", 
         RowBox[{"tmpMassList", "=", "MassListB"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"tmpMassList", "=", "MassListBc"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"MNlist", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"Length", "[", "tmpMassList", "]"}]}], ",", 
       RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"Keys", "[", 
            RowBox[{"tmpMassList", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"lp", ",", "ld"}], "}"}]}], "]"}], ",", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"MNlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"tmpMassList", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              "\"\<\!\(\*SubscriptBox[\(M\), \(N\)]\)\>\"", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"tmpMassList", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"{", 
                RowBox[{"lp", ",", "ld"}], "}"}], "]"}], "[", 
              "\"\<\!\(\*SubscriptBox[\(N\), \(det\)]\)\>\"", "]"}]}], 
            "}"}]}], "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "MNlist"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GetAcceptance", "[", 
   RowBox[{"lp_", ",", "ld_", ",", "meson_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tmpMassList", ",", "MNlist", ",", "i"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"meson", "\[Equal]", "\"\<D\>\""}], ",", 
       RowBox[{"tmpMassList", "=", "MassListD"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"meson", "\[Equal]", "\"\<B\>\""}], ",", 
         RowBox[{"tmpMassList", "=", "MassListB"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"tmpMassList", "=", "MassListBc"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"MNlist", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", 
        RowBox[{"Length", "[", "tmpMassList", "]"}]}], ",", 
       RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{
           RowBox[{"Keys", "[", 
            RowBox[{"tmpMassList", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"lp", ",", "ld"}], "}"}]}], "]"}], ",", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"MNlist", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"tmpMassList", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              "\"\<\!\(\*SubscriptBox[\(M\), \(N\)]\)\>\"", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"tmpMassList", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"{", 
                 RowBox[{"lp", ",", "ld"}], "}"}], "]"}], "[", 
               "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(dec\)]\)\>\"", "]"}], 
              RowBox[{
               RowBox[{
                RowBox[{"tmpMassList", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"{", 
                 RowBox[{"lp", ",", "ld"}], "}"}], "]"}], "[", 
               "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(det\)]\)\>\"", 
               "]"}]}]}], "}"}]}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
      "]"}], ";", "\[IndentingNewLine]", "MNlist"}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GetMatrix", "[", "element_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", "j", ",", "key"}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"key", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Llist", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"Llist", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "}"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Keys", "[", "element", "]"}], ",", "key"}], "]"}], ",", 
            RowBox[{
             RowBox[{"element", "[", "key", "]"}], "[", 
             "\"\<\!\(\*SubscriptBox[\(N\), \(det\)]\)\>\"", "]"}], ",", 
            "0"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "3"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Downloading", " ", "raw", " ", "data", " ", "and", " ", "organizing", " ",
     "into", " ", "3", " ", "MassLists"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rawdata", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<results.dat\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MassListD", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MassListB", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MassListBc", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", ",", "tmpmass", ",", "couplings", ",", "meson"}], "}"}], ",", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", " ", 
      RowBox[{"Length", "[", "rawdata", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"NumberQ", "[", 
          RowBox[{"rawdata", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}]}], ",", 
        RowBox[{"Continue", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"tmpmass", "=", 
       RowBox[{"rawdata", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"couplings", "=", 
       RowBox[{"rawdata", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"2", ";;", "7"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"meson", "=", 
       RowBox[{"rawdata", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", 
          RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", 
          RowBox[{"rawdata", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[Equal]", "12"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AddPoint", "[", 
          RowBox[{"tmpmass", ",", "couplings", ",", 
           RowBox[{"<|", 
            RowBox[{
             RowBox[{"\"\<fh\[Times]Br\>\"", "\[Rule]", " ", 
              RowBox[{
               SuperscriptBox["10", "9"], 
               RowBox[{"rawdata", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "8"}], "]"}], "]"}]}]}], ",", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(\[Gamma]\), \(N\)]\)\>\"", "\[Rule]", 
              "0"}], ",", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(P\), \(dec\)]\)\>\"", "\[Rule]", " ", 
              "0"}], ",", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(dec\)]\)\>\"", 
              "\[Rule]", " ", "0"}], ",", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(det\)]\)\>\"", 
              "\[Rule]", "0"}], ",", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(N\), \(det\)]\)\>\"", "\[Rule]", 
              "0"}]}], "|>"}], ",", "meson"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Continue", "[", "]"}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AddPoint", "[", 
       RowBox[{"tmpmass", ",", "couplings", ",", 
        RowBox[{"<|", 
         RowBox[{
          RowBox[{"\"\<fh\[Times]Br\>\"", "\[Rule]", " ", 
           RowBox[{
            SuperscriptBox["10", "9"], 
            RowBox[{"rawdata", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "8"}], "]"}], "]"}]}]}], ",", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(\[Gamma]\), \(N\)]\)\>\"", "\[Rule]", " ", 
           RowBox[{"rawdata", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "9"}], "]"}], "]"}]}], ",", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(P\), \(dec\)]\)\>\"", "\[Rule]", " ", 
           RowBox[{
            SuperscriptBox["10", "9"], 
            RowBox[{"rawdata", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "10"}], "]"}], "]"}]}]}], ",", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(dec\)]\)\>\"", "\[Rule]", 
           " ", 
           RowBox[{"rawdata", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "11"}], "]"}], "]"}]}], ",", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(\[Epsilon]\), \(det\)]\)\>\"", "\[Rule]", 
           " ", 
           RowBox[{"rawdata", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "12"}], "]"}], "]"}]}], ",", 
          RowBox[{
          "\"\<\!\(\*SubscriptBox[\(N\), \(det\)]\)\>\"", "\[Rule]", " ", 
           RowBox[{
            SuperscriptBox["10", "18"], 
            RowBox[{"rawdata", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "13"}], "]"}], "]"}]}]}]}], "|>"}], ",", 
        "meson"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MassListD", "=", 
   RowBox[{"SortBy", "[", 
    RowBox[{"MassListD", ",", 
     RowBox[{
      RowBox[{"#", "[", "\"\<\!\(\*SubscriptBox[\(M\), \(N\)]\)\>\"", "]"}], 
      "&"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MassListB", "=", 
   RowBox[{"SortBy", "[", 
    RowBox[{"MassListB", ",", 
     RowBox[{
      RowBox[{"#", "[", "\"\<\!\(\*SubscriptBox[\(M\), \(N\)]\)\>\"", "]"}], 
      "&"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MassListBc", "=", 
   RowBox[{"SortBy", "[", 
    RowBox[{"MassListBc", ",", 
     RowBox[{
      RowBox[{"#", "[", "\"\<\!\(\*SubscriptBox[\(M\), \(N\)]\)\>\"", "]"}], 
      "&"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{3.745835768199342*^9},
 ExpressionUUID -> "2bf66d7e-a1f9-4240-837c-b7e147c1398d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["II. Constructing production vector", "Section",
 CellChangeTimes->{{3.741781017876628*^9, 3.7417810242760124`*^9}, {
  3.7417811072165613`*^9, 
  3.741781107605522*^9}},ExpressionUUID->"70b863bb-d915-4c5b-918d-\
32571b0f1a05"],

Cell[CellGroupData[{

Cell["1. Decay acceptance fit", "Subsection",
 CellChangeTimes->{{3.74178103468644*^9, 3.7417810455172987`*^9}},
 ExpressionUUID -> "4abc2155-022e-46ed-9b47-249f055b4bed"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Acceptanceee", "[", "list_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
       RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Acceptance\[Mu]\[Mu]", "[", "list_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], "[", 
       RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Acceptance\[Tau]\[Tau]", "[", "list_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}], "[", 
       RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceFittedeD", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptanceee", "[", "MassListD", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "1.57"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "<", "1.57"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptanceee", "[", "MassListD", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", "2"}], " ", "&&",
                " ", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "1.57"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "1.57"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceFittedeB", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptanceee", "[", "MassListB", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "3.12"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"0", "\[LessEqual]", "M", "<", "3.12"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptanceee", "[", "MassListB", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "3.12"}], "&&", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", "5.3"}]}], 
              "&"}]}], "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "3.12"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceFittedeBc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptanceee", "[", "MassListBc", "]"}], ",", " ", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<", "4.58"}], "&&", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "1.5"}]}],
               "&"}]}], "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"1.5", "<", "M", "<", "4.58"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptanceee", "[", "MassListBc", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "4.58"}], 
               "&&", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", "6.3"}]}], 
              "&"}]}], "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "4.58"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceFitted\[Mu]D", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Mu]\[Mu]", "[", "MassListD", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "1.88"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "<", "1.88"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Mu]\[Mu]", "[", "MassListD", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", "2"}], " ", "&&",
                " ", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "1.88"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "1.88"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceFitted\[Mu]B", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"M", "\[LessEqual]", "1.5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Mu]\[Mu]", "[", "MassListB", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "3.06"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"1.5", "\[LessEqual]", "M", "<", "3.06"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Mu]\[Mu]", "[", "MassListB", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "3.06"}], "&&", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<", "5.2"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "3.06"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceFitted\[Mu]Bc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"M", "\[LessEqual]", "1.5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Mu]\[Mu]", "[", "MassListBc", "]"}], ",", 
             " ", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "3.8"}], "&"}]}], "]"}], 
           ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"1.5", "\[LessEqual]", "M", "<", "3.8"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Mu]\[Mu]", "[", "MassListBc", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "3.8"}], "&&", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<", "6.2"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "3.8"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceFitted\[Tau]D", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"M", "<", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Tau]\[Tau]", "[", "MassListD", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "1.63"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"0", "\[LessEqual]", " ", "M", "\[LessEqual]", "1.63"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"M", ">", "1.63"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceFitted\[Tau]B", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"M", "<", "1.5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Tau]\[Tau]", "[", "MassListB", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "1.72"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"1.5", "\[LessEqual]", "M", "<", "1.72"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Tau]\[Tau]", "[", "MassListB", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "1.72"}], "&&", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<", "3.59"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "1.72"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceFitted\[Tau]Bc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"M", "<", "1.5"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"Acceptance\[Tau]\[Tau]", "[", "MassListBc", "]"}], ",", 
             " ", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "4.55"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"1.5", "\[LessEqual]", "M", "<", "4.55"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7458358181258163`*^9, 3.745835832993723*^9}, 
   3.74583586548944*^9},
 ExpressionUUID -> "690fabd3-aa40-4663-bfe5-0168d652358a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Production vector", "Subsection",
 CellChangeTimes->{{3.7417810549956756`*^9, 
  3.741781057656053*^9}},ExpressionUUID->"2d9bebc1-a3da-4221-837c-\
51c453658a42"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NumberOfMesons", "[", "list_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"list", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"{", 
      RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
    RowBox[{"[", "6", "]"}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
      RowBox[{"[", "4", "]"}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
      RowBox[{"[", "5", "]"}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
      RowBox[{"[", "3", "]"}], "]"}]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductionVectorTemp", "[", "list_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"NumberOfMesons", "[", "list", "]"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"list", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"{", 
           RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"NumberOfMesons", "[", "list", "]"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"list", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"{", 
           RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"NumberOfMesons", "[", "list", "]"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"list", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "[", 
          RowBox[{"{", 
           RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}], 
         "[", 
         RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Interpolation", " ", "for", " ", "production", " ", "from", " ", 
    "electron"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionDInterpolationeTemp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListD", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListD", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "MassListD", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionBInterpolationeTemp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListB", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListB", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "MassListB", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionBcInterpolationeTemp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListBc", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListBc", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "MassListBc", "]"}]}], "}"}]}], "]"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductionDInterpolatione", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ProductionDInterpolationeTemp", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "1.96"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ProductionBInterpolatione", "[", "M_", "]"}], "=", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ProductionBInterpolationeTemp", "[", "M", "]"}], ",", 
         RowBox[{"M", "<", "5.2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"The", " ", "factor", " ", 
      FractionBox["2.6", "2"], " ", "takes", " ", "into", " ", "account", " ",
       "that", " ", "in", " ", "initial", " ", "data", " ", "there", " ", 
      "was", " ", "taken", " ", 
      SubscriptBox["f", 
       RowBox[{"b", "\[Rule]", 
        SubscriptBox["B", "c"]}]]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"2", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "3"}]], " ", "instead", " ", "of", " ", 
       RowBox[{"LHC", "'"}], "s", " ", 
       SubscriptBox["f", 
        RowBox[{"b", "\[Rule]", 
         SubscriptBox["B", "c"]}]]}], " ", "=", " ", 
      RowBox[{"2.6", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "3"}]]}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "while", " ", "the", " ", "results", " ", "are", " ", "stated", " ", 
      "to", " ", "be", " ", "for", " ", 
      SubscriptBox["f", 
       RowBox[{"b", "\[Rule]", 
        SubscriptBox["B", "c"]}]]}], " ", "=", " ", 
     RowBox[{"2.6", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "3"}]]}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ProductionBcInterpolatione", "[", "M_", "]"}], "=", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          FractionBox["2.6", "2"], "*", 
          RowBox[{"ProductionBcInterpolationeTemp", "[", "M", "]"}]}], ",", 
         RowBox[{"M", "<", "6.19"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Interpolation", " ", "for", " ", "production", " ", "from", " ", "muon"}],
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionDInterpolation\[Mu]Temp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListD", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListD", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "MassListD", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionBInterpolation\[Mu]Temp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListB", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListB", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "MassListB", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionBcInterpolation\[Mu]Temp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListBc", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListBc", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "MassListBc", "]"}]}], "}"}]}], "]"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductionDInterpolation\[Mu]", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ProductionDInterpolation\[Mu]Temp", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "1.87"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductionBInterpolation\[Mu]", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ProductionBInterpolation\[Mu]Temp", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "5.14"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ProductionBcInterpolation\[Mu]", "[", "M_", "]"}], "=", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          FractionBox["2.6", "2"], "*", 
          RowBox[{"ProductionBcInterpolation\[Mu]Temp", "[", "M", "]"}]}], 
         ",", 
         RowBox[{"M", "<", "6.15"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Interpolation", " ", "for", " ", "production", " ", "from", " ", "tau"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionDInterpolation\[Tau]Temp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListD", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListD", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "MassListD", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionBInterpolation\[Tau]Temp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListB", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListB", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "MassListB", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ProductionBcInterpolation\[Tau]Temp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListBc", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductionVectorTemp", "[", "MassListBc", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "MassListBc", "]"}]}], "}"}]}], "]"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductionDInterpolation\[Tau]", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ProductionDInterpolation\[Tau]Temp", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "1.64"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductionBInterpolation\[Tau]", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ProductionBInterpolation\[Tau]Temp", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "3.52"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ProductionBcInterpolation\[Tau]", "[", "M_", "]"}], "=", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          FractionBox["2.6", "2"], "*", 
          RowBox[{"ProductionBcInterpolation\[Tau]Temp", "[", "M", "]"}]}], 
         ",", 
         RowBox[{"M", "<", "4.55"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Generating", " ", "table", " ", "output"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductioneWithBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductionDInterpolatione", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFittedeD", "[", "M", "]"}]}], "+", 
    RowBox[{
     RowBox[{"ProductionBInterpolatione", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFittedeB", "[", "M", "]"}]}], "+", 
    RowBox[{
     RowBox[{"ProductionBcInterpolatione", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFittedeBc", "[", "M", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductioneWithoutBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductionDInterpolatione", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFittedeD", "[", "M", "]"}]}], "+", 
    RowBox[{
     RowBox[{"ProductionBInterpolatione", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFittedeB", "[", "M", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Production\[Mu]WithBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductionDInterpolation\[Mu]", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFitted\[Mu]D", "[", "M", "]"}]}], "+", 
    RowBox[{
     RowBox[{"ProductionBInterpolation\[Mu]", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFitted\[Mu]B", "[", "M", "]"}]}], "+", 
    RowBox[{
     RowBox[{"ProductionBcInterpolation\[Mu]", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFitted\[Mu]Bc", "[", "M", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Production\[Mu]WithoutBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductionDInterpolation\[Mu]", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFitted\[Mu]D", "[", "M", "]"}]}], "+", 
    RowBox[{
     RowBox[{"ProductionBInterpolation\[Mu]", "[", "M", "]"}], "*", 
     RowBox[{"AcceptanceFitted\[Mu]B", "[", "M", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Production\[Tau]WithBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductionDInterpolation\[Tau]", "[", "M", "]"}], 
     RowBox[{"AcceptanceFitted\[Tau]D", "[", "M", "]"}]}], "+", 
    RowBox[{
     RowBox[{"ProductionBInterpolation\[Tau]", "[", "M", "]"}], 
     RowBox[{"AcceptanceFitted\[Tau]B", "[", "M", "]"}]}], "+", 
    RowBox[{
     RowBox[{"ProductionBcInterpolation\[Tau]", "[", "M", "]"}], 
     RowBox[{"AcceptanceFitted\[Tau]Bc", "[", "M", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Production\[Tau]WithoutBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductionDInterpolation\[Tau]", "[", "M", "]"}], 
     RowBox[{"AcceptanceFitted\[Tau]D", "[", "M", "]"}]}], "+", 
    RowBox[{
     RowBox[{"ProductionBInterpolation\[Tau]", "[", "M", "]"}], 
     RowBox[{"AcceptanceFitted\[Tau]B", "[", "M", "]"}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7458358604284687`*^9, 3.745835861478401*^9}, {
  3.745835891800686*^9, 3.745835912281458*^9}, {3.745836053193163*^9, 
  3.745836066096569*^9}},
 ExpressionUUID -> "946312ca-9379-4abd-8fbc-b1facae276b6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["III. Constructing decay vector", "Section",
 CellChangeTimes->{{3.741781100207096*^9, 3.741781104776724*^9}, {
  3.7417811350541024`*^9, 
  3.741781135614431*^9}},ExpressionUUID->"edcb9368-b9da-4fe7-9946-\
d38d18f4e24d"],

Cell[CellGroupData[{

Cell["1. Average \[Gamma]-factor", "Subsection",ExpressionUUID->"bb5f3b2e-d8cc-4952-aff8-f0f768577151"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"gammaeWithBcTable", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListD", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListD", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "1.96"}], "&"}]}], "]"}], ",", 
     
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListB", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListB", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "1.96"}], " ", "&&",
          " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "3.4"}]}], "&"}]}], "]"}], 
     ",", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListBc", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListBc", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "3.4"}], "&&", 
         " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "6.2"}]}], "&"}]}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gammaeWithoutBcTable", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"MassListD", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"{", 
               RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "MassListD", "]"}], ",", "1"}], "}"}]}], 
         "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "1.96"}], "&"}]}], "]"}], ",", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"MassListB", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"{", 
               RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "MassListB", "]"}], ",", "1"}], "}"}]}], 
         "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "1.96"}], " ", 
          "&&", " ", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "5.2"}]}], "&"}]}], "]"}]}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma\[Mu]WithBcTable", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListD", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], 
            "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListD", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "1.86"}], "&"}]}], "]"}], ",", 
     
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListB", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], 
            "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListB", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "1.86"}], " ", "&&",
          " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "3.3"}]}], "&"}]}], "]"}], 
     ",", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListBc", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], 
            "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListBc", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "3.3"}], " ", "&&",
          " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "6.2"}]}], "&"}]}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gamma\[Mu]WithoutBcTable", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"MassListD", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"{", 
               RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], 
             "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "MassListD", "]"}], ",", "1"}], "}"}]}], 
         "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "1.86"}], "&"}]}], "]"}], ",", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"MassListB", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"{", 
               RowBox[{"\"\<\[Mu]\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], 
             "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "MassListB", "]"}], ",", "1"}], "}"}]}], 
         "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "1.86"}], " ", 
          "&&", " ", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "5.1"}]}], "&"}]}], "]"}]}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma\[Tau]WithBcTable", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListD", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}],
             "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListD", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "1.6"}], "&"}]}], "]"}], ",", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListB", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}],
             "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListB", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "1.6"}], " ", "&&",
          " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2.1"}]}], "&"}]}], "]"}], 
     ",", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListBc", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}],
             "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListBc", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "2.1"}], " ", "&&",
          " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "4.5"}]}], "&"}]}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gamma\[Tau]WithoutBcTable", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListD", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}],
             "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListD", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "1.6"}], "&"}]}], "]"}], ",", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListB", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}],
             "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListB", "]"}], ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "1.6"}], " ", "&&",
          " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "3.6"}]}], "&"}]}], "]"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gammaeWithBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"gammaeWithBcTable", ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gammaeWithoutBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"gammaeWithoutBcTable", ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gamma\[Mu]WithBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"gamma\[Mu]WithBcTable", ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gamma\[Mu]WithoutBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"gamma\[Mu]WithoutBcTable", ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gamma\[Tau]WithBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"gamma\[Tau]WithBcTable", ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gamma\[Tau]WithoutBc", "[", "M_", "]"}], "=", 
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"gamma\[Tau]WithoutBcTable", ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
    "]"}]}], ";"}]}], "Input",
 ExpressionUUID -> "3c7c5475-293f-4c4f-bcde-0eaf434bd0a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Detection acceptance fit", "Subsection",ExpressionUUID->"49acd2d3-9be1-4d06-b8cf-405751e5b271"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"AcceptanceDetectionee", "[", "list_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
       RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AcceptanceDetection\[Mu]\[Mu]", "[", "list_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"\"\<e\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], "[", 
       RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetection\[Tau]\[Tau]", "[", "list_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"list", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"{", 
          RowBox[{"\"\<e\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}], "[", 
        RowBox[{"[", "5", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "list", "]"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Fitted", " ", "acceptance", " ", "for", " ", "decays", " ", "through", 
    " ", "e", " ", "channel"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetectionFittedeD", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"AcceptanceDetectionee", "[", "MassListD", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "1.57"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "<", "1.57"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"AcceptanceDetectionee", "[", "MassListD", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", "2"}], " ", "&&",
                " ", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "1.57"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "1.57"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetectionFittedeB", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"AcceptanceDetectionee", "[", "MassListB", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "3.12"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "<", "3.12"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"AcceptanceDetectionee", "[", "MassListB", "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "3.12"}], "&&", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", "5.3"}]}], 
              "&"}]}], "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "3.12"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AcceptanceDetectionFittedeBc", "[", "M_", "]"}], "=", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Normal", "@", 
          RowBox[{"NonlinearModelFit", "[", 
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"AcceptanceDetectionee", "[", "MassListBc", "]"}], ",", 
              " ", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<", "4.58"}], "&"}]}], 
             "]"}], ",", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "M"}], "+", 
             RowBox[{"c", "*", 
              SuperscriptBox["M", "0.5"]}]}], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
         ",", 
         RowBox[{"M", "<", "4.58"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Normal", "@", 
          RowBox[{"NonlinearModelFit", "[", 
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"AcceptanceDetectionee", "[", "MassListBc", "]"}], ",", 
              
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "4.58"}],
                 "&&", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", "6.3"}]}], 
               "&"}]}], "]"}], ",", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "M"}], "+", 
             RowBox[{"c", "*", 
              SuperscriptBox["M", "0.5"]}]}], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
         ",", 
         RowBox[{"M", "\[GreaterEqual]", "4.58"}]}], "}"}]}], "}"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Fitted", " ", "acceptance", " ", "for", " ", "decays", " ", "through", 
    " ", "\[Mu]", " ", "channel"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetectionFitted\[Mu]D", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"AcceptanceDetection\[Mu]\[Mu]", "[", "MassListD", "]"}],
              ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "1.88"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "<", "1.88"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"AcceptanceDetection\[Mu]\[Mu]", "[", "MassListD", "]"}],
              ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", "2"}], " ", "&&",
                " ", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "1.88"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "1.88"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetectionFitted\[Mu]B", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"AcceptanceDetection\[Mu]\[Mu]", "[", "MassListB", "]"}],
              ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "<", "3.06"}], "&"}]}], "]"}],
            ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "<", "3.06"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{"AcceptanceDetection\[Mu]\[Mu]", "[", "MassListB", "]"}],
              ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "3.06"}], "&&", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<", "5.2"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "\[GreaterEqual]", "3.06"}]}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"AcceptanceDetectionFitted\[Mu]Bc", "[", "M_", "]"}], "=", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Normal", "@", 
          RowBox[{"NonlinearModelFit", "[", 
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{
              "AcceptanceDetection\[Mu]\[Mu]", "[", "MassListBc", "]"}], ",", 
              " ", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<", "3.8"}], "&"}]}], "]"}],
             ",", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "M"}], "+", 
             RowBox[{"c", "*", 
              SuperscriptBox["M", "0.5"]}]}], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
         ",", 
         RowBox[{"M", "<", "3.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Normal", "@", 
          RowBox[{"NonlinearModelFit", "[", 
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{
              "AcceptanceDetection\[Mu]\[Mu]", "[", "MassListBc", "]"}], ",", 
              
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "\[GreaterEqual]", "3.8"}], 
                "&&", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "<", "6.2"}]}], "&"}]}], 
             "]"}], ",", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "M"}], "+", 
             RowBox[{"c", "*", 
              SuperscriptBox["M", "0.5"]}]}], ",", 
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
         ",", 
         RowBox[{"M", "\[GreaterEqual]", "3.8"}]}], "}"}]}], "}"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Fitted", " ", "acceptance", " ", "for", " ", "decays", " ", "through", 
    " ", "\[Tau]", " ", "channel"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetectionFitted\[Tau]D", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"M", "<", "0.03"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{
             "AcceptanceDetection\[Tau]\[Tau]", "[", "MassListD", "]"}], ",", 
             
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "0.17"}], 
              "&"}]}], "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"0.03", "<", "M", "\[LessEqual]", "0.17"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{
             "AcceptanceDetection\[Tau]\[Tau]", "[", "MassListD", "]"}], ",", 
             
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "0.17"}], "&&", " ", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<", "1.63"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"0.17", "<", "M", "\[LessEqual]", "1.51"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{"Select", "[", 
            RowBox[{
             RowBox[{
             "AcceptanceDetection\[Tau]\[Tau]", "[", "MassListD", "]"}], ",", 
             
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ">", "0.51"}], "&&", " ", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "<", "1.95"}]}], "&"}]}], 
            "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"1.51", "<", "M", "\[LessEqual]", "1.95"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetectionFitted\[Tau]B", "[", "M_", "]"}], "=", 
   RowBox[{"Normal", "@", 
    RowBox[{"NonlinearModelFit", "[", 
     RowBox[{
      RowBox[{"AcceptanceDetection\[Tau]\[Tau]", "[", "MassListB", "]"}], ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "M"}], "+", 
       RowBox[{"c", "*", 
        SuperscriptBox["M", "0.5"]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetectionFitted\[Tau]Bc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Normal", "@", 
         RowBox[{"NonlinearModelFit", "[", 
          RowBox[{
           RowBox[{
           "AcceptanceDetection\[Tau]\[Tau]", "[", "MassListBc", "]"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "M"}], "+", 
            RowBox[{"c", "*", 
             SuperscriptBox["M", "0.5"]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "M"}], "]"}]}], 
        ",", 
        RowBox[{"M", "<", "6.2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AcceptanceDetectionFittedeD", "[", "M", "]"}], ",", 
       RowBox[{"M", "<", "1.95"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AcceptanceDetectionFittedeB", "[", "M", "]"}], ",", 
       RowBox[{"1.95", "\[LessEqual]", "M", "<", "3.4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AcceptanceDetectionFittedeBc", "[", "M", "]"}], ",", 
       RowBox[{"3.4", "\[LessEqual]", "M", "<", "6.2"}]}], "}"}]}], "}"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetectioneWithBc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFittedeD", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "1.95"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFittedeB", "[", "M", "]"}], ",", 
        RowBox[{"1.95", "\[LessEqual]", "M", "<", "3.4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFittedeBc", "[", "M", "]"}], ",", 
        RowBox[{"3.4", "\[LessEqual]", "M", "<", "6.2"}]}], "}"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetection\[Mu]WithBc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Mu]D", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "1.85"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Mu]B", "[", "M", "]"}], ",", 
        RowBox[{"1.85", "\[LessEqual]", "M", "<", "3.3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Mu]Bc", "[", "M", "]"}], ",", 
        RowBox[{"3.3", "\[LessEqual]", " ", "M", "<", "6.2"}]}], "}"}]}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetection\[Tau]WithBc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Tau]D", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "1.63"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Tau]B", "[", "M", "]"}], ",", 
        RowBox[{"1.63", "\[LessEqual]", "M", "<", "2.64"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Tau]Bc", "[", "M", "]"}], ",", 
        RowBox[{"2.64", "\[LessEqual]", " ", "M", "<", "6.2"}]}], "}"}]}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetectioneWithoutBc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFittedeD", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "1.95"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFittedeB", "[", "M", "]"}], ",", 
        RowBox[{"1.95", "\[LessEqual]", "M", "\[LessEqual]", "5.2"}]}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetection\[Mu]WithoutBc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Mu]D", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "1.85"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Mu]B", "[", "M", "]"}], ",", 
        RowBox[{"1.85", "\[LessEqual]", " ", "M", "\[LessEqual]", "5.2"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AcceptanceDetection\[Tau]WithoutBc", "[", "M_", "]"}], "=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Tau]D", "[", "M", "]"}], ",", 
        RowBox[{"M", "<", "1.63"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"AcceptanceDetectionFitted\[Tau]B", "[", "M", "]"}], ",", 
        RowBox[{"1.63", "\[LessEqual]", "M", "\[LessEqual]", "5.2"}]}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "True"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AcceptanceDetectionTable", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"M", ",", 
       RowBox[{"AcceptanceDetectioneWithBc", "[", "M", "]"}], ",", 
       RowBox[{"AcceptanceDetectioneWithoutBc", "[", "M", "]"}], ",", 
       RowBox[{"AcceptanceDetection\[Mu]WithBc", "[", "M", "]"}], ",", 
       RowBox[{"AcceptanceDetection\[Mu]WithoutBc", "[", "M", "]"}], ",", 
       RowBox[{"AcceptanceDetection\[Tau]WithBc", "[", "M", "]"}], ",", 
       RowBox[{"AcceptanceDetection\[Tau]WithoutBc", "[", "M", "]"}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"M", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "2"}]], ",", "6.3", ",", "0.05"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwd0VtIUwEAxvE1bado05ccZEZrVBLZ7Ij6cKKLggu0QEWH0Zq4iuyp0PLC
DkUWmRUTIuwylAQxkOmmWMEeRGQ2DbtNKWlWmrBqRlkGtQ2l8+/h4/f2vfy3
2M+UnlSrVKp0ZXhOU/fUPbuQN3G8JoQZnuBH1GfvWsAXlUu/cKd+Mo7fpAfq
XsXyDQ4NSpEpAwajv40op4Z34NXNYREtwdqiPsU97ueHUVsYKMPupQsVWG9q
sGJuTbUNLZosP54fnA9gokn3Ehc1VSHsak1aRL1si+JQy9QyPtqWkuBRdHVK
XvR9b+rHo67VbzFDmzqDwZS+Ua9im/bZBArrVz5jVpr4B4fyBuJoWScv4/T0
wYR+xZ5qScD2nxEdGvLNeny39uxGjInjIupq7+Wg81ijhK/crQdwViwz49Zu
oRjvtnwqx9KKN1ZsPjR4Arsmfafx5vU0Bxbvu3YDbY5cJ26yltzGK/65Ntzr
z0x6rBj96knGH9mJjveKR4q8Mt43jDVhOBS6jNKT3mZU1792ot1vvIPJdvm/
f2+VuHDNqZEONBcIPjSudEZwvGA4hg3C7jiOZO43faBToEfEWP7MxfYvys/D
VZewsKpjDtMbt8/jP4ZRcLg=
  "],
 ExpressionUUID -> "c10b6c9b-fe03-4c30-bdfe-97ce14c95ad3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Decay vector  ", "Subsection",ExpressionUUID->"70de2235-bcdf-480b-a2b4-759ae5136fb0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"The", " ", "vector", " ", "of", " ", "values", " ", 
      RowBox[{
       FractionBox[
        SubscriptBox["l", 
         RowBox[{"to", " ", "detector"}]], 
        RowBox[{
         SubscriptBox["l", 
          RowBox[{"decay", ",", "i"}]], 
         SubscriptBox["|", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             SubscriptBox["U", "i"], "2"], "=", "1"}], ",", 
           RowBox[{
            SubscriptBox["U", 
             RowBox[{"j", "\[NotEqual]", "i"}]], "=", "0"}]}]]}]], ".", " ", 
       "Since"}], " ", "Ldet"}], " ", "=", " ", "Ltd"}], ",", " ", 
    RowBox[{"they", " ", "are", " ", "chosen", " ", "as", " ", 
     SubscriptBox["P", "decay"], " ", "for", " ", "ee"}], ",", " ", 
    RowBox[{"e\[Mu]", " ", 
     RowBox[{"(", "\[Mu]\[Mu]", ")"}]}], ",", " ", 
    RowBox[{"e\[Tau]", " ", 
     RowBox[{"(", "\[Tau]\[Tau]", ")"}], " ", "data", " ", "from", " ", 
     "FairSHiP", " ", "list"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"DecayVectoreDTemp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListD", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListD", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "1.97"}], "&"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVectoreBTemp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListB", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListB", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", "1.97"}], "&"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVectoreB\:0441Temp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListBc", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<e\>\""}], "}"}], "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListBc", "]"}]}], "}"}]}], "]"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", "1.97"}], "&"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Mu]DTemp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListD", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], "[", 
            
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListD", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "1.87"}], "&"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Mu]BTemp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListB", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], "[", 
            
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListB", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", "1.87"}], "&"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Mu]B\:0441Temp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListBc", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<\[Mu]\>\""}], "}"}], "]"}], "[", 
            
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListBc", "]"}]}], "}"}]}], "]"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", "1.87"}], "&"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]DeTemp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListD", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListD", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "1.63"}], "&"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]BeTemp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListB", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListB", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", "1.63"}], "&"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]B\:0441eTemp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListBc", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<e\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListBc", "]"}]}], "}"}]}], "]"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ">", "1.63"}], "&"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]D\[Tau]Temp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListD", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListD", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}],
             "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListD", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "1.63"}], "&"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]B\[Tau]Temp", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListB", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListB", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}],
             "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListB", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ">", "1.63"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "3.6`"}]}], "&"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]B\:0441\[Tau]Temp0", "=", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"MassListBc", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"MassListBc", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"\"\<\[Tau]\>\"", ",", "\"\<\[Tau]\>\""}], "}"}], "]"}],
             "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "MassListBc", "]"}]}], "}"}]}], "]"}], ",", 
       
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ">", "1.63"}], "&&", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "4.56827758299`"}]}], "&"}]}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]B\:0441\[Tau]Temp", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"DecayVector\[Tau]B\:0441\[Tau]Temp0", ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"4.52", ",", " ", 
          RowBox[{"5.32", "*", 
           SuperscriptBox["10", "6"]}]}], "}"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVectoreWithBcTable", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"DecayVectoreDTemp", ",", 
       RowBox[{"Select", "[", 
        RowBox[{"DecayVectoreBTemp", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "3.4"}], "&"}]}], 
        "]"}], ",", 
       RowBox[{"Select", "[", 
        RowBox[{"DecayVectoreB\:0441Temp", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ">", "3.4"}], "&"}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVectoreWithoutBcTable", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"DecayVectoreDTemp", ",", "DecayVectoreBTemp"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Mu]WithBcTable", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"DecayVector\[Mu]DTemp", ",", 
       RowBox[{"Select", "[", 
        RowBox[{"DecayVector\[Mu]BTemp", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "3.4"}], "&"}]}], 
        "]"}], ",", 
       RowBox[{"Select", "[", 
        RowBox[{"DecayVector\[Mu]B\:0441Temp", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ">", "3.4"}], "&"}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Mu]WithoutBcTable", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"DecayVector\[Mu]DTemp", ",", "DecayVector\[Mu]BTemp"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]WithBceTable", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"DecayVector\[Tau]DeTemp", ",", 
       RowBox[{"Select", "[", 
        RowBox[{"DecayVector\[Tau]BeTemp", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "2.64"}], "&"}]}],
         "]"}], ",", 
       RowBox[{"Select", "[", 
        RowBox[{"DecayVector\[Tau]B\:0441eTemp", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ">", "2.64"}], "&"}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]WithoutBceTable", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"DecayVector\[Tau]DeTemp", ",", "DecayVector\[Tau]BeTemp"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]WithBc\[Tau]Table", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"DecayVector\[Tau]D\[Tau]Temp", ",", 
       RowBox[{"Select", "[", 
        RowBox[{"DecayVector\[Tau]B\[Tau]Temp", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "2.64"}], "&"}]}],
         "]"}], ",", 
       RowBox[{"Select", "[", 
        RowBox[{"DecayVector\[Tau]B\:0441\[Tau]Temp", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ">", "2.64"}], "&"}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DecayVector\[Tau]WithoutBc\[Tau]Table", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
      "DecayVector\[Tau]D\[Tau]Temp", ",", "DecayVector\[Tau]B\[Tau]Temp"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVectoreWithBcTemp", "[", "M_", "]"}], "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Log", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "DecayVectoreWithBcTable"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVectoreWithBc", "[", "M_", "]"}], "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"M", "<", "6.14"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"DecayVectoreWithBcTemp", "[", "M", "]"}], "]"}], ",", "0"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVectoreWithoutBcTemp", "[", "M_", "]"}], "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Log", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "DecayVectoreWithoutBcTable"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVectoreWithoutBc", "[", "M_", "]"}], "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"M", "<", "5.14"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"DecayVectoreWithoutBcTemp", "[", "M", "]"}], "]"}], ",", 
       "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Mu]WithBcTemp", "[", "M_", "]"}], "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Log", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "DecayVector\[Mu]WithBcTable"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Mu]WithBc", "[", "M_", "]"}], "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"M", "<", "6.14"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"DecayVector\[Mu]WithBcTemp", "[", "M", "]"}], "]"}], ",", 
       "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Mu]WithoutBcTemp", "[", "M_", "]"}], "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Log", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "DecayVector\[Mu]WithoutBcTable"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Mu]WithoutBc", "[", "M_", "]"}], "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"M", "<", "5.1"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"DecayVector\[Mu]WithoutBcTemp", "[", "M", "]"}], "]"}], ",", 
       "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Tau]WithBceTemp", "[", "M_", "]"}], "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Log", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "DecayVector\[Tau]WithBceTable"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Tau]WithBce", "[", "M_", "]"}], "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"M", "<", "6.14"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"DecayVector\[Tau]WithBceTemp", "[", "M", "]"}], "]"}], ",", 
       "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Tau]WithoutBceTemp", "[", "M_", "]"}], "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Log", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "DecayVector\[Tau]WithoutBceTable"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Tau]WithoutBce", "[", "M_", "]"}], "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"M", "<", "6.14"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"DecayVector\[Tau]WithoutBceTemp", "[", "M", "]"}], "]"}], 
       ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Tau]WithBc\[Tau]Temp", "[", "M_", "]"}], "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Log", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "DecayVector\[Tau]WithBc\[Tau]Table"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Tau]WithBc\[Tau]", "[", "M_", "]"}], "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"M", "<", "4.54"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"DecayVector\[Tau]WithBc\[Tau]Temp", "[", "M", "]"}], "]"}], 
       ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Tau]WithoutBc\[Tau]Temp", "[", "M_", "]"}], "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Log", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "DecayVector\[Tau]WithoutBc\[Tau]Table"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "M", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DecayVector\[Tau]WithoutBc\[Tau]", "[", "M_", "]"}], "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"M", "<", "3.51"}], ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"DecayVector\[Tau]WithoutBc\[Tau]Temp", "[", "M", "]"}], 
        "]"}], ",", "0"}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7416841103442736`*^9, 3.74168414448404*^9}, {
   3.7416841845234118`*^9, 3.7416843638678503`*^9}, {3.7416844671191187`*^9, 
   3.7416844708591747`*^9}, {3.7416846011671534`*^9, 
   3.7416846769344807`*^9}, {3.7416847368848515`*^9, 
   3.7416848912851315`*^9}, {3.7416852094744177`*^9, 3.741685290536069*^9}, {
   3.7416853357788663`*^9, 3.7416853545479183`*^9}, {3.7416854134461327`*^9, 
   3.741685724120129*^9}, {3.741685758318688*^9, 3.741685764543299*^9}, {
   3.7416863151863017`*^9, 3.7416863771111994`*^9}, {3.7416888470316105`*^9, 
   3.7416888474026184`*^9}, {3.7416888984989214`*^9, 
   3.7416889993416886`*^9}, {3.741689069069168*^9, 3.7416892930207787`*^9}, {
   3.741689344238509*^9, 3.741689368063743*^9}, {3.741689398524678*^9, 
   3.7416896131975594`*^9}, {3.741689649349674*^9, 3.7416897523817244`*^9}, {
   3.741689864574922*^9, 3.741689871265916*^9}, {3.7416899408840837`*^9, 
   3.7416899907923136`*^9}, {3.741690073252065*^9, 3.7416901108243437`*^9}, {
   3.741690261489277*^9, 3.7416903137673345`*^9}, {3.7416903463697453`*^9, 
   3.7416907729654036`*^9}, 3.7416908077747016`*^9, {3.7416908443159084`*^9, 
   3.7416908482248807`*^9}, {3.7416909788366413`*^9, 3.741691058023012*^9}, {
   3.74169187691469*^9, 3.741691879233119*^9}, {3.741768368790844*^9, 
   3.741768373343666*^9}, {3.7417686675280237`*^9, 3.7417686710765324`*^9}, {
   3.7417726744611483`*^9, 3.741772681388793*^9}, {3.741773694001057*^9, 
   3.741773740319072*^9}, {3.7419801676445055`*^9, 3.7419801926169224`*^9}, {
   3.741980256689459*^9, 3.74198030293929*^9}, {3.741980414939851*^9, 
   3.741980462310328*^9}, {3.741980661419044*^9, 3.7419807215437174`*^9}, {
   3.74198077598722*^9, 3.7419808314836674`*^9}, {3.7419808740753107`*^9, 
   3.7419810231518216`*^9}, {3.7419813591065063`*^9, 
   3.7419814073518744`*^9}, {3.741981451550741*^9, 3.7419814693870955`*^9}, {
   3.7419815229765344`*^9, 3.7419815294398355`*^9}, {3.7419815711326838`*^9, 
   3.741981632116211*^9}, 3.7458359670735083`*^9, 3.745836009695141*^9},
 ExpressionUUID -> "7e824821-755d-407b-aabf-a514cc012638"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IV. Generating input table", "Section",
 CellChangeTimes->{{3.7417811839737625`*^9, 
  3.7417811992637463`*^9}},ExpressionUUID->"58d74e4b-cd24-4829-a662-\
d34a23baee91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{" ", 
                    RowBox[{"Columns", ":", " ", "1"}], ")"}], " ", "Mass", 
                    " ", "in", " ", 
                    RowBox[{"GeV", ".", " ", "2"}]}], ")"}], " ", 
                    "Production", " ", "from", " ", "e", " ", "channel", " ", 
                    
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "3"}]}], ")"}],
                     " ", "Production", " ", "from", " ", "e", " ", "channel",
                     " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "4"}]}], ")"}],
                     " ", "Production", " ", "from", " ", "\[Mu]", " ", 
                    "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox[
                    StyleBox["B",
                    FontWeight->"Plain"], "c"]}], ")"}], ".", " ", "5"}]}], 
                    ")"}], " ", "Production", " ", "from", " ", "\[Mu]", " ", 
                    "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "6"}]}], ")"}],
                     " ", "Production", " ", "from", " ", "\[Tau]", " ", 
                    "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "7"}]}], ")"}],
                     " ", "Production", " ", "from", " ", "\[Tau]", " ", 
                    "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "8"}]}], ")"}],
                     " ", "Detection", " ", "efficiency", " ", "for", " ", 
                    "e", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "9"}]}], ")"}],
                     " ", "Detection", " ", "efficiency", " ", "for", " ", 
                    "e", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "10"}]}], 
                    ")"}], " ", "Detection", " ", "efficiency", " ", "for", 
                    " ", "\[Mu]", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox[
                    StyleBox["B",
                    FontWeight->"Plain"], "c"]}], ")"}], ".", " ", "11"}]}], 
                    ")"}], " ", "Detection", " ", "efficiency", " ", "for", 
                    " ", "\[Mu]", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "12"}]}], 
                    ")"}], " ", "Detection", " ", "efficiency", " ", "for", 
                    " ", "\[Tau]", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "13"}]}], 
                    ")"}], " ", "Detection", " ", "efficiency", " ", "for", 
                    " ", "\[Tau]", " ", "channel", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "14"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "e", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "15"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "e", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "16"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "\[Mu]", 
                    " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "17"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "\[Mu]", 
                    " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}], ".", " ", "18"}]}], 
                    ")"}], " ", "Decay", " ", "probability", " ", "component",
                     " ", "for", " ", "mixing", " ", "with", " ", "\[Tau]", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}]}], ",", " ", 
                    RowBox[{"assuming", " ", "e", " ", "production", " ", 
                    RowBox[{"channel", ".", " ", "19"}]}]}], ")"}], " ", 
                    "Decay", " ", "probability", " ", "component", " ", "for",
                     " ", "mixing", " ", "with", " ", "\[Tau]", " ", 
                    RowBox[{"(", 
                    RowBox[{"with", " ", 
                    SubscriptBox["B", "c"]}], ")"}]}], ",", " ", 
                    RowBox[{"assuming", " ", "\[Tau]", " ", "production", " ", 
                    RowBox[{"channel", ".", " ", "20"}]}]}], ")"}], " ", 
                    "Decay", " ", "probability", " ", "component", " ", "for",
                     " ", "mixing", " ", "with", " ", "\[Tau]", " ", 
                    RowBox[{"(", 
                    RowBox[{"without", " ", 
                    SubscriptBox["B", "c"]}], ")"}]}], ",", " ", 
                   RowBox[{"assuming", " ", "e", " ", "production", " ", 
                    RowBox[{"channel", ".", " ", "21"}]}]}], ")"}], " ", 
                 "Decay", " ", "probability", " ", "component", " ", "for", 
                 " ", "mixing", " ", "with", " ", "\[Tau]", " ", 
                 RowBox[{"(", 
                  RowBox[{"without", " ", 
                   SubscriptBox["B", "c"]}], ")"}]}], ",", " ", 
                RowBox[{"assuming", " ", "\[Tau]", " ", "production", " ", 
                 RowBox[{"channel", ".", " ", "22"}]}]}], ")"}], "-", "23"}], 
             ")"}], " ", "<", 
            SubscriptBox["\[Gamma]", "N"], ">", " ", 
            RowBox[{"for", " ", "mixing", " ", "with", " ", 
             SubscriptBox["\[Nu]", "e"], " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"with", " ", "and", " ", "without", " ", 
                SubscriptBox["B", "c"]}], ")"}], ".", " ", "24"}]}]}], ")"}], 
          "-", "25"}], ")"}], " ", "<", 
        SubscriptBox["\[Gamma]", "N"], ">", " ", 
        RowBox[{"for", " ", "mixing", " ", "with", " ", 
         SubscriptBox["\[Nu]", "\[Mu]"], " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"with", " ", "and", " ", "without", " ", 
            SubscriptBox["B", "c"]}], ")"}], ".", " ", "26"}]}]}], ")"}], "-",
       "27"}], ")"}], " ", "<", 
    SubscriptBox["\[Gamma]", "N"], ">", " ", 
    RowBox[{"for", " ", "mixing", " ", "with", " ", 
     SubscriptBox["\[Nu]", "\[Tau]"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"with", " ", "and", " ", "without", " ", 
        SubscriptBox["B", "c"]}], ")"}], "."}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TableOutputTotal", "=", 
     RowBox[{"Quiet", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"M", ",", 
          RowBox[{"ProductioneWithBc", "[", "M", "]"}], ",", 
          RowBox[{"ProductioneWithoutBc", "[", "M", "]"}], ",", 
          RowBox[{"Production\[Mu]WithBc", "[", "M", "]"}], ",", 
          RowBox[{"Production\[Mu]WithoutBc", "[", "M", "]"}], ",", 
          RowBox[{"Production\[Tau]WithBc", "[", "M", "]"}], ",", 
          RowBox[{"Production\[Tau]WithoutBc", "[", "M", "]"}], ",", 
          RowBox[{"AcceptanceDetectioneWithBc", "[", "M", "]"}], ",", 
          RowBox[{"AcceptanceDetectioneWithoutBc", "[", "M", "]"}], ",", 
          RowBox[{"AcceptanceDetection\[Mu]WithBc", "[", "M", "]"}], ",", 
          RowBox[{"AcceptanceDetection\[Mu]WithoutBc", "[", "M", "]"}], ",", 
          RowBox[{"AcceptanceDetection\[Tau]WithBc", "[", "M", "]"}], ",", 
          RowBox[{"AcceptanceDetection\[Tau]WithoutBc", "[", "M", "]"}], ",", 
          
          RowBox[{"DecayVectoreWithBc", "[", "M", "]"}], ",", 
          RowBox[{"DecayVectoreWithoutBc", "[", "M", "]"}], ",", 
          RowBox[{"DecayVector\[Mu]WithBc", "[", "M", "]"}], ",", 
          RowBox[{"DecayVector\[Mu]WithoutBc", "[", "M", "]"}], ",", 
          RowBox[{"DecayVector\[Tau]WithBce", "[", "M", "]"}], ",", 
          RowBox[{"DecayVector\[Tau]WithBc\[Tau]", "[", "M", "]"}], ",", 
          RowBox[{"DecayVector\[Tau]WithoutBce", "[", "M", "]"}], ",", 
          RowBox[{"DecayVector\[Tau]WithoutBc\[Tau]", "[", "M", "]"}], ",", 
          RowBox[{"gammaeWithBc", "[", "M", "]"}], ",", 
          RowBox[{"gammaeWithoutBc", "[", "M", "]"}], ",", 
          RowBox[{"gamma\[Mu]WithBc", "[", "M", "]"}], ",", 
          RowBox[{"gamma\[Mu]WithoutBc", "[", "M", "]"}], ",", 
          RowBox[{"gamma\[Tau]WithBc", "[", "M", "]"}], ",", 
          RowBox[{"gamma\[Tau]WithoutBc", "[", "M", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"M", ",", "0.02", ",", "6.12", ",", "0.05"}], "}"}]}], "]"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<inputfile.dat\>\"", ",", "TableOutputTotal"}], "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TableInput", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
         "\"\<M, GeV\>\"", ",", "\"\<Nprod e (w Bc)\>\"", ",", " ", 
          "\"\<Nprod e (w/o Bc)\>\"", ",", "\"\<Nprod mu (w Bc)\>\"", ",", 
          " ", "\"\<Nprod mu (w/o Bc)\>\"", ",", "\"\<Nprod tau (w Bc)\>\"", 
          ",", " ", "\"\<Nprod tau (w/o Bc)\>\"", ",", " ", 
          "\"\<e_det e (w Bc)\>\"", ",", "\"\<e_det e (w/o Bc)\>\"", ",", 
          "\"\<e_det mu (w Bc)\>\"", ",", "\"\<e_det mu (w/o Bc)\>\"", ",", 
          "\"\<e_det tau (w Bc)\>\"", ",", "\"\<e_det tau (w/o Bc)\>\"", ",", 
          "\"\<P_dec e (w Bc)\>\"", ",", "\"\<P_dec e (w/o Bc)\>\"", ",", 
          "\"\<P_dec mu (w Bc)\>\"", ",", "\"\<P_dec mu (w/o Bc)\>\"", ",", 
          "\"\<P_dec tau (w Bc), e\>\"", ",", 
          "\"\<P_dec tau (w Bc), \[Tau]\>\"", ",", 
          "\"\<P_dec tau (w/o Bc), e\>\"", ",", 
          "\"\<P_dec tau (w/o Bc), \[Tau]\>\"", ",", 
          "\"\<<\!\(\*SubscriptBox[\(\[Gamma]\), \(N\)]\)> (w Bc), e\>\"", 
          ",", "\"\<<\!\(\*SubscriptBox[\(\[Gamma]\), \(N\)]\)> (w/o Bc), e\>\
\"", ",", "\"\<<\!\(\*SubscriptBox[\(\[Gamma]\), \(N\)]\)> (w Bc), \[Mu]\>\"",
           ",", "\"\<<\!\(\*SubscriptBox[\(\[Gamma]\), \(N\)]\)> (w/o Bc), \
\[Mu]\>\"", ",", 
          "\"\<<\!\(\*SubscriptBox[\(\[Gamma]\), \(N\)]\)> (w Bc), \
\[Tau]\>\"", ",", 
          "\"\<<\!\(\*SubscriptBox[\(\[Gamma]\), \(N\)]\)> (w/o Bc), \[Tau]\>\
\""}], "}"}], "}"}], ",", "TableOutputTotal"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "If", " ", "you", " ", "want", " ", "to", " ", "see", " ", "the", " ", 
     "full", " ", "input", " ", "table", " ", "with", " ", "labels", " ", 
     "uncomment", " ", "the", " ", "last", " ", "line"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"TableInput", ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.745836188717389*^9, {3.745836220670649*^9, 3.7458362674541683`*^9}, {
   3.7458363943621264`*^9, 3.7458364097782516`*^9}, {3.7458364647029533`*^9, 
   3.745836520371784*^9}, {3.745837024537086*^9, 3.74583702469315*^9}, {
   3.7458371061573677`*^9, 3.74583711097712*^9}, {3.745837290712669*^9, 
   3.7458373466332808`*^9}},
 ExpressionUUID -> "c43073f4-38d3-4b29-934f-7953d439f0b5"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.741983823582282*^9, 
  3.7419838252664566`*^9}},ExpressionUUID->"10e8da8a-6097-4e3f-9654-\
b2dc8878a8f0"]
}, Open  ]]
},
WindowSize->{1484, 917},
WindowMargins->{{96, Automatic}, {31, Automatic}},
Magnification:>1.25 Inherited,
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[400, 13, 1027, 17, 172, "Input"],
Cell[CellGroupData[{
Cell[1452, 34, 210, 3, 88, "Section"],
Cell[1665, 39, 17198, 449, 2545, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18900, 493, 232, 4, 88, "Section"],
Cell[CellGroupData[{
Cell[19157, 501, 171, 2, 62, "Subsection"],
Cell[19331, 505, 18402, 522, 2089, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37770, 1032, 170, 3, 62, "Subsection"],
Cell[37943, 1037, 18595, 527, 2602, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56587, 1570, 226, 4, 88, "Section"],
Cell[CellGroupData[{
Cell[56838, 1578, 103, 0, 62, "Subsection"],
Cell[56944, 1580, 17791, 516, 1420, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74772, 2101, 104, 0, 62, "Subsection"],
Cell[74879, 2103, 25150, 697, 2941, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100066, 2805, 94, 0, 62, "Subsection"],
Cell[100163, 2807, 26885, 720, 2614, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[127097, 3533, 175, 3, 88, "Section"],
Cell[127275, 3538, 14472, 305, 1592, "Input"],
Cell[141750, 3845, 154, 3, 43, "Input"]
}, Open  ]]
}
]
*)

