/*******************************************************************************************
Authors: Carlos Segura (Programmer and Designer), Lazaro Lugo (Programmer and Designer),
Gara Miranda (Designer)

Description: main function to execute MA-EDM to an instance.
Parameters:
- Number of individuals in the population
- Crossover: it can be cx or ob
- Perturbation Type performed on the ils, it can be: SM, SWM, INM, ISM.
- Diversity factor, a value between 0 and 1.
- Run time of the intensification process based on ils
- Stopping criterion in time
- Seed
- Instance file
- Output file
********************************************************************************************/


#include "MA.h"
#include <unistd.h>
#include <bits/stdc++.h>
#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <vector>
#include <fstream>

Problem *Individual::problem;
int main(int argc, char **argv){
	if(argc!=10){
		cout << "Error. Usage: " << argv[0] << " N crossover perturbation Dfactor ils_time stopping_criterion seed instance_file output_file" << endl; 
		exit(0);
	}
	int N = atoi(argv[1]);
	double pc = 1.0;
	string crossType = argv[2];
	string perturbationType = argv[3];
	double Dfactor=atof(argv[4]);
	double ils_time=atof(argv[5]);
	double finalTime = atof(argv[6]);
	int seed = atoi(argv[7]);
	string instanceFile = argv[8];
	string outputFile = argv[9];

	srand(seed);
	MA ma(N, pc, crossType ,perturbationType, Dfactor,ils_time,finalTime, outputFile);
	Problem p(instanceFile);
	Individual::problem = &p;
	ma.run();
}
