# Extended Memetic Algorithm for the LOP (Repository)

This repository contains the source code for the research on extensions made to the MA-EDM algorithm for the Linear Ordering Problem. The repository includes all the algorithms developed in this study, as well as the best results obtained during the experiments.

# Linear Ordering Problem (LOP)

The Linear Ordering Problem (LOP) is a classical combinatorial optimization problem that arose in the field of economics. It has applications in other research areas, such as machine learning and logistics. The problem was introduced in 1936 by Leontief [[1]](https://doi.org/10.2307/1927837) and formalized in 1958 by Chenery and Watanabe [[2]](https://doi.org/10.2307/1907514), but it was not until decades later that Garey and Johnson [3] demonstrated that LOP is an NP-hard problem. Although the problem has multiple applications and formulations, it is quite common to define it as a matrix triangulation problem.

Given a matrix \($M_{n \times n} = (m_{ij})$ \), the triangulation problem is to determine a simultaneous permutation \( $\sigma$ \) of the rows and columns of \( $M$ \) such that the sum of the entries above the main diagonal is maximized (or equivalently, the sum of subdiagonal entries is minimized) [[4]](https://doi.org/10.1007/s10589-010-9384-9). Therefore, the LOP can be formulated as finding a permutation \( \sigma \) that maximizes the following equation:

$$
\sum_{i=1}^{n-1} \sum_{j=i+1}^{n} m_{\sigma_i \sigma_j}
$$

Several exact and approximate solvers have been proposed for this combinatorial optimization problem [[5]](https://doi.org/10.1007/978-3-642-16729-4_2). The interest in this problem has continued over the years, resulting in research compilations such as [[4]](https://doi.org/10.1007/s10589-010-9384-9). Until now, different algorithms have been devised that yield very promising solutions for the LOP instances addressed in [[4]](https://doi.org/10.1007/s10589-010-9384-9).

# Instances

The instances used in this research belong to the [xLOLIB2](https://doi.org/10.1016/j.ejor.2014.09.041) package:

N-t65i11xx_300,
N-be75eec_500,
N-stabu75_750,
N-t75e11xx_750,
N-usa79_750,
N-t59f11xx_750,
N-t65l11xx_750,
N-t75u11xx_750,
N-tiw56n72_750,
N-tiw56r66_750,
N-t70b11xx_1000,
N-t59n11xx_1000,
N-t70k11xx_1000,
N-t59i11xx_1000,
N-t65w11xx_1000,
N-t75u11xx_1000,
N-tiw56r54_1000,
N-tiw56r67_1000

# Algorithms

This repository contains the source code of Memetic Algorithm with Explicit Diversity Management (MA-EDM). MA-EDM is a population-based optimizer that has been used to generate several new best-known solutions (BKSs) of the Linear Ordering Problem (LOP).

The algorithms are:
1) Memetic Algorithm with Explicit Diversity Management (MA-EDM).
2) **Memetic Algorithm with Explicit Diversity Management Enhanced Intensification (MA-EDMei)**
3) **Parallel Memetic Algorithm with Explicit Diversity Management Enhanced Intensification** (PMA-EDMei)
4) Links to State-Of-The Art Methods (These methods are so far considered to be the standard methods used for LOP)
    * [ILSr](https://doi.org/10.1023/B:JMMA.0000049426.06305.d8)
    * [Mar](https://doi.org/10.1023/B:JMMA.0000049426.06305.d8)
    * [CD_RVNS](https://doi.org/10.1016/j.asoc.2019.105998)

## Executions

## Iterate Local Search (ILSr)
1) Compile with make
2) Execute with the following parameters:
3) General Parameters:
- Instance file
- Stopping criterion in time
- Output file
- Seed

Example:
```bash
 ./ils_lop -i N-t70b11xx_1000 -t 691200 -o output.txt -s 16
```

## Pairwise Precedence (CD_RVNS)
1) Compile with make
2) Parameter-less Algorithm
3) General Parameters:
- Instance file
- Stopping criterion in time
- Output file
- Seed

Example: 
```bash
./CDRVNSforLOP -i N-t70b11xx_1000 -t 691200 -o output.txt -s 30
```

## Memetic Algorithm (MAr)
1) Compile with make
2) Execute with the following parameters:
- Instance file
- Stopping criterion in time
- Output file
- Number of individuals in the population
- Seed

Example: 
```bash
./ma_lop -i N-t70b11xx_1000 -t 691200 -z output.txt -P 200 -s 6
```

## Memetic Algorithm with Explicit Diversity Management (MA-EDM)

1) Compile with make
2) Execute with the following parameters:
Parameters:
- Number of individuals in the population
- Crossover: it can be cx or ob
- Diversity factor, a value between 0 and 1.
- Stopping criterion in time
- Seed
- Instance file
- Output file

Example: 
```bash
./main 200 cx 1 14400 99 N-t65i11xx_300 output.txt
```

## Memetic Algorithm with Explicit Diversity Management Enhanced Intensification (MA-EDMei)

1) Compile with make
2) Execute with the following parameters:
Parameters:
- Number of individuals in the population
- Crossover: it can be cx or ob
- Perturbation Type performed on the ils, it can be: SM, SWM, INM, ISM.
- Diversity factor, a value between 0 and 1.
- Run time of the intensification process based on ils
- Stopping criterion in time
- Seed
- Instance file
- Output file

Example: 
```bash
./main 200 cx SWM 1 3.6 14400 99 N-t65i11xx_300 output.txt
```

## Parallel Memetic Algorithm with Explicit Diversity Management Enhanced Intensification (PMA-EDMei)

1) Compile with make
2) Execute with the following parameters:
Parameters:
- Number of individuals in the population
- Crossover: it can be cx or ob
- Perturbation Type performed on the ils, it can be: SM, SWM, INM, ISM.
- Run time of the intensification process based on ils
- Stopping criterion in time
- Seed
- Instance file
- Output file

NOTE: In this case it can be noted that the MPI library was used for the execution process. In the same way the compilation process was performed using MPI

Example: 
```bash
mpirun.openmpi -map-by slot -np 33 ./main 200 cx SWM 1 3.6 14400 99 N-t65i11xx_300 output.txt
```

# Best Known Solutions (BKS)
The BKS.zip file contains the best solutions obtained by the PMA-EDMei algorithm. Each file corresponds to a problem or instance. The runtime for which the solution was obtained is at the end of the file name. The times used were 26h and 120h

# Bibliography

## References

1. **Leontief, W.W.**: Quantitative input and output relations in the economic systems of the United States. *Rev Econ Stat* **18**(3), 105–125 (1936)

2. **Chenery, H.B., Watanabe, T.**: International comparisons of the structure of production. *Econometrica* **26**(4), 487–521 (1958)

3. **Garey, M.R., Johnson, D.S.**: Computers and Intractability: A Guide to the Theory of NP-Completeness. *W. H. Freeman & Co.*, Philadelphia, USA (1979)

4. **Martí, R., Reinelt, G., Duarte, A.**: A benchmark library and a comparison of heuristic methods for the linear ordering problem. *Comput. Optim. Appl.* **51**, 1297–1317 (2012)

5. **Martí, R., Reinelt, G.**: The Linear Ordering Problem - Exact and Heuristic Methods in Combinatorial Optimization, p. 169. *Springer, Springer Heidelberg Dordrecht London New York* (2011)



