/*******************************************************************************************
Authors: Carlos Segura (Programmer and Designer), Lazaro Lugo (Programmer and Designer),
Gara Miranda (Designer)

	Description: Method to send an individual. It sends the permutation, 
	the way to evaluate it in the intensification (exact vs approximated) and 
	optionally, its current cost. 
	The cost will be DBL_MAX if it is not valid.
**********************************************************************************/

#include "Individual.h"
#include "mpi.h"
#include "MA.h"

void Individual::send(int to){
	int Size = problem->problemDimension;
	// cout << "Envia arreglo con tam: " << S.size() << endl << flush;
	// cout << "El problem dimension es: " << Size << endl << flush;
	MPI_Send(S.data(), Size, MPI_INT, to, TAG_INTENSIFY, MPI_COMM_WORLD);
	MPI_Send(&cost, 1, MPI_LONG_LONG_INT, to, TAG_INTENSIFY, MPI_COMM_WORLD);
}
