/*******************************************************************************************
Authors: Carlos Segura (Programmer and Designer), Lazaro Lugo (Programmer and Designer),
Gara Miranda (Designer)

	Description: Method to receive an individual. It receives the permutation, 
	the way to evaluate it in the intensification (exact vs approximated) and 
	optionally, its current cost. 
	The cost will be LLONG_MAX if it is not valid.
**********************************************************************************/

#include "Individual.h"
#include "mpi.h"
#include "MA.h"

int Individual::receive(int from) {
	// cout << "El espacio reservado actualmente es " << S.size() << endl << flush;
	int Size = problem->problemDimension;
	// cout << "Lo que pide recibir es " << Size << endl << flush;
	MPI_Status status;
	MPI_Recv(S.data(), Size, MPI_INT, from, TAG_INTENSIFY, MPI_COMM_WORLD, &status);
	// cout << "Recibio de " << status.MPI_SOURCE << endl << flush;
	MPI_Recv(&cost, 1, MPI_LONG_LONG_INT, status.MPI_SOURCE, TAG_INTENSIFY, MPI_COMM_WORLD, &status);
	// cout << "Recibio el cost de " << status.MPI_SOURCE << endl << flush;
	return status.MPI_SOURCE;
}
