/*******************************************************************************************
Authors: Carlos Segura (Programmer and Designer), Lazaro Lugo (Programmer and Designer),
Gara Miranda (Designer)

Description: main function to execute MA-EDM to an instance.
Parameters:
- Number of individuals in the population
- Crossover: it can be cx or ob
- Perturbation Type performed on the ils, it can be: SM, SWM, INM, ISM.
- Diversity factor, a value between 0 and 1.
- Run time of the intensification process based on ils
- Stopping criterion in time
- Seed
- Instance file
- Output file
********************************************************************************************/

/*
* Proceso de Paralelización SINCRONA del problema LOP con Memético
* -Los códigos paralelos se pondrán entre los comentarios 
*&&&&&&&& MPI &&&&&&&
*&&&&&&&& MPI &&&&&&&
*/

#include "MA.h"
#include <unistd.h>
#include <bits/stdc++.h>
#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <vector>
#include <fstream>
#include "mpi.h"

Problem *Individual::problem;
int main(int argc, char **argv){
	if(argc!=9){
		cout << "Error. Usage: " << argv[0] << " N crossover perturbation ils_time stopping_criterion seed instance_file output_file" << endl; 
		exit(0);
	}

	//&&&&&&&& MPI &&&&&&&
	MPI_Init(&argc, &argv);
	int p_rank;
	MPI_Comm_rank(MPI_COMM_WORLD,&p_rank);
    //&&&&&&&& MPI &&&&&&&
	
	int N = atoi(argv[1]);
	double pc = 1.0;
	string crossType = argv[2];
	string perturbation = argv[3];
	double ils_time = atof(argv[4]);
	double finalTime = atof(argv[5]);
	int seed = atoi(argv[6]);
	string instanceFile = argv[7];
	string outputFile = argv[8];

	//&&&&&&&& MPI &&&&&&&
	//Proceso Maestro imprime informacion de parametros del Algoritmo
	if(p_rank==0){
		cout << "Information about parameters" << endl;
		cout << "N: " << N << " (Population Size)" << endl;
		cout << "Pc: " << pc << " (Crossover Probability)" << endl;
		cout << "crossType: " << crossType << " (Cross Type Operator)" << endl;
		cout << "perturbation: " << perturbation << " (Perturbation Operator)" << endl;
		cout << "ils_time: " << ils_time << " Ils Time" << endl;
		cout << "FinalTime: " << finalTime << " (Stopping criterion in seconds)" << endl;
		cout << "Seed: " << seed << " (Seed of random generator)" << endl;
		cout << "OutputFile: " << outputFile <<  endl;
	}
	srand(seed+p_rank); //Para Evitar que existan soluciones repetidas con la misma semilla 
	//&&&&&&&& MPI &&&&&&&

	MA ma(N, pc, crossType, perturbation,ils_time,finalTime, outputFile);
	Problem p(instanceFile);
	Individual::problem = &p;
	ma.run();
	

	
}
