![GW150914](docs/_static/gw150914st.png)

Welcome to PyCBC, a python toolkit for analysis of data from gravitational-wave
laser interferometer detectors with the goal of detecting and studying signals
from compact binary coalescences (CBCs).

The PyCBC home page is located on github at

 * https://pycbc.org/

Documentation is automatically built nightly and available from

 * https://pycbc.org/pycbc/latest/html/

For the detailed installation instructions of PyCBC

 * https://pycbc.org/pycbc/latest/html/install.html
  
Quick Installation
```
pip install lalsuite pycbc
```
  
You can start up an interactive jupyter notebook with PyCBC using either of the links below.

[![Azure Notebooks](https://notebooks.azure.com/launch.png)](https://notebooks.azure.com/nitz/libraries/pycbc)
[![Start your mybinder session](http://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/gwastro/PyCBC-Tutorials/master?filepath=index.ipynb)

If you use any code from PyCBC in a scientific publication, then we ask that
it is cited in the following way:

```
These results were generated using the PyCBC software package
\cite{Canton:2014ena,Usman:2015kfa,pycbc-software}
```

For the citation ``pycbc-software``,  please use a bibtex entry and DOI for the
appropriate release of the PyCBC software (or the latest available release).
A bibtex key and DOI for each release is avaliable from [Zenodo](http://zenodo.org/).
A key for the latest release is available at:

[![DOI](https://zenodo.org/badge/31596861.svg)](https://zenodo.org/badge/latestdoi/31596861)

Please see our [citation guidelines](http://pycbc.org/pycbc/latest/html/credit.html) for 
more details.

[![PyPI version](https://badge.fury.io/py/PyCBC.svg)](https://badge.fury.io/py/PyCBC)
[![Build Status](https://travis-ci.org/gwastro/pycbc.svg?branch=master)](https://travis-ci.org/gwastro/pycbc)
[![Code Health](https://landscape.io/github/gwastro/pycbc/master/landscape.svg?style=flat)](https://landscape.io/github/gwastro/pycbc/master)
[![Research software impact](http://depsy.org/api/package/pypi/PyCBC/badge.svg)](http://depsy.org/package/python/PyCBC)
