/*-
 * #%L
 * BroadleafCommerce Framework
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 * 
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
/**
 * @author Austin Rooke (austinrooke)
 */
package org.broadleafcommerce.core.spec.pricing.service.workflow

import org.broadleafcommerce.core.pricing.service.TaxService
import org.broadleafcommerce.core.pricing.service.workflow.TaxActivity

class TaxActivitySpec extends BasePricingActivitySpec {

    TaxService mockTaxService

    def "Test TaxActivity with a provided TaxService and TaxModule"() {
        setup: "Prepare mock objects"
        mockTaxService = Mock()
        activity = new TaxActivity().with() {
            taxService = mockTaxService
            it
        }

        when: "I execute TaxActivity"
        context = activity.execute(context)

        then: "mockTaxService should be invoked but mockTaxModule should not"
        1 * mockTaxService.calculateTaxForOrder(_) >> context.seedData
    }

    def "Test TaxActivity with a provided TaxService"() {
        setup: "Prepare mock object"
        mockTaxService = Mock()
        activity = new TaxActivity().with() {
            taxService = mockTaxService
            it
        }

        when: "I execute TaxActivity"
        context = activity.execute(context)

        then: "mockTaxService should be invoked"
        1 * mockTaxService.calculateTaxForOrder(_) >> context.seedData
    }
}
