/*-
 * #%L
 * BroadleafCommerce Framework
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.core.offer.domain;

import org.broadleafcommerce.common.copy.MultiTenantCloneable;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;

/**
 * Records the actual adjustments that were made to an OrderItemPriceDetail.
 *
 * @author bpolster
 */
public interface OrderItemPriceDetailAdjustment extends Adjustment, MultiTenantCloneable<OrderItemPriceDetailAdjustment> {

    /**
     * Stores the offer name at the time the adjustment was made.   Primarily to simplify display
     * within the admin.
     *
     * @return
     */
    String getOfferName();

    /**
     * Returns the name of the offer at the time the adjustment was made.
     *
     * @param offerName
     */
    void setOfferName(String offerName);

    OrderItemPriceDetail getOrderItemPriceDetail();

    void setOrderItemPriceDetail(OrderItemPriceDetail orderItemPriceDetail);

    void init(OrderItemPriceDetail orderItemPriceDetail, Offer offer, String reason);

    /**
     * Even for items that are on sale, it is possible that an adjustment was made
     * to the retail price that gave the customer a better offer.
     * <p>
     * Since some offers can be applied to the sale price and some only to the
     * retail price, this setting provides the required value.
     *
     * @return true if this adjustment was applied to the sale price
     */
    boolean isAppliedToSalePrice();

    void setAppliedToSalePrice(boolean appliedToSalePrice);

    /**
     * Value of this adjustment relative to the retail price.
     *
     * @return
     */
    Money getRetailPriceValue();

    void setRetailPriceValue(Money retailPriceValue);

    /**
     * Value of this adjustment relative to the sale price.
     *
     * @return
     */
    Money getSalesPriceValue();

    void setSalesPriceValue(Money salesPriceValue);

    /**
     * Future credit means that the associated adjustment will be discounted at a later time to the customer
     * via a credit. It is up to the implementor to decide how to achieve this. This field is used to determine
     * if the adjustment originated from an offer marked as FUTURE_CREDIT.
     * <p>
     * See {@link Offer#getAdjustmentType()} for more info
     *
     * @return
     */
    boolean isFutureCredit();

    /**
     * Future credit means that the associated adjustment will be discounted at a later time to the customer
     * via a credit. It is up to the implementor to decide how to achieve this. This field is used to determine
     * if the adjustment originated from an offer marked as FUTURE_CREDIT.
     * <p>
     * See {@link Offer#getAdjustmentType()} for more info
     *
     * @param futureCredit
     */
    void setFutureCredit(boolean futureCredit);

}
