-- ISO-3166-1 list of countries
-- see http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2 decoding table

INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AA', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AC', 'Ascension Island', 'ASC', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AD', 'Andorra', 'AND', '20', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AE', 'United Arab Emirates', 'ARE', '784', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AF', 'Afghanistan', 'AFG', '4', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AG', 'Antigua and Barbuda', 'ATG', '28', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AI', 'Anguilla', 'AIA', '660', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AL', 'Albania', 'ALB', '8', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AM', 'Armenia', 'ARM', '51', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AN', 'Netherlands Antilles', 'ANHH', '530', 'TRANSITIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AO', 'Angola', 'AGO', '24', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AP', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AQ', 'Antarctica', 'ATA', '10', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AR', 'Argentina', 'ARG', '32', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AS', 'American Samoa', 'ASM', '16', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AT', 'Austria', 'AUT', '40', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AU', 'Australia', 'AUS', '36', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AW', 'Aruba', 'ABW', '533', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AX', 'Åland Islands', 'ALA', '248', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('AZ', 'Azerbaijan', 'AZE', '31', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BA', 'Bosnia and Herzegovina', 'BIH', '70', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BB', 'Barbados', 'BRB', '52', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BD', 'Bangladesh', 'BGD', '50', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BE', 'Belgium', 'BEL', '56', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BF', 'Burkina Faso', 'BFA', '854', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BG', 'Bulgaria', 'BGR', '100', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BH', 'Bahrain', 'BHR', '48', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BI', 'Burundi', 'BDI', '108', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BJ', 'Benin', 'BEN', '204', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BL', 'Saint Barthélemy', 'BLM', '652', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BM', 'Bermuda', 'BMU', '60', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BN', 'Brunei Darussalam', 'BRN', '96', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BO', 'Bolivia, Plurinational State of', 'BOL', '68', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BQ', 'Bonaire, Sint Eustatius and Saba', 'BES', '535', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BR', 'Brazil', 'BRA', '76', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BS', 'Bahamas', 'BHS', '44', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BT', 'Bhutan', 'BTN', '64', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BU', 'Burma', 'BUMM', '104', 'TRANSITIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BV', 'Bouvet Island', 'BVT', '74', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BW', 'Botswana', 'BWA', '72', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BX', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BY', 'Belarus', 'BLR', '112', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('BZ', 'Belize', 'BLZ', '84', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CA', 'Canada', 'CAN', '124', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CC', 'Cocos (Keeling) Islands', 'CCK', '166', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CD', 'Congo, the Democratic Republic of the', 'COD', '180', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CF', 'Central African Republic', 'CAF', '140', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CG', 'Congo', 'COG', '178', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CH', 'Switzerland', 'CHE', '756', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CI', 'Côte d''Ivoire', 'CIV', '384', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CK', 'Cook Islands', 'COK', '184', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CL', 'Chile', 'CHL', '152', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CM', 'Cameroon', 'CMR', '120', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CN', 'China', 'CHN', '156', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CO', 'Colombia', 'COL', '170', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CP', 'Clipperton Island', 'CPT', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CR', 'Costa Rica', 'CRI', '188', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CS', 'Serbia and Montenegro', 'CSXX', '891', 'TRANSITIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CU', 'Cuba', 'CUB', '192', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CV', 'Cape Verde', 'CPV', '132', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CW', 'Curaçao', 'CUW', '531', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CX', 'Christmas Island', 'CXR', '162', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CY', 'Cyprus', 'CYP', '196', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('CZ', 'Czech Republic', 'CZE', '203', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DA', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DE', 'Germany', 'DEU', '276', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DG', 'Diego Garcia', 'DGA', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DJ', 'Djibouti', 'DJI', '262', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DK', 'Denmark', 'DNK', '208', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DM', 'Dominica', 'DMA', '212', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DO', 'Dominican Republic', 'DOM', '214', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DR', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DY', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('DZ', 'Algeria', 'DZA', '12', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EA', 'Ceuta, Melilla', 'null', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EC', 'Ecuador', 'ECU', '218', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ED', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EE', 'Estonia', 'EST', '233', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EF', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EG', 'Egypt', 'EGY', '818', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EH', 'Western Sahara', 'ESH', '732', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EM', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EP', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ER', 'Eritrea', 'ERI', '232', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ES', 'Spain', 'ESP', '724', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ET', 'Ethiopia', 'ETH', '231', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EU', 'European Union', 'null', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EV', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EW', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('EZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FA', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FI', 'Finland', 'FIN', '246', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FJ', 'Fiji', 'FJI', '242', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FK', 'Falkland Islands (Malvinas)', 'FLK', '238', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FL', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FM', 'Micronesia, Federated States of', 'FSM', '583', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FO', 'Faroe Islands', 'FRO', '234', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FR', 'France', 'FRA', '250', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FX', 'France, Metropolitan', 'FXX', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('FZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GA', 'Gabon', 'GAB', '266', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GB', 'United Kingdom', 'GBR', '826', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GC', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GD', 'Grenada', 'GRD', '308', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GE', 'Georgia', 'GEO', '268', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GF', 'French Guiana', 'GUF', '254', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GG', 'Guernsey', 'GGY', '831', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GH', 'Ghana', 'GHA', '288', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GI', 'Gibraltar', 'GIB', '292', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GL', 'Greenland', 'GRL', '304', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GM', 'Gambia', 'GMB', '270', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GN', 'Guinea', 'GIN', '324', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GP', 'Guadeloupe', 'GLP', '312', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GQ', 'Equatorial Guinea', 'GNQ', '226', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GR', 'Greece', 'GRC', '300', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GS', 'South Georgia and the South Sandwich Islands', 'SGS', '239', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GT', 'Guatemala', 'GTM', '320', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GU', 'Guam', 'GUM', '316', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GW', 'Guinea-Bissau', 'GNB', '624', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GY', 'Guyana', 'GUY', '328', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('GZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HA', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HK', 'Hong Kong', 'HKG', '344', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HM', 'Heard Island and McDonald Islands', 'HMD', '334', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HN', 'Honduras', 'HND', '340', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HR', 'Croatia', 'HRV', '191', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HT', 'Haiti', 'HTI', '332', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HU', 'Hungary', 'HUN', '348', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('HZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IA', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IB', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IC', 'Canary Islands', 'null', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ID', 'Indonesia', 'IDN', '360', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IE', 'Ireland', 'IRL', '372', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('II', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IL', 'Israel', 'ISR', '376', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IM', 'Isle of Man', 'IMN', '833', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IN', 'India', 'IND', '356', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IO', 'British Indian Ocean Territory', 'IOT', '86', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IQ', 'Iraq', 'IRQ', '368', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IR', 'Iran, Islamic Republic of', 'IRN', '364', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IS', 'Iceland', 'ISL', '352', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IT', 'Italy', 'ITA', '380', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('IZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JA', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JE', 'Jersey', 'JEY', '832', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JM', 'Jamaica', 'JAM', '388', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JO', 'Jordan', 'JOR', '400', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JP', 'Japan', 'JPN', '392', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JR', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('JZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KA', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KE', 'Kenya', 'KEN', '404', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KG', 'Kyrgyzstan', 'KGZ', '417', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KH', 'Cambodia', 'KHM', '116', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KI', 'Kiribati', 'KIR', '296', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KM', 'Comoros', 'COM', '174', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KN', 'Saint Kitts and Nevis', 'KNA', '659', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KP', 'Korea, Democratic People''s Republic of', 'PRK', '408', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KR', 'Korea, Republic of', 'KOR', '410', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KW', 'Kuwait', 'KWT', '414', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KY', 'Cayman Islands', 'CYM', '136', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('KZ', 'Kazakhstan', 'KAZ', '398', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LA', 'Lao People''s Democratic Republic', 'LAO', '418', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LB', 'Lebanon', 'LBN', '422', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LC', 'Saint Lucia', 'LCA', '662', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LF', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LI', 'Liechtenstein', 'LIE', '438', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LK', 'Sri Lanka', 'LKA', '144', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LM', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LR', 'Liberia', 'LBR', '430', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LS', 'Lesotho', 'LSO', '426', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LT', 'Lithuania', 'LTU', '440', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LU', 'Luxembourg', 'LUX', '442', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LV', 'Latvia', 'LVA', '428', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LY', 'Libya', 'LBY', '434', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('LZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MA', 'Morocco', 'MAR', '504', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MC', 'Monaco', 'MCO', '492', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MD', 'Moldova, Republic of', 'MDA', '498', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ME', 'Montenegro', 'MNE', '499', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MF', 'Saint Martin (French part)', 'MAF', '663', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MG', 'Madagascar', 'MDG', '450', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MH', 'Marshall Islands', 'MHL', '584', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MK', 'Macedonia, the former Yugoslav Republic of', 'MKD', '807', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ML', 'Mali', 'MLI', '466', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MM', 'Myanmar', 'MMR', '104', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MN', 'Mongolia', 'MNG', '496', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MO', 'Macao', 'MAC', '446', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MP', 'Northern Mariana Islands', 'MNP', '580', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MQ', 'Martinique', 'MTQ', '474', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MR', 'Mauritania', 'MRT', '478', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MS', 'Montserrat', 'MSR', '500', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MT', 'Malta', 'MLT', '470', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MU', 'Mauritius', 'MUS', '480', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MV', 'Maldives', 'MDV', '462', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MW', 'Malawi', 'MWI', '454', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MX', 'Mexico', 'MEX', '484', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MY', 'Malaysia', 'MYS', '458', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('MZ', 'Mozambique', 'MOZ', '508', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NA', 'Namibia', 'NAM', '516', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NC', 'New Caledonia', 'NCL', '540', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ND', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NE', 'Niger', 'NER', '562', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NF', 'Norfolk Island', 'NFK', '574', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NG', 'Nigeria', 'NGA', '566', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NI', 'Nicaragua', 'NIC', '558', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NL', 'Netherlands', 'NLD', '528', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NM', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NO', 'Norway', 'NOR', '578', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NP', 'Nepal', 'NPL', '524', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NR', 'Nauru', 'NRU', '520', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NT', 'Neutral Zone', 'NTHH', '536', 'TRANSITIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NU', 'Niue', 'NIU', '570', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('NZ', 'New Zealand', 'NZL', '554', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OA', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OM', 'Oman', 'OMN', '512', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ON', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OR', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('OZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PA', 'Panama', 'PAN', '591', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PE', 'Peru', 'PER', '604', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PF', 'French Polynesia', 'PYF', '258', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PG', 'Papua New Guinea', 'PNG', '598', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PH', 'Philippines', 'PHL', '608', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PI', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PK', 'Pakistan', 'PAK', '586', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PL', 'Poland', 'POL', '616', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PM', 'Saint Pierre and Miquelon', 'SPM', '666', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PN', 'Pitcairn', 'PCN', '612', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PR', 'Puerto Rico', 'PRI', '630', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PS', 'Palestine, State of', 'PSE', '275', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PT', 'Portugal', 'PRT', '620', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PW', 'Palau', 'PLW', '585', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PY', 'Paraguay', 'PRY', '600', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('PZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QA', 'Qatar', 'QAT', '634', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QM', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QN', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QO', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QP', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QQ', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QR', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QS', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QT', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QU', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QV', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QW', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QX', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QY', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('QZ', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RA', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RB', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RC', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RE', 'Réunion', 'REU', '638', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RH', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RI', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RL', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RM', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RN', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RO', 'Romania', 'ROU', '642', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RP', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RR', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RS', 'Serbia', 'SRB', '688', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RU', 'Russian Federation', 'RUS', '643', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RW', 'Rwanda', 'RWA', '646', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('RZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SA', 'Saudi Arabia', 'SAU', '682', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SB', 'Solomon Islands', 'SLB', '90', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SC', 'Seychelles', 'SYC', '690', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SD', 'Sudan', 'SDN', '729', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SE', 'Sweden', 'SWE', '752', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SF', 'Finland', 'FIN', '246', 'TRANSITIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SG', 'Singapore', 'SGP', '702', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SH', 'Saint Helena, Ascension and Tristan da Cunha', 'SHN', '654', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SI', 'Slovenia', 'SVN', '705', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SJ', 'Svalbard and Jan Mayen', 'SJM', '744', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SK', 'Slovakia', 'SVK', '703', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SL', 'Sierra Leone', 'SLE', '694', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SM', 'San Marino', 'SMR', '674', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SN', 'Senegal', 'SEN', '686', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SO', 'Somalia', 'SOM', '706', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SR', 'Suriname', 'SUR', '740', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SS', 'South Sudan', 'SSD', '728', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ST', 'Sao Tome and Principe', 'STP', '678', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SU', 'USSR', 'SUN', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SV', 'El Salvador', 'SLV', '222', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SX', 'Sint Maarten (Dutch part)', 'SXM', '534', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SY', 'Syrian Arab Republic', 'SYR', '760', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('SZ', 'Swaziland', 'SWZ', '748', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TA', 'Tristan da Cunha', 'TAA', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TC', 'Turks and Caicos Islands', 'TCA', '796', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TD', 'Chad', 'TCD', '148', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TF', 'French Southern Territories', 'ATF', '260', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TG', 'Togo', 'TGO', '768', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TH', 'Thailand', 'THA', '764', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TJ', 'Tajikistan', 'TJK', '762', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TK', 'Tokelau', 'TKL', '772', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TL', 'Timor-Leste', 'TLS', '626', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TM', 'Turkmenistan', 'TKM', '795', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TN', 'Tunisia', 'TUN', '788', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TO', 'Tonga', 'TON', '776', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TP', 'East Timor', 'TPTL', '0', 'TRANSITIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TR', 'Turkey', 'TUR', '792', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TT', 'Trinidad and Tobago', 'TTO', '780', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TV', 'Tuvalu', 'TUV', '798', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TW', 'Taiwan, Province of China', 'TWN', '158', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('TZ', 'Tanzania, United Republic of', 'TZA', '834', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UA', 'Ukraine', 'UKR', '804', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UG', 'Uganda', 'UGA', '800', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UK', 'United Kingdom', 'null', '-1', 'EXCEPTIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UM', 'United States Minor Outlying Islands', 'UMI', '581', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UR', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('US', 'United States', 'USA', '840', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UY', 'Uruguay', 'URY', '858', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('UZ', 'Uzbekistan', 'UZB', '860', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VA', 'Holy See (Vatican City State)', 'VAT', '336', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VC', 'Saint Vincent and the Grenadines', 'VCT', '670', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VE', 'Venezuela, Bolivarian Republic of', 'VEN', '862', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VG', 'Virgin Islands, British', 'VGB', '92', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VI', 'Virgin Islands, U.S.', 'VIR', '850', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VM', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VN', 'Viet Nam', 'VNM', '704', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VR', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VU', 'Vanuatu', 'VUT', '548', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('VZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WA', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WF', 'Wallis and Futuna', 'WLF', '876', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WG', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WL', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WM', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WO', NULL, NULL, -1, 'NOT_USED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WR', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WS', 'Samoa', 'WSM', '882', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WV', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('WZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XA', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XB', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XC', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XD', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XE', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XF', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XG', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XH', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XI', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XJ', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XK', 'Kosovo, Republic of', 'XXK', '-1', 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XL', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XM', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XN', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XO', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XP', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XQ', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XR', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XS', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XT', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XU', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XV', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XW', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XX', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XY', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('XZ', NULL, NULL, -1, 'USER_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YA', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YE', 'Yemen', 'YEM', '887', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YM', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YR', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YT', 'Mayotte', 'MYT', '175', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YU', 'Yugoslavia', 'YUCS', '890', 'TRANSITIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YV', NULL, NULL, -1, 'INDETERMINATELY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YW', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('YZ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZA', 'South Africa', 'ZAF', '710', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZB', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZC', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZD', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZE', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZF', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZG', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZH', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZI', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZJ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZK', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZL', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZM', 'Zambia', 'ZMB', '894', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZN', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZO', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZP', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZQ', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZR', 'Zaire', 'ZRCD', '0', 'TRANSITIONALLY_RESERVED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZS', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZT', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZU', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZV', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZW', 'Zimbabwe', 'ZWE', '716', 'OFFICIALLY_ASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZX', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZY', NULL, NULL, -1, 'UNASSIGNED');
INSERT INTO BLC_ISO_COUNTRY (ALPHA_2, NAME, ALPHA_3, NUMERIC_CODE, STATUS) VALUES ('ZZ', NULL, NULL, -1, 'USER_ASSIGNED');
