/*-
 * #%L
 * BroadleafCommerce Common Libraries
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.common.web;

import com.fasterxml.jackson.databind.ObjectMapper;

import java.util.HashMap;
import java.util.Map;

import jakarta.servlet.http.HttpServletResponse;

/**
 * Used when a controller typically returns a String that represents a view path but would like to return a
 * JSON response in other scenarios, such as an error case.
 * <p>
 * Example Usage:
 * <p>
 * return new JsonResponse(response)
 * .with("status", "ok")
 * .with("shouldRefresh", true)
 * .done();
 *
 * @author Andre Azzolini (apazzolini)
 */
public class JsonResponse {

    protected Map<String, Object> map = new HashMap<>();
    protected HttpServletResponse response;

    public JsonResponse(HttpServletResponse response) {
        this.response = response;
    }

    public JsonResponse with(String key, Object value) {
        map.put(key, value);
        return this;
    }

    public String done() {
        response.setHeader("Content-Type", "application/json");
        try {
            new ObjectMapper().writeValue(response.getWriter(), map);
        } catch (Exception e) {
            throw new RuntimeException("Could not serialize JSON", e);
        }
        return null;
    }

}
