/*-
 * #%L
 * BroadleafCommerce Common Libraries
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.common.weave;

import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.persistence.Status;

import jakarta.persistence.Embedded;

/**
 * @author by reginaldccole
 */
public final class WeaveArchiveStatus implements Status {

    @Embedded
    protected ArchiveStatus archiveStatus;

    private ArchiveStatus getEmbeddableArchiveStatus(boolean assign) {
        ArchiveStatus temp = archiveStatus;
        if (temp == null) {
            temp = new ArchiveStatus();
            if (assign) {
                archiveStatus = temp;
            }
        }
        return temp;
    }

    @Override
    public Character getArchived() {
        return getEmbeddableArchiveStatus(false).getArchived();
    }

    @Override
    public void setArchived(Character archived) {
        getEmbeddableArchiveStatus(true).setArchived(archived);
    }

    @Override
    public boolean isActive() {
        return 'Y' != getArchived();
    }

}
