/*-
 * #%L
 * BroadleafCommerce Common Libraries
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.common.util;

import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.web.BroadleafRequestContext;

import java.util.Locale;
import java.util.Map;

/**
 * Convenience class to format prices for front-end display.
 *
 * @author Chris Kittrell (ckittrell)
 */
public class BLCMoneyFormatUtils {

    /**
     * Reformats the given price field for front-end display.
     *
     * @param price
     * @return the formatted price
     */
    public static String formatPrice(Money price) {
        if (price == null) {
            return "Not Available";
        }

        BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
        if (brc.getJavaLocale() != null) {
            return BroadleafCurrencyUtils.getNumberFormatFromCache(brc.getJavaLocale(), price.getCurrency()).format(price.getAmount());
        } else {
            // Setup your BLC_CURRENCY and BLC_LOCALE to display a diff default.
            return "$ " + price.getAmount().toString();
        }
    }

    public static String formatPrice(Money price, Map<String,String> localeToChange) {
        if (price == null) {
            return "Not Available";
        }

        Locale javaLocale = BroadleafRequestContext.getBroadleafRequestContext().getJavaLocale();
        if (javaLocale != null) {
            return BroadleafCurrencyUtils.getNumberFormatFromCache(javaLocale, price.getCurrency(),localeToChange)
                    .format(price.getAmount());
        } else {
            // Setup your BLC_CURRENCY and BLC_LOCALE to display a diff default.
            return "$ " + price.getAmount().toString();
        }
    }

}
