/*-
 * #%L
 * BroadleafCommerce Common Libraries
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.common.sitemap.wrapper;

import java.io.Serial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

/**
 * Representation the sitemapindex element defined in the schema definition at
 * http://www.sitemaps.org/schemas/sitemap/0.9.
 *
 * @author bpolster
 */
@XmlRootElement(name = "sitemapindex")
public class SiteMapIndexWrapper implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    private List<SiteMapWrapper> siteMapWrappers = new ArrayList<SiteMapWrapper>();

    public List<SiteMapWrapper> getSiteMapWrappers() {
        return siteMapWrappers;
    }

    @XmlElement(name = "sitemap")
    public void setSiteMapWrappers(List<SiteMapWrapper> siteMapWrappers) {
        this.siteMapWrappers = siteMapWrappers;
    }

}
