/*-
 * #%L
 * BroadleafCommerce Common Libraries
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.common.site.dao;

import org.broadleafcommerce.common.site.domain.Catalog;
import org.broadleafcommerce.common.site.domain.Site;
import org.broadleafcommerce.common.site.domain.SiteCatalogXref;

import java.util.List;

public interface SiteDao {

    /**
     * Creates an instance of Site based on the class matching the bean id of
     * "org.broadleafcommerce.common.site.domain.Site"
     *
     * @return
     */
    Site create();

    /**
     * Finds a site by its id.
     *
     * @param id
     * @return
     */
    Site retrieve(Long id);

    /**
     * Finds a site by its domain or domain prefix.
     *
     * @param domain
     * @param prefix
     * @return
     */
    Site retrieveSiteByDomainOrDomainPrefix(String domain, String prefix);

    /**
     * Finds a site by its {@link Site#getSiteIdentifierValue()}.
     *
     * @param identifier
     * @return
     */
    Site retrieveSiteByIdentifier(String identifier);

    /**
     * Persists the site changes.
     *
     * @param site
     * @return
     */
    Site save(Site site);

    /**
     * Returns a default site.   This method returns null in the out of box implementation of Broadleaf.
     * Extend for implementation specific behavior.
     *
     * @return
     */
    Site retrieveDefaultSite();

    /**
     * @return a List of all sites in the system
     */
    List<Site> readAllActiveSites();

    /**
     * Finds a catalog by its id.
     *
     * @param id
     * @return the catalog
     */
    Catalog retrieveCatalog(Long id);

    Catalog retrieveCatalogByName(String name);

    /**
     * Creates a catalog using {@link org.broadleafcommerce.common.persistence.EntityConfiguration}.
     *
     * @return the catalog
     */
    Catalog createCatalog();

    /**
     * Creates a new instance of {@code SiteCatalogXref} using {@link org.broadleafcommerce.common.persistence.EntityConfiguration}.
     *
     * @return the site catalog
     */
    SiteCatalogXref createSiteCatalog();

    Catalog save(Catalog catalog);

    /**
     * Retrieves all catalogs
     *
     * @return the list of catalogs
     */
    List<Catalog> retrieveAllCatalogs();

}
