/*-
 * #%L
 * BroadleafCommerce Common Libraries
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.common.security.service;

import org.broadleafcommerce.common.exception.ServiceException;

/**
 * @author jfischer
 */
public interface ExploitProtectionService {

    /**
     * Detect and remove possible XSS threats from the passed in string. This
     * includes {@code <script>} tags, and the like.
     *
     * @param string The possibly dirty string
     * @return The cleansed version of the string
     * @throws ServiceException
     */
    String cleanString(String string) throws ServiceException;

    /**
     * Detect and remove possible XSS threats from the passed in string. This
     * includes {@code <script>} tags, and the like. If an html, validation, or
     * security problem is detected, an exception is thrown. This method also emits
     * well formed xml, which is important if using Thymeleaf to display the results.
     *
     * @param string The possibly dirty string
     * @return The cleansed version of the string
     * @throws ServiceException, CleanStringException
     */
    String cleanStringWithResults(String string) throws ServiceException;

    /**
     * Detect possible XSRF attacks by comparing the csrf token included
     * in the request against the true token for this user from the session. If they are
     * different, then the exception is thrown.
     *
     * @param passedToken The csrf token that was passed in the request
     * @throws ServiceException
     */
    void compareToken(String passedToken) throws ServiceException;

    String getCSRFToken() throws ServiceException;

    String getCsrfTokenParameter();

    String htmlDecode(String value);

}
