/*-
 * #%L
 * BroadleafCommerce Common Libraries
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.common.extensibility.jpa;

/**
 * Represents the columns that get weaved into entities that are marked as site-specific.
 *
 * @author Jeff Fischer
 */
public interface SiteDiscriminator extends Discriminatable {

    /**
     * @return the site discriminator
     */
    Long getSiteDiscriminator();

    /**
     * Sets the site discriminator
     *
     * @param siteDiscriminator
     */
    void setSiteDiscriminator(Long siteDiscriminator);

}
