/*-
 * #%L
 * BroadleafCommerce Open Admin Platform
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 * 
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
/*!
 * jQuery QueryBuilder 2.3.0
 * Copyright 2014-2015 Damien "Mistic" Sorel (http://www.strangeplanet.fr)
 * Licensed under MIT (http://opensource.org/licenses/MIT)
 */

!function(a,b){"function"==typeof define&&define.amd?define(["jquery","doT","jQuery.extendext"],b):b(a.jQuery,a.doT)}(this,function($,a){"use strict";function b(a){return this instanceof b?(this.root=null,void(this.$=$(this))):b.getModel(a)}function c(a,b){b.forEach(function(b){Object.defineProperty(a.prototype,b,{enumerable:!0,get:function(){return this.__[b]},set:function(a){var c=null!==this.__[b]&&"object"==typeof this.__[b]?$.extend({},this.__[b]):this.__[b];this.__[b]=a,null!==this.model&&this.model.trigger("update",this,b,a,c)}})})}function d(a,c){var d;return d=c.closest(f.rule_container),d.length?void a.moveAfter(b(d)):(d=c.closest(f.group_header),d.length?(d=c.closest(f.group_container),void a.moveAtBegin(b(d))):(d=c.closest(f.group_container),d.length?void a.moveAtEnd(b(d)):void 0))}var e=function(a,b){this.init(a,b)};$.extend(e.prototype,{change:function(a,b){var c=new $.Event(a+".queryBuilder.filter",{builder:this,value:b});return this.$el.triggerHandler(c,Array.prototype.slice.call(arguments,2)),c.value},trigger:function(a){var b=new $.Event(a+".queryBuilder",{builder:this});return this.$el.triggerHandler(b,Array.prototype.slice.call(arguments,1)),b},on:function(a,b){return this.$el.on(a+".queryBuilder",b),this},off:function(a,b){return this.$el.off(a+".queryBuilder",b),this},once:function(a,b){return this.$el.one(a+".queryBuilder",b),this}}),e.plugins={},e.defaults=function(a){return"object"!=typeof a?"string"==typeof a?"object"==typeof e.DEFAULTS[a]?$.extend(!0,{},e.DEFAULTS[a]):e.DEFAULTS[a]:$.extend(!0,{},e.DEFAULTS):void $.extendext(!0,"replace",e.DEFAULTS,a)},e.define=function(a,b,c){e.plugins[a]={fct:b,def:c||{}}},e.extend=function(a){$.extend(e.prototype,a)},e.prototype.initPlugins=function(){if(this.plugins){if($.isArray(this.plugins)){var a={};this.plugins.forEach(function(b){a[b]=null}),this.plugins=a}Object.keys(this.plugins).forEach(function(a){a in e.plugins?(this.plugins[a]=$.extend(!0,{},e.plugins[a].def,this.plugins[a]||{}),e.plugins[a].fct.call(this,this.plugins[a])):j.error('Unable to find plugin "{0}"',a)},this)}},e.types={string:"string",integer:"number","double":"number",date:"datetime",time:"datetime",datetime:"datetime","boolean":"boolean"},e.inputs=["text","textarea","radio","checkbox","select"],e.modifiable_options=["display_errors","allow_groups","allow_empty"];var f=e.selectors={group_container:".rules-group-container",rule_container:".rule-container",filter_container:".rule-filter-container",operator_container:".rule-operator-container",value_container:".rule-value-container",error_container:".error-container",condition_container:".group-conditions",rule_header:".rule-header",group_header:".rules-group-header",group_actions:".group-actions",rule_actions:".rule-actions",rules_list:".rules-group-body>.rules-list",group_condition:".rules-group-header [name$=_cond]",rule_filter:".rule-filter-container [name$=_filter]",rule_operator:".rule-operator-container [name$=_operator]",rule_value:".rule-value-container [name*=_value_]",add_rule:"[data-add=rule]",delete_rule:"[data-delete=rule]",add_group:"[data-add=group]",delete_group:"[data-delete=group]"};e.templates={},e.regional={},e.DEFAULTS={filters:[],plugins:[],display_errors:!0,allow_groups:-1,allow_empty:!1,conditions:["AND","OR"],default_condition:"AND",inputs_separator:" , ",select_placeholder:"------",optgroups:{},default_rule_flags:{filter_readonly:!1,operator_readonly:!1,value_readonly:!1,no_delete:!1},templates:{group:null,rule:null,filterSelect:null,operatorSelect:null},lang_code:"en",lang:{},operators:[{type:"equal",nb_inputs:1,multiple:!1,apply_to:["string","number","datetime","boolean"]},{type:"not_equal",nb_inputs:1,multiple:!1,apply_to:["string","number","datetime","boolean"]},{type:"in",nb_inputs:1,multiple:!0,apply_to:["string","number","datetime"]},{type:"not_in",nb_inputs:1,multiple:!0,apply_to:["string","number","datetime"]},{type:"less",nb_inputs:1,multiple:!1,apply_to:["number","datetime"]},{type:"less_or_equal",nb_inputs:1,multiple:!1,apply_to:["number","datetime"]},{type:"greater",nb_inputs:1,multiple:!1,apply_to:["number","datetime"]},{type:"greater_or_equal",nb_inputs:1,multiple:!1,apply_to:["number","datetime"]},{type:"between",nb_inputs:2,multiple:!1,apply_to:["number","datetime"]},{type:"not_between",nb_inputs:2,multiple:!1,apply_to:["number","datetime"]},{type:"begins_with",nb_inputs:1,multiple:!1,apply_to:["string"]},{type:"not_begins_with",nb_inputs:1,multiple:!1,apply_to:["string"]},{type:"contains",nb_inputs:1,multiple:!1,apply_to:["string"]},{type:"not_contains",nb_inputs:1,multiple:!1,apply_to:["string"]},{type:"ends_with",nb_inputs:1,multiple:!1,apply_to:["string"]},{type:"not_ends_with",nb_inputs:1,multiple:!1,apply_to:["string"]},{type:"is_empty",nb_inputs:0,multiple:!1,apply_to:["string"]},{type:"is_not_empty",nb_inputs:0,multiple:!1,apply_to:["string"]},{type:"is_null",nb_inputs:0,multiple:!1,apply_to:["string","number","datetime","boolean"]},{type:"is_not_null",nb_inputs:0,multiple:!1,apply_to:["string","number","datetime","boolean"]}],icons:{add_group:"glyphicon glyphicon-plus-sign",add_rule:"glyphicon glyphicon-plus",remove_group:"glyphicon glyphicon-remove",remove_rule:"glyphicon glyphicon-remove",error:"glyphicon glyphicon-warning-sign"}},e.prototype.init=function(c,d){c[0].queryBuilder=this,this.$el=c,this.settings=$.extendext(!0,"replace",{},e.DEFAULTS,d),this.model=new b,this.status={group_id:0,rule_id:0,generated_id:!1,has_optgroup:!1,id:null,updating_value:!1},this.settings.allow_groups===!1?this.settings.allow_groups=0:this.settings.allow_groups===!0&&(this.settings.allow_groups=-1),this.filters=this.settings.filters,this.icons=this.settings.icons,this.operators=this.settings.operators,this.templates=this.settings.templates,this.plugins=this.settings.plugins,void 0===e.regional.en&&j.error('"i18n/en.js" not loaded.'),this.lang=$.extendext(!0,"replace",{},e.regional.en,e.regional[this.settings.lang_code],this.settings.lang),Object.keys(this.templates).forEach(function(b){this.templates[b]||(this.templates[b]=e.templates[b]),"string"==typeof this.templates[b]&&(this.templates[b]=a.template(this.templates[b]))},this),this.$el.attr("id")||(this.$el.attr("id","qb_"+Math.floor(99999*Math.random())),this.status.generated_id=!0),this.status.id=this.$el.attr("id"),this.$el.addClass("query-builder form-inline"),this.filters=this.checkFilters(this.filters),this.bindEvents(),this.initPlugins(),this.trigger("afterInit"),d.rules?(this.setRules(d.rules),delete this.settings.rules):this.setRoot(!0)},e.prototype.checkFilters=function(a){var b=[];if(a&&0!==a.length||j.error("Missing filters list"),a.forEach(function(a,c){switch(a.id||j.error("Missing filter {0} id",c),-1!=b.indexOf(a.id)&&j.error('Filter "{0}" already defined',a.id),b.push(a.id),a.type?e.types[a.type]||j.error('Invalid type "{0}"',a.type):a.type="string",a.input?"function"!=typeof a.input&&-1==e.inputs.indexOf(a.input)&&j.error('Invalid input "{0}"',a.input):a.input="text",a.field||(a.field=a.id),a.label||(a.label=a.field),a.optgroup?(this.status.has_optgroup=!0,this.settings.optgroups[a.optgroup]||(this.settings.optgroups[a.optgroup]=a.optgroup)):a.optgroup=null,a.input){case"radio":case"checkbox":(!a.values||a.values.length<1)&&j.error('Missing filter "{0}" values',a.id);break;case"select":a.placeholder&&(void 0===a.placeholder_value&&(a.placeholder_value=-1),j.iterateOptions(a.values,function(b){b==a.placeholder_value&&j.error('Placeholder of filter "{0}" overlaps with one of its values',a.id)}))}},this),this.status.has_optgroup){var c=[],d=[];a.forEach(function(a){var b;a.optgroup?(b=c.lastIndexOf(a.optgroup),-1==b?b=c.length:b++):b=c.length,c.splice(b,0,a.optgroup),d.splice(b,0,a)}),a=d}return a},e.prototype.bindEvents=function(){var a=this;this.$el.on("change.queryBuilder",f.group_condition,function(){if($(this).is(":checked")){var a=$(this).closest(f.group_container);b(a).condition=$(this).val()}}),this.$el.on("change.queryBuilder",f.rule_filter,function(){var c=$(this).closest(f.rule_container);b(c).filter=a.getFilterById($(this).val())}),this.$el.on("change.queryBuilder",f.rule_operator,function(){var c=$(this).closest(f.rule_container);b(c).operator=a.getOperatorByType($(this).val())}),this.$el.on("click.queryBuilder",f.add_rule,function(){var c=$(this).closest(f.group_container);a.addRule(b(c))}),this.$el.on("click.queryBuilder",f.delete_rule,function(){var c=$(this).closest(f.rule_container);a.deleteRule(b(c))}),0!==this.settings.allow_groups&&(this.$el.on("click.queryBuilder",f.add_group,function(){var c=$(this).closest(f.group_container);a.addGroup(b(c))}),this.$el.on("click.queryBuilder",f.delete_group,function(){var c=$(this).closest(f.group_container);a.deleteGroup(b(c))})),this.model.on({drop:function(a,b){b.$el.remove()},add:function(a,b,c){b.$el.detach(),0===c?b.$el.prependTo(b.parent.$el.find(">"+f.rules_list)):b.$el.insertAfter(b.parent.rules[c-1].$el)},update:function(b,c,d,e,f){switch(d){case"error":a.displayError(c);break;case"condition":a.updateGroupCondition(c);break;case"filter":a.updateRuleFilter(c);break;case"operator":a.updateRuleOperator(c,f);break;case"flags":a.applyRuleFlags(c);break;case"value":a.updateRuleValue(c)}}})},e.prototype.setRoot=function(a,b){a=void 0===a||a===!0;var c=this.nextGroupId(),d=$(this.getGroupTemplate(c,1));return this.$el.append(d),this.model.root=new h(null,d),this.model.root.model=this.model,this.model.root.condition=this.settings.default_condition,void 0!==b&&(this.model.root.data=b),a&&this.addRule(this.model.root),this.model.root},e.prototype.addGroup=function(a,b,c){b=void 0===b||b===!0;var d=a.level+1,e=this.trigger("beforeAddGroup",a,b,d);if(e.isDefaultPrevented())return null;var f=this.nextGroupId(),g=$(this.getGroupTemplate(f,d)),h=a.addGroup(g);return void 0!==c&&(h.data=c),this.trigger("afterAddGroup",h),h.condition=this.settings.default_condition,b&&this.addRule(h),h},e.prototype.deleteGroup=function(a){if(a.isRoot())return!1;var b=this.trigger("beforeDeleteGroup",a);if(b.isDefaultPrevented())return!1;var c=!0;return a.each("reverse",function(a){c&=this.deleteRule(a)},function(a){c&=this.deleteGroup(a)},this),c&&(a.drop(),this.trigger("afterDeleteGroup")),c},e.prototype.updateGroupCondition=function(a){a.$el.find(">"+f.group_condition).each(function(){var b=$(this);b.prop("checked",b.val()===a.condition),b.parent().toggleClass("active",b.val()===a.condition)}),this.trigger("afterUpdateGroupCondition",a)},e.prototype.addRule=function(a,b){var c=this.trigger("beforeAddRule",a);if(c.isDefaultPrevented())return null;var d=this.nextRuleId(),e=$(this.getRuleTemplate(d)),f=a.addRule(e);return void 0!==b&&(f.data=b),this.trigger("afterAddRule",f),this.createRuleFilters(f),f},e.prototype.deleteRule=function(a){if(a.flags.no_delete)return!1;var b=this.trigger("beforeDeleteRule",a);return b.isDefaultPrevented()?!1:(a.drop(),this.trigger("afterDeleteRule"),!0)},e.prototype.createRuleFilters=function(a){var b=this.change("getRuleFilters",this.filters,a),c=$(this.getRuleFilterSelect(a,b));a.$el.find(f.filter_container).html(c),this.trigger("afterCreateRuleFilters",a)},e.prototype.createRuleOperators=function(a){var b=a.$el.find(f.operator_container).empty();if(a.filter){var c=this.getOperators(a.filter),d=$(this.getRuleOperatorSelect(a,c));b.html(d),a.__.operator=c[0],this.trigger("afterCreateRuleOperators",a,c)}},e.prototype.createRuleInput=function(a){var b=a.$el.find(f.value_container).empty();if(a.__.value=void 0,a.filter&&a.operator&&0!==a.operator.nb_inputs){for(var c=this,d=$(),e=a.filter,g=0;g<a.operator.nb_inputs;g++){var h=$(this.getRuleInput(a,g));g>0&&b.append(this.settings.inputs_separator),b.append(h),d=d.add(h)}b.show(),d.on("change",function(){c.status.updating_value=!0,a.value=c.getRuleValue(a),c.status.updating_value=!1}),e.plugin&&d[e.plugin](e.plugin_config||{}),this.trigger("afterCreateRuleInput",a),void 0!==e.default_value?a.value=e.default_value:(c.status.updating_value=!0,a.value=c.getRuleValue(a),c.status.updating_value=!1)}},e.prototype.updateRuleFilter=function(a){this.createRuleOperators(a),this.createRuleInput(a),a.$el.find(f.rule_filter).val(a.filter?a.filter.id:"-1"),this.trigger("afterUpdateRuleFilter",a)},e.prototype.updateRuleOperator=function(a,b){var c=a.$el.find(f.value_container);a.operator&&0!==a.operator.nb_inputs?(c.show(),(c.is(":empty")||a.operator.nb_inputs!==b.nb_inputs)&&this.createRuleInput(a)):(c.hide(),a.__.value=void 0),a.operator&&a.$el.find(f.rule_operator).val(a.operator.type),this.trigger("afterUpdateRuleOperator",a)},e.prototype.updateRuleValue=function(a){this.status.updating_value||this.setRuleValue(a,a.value),this.trigger("afterUpdateRuleValue",a)},e.prototype.applyRuleFlags=function(a){var b=a.flags;b.filter_readonly&&a.$el.find(f.rule_filter).prop("disabled",!0),b.operator_readonly&&a.$el.find(f.rule_operator).prop("disabled",!0),b.value_readonly&&a.$el.find(f.rule_value).prop("disabled",!0),b.no_delete&&a.$el.find(f.delete_rule).remove(),this.trigger("afterApplyRuleFlags",a)},e.prototype.clearErrors=function(a){a=a||this.model.root,a&&(a.error=null,a instanceof h&&a.each(function(a){a.error=null},function(a){this.clearErrors(a)},this))},e.prototype.displayError=function(a){if(this.settings.display_errors)if(null===a.error)a.$el.removeClass("has-error");else{var b=$.extend([],a.error,[this.lang.errors[a.error[0]]||a.error[0]]);a.$el.addClass("has-error").find(f.error_container).eq(0).attr("title",j.fmt.apply(null,b))}},e.prototype.triggerValidationError=function(a,b,c){$.isArray(b)||(b=[b]);var d=this.trigger("validationError",a,b,c);d.isDefaultPrevented()||(a.error=b)},e.prototype.destroy=function(){this.trigger("beforeDestroy"),this.status.generated_id&&this.$el.removeAttr("id"),this.clear(),this.model=null,this.$el.off(".queryBuilder").removeClass("query-builder").removeData("queryBuilder"),delete this.$el[0].queryBuilder},e.prototype.reset=function(){this.status.group_id=1,this.status.rule_id=0,this.model.root.empty(),this.addRule(this.model.root),this.trigger("afterReset")},e.prototype.clear=function(){this.status.group_id=0,this.status.rule_id=0,this.model.root&&(this.model.root.drop(),this.model.root=null),this.trigger("afterClear")},e.prototype.setOptions=function(a){$.makeArray($(Object.keys(a)).filter(e.modifiable_options)).forEach(function(b){this.settings[b]=a[b]},this)},e.prototype.getModel=function(a){return a?b(a):this.model.root},e.prototype.validate=function(){this.clearErrors();var a=this,b=function c(b){var d=0,e=0;return b.each(function(b){if(!b.filter)return a.triggerValidationError(b,"no_filter",null),void e++;if(0!==b.operator.nb_inputs){var c=a.validateValue(b,b.value);if(c!==!0)return a.triggerValidationError(b,c,b.value),void e++}d++},function(a){c(a)?d++:e++}),e>0?!1:0!==d||a.settings.allow_empty&&b.isRoot()?!0:(a.triggerValidationError(b,"empty_group",null),!1)}(this.model.root);return this.change("validate",b)},e.prototype.getRules=function(){if(!this.validate())return{};var a=function b(a){var c={condition:a.condition,rules:[]};return a.data&&(c.data=$.extendext(!0,"replace",{},a.data)),a.each(function(a){var b=null;0!==a.operator.nb_inputs&&(b=a.value);var d={id:a.filter.id,field:a.filter.field,type:a.filter.type,input:a.filter.input,operator:a.operator.type,value:b};(a.filter.data||a.data)&&(d.data=$.extendext(!0,"replace",{},a.filter.data,a.data)),c.rules.push(d)},function(a){c.rules.push(b(a))}),c}(this.model.root);return this.change("getRules",a)},e.prototype.setRules=function(a){$.isArray(a)&&(a={condition:this.settings.default_condition,rules:a}),a&&a.rules&&(0!==a.rules.length||this.settings.allow_empty)||j.error("Incorrect data object passed"),this.clear(),this.setRoot(!1,a.data),a=this.change("setRules",a);var b=this;!function c(a,d){null!==d&&(void 0===a.condition?a.condition=b.settings.default_condition:-1==b.settings.conditions.indexOf(a.condition)&&j.error('Invalid condition "{0}"',a.condition),d.condition=a.condition,a.rules.forEach(function(a){var e;if(a.rules&&a.rules.length>0)-1!=b.settings.allow_groups&&b.settings.allow_groups<d.level?(b.reset(),j.error("No more than {0} groups are allowed",b.settings.allow_groups)):(e=b.addGroup(d,!1,a.data),c(a,e));else{if(void 0===a.id&&j.error("Missing rule field id"),void 0===a.operator&&(a.operator="equal"),e=b.addRule(d,a.data),null===e)return;e.filter=b.getFilterById(a.id),e.operator=b.getOperatorByType(a.operator),e.flags=b.parseRuleFlags(a),0!==e.operator.nb_inputs&&void 0!==a.value&&(e.value=a.value)}}))}(a,this.model.root)},e.prototype.validateValue=function(a,b){var c=a.filter.validation||{},d=!0;return d=c.callback?c.callback.call(this,b,a):this.validateValueInternal(a,b),this.change("validateValue",d,b,a)},e.prototype.validateValueInternal=function(a,b){var c,d=a.filter,f=a.operator,g=d.validation||{},h=!0;b=1===a.operator.nb_inputs?[b]:b;for(var i=0;i<f.nb_inputs;i++){switch(d.input){case"radio":if(void 0===b[i]){h=["radio_empty"];break}break;case"checkbox":if(void 0===b[i]||0===b[i].length){h=["checkbox_empty"];break}if(!f.multiple&&b[i].length>1){h=["operator_not_multiple",this.lang[f.type]||f.type];break}break;case"select":if(d.multiple){if(void 0===b[i]||0===b[i].length||d.placeholder&&b[i]==d.placeholder_value){h=["select_empty"];break}if(!f.multiple&&b[i].length>1){h=["operator_not_multiple",this.lang[f.type]||f.type];break}}else if(void 0===b[i]||d.placeholder&&b[i]==d.placeholder_value){h=["select_empty"];break}break;default:switch(e.types[d.type]){case"string":if(void 0===b[i]||0===b[i].length){h=["string_empty"];break}if(void 0!==g.min&&b[i].length<parseInt(g.min)){h=["string_exceed_min_length",g.min];break}if(void 0!==g.max&&b[i].length>parseInt(g.max)){h=["string_exceed_max_length",g.max];break}if(g.format&&("string"==typeof g.format&&(g.format=new RegExp(g.format)),!g.format.test(b[i]))){h=["string_invalid_format",g.format];break}break;case"number":if(void 0===b[i]||isNaN(b[i])){h=["number_nan"];break}if("integer"==d.type){if(parseInt(b[i])!=b[i]){h=["number_not_integer"];break}}else if(parseFloat(b[i])!=b[i]){h=["number_not_double"];break}if(void 0!==g.min&&b[i]<parseFloat(g.min)){h=["number_exceed_min",g.min];break}if(void 0!==g.max&&b[i]>parseFloat(g.max)){h=["number_exceed_max",g.max];break}if(void 0!==g.step&&"any"!==g.step){var k=b[i]/g.step;if(parseInt(k)!=k){h=["number_wrong_step",g.step];break}}break;case"datetime":if(void 0===b[i]||0===b[i].length){h=["datetime_empty"];break}if(g.format){"moment"in window||j.error("MomentJS is required for Date/Time validation. Get it here http://momentjs.com");var l=moment(b[i],g.format);if(!l.isValid()){h=["datetime_invalid"];break}if(g.min&&l<moment(g.min,g.format)){h=["datetime_exceed_min",g.min];break}if(g.max&&l>moment(g.max,g.format)){h=["datetime_exceed_max",g.max];break}}break;case"boolean":if(c=b[i].trim().toLowerCase(),"true"!==c&&"false"!==c&&"1"!==c&&"0"!==c&&1!==b[i]&&0!==b[i]){h=["boolean_not_valid"];break}}}if(h!==!0)break}return h},e.prototype.nextGroupId=function(){return this.status.id+"_group_"+this.status.group_id++},e.prototype.nextRuleId=function(){return this.status.id+"_rule_"+this.status.rule_id++},e.prototype.getOperators=function(a){"string"==typeof a&&(a=this.getFilterById(a));for(var b=[],c=0,d=this.operators.length;d>c;c++){if(a.operators){if(-1==a.operators.indexOf(this.operators[c].type))continue}else if(-1==this.operators[c].apply_to.indexOf(e.types[a.type]))continue;b.push(this.operators[c])}return a.operators&&b.sort(function(b,c){return a.operators.indexOf(b.type)-a.operators.indexOf(c.type)}),this.change("getOperators",b,a)},e.prototype.getFilterById=function(a){if("-1"==a)return null;for(var b=0,c=this.filters.length;c>b;b++)if(this.filters[b].id==a)return this.filters[b];j.error('Undefined filter "{0}"',a)},e.prototype.getOperatorByType=function(a){if("-1"==a)return null;for(var b=0,c=this.operators.length;c>b;b++)if(this.operators[b].type==a)return this.operators[b];j.error('Undefined operator  "{0}"',a)},e.prototype.getRuleValue=function(a){var b=a.filter,c=a.operator,d=[];if(b.valueGetter)d=b.valueGetter.call(this,a);else{for(var e,g=a.$el.find(f.value_container),h=0;h<c.nb_inputs;h++){var i=a.id+"_value_"+h;switch(b.input){case"radio":d.push(g.find("[name="+i+"]:checked").val());break;case"checkbox":e=[],g.find("[name="+i+"]:checked").each(function(){e.push($(this).val())}),d.push(e);break;case"select":b.multiple?(e=[],g.find("[name="+i+"] option:selected").each(function(){e.push($(this).val())}),d.push(e)):d.push(g.find("[name="+i+"] option:selected").val());break;default:d.push(g.find("[name="+i+"]").val())}}1===c.nb_inputs&&(d=d[0]),b.valueParser&&(d=b.valueParser.call(this,a,d))}return this.change("getRuleValue",d,a)},e.prototype.setRuleValue=function(a,b){var c=a.filter,d=a.operator;if(c.valueSetter)c.valueSetter.call(this,a,b);else{var e=a.$el.find(f.value_container);b=1==d.nb_inputs?[b]:b;for(var g=0;g<d.nb_inputs;g++){var h=a.id+"_value_"+g;switch(c.input){case"radio":e.find("[name="+h+'][value="'+b[g]+'"]').prop("checked",!0).trigger("change");break;case"checkbox":$.isArray(b[g])||(b[g]=[b[g]]),b[g].forEach(function(a){e.find("[name="+h+'][value="'+a+'"]').prop("checked",!0).trigger("change")});break;default:e.find("[name="+h+"]").val(b[g]).trigger("change")}}}},e.prototype.parseRuleFlags=function(a){var b=$.extend({},this.settings.default_rule_flags);return a.readonly&&$.extend(b,{filter_readonly:!0,operator_readonly:!0,value_readonly:!0,no_delete:!0}),a.flags&&$.extend(b,a.flags),this.change("parseRuleFlags",b,a)},e.prototype.translateLabel=function(a){return"string"==typeof a?a:a[this.settings.lang_code]||a.en},e.templates.group='<dl id="{{= it.group_id }}" class="rules-group-container">   <dt class="rules-group-header">     <div class="btn-group pull-right group-actions">       <button type="button" class="btn btn-xs btn-success" data-add="rule">         <i class="{{= it.icons.add_rule }}"></i> {{= it.lang.add_rule }}       </button>       {{? it.settings.allow_groups===-1 || it.settings.allow_groups>=it.level }}         <button type="button" class="btn btn-xs btn-success" data-add="group">           <i class="{{= it.icons.add_group }}"></i> {{= it.lang.add_group }}         </button>       {{?}}       {{? it.level>1 }}         <button type="button" class="btn btn-xs btn-danger" data-delete="group">           <i class="{{= it.icons.remove_group }}"></i> {{= it.lang.delete_group }}         </button>       {{?}}     </div>     <div class="btn-group group-conditions">       {{~ it.conditions: condition }}         <label class="btn btn-xs btn-primary">           <input type="radio" name="{{= it.group_id }}_cond" value="{{= condition }}"> {{= it.lang.conditions[condition] || condition }}         </label>       {{~}}     </div>     {{? it.settings.display_errors }}       <div class="error-container"><i class="{{= it.icons.error }}"></i></div>     {{?}}   </dt>   <dd class=rules-group-body>     <ul class=rules-list></ul>   </dd> </dl>',e.templates.rule='<li id="{{= it.rule_id }}" class="rule-container">   <div class="rule-header">     <div class="btn-group pull-right rule-actions">       <button type="button" class="btn btn-xs btn-danger" data-delete="rule">         <i class="{{= it.icons.remove_rule }}"></i> {{= it.lang.delete_rule }}       </button>     </div>   </div>   {{? it.settings.display_errors }}     <div class="error-container"><i class="{{= it.icons.error }}"></i></div>   {{?}}   <div class="rule-filter-container"></div>   <div class="rule-operator-container"></div>   <div class="rule-value-container"></div> </li>',e.templates.filterSelect='{{ var optgroup = null; }} <select class="form-control" name="{{= it.rule.id }}_filter">   <option value="-1">{{= it.settings.select_placeholder }}</option>   {{~ it.filters: filter }}     {{? optgroup !== filter.optgroup }}       {{? optgroup !== null }}</optgroup>{{?}}       {{? (optgroup = filter.optgroup) !== null}}         <optgroup label="{{= it.translate(it.settings.optgroups[optgroup]) }}">       {{?}}     {{?}}     <option value="{{= filter.id }}">{{= it.translate(filter.label) }}</option>   {{~}}   {{? optgroup !== null }}</optgroup>{{?}} </select>',e.templates.operatorSelect='<select class="form-control" name="{{= it.rule.id }}_operator">   {{~ it.operators: operator }}     <option value="{{= operator.type }}">{{= it.lang.operators[operator.type] || operator.type }}</option>   {{~}} </select>',e.prototype.getGroupTemplate=function(a,b){var c=this.templates.group({builder:this,group_id:a,level:b,conditions:this.settings.conditions,icons:this.icons,lang:this.lang,settings:this.settings});return this.change("getGroupTemplate",c,b)},e.prototype.getRuleTemplate=function(a){var b=this.templates.rule({builder:this,rule_id:a,icons:this.icons,lang:this.lang,settings:this.settings});return this.change("getRuleTemplate",b)},e.prototype.getRuleFilterSelect=function(a,b){var c=this.templates.filterSelect({builder:this,rule:a,filters:b,icons:this.icons,lang:this.lang,settings:this.settings,translate:this.translateLabel});return this.change("getRuleFilterSelect",c,a)},e.prototype.getRuleOperatorSelect=function(a,b){var c=this.templates.operatorSelect({builder:this,rule:a,operators:b,icons:this.icons,lang:this.lang,settings:this.settings});return this.change("getRuleOperatorSelect",c,a)},e.prototype.getRuleInput=function(a,b){var c=a.filter,d=a.filter.validation||{},f=a.id+"_value_"+b,g=c.vertical?" class=block":"",h="";if("function"==typeof c.input)h=c.input.call(this,a,f);else switch(c.input){case"radio":case"checkbox":j.iterateOptions(c.values,function(a,b){h+="<label"+g+'><input type="'+c.input+'" name="'+f+'" value="'+a+'"> '+b+"</label> "});break;case"select":h+='<select class="form-control" name="'+f+'"'+(c.multiple?" multiple":"")+">",c.placeholder&&(h+='<option value="'+c.placeholder_value+'" disabled selected>'+c.placeholder+"</option>"),j.iterateOptions(c.values,function(a,b){h+='<option value="'+a+'">'+b+"</option> "}),h+="</select>";break;case"textarea":h+='<textarea class="form-control" name="'+f+'"',c.size&&(h+=' cols="'+c.size+'"'),c.rows&&(h+=' rows="'+c.rows+'"'),void 0!==d.min&&(h+=' minlength="'+d.min+'"'),void 0!==d.max&&(h+=' maxlength="'+d.max+'"'),c.placeholder&&(h+=' placeholder="'+c.placeholder+'"'),h+="></textarea>";break;default:switch(e.types[c.type]){case"number":h+='<input class="form-control" type="number" name="'+f+'"',void 0!==d.step&&(h+=' step="'+d.step+'"'),void 0!==d.min&&(h+=' min="'+d.min+'"'),void 0!==d.max&&(h+=' max="'+d.max+'"'),c.placeholder&&(h+=' placeholder="'+c.placeholder+'"'),c.size&&(h+=' size="'+c.size+'"'),h+=">";break;default:h+='<input class="form-control" type="text" name="'+f+'"',c.placeholder&&(h+=' placeholder="'+c.placeholder+'"'),"string"===c.type&&void 0!==d.min&&(h+=' minlength="'+d.min+'"'),"string"===c.type&&void 0!==d.max&&(h+=' maxlength="'+d.max+'"'),c.size&&(h+=' size="'+c.size+'"'),h+=">"}}return this.change("getRuleInput",h,a,f)},$.extend(b.prototype,{trigger:function(a){return this.$.triggerHandler(a,Array.prototype.slice.call(arguments,1)),this},on:function(){return this.$.on.apply(this.$,Array.prototype.slice.call(arguments)),this},off:function(){return this.$.off.apply(this.$,Array.prototype.slice.call(arguments)),this},once:function(){return this.$.one.apply(this.$,Array.prototype.slice.call(arguments)),this}}),b.getModel=function(a){return a?a instanceof g?a:$(a).data("queryBuilderModel"):null};var g=function(a,b){return this instanceof g?(Object.defineProperty(this,"__",{value:{}}),b.data("queryBuilderModel",this),this.__.level=0,this.__.error=null,this.__.data=void 0,this.$el=b,this.id=b[0].id,this.model=null,void(this.parent=a)):new g};c(g,["level","error","data"]),Object.defineProperty(g.prototype,"parent",{enumerable:!0,get:function(){return this.__.parent},set:function(a){this.__.parent=a,this.level=null===a?1:a.level+1,this.model=null===a?null:a.model}}),g.prototype.isRoot=function(){return 1===this.level},g.prototype.getPos=function(){return this.isRoot()?-1:this.parent.getNodePos(this)},g.prototype.drop=function(){null!==this.model&&this.model.trigger("drop",this),this.isRoot()||(this.parent._dropNode(this),this.parent=null)},g.prototype.moveAfter=function(a){return this.isRoot()?void 0:(this.parent._dropNode(this),a.parent._addNode(this,a.getPos()+1),this)},g.prototype.moveAtBegin=function(a){return this.isRoot()?void 0:(void 0===a&&(a=this.parent),this.parent._dropNode(this),a._addNode(this,0),this)},g.prototype.moveAtEnd=function(a){return this.isRoot()?void 0:(void 0===a&&(a=this.parent),this.parent._dropNode(this),a._addNode(this,a.length()),this)};var h=function(a,b){return this instanceof h?(g.call(this,a,b),this.rules=[],void(this.__.condition=null)):new h(a,b)};h.prototype=Object.create(g.prototype),h.prototype.constructor=h,c(h,["condition"]),h.prototype.empty=function(){this.each("reverse",function(a){a.drop()},function(a){a.drop()})},h.prototype.drop=function(){this.empty(),g.prototype.drop.call(this)},h.prototype.length=function(){return this.rules.length},h.prototype._addNode=function(a,b){return void 0===b&&(b=this.length()),this.rules.splice(b,0,a),a.parent=this,null!==this.model&&this.model.trigger("add",a,b),a},h.prototype.addGroup=function(a,b){return this._addNode(new h(this,a),b)},h.prototype.addRule=function(a,b){return this._addNode(new i(this,a),b)},h.prototype._dropNode=function(a){var b=this.getNodePos(a);return-1!==b&&(a.parent=null,this.rules.splice(b,1)),this},h.prototype.getNodePos=function(a){return this.rules.indexOf(a)},h.prototype.each=function(a,b,c,d){"function"==typeof a&&(d=c,c=b,b=a,a=!1),d=void 0===d?null:d;for(var e=a?this.rules.length-1:0,f=a?0:this.rules.length-1,g=a?-1:1,i=function(){return a?e>=f:f>=e},j=!1;i()&&(this.rules[e]instanceof h?void 0!==c&&(j=c.call(d,this.rules[e])===!1):j=b.call(d,this.rules[e])===!1,!j);e+=g);return!j},h.prototype.contains=function(a,b){return-1!==this.getNodePos(a)?!0:b?!this.each(function(){return!0},function(b){return!b.contains(a,!0)}):!1};var i=function(a,b){return this instanceof i?(g.call(this,a,b),this.__.filter=null,this.__.operator=null,this.__.flags={},void(this.__.value=void 0)):new i(a,b)};i.prototype=Object.create(g.prototype),i.prototype.constructor=i,c(i,["filter","operator","flags","value"]),e.Group=h,e.Rule=i;var j=e.utils={};j.iterateOptions=function(a,b){a&&($.isArray(a)?a.forEach(function(a){$.isPlainObject(a)?$.each(a,function(a,c){return b(a,c),!1}):b(a,a)}):$.each(a,function(a,c){b(a,c)}))},j.fmt=function(a,b){return b=Array.prototype.slice.call(arguments),a.replace(/{([0-9]+)}/g,function(a,c){return b[parseInt(c)+1]})},j.error=function(){$.error(j.fmt.apply(null,arguments))},j.changeType=function(a,b,c){switch(b){case"integer":return parseInt(a);case"double":return parseFloat(a);case"boolean":var d="true"===a.trim().toLowerCase()||"1"===a.trim()||1===a;return c?d?1:0:d;default:return a}},j.escapeString=function(a){return"string"!=typeof a?a:a.replace(/[\0\n\r\b\\\'\"]/g,function(a){switch(a){case"\x00":return"\\0";case"\n":return"\\n";case"\r":return"\\r";case"\b":return"\\b";default:return"\\"+a}}).replace(/\t/g,"\\t").replace(/\x1a/g,"\\Z")},j.escapeRegExp=function(a){return a.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")},$.fn.queryBuilder=function(a){this.length>1&&j.error("Unable to initialize on multiple target");var b=this.data("queryBuilder"),c="object"==typeof a&&a||{};return b||"destroy"!=a?(b||this.data("queryBuilder",new e(this,c)),"string"==typeof a?b[a].apply(b,Array.prototype.slice.call(arguments,1)):this):this},$.fn.queryBuilder.constructor=e,$.fn.queryBuilder.defaults=e.defaults,$.fn.queryBuilder.extend=e.extend,$.fn.queryBuilder.define=e.define,$.fn.queryBuilder.regional=e.regional,e.define("bt-checkbox",function(a){if("glyphicons"==a.font){var b=document.createElement("style");b.innerHTML='.checkbox input[type=checkbox]:checked + label:after {     font-family: "Glyphicons Halflings";     content: "\\e013"; } .checkbox label:after {     padding-left: 4px;     padding-top: 2px;     font-size: 9px; }',
document.body.appendChild(b)}this.on("getRuleInput.filter",function(b,c,d){var e=c.filter;if(("radio"===e.input||"checkbox"===e.input)&&!e.plugin){b.value="",e.colors||(e.colors={}),e.color&&(e.colors._def_=e.color);var f,g,h=e.vertical?' style="display:block"':"",i=0;j.iterateOptions(e.values,function(c,j){f=e.colors[c]||e.colors._def_||a.color,g=d+"_"+i++,b.value+="<div"+h+' class="'+e.input+" "+e.input+"-"+f+'">   <input type="'+e.input+'" name="'+d+'" id="'+g+'" value="'+c+'">   <label for="'+g+'">'+j+"</label> </div>"})}})},{font:"glyphicons",color:"default"}),e.define("bt-selectpicker",function(a){$.fn.selectpicker&&$.fn.selectpicker.Constructor||j.error('Bootstrap Select is required to use "bt-selectpicker" plugin. Get it here: http://silviomoreto.github.io/bootstrap-select'),this.on("afterCreateRuleFilters",function(b,c){c.$el.find(f.rule_filter).removeClass("form-control").selectpicker(a)}),this.on("afterCreateRuleOperators",function(b,c){c.$el.find(f.rule_operator).removeClass("form-control").selectpicker(a)}),this.on("afterUpdateRuleFilter",function(a,b){b.$el.find(f.rule_filter).selectpicker("render")}),this.on("afterUpdateRuleOperator",function(a,b){b.$el.find(f.rule_operator).selectpicker("render")})},{container:"body",style:"btn-inverse btn-xs",width:"auto",showIcon:!1}),e.define("bt-tooltip-errors",function(a){$.fn.tooltip&&$.fn.tooltip.Constructor&&$.fn.tooltip.Constructor.prototype.fixTitle||j.error('Bootstrap Tooltip is required to use "bt-tooltip-errors" plugin. Get it here: http://getbootstrap.com');var b=this;this.on("getRuleTemplate.filter getGroupTemplate.filter",function(a){var b=$(a.value);b.find(f.error_container).attr("data-toggle","tooltip"),a.value=b.prop("outerHTML")}),this.model.on("update",function(c,d,e){"error"==e&&b.settings.display_errors&&d.$el.find(f.error_container).eq(0).tooltip(a).tooltip("hide").tooltip("fixTitle")})},{placement:"right"}),e.extend({setFilters:function(a,b){var c=this;void 0===b&&(b=a,a=!1),b=this.checkFilters(b);var d=b.map(function(a){return a.id});a||!function e(a){a.each(function(a){a.filter&&-1===d.indexOf(a.filter.id)&&j.error('A rule is using filter "{0}"',a.filter.id)},e)}(this.model.root),this.filters=b,function g(a){a.each(!0,function(a){a.filter&&-1===d.indexOf(a.filter.id)?a.drop():(c.createRuleFilters(a),a.$el.find(f.rule_filter).val(a.filter?a.filter.id:"-1"))},g)}(this.model.root),c.settings.plugins&&(c.settings.plugins["unique-filter"]?this.updateDisabledFilters():this.settings.plugins["bt-selectpicker"]&&this.$el.find(f.rule_filter).selectpicker("render"))},addFilter:function(a,b){void 0===b||"#end"==b?b=this.filters.length:"#start"==b&&(b=0);var c=$.extend(!0,[],this.filters);parseInt(b)==b?c.splice(b,0,a):this.filters.some(function(a,c){return a.id==b?(b=c+1,!0):void 0})?c.splice(b,0,a):c.push(a),this.setFilters(c)},removeFilter:function(a,b){var c=$.extend(!0,[],this.filters);c=c.filter(function(b){return b.id!=a}),this.setFilters(b,c)}}),e.define("filter-description",function(a){"inline"===a.mode?this.on("afterUpdateRuleFilter",function(b,c){var d=c.$el.find("p.filter-description");c.filter&&c.filter.description?(0===d.length?(d=$('<p class="filter-description"></p>'),d.appendTo(c.$el)):d.show(),d.html('<i class="'+a.icon+'"></i> '+c.filter.description)):d.hide()}):"popover"===a.mode?($.fn.popover&&$.fn.popover.Constructor&&$.fn.popover.Constructor.prototype.fixTitle||j.error('Bootstrap Popover is required to use "filter-description" plugin. Get it here: http://getbootstrap.com'),this.on("afterUpdateRuleFilter",function(b,c){var d=c.$el.find("button.filter-description");c.filter&&c.filter.description?(0===d.length?(d=$('<button type="button" class="btn btn-xs btn-info filter-description" data-toggle="popover"><i class="'+a.icon+'"></i></button>'),d.prependTo(c.$el.find(f.rule_actions)),d.popover({placement:"left",container:"body",html:!0}),d.on("mouseout",function(){d.popover("hide")})):d.show(),d.data("bs.popover").options.content=c.filter.description,d.attr("aria-describedby")&&d.popover("show")):(d.hide(),d.data("bs.popover")&&d.popover("hide"))})):"bootbox"===a.mode&&("bootbox"in window||j.error('Bootbox is required to use "filter-description" plugin. Get it here: http://bootboxjs.com'),this.on("afterUpdateRuleFilter",function(b,c){var d=c.$el.find("button.filter-description");c.filter&&c.filter.description?(0===d.length&&(d=$('<button type="button" class="btn btn-xs btn-info filter-description" data-toggle="bootbox"><i class="'+a.icon+'"></i></button>'),d.prependTo(c.$el.find(f.rule_actions)),d.on("click",function(){bootbox.alert(d.data("description"))})),d.data("description",c.filter.description)):d.hide()}))},{icon:"glyphicon glyphicon-info-sign",mode:"popover"}),e.defaults({operatorOpposites:{equal:"not_equal",not_equal:"equal","in":"not_in",not_in:"in",less:"greater_or_equal",less_or_equal:"greater",greater:"less_or_equal",greater_or_equal:"less",between:"not_between",not_between:"between",begins_with:"not_begins_with",not_begins_with:"begins_with",contains:"not_contains",not_contains:"contains",ends_with:"not_ends_with",not_ends_with:"ends_with",is_empty:"is_not_empty",is_not_empty:"is_empty",is_null:"is_not_null",is_not_null:"is_null"},conditionOpposites:{AND:"OR",OR:"AND"}}),e.define("invert",function(a){var c=this;this.on("afterInit",function(){c.$el.on("click.queryBuilder","[data-invert=group]",function(){var d=$(this).closest(f.group_container);c.invert(b(d),a)}),a.display_rules_button&&a.invert_rules&&c.$el.on("click.queryBuilder","[data-invert=rule]",function(){var d=$(this).closest(f.rule_container);c.invert(b(d),a)})}),this.on("getGroupTemplate.filter",function(b){var d=$(b.value);d.find(f.condition_container).after('<button type="button" class="btn btn-xs btn-default" data-invert="group"><i class="'+a.icon+'"></i> '+c.lang.invert+"</button>"),b.value=d.prop("outerHTML")}),a.display_rules_button&&a.invert_rules&&this.on("getRuleTemplate.filter",function(b){var d=$(b.value);d.find(f.rule_actions).prepend('<button type="button" class="btn btn-xs btn-default" data-invert="rule"><i class="'+a.icon+'"></i> '+c.lang.invert+"</button>"),b.value=d.prop("outerHTML")})},{icon:"glyphicon glyphicon-random",recursive:!0,invert_rules:!0,display_rules_button:!1,silent_fail:!1}),e.extend({invert:function(a,b){if(!(a instanceof g)){if(!this.model.root)return;b=a,a=this.model.root}if("object"!=typeof b&&(b={}),void 0===b.recursive&&(b.recursive=!0),void 0===b.invert_rules&&(b.invert_rules=!0),void 0===b.silent_fail&&(b.silent_fail=!1),a instanceof h)this.settings.conditionOpposites[a.condition]?a.condition=this.settings.conditionOpposites[a.condition]:b.silent_fail||j.error('Unknown inverse of condition "{0}"',a.condition),b.recursive&&a.each(function(a){b.invert_rules&&this.invert(a,b)},function(a){this.invert(a,b)},this);else if(a instanceof i&&a.operator&&!a.filter.no_invert)if(this.settings.operatorOpposites[a.operator.type]){var c=this.settings.operatorOpposites[a.operator.type];a.filter.operators&&-1==a.filter.operators.indexOf(c)||(a.operator=this.getOperatorByType(c))}else b.silent_fail||j.error('Unknown inverse of operator "{0}"',a.operator.type)}}),e.defaults({mongoOperators:{equal:function(a){return a[0]},not_equal:function(a){return{$ne:a[0]}},"in":function(a){return{$in:a}},not_in:function(a){return{$nin:a}},less:function(a){return{$lt:a[0]}},less_or_equal:function(a){return{$lte:a[0]}},greater:function(a){return{$gt:a[0]}},greater_or_equal:function(a){return{$gte:a[0]}},between:function(a){return{$gte:a[0],$lte:a[1]}},not_between:function(a){return{$lt:a[0],$gt:a[1]}},begins_with:function(a){return{$regex:"^"+j.escapeRegExp(a[0])}},not_begins_with:function(a){return{$regex:"^(?!"+j.escapeRegExp(a[0])+")"}},contains:function(a){return{$regex:j.escapeRegExp(a[0])}},not_contains:function(a){return{$regex:"^((?!"+j.escapeRegExp(a[0])+").)*$",$options:"s"}},ends_with:function(a){return{$regex:j.escapeRegExp(a[0])+"$"}},not_ends_with:function(a){return{$regex:"(?<!"+j.escapeRegExp(a[0])+")$"}},is_empty:function(){return""},is_not_empty:function(){return{$ne:""}},is_null:function(){return null},is_not_null:function(){return{$ne:null}}},mongoRuleOperators:{$ne:function(a){return a=a.$ne,{val:a,op:null===a?"is_not_null":""===a?"is_not_empty":"not_equal"}},eq:function(a){return{val:a,op:null===a?"is_null":""===a?"is_empty":"equal"}},$regex:function(a){return a=a.$regex,"^(?!"==a.slice(0,4)&&")"==a.slice(-1)?{val:a.slice(4,-1),op:"not_begins_with"}:"^((?!"==a.slice(0,5)&&").)*$"==a.slice(-5)?{val:a.slice(5,-5),op:"not_contains"}:"(?<!"==a.slice(0,4)&&")$"==a.slice(-2)?{val:a.slice(4,-2),op:"not_ends_with"}:"$"==a.slice(-1)?{val:a.slice(0,-1),op:"ends_with"}:"^"==a.slice(0,1)?{val:a.slice(1),op:"begins_with"}:{val:a,op:"contains"}},between:function(a){return{val:[a.$gte,a.$lte],op:"between"}},not_between:function(a){return{val:[a.$lt,a.$gt],op:"not_between"}},$in:function(a){return{val:a.$in,op:"in"}},$nin:function(a){return{val:a.$nin,op:"not_in"}},$lt:function(a){return{val:a.$lt,op:"less"}},$lte:function(a){return{val:a.$lte,op:"less_or_equal"}},$gt:function(a){return{val:a.$gt,op:"greater"}},$gte:function(a){return{val:a.$gte,op:"greater_or_equal"}}}}),e.extend({getMongo:function(a){a=void 0===a?this.getRules():a;var b=this;return function c(a){if(a.condition||(a.condition=b.settings.default_condition),-1===["AND","OR"].indexOf(a.condition.toUpperCase())&&j.error('Unable to build MongoDB query with condition "{0}"',a.condition),!a.rules)return{};var d=[];a.rules.forEach(function(a){if(a.rules&&a.rules.length>0)d.push(c(a));else{var e=b.settings.mongoOperators[a.operator],f=b.getOperatorByType(a.operator),g=[];void 0===e&&j.error('Unknown MongoDB operation for operator "{0}"',a.operator),0!==f.nb_inputs&&(a.value instanceof Array||(a.value=[a.value]),a.value.forEach(function(b){g.push(j.changeType(b,a.type,!1))}));var h={};h[a.field]=e.call(b,g),d.push(h)}});var e={};return d.length>0&&(e["$"+a.condition.toLowerCase()]=d),e}(a)},getRulesFromMongo:function(a){if(void 0===a||null===a)return null;var b=this,c=["$and","$or"];return function d(a){var e=Object.keys(a);e.length>1&&j.error("Invalid MongoDB query format."),-1===c.indexOf(e[0].toLowerCase())&&j.error('Unable to build Rule from MongoDB query with condition "{0}"',e[0]);var f=e[0].toLowerCase()===c[0]?"AND":"OR",g=a[e[0]],h=[];g.forEach(function(a){var e=Object.keys(a);if(-1!==c.indexOf(e[0].toLowerCase()))h.push(d(a));else{var f=e[0],g=a[f],i=b.determineMongoOperator(g,f);void 0===i&&j.error("Invalid MongoDB query format.");var k=b.settings.mongoRuleOperators[i];void 0===k&&j.error('JSON Rule operation unknown for operator "{0}"',i);var l=k.call(b,g);h.push({id:b.change("getMongoDBFieldID",f,g),field:f,operator:l.op,value:l.val})}});var i={};return h.length>0&&(i.condition=f,i.rules=h),i}(a)},determineMongoOperator:function(a){if(null!==a&&"object"==typeof a){var b=Object.keys(a);return 1===b.length?b[0]:void 0!==a.$gte&&void 0!==a.$lte?"between":void 0!==a.$lt&&void 0!==a.$gt?"not_between":void 0!==a.$regex?"$regex":void 0}return"eq"},setRulesFromMongo:function(a){this.setRules(this.getRulesFromMongo(a))}}),f.rule_and_group_containers=f.rule_container+", "+f.group_container,e.define("sortable",function(a){this.on("afterInit",function(a){$.event.props.push("dataTransfer");var c,e,g=a.builder;g.$el.on("mouseover",".drag-handle",function(){g.$el.find(f.rule_and_group_containers).attr("draggable",!0)}),g.$el.on("mouseout",".drag-handle",function(){g.$el.find(f.rule_and_group_containers).removeAttr("draggable")}),g.$el.on("dragstart","[draggable]",function(a){a.stopPropagation(),a.dataTransfer.setData("text","drag"),e=b(a.target),setTimeout(function(){var a=$('<div class="rule-placeholder">&nbsp;</div>');a.css("min-height",e.$el.height()),c=e.parent.addRule(a,e.getPos()),e.$el.hide()},0)}),g.$el.on("dragenter","[draggable]",function(a){a.preventDefault(),a.stopPropagation(),c&&d(c,$(a.target))}),g.$el.on("dragover","[draggable]",function(a){a.preventDefault(),a.stopPropagation()}),g.$el.on("drop",function(a){a.preventDefault(),a.stopPropagation(),d(e,$(a.target))}),g.$el.on("dragend","[draggable]",function(a){a.preventDefault(),a.stopPropagation(),e.$el.show(),c.drop(),e=c=null,g.$el.find(f.rule_and_group_containers).removeAttr("draggable")})}),this.on("parseRuleFlags.filter",function(b){void 0===b.value.no_sortable&&(b.value.no_sortable=a.default_no_sortable)}),this.on("afterApplyRuleFlags",function(a,b){b.flags.no_sortable&&b.$el.find(".drag-handle").remove()}),this.on("getGroupTemplate.filter",function(b,c){if(c>1){var d=$(b.value);d.find(f.condition_container).after('<div class="drag-handle"><i class="'+a.icon+'"></i></div>'),b.value=d.prop("outerHTML")}}),this.on("getRuleTemplate.filter",function(b){var c=$(b.value);c.find(f.rule_header).after('<div class="drag-handle"><i class="'+a.icon+'"></i></div>'),b.value=c.prop("outerHTML")})},{default_no_sortable:!1,icon:"glyphicon glyphicon-sort"}),e.defaults({sqlOperators:{equal:{op:"= ?"},not_equal:{op:"!= ?"},"in":{op:"IN(?)",sep:", "},not_in:{op:"NOT IN(?)",sep:", "},less:{op:"< ?"},less_or_equal:{op:"<= ?"},greater:{op:"> ?"},greater_or_equal:{op:">= ?"},between:{op:"BETWEEN ?",sep:" AND "},not_between:{op:"NOT BETWEEN ?",sep:" AND "},begins_with:{op:"LIKE(?)",fn:function(a){return a+"%"}},not_begins_with:{op:"NOT LIKE(?)",fn:function(a){return a+"%"}},contains:{op:"LIKE(?)",fn:function(a){return"%"+a+"%"}},not_contains:{op:"NOT LIKE(?)",fn:function(a){return"%"+a+"%"}},ends_with:{op:"LIKE(?)",fn:function(a){return"%"+a}},not_ends_with:{op:"NOT LIKE(?)",fn:function(a){return"%"+a}},is_empty:{op:"= ''"},is_not_empty:{op:"!= ''"},is_null:{op:"IS NULL"},is_not_null:{op:"IS NOT NULL"}},sqlRuleOperator:{"=":function(a){return{val:a,op:""===a?"is_empty":"equal"}},"!=":function(a){return{val:a,op:""===a?"is_not_empty":"not_equal"}},LIKE:function(a){return"%"==a.slice(0,1)&&"%"==a.slice(-1)?{val:a.slice(1,-1),op:"contains"}:"%"==a.slice(0,1)?{val:a.slice(1),op:"ends_with"}:"%"==a.slice(-1)?{val:a.slice(0,-1),op:"begins_with"}:void j.error("Invalid value for LIKE operator")},IN:function(a){return{val:a,op:"in"}},"NOT IN":function(a){return{val:a,op:"not_in"}},"<":function(a){return{val:a,op:"less"}},"<=":function(a){return{val:a,op:"less_or_equal"}},">":function(a){return{val:a,op:"greater"}},">=":function(a){return{val:a,op:"greater_or_equal"}},BETWEEN:function(a){return{val:a,op:"between"}},"NOT BETWEEN":function(a){return{val:a,op:"not_between"}},IS:function(a){return null!==a&&j.error("Invalid value for IS operator"),{val:null,op:"is_null"}},"IS NOT":function(a){return null!==a&&j.error("Invalid value for IS operator"),{val:null,op:"is_not_null"}}},sqlStatements:{question_mark:function(){var a=[];return{add:function(b,c){return a.push(c),"?"},run:function(){return a}}},numbered:function(){var a=0,b=[];return{add:function(c,d){return b.push(d),a++,"$"+a},run:function(){return b}}},named:function(){var a={},b={};return{add:function(c,d){a[c.field]||(a[c.field]=0),a[c.field]++;var e=c.field+"_"+a[c.field];return b[e]=d,":"+e},run:function(){return b}}}},sqlRuleStatement:{question_mark:function(a){var b=0;return{get:function(c){return $.isArray(c)?c.map(function(c){return"?"==c?a[b++]:c}):"?"==c?a[b++]:c},esc:function(a){return a.replace(/\?/g,"'?'")}}},numbered:function(a){return{get:function(b){return $.isArray(b)?b.map(function(b){return/^\$[0-9]+$/.test(b)?a[b.slice(1)-1]:b}):/^\$[0-9]+$/.test(b)?a[b.slice(1)-1]:b},esc:function(a){return a.replace(/\$([0-9]+)/g,"'$$$1'")}}},named:function(a){return{get:function(b){return $.isArray(b)?b.map(function(b){return/^:/.test(b)?a[b.slice(1)]:b}):/^:/.test(b)?a[b.slice(1)]:b},esc:function(b){return b.replace(new RegExp(":("+Object.keys(a).join("|")+")","g"),"':$1'")}}}}}),e.extend({getSQL:function(a,b,c){c=void 0===c?this.getRules():c,b=b===!0?"\n":" ",(a===!0||void 0===a)&&(a="question_mark"),"string"==typeof a&&(a=this.settings.sqlStatements[a]());var d=this,e=function f(c){if(c.condition||(c.condition=d.settings.default_condition),-1===["AND","OR"].indexOf(c.condition.toUpperCase())&&j.error('Unable to build SQL query with condition "{0}"',c.condition),!c.rules)return"";var e=[];return c.rules.forEach(function(c){if(c.rules&&c.rules.length>0)e.push("("+b+f(c)+b+")"+b);else{var g=d.settings.sqlOperators[c.operator],h=d.getOperatorByType(c.operator),i="";void 0===g&&j.error('Unknown SQL operation for operator "{0}"',c.operator),0!==h.nb_inputs&&(c.value instanceof Array||(c.value=[c.value]),c.value.forEach(function(b,d){d>0&&(i+=g.sep),"integer"==c.type||"double"==c.type||"boolean"==c.type?b=j.changeType(b,c.type,!0):a||(b=j.escapeString(b)),g.fn&&(b=g.fn(b)),a?i+=a.add(c,b):("string"==typeof b&&(b="'"+b+"'"),i+=b)})),e.push(c.field+" "+g.op.replace(/\?/,i))}}),e.join(" "+c.condition+b)}(c);return a?{sql:e,params:a.run()}:{sql:e}},getRulesFromSQL:function(a,b){"SQLParser"in window||j.error("SQLParser is required to parse SQL queries. Get it here https://github.com/forward/sql-parser");var c=this;"string"==typeof a&&(a={sql:a}),"string"==typeof b&&(b=this.settings.sqlRuleStatement[b](a.params),a.sql=b.esc(a.sql)),a.sql.toUpperCase().startsWith("SELECT")||(a.sql="SELECT * FROM table WHERE "+a.sql);var d=SQLParser.parse(a.sql);d.where||j.error("No WHERE clause found");var e={condition:this.settings.default_condition,rules:[]},f=e;return function g(a,d){if(-1!==["AND","OR"].indexOf(a.operation.toUpperCase())){d>0&&f.condition!=a.operation.toUpperCase()&&(f.rules.push({condition:c.settings.default_condition,rules:[]}),f=f.rules[f.rules.length-1]),f.condition=a.operation.toUpperCase(),d++;var e=f;g(a.left,d),f=e,g(a.right,d)}else{(void 0===a.left.value||void 0===a.right.value)&&j.error("Missing field and/or value"),$.isPlainObject(a.right.value)&&j.error("Value format not supported for {0}.",a.left.value);var h;h=$.isArray(a.right.value)?a.right.value.map(function(a){return a.value}):a.right.value,b&&(h=b.get(h));var i=a.operation.toUpperCase();"<>"==i&&(i="!=");var k;k="NOT LIKE"==i?c.settings.sqlRuleOperator.LIKE:c.settings.sqlRuleOperator[i],void 0===k&&j.error("Invalid SQL operation {0}.",a.operation);var l=k.call(this,h,a.operation);"NOT LIKE"==i&&(l.op="not_"+l.op),f.rules.push({id:c.change("getSQLFieldID",a.left.value,h),field:a.left.value,operator:l.op,value:l.val})}}(d.where.conditions,0),e},setRulesFromSQL:function(a,b){this.setRules(this.getRulesFromSQL(a,b))}}),e.define("unique-filter",function(){this.status.used_filters={},this.on("afterUpdateRuleFilter",this.updateDisabledFilters),this.on("afterDeleteRule",this.updateDisabledFilters),this.on("afterCreateRuleFilters",this.applyDisabledFilters)}),e.extend({updateDisabledFilters:function(a){var b=a?a.builder:this;b.status.used_filters={},b.model&&(!function c(a){a.each(function(a){a.filter&&a.filter.unique&&(b.status.used_filters[a.filter.id]||(b.status.used_filters[a.filter.id]=[]),"group"==a.filter.unique&&b.status.used_filters[a.filter.id].push(a.parent))},function(a){c(a)})}(b.model.root),b.applyDisabledFilters(a))},applyDisabledFilters:function(a){var b=a?a.builder:this;b.$el.find(f.filter_container+" option").prop("disabled",!1),$.each(b.status.used_filters,function(a,c){0===c.length?b.$el.find(f.filter_container+' option[value="'+a+'"]:not(:selected)').prop("disabled",!0):c.forEach(function(b){b.each(function(b){b.$el.find(f.filter_container+' option[value="'+a+'"]:not(:selected)').prop("disabled",!0)})})}),b.settings.plugins&&b.settings.plugins["bt-selectpicker"]&&b.$el.find(f.rule_filter).selectpicker("render")}}),e.regional.en={__locale:"English (en)",__author:'Damien "Mistic" Sorel, http://www.strangeplanet.fr',add_rule:"Add rule",add_group:"Add group",delete_rule:"Delete",delete_group:"Delete",conditions:{AND:"AND",OR:"OR"},operators:{equal:"equal",not_equal:"not equal","in":"in",not_in:"not in",less:"less",less_or_equal:"less or equal",greater:"greater",greater_or_equal:"greater or equal",between:"between",not_between:"not between",begins_with:"begins with",not_begins_with:"doesn't begin with",contains:"contains",not_contains:"doesn't contain",ends_with:"ends with",not_ends_with:"doesn't end with",is_empty:"is empty",is_not_empty:"is not empty",is_null:"is null",is_not_null:"is not null"},errors:{no_filter:"No filter selected",empty_group:"The group is empty",radio_empty:"No value selected",checkbox_empty:"No value selected",select_empty:"No value selected",string_empty:"Empty value",string_exceed_min_length:"Must contain at least {0} characters",string_exceed_max_length:"Must not contain more than {0} characters",string_invalid_format:"Invalid format ({0})",number_nan:"Not a number",number_not_integer:"Not an integer",number_not_double:"Not a real number",number_exceed_min:"Must be greater than {0}",number_exceed_max:"Must be lower than {0}",number_wrong_step:"Must be a multiple of {0}",datetime_empty:"Empty value",datetime_invalid:"Invalid date format ({0})",datetime_exceed_min:"Must be after {0}",datetime_exceed_max:"Must be before {0}",boolean_not_valid:"Not a boolean",operator_not_multiple:"Operator {0} cannot accept multiple values"},invert:"Invert"},e.defaults({lang_code:"en"})});
