/*-
 * #%L
 * BroadleafCommerce Open Admin Platform
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.openadmin.server.service.persistence.validation;

import org.broadleafcommerce.common.presentation.ValidationConfiguration;
import org.broadleafcommerce.openadmin.dto.BasicFieldMetadata;
import org.broadleafcommerce.openadmin.dto.Entity;
import org.broadleafcommerce.openadmin.dto.FieldMetadata;
import org.broadleafcommerce.openadmin.server.service.persistence.module.BasicPersistenceModule;

import java.io.Serializable;
import java.util.Map;

/**
 * Analagous to {@link PropertyValidator} except this does not attempt to use any {@link ValidationConfiguration} from an
 * {@link AdminPresentation} annotation. These global validators will execute on every field of every entity that is
 * attempted to be populated by the admin
 *
 * @author Phillip Verheyden (phillipuniverse)
 * @see {@link PropertyValidator}
 * @see {@link EntityValidatorService#getGlobalEntityValidators()}
 * @see {@link BasicPersistenceModule#createPopulatedInstance(Serializable, Entity, Map, Boolean)}
 */
public interface GlobalPropertyValidator {

    /**
     * Validates a property for an entity
     *
     * @param entity              Entity DTO of the entity attempting to save
     * @param instance            actual object representation of <b>entity</b>. This can be cast to entity interfaces (like Sku or
     *                            Product)
     * @param entityFieldMetadata complete field metadata for all properties in <b>entity</b>
     * @param propertyMetadata    {@link BasicFieldMetadata} corresponding to the property that is being valid
     * @param propertyName        the property name of the value attempting to be saved (could be a sub-entity obtained via dot
     *                            notation like 'defaultSku.name')
     * @param value               the value attempted to be saved
     * @return <b>true</b> if this passes validation, <b>false</b> otherwise.
     */
    PropertyValidationResult validate(
            Entity entity,
            Serializable instance,
            Map<String, FieldMetadata> entityFieldMetadata,
            BasicFieldMetadata propertyMetadata,
            String propertyName,
            String value
    );

}
