/*-
 * #%L
 * BroadleafCommerce Open Admin Platform
 * %%
 * Copyright (C) 2009 - 2024 Broadleaf Commerce
 * %%
 * Licensed under the Broadleaf Fair Use License Agreement, Version 1.0
 * (the "Fair Use License" located  at http://license.broadleafcommerce.org/fair_use_license-1.0.txt)
 * unless the restrictions on use therein are violated and require payment to Broadleaf in which case
 * the Broadleaf End User License Agreement (EULA), Version 1.1
 * (the "Commercial License" located at http://license.broadleafcommerce.org/commercial_license-1.1.txt)
 * shall apply.
 *
 * Alternatively, the Commercial License may be replaced with a mutually agreed upon license (the "Custom License")
 * between you and Broadleaf Commerce. You may not use this file except in compliance with the applicable license.
 * #L%
 */
package org.broadleafcommerce.openadmin.server.service.persistence.module.extension;

import org.broadleafcommerce.common.extension.AbstractExtensionHandler;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.openadmin.dto.FieldMetadata;
import org.broadleafcommerce.openadmin.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.server.service.persistence.module.BasicPersistenceModule;

import java.io.Serializable;
import java.util.Map;

/**
 * Convenience implementation of interface so that subclasses do not have to implement uninteresting methods
 *
 * @author Jeff Fischer
 * @see org.broadleafcommerce.openadmin.server.service.persistence.module.extension.BasicPersistenceModuleExtensionHandler
 */
public class AbstractBasicPersistenceModuleExtensionHandler extends AbstractExtensionHandler implements BasicPersistenceModuleExtensionHandler {

    @Override
    public ExtensionResultStatusType rebalanceForUpdate(
            BasicPersistenceModule basicPersistenceModule,
            PersistencePackage persistencePackage,
            Serializable instance,
            Map<String, FieldMetadata> mergedProperties,
            Object primaryKey,
            ExtensionResultHolder<Serializable> resultHolder
    ) {
        return ExtensionResultStatusType.NOT_HANDLED;
    }

    @Override
    public ExtensionResultStatusType rebalanceForAdd(
            BasicPersistenceModule basicPersistenceModule,
            PersistencePackage persistencePackage,
            Serializable instance,
            Map<String, FieldMetadata> mergedProperties,
            ExtensionResultHolder<Serializable> resultHolder
    ) {
        return ExtensionResultStatusType.NOT_HANDLED;
    }

}
